C **********************************************************************
C *                                                                    *
C *                 *******************************                    *
C *                 *    P L A T O N - 2 0 2 5    *                    *
C *                 *******************************                    *
C *                                                                    *
C *                     (C) 1980-2025 A.L.SPEK                         *
C *                                                                    *
C *                   UTRECHT UNIVERSITY, UTRECHT                      *
C *                        THE NETHERLANDS                             *
C *                                                                    *
C *                         a.l.spek@uu.nl                             *
C *                                                                    *
C **********************************************************************
C * THIS RESEARCH PROGRAM MAY BE USED FREE OF CHARGE FOR USE WITHIN THE*
C *  ACADEMIC COMMUNITY AND NOT FOR PROFIT WITHOUT EXPLICIT PERMISSION.*
C * COMMERCIAL USERS SHOULD APPLY BY FILLING OUT AN APPLICATION FORM.  *
C * IT IS TO BE UNDERSTOOD THAT THE AUTHOR OR HIS UNIVERSITY CANNOT BE *
C *  HELD RESPONSIBLE FOR ANY PROBLEMS CAUSED BY ERRORS IN THE CODE.   *
C * PLEASE REPORT ENCOUNTERED ISSUES TO ITS AUTHOR WITH ASSOCIATED DATA*
C **********************************************************************
      PROGRAM PLATON
C * START-OF-PLATON_PROGRAM LOOP
      CALL MAJOR_PLATON_LOOP
C * END-OF-PLATON_PROGRAM LOOP
      END PROGRAM PLATON
C **********************************************************************
C * The PLATON program includes a large collection of tools for the    *
C * analysis and validation of crystal structures.                     *
C * Examples are: checkCIF, SQUEEZE, ADDSYM, TwinRotMat, CALC, ORTEP   *
C *                                                                    *
C * References: A.L.Spek (2003). J. Appl. Cryst. 36, 7-13.             *
C *             A.L.Spek (2009). Acta Cryst. 65, 148-155.              *
C *             A.L.Spek (2015). Acta Cryst. C71, 9-18.                *
C *             A.L.Spek (2018). Inorg. Chim. Acta, 470, 232-237.      *
C *             A.L.Spek (2020). Acta Cryst. E76, 1-11.                *
C *                                                                    *
C **********************************************************************
C *                                                                    *
C * PLATON development started on a CDC6400 mainframe in 1980. It is   *
C * currently maintained on the LINUX platform and depends on the      *
C * availability of a modern FORTRAN compiler and the X-Windows Library*
C * whose functionality is accessed through a small C language driver  *
C * routine (xdrvr.c). A stripped version without X-Windows is also    *
C * available.                                                         *
C *                                                                    *
C *             L I N U X  - I M P L E M E N T A T I O N               *
C *             ****************************************               *
C *                                                                    *
C * Compile/Link:  gfortran -o platon platon.f xdrvr.c -lX11           *
C * Run as:        platon name.cif, platon name.res or platon name.spf *
C *                                                                    *
C * PLATON compiles unchanged on the WINDOWS11/WSL2/UBUNTU platform    *
C *                                                                    *
C * A WINDOWS11 executable is available from Dr. Louis Farrugia (UK)   *
C *                                                                    *
C * see: https://platonsoft.nl for more details                        *
C *                                                                    *
C **********************************************************************
C *                                                                    *
C *                       IMPLEMENTATION HISTORY                       *
C *                       ======================                       *
C *        PRELIMINARY VERSION (CDC6400)  .............     1980       *
C *        MICROVAX-II IMPLEMENTATION     .............     1986       *
C *        CONVEX/UNIX        ''          .............     1989       *
C *        SILICON-GRAPHICS   ''          .............     1990       *
C *        DEC/ULTRIX         ''          .............     1991       *
C *        LINUX              ''          .............     1993       *
C *        DEC/OSF/1          ''          .............     1993       *
C *        SUN-SOLARIS        ''          .............     1998       *
C *        MAC-OSX            ''          .............     2009       *
C *        RASPBERRY PI       ''          .............     2013       *
C *        INTEL NUC/UBUNTU   ''          .............     2016       *
C *        MacOS /M1/M2/M3/M4 ''          .............     2020       *
C *                                                                    *
C **********************************************************************
C *  S U M M A R Y   O F   P L A T O N   I N S T R U C T I O N S       *
C *---------------------------------------------------------------     *
C *  KEYWORD  I  SUB-KEYWORD(S) I           COMMENT                    *
C *-----------I-----------------I---------------------------------     *
C *ENTRY      I (nr)/(refcode)  |DIR AND POSITION MULT. ENTRY DATA-FILE*
C *-----------I-----------------I---------------------------------     *
C *NOMOVE     I (OFF)           INO MOVE-AROUND OF INPUT ATOMS         *
C *INORG      I                 IINORGANIC MODE                        *
C *ORGA       I                 IORGANIC   MODE                        *
C *ROUND      I ON/OFF/(range)  IROUND OPTION ON/OFF (DEF = ON, 1)     *
C *PARENTHESESI ON/OFF          ILABEL PARENTHESES ON/OFF (DEF = ON)   *
C *INCLUDE    I EL1 EL2  (Me)   IINCLUDE SPECIFIED ELEMENTS ONLY       *
C *EXCLUDE    I EL1 EL2  (Me)   IEXCLUDE SPECIFIED ELEMENTS            *
C *SET VDWR   I EL1 rad EL2 rad ISET NON-DEFAULT VDWAALS RADII         *
C *COLOR TYPE I EL1 col1 etc.   ICHANGE DEFAULT COLORS                 *
C *-----------I-----------------I--------------------------------------*
C *DOAC       IEL1 EL2 ....     IDON./ACCEPT. ATOMS(DEF:N,O,CL,S,F,BR  *
C *-----------I-----------------I--------------------------------------*
C *HBOND      I(NORM) P1 P2 P3  IH-BOND PARAMETERS (DEF 0.5,-.12,100)  *
C *-----------I-----------------I--------------------------------------*
C *LINE       IAT1 AT2          IEXPLICIT LINE SPECIFICATION           *
C *-----------I-----------------I--------------------------------------*
C *LSPL       IAT1 AT2..DIST AT3IEXPLICIT L.S.-PLANE SPECIFICATION     *
C *-----------I-----------------I--------------------------------------*
C *RING       IAT1 AT2 ....     IEXPLICIT RING SPECIFICATION (MAX 30)  *
C *-----------I-----------------I--------------------------------------*
C *FIT        IA11 A21 A1N A2N..IFIT MOL1 (A11,A12,....,A1N) TO        *
C *           I                 I    MOL2 (A21,A22,....,A2N)           *
C *FIT        IA1A  A1B         ISIMILARLY NUMBERED RESIDUE FIT        *
C *-----------I-----------------I--------------------------------------*
C *SAVE       I                 IUSED IN CONJ. WITH ENDS ON TAPE1      *
C *-----------I-----------------I--------------------------------------*
C *ASYM       I(AVF)(ZONEX)     IASYM                                  *
C *           I(LIST 0/1/2/3)   I                                      *
C *           I(THM thm)(VIEW)  I                                      *
C *           I(EXPECT) (EXPAND)I                                      *
C *           I(VIEW/VALID)     I                                      *
C *-----------I-----------------I--------------------------------------*
C *LEPAGE     I(MANG) (MaxDot)  IDO LEPAGE ANALYSIS (METRIC ANGLE)     *
C *           |    (TwoAxCrit)  I                                      *
C *-----------I-----------------I--------------------------------------*
C *EXPT       I                 IGIVE # OF EXPECTED REFL FOR RESOLN    *
C *-----------I-----------------I--------------------------------------*
C *CALC ADDSYMI (EL/EQUAL/SAVE) ICHECK FOR HIGHER SYMMETRY             *
C *           I (ang d1 d2 d3)  ICHANGE DEFAULT CRITERIA               *
C *           I (SHELX) (NOSF)  IPREPARE NEW FILE FOR SUSPECT ENTRY    *
C *           I (PLOT)          IPLOT NEW AVERAGED STRUCTURE           *
C *-----------I-----------------I--------------------------------------*
C *CALC NONSYMI (symmol-tol)    ILOOK FOR NON-CRYST. SYMMETRY          *
C *-----------I-----------------I--------------------------------------*
C *CALC NEWSYMI (ang-metric)    ICHECK FOR (HIGHER) SPACE GROUP SYMM   *
C *-----------I-----------------I--------------------------------------*
C *CALC INTRA I        -        ICALCULATE INTRA MOLECULAR GEO-        *
C *           I                 I METRY USING STANDARD ATOM RADII      *
C *           I                 I D(A-B).LE.R(A)+R(B)+TOLA( =0.4)      *
C *           IEL1 P1 EL2 P2 .. IUSE SPECIFIED ELEMENTAL RADII         *
C *           ITOLA P1          IUSE SPECIFIED TOLERANCE VALUE         *
C *           ITOLEA P1         IADDITIONAL EARTH-ALK. TOLERANCE       *
C *           ITOLM P1          IADDITIONAL TOLERANCE FOR METAL-METAL  *
C *           IEWLSPL           IESD-WEIGHT LS-PLANES                  *
C *           IUWLSPL           IUNIT-WEIGHT LS-PLANES                 *
C *           IAWLSPL           IATOMIC-WEIGHT WEIGHTED LS-PLANES      *
C *           INOTMA            IDO NOT ANALYSE THERMAL MOTION         *
C *           INOBOND           IDO NOT PRINT BOND DISTANCES           *
C *           INOANG            IDO NOT PRINT BOND ANGLES              *
C *           INOTOR            IDO NOT PRINT TORSION ANGLES           *
C *           INOLSP            IDO NOT PRINT L.S-PLANES               *
C *           INORING           IDO NOT SEARCH FOR RINGS               *
C *           INOSTD            IDO NOT CALCULATE ST.DEV. IN PAR.      *
C *           INOMOVE           IDO NOT MOVE PRIMARY ATOMS             *
C *           INOSYMM           IDO NOT APPLY ANY SYMMETRY             *
C *           INOBPA            INO CALCULATION OF BOND/PLANE ANGLES   *
C *           ITOLP P1          IMAX OUT OF PLANE DEV. FOR LSP(.1)     *
C *           IMAXDEV           IMAX LIST DIST FROM PLANE (Def 1.5)    *
C *           IMAXRING P1       IMAXIMUM RING-SIZE (default 24)        *
C *-----------I-----------------I--------------------------------------*
C *CALC GEOM  I(OMEGA/          IBONDS,ANGLE AND TORSION ANGLES (DEF)  *
C *           I SPF/            I(AND GENERATE SPECIFIED FILE)         *
C *           I SHELXL/CSD/     I                                      *
C *           I PDB)            I                                      *
C *           I (NOMOVE)        I DO NOT MOVE INPUT ATOMS              *
C *           I (EXPAND)        I OUTPUT SYMMETRY EXPANDED MOLECULES   *
C *           I (BOND) (ANGLE)  I                                      *
C *           I (TORSION)       I                                      *
C *-----------I-----------------I--------------------------------------*
C *CALC TMA   I (RMAX)          ITHERMAL MOTION ANALYSIS               *
C *           I (HINCL)         I   INCLUDE ANISOTROPIC H-ATOMS        *
C *           I                 I         (def Rmax=0.25)              *
C *           I (Atmin)         I         (def Min numb at=6)          *
C *           I (Cartesian)     ILIST CARTESIAN UIJ AS WELL            *
C *-----------I-----------------I--------------------------------------*
C *CALC INTER I        -        ICALCULATE INTERMOLECULAR GEOMETRY     *
C *           I(NOMOVE)         I WITH VAN DER WAALS RADII + TOLR=0.2  *
C *           ITOLR P1          IUSE SPECIFIED TOLERANCE VALUE         *
C *           IEL1 P1 EL2 P2 .. I MODIFY LISTED CONTACT RADII          *
C *-----------I-----------------I--------------------------------------*
C *CALC HBONDSI P1 P2 P3        IHBOND - ANALYSIS                      *
C *           I (NONA)          I No Network Analysis                  *
C *           I (ICHX)          I INCLUDE C-H...X BONDS                *
C *           I (DISORDER)      I INCLUDE MINOR DISORDER               *
C *-----------I-----------------I--------------------------------------*
C *CALC COORDNI (P1)            ICOORDN RADII NON C,H-ATOMS(DEF=3.6)   *
C *           IEL1 P1 EL2 P2 .. ICALCULATE COORDN SPHERE GEOMETRY      *
C *           I                 I FOR THE SPECIFIED ELEMENTS ONLY.     *
C *           I (NOANG)         I SUPPRESS ANGLE CALCULATION           *
C *           I (FIVE (TBA))    I ANALYSE FIVE COORDINATION            *
C *           I (SPF)           I(OUTPUT ON SPECIFIED FILE TYPE)       *
C *-----------I-----------------I--------------------------------------*
C *CALC COORDNI atom-name p1    I COORDINATION SPHERE FOR SPEC. ATOM   *
C *           I (NOANG)         I                                      *
C *-----------I-----------------I--------------------------------------*
C *CALC METAL I (p1)            IMETAL..METAL DISTANCES (DEF. 5 Ang)   *
C *-----------I-----------------I--------------------------------------*
C *CALC RDF   I (p1)            I CALC RADIAL DISTRIBUTION FUNCTION    *
C *-----------I-----------------I--------------------------------------*
C *CALC DIST  I EL (p1)         I EL-EL DISTANCE SCAN                  *
C *-----------I-----------------I--------------------------------------*
C *CALC SOLV  I (PROBE rad)     I DETERMINE SOLVENT ACCESSIBLE AREAS   *
C *           I (PSTEP n/GRID x)I GRID = rad / n or as given           *
C *           I (LIST/LISTxyz)  I LIST MAP ON LISTING FILE             *
C *           I (SAV)           I WRITE FILE WITH SOLVENT GRID POINTS  *
C *CALC VOID  I (PROBE rad)     I SEARCH FOR VOIDS IN THE STRUCTURE    *
C *           I (PSTEP n)       I GRID = rad / n                       *
C *           I (LIST/LISTxyz)  I LIST MAP ON DISPLAY                  *
C *-----------I-----------------I--------------------------------------*
C *CALC SQUEEZE        (FCAL)   I (HANDLE DISORDERED SOLVENT REGION)   *
C *           I (PROBE radius)  I                                      *
C *           I (PSTEP n)       I                                      *
C *           : (CYCLE n)       I                                      *
C *-----------I-----------------I--------------------------------------*
C *CALC FCF   I (GENERATE)      I CALCULATE STRUCTURE FACTORS          *
C *-----------I-----------------I--------------------------------------*
C *ABSG       I mu,(ng1,ng2,ng3)I GAUSSIAN INTEGRATION ABS CORRECTION  *
C *           I (NOCHECK)(LIST) I                                      *
C *ABST       I mu              I MEULENAAR & TOMPA ABS. CORR.         *
C *           I (NOCHECK)(LIST) I                                      *
C *ABSP       I                 I PSI-SCAN ABS CORRECTION              *
C *           I (NOCHECK)(LIST) I                                      *
C *ABSS       I mu*r            I SPHERICAL ABSORPTION CORRECTION      *
C *           I (NOCHECK)(LIST) I                                      *
C *-----------I-----------------I--------------------------------------*
C *MULABS     I mu radius       I MULTISCAN ABSORPTION CORRECTION      *
C *           I (NOCHECK)(LIST) I                                      *
C *-----------I-----------------I--------------------------------------*
C *CALC       I (ALL)           IDEFAULT CALCULATION OF ALL GEOMETRY   *
C *-----------I-----------------I--------------------------------------*
C *LIST/INFO  I CELL            I LIST CELL DIMENSIONS ON DISPLAY      *
C *LIST/INFO  I SYMM            I LIST CURRENT SYMMETRY                *
C *LIST/INFO  I ATOM (type)(res)I LIST CURRENT ATOM-TABLE (SELECT)     *
C *LIST/INFO  I BOND (type)(res)I LIST CURRENT BOND-TABLE (SELECT)     *
C *LIST/INFO  I UIJ/Ueq         I LIST UIJ or U(eq)                    *
C *LIST/INFO  I RADII           I LIST COVALENT & V.D.WAALS RADII      *
C *LIST/INFO  I IPR (IVL1(IVL2))I LIST INTEGER PARAMETER VALUE         *
C *LIST/INFO  I PAR (IVL1(IVL2))I LIST REAL PARAMETER VALUE            *
C *LIST/INFO  I FLAG            I LIST INTERNAL FLAG VALUES            *
C *-----------I-----------------I--------------------------------------*
C *DIST       I AT1 AT2         IINTERACTIVE DISTANCE CALCULATION      *
C *ANGL       I AT1 AT2 AT3(AT4)I    ,,      ANGLE       ,,            *
C *TORS       I AT1 AT2 AT3 AT4 I    ,,      TORSION     ,,            *
C *LSPL       I AT1 AT2 .....   I    ,,      LEAST-SQUARES PL ,,       *
C *LSPL       I AT1 AT2 .. WITH IINTERACTIVE ANGLE BETWEEN PLANES      *
C *           I AT11 AT12 ..    I                                      *
C *           I (DIST AT3 ..)   I            (TO PLANE DISTANCE)       *
C *FIT        IA11 A21 A1N A2N..IFIT MOL1 (A11,A12,....,A1N) TO        *
C *           I                 I    MOL2 (A21,A22,....,A2N)           *
C *GEOM       I AT1             I    ,,      BONDS,ANGLES FOR AT1      *
C *-----------I-----------------I--------------------------------------*
C *PLOT       I LSPL            IPLOT SPECIFIED PLANE(S)               *
C *           I PLAN            I     AUTOM.    PLANE(S)               *
C *           I RING            I                RING(S)               *
C *           I RESD            I             RESIDUE(S)               *
C *           I ALONG           IPLOT WITH PLANE NORMAL UPWARDS(Y)     *
C *           I PERP            IPLOT DOWN PLANE NORMAL                *
C *           I (DISPLAY/META)  IPLOT MEDIUM (DEFAULT DISPLAY)         *
C *-----------I-----------------I--------------------------------------*
C *PLOT       I NEWMAN (AT1 AT2)INEWMAN PLOT(S) (FOR SPECIFIED BOND)   *
C *           I (DISPLAY/META)  IPLOT MEDIUM (DEFAULT DISPLAY)         *
C *           I (COLOR)         I                                      *
C *-----------I-----------------I--------------------------------------*
C *PLOT       I ADP/ORTEP       IPLOT ANISOTR. DISPLACEMENT ELLIPSOID  *
C *           I (DISPLAY/META)  I     PLOT MEDIUM (DEFAULT DISPLAY)    *
C *           I (COLOR)         ICOLOR O,N AND HALOGENS                *
C *           I (OCTANT/HETERO/ IELLIPSOID TYPE                        *
C *           I  ENVELOPE)      I                                      *
C *           I (LABELS/NOLABEL)ILABEL PLOT                            *
C *           I (HATOM/NOHATOM) IH-ATOM (IN/EX)CLUDE                   *
C *           I (PARENT/NOPAREN)ILabels with or without parentheses    *
C *           I (MARGIN marg)   IOVERLAP MARGIN                        *
C *           I (RESIDUE resnr) IResidue number to be plotted (0=all)  *
C *-----------I-----------------I--------------------------------------*
C *PLOT       I POLY            IPOLYEDER PLOT (IMPLEM IN PROGRESS)    *
C *-----------I-----------------I--------------------------------------*
C *RADII BONDSI (LIST/TO MET/   IRESET (LIST)DEFAULT BOND PARAMETERS   *
C *           I TO H/NORMAL/ALL)IFOR ADP PLOT                          *
C *           I(bond-type (rad))I -5 <= bondtype <= 5 and radius(Ang)  *
C *-----------I-----------------I--------------------------------------*
C *ELLIPSOID  |(C/H/Other)      IPLOT TYPES OF ELLIPSOID SHAPES        *
C *           I type (lines)    Itype 0/1                              *
C *-----------I-----------------I--------------------------------------*
C *JOIN       I At1 At2 ((L)DASH) ADD (DASHED) BOND FOR PLOTTING       *
C *DETACH     I At1 At2         IDELETE BOND FROM PLOT LIST            *
C *DEFINE     I At1 TO At2 ..ATnIADD BOND TO CG                        *
C *           I (DASH)          I (Optionally dashed)                  *
C *-----------I-----------------I--------------------------------------*
C *BOX        I (ON/OFF)        IOUTLINE BOX WITH TEXT ON/OFF          *
C *           I (RATIO ratio)   I HOR/VERT RATIO ADP PLOT              *
C *-----------I-----------------I--------------------------------------*
C *VIEW       I                 IDEFAULT 0,0,0                         *
C *VIEW       I (UNIT) (XR P1)  IROTATE ABOUT X,Y,Z BY P1,P2,P3 ETC.   *
C *VIEW       I MIN             ICALCULATE MINIMUM OVERLAP ORTEP       *
C *VIEW       I INVERT          IINVERT VIEW-MATRIX                    *
C *-----------I-----------------I--------------------------------------*
C *HELP       IMANUAL  (PRINT)  IGIVES (ON LINE/PRINTED) MANUAL        *
C *           ISPGR             ILISTS KNOWN SPACE GROUPS              *
C *-----------I-----------------I--------------------------------------*
C *END        I                 INORMAL END OF PROGRAM                 *
C *STOP/QUIT  I                 IFORCED END OF PROGRAM                 *
C *EXIT       I                 IFORCED END OF PROGRAM                 *
C *-----------I-----------------I--------------------------------------*
C *MENU       I(ON/OFF)         IMOUSE/MENU ON/OFF                     *
C *-----------I-----------------I--------------------------------------*
C *SET        IPAR/IPR nr val   ISET PARAMETERS                        *
C *SET        IPROB (10<-->90)  ISET PROBABILITY LEVEL (DEF=50)        *
C *SET        IPRINTER LEVEL levISET PRINT LEVEL                       *
C *SET        ILABEL SIZE (size)ISET SIZE OF LABELS                    *
C *SET        IWINDOW fraction  IMANIPULATE X-WINDOW-size              *
C *-----------I-----------------I--------------------------------------*
C *TABLE      I(SU/AC/JA/IC)    IGENERATE PUBLICATION/SUPPL.MAT.TABL.  *
C *           I(NOHATOM)        I                                      *
C *           I(NORESIDUE)      I DO-NOT SPLIT IN RESIDUES             *
C *TABLE      I(CIF/CSD) (LOCAL)I GENERATE CIF-FILE FOR ACC-PUBL.      *
C *-----------I-----------------I--------------------------------------*
C *CONTOUR    I                 ICONTOUR PLOTS (IMPL. IN PROGRESS)     *
C *           I(FO/DIFF/SQUEEZE)ITYPE OF MAP (DEFAULT FO)              *
C **********************************************************************
C *                                                                    *
C *    S T A N D A R D  I N P U T  O N  F I L E  name.spf              *
C * -------------------------------------------------------------------*
C *                                                                    *
C *   TITL  <  TEXT >                                                  *
C *   CELL  <LAMBDA, A, B, C, ALPHA, BETA, GAMMA>                      *
C *   CESD  <ST.DEV. A, B, C, ALPHA, BETA, GAMMA>                      *
C *   SPGR  <SPACE GROUP NAME>                                         *
C *   ATOM  <ATOM LABEL, X, Y, Z, POP, SIG(X),SIG(Y),SIG(Z),SIG(POP)>  *
C *   UIJ   <ATOM LABEL, U11, U22, U33, U23, U13, U12>                 *
C *   SUIJ  <ATOM LABEL, S(U11),S(U22),S(U33),S(U23),S(U13),S(U12)>    *
C *         OR FOR ISOTROPIC TEMPERATURE FACTOR                        *
C *   U     <ATOM LABEL, U, S(U)                                       *
C *                ETC. FOR NEXT ATOMS                                 *
C *                                                                    *
C *              E X A M P L E of freeformat name.spf file             *
C *              -----------------------------------------             *
C *                                                                    *
C *   TITL NICKEL COMPOUND C2/C                                        *
C *   CELL 0.71073 11.12 7.564 18.93 90 131.1 90                       *
C *   CESD .01 .005 .01 0 .1 0                                         *
C *   SPGR C2/C                                                        *
C *   ATOM NI  .123 .544 -.176 1 .001 .002 .001 0.0                    *
C *   UIJ  NI  .011 .013 .025 -.011 .004 .009                          *
C *   SUIJ NI  .001 .001 .002 .002 .002 .001                           *
C *   ATOM C1  .345 .675 -.334 1 .010 .009 .005 0.0                    *
C *   U    C1  0.04 .01                                                *
C *                       ETC. ETC.                                    *
C *                                                                    *
C **********************************************************************
C *                                                                    *
C *   A SHELX(L) INPUT FILE WITH ATOM PARAMETERS IS ALSO ACCEPTABLE    *
C *   CIF STRUCTURED FILES ARE ACCEPTABLE AS WELL                      *
C *                                                                    *
C **********************************************************************
C *                                                                    *
C *                        R E M A R K S                               *
C *                        - - - - - - -                               *
C * # 1  -  AN INPUT FILE CONTAINING THE KEYWORD FVAR IS INTERPRETED   *
C *         FOLLOWING THE CONVENTIONS OF SHELX                         *
C * # 2  -  SYMMETRY MAY BE SPECIFIED ALSO WITH LATT AND SYMM RECORDS  *
C *         FOLLOWING THE CONVENTIONS OF SHELX                         *
C * # 3  -  RECORDS THAT START WITH AN ATOM LABEL, FOLLOWED BY THREE   *
C *         NUMBERS ARE INTERPRETED AS ATOM RECORDS                    *
C * # 4  -  AN ATOMLABEL MAY CONTAIN THE SYMBOLS ' AND "               *
C * # 5  -  AN ATOMLABEL (EXCLUDING PARENTHESES CANNOT TAKE MORE THAN  *
C *         SEVEN POSITIONS                                             *
C *                                                                    *
C **********************************************************************
C *                    C A L C U L A T I O N S                         *
C *                    -----------------------                         *
C *                                                                    *
C *   CALC INTRA (OR GEOM)    - FOR INTRAMOLECULAR GEOMETRY            *
C *   CALC INTER              - FOR INTERMOLECULAR GEOMETRY            *
C *   CALC COORDN             - FOR COORDINATION   GEOMETRY (NON C,H)  *
C *   CALC METAL              - FOR METAL-DISTANCE SCAN                *
C *   CALC ALL                - THE ABOVE AND OTHER TOOLS ARE RUN      *
C *                                                                    *
C **********************************************************************
C *                                                                    *
C *     A D D I T I O N A L  S P E C I A L  I N S T R U C T I O N S    *
C *  ---------------------------------------------------------------   *
C *                   (SHOULD PRECEDE THE ITEMS TO OPERATE ON)         *
C *                                                                    *
C * ANGSTROM  (SCALE)        -  ANGSTROM SCALE (DEFAULT 1.0)           *
C * TRNS      -N.KLM         -  APPLY AND FIX (FIRST ATOM IN RESD.)    *
C * TRNS       N.KLM         -  APPLY AND FIX (NEXT ATOM ONLY)         *
C * TRNS      T11,T12,...T33 -  APPLY CELL AXES TRANSFORMATION         *
C *           (SH1,SH2,SH3)     (+ ORIGIN SHIFT)                       *
C *                                                                    *
C * FVAR                     -  SIGNALS SHELX PARAMETER STYLE          *
C *                                                                    *
C * LABEL    X  Y  Z         -  ALTERNATIVE ATOM PARAMETERS TYPE       *
C *                                                                    *
C **********************************************************************
C *                                                                    *
C *   S U B R O U T I N E  F U N C T I O N  D E S C R I P T I O N      *
C *   -----------------------------------------------------------      *
C * PLATON                                                             *
C *   PLATON - MAIN                                                    *
C *   MAJOR_PLATON_LOOP                                                *
C * PLATON MAJOR LOOP ROUTINES-----------------------------------------*
C *   PLA000 - (FILE) INIT, OPEN                                       *
C *   PLA001 - DATA INITIALIZATION                                     *
C *   PLA002 - DATA INPUT HANDLING                                     *
C *   PLA003 - ERROR REPORT AND HANDLING                               *
C *   PLA004 - (FILE) CLOSE/TERMINATE ROUTINE                          *
C * DATA --------------------------------------------------------------*
C *   PLA005 - HANDLE COMMAND LINE SWITCHES                            *
C *   PLA006 - READ ROUTINE FOR MOST FREE FORMATTED INPUT DATA         *
C *   PLA007 - SEARCH/LOAD ENTRY                                       *
C * DETERMINE REFLECTION FILE TYPE ------------------------------------*
C *   PLA008 - DETERMINE REFLECTION FILE TYPE (1)                      *
C *   PLA009 - DETERMINE REFLECTION FILE TYPE (2)                      *
C *   PLA010 - DETERMINE REFLECTION FILE TYPE (3)                      *
C * GUI'S -------------------------------------------------------------*
C *   PLA011 - MAIN MENU TOOL SELECTION   (NH,NV)                      *
C *   PLA012 - MENU - WHAT NEXT ?                                      *
C *   PLA013 - SET SUBMENU OPTIONS                                     *
C *   PLA014 - GET ITEM NEAREST TO CLICK POSITION                      *
C *   PLA015 - NOTIFICATION MESSAGES                                   *
C *   PLA016 - SIDE MENU -OPTIONS                                      *
C * -------------------------------------------------------------------*
C *   PLA017 - SPF or RES & Instruction reading                        *
C *   PLA018 - NEAREST ATOM POS TO CLICK POS                           *
C *   PLA019 - NEAREST ATOM + READ/ANSWER                              *
C *   PLA020 - HANDLE EVENTS ON CANVAS (AREA #1)                       *
C *   PLA021 - SUBROUTINE TO PLA002                                    *
C *   PLA022 - ATOM CARD HANDLING (CALLED FROM PLA002)                 *
C *   PLA023 - LOAD & EXPAND COORDINATE DATA                           *
C *   PLA024 - ANALYSES OF AN. TEMP. AND OUTPUT OF CONNECTED SET       *
C *   PLA025 - SUPPORT PLA024                                          *
C *   PLA026 - LISTING OF (AN)ISOTROPIC THERMAL PARAMETERS + SHELX     *
C * TLS ANALYSIS ------------------------------------------------------*
C *   PLA027 - TLS - ANALYSIS (1)                                      *
C *   PLA028 - TMA - ANALYSIS (2)                                      *
C *   PLA029 - TMA - ANALYSIS (3)                                      *
C * R/S DETERMINATION -------------------------------------------------*
C *   PLA030 - R/S DETERMINATION                                       *
C *   PLA031 - PATH SORT
C *   PLA032 - LABUTE TOPOLOGY NUMBER                                  *
C * -------------------------------------------------------------------*
C *   PLA033 - SUPPORT NEWMAN PROJECTION CALCULATIONS                  *
C *   PLA034 - GENERATION OF TORSION ANGLE LIST                        *
C *   PLA035 - ANALYSIS OF METAL-RING GEOMETRY                         *
C *   PLA036 - GET DISORDER INFORMATION IN NAMS(,,)                    *
C *   PLA037 - ANALYSIS OF ATOM LABEL FOR ATOM TYPE/SERIAL NR.         *
C *   PLA038 - GENERATE BONDS FROM CONN ARRAY                          *
C *   PLA039 - GENERATE ANGLES FROM CONN ARRAY                         *
C *   PLA040 - SUBROUTINE MANAGES CONN-ARRAY                           *
C *   PLA041 - SPECIAL ME..O,N ETC. TEST                               *
C *   PLA042 - LATTICE/SPGR HEADER                                     *
C *   PLA043 - SYMMETRY CODE LISTING                                   *
C *   PLA044 - ROTATION SUPPORT                                        *
C *   PLA045 - LS-PLANE HANDLING                                       *
C *   PLA046 - PACK ATOM LABEL                                         *
C *   PLA047 - UNPACK ATOM LABEL                                       *
C *   PLA048 - ANALYSE RING INTERACTIONS                               *
C *   PLA049 - SU (esd) CALCULATION SUPPORT                            *
C *   PLA050 - CALC DISTANCE, ANGLE OR TORSION                         *
C *   PLA051 - SET PARAMETERS FOR ESD CALCULATION                      *
C *   PLA052 - SET PARAMETERS FOR ESD CALCULATION (LS-PLANE)           *
C *   PLA053 - CALC DISTANCE, ANGLE OR TORSION WITH ESD                *
C *   PLA054 - CALCULATE LEAST-SQUARES PLANE FOR ATOMS IN IATP()       *
C *   PLA055 - LEAST-SQUARES PLANE CALCULATION (WITH ESD)              *
C *   PLA056 - ATOM TO PLANE DISTANCE (WITH SU)                        *
C *   PLA057 - OUTPUT OF SHORT CONTACT                                 *
C *   PLA058 - SAVE SYMMETRY OPERARATIONS FROM CIF                     *
C *   PLA059 - ORTHONORMALIZE                                          *
C *   PLA060 - ADDSYM-SYMMETRY CHECK (MAIN)                            *
C *   PLA061 - ADDSYM - SEARCH FOR AXES AND PLANES                     *
C *   PLA062 - ADDSYM-SYMMETRY CHECK (2)                               *
C *   PLA063 - ADDSYM-SYMMETRY CHECK (3)                               *
C *   PLA064 - ADDSYM-SYMMETRY CHECK (4)                               *
C *   PLA065 - ADDSYM-SYMMETRY CHECK (5)                               *
C *   PLA066 - ACCUMULATE SHORTEST INTERMOLECULAR CONTACTS             *
C *   PLA067 - SETUP OF CONNECTED SETS, INTER AND COORDN. SCANS        *
C *   PLA068 - J-LOOP IN PLA067                                        *
C *   PLA069 - HANDLING OF SHORT INTRA,INTER OR COORDN DISTANCES       *
C *   PLA070 - STORAGE OF CONNECTIONS                                  *
C *   PLA071 - SUPPORT PLA067 (FIX/MOVE)                               *
C *   PLA072 - GENERATE ATOMS FOR SYMMETRY RELATED UNITS               *
C *   PLA073 - OUTPUT OF ATOM TABLES                                   *
C *   PLA074 - OUTPUT OF CONNECTION TABLES                             *
C *   PLA075 - LIST LEAST-SQUARES PLANES                               *
C *   PLA076 - RING PUCKERING ANALYSIS LOOP                            *
C *   PLA077 - LIST INTRA GEOMETRY (BONDS, ANGLE, TORSION)             *
C *   PLA078 - GENERATE RINGS AND PLANES                               *
C *   PLA079 - ANALYSIS OF COORDINATION                                *
C *   PLA080 - COMPOSE CALCULATED COMPOSITION FORMULA                  *
C *   PLA082 - CHECK REPORTED AGAINST CALCULATED COMPOSITION FORMULAE  *
C *   PLA083 - CALCULATE THE PRINCIPLE AXES OF INERTIA FOR RESD NR     *
C *   PLA084 - COMPARE BONDS/ANGLES                                    *
C *   PLA085 - NON CRYSTALLOGRAPHIC SYMMETRY SEARCH                    *
C *   PLA086 - EXPECTED # REFLECTIONS                                  *
C *   PLA087 - SETS IN/EXCLUDE AND DO/AC FLAGS AND INIT FOR PLA067     *
C *   PLA088 - PREPARE ATOM SET (PART1)                                *
C *   PLA089 - H-BOND ANALYSIS                                         *
C *   PLA090 - H-BOND ANALYSIS (SUBR)                                  *
C *   PLA091 - (HYDROGEN BOND) CLUSTER/AGGREGATE ANALYSIS              *
C *   PLA092 - HYDROGEN BOND NETWORK ANALYSIS                          *
C *   PLA093 - SUPPORT PLA091                                          *
C *   PLA094 - NETWORK ANALYSIS                                        *
C *   PLA095 - RING PUCKERING ANALYSIS                                 *
C *   PLA096 - VALENCE BOND ANALYSIS                                   *
C *   PLA097 - TRANSLATE ARU TO SYMMETRY                               *
C *   PLA098 - CALCULATE AVERAGE BOND DISTANCES (+ BP)                 *
C *   PLA099 - ATOM CHARACTERISTICS                                    *
C *   PLA100 - CELL PARAMETERS AND ORTHOG. AXES SYSTEM CALCULATION     *
C * POLYEDER PLOT -----------------------------------------------------*
C *   PLA101 - POLYEDER PLOT (1)                                       *
C *   PLA102 - POLYEDER PLOT (2)                                       *
C *   PLA103 - POLYEDER PLOT (3)                                       *
C * ADP (ORTEP) PLOT --------------------------------------------------*
C *   PLA106 - ADP-MAIN                                                *
C *   PLA107 - SUPPORT ADP                                             *
C *   PLA108 - DRAW                                                    *
C * -------------------------------------------------------------------*
C *   PLA109 - PLOT SPECIAL TEXT                                       *
C *   PLA110 - PLOT BOX                                                *
C * -------------------------------------------------------------------*
C *   PLA111 - ALL (NEWMAN AND PLANE PLOTTING IS INITIATED HERE)       *
C *   PLA112 - SUPPORT PLA111                                          *
C * POWDER PATTERN CALCULATION AND DISPLAY MODULE ---------------------*
C *   PLA113 - POWDER PATTERN MAIN                                     *
C *   PLA114 - POWDER PATTERN - GENERATE REFLECTION DATA FROM COORD    *
C *   PLA115 - POWDER PATTERN PLOT                                     *
C * VOID SEARCH MODULE ------------------------------------------------*
C *   PLA118 - SOLV/VOID                                               *
C *   PLA119 - SOLV/VOID J-LOOP                                        *
C *   PLA120 - SOLV/VOID PROBE                                         *
C *   PLA121 - SOLV/EXPAND                                             *
C *   PLA122 - SOLVENT ACCESSIBLE VOLUME STATISTICS                    *
C *   PLA123 - SOLVENT ACCESSIBLE VOLUME DISPLAY                       *
C * SQUEEZE MODULE ----------------------------------------------------*
C *   PLA125 - SQUEEZE MAIN ROUTINE                                    *
C *   PLA126 - SQUEEZE SOLV GRID TO FFT GRID REMAPPING                 *
C *   PLA127 - SQUEEZE RESULTS (FAB-FILE & CIF-FORMATTED SQUEEZE INFO  *
C *   PLA128 - SQUEEZE REPORT (GRAPHICS)                               *
C *   PLA129 - SQUEEZE REPORT                                          *
C *   PLA130 - GET REFLECTIONS FOR SQUEEZE AND DIFF. MAP.              *
C *   PLA131 - HYBRID SHELXL/SQUEEZE LOOP                              *
C * REFLECTION DATA ---------------------------------------------------*
C *   PLA132 - HKL/FCF-READ                                            *
C *   PLA133 - DETERMINE HMAX, KMAX & LMAX                             *
C *   PLA134 - HKL - READ / TRANS                                      *
C *   PLA135 - READ REFLECTIONS & SFCALC FOR SQUEEZE/FCF               *
C *   PLA136 - HANDLE ASYMMETRIC UNIT                                  *
C *   PLA137 - STRUCTUREFACTOR - CALCULATION                           *
C *   PLA139 - FCF to HKL EXTRACTION                                   *
C * PEAK SEARCH IN FOURIER MAP ----------------------------------------*
C *   PLA140 - PEAK SEARCH                                             *
C *   PLA141 - FOURIER + PEAKS                                         *
C *   PLA142 - FOURIER + PEAKS                                         *
C *   PLA143 - DISTANCE CALCULATION                                    *
C * RADIAL DISTRIUTION FUNCTION----------------------------------------*
C *   PLA144 - RADIAL DISTRIBUTION FUNCTION                            *
C * ASYM --------------------------------------------------------------*
C *   PLA145 - ASYM - MAIN ROUTINE                                     *
C *   PLA146 - ASYM - SUPPORT                                          *
C *   PLA147 - ASYM - GUI                                              *
C *   PLA148 - ASYM - SUPPORT                                          *
C *   PLA149 - ASYM - HKL AVERAGING AND MULTIPLICITY                   *
C * EXOR --------------------------------------------------------------*
C *   PLA151 - SETUP EXOR.BIN/EXOR (1)                                 *
C *   PLA152 - SETUP EXOR.BIN/EXOR (2)                                 *
C *   PLA153 - SETUP EXOR.BIN/EXOR (3)                                 *
C *   PLA154 - SETUP EXOR.BIN/EXOR (4)                                 *
C * SHELXS86 STRIPPED VERSION FOR SYSTEM-S ----------------------------*
C *   PLA155 - SHX86 CRYSTAL STRUCTURE SOLUTION (MODIFIED FOR SYSTEM=S *
C *   PLA156 - SHX86 READ REFLECTION DATA, GENERATE AND SORT E-VALUE   *
C *   PLA157 - SHX86 DERIVE PHASE RELATIONS                            *
C *   PLA158 - SHX86 TANGENT REFINEMENT                                *
C *   PLA159 - SHX86 PARTIAL STRUCTURE EXPANSION                       *
C * FSPGR/NEWSYM ------------------------------------------------------*
C *   PLA160 - FSPGR/NEWSYM  (1)                                       *
C *   PLA161 - FSPGR/NEWSYM  (2)                                       *
C *   PLA162 - FSPGR/NEWSYM  (3)                                       *
C *   PLA163 - FSPGR/NEWMAN  (4)                                       *
C * LEPAGE ------------------------------------------------------------*
C *   PLA164 - LEPAGE (1)                                              *
C *   PLA165 - LEPAGE (2)                                              *
C *   PLA166 - LEPAGE (3)                                              *
C * -------------------------------------------------------------------*
C *   PLA167 - LAUE (1) - LAUE AVERAGES                                *
C *   PLA168 - LAUE (2)                                                *
C *   PLA169 - LAUE (3)                                                *
C *   PLA170 - LAUE (4)                                                *
C * TABLES ------------------------------------------------------------*
C *   PLA171 - TABLE (1)                                               *
C *   PLA172 - TABLE (2)                                               *
C *   PLA173 - TABLE (3)                                               *
C *   PLA174 - TABLE (4)                                               *
C *   PLA175 - TABLE (5)                                               *
C * CIF FILE READ------------------------------------------------------*
C *   PLA176 - MAIN CIF-READ                                           *
C *   PLA177 - CHECK FOR/EMBEDDED MATERIAL BETWEEN ;:                  *
C *   PLA178 - SAVE EMBEDDED MATERIAL BETWEEN ;;                       *
C *   PLA179 - DATANAME > VALUE                                        *
C *   PLA180 - HANDLE CELL/CIF                                         *
C *   PLA181 - HANDLE CIF BOND,ANGLE etc. LOOPS                        *
C *   PLA182 - HANDLE WEIGHT EXPRESSION                                *
C *   PLA183 - CALCULATE SIGIW                                         *
C *   PLA184 - INSPECT CONTENT RES FILE  (TWIN,SAME etc.)              *
C *   PLA185 - HANDLE CELL DATA                                        *
C * ABSORPTION CORRECTION----------------------------------------------*
C *   PLA186 - MANAGE ABSORPTION CORRECTION CALLS                      *
C *   PLA187 - XTAL                                                    *
C *   PLA188 - PSI-SCAN PLOT                                           *
C *   PLA189 - PSI-SCAN                                                *
C *   PLA190 - MULABS                                                  *
C *   PLA191 - Spherical Absorption Correction                         *
C * ABSGAUSS-----------------------------------------------------------*
C *   PLA192 - ABSGAUSS (1)                                            *
C * ABSTOMPA ----------------------------------------------------------*
C *   PLA193 - ABSTOMPA (1)                                            *
C *   PLA194 - ABSTOMPA (2)                                            *
C *   PLA195 - ABSTOMPA (3)                                            *
C *   PLA196 - ABSTOMPA (4)                                            *
C *   PLA197 - ABSTOMPA (5)                                            *
C * -------------------------------------------------------------------*
C *   PLA198 - GUI - Absorption Correction                             *
C * -------------------------------------------------------------------*
C *   PLA199 - CHECK DIRCOS                                            *
C *   PLA200 - CHECK DIRCOS                                            *
C *   PLA201 - ANALYSE CRYSTAL DESCRIPTION                             *
C * SHXABS ------------------------------------------------------------*
C *   PLA202 - SHXABS                                                  *
C * -------------------------------------------------------------------*
C *   PLA204 - Display NPP                                             *
C *   PLA205 - SHELXTPLOT                                              *
C *   PLA206 - LIST IPR / PAR / IGBL / RGBL / CHK                      *
C *   PLA207 - CAVITY                                                  *
C *   PLA208 - EXPAND TO P1                                            *
C *   PLA209 - RENDER3D PREP                                           *
C *   PLA210 - CHECK FOR NEW PLATON SOURCE/VERSION & DOWNLOAD          *
C * MOLSYM ------------------------------------------------------------*
C *   PLA211 - MOLSYM/WORK (1)                                         *
C *   PLA212 - MOLSYM/WORK (2)                                         *
C *   PLA213 - MOLSYM/WORK (3)                                         *
C *   PLA214 - MOLSYM/WORK (4)                                         *
C *   PLA215 - MOLSYM/WORK (5)                                         *
C *   PLA216 - MOLSYM/WORK (6)                                         *
C *   PLA217 - MOLSYM/WORK (7)                                         *
C * CONPUC (BOEYENS) --------------------------------------------------*
C *   PLA218 - CONPUC MAIN                                             *
C *   PLA219 - CONPUC (BOEYENS) (2)                                    *
C *   PLA220 - CONPUC (BOEYENS) (3)                                    *
C *   PLA221 - CONPUC (BOEYENS) (4)                                    *
C *   PLA222 - CONPUC (BOEYENS) (5)                                    *
C *   PLA223 - CONPUC (BOEYENS) (6)                                    *
C *   PLA224 - CONPUC (BOEYENS) (7)                                    *
C *   PLA225 - CONPUC (BOEYENS) (8)                                    *
C * -------------------------------------------------------------------*
C *   PLA226 - ORIENTATION PARAMETERS                                  *
C *   PLA227 - CALCULATE THE UNIT VECTOR ALONG IAT TO JAT              *
C *   PLA228 - AUTO-RENUMBER                                           *
C *   PLA229 - RENUMBER SUPPORT                                        *
C * CHECKCIF ----------------------------------------------------------*
C *   PLA230 - IUCR-CHECK (CIF-VALIDATION) - MAIN                      *
C *   PLA231 - IUCR-CHECK (CIF-VALIDATION) - REPORT ALERTS             *
C *   PLA232 - IUCR-CHECK (CIF-VALIDATION) (3)                         *
C *   PLA233 - IUCR-CHECK (CIF-VALIDATION) (4)                         *
C *   PLA234 - IUCR-CHECK (CIF-VALIDATION) - CREATE VRF RECORD         *
C *   PLA235 - IUCR-CHECK (CIF-VALIDATION) - DISPLAY RESULT            *
C *   PLA236 - IUCR-CHECK (CIF-VALIDATION) - COLLECT ALERTS            *
C *   PLA237 - IUCR-CHECK (CIF-VALIDATION) - OVERVIEW                  *
C * HELENA ------------------------------------------------------------*
C *   PLA240 - HELENA MAIN                                                    *
C *   PLA241 - HELENA (2)                                              *
C *   PLA242 - HELENA (3)                                              *
C *   PLA243 - HELENA (4)                                              *
C *   PLA244 - HELENA (5)                                              *
C *   PLA245 - HELENA (6)                                              *
C *   PLA246 - HELENA (7)                                              *
C *   PLA247 - HELENA (8)                                              *
C *   PLA248 - HELENA (9)                                              *
C *   PLA249 - HELENA (10)                                             *
C * CONTOUR -----------------------------------------------------------*
C *   PLA250 - DENSITY CONTOUR MAP (1)                                 *
C *   PLA251 - DENSITY CONTOUR MAP (2)                                 *
C *   PLA252 - DENSITY CONTOUR MAP (3)                                 *
C *   PLA253 - DENSITY CONTOUR MAP (4)                                 *
C *   PLA254 - DENSITY CONTOUR MAP (5)                                 *
C *   PLA255 - DENSITY CONTOUR MAP (6)                                 *
C *   PLA256 - DENSITY CONTOUR MAP (7)                                 *
C *   PLA257 - DENSITY CONTOUR MAP (8)                                 *
C *   PLA258 - DENSITY CONTOUR MAP (9)                                 *
C *   PLA259 - DENSITY CONTOUR MAP (10)                                *
C *   PLA260 - DENSITY CONTOUR MAP (11)                                *
C * -------------------------------------------------------------------*
C *   PLA261 - GET FILENAME ARGUMENT                                   *
C *   PLA262 - NEWPAGE HANDLING                                        *
C *   PLA263 - SUBSTITUTE                                              *
C * DELAUNEY REDUCTION-------------------------------------------------*
C *   PLA265 - DELAUNEY-REDUCTION                                      *
C * -------------------------------------------------------------------*
C * KRIVY & GRUBER CELL REDUCTION--------------------------------------*
C *   PLA266 - KRIVY & GRUBER MAIN                                     *
C *   PLA267 - KRIVY REDUCTIE                                          *
C * -------------------------------------------------------------------*
C *   PLA268 - BOND IN SCRATCH VOID LIST MANAGEMENT                    *
C *   PLA269 - SAVE/RESTORE XXO,XSD,CON FROM SCRAT                     *
C *   PLA270 - MULTIPLY SYMMETRY OPERATIONS                            *
C *   PLA271 - LAST MINUTE UPDATE                                      *
C *   PLA272 - CHECK BONDS, ANGLES, TORSIONS etc. IN CIF               *
C *   PLA273 - SAVE ORIGINAL SYMMETRY CODES SUPPLIED IN CIF            *
C *   PLA274 - LIST SYMMETRY                                           *
C * PACK/UNPACK CHECK.DEF ---------------------------------------------*
C *   PLA275 - PACK/UNPACK check.def (1)    [Created as/from]          *
C *   PLA276 - PACK/UNPACK check.def (2)    [ check.f / .def]          *
C *   PLA277 - PACK/UNPACK check.def (3)    [   by PLATON   ]          *
C * -------------------------------------------------------------------*
C *   PLA278 - GENERATE platon_special.f from platon.f                 *
C *   PLA279 - Descriptors for Octahedral and Tetrahedral Distort.     *
C *   PLA280 - AUTO INSTRUCTIONS                                       *
C *   PLA281 - ALIAS SUBSTITUTION                                      *
C *   PLA282 - ALIAS SUBSTITUTION (REGISTER & LISTING)                 *
C *   PLA283 - GENERATE MOIETY/RESIDUE/SUM STRING                      *
C * STRAIN ------------------------------------------------------------*
C *   PLA284 - STRAIN (1)                                              *
C *   PLA285 - STRAIN (2)                                              *
C * -------------------------------------------------------------------*
C *   PLA286 - RESET                                                   *
C *   PLA287 - SETUP CONNECTED SET(S)                                  *
C *   PLA288 - DEFINE BOND                                             *
C *   PLA289 - PLOT CIRCLE                                             *
C *   PLA292 - UNIT #2 FILE OPEN                                       *
C *   PLA293 - Check Wavelength                                        *
C *   PLA294 - CCDC/CQBATCH                                            *
C *   PLA295 - MANAGE MOL-LIST FOR ORTEP                               *
C *   PLA296 - PRINT/PLOT LINE                                         *
C *   PLA297 - (SUPPORT ROUTINE)                                       *
C *   PLA299 - LISTS SHORT MANUAL + HELP FUNCTION                      *
C *   PLA300 - GET WEBPAGE                                             *
C * STRUCTURE TIDY-----------------------------------------------------*
C *   PLA301 - Structure Tidy (1)                                      *
C *   PLA302 - Structure Tidy (2)   'BURZ'                             *
C *   PLA303 - Structure Tidy (3)                                      *
C *   PLA304 - Structure Tidy (4)                                      *
C *   PLA305 - Structure Tidy (5)                                      *
C *   PLA306 - Structure Tidy (6)                                      *
C *   PLA307 - Structure Tidy (7)   'TRA'                              *
C *   PLA308 - Structure Tidy (8)                                      *
C *   PLA309 - Structure Tidy (9)                                      *
C *   PLA310 - Structure Tidy (10)  'BEST'                             *
C *   PLA311 - Structure Tidy (11)                                     *
C *   PLA312 - Structure Tidy (12)                                     *
C *   PLA313 - Structure Tidy (13)                                     *
C *   PLA314 - Structure Tidy (14)                                     *
C *   PLA315 - Structure Tidy (15)                                     *
C *   PLA316 - Structure Tidy (16)                                     *
C *   PLA317 - Structure Tidy (17)                                     *
C *   PLA318 - Structure Tidy (18)                                     *
C *   PLA319 - Structure Tidy (19)                                     *
C *   PLA320 - Structure Tidy (20)                                     *
C *   PLA321 - Structure Tidy (21)                                     *
C *   PLA322 - Structure Tidy (22)                                     *
C *   PLA323 - Structure Tidy (23)                                     *
C *   PLA324 - Structure Tidy (24)                                     *
C *   PLA325 - Structure Tidy (25)                                     *
C *   PLA326 - Structure Tidy (26)                                     *
C *   PLA327 - Structure Tidy (27)                                     *
C * -------------------------------------------------------------------*
C *   PLA330 - transformation h,k,l (and Direction Cosines)            *
C * -------------------------------------------------------------------*
C *   PLA340 - ANOMALOUS SCATTERING AND ABSORPTION CONTRIBUTIONS       *
C * -------------------------------------------------------------------*
C *   PLA344 - TRANSFORM OLD STYLE SQUEEZE.HKL TO ORIG.HKL             *
C *   PLA345 - CIF2SHELXL                                              *
C *   PLA346 - Create FCF from SHELXLxy CIF OR COPY EMBEDDED FCF       *
C *   PLA347 - Create FCF from SHELXLxy CIF                            *
C *   PLA348 - SPGR EXERCISE ROUTINE                                   *
C *   PLA349 -                                                         *
C * CHARGE FLIPPING ---------------------------------------------------*
C *   PLA350 - Charge Flipping (1)                                     *
C *   PLA351 - Charge Flipping (2)                                     *
C *   PLA352 - Charge Flipping (3)                                     *
C *   PLA353 - Charge Flipping (4)                                     *
C *   PLA354 - Charge Flipping (5)                                     *
C *   PLA355 - Charge Flipping (6)                                     *
C * RDIFFERENCE MAP ---------------------------------------------------*
C *   PLA360 - Difference Map (1)                                      *
C *   PLA361 - Difference Map (2)                                      *
C *   PLA362 - Difference Map (3)                                      *
C *   PLA363 - Difference Map (4)                                      *
C * WILSON PLOT--------------------------------------------------------*
C *   PLA370 - WILSON PLOT ETC. (1)                                    *
C *   PLA371 - WILSON PLOT ETC. (2)                                    *
C *   PLA372 - WILSON PLOT ETC. (3)                                    *
C *   PLA373 - WILSON PLOT ETC. (4)                                    *
C *   PLA374 - WILSON PLOT ETC. (5)                                    *
C *   PLA375 - WILSON PLOT ETC. (6)                                    *
C *   PLA376 - WILSON PLOT ETC. (7)                                    *
C *   PLA377 - WILSON PLOT ETC. (8)                                    *
C *   PLA378 - WILSON PLOT ETC. (9)                                    *
C *   PLA379 - WILSON PLOT ETC. (10) - N(Z) PLOT                       *
C * -------------------------------------------------------------------*
C *   PLA381 - PDB-READ HANDLER                                        *
C *   PLA382 - LIST                                                    *
C *   PLA383 - SHELXL TYPE INPUT RECORDS                               *
C *   PLA384 - DETERMINE ORGANIC/INORGANIC/METALORGANIC                *
C * ANOMALOUS DISPERSION VALUES ---------------------------------------*
C *   PLA385 - ANOMALOUS DISPERSION VALUES (1)                         *
C *   PLA386 - ANOMALOUS DISPERSION VALUES (2)                         *
C *   PLA387 - ANOMALOUS DISPERSION VALUES (3)                         *
C * -------------------------------------------------------------------*
C *   PLA390 - PRE-GEOM LSPL REQUESTS                                  *
C *   PLA391 - REMOVE '_$1' FROM LABEL                                 *
C *   PLA392 - REMOVE ' ^'  FROM LABEL                                 *
C *   PLA393 - CREATE CIF-style SYMMETRY CODE                          *
C *   PLA394 - ACCESSIBLE SURFACE AREA (ASA) ROUTINE                   *
C *   PLA395 - CHECK FOR SPECIAL SHORT CONTACTS                        *
C *   PLA396 - MolVolume
C * MP-TOOL------------------------------------------------------------*
C *   PLA400 - MP TOOL (1)                                             *
C *   PLA401 - MP TOOL (2)                                             *
C *   PLA402 - MP TOOL (3)                                             *
C * ------------- Bijvoet/Twinning, Anal-of-Var, Scatter Plot MODULE --*
C *   PLA405 - Setup                                                   *
C *   PLA406 - PLOT MARK                                               *
C *   PLA407 - Scatter Plot                                            *
C *   PLA408 - Diederichs Plot etc.                                    *
C *   PLA409 - SUPPORT
C * ANALYSIS OF VARIANCE ----------------------------------------------*
C *   PLA412 - Analysis of Variance & Listing                          *
C *   PLA413 - Analysis of Variance Listing                            *
C * TWINROTMAT --------------------------------------------------------*
C *   PLA414 - TwinRotMat (1)                                          *
C *   PLA415 - TwinRotMat (2)                                          *
C *   PLA416 - TwinRotMat (3)                                          *
C *   PLA417 - TwinRotMat (4)                                          *
C *   PLA418 - TwinRotMat (5)                                          *
C * -------------------------------------------------------------------*
C * BIJVOET PAIR ANALYSIS----------------------------------------------*
C *   PLA421 - Bijvoet Pair Analysis (1)                               *
C *   PLA422 - Bijvoet Pair Analysis (2)                               *
C *   PLA423 - Bijvoet Pair Analysis (3)                               *
C *   PLA424 - Bijvoet Pair Analysis (4)                               *
C *   PLA425 - Bijvoet Pair Analysis (5)                               *
C *   PLA426 - Bijvoet Pair Analysis (6)                               *
C * -------------------------------------------------------------------*
C *   PLA427 - COMPARE TWO FCF FILES                                   *
C * -------------------------------------------------------------------*
C *   PLA428 - TEST FOR SHELXL20XY                                     *
C *   PLA429 - TEST FOR PLATON & SHELXL  ETC.                          *
C *   PLA430 - GET UPDATE VERSION DATE                                 *
C *   PLA431 - INIT GRAPHICS                                           *
C *   PLA432 - TRMX - GRAPHICS                                         *
C *              ...                                                   *
C *   PLA439 - PLOT STRING                                             *
C * INTERACTIVE GEOMETRY CALCULATIONS CALCULATIONS---------------------*
C *   PLA440 - INTERACTIVE DIST,ANGLE,TORSION & FIT CALCULATION        *
C *   PLA441 - FIT 1 2 ETC.                                            *
C * MOLFIT ROUTINES ---------------------------------------------------*
C *   PLA442 - MOLFIT(QUATERNION)                                      *
C *   PLA443 - BMFIT                                                   *
C * -------------------------------------------------------------------*
C *   PLA445 - LOAD SFAC & BOND_VALENCE DATA                           *
C *   PLA446 - LOAD CIF_DATA                                           *
C * -------------------------------------------------------------------*
C *   SPAWN                                                            *
C *   FINDEXE                                                          *
C *   PRINTX                                                           *
C *   TRAILER                                                          *
C **********************************************************************
C * THE ARRAY IFG(1, )  CONTAINS THE FOLLOWING BIT FLAGS               *
C * - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -      *
C * BIT 1    - DONE FLAG (PLA067)                                      *
C * BIT 2    - FIX  FLAG (PLA067)                                      *
C * BIT 3    - NEXT FLAG (PLA067)                                      *
C * BIT 4    - (0/1) ATOM IS ISO/ANISOTROPIC                           *
C * BIT 5    - FLAG FOR SYMMETRY RELATED ATOM                          *
C * BIT 6    - FLAG FOR SPECIAL POSITION ATOM                          *
C * BIT 7    - HYDROGEN ATOM IDENTIFICATION BIT                        *
C * BIT 8    - (0/1) ATOM WITH MORE THAN 9 CONNECTIONS                 *
C * BIT 9 -14- 6-BIT VARIABLE IN PLA067(RES)                           *
C * BIT 15-18- ATOM TYPE NR IN IEN                                     *
C * BIT 19   - METAL                                                   *
C * BIT 20   - POTENTIAL H - BOND  H-ATOM                              *
C * BIT 21   - POTENTIAL DONOR ATOM (X-H)                              *
C * BIT 22   - ACCEPTOR ATOM                                           *
C * BIT 23   - DONOR/ACCEPTOR ATOM                                     *
C * BIT 24-27- HATOM CALCULATION / HYBRIDISATION  TYPE                 *
C * BIT 28-29- R/S CONFIGURATION                                       *
C * BIT 30   - OMIT  (FROM SFCalc)                                     *
C * BIT 31   - C(O2), N(O3), S(O4), Cl(O4), P(O4)                      *
C *                                                                    *
C * IFG(2, ) FLAGS                                                     *
C *                                                                    *
C * BIT  1- 8- POPULATION PARAMETER NR                                 *
C * BIT  9   - SPECIAL FIX-BIT                                         *
C * BIT 10   - ISU (0/1)                                               *
C * BIT 11   - LABEL (0/1)                                             *
C * BIT 12   - HINC  (0/1)                                             *
C * BIT 13   - B OR H (0/1)                                            *
C * BIT 14-23- LABUTE-VALUE                                            *
C * BIT 24-26- EFFECTIVE # ATTACHED H-ATOMS                            *
C * BIT 27   - EXCLUDE ATOM  (ORTEP/SOLV)                              *
C * BIT 28   - B-H (0/1)                                               *
C * BIT 29   - (0/1) POPULATION SU                                     *
C * BIT 30   - ATOM OMITTED                                            *
C * BIT 31   -                                                         *
C *                                                                    *
C * IFG(3, ) FLAGS                                                     *
C *                                                                    *
C * BIT  1   - d      FLAG (CALC)                                      *
C * BIT  2   - C(ALC) FLAG (CALC)                                      *
C * BIT  3   - DUM    FLAG (CALC)                                      *
C * BIT  4   - S      FLAG (REFINEMENT)                                *
C * BIT  5   - G      FLAG (REFINEMENT-GROUP)                          *
C * BIT  6   - R      FLAG (REFINEMENT-RIDING)                         *
C * BIT  7   - D      FLAG (REFINEMENT)                                *
C * BIT  8   - T      FLAG (REFINEMENT)                                *
C * BIT  9   - U      FLAG (REFINEMENT)                                *
C * BIT 10   - P      FLAG (REFINEMENT)                                *
C * BIT 11   - A      FLAG (DISORDER ASSEMBLY)                         *
C * BIT 12   - B      FLAG (DISORDER ASSEMBLY)                         *
C * BIT 13   - S      FLAG (DISORDER ASSEMBLY)                         *
C * BIT 14-18-        SHELXL-STYLE PART                                *
C *                                                                    *
C * BIT 25-27-        TOTAL # OF ATTACHED H-ATOMS                      *
C * BIT 28-31-        EFFECTIVE # OF BONDS FOR ATOM I                  *
C * PAR(565)= Pearson's CC           PAR(566)= SQUEEZE SCF             *
C * PAR(567)= FLOAT Z CALC           PAR(568)= FLOAT Z REPORTED        *
C * PAR(569)= MolVol GridStep        PAR(570)= RVMIN TERMINATE R (FLIP)*
C * PAR(571)= CAVITY PARAMETER       PAR(572)= STLMAX (SQUEEZE HKL)    *
C * PAR(573)= SIG(I)/HKLF SCALING    PAR(574)= MIN (RMSQ) IN TMA ANAL  *
C * PAR(575)= ABIN SF N1             PAR(576)= ABIN SF N2              *
 
      MODULE parameters
      SAVE
      INTEGER, PARAMETER :: NP12 = 790
      INTEGER, PARAMETER :: NP13 = 600
      INTEGER, PARAMETER :: NP15 = 20
      INTEGER, PARAMETER :: NP17 = 99
      INTEGER, PARAMETER :: NP36 = 5000
      INTEGER, PARAMETER :: NP38 = 150
      INTEGER, PARAMETER :: NP39 = 46
      INTEGER, PARAMETER :: NP45 = 2048
      INTEGER, PARAMETER :: NP59 = 100000
      INTEGER, PARAMETER :: NP64 = 12
      INTEGER, PARAMETER :: NP67 = 5000
      INTEGER, PARAMETER :: NP71 = 27
      INTEGER, PARAMETER :: NP73 = 18000
      INTEGER, PARAMETER :: NP75 = 100
      INTEGER, PARAMETER :: NP76 = 100
      INTEGER, PARAMETER :: NP77 = 100
      INTEGER, PARAMETER :: NP86 = 500
      INTEGER, DIMENSION(NP12) :: IPR
      INTEGER, DIMENSION(NP38) :: IGBL
      INTEGER, DIMENSION(NP59) :: LABB
      REAL :: TPMTDM
      REAL :: TOMTCM
      REAL, DIMENSION(NP17) :: FN
      REAL, DIMENSION(NP13) :: PAR
      REAL, DIMENSION(NP39) :: RGBL
      CHARACTER(len=NP45) :: ICL
      CHARACTER(len=NP64) :: NQ0
      CHARACTER(len=NP64) :: NQ1
      CHARACTER(len=NP64) :: NQ2
      CHARACTER(len=NP64) :: NQ3
      CHARACTER(len=NP64) :: NQ4
      CHARACTER(len=NP64) :: NQ5
      CHARACTER(len=NP64) :: NQ6
      CHARACTER(len=NP64), DIMENSION(NP17)    :: IFL
      CHARACTER(len=NP64), DIMENSION(9, 4)    :: NAMS
      CHARACTER(len=NP64), DIMENSION(NP36)    :: ALAB
      CHARACTER(len=NP64), DIMENSION(NP36)    :: BLAB
      CHARACTER(len=NP64), DIMENSION(NP36)    :: CLAB
      CHARACTER(len=NP64), DIMENSION(NP86)    :: PLAB
      CHARACTER(len=8),    DIMENSION(NP77, 2) :: CISO
      END MODULE parameters
 
      SUBROUTINE MAJOR_PLATON_LOOP
C * MAJOR PLATON LOOP (MANAGED BY THE VALUE OF IGBL(1) = [-2,-1,0,1,2,3,4,5])
      USE parameters
C * SET TO STARTING WITH GLOBAL PROGRAM INIT
      IGBL(1) = -2
      DO
        SELECT CASE (IGBL(1))
C * -2 : GLOBAL INIT (IGBL & RGBL ARRAYS), GET COMMAND-LINE ARGUMENTS
C *      CHECK FOR ESCAPE MODES TO (S, HELENA, SHX86, STIDY & COMPARE HKL PLOT)
          CASE (-2)
            CALL PLA000
C * -1 : INIT & FILE OPEN
          CASE (-1)
            CALL PLA000
C *  0 : MANAGE INPUT DATA FILE LU1
          CASE (0)
            CALL PLA000
C * RESTART FOR NEW DATASET
          CASE (1)
            CALL PLA001
C * READ DATA AND INSTRUCTIONS & EXECUTE INSTRUCTIONS
          CASE (2)
            CALL PLA002
C * ERROR HANDLING (AND SUMMARY)
          CASE (3)
            CALL PLA003
C * CLOSE & TERMINATE PLATON RUN
          CASE (4)
            CALL PLA004 (0)
          CASE DEFAULT
C * EXIT (IGBL(1) = 5 etc.)
            EXIT
        END SELECT
      END DO
      RETURN
      END SUBROUTINE MAJOR_PLATON_LOOP
 
      MODULE files
      SAVE
      INTEGER, PARAMETER :: NVDR = 100000000   ! real    array VOID size
      INTEGER, PARAMETER :: NVDI = 100000000   ! integer ARRAY IAR  size
      INTEGER, PARAMETER :: NP23 = 28000
      INTEGER, PARAMETER :: NP74 = 28000
      INTEGER, PARAMETER :: NVDS = 100000000   ! shx86
      INTEGER, PARAMETER :: NVDL = 100000000   ! laue
      INTEGER :: KXT
      INTEGER :: KERR
      INTEGER :: IOST = 0
      INTEGER :: KNMXT
      INTEGER :: KNM16
      INTEGER :: KNMFIL = 6
      INTEGER :: INDP
      INTEGER :: ISAVEMOD = 0
      INTEGER :: LU1  =  1 ! INPUT OF PARAMETER DATA (CIF/RES/SPF etc)
      INTEGER :: LU2  =  2 ! OUTPUT OF PLATON DATA FOR SHELX(L) ETC.
      INTEGER :: LU3  =  3 ! SAVE(D) INSTRUCTION FILE (INTERNAL USE ONLY)
      INTEGER :: LU4  =  4 ! SCRATCH FILE (BINARY) ATOMIC PARAMETERS
      INTEGER :: LU5  =  5 ! INPUT OF CONTROL RECORD(S) FOR CALCN(S)
      INTEGER :: LU6  =  6 ! INTERACTIVE OUTPUT TO TERMINAL DISPLAY
      INTEGER :: LU7  =  7 ! LINEPRINTER OUTPUT
      INTEGER :: LU8  =  8 ! SCRATCH-BINARY FILE  (PLANES ETC)
      INTEGER :: LU9  =  9 ! REFLECTION SCRATCH (BINARY)
      INTEGER :: LU10 = 10 ! VALIDATION-LIST-OUTPUT  (SCRATCH IN HELENA)
      INTEGER :: LU11 = 11 ! CIF-DATA SCRATCH        (SCRATCH IN HELENA)
      INTEGER :: LU12 = 12 ! IUCR-CHECK-DEF (VALIDATION)
      INTEGER :: LU13 = 13 ! CKF-FILE (VALIDATION)
      INTEGER :: LU14 = 14 ! SCRATCH (ASYM) OR CHECK.SUM
      INTEGER :: LU15 = 15 ! SAV-FILE
      INTEGER :: LU16 = 16 ! REFLECTION DATA IN
      INTEGER :: LU17 = 17 ! REFLECTION DATA OUT (HKP)
      INTEGER :: LU18 = 18 ! REFLECTION DATA OUT (HKS)
      INTEGER :: LU19 = 19 ! BIN
      INTEGER :: LU20 = 20 ! SCRATCH (FORMATTED)
      INTEGER :: LU21 = 21 ! MODIFIED SHELXL.RES FILE
      INTEGER :: LU22 = 22 ! PLUTON.PJN
      INTEGER :: LU23 = 23 ! DEF-FILE
      INTEGER :: LU24 = 24 ! SHELXL(20xy) _sx.ins
      INTEGER :: LU25 = 25 ! SHELXL(20xy) _sx.hkl
      INTEGER :: LU26 = 26 ! SHELXL(20xy) _sx.fab
      INTEGER :: LU27 = 27 ! BINARY REFLECTION FILE
      INTEGER :: LU28 = 28 ! _iucr_fcf
      INTEGER :: LU60 = 60 ! (.RAS,.POV,.SUP,_ACC.CIF)
      INTEGER :: LU61 = 61 !
      INTEGER :: LU62 = 62 !
      INTEGER :: LU63 = 63 !
      INTEGER :: LU64 = 64 !
      INTEGER :: LU65 = 65 !
      INTEGER :: LU66 = 66 ! checkCIF VRF file
      INTEGER :: LU67 = 67 !
      INTEGER :: LU68 = 68 ! ALERT SCRATCH FILE
      INTEGER :: LU98 = 98 ! - GRAPHICS
      INTEGER, DIMENSION(2, NP23) :: JNSC
      INTEGER, DIMENSION(NP74)    :: JNSX
      INTEGER, DIMENSION(25)      :: INDEXP
      REAL, DIMENSION(NVDR) :: VOID
      CHARACTER(len=8)   :: PAGET = '        '
      CHARACTER(len=20)  :: DATIJD
      CHARACTER(len=80)  :: FNLU16
      CHARACTER(len=255) :: PLAPATH
      CHARACTER(len=80)  :: SHLPATH
      CHARACTER(len=80)  :: SHTPATH
      CHARACTER(len=255) :: BROWSER
      CHARACTER(len=255) :: CGETENV
      CHARACTER(len=40)  :: CURLPATH
      CHARACTER(len=80)  :: CHECKDEF = '/usr/local/lib/platon/check.def'
      CHARACTER(len=40)  :: HTTPSERVER = 'https://platonsoft.nl/'
      CHARACTER(len=80)  :: INCLUDEFILE
      CHARACTER(len=8), DIMENSION(25) :: PAGEIND
      LOGICAL :: DOS = .FALSE.
      LOGICAL :: EXST
      LOGICAL :: OPEND
      LOGICAL :: EXST1
      LOGICAL :: EXST16
      LOGICAL :: EXST21
      LOGICAL :: EXST61
      END MODULE files
 
      MODULE plato
      SAVE
      INTEGER, PARAMETER :: NP1  = 20000
      INTEGER, PARAMETER :: NP2  = 99
      INTEGER, PARAMETER :: NP6  = 100
      INTEGER, PARAMETER :: NP7  = 50
      INTEGER, PARAMETER :: NP8  = 50
      INTEGER, PARAMETER :: NP11 = 128
      INTEGER, PARAMETER :: NP19 = 31
      INTEGER, PARAMETER :: NP25 = 99
      INTEGER, PARAMETER :: NP29 = 63
      INTEGER, PARAMETER :: NP41 = 200
      INTEGER, PARAMETER :: NP47 = 9
      INTEGER, PARAMETER :: NP62 = 250
      INTEGER, PARAMETER :: NP65 = 20
      INTEGER, PARAMETER :: MP7  = 256
      INTEGER :: NDERIV
      INTEGER :: MXNW
      INTEGER :: NETTYPE
      INTEGER, DIMENSION(NP11)           :: MP
      INTEGER, DIMENSION(NP1)            :: JR
      INTEGER, DIMENSION(NP1)            :: JCA
      INTEGER, DIMENSION(NP8, 5)         :: KBO
      INTEGER, DIMENSION(NP11)           :: MOL
      INTEGER, DIMENSION(3, NP1)         :: IFG
      INTEGER, DIMENSION(3)              :: ITR
      INTEGER, DIMENSION(NP19)           :: NCN
      INTEGER, DIMENSION(NP19)           :: JLN
      INTEGER, DIMENSION(8)              :: ISPV
      INTEGER, DIMENSION(7, 2)           :: IPLA
      INTEGER, DIMENSION(0:NP29)         :: NPOL
      INTEGER, DIMENSION(NP29)           :: MLTI
      INTEGER, DIMENSION(0:NP29)         :: MPOL
      INTEGER, DIMENSION(NP1)            :: IATP
      INTEGER, DIMENSION(NP1)            :: IATC
      INTEGER, DIMENSION(NP1)            :: LABA
      INTEGER, DIMENSION(NP1)            :: JATC
      INTEGER, DIMENSION(NP1)            :: IFNT
      INTEGER, DIMENSION(NP6, 2)         :: IBON
      INTEGER, DIMENSION(NP7)            :: IDIR
      INTEGER, DIMENSION(NP11)           :: MOLS
      INTEGER, DIMENSION(MP7, 3)         :: IPPR
      INTEGER, DIMENSION(8)              :: IXPV
      INTEGER, DIMENSION(6)              :: ISDV
      INTEGER, DIMENSION(6)              :: IXSD
      INTEGER, DIMENSION(4, 3, 5)        :: LHNT
      INTEGER, DIMENSION(64, 3)          :: NETW
      INTEGER, DIMENSION((NP65 + 1) * 5) :: NALV
      INTEGER, DIMENSION(NP1)            :: NTRNS
      INTEGER, DIMENSION(10)             :: IDBUF
      INTEGER, DIMENSION(NP47)           :: NEWLAT
      INTEGER, DIMENSION(NP65)           :: JENTRY
      INTEGER, DIMENSION(3, NP62)        :: IHKLOMIT
      REAL,    DIMENSION(4)         :: V1
      REAL,    DIMENSION(3)         :: V2
      REAL,    DIMENSION(3)         :: V3
      REAL,    DIMENSION(3)         :: V4
      REAL,    DIMENSION(3)         :: V5
      REAL,    DIMENSION(3)         :: V6
      REAL,    DIMENSION(3)         :: V7
      REAL,    DIMENSION(3)         :: V8
      REAL,    DIMENSION(NP25)      :: RP
      REAL,    DIMENSION(2, 132)    :: DP
      REAL,    DIMENSION(3, 3)      :: AA
      REAL,    DIMENSION(3, 3)      :: BB
      REAL,    DIMENSION(3, 3)      :: QQ
      REAL,    DIMENSION(3, 3)      :: OR
      REAL,    DIMENSION(3, 3)      :: QM
      REAL,    DIMENSION(3, 3)      :: TM1
      REAL,    DIMENSION(3, 3)      :: TM2
      REAL,    DIMENSION(3, 3)      :: UIJ
      REAL,    DIMENSION(3, 3)      :: RIK
      REAL,    DIMENSION(3, 3)      :: UKL
      REAL,    DIMENSION(3)         :: ORG
      REAL,    DIMENSION(6)         :: DEV
      REAL,    DIMENSION(6)         :: SDV
      REAL,    DIMENSION(8)         :: XPV
      REAL,    DIMENSION(5)         :: RMS
      REAL,    DIMENSION(NP1, 6)    :: XXO
      REAL,    DIMENSION(NP1, 6)    :: XSD
      REAL,    DIMENSION(NP1, 9)    :: CON
      REAL,    DIMENSION(10, NP2)   :: XLS
      REAL,    DIMENSION(NP8, 6)    :: BOK
      REAL,    DIMENSION(4, NP29)   :: RCG
      REAL,    DIMENSION(3, 5)      :: PAC
      REAL,    DIMENSION(10, 2)     :: SLN
      REAL,    DIMENSION(3, 3)      :: PAT
      REAL,    DIMENSION(3, 3)      :: ROR
      REAL,    DIMENSION(3, 3)      :: RAA
      REAL,    DIMENSION(3, 3)      :: RBB
      REAL,    DIMENSION(3, 3)      :: DAM
      REAL,    DIMENSION(3, 3)      :: RORO
      REAL,    DIMENSION(3, 3)      :: UIJC
      REAL,    DIMENSION(3, 3)      :: TRNS
      REAL,    DIMENSION(3, 3)      :: RMAT
      REAL,    DIMENSION(3, 3)      :: ADIR
      REAL,    DIMENSION(3, 3)      :: AINV
      REAL,    DIMENSION(15, NP41)  :: SXYZ
      REAL,    DIMENSION(2, 100)    :: YMOL
      REAL,    DIMENSION(10)        :: DBUF
      REAL,    DIMENSION(6)         :: DUMA
      REAL,    DIMENSION(3)         :: SHFT
      REAL,    DIMENSION(8)         :: XSPV
      REAL,    DIMENSION(8)         :: VECN
      REAL,    DIMENSION(15)        :: BASF
      REAL,    DIMENSION(NP1)       :: DATC
      REAL,    DIMENSION(NP1, 6)    :: ANIS
      REAL,    DIMENSION(NP1, 7)    :: SUAN
      REAL,    DIMENSION(NP7, 3, 4) :: XDIR
      REAL,    DIMENSION(3, 155)    :: SCIR
      REAL,    DIMENSION(3, 3)      :: DUMV
      REAL,    DIMENSION(3)         :: VECIJ
      REAL,    DIMENSION(3)         :: VIEWV
      REAL,    DIMENSION(10)        :: TWINF
      REAL,    DIMENSION(3)         :: VECJK
      REAL,    DIMENSION(3)         :: VECKL
      REAL,    DIMENSION(63)        :: RCONT
      REAL,    DIMENSION(3, 3)      :: ORRES
      REAL,    DIMENSION(3, 3)      :: TRNSM1
      REAL,    DIMENSION(3, 3)      :: ROTM1
      REAL,    DIMENSION(3, 3)      :: ROTM2
      CHARACTER(len=1), DIMENSION(7)         :: CVLAG =
     1 (/'S', 'G', 'R', 'D', 'T', 'U', 'P'/)
      CHARACTER(len=5),  DIMENSION(NP65 + 1) :: BNDTP
      CHARACTER(len=13), DIMENSION(NP65 + 1) :: POISSON
      CHARACTER(len=60), DIMENSION(NP29)     :: RFORM
      END MODULE plato
 
      MODULE atomdata
      SAVE
      INTEGER, PARAMETER :: NP9    = 119
      INTEGER, PARAMETER :: NP10   = 16
      INTEGER, PARAMETER :: NP10P1 = 17 ! = NP10 + 1
      INTEGER, PARAMETER :: NP53   = 1632
      INTEGER :: IAN
      INTEGER :: ICLR
      INTEGER, DIMENSION(NP10) :: NWX
      INTEGER, DIMENSION(NP10) :: NOX
      INTEGER, DIMENSION(NP9)  :: IEL = (/
     1  800,  300, 1500, 1400,  312, 1900,  218, 1600,  900,  321,
     2 1409,  103,  107,  112,  113,  118,  119,  120,  121,  200,
     3  201,  205,  209,  211,  301,  304,  305,  306,  313,  315,
     4  318,  319,  400,  425,  518,  519,  521,  600,  605,  613,
     5  618,  701,  704,  705,  805,  806,  807,  815,  914,  918,
     6 1100, 1118, 1201, 1209, 1221, 1223, 1304, 1307, 1314, 1315,
     7 1401, 1402, 1404, 1405, 1415, 1416, 1519, 1601, 1602, 1604,
     8 1613, 1615, 1618, 1620, 1621, 1801, 1802, 1805, 1808, 1814,
     9 1821, 1902, 1903, 1905, 1909, 1913, 1914, 1918, 2001, 2002,
     * 2003, 2005, 2008, 2009, 2012, 2013, 2100, 2200, 2300, 2405,
     1 2500, 2502, 2614, 2618, 1819,  307, 2601, 2602, 2603, 1523,
     2 1700, 2400,  823, 2600, 1518, 1501, 1502, 1503, 1200/)
      INTEGER, DIMENSION(NP10) :: IEN =
     1  (/0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0/)
      INTEGER, DIMENSION(NP10) :: IACL
C * H, C, O, N, ....
      INTEGER, DIMENSION(NP10) :: IBCL =
     1  (/17, 3, 6, 2, 5, 4, 1, 7, 8, 9, 0, 0, 0, 0, 0, 0/)
      INTEGER, DIMENSION(NP10) :: IENS
C * H, C, O, N, ....
      INTEGER, DIMENSION(NP10) :: JACL
     1  = (/17, 1, 2, 4, 3, 5, 6, 7, 8, 0, 0, 0, 0, 0, 0, 0/)
C * ELEMENT CHARACTERISTICS   (NEGATIVE = NONMETAL)
C * 2 = LANTHANIDE, 3 = ACTINIDE, 4 = TRANSITION, 5 = ALKALI
C * 6 = ALKALI EARTH, 7 = HALOGEN
      INTEGER, DIMENSION(NP9) :: IATPR = (/
     1   -1,   -1,   -1,   -1,   -7,   -1,   -7,   -1,   -7,   4,
     2    4,    3,    4,    1,    3,   -1,   -1,   -7,    4,  -1,
     3    6,    6,    1,    3,    6,    4,    2,    3,    3,   4,
     4    4,    5,   -1,    2,    2,    3,    2,   -7,    4,   3,
     5    5,    1,    2,   -1,   -1,    4,    4,    2,    1,   4,
     6    5,   -1,    2,    5,    2,    3,    3,    6,    4,   4,
     7    5,    4,    2,   -1,    3,    3,    4,    3,    1,   4,
     8    2,    1,    2,    4,    3,    6,    5,    4,    4,  -1,
     9    4,    1,    4,   -1,   -1,    2,    1,    6,    4,   2,
     *    4,   -1,    3,    4,    1,    2,    3,    4,    4,  -1,
     1    4,    2,    4,    4,    8,   -8,    8,    8,    8,  -1,
     2   -1,   -1,   -1,   -1,    8,    8,    8,    8,    8/)
C * ATOM NUMBERS
      INTEGER, DIMENSION(NP9) :: IATNR = (/
     1    1,    6,    8,    7,   17,   16,   35,   15,   53,   29,
     2   28,   89,   47,   13,   95,   18,   33,   85,   79,    5,
     3   56,    4,   83,   97,   20,   48,   58,   98,   96,   27,
     4   24,   55,    1,   66,   68,   99,   63,    9,   26,  100,
     5   87,   31,   64,   32,    2,   72,   80,   67,   49,   77,
     6   19,   36,   57,    3,   71,  103,  101,   12,   25,   42,
     7   11,   41,   60,   10,  102,   93,   76,   91,   82,   46,
     8   61,   84,   59,   78,   94,   88,   37,   75,   45,   86,
     9   44,   51,   21,   34,   14,   62,   50,   38,   73,   65,
     *   43,   52,   90,   22,   81,   69,   92,   23,   74,   54,
     1   39,   70,   30,   40,    0,    0,    0,    0,    0,    8,
     2    6,    0,    1,    0,    0,    0,    0,    0,    0/)
      INTEGER, DIMENSION(NP10) :: IENLB
      INTEGER, DIMENSION(NP10) :: IDOAC =
     1 (/3, 4, 5, 6, 7, 8, 9, 38, 84, 110, 10, 2, 0, 0, 0, 0/)
      INTEGER, DIMENSION(NP9)  :: IVALMAX = (/
     1    9,    9,   -9,   -9,    9,    9,    9,    9,    9,   9,
     2    3,    9,    1,    9,    9,    9,    9,    9,    3,   9,
     3    9,    9,    9,    9,    9,    9,    9,    9,    9,   3,
     4    3,    9,    9,    9,    9,    9,    3,    9,    3,   9,
     5    9,    9,    9,    9,    9,    9,    9,    9,    9,   3,
     6    9,    9,    9,    9,    9,    9,    9,    9,    4,   9,
     7    9,    9,    9,    9,    9,    9,    9,    9,    9,   2,
     8    9,    9,    9,    2,    9,    9,    9,    9,    9,   9,
     9    3,    5,    9,    9,    9,    9,    9,    9,    9,   9,
     *    9,    9,    9,    4,    9,    9,    9,    5,    9,   9,
     1    9,    9,    9,    9,    9,    9,    9,    9,    9,   9,
     2    9,    9,    9,    9,    9,    9,    9,    9,    9/)
      REAL, DIMENSION(3, NP10) :: RGB = RESHAPE((/
     1 0.625,  0.625,  0.625, 0.750,  0.050,  0.050,
     3 0.400,  1.000,  0.400, 0.125,  0.125,  1.000,
     5 1.000,  1.000,  0.000, 0.800,  0.200,  0.200,
     7 0.320,  0.200,  0.320, 0.660,  0.160,  0.160,
     9 0.000,  0.000,  0.000, 0.000,  0.000,  0.000,
     1 0.000,  0.000,  0.000, 0.000,  0.000,  0.000,
     3 0.000,  0.000,  0.000, 0.000,  0.000,  0.000,
     5 0.000,  0.000,  0.000, 0.000,  0.000,  0.000/), (/3, NP10/))
C * MU(A) BASED ON MU/RHO VALUES FROM INT. TABLES C - TABLE 4.2.4.2
C * - P 193-199 (CF. SHELXL97):(MU(A) = (MU/RHO) / (ATWEIGHT * 1.66043))
C * CuKa/GaKa/MoKa/AgKa/InKa
C * (For GaKa & InKa for elements 93-98: PROGRAM FPRIME)
C * INKA 0.51359
      REAL, DIMENSION(NP9, 5) :: AMR = RESHAPE((/
     1       0.7,       6.6,      15.1,      10.0,     261.4,
     2     205.0,    4205.6,     158.3,    3172.3,    2108.0,
     3    1846.5,   24710.1,    1950.4,      89.6,   30292.1,
     4     328.8,    3398.2,   20776.6,   15698.2,       4.4,
     5    3985.2,       2.9,   18976.3,   19827.6,     499.4,
     6    2123.8,    4599.7,   20451.3,   27300.7,    1608.8,
     7    1023.3,    3702.8,       0.7,    7737.1,    8715.3,
     8       0.0,    6421.3,      22.5,    1393.1,       0.0,
     9   22672.8,    2702.1,    6837.3,    3037.1,       1.4,
     *   10924.6,   16482.2,    8215.5,    2308.6,   14211.2,
     1     407.5,    4651.1,    4282.6,       2.0,   10335.5,
     2       0.0,       0.0,      65.2,    1198.4,    7866.1,
     3      46.7,    7290.6,    5275.7,      32.9,       0.0,
     4   28091.4,   13504.9,   26829.2,   18122.5,    1788.3,
     5    5639.4,   19867.3,    4930.1,   14944.2,   28987.3,
     6   23668.4,    5121.5,   12823.5,   10003.8,   21712.9,
     7    9234.2,    2714.5,     605.9,    3788.7,     120.2,
     8    6021.3,    2505.5,    5633.8,   11535.2,    7281.1,
     9    8522.0,    2936.6,   25757.6,     727.5,   17290.7,
     *    9235.6,   27902.5,     865.7,   12169.0,    3423.3,
     1    6166.2,    9776.5,    2992.7,    6727.8,       0.0,
     2       0.0,       0.0,       0.0,       0.0,      15.1,
     3       0.0,       0.0,       0.7,       0.0,       0.0,
     4       0.0,       0.0,       0.0,       0.0,
C * AGKA 0.56086
     1 0.614E+00, 0.745E+01, 0.182E+02, 0.117E+02, 0.341E+03,
     2 0.267E+03, 0.535E+04, 0.206E+03, 0.409E+04, 0.271E+04,
     3 0.238E+04, 0.311E+05, 0.251E+04, 0.116E+03, 0.250E+05,
     4 0.429E+03, 0.433E+04, 0.262E+05, 0.199E+05, 0.479E+01,
     5 0.511E+04, 0.313E+01, 0.240E+05, 0.250E+05, 0.652E+03,
     6 0.273E+04, 0.588E+04, 0.289E+05, 0.246E+05, 0.207E+04,
     7 0.133E+04, 0.475E+04, 0.614E+00, 0.985E+04, 0.111E+05,
     8 0.000E+00, 0.819E+04, 0.277E+02, 0.180E+04, 0.000E+00,
     9 0.285E+05, 0.346E+04, 0.872E+04, 0.387E+04, 0.128E+01,
     * 0.139E+05, 0.209E+05, 0.104E+05, 0.297E+04, 0.180E+05,
     1 0.532E+03, 0.592E+04, 0.549E+04, 0.206E+01, 0.131E+05,
     2 0.000E+00, 0.000E+00, 0.842E+02, 0.155E+04, 0.115E+05,
     3 0.596E+02, 0.922E+04, 0.674E+04, 0.412E+02, 0.000E+00,
     4 0.299E+05, 0.171E+05, 0.342E+05, 0.229E+05, 0.230E+04,
     5 0.720E+04, 0.251E+05, 0.630E+04, 0.189E+05, 0.227E+05,
     6 0.298E+05, 0.652E+04, 0.162E+05, 0.210E+04, 0.273E+05,
     7 0.192E+04, 0.350E+04, 0.789E+03, 0.482E+04, 0.156E+03,
     8 0.768E+04, 0.323E+04, 0.715E+04, 0.146E+05, 0.927E+04,
     9 0.107E+05, 0.378E+04, 0.323E+05, 0.947E+03, 0.219E+05,
     * 0.117E+05, 0.350E+05, 0.112E+04, 0.154E+05, 0.441E+04,
     1 0.780E+04, 0.124E+05, 0.307E+04, 0.847E+04, 0.000E+00,
     2 0.000E+00, 0.000E+00, 0.000E+00, 0.000E+00, 0.182E+02,
     3 0.000E+00, 0.000E+00, 0.614E+00, 0.0      , 0.0      ,
     4 0.0      , 0.0      , 0.0,       0.0,
C * MOKA 0.71073
     1 0.624E+00, 0.115E+02, 0.325E+02, 0.196E+02, 0.678E+03,
     2 0.532E+03, 0.100E+05, 0.410E+03, 0.773E+04, 0.518E+04,
     3 0.457E+04, 0.540E+05, 0.476E+04, 0.229E+03, 0.189E+05,
     4 0.851E+03, 0.822E+04, 0.407E+05, 0.365E+05, 0.661E+01,
     5 0.965E+04, 0.383E+01, 0.438E+05, 0.201E+05, 0.129E+04,
     6 0.518E+04, 0.111E+05, 0.209E+05, 0.201E+05, 0.401E+04,
     7 0.258E+04, 0.898E+04, 0.624E+00, 0.184E+05, 0.207E+05,
     8 0.000E+00, 0.154E+05, 0.515E+02, 0.349E+04, 0.000E+00,
     9 0.322E+05, 0.660E+04, 0.163E+05, 0.738E+04, 0.134E+01,
     * 0.258E+05, 0.382E+05, 0.195E+05, 0.563E+04, 0.331E+05,
     1 0.105E+04, 0.110E+05, 0.104E+05, 0.228E+01, 0.244E+05,
     2 0.000E+00, 0.000E+00, 0.165E+03, 0.302E+04, 0.300E+04,
     3 0.116E+03, 0.273E+04, 0.127E+05, 0.786E+02, 0.000E+00,
     4 0.257E+05, 0.316E+05, 0.387E+05, 0.419E+05, 0.436E+04,
     5 0.135E+05, 0.458E+05, 0.119E+05, 0.348E+05, 0.162E+05,
     6 0.330E+05, 0.121E+05, 0.301E+05, 0.399E+04, 0.398E+05,
     7 0.364E+04, 0.662E+04, 0.156E+04, 0.911E+04, 0.310E+03,
     8 0.144E+05, 0.611E+04, 0.132E+05, 0.272E+05, 0.174E+05,
     9 0.332E+04, 0.716E+04, 0.370E+05, 0.186E+04, 0.401E+05,
     * 0.219E+05, 0.403E+05, 0.220E+04, 0.286E+05, 0.834E+04,
     1 0.143E+05, 0.231E+05, 0.586E+04, 0.247E+04, 0.000E+00,
     2 0.000E+00, 0.000E+00, 0.000E+00, 0.000E+00, 0.325E+02,
     3 0.000E+00, 0.000E+00, 0.624E+00, 0.0      , 0.0      ,
     4 0.0      , 0.0      , 0.0,       0.0,
C * GAKA 1.3414
     1       0.6,      57.1,     193.4,     109.9,    4162.2,
     2    3294.4,    7840.1,    2560.5,   41756.0,   28058.5,
     3   25038.0,   74252.0,   26090.1,    1447.9,   92420.1,
     4    5181.0,    6173.2,   61961.4,   46030.9,      26.6,
     5   51793.2,      11.0,   56254.7,  100049.1,    7678.0,
     6   28360.2,   59203.9,  102821.8,   95858.6,   22109.5,
     7   14773.5,   48349.0,       0.6,   95237.5,   67379.9,
     8       0.0,   80378.8,     317.7,   19450.3,       0.0,
     9   67977.1,    4786.5,   85155.2,    5448.7,       1.7,
     *   31510.4,   48465.2,   87267.5,   30756.5,   41453.6,
     1    6349.0,    8795.2,   55362.7,       4.2,   29737.4,
     2       0.0,       0.0,    1045.0,   17004.7,   16653.4,
     3     732.4,   15119.3,   67162.7,     494.0,       0.0,
     4   85439.3,   39295.1,   80981.3,   53590.1,   23961.5,
     5   71418.3,   59082.9,   63110.1,   43704.6,   88080.1,
     6   71084.4,    9820.1,   37233.7,   21950.7,   64939.0,
     7   20068.6,   35966.3,    9182.7,    6972.5,    1947.9,
     8   75832.4,   33293.6,   11104.2,   33349.3,   90317.2,
     9   18296.1,   38783.4,   77588.3,   10857.6,   50984.7,
     *   71284.4,   84399.8,   12716.4,   35261.7,   44918.3,
     1   12343.5,   75481.0,    4188.7,   13676.4,       0.0,
     2       0.0,       0.0,       0.0,       0.0,     193.4,
     3       0.0,       0.0,       0.6,       0.0,       0.0,
     4       0.0,       0.0,       0.0,       0.0,
C * CUKa 1.5418
     1 0.655E+00, 0.899E+02, 0.304E+03, 0.173E+03, 0.624E+04,
     2 0.497E+04, 0.118E+05, 0.388E+04, 0.607E+05, 0.547E+04,
     3 0.476E+04, 0.143E+06, 0.382E+05, 0.222E+04, 0.144E+06,
     4 0.772E+04, 0.929E+04, 0.865E+05, 0.669E+05, 0.415E+02,
     5 0.750E+05, 0.166E+02, 0.843E+05, 0.143E+06, 0.113E+05,
     6 0.415E+05, 0.857E+05, 0.150E+06, 0.138E+06, 0.314E+05,
     7 0.213E+05, 0.700E+05, 0.655E+00, 0.977E+05, 0.367E+05,
     8 0.000E+00, 0.110E+06, 0.498E+03, 0.280E+05, 0.000E+00,
     9 0.102E+06, 0.719E+04, 0.105E+06, 0.819E+04, 0.194E+01,
     * 0.460E+05, 0.668E+05, 0.347E+05, 0.450E+05, 0.624E+05,
     1 0.940E+04, 0.132E+05, 0.803E+05, 0.576E+01, 0.450E+05,
     2 0.000E+00, 0.000E+00, 0.161E+04, 0.246E+05, 0.246E+05,
     3 0.114E+04, 0.223E+05, 0.968E+05, 0.768E+03, 0.000E+00,
     4 0.123E+06, 0.580E+05, 0.106E+06, 0.798E+05, 0.352E+05,
     5 0.102E+06, 0.881E+05, 0.912E+05, 0.634E+05, 0.113E+06,
     6 0.102E+06, 0.148E+05, 0.572E+05, 0.323E+05, 0.972E+05,
     7 0.295E+05, 0.525E+05, 0.135E+05, 0.105E+05, 0.297E+04,
     8 0.108E+06, 0.486E+05, 0.165E+05, 0.485E+05, 0.847E+05,
     9 0.270E+05, 0.565E+05, 0.118E+06, 0.159E+05, 0.754E+05,
     * 0.393E+05, 0.112E+06, 0.185E+05, 0.513E+05, 0.652E+05,
     1 0.183E+05, 0.410E+05, 0.629E+04, 0.203E+05, 0.000E+00,
     2 0.000E+00, 0.000E+00, 0.000E+00, 0.000E+00, 0.304E+03,
     3 0.000E+00, 0.000E+00, 0.655E+00, 0.0      , 0.0      ,
     4 0.0      , 0.0      , 0.0,       0.0/), (/119, 5/))
C * COVALENT RADII
      REAL, DIMENSION(NP9) :: REL = (/
     1 0.35, 0.68, 0.68, 0.68, 0.99, 1.04, 1.21, 1.05, 1.60, 1.52,
     2 1.50, 1.88, 1.59, 1.35, 1.75, 0.00, 1.21, 0.00, 1.50, 0.83,
     3 1.34, 0.35, 1.72, 1.75, 0.99, 1.69, 1.83, 1.75, 1.75, 1.23,
     4 1.35, 1.67, 0.35, 1.75, 1.73, 1.75, 1.99, 0.64, 1.35, 1.75,
     5 0.00, 1.26, 1.79, 1.27, 0.00, 1.57, 1.70, 1.74, 1.63, 1.32,
     6 1.33, 0.00, 1.87, 0.68, 1.72, 1.75, 1.75, 1.10, 1.35, 1.47,
     7 0.97, 1.48, 1.81, 0.00, 1.75, 1.70, 1.50, 1.61, 1.97, 1.50,
     8 1.80, 1.68, 1.82, 1.50, 1.53, 1.90, 1.47, 1.60, 1.45, 0.00,
     9 1.50, 1.46, 1.44, 1.22, 1.20, 1.80, 1.65, 1.12, 1.43, 1.76,
     * 1.35, 1.49, 1.79, 1.47, 1.64, 1.72, 1.75, 1.33, 1.37, 1.40,
     1 1.78, 1.94, 1.45, 1.56, 0.00, 0.00, 0.00, 0.00, 0.00, 0.68,
     2 0.68, 0.00, 0.23, 1.00, 0.00, 0.00, 0.00, 0.00, 0.00/)
      REAL, DIMENSION(NP10P1, 99) :: CONT
      REAL, DIMENSION(5)          :: STWL = (/
     1 1.5418, 1.3414, 0.71073, 0.56086, 0.51359/)
      REAL, DIMENSION(NP10, 4) :: RADR
      REAL, DIMENSION(NP10, 3) :: ANOM
      REAL, DIMENSION(2242)    :: SFAC
C * ATOMIC WEIGHTS (C12-IUPAC 1989) - HANDBOOK FOR PHYSICS & CHEMISTRY
C * UPDATED (IUPAC 1993) FROM Inorg. Chim. Acta 217 (1994) 217-218
      REAL, DIMENSION(NP9) :: ATWT = (/
     1   1.00794,    12.011,   15.9994, 14.00674,   35.4527,    32.06,
     2    79.904, 30.973762, 126.90447,   63.546,   58.6934, 227.0278,
     3  107.8682, 26.981539,    241.06,   39.948,  74.92159,   209.99,
     4 196.96654,    10.811,   137.327, 9.012182, 208.98037,   249.08,
     5    40.078,   112.411,   140.115,   252.08,    244.06, 58.93320,
     6   51.9961, 132.90543,     2.014,   162.50,    167.26,   252.08,
     7   151.965, 18.998403,    55.845,   257.10,    223.02,   69.723,
     8    157.25,     72.61,  4.002602,   178.49,    200.59, 164.9303,
     9    114.82,    192.22,   39.0983,    83.80,  138.9055,    6.941,
     *   174.967,    262.11,    258.10,  24.3050,  54.93805,    95.94,
     1 22.989768,  92.90638,    144.24,  20.1797,    259.10, 237.0482,
     2    190.23, 231.03588,     207.2,   106.42,    146.92,   209.98,
     3 140.90765,    195.08,     242.0, 226.0254,   85.4678,  186.207,
     4 102.90550,    222.02,    101.07,  121.757, 44.955910,    78.96,
     5   28.0855,    150.36,   118.710,    87.62,  180.9479, 158.9253,
     6    98.906,    127.60,  232.0381,   47.867,  204.3833, 168.9342,
     7  238.0289,   50.9415,    183.84,   131.29,  88.90585,   173.04,
     8     65.39,    91.224,       0.0,      0.0,     999.0,    999.0,
     9     999.0,   15.9994,      12.0,      0.0,   1.00794,      0.0,
     *       0.0,       0.0,       0.0,      0.0,       0.0/)
C * VAN DER WAALS RADII - A.BONDI, J.CHEM.PHYS.(1964),68,441-451.
C * OTHER ENTRIES FROM CCDC/MERCURY
C * NEGATIVE ENTRIES WERE ESTIMATED AS COVALENT RADIUS + 0.8 ANG.
      REAL, DIMENSION(NP9) :: VDWR = (/
     1 1.20, 1.70, 1.52, 1.55, 1.75, 1.80, 1.85, 1.80, 1.98, 1.40,
     2 1.63,-2.68, 1.72,-2.15,-2.31, 1.88, 1.85, 0.00, 1.66,-1.63,
     3-2.14,-1.15,-2.34,-2.55,-1.79, 1.58,-2.63,-2.55,-2.55,-2.03,
     4-2.15,-2.47, 1.20,-2.55,-2.53,-2.55,-2.79, 1.47,-2.14,-2.55,
     5 0.00, 1.87,-2.59,-1.97, 1.40,-2.37, 1.55,-2.54, 1.93,-2.12,
     6 2.75, 2.02,-2.67, 1.82,-2.52,-2.55,-2.55, 1.73,-2.15,-2.27,
     7 2.27,-2.28,-2.61, 1.54,-2.55,-2.35,-2.17,-2.41, 2.02, 1.63,
     8-2.60,-2.48,-2.62, 1.72,-2.33,-2.70,-2.27,-2.15,-2.25, 0.00,
     9-2.30,-2.26,-2.24, 1.90, 2.10,-2.60, 2.17,-1.92,-2.23,-2.56,
     *-2.15, 2.06,-2.59,-2.27, 1.96,-2.52, 1.86,-2.13,-2.17, 2.16,
     1-2.58,-2.74,-2.25,-2.36, 0.00, 1.80, 0.00, 0.00, 0.00, 1.52,
     2 1.70, 1.80, 1.20, 1.80, 0.00, 0.00, 0.00, 0.00, 0.00/)
      REAL, DIMENSION(NP10)        :: SATWT
      REAL, DIMENSION(NP10, 14, 2) :: CIFSF
C * NEUTRON SCATTERING LENGTHS (NEUTRON DATA BOOKLET, 2003)
      REAL, DIMENSION(NP9) :: RNSCL = (/
     1 -3.7423, 6.6484,  5.805,  9.36, 9.5792,  2.847,   6.79,  5.13,
     2    5.28,  7.718,   10.3,   0.0,  5.922,  3.449,    8.3, 1.909,
     3    6.58,    0.0,   7.90,  5.30,   5.07,   7.79,  8.532,   0.0,
     4    4.70,   4.83,   4.84,   0.0,    9.5,   2.49,  3.635,  5.42,
     5   6.674,   16.9,   7.79,   0.0,    5.3,  5.654,   9.45,   0.0,
     6     0.0,  7.288,    9.5, 8.185,   3.26,   7.77, 12.595,  8.44,
     7   4.065,   10.6,   3.67,  7.81,   8.24,  -1.90,   7.21,   0.0,
     8     0.0,  5.375, -3.750, 6.715,   3.63,  7.054,   7.69, 4.566,
     9     0.0,  10.55,   10.7,   9.1,  9.401,   5.91,   12.6,   0.0,
     *    4.58,   9.60,    7.7,  10.0,   7.08,    9.2,   5.90,   0.0,
     1    7.02,   5.57,   12.1, 7.970, 4.1507,   0.00,  6.225,  7.02,
     2    6.91,   7.34,    6.8,  5.68,  10.31, -3.370,  8.776,  7.07,
     3   8.417, -0.443,  4.755,  4.69,   7.75,  12.41,  5.680,  7.16,
     4     0.0,    0.0,    0.0,   0.0,    0.0, 6.6484,    0.0,   0.0,
     5 -3.7423,    0.0,    0.0,   0.0,    0.0,    0.0,    0.0/)
C * AVERAGE ATOMIC VOLUME
C * (D.W.M.Hofmann (2002). Acta Cryst. B58, 489-493)
      REAL, DIMENSION(NP9) :: ATVOL = (/
     1 5.08,13.87,11.39, 11.8, 25.8, 25.2, 32.7, 29.5, 46.2, 26.9,
     2 26.0, 74.0, 35.0, 39.6, 17.0,  0.0, 36.4,  0.0, 43.0,13.24,
     3 66.0, 36.0, 60.0,  0.0, 45.0, 51.0, 54.0,  0.0,  0.0, 29.4,
     4 28.1, 46.0, 5.08, 50.0, 54.0,  0.0, 53.0,11.17, 30.4,  0.0,
     5  0.0, 37.8, 56.0, 41.6,  0.0, 40.0, 38.0, 42.0, 55.0, 34.3,
     6 36.0,  0.0, 58.0, 22.6, 35.0,  0.0,  0.0, 36.0, 31.9, 38.0,
     7 26.0, 37.0, 50.0,  0.0,  0.0, 45.0, 41.9, 60.0, 52.0, 35.0,
     8  0.0,  0.0,  0.0, 38.0,  0.0,  0.0, 42.0, 42.7, 31.2,  0.0,
     9 37.3, 48.0, 42.0, 30.3, 37.3, 50.0, 52.8, 47.0, 43.0, 45.0,
     * 38.0, 46.7, 56.0, 27.3, 54.0, 49.0, 58.0, 24.0, 38.8, 45.0,
     1 44.0, 59.0, 39.0, 27.0,  0.0,  0.0,  0.0,  0.0,  0.0,11.39,
     2  0.0,  0.0, 5.08,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0/)
      REAL, DIMENSION(NP10, 3) :: DISPVAL
C ********************************************************************
C * TABLE OF ELEMENT SYMBOLS KNOWN TO THE PROGRAM.                   *
C * THE ELEMENTS ARE GIVEN IN THE ORDER OF THE 11 MOST FREQUENTLY    *
C * OCCURRING, AND THEN ALPHABETICALLY.                              *
C * RS = RESIDUE, CG = RING CENTRE OF GRAV., ZA,ZB,ZC   : AUXILLARY  *
C * OW = OXYGEN ATOM OF WATER MOLECULE                               *
C ********************************************************************
      CHARACTER(len=2), DIMENSION(NP9) :: ELB = (/
     1  'H ', 'C ', 'O ', 'N ', 'Cl', 'S ', 'Br', 'P ', 'I ', 'Cu',
     2  'Ni', 'Ac', 'Ag', 'Al', 'Am', 'Ar', 'As', 'At', 'Au', 'B ',
     3  'Ba', 'Be', 'Bi', 'Bk', 'Ca', 'Cd', 'Ce', 'Cf', 'Cm', 'Co',
     4  'Cr', 'Cs', 'D ', 'Dy', 'Er', 'Es', 'Eu', 'F ', 'Fe', 'Fm',
     5  'Fr', 'Ga', 'Gd', 'Ge', 'He', 'Hf', 'Hg', 'Ho', 'In', 'Ir',
     6  'K ', 'Kr', 'La', 'Li', 'Lu', 'Lr', 'Md', 'Mg', 'Mn', 'Mo',
     7  'Na', 'Nb', 'Nd', 'Ne', 'No', 'Np', 'Os', 'Pa', 'Pb', 'Pd',
     8  'Pm', 'Po', 'Pr', 'Pt', 'Pu', 'Ra', 'Rb', 'Re', 'Rh', 'Rn',
     9  'Ru', 'Sb', 'Sc', 'Se', 'Si', 'Sm', 'Sn', 'Sr', 'Ta', 'Tb',
     *  'Tc', 'Te', 'Th', 'Ti', 'Tl', 'Tm', 'U ', 'V ', 'W ', 'Xe',
     1  'Y ', 'Yb', 'Zn', 'Zr', 'Rs', 'Cg', 'Za', 'Zb', 'Zc', 'Ow',
     2  'Q ', 'X ', 'Hw', 'Z ', 'Or', 'Oa', 'Ob', 'Oc', 'L '/)
      CHARACTER(len=2),  DIMENSION(NP10, 2) :: LMT
      CHARACTER(len=80), DIMENSION(25)      :: LREF
      CHARACTER(len=10), DIMENSION(NP10P1)  :: COLR = (/
     1 'BLACK     ', 'RED       ', 'GREEN     ', 'BLUE      ',
     2 'YELLOW    ', 'ORANGE    ', 'VIOLET    ', 'BROWN     ',
     3 'COPPER    ', 'BRASS     ', 'BRONZE    ', 'SILVER    ',
     4 'QUARTZ    ', 'GOLD      ', 'MICA      ', 'STEELBLUE ',
     5 'VOID      '/)
      CHARACTER(len=10), DIMENSION(NP10P1) :: BWCT = (/
     1 'CONTOUR   ', 'NET       ', 'SHADE     ', 'SEGMENT   ',
     2 'DOTS      ', 'BLACK     ', 'CROSS     ', 'GLOBE     ',
     3 'PARALLEL  ', 'MERIDIAN  ', 'HORIZONTAL', 'VERTICAL  ',
     4 'MESH      ', 'DIAGONAL  ', 'SLANT     ', 'TEXTILE   ',
     5 'VOID      '/)
      CHARACTER(len=4), DIMENSION(5) :: CSTWL = (/
     1 'CuKa', 'GaKa', 'MoKa', 'AgKa', 'InKa'/)
      CHARACTER(len=18), DIMENSION(NP53) :: VALENCE
      CHARACTER(len=6),  DIMENSION(10)   :: VALENCES = (/
     1 '(I)   ', '(II)  ', '(III) ', '(IV)  ', '(V)   ',  '(VI)  ',
     2 '(VII) ', '(VIII)', '(IX)  ', '      '/)
      REAL, DIMENSION(832) :: PENG
      CHARACTER(len=2), DIMENSION(NP10, 2) :: DISPTYPE
      END MODULE atomdata
 
      MODULE cchar
      SAVE
      INTEGER, PARAMETER :: NP52 = 300
      INTEGER, PARAMETER :: NP56 = 72
      INTEGER, PARAMETER :: NP57 = 72
      INTEGER, PARAMETER :: NP85 = 22
      INTEGER :: NCIF23
      INTEGER, DIMENSION(NP56) :: NCIF
      CHARACTER(len=80)   :: IDM
      CHARACTER(len=80)   :: JID
      CHARACTER(len=19)   :: FMOL
      CHARACTER(len=80)   :: LINE = '      '
      CHARACTER(len=4)    :: KRAD
      CHARACTER(len=6)    :: CHSG
      CHARACTER(len=7)    :: ZSPG
      CHARACTER(len=NP52) :: CFORM
      CHARACTER(len=132)  :: PRBUF
      CHARACTER(len=80)   :: FNLU1
      CHARACTER(len=2)    :: XLDTP
      CHARACTER(len=32)   :: DATANM
      CHARACTER(len=5)    :: LAUEGR
      CHARACTER(len=12)   :: UPDATE = '            '
      CHARACTER(len=9)    :: EXTENS = 'spf'
      CHARACTER(len=28)   :: PROGNM
      CHARACTER(len=80)   :: NAMEFIL = 'platon'
      CHARACTER(len=12)   :: SPGRNAMF
      CHARACTER(len=NP57) :: CCIF23
      CHARACTER(len=2),    DIMENSION(8)    :: JTP = (/
     1 '--', 'LN', 'AN', 'TR', 'AK', 'AE', 'HL', '  '/)
      CHARACTER(len=10),   DIMENSION(250)  :: TKST
      CHARACTER(len=NP57), DIMENSION(NP56) :: CCIF
      CHARACTER(len=NP52), DIMENSION(0:5)  :: RLWS
      CHARACTER(len=5),    DIMENSION(5)    :: DTYPE = (/
     1 'SPF  ', 'RES  ', 'CIF  ', 'PDB  ', 'C3D  '/)
      CHARACTER(len=125),  DIMENSION(55)   :: GRAPH
      CHARACTER(len=26),   DIMENSION(4)    :: SPGRNM
      CHARACTER(len=12),   DIMENSION(3)    :: KRSYST
      CHARACTER(len=80),   DIMENSION(2)    :: FILENAMES
      CHARACTER(len=6),    DIMENSION(NP85) :: CNRH
      END MODULE cchar
 
      MODULE mentry
      SAVE
      INTEGER, PARAMETER :: NP54 = 250
      INTEGER, PARAMETER :: NP66 = 27
      INTEGER :: NKAR
      INTEGER, DIMENSION(NP54, 4) :: IENTRY
      CHARACTER(len=75), DIMENSION(NP54) :: CENTRY
      CHARACTER(len=7), DIMENSION(-1:NP66) :: RDTYP = (/
     1 'HKL-EXT', 'HKL    ', 'LIST4  ', 'XTAL-F ', 'NRCVAX ', 'MOLEN  ',
     2 'CRYSTL1', 'TEXSAN1', 'MOLEN1 ', 'CRYSTL2', 'JANA2  ', 'TEXSAN2',
     3 'XD     ', 'REALS  ', 'TEXSAN3', 'JANA1-F', 'RIGAKU ', 'JANA3  ',
     4 'CRYSTLT', 'CRYSTL3', '       ', '       ', 'LIST3  ', 'LIST5  ',
     5 'LIST6  ', 'LIST7  ', 'LIST8  ', 'REALS-F', 'JANA-TW'/)
      END MODULE mentry
 
      MODULE xwdw
      SAVE
      INTEGER :: LRET
      INTEGER :: IWIN = 0
      REAL :: HRT
      REAL :: VRT
      REAL :: HORS
      REAL :: VERT
      REAL :: VRTS
      REAL :: XSH0 = 0.0     ! GRAPHICS ORIGIN (CHANGED IN SYSTEM S)
      REAL :: YSH0 = 0.0     ! GRAPHICS ORIGIN (CHANGED IN SYSTEM S)
      END MODULE XWDW
 
      MODULE cggt
      SAVE
      INTEGER :: NCNT = 0
      INTEGER :: NCHE
      INTEGER :: LMOD
      INTEGER :: NPLOT
      INTEGER :: MEDIUM
      REAL :: CHT
      REAL :: THET
      REAL :: XGGIP = 0.0
      REAL :: YGGIP = 0.0
      REAL :: ZGGIP = 0.0
      CHARACTER(len=132) :: BCD   = 'P.L.A.T.O.N'//CHAR(0)
      CHARACTER(LEN=79)  :: T111
      CHARACTER(len=79)  :: T112
      CHARACTER(len=80)  :: IGGT = ' '
      CHARACTER(len=132) :: SBCD = ' '
      CHARACTER(len=100) :: STRING
      LOGICAL :: CC   = .FALSE.
      END MODULE cggt
 
      MODULE cif
      SAVE
      INTEGER, PARAMETER :: NP78 = 50
      INTEGER, PARAMETER :: NP70 = 122
      INTEGER, PARAMETER :: NP34 = 1004
      INTEGER, PARAMETER :: NP58 = 50
      INTEGER, PARAMETER :: NKW  = 51
      INTEGER :: NL
      INTEGER :: KW
      INTEGER :: NW
      INTEGER :: NLPM
      INTEGER :: NHTP
      INTEGER :: KNUM
      INTEGER :: NSTR
      INTEGER :: ILOOP
      INTEGER :: IVOID
      INTEGER :: NSTRS
      INTEGER :: ISEMCOL = 0
      INTEGER :: IRECMAX
      INTEGER :: LRETCIF = 0
      INTEGER, DIMENSION(4)       :: ICOUNT
      INTEGER, DIMENSION(4)       :: JCOUNT
      INTEGER, DIMENSION(4)       :: KCOUNT
      INTEGER, DIMENSION(5)       :: IATYPE
      INTEGER, DIMENSION(NP58)    :: NLP
      INTEGER, DIMENSION(999)     :: NDOC
      INTEGER, DIMENSION(3, NP78) :: NOMIT
      REAL, DIMENSION(2)  :: FA
      REAL, DIMENSION(12) :: CELL
      CHARACTER(len=NP70) :: NWRD = ' '
      CHARACTER(len=NP70) :: NWRDS
      CHARACTER(len=5000) :: STRSAVE
      CHARACTER(len=1)    :: TTYPE
      CHARACTER(len=4)    :: VTYPE
      CHARACTER(len=1)    :: CTYPE
      CHARACTER(len=1), DIMENSION(4) :: WLEVEL =
     1 (/'G', 'C', 'B', 'A'/)
      CHARACTER(len=61),  DIMENSION(5)       :: ATYPE = (/
     1 'CIF Construction/Syntax Error, Inconsistent or Missing Data. ',
     2 'Indicator that the Structure Model may be Wrong or Deficient.',
     3 'Indicator that the Structure Quality may be Low.             ',
     4 'Improvement, Methodology, Query or Suggestion.               ',
     5 'Informative Message, Check.                                  '/)
      CHARACTER(len=62),  DIMENSION(4)    :: ALEVEL = (/
     1 'A = Most Likely a Serious Problem - Resolve or Explain        ',
     2 'B = A Potentially Serious Problem - Consider Carefully        ',
     3 'C = Check. Ensure it is Not caused by an Omission or Oversight',
     4 'G = General Info/Check that it is not Something Unexpected    '
     5 /)
      CHARACTER(len=NKW), DIMENSION(NP34) :: CIFDIR
      END MODULE cif
 
      MODULE ccom
      SAVE
      INTEGER, PARAMETER :: NP42 = 250
      CHARACTER(len=254) :: FNM
      CHARACTER(len=80)  :: LINE
      CHARACTER(len=58)  :: BDAT
      CHARACTER(len=40)  :: FILE1
      CHARACTER(len=50)  :: FILE3
      CHARACTER(len=10)  :: COMPD = '          '
      CHARACTER(len=80)  :: EDITOR
      CHARACTER(len=40)  :: HELPATH
      CHARACTER(len=80)  :: DATAORG
      CHARACTER(len=40)  :: PSLASER
      CHARACTER(len=80)  :: PROBLEM
      CHARACTER(len=254) :: WORKDIR
      CHARACTER(len=13)  :: COMPDFL
      CHARACTER(len=254) :: USRPATH
      CHARACTER(len=40)  :: SHSPATH
      CHARACTER(len=40)  :: SHDPATH
      CHARACTER(len=40)  :: DIRPATH
      CHARACTER(len=40)  :: CRUPATH
      CHARACTER(len=80)  :: PSVIEWER
      CHARACTER(len=40)  :: SIR04PATH
      CHARACTER(len=40)  :: SIR97PATH
      CHARACTER(len=40)  :: SIR11PATH
      CHARACTER(len=10),  DIMENSION(99)   :: JFL
      CHARACTER(len=2),   DIMENSION(16)   :: SFC
      CHARACTER(len=200), DIMENSION(2)    :: LNKS
      CHARACTER(len=50),  DIMENSION(NP42) :: TSPGR
      CHARACTER(len=8),   DIMENSION(6)    :: SSTAT = (/
     1 'Create  ', 'Data_Red', 'Setup   ', 'PhaseDet', 'Refine  ',
     2 'Finish  '/)
      CHARACTER(len=10),  DIMENSION(4)    :: SSTATA = (/
     1 'Isotropic ', 'Aniso     ', 'Hatoms    ', 'Weight_Ref'/)
      CHARACTER(len=10),  DIMENSION(9)    :: SSTATB = (/
     1 'shelxs86  ', 'shelxs97  ', 'sir97     ', 'sir2004   ',
     2 'dirdif08  ', 'shelxd    ', '          ', 'shelxt    ',
     3 'sir2011   '/)
      END MODULE ccom
 
      MODULE sgxyz
      SAVE
      INTEGER :: IERR
      REAL, DIMENSION(14) :: SGX
      REAL, DIMENSION(14) :: SGY
      REAL, DIMENSION(14) :: SGZ
      END MODULE sgxyz
 
      SUBROUTINE PLA000
C * IGBL(1) = -2 - GLOBAL INIT & ESCAPES FOR (S, HELENA, SHX86, STIDY, COMPARE)
C * IGBL(1) = -1 - INIT & FILE-OPEN
C * IGBL(1) =  0 - MANAGE INPUT DATA FILE ON UNIT LU1
      USE files
      USE parameters
      USE atomdata
      USE cchar
      USE mentry
      USE xwdw
      USE cggt
      USE cif
      IMPLICIT NONE
      INTEGER :: META = 1
      INTEGER :: IUNIT
      INTEGER :: ISWVAL = 0
      INTEGER :: IDATAFRM
      REAL    :: TREF
C * IGBL(1) = -2 : GLOBAL INIT
      IF (IGBL(1) == -2) THEN
C * INIT GLOBAL PARAMETERS
        CALL GEN097 (IGBL, 2, NP38,   0)
        CALL GEN074 (RGBL, 1, NP39, 0.0)
        NCIF23 = -1
        XLDTP  = '  '
C * SET PLATON VERSION DATE
        IGBL(4) = 250725
C * GET CURRENT DATE&TIME
        CALL DATE_TIME (DATIJD)
        PROGNM = 'PLATON-'//DATIJD
C * LOAD SFAC & BOND_VALENCE DATA IN MODULE atomdata
        CALL PLA445
C * LOAD KNOWN CIF DATANAMES IN MODULE CIF
        CALL PLA446
C * CHECK For Access to External Programs (PLATON & SHELXL ETC.)
        CALL PLA429
C * SET DEFAULT GRAPHICS MODE (EITHER X11 or POSTSCRIPT)
C STRIP_END
        IF (META == 1) CALL GGIP (-999.0, 0.0, 0.0, -2)
C * INITIALIZE GLOBAL PARAMETERS
C * VERT SIZE 'SCREEN' (CM) - CONSISTENT WITH A4 FORMAT
        RGBL(1)  = 19.5
        VERT     = RGBL(1)
C * SCREEN RATIO
        RGBL(2)  = 4.0 / 3.0
        HORS     = VERT * RGBL(2)
C * 2PI (6.28...)
        RGBL(5)  = 8 * ATAN2 (1.0, 1.0)
C * RAD = 57.295779 DEGREES
        RGBL(6)  = 360.0 / RGBL(5)
C * 2 * PI**2
        RGBL(7)  = RGBL(5)**2 / 2.0
C * 8 * PI**2
        RGBL(8)  = 4.0 * RGBL(7)
C * DelFromInputCrit
        RGBL(25) = 1.0
C * Min-Q-PEAK-Height
        RGBL(26) = 0.4
C * Min-Q-Peak-Dist
        RGBL(27) = 0.5
C * XROT
        RGBL(28) = 0.0
C * YROT
        RGBL(29) = 0.0
C * ZROT
        RGBL(30) = 0.0
C * ADDSYM ORGANIC PARAMETERS
        RGBL(31) = 0.25
        RGBL(32) = 0.45
        RGBL(33) = 0.45
C * ADDSYM INORGANIC DEFAULTS
        RGBL(34) = 0.25
        RGBL(35) = 0.25
        RGBL(36) = 0.25
C * ADDSYM (ALERT LEVEL) TOL
        RGBL(37) = 0.15
        RGBL(38) = 0.15
        RGBL(39) = 0.15
        RGBL(40) = 20.0
C * H-BOND DEFAULTS
        RGBL(41) = 0.5
        RGBL(42) = -0.12
        RGBL(43) = 100.0
        RGBL(44) = 0.5
        RGBL(45) = -0.12
        RGBL(46) = 100.0
C * SET MENU ON
        IGBL(25) = 1
C * SET ATOM SORT ON
        IGBL(33) = 1
C * SET AUTO-PLOT ON
        IGBL(35) = 1
C * SEARCH INCLUDES DI-HYDROGEN BONDS
        IGBL(56) = 1
C * WINDOW SIZE
        IGBL(62) = 4
C * SET PRINT LEVEL(S)
        IGBL(63) = 4
        IGBL(64) = 4
C * LPS OFF
        IGBL(70) = 0
C * 110 color (yellow/orange)
        IGBL(82) = 1
C * CHECK-DOC ON (TERMINAL WINDOW)
        IGBL(83) = -1
C * DIP (LIGHT/HEAVY)
        IGBL(89) = 5
C * TOP CIF ETC. ENTRY LIST
        IGBL(86) = NVDR - 6
C * DEFAULT # OF L.S. CYCLES FOR SHELXL201n FCF CREATION
        IGBL(93) = 1
C * MAX + 1 LINES/PAGE
        IGBL(102) = 51
C * BOX (DECORATION) ON
        IGBL(103) = 1
C * KEEP (0/1) P21/n & I2/n
        IGBL(106) = 1
C * PAGEHEADER
        IGBL(137) = 1
C * INIT ERROR DOC COUNT
        CALL GEN097 (NDOC, 1, 999, 0)
C * BLANK LINES
        CALL GEN038 (LINE, 1, 80)
        CALL GEN038 (IDM,  1, 80)
        CALL GEN038 (ICL,  1, 80)
C * INIT REFLECTION ENTRY LIST
        CALL GEN097 (IENTRY, 1, NP54 * 4, 0)
C * RUN OVER SWITCHES AND ARGUMENTS
        CALL PLA005 (-1, ISWVAL)
C * SPECIAL ESCAPE OPTIONS
        SELECT CASE (IGBL(3))
C * ESCAPE TO COMPARE TWO FCF REFLECTION SETS '-d' and '-J'
          CASE (6, 47)
            CALL PLA427
          CASE (11)
C * ESCAPE TO 'BMFIT' TOOL ('platon -b1') - DATA on FILE.1, FILE.2, FILE.7
            IF (ISWVAL == 1) THEN
              WRITE (LU6, 99996)
              LINE = 'mol'
              CALL PLA443 (LINE)
              CALL SPAWN ('platon -p mol_bm.res', LU6, .true., KERR)
              STOP
C * ESCAPE TO MP TOOL ('platon -b2 MP1.ins')
            ELSE IF (ISWVAL == 2) THEN
              WRITE (LU6, 99995)
              CALL PLA400
            ELSE
C * SET NEXT MAIN LOOP PARAMETER
              IGBL(1) = -1
            END IF
C STRIP_END
C * ESCAPE TO 'NATIVE' STIDY MODE (-Y)
          CASE (39)
            CALL GEN038 (JID,  1, 80)
            CALL PLA301 (0)
C * SET NEXT MAIN PLATON LOOP PARAMETER
            IGBL(1) = 4
          CASE DEFAULT
C * SET NEXT MAIN PLATON LOOP PARAMETER
            IGBL(1) = -1
        END SELECT
C * IGBL(1) = -1: INIT & FILE OPEN MODE
      ELSE IF (IGBL(1) == -1) THEN
C * INIT GRAPHICS
        CALL PLA431
        CALL GEN038 (IGGT, 1, 80)
C * CHANNEL FOR SAVED INSTRUCTIONS
        OPEN (UNIT = LU3, STATUS = 'SCRATCH', FORM = 'FORMATTED')
C * OPEN LU21, LU22, LU23
        OPEN (UNIT = LU21, FILE = NAMEFIL(1:KNMFIL)//'_pl.res',
     1                            STATUS = 'UNKNOWN', IOSTAT = IOST)
        OPEN (UNIT = LU22, FILE = NAMEFIL(1:KNMFIL)//'.pjn',
     1                            STATUS = 'UNKNOWN', IOSTAT = IOST)
        OPEN (UNIT = LU23, FILE = NAMEFIL(1:KNMFIL)//'.def',
     1                            STATUS = 'UNKNOWN', IOSTAT = IOST)
C * CHECK FOR CONTENTS OF PLUTON-DEF-FILE
        READ (LU23, 99998, IOSTAT = IOST) ICL(1:80)
C * CHECK FOR/DELETE PLATON GENERATED .DEF
        IF (IOST == 0) THEN
          IF (INDEX (ICL, 'CREATED') /= 0) THEN
            CALL GEN108 (LU23, 0)
            ENDFILE (LU23, IOSTAT = IOST)
            IGBL(23) = 0
          ELSE
            IGBL(23) = 1
          END IF
        END IF
        CALL GEN108 (LU23, 0)
C * EXECUTE & ESCAPE FOR EXPLICIT PLUTON MODE ONLY
C *  8 - PLUTON/NATIVE '-p'
C * 12 - PLUTON/RENAME
C * 13 - PLUTON/HFIX
C * 26 - PLUTON/ANIS
        IF (IGBL(3) ==  8 .OR.
     1      IGBL(3) == 12 .OR.
     2      IGBL(3) == 13 .OR.
     3      IGBL(3) == 26) THEN
          CALL PLUTON (-1)
C * SET RETURN CODE TO 'TERMINATE'
          IGBL(1) = 4
        ELSE
C * CIF DATA SCRATCH (SYMM, BOND, ANGLE ETC.
          OPEN (UNIT = LU11, STATUS = 'SCRATCH', FORM = 'UNFORMATTED',
     1         IOSTAT = IOST)
C * CALL EXIT/STOP
          IF (IOST /= 0) CALL GEN127 ('OPEN ERROR FILE LU11')
C * REDIRECT CONSOLE-OUTPUT for -u & -V (-W) validation modes
          IF (IGBL(3) == 1 .OR. IGBL(3) == 33 .OR.
     1        IGBL(3) == 34) LU6 = LU20
          OPEN (UNIT = LU4, STATUS = 'SCRATCH', FORM = 'UNFORMATTED',
     1         IOSTAT = IOST)
C * CALL EXIT/STOP
          IF (IOST /= 0) CALL GEN127 ('OPEN ERROR FILE LU4')
          OPEN (UNIT = LU8, STATUS = 'SCRATCH', FORM = 'UNFORMATTED',
     1         IOSTAT = IOST)
C * CALL EXIT/STOP
          IF (IOST /= 0) CALL GEN127 ('OPEN ERROR FILE LU8')
          OPEN (UNIT = LU9, STATUS = 'SCRATCH', FORM = 'UNFORMATTED',
     1         IOSTAT = IOST)
C * CALL EXIT/STOP
          IF (IOST /= 0) CALL GEN127 ('OPEN ERROR FILE LU9')
          OPEN (UNIT = LU14, FILE = NAMEFIL(1:KNMFIL)//'.sum',
     1      STATUS = 'UNKNOWN', IOSTAT = IOST)
          OPEN (UNIT = LU17, FILE = NAMEFIL(1:KNMFIL)//'.hkp',
     1      STATUS = 'UNKNOWN', IOSTAT = IOST)
          CALL GEN108 (LU17, 0)
C * CHECK FOR SHELX-BIN
          INQUIRE (FILE = NAMEFIL(1:KNMFIL)//'.bin', EXIST = EXST21)
          OPEN (UNIT = LU19, FILE = NAMEFIL(1:KNMFIL)//'.bin',
     1      STATUS = 'UNKNOWN', FORM = 'UNFORMATTED', IOSTAT = IOST)
          IF (EXST21) THEN
            READ (LU19, IOSTAT = IOST)
            IF (IOST == 0) IGBL(16) = 1
          END IF
          IPR(437) = 0
C * SET NEXT MAIN PLATON LOOP PARAMETER VALUE
          IGBL(1)  = 0
        END IF
C * IGBL(1) = 0 : MANAGE DATA FILE ON UNIT LU1
      ELSE IF (IGBL(1) == 0) THEN
        IDATAFRM = 1
C * TARGET DEPENDENCY
        KNMXT = KNMFIL + KXT + 1
        FNLU1 = NAMEFIL(1:KNMFIL)//'.'//EXTENS(1:KXT)
        INQUIRE (FILE = FNLU1, OPENED = OPEND)
        IF (OPEND) THEN
          INQUIRE (FILE = FNLU1, NUMBER = IUNIT)
            LU1 = IUNIT
        ELSE
          INQUIRE (UNIT = LU1, OPENED = OPEND)
          IF (OPEND) CLOSE (UNIT = LU1)
          OPEN (UNIT = LU1, FILE = FNLU1(1:KNMFIL + KXT + 1),
     1     FORM = 'FORMATTED',  IOSTAT = IOST)
          IF (IOST /= 0) THEN
            WRITE (LU6, 99999, IOSTAT = IOST) FNLU1(1:KNMXT)
C * EXIT IN CASE OF -T OPTION
            IF (IGBL(3) == 30) THEN
              RETURN
C * SPF-DATA
            ELSE
              IGBL(8)  = 1
              IGBL(39) = 0
              LU1      = LU3
              IDATAFRM = 0
            END IF
          END IF
        END IF
        IF (IDATAFRM == 1) THEN
          WRITE (LU6, 99997, IOSTAT = IOST) FNLU1(1:KNMXT)
          IF (EXTENS(1:KXT) == 'lis') THEN
            WRITE (LU6, 99994)
C * SET NEXT MAIN LOOP PARAMETER
            IGBL(1) = 4
            RETURN
          END IF
          IGBL(39) = 1
        END IF
        CALL GEN108 (LU3,  0)
        CALL GEN108 (LU4,  0)
        CALL GEN108 (LU8,  0)
        CALL GEN108 (LU14, 0)
        CALL GEN108 (LU17, 0)
C * SET NEXT MAIN LOOP PARAMETER VALUE
        IGBL(1) = 1
      END IF
      RETURN
99999 FORMAT ('!! File ', A, ' NOT Available, Interactive Input ',
     1        'Assumed', /)
99998 FORMAT (A)
99997 FORMAT (':: Data from: ', A, /)
99996 FORMAT (':: RUN BMFIT TOOL')
99995 FORMAT (':: RUN MP TOOL')
99994 FORMAT (/, ':: Invalid Data Type', /)
      END SUBROUTINE PLA000
 
      MODULE menus
      SAVE
      INTEGER, PARAMETER :: NP31 = 38
      INTEGER, PARAMETER :: NP35 = 110
      INTEGER, PARAMETER :: NP40 = 444
      INTEGER, PARAMETER :: NP46 = 17
      INTEGER, DIMENSION(NP35) :: MNH
C * IOPT =  2 - Reflections Required
C *      = -2 - Check for Unique Calculation done
      INTEGER, DIMENSION(7, NP46) :: IOPT = RESHAPE ( (/
     1  1, -2,  1,  1,  2, -1,  2,
     2  1, -2,  1, -2,  2,  2,  2,
     3 -4, -3,  2, -2,  2,  5,  1,
     4 -4,  1,  2, -2,  2,  2,  1,
     5 -4,  1,  3, -2,  2,  5, -5,
     6  1, -2,  1, -2,  2,  5,  2,
     1  2, -3,  1, -2,  2,  1,  9,
     2  2, -2,  1,  1,  1,  2,  9,
     3  1,  1,  1,  1,  1,  1,  9,
     4  2,  1,  1, -2,  1,  1,  9,
     5 -8,  1,  2,  2,  1, -2, -5,
     6  1,  1,  2,  2,  1, -2, -5,
     3  2, -4,  2,  2,  1,  1, -2,
     4  2, -4,  2,  1,  1,  1,  1,
     5  2,  1,  2,  5,  1,  1,  1,
     6  2,  1,  1,  1,  1,  1,  1,
     7  1,  1,  1,  5,  1,  1,  1/), (/7, NP46/))
      INTEGER, DIMENSION(25, NP31) :: MENA = RESHAPE ( (/
C * # (0/1) SWITCH PARAMETERS POS = IPR(), NEG = IGBL()
C * ORTEP - MAIN (1)
     1   0, 116, 212, 351,   0, 440, 341, 311, 508,   0,
     2 -59, -75, 349,   0, 327, 328,   0,   0,   0,   0,
     3   0,   1,-103,   0,   0,
C * PLUTON MAIN (2)
     1   0, 116, 212,1004,2004,3004,4004,   4, 345,   0,
     2 -59,   0,  46,   0,   0,   0, -75,   0,   0,   0,
     3   0, 346,-103,   0,   0,
C * DPLUTON SUB1 (3)
     1   0, 173, 453, 448,   0, 344, 334, 351, 335, 349,
     21341, 343,   0,   0,   0,   0, -75, 105,   0,   0,
     3   0, 213, 141,-128,   0,
C * PLUTON SUB2 (4)
     1   0, 348, 338,1004,2004,3004,4004,   4, 345, 345,
     2   0, 339,   0,  63, 339, 452, -75,2508,   0,   0,
     3   0, 346,1508, 311,   0,
C * PLUTON SUB3 (5)
     1   0,1150,2150,3150,4150,5150,6150,7150,8150, 330,
     21329,2329,3329,   0,   0,   0, -75,   0,   0,   0,
     3   0, 346,-103,   0,   0,
C * PLUTON SUB4 (6)
     1   0,2341,3341,4341,1341,   0,   0,   0,   0,   0,
     2   0,   0,   0,   0,   0,   0, -75,   0,   0,   0,
     3   0, 346,-103,   0,   0,
C * PLUTON SUB5 (7)
     1   0, -25,   0, -97, -105,  14, -55, 231, -30,   0,
     2 -35,   0,   0,   0,   0,  71, -46, -68, -69,   0,
     3 166,-127,   0, 462,   0,
C * ORTEP SUP1 (8)
     1   0, 173, 453, 448,   0, 344,   0,   0, -52, 330,
     2 536,   0, 211,1211,2211, 350,   0,   0,   0,   0,
     3   0,   0,   0, 341, 476,
C * ORTEP SUB2 (9)
     1 414, -69, 346, 618, -105, 506, -55, 312,   0,   0,
     2 341,   0,   0,   0,   0,   0,   0, -68,   0,   0,
     3   0,-104, 552, 476,   0,
C * PLATON/MAIN (10)
     1   0, -30, 110, -97,  68,  71, -55, 324,  87, -52,
     2 -59,   0,   0,   0,   0,   0, 605,   0,   0, -95,
     3   0,   0, -45, 462,   0,
C * PLATON/SUP1 (11)
     1   0,  29, 592, -56, 501, 502, 497, -61, 181,   0,
     2 154, 445, 363, -33,-121, 597,   0, 603, 645,   0,
     3   0, 346,-103,   0,   0,
C * PLATON/SUP2 (12)
     1   0, 449, -70,-130,-137,   0,   0,   0,  33,-106,
     2-136, 594,-109, -57, -74,   0, -46,   0, 647,   0,
     3 -35, -69, -68, 590,   0,
C * GEOM (13)
     1   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     2   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     3   0, 346,-103,   0,   0,
C * ASYM (14)
     1   0,1394,2394,3394,   0, 406, 387, 388,   0,   0,
     2   0,   0, 369, 776, 468,   0,   0,   0,   0,   0,
     3   0,   0,-103,   0,   0,
C * HELENA (15)
     1   0,   0,   0,   0, 320, 428, 424, 425, 426,   0,
     2 371, 372, 373, 374, 375, 376, 377, 378, 379,   0,
     3   0,   0,   0,   0,   0,
C * ABSCOR (16)
     1 539, 540, 541, 542, 441, 442, 443, 444, 451,   0,
     2 -57, 445, 363, 331, 388, -75,   0,   0,   0,   0,
     3   0,   0,-103,   0,   0,
C * S (17)
     1   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     2   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     3   0,   0,   0,   0,   0,
C * S (18)
     1   0,   0,   0,   0,   0,   0,   0,   0, 321, -40,
     2 -41, -34,   0,   0,   0,   0,   0,   0,   0,   0,
     3   0, -42, -43,   0,   0,
C * S (19)
     1   0, -44,   0,   0,   0,   0,   0, -91, -51, -96,
     2-125,   0,   0,   0, -74,   0,-122, -68,   0,   0,
     3   0,   0,   0,   0,   0,
C * LEPAGE (20)
     1   0,   0,   0,   0,   0,   0,   0,   0,   0,-106,
     2   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     3   0,   0,   0,   0,   0,
C * POWDER (21)
     1   0, 549,   0,   0,   0,   0,   0,   0,   0,   0,
     2   0,   0,   0,   0,   0,   0,   0, 650,   0, 649,
     3 569, 570,-103,   0,   0,
C * CONTOUR (22)
     15414,1414,2414,3414,4414, 416,1416,2416,3416,4416,
     2   0,   0,   0,   0,   0, 458, -75,   0,   0,   0,
     3 182, 182,-103,   0,   0,
C * CONTOUR-SUP (23)
     1   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     2   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     3   0,   0,   0,   0,   0,
C * SOLV (24)
     1   0, 116,   0,   0,   0,   0, -68, 598, 537,   0,
     2 535,   0, 527, 528, 529, 532, -75,   0,   0,   0,
     3   0, 346,-103,   0,   0,
C * TwRtMt (25)
     1   0,   0,   0,   0, 469,   0,1543,2543,3543,4543,
     2   0,   0, 608,   0,   0,   0, 575, 571, 572, 573,
     3 574,   0,   0,   0,   0,
C * ADDSYM (26)
     1   0,   0,   0,   0,   0, 568,   0, 708, 503,-106,
     2   0,   0,   0,   0,   0,   0,   0,   0, 566,   0,
     3   0,   0,   0,   0,   0,
C * EXOR (27)
     1   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     2   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     3   0,   0,   0,   0,   0,
C * RDF (28)
     1 581,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     2   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     3   0,   0,   0,   0,   0,
C * BIJVOET (29)
     1 594, 629,   0,   0,   0,   0, 666,   0,   0,   0,
     2   0,   0, 613,   0, 593,   0, 613, 613, 613,   0,
     3   0, 636, 634,   0,   0,
C * POLYHEDRA (30)
     1   0, 346, 355, 212,   0,   0,   0,   0,   0,   0,
     2 353, 358, 357, 359, 339,   0, 356,   0,   0,   0,
     3   0,   0,   0,   0,   0,
C * FLIPPER (31)
     1   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     2   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     3 640, 614,   0,   0,   0,
C * ANAL-OF-VARIANCE (32)
     1   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     2   0,   0,   0, 711,   0, 633, 634,   0,   0,   0,
     3   0,   0, 778,   0,   0,
C * ANOMALOUS DISPERSION (33)
     1   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     2   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     3   0,   0,-103,   0,   0,
C * FCF-COMPARE (34)
     1   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     2   0,   0,   0,   0,   0, 633, 634,   0,   0, 657,
     3   0,   0,   0,   0,   0,
C * WILSON PLOT + E-STATISTICS (35)
     1   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     2   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     3   0,   0,   0,   0,   0,
C * SQUEEZE (36)
     1   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     2   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     3   0,   0,   0,   0,   0,
C * SPGRfromEX (37)
     1   0,   0,   0,   0,   0,   0,   0,   0,   0,-106,
     2   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     3   0,   0,   0,   0,   0,
C * DIEDERICHS PLOT (38)
     1   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     2   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     3   0,   0,   0,   0,   0/), (/25, NP31/))
C * CODE nnmm : mm = number of devisions, nn = parameter with current value
      INTEGER, DIMENSION(25, NP31) :: MENS = RESHAPE ( (/
C * ORTEP-MAIN (1)
     1      4803, 2, 1, 1, 409, 1, 3503, 3603, 5603, 605, 6602, 1502, 1,
     2      508, 1, 1, 100, 9, 10, 10, 10, 2, 1, 2302, 2,
C * PLUTON-MAIN (2)
     1      1106, 4, 3, 2405, 1, 2, 1, 1, 203, 605, 6602, 508, 1, 100,
     2      2, 707, 1502, 9, 10, 10, 10, 303, 1, 3, 2,
C * PLUTON-SUB1 (3)
     1      1106, 1, 1, 1, 1410, 1, 1, 1, 1, 1, 1, 1, 7308, 100,
     2      9002, 605, 1502, 9, 10, 10, 10, 1, 1, 1, 2,
C * PLUTON-SUB2 (4)
     1      1106, 5102, 1, 2405, 1, 2, 1, 1, 203, 817, 3306, 1003, 904,
     2      1, 1, 1, 1502, 5602, 10, 10, 10, 303, 5603, 3603, 2,
C * PLUTON-SUB3 (5)
     1      1106, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 100, 1,
     2      1, 1502, 1, 10, 10, 10, 303, 1, 3, 2,
C * PLUTON/GEOM (6)
     1      1106, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 100, 1,
     2      1, 1502, 1, 10, 10, 10, 303, 1, 3, 2,
C * PLUTON/AUX (7)
     1      1106, 1, 6007, 1, 1, 1, 1, 1, 1, 1, 1, 4203,
     2      9906, 9102, 7605, 1, 1, 1, 1, 7005, 1, 1, 2, 1, 2,
C * PLATON/ORTEP/SUB1-MENU (8)
     1      4803, 1, 1, 1, 1410, 1, 1, 7104, 1, 1, 7208, 5304, 3802, 1,
     2      3802, 1, 100, 5805 ,5905, 2708, 2808, 2908, 3008, 3409, 2,
C * PLATON/ORTEP/SUB2-MENU (9)
     1      4803, 1, 1, 1, 1, 1, 1, 3703, 3703, 5203, 1, 1,
     2      2, 2, 2, 1, 100, 1, 10, 10, 10, 1, 7503, 3903, 2,
C * PLATON-MAIN (19)
     1      8603, 1, 1, 1, 2604, 1, 1, 1, 1, 1, 6602, 2, 2,
     2      1, 1, 1, 1, 8705, 8805, 2, 1, 2, 1, 1, 2,
C * PLATON/SUP1 (11)
     1      8603, 1, 1, 1, 1, 1, 1, 1, 1, 5203, 1, 1, 1,
     2      1, 1, 1, 7104, 1, 1, 7005, 1, 6504, 6404, 1, 2,
C * PLATON/SUP2 (12)
     1      8603, 2105, 1, 1, 1, 1, 1, 2, 1, 1, 1, 1,
     2      1, 1, 1, 5404, 1, 5, 1, 1202, 1, 1, 1, 1, 2,
C * GEOM PLOT - MENU (13)
     1      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
     2      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2302, 2,
C * ASYM-MENU (14)
     1      1, 1, 1, 1, 1, 1, 1, 1, 1, 2507, 1309, 1,
     2      1, 1, 1, 5704, 1, 4102, 1, 1, 1, 1, 1, 1, 2,
C * HELENA MENU (15)
     1      1, 1, 4706, 1, 1, 1, 2703, 2803, 2902, 1, 1, 1,
     2      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
C * ABSCOR MENU (16)
     1      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
     2      1, 1, 1, 1, 2210, 9, 10, 10, 10, 1, 1, 1, 2,
C * SYSTEM-S MENU (17)
     1      4003, 3, 1, 3, 2, 3, 4, 2, 3, 3, 6, 6,
     2      1, 2, 6, 6, 2, 2, 2, 2, 2, 2, 2, 1, 2,
C * S/SUB-MENU (18)
     1      4003, 3, 2, 1, 1, 2, 1, 10004, 1, 1, 1, 1,
     2      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2,
C * S/SHELXL (19)
     1      4003, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
     2      1, 1, 1, 1, 1, 1, 2, 1, 10204, 1, 1, 2, 2,
C * LEPAGE-MENU (20)
     1   3109, 3204, 4305, 6205, 4407, 7404, 1, 1, 1, 1, 1, 1,
     2      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
C * POWDER MENU (21)
     1   4904,    1, 4605, 5006, 6105, 4505, 10602, 1, 1, 1, 1, 1,
     2      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
C * CONTOUR (22)
     1      1   ,6305,6305,6305,6305,1,1,1,1,1603, 2006, 1705,
     2      6, 6, 6, 1, 1502, 1805, 1908, 1, 5503, 1, 1, 2, 2,
C * CONTOUR-SUP (23)
     1      1,6304, 1, 1, 1, 1, 1, 9706, 9806, 1, 1, 1,
     2      1, 1, 1, 1, 1, 1805, 1, 1, 1, 1, 1, 1, 1,
C * SOLV MENU (24)
     1      1, 6802, 6902, 1, 1, 1, 1, 1, 1, 100, 1, 6700,
     2      1, 1, 1, 1, 1502, 508, 10, 10, 10, 1, 1, 1, 1,
C * TwinRotMat-MENU (25)
     1      8406, 8206, 9405, 8305, 1, 1, 1, 1, 1, 1, 4, 9207,
     2      1, 1, 10103, 2, 1, 1,  1, 1, 1, 8506, 9305, 1, 1,
C * ADDSYM-MENU (26)
     1      7704, 7806, 7906, 8006, 8106, 1, 1, 1, 1, 1, 1, 1,
     2      1, 1, 1, 1, 1, 1, 2, 1, 8900, 1, 1, 1, 1,
C * S/EXOR-MENU (27)
     1      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
     2      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2,
C * RDF (28)
     1      1, 9505, 9606, 1, 1, 1, 1, 1, 1, 1, 1, 1,
     2      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
C * BIJVOET (29)
     1      1, 1, 1, 1, 1, 10410,   1, 10006, 1, 1, 1, 1,
     2      2, 1, 1, 1, 1, 1, 10510, 1, 1, 1, 1, 1, 1,
C * POLYHEDRA (30)
     1      1, 1, 1, 1, 1, 1, 1, 1, 1, 604, 1, 1,
     2      1, 1, 1,10305, 1, 1, 10, 10, 10, 1, 1, 2, 1,
C * FLIPPER (31)
     1      1, 1, 1, 1, 1, 1, 1, 1, 1, 5, 5, 5,
     2      5, 6, 7, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
C * ANAL-OF-VARIANCE (32)
     1      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
     2      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
C * ANOMALOUS DISPERSION (33)
     1      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
     2      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
C * FCF COMPARE (34)
     1      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
     2      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
C * WILSON-PLOT + E-STATISTICS (35)
     1      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
     2      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
C * SQUEEZE (36)
     1      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
     2      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
C * SPGRfromEX (37)
     1      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
     2      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
C * Diederichs Plot (38)
     1      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
     2      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1/), (/25, NP31/))
      INTEGER, DIMENSION(50, NP31) :: MENU = RESHAPE ( (/
C * REFERENCE TO MENUTEXT
C * ORTEP (1)
     1 37, 17,  2,  8, 38,217,219,220,271, 22, 26, 11, 10, 12,141,
     2142, 14, 18, 19, 20, 21,251, 23,148, 53, 37, 34,502,508, 38,
     3717,719,720,771, 22,526,511,510, 32,641,642, 14, 18, 19, 20,
     4 21,251,523,148, 53,
C * PLUTON-MAIN (2)
     1 37, 17,376,  4,  5,  6,  7,528,  3, 22, 26, 12, 13, 14, 15,
     2 16, 11, 18, 19, 20, 21, 99, 23, 24, 59, 37, 34,876,504,505,
     3506,507, 28,503, 22,526, 12,513, 14, 15, 16,511, 18, 19, 20,
     4 21,599,523, 24, 59,
C * PLUTON SUB1 (3)
     1537, 48, 50, 52, 54, 69,100,  8,  9, 10, 58, 66, 68, 14, 35,
     2 22, 11, 18, 19, 20, 21,234, 93,201, 59, 37,548,550,552, 54,
     3569,600,508,509,510,558,566, 68, 14,535, 22,511, 18, 19, 20,
     4 21,734,593,701, 59,
C * PLUTON SUB2 (4)
     1537, 60, 98,  4,  5,  6,  7,528,  3,607,216, 97, 95, 90, 92,
     2 94, 11,352, 19, 20, 21, 99,271,220, 59, 37,560,598,504,505,
     3506,507, 28,503,107,216, 97, 95,590,592,594,511,852, 19, 20,
     4 21,599,771,720, 59,
C * PLUTON SUB3 (5)
     1537, 71, 72, 73, 74, 75, 83, 84, 85, 86, 87, 88, 89, 14,  1,
     2  1, 11,  1, 19, 20, 21, 99, 23, 24, 59, 37,571,572,573,574,
     3575,583,584,585,586,587,588,589, 14,  1,  1,511,  1, 19, 20,
     4 21,599,523, 24, 59,
C * PLUTON SUB4 (6)
     1537, 55, 56, 57, 58, 80, 81, 82,215, 76, 77, 78, 79, 14,  1,
     2  1, 11, 49, 19, 20, 21, 99, 23, 24, 59, 37,555,556,557,558,
     3 80, 81, 82,215, 76, 77, 78, 79, 14,  1,  1,511, 49, 19, 20,
     4 21,599,523, 24, 59,
C * PLUTON SUB5 (7)
     1537,269,276, 30,324,218,241,284, 27,321, 91,242,326,325,305,
     2 32,153,280,243,289, 96,686,251, 49, 59, 37,769,276,530,824,
     3718,741,784,527,  1,591,242,326,325,305,532,653,780,743,289,
     4596,186,251,549, 59,
C * ORTEP MAIN (8)
     1537, 48, 50, 52, 54, 69,100,291,101, 86,293, 39,540, 41, 42,
     2 32, 14,273,274,189,190,191,192,216, 53,537,548,550,552, 54,
     3569,600,291,601,586,793, 39, 40,541,542,532, 14,273,274,189,
     4190,191,192,216, 53,
C * ORTEP/SUB1 (9)
     1537,243, 64,380,324,270,241,232,187,265,351,275,250,252,256,
     2 82, 14,280, 19, 20, 21,290,304,233, 53,537,743,564,880,824,
     3770,741,732,187,265,851,275,250,252,256, 82, 14,780, 19, 20,
     4 21,790,804,733, 53,
C * PLATON/MAIN (10)
     1 37, 27,231, 30, 31, 32,241,124,140,101, 26,279,250, 78, 79,
     2154,371,318,319,320,321,251,145, 49, 59, 37,527,731,530,531,
     3532,741,624,640,601,526,279,750, 78, 79,154,871,318,319,820,
     4321,251,645,549, 59,
C * PLATON/SUP1 (11)
     1537,237,855,247,261,262,264,266,138,265,350,149,156, 29,358,
     2364,291,370,408,289,  1,283,281,  1, 59,537,737,355,747,761,
     3762,764,766,638,265,850,649,656,529,858,864,291,870,908,289,
     4  1,283,281,  1, 59,
C * PLATON/SUP2 (12)
     1537,144,143,372,399,  1,  1,256,427,333,390,362,345,249,267,
     2268,153,428,409,627, 91,243,280,147, 59,537,644,643,872,899,
     3  1,  1,256,927,833,890,862,845,749,767,768,653,428,909,127,
     4591,743,780,647, 59,
C * GEOM (13)
     1  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     2  1,354,282,102, 67, 70, 64, 23,148, 53,  1,  1,  1,  1,  1,
     3  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,282,102, 67,
     4 70,564,523,148, 53,
C * ASYM (14)
     1  1,109,110,111,  1,128,108,112,  1,122,123,  1,125,443,134,
     2272,  1,103,  1,  1,  1,  1, 23,  1,104,  1,609,610,611,  1,
     3628,608,612,  1,122,123,  1,625,943,634,272,  1,103,  1,  1,
     4  1,  1,523,  1,104,
C * HELENA (15)
     1  1,  1,255,  1,185,155,657,658,659,  1,221,222,223,224,225,
     2226,227,228,229,  1,  1,  1,  1,  1,126,  1,  1,255,  1,685,
     3655,657,658,659,  1,721,722,723,724,725,726,727,728,729,  1,
     4  1,  1,  1,  1,126,
C * ABSCOR (16)
     1150,151,132,152,130,131,133,135,136,137,249,149,156, 36,112,
     2129,146, 18, 19, 20, 21,126, 23,248,104,650,651,632,652,630,
     3631,633,635,636,137,749,649,656,536,612,629,146, 18, 19, 20,
     4 21,126,523,248,104,
C * S (17)
     1 37,162,173,160,165,166,167,168,169,170,171,172,330,174,175,
     2176,177,178,179,180,181,163,182,261,184, 37,162,  1,160,165,
     3166,167,168,169,170,171,172,330,174,175,176,177,178,179,180,
     4181,163,182,261,184,
C * S/SUB (18)
     1537,162,161,257,205,164,214,208, 30,198,199,200,258,259,206,
     2 62, 63, 65,203,202,197,196,195,194,184,537,162,161,257,205,
     3164,214,208,530,698,699,700,258,259,206, 62, 63, 65,203,202,
     4197,696,695,194,184,
C * S/SHELXL (19)
     1537,193,213,  1,  1,212,  1,302,204,295,853,  1,  1,  1,267,
     2  1,366,280,240,  1,357,238,239,183,184,537,693,213,  1,  1,
     3212,  1,802,704,795,353,  1,  1,  1,767,  1,866,780,240,  1,
     4357,238,239,183,184,
C * LEPAGE (20)
     1210,211,244,278,245,296,  1,  1,  1,333,  1,  1,  1,  1,  1,
     2  1,  1,  1,  1,  1,  1,  1,  1,126, 25,210,211,244,278,245,
     3296,  1,  1,  1,833,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     4  1,  1,  1,126, 25,
C * POWDER (21)
     1209,303,254,260,277,253,441,  1,  1,  1,  1,  1,  1,  1,  1,
     2  1,  1,413,367,412,334,335, 23, 44, 25,209,803,254,260,277,
     3253,441,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,913,367,912,
     4834,835,523, 44, 25,
C * COUNTOUR (22)
     1 37, 63,207, 62, 65,613,114,115,116,121,139,117,118,119,120,
     2 61, 11,106,105,235,123,236, 23,103,104, 37,563,707,562,565,
     3113,614,615,616,621,139,117,118,119,120,561,511,106,105,235,
     4246,736,523,103,104,
C * CONTOUR-SUP (23)
     1 37,206,  1,  1,  1,  1,  1,347,348,346,  1,  1,  1,  1,  1,
     2  1,  1,106,  1,  1,  1,  1,  1,  1,  1, 37,706,  1,  1,  1,
     3  1,  1,347,348,346,  1,  1,  1,  1,  1,  1,  1,106,  1,  1,
     4  1,  1,  1,  1,  1,
C * SOLV (24)
     1  1, 17,288, 73, 74, 75,280,365,294, 14,292,287, 13,286,285,
     2 92, 11, 12, 19, 20, 21, 64, 23, 44, 25,  1,517,288, 73, 74,
     3 75,780,865,794, 14,792,287,513,786,785,592,511, 12, 19, 20,
     4 21,564,523, 44, 25,
C * TwinRotMat (25)
     1316,314,332,315,328,343,297,298,299,300,327, 95,374,  1,356,
     2103,344,336,337,338,339,317,331,301, 25,316,314,332,315,828,
     3343,797,798,799,800,327, 95,375,610,611,103,844,836,837,838,
     4839,317,331,301, 25,
C * ADDSYM (26)
     1309,310,311,312,313,230,  1,431,263,333,  1,  1,  1,  1,  1,
     2  1,  1,322,426,329,323,308,306,307, 25,309,310,311,312,313,
     3730,  1,931,763,833,  1,  1,  1,  1,  1,  1,  1,822,426,329,
     4323,308,306,307, 25,
C * S/EXOR (27)
     1  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     2  1,  1,  1,  1,  1,  1,  1,  1,  1,184,  1,  1,  1,  1,  1,
     3  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     4  1,  1,  1,  1,184,
C * RDF (28)
     1340,341,342,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     2  1,  1,  1,  1,  1,  1,  1, 23, 44, 25,840,341,342,  1,  1,
     3  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     4  1,  1,523, 44, 25,
C * BIJVOET (29)
     1374,383,  1,  1,  1,377,418,349,420,421,422,423,382,  1,359,
     2  1,411,879,378,  1,  1,389,388, 44, 25,375,883,  1,  1,  1,
     3377,419,349,420,421,422,423,410,  1,859,  1,911,379,878,  1,
     4  1,889,888, 44, 25,
C * POLYHEDRA (30)
     1  1, 64,276,  2,  1,  1,  1,  1,  1, 22,360,361, 13,363, 92,
     2 16, 93,  1, 19, 20, 21,  1, 23,148, 25,  1,564,776,502,  1,
     3  1,  1,  1,  1, 22,860,861,513,863,592, 16,593,  1, 19, 20,
     4 21,  1,523,148, 25,
C * FLIPPER (31)
     1  1,  1,  1,  1,  1,  1,  1,  1,  1,392,393,394,395,396,397,
     2  1,  1,  1,  1,  1,398,391,381,373, 25,  1,  1,  1,  1,  1,
     3  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     4898,891,381,373, 25,
C * ANAL-OF-VARIANCE (32)
     1384,415,416,424,425,433,440,417,  1,  1,  1,  1,  1,432,385,
     2386,388,  1,  1,  1,  1,  1,444, 44, 25,384,415,416,424,433,
     3440,417,  1,  1,  1,  1,  1,  1,932,385,387,888,  1,  1,  1,
     4  1,  1,944, 44, 25,
C * ANOMALOUS DISPERSION (33)
     1400,401,402,403,404,405,406,  1,  1,434,435,436,437,438,  1,
     2  1,  1,  1,  1,  1,  1,  1, 23, 44, 25,400,401,402,403,404,
     3405,406,  1,  1,434,435,436,437,438,  1,  1,  3,  1,  1,  1,
     4  1,  1,523, 44, 25,
C * FCF-COMPARE (34)
     1384,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,385,
     2386,  1,  1,  1,414,  1,  1,  1, 44, 25,  1,  1,  1,  1,  1,
     3  1,  1,  1,  1,  1,  1,  1,  1,  1,385,387,  1,  1,  1,914,
     4  1,  1,  1, 44, 25,
C * WILSON-PLOT + E-STATISTICS (35)
     1430,429,439,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     2  1,  1,  1,  1,  1,  1,  1,  1, 44, 25,430,429,  1,  1,  1,
     3  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     4  1,  1,  1, 44, 25,
C * SQUEEZE (36)
     1  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     2  1,  1,  1,  1,  1,  1,  1,  1, 44, 25,  1,  1,  1,  1,  1,
     3  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     4  1,  1,  1, 44, 25,
C * SPGRfromEX (37)
     1  1,  1,  1,  1,  1,  1,  1,  1,  1,333,  1,  1,  1,  1,  1,
     2  1,  1,  1,  1,  1,  1,  1,  1, 44, 25,  1,  1,  1,  1,  1,
     3  1,  1,  1,  1,833,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     4  1,  1,  1, 44, 25,
C * Diederichs Plot (38)
     1  1,415,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     2  1,  1,  1,  1,  1,  1,  1,  1, 44, 25,  1,415,  1,  1,  1,
     3  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     4  1,  1,  1, 44, 25/), (/50, NP31/))
      CHARACTER(len=11), DIMENSION(NP31) :: MENX = (/
     1 'ORTEP     1', 'PLUTON    2', 'Contents  3', 'Style     4',
     2 'View      5', 'GeomTy    6', 'Aux       7', 'ORT_SP1   8',
     3 'ORT_SP2   9', 'PLATON   10', 'PLA-SP1  11', 'PLA-SP2  12',
     4 'GEOM     13', 'ASYM     14', 'HELENA   15', 'ABSCOR   16',
     5 'SYSTEM-S 17', 'S-SUB    18', 'S-SHXL   19', 'LEPAGE   20',
     6 'POWDER   21', 'Contour  22', 'CON-Sup  23', 'SolvPlot 24',
     7 'TwinRotM 25', 'ADDSYM   26', 'S/EXOR   27', 'RDF      28',
     8 'BIJVOET  29', 'POLYHN   30', 'Flipper  31', 'ANALoVAR 32',
     9 'AnomDisp 33', 'FCF-Comp 34', 'WilsonPl 35', 'SQUEEZE  36',
     * 'SPGRfrEX 37', 'DiedPlot 38'/)
      CHARACTER(len=11), DIMENSION(NP40) :: CMEN = (/
     1 '           ', 'Incl-HAtoms', 'BWC Res ARU', 'Solid-Style',
     2 'Rod  -Style', 'CPK  +Stick', 'Straw-Style', 'DeleteAtoms',
     3 'RenameAtoms', 'MoveLabel  ', 'Label -Hat+', 'LabelSize >',
     4 'UnitCellBox', 'Resd012..  ', 'H-Bonds-X  ', 'PackRange  ',
     5 'Stereo Opts', 'CRotY >>   ', '<<-RotZ+>> ', '<<-RotY+>> ',
     6 '<<-RotX+>> ', 'ViewOptions', 'Decoration ', 'Met Pov Ras',
     7 '        End', 'NoDisorder ', 'NoMove     ', 'Stick-Style',
     8 'AtomSort   ', 'Organic    ', 'Round      ', 'Parentheses',
     9 'ListRadii  ', 'Mono       ', 'HFIX   ANIS', 'Cell Dimens',
     * 'OptionMenus', 'Probability', 'Raster3D   ', 'Hetero El.s',
     1 'Envelope El', 'Octant El.s', 'ViewMin    ', 'EPS-File   ',
     2 'StyleA     ', 'BwcStyle   ', 'ToMainMenu ', 'DisplayText',
     3 'ENTRY-LIST ', 'NewText    ', 'NewText    ', 'MoveText   ',
     4 'PLUTON  End', 'TextSize   ', 'Distance   ', 'Angle      ',
     5 'Torsion    ', 'GeomCalc   ', 'Reset   End', 'SelPattern ',
     6 'Bonds      ', 'Fo-Fc-Map  ', 'Fo-Map     ', 'Color      ',
     7 'SQUEEZE-Map', 'ZoomCenter ', 'NextRing   ', 'Zoom       ',
     8 'DeleteText ', 'NextPlane  ', 'ViewUnit   ', 'ViewMin    ',
     1 'ViewXO     ', 'ViewYO     ', 'ViewZO     ', 'ListCell   ',
     2 'ListSymm   ', 'ListAtoms  ', 'ListBonds  ', 'ListTypes  ',
     3 'ListLines  ', 'ListARU    ', 'ViewAFace  ', 'ViewBFace  ',
     4 'ViewCFace  ', 'ViewInvert ', 'ViewLine   ', 'ViewPerp   ',
     5 'ViewBisect ', 'LabelARU   ', 'Auto-Plot  ', 'LabelCell  ',
     6 'OmitOutside', 'LabelAtom  ', 'Resolution>', 'InclZombie ',
     7 '<OverlapMrg', 'SelectColor', 'Col Res ARU', 'ChTextSize ',
     8 'NoSymm     ', 'Newman-Next', 'Up     Down', 'EPS    End ',
     9 'Ch-Cntr-Lev', 'Ch-Step-Siz', 'GlobalPattn', 'Resolution ',
     * 'Zone-H     ', 'Zone-K     ', 'Zone-L     ', 'Axes       ',
     1 'Plane-Horiz', 'Plane-abcd ', 'PlaneBisect', 'Plane-Perp ',
     2 'VertAngSize', 'Horiz Shift', 'Vert  Shift', 'Z-Rotation ',
     3 'PlaneXYXZYZ', 'OMIT  STH/L', 'OMIT SIG(I)', 'R/S-Determ ',
     4 'MissingRefl', 'Next-Step  ', 'EPS    HPGL', 'Summary    ',
     5 'LabelVert.s', 'Mu     (mm)', 'Radius (mm)', 'T(min) (mm)',
     6 'MuR        ', 'N-Measured ', 'Gauss  Grid', 'FaceAdd(mm)',
     7 'FaceDelete ', 'SHELXL-ATWT', 'PlaneDisTol', 'Norm-H-bond',
     8 'DeleteLabel', 'IncludLabel', 'EPS-Listing', 'Print-Level',
     1 'SAVE-InstrS', 'ZoomXtlPlot', 'Browser    ', 'b&w-EPS-col',
     2 'WriteDirCos', 'L0(max)    ', 'L1(max)    ', 'T(max) mm  ',
     3 'Portrait   ', 'List Uij   ', 'No-SCALE   ', 'CheckDirCos',
     4 'BetaPerpPar', 'LSR-MSM-MSA', 'DirCos-ABSP', 'ABST/P/NONE',
     5 'TREE   LIST', 'LOG  RELINK', 'ADDSYM SOLV', 'CELL HELENA',
     6 'TRMX   SPGR', 'FORM Z SX86', 'SHX/S/P/D/T', 'DIRDIF ORNT',
     7 'SIR97/04/11', 'EXOR  /S /D', 'SHELXL-ISO ', 'SHELXL-ANIS',
     8 'MULABS     ', 'HDIF   HFIX', 'SHELXL-HATS', 'SHELXL-WGHT',
     9 'PLUTON RENM', 'PLATON  ADP', 'INVRT HFREE', 'ASYM   VIEW',
     * 'SQUEEZE FCF', 'VALI REPORT', 'LstRES SXPS', 'SKIP ACCEPT',
     1 'LIST-REFL  ', 'AutoMolExpd', 'Fit Res 1&2', '           ',
     2 'RadBndAll  ', 'RadBndNorm ', 'RadBndToMet', 'RadBndToHat',
     3 'Edit-s.ins ', 'PruneS-Tree', 'Browse-lis ', 'Browse-lps ',
     4 'Laser-lps  ', 'Void-Check ', 'AddsymCheck', 'Valid-Check',
     5 'Asym-Residu', 'Browse-ps  ', 'Laser-ps   ', 'OmitOutlier',
     6 'XtalDisplay', 'F0**2-Map  ', '2Fo-Fc-Map ', '54 60 65 MX',
     7 'Ag Mo Cu X ', 'MaxDotProd ', 'ExpErrorDeg', 'Twin-Matrix',
     8 'Edit-s.res ', 'Flipper    ', 'ListFlags  ', 'BondTaper> ',
     1 'CalcCoordn ', 'LablFullNum', 'DisAnglTors', 'JoinDashDet',
     2 'Include RR1', 'Include RR2', 'Include RR3', 'Include RR4',
     3 'Include RR5', 'Include RR6', 'Include RR7', 'Include RR8',
     4 'Include RR9', 'NFTPercImpl', 'Join-Expand', 'FITbyCLICK ',
     5 'LsplDistEnd', 'ExcludeARU ', 'Def-Cntr-Lv', 'OmitFromSFC',
     6 'MaxRingSize', 'SHELXL-CGLS', 'SHELXL-LS  ', 'Anis    All',
     7 'Label-Alias', 'OvrlpSHADOW', 'X-LineWidth', 'Two-Ax-Crit',
     8 'Sub/SupCell', 'XR  YR  ZR ', 'D-H..H-A   ', 'CalcAbsCorr',
     9 'ReflListing', 'LstCellSymm', 'Prev   Next', 'LstAtomsUeq',
     * 'LineWidth  ', '<VertScale>', 'ScaleDegree', 'LstFlagRadi',
     1 'RemoveTree ', 'CSD-Search ', 'R-PLUTO    ', '<HorsScale>',
     2 'AutoRenum  ', 'InclDisCont', 'NoSubCell  ', 'TMA-Hincl  ',
     3 '(UAE)WLSPL ', 'AltLablPack', 'DebugOutput', 'SetWindSize',
     4 'MenuOff    ', 'LabelCg    ', 'DefineToEnd', 'ObsCalcDelt',
     5 'NrLinesNorm', 'NrLinesToMe', 'LstRadBonds', 'Perspective',
     6 'StepSize   ', 'Max2Axis   ', 'LstARU RCel', 'Reverse-B&W',
     7 'Tola       ', 'ADP-PLOT   ', 'Tolm       ', 'Uiso       ',
     8 'Ohashi-Vol ', 'Show-Mol   ', 'Void0123...', 'DotsContour',
     1 'MinDistCrit', 'LtReference', 'CoordRadDef', 'UnitFill   ',
     2 'ColorType  ', 'UnitSymPack', 'AutoEXTIref', 'RoundCell  ',
     3 'DspTwinMat1', 'DspTwinMat2', 'DspTwinMat3', 'DspTwinMat4',
     4 'HKLF5-Gener', 'Merg 4     ', 'InputLambda', 'LsplWithEnd',
     5 'PovrayStyle', 'ADDSYM-PLOT', 'ADDSYM-SHX ', 'ADDSYMExact',
     6 'NonFitPerc ', 'TolMetric  ', 'TolRotAxis ', 'TolInvers  ',
     7 'TolTransl  ', 'DeltaI/SigI', 'DeltaTheta ', 'NRefSelMin ',
     8 'HKLF5-CritI', 'MinQPeakHgt', 'MinQPeakDis', 'Q-Peak-Incl',
     9 'KeyInstruct', 'ListDetails', 'ADDSYMElmnt', 'DisplAllLab',
     * 'HorVerRatio', 'PovrayResol', 'EPS-TwinLat', 'FullListing',
     1 'ADDSYMEqual', 'TwinRotMat ', 'HKLF5-CritT', 'MaxIndexUVW',
     1 'KeepMon-I-n', 'Displ-d-val', 'Display-2Th', 'SelectTMat1',
     1 'SelectTMat2', 'SelectTMat3', 'SelectTMat4', 'Normalize  ',
     4 'RDF-radius ', 'RDFwidthPar', 'EPS-TwinLaw', 'RacemicTwin',
     5 'PNG        ', 'Fourier3D  ', 'Nr-Sections', 'Nr+Sections',
     6 'SigmaCriter', 'ExclDisOper', 'Angle2Lines', 'DefineCgEnd',
     7 'UisoMax    ', 'CremerPople', 'MaxNumRings', 'Zone-H,K,L ',
     8 'NpeakFmap  ', 'BondValence', 'ApplySlope ', 'Polyhedra  ',
     1 'PolyShade  ', 'FCF-Calc   ', 'InclAtoms  ', 'ResdSort   ',
     2 'VoidAxes   ', 'SirWindow  ', 'List-Pow   ', 'PLATON     ',
     3 'EXOR       ', 'UisoHRadius', 'Exclude H  ', 'PDF-Listing',
     4 'Converged  ', 'IcalFromCIF', 'IcalFromFCF', 'Inc H CH DH',
     5 'OutlierCrit', 'Manual Nu  ', 'Gaussian   ', 'LabelHetAts',
     6 'Continue   ', 'NPP-Bijvoet', 'InclWghtPar', 'NorProbPlot',
     7 'ScatterPlot', 'LogLog-Plot', 'Linear-Plot', 's.u.-Bar   ',
     8 'HKL-Display', 'NoExpand   ', 'Show       ', 'Ntry       ',
     9 'Nloop      ', 'Nsolve     ', 'Delta      ', 'Perc       ',
     * 'Uiso       ', 'Structure  ', 'PageHeader ', 'AnomDispPlt',
     1 'MuPlot     ', 'Anom-CuKa  ', 'Anom-GaKa  ', 'Anom-MoKa  ',
     2 'Anom-AgKa  ', 'Anom-InKa  ', '           ', 'Incl C-H..X',
     3 'GenerRandom', 'TPP-Bijvoet', 'Student-T  ', 'Displ-q-Val',
     4 'CPI-File   ', 'ReducedCell', 'I/s-log(I) ', 'I/sw-log(I)',
     5 'VarAnalysis', 'ParsonsDiff', 'BijvoetDiff', 'BtDiff-Th  ',
     6 'BtDiff-Fc2 ', 'BtDifSig-Th', 'BtDifSigFc2', 's(I)-log(I)',
     7 'log(s)-logI', 'ADDSYMPart#', 'NoMolFitInv', 'GenerSthlMx',
     8 'N(Z)-Stat  ', 'Wilson-Plot', 'NoInversion', 'I-or-F-Plot',
     9 's(I)-sqt(I)', 'Mu-CuKa    ', 'Mu-GaKa    ', 'Mu-MoKa    ',
     * 'Mu-AgKa    ', 'Mu-InKa    ', 'N(Z)-PLOT  ', '<I/s(I)>-Th',
     1 'Iobs   Ical', 'Volcal     ', 'ShowExtinct', 'K-Analyze  '/)
      CHARACTER(len=10), DIMENSION(7, NP46)  :: OPTS = RESHAPE ((/
     1 'PlutonAuto', 'Calc All  ', 'Calc Solv ', 'Addsym    ',
     2 'MULscanABS', 'Validation', 'System-S  ',
     3 'Ortep-Plot', 'Calc Intra', 'Calc K.P.I', 'Addsym-EQL',
     4 'ABSPsiScan', 'Asym-View ', 'fcf2hkl   ',
     5 'NewmanPlot', 'Calc Inter', 'Squeeze   ', 'Addsym-EXT',
     6 'ABSTompa  ', 'FCF-Valid ', 'Expand2P1 ',
     7 'Ring-Plots', 'Calc Coord', 'Hybrid    ', 'Addsym-PLT',
     8 'ABSGauss  ', 'DifFourier', 'FCF-Gener ',
     9 'Plane-Plot', 'Calc Metal', 'CalcFCFsqd', 'Addsym-SHX',
     * 'ABSXtal   ', 'ANALofVAR ', 'HKLF-Gener',
     1 'PolyPlot  ', 'Calc Geom ', 'ContourSol', 'Newsym    ',
     2 'ABSSphere ', 'ByvoetPair', 'HKL-Transf',
     3 'ContourDif', 'Calc Hbond', 'Solv F3D  ', 'Nonsym    ',
     4 'ShxAbs    ', 'AsymExpect', 'Exor-Res  ',
     5 'Contour-Fo', 'Calc TMA  ', 'Solv Plot ', 'LePage    ',
     6 'AnomDisVal', 'Asym-Valid', 'Anis-Res  ',
     7 'AutoMolFit', 'L.S.-Plane', 'CavityPlot', 'DelRed    ',
     8 'AnomDisPlt', 'SupplMater', 'Rename-Res',
     9 'hkl2Powder', 'DihedAngle', 'Calc SASA ', 'Molsym    ',
     * 'MuPlot    ', 'Expect-hkl', 'Auto-Renum',
     1 'SimPowderP', 'AngleLines', 'Flip Menu ', 'SPGRfromEX',
     2 '          ', 'CSD-Cell  ', 'Create-spf',
     3 'RadDistFun', 'AngLsplLin', 'Flip Show ', 'Asym      ',
     4 '          ', 'CSD-Quest ', 'Create-res',
     5 'Patterson ', 'CremerPopl', 'Flip Patt ', 'ASYMaverFR',
     6 '          ', 'StructTidy', 'Create-cif',
     7 'ShelxtPlot', 'BondValenc', 'Flipper 25', 'LePageTwin',
     8 'XtlPlanAgl', 'StrainAnal', 'Create-pdb',
     9 'Diederichs', 'Volcal    ', 'Structure?', '          ',
     * 'Xtal Habit', '          ', 'HFIX-Res  ',
     1 'WilsonPlot', 'R/S-CIP   ', '          ', '          ',
     2 '          ', '          ', 'cif2fcf   ',
     3 'PlutoNativ', 'MolVolume ', '          ', 'TwinRotMat',
     4 '          ', '          ', 'cif2shelxl'/), (/7, NP46/))
      CHARACTER(len=11), DIMENSION(25) :: MENUSUB
      END MODULE menus
 
      MODULE dfspgr
      SAVE
      INTEGER, PARAMETER :: NCS = 52
      INTEGER :: LU
      INTEGER :: NREF
      INTEGER :: IPERC
      INTEGER :: IFRQC
      INTEGER :: IFRQA
      INTEGER :: IFRQH
      INTEGER :: ISPGRC
      INTEGER :: ISPGRA
      INTEGER :: ISPGRH
      INTEGER :: IPCNTC
      INTEGER :: IPCNTA
      INTEGER :: IPCNTH
      INTEGER, DIMENSION(3)      :: IR
      INTEGER, DIMENSION(24)     :: INZ
      INTEGER, DIMENSION(12)     :: ITL
      INTEGER, DIMENSION(10)     :: NNZ
      INTEGER, DIMENSION(NCS, 5) :: NUM
      REAL :: RAVERC
      REAL :: RAVERA
      REAL :: RAVERH
      REAL, DIMENSION(48)     :: XN
      REAL, DIMENSION(12)     :: XTL
      REAL, DIMENSION(12)     :: XNM
      REAL, DIMENSION(10)     :: ANZ
      REAL, DIMENSION(12)     :: FMN
      REAL, DIMENSION(11)     :: CRI = (/1.0, 2.5,
     1  1.5, 5.0, 2.5, 10.0, 10.0, 20.0, 50.0, 100.0, 5.0/)
      REAL, DIMENSION(15, 10) :: PNZ
      REAL, DIMENSION(NCS, 5) :: SUMZ
      REAL, DIMENSION(20)     :: STLS
      REAL, DIMENSION(NCS)    :: XMFS
      REAL, DIMENSION(3)      :: AVNZ
      REAL, DIMENSION(3, 3)   :: TRMXS
      CHARACTER(len=5) :: LAUE
      CHARACTER(len=1) :: ILAT0
      CHARACTER(len=1) :: ILAT1
      CHARACTER(len=1),  DIMENSION(NCS) :: EXT
      CHARACTER(len=16), DIMENSION(NCS) :: EXTYPE = (/
     1 'HKL:H+K=2N     C', 'HKL:H+L=2N     B', 'HKL:K+L=2N     A',
     2 'HKL:H+K+L=2N   I', 'HKL:-H+K+L=3N oR', 'HKL:H-K+L=3N  rR',
     3 '0KL:K=2N      bx', '0KL:L=2N      cx', '0KL:K+L=2N    nx',
     4 'H0L:H=2N      ay', 'H0L:L=2N      cy', 'H0L:H+L=2N    ny',
     5 'HK0:H=2N      az', 'HK0:K=2N      bz', 'HK0:H+K=2N    nz',
     6 'H00:H=2N     21x', '0K0:K=2N     21y', '00L:L=2N     21z',
     7 '0KL:K+L=4N    dx', 'H0L:H+L=4N    dy', 'HK0:H+K=4N    dz',
     8 'H00:H=4N     41x', '0K0:K=4N     41y', '00L:L=4N     41z',
     9 'HHL:L=2N     cxy', 'HHL:H=2N        ', 'HHL:H+L=2N      ',
     * 'HHL:2H+L=4N     ', 'H-HL:H+L=3N     ', 'H-HL:-H+L=3N    ',
     1 '00L:L=6N     61z', 'HH0:H=2N        ', 'H-HL:L=2N       ',
     2 'HHL:L=3N        ', 'H-2HL:L=2N      ', '-2HHL:L=2N      ',
     3 'H-2HL:L=3N      ', '-2HHL:L=3N      ', '00L:L=3N     31z',
     4 'H-HL:H=2N       ', 'HKL:H=2N      2X', 'HKL:K=2N      2Y',
     5 'HKL:L=2N      2Z', 'HKL:H=3N      3X', 'HKL:K=3N      3Y',
     6 'HKL:L=3N      3Z', '-HKL, H-KL=3NtwR', '-HKL:K2,KL4P2tw2',
     7 '-HKL:H2,HL4P2tw2', '-HKL:H2,HK4P2tw2', 'HKL:H+2L=3N     ',
     8 'HKL:H+K+L=3N    '/)
      LOGICAL, DIMENSION(NCS) :: EX
      END MODULE dfspgr
 
      MODULE symsav
      SAVE
      INTEGER :: NSCF
      INTEGER, DIMENSION(192)    :: NSID
      INTEGER, DIMENSION(4, 192) :: NSCIF
      END MODULE symsav
 
      MODULE strain1
      SAVE
      INTEGER, DIMENSION(2) :: ICV
      REAL, DIMENSION(2, 6) :: VCAB
      REAL, DIMENSION(2, 6) :: CELAB
      REAL, DIMENSION(2)    :: TEMPAB
      END MODULE strain1
 
      SUBROUTINE PLA001
C * DATA INITIALIZATION
      USE files
      USE parameters
      USE plato
      USE atomdata
      USE cchar
      USE menus
      USE cggt
      USE dfspgr
      USE strain1
      USE symsav
      USE sgxyz
      IMPLICIT NONE
      INTEGER :: I
      INTEGER :: J
      PNZ(14, 1:10) = (/  9.52, 18.13, 25.92, 32.97, 39.25, 45.12,
     1  50.34, 55.07, 59.34, 63.21/)
      PNZ(15, 1:10) = (/ 24.81, 34.53, 41.87, 47.38, 52.05, 56.14,
     1  59.72, 62.89, 65.72, 68.33/)
      DO  I = 1, 20
        STLS(I) = ((I * 0.1) ** 0.3333333) / 1.5418
      END DO
      CALL GEN097 (MNH, 1, NP35, 0)
      IAN      = 0
      NSCF     = 0
      MNH(6)   = 2
      MNH(7)   = 2
      IGBL(6)  = 1
C * # ALIASES
      IPR(759) = 0
      IPR(760) = 0
      DO I = 1, NP36
        ALAB(I) = ' '
        BLAB(I) = ' '
        CLAB(I) = ' '
      END DO
      ILAT0    = ' '
      ILAT1    = 'P'
      LAUE     = ' '
      KRAD     = '??'
      INDP     = 0
      PAGET    = 'GENERAL'
C * SET DEFAULT FVAR SCALE
      RP(1)    = 1.0
      CALL GEN097 (MLTI, 1, 63, 1)
      CALL GEN097 (IXSD, 1, 6,  0)
      IGBL(8) = IABS(IGBL(8))
      IF (IGBL(53) == 0) THEN
        DO I = 1, NP65 + 1
          CALL GEN038 (BNDTP(I), 1, 5)
        END DO
      END IF
      CALL GEN038 (JID,  1, 80)
      CALL GEN038 (IGGT, 1, 80)
      DO I = 1, 25
        CALL GEN038 (LREF(I), 1, 80)
      END DO
      DO I = 1, 5
        RLWS(I) = ' ?'
      END DO
      DO I = 1, 4
        CALL GEN038 (SPGRNM(I), 1, 26)
      END DO
      CALL GEN038 (ZSPG     , 1, 7)
C * INIT IBT - BIT ARRAY
      CALL GEN048 (0, I, 0, I)
      CALL GEN097 (IPPR, 1, MP7 * 3, 0)
      CALL GEN097 (IFG,  1, NP1 * 3, 0)
      IPPR(1, 1) = 10000
      IPPR(1, 2) = 0
      IPPR(1, 3) = 1
      DO I = 1, NP10
        IENLB(I) = 0
        DO J = 1, 4
          RADR(I, J) = -1
        END DO
        IACL(I)  = 1
        DO J = 1, 2
          LMT(I, J) = '  '
          IENS(I)   = I
        END DO
      END DO
      DO I = 1, NP10
        DO J = 1, 3
          DISPVAL(I, J) = 0.0
        END DO
      END DO
      CALL GEN074 (ANIS,   1, NP1 * 6, 0.0)
      CALL GEN074 (SUAN,   1, NP1 * 7, 0.0)
      CALL GEN074 (TEMPAB, 1,  2, 0.0)
      CALL GEN074 (CELAB,  1, 12, 0.0)
      CALL GEN074 (SGY,    1, 13, 0.0)
      CALL GEN021 (TM1,  1.0)
      CALL GEN021 (TM2,  1.0)
      CALL GEN021 (RMAT, 1.0)
      CALL GEN021 (OR,   1.0)
      CALL GEN097 (ICV, 1, 2, 0)
C * INIT IPR & PAR ARRAYS
      CALL GEN074 (PAR, 1, NP13, 0.0)
      CALL GEN097 (IPR, 1, NP12, 0)
C * SET DEFAULT ANGSTROM CELL
      CALL GEN074 (PAR,  101, 103,  1.0)
      CALL GEN074 (PAR,  104, 106, 90.0)
      CALL GEN074 (SHFT,   1,   3,  0.0)
      CALL GEN097 (NSID, 1, 192,  0)
      DO I = 0, NP29
        NPOL(I) = 0
        MPOL(I) = 0
      END DO
      PAR(98) = 1.0
      DO I = 1, 3
        KRSYST(1) = '           ?'
      END DO
C * INIT USED CIF-AUDIT TOOL
      DO I = 1, NP56
        CCIF(I) = ' ?'
        NCIF(I) = 2
      END DO
      NEWLAT(1) = 1
C * INIT SPACE GROUP SYMMETRY TO P1
      CALL SGSM (1, IDM, SGY, 0, 0, IERR)
      IPR(48)  = 1
      IPR(146) = 10
      IAN      = 0
      ICLR     = 4
C * DEFAULT AXIAL ORDER
      IPR(34) = 1
      IPR(35) = 2
      IPR(36) = 3
C * MIN-FIT-PAIR
      IPR(28)  = 5
      IPR(40)  = 1
C * SET DEFAULT = UNIT WEIGHTS FOR LEAST-SQUARES PLANES
      IPR(41)  = 0
C * SET PROBABILITY = 50 PERCENT
      IPR(45)  = 5
C * START READING FROM LU1
      IGBL(5)  = LU1
C * SET PP NR
      IPR(65)  = 1
C * SET MAX CIRCUIT
      IPR(66)  = 7
C * SET MAX CHAIN
      IPR(82)  = 5
C * SET ROUND OPTION ON
      IPR(68)  = 2
C * LABEL PARENTHESES ON
      IPR(71)  = 0
C * DEFAULT TRNS
      IPR(95)  = 0
C * MAXIMUM BOND OVERFLOW
      IPR(96)  = NP6
C * EXPAND DEFAULT
      IPR(110) = 1
C * SET FOR UNIT LENGTH POLYHEDRA
      IPR(125) = 1
C * MAXIMUM NUMBER OF RESIDUES
      IPR(129) = NP29
C * DEFAULT MAXIMUM SQUEEZE CYCLES
      IPR(142) = 15
C * RG-STEREO
      IPR(143) = 2
      IPR(144) = 3
C * IN/EXCLUDE DISORDER OPERATIONS
      IPR(154) = 0
C * SET MAXIMUM COORDINATION ABOUT METAL FOR RING SEARCH
      IPR(159) = 6
C * SET OBSOLETE ALERT ON
      IGBL(134) = 1
C * SET LABEL ON
      IGBL(75) = 1
C * SET BONDS IN CONTOUR ON
      IPR(458) = 1
C * MAX COORDINATION FOR NEWMAN PLOT
      IPR(163) = 4
C * MIN NUMBER OF ATOMS IN TMA ANALYSIS
      IPR(21)  = 7
C * SET NFIRST CATOMS (ADP)
      IPR(175) = 1
C * SET C-ATOM ADP PAR
      IPR(176) = 1
C * SET NFIRST HATOMS (ADP)
      IPR(177) = 0
C * SET NLINES HATOMS (ADP)
      IPR(178) = 0
C * SET NFIRST (ADP)
      IPR(179) = 1
C * SET LINES (ADP)
      IPR(180) = 4
C * SET DEFAULT TO SHELXL ATWT
      IPR(181) = 1
C * SET DEFAULT COORDINATE DECIMALS
      IPR(183) = 6
C * SET H-ATOM PLOT (ADP)
      IPR(212) = 1
C * SET PROBE GRID STEP
      IPR(214) = 6
C * SET REDUCED RING-SIZE (DISORDER ETC)
      IPR(216) = 6
C * SET MAX METAL-RING SIZE + 1
      IPR(217) = 6
C * SET MAX H-RING-SIZE + 1
      IPR(218) = 18
C * SET MAX RING-SIZE + 1
      IPR(219) = 24
      IPR(579) = IPR(219)
C * HETERO ADP STYLE DEFAULT
      IPR(211) = 0
C * SET R/S DETERMINATION ON
      IPR(324) = 1
C * SET BEL SIGNAL (CTRL-G = ASCII 7)
      IPR(223) = 7
C * ABSORB/XTAL - CELLDIM ON
      IPR(331) = 1
C * SET COLOR ON
      IPR(346) = 1
C * NONH/EXOR
      IPR(366) = 25
C * 'END' Status
      IPR(460) = 3
      IPR(551) = 3
      IPR(507) = 3
C * EXOR-LOOP-MAX
      IPR(467) = 3
C * SET DEFAULT NO-Hydrogen Atoms
      IPR(484) = -1
C * RING-POP-PAR
      IPR(222) = 100
C * SET NUMBER OF LINES PER PAGE (OMEGA)
      IPR(243) = 60
C * SET Z = 1
      IPR(260) = 1
C * SET DOUBLE SPACE FORMAT TO 2 (SUPPLEMENTARY MATERIAL)
      IPR(274) = 2
C * SET FULL H-BOND ANALYSIS
      IPR(300) = 1
C * SET APPROXIMATE MAXIMUM NUMBER OF RINGS
      IPR(302) = 25
C * ADP LABEL PLOT PARAMETER
      IPR(350) = 0
C * (1/0) POLYHEDRON SKELETON PLOT
      IPR(353) = 1
C * POLYHEDRON DEFAULT RANGE
      IPR(354) = -1
C * POLYHEDRON OMIT OUTSIDE DEFAULT
      IPR(356) = -1
C * PERSPECTIVE VIEW
      IPR(355) = 0
C * DRAW UNITCELL OUTLINE
      IPR(357) = 1
C * SHADE POLY
      IPR(358) = 1
C * Incl Atoms (Poly)
      IPR(359) = 1
C * (NO)CHECK (DIR COS)
      IPR(363) = 1
C * X-H/PLANE ANGLE CALC (0/1) default
      IPR(368) = 0
C * ASYM LIST OPTION
      IPR(392) = 3
C * ASYM ZONEL
      IPR(394) = 3
C * DEFAULT CONTOUR
      IPR(419) = 10
C * DEFAULT NUMBER OF DOAC ATOM TYPES
      IPR(480) = 11
C * EXOR/NV
      IPR(482) = 4
C * ANION/SOLVENT CRIT
      IPR(487) = 10
C * SET R/S-ANALYSIS DEPTH
      IPR(492) = 6
C * CONTOUR/ORTEP XR/YR/ZR
      IPR(505) = 1
C * SET MAXIMUM 2-AXES (LEPAGE)
      IPR(514) = 9
C * SET FOURIER CUT-OFF AT 2 SIGMA(I)
      IPR(515) = 2
C * PLA202 DEFAULTS
      IPR(523) = 6
      IPR(524) = 3
C * LABEL AXES TOGGLE (SOLV PLOT)
      IPR(532) = 1
C * TWINROTMAT - NSELMIN
      IPR(550) = 50
C * TWINROTMAT MAXIND
      IPR(567) = 5
C * (0/1) Displ d-val
      IPR(569) = 1
C * NUMBER OF MARCHING CUBE SECTION DEFAULTS
      IPR(577) = 5
      IPR(578) = 5
C * POPULATION MIN FOR R/S ANALYSIS
      IPR(582) = 2500
      IF (IGBL(47) > 0) THEN
        IPR(590) = 1
      ELSE
        IPR(590) = 0
      END IF
C * FCALC FOR BIJVOET (FROM CIF)
      IPR(594) = 1
C * MAXIMUM NUMBER OF BIJVOET PAIRS TO BE LISTED
      IPR(596) = 50
C * RESD SORT ON NR OF ATOMS
      IPR(597) = 1
C * PLOT VOID AXES
      IPR(598) = 1
C * MAXIMUM NUMBER OF TWIN_LAWS TESTED
      IPR(607) = 25
C * BIJVOET SELECTION CRITERIUM
      IPR(611) = 2
C * MAX SQUEEZE/SHELXL CYCLES
      IPR(682) = 5
      IPR(735) = 5
C * BIJVOET NU-CRIT
      PAR(487) = 10.0
C * ICHX
      IPR(645) = 0
C * HKLF DEFAULT
      IPR(648) = 4
C * ADD CALCULATED SOLVENT CONTRIBUTION FOR MISSING REFLECTIONS (= 1)
      IPR(681) = 1
C * MAXINUM NUMBER OF ATOMS IN P1 SET FOR ADDSYM/CheckCIF TEST
      IPR(737) = 2500
C * MONTE CARLO # IN SASA
      IPR(743) = 5000
C * AXIS/RAW TWINLOOP MAX DEFAULT
      IPR(774) = 2
C * SHOW ABSENCIES
      IPR(776) = 1
C * INIT PAR-PARAMETERS
C * INTRA TOLERANCE
      PAR(2)   = 0.4
C * INTER VDW TOLERANCE
      PAR(3)   = 0.2
C * DEFAULT CALC COORDN RADIUS
      PAR(7)   = 3.6
      PAR(11)  = 1.0
C * SMALL INCREMENT FOR  THE CALCULATION OF NUMERICAL DERIVATIVES
      PAR(12)  = 0.0001
      PAR(15)  = 160.0
      PAR(17)  = -999999.0
      PAR(18)  = 0.01
C * SYMMETRY EQUIVALENCE CRITERIUM
      PAR(22)  = 0.3
      PAR(24)  = 1.0
      PAR(25)  = 0.4
C * (EARTH)ALKALI ADDITIONAL INTRA TOLERANCE IN CONTACTS WITH NON-METALS
      PAR(26)  = 0.70
C * METAL-METAL TOL
      PAR(27)  = - PAR(2)
C * TOL CSD-CELL
      PAR(28)  = 0.25
      PAR(29)  = 1.0
C * DEFAULT U(ISO)
      PAR(30)  = 0.05
C * DEFAULT TRANS BASAL ANGLE
      PAR(31)  = 150.0
C * TRMXS DET - DEFAULT
      PAR(32)  = 1.0
      PAR(33)  = 100.0
C * RIND - LIMIT (TMA)
      PAR(34)  = 0.25
C * MAX RING-RING CG DIST
      PAR(36)  = 6.0
C * PLOT SIZE
      PAR(37)  = RGBL(1)
      PAR(38)  = RGBL(1)
C * SET RESCALE FACTOR FOR SPACEFILL
      PAR(39)  = 1.0
      PAR(40)  = 0.25
      PAR(41)  = 0.75
C * ARU-PACK CONSTANT
      PAR(42)  = 100.0
C * ADDSYM/LEPAGE CRITERIUM
      PAR(43)  = 1.0
C * ADP OVERLAP MARGIN
      PAR(44)  = 0.075
      PAR(48)  = 0.375
C * LSPL TOLERANCE
      PAR(49)  = 0.1
C * DEFAULT HOR/VERT RATIO
      PAR(50)  = (4.0 - IGBL(46)) / 3.0
      PAR(51)  = 1.25
      PAR(52)  = 0.5
      PAR(53)  = 0.2
C * TOL IN ADP
      PAR(54)  = 1.E-5
C * Cg-Ring-Ring ANGLE TEST
      PAR(62)  = 60.0
C * WAVEL SEL CRIT
      PAR(63)  = 0.0005
      PAR(69)  = 4.0
C * MAX-RING SLIPPAGE (ADP)
      PAR(70)  = 0.3
C * SMALL LABEL OFFSET
      PAR(71)  = 0.05
C * STICK LABEL SIZE
      PAR(72)  = 0.25
C * MOLSYM PARAMETER
      PAR(73)  = 0.1
C * DEFAULT FVAR
      PAR(74)  = 1.0
C * MOLSYM PARAMETER (DCM-MAX)
      PAR(75)  = 0.8
      PAR(76)  = 1.5
C * DIRECTION COSINE TEST PARAMETERS
      PAR(77)  = 0.03
      PAR(78)  = 0.5
C * SOLV/VOID DEFAULT GRID
      PAR(80)  = 0.2
C * SET PROBE RADIUS
      PAR(84)  = 1.20
C * ADP NORMAL BOND PARAMETERS
      PAR(85)  = 4
      PAR(86)  = 0.03
C * ADP KODE 4 PARAMETERS
      PAR(87)  = 2
      PAR(88)  = 0.02
C * ADP KODE 1 PARAMETERS
      PAR(89)  = 5
      PAR(90)  = 0.05
C * ADP DISORDER BOND PARAMETERS
      PAR(91)  = 2
      PAR(92)  = 0.02
C * SMALL INCREMENT FOR THE CALCULATION OF NUMERICAL DERIVATIVES
      PAR(93)  = 0.001
C * SET TAUPUCK CRITERIUM
      PAR(94)  = 10.0
C * SET MINIMUM NON-PLANAR TAU
      PAR(95)  = 5.0
C * SET TAUPLAN CRITERIUM
      PAR(96)  = 10.0
      PAR(97)  = 25.0
C * SPGR-FROM-EXT RATIO
      PAR(141) = 5.0
C * ASYM/SHELX OMIT TMAX
      PAR(165) = 90.0
C * CLOSE CONTACT COUNT CRITERIUM
      PAR(199) = -1.0
C * RADII SCALE
      PAR(213) = 0.5
C * TETRAEDER CRITERIA
      PAR(214) = 109.0
      PAR(215) = 20.0
      PAR(216) = 1.62
      PAR(217) = 0.2
C * OCTAEDER CRITERIA
      PAR(218) = 90.0
      PAR(219) = 20.0
      PAR(220) = 1.97
      PAR(221) = 0.4
C * DEFAULT HKLF - TRANSFORMATION
      PAR(231) = 1.0
      PAR(235) = 1.0
      PAR(239) = 1.0
C * DETERMINANT OF TRANSFORMATION MATRIX
      PAR(240) = 1.0
C * NEWSYM PARAMETERS U AND RESOLUTION & AXIAL CRIT
      PAR(247) = 0.05
      PAR(248) = 0.6
C * SET SQUEEZE STOP CRITERIUM FOOO
      PAR(249) = 0.0002
C * SET SQUEEZE STOP CRITERIUM  (ELECTRONS PER ASYMMETRIC VOID)
      PAR(250) = 0.1
C * CLOSE CONTACT COUNT CRITERIUM (H-H)
      PAR(251) = -0.25
      PAR(253) = -0.25
C * X-H..Cg(Pi) CRITERIA
      PAR(263) = 3.0
      PAR(264) = 40.0
C * DEFAULT H & NON-H ISOTROPIC RADII
      PAR(265) = 0.1
      PAR(266) = 0.2
C * RHO-CUT-OFF
      PAR(268) = 0.5
      PAR(269) = 0.5
C * RATIO (CONTOUR)
      PAR(270) = 0.2
C * RESOL (CONTOUR)
      PAR(271) = 0.3
C * HOR & VERT SIZE (ANGSTROM) CONTOUR-PLOT
      PAR(273) = 10.0
      PAR(272) = PAR(273) * 4.0 / 3.0
C * TOL (DIST TO CONTOUR-PLANE)
      PAR(279) = 1.5
C * BOND TEST CRIT
      PAR(280) = 0.1
C * EXOR/STHMN
      PAR(281) = 0.2
C * EXOR/STHM
      PAR(282) = 1.0
C * EXOR/SOEM
      PAR(283) = 0.05
C * EXOR/SS
      PAR(284) = 1.E5
C * SQUEEZE RHO-CUTOFF
      PAR(285) = 0.0
C * LISTING SINT/L MAX (SQUEEZE)
      PAR(286) = 0.15
C * DEFAULT SINTH/LAMBDA MAX
      PAR(287) = 1.0 / 1.54184
C * SQUEEZE LIST PAR
      PAR(288) = 2.0
C * SINTH/L - MIN FOR SQUEEZE SCALING
      PAR(290) = 0.2
C * SQUEEZE DELTA-F OUTLIER CRITERIUM
      PAR(292) = 500.0
C * SET X-H NORM VALUES
C * Allen & Bruno (Acta Cryst. (2010). B66, 380-386
      PAR(294) = 1.185
      PAR(295) = 1.506
      PAR(296) = 1.098
      PAR(297) = 1.036
      PAR(298) = 0.983
C * RELATIVE XTAL PLOTSCALE
      PAR(325) = 1.0
C * UMIN - MULABS
      PAR(326) = 0.5E-15
C * YES/NO C & P ANALYSE
      PAR(328) = 25.0
C * NON-INT LEVEL
      PAR(331) = 0.011
C * ADP LABEL SIZE
      PAR(349) = 0.25
C * INTERACTIVE TEXT-SIZE
      PAR(350) = 0.55
C * POWDER PARAMETERS (LORENTZIAN ALFA)
      PAR(371) = 0.1
      PAR(372) = 1.0
C * DELRED CRITERIA
      PAR(381) = 1.0
      PAR(382) = 0.5
      PAR(383) = 0.2
C * PLA030/DOUBLE BOND CRITERIUM
      PAR(384) = 1.41
C * DAMP IN C&P
      PAR(410) = 0.00000001
C * POWDER-SCAN STEP
      PAR(411) = 0.02
C * STHLMAX CONTOURMAP
      PAR(412) = 100.0
C * RATMIN (TWINROTMAT)
      PAR(413) = 4.0
C * THDEL (TWINROTMAT)
      PAR(414) = 0.10
C * HKLF5-PAR (TwinRotMat)
      PAR(415) = 0.1
C * ALPHA-MIN
      PAR(416) = 0.01
C * SHXABS - PARAM (TH & DU)
      PAR(417) = 5.0
      PAR(418) = 0.0
C * BEAM-STOP THETA-MIN
      PAR(419) = 2.5
C * TWIN-DELTH
      PAR(420) = 0.10
C * HIRSHFELD RIGID-BOND TEST CRIT
      PAR(421) = 5.0
C * METAL-RING MAX DIST (FOR RING SLIPPAGE)
      PAR(422) = 3.5
      PAR(423) = 2.0
      PAR(424) = 1.5
C * RING-RING SLIPPAGE ALPHA-MAX
      PAR(427) = 20.0
C * MINIMUM CAVITY RADIUS
      PAR(519) = 1.2
C * MAXIMUM EXPECTED CAVITY RADIUS
      PAR(520) = 5.0
C * NEWSYM/LAUE R_MAX
      PAR(429) = 5.0
C * SPGR/LAUE RMAX-GREEN/RED-COLOUR
      PAR(430) = 10.0
C * SPGR/LAUE RMAX=LIST
      PAR(431) = 40.0
C * SPGR/LAUE-%Ct COLOUR
      PAR(432) = 80.0
C * SPGR/LEPAGE CRIT
      PAR(439) = 0.4
      PAR(440) = 1000.0
      PAR(441) = 0.4
C * TOLERANCE ON SIN(THETA)/LAMBDA FOR SQUEEZE
      PAR(442) = 0.000
C * Y-X..Cg(Pi) CRITERIA
      PAR(447) = 4.0
      PAR(448) = 30.0
C * Default TwinPlot Resolution
      PAR(449) = 0.4
C * Default RDF-Radius
      PAR(450) = 5.0
C * DEFAULT RDF-SIGMA
      PAR(451) = 5.0
C * DEFAULT BIJVOET SIGMA-CRIT
      PAR(452) = 0.25
C * MIN. Bond Valence Contrib
      PAR(454) = 0.04
C * MAXIMUM Me-H DIST
      PAR(461) = 2.1
C * RFLMX (PLA350)
      PAR(466) = 0.50
C * REXMX (PLA350)
      PAR(467) = 0.30
C * RVALHALF (PLA350)
      PAR(468) = 0.40
C * (NON)MEROHEDRAL TEST
      PAR(473) = 0.10
C * DEFAULT FACTOR (FLIPPER)
      PAR(475) = 0.02
C * BIJVOET COVERAGE MIN
      PAR(476) = 80.0
C * RMS-FIT-MAX
      PAR(483) = 0.5
C * LESS THAN CRIT
      PAR(484) = 2.0
C * I/SIG-MAX
      PAR(485) = 400.0
C * SQUEEZE MISSING REFLECTION SIN(THETA)/LAMBDA
      PAR(486) = 0.25
C * TWO-THETA CUTOFF DEFAULT
      PAR(500) = 180.0
C * HOOFT Y STEP
      PAR(515) = 0.025
C * DEFAULT SINTH/LAMBDA MAX FOR HKLF-GENER
      PAR(540) = 1.0 / 1.54184
C * ZN-O,N ADD
      PAR(541) = 0.20
C * CU-O,N ADD
      PAR(542) = 0.35
C * MN-O,N ADD
      PAR(543) = 0.40
C * AG-O,N ADD
      PAR(544) = 0.20
C * CR-O,N ADD
      PAR(545) = 0.20
C * TL-O,N
      PAR(546) = 0.30
C * AVER TOL CREATE SHX
      PAR(547) = 0.20
C * PROBE RADIUS SASA OPTION
      PAR(557) = 1.84
C * GRIDSTEP MOLVOL
      PAR(569) = 0.1
C * MIN PLANAR RMSD IN TMA ANAL
      PAR(574) = 0.05
C * ABIN SF
      PAR(575) = 1.0
C * ABIN U
      PAR(576) = 0.0
C * DEF INIT (CIF)
      DO I = 262, 272
        IPR(I) = -999999
      END DO
      IPR(267) = - IPR(268)
      IPR(269) = - IPR(270)
      IPR(271) = - IPR(272)
      IPR(261) = -999999
      IPR(310) = -999999
      PAR(158) =  999999.0
      PAR(167) = -999999.0
      PAR(168) = -999999.0
      PAR(170) = -999999.0
      PAR(173) = -999999.0
      PAR(174) = -999999.0
      PAR(175) = -999999.0
      PAR(176) =  999999.0
      PAR(177) = -999999.0
      PAR(178) = -999999.0
      PAR(179) = -999999.0
      PAR(197) = -999999.0
      PAR(198) = -999999.0
      PAR(299) = -999999.0
      PAR(300) = -999999.0
      PAR(302) = -999999.0
      PAR(303) = -999999.0
      PAR(304) = -999999.0
      PAR(305) = -999999.0
      PAR(306) =  999999.0
      PAR(307) =  999999.0
      PAR(309) = -999999.0
      PAR(310) = -999999.0
      PAR(227) = -999999.0
      PAR(228) = -999999.0
      PAR(229) = -999999.0
      PAR(312) = -999999.0
      PAR(313) = -999999.0
      PAR(314) = -999999.0
      PAR(425) = -999999.0
      PAR(433) =  999999.0
      PAR(434) =  999999.0
      PAR(435) =  999999.0
      PAR(436) =  999999.0
      PAR(471) = -999999.0
      PAR(474) = -999999.0
      PAR(493) = -999999.0
      PAR(503) =  999999.0
      PAR(559) = -999999.0
      PAR(563) = -999999.0
C * NOW READ THE DATA
      IGBL(1)   = 2
C * FCF CHECK
      IGBL(129) = - IABS(IGBL(129))
      RETURN
      END SUBROUTINE PLA001
 
      MODULE chdat
      SAVE
      INTEGER, PARAMETER :: NP22 = 80
      INTEGER, PARAMETER :: NP24 = 224
      INTEGER, PARAMETER :: NP37 = 191
C * KEYWORDS (PLATON)
      CHARACTER(len=4), DIMENSION(NP24) :: ISWS = (/
     1 'TITL', 'MESS', 'REM ', 'ANGS', 'ROUN', 'FIT ', 'LSPL', 'RING',
     2 'NOMO', 'MOLV', 'DOAC', 'LINE', 'ENDS', 'PLOT', 'YES ', 'NO  ',
     3 'CALC', 'END ', 'INCL', 'EXCL', 'STOP', 'HELP', 'SAVE', 'UIJ ',
     4 'SUIJ', 'U   ', 'ATOM', 'LIST', 'CELL', 'CESD', 'SYMM', 'SPGR',
     5 'LATT', 'DIST', 'ANGL', 'TORS', 'HBON', 'BIJ ', 'SBIJ', 'B   ',
     6 'TRNS', 'FVAR', 'PARE', 'QUIT', 'SET ', 'AFIX', 'SFAC', 'UNIT',
     7 'WGHT', 'VIEW', 'BOX ', 'EXIT', 'BOND', 'ZERR', 'GEOM', 'L   ',
     8 'FMAP', 'INFO', 'TABL', 'RADI', 'BLOC', 'MENU', 'OMIT', 'GRID',
     9 'DFIX', 'JOIN', 'DETA', 'DEFI', 'HKLF', 'RADN', 'TRMX', 'PART',
     * 'INOR', 'ORGA', 'RTAB', 'SIMU', 'ENTR', 'ELLI', 'ORMA', 'EXTI',
     1 'SETU', 'EXOR', 'ABSG', 'FACE', 'ABST', 'ABSX', 'LEPA', 'ASYM',
     2 'ABSP', 'ABSS', 'CONT', 'REST', 'VALI', 'EXPT', 'PLUT', 'MOLE',
     3 'PLAN', 'TWIN', 'SPEC', 'MERG', 'SUMP', 'RESI', 'SHEL', 'MORE',
     4 'TIME', 'CGLS', 'ACTA', 'DAMP', 'DISP', 'SLIM', 'SIZE', 'EQIV',
     5 'EXYZ', 'EADP', 'NCSY', 'FREE', 'BIND', 'SAME', 'CONF', 'MPLA',
     6 'FLAT', 'CHIV', 'DELU', 'ISOR', 'SADI', 'ANIS', 'CONN', 'HFIX',
     7 'LAUE', 'BUMP', 'TEMP', 'DEFS', 'ABSC', 'SWAT', 'EMPI', 'LAMI',
     8 'HOPE', 'DMAT', 'SKIP', 'WPDB', 'BASF', 'MOVE', 'FRAG', 'FEND',
     9 'HALL', 'HTAB', 'MULA', 'HKLT', 'XTAL', 'HINC', 'HEXC', 'FILE',
     * 'RENA', 'SYST', 'DELR', 'EXP1', 'ARU ', 'VARI', 'FCF2', 'PORT',
     1 'POWD', 'FSUM', 'SCAL', 'CRYS', 'ROTM', 'CAVI', 'SHXA', 'DELE',
     2 'COLO', 'RESE', 'SCAT', 'STID', 'BIJV', 'FLIP', 'STRU', 'FROM',
     3 'STRA', 'CELA', 'CELB', 'CSUA', 'CSUB', 'CIF2', 'NOEX', 'RESD',
     4 'ANOM', 'MU  ', 'XTPL', 'ABIN', 'ANSC', 'ANSR', 'NEUT', 'PRIG',
     5 'RIGU', 'STIR', 'TWST', 'WIGL', 'XNPD', 'HYBR', 'BYPA', 'DANG',
     6 'ADDS', 'NEWS', 'SQUE', 'WILS', 'FCF ', 'PAIR', 'BEDE', 'LONE',
     7 'SASA', 'NONS', 'ADP ', 'SOLV', 'NEWM', 'RADI', 'VOLC', 'NONB',
     8 'CIP ', 'ORTE', 'DIED', '    ', '    ', '    ', '    ', '    '/)
C * SUB-KEYWORDS (PLATON)
      CHARACTER(len=4), DIMENSION(NP22) :: ISWSS = (/
     1 'GEOM', 'TMA ', 'INTR', 'INTE', 'NOTM', 'NOAN', 'NOTO', 'NOLS',
     2 'NOST', 'NORI', 'NOBO', 'NOMO', 'NOSY', 'NOBP', 'EWLS', 'TOLA',
     3 'COOR', 'META', 'AWLS', 'HBON', 'UWLS', 'SHEL', 'OMEG', 'ICHX',
     4 'SPF ', 'FIVE', 'ALL ', 'TOLP', 'TOLR', 'NOTH', 'VOID', 'PROB',
     5 'PSTE', 'LIST', 'EXPA', 'DIST', 'TOLE', 'MISS', 'SOLV', 'TOLM',
     6 'NODI', 'BOND', 'ANGL', 'TORS', 'CSD ', 'SQUE', 'SAV ', 'FCF ',
     7 'CYCL', 'NEWS', 'NOCH', 'PDB ', 'HINC', 'NONS', 'NONA', 'MAXD',
     8 'WLSP', 'FCAL', 'ADDS', 'DIFF', 'NOSO', 'DISO', 'GENE', 'EXPE',
     9 'MAXR', 'MOLS', 'RENU', 'PLOT', 'RDF ', 'GRID', 'F3D ', 'NOSF',
     * '    ', '    ', '    ', '    ', '    ', '    ', '    ', '    '/)
      CHARACTER(len=2), DIMENSION(16)   :: LABP = (/
     1 '  ', 'AU', 'E ', 'NE', 'N ', 'NW', 'W ', 'SW', 'S ', 'SE',
     2 'NU', '  ', '  ', '  ', '  ', 'MS'/)
C * KEYWORDS (PLUTON)
      CHARACTER(len=4), DIMENSION(NP37) :: CRD = (/
     1         'TITL', 'MESS', 'REM ', 'CELL', 'SPGR', 'LATT', 'LIST',
     2 'SYMM', 'ANGS', 'ROD ', 'ATOM', 'JOIN', 'END ', 'UIJ ', 'SUIJ',
     3 'U   ', 'VIEW', 'SOLI', 'STIC', 'LABE', 'UNLA', 'PUT ', 'RADI',
     4 'PACK', 'MOLE', 'INCL', 'EXCL', 'UNIT', 'RETR', 'STER', 'MONO',
     5 'SIZE', 'PLOT', 'RESE', 'SEGM', 'ECHO', 'HP  ', 'CAL ', 'COLO',
     6 'SET ', 'OMIT', 'STOP', 'RESI', 'ANGL', 'DETA', 'SAVE', 'OVER',
     7 'QUIT', 'ORT ', 'BOX ', 'FVAR', 'HELP', 'BIJ ', 'B   ', 'CESD',
     8 'SBIJ', 'CPK ', 'SFAC', 'DFIX', 'AFIX', 'DIST', 'TORS', 'BWC ',
     9 'TRNS', 'WAIT', 'INOR', 'ORGA', 'STRA', 'INFO', 'ARU ', 'CROT',
     * 'XROT', 'YROT', 'ZROT', 'DEFI', 'BLOC', 'RENA', 'GEOM', 'MENU',
     1 'ZERO', 'HKLF', 'L   ', 'PART', 'RTAB', 'SIMU', 'COOR', 'SADI',
     2 'DELE', 'ENTR', 'DIR ', 'HFIX', 'TRMX', 'PLAN', 'GRID', 'FMAP',
     3 'MOVE', 'SWAT', 'WPDB', 'BASF', 'EXTI', 'FRAG', 'FEND', 'TWIN',
     4 'SPEC', 'MERG', 'SUMP', 'SHEL', 'MORE', 'TIME', 'CGLS', 'ACTA',
     5 'DAMP', 'DISP', 'SLIM', 'EQIV', 'EXYZ', 'EADP', 'BOND', 'FREE',
     6 'BIND', 'SAME', 'CONN', 'LAUE', 'BUMP', 'TEMP', 'XXXX', 'ABS ',
     7 'FACE', 'EMPI', 'LAMB', 'HOPE', 'DMAT', 'SKIP', 'ANIS', 'WGHT',
     8 'EXOR', 'ISOR', 'RADN', 'ENDS', 'ZERR', 'DELU', 'NOMO', 'RESD',
     9 'NOSO', 'DEFS', 'HALL', 'FLAT', 'HTAB', 'EXIT', 'MPLA', 'PORT',
     * 'FSUM', 'SCAL', 'CRYS', 'CALC', 'REN ', 'LAB ', 'DEL ', 'CONF',
     1 'VIE ', 'SOL ', 'STI ', 'UNL ', 'INC ', 'EXC ', 'UNI ', 'PAC ',
     2 'SCAT', 'FIT ', 'ABIN', 'ANSC', 'ANSR', 'NEUT', 'PRIG', 'RIGU',
     3 'STIR', 'TWST', 'WIGL', 'XNPD', 'DANG', 'PAIR', 'BEDE', 'LONE',
     4 'TEXT', '    ', '    ', '    ', '    ', '    ', '    ', '    '/)
      END MODULE chdat
 
      MODULE crystal
      SAVE
      INTEGER, PARAMETER :: NXT1 = 100
      INTEGER, PARAMETER :: NXT2 = 200
      INTEGER, PARAMETER :: NXT3 = 100
      INTEGER, PARAMETER :: NXT4 = 200
      INTEGER :: NVER
      INTEGER :: NVRR
      INTEGER :: NEDGE
      INTEGER :: NFACES
      INTEGER, DIMENSION(NXT4, 4) :: IDG
      INTEGER, DIMENSION(21)      :: IHLP
      INTEGER, DIMENSION(NXT3)    :: IEDGE
      REAL, DIMENSION(7, NXT2) :: XTLV
      REAL, DIMENSION(NXT1, 5) :: PMILL
      REAL, DIMENSION(3, NXT2) :: XYZPL
      REAL, DIMENSION(5, NXT2) :: CFACE
      END MODULE crystal
 
      MODULE spgrdata
      SAVE
      CHARACTER(len=5), DIMENSION(14)  :: NLAUE = (/
     1 '   -1', '  2/m', '  mmm', '  4/m', '4/mmm', '   -3', ' -3m1',
     2 ' -31m', '  6/m', '6/mmm', '  m-3', ' m-3m', '     ', '  -3m'/)
      CHARACTER(len=12), DIMENSION(8)  :: XSYST = (/
     1 '   Triclinic', '  Monoclinic', 'Orthorhombic', '  Tetragonal',
     2 '    Trigonal', '   Hexagonal', '       Cubic', '            '/)
      CHARACTER(len=1),  DIMENSION(8)  :: IBVL = (/
     1 'a', 'm', 'o', 't', 'r', 'h', 'c', ' '/)
      CHARACTER(len=5),  DIMENSION(12) :: LGR = (/
     1 '   -1', '  2/m', '  mmm', '  4/m', '4/mmm', '   -3', '  -3m',
     2 '  6/m', '6/mmm', '  m-3', ' m-3m', '     '/)
      CHARACTER(len=1),  DIMENSION(7)  :: LAT = (/
     1 'P', 'A', 'B', 'C', 'F', 'I', 'R'/)
      END MODULE spgrdata
 
      SUBROUTINE PLA002
C * MAIN (INSTRUCTION) INPUT LOOP ROUTINE (LU1 > LU3 > LU5)
      USE files
      USE parameters
      USE plato
      USE atomdata
      USE cchar
      USE xwdw
      USE cggt
      USE menus
      USE spgrdata
      USE crystal
      USE dfspgr
      USE strain1
      USE chdat
      USE sgxyz
      IMPLICIT NONE
      INTEGER :: I
      INTEGER :: J
      INTEGER :: K
      INTEGER :: L
      INTEGER :: M
      INTEGER :: N
      INTEGER :: JB
      INTEGER :: JE
      INTEGER :: N1
      INTEGER :: IS
      INTEGER :: NR
      INTEGER :: NN
      INTEGER :: K0
      INTEGER :: KN
      INTEGER :: IP
      INTEGER :: ISS
      INTEGER :: NID
      INTEGER :: LBB
      INTEGER :: LBC
      INTEGER :: LBD
      INTEGER :: ICT
      INTEGER :: MODE
      INTEGER :: NIEN
      INTEGER :: NTYP
      INTEGER :: NSMR
      INTEGER :: NRET
      INTEGER :: MORT
      INTEGER :: ITRS
      INTEGER :: IENM
      INTEGER :: NOPT
      INTEGER :: NCHAR
      INTEGER :: IDUM2
      INTEGER :: IEXIT
      INTEGER :: IFN10
      INTEGER :: ITRNS
      INTEGER :: IYUNK
      INTEGER :: IRETN
      INTEGER :: INQNR
      INTEGER :: JNQNR
      INTEGER :: JNQNR2
      INTEGER :: INQNR2
      INTEGER :: IPR220
      INTEGER :: NRETURN = 0
      INTEGER :: IUNKNOWN
      REAL :: ANG
      REAL :: FNN
      REAL :: FN1
      REAL :: FN2
      REAL :: DET
      REAL :: DIFF
      REAL :: GEN016
 
      CHARACTER(len=3) :: OPT
      CHARACTER(len=9) :: EXTENS1
C * TEST FOR A 'CALC' = 'CALC ALL' JOB (i.e. IPR(121) > 0)
  10  IF (IPR(121) == 0) THEN
C * DEFAULT POSITION OF LABEL IN ATOM RECORD
        IPR(473) = 2
C * DATA READ SEQUENCE LU1, LU3, LU5
C * GET NEXT INPUT-LINE AND RECORD TYPE (IN IS)
        CALL PLA006 (0, IS)
C * ERROR CHECK
        IF (IPR(2) /= 0) THEN
C * ERROR HANDLING
          IGBL(1) = 3
          RETURN
        END IF
C * CHECK FOR AND HANDLE SHELX(L) TYPE INPUT RECORDS
        CALL PLA383 (IS)
        DO
          SELECT CASE (IS)
C * IS = -4: SHELXL INSTRUCTION RECORD
            CASE (-4)
              EXIT
C * IS = -3: CIF BOND/ANGLE/TORSION/HBOND
            CASE (-3)
              GO TO 10
C * IS = -1 & IS = -2: HANDLE END-OF-FILE (SWITCH TO LU3 OR LU5 RESP. READING)
            CASE (-1, -2)
              IF (IGBL(5) == LU5) THEN
                GO TO 190
              ELSE IF (IGBL(5) == LU3) THEN
                IGBL(5) = LU5
C * OPEN MAIN X-WINDOW (IGBL(24) = 1)
                IGBL(6)  = 10
                IGBL(24) = 1
                GO TO 10
              ELSE
C * CHECK FOR NO-ATOMS & NO-FACES AND NO-CELL INFO FOUND
                IF (IPR(37) == 0 .AND. IPR(367) == 0 .AND.
     1              PAR(101) == 0.0) GO TO 200
C * CHECK FOR 'ENDS'
                IF (IPR(3) == 1) THEN
                  IPR(3) = -1
                  GO TO 200
                ELSE
                  IGBL(5) = LU3
                END IF
              END IF
              CALL GEN108 (LU3, 0)
              GO TO 10
C * IS = 0: FORMAT/READ - ERROR
            CASE (0)
              IPR(2) = 61
              GO TO 200
C * IS = 1, 28: POTENTIAL ATOM LINE/ATOM
            CASE (1, 28)
              IF (IS == 1) THEN
                IF (IGBL(5) == 5) GO TO 10
                IPR(473) = 1
C * TEST FOR PREVIOUS CALC UNIQUE (NO = 0)
                IF (IPR(30) /= 0) THEN
C * UNKNOWN CARD ERROR
                  IPR(2) = 7
                  GO TO 200
                END IF
              END IF
C * ATOMIC COORDS IN FREE-FORMAT INPUT
              IF (IPR(220) < IPR(473) .OR. IPR(221) < 3) THEN
                IPR(471) = IPR(471) + 1
                IF (IGBL(5) == LU5) THEN
C * UNKNOWN CARD ERROR
                  IPR(2) = 7
                  GO TO 200
                END IF
              ELSE
                IF (IGBL(8) /= 2 .OR. IGBL(95) /= 1 .OR.
     1            IFL(1)(1:1) /= 'Q' .OR. FN(7) >= RGBL(26)) THEN
                  CALL PLA022 (INQNR)
C * CHECK FOR ERROR RETURN
                  IF (IPR(2) /= 0) THEN
                    IF (IPR(2) == 10) THEN
                      IGBL(1) = 3
                      RETURN
                    ELSE
                      GO TO 200
                    END IF
                  END IF
                END IF
              END IF
              GO TO 10
C * IS = 3: MESSAGE (ECHO)
            CASE (3)
              WRITE (LU6, 99988, IOSTAT = IOST) ICL(5:80)
              GO TO 10
C * IS = 5: ANGSTROM COORDINATE SCALE
            CASE (5)
              IF (IPR(221) == 1) THEN
                CALL PLA100
                PAR(11) = FN(1)
              END IF
              GO TO 10
C * IS = 6: ROUND ON/OFF OPTION
            CASE (6)
              IF (IPR(221) == 1) THEN
                IPR(68) = MAX (MIN (NINT(FN(1)), 10), 0)
              ELSE
                IPR(68) = 1
              END IF
              IF (IPR(220) > 1) THEN
                IF (IFL(2)(1:3) == 'OFF') THEN
                  IPR(68) = 0
                END IF
              END IF
              IF (IPR(68) > 0) THEN
                CALL GEN040 (IPR(68), NQ1, IP)
                WRITE (LU6, 99990, IOSTAT = IOST) IPR(68) * 10 - 1
              END IF
              GO TO 180
C * IS = 7: FIT MOL1 ON MOL2 (OR INVERTED MOL2)
            CASE (7)
C * SAVE OPTION TEST
              IF (IGBL(45) > 0 .AND. IGBL(5) == LU5) THEN
                IGBL(45) = IGBL(45) + 1
                WRITE (LU3, 99984, IOSTAT = IOST) ICL(1:80)
                WRITE (LU6, 99973, IOSTAT = IOST) ICL(1:70)
              END IF
              IF (IPR(220) == 1 .AND. IPR(221) == 0) THEN
                IPR(1)  = 7
                IPR(81) = -1
                CALL PLA021 (11, NRETURN)
                RETURN
              ELSE
C * TEST FOR PREVIOUS CALC UNIQUE (NO = 0)
                IF (IPR(30) == 0) THEN
C * FIT RES-NR1 RES-NR2
                  IF (IPR(221) == 2) THEN
                    FN1      = FN(1)
                    FN2      = FN(2)
                    IPR(221) = 0
C * NO SORTING WHEN NON-ZERO NUMBER OF ALIASES
                    IF (IPR(759) > 0) IGBL(33) = 0
                    WRITE (LU6, 99963)
C * SET UP CONNECTED SET
                    CALL PLA067
                    IF (IPR(2) /= 0) RETURN
                    CALL PLA073 (-1, -1)
                    FN(1)    = FN1
                    FN(2)    = FN2
                    IPR(221) = 2
                    IPR(220) = - IPR(220)
C * FIT ATOM-NAME1 ATOM-NAME2
                  ELSE IF (IPR(220) == 3) THEN
                    IPR220   = IPR(220)
                    IPR(220) = 1
C * SET UP CONNECTED SET
                    CALL PLA067
                    IF (IPR(2) /= 0) RETURN
                    CALL PLA073 (-1, -1)
                    IPR(220) = - IPR220
                  ELSE
                    NTYP = 0
                    GO TO 20
                  END IF
                ELSE
                  IPR(220) = - IPR(220)
                END IF
                GO TO 30
              END IF
              GO TO 10
C * IS = 8: LSPL: EXPLICIT PLANE SPECIFICATION
            CASE (8)
              NTYP = 4
              GO TO 20
C * IS = 9: RING: EXPLICIT RING SPECIFICATION
            CASE (9)
              NTYP = 2
              GO TO 20
C * IS = 10: NOMOVE (OFF)
            CASE (10)
C * TEST FOR PREVIOUS CALC UNIQUE (NO = 0)
              IF (IPR(30) == 0) THEN
                IF (IPR(220) > 1 .AND. IFL(2)(1:3) == 'OFF') THEN
                  IGBL(30) = 0
C * MOVE MOLECULES CLOSEST TO FN(1), FN(2), FN(3) FRACTIONAL POSITION
                  IF (IPR(221) == 3) THEN
                    DO I = 1, 3
                      PAR(63 + I) = FN(I)
                    END DO
                  END IF
                ELSE
                  IGBL(30) = 1
                END IF
              END IF
              GO TO 10
C * IS = 11: MolVolume
            CASE (11)
C * RESET DEFAULT GRID STEP
              IF (IPR(221) /= 0) PAR(569) = FN(1)
C * SAVE OPTION TEST
              IF (IGBL(45) > 0 .AND. IGBL(5) == LU5) THEN
                IGBL(45) = IGBL(45) + 1
                WRITE (LU3, 99984, IOSTAT = IOST) ICL(1:80)
                WRITE (LU6, 99973, IOSTAT = IOST) ICL(1:70)
              END IF
C * SET TO NO R/S CALC
              IPR(744) = 1
C * Molecular volume  CALCULATION
              CALL PLA396
              RETURN
C * IS = 12: DONOR/ACCEPTOR TYPES
            CASE (12)
              IPR(480) = 0
              DO I = 1, IPR(220)
                CALL PLA037 (I, N, 2)
C * SKIP ELEMENTS THAT ARE NOT PRESENT
                IF (N > 0) THEN
                  IF (IPR(480) <= NP10) THEN
                    IPR(480)        = IPR(480) + 1
                    IDOAC(IPR(480)) = IEN(N)
                  ELSE
                    WRITE (LU6, 99979, IOSTAT = IOST) NP10
                  END IF
                END IF
              END DO
              GO TO 180
C * IS = 13: SPECIAL LINE MANAGEMENT
            CASE (13)
C * TEST FOR PREVIOUS CALC UNIQUE (NO = 0)
              IF (IPR(30) == 0) THEN
                IF (IPR(220) == 3 .AND. IPR(407) < 10) THEN
                  DO I = 2, 3
                    CALL PLA046 (1, IFL(I), IENM, LBB, LBC, LBD,
     1                           INQNR, JNQNR, NIEN)
                    IF (NIEN < 0) GO TO 10
                    SLN(IPR(407) + 1, I - 1) = INQNR
                  END DO
                  IPR(407) = IPR(407) + 1
                  WRITE (LU6, 99987, IOSTAT = IOST)
                END IF
              END IF
              GO TO 10
C * IS = 14: ENDS
            CASE (14)
              IPR(3)  = 1
              IGBL(8) = - IABS (IGBL(8))
              IGBL(5) = LU3
              CALL GEN108 (LU3, 0)
              GO TO 10
C * IS = 15: PLOT
            CASE (15)
              IPR(14) = 0
              GO TO 80
C * IS = 16: YES
            CASE (16)
              GO TO 210
C * IS = 18: CALC
            CASE (18)
              IF (IPR(220) == 2) THEN
                IF (IFL(2)(1:3) == 'ALL') IPR(220) = 1
              END IF
              GO TO 100
C * IS = 19: END
            CASE (19)
              GO TO 190
C * IS = 20/21: (1/0)IN/EXCLUDE NAMED ELEMENTS IN/FROM CALCULATIONS
            CASE (20, 21)
              IF (IS == 20) THEN
                IPR(70) = 1
              ELSE
                IPR(70) = 0
              END IF
C * TEST FOR PREVIOUS CALC UNIQUE (NO = 0)
              IF (IPR(30) == 1) THEN
C * INSTRUCTION NOT ALLOWED
                IPR(2) = 11
                GO TO 200
              ELSE
                IPR(4) = 0
C * LOOP MAXIMUM IS POTENTIALLY REDEFINED WITHIN THE LOOP
                I = 1
                DO WHILE (I < IPR(220))
                  I = I + 1
C * TEST FOR KEYWORD METAL
                  IF (IFL(I)(1:3) == 'MET') THEN
                    DO J = 1, IAN
                      IF (IATPR(IEN(J)) > 0) THEN
                        IPR(220)           = IPR(220) + 1
                        N                  = IEL(IEN(J))
                        N1                 = N / 100
                        IFL(IPR(220))(1:3) =
     1                      CHAR (ICHAR ('A') - 1 + N1)//'  '
                        N1                 = MOD (N, 100)
                        IF (N1 > 0) THEN
                          IFL(IPR(220))(2:2) =
     1                      CHAR (ICHAR ('A') - 1 + N1)
                        END IF
                      END IF
                    END DO
                    CYCLE
                  END IF
                  CALL PLA037 (I, N, 2)
C * SKIP SPECIFIED ELEMENTS THAT ARE NOT PRESENT
                  IF (N > 0) THEN
                    IF (IPR(4) <= NP10) THEN
                      IPR(4) = IPR(4) + 1
C * SCRATCH USE OF ARRAY RADI FOR INCLUDE OPTION
                      RADR(IPR(4), 2) = N
                    ELSE
                      WRITE (LU6, 99978, IOSTAT = IOST) NP10
                    END IF
                  ELSE
                    IPR(2) = 16
                    IPR(4) = 0
                    IAN    = IAN - 1
                    GO TO 200
                  END IF
                END DO
                GO TO 180
              END IF
              GO TO 10
C * IS = 22, 45, 53: STOP/QUIT/EXIT - NO FULL END PROCESSING - TERMINATE JOB
            CASE (22, 45, 53)
              WRITE (LU6, 99999, IOSTAT = IOST)
     1          IGBL(49), NAMEFIL(1 : KNMFIL)
              IGBL(1) = 4
              RETURN
C * IS = 23: HELP (SPGR)
            CASE (23)
              IF (IPR(220) > 1) THEN
                OPT = IFL(2)(1:3)
C * LIST KNOWN SPACE GROUP NAMES
                IF (OPT == 'SPG') THEN
                  CALL SGSM (14, ICL, SGY, 0, LU6, IERR)
                  GO TO 10
                END IF
              END IF
C * HELP MANUAL
              IWIN = IGBL(25) * IGBL(32)
              CALL PLA299 (1)
C * GET NEW INSTRUCTION
              RETURN
C * IS = 24: SAVE INSTRUCTION OPTION ON
            CASE (24)
              IGBL(45) = 1
              ISAVEMOD = 1
              CALL GEN108 (LU3, 0)
              GO TO 10
C * IS = 25,26: UIJ/SUIJ
            CASE (25, 26)
C * UIJ DATA & SUIJ DATA
C * INCLUDE A*,B* AND C* INTO U(I, J) BEFORE TRANSFORMATION
              CALL GEN144 (1, FN(1), PAR(135))
C * CHECK FOR SUIJ
              IF (IS == 26) THEN
                ICT = 3
                GO TO 50
              END IF
              GO TO 40
C * IS = 27, 41: U, B DATA (SHOULD INCLUDE ATOM LABEL)
            CASE (27, 41)
              IF (IS == 41) THEN
                IF (IPR(220) == 1) THEN
                  IS = 1
                  CYCLE
                END IF
                FN(1) = FN(1) / RGBL(8)
                FN(2) = FN(2) / RGBL(8)
              END IF
              IF (IPR(220) == 1) THEN
                IS = 1
                CYCLE
              END IF
              ICT = 4
              GO TO 60
C * IS = 29: LIST/INFO
            CASE (29)
C * LIST OPTION(S) ON DISPLAY (ATOMS/BONDS/SYMM/PAR/IPR/IGBL/RADII/CELL)
              IF (IFL(2)(1:3) == 'UIJ') THEN
                IF (IPR(30) == 0) THEN
                  CALL PLA280 ('CALC TMA')
                  GO TO 10
                END IF
              END IF
              IRETN = 0
              CALL PLA382 (IRETN)
              IF (IRETN /= 0) THEN
C * TEST FOR PREVIOUS CALC UNIQUE (NO = 0)
                IF (IPR(30) == 0) THEN
                  IGBL(52) = MAX (IGBL(52), IPR(23))
                  IPR(205) = 0
                END IF
                CALL PLA021 (11, NRETURN)
                RETURN
              END IF
              GO TO 10
C * IS = 30: CELL CONSTANTS
            CASE (30)
C * ASSUME A = B = C
              IF (IPR(221) == 1) THEN
                FN(2)    = FN(1)
                FN(3)    = FN(1)
                IPR(221) = 3
              END IF
C * ASSUME 90,90,90
              IF (IPR(221) == 3) THEN
                CALL GEN074 (FN, 4, 6, 90.0)
                IPR(221) = 6
              END IF
              IF (IPR(221) < 6 .OR.
     1           (IPR(221) > 7 .AND. IPR(221) /= 12)) THEN
C * NOT ENOUGH DATA ON CARD
                IPR(2) = 5
                GO TO 200
              END IF
C * TEST FOR SHELX STYLE CELL CARD
              IF (IPR(221) == 7) THEN
C * REGISTER SUPPLIED WAVELENGTH (PAR(16))
                PAR(16) = FN(1)
                PAR(17) = FN(1)
                K = 1
              ELSE
                K = 0
              END IF
              DO I = 1, 12
C * TEST CELL CARD FOR ZERO'S
                IF (I <= 3 .AND. ABS (FN(K + I)) < 2.0) THEN
                  IF (IGBL(5) == LU1) IPR(470) = 1
C * NOT ENOUGH DATA ON CARD
                  IPR(2) = 5
                  GO TO 200
                END IF
                PAR(100 + I) = FN(K + I)
              END DO
              IF (K /= 0) CALL PLA293 (FN(1))
              GO TO 10
C * IS = 31: CELL STANDARD DEVIATION (COPY)
            CASE (31)
              CALL GEN113 (FN, PAR(107), 6)
              GO TO 10
C * IS = 32: SYMM (LATT/SPGR/HALL etc.)
            CASE (32)
C * SYMM RECORDS AS (R|T)
              IF (IPR(220) == 1 .AND.
     1           (IPR(221) == 9 .OR. IPR(221) == 12)) THEN
C * SYMM MATRIX R11,R12,..,R33, (T1,T2,T3) INPUT
                IF (IPR(93) == 0) THEN
                  ITRS = 15
                  CALL SGSM (ITRS, ICL, FN,  0,  LU6, IERR)
                  CALL SGSM (18,   ICL, SGZ, 0,    0, IERR)
C * NO SUITABLE SPACE-GROUP
                  IPR(48) = NINT(SGZ(9))
C * CHECK FOR CIF-DATA
                  IF (IGBL(8) == 3) THEN
                    IF (CCIF(7)(1:1) == ' ' .AND.
     1                 CCIF(16)(1:1) == '?') THEN
C * ALERT _121
                      CALL PLA236 (121, 0, 1.0, 1.0, ICL(1:7), ' ')
                      ICL = 'SPGR P1'
                      WRITE (LU6, 99970, IOSTAT = IOST)
                      IS = 32
                      CYCLE
                    END IF
                  END IF
                ELSE
C * NO TRANS ALLOWED WITH SYMM MATRIX INPUT
                  IPR(2) = 27
                  GO TO 200
                END IF
              ELSE
C * OPTIONALLY ADD 'LATT 1' INSTRUCTION FOR COMPATIBILITY
                IF (IGBL(8) == 2) THEN
                  IF (IPR(141) == 0 .AND. IFL(1)(1:4) == 'SYMM')
     1              THEN
                    IDM = 'LATT 1'
                    CALL SGSM (0, IDM, SGY, 0, 0, IERR)
                    IPR(141) = 1
                  END IF
                END IF
C * CHECK FOR CELL TRANSFORMATION OR SHIFT
                IF (IPR(93) == 1 .OR. IPR(139) == 1) THEN
                  ITRS = 16
                ELSE
                  ITRS = 0
                END IF
                CALL SGSM (ITRS, ICL, SGY, 0, LU6, IERR)
                IF (IERR /= 0) THEN
C * PROBLEM WITH CELL TRANSFORMATION
                  IF (IERR == 14) THEN
                    IPR(2) = 66
                    GO TO 200
C * ERROR/PROBLEM IN HALL SYMBOL
                  ELSE IF (IERR == 7) THEN
C * ALERT _126
                    CALL PLA236 (126, 0, 1.0, 1.0, ICL(6:15), ' ')
                      IPR(673) = 1
                    GO TO 10
                  ELSE IF (IERR == 5) THEN
                    CALL GEN047 (ICL, 6, 16)
C * ALERT _129
                    CALL PLA236 (129, 0, 1.0, 1.0, ICL(6:12), ' ')
                    GO TO 10
                  ELSE IF (IERR == 12) THEN
                    GO TO 10
                  ELSE IF (IERR == 2) THEN
C * ALERT _119
                    CALL PLA236 (119, 0, 1.0, 1.0, ICL(6:12), ' ')
                    GO TO 10
                  ELSE
                    IPR(470) = 1
C * NOT ENOUGH DATA ON CARD
                    IPR(2) = 5
                    GO TO 200
                  END IF
                END IF
                CALL SGSM (18, ICL, SGZ, 0, 0, IERR)
                IPR(48) = NINT (SGZ(9))
                IF (IPR(48) == 0) THEN
C * CHECK FOR CIF-DATA
C * ALERT _121
                  IF (IGBL(8) == 3)
     1              CALL PLA236 (121, 0, 1.0, 1.0, ICL(1:7), ' ')
                END IF
              END IF
              IPR(141) = 1
C * HANDLE ERROR CASE
              IF (IPR(48) == 0) THEN
                IF (IGBL(5) == LU1) IPR(470) = 1
C * NOT ENOUGH DATA ON CARD
                IPR(2) = 5
                GO TO 200
              END IF
C * 'LAST-MINUTE SYMM UPDATE'
              IF (IPR(39) == 0) CALL PLA271
              GO TO 10
C * IS = 33: SPGR
            CASE (33)
C * CHECK FOR EXPLICIT SPACE GROUP INFO
              IF (IPR(220) /= 1 .OR. IPR(221) > 2) THEN
                IS = 32
C * DETERMINE SPACE GROUP FROM EXTINCTIONS
              ELSE
C * CHECK FOR REFLECTION DATA
                CALL PLA008
                IF (IGBL(15) >= 0) THEN
                  MODE = 3
                  IF (IPR(221) > 0) THEN
                    MODE = NINT (FN(1))
                    IF (IPR(221) > 1) PAR(141) = FN(2)
                  END IF
                  CALL PLA100
                  IGBL(31) = 5
C * OPEN UNIT #2
                  CALL PLA292
C * OUTPUT CELL HEADER
                  CALL PLA042 (0)
C * DETERMINE SPACEGROUP FROM EXTINCTIONS
                  CALL PLA160 (MODE, TM1)
C * ERROR HANDLING
                  IGBL(1) = 3
                  IF (IPR(3) /= 0) RETURN
                  GO TO 10
                ELSE
C * NO REFL DATA PROBLEM
                  IPR(2) = 55
                  GO TO 200
                END IF
              END IF
              CYCLE
C * IS = 34: LATT
            CASE (34)
C * SUBSTITUTE 'LATT 1' FOR 'LATT' AND 'LATT 0' IN CASE OF SHELX RES
              IF (IGBL(8) == 2) THEN
                IF (FN(1) == 0.0) ICL = 'LATT 1'
              END IF
              IS = 32
              CYCLE
C * IS = 35: DIST
            CASE (35)
              GO TO 30
C * IS = 36: ANGLE
            CASE (36)
              GO TO 30
C * IS = 37: TORSION
            CASE (37)
              GO TO 30
C * IS = 38: HBON: CHANGE H-BOND PARAMETERS FROM ORIGINAL TO NEW DEFAULTS
            CASE (38)
              IF (IPR(220) > 1 .AND. IFL(2)(1:4) == 'NORM') THEN
                IGBL(147) = 1
                IGBL(148) = 1
                IPR(87)   = 1
              ELSE
                IGBL(147) = 0
                IGBL(148) = 0
                IPR(87)   = 0
              END IF
              IF (IPR(221) > 0) THEN
                DO K = 1, IPR(221)
                  RGBL(40 + K) = FN(K)
                  RGBL(43 + K) = FN(K)
                END DO
              END IF
              GO TO 180
C * IS = 39,40: BIJ, SBIJ
            CASE (39, 40)
C * BIJ & SBIJ DATA
C * (BETA-VALUES ARE TRANSFORMED TO U-VALUES AFTER TRANSFORMATION)
              DO I = 1, 6
                FN(I) = FN(I) / RGBL(7)
              END DO
C * CHECK FOR SBIJ
              IF (IS == 40) THEN
                ICT = 3
                GO TO 50
              ELSE
                GO TO 40
              END IF
C * IS = 42: TRNS/TRMX
            CASE (42)
C * STANDARDISE ENTRIES
              CALL GEN074 (SHFT, 1, 3, 0.0)
C * MOVE/FIX ATOM CASE (accept both 3.456 and 3456.01)
              IF (IPR(221) == 1) THEN
                IF (ABS(FN(1)) > 1000.0) THEN
                  ITRNS = INT (FN(1))
                ELSE
                  ITRNS = NINT (FN(1) * 1000.0)
                END IF
C * TEST FOR SYMMETRY NUMBER IN RANGE
                IF (IABS(ITRNS) / 1000 > IPR(48)) THEN
                  IPR(2) = 15
                  GO TO 200
                END IF
                IF (ITRNS <= 0) THEN
                  IPR(95)  = ITRNS
                ELSE IF (ITRNS > 0) THEN
                  IPR(165) = ITRNS
                END IF
                GO TO 10
C * ORIGIN SHIFT ONLY
              ELSE IF (IPR(221) == 3) THEN
                CALL GEN074 (FN, 1, 9, 0.0)
                FN(1)    = 1.0
                FN(5)    = 1.0
                FN(9)    = 1.0
                IPR(139) = 1
                DO I = 1, 3
                  SHFT(I) = - FN(I)
                END DO
              ELSE IF (IPR(221) == 9) THEN
C * GET CRYSTAL SYSTEM
              ELSE IF (IPR(221) == 10 .AND. IPR(220) == 2) THEN
                ILAT0 = IFL(2)(1:1)
                IF (IFL(2)(2:2) /= ' ') ILAT1 = IFL(2)(2:2)
                CALL GEN020 (-1, ILAT0, 1, 1)
                IFN10 = NINT (FN(10))
                IF (IFN10 > 0 .AND. IFN10 < 14) THEN
                  LAUE = NLAUE(NINT(FN(10)))
                ELSE
                  LAUE = ' '
                END IF
C * TRANSLATION COMPONENT (ORIGIN SHIFT)
              ELSE IF (IPR(221) == 12) THEN
                IPR(139) = 1
                DO I = 1, 3
                  SHFT(I) = - FN(9 + I)
                END DO
C * INCORRECT NUMBER OF NUMERIC DATA ON TRMX LINE
              ELSE
                IPR(2) = 63
                GO TO 200
              END IF
C * TRANSFORMATION OF CELL AXES
              IF (IPR(39) > 0) THEN
C * INSTRUCTION NOT ALLOWED
                IPR(2) = 11
                GO TO 200
              END IF
              K = 0
              DO I = 1, 3
                SGY(9 + I) = - SHFT(I)
                DO J = 1, 3
                  K            = K + 1
                  TM1(I, J)    = FN(K)
                  SGY(K)       = FN(K)
C * TRANSFER TO SHELX-HKLF
                  PAR(230 + K) = FN(K)
                END DO
              END DO
C * CALCULATE TRANSPOSED INVERSE TM2 OF TM1
              CALL GEN003 (TM1, DUMV, DET, 0)
              IF (ABS(ABS(DET) - 1.0) > 0.001) THEN
                WRITE (LU6, 99985, IOSTAT = IOST) DET
                PAR(32) = DET
              END IF
              CALL GEN005 (DUMV, TM2)
              IPR(93) = 1
              WRITE (LU6, 99972, IOSTAT = IOST)
     1          ((TM2(I, J), J = 1, 3), SHFT(I), I = 1, 3)
              GO TO 10
C * IS = 44: PARENTHESES ON/OFF OPTION
            CASE (44)
              IPR(71) = 1
              IF (IPR(220) > 1) THEN
                IF (IFL(2)(2:2) == 'F') IPR(71) = 0
              END IF
              GO TO 180
C * IS = 46: SET OPTION(S)
            CASE (46)
C * SET - OPTION(S)
              OPT = IFL(2)(1:3)
C * (RE)SET VAN DER WAALS RADII
              IF (OPT == 'VDW') THEN
                IF (IPR(220) > 2 .AND. IPR(221) == IPR(220) - 2)
     1            THEN
                  DO I = 3, IPR(220)
                    CALL PLA037 (I, NID, 2)
                    IF (NID > 0) RADR(NID, 4) = FN(I - 2)
                  END DO
                END IF
                IF (IGBL(5) == LU5) CALL PLA280 ('LIST RADII')
C * SET RANGE (FOR POLY)
              ELSE IF (OPT == 'RAN') THEN
                IF (IPR(221) == 6) THEN
                  IPR(354) = 0
                  DO I = 1, 6
                    PAR(200 + I) = FN(I)
                  END DO
C * SET OMIT RANGE (POLY)
              ELSE IF (OPT == 'OMI') THEN
                ELSE IF (IPR(221) == 6) THEN
                  IPR(356) = 0
                  DO I = 1, 6
                    PAR(206 + I) = FN(I)
                  END DO
                END IF
C * SET TETR (POLY)
              ELSE IF (OPT == 'TET') THEN
                DO I = 1, 4
                 IF (FN(I) /= 0.0) PAR(213 + I) = FN(I)
                END DO
C * SET OCTA (POLY)
              ELSE IF (OPT == 'OCT') THEN
                DO I = 1, 4
                  IF (FN(I) /= 0.0) PAR(217 + I) = FN(I)
                END DO
C * SET LABEL SIZE
              ELSE IF (OPT == 'LAB') THEN
                IF (IPR(220) == 3 .AND. IFL(3)(1:1) == 'S') THEN
                  WRITE (LU6, 99994, IOSTAT = IOST) PAR(349)
                  IF (IPR(221) == 1) THEN
                    PAR(349) = FN(1)
                    WRITE (LU6, 99993, IOSTAT = IOST) PAR(349)
                  END IF
                END IF
C * SET PRINTER LEVEL (0,1,2,3,4)
              ELSE IF (OPT == 'PRI') THEN
                IF (IPR(220) == 3) THEN
C * LEVEL
                  IF (IFL(3)(1 : 1) == 'L') THEN
                    IF (IPR(221) > 0) THEN
                      IGBL(64) = NINT (FN(1))
                      IGBL(63) = IGBL(64)
                    END IF
                  END IF
                END IF
C * SET REVERSE (IGBL(68) = (0/1) REVERSE TOGGLE
              ELSE IF (OPT == 'REV') THEN
                IGBL(68) = MOD (IGBL(68) + 1, 2)
                CALL GGIP (-999.0, FLOAT (IGBL(68)), IGBL(62) * 0.25, 9)
C * SET IPR/PAR/IGBL/RGBL
              ELSE IF (IPR(221) == 2 .AND. IPR(220) == 2) THEN
                CALL PLA206 (1, OPT)
C * SET PROBABILITY (10 <--> 90 PERCENT)
              ELSE IF (IPR(221) == 1 .AND. IPR(220) == 2) THEN
                IF (OPT == 'PRO') THEN
                  IPR(45)  = MAX (1, MIN (9, NINT (FN(1) / 10)))
C * RESET LABEL POSITIONING STATUS
                  IPR(201) = 0
C * SET WINDOW FRACTION
                ELSE IF (OPT == 'WIN') THEN
                 CALL GGIP (-999.0, FLOAT (IGBL(68)), FN(1) * 1000.0, 9)
                 IGBL(62) = MIN (MAX (1, NINT (FN(1) / 0.25)), 4)
                END IF
              ELSE IF (IPR(220) == 3) THEN
                SELECT CASE (OPT)
C * SET BEEP ON/OFF
                  CASE ('BEE')
                    MEDIUM = 0
C * SET DISPLAY TYPE
                  CASE ('DIS')
                    MEDIUM = 1
C * SET META TYPE
                  CASE ('MET')
                    MEDIUM = 2
                END SELECT
                IF (IPR(220) > 2) CALL GGIP (-999.0, 0.0, 0.0, 6)
              END IF
              GO TO 180
C * IS = 48: SFAC CARD (SHELX) OR IS = 172: SCAT
            CASE (48, 172)
C * ADD 'LATT 1' FOR COMPATIBILITY
              IF (IPR(141) == 0 .AND. IGBL(8) == 2) THEN
                IDM = 'LATT 1'
                CALL SGSM (0, IDM, SGY, 0, 0, IERR)
                IPR(141) = 1
C * 'LAST-MINUTE SYMM UPDATE'
                CALL PLA271
              END IF
              M = IPR(221)
C * LOAD SFAC LABEL TYPE DATA INTO IEN
              IF (IPR(220) > 1) THEN
                DO I = 2, IPR(220)
                  NCHAR = 0
C * SEARCH FOR UPPERCASE CHARACTER ASCII NUMBER
                  CALL GEN105 (1, IFL(I)(1:1), N)
                  IF (N > 0) NCHAR = (N - ICHAR ('A') + 1) * 100
C * SEARCH FOR UPPERCASE CHARACTER ASCII NUMBER
                  CALL GEN105 (1, IFL(I)(2:2), N)
                  IF (N > 0) NCHAR = NCHAR + N - ICHAR ('A') + 1
C * REGISTER FOR ELEMENT 'HO'
                  IF (NCHAR == 815) IPR(435) = 1
                  IUNKNOWN = 1
                  DO J = 1, NP9
                    IF (IEL(J) == NCHAR) THEN
                      IAN          = IAN + 1
                      IEN(IAN)     = J
                      RADR(IAN, 3) = REL(J)
                      RADR(IAN, 4) = ABS (VDWR(J))
                      IF (IFL(I)(2:2) == ' ') THEN
                        LMT(IAN, 1) = ' '//IFL(I)(1:1)
                      ELSE
                        LMT(IAN, 1) = IFL(I)(1:2)
C * TRANSFORM 2nd CHAR to LOWERCASE
                        CALL GEN020 (-1, LMT(IAN, 1), 2, 2)
                      END IF
                      LMT(IAN, 2) = JTP(IABS (IATPR(J)))
C * ASSIGN COLORS FOR SHELX
                      IF (J == 3) THEN
                        IACL(IAN) = 2
                      ELSE IF (J == 4) THEN
                        IACL(IAN) = 4
                      ELSE IF (IATPR(J) == -7) THEN
                        IACL(IAN) = 3
                      ELSE IF (J > 2) THEN
                        IF (ICLR < 8) ICLR = ICLR + 1
                        IACL(IAN) = ICLR
                      END IF
                      IUNKNOWN = 0
                    END IF
                  END DO
C * CATCH UNKNOWN ELEMENT TYPE CASE
                  IF (IUNKNOWN == 1) THEN
                    IPR(2) = 41
                    GO TO 200
                  END IF
                END DO
C * CHECK FOR NEUTRON SCATTERING
                IF (IPR(220) == 2 .AND. IPR(221) > 0
     1            .AND. FN(1) == 0.0) IPR(493) = 7
              END IF
              GO TO 10
C * IS = 51: VIEW CARD(S)
            CASE (51)
C * VIEW MIN
              IF (IFL(2)(1:3) == 'MIN') THEN
C * RESET LABEL POSITIONING STATUS
                IPR(201) = 0
                IGBL(67) = 0
              ELSE
C * VIEW (XR xr YR yr ZR zr)
                N = 1
                IF (IPR(220) == 1) THEN
                  CALL PLA226 (0, 0.0)
                ELSE
C * GENERATE UNIT MATRIX (DET = IGBL(87))
                  CALL GEN021 (RMAT, FLOAT (IGBL(87)))
C * RECREATE ORIENTATION MATRIX
                  DO L = 1, 3
                    CALL GEN051 (0, RMAT, - RGBL(27 + L) / RGBL(6), L)
                  END DO
                  DO I = 2, IPR(220)
                    SELECT CASE (IFL(I)(1:3))
C * UNIT
                      CASE ('UNI')
                        CALL PLA226 (0, 0.0)
C * INVERT
                      CASE ('INV')
                        CALL PLA226 (-4, 0.0)
C * XROT
                      CASE ('XR ', 'XRO')
                        CALL PLA226 (-1, - FN(N) / RGBL(6))
                        N = N + 1
C * YROT
                      CASE ('YR ', 'YRO')
                        CALL PLA226 (-2, - FN(N) / RGBL(6))
                        N = N + 1
C * ZROT
                      CASE ('ZR', 'ZRO')
                        CALL PLA226 (-3, - FN(N) / RGBL(6))
                        N = N + 1
                    END SELECT
                  END DO
                END IF
              END IF
              GO TO 180
C * IS = 52: BOX ON/OFF (1/0)
            CASE (52)
              IF (IPR(220) > 1) THEN
                DO I = 2, IPR(220)
                  SELECT CASE (IFL(I)(1:3))
C * BOX OFF
                    CASE ('OFF')
                      IGBL(103) = 0
C * BOX ON
                    CASE ('ON ')
                      IGBL(103) = 1
C * BOX RATIO
                    CASE ('RAT')
                      PAR(50) = FN(1)
                  END SELECT
                END DO
              END IF
              GO TO 180
C * IS = 56: GEOM
            CASE (56)
              GO TO 30
C * IS = 59: INFO
            CASE (59)
              IS = 29
              CYCLE
C * IS = 60: TABLE OPTION
            CASE (60)
C * TEST FOR PREVIOUS CALC UNIQUE (NO = 0)
              IF (IPR(30) /= 0) THEN
                IPR(2) = 31
                GO TO 200
              END IF
              IPR(430) = 1
C * REPORT NO-ESD STATUS
              IF (IPR(72) == 0) WRITE (LU6, 99966, IOSTAT = IOST)
C * SET NHATOM
              IPR(454) = 1
C * SET RES
              IPR(240) = 1
C * SET PARENTHESES TO NO
              IPR(71) = 0
              IF (IPR(220) > 1) THEN
                DO I = 2, IPR(220)
                  SELECT CASE (IFL(I)(1:3))
C * NO-HATOM
                    CASE ('NHA')
                      IPR(454) = 0
C * RESIDUE SORT/LISTING (NORES)
                    CASE ('NOR')
                      IPR(240) = 0
                    CASE ('SUP')
C * SU  (FULL SUPPLEMENTARY MATERIAL)
                      IPR(431) = 1
                    CASE ('ACC', 'CIF')
C * ACC (ACTA CRYST C - CIF) - NOPARENTHESES
                      IPR(430) =  1
C * ACC-CIF
                      IPR(431) = -1
                      IGBL(31) = 8
C * LOCAL
                    CASE ('LOC')
                      IPR(399) = 1
                  END SELECT
                END DO
              END IF
C * DO A CALC OMEGA CALCULATION WHEN NECESSARY (NO = 0)
              IF (IPR(30) == 0) THEN
                IPR(220)  = 2
                IFL(2)    = 'OMEGA'
                GO TO 100
              ELSE
C * EXECUTE TABLE OPTIONS
                IF (IPR(430) > 0) THEN
                  IPR(31)  = -1
                  IPR(17)  = -1
                  IPR(90)  =  1
                  IGBL(63) =  0
C * SET UP CONNECTED SET
                  CALL PLA067
                  IF (IPR(2) /= 0) RETURN
                  CALL PLA171
                  IPR(1) = 1
                  IF (IPR(2) == 0) IPR(2) = -1
C * ERROR HANDLING
                  IGBL(1) = 3
                  RETURN
                END IF
                RETURN
              END IF
              GO TO 10
C * IS = 61: RADII BONDS ((LIST/NORMAL/TO H/TO MET/ALL) (#lines (radius)))
            CASE (61)
              JB = 0
              JE = 0
              DO I = 3, IPR(220)
                SELECT CASE (IFL(I)(1:3))
C * RADII BONDS TO H
                  CASE ('H  ')
                    JB = 3
                    JE = 3
C * RADII BONDS TO METAL
                  CASE ('MET')
                    JB = 5
                    JE = 5
C * NORMAL
                  CASE ('NOR')
                    JB = 1
                    JE = 1
                  CASE ('ALL')
                    JB = 1
                    JE = 5
                  CASE DEFAULT
                    CYCLE
                END SELECT
                DO J = JB, JE, 2
                  IF (IPR(221) > 0) THEN
                    IF (ABS (FN(1)) > 5.0) FN(1) = SIGN (5.0, FN(1))
                    PAR(84 + J) = FN(1)
                  END IF
                  IF (IPR(221) > 1) PAR(85 + J) = FN(2)
                END DO
                IF (.TRUE.) EXIT
              END DO
C * LIST BOND RADII
              WRITE (PRBUF, 99977, IOSTAT = IOST)
              IF (IWIN == 1) THEN
                CALL GGIP (HORS, VERT, 0.0, 1)
                VRT = VERT - 3.0
                CALL PLA439 (0.0, PRBUF, 75, 0.35, 5 + IGBL(68), 2,
     1             1.0, VRT)
              ELSE
                WRITE (LU6, 99991, IOSTAT = IOST) PRBUF(1:75)
              END IF
              WRITE (PRBUF, 99976, IOSTAT = IOST)
     1          NINT (PAR(85)), 2**NINT (ABS (PAR(85)) - 1) + 1, PAR(86)
              IF (IWIN == 1) THEN
                VRT = VRT - 1.5
                CALL PLA439 (0.0, PRBUF, 75, 0.35, 1, 2, 1.0, VRT)
              ELSE
                WRITE (LU6, 99991, IOSTAT = IOST) PRBUF(1:75)
              END IF
              WRITE (PRBUF, 99975, IOSTAT = IOST)
     1          NINT(PAR(87)), 2**NINT (ABS (PAR(87)) - 1) + 1, PAR(88)
              IF (IWIN == 1) THEN
                VRT = VRT - 1.5
                CALL PLA439 (0.0, PRBUF, 75, 0.35, 1, 2, 1.0, VRT)
              ELSE
                WRITE (LU6, 99981, IOSTAT = IOST) PRBUF(1:75)
              END IF
C * TEST FOR METAL CONTAINING COMPOUND
              IF (IPR(155) > 0) THEN
                WRITE (PRBUF, 99974, IOSTAT = IOST) NINT (PAR(89)),
     1            2**NINT (ABS (PAR(89)) - 1) + 1, PAR(90)
                IF (IWIN == 1) THEN
                  VRT = VRT - 1.5
                  CALL PLA439 (0.0, PRBUF, 75, 0.35, 1, 2, 1.0, VRT)
                ELSE
                  WRITE (LU6, 99981, IOSTAT = IOST) PRBUF(1:75)
                END IF
              END IF
              IF (IWIN == 1) CALL PLA297 (1)
              GO TO 180
C * IS = 63: MENU (ON/OFF)
            CASE (63)
              IF (IPR(220) == 2 .AND. IFL(2)(1:3) == 'OFF') THEN
                IGBL(25) = 0
              ELSE
                IGBL(25) = 1
                IF (IGBL(6) < 10 .OR. IGBL(6) > 12)
     1            CALL PLA280 ('PLOT')
              END IF
              GO TO 10
C * IS = 64: OMIT CARD
            CASE (64)
C * CHECK FOR QUOTE COMMENT
              IF (IGBL(8) == 2) IPR(220) = 1
              N = IPR(220)
              IF (N > 1) THEN
C * TEST FOR PREVIOUS CALC UNIQUE (NO = 0)
                IF (IPR(30) == 0) THEN
                  IF (IPR(37) == 0) THEN
                    IPR(2) = 42
                    GO TO 200
                  END IF
                  IGBL(52) = MAX (IGBL(52), IPR(23))
                  CALL PLA287 (0, 1, 0)
                END IF
                DO I = 2, N
                  CALL PLA046 (2, IFL(I), IENM, LBB, LBC, LBD,
     1                            INQNR, JNQNR, NR)
                  IF (NR > 0) THEN
                    CALL GEN048 (1, IFG(1, NR), 30, 1)
                  ELSE
                    WRITE (LU6, 99995) ICL(1:50)
                    CALL PLA015 (0, 28)
                  END IF
                END DO
              ELSE
                M = IPR(221)
C * SHELXL/RES THETA-MAX
                IF (M == 2) THEN
                  PAR(165) = FN(2) / 2.0
                  IGBL(8)  = 2
C * OMIT REFECTIONS + SYMMETRY RELATED ONE'S
                ELSE IF (M == 3) THEN
                  NSMR = IPR(255) * IPR(257)
                  IF (IPR(620) + NSMR  <= NP62) THEN
                    DO J = 1, NSMR
                      DO K = 1, 3
                        SGY(K) = FN(K)
                      END DO
                      CALL SGSM (5, IDM, SGY, J, 0, IERR)
                      IPR(620) = IPR(620) + 1
                      DO I = 1, 3
                        IHKLOMIT(I, IPR(620)) = NINT (SGY(I + 6))
                      END DO
C * AVOID DUPLICATIONS
                      IF (IPR(620) > 1) THEN
                        DO K = 1, IPR(620) - 1
                          IYUNK = 0
                          DO L = 1, 3
                            IYUNK = IYUNK
     1                            + IABS (IHKLOMIT(L, IPR(620))
     2                            -       IHKLOMIT(L, K))
                          END DO
                          IF (IYUNK == 0) THEN
                            IPR(620) = IPR(620) - 1
                            EXIT
                          END IF
                        END DO
                      END IF
                    END DO
                  END IF
                END IF
              END IF
              GO TO 10
C * IS = 67: JOIN ATOMS
            CASE (67)
              IPR(785) = 1
              CALL PLA021 (7, NRETURN)
              IF (NRETURN == 0) THEN
                RETURN
              ELSE IF (NRETURN == 1) THEN
                GO TO 10
              END IF
C * IS = 68: DETACH ATOMS
            CASE (68)
              IPR(785) = -1
              CALL PLA021 (7, NRETURN)
              IF (NRETURN == 0) THEN
                RETURN
              ELSE IF (NRETURN == 1) THEN
                GO TO 10
              END IF
C * IS = 69: DEFINE SUBSTITUTE BOND
            CASE (69)
              IPR(785) = -1
              CALL PLA021 (7, NRETURN)
              IF (NRETURN == 0) THEN
                RETURN
              ELSE IF (NRETURN == 1) THEN
                GO TO 10
              END IF
C * IS = 70: HKLF - LINE
            CASE (70)
              CALL PLA100
              IPR(648) = NINT (FN(1))
              PAR(573) = 1.0
              IF (IPR(221) >= 11) THEN
                DO K = 1, 9
                  I        = ((K - 1) / 3)  + 1
                  J        = MOD (K - 1, 3) + 1
                  QQ(I, J) = FN(K + 2)
                END DO
                IF (FN(12) /= 0.0 .AND. FN(12) /= 1.0) THEN
                  PAR(573) = FN(12)
                END IF
              ELSE
                CALL GEN021 (QQ, 1.0)
              END IF
C * APPLY TRNS/TRMX ON HKLF-TRNS
              CALL GEN004 (TM1, QQ, DUMV)
              K = 0
              DO I = 1, 3
                DO J = 1, 3
                  K = K + 1
                  PAR(230 + K) = DUMV(I, J)
                END DO
              END DO
              WRITE (LU6, 99968, IOSTAT = IOST) (PAR(230 + I), I = 1, 9)
C * GET INVERSE AND DETERMINANT  OF TRANSFORMATION MATRIX
              CALL GEN003 (DUMV, QQ, DET, 0)
              PAR(240) = DET
              IF (ABS (ABS (DET) - 1.0) > 0.001)
     1          WRITE (LU6, 99980, IOSTAT = IOST) DET
              IF (DET < 0.0) THEN
                IPR(2) = 40
                GO TO 200
              END IF
C * APPLY TRANSVERSE AXES TRANSFORMATION
              CALL GEN001 (1, QQ, AA, RAA)
C * GET TRANSFORMED DIRECT AXIS PARAMETERS
              CALL GEN026 (-1, RAA, PAR(241))
C * GET INVERSE TRANSFORMED METRIC
              CALL GEN003 (RAA, RBB, DET, 0)
C * CALL EXIT/STOP
              IF (DET <= 0.0)
     1         CALL GEN127 ('CANNOT INVERT METRICAL MATRIX')
C * GET TRANSFORMED RECIPROCAL AXIS PARAMETERS
              CALL GEN026 (-1, RBB, PAR(135))
              WRITE (LU6, 99969, IOSTAT = IOST) (PAR(100 + I), I = 1, 6)
     1                        ,(PAR(240 + I), I = 1, 6)
              CALL GEN025 (RBB, PAR(391), 1)
C * LOOK FOR REFLECTION DATA
              IF (NINT(FN(1)) == 4) CALL PLA008
              IF (NINT(FN(1)) == 5) CALL PLA008
              GO TO 10
C * IS = 71: RADN LINE
            CASE (71)
              CALL PLA293 (FN(1))
              GO TO 10
C * IS = 72: TRMX
            CASE (72)
              IS = 42
              CYCLE
C * IS = 74: INORG (FORCE INORGANIC MODE)
            CASE (74)
              IGBL(97) = 0
              GO TO 10
C * IS = 75: ORGA (FORCE ORGANIC MODE)
            CASE (75)
              IGBL(97) = 1
              GO TO 10
C * IS = 78: ENTRY (CSD/CIF ETC.-FILE ENTRY)
            CASE (78)
              CALL PLA007
              IF (ICL(1:4) == 'END ') GO TO 190
              GO TO 10
C * IS = 79: ELLIPSOID PARAMETERS
            CASE (79)
              IF (IPR(220) > 1) THEN
                SELECT CASE (IFL(2)(1:3))
                  CASE ('C  ')
                    N = 175
                  CASE ('H  ')
                    N = 177
                  CASE ('OTH')
                    N = 179
                END SELECT
                IF (IPR(221) > 1) THEN
                  IPR(N)     = MAX (0, MIN (1, NINT (ABS (FN(1)))))
                  IPR(N + 1) = NINT (ABS (FN(2)))
                END IF
              END IF
              WRITE (LU6, 99964, IOSTAT = IOST) (IPR(174 + I), I = 1, 6)
              GO TO 10
C * IS = 80: ORMA - CAD4 ORIENTATION MATRIX (Reciprocal Axes)
            CASE (80)
              IF (IPR(221) == 9) THEN
                DO I = 1, 9
                  PAR(180 + I) = FN(I)
                  J = MOD (I - 1, 3) + 1
                  K = ((I - 1) / 3)  + 1
                  DAM(J, K)    = FN(I)
                END DO
                CALL GEN003 (DAM, DUMV, DET, 0)
C * CALL EXIT/STOP
                IF (DET <= 0.0) CALL GEN127 ('CANNOT INVERT ORMA')
                WRITE (LU6, 99965, IOSTAT = IOST) 1.0 / DET
                IPR(16) = 1
              ELSE
C * NOT ENOUGH DATA ON CARD
                IPR(2) = 5
                GO TO 200
              END IF
              GO TO 10
C * IS = 82: SETUP (EXOR.BIN)
            CASE (82)
              IF (IABS (IGBL(8)) == 2) THEN
                CALL PLA151 (0)
                GO TO 210
              ELSE
                GO TO 10
              END IF
C * IS = 83: EXOR
            CASE (83)
              IF (IABS (IGBL(8)) == 2) THEN
                CALL PLA151 (1)
                GO TO 210
              ELSE
                GO TO 10
              END IF
C * IS = 84: ABSG(AUSS)
            CASE (84)
              IPR(78) = 2
              CALL PLA186
C * ERROR HANDLING
              IGBL(1) = 3
              RETURN
C * IS = 85: FACE CARD
            CASE (85)
C * TEST FOR DIST >= 0.0
              IF (FN(4) <= 0) THEN
                IPR(2) = 34
                GO TO 210
              END IF
C * TEST FOR PRE-OCCURRENCE
              IF (NFACES > 0) THEN
                DO I = 1, NFACES
                  DIFF = 0.0
                  DO J = 1, 3
                    DIFF = DIFF + ABS (PMILL(I, J) - FN(J))
                  END DO
                  IF (DIFF < 0.001) GO TO 10
                END DO
              END IF
              IPR(367) = IPR(367) + 1
              NFACES   = IPR(367)
              DO J = 1, 4
                PMILL(NFACES, J) = FN(J)
              END DO
              PMILL(NFACES, 5) = FN(4)
              GO TO 10
C * IS = 86: ABST(OMPA) (de MEULENAER-TOMPA)
            CASE (86)
              IPR(78) = 3
              CALL PLA186
C * ERROR HANDLING
              IGBL(1) = 3
              RETURN
C * IS = 87: ABSXTAL
            CASE (87)
              PAR(162) = FN(1)
              IPR(78)  = 1
              GO TO 70
C * IS = 88: LEPAGE METRICAL SYMMETRY ANALYSIS
            CASE (88)
              IPR(94) = 2
              IGBL(6) = 20
              IPR(2)  = -1
C * -L1 SWITCH OPTION
              IF (IGBL(3) == 52) THEN
                IPR(504) = 2
                PAR(441) = 0.01
                PAR(439) = 0.01
              ELSE
                IF (IPR(220) > 1) THEN
                  IF (IFL(2) == 'SHELX') IPR(504) = 2
                END IF
                IF (FN(1) /= 0.0) PAR(441) = FN(1)
                IF (FN(2) /= 0.0)
     1            IPR(94)  = MAX (2, MIN (10, NINT(FN(2))))
                IF (FN(3) /= 0.0) PAR(439) = FN(3)
              END IF
C * UNIT CELL CALCULATIONS
              CALL PLA100
C * GET SPACE GROUP INFO
              CALL SGSM (18, ICL, SGY, 0, 0, IERR)
C * CALL LEPAGE
              CALL PLA164 (0, 0, ICL(13:13), TM1, PAR(439), ' ')
              CALL GEN038 (ICL, 1, 80)
C * GET NEW INSTRUCTION
              RETURN
C * IS = 89: ASYM
            CASE (89)
              MODE = 0
              IF (PAR(168) > 0.0) THEN
C * ASYM VALID
                IF (IPR(220) > 1) THEN
                  IF (IFL(2)(1:5) == 'VALID') THEN
                    IFL(4) = IFL(2)
                    MODE   = 2
C * ASYM AVF VALID or ASYM VALID AVF => MODE = 2
                  ELSE IF (IPR(220) == 3) THEN
                    IF (IFL(2)(1:3) == 'AVF' .AND.
     1                  IFL(3)(1:5) == 'VALID') THEN
                      MODE = 2
                    ELSE IF (IFL(2)(1:5) == 'VALID' .AND.
     1                   IFL(3)(1:3) == 'AVF') THEN
                      MODE = 2
                    END IF
C * GET EXPECTED NUMBER OF REFLECTIONS
                  ELSE IF (IFL(2)(1:6) == 'EXPECT') THEN
                    MODE = 1
                  END IF
                END IF
              END IF
              IF (MODE == 3) THEN
                IGBL(22) = -1
                MODE     = 1
                CALL PLA145 (MODE)
                MODE = 3
                REWIND (UNIT = LU13, IOSTAT = IOST)
              END IF
              CALL PLA145 (MODE)
              IF (IPR(2) == 0) IPR(2) = -14
C * ERROR HANDLING
              IGBL(1) = 3
              RETURN
C * IS = 90: ABSPSI
            CASE (90)
              CALL PLA008
              IF (IGBL(37) == 0) THEN
                IPR(2)  = 56
C * ERROR HANDLING
                IGBL(1) = 3
                RETURN
              END IF
              PAGET   = 'ABSPSI'
              IPR(78) = 4
              GO TO 70
C * IS = 91: ABSSPHERE
            CASE (91)
              IPR(78) = -1
              GO TO 70
C * IS = 92: CONTOUR-PLOTS
            CASE (92)
              CALL PLA250
              IF (IPR(2) /= 0) THEN
C * ERROR HANDLING
                IGBL(1) = 3
                RETURN
              END IF
              IF (IGGT(1:4) == 'EXIT') THEN
C * ERROR HANDLING
                IGBL(1) = 3
                RETURN
              END IF
              IF (IGBL(3) >= 19 .AND. IGBL(3) <= 22) THEN
C * ERROR HANDLING
                IGBL(1) = 3
                RETURN
              ELSE
C * RESTART
                IGBL(54) = IGBL(54) - 1
                CALL PLA280 ('RESTART')
              END IF
              GO TO 10
C * IS = 93: RESTART
            CASE (93)
              CALL GEN108 (LU1,  0)
              REWIND (UNIT = LU2, IOSTAT = IOST)
              IF (IOST /= 0) CALL GEN148 (LU2, 1)
              CALL GEN108 (LU20, 0)
              IF (IABS (IGBL(8)) == 3) IGBL(8) = 3
              WRITE (LU6, 99967, IOSTAT = IOST)
C * RESTART (FOR NEW) DATASET
              IGBL(1) = 1
              RETURN
C * IS = 94: VALIDATION CHECK MODE (FOR ACTA CRYST ETC)
            CASE (94)
C * CHECK MODE ON  (NOMOVE CASE)
              IF (IGBL(30) == 1) THEN
                IGBL(146) = 0
                IF (IPR(220) > 1) THEN
                  IF (IFL(2)(1:5) == 'TABSF') THEN
                    IGBL(146) = 0
                  ELSE IF (IFL(2)(1:5) == 'CIFSF') THEN
                    IGBL(146) = 1
                    WRITE (LU6, 99962) 'CIF'
                  ELSE IF (IFL(2)(1:5) == 'RESSF') THEN
                    IGBL(146) = 2
                    WRITE (LU6, 99962) 'RES'
                  END IF
                END IF
                IPR(220) = 1
C * SET FOR ATOM LABELS WITHOUT ()
                IPR(71)  = 0
C * SET IUCR CHECK MODE
                IGBL(36) = 1
                LINE = NAMEFIL(1:KNMFIL)//'.chk'
                WRITE (LU6, 99997, IOSTAT = IOST) LINE
C * PRINTER LEVEL 0
                IGBL(64) = 0
                IGBL(63) = IGBL(64)
C * VALIDATION DISPLAY ON
                IGBL(66) = 1
                IGBL(3)  = 1
C * LIMIT VOID SEARCH
                GO TO 100
              ELSE
                CALL PLA015 (0, 47)
                IGBL(3) = 0
              END IF
              GO TO 10
C * IS = 95: EXPT - CALCULATE EXPECTED NUMBER OF REFLECTIONS
            CASE (95)
              CALL PLA086 (LU6)
              CALL PLA086 (LU7)
C * ERROR HANDLING
              IGBL(1) = 3
              RETURN
C * IS = 96: PLUTON
            CASE (96)
C * PLUTON/PLOT - TEST FOR 'PLUTON' OR 'PLUTON/RENAME' SHORTCUT
              IF (IFL(2)(1:3) == 'NAT') IGBL(3) = 8
              IF (IGBL(3) == 8) THEN
                CALL PLUTON (-1)
C * TERMINATE JOB
                IGBL(1) = 4
                RETURN
              END IF
              IFL(2)   = IFL(1)
              IPR(220) = 2
              GO TO 80
C * IS = 146: HALL
            CASE (146)
              IS = 32
              CYCLE
C * IS = 148: MULABS
            CASE (148)
              CALL PLA008
              IF (IPR(220) > 1) THEN
                DO I = 2, IPR(220)
                  IF (IFL(I)(1:5) == 'LIST')    IGBL(57) = 1
                  IF (IFL(I)(1:7) == 'NOCHECK') IPR(363) = 0
                END DO
              END IF
              IF (IGBL(37) == 0) THEN
                IPR(2)  = 56
C * ERROR HANDLING
                IGBL(1) = 3
                RETURN
              END IF
              IPR(78) = -2
              CALL PLA100
              CALL PLA042 (1)
              PAGET = 'MULABS'
              CALL PLA190
              IF (IPR(2) == 0) IPR(2) = -4
C * ERROR HANDLING
              IGBL(1) = 3
              RETURN
C * IS = 149: HKLFTRANS
            CASE (149)
              IF (IABS(IGBL(8)) == 2) THEN
                CALL PLA042 (1)
                CALL PLA330
                IF (IPR(2) == 0) IPR(2) = -15
              ELSE
                IPR(2) = 72
              END IF
C * ERROR HANDLING
              IGBL(1) = 3
              RETURN
C * IS = 150: XTAL-HABIT PLOT
            CASE (150)
              IPR(78) = 0
              CALL PLA186
C * TERMINATE JOB
              IGBL(1) = 4
              RETURN
C * IS = 151: HINCLUDE (ORTEP)
            CASE (151)
              DO I = 2, IPR(220)
                CALL PLA046 (3, IFL(I), IENM, LBB, LBC, LBD,
     1                          INQNR, JNQNR, N1)
                CALL GEN048 (1, IFG(2, N1), 12, 1)
              END DO
              GO TO 180
C * IS = 152: HEXCLUDE (ORTEP)
            CASE (152)
              DO I = 2, IPR(220)
                CALL PLA046 (3, IFL(I), IENM, LBB, LBC, LBD,
     1                          INQNR, JNQNR, N1)
                CALL GEN048 (1, IFG(2, N1), 12, 0)
              END DO
              GO TO 180
C * IS = 153: FILE
            CASE (153)
              CALL PLA004 (1)
              IGBL(8)  = 0
              IGBL(19) = 1
              M        = 1
              N        = 0
              CALL GEN039 (0, ICL, 5, 80, M, N)
              FILENAMES(1) = ICL(M:N)
              CALL PLA261 (IGBL(19))
C * INIT & FILE OPEN
              IGBL(1) = -1
              RETURN
C * IS = 154: RENAME (RES)
            CASE (154)
              IF (IABS(IGBL(8)) == 2) THEN
C * SET PLUTON/RENAME
                IGBL(3)   = 12
C * SET DISPLAY ALL LABELS
                IGBL(105) = 1
                CALL PLUTON (-1)
C * TERMINATE JOB
                IGBL(1) = 4
                RETURN
              ELSE
                CALL PLA015 (427, 40)
              END IF
              GO TO 10
C STRIP_END
C * IS = 156: DELAUNEY REDUCTION
            CASE (156)
              IF (IPR(221) > 0) THEN
                PAR(382) = FN(1)
                IF (IPR(221) == 2) PAR(381) = FN(2)
              END IF
              CALL PLA100
C * GET SPACE GROUP INFO
              CALL SGSM (18, ICL, SGY, 0, 0, IERR)
              CALL PLA265 (ICL(13:13), LU7)
C * GET NEW INSTRUCTION
              RETURN
C * IS = 157: EXPAND ASYMMETRIC UNIT CONTENTS TO P1
            CASE (157)
              CALL PLA208
C * ERROR HANDLING
              IGBL(1) = 3
              RETURN
C * IS = 158: ARU
            CASE (158)
              CALL PLA295
              GO TO 10
C * IS = 159: ANALYSIS OF VARIANCE
            CASE (159)
              IGBL(66) = 1
              NOPT = -1
              CALL PLA405 (0, NOPT)
C * ERROR HANDLING
              IGBL(1) = 3
              RETURN
C * IS = 160: FCF2HKL
            CASE (160)
C * LU25 MIGHT BE OPEN DUE TO EMBEDDED HKL
              IF (IPR(664) /= 0) THEN
                CLOSE (LU25, STATUS = 'DELETE', IOSTAT = IOST)
                IPR(664) = 0
              END IF
              OPEN (LU61, FILE = NAMEFIL(1:KNMFIL)//'_sx.hkl',
     1          STATUS = 'UNKNOWN', IOSTAT = IOST)
              CALL PLA139 (LU6, LU16, LU61, IPR(384))
              CLOSE (UNIT = LU61)
              IF (IPR(2) == 0) IPR(2) = -16
C * TERMINATE JOB
              IGBL(1) = 4
              RETURN
C * IS = 161: PORTRAIT
            CASE (161)
              IGBL(46) = MOD (IGBL(46) + 1, 2)
              PAR(50)  = (4.0 - IGBL(46)) / 3.0
              NN       = 4 - IGBL(46) * 8
              CALL GGIP (-999.0, 0.0, 0.0, NN)
              GO TO 10
C * IS = 162: SIMULATED POWDER-PATTERN
            CASE (162)
              CALL PLA113
C * TERMINATE JOB
              IF (IGBL(3) == 31) IGBL(1) = 4
              RETURN
C * IS = 163: FSUM
            CASE (163)
              GO TO 10
C * IS = 164: SCAL
            CASE (164)
              IS = 1
              CYCLE
C * IS = 165: CRYS
            CASE (165)
              IS = 1
              CYCLE
C * IS = 166: TWINROTMAT
            CASE (166)
              CALL PLA405 (1, NOPT)
C * ERROR HANDLING
              IGBL(1) = 3
              RETURN
C * IS = 167: CAVITY
            CASE (167)
              PAR(571) = 0.025
              IF (IPR(221) > 0) THEN
C * OVERRULE MINIMUM CAVITY RADIUS DEFAULT (1.2)
                PAR(519) = MAX (0.3, FN(1))
                IF (IPR(221) > 1) PAR(520) = MAX (5.0, FN(2))
              END IF
C * TEST FOR PREVIOUS CALC UNIQUE (NO = 0) ==> SETUP CONNECTED SET
              IF (IPR(30) == 0) CALL PLA067
C * RUN CAVITY TOOL
              IF (IPR(2)  == 0) CALL PLA207
C * RESTART
              CALL PLA280 ('RESTART')
              GO TO 10
C * IS = 168: SHXABS
            CASE (168)
              IF (IPR(221) > 0) THEN
                PAR(417) = FN(1)
                IF (IPR(221) > 1) THEN
                  PAR(418) = FN(2)
                  IF (IPR(221) > 2) THEN
                    IYUNK = NINT (FN(3))
                    IF (IYUNK <= 8 .AND. MOD (IYUNK, 2) == 0) THEN
                      IPR(523) = IYUNK
                    END IF
                    IF (IPR(221) > 3) THEN
                      IYUNK = NINT (FN(4))
                      IF (IYUNK == 0 .OR.
     1                  (IYUNK < 8 .AND. MOD (IYUNK, 2) == 1)) THEN
                        IPR(524) = IYUNK
                      END IF
                    END IF
                  END IF
                END IF
              END IF
C * SHXABS
              CALL PLA202
C * ERROR HANDLING
              IGBL(1) = 3
              RETURN
C * IS = 169: DELETE ATOM (ORTEP/SOLV)
            CASE (169)
              N = IPR(220)
              IF (N > 1) THEN
                DO I = 2, N
                  CALL PLA046 (2, IFL(I), IENM, LBB, LBC, LBD,
     1                         INQNR, JNQNR, NR)
                  IF (NR > 0) THEN
                    CALL GEN048 (1, IFG(2, NR), 27, 1)
                  ELSE
                    CALL PLA015 (0, 28)
                  END IF
                END DO
              END IF
              GO TO 10
C * IS = 170: COLOR TYPE INSTRUCTION
            CASE (170)
              N = IPR(220)
              IF (MOD (N, 2) == 0 .AND. N >= 4) THEN
                DO I = 3, N, 2
                  IEXIT = 0
                  NQ1 = IFL(I)(1:2)
                  NQ2 = IFL(I + 1)(1:3)
                  IF (NQ1(2:2) == ' ') THEN
                    NQ1 = ' '//IFL(I)(1:1)
                  ELSE
                    CALL GEN020 (-1, NQ1, 2, 2)
                  END IF
                  DO J = 1, IAN
                    IF (NQ1(1:2) == LMT(J, 1)) THEN
                      DO K = 1, NP10 + 1
                        IF (NQ2(1:3) == COLR(K)(1:3)) THEN
                          IACL(J) = K
                          IEXIT   = 1
                          EXIT
                        END IF
                      END DO
                    END IF
                    IF (IEXIT /= 0) EXIT
                  END DO
                END DO
              END IF
              GO TO 10
C * IS = 171: RESET
            CASE (171)
              CALL PLA286 (0)
              GO TO 190
C * IS = 173: STIDY (Structure Tidy - Parthe & Gelato)
            CASE (173)
C * RUN STRUCTURE TIDY
              EXTENS1 = EXTENS
              CALL PLA301 (1)
              EXTENS = EXTENS1
              IF (IPR(2) == 0) IPR(2) = -1
C * ERROR HANDLING
              IGBL(1) = 3
              RETURN
C * IS = 174: BIJVOET PAIR ANALYSIS
            CASE (174)
C * SET DEFAULTS
C * GAUSSIAN PROBABILITY DISTRIBUTION
              IPR(613) = 0
C * NO PROBALILITY DISTRIBUTION CORRECTION
              IPR(593) = 0
C * NO RECYCLE-T
              IPR(617) = 0
C * Fo/Fc BASED ON CIF
              IPR(594) = 1
              PAR(488) = 0.0
              KN = IPR(221)
              IF (KN.GT. 0) THEN
                DO I = 1, IPR(221)
C * Gaussian/Student-t
                  IF (I == 1) THEN
                    IPR(613) = NINT (FN(1))
C * PP Slope Correction
                  ELSE IF (I == 2) THEN
                    IPR(593) = NINT (FN(2))
C * Recycle Student-t
                  ELSE IF (I == 3) THEN
                    IPR(617) = NINT (FN(3))
C * CIF/FCF Based Fcalc
                  ELSE IF (I == 4) THEN
                    IPR(594) = NINT (FN(4))
C * NU VALUE
                  ELSE IF (I == 5) THEN
                    PAR (488) = FN(5)
                  END IF
                END DO
              END IF
              CALL PLA405 (-1, NOPT)
C * ERROR HANDLING
              IGBL(1) = 3
              RETURN
C * IS = 175: FLIPPER (FLIP PATT / FLIP SHOW)
            CASE (175)
              IF (IGBL(80) /= 0) CALL PLA350
C * ERROR HANDLING
              IGBL(1) = 3
              RETURN
C * IS = 176: STRUCTURE?
            CASE (176)
              IF (IGBL(80) /= 0) CALL PLA350
C * ERROR HANDLING
              IGBL(1) = 3
              RETURN
C * IS = 178: STRAIN
            CASE (178)
              IF (CELAB(1, 1) > 0.0 .AND. TEMPAB(1) /= TEMPAB(2))
     1          THEN
C * DO AN ANALYSIS BASED ON HAZEN ET AL. OR DUNITZ ORTHOGONALIZATION RESP.
                DO I = 1, 2
                  MORT = 3 - I
                  CALL PLA284 (MORT, JID)
                END DO
              ELSE
                WRITE (LU6, 99971, IOSTAT = IOST)
              END IF
              IGBL(1) = 3
              RETURN
C * IS = 179: CELA (STRAIN)
            CASE (179)
              DO I = 1, 6
                CELAB(1, I) = FN(I)
              END DO
              TEMPAB(1) = FN(7)
              IPR(221)  = 6
              IS        = 30
              CYCLE
C * IS = 180: CELB (STRAIN)
            CASE (180)
              DO I = 1, 6
                CELAB(2, I) = FN(I)
              END DO
              TEMPAB(2) = FN(7)
              GO TO 10
C * IS = 181: CSUA (STRAIN)
            CASE (181)
              DO I = 1, 6
                VCAB(1, I) = FN(I)
              END DO
              ICV(1) = 1
              GO TO 10
C * IS = 182: CSUB (STRAIN)
            CASE (182)
              DO I = 1, 6
                VCAB(2, I) = FN(I)
              END DO
              ICV(2) = 1
              GO TO 10
C * IS = 183: CIF2SHELXL
            CASE (183)
              CALL PLA345
              IF (IPR(663) == -2 .OR. IPR(321) > 0) THEN
                IGBL(1) = 4
                RETURN
              END IF
              GO TO 10
C * IS = 184: NOEXPAND
            CASE (184)
              IGBL(136) = 1
              IPR(129)  = 1
              IGBL(30)  = 1
              GO TO 10
C * IS = 186: ANOM
            CASE (186)
              CALL PLA385 (1)
              GO TO 10
C * IS = 187: MU
            CASE (187)
              CALL PLA385 (2)
              GO TO 10
C * IS = 188: XTPLOT (SHELXT + PLOT)
            CASE (188)
C * CHECK FOR SHELXT ACCESS
              IF (IGBL(119) /= 0) THEN
                CALL PLA205
              ELSE
                WRITE (LU6, 99998)
              END IF
              GO TO 10
C * IS = 199: HYBRID, (BYPASS)
            CASE (199, 200)
C * CHECK FOR SHELXL201n WHEN TRUE: IGBL(139) = 1
              CALL PLA428
              IF (IGBL(110) > 0) CALL PLA131 (NINT (FN(1)))
              RETURN
C * IS = 202: ADDSYM (EXPANDED TO CALC ADDSYM)
            CASE (202)
              DO I = IPR(220), 1, -1
                IFL(I + 1) = IFL(I)
              END DO
              IFL(1)   = 'CALC'
              IPR(220) = IPR(220) + 1
              IS       = 18
              CYCLE
C * IS = 203: NEWSYM (EXPANDED TO CALC NEWSYM)
            CASE (203)
              DO I = IPR(220), 1, -1
                IFL(I + 1) = IFL(I)
              END DO
              IFL(1)   = 'CALC'
              IPR(220) = IPR(220) + 1
              IS       = 18
              CYCLE
C * IS = 204: SQUEEZE (EXPANDED TO CALC SQUEEZE)
            CASE (204)
              DO I = IPR(220), 1, -1
                IFL(I + 1) = IFL(I)
              END DO
              IFL(1)   = 'CALC'
              IPR(220) = IPR(220) + 1
              IS       = 18
              CYCLE
C * IS = 205: WILSON PLOT
            CASE (205)
              CALL PLA370 (0)
              GO TO 10
C * IS = 206: CALCULATE FCF FROM SHELXL201x.cif
            CASE (206)
              CALL PLA346
              GO TO 10
C * IS = 210: (SOLVENT) ACCESSIBLE SURFACE AREA (S)ASA
            CASE (210)
C * HANDLE NON-DEFAULT PARAMETER SETTINGS
              IF (IPR(221) > 0) THEN
C * PROBE RADIUS [DEFAULT = 1.84]
                PAR(557) = FN(1)
C * NUMBER OF MonteCarlo PROBES [DEFAULT = 5000]
                IF (IPR(221) > 1) IPR(743) = NINT (FN(2))
              END IF
C * SET TO NO R/S CALC
              IPR(744) = 1
              CALL PLA067
C * (S)ASA CALCULATION
              CALL PLA394
              IPR(2)  = -1
              IGBL(1) = 3
              RETURN
C * IS = 211 -NONSYM (EXPANDED TO CALC NONSYM)
            CASE (211)
              DO I = IPR(220), 1, -1
                IFL(I + 1) = IFL(I)
              END DO
              IFL(1)   = 'CALC'
              IPR(220) = IPR(220) + 1
              IS       = 18
              CYCLE
C * IS = 212: ADP/ORTEP (EXPANDED TO PLOT ADP)
            CASE (212, 219)
              DO I = IPR(220), 1, -1
                IFL(I + 1) = IFL(I)
              END DO
              IFL(1)   = 'PLOT'
              IPR(220) = IPR(220) + 1
              IS       = 15
              CYCLE
C * IS = 213: SOLV (EXPANDED TO CALC SOLV)
            CASE (213)
              DO I = IPR(220), 1, -1
                IFL(I + 1) = IFL(I)
              END DO
              IFL(1)   = 'CALC'
              IPR(220) = IPR(220) + 1
              IS       = 18
              CYCLE
C * IS = 214: NEWMAN (EXPANDED TO PLOT NEWMAN)
            CASE (214)
              DO I = IPR(220), 1, -1
                IFL(I + 1) = IFL(I)
              END DO
              IFL(1)   = 'PLOT'
              IPR(220) = IPR(220) + 1
              IS       = 15
              CYCLE
C * IS = 215: RADII (EXPANDED TO LIST RADII)
            CASE (215)
              DO I = IPR(220), 1, -1
                IFL(I + 1) = IFL(I)
              END DO
              IFL(1)   = 'LIST'
              IPR(220) = IPR(220) + 1
              IS       = 29
              CYCLE
C * IS = 216: VOLCAL (HAZEN & FINGER)
            CASE (216)
              IFL(1)    = 'CALC'
              IFL(2)    = 'COORDN'
              IGBL(144) = 1
              IPR(220)  = 2
              IS        = 18
              CYCLE
C * IS = 218: CIP (R/S)
            CASE (218)
              IF (IPR(221) /= 0) IPR(492) = MIN (NINT (FN(1)), 10)
              IFL(1) = 'CALC'
              IFL(2) = 'GEOM'
C * R/S OUTPUT DEFAULT
              IPR(777) = 1
              IPR(220) = 2
              IPR(221) = 0
              IS       = 18
              CYCLE
C * IS = 220: DIEDERICHS PLOT
            CASE (220)
              IGBL(66) = 1
              NOPT = 2
              CALL PLA405 (0, NOPT)
C * ERROR HANDLING
              IGBL(1) = 3
              RETURN
            CASE DEFAULT
              GO TO 10
          END SELECT
        END DO
        GO TO 10
C * TEST FOR TOO MANY SPECIFIED ATOMS
   20   IF (IPR(220) > NP1 + 1) THEN
          IPR(2) = 8
          GO TO 200
        END IF
        IF (NTYP == 4) THEN
          IF (IPR(30) == 0) THEN
            DO I = 2, IPR(220)
C * SET UP CONNECTED SET
              IF (IFL(I)(1:4) == 'DIST') CALL PLA067
            END DO
          END IF
        END IF
C * TEST FOR PREVIOUS CALC UNIQUE (NO = 0)
        IF (IPR(30) == 0) THEN
          NRET = 1
          CALL PLA390 (1, NTYP, NRET)
          IF (NRET == 1) THEN
            GO TO 10
          ELSE IF (NRET == 2) THEN
            GO TO 30
          ELSE IF (NRET == 3) THEN
            GO TO 200
          END IF
C * PREVIOUS GEOM CALCULATION CASE
        ELSE
          IF (NTYP == 4) THEN
            IPR(81) = - IPR(220)
C * INTERACTIVE CALCULATION
            CALL PLA440 (1)
            GO TO 10
          END IF
        END IF
        IPR(220) = - IPR(220)
C * SINGLE DISTANCE, ANGLE OR TORSION ANGLE CALCULATION (+GEOM)
C * ALSO: ANGLE BETWEEN TWO CRYSTAL PLANES
   30   IF (IPR(220) == 1) THEN
          IF (IPR(221) == 6) THEN
            CALL PLA100
            ANG = 180.0 - GEN016 (FN(1), RBB, FN(4))
            WRITE (PRBUF, 99996, IOSTAT = IOST) (NINT (FN(I)), I = 1, 6)
     1        , ANG
            WRITE (LU6, 99981, IOSTAT = IOST) PRBUF(1:50)
            SBCD = PRBUF(1:50)//CHAR (0)
            GO TO 10
          ELSE
C * NOT ENOUGH DATA ON CARD
            IPR(2) = 5
            GO TO 200
          END IF
        ELSE IF (IFL(1)(1:3) == 'FIT' .OR. IPR(220) == -1 .OR.
     1          (IPR(220) > 1 .AND. IPR(220) < 6)) THEN
          IPR(1)  = 7
          IPR(81) = IPR(220)
C * TEST FOR PREVIOUS CALC UNIQUE (NO = 0)
          IF (IPR(30) == 0) THEN
            IGBL(52) = MAX (IGBL(52), IPR(23))
            IPR(205) = 0
          END IF
          CALL PLA021 (11, NRETURN)
          RETURN
        ELSE
C * NOT ENOUGH DATA ON CARD
          IPR(2) = 5
          GO TO 200
        END IF
C * CHECK FOR # OF VALUES IN CIF-MODE
   40   IF (IGBL(8) == 3) THEN
          IF (IFL(2)(1:1) == '?') GO TO 10
          IF (IPR(221) /= 12 .OR.
     1        (FN(2) == 0.0 .AND. FN(3) == 0.0 .AND. FN(4) == 0
     2        .AND. FN(5) == 0 .AND. FN(6) == 0)) THEN
            IF (IPR(221) /= 0) THEN
              IF (IGBL(3) == 1) THEN
C * ALERT _217
                CALL PLA236 (217, 0, 1.0, 1.0, IFL(2), ' ')
              ELSE
                IPR(2) = 50
                GO TO 200
              END IF
            ELSE
              GO TO 10
            END IF
          END IF
        END IF
C * LOAD U-MATRIX(6 TO 9 COMPONENTS)
        CALL GEN025 (DUMV, FN, -1)
C * CALCULATE TM2 * UIJ * TR(TM2)
        CALL GEN001 (1, TM2, DUMV, UIJ)
C * EXTRACT FROM TRANSFORMED U-MATRIX (9 TO 6 COMPONENTS)
        CALL GEN025 (UIJ, FN, 1)
        ICT     = 2
        IPR(32) = 2
C * SUIJ DATA
   50   IF (PAR(113) /= 0.0) CALL GEN144 (-1, FN(1), PAR(113))
C * TEST FOR PREVIOUS CALC UNIQUE (NO = 0)
   60   IF (IPR(30) == 1 .OR. IPR(107) == 1) THEN
          IPR(471) = IPR(471) + 1
          IF (IGBL(5) /= LU5) GO TO 10
C * UNKNOWN CARD ERROR
          IPR(2) = 7
          GO TO 200
        ELSE
          NQ2 = IFL(2)
          IF (IGBL(8) == 1) THEN
            IF (NQ4 /= NQ2) THEN
C * LABEL INCONSISTENT
              IPR(2) = 4
              GO TO 200
            END IF
            INQNR2 = INQNR
          ELSE
            MODE = 0
            CALL PLA046 (-2, NQ2, IENM, LBB, LBC, LBD,
     1                       INQNR2, JNQNR2, IDUM2)
          END IF
C * REGISTER (AN)ISO PARAMETER INPUT
          IPR(32) = MAX (IPR(32), 1)
          WRITE (LU4) ICT, INQNR2, (FN(K), K = 1, 8)
C * HANDLE CIF-FILE INPUT
          IF (IGBL(8) == 3) THEN
            IF (IS == 25) THEN
              IS = 26
              DO I = 1, 6
                FN(I) = FN(I + 6)
              END DO
C * UIJ DATA & SUIJ DATA
C * INCLUDE A*,B* AND C* INTO U(I, J) BEFORE TRANSFORMATION
              CALL GEN144 (1, FN(1), PAR(135))
C * CHECK FOR SUIJ
              IF (IS == 26) THEN
                ICT = 3
                GO TO 50
              END IF
              GO TO 40
            END IF
          END IF
          GO TO 10
        END IF
   70   CONTINUE
        CALL PLA186
        IF (IPR(2) == 0) THEN
          SELECT CASE (IPR(78))
            CASE (-1)
              IPR(2) = -5
            CASE (1)
              IPR(2) = -1
            CASE (2)
              IPR(2) = -8
            CASE (3)
              IPR(2) = -7
            CASE (4)
              IPR(2) = -6
          END SELECT
        END IF
C * ERROR HANDLING
        IGBL(1) = 3
        RETURN
C * PLOT INSTRUCTION CARD
C * IPR(14) =  0 : NO PLOTTING
C * IPR(14) = -1 : IPR(55) = -1 NEWMAN
C *              :         =  0
C *              :         =  1 : PLAN
C *              :         =  2 : RING
C *              :         =  3 : RESD
C *              :         =  4 : LSPL
C *         =  4 : ORTEP
C *         =  5 : POLYEDRA PLOT
C *         =  6 : PLUTON
C * SET GOTO SWITCH
   80   IPR(1)   = 5
        IPR(56)  = 0
        IPR(112) = 0
        IPR(205) = 0
        N        = 1
        K0       = 0
C * SAVE OPTION TEST
        IF (IGBL(45) > 0 .AND. IGBL(5) == LU5) THEN
          IGBL(45) = IGBL(45) + 1
          WRITE (LU3, 99984, IOSTAT = IOST) ICL(1:80)
          WRITE (LU6, 99973, IOSTAT = IOST) ICL(1:70)
        END IF
C * MAKE PLOT ADP DEFAULT FOR 'PLOT-AT-START' INSTRUCTION
        IF ((IPR(14) == 0  .OR. IPR(14) == 4) .AND.
     1       IPR(220) == 1) THEN
          IGBL(3)  = 3
          IPR(220) = 2
          IFL(2)   = 'ADP'
          IF (IPR(346) == 1) THEN
            IFL(3) = 'COLOR'
            IPR(220) = 3
          END IF
        END IF
        IF (IPR(220) > 1) THEN
          DO I = 2, IPR(220)
            SELECT CASE (IFL(I)(1:4))
              CASE ('RING')
                IPR(55) = 2
                IPR(14) = -1
              CASE ('PLAN')
                IPR(55) = 1
                IPR(14) = -1
              CASE ('RESD')
                IF (IPR(14) > 0) THEN
                  K0 = K0 + 1
                  IF (K0 <= IPR(221)) IPR(140) = NINT (FN(K0))
C * RESET LABEL POSITIONING STATUS
                  IPR(201) = 0
                ELSE
                  IPR(55) = 3
                  IPR(14) = -1
                END IF
              CASE ('LSPL')
                IPR(55) = 4
                IPR(14) = -1
C * DISPLAY ON
              CASE ('DISP')
                CALL GGIP (-999.0, 0.0, 0.0, -3)
                CALL GGIP (-999.0, 0.0, 0.0, 2)
C * META ON
              CASE ('META')
                CALL GGIP (-999.0, 0.0, 0.0, -2)
              CASE ('NEWM')
                IPR(30)  =  0
                IPR(55)  = -1
                IPR(14)  = -1
                IPR(169) = 0
C * TEST FOR PREVIOUS CALC UNIQUE (NO = 0)
                IF (IPR(30) /= 0) CALL GEN108 (LU8, 0)
                IPR(162) = 0
              CASE ('PERP')
                IPR(56) = 0
              CASE ('ALON')
                IPR(56) = 1
              CASE ('ADP ')
                IPR(14) = 4
                IF (IGBL(3) /= 28) IGBL(3) = 3
              CASE ('ORTE')
                IPR(14) = 4
                IF (IGBL(3) /= 28) IGBL(3) = 3
              CASE ('TME ')
                IPR(14) = 4
              CASE ('POLY')
                IPR(14) = 5
C * PLUTON (AUTO)
              CASE ('PLUT')
                IPR(14) = 6
              CASE ('HATO')
                IPR(212) = 1
              CASE ('NOHA')
                IPR(212) = 0
              CASE ('LABE')
                IGBL(75) = 1
              CASE ('NOLA')
                IGBL(75) = 0
              CASE ('ENVE')
                IPR(211) = 1
              CASE ('HETE')
                IPR(211) = 0
              CASE ('OCTA')
                IPR(211) = 2
              CASE ('PARE')
                IPR(350) = 1
              CASE ('NOPA')
                IPR(350) = 0
              CASE ('MARG')
                IF (K0 < IPR(221))  THEN
                  K0 = K0 + 1
                  PAR(44) = FN(K0)
                END IF
              CASE ('TAPE')
                IF (K0 < IPR(221))  THEN
                  K0 = K0 + 1
                  PAR(48) = FN(K0)
                END IF
              CASE ('NET ')
                IPR(112) = 1
              CASE ('MONO')
                IPR(116) = 0
              CASE ('STER')
                IPR(116) = 1
              CASE ('COLO')
                IPR(346) = 1
              CASE DEFAULT
                CALL PLA037 (I, L, 2)
                IF (IPR(2) == 0) THEN
                  IF (L < 0)
     1              IPR(162)  = IPR(162) * (NP1 + 1) + IABS (L)
                ELSE
                  IPR(2) = 0
                  WRITE (LU6, 99986, IOSTAT = IOST) IFL(I)
                END IF
            END SELECT
          END DO
C * TEST FOR PREVIOUS CALC UNIQUE (NO = 0)
          IF (IPR(30) == 0) THEN
            IPR(220) = 2
            IF (IPR(14) < 0) THEN
              WRITE (LU6, 99983, IOSTAT = IOST)
            ELSE
              WRITE (LU6, 99982, IOSTAT = IOST)
            END IF
            GO TO 110
          ELSE
            IF (IPR(14) > 0) GO TO 210
C * TEST FOR CALC INTRA AS PREVIOUS INSTRUCTION
            IF (IPR(136) /= 1) THEN
C * MISPLACED PLOT INSTRUCTION
              IPR(2) = 12
              GO TO 200
            END IF
          END IF
          IF (IPR(86) == 0) GO TO 10
        ELSE
          IF (IPR(14) == 0) THEN
C * NOT ENOUGH DATA ON CARD
            IPR(2) = 5
            GO TO 200
          END IF
        END IF
        GO TO 210
C * CALC CONTROL CARD FOR PLA067. THE SUB-KEYWORDS ARE:
C * INTRA, INTER, COORDN, METAL, GEOM, HBOND, TMA, VOID, LIST, ADDSYM
C * SET PLOTTING DEFAULT NO
  100   IPR(14)  = 0
C * SET UNIQUE DEFAULT zero
        IPR(31)  = 0
C * SET LU2 DEFAULT NO
        IPR(67)  = 0
C * SET VOID/SOLV DEFAULT NO
        IPR(189) = 0
C * SET VOID MAP DEFAULT NO
        IPR(197) = 0
C * SET VOID/SOLV DEFAULT NO
        IPR(200) = 0
C * SET CALC ADDSYM DEFAULT NO
        IPR(205) = 0
        IF (IGBL(45) > 0 .AND. IGBL(5) == LU5) THEN
          IGBL(45) = IGBL(45) + 1
C * INSTRUCTION SAVE AND MESSAGE
          WRITE (LU3, 99984, IOSTAT = IOST) ICL(1:80)
          WRITE (LU6, 99973, IOSTAT = IOST) ICL(1:70)
        END IF
  110   IPR(136) = 0
        IPR(121) = 0
C * HANDLE CALC ( = CALC ALL) CASE
        IF (IPR(220) == 1) THEN
C * NO NUMERICAL PARAMETERS FOR 'CALC ALL'
          IF (IPR(221) > 0) THEN
            IPR(221) = 0
C * UNKNOWN CARD ERROR
            IPR(2) = 7
            GO TO 200
          ELSE
C * CHECK MODE
            IF (IGBL(36) == 0) IGBL(36) = -1
            IPR(121) = 9
            IGBL(22) = 0
            IPR(495) = 1
C * SET 'CALC ALL'
            IPR(123) = 1
            IPR(326) = 1
          END IF
        END IF
      END IF
C * TEST FOR 'UNIQUE CALCULATION DONE'
  120 IF (IPR(30) == 0) THEN
        IPR(1) = 2
      ELSE
        IPR(1) = 6
      END IF
      IPR(57)  = 0
      N        = 0
      IGBL(52) = MAX (IGBL(52), IPR(23))
C * GET DEFAULT COORDINATION RADIUS
      PAR(262) = PAR(7)
      IF (IPR(14) /= 0) THEN
        IPR(121) = 1
        L        = 2
        CALL PLA021 (3, NRETURN)
        IF (NRETURN == 3) GO TO 130
      END IF
      L = 1
C * HANDLE CALC (ALL) CASE
C * (= ADDSYM, INTRA, INTER, COORDN, METAL, SOLV, (ASYM))
      IF (IPR(220) == 1) THEN
  125   SELECT CASE (IPR(121))
C * GET AVERAGE HKL MULTIPLICITY AND MERGED HKL LISTING
          CASE (9)
C * CHECK FOR EMBEDDED *.res AND *.hkl
            IF (IPR(663) /= 0 .AND. IPR(664) /= 0) THEN
C * INCLUDE ASYM - HKL DATA ANALYSIS IN LOOP
              CALL PLA149
            ELSE
              IPR(121) = 8
            END IF
            GO TO 125
C * RUN DEFAULT ADDSYM
          CASE (8)
            CALL PLA021 (2, NRETURN)
            IF (NRETURN == 0) THEN
              RETURN
            ELSE IF (NRETURN == 1) THEN
              GO TO 120
            ELSE IF (NRETURN == 2) THEN
              GO TO 200
            END IF
C * RUN DEFAULT CALC INTRA
          CASE (7)
            CALL PLA021 (3, NRETURN)
            IF (NRETURN == 3) GO TO 130
C * RUN DEFAULT CALC INTER
          CASE (6)
            CALL PLA021 (4, NRETURN)
            IF (NRETURN == 2) THEN
              GO TO 200
            ELSE IF (NRETURN == 3) THEN
              GO TO 210
            ELSE IF (NRETURN == 4) THEN
              GO TO 190
            ENDIF
C * RUN DEFAULT CALC COORDN
          CASE (5)
            CALL PLA021 (5, NRETURN)
            IF (NRETURN == 0) THEN
              RETURN
            ELSE IF (NRETURN == 3) THEN
              GO TO 210
            END IF
C * RUN DEFAULT CALC METAL
          CASE (4)
            CALL PLA021 (8, NRETURN)
            IF (NRETURN == 1) THEN
              GO TO 10
            ELSE IF (NRETURN == 3) THEN
              GO TO 130
            END IF
C * RUN DEFAULT CALC SOLV
          CASE (3)
            IPR(200) = 2
            CALL PLA021 (9, NRETURN)
            IF (NRETURN == 2) THEN
              GO TO 200
            ELSE IF (NRETURN == 3) THEN
              GO TO 210
            END IF
C * RUN DEFAULT IUCR-CHECK (CIF + FCF) (ASYM)
          CASE (2)
            CALL PLA021 (10, NRETURN)
            IF (NRETURN == 0) THEN
              RETURN
            ELSE IF (NRETURN == 4) THEN
              GOTO 190
            END IF
C * RUN END
          CASE (1)
            GO TO 190
        END SELECT
      END IF
C * SUB-KEYWORDS LOOP
      IF (IPR(221) > 0) PAR(262) = 0.0
      IPR(121) = 1
  130 L        = L + 1
      IF (L <= IPR(220)) THEN
        DO ISS = 1, NP22
          NQ1 = IFL(L)(1:7)
          IF (NQ1(1:4) == ISWSS(ISS)) THEN
            SELECT CASE (ISS)
C * ISS = 1: GEOM
              CASE (1)
                GO TO 160
C * ISS = 2: TMA, ATOMIC DISPLACEMENT MOTION CALCULATION
              CASE (2)
C * TEST FOR PREVIOUS CALC UNIQUE (NO = 0)
                IF (IPR(30) /= 0) THEN
                  IPR(2) = 29
                  GO TO 200
                END IF
                IPR(5)  = -1
                IF (IPR(221) > 0) THEN
                  PAR(34) = FN(1)
                  IF (IPR(221) > 1) IPR(21) = NINT (FN(2))
                END IF
                IF (IPR(220) > 2 .AND. IFL(3)(1:3) == 'CAR')
     1            IPR(347) = 1
                CALL PLA021 (3, NRETURN)
                IF (NRETURN == 3) GO TO 130
C * ISS = 3: INTRA
              CASE (3)
                CALL PLA021 (3, NRETURN)
                IF (NRETURN == 3) GO TO 130
C * ISS = 4: INTER
              CASE (4)
                CALL PLA021 (4, NRETURN)
                IF (NRETURN == 2) THEN
                  GO TO 200
                ELSE IF (NRETURN == 3) THEN
                  GO TO 130
                ELSE IF (NRETURN == 4) THEN
                  GO TO 190
                ENDIF
C * ISS = 5: NOTM(A)
              CASE (5)
                IPR(5) = 0
C * ISS = 6: NOAN(G)
              CASE (6)
                IPR(7) = 0
C * ISS = 7: NOTO(R)
              CASE (7)
                IPR(8) = 0
C * ISS = 8: NOLS(PL)
              CASE (8)
                IPR(9) = 0
C * ISS = 9: NOST(D)
              CASE (9)
                IPR(72) = 0
C * ISS = 10: NORI(NG)
              CASE (10)
                IPR(10) = 0
C * ISS = 11: NOBOND
              CASE (11)
C * NOBO(ND)/NODI(ST)
                IPR(6) = 0
C * ISS = 12: NOMO(VE) OPTION
              CASE (12)
C * TEST FOR PREVIOUS CALC UNIQUE (NO = 0)
                IF (IPR(30) == 1) THEN
C * INSTRUCTION NOT ALLOWED
                  IPR(2) = 11
                  GO TO 200
                ELSE
C * SET NOMOVE
                  IGBL(30) = 1
                END IF
C * ISS = 13: NOSY(MM) OPTION
              CASE (13)
                IGBL(52) = 1
C * ISS = 14: NOBP(A)
              CASE (14)
                IPR(40) = 0
C * ISS = 15: EWLS
              CASE (15)
C * (E)WLSPL - CALCULATE ESD-WEIGHTED PLANES
                IPR(41) = 2
C * ISS = 16: TOLA
              CASE (16)
                N = N + 1
                IF (N > IPR(221)) THEN
C * NOT ENOUGH DATA ON CARD
                  IPR(2) = 5
                  GO TO 200
                ELSE
                  PAR(2) = FN(N)
                END IF
C * ISS = 17: CALC COORDINATION
              CASE (17)
                CALL PLA021 (5, NRETURN)
                IF (NRETURN == 0) THEN
                  RETURN
                ELSE IF (NRETURN == 3) THEN
                  GO TO 130
                END IF
C * ISS = 18: CALC METAL
              CASE (18)
                CALL PLA021 (8, NRETURN)
                IF (NRETURN == 1) THEN
                  GO TO 10
                ELSE IF (NRETURN == 3) THEN
                  GO TO 130
                END IF
C * ISS = 19: AWLSPL - CALCULATE (ATOM-WEIGHT) WEIGHTED L.S.-PLANES
              CASE (19)
                IPR(41) = 1
C * ISS = 20: CALC HBONDS (p1, p2, p3)
              CASE (20)
                CALL PLA021 (12, NRETURN)
                IF (NRETURN == 2) GO TO 200
C * ISS = 21: UWLSPL - LSPL - BASED ON UNIT WEIGHTS
              CASE (21)
                IPR(41) = 0
C * ISS = 22: OUTPUT SHELX(L) RES-FILE (CALC SHELX(L) INSTRUCTION)
              CASE (22)
                IF (IGBL(131) == 0) THEN
                  IGBL(31) = -2
                ELSE
                  IGBL(31) = -3
                END IF
C * SET ROUND OFF
                IPR(68) = 0
                WRITE (LU6, 99989, IOSTAT = IOST)
                GO TO 140
C * ISS = 23: OUTPUT OMEGA INPUT-FILE (CALC OMEGA INSTRUCTION)
              CASE (23)
                IF (IPR(438) == 0) THEN
                  IGBL(31) = 1
                END IF
                IF (IPR(220) < 4) THEN
C * BONDS, ANGLES, TORSION-ANGLES
                  IPR(6) = 1
                  IPR(7) = 1
                  IPR(8) = 1
                END IF
                GO TO 140
C * ISS = 24: CHX INCLUDE
              CASE (24)
                IPR(645) = 1
C * ISS = 25: OUTPUT SPF - FILE (CALC SPF INSTRUCTION)
              CASE (25)
                IGBL(31) = 3
C * SET ROUND OFF
                IPR(68) = 0
                WRITE (LU6, 99989, IOSTAT = IOST)
                GO TO 140
C * ISS = 26: FIVE COORDINATION
              CASE (26)
                IPR(122) = 5
                IF (N < IPR(221)) THEN
                  N       = N + 1
                  PAR(35) = FN(N)
                ELSE
                  PAR(35) = 0.0
                END IF
C * ISS = 27: CALC ALL
              CASE (27)
                IPR(121) = 8
                IPR(220) = 1
                GO TO 120
C * ISS = 28: TOLP
              CASE (28)
                N = N + 1
                IF (N > IPR(221)) THEN
C * NOT ENOUGH DATA ON CARD
                  IPR(2) = 5
                  GO TO 200
                ELSE
                  PAR(49) = FN(N)
                END IF
C * ISS = 29: TOLR
              CASE (29)
                N = N + 1
                IF (N > IPR(221)) THEN
C * NOT ENOUGH DATA ON CARD
                  IPR(2) = 5
                  GO TO 200
                ELSE
                  PAR(3) = FN(N)
                END IF
C * ISS = 31: VOID
              CASE (31)
                IPR(200) = 1
                CALL PLA021 (9, NRETURN)
                IF (NRETURN == 2) THEN
                  GO TO 200
                ELSE IF (NRETURN == 3) THEN
                  GO TO 130
                END IF
C * ISS = 32: PROBE RADIUS
              CASE (32)
                N = N + 1
                IF (N > IPR(221)) THEN
C * NOT ENOUGH DATA ON CARD
                  IPR(2) = 5
                  GO TO 200
                ELSE
                  PAR(84) = FN(N)
                END IF
C * ISS = 33: PSTEP
              CASE (33)
                N = N + 1
                IF (N > IPR(221)) THEN
C * NOT ENOUGH DATA ON CARD
                  IPR(2) = 5
                  GO TO 200
                ELSE
                  IPR(214) = NINT (FN(N))
                END IF
C * ISS = 34: LIST
              CASE (34)
                IPR(197) = 1
C * ISS = 35: SUBKEYWORD EXPAND
              CASE (35)
                IPR(67) = 1
C * ISS = 36: CALC DIST
              CASE (36)
                IPR(57)  = -2
                PAR(262) = 3.0
                IPR(7)   = 0
                CALL PLA021 (6, NRETURN)
                IF (NRETURN == 6) GO TO 130
C * ISS = 37: TOLEA
              CASE (37)
                N = N + 1
                IF (N > IPR(221)) THEN
C * NOT ENOUGH DATA ON CARD
                  IPR(2) = 5
                  GO TO 200
                ELSE
                  PAR(26) = FN(N)
                END IF
C * ISS = 38: MISSYM (= ADDSYM)
              CASE (38)
                CALL PLA021 (2, NRETURN)
                  IF (NRETURN == 0) THEN
                  RETURN
                ELSE IF (NRETURN == 1) THEN
                  GO TO 10
                ELSE IF (NRETURN == 2) THEN
                  GO TO 200
                END IF
C * ISS = 39: SOLV
              CASE (39)
                IPR(326) = 1
                IPR(200) = 2
                CALL PLA021 (9, NRETURN)
                IF (NRETURN == 2) THEN
                  GO TO 200
                ELSE IF (NRETURN == 3) THEN
                  GO TO 130
                END IF
C * ISS = 40: TOLM
              CASE (40)
                N = N + 1
                IF (N > IPR(121)) THEN
C * NOT ENOUGH DATA ON CARD
                  IPR(2) = 5
                  GO TO 200
                ELSE
                  PAR(27) = FN(N)
                END IF
C * ISS = 41: NOBO(ND)/NODI(ST)
              CASE (41)
                IPR(6) = 0
C * ISS = 42: BOND
              CASE (42)
                IPR(6) = 1
C * ISS = 43: ANGLE
              CASE (43)
                IPR(7) = 1
C * ISS = 44: TORS(ION)
              CASE (44)
                IPR(8) = 1
C * ISS = 45: CSD-QUE
              CASE (45)
                IGBL(31) = 4
                GO TO 140
C * ISS = 46: SQUEEZE
              CASE (46)
C * CHECK FOR SUITABLE MODEL AND REFLECTION FILE COMBINATIONS (PLA008)
C * CASE: SHELXL201n CIF + FCF (LIST 4) - (UNTWINNED)
                IF (IGBL(29) == 1 .AND. IPR(619) == 0 .AND.
     1            IPR(663) /= 0 .AND. IPR(664) /= 0) THEN
C * CASE: SHELXL201n CIF + FCF (LIST 8) (TWINNING)
                ELSE IF (IGBL(29) == 3 .AND. IPR(619) == 1 .AND.
     1            IPR(663) /= 0 .AND. IPR(664) /= 0) THEN
C * CASE: SHELXL INS/RES + SHELXL HKL
                ELSE IF (IGBL(29) == -1) THEN
C * CASE: SHELXL INS/RES + SHELXL FCF (LIST 4)
                ELSE IF (IGBL(29) == -2) THEN
                ELSE
                  IPR(1) = 1
                  IPR(2) = 68
                  GO TO 200
                END IF
C * SET JOIN EXPAND TO NO
                IPR(110) = 0
C * SET SQUEEZE MODE
                IPR(210) = 1
C * SET SAV-FILE SQUEEZE MODE
                IPR(326) = 1
C * SOLV MODE
                IPR(200) = 2
                CALL PLA021 (9, NRETURN)
                IF (NRETURN == 2) THEN
                  GO TO 200
                ELSE IF (NRETURN == 3) THEN
                  GO TO 130
                END IF
C * ISS = 47: SAV
              CASE (47)
                IPR(326) = -1
C * ISS = 48: CALC FCF
              CASE (48)
                IPR(210) = - 1
                IF (L == IPR(220)) GO TO 160
C * ISS = 49: CYCL
              CASE (49)
                N = N + 1
                IF (N > IPR(221)) THEN
C * NOT ENOUGH DATA ON CARD
                  IPR(2) = 5
                  GO TO 200
                ELSE
                  IPR(142) = MAX (2, NINT (FN(N)))
                END IF
C * ISS = 50: CALC NEWSYM
              CASE (50)
C * CHANGE AXIS CRITERIUM FROM DEFAULT 0.2 VALUE
                IF (FN(1) /= 0.0) PAR(383) = FN(1)
                IPR(210) = -2
                IGBL(31) = 5
                IPR(6)   = 0
C * OPEN UNIT #2
                CALL PLA292
                CALL PLA015 (0, 39)
                GO TO 170
C * ISS = 52: OUTPUT PDB-FORMATTED FILE
              CASE (52)
                IGBL(31) = 7
                GO TO 140
C * ISS = 53: HINCL (TMA)
              CASE (53)
                IPR(497) = 1
C * ISS = 54: NONSYM
              CASE (54)
                IPR(495) = 3
                IF (IPR(221) > 0) PAR(73) = FN(1)
                IF (IPR(221) > 1) PAR(75) = FN(2)
                CALL PLA015 (0, 39)
                GO TO 170
C * ISS = 55: NONA OPTION (HBONDS)
              CASE (55)
                IPR(300) = 0
C * ISS = 56: MAXDEV
              CASE (56)
                N = N + 1
                IF (N > IPR(221)) THEN
C * NOT ENOUGH DATA ON CARD
                  IPR(2) = 5
                  GO TO 200
                ELSE
                  PAR(76) = FN(N)
                END IF
C * ISS = 57: WLSP
              CASE (57)
C * (E)WLSPL - CALCULATE ESD-WEIGHTED PLANES
                IPR(41) = 2
C * ISS = 58: FCAL (SQUEEZE OPTION)
              CASE (58)
                IPR(132) = 1
C * ISS = 59: ADDSYM
              CASE (59)
                CALL PLA021 (2, NRETURN)
                IF (NRETURN == 0) THEN
                  RETURN
                ELSE IF (NRETURN == 1) THEN
                  GO TO 10
                ELSE IF (NRETURN == 2) THEN
                  GO TO 200
                END IF
C * ISS = 60: DIFFOURIER
              CASE (60)
C * SET CALC DIFFMAP MODE
                IPR(210) = 2
                IPR(326) = 0
                IPR(200) = 0
                CALL PLA021 (9, NRETURN)
                IF (NRETURN == 2) THEN
                  GO TO 200
                ELSE IF (NRETURN == 3) THEN
                  GO TO 130
                END IF
C * ISS = 61: NOSORT ATOMS OPTION
              CASE (61)
                IGBL(33) = 0
C * ISS = 62: DISORDER (MINOR) INCLUDED
              CASE (62)
                IPR(303) = 1
C * ISS = 63: GENERATE (HKL) - IPR(408) = 1
              CASE (63)
                IPR(408) = 1
                IPR(700) = NINT (FN(1))
                IF (IPR(210) == -1) GO TO 160
                GO TO 150
C * ISS = 64: EXPECT
              CASE (64)
                IPR(408) = 2
                GO TO 150
C * ISS = 65: MAXRING
              CASE (65)
                N = N + 1
                IF (N > IPR(221)) THEN
C * NOT ENOUGH DATA ON CARD
                  IPR(2) = 5
                  GO TO 200
                ELSE
                  IPR(579) = NINT (FN(N))
                END IF
C * ISS = 66: MOLSYM
              CASE (66)
                IPR(495) = 2
                IF (IPR(221) > 0) PAR(73) = FN(1)
                IF (IPR(221) > 1) PAR(75) = FN(2)
                GO TO 170
C * ISS = 67: RENUM KEYWORD
              CASE (67)
                IPR(501) = 1
C * ISS = 68: SOLV PLOT
              CASE (68)
                IPR(326) = 2
C * ISS = 69: CALC RDF
              CASE (69)
C * SET RADIUS RANGE MAXIMUM
                PAR(262) = PAR(450)
                IF (IPR(221) > 0) THEN
                  PAR(262) = FN(1)
C * (RE)SET SIGMA ASSIGNED TO BOND
                  IF (IPR(221) > 1) PAR(451) = FN(2)
                END IF
                IPR(57)  = 2
                IPR(170) = 0
C * INIT RADIAL DISTRIBUTION FUNCTION
                CALL PLA144 (0, 0)
                CALL PLA015 (0, 39)
                CALL PLA021 (6, NRETURN)
                IF (NRETURN == 6) GO TO 130
C * ISS = 70: SOLV GRID
              CASE (70)
                N = N + 1
                IF (N > IPR(221)) THEN
C * NOT ENOUGH DATA ON CARD
                  IPR(2) = 5
                  GO TO 200
                ELSE
                  PAR(80)  = FN(N)
                  IPR(214) = 0
                END IF
C * ISS = 71: SOLV F3D
              CASE (71)
                IPR(326) = 3
C * ISS = 72: NOSF (NO EXPLICTION SCATTERING FACTORS IN RES)
              CASE (72)
                IPR(595) = 1
C * DEFAULT
              CASE DEFAULT
                CYCLE
            END SELECT
            GO TO 130
          END IF
        END DO
C * CALC CARD HANDLING
      ELSE
C * TEST WHETHER THERE ARE NON-ZERO ATOMS
        IF (IPR(39) > 0) THEN
          GO TO 210
        ELSE
C * MESSAGES
          WRITE (LU6, 99992, IOSTAT = IOST)
          GO TO 190
        END IF
      END IF
C * IF NOT A SUB-KEYWORD THEN ASSUME ELEMENT SYMBOL FOLLOWED BY RADIUS
C * NOTE: INDIVIDUAL ATOM - RADIUS INTERPRETED IN PLA067 FOR IPR(17)=1
      IF (IPR(210) == 0) THEN
C * TEST FOR COORDN MODE
        IF (IPR(31) == 1) THEN
          IF (IPR(221) > 0) THEN
            N = N + 1
            PAR(68) = FN(N)
          ELSE
            PAR(68) = PAR(7)
          END IF
        END IF
        CALL PLA037 (L, NID, 3)
        IF (IPR(31) == 0) IPR(156) = 1
        IF (L > 2) THEN
          IF (NID > 0) THEN
            IF (IPR(31) < 1) N = N + 1
            IF (IPR(57) < 0) THEN
              IPR(57) = - NID
              IF (N == IPR(221)) PAR(262) = FN(N)
            ELSE
              IF (N > IPR(221)) THEN
                FNN = PAR(7)
              ELSE
                FNN = FN(N)
              END IF
              RADR(NID, 1) = FNN
            END IF
C * TEST FOR PREVIOUS CALC UNIQUE (NO = 0)
          ELSE IF (NID == 0 .AND. IPR(30) /= 0) THEN
            IF (IPR(31) == 1) THEN
              GO TO 10
            ELSE
              IPR(2) = 18
              GO TO 200
            END IF
          END IF
        ELSE
          IPR(2) = 18
          GO TO 200
        END IF
      END IF
      GO TO 130
  140 IF (IPR(438) == 0) THEN
C * OPEN UNIT #2
        CALL PLA292
      END IF
      GO TO 170
  150 CALL PLA293 (PAR(17))
      PAR(165) = ASIN (MIN(1.0, PAR(287) * PAR(17))) * RGBL(6)
      GO TO 130
C * SHORT GEOMETRY CALCULATION (GEOM)
  160 IF (IPR(220) == 2 .OR.
     1   (IPR(220) == 3 .AND. IFL(3)(1:3) == 'NOM')) THEN
C * SET FOR BONDS, ANGLES AND TORSION CALCULATION
        CALL PLA015 (0, 39)
C * CALC FCF (-1)
        IPR(6) = 1
        IPR(7) = 1
        IPR(8) = 1
      END IF
C * NO GEOM ETC AFTER PREVIOUS INTRA
C * TEST FOR PREVIOUS CALC UNIQUE (NO = 0)
  170 IF (IPR(30) /= 0) THEN
        IPR(2) = 31
        GO TO 200
      END IF
      IPR(31)  = 0
      IPR(121) = 0
      GO TO 130
C * OPTIONALLY SAVE THIS INSTRUCTION
  180 IF (IGBL(45) > 0 .AND. IGBL(5) == LU5) THEN
        WRITE (LU3, 99984, IOSTAT = IOST) ICL(1:80)
        IGBL(45) = IGBL(45) + 1
        WRITE (LU6, 99973, IOSTAT = IOST) ICL(1:70)
      END IF
      GO TO 10
C * HANDLE END-CARD
  190 IF (IGBL(5) == LU5) THEN
        IF (IABS(IGBL(45)) > 1) THEN
C * WRITE END CARD TO SAVE-FILE
          WRITE (LU3, 99984, IOSTAT = IOST) ICL(1:80)
          IGBL(45) = -1
          CALL GEN108 (LU3, 0)
        END IF
        GO TO 200
      END IF
C * TREAT END-CARD AS END-OF-FILE FOR SHELX-INPUT ON LU1
C * BUT IGNORE WHEN Q-PEAKS ARE REQUESTED
      IF (IGBL(5) == LU1 .AND. IABS (IGBL(8)) == 2) THEN
        IF (IGBL(95) == 0) THEN
          IGBL(5) = LU3
          CALL GEN108 (LU3, 0)
        END IF
        GO TO 10
      END IF
      IF (IPR(3) /= 0) THEN
C * GIVE SUMMARY
        IPR(1) = 3
        GO TO 210
      END IF
C * GOTO HANDLING
  200 IF (IGBL(138) == 0) THEN
        IPR(1) = 1
      ELSE
        IPR(1) = 8
      END IF
      IPR(121) = 0
  210 SELECT CASE (IPR(1))
C * 1 - ERROR HANDLING
        CASE (1)
          IF (IPR(2) == 0) IPR(2) = -1
          IGBL(1) = 3
          RETURN
C * 2 - SET UP CONNECTED SET ETC. (INCLUDING VOID MAP)
        CASE (2)
          CALL PLA067
          IF (IPR(2) /= 0) RETURN
C * PRINT COORDINATES
          CALL PLA073 (-1, 1)
C * ERROR TEST
          IF (IPR(2) /= 0) THEN
C * ERROR HANDLING
            IGBL(1) = 3
            RETURN
          END IF
C * CHECK BONDS ETC IN CIF
          IF (IABS (IGBL(8)) == 3 .AND. IPR(14) /= 4) CALL PLA272
          GO TO 220
C * 3 - GIVE SUMMARY
        CASE (3)
          IPR(2)  = -1
          IGBL(5) = LU1
          IGBL(8) = IABS (IGBL(8))
C * ERROR HANDLING
          IGBL(1) = 3
          RETURN
C * 5 - EXECUTE PLOT & TABLE OPTION(S)
        CASE (5)
          IF (IPR(14) < 0) THEN
C * NEWMAN, RING, PLAN, LSPL, RESD PLOT
            CALL GEN108 (LU8, 0)
            CALL PLA111
          ELSE IF (IPR(14) == 4) THEN
C * DISPLACEMENT MOTION ELLIPSOID-PLOT
            IF (IPR(85) == 0) THEN
              IPR(5) = 0
              CALL PLA024
            END IF
C * TEST FOR RESIDUE NR OUT OF RANGE
            IF (IPR(140) > IPR(75)) THEN
              IPR(2)  = 13
C * ERROR HANDLING
              IGBL(1) = 3
              RETURN
            END IF
C * SWITCH TO LSPL CALC
            IF (IPR(460) < 3) THEN
              IGBL(6)  = 9
              LMOD     = 1
              IFL(1)   = 'LSPL'
              CALL PLA015 (476, 1)
              IPR(453) = 0
              IPR(448) = 0
            END IF
C * SWITCH TO ANGLE BETWEEN LINES
            IF (IPR(341) == 5) THEN
              IGBL(6) = 9
            END IF
C * SWITCH TO DIHEDRAL PLANE CALC
            IF (IPR(551) < 3) THEN
              IGBL(6)  = 9
              LMOD     = 1
              IFL(1)   = 'LSPL'
              IPR(551) = 1
              CALL PLA015 (552, 1)
              IPR(453) = 0
              IPR(448) = 0
            END IF
C * CALL ORTEP
            CALL PLA106
            IF (IPR(2) /= 0) THEN
C * ERROR HANDLING
              IGBL(1) = 3
            END IF
C * POLY PLOT
          ELSE IF (IPR(14) == 5) THEN
            MNH(6) = 1
            CALL PLA101
C * PLUTON PLOT
          ELSE IF (IPR(14) == 6) THEN
C * TEST FOR PLA024 'DONE'
            IF (IPR(85) == 0) THEN
              IPR(5) = 0
              CALL PLA024
            END IF
            IF (IGBL(3) /= 13 .AND. IGBL(3) /= 26) THEN
              CALL PLUTON (1)
C * MANAGE LU1
              IGBL(1) = 0
            ELSE
C * EXPLICIT PLUTON
C * HFIX IGBL(3) = 13
C * ANIS IGBL(3) = 26
              CALL PLUTON (-1)
C * TERMINATE JOB
              IGBL(1) = 4
            END IF
            RETURN
          END IF
C * TABL OPTIONS
          IF (IPR(430) > 0) THEN
            IPR(31)  = -1
            IPR(17)  = -1
            IPR(90)  =  1
            IGBL(63) =  0
C * SET UP CONNECTED SET
            CALL PLA067
            IF (IPR(2) == 0) THEN
              CALL PLA171
              IPR(1) = 1
              IF (IPR(2) == 0) IPR(2) = -1
C * ERROR HANDLING
              IGBL(1) = 3
            END IF
          END IF
          RETURN
C * 6 - CALLS TO PLUTON ETC.
        CASE (6)
          GO TO 220
C * 7 - LIST ON DISPLAY OPTION(S)
        CASE (7)
          CALL PLA021 (11, NRETURN)
          RETURN
C * 8 - SHELXT - XTPLOT
        CASE (8)
C * HANDLE XTPLOT
          CALL PLA205
          RETURN
        CASE DEFAULT
C * ERROR HANDLING
          IGBL(1) = 3
          RETURN
      END SELECT
C * CALC INTRA MODE
  220 IF (IPR(31) == 0) THEN
        CALL PLA021 (0, NRETURN)
        IF (NRETURN == 0) RETURN
C * CALC INTER, VOID, SQUEEZE, NEWSYM AND COORDINATION MODE
      ELSE
        CALL PLA021 (1, NRETURN)
        IF (NRETURN == 0) RETURN
      END IF
      IPR(1) = 5
      GO TO 210
      RETURN
99999 FORMAT (/, ':: Escape EXIT from PLATON - ', I4, ' Pages',
     1 ' on FILES ', A, '.lis', /)
99998 FORMAT (/,'SHELXT not Accessible !!', /)
99997 FORMAT (/, ':: CIF-Validation-Check Result on ', A)
99996 FORMAT ('ANGLE (', 3I3, ') (', 3I3, ') =', F10.2, ' Deg.')
99995 FORMAT ('ERROR IN RECORD: ', A)
99994 FORMAT (/, ':: Old/Current Label Size =', F5.2)
99993 FORMAT (   ':: New         Label Size =', F5.2, /)
99992 FORMAT (':: No ATOMS supplied as yet')
99991 FORMAT (/, ':: ', A, /)
99990 FORMAT (':: Rounding Range 1 :', I3)
99989 FORMAT (':: Rounding set to OFF')
99988 FORMAT ('** ', A)
99987 FORMAT (':: LSPL/RING/FIT/LINE calculation will be included in ',
     1        'next CALC GEOM/INTRA run', /)
99986 FORMAT (':: Unrecognised keyword or label (ignored): ', A, /)
99985 FORMAT (':: Transformation on input data with Det =', F6.3, /)
99984 FORMAT (A)
99983 FORMAT (':: AUTO EXEC: Calc Intra',/)
99982 FORMAT (/, ':: Automatic JOIN Instruction (in PLATON section)')
99981 FORMAT (':: ', A)
99980 FORMAT (/, ':: Determinant TM = ', F10.5)
99979 FORMAT (':: No more than', I3, ' Atom Types allowed',
     1             ' on DOAC card', /)
99978 FORMAT (':: No more than', I3, ' Atom Types allowed',
     1             ' on (IN/EX)CLUDE card', /)
99977 FORMAT (':: Bond Type/code = #Lines    Bond Radius (Ang)')
99976 FORMAT (':: Normal   ', I5, I9, 9X, F6.2)
99975 FORMAT (':: To H     ', I5, I9, 9X, F6.2)
99974 FORMAT (':: To Metal ', I5, I9, 9X, F6.2)
99973 FORMAT (':: Saved: ', A)
99972 FORMAT (':: Transformation for x,y,z coordinates', /,
     1        ':: (', 3F8.4, ') (x)  ', F10.4, /,
     1        ':: (', 3F8.4, ') (y) +', F10.4, /,
     1        ':: (', 3F8.4, ') (z)  ', F10.4, /)
99971 FORMAT (/, ':: No CELA & CELB Data given for STRAIN Analysis')
99970 FORMAT (':: SPGR P1 Substituted', /)
99969 FORMAT (':: Coord. Cell:', 3F10.3, 3F10.2, /,
     1        ':: Refln. Cell:', 3F10.3, 3F10.2, /)
99968 FORMAT (':: SHELXL HKLF Matrix:', 9F6.2, /)
99967 FORMAT (//, '>> RESTART <<')
99966 FORMAT (/, 'W: No SU''s on parameters supplied on input', /)
99965 FORMAT (/, ':: Volume From ORMA =', F10.1, ', Please Check')
99964 FORMAT (/, ':: AtomType  EllipsoidType   NumberOfShadeLines', //,
     1           ':: C        ', I10, 10X, I10, /,
     2           ':: H        ', I10, 10X, I10, /,
     3           ':: Other    ', I10, 10X, I10, //,
     4           'Note: Ellipsoid types: 0 = Principle Ellipsoids, ',
     5           ' 1 = Envelope Type', /)
99963 FORMAT (/, '** NO ATOM LIST SORTING WITH ALIASED LABELS **', /)
99962 FORMAT (/, ':: Scattering Factors From: ', A3, ' Used', /)
      END SUBROUTINE PLA002
 
      SUBROUTINE PLA003
C * ERROR REPORT AND HANDLING
      USE files
      USE parameters
      USE plato
      USE atomdata
      USE cchar
      USE mentry
      USE cggt
      USE sgxyz
      IMPLICIT NONE
      INTEGER :: I
      INTEGER :: J
      INTEGER :: LU
      INTEGER :: IUCR
      INTEGER :: NPAGE
      INTEGER :: NLINE
      CHARACTER(len=2) :: DTP
      IGBL(1) = 4
C * CHECK FOR PRINTER LEVEL
      IF (IGBL(63) > 0) THEN
        LU = LU7
        CALL PLA262 (1)
      ELSE
        LU = LU6
      END IF
C * IPR(2) =  0 (NO ERROR)
C * IPR(2) >  0 ERROR NUMBER
C * IPR(2) = -1
C * IPR(2) < -1 : Terminate but do not delete specified file
C * ERROR
   10 IF (IPR(2) > 0) THEN
        SELECT CASE (IPR(2))
C * 1: ATTEMPT TO EXCEED MAX ATOM LIMIT
          CASE (1)
            WRITE (LU, 99984, IOSTAT = IOST) NP1
C * ALERT _807
            CALL PLA236 (807, 0, 1.0, 1.0, ' ', ' ')
            IF (IGBL(3) == 1) THEN
              IF (IGBL(36) /= 0) CALL PLA230 (0)
            END IF
            IGBL(1) = 4
            RETURN
C * 2: LABEL PREOCCURRED
          CASE (2)
            WRITE (LU, 99977, IOSTAT = IOST) NQ1
C * 3: UNSUITABLE ATOM LABEL
          CASE (3)
            WRITE (LU, 99978, IOSTAT = IOST) NQ0
C * ALERT _071
            CALL PLA236 (71, 0, 1.0, 1.0, NQ1, NQ1)
            IF (IGBL(3) == 1) THEN
C * TEST FOR CHECK MODE
              IF (IGBL(36) /= 0) THEN
                CALL PLA230 (0)
                IGBL(1) = 1
              END IF
              GO TO 70
            ELSE
              GO TO 30
            END IF
C * 4: LABEL INCONSISTENT
          CASE (4)
            WRITE (LU, 99983, IOSTAT = IOST) IFL(2), NQ4
C * 5: NOT ENOUGH DATA ON CARD
          CASE (5)
            IF (LU == LU6) THEN
              WRITE (LU, 99982, IOSTAT = IOST) ICL(1:76)
              CALL PLA015 (0, 49)
              IF (IPR(470) == 1) WRITE (LU, 99961, IOSTAT = IOST)
            END IF
C * 6: INVALID ELEMENT SYMBOL
          CASE (6)
            WRITE (LU, 99981, IOSTAT = IOST) NQ1(1:3)
C * 7: UNKNOWN CARD ERROR
          CASE (7)
            IF (LU == LU6) WRITE (LU, 99992, IOSTAT = IOST) ICL(1:30)
C * 8: TOO MANY ATOMS SPECIFIED
          CASE (8)
            WRITE (LU, 99976, IOSTAT = IOST) NP1
C * 9: FVAR ERROR (SHELX INPUT STYLE)
          CASE (9)
            WRITE (LU, 99975, IOSTAT = IOST)
            GO TO 30
C * 10: POPULATION PARAMETER OVERFLOW
          CASE (10)
            IF (IGBL(36) /= 0) THEN
C * _815 ALERT
              CALL PLA236 (815, 0,    1.0, 1.0, ' ', ' ')
C * TEST FOR CHECK MODE
              CALL PLA230 (0)
              IGBL(1) = 4
              GO TO 70
            ELSE
              WRITE (LU6, 99974, IOSTAT = IOST)
              GO TO 30
            END IF
C * 11: INSTRUCTION NOT ALLOWED
          CASE (11)
            WRITE (LU, 99972, IOSTAT = IOST) IFL(1)
C * 12: PLOT INSTRUCTION NOT ALLOWED HERE
          CASE (12)
            IF (LU == LU6) WRITE (LU, 99970, IOSTAT = IOST)
C * 13: SPECIFIED RESIDUE NUMBER NOT PRESENT
          CASE (13)
            IF (LU == LU6) WRITE (LU, 99960, IOSTAT = IOST) IPR(140)
C * 14:
          CASE (14)
C * 15: TRNS (FIX) INSTRUCTION N.O.K.
          CASE (15)
            IF (LU == LU6) WRITE (LU, 99957, IOSTAT = IOST)
C * 16: INVALID ELEMENT SYMBOL
          CASE (16)
            WRITE (LU, 99981, IOSTAT = IOST) NQ3(1:3)
C * 17: TRANSLATION CODE OUT-OF-RANGE
          CASE (17)
            WRITE (LU, 99947, IOSTAT = IOST) (ITR(I), I = 1, 3), NQ1
            GO TO 30
C * 18: INVALID SUB-KEYWORD or ATOM NAME/TYPE
          CASE (18)
            IF (LU == LU6) WRITE (LU, 99949, IOSTAT = IOST)
C * 19: VOID ARRAY OVERFLOW
          CASE (19)
            IF (LU == LU6) WRITE (LU, 99946, IOSTAT = IOST) NVDR
C * 20: Input and Output Files with the same <name.res>
          CASE (20)
            IF (LU == LU6) WRITE (LU, 99944, IOSTAT = IOST)
            GO TO 20
C * 21:
          CASE (21)
C * 22: NOT ENOUGH OVERLAP MEMORY
          CASE (22)
             IF (LU == LU6) WRITE (LU, 99943, IOSTAT = IOST)
C * 23: TOO MANY AXES (ADDSYM) CONDITION
          CASE (23)
            WRITE (LU, 99942, IOSTAT = IOST) PAR(43)
C * 24: TOO MANY SOLVENT AREAS
          CASE (24)
            WRITE (LU, 99940, IOSTAT = IOST)
C * 25: LMX/PLA091 ERROR
          CASE (25)
            WRITE (LU, 99939, IOSTAT = IOST)
            GO TO 30
C * 26: OVERFLOW IN VOID-ROUTINE (NP1)
          CASE (26)
            WRITE (LU, 99938, IOSTAT = IOST)
C * 27: SYMM/TRNS ERROR
          CASE (27)
            WRITE (LU, 99937, IOSTAT = IOST)
C * 28: ARU-OUT OFF RANGE
          CASE (28)
            IPR(600) = IPR(600) + 1
            IF (IGBL(3) == 1) THEN
              IF (IGBL(36) /= 0) CALL PLA230 (0)
              IF (IGBL(3) == 36) THEN
                IGBL(1) = 4
              END IF
              RETURN
            ELSE
              IF (IPR(600) < 10) WRITE (LU, 99935, IOSTAT = IOST)
            END IF
C * 29: TMA-CALCULATION OUT-OF-SEQUENCE
          CASE (29)
            WRITE (LU, 99934, IOSTAT = IOST)
C * 30: TOO MANY FVAR-PARAMETERS
          CASE (30)
            WRITE (LU, 99932, IOSTAT = IOST)
            GO TO 30
C * 31:
          CASE (31)
            WRITE (LU, 99931, IOSTAT = IOST)
C * 32: NON-RECOVERABLE PROBLEM
          CASE (32)
            WRITE (LU, 99929, IOSTAT = IOST) IPR(323)
            IF (LU /= LU6) WRITE (LU6, 99929, IOSTAT = IOST) IPR(323)
            GO TO 70
C * 33: CALC SOLV/VOID NOT ALLOWED IN ANGSTROM MODE
          CASE (33)
            WRITE (LU, 99928, IOSTAT = IOST)
C * 34: FACE DIST < 0
          CASE (34)
            WRITE (LU, 99923, IOSTAT = IOST)
C * 35: NO MU-PROVIDED FOR ABSGAUSS or ABSTOMPA
          CASE (35)
            WRITE (LU, 99921, IOSTAT = IOST)
            GO TO 30
C * 36: UNKNOWN ELEMENT TYPE ON SFAC LINE
          CASE (36)
            WRITE (LU, 99920, IOSTAT = IOST)
            GO TO 30
C * 37: NO VALID DIRCOS
          CASE (37)
            WRITE (LU, 99916, IOSTAT = IOST)
            GO TO 30
C * 38: NO VALID PSI-SCAN DATA
         CASE (38)
            WRITE (LU, 99915, IOSTAT = IOST)
            GO TO 30
C * 39: No Refl Supplied
          CASE (39)
            WRITE (LU, 99914, IOSTAT = IOST)
            GO TO 30
C * 40: NO TRMX WITH NEG DET ON HKLF
          CASE (40)
            WRITE (LU, 99913, IOSTAT = IOST)
            GO TO 30
C * 41: UNKNOWN ELEMENT ON SFAC
          CASE (41)
            WRITE (LU, 99912, IOSTAT = IOST)
            GO TO 30
C * 42: NO VALID ATOMS
          CASE (42)
C * ALERT _011
            IF (IGBL(3) == 1) THEN
              CALL PLA236 (11, 0, 1.0, 1.0, ' ', ' ')
              IGBL(36) = 1
              CALL PLA230 (0)
              IGBL(1) = 4
              RETURN
            ELSE
              WRITE (LU, 99911, IOSTAT = IOST)
              GO TO 30
            END IF
C * 43: NO .hkl or .fcf
          CASE (43)
            WRITE (LU, 99910, IOSTAT = IOST)
     1        NAMEFIL(1:KNMFIL), NAMEFIL(1:KNMFIL)
            GO TO 30
C * 44: NO .hkl file given
          CASE (44)
            WRITE (LU, 99909, IOSTAT = IOST) NAMEFIL(1:KNMFIL)
            GO TO 30
C * 45: SOMETHING WRONG WITH U/UIJ
          CASE (45)
            WRITE (LU, 99907, IOSTAT = IOST) IPR(498)
            GO TO 30
C * 46: NO-SFAC PROBLEM
          CASE (46)
            WRITE (LU, 99906, IOSTAT = IOST) NQ1
            GO TO 30
C * 47: NO LAMBDA GIVEN
          CASE (47)
            WRITE (LU, 99904, IOSTAT = IOST) MAX (0.0, PAR(17))
C * 48: VOID TOO-LARGE
          CASE (48)
            WRITE (LU, 99901, IOSTAT = IOST)
C * 49: SCRATCH OVERRUN IN EXOR/FMAP
          CASE (49)
            WRITE (LU, 99900, IOSTAT = IOST) NP1
            GO TO 30
C * 50: INCOMPLETE UIJ(SUIJ) DATA ON CIF
          CASE (50)
            IF (IGBL(3) == 1) THEN
              IGBL(36) = 1
              LINE     = NAMEFIL(1:KNMFIL)//'.chk'
              WRITE (LU6, 99842, IOSTAT = IOST) LINE
C * ALERT _806
              CALL PLA236 (806, 0, 1.0, 1.0, ' ', ' ')
C * TEST FOR CHECK MODE
              IF (IGBL(36) /= 0) THEN
                CALL PLA230 (0)
                IGBL(1) = 1
              END IF
              GO TO 70
            ELSE
              WRITE (6, 99898, IOSTAT = IOST) IFL(2)
              GO TO 30
            END IF
C * 51: INCOMPLETE ATOM DATA ON CIF
          CASE (51)
            WRITE (6, 99896, IOSTAT = IOST) IFL(2)
C * ALERT _805
            CALL PLA236 (805, 0, 1.0, 1.0, ' ', ' ')
            GO TO 20
C * 52:
          CASE (52)
            WRITE (LU, 99895, IOSTAT = IOST)
            GO TO 30
C * 53:
          CASE (53)
            WRITE (LU, 99894, IOSTAT = IOST)
            GO TO 30
C * 54: SYMM-LABEL PACK PROBLEM
          CASE (54)
            WRITE (LU, 99892, IOSTAT = IOST)
C * 55: NO REFLECTION DATA PROBLEM
          CASE (55)
            WRITE (LU, 99891, IOSTAT = IOST)
C * 56: NO DIR-COS
          CASE (56)
            WRITE (6, 99888, IOSTAT = IOST)
            GO TO 20
C * 57: LABEL ALIAS OVERFLOW
          CASE (57)
            WRITE (6, 99885, IOSTAT = IOST)
C * TEST FOR PREVIOUS CALC UNIQUE (NO = 0)
            IF (IGBL(61) == 0 .AND. IPR(30) == 0) THEN
              IGBL(61) = 1
C * RESET INPUT
              CALL PLA286 (1)
              CALL GEN108 (LU20, 0)
              IPR(2) = 0
              GO TO 70
            END IF
C * ALERT _071
            CALL PLA236 (71, 0, 1.0, 1.0, NQ1, NQ1)
C * 58: CELL PROBLEM
          CASE (58)
            IF (IGBL(3) == 1) THEN
              IGBL(36) = 1
              LINE     = NAMEFIL(1:KNMFIL)//'.chk'
              WRITE (LU6, 99842, IOSTAT = IOST) LINE
C * ALERT _801
              CALL PLA236 (801, 0, 1.0, 1.0, ' ', ' ')
C * TEST FOR CHECK MODE
              IF (IGBL(36) /= 0) THEN
                CALL PLA230 (0)
                IGBL(1) = 1
              END IF
            ELSE
C * CELL PROBLEM
              WRITE (6, 99848, IOSTAT = IOST)
            END IF
            GO TO 70
C * 59: CIF-LINE TOO LONG
          CASE (59)
            IF (IGBL(3) == 1) THEN
              IPR(544) = IPR(544) + 1
C * TEST FOR CHECK MODE
              IF (IGBL(36) /= 0) THEN
                CALL PLA230 (0)
                IGBL(1) = 1
              END IF
            ELSE
C * CIF-LINE LONGER THAN 2048 CHARACTERS
              WRITE (6, 99847, IOSTAT = IOST)
            END IF
            GO TO 70
C * 60: CIF-LOOP PROBLEM
          CASE (60)
            IF (IGBL(3) == 1) THEN
C * ALERT _803
              CALL PLA236 (803, 0, 1.0, 1.0, ' ', ' ')
C * TEST FOR CHECK MODE
              IF (IGBL(36) /= 0) THEN
                CALL PLA230 (0)
                IGBL(1) = 1
              END IF
            ELSE
C * CIF-LOOP PROBLEM
              WRITE (6, 99846, IOSTAT = IOST)
            END IF
            GO TO 70
C * 61: READ/FORMAT ERROR
          CASE (61)
            WRITE (6, 99853, IOSTAT = IOST)
            GO TO 20
C * 62: NSP-Problem
          CASE (62)
            WRITE (LU6, 99852, IOSTAT = IOST)
            GO TO 30
C * 63: TRNS/TRMX PROBLEM
          CASE (63)
            WRITE (LU6, 99850, IOSTAT = IOST)
            GO TO 20
C * 64: DATA FORMAT NOT VALID/RECOGNISED
          CASE (64)
            WRITE (LU6, 99849, IOSTAT = IOST)
            IPR(2) = 0
C * 65: HKLF4 Required
          CASE (65)
            WRITE (LU, 99843, IOSTAT = IOST)
C * 66: Obverse Setting Only
          CASE (66)
            GO TO 20
C * 67: Too many ALIASES
          CASE (67)
            WRITE (LU6, 99841, IOSTAT = IOST) NP36
            IF (IGBL(3) == 1) THEN
C * ALERT _812
              CALL PLA236 (812, 0, 1.0, FLOAT (NP36), ' ', ' ')
              IF (IGBL(36) /= 0) CALL PLA230 (0)
            END IF
            IGBL(1) = 4
            RETURN
C * 68: Unsuitable file type combination for SQUEEZE
          CASE (68)
            WRITE (LU6, 99840, IOSTAT = IOST) IGBL(29), IPR(619)
            IF (IPR(619) == 1) WRITE (LU6, 99839, IOSTAT = IOST)
            WRITE (LU6, 99838, IOSTAT = IOST)
            IGBL(1) = 5
            RETURN
C * 69: No Matching Reflection Data Entry found
          CASE (69)
            WRITE (LU6, 99833, IOSTAT = IOST) JID(1:8)
            GO TO 20
C * 70: No Numerical data on HKLF record
          CASE (70)
            IF (IGBL(3) == 1) THEN
C * _813 ALERT
              CALL PLA236 (813, 0, -999.0, 1.0, ' ', ' ')
C * TEST FOR CHECK MODE
              IF (IGBL(36) /= 0) THEN
                CALL PLA230 (0)
                IGBL(1) = 1
              END IF
              GO TO 70
            ELSE
              WRITE (LU6, 99832, IOSTAT = IOST)
              GO TO 30
            END IF
C * 71: Unsuitable file type combination for HYBRID
          CASE (71)
            WRITE (LU6, 99837, IOSTAT = IOST)
            IGBL(1) = 4
            RETURN
C * 72: Unsuitable file type: RES file (.ins or ,res) needed
          CASE (72)
            WRITE (LU6, 99836, IOSTAT = IOST)
            GO TO 20
C * 73: Determinant of the transformation matrix = 0.0
          CASE (73)
            WRITE (LU6, 99835, IOSTAT = IOST)
            GO TO 20
C * 74: General PROBLEM STOP
          CASE (74)
            GO TO 20
C * 75: NO SQUEEZE with EXTI based CIF/FCF
          CASE (75)
            WRITE (LU6, 99834)
            IGBL(1) = 4
            RETURN
C * 76: Inconsistent CIF/FCF
          CASE (76)
            WRITE (LU6, 99936)
            IGBL(1) = 4
            RETURN
        END SELECT
C * NON-FATAL ERROR
        IF (LU == LU7) GO TO 50
        IPR(2) = 0
        CALL GEN038 (IGGT, 1, 80)
        IGBL(6)  = 10
        IGBL(24) = 1
        IF (LU == LU6) WRITE (LU, 99980, IOSTAT = IOST) CHAR (IPR(223))
        GO TO 40
C * FATAL ERROR (EXECUTE EXIT STATEMENT)
   20   FNLU1 = NAMEFIL(1:KNMFIL)//'.'//EXTENS(1:KXT)
        KNMXT = KNMFIL + KXT + 1
        WRITE (6, 99897, IOSTAT = IOST) FNLU1(1:KNMXT)
C * CALL EXIT/STOP
        CALL GEN127 (' ')
C * FATAL ERROR (EXECUTE END STATEMENT)
   30   IF (LU == LU7) GO TO 50
        IPR(2) = 0
        WRITE (LU, 99979, IOSTAT = IOST)
        IF (IGBL(54) < IGBL(100)) THEN
          IGBL(54) = IGBL(54) + 1
          FN(1)    = IGBL(54)
          IPR(220) = 1
          IPR(221) = 1
          CALL PLA007
          IGBL(5)  = LU5
          IGBL(1)  = 1
          IPR(121) = 0
          GO TO 70
        END IF
      END IF
C * TERMINATE ?
   40 IF (IPR(2) /= 0) THEN
        IF (LU == LU7 .OR. IGBL(63) == 0) THEN
C * TEST FOR CHECK-MODE
C * TEST FOR PREVIOUS CALC UNIQUE (NO = 0)
          IUCR = IABS(IGBL(8) * IPR(30))
          IF (IUCR == 3 .OR. IUCR == 4) THEN
            IF (IGBL(36) /= 0 .AND. IPR(734) == 0) CALL PLA230 (0)
          END IF
        END IF
C * TEST FOR NON-ANGSTROM DATA
        IF (IPR(23) == 0) THEN
          PAGET = 'SUMMARY '
          IF (LU == LU7 .AND. IGBL(63) > 3 .AND.
     1        IGBL(7) > 0) THEN
            IF (IPR(2) <= 0 .AND. IPR(3) <= 0) THEN
C * CHECK FOR CIF-DATA
              IF (IABS(IGBL(8)) == 3 .AND. PAR(160) /= 0.0)
     1          CALL PLA172 (0, 1, 1)
              CALL PLA262 (0)
              WRITE (LU, 99962, IOSTAT = IOST)
     1          HTTPSERVER(1:IGBL(135))//'xraysoft',
     2          HTTPSERVER(1:IGBL(135) - 1)
            END IF
          END IF
        END IF
        IF (IPR(3) >= 0 .AND. IPR(37) > 0) THEN
          IF (LU == LU7) THEN
            CALL PLA262 (0)
            CALL PLA262 (-999)
          END IF
          WRITE (LU, 99991, IOSTAT = IOST)
C * FRACTIONAL COORDINATES CASE WARNINGS AND NOTES
          IF (IPR(23) == 0) THEN
            IF (PAR(17)  < 0.001)    WRITE (LU, 99999, IOSTAT = IOST)
            IF (PAR(107) < 0.00001)  WRITE (LU, 99998, IOSTAT = IOST)
            IF (IGBL(30) == 1)       WRITE (LU, 99997, IOSTAT = IOST)
            IF (IGBL(52) == 1)       WRITE (LU, 99996, IOSTAT = IOST)
          END IF
C * MODIFIED RESIDUE-PACKING WARNING
          IF (IPR(129) < 10) WRITE (LU, 99948, IOSTAT = IOST)
C * EXTRA SYMMETRY NOTE
          IF (IPR(209) /= 0)  WRITE (LU, 99951, IOSTAT = IOST)
C * SPECIAL INVERSION SYMMETRY NOTE
          IF (IPR(118) /= 0) WRITE (LU, 99925, IOSTAT = IOST)
C * ADDITIONAL TRANSLATION
          IF (IPR(459) /= 0) WRITE (LU, 99903, IOSTAT = IOST)
C * WARNING NO E.S.D. PARAMETERS
          IF (IPR(72)  == 0) WRITE (LU, 99956, IOSTAT = IOST)
          IF (IPR(130) == 1) WRITE (LU, 99995, IOSTAT = IOST)
          IF (IPR(124) /= 0) WRITE (LU, 99886, IOSTAT = IOST)
          IF (IGBL(8)  == 2) WRITE (LU, 99973, IOSTAT = IOST)
C * NO EXPLICIT SPACE GROUP SPECIFIED
          IF (IPR(23) == 0 .AND. IPR(202) == 0)
     1      WRITE (LU, 99950, IOSTAT = IOST)
C * REDUCED NUMBER OF ALLOWED RESIDUES (CUBIC SYMMETRY)
          IF (PAR(42) < 100.0) WRITE (LU, 99927, IOSTAT = IOST)
C * DISORDERED WARNING
          IF (IPR(44) == 1) WRITE (LU, 99988, IOSTAT = IOST)
C * WARNING NON-INTEGRAL ATOM NUMBER IN UNITCELL
          IF (IPR(215) > 0) WRITE (LU, 99952, IOSTAT = IOST)
C * NO HYDROGEN ATOMS IN STRUCTURE (CRYSTAL)
          IF (IPR(23) == 0 .AND. IPR(484) == 0)
     1      WRITE (LU, 99933, IOSTAT = IOST)
C * WARNING FOR ISOLATED H-ATOMS
          IF (IPR(153) > 0) WRITE (LU, 99959, IOSTAT = IOST) IPR(153)
C * WARNING FOR ISOLATED O-ATOMS
          IF (IPR(161) > 0) WRITE (LU, 99889, IOSTAT = IOST) IPR(161)
C * WARNING SHORT INTRA/INTER CONTACTS
          IF (IPR(160) > 0) WRITE (LU, 99958, IOSTAT = IOST)
     1     IPR(160), PAR(199), PAR(200)
C * WARNING SHORT INTRA/INTER CONTACTS (H-H)
          IF (IPR(403) > 0) WRITE (LU, 99924, IOSTAT = IOST)
     1      IPR(403), PAR(251), PAR(252)
          IF (IPR(404) > 0) WRITE (LU, 99918, IOSTAT = IOST)
     1      IPR(404), PAR(253), PAR(254)
C * NUMBER OF ISOTROPIC NON-H ATOMS
          IF (IPR(489) + IPR(490) > 0) THEN
            WRITE (LU, 99930, IOSTAT = IOST) IPR(489) + IPR(490)
          END IF
          IF (IPR(50)  > 0) WRITE (LU, 99966, IOSTAT = IOST) IPR(50)
          IF (IPR(204) > 0) WRITE (LU, 99965, IOSTAT = IOST) IPR(204)
          IF (IPR(498) > 0) WRITE (LU, 99907, IOSTAT = IOST) IPR(498)
          IF (PAR(387) < 1.0) WRITE (LU, 99887, IOSTAT = IOST)
     1      PAR(387)
          IF (IPR(93)  == 1) WRITE (LU, 99990, IOSTAT = IOST)
     1      ((TM1(I, J), J = 1, 3), I = 1, 3)
          IF (IPR(139) == 1) WRITE (LU, 99968, IOSTAT = IOST)
     1      (SHFT(I), I = 1, 3)
          IF (IPR(100) > 0) WRITE (LU, 99989, IOSTAT = IOST) IPR(100)
          IF (IPR(101) > 0) WRITE (LU, 99987, IOSTAT = IOST) IPR(101)
          IF (IPR(171) > 0) WRITE (LU, 99963, IOSTAT = IOST)
     1      PAR(30), IPR(171)
          IF (IPR(172) > 0) WRITE (LU, 99945, IOSTAT = IOST)
     1      PAR(30), IPR(172)
          IF (IPR(102) > 0) WRITE (LU, 99986, IOSTAT = IOST) IPR(102)
          IF (IPR(103) > 0) WRITE (LU, 99985, IOSTAT = IOST) IPR(103)
          IF (IPR(401) > 0) WRITE (LU, 99922, IOSTAT = IOST) IPR(401)
          IF (IPR(402) > 0) WRITE (LU, 99919, IOSTAT = IOST) IPR(402)
          IF (IPR(471) /= 0) WRITE (LU, 99993, IOSTAT = IOST)
     1      IPR(471), IPR(472)
C * REPORT # ALIASES (WHEN > 0)
          IF (IPR(759) > 0) WRITE (LU, 99994, IOSTAT = IOST) IPR(759)
          IF (IPR(135) > 0) WRITE (LU, 99971, IOSTAT = IOST) IPR(135)
          IF (IPR(138) > 0) WRITE (LU, 99969, IOSTAT = IOST) IPR(138)
          IF (PAR(150) > 0) WRITE (LU, 99941, IOSTAT = IOST)
     1      NINT(PAR(150))
          IF (PAR(354) > 0) WRITE (LU, 99926, IOSTAT = IOST)
     1      NINT(PAR(354))
          IF (IPR(126) > 0) WRITE (LU, 99899, IOSTAT = IOST) IPR(126)
          IF (IPR(429) > 0) WRITE (LU, 99893, IOSTAT = IOST) IPR(429)
C * NUMBER of NON_HBONDED D-H
          IF (IPR(405) > 0) WRITE (LU, 99917, IOSTAT = IOST) IPR(405)
C * OVERFLOW IN INTER MODE
          IF (IPR(149) > 0) WRITE (LU, 99967, IOSTAT = IOST) IPR(149)
C * INTER ARU-Problem
          IF (IPR(494) > 0) WRITE (LU, 99902, IOSTAT = IOST) IPR(494)
          WRITE (LU, 99953, IOSTAT = IOST)
        END IF
C * TEST FOR PRINT LEVEL AND OPEN LU7
        IF (IGBL(63) > 0 .AND. IGBL(7) > 0) THEN
C * CHECK FOR SHELXL201x RES
          IF (IPR(663) /= 0) THEN
            DTP = '14'
          ELSE
            DTP = '  '
          ENDIF
          FNLU1 = NAMEFIL(1:KNMFIL)//'.'//EXTENS(1:KXT)
          KNMXT = KNMFIL + KXT + 1
          IF (FNLU1(1:5) /= 'zz123' .AND. IGBL(8) /= 0) THEN
            WRITE (LU, 99905, IOSTAT = IOST) FNLU1(1:KNMXT),
     1        DTYPE(IABS (IGBL(8)))(1:3)//DTP
            IF (IGBL(9) > 0 .AND. IGBL(9) < 28) THEN
              IF (LU == LU7) CALL PLA262 (2)
              WRITE (LU, 99845, IOSTAT = IOST) FNLU16(1:KNM16),
     1          RDTYP(IGBL(9))
            END IF
          END IF
C * OPEN FILES FOR .ins & .res from .cif & .fcf
C * CHECK FOR 'special .res' and 'xtplot'
          IF (IGBL(131) == 1 .AND. IGBL(138) == 0) THEN
              WRITE (LU, 99844, IOSTAT = IOST)
     1          NAMEFIL(1:KNMFIL)//'_sx.ins',
     1                          NAMEFIL(1:KNMFIL)//'_sx.hkl'
          END IF
          NPAGE = IGBL(49)
          IF (IGBL(7) == 1) THEN
            LINE = NAMEFIL(1:KNMFIL)
            NLINE = KNMFIL
          ELSE IF (IGBL(7) == 2) THEN
            LINE = NAMEFIL(1:KNMFIL)//'_sq'
            NLINE = KNMFIL + 3
          END IF
          IF (IPR(2) < 0) THEN
C * RESET VIEW
            IGBL(67) = 0
            IF (IGBL(70) == 1) THEN
              IF (IGBL(116) /= 0 .AND. IGBL(130) /= 0) THEN
                WRITE (LU, 99955, IOSTAT = IOST) NPAGE, LINE(1:NLINE),
     1            LINE(1:NLINE), LINE(1:NLINE)
              ELSE
                WRITE (LU, 99955, IOSTAT = IOST) NPAGE, LINE(1:NLINE),
     1            LINE(1:NLINE)
              END IF
            ELSE
              WRITE (LU, 99855, IOSTAT = IOST) NPAGE, LINE(1:NLINE)
            END IF
          ELSE
            WRITE (LU, 99954, IOSTAT = IOST) NPAGE, LINE(1:NLINE),
     1        LINE(1:NLINE)
          END IF
        END IF
        IGBL(8) = IABS (IGBL(8))
      END IF
C * SWITCH FROM  LIST-FILE TO ASCII WINDOW
   50 IF (LU == LU7) THEN
        LU = LU6
        GO TO 10
      END IF
C * TEST ERROR-FLAG (IPR(2))
      IF (IPR(1) == 1 .OR.
     1    IPR(1) == 2 .OR.
     2    IPR(1) == 4 .OR.
     3    IPR(1) == 5 .OR.
     4    IPR(1) == 6 .OR.
     5    IPR(1) == 7) THEN
        IF (IPR(2) == 0) IGBL(1) = 1
      ELSE IF (IPR(1) == 3 .AND. IGBL(8) /= 2) THEN
        READ (LU1, 99964, IOSTAT = IOST) ICL(1:80)
        IF (IOST == 0) THEN
          BACKSPACE LU1
          IGBL(1) = 1
        END IF
      END IF
C * ERROR RECOVERY FOR AUTO SEQUENCE
      IF (IPR(3) == 1) THEN
        IGBL(5) = LU1
        IGBL(1) = 1
      END IF
C * TEST FOR KPI MODE
   70 IF (IGBL(3)  ==  36) IGBL(1) = 4
      IF (IPR(2)   == -11) IGBL(1) = 4
C * HANDLE SQUEEZE CASE
      IF (IGBL(31) ==  10) IGBL(1) = 4
      RETURN
99999 FORMAT ('W: No wavelength given.')
99998 FORMAT ('W: No Cell estimated standard deviation (CESD) given.')
99997 FORMAT ('W: NOMOVE option used.', /, ':: >>> WARNING:',
     1 ' ''CONNECTED INPUT SET'' is assumed to be TRUE', /,
     2 ':: >>> The Network Analysis may be INCORRECT when this',
     3 '  assumption is FALSE')
99996 FORMAT ('W: NOSYMM option used. (No Symmetry applied)')
99995 FORMAT ('E: Maximum residue number exceeded.')
99994 FORMAT ('N: Number of modified (= # ) ATOM labels ',
     1             33('.'),  I5)
99993 FORMAT ('N: Number of Ignored Lines on INPUT ', 38('.'),
     1   I5, /, 10X, 'of which blank in column 1 ', 37('.'), I5)
99992 FORMAT (':: ** Instruction N.O.K. ** :', A, /,
     1 ':: Check also for mistyped ATOM labels and ATOM types')
99991 FORMAT (/, 80('='), /,
     1 'Summary and Remarks : N = NOTE, W = WARNING, E = ERROR',
     2 /, 80('='))
99990 FORMAT ('N: Input Data following TRNS ',
     1        '[e.g. (CELL/CESD)/SPGR/COORDS/'
     1 ,'UIJ)] have been', /, 4X, 'transformed according to the ',
     2 'specified Cell Transformation Matrix: ', 3(/, 20X, 3F10.5))
99989 FORMAT ('N: Number of deleted ATOMS from input stream ',
     1        29('.'), I5)
99988 FORMAT ('N: DISORDERED structure - ATOMS with Pop. .LT.',
     1 ' 1.0 are not moved or as a group.')
 
99987 FORMAT ('N: Number of detected and excluded disorder',
     1        ' operations ',14('.'), I5)
99986 FORMAT ('W: Number of valency check faults for H & C ',
     1        30('.'), I5)
99985 FORMAT ('W: Number of unusual bond angle faults ', 35('.'), I5)
99984 FORMAT (/, ':: FATAL attempt to EXCEED the max.ATOMS limit:', I5)
99983 FORMAT (':: U/UIJ/SUIJ/B/BIJ/SBIJ/ label: ', A, /, 4X,
     1 'inconsistent with ATOM label: ', A, /)
99982 FORMAT (':: Error - Not Enough Data Items on Input Line:',
     1        /, 3X, A)
99981 FORMAT (':: Error - Invalid Element Symbol: ', A)
99980 FORMAT (':: Last Line(s) Ignored', A, /)
99979 FORMAT (':: END Statement Executed for this Entry')
99978 FORMAT (//, ':: Unsuitable Keyword/ATOM label : ', A, //,
     1        3X, 'Legal are: C, H999, O(3), FE(77)', /)
99977 FORMAT (//, ':: Label ', A, ' pre-occurred '/)
99976 FORMAT (':: Too many ATOMS specified, Max.Nr:', I5)
99975 FORMAT (':: FVAR - error')
99974 FORMAT (':: Population parameter OVERFLOW')
99973 FORMAT ('N: SHELXL-style data input.')
 
99972 FORMAT (':: Instruction ', A, ' NOT allowed at this point')
99971 FORMAT ('W: Number of unusual anisotropic displacement ',
     1        'parameters ', 17('.'), I5)
99970 FORMAT (':: * The PLOT instructions should be given after the',
     1 ' execution of ', /, 4X, 'the -CALC INTRA- instruction')
99969 FORMAT ('W:', I5, ' Times MOL-list overflow. Results ????')
99968 FORMAT ('N: Input data (COORDINATES) have been transformed',
     1 /, 4X, 'according to additive coordinate shift vector: ', /,
     2 20X, 3F10.5)
99967 FORMAT ('W: array OVERFLOW in INTER-mode (Results INCOMPLETE)',
     1 ' Code nnmmkk =', I8)
99966 FORMAT ('N: Number of positions fixed with TRNS by user ',
     1        27('.'), I5)
99965 FORMAT ('N: Number of moved primary input atoms: ',34('.'), I5)
99964 FORMAT (A)
99963 FORMAT ('N: Number of Unspecified Non-H Displacement ',
     1        'Parameters set to U =', F5.2, 1X, 3('.'), I5)
99962 FORMAT (//, 58X, 11('='), /, 57('*'), ' N O T I C E ', 50('*'),
     1 /, 58X, 11('='), //, '- PLATON References : Spek, A.L. (2003). ',
     2 'J. Appl. Cryst. 36, 7-13.', /, 22X, 'Spek, A.L. (2009). ',
     3 'Acta Cryst. D65, 148-155.', /, 22X, 'Spek, A.L. (2015). ',
     4 'Acta Cryst. C71, 9-18.', /, 22X, 'Spek, A.L. (2018). ',
     5 'Inorg. Chim. Acta, 470, 232-237.', /, 22X, 'Spek, A.L. (2020).',
     6 ' Acta Cryst. E76, 1-11.', //, '- Output Values (Esd) may ',
     7 'have been (re)set to 99, 999 or 9999 to Avoid Format Overflow.',
     8 //, '- Derived Parameter SU''s (= Esd''s) may be Incorrect in',
     9 ' Cases where Covariances in the Atom Parameters should have',
     * ' been taken', /, '  into Account (e.g. Those Involving Atoms',
     1 ' That were Refined with Constraints).', //, '- ROUNDING, in',
     2 ' particular of the Input Coordinate Data, may give deviating',
     3 ' values for derived geometry parameters.', /, '  However,',
     4 ' differences should be within the associated esd-range.', //,
     5 '- PLATON is Research Program. The Implementation of',
     6 ' Additional Options is Planned. Some of the More Advanced', /,
     7 2X, 'Features are Experimental and may Contain Loose Ends.',//,
     8 '- The Communication of Glitches Encountered will be',
     9 ' Appreciated: E-mail: a.l.spek@uu.nl', //,
     * '- Recent versions of PLATON may be obtained from: ', A, //,
     1 '- More INFO can be found on : ', A, //)
99961 FORMAT (':: Following data will be skipped until End-Of-',
     1        'Section')
99960 FORMAT (':: Specified  RESIDUE number:', I3, ' NOT present')
99959 FORMAT ('W: Structure contains', I3,' isolated H-atom(s).')
99958 FORMAT ('W: Structure contains', I3, ' Intra/Inter contacts',
     1        ' < Sum(vdWrad) ', F5.2, ' A (max ', F5.2,')')
99957 FORMAT (':: TRNS (FIX) instruction N.O.K.')
99956 FORMAT ('N: No S.U.''s (esd) on observed/calculated parameters.')
99955 FORMAT (':: NORMAL END of PLATON :', I6, ' Pages on:', /,
     1        ':: ', A, '.lis (ASCII, 132 Characters Wide)', /,
     2        ':: ', A, '.lps (PostScript Version of .lis)', /,
     3        ':: ', A, '.pdf (PDF        Version of .lis)', /)
99954 FORMAT (':: ABNORMAL END of PLATON :', I6, ' Pages on:', /,
     1        A, '.lis ASCII)', /, A, '.lps (PostScript)', /)
99953 FORMAT (80('='), /)
99952 FORMAT ('W: Unit cell contains non-integral number of atoms',
     1 ' (please check).')
99951 FORMAT ('N: ADDSYM finds additional (pseudo)symmetry in the',
     1 ' structure (please check!)')
99950 FORMAT ('N: No Explicit space group name specified')
 
99949 FORMAT (':: Sub-keyword NOT Acceptable')
99948 FORMAT ('N: Maximum Residue Number Reduced',
     1        ' (Round ARU to 0.1 units)')
99947 FORMAT ('E: Translation code [', 3I3, '] out-of-range -4:4',
     1        ' for ', A)
99946 FORMAT (':: Void-array overflow, Raise NVDR to value > ', I7)
99945 FORMAT ('N: Number of Unspecified     H Displacement ',
     1        'Parameters set to U =', F5.2, 1X, 3('.'), I5)
99944 FORMAT ('!! Error: Input and Output with the same <name.res>')
99943 FORMAT (':: Not enough storage available to handle OVERLAP')
99942 FORMAT (':: Too many axes found. Rerun with obl. ang. <', F4.1)
99941 FORMAT ('N: Total Potential Solvent Accessible Void Vol ',
     1            ' (SOLV-Map Value) ', 3('.'), I6, ' Ang^3')
99940 FORMAT (':: Too many independent solvent areas')
99939 FORMAT (':: STOP LMX/PLA091')
99938 FORMAT (':: Overflow in VOID/SOLV routine (NP1)')
99937 FORMAT (':: No SYMM matrix allowed with TRNS option')
99936 FORMAT (':: Inconsistent CIF/FCF Data - (ABORT)')
99935 FORMAT (':: ARU-code not representable (out-of-range)')
99934 FORMAT (':: CALC TMA not allowed after previous CALC INTRA')
99933 FORMAT ('N: No-Hydrogen atoms in this structure')
99932 FORMAT ('E: Too many FVAR - parameters (increase NP25)')
99931 FORMAT (':: No CALC INTRA or GEOM after previous (implicit) ',
     1        ' CALC INTRA allowed')
99930 FORMAT ('N: Number of Isotropic Non-H Atoms ', 39('.'), I5)
99929 FORMAT ('E: Non-Recoverable problem in routine PLA', I3.3)
99928 FORMAT (':: CALC SOLV/VOID incompatible with ANGSTROM mode')
99927 FORMAT ('N: Maximum allowed number of residues reduced')
99926 FORMAT ('N: Electron Count Voids / Cell =', I7)
99925 FORMAT ('W: Look carefully at the approximate inversion',
     1        ' symmetry reported by ADDSYM')
99924 FORMAT ('W: Structure contains', I3, ' Intra H..H contacts',
     1        ' < Sum(vdW-rad) ', F5.2, ' A (max ', F5.2,')')
99923 FORMAT ('W: Negative Distance Detected (i.e. Origin Outside ',
     1        'Xtal)')
99922 FORMAT ('W: Number of Carbon Atoms with missing H-atoms ',
     1         27('.'), I5)
99921 FORMAT ('E: No Mu-value provided')
99920 FORMAT ('E: Unknown Element Type on SFAC line, Fatal')
99919 FORMAT ('W: Number of (Carbon) Atoms with no sp(x) ',
     1        'assignment ', 21('.'), I5)
99918 FORMAT ('W: Structure contains', I3, ' Inter H..H contacts',
     1        ' < Sum(vdW-rad) ', F5.2, ' A (max ', F5.2,')')
99917 FORMAT ('N: Number of Non-HBonded D-H atoms ', 39('.'), I5)
99916 FORMAT ('W: No Valid Direction Cosine or Psi-values Found', /)
99915 FORMAT ('W: No Valid Psi-scans Found')
99914 FORMAT ('W: No Reflections Supplied !', /)
99913 FORMAT ('E: I Can''t accept transformations on hkl with a',
     1           ' NEGATIVE Det. ')
99912 FORMAT ('E: Unknown ELEMENT Type on SFAC')
99911 FORMAT ('E: No Valid Atoms found on Input File')
99910 FORMAT ('E: No ', A,'.hkl or ', A,'.fcf Reflection file present')
99909 FORMAT ('E: No ', A,'.hkl Reflection file present', /)
99907 FORMAT ('E: Something wrong with', I5,
     1        ' input U/Uij(s) (incomplete?)', /)
99906 FORMAT ('E: SFAC data incomplete or missing on shelx.res/ins file'
     1         , ' for: ', A, /)
99905 FORMAT (/, ':: Input Xtal Data from File ', A, ' - Data Type ',
     1        A, /)
99904 FORMAT (':: No proper wavelength (Ag,Mo,Ga,Cu) recognised (',
     1        F8.5, ')')
99903 FORMAT ('W: Look carefully at the (approximate) Translation',
     1        ' symmetry reported by ADDSYM')
99902 FORMAT ('W: Number of out of range ARU-coding problems =', I5, /,
     1        '   Analysis of Inter Contacts may be incomplete')
99901 FORMAT ('E: Void TOO LARGE to be Interesting; Search Aborted', /,
     1            '(at own risk: SET IPR 491 1000000 before SQUEEZE)')
99900 FORMAT (/, 'E: Scratch Array Overrun in PLA153 (Fatal)', /,
     1        '    Use larger program version i.e. NP1 ',
     2        '> ', I9, /)
99899 FORMAT (/, 'W: # MAXPATH EXCEEDED IN R/S-Assignment Routine =',
     1        I3)
99898 FORMAT (/, 'E: Insufficient Data on UIJ/SUIJ - CIF-Input for ',
     1        A, /)
99897 FORMAT (':: EXIT Statement Executed for: ', A)
99896 FORMAT (/, 'E: Insufficient Data on ATOM - CIF-Input for ',
     1        A, /)
99895 FORMAT (/, 'E: Symmetry Problem in PLA270', /)
99894 FORMAT (/ )
99893 FORMAT ('N: Number of Unrecognized (CIF) Keywords ', 33('.'), I5)
99892 FORMAT ('E: SYMM-LABEL PACK PROBLEM')
99891 FORMAT ('E: No Reflection Data Available')
99889 FORMAT ('W: Structure contains', I3,' isolated O-atom(s).')
99888 FORMAT ('E: No Direction Cosines or Psi found on Reflection Data')
99887 FORMAT ('W: Low density (check!) of ', 38('.'), F8.3, ' gcm-3')
99886 FORMAT ('W: Coordinates do not form a Connected Set')
99885 FORMAT ('E: Label Alias Overflow: TRY: SET IGBL 61  1')
99855 FORMAT (':: NORMAL END of PLATON :', I6, ' Pages on FILE ',
     1        A, '.lis', /)
99853 FORMAT (//, 'E: READ ERROR - FATAL', /)
99852 FORMAT ('E: NSP-Problem in PLA024: Nr species too large')
99850 FORMAT ('W: Incorrect Number of Numerical Arguments on TRNS/TRMX')
99849 FORMAT (/, 'E: Check Data Type (cif,ins,res,spf,pdb,fcf)',
     1       ' of the Input (TITL missing?)')
99848 FORMAT (/, ':: CELL PROBLEM')
99847 FORMAT (/, 'CIF-LINE LONGER THAN 2048 CHARACTERS')
99846 FORMAT (/, 'CIF-LOOP PROBLEM')
99845 FORMAT (':: Input Refl Data from File ', A, ' - Data Type ', A, /)
99844 FORMAT (':: SHELXL.INS (From CIF data) on: ', A, /,
     1        ':: SHELXL.HKL (From FCF data) on: ', A, /)
99843 FORMAT (/, ':: HKLF 4 Style Reflection File Needed', /)
99842 FORMAT (/, ' >> CIF-Validation-Check Result on ', A)
99841 FORMAT (/, ' >> More than', I5, ' Aliases. Aborted')
99840 FORMAT (/, '*** Unsuitable File (Type) Combination Supplied for ',
     1        'a SQUEEZE Calculation ***', /, 4X,
     2        '[IGBL(29) =', I2, ', IPR(619) =', I2, ']', /)
99839 FORMAT (/, '*** A LIST 8 TYPE FCF is Needed for TWINNED',
     1        ' Structures ****', /)
99838 FORMAT (/, 'Valid File Combinations: ', /,
     1        '(Note: The CIF & FCF should be SHELXL Standard  with ',
     2        'Embedded .res & .hkl)', /,
     3        '1 -  SHELXL20nm CIF + FCF (SHELXL LIST 4)', /,
     4        '2 -  SHELXL20nm CIF + FCF (SHELXL LIST 8) (TWINNING)', /,
     5        '3 -  SHELXL INS/RES + SHELXL HKL', /,
     6        '4 -  SHELXL INS/RES + SHELXL FCF (SHELXL LIST 4)', /)
99837 FORMAT (/, '** Unsuitable File Type combination for SQUEEZE',/,
     1        '** HYBRID Requires .ins/.res + .hkl or',
     2        ' SHELXL201n .cif file(s) as input')
99836 FORMAT (/, ':: RES File (.ins or .res) INPUT only !')
99835 FORMAT (/, ':: Determinant for transformation = 0.0', /)
99834 FORMAT (/, ':: SQUEEZE job ABORTED: CIF based on EXTI refinement',
     1        /, '   Please re-refine without EXTI for proper .fcf', /)
99833 FORMAT (/, ':: No Matching Reflection Data Entry found for ', A)
99832 FORMAT (/, ':: No Numerical Data on HKLF (res) RECORD in CIF')
      END SUBROUTINE PLA003
 
      SUBROUTINE PLA004 (MODE)
C * (FILE) CLOSE/TERMINATE ROUTINE
      USE files
      USE parameters
      USE atomdata
      USE cchar
      USE cggt
      USE xwdw
      IMPLICIT NONE
      INTEGER :: I
      INTEGER :: NB
      INTEGER :: NE
      INTEGER :: LU
      INTEGER :: MODE
      INTEGER :: IEND
      INTEGER :: IYUNK
      INTEGER :: FINDEXE
      CHARACTER(len=6) :: PS
      IF (IWIN == 1) THEN
        PS = '.ps'
      ELSE
        PS = '_sq.ps'
      END IF
C * DISPLAY VALIDATION RESULT
      IF (IGBL(36) * IGBL(66) * IGBL(32) /= 0) CALL PLA235 (0)
C * OUTPUT-FILE TYPE
C *  1 - OMEGA,  3 - SPF, 4 - CSD, 7 - PDB
C * 10 - SQUEEZE
C * -2 - SHELXL
      IF (MODE == 0) THEN
C * STOP AND CLOSE GRAPHICS (IF ANY)
        XGGIP = -999.0
        CALL GGIP (XGGIP, 0.0, 0.0, -5)
C * CLOSE 'ALERT' FILE
        CLOSE (UNIT = LU20, STATUS = 'DELETE', IOSTAT = IOST)
        CLOSE (UNIT = LU68, STATUS = 'DELETE', IOSTAT = IOST)
      END IF
      IF (IGBL(3) == 1 .OR. IGBL(22) /= 0)
     1  CLOSE (UNIT = LU2, STATUS = 'DELETE', IOSTAT = IOST)
      LU   = LU6
      IEND = 1
      IF (IGBL(63) > 0) IEND = 2
      DO I = 1, IEND
        IF (I == 2) LU = LU7
        SELECT CASE (IGBL(31))
C * REPORT OME OUTPUT FILE
          CASE (1)
C * SUP/PUB TABLE TEST
            IF (IPR(430) == 0) THEN
              WRITE (LU, 99997, IOSTAT = IOST) NAMEFIL(1:KNMFIL)
            END IF
C * REPORT (SPF/ELD) OUTPUT FILE
          CASE (3)
C * TEST FOR 'FCF CHECK' AND 'CALC FCF'
            IF (IGBL(129) <= 0 .AND. IPR(210) /= -1) THEN
              IF (IPR(2) /= -11) THEN
                IF (LU /= LU20 .AND. IPR(777) /= 1)
     1            WRITE (LU, 99995, IOSTAT = IOST) NAMEFIL(1:KNMFIL)
                END IF
            END IF
C * REPORT CSD-QUE OUTPUT FILE
          CASE (4)
            IF (LU /= LU7 .AND. LU /= LU20)
     1        WRITE (LU, 99994, IOSTAT = IOST) NAMEFIL(1:KNMFIL)
C * REPORT SPGR PAR OUTPUT FILE
          CASE (5)
            IF (IPR(2) == 0) WRITE (LU, 99985, IOSTAT = IOST)
     1        NAMEFIL(1:KNMFIL)
C * REPORT SHELXL RES FILE OUTPUT
          CASE (-2, 6)
            CLOSE (LU2, IOSTAT = IOST)
            WRITE (LU, 99988, IOSTAT = IOST) NAMEFIL(1:KNMFIL)
C * REPORT PDB OUTPUT FILE
          CASE (7)
            WRITE (LU, 99977, IOSTAT = IOST) NAMEFIL(1:KNMFIL)
C * REPORT SQUEEZE RESULT FILES
          CASE (10)
            IF (IPR(2) <= 0) THEN
              WRITE (LU, 99976, IOSTAT = IOST)
     1          NAMEFIL(1:KNMFIL)//'_sq.ins',
     2          NAMEFIL(1:KNMFIL)//'_sq.hkl',
     3          NAMEFIL(1:KNMFIL)//'_sq.fab',
     4          NAMEFIL(1:KNMFIL)//'_sq.sqf',
     5          NAMEFIL(1:KNMFIL)//'_sq.sqz',
     6          NAMEFIL(1:KNMFIL)//'_sq.lis',
     7          NAMEFIL(1:KNMFIL)//PS
              IF (ABS (IGBL(8)) == 2) THEN
                WRITE (LU, 99975, IOSTAT = IOST)
     1            NAMEFIL(1:KNMFIL), NAMEFIL(1:KNMFIL),
     2            NAMEFIL(1:KNMFIL), NAMEFIL(1:KNMFIL)
              END IF
            END IF
        END SELECT
      END DO
 
C * DELETE ? _sx.ins & _sx.hkl & _sx.fab FROM SHELX20xy CIF
      LU6 = 6
C * .ins CASE
      IF (IPR(663) == -2) THEN
        WRITE (LU6, 99952, IOSTAT = IOST)
     1    NAMEFIL(1:KNMFIL)//'_sx.ins'
      ELSE IF (IPR(663) == -1) THEN
        CLOSE (UNIT = LU24, STATUS = 'DELETE', IOSTAT = IOST)
      END IF
C * .hkl CASE
      IF (IPR(664) == -3) THEN
        WRITE (LU6, 99947, IOSTAT = IOST)
     1    NAMEFIL(1:KNMFIL)//'_sx.hkl'
      ELSE IF (IPR(664) == -2 .OR. IPR(321) /= 0) THEN
C * CHECK FOR IUCr VALIDATION
        IF (IGBL(3) /= 1) THEN
          WRITE (LU6, 99951, IOSTAT = IOST)
     1      NAMEFIL(1:KNMFIL)//'_sx.hkl'
        ELSE
          CLOSE (UNIT = LU25, STATUS = 'DELETE', IOSTAT = IOST)
        END IF
      ELSE IF (IPR(664) == -1) THEN
        CLOSE (UNIT = LU25, STATUS = 'DELETE', IOSTAT = IOST)
      END IF
C * .fab CASE
      IF (IPR(665) == -2) THEN
        WRITE (LU6, 99950, IOSTAT = IOST)
     1    NAMEFIL(1:KNMFIL)//'_sx.fab'
      ELSE IF (IPR(665) == -1) THEN
        CLOSE (UNIT = LU26, STATUS = 'DELETE', IOSTAT = IOST)
      END IF
C * CIF & SUP OUTPUT FILES
      IF (IPR(431) == 1) THEN
        WRITE (LU6, 99992, IOSTAT = IOST) NAMEFIL(1:KNMFIL)
      ELSE IF (IPR(431) == -1) THEN
        WRITE (LU6, 99990, IOSTAT = IOST) NAMEFIL(1:KNMFIL)
      ENDIF
      CLOSE (UNIT = LU14, STATUS = 'DELETE', IOSTAT = IOST)
C * CHECK SUMMARY FILE
      IF (IGBL(36) > 0) THEN
C * APPEND FCF CREATION LOG TO .ckf file
        INQUIRE (FILE = NAMEFIL(1:KNMFIL)//'_sx.log',
     1    EXIST = EXST)
        IF (EXST) THEN
          WRITE (LU13, 99940)
          OPEN (UNIT = LU60, FILE = NAMEFIL(1:KNMFIL)//
     1      '_sx.log', STATUS = 'UNKNOWN')
          DO
            READ  (LU60, 99953, IOSTAT = IOST) ICL(1:80)
            IF (IOST /= 0) EXIT
            WRITE (LU13, 99953) ICL(1:80)
          END DO
          CLOSE (UNIT = LU60, STATUS = 'DELETE',
     1      IOSTAT = IOST)
        END IF
*
C * APPEND ASYM HKL AVERAGING LISTING TO .ckf file
        INQUIRE (FILE = 'lasym.lis', EXIST = EXST)
        IF (EXST) THEN
          WRITE (LU13, 99939)
          OPEN (UNIT = LU60, FILE = 'lasym.lis',
     1      STATUS = 'UNKNOWN')
          NB = 0
          NE = 0
          DO
            READ  (LU60, 99953, IOSTAT = IOST) ICL(1:132)
            IF (IOST /= 0) EXIT
            IF (ICL(1:1) == CHAR (12)) THEN
              WRITE (LU13, 99938)
              CYCLE
            END IF
            CALL GEN039 (1, ICL, 80, 132, NB, NE)
            WRITE (LU13, 99953) ICL(1:NE)
            IF (ICL(1:7) == 'Average') EXIT
          END DO
          CLOSE (UNIT = LU60, STATUS = 'DELETE',
     1      IOSTAT = IOST)
        END IF
        LU6 = 6
        CALL PLA230 (1)
        WRITE (LU6, 99971, IOSTAT = IOST) NAMEFIL(1:KNMFIL)
      ELSE
        CLOSE (UNIT = LU10, STATUS = 'DELETE', IOSTAT = IOST)
      END IF
C * CHECK FCF- SUMMARY FILE
      IF (IGBL(129) /= 0) THEN
        LU6 = 6
        WRITE (LU6, 99962, IOSTAT = IOST) NAMEFIL(1:KNMFIL)
      END IF
C * CHECK VRF
      IF (IGBL(141) > 0) THEN
        WRITE (LU66, 99945)
        WRITE (LU6,  99944, IOSTAT = IOST) NAMEFIL(1:KNMFIL)
      END IF
C * CHECK PS
      IF (IGBL(149) == 1 .AND. NPLOT > 0 .AND. IGBL(3) == 1) THEN
        WRITE (LINE, 99942, IOSTAT = IOST) NAMEFIL(1:KNMFIL)
        WRITE (LINE(71:80), 99941, IOSTAT = IOST) NPLOT
        WRITE (LU6, 99953, IOSTAT = IOST) LINE
      END IF
C * BIN-FILE
      IF (IGBL(16) == 0)
     1    CLOSE (UNIT = LU19, STATUS = 'DELETE', IOSTAT = IOST)
C * SAV - FILE CLOSE/DELETE
      IF (IPR(326) == -1 .AND. IPR(198) > 0 .AND.
     1    IPR(189) ==  2 .AND. IPR(210) <= 0) THEN
        WRITE (LU6, 99989, IOSTAT = IOST) NAMEFIL(1:KNMFIL)
      ELSE
        CLOSE (UNIT = LU15, STATUS = 'DELETE', IOSTAT = IOST)
      END IF
C * HKS/CPI - FILE
      IF (IGBL(18) == 1 .AND. IPR(408) < 1
     1    .AND. IGBL(3) /= 34 .AND. IGBL(3) /= 1 .AND.
     2     IGBL(129) <= 0) THEN
        WRITE (LU6, 99966, IOSTAT = IOST) NAMEFIL(1:KNMFIL), IPR(378)
      ELSE IF (IGBL(18) == 2) THEN
        WRITE (LU6, 99965, IOSTAT = IOST) NAMEFIL(1:KNMFIL)
      END IF
C * HKP - FILE
      IF (IPR(210) == -1) THEN
        WRITE (LU6, 99987, IOSTAT = IOST) NAMEFIL(1:KNMFIL),
     1                     NAMEFIL(1:KNMFIL)
C * MULABS
      ELSE IF (IPR(2) == -4) THEN
        WRITE (LU6, 99972, IOSTAT = IOST) NAMEFIL(1:KNMFIL)
C * ABSSPHERE
      ELSE IF (IPR(2) == -5) THEN
        WRITE (LU6, 99979, IOSTAT = IOST) NAMEFIL(1:KNMFIL)
C * ABSPSI
      ELSE IF (IPR(2) == -6 .AND. IPR(432) > 0) THEN
        WRITE (LU6, 99980, IOSTAT = IOST) NAMEFIL(1:KNMFIL)
C * ABSTOMPA
      ELSE IF (IPR(2) == -7 .AND. IPR(432) > 0) THEN
        WRITE (LU6, 99982, IOSTAT = IOST) NAMEFIL(1:KNMFIL)
C * ABSGAUSS
      ELSE IF (IPR(2) == -8 .AND. IPR(432) > 0) THEN
        WRITE (LU6, 99983, IOSTAT = IOST) NAMEFIL(1:KNMFIL)
C * SHXABS-HKP
      ELSE IF (IPR(2) == -10) THEN
        WRITE (LU6, 99963, IOSTAT = IOST) NAMEFIL(1:KNMFIL)
C * HKLF5 - FILE
      ELSE IF (IPR(2) == -11) THEN
        WRITE (LU6, 99943, IOSTAT = IOST) NAMEFIL(1:KNMFIL)
        WRITE (LU6, 99964, IOSTAT = IOST) NAMEFIL(1:KNMFIL)
C * RP1 - FILE
      ELSE IF (IPR(2) == -12) THEN
        WRITE (LU6, 99961, IOSTAT = IOST) NAMEFIL(1:KNMFIL)
        IF (IPR(373) /= 0) WRITE (LU6, 99960, IOSTAT = IOST)
     1    NAMEFIL(1:KNMFIL)
C * SHELX.BIN
      ELSE IF (IPR(2) == -13 .AND. IPR(525) == 0 .AND.
     1   IPR(409) == 0) THEN
        WRITE (LU6, 99984, IOSTAT = IOST) NAMEFIL(1:KNMFIL)
C * ASYM hkp
      ELSE IF (((IPR(2) == -14 .AND. IPR(408) /= 2) .OR.
     1          IGBL(17) == 1) .AND. IGBL(22) == 0) THEN
        IYUNK = IPR(377)
        IF (IGBL(18) == 0) IYUNK = IYUNK + IPR(378)
        IF (IPR(408) == 1) THEN
          WRITE (LU6, 99946, IOSTAT = IOST) NAMEFIL(1:KNMFIL), IYUNK
        ELSE
          WRITE (LU6, 99981, IOSTAT = IOST) NAMEFIL(1:KNMFIL), IYUNK
        END IF
C * HKLF-TRANS
      ELSE IF (IPR(2) == -15) THEN
        WRITE (LU6, 99970, IOSTAT = IOST) NAMEFIL(1:KNMFIL),
     1  NAMEFIL(1:KNMFIL)
      ELSE
        CLOSE (UNIT = LU17, STATUS = 'DELETE', IOSTAT = IOST)
      END IF
C * HKLF4.HKL FROM FCF
      IF (IPR(2) == -16 .AND. IPR(384) > 0) THEN
        WRITE (LU6, 99948, IOSTAT = IOST) NAMEFIL(1:KNMFIL)
      END IF
      CLOSE (UNIT = LU1)
C * DEF-FILE
      IF (IGBL(23) == 0)
     1  CLOSE (UNIT = LU23, STATUS = 'DELETE', IOSTAT = IOST)
C * NON-S MODE, NEW-RES
      IF (IGBL(92) == 0) THEN
        IF (IGBL(26) == 0 .OR. IABS (IGBL(8)) /= 2) THEN
          CLOSE (UNIT = LU21, STATUS = 'DELETE', IOSTAT = IOST)
        ELSE
          CALL PLUT29 (-1, ICL, NQ1, 0, LU21)
          WRITE (LU6, 99949, IOSTAT = IOST) NAMEFIL(1:KNMFIL)
        END IF
      END IF
C * POVRAY-OUT
      IF (IGBL(98) /= 0) WRITE (LU6, 99999, IOSTAT = IOST)
     1  NAMEFIL(1:KNMFIL)
C * PBD-RASMOL-OUT
      IF (IGBL(11) /= 0) WRITE (LU6, 99969, IOSTAT = IOST)
     1  NAMEFIL(1:KNMFIL)
C * LIS
      IF ((IGBL(7) > 0 .AND. IGBL(3) == 1) .OR.
     1   (IPR(123) == 0 .AND. ((IGBL(7) > 0 .AND. IGBL(3) == 8)
     1  .OR. IGBL(63) == 0 .OR. IGBL(6) == 17
     2  .OR. IGBL(6) == 18 .OR. IGBL(6) == 19))) THEN
        CLOSE (UNIT = LU7, STATUS = 'DELETE', IOSTAT = IOST)
C * CHECK FOR .lps
      ELSE IF (MODE == 0) THEN
C * TEST WHETHER LU7 IS OPEN
        IF (IGBL(7) > 0) THEN
          CALL GEN108 (LU7, 0)
          CLOSE (UNIT = LU1)
C * CREATE PostScript Listing Output
          IF (IGBL(70) == 1) THEN
            READ (LU7, 99953, IOSTAT = IOST) PRBUF
            IF (IOST == 0) THEN
              CALL GEN108 (LU7, 0)
              IF (IGBL(7) == 1) THEN
                FNLU1  = NAMEFIL(1:KNMFIL) //'.lps'
              ELSE IF (IGBL(7) == 2) THEN
                FNLU1  = NAMEFIL(1:KNMFIL) //'_sq.lps'
              END IF
              OPEN (UNIT = LU1,  FILE = FNLU1, STATUS = 'UNKNOWN')
              CALL GEN089 (LU7, LU1, IGBL(49), IGBL(102))
              IF (IGBL(116) /= 1 .AND. IGBL(130) /= 0) THEN
                CLOSE (UNIT = LU1)
                NE = FINDEXE ('PS2PDF', CGETENV, 'ps2pdf')
                IF (IGBL(7) == 1) THEN
                  CGETENV(NE+1:) =
     1 ' '//NAMEFIL(1:KNMFIL)//'.lps '//NAMEFIL(1:KNMFIL)//'.pdf'
                ELSE IF (IGBL(7) == 2) THEN
                  CGETENV(NE+1:) =
     1 ' '//NAMEFIL(1:KNMFIL)//'_sq.lps '//NAMEFIL(1:KNMFIL)//'_sq.pdf'
                END IF
                KERR = 0
                CALL SPAWN (CGETENV, LU6, .true., KERR)
                IF (KERR /= 0) WRITE (6, 99998)
              END IF
            ELSE
              CLOSE (UNIT = LU7, STATUS = 'DELETE', IOSTAT = IOST)
              IGBL(7) = 0
            END IF
          END IF
        END IF
      END IF
C * PJN
      IF (IGBL(27) == 1) THEN
        WRITE (LU6, 99973, IOSTAT = IOST) NAMEFIL(1:KNMFIL)
      ELSE
        CLOSE (UNIT = LU22, STATUS = 'DELETE', IOSTAT = IOST)
      END IF
      IF (IPR(580) < 0)  THEN
        IF (IPR(580) == -1) THEN
          WRITE (LU6, 99959, IOSTAT = IOST) NAMEFIL(1:KNMFIL)
        ELSE
          WRITE (LU6, 99958, IOSTAT = IOST) NAMEFIL(1:KNMFIL)
        END IF
      END IF
      IF (IPR(409) == 1) THEN
C * REPORT ON FLIP FILES
        WRITE (LU6, 99957, IOSTAT = IOST) NAMEFIL(1:KNMFIL),
     1    NAMEFIL(1:KNMFIL), NAMEFIL(1:KNMFIL)
C * TEST FOR UPDATED .res
        WRITE (LINE, 99953, IOSTAT = IOST) NAMEFIL(1:KNMFIL)//'_res.new'
        INQUIRE (FILE = LINE, EXIST = EXST)
        IF (EXST) WRITE (LU6, 99955, IOSTAT = IOST)
     1    NAMEFIL(1:KNMFIL), NAMEFIL (1:KNMFIL)
      END IF
      IF (MODE /= 0) THEN
        CLOSE (UNIT = LU7, STATUS = 'DELETE', IOSTAT = IOST)
        LU1     = 1
        LINE    = ICL(5:80)
        IGBL(7) = 0
        IGBL(8) = 0
      ELSE
        IGBL(1) = 5
C * DELETE check.def WHEN ITS DATE IS EARLIER OR EQUAL ENBEDDED VERSION (20)
        IF (IGBL(20) >= IGBL(21)) THEN
          CLOSE (UNIT = LU12, STATUS = 'DELETE', IOSTAT = IOST)
        END IF
      END IF
C * CLOSE OTHER POTENTIALLY OPEN FILES
      CLOSE (UNIT = LU1,  IOSTAT = IOST)
      CLOSE (UNIT = LU2,  IOSTAT = IOST)
      CLOSE (UNIT = LU3,  IOSTAT = IOST)
      CLOSE (UNIT = LU4,  IOSTAT = IOST)
      CLOSE (UNIT = LU7,  IOSTAT = IOST)
      CLOSE (UNIT = LU8,  IOSTAT = IOST)
      CLOSE (UNIT = LU9,  IOSTAT = IOST)
      CLOSE (UNIT = LU10, IOSTAT = IOST)
      CLOSE (UNIT = LU11, IOSTAT = IOST)
      CLOSE (UNIT = LU12, IOSTAT = IOST)
      CLOSE (UNIT = LU13, IOSTAT = IOST)
      CLOSE (UNIT = LU14, IOSTAT = IOST)
      CLOSE (UNIT = LU15, IOSTAT = IOST)
      CLOSE (UNIT = LU16, IOSTAT = IOST)
      CLOSE (UNIT = LU17, IOSTAT = IOST)
      CLOSE (UNIT = LU18, IOSTAT = IOST)
      CLOSE (UNIT = LU19, IOSTAT = IOST)
      CLOSE (UNIT = LU20, IOSTAT = IOST)
      CLOSE (UNIT = LU21, IOSTAT = IOST)
      CLOSE (UNIT = LU22, IOSTAT = IOST)
      CLOSE (UNIT = LU23, IOSTAT = IOST)
      CLOSE (UNIT = LU24, IOSTAT = IOST)
      CLOSE (UNIT = LU25, IOSTAT = IOST)
      CLOSE (UNIT = LU26, IOSTAT = IOST)
      CLOSE (UNIT = LU27, IOSTAT = IOST)
      CLOSE (UNIT = LU60, IOSTAT = IOST)
      CLOSE (UNIT = LU61, IOSTAT = IOST)
      CLOSE (UNIT = LU62, IOSTAT = IOST)
      CLOSE (UNIT = LU63, IOSTAT = IOST)
      CLOSE (UNIT = LU64, IOSTAT = IOST)
      CLOSE (UNIT = LU65, IOSTAT = IOST)
      CLOSE (UNIT = LU66, IOSTAT = IOST)
      CLOSE (UNIT = LU67, IOSTAT = IOST)
      CLOSE (UNIT = LU68, IOSTAT = IOST)
      RETURN
99999 FORMAT (/,
     1        ':: POV-Ray File on :', A, '.pov')
99998 FORMAT (/, '*** SPAWN PROBLEM WITH CGETENV ***', /)
99997 FORMAT (':: OMEGA File   on :', A, '.ome')
99995 FORMAT (':: SPF File spf on :', A, '_pl.spf')
99994 FORMAT (':: CSD-QUE      on :', A, '.que')
99992 FORMAT (':: SUPP. Mat.   on :', A, '.sup')
99990 FORMAT (':: CIF/ACC-File on :', A, '_acc.cif')
99989 FORMAT (':: SAV-File     on :', A, '.sav')
99988 FORMAT (':: SHELXL   res on :', A, '_pl.res')
99987 FORMAT (':: FCF-CIF  cif on :', A, '_pl.cif', /,
     1        ':: FCF-CIF  fcf on :', A, '_pl.fcf', /)
99985 FORMAT (':: SPGR.PAR     on :', A, '.par')
99984 FORMAT (':: HKLF3.HKL    on :', A, '.hkp')
99983 FORMAT (':: ABSGAUSS hkl on :', A, '.hkp')
99982 FORMAT (':: ABSTOMPA hkl on :', A, '.hkp')
99981 FORMAT (':: ASYM     hkl on :', A, '.hkp (# refl. =', I7, ')')
99980 FORMAT (':: ABSPSI   hkl on :', A, '.hkp')
99979 FORMAT (':: ABSSPHER hkl on :', A, '.hkp')
99977 FORMAT (':: PDB-FILE out on :', A, '_pl.pdb')
99976 FORMAT (':: Files for Final Refinement with SHELXL201n', //,
     1        ':: SQUEEZE  ins on :', A, /,
     2        ':: SQUEEZE  hkl on :', A, /,
     3        ':: SQUEEZE  fab on :', A, //,
     4        ':: Additional INFO on the SQUEEZE Job',//,
     5        ':: SQUEEZE  sqf on :', A, /,
     6        ':: SQUEEZE  xyz on :', A, /,
     7        ':: SQUEEZE  lis on :', A, /,
     8        ':: SQUEEZE  ps  on :', A, /)
99975 FORMAT (/,
     1        ':: Files for Final Refinement with CRYSTALS ', //,
     2        ':: SQUEEZE  ins on :', A, '_sqd.ins', /,
     3        ':: SQUEEZE  hkl on :', A, '_sqd.hkl', /,
     4        ':: SQUEEZE  cif on :', A, '_sqd.sqf', /,
     5        ':: SQUEEZE  xyz on :', A, '_sqd.sqz', /)
99973 FORMAT (/,
     1        ':: Journal File on :', A, '.pjn', //,
     2        ':: Normal End of PLATON/PLUTON RUN.')
99972 FORMAT (':: MULABS   hkl on :', A, '.hkp')
99971 FORMAT (':: CheckCIF out on :', A, '.chk')
99970 FORMAT (':: HKLTRANS hkl on :', A, '_trans.hkl', /,
     1        ':: HKLTRANS ins on :', A, '_trans.ins')
99969 FORMAT (':: RASMOL(pdb)  on :', A, '.ras')
99966 FORMAT (':: ASYM    -hkl on :', A, '.hks (# refl. =', I7, ')')
99965 FORMAT (':: POWDER   cpi on :', A, '.cpi')
99964 FORMAT (':: HKLF5.HKL    on :', A, '_tw.hkl')
99963 FORMAT (':: SHXABS   hkl on :', A, '.hkp')
99962 FORMAT (':: CheckFCF out on :', A, '.ckf')
99961 FORMAT (':: Expanded Coordinate Set (shelx-style) on: ', A,
     1        '_exp.ins')
99960 FORMAT (':: Expanded Reflection Set (SHELX-Style) on: ', A,
     1        '_exp.hkl')
99959 FORMAT (':: Fourier3D    on :', A, '.fou')
99958 FORMAT (':: Solv3D       on :', A, '.slv')
99957 FORMAT (':: Flip Results on: ', A, '_flp.res',
     1        ' - Concatenation of Flip-maps', /, 20X,
     2        A, '_sol.res - Concatenation of Solutions', /, 20X,
     3        A, '_res.res - Best Solution')
99955 FORMAT (20X, A, '_res.new - Updated version of ', A, '_res.res')
99953 FORMAT (A)
99952 FORMAT (':: SHELXL.INS (From .res in CIF) on :', A)
99951 FORMAT (':: SHELXL.HKL (From .hkl in CIF) on :', A)
99950 FORMAT (':: SHELXL.FAB (From .fab in CIF) on :', A)
99949 FORMAT (/, ':: Modified SHELX-File on ', A, '_pl.res')
99948 FORMAT (':: HKLF4.HKL    on :', A, '_sx.hkl')
99947 FORMAT (':: SHELXL.HKL (From .hkl in FCF) on :', A, /)
99946 FORMAT (':: GENERATE hkl on :', A, '_gener.hkl(# refl. =',
     1  I7, ')')
99945 FORMAT ('# end Validation Reply Form')
99944 FORMAT (':: CheckVRF out on :', A, '.vrf')
99943 FORMAT (':: HKLF5.INS    on :', A, '_tw.ins')
99942 FORMAT (':: CheckPlots   on :', A, '.ps')
99941 FORMAT ('[', I2, ' Plots]')
 
99940 FORMAT (/, 'Section 11: FCF Creation Job with SHELXL Logfile',
     1        /, 80('='))
99939 FORMAT (/, 'Section 12: ASYM Reflection Averaging Listing',
     1        ' (Embedded hkl Data)', /, 80('='))
99938 FORMAT (1X)
      END SUBROUTINE PLA004
 
      SUBROUTINE PLA005 (MODE, ISWVAL)
C * HANDLE COMMAND LINE SWITCHES
      USE files
      USE parameters
      USE cchar
      USE strain1
      IMPLICIT NONE
      INTEGER :: J
      INTEGER :: JARG
      INTEGER :: MODE
      INTEGER :: IVERS
      INTEGER :: ISWVAL
      INTEGER, SAVE :: NCYCLE
C * MODE = -1 - DIRECT ACCESS TO PLATON FOR ALIAS LINKED TOOLS
C * MODE =  0 - PLATON
C * MODE =  1 - PLUTON
C * GET ARGUMENTS & FLAGS
      IF (MODE < 0) THEN
C * FIRST CHECK FOR SUB-PROGRAM NAMES SIM-LINKED TO THE PLATON EXECUTABLE)
        JARG = COMMAND_ARGUMENT_COUNT()
        DO J = 0, JARG
          CALL GET_COMMAND_ARGUMENT(J, IDM)
          IF (J == 0) THEN
            IF (INDEX (IDM, 'platon') /= 0) THEN
              CYCLE
C * SIMULATE -p option when called as 'pluton'
            ELSE IF (INDEX (IDM, 'pluton') /= 0) THEN
              IDM = '-p'
C * SIMULATE -u option when called as 'cifchk' or 'checkcif'
            ELSE IF (INDEX (IDM, 'cifchk') /= 0 .OR.
     1               INDEX (IDM, 'checkcif') /= 0) THEN
              IDM = '-u'
C * SIMULATE -s option when called as 's'
            ELSE IF (INDEX (IDM, 's ') /= 0) THEN
              IDM = '-s'
C * SIMULATE -k option when called as 'helena'
            ELSE IF (INDEX (IDM, 'helena ') /= 0) THEN
              IDM = '-k'
C * SIMULATE -Y option when called as 'stidy'
            ELSE IF (INDEX (IDM, 'stidy ') /= 0) THEN
              IDM = '-Y'
C * SIMULATE -Z option when called as 'flipper'
            ELSE IF (INDEX (IDM, 'flipper ') /= 0) THEN
              IDM = '-Z'
            ELSE
              CYCLE
            END IF
          END IF
C * LOOP OVER SWITCHES - GET NUMERICAL EXTENSION
C * SET DEFAULT WAVELENGTH
          IF (IDM(1:1) == '-') THEN
            IF (IDM(2:3) == 'Cu') THEN
              IGBL(143) = 1
            ELSE IF (IDM(2:3) == 'Ga') THEN
              IGBL(143) = 2
            ELSE IF (IDM(2:3) == 'Mo') THEN
              IGBL(143) = 3
            ELSE IF (IDM(2:3) == 'Ag') THEN
              IGBL(143) = 4
            ELSE IF (IDM(2:3) == 'In') THEN
              IGBL(143) = 5
            ELSE
              ISWVAL = 0
              READ (IDM(3:6), *, IOSTAT = IOST) ISWVAL
              IF (IOST /= 0) ISWVAL = 0
              SELECT CASE (IDM(2:2))
C * ADP-ORTEP MODE
                CASE ('a')
                  IGBL(3) = 3
C * SET FOR THE DISPLAY OF ALL LABELS
                  IF (ISWVAL == 1) IGBL(105) = 1
C * CALC GEOM CSD  (b1 = BMFIT), b2 = MP)
                CASE ('b')
                  IGBL(3) = 11
C * CALC MODE
                CASE ('c')
                  IGBL(3)   = 2
                  IGBL(150) = ISWVAL
C * COMPARE REFL FILES
                CASE ('d')
                  IGBL(3) = 6
C * MULABS - MODE
                CASE ('e')
                  IGBL(3) = 18
C * HFIX
                CASE ('f')
                  IGBL(3)  = 13
                  IGBL(50) = 1
C * CALC GEOM SHELX NOSF
                CASE ('g')
                  IF (ISWVAL == 0) THEN
                    IGBL(3) = 24
                  ELSE IF (ISWVAL == 1) THEN
                    IGBL(3) = 50
                  END IF
C * HKL CALC
                CASE ('h')
                  IGBL(3) = 10
C * PATTERSON PLOT
                CASE ('i')
                  IGBL(3) = 22
C * CALC GEOM SPF
                CASE ('j')
                  IGBL(3)  = 23
                  IGBL(25) = 0
C * HELENA - MODE
                CASE ('k')
                  IGBL(3) = 15
                  NAMEFIL = 'helena'
                  KNMFIL  = 6
                  EXTENS  = 'cad'
                  KXT     = 3
C * ASYM (AVF) (VIEW)
                CASE ('l')
                  IGBL(3)  = 17
C * VIEW
                  IGBL(22) = 1
                  IF (ISWVAL == 1) THEN
                    IGBL(22) = 0
                  ELSE IF (ISWVAL == 2) THEN
                    IGBL(22) = 2
                  END IF
C * ADDSYM - MODE
                CASE ('m')
C * SET MENU OFF
                  IGBL(25) = 0
                  IF (ISWVAL > 0) RGBL(40) = FLOAT (100 - ISWVAL)
                  IGBL(3) = 4
C * ADDSYM SHELX - MODE
                CASE ('n')
                  IGBL(3) = 16
C * SET MINIMAL ATOM FIT PERCENTAGE
                  IF (ISWVAL > 0) RGBL(40) = FLOAT (100 - ISWVAL)
C * SET MENU OFF
                CASE ('o')
                  IGBL(25) = 0
C * PLUTON MODE
                CASE ('p')
                  IGBL(3) = 8
C * SQUEEZE/HYBRID - MODE
                CASE ('q')
                  IF (ISWVAL == 0) THEN
                    IGBL(3) = 5
                  ELSE
                    NCYCLE   = ISWVAL
                    IPR(682) = ISWVAL
                    IGBL(3)  = 48
                  END IF
C * RENAME MODE
                CASE ('r')
                  IGBL(3) = 12
C * SYSTEM-S - MODE
                CASE ('s')
                  IGBL(3) = 14
                  NAMEFIL = 's'
                  KNMFIL  = 1
                  RETURN
C * TABLE  - MODE
                CASE ('t')
                  IGBL(3) = 7
C * IUCR CHECKCIF MODE
                CASE ('u')
                  IGBL(3)  = 1
                  IGBL(36) = 1
C * ALERT DOCUMENTATION ON (TERMINAL WINDOW)
                  IGBL(83) = -1
                  IPR(71)  = 0
C * NON DEFAULT # OF L.S. CYCLES FOR SHELXL201n FCF CREATION
                  IF (ISWVAL > 0) IGBL(93) = ISWVAL
C * SOLV MODE
                CASE ('v')
                  IGBL(3) = 9
C * DIFFERENCE MAP
                CASE ('w')
                  IGBL(3) = 19
C * FO MAP
                CASE ('x')
                  IGBL(3) = 20
C * SQUEEZE MAP
                CASE ('y')
                  IGBL(3) = 21
C * WRITE IDENT ETC.
                CASE ('z')
                  IF (ISWVAL == 0) THEN
                    WRITE (LU6, 99998, IOSTAT = IOST) IGBL(4)
                    CLOSE (UNIT = LU6, IOSTAT = IOST)
C * CALL EXIT/STOP
                    IF (IOST == 0 .OR. IOST /= 0) CALL GEN127 (' ')
C * PACK check.def into check.f
                  ELSE IF (ISWVAL == 1) THEN
                    CALL PLA275
C * EXIT/STOP
                    CALL GEN127 (' ')
C * UNPACK check.f into check.def
                  ELSE IF (ISWVAL == 2) THEN
                    IVERS = 0
                    CALL CHECK (1, IVERS)
C * EXIT/STOP
                    CALL GEN127 (' ')
C * CREATE stripped platon_special.f from platon.f
                  ELSE IF (ISWVAL == 4) THEN
                    CALL PLA278
C * RECOVER ORIGINAL HKLF4 FILE FROM HKLF5 FILE
                  ELSE IF (ISWVAL == 8) THEN
                    CALL PLA343
C * EXIT/STOP
                    CALL GEN127 (' ')
C * RECOVER ORIGINAL HKL FILE FROM OLD-STYLE SOLVENT FREE HKL FILE
                  ELSE IF (ISWVAL == 9) THEN
                    CALL PLA344
C * EXIT/STOP
                    CALL GEN127 (' ')
                  END IF
C * PLUTON ANIS
                CASE ('A')
                  IGBL(3) = 26
C * BIJVOET ANALYSIS
                CASE ('B')
                  IGBL(3) = 46
C * TABL ACC
                CASE ('C')
                  IGBL(3) = 35
C * DIFF-FOURIER
                CASE ('D')
                  IGBL(3) = 44
C * EXOR
                CASE ('E')
                  IGBL(25) = 0
                  IGBL(3)  = 42
C * SILENT SYSTEM-S NQA - MODE
                CASE ('F')
                  IGBL(50) = 2
                  IGBL(3)  = 14
                  NAMEFIL  = 's'
                  KNMFIL   = 1
                  RETURN
C * CHEM-MODE CHECKCIF (I MARKED ALERTS IGNORED)
                CASE ('G')
                  IGBL(132) = 1
                  IPR(71)   = 0
                  IGBL(3)   = 1
C * CREATE .ins & .hkl + SHELXL refinement
                CASE ('H')
                  IGBL(3)  = 45
                  IGBL(25) = 0
C * AUTOMOLFIT
                CASE ('I')
                  IGBL(3)  = 41
                  IGBL(25) = 0
                  IGBL(32) = 0
C * COMPARE PS
                CASE ('J')
                  IGBL(25) = 0
                  IGBL(3)  = 47
C * CALC KPI (PACKING INDEX)
                CASE ('K')
                  IGBL(3)  = 36
                  IGBL(25) = 0
C * LEPAGE
                CASE ('L')
C * LEPAGE (-L)
                  IF (ISWVAL == 0) THEN
                    IGBL(3) = 51
C * LEPAGE (-L1)
                  ELSE IF (ISWVAL == 1) THEN
                    IGBL(3) = 52
                  END IF
                CASE ('M')
C * ADDSYM EQUAL SHELX - MODE
                CASE ('N')
                  IGBL(3)  = 38
C * PLOT ADP PS
                CASE ('O')
                  IGBL(3)  = 28
C * SET FOR THE DISPLAY OF ALL LABELS
                  IF (ISWVAL == 1) IGBL(105) = 1
C * HKL2POWDER IOBS
                CASE ('P')
                  IGBL(3)  = 29
                  RGBL(23) = FLOAT (ISWVAL)
C * POWDER ICALC (POSTSCRIPT + CPI)
                CASE ('Q')
                  IGBL(3)  = 31
                  RGBL(23) = FLOAT (ISWVAL)
C * RENUM ==> SHELX
                CASE ('R')
                  IGBL(3) = 27
C * ShelxtPlot
                CASE ('S')
                  IGBL(3) = 53
C * TWINROTMAT OPTIONS
                CASE ('T')
C * TWINROTMAT (INTERACTIVE)
                  IF (ISWVAL == 0) THEN
                    IGBL(3) = 40
C * TWINROTMAT (FILTER MODE)
                  ELSE IF (ISWVAL == 1) THEN
                    IGBL(3) = 37
C * TWINROTMAT (RL-PLOT)
                  ELSE IF (ISWVAL == 2) THEN
                    IGBL(3) = 30
                END IF
C * IUCR CHECKCIF MODE (without VALIDATION DOC)
                CASE ('U')
                  IGBL(3)  = 1
                  IGBL(36) = 1
C * ALERT DOCUMENTATION OFF
                  IGBL(83) = 0
                  IPR(71)  = 0
C * REGISTER -U SWITCH FUNCTIONALITY
                  IGBL(149) = 1
C * NON DEFAULT # OF L.S. CYCLES FOR SHELXL201n FCF CREATION
                  IF (ISWVAL > 0) IGBL(93) = ISWVAL
C * FCF-VALIDATION (LAUE)
                CASE ('V')
                  IGBL(3) = 33
C * FCF-VALIDATION (BIJVOET)
                CASE ('W')
                  IGBL(3) = 34
C * SHX86
                CASE ('X')
                  IGBL(3) = 32
C * STIDY
                CASE ('Y')
                  IGBL(3) = 39
C * ULTRA FLIPPER
                CASE ('Z')
                  IGBL(3) = 43
C * DEFAULT
                CASE DEFAULT
                  IGBL(8)      = 1
                  IGBL(19)     = 1
                  FILENAMES(1) = 'zz12345.zzz'
              END SELECT
            END IF
          ELSE IF (IDM(1:1) /= '+') THEN
            IF (IGBL(19) < 2) THEN
              IGBL(19)            = IGBL(19) + 1
              FILENAMES(IGBL(19)) = IDM
            END IF
          END IF
        END DO
C * ANALYZE/STORE FILENAME - DETERMINE FILE EXTENSION
        CALL PLA261 (IGBL(19))
      ELSE
        IPR(599) = 0
C * CHECK/IMPLEMENT FOR SHORTCUTS
        IF (IGBL(3) /= 0) CALL GEN038 (ICL, 1, 80)
        SELECT CASE (IGBL(3))
C * CHECK FOR CIF-VALIDATION-RUN
          CASE (1)
            IF (IABS(IGBL(8)) == 3) THEN
              ICL      = 'VALID'
              IGBL(45) = 1
              CALL GEN108 (LU3, 0)
            ELSE
              WRITE (6,
     1   '(/, '' **  Cannot do -u !!! - CIF not Recognized **'', /)',
     2        IOSTAT = IOST)
              IF (IABS (IGBL(3)) == 1) STOP
            END IF
C * CALC RUN
          CASE (2)
            IF (IGBL(150) == 0) THEN
              ICL      = 'CALC'
              IGBL(45) = 1
            ELSE IF (IGBL(150) == 1) THEN
              ICL      = 'CALC INTRA'
            ELSE IF (IGBL(150) == 2) THEN
              ICL      = 'CALC INTER'
              IGBL(25) = 0
            ELSE IF (IGBL(150) == 3) THEN
              ICL      = 'CALC COORDN'
            ELSE IF (IGBL(150) == 4) THEN
              ICL      = 'CALC METAL'
            ELSE IF (IGBL(150) == 5) THEN
              ICL      = 'CALC HBONDS'
              IGBL(45) = 0
            END IF
            CALL GEN108 (LU3, 0)
C * ADP RUN
          CASE (3)
C * SET FOR PORTRAIT
            IGBL(45) = 1
C * SET CR ->> END & EXIT
            IPR(308) = 2
C * NO R/S CALC
            IPR(324) = 0
            CALL GEN108 (LU3, 0)
            ICL      = 'PLOT ADP COLOR'
C * ADDSYM RUN
          CASE (4)
C * NO R/S CALC
            IPR(324)  = 0
C * NO EXPAND
            IGBL(136) = 1
            ICL       = 'ADDSYM'
C * SQUEEZE RUN
          CASE (5)
            ICL = 'SQUEEZE'
C * TABLE RUN
          CASE (7)
            ICL = 'TABLE SUP'
C * SOLVE RUN
          CASE (9)
            ICL = 'CALC SOLV'
C * HKL GENERATE
          CASE (10)
            ICL = 'ASYM GENERATE'
C * CALC GEOM CSD
          CASE (11)
            ICL = 'CALC GEOM CSD'
C * ADDSYM SHELX
          CASE (16)
            ICL       = 'ADDSYM SHELX NOSF'
C * NO R/S CALC
            IPR(324)  = 0
C * NO EXPAND
            IGBL(136) = 1
C * ASYM (AVF) (VIEW)
          CASE (17)
            IF (IGBL(22) == 0) THEN
              ICL = 'ASYM AVF LIST 0 '
            ELSE IF (IGBL(22) == 1) THEN
              ICL = 'ASYM AVF VIEW '
            ELSE IF (IGBL(22) == 2) THEN
              ICL = 'ASYM AVF LIST 1 '
            END IF
C * MULABS
          CASE (18)
            ICL = 'MULABS'
C * CONTOUR DIFF-MAP
          CASE (19)
            ICL = 'CONTOUR DI'
C * CONTOUR FO-MAP
          CASE (20)
            ICL = 'CONTOUR FO'
C * CONTOUR SQUEEZE-MAP
          CASE (21)
            ICL = 'CONTOUR SQ'
C * CONTOUR PATTERSON-MAP
          CASE (22)
            ICL = 'CONTOUR PT'
C * CALC GEOM SPF
          CASE (23)
            ICL = 'CALC GEOM SPF'
C * CALC GEOM SHELX
          CASE (24)
            ICL = 'CALC SHELX'
            IGBL(25) = 0
            IPR(595) = 1
C * CALC GEOM RENUM SHELX
          CASE (27)
            ICL = 'CALC GEOM RENUM SHELX'
C * ADP RUN (PS ONLY)
          CASE (28)
C * SET MENU OFF
            IGBL(25) = 0
C * SET FOR PORTRAIT
            IGBL(45) = 1
C * NO R/S CALC
            IPR(324) = 0
            ICL      = 'PLOT ADP COLOR'
C * POWDER IOBS
          CASE (29)
            ICL = 'POWDER IOBS'
C * TWINROTMAT (-T2)
          CASE (30)
            ICL = 'ROTMAT'
C * POWDER ICALC
          CASE (31)
            ICL = 'POWDER'
C * FCF-VALIDATION  (LAUE)
          CASE (33)
            ICL = 'ASYM AVF VALID'
C * FCF-VALIDATION (BIJVOET)
          CASE (34)
            ICL = 'ASYM VALID'
C * TABL ACC
          CASE (35)
            ICL = 'TABL ACC'
C * CALC VOID (KPI)
          CASE (36)
            ICL = 'CALC VOID'
C * TWINROTMAT (-T1)
          CASE (37)
            ICL      = 'ROTMAT'
            IGBL(25) = 0
C * ADDSYM EQUAL
          CASE (38)
            ICL = 'CALC ADDSYM EQUAL SHELX NOSF'
C * TWINROTMAT (-T)
          CASE (40)
            ICL = 'ROTMAT'
C * AUTOMOLFIT
          CASE (41)
            ICL = 'FIT'
C * EXOR
          CASE (42)
            ICL = 'EXOR'
C * ULTRA FLIPPER
          CASE (43)
            ICL = 'FLIP'
C * DIFFFOURIER
          CASE (44)
            ICL = 'CALC DIFF'
C * CIF2SHELXL
          CASE (45)
            ICL = 'CIF2SHELXL'
C * BIJVOET ANALYSIS
          CASE (46)
            ICL = 'BIJVOET'
C * HYBRID (SQUEEZE) LOOP
          CASE (48)
            WRITE (ICL, '(''HYBRID'', I3)') NCYCLE
C * Z
          CASE (49)
C * CIF2PDB
          CASE (50)
            IPR(675) = 1
            ICL = 'CALC PDB EXPAND'
C * LEPAGE (-L) - WITH GRAPHICAL OUTPUT
          CASE (51)
            ICL = 'LEPAGE'
C * LEPAGE (-L1) - WITHOUT GRAPHICAL OUTPUT (TRAILER + LIS) ONLY
          CASE (52)
            ICL      = 'LEPAGE'
            IGBL(25) = 0
C * ShelxtPlot
          CASE (53)
            ICL = 'XTPLOT'
          CASE DEFAULT
C * INTERACTIVE OUTPUT PROGRAM HEADER (PLATON)
            IF (MODE == 0) THEN
C * PLATON HEADER ON TRAILER LISTING
              IF (IGBL(72) == 0) THEN
                WRITE (LU6, 99999, IOSTAT = IOST)
     1            IGBL(4), NVDR / 250000
                IGBL(72) = 1
              END IF
C * LIST ATOM LABEL ALIASES
              CALL PLA282 (-1, IDM(1:NP64), IDM(1:NP64), LU6)
              IF (IPR(39) == 0) THEN
C * END FOR EMPTY GLOBAL BLOCK
                IF (IABS (IGBL(8)) == 3) THEN
                  ICL = 'END'
                  RETURN
                ELSE
C * REPORT NO ATOMS (EXCEPT FOR STRAIN ANALYSIS)
 
                  IF (TEMPAB(1) == 0.0)
     1              WRITE (LU6, 99997, IOSTAT = IOST)
                END IF
              END IF
            END IF
            IPR(599) = 1
        END SELECT
      END IF
      RETURN
99999 FORMAT (/, '::', 25X,
     1        '*** S.e.l.e.c.t.e.d  I.n.s.t.r.u.c.t.i.o.n.s ***', /,
     2        ':: ', 24('*'), 1X,
     3        'CALC ALL   - for an exhaustive geometry calculation', /,
     4        ':: ', '*        PLATON        *', 1X,
     5        'ORTEP      - for default labeled ORTEP-look-alike', /,
     6        ':: ', '*        ======        *', 1X,
     7        'VALID      - for a PLATON/checkCIF validation run', /,
     8        ':: ', '*    A Multipurpose    *', 1X,
     9        'LEPAGE     - to  check for higher metrical symmetry', /,
     *        ':: ', '*   Crystallographic   *', 1X,
     1        'ADDSYM     - for a check for MISsed SYMmetry', /,
     2        ':: ', '*         Tool         *', 1X,
     3        'NONSYM     - for a non-cryst. symm. check', /,
     4        ':: ', '*          --          *', 1X,
     5        'SOLV       - to  search for missed solvent areas', /,
     6        ':: ', '*(C) 1980-2025 A.L.Spek*', 1X,
     7        'SQUEEZE    - to  handle disordered solvents', /,
     8        ':: ', '*          --          *', 1X,
     9        'NEWMAN     - for NEWMAN-Projection Plots', /,
     *        ':: ', '*   version :', I7, '   *', 1X,
     1        'LIST RADII - for current atomic radii list', /,
     2        ':: ', '*   scratch :', I5, 'MB   *', 1X,
     3        'HELP       - for Available Instruction Information', /,
     4        ':: ', 24('*'), 1X,
     5        'PLUTON     - to  enter the PLUTON sub-program', /, ':: ')
99998 FORMAT ('PLATON-Version=', I10)
99997 FORMAT (/, ':: Warning: no ATOMS given yet')
      END SUBROUTINE PLA005
 
      SUBROUTINE PLA006 (MODE, IS)
C * FREE FORMAT READ ROUTINE FOR PLATON, SYSTEM-S & PLUTON
      USE files
      USE parameters
      USE atomdata
      USE cchar
      USE cif
      USE cggt
      USE chdat
      USE mentry
      IMPLICIT NONE
      INTEGER :: I
      INTEGER :: J
      INTEGER :: N
      INTEGER :: IS
      INTEGER :: KL
      INTEGER :: KN
      INTEGER :: NP
      INTEGER :: IER
      INTEGER :: MODE
      INTEGER :: NCARD
      INTEGER :: ICONT
      INTEGER :: IENDS
      INTEGER :: IGOTO
      INTEGER :: ISWVAL
      INTEGER :: LRETPDB
      REAL :: A
      REAL :: S
C * READ MODE = 0 - PLATON/SYSTEM-S
C *             1 - PLUTON
C * DATA INPUT STYLES:
C * IGBL(8) = 1 - SPF
C *         = 2 - RES
C *         = 3 - CIF
C *         = 4 - PDB
      NP    = 0
      S     = 0.0
      IGOTO = 0
   10 J     = 0
      ICONT = 0
      A     = 0.0
   20 KN    =  0
      KL    =  0
      IS    = -1
C * INITIALIZE LITERAL AND NUMBER ARRAYS (IFL & FN)
      CALL GEN074 (FN, 1, NP17, 0.0)
      DO I = 1, NP17
        CALL GEN038 (IFL(I), 1, NP64)
      END DO
C * CONSIDER INTERACTIVE GRAPHICS INPUT OR AUTO 'PLOT'
      IF (IGGT(1:1) == ' ') THEN
C * IGBL(6) = MENU #
        IF (IGBL(6) > 0) THEN
C * CHECK FOR PLATON MAIN MENU'S
          IF (IGBL(6) < 10 .OR. IGBL(6) > 12) THEN
C * IGBL(5)  = READ CHANNEL SEQUENCE (1, 3, 5)
C * IGBL(24) = PLOT-AS-DEFAULT
C * IGBL(25) = MENU ON/OFF
            IF (IGBL(5) * IGBL(24) * IGBL(25) == LU5) THEN
              ICL = 'PLOT'
              GO TO 50
            END IF
          END IF
        END IF
C * CHECK FOR ALTERNATE INPUT/OUTPUT FROM/TO GRAPHICS ROUTINE
      ELSE
C * COPY GRAPHICAL INPUT
        ICL = IGGT
C * CLEAR
        CALL GEN038 (IGGT, 1, 80)
        GO TO 50
      END IF
C * CHECK FOR SPECIAL SHORTCUTS AND GENERATE CORRESPONDING INSTRUCTIONS
   30 IF (IGBL(5) == LU5) THEN
        CALL PLA005 (MODE, ISWVAL)
        IF (IPR(599) == 0) GO TO 50
      END IF
C * READ CARD-IMAGE IN CHARACTER BUFFER ICL
   40 CALL PLA019 (0, IER)
      IF (IER /= 0) THEN
        IGBL(8) = - IABS (IGBL(8))
        GO TO 70
      END IF
C * CHECK FOR PLUTON MODE
      IF (MODE == 1 .AND. IGBL(5) == LU1) THEN
        CALL GEN038 (NQ1, 1, NP64)
        CALL PLUT29 (1, ICL, NQ1, 0, 0)
      END IF
C * CHECK/FIND-OUT DATA TYPE (= IGBL(8))
   50 IF (IGBL(8) == 0) THEN
C * CHECK FOR 'FIRST LINE(S)' FOR CIF/PDB
C * BUT IGNORE BLANK AND # IN COLUMN 1 LINES
        DO
C * LOOK FOR CIF-STYLE STRUCTURED DATA (TRIGGERED BY data_) (IGBL(8) = 3)
          N = INDEX (ICL, 'data_')
          IF (N > 0 .AND. ICL(1:4) /= 'TITL' .AND.
     1      INDEX (ICL, '_data_') == 0) THEN
C * CIF-standard Data !!
            IGBL(8) = 3
            ISEMCOL = 0
            IVOID   = 0
            ILOOP   = 0
            NL      = 0
            LRETCIF = 0
C * CHECK FOR CSD-CIF VARIETY
            IF (ICL(N + 5:N + 11) == 'CSD_CIF') IGBL(104) = 1
C * GET NUMBER OF DATASET ENTRIES
            IPR(220) = 1
            IPR(221) = 0
C * SET NOMOVE DEFAULT FOR CIF DATA INPUT
            IGBL(30) = 1
            WRITE (LU6, 99999, IOSTAT = IOST)
C * CREATE MULTIPLE CIF ENTRY DIRECTORY (=> IGBL(100) ENTRIES)
            CALL PLA007
C * REPORT NUMBER OF VALID CIF DATA ENTRIES
            WRITE (LU6, 99998) IGBL(100)
C * FIND REFLECTIONS (fcf or hkl STYLE) PLATON MODE
            IF (MODE == 0) CALL PLA008
C * SKIP TO FIRST REAL ENTRY
            IF (IGBL(100) > 0) THEN
              CALL GEN108 (LU1, 0)
              NCARD = IENTRY(1, 2)
              DO I = 1, NCARD
                READ (LU1, 99997, IOSTAT = IOST) ICL
                IF (IOST /= 0) CYCLE
              END DO
            END IF
            GO TO 40
          END IF
          IF (LRETCIF == -2) THEN
            IGBL(8) = - IABS (IGBL(8))
            RETURN
          END IF
C * ASSUME SPF = 1 (OR RES = 2, BASED ON SFAC)
          IF (IGBL(8) == 0) THEN
            N = INDEX (ICL, 'TITL')
            IF (N > 0) THEN
              IGBL(8) = 1
C * CHECK FOR REFLECTION FILE
              CALL PLA008
              GO TO 50
            END IF
          END IF
C * CHECK FOR PDB-FILE-STRUCTURE  (IGBL(8) = 4)
          IF (IGBL(8) == 0) THEN
            LRETPDB = -1
            CALL PLA381 (MODE, LRETPDB)
            IF (IGBL(8) /= 0) EXIT
          END IF
C * CATCH INSTRUCTIONS
          IF (IGBL(8) == 0) THEN
            NQ1 = ICL(1:4)
            CALL GEN020 (1, NQ1, 1, 4)
            IF (NQ1(1:4) == '    ') THEN
              GO TO 40
            ELSE IF (NQ1(1:4) == 'EXIT') THEN
              RETURN
            ELSE IF (NQ1(1:4) == 'FILE') THEN
              IGBL(8) = 1
              GO TO 50
            ELSE IF (NQ1(1:4) == 'TITL') THEN
              IGBL(8) = 1
              GO TO 50
            ELSE IF (NQ1(1:4) == 'HELP') THEN
              GO TO 50
            END IF
          ELSE
            IPR(2) = 64
            RETURN
          END IF
          GO TO 40
        END DO
C * RESTRICTED CIF - FORMAT (COMPATIBLE WITH SHELXL)
      ELSE IF (IGBL(8) == 3) THEN
        CALL PLA176 (MODE)
        KL = IPR(220)
        KN = IPR(221)
        SELECT CASE (LRETCIF)
C * NORMAL RETURN
          CASE (0)
            GO TO 60
C * TITL, CELL etc. RECORD
          CASE (1)
            GO TO 60
C * ERROR RETURN
          CASE (2)
            IGBL(8) = - IABS (IGBL(8))
            GO TO 70
C * SYSTEM S RETURN
          CASE (3)
            IS      = -2
            IPR(3)  = 1
            IGBL(8) = - IABS (IGBL(8))
            GO TO 70
C * CIF BOND/ANGLE/TORSION/HBOND
          CASE (4)
            IS = -3
            RETURN
        END SELECT
C * PDB-FILE STRUCTURE
      ELSE IF (IGBL(8) == 4) THEN
        LRETPDB = 0
        CALL PLA381 (MODE, LRETPDB)
C * CHECK RETURN CODE
        IF (LRETPDB == 0) THEN
          GO TO 60
C * END-OF-FILE
        ELSE IF (LRETPDB == 1) THEN
          IGBL(8) = - IABS (IGBL(8))
          GO TO 70
C * ERROR IN READ
        ELSE IF (LRETCIF == 2) THEN
          IS      = 0
          IPR(3)  = 1
          IGBL(8) = - IABS (IGBL(8))
          GO TO 70
        END IF
C * SPF or RES  & Instructions
      ELSE
        CALL PLA017 (MODE, IGOTO, ICONT, KL, KN, IS, A, J, NP, S)
        SELECT CASE (IGOTO)
          CASE (1)
            GO TO 20
          CASE (2)
            GO TO 60
          CASE (3)
            GO TO 70
        END SELECT
      END IF
C * TEST FOR CONTINUATION OR FINISHED
   60 IF (IS < 0) THEN
        IF (IFL(1)(1:4) == 'TEXT') THEN
          LMOD = 0
          CALL PLA109 (1, 1, 0.0, 0.0)
C * WHAT NEXT ?
          CALL PLA012 (0, 1)
          GO TO 10
        END IF
C * PLATON
        IF (MODE == 0) THEN
C * TRANSFORM KEYWORD TO ENTRYPOINT NUMBER IN ARRAY
          CALL GEN102 (IS, IFL(1)(1:4), ISWS, NP24)
C * PLUTON
        ELSE
C * TRANSFORM KEYWORD TO ENTRYPOINT NUMBER IN ARRAY
          CALL GEN102 (IS, IFL(1)(1:4), CRD,  NP37)
        END IF
      END IF
C * DO NOT INTERPRETE TITL, REM OR MESS CARD (ADD 1 TO IS SERIAL NR)
      IF (ICONT == 1) THEN
        IF (IS < 2 .OR. IS > 4) GO TO 30
      END IF
C * HANDLE TERMINATING ENDS - LINE
      IENDS = 0
      IF (MODE == 0) THEN
        IF (IS == 14)  IENDS = 1
      ELSE
        IF (IS == 140) IENDS = 1
      END IF
      IF (IENDS == 1) THEN
        CALL PLA019 (0, IER)
          IF (IER >= 0) THEN
          BACKSPACE IGBL(5)
        ELSE
          IS = -1
        END IF
      END IF
   70 IPR(220) = KL
      IPR(221) = KN
      IF (MODE == 1) THEN
C * TRNS = TRMX
        IF (IS == 93) THEN
          IS = 65
C * ARU  = MOLES
        ELSE IF (IS == 71) THEN
          IS = 26
C * BWC  > COLOR
        ELSE IF (IS == 64) THEN
          IS = 40
C * MONO > STEREO
        ELSE IF (IS == 32) THEN
          IS = 31
C * CALC = JOIN
        ELSE IF (IS == 156) THEN
          IS = 13
        END IF
      END IF
      RETURN
99999 FORMAT (':: Restricted CIF-File Format assumed',
     1           ' (Automatic NOMOVE effective) ', /)
99998 FORMAT (/, ':: Number of Valid CIF data_ ENTRIES =', I6, /)
99997 FORMAT (A)
      END SUBROUTINE PLA006
 
      SUBROUTINE PLA007
C * HANDLING OF MULTIPLE ENTRY FILES - CREATE VALID ENTRY DIRECTORY
      USE files
      USE parameters
      USE mentry
      USE xwdw
      USE cggt
      USE cchar
      IMPLICIT NONE
      INTEGER :: I
      INTEGER :: J
      INTEGER :: K
      INTEGER :: L
      INTEGER :: N
      INTEGER :: M
      INTEGER :: NPC
      INTEGER :: NPD
      INTEGER :: IFCF
      INTEGER :: NCRD
      INTEGER :: ILST
      INTEGER :: NCARD
      INTEGER :: ISKIP
      INTEGER :: NDATA
      INTEGER :: NENTRY
      INTEGER :: IVALID
      INTEGER :: ISEMCOL
      REAL :: XH
      REAL :: XV
      CHARACTER(len=1)       :: CYN
      CHARACTER(len=80)      :: LIN
      CHARACTER(len=75)      :: CDATA
      CHARACTER(len=8), SAVE :: RCODE = '        '
      CHARACTER(len=8)       :: REFCOD
C * RECOGNIZED STRUCTURE PARAMETER INPUT FILE TYPES
C * IGBL(8) = 1 - spf
C *         = 2 - res (ins)
C *         = 3 - cif
C *         = 4 - pdb
      PRBUF = ' '
      IFCF    = 0
      ISEMCOL = 0
C * CHECK FOR THE CASE OF NO-DATA ON THE INPUT FILE LU1  (All interactive mode)
      IF (LU1 == LU5) THEN
        WRITE (LU6, 99999, IOSTAT = IOST)
      ELSE
C * OPTIONS: NUMBER, REFCODE OR BLANK (= LIST)
        IF (IPR(220) > 1) THEN
          REFCOD = IFL(2)(1:8)
          NENTRY = 0
        ELSE
          REFCOD = ' '
          IF (IPR(221) > 0) THEN
            NENTRY = NINT(FN(1))
C * CHECK # OF ENTRIES IN FILE (CIF)
            IF (IGBL(100) /= 0) GO TO 30
          ELSE
C * LIST ENTRY DETAILS (CIF & FCF)
            NENTRY = 0
            IF (IGBL(100) /= 0 .AND. IGBL(94) == 0) THEN
              IPR(462) = 1
              N = MIN (IGBL(100), NP54)
              DO I = 1, N
                IF (I == 1) WRITE (LU6, 99993)
                WRITE (LU6, 99996) I, CENTRY(I)(1:57),
     1           (IABS (IENTRY(I, J)), J = 1, 4)
              END DO
            END IF
          END IF
        END IF
C * GET DIRECTORY FOR CIF_FILE OR ELD_FILE
        IF (NENTRY == 0 .OR. IGBL(100) == 0) THEN
          IF (IGBL(8) /= 0 .AND. IABS (IGBL(8)) <= 4) THEN
            ILST      = 1
            NCARD     = 0
            NDATA     = 0
            ISKIP     = 0
            IVALID    = -1
            XH        = 0.0
            XV        = VERT
            IGBL(100) = 0
            IGBL(86)  = NVDR - 6
C * REWIND
            CALL GEN108 (LU1, 0)
C * READ DATA ENTRIES LOOP
            DO
              READ (LU1, 99994, IOSTAT = IOST) ICL
              IF (IOST /= 0) EXIT
C * COUNT READ LINES
              NCARD = NCARD + 1
C * HANDLE/SKIP EMBEDDED '_iucr_refine_fcf_details' SECTION(S)
              IF (IFCF == 1) THEN
                IF (ICL(1:1) == ';') THEN
                  IF (ISEMCOL == 0) THEN
                    ISEMCOL = 1
                  ELSE
                    ISEMCOL = 0
                    IFCF    = 0
                  END IF
                END IF
                CYCLE
              END IF
              IF (ICL(1:1) == '#') CYCLE
              NCRD  = 1
C * SPF - SEQUENCE
              IF (ABS(IGBL(8)) == 1) THEN
                CALL GEN020 (1, ICL(1:4), 1, 4)
                IF (ICL(1:4) == 'TITL') THEN
                  CDATA = ICL(6:13)
                  NDATA = NCARD - 1
                  GO TO 10
                 ELSE
                   CYCLE
                 END IF
C * RES - SEQUENCE
              ELSE IF (ABS (IGBL(8)) == 2) THEN
                IF (ICL(1:4) == 'TITL') THEN
                  NDATA = NCARD - 1
                  CDATA = ICL(6:13)
                  GO TO 10
                ELSE
                  CYCLE
                END IF
C * CIF - SEQUENCE
              ELSE IF (ABS (IGBL(8)) == 3) THEN
C * HANDLE EMBEDDED FCF
                IF (INDEX (ICL(1:80), '_iucr_refine_fcf_details') /= 0
     1            .OR. INDEX (ICL(1:80), '_shelx_fcf_hkl') /= 0) THEN
                  IFCF    = 1
                  ISEMCOL = 0
                  CYCLE
                END IF
                NPD = INDEX (ICL(1:80), '#')
                IF (NPD == 0) NPD = 80
                NPC = INDEX (ICL(1:NPD), '_publ_requested_category')
                IF (NPC /= 0) THEN
                  IF (INDEX (ICL(NPC + 24: NPD), 'I') /= 0) THEN
                    IGBL(99) = 1
                  ELSE IF (INDEX (ICL(NPC + 24: NPD), 'M') /= 0) THEN
                    IGBL(99) = 2
                  ELSE IF (INDEX (ICL(NPC + 24: NPD), 'O') /= 0) THEN
                    IGBL(99) = 3
                  END IF
                ELSE IF (INDEX (ICL(1:40), 'data_') /= 0 .AND.
     1                   INDEX (ICL(1:40), '_data_') == 0 .AND.
     2                   ICL(1:4) /= 'TITL' .AND.
     3                   ICL(1:3) /= 'REM') THEN
C * REPORT ON NON-VALID CIF DATA SECTIONS
                  IF (IVALID == 0) THEN
                    WRITE (LU6, 99992) CDATA(1:50)
                  END IF
                  IVALID = 0
                  N = INDEX (ICL(1:40), 'data')
C * PREPARE TO RECEIVE AUDIT SOFTWARE TOOL NAME TO BE USED AS DEFAULT
                  IF (INDEX (ICL(1:80), 'global') /= 0) NCIF23 = 0
                  CALL GEN151 (ICL, N + 5)
                  CDATA = ICL(N + 5:80)
C * HANDLE CSD CREATED CIF DATASET NAME CASE
                  IF (CDATA(1:7) == 'CSD_CIF') THEN
                    IF (ICL(N + 13:N + 16) == 'MIF_') THEN
                      CDATA = ICL(N + 17:N + 24)
                    ELSE
                      CDATA = ICL(N + 13:80)
                    END IF
                  END IF
                  NDATA = NCARD - 1
                ELSE IF (INDEX (ICL(1:80), '_cell_length_a') /= 0) THEN
                  IVALID = 1
                  GO TO 10
                ELSE IF (INDEX (ICL(1:80), '_audit_creation_method')
     1            /= 0) THEN
                  I = INDEX (ICL(1:80), '_audit_creation_method')
                  K = 0
                  L = 0
                  DO J = I + 22, 80
                    IF (ICL(J:J) == ' ') THEN
                      CYCLE
                    ELSE IF (ICL(J:J) == '''' .OR.
     1                       ICL(J:J) == '"') THEN
                      K = J
                      L = INDEX (ICL(K + 1:80), '''')
                      IF (L == 0) L = INDEX (ICL(K + 1:80), '"')
                      IF (L == 0) L = 60 - K
                      EXIT
                    ELSE
                      K = J - 1
                      L = INDEX (ICL(K + 1:80), ' ')
                      EXIT
                    END IF
                  END DO
                  IF (K == 0 .AND. L == 0) THEN
                    READ (LU1, 99994, IOSTAT = IOST) ICL
                    IF (IOST /= 0) EXIT
C * COUNT READ LINES
                    NCARD = NCARD + 1
                    IF (ICL(1:1) == ';') THEN
                      READ (LU1, 99994, IOSTAT = IOST) ICL
                      IF (IOST /= 0) EXIT
C * COUNT READ LINES
                      NCARD = NCARD + 1
                      CALL GEN039 (0, ICL, 1, 80, K, L)
                    END IF
                    NCIF23 = L - K + 1
                    CCIF23 = ICL(K:L)
                  ELSE
                    NCIF23 = L - 1
                    CCIF23 = ICL(K + 1: K + L - 1)
                  END IF
                  WRITE (LU6, 99991) CCIF23(1:NCIF23)
                END IF
                CYCLE
C * PDB SEQUENCE
              ELSE IF (IABS (IGBL(8)) == 4 .AND.
     1                 ICL(1:6) == 'HEADER') THEN
              ELSE
                CYCLE
              END IF
C * SAVE DATA ENTRY NAMES
   10         IF (IGBL(86) > 1) THEN
                IGBL(100) = IGBL(100) + 1
                IF (IPR(462) /= 1) THEN
                  IF (ABS (IGBL(8)) == 3) THEN
C * SHOW PROGRESS IN READING ENTRIES IN FILE
                    IF (MOD (IGBL(100), 1000) == 0) THEN
                      IF (IGBL(25) * IGBL(32) == 1) THEN
                        IF (IGBL(100) == 1000) THEN
                          CALL GGIP (HORS, VERT, 0.0, 1)
                        END IF
                        CALL PLA439 (0.0, PRBUF, 80, 0.35, 0, 2, 0.5,
     1                     0.5)
                        WRITE (PRBUF, 99995, IOSTAT = IOST) IGBL(100)
                        CALL PLA439 (0.0, PRBUF, 80, 0.35, 1, 2, 0.5,
     1                     0.5)
                        CALL GGIP (0.0, 0.0, 0.0, 6)
                      END IF
                    END IF
                  END IF
                END IF
                IGBL(86) = IGBL(86) - 1
C * SPF - STYLE
                IF (ABS (IGBL(8)) == 1) THEN
                  VOID(NVDR - 6 - IGBL(100)) = NDATA
                  IF (IGBL(100) <= NP54) THEN
                    CENTRY(IGBL(100))    = CDATA
                    IENTRY(IGBL(100), 1) = IGBL(8)
                    IENTRY(IGBL(100), 2) = NDATA
                  END IF
C * RES - STYLE
                ELSE IF (ABS (IGBL(8)) == 2) THEN
                  VOID(NVDR - 6 - IGBL(100)) = NDATA
                  IF (IGBL(100) <= NP54) THEN
                    CENTRY(IGBL(100))    = CDATA
                    IENTRY(IGBL(100), 1) = IGBL(8)
                    IENTRY(IGBL(100), 2) = NDATA
                  END IF
C * CIF - STYLE
                ELSE IF (ABS (IGBL(8)) == 3) THEN
                  VOID(NVDR - 6 - IGBL(100)) = NDATA
C * SPECIAL SAVE
                  IF (IGBL(100) <= NP54) THEN
                    CENTRY(IGBL(100))    = CDATA
                    IENTRY(IGBL(100), 1) = IGBL(8)
                    IENTRY(IGBL(100), 2) = NDATA
                  END IF
                ELSE
                  VOID(NVDR - 6 - IGBL(100)) = NCARD - NCRD
C * SPECIAL SAVE
                  IF (IGBL(100) <= NP54)
     1              IENTRY(IGBL(100), 1) = NCARD - NCRD
                END IF
C * LIST ENTRIES
                IF (IPR(220) == 1 .AND. IPR(221) == 0) THEN
                  IF (ILST * IPR(462) == 1) THEN
                    IF (ILST == 1) THEN
                      IF (IGBL(25) * IGBL(32) == 1 .AND.
     1                    IGBL(100) == 1)
     2                    CALL GGIP (HORS, VERT, 0.0, 1)
C * SPF ENTRY
                      IF (ABS (IGBL(8)) == 1) THEN
                        WRITE (LIN, 99997, IOSTAT = IOST)
     1                    IGBL(100), ICL(6:10)
                        M = 4
C * RES ENTRY
                      ELSE IF (ABS (IGBL(8)) == 2) THEN
                        WRITE (LIN, 99997, IOSTAT = IOST)
     1                    IGBL(100), ICL(6:10)
                        M = 4
C * CIF ENTRY
                      ELSE IF (IABS (IGBL(8)) == 3) THEN
C * CHECK FOR FULL OR CSD-CIF TYPE
                        IF (IGBL(94) == 0) THEN
                          M = 74
                        ELSE
                          M = 8
                        END IF
                        WRITE (LIN, 99997, IOSTAT = IOST)
     1                    IGBL(100), CDATA(1:M)
C * PDB ENTRY
                      ELSE IF (IABS (IGBL(8)) == 4) THEN
                        IF (ICL(63:66) /= '    ') THEN
                          WRITE (LIN, 99997, IOSTAT = IOST)
     1                      IGBL(100), ICL(63:70)
                          M = 8
                        ELSE
                          WRITE (LIN, 99997, IOSTAT = IOST)
     1                      IGBL(100), ICL(11:18)
                          M = 8
                        END IF
                      END IF
                      XV = XV - 0.45
                      CALL PLA439 (0.0, LIN, 6 + M, 0.34, 1, 2, XH, XV)
                    END IF
                    IF (MOD (IGBL(100), 43) == 0) THEN
                      XH = XH + 4.3
                      XV = VERT
                      IF (XH + 4.3 >= HORS) THEN
                        IF (IGBL(25) * IGBL(32) == 1) THEN
C * WHAT NEXT ?
   20                     CALL PLA012 (3, 1)
                          SELECT CASE (IGGT(1:4))
                            CASE ('PLOT')
                              GO TO 20
                            CASE ('EXIT')
                              CALL GEN038 (IGGT, 1, 80)
                              RETURN
                            CASE ('N   ', 'NO  ')
                              CALL GEN038 (IGGT, 1, 80)
                              RETURN
                          END SELECT
                          CALL GEN072 (IGGT, IFL, FN, IPR(220),
     1                       IPR(221), 0, LU6, 1, 1, 80, 7, NP17)
                          CALL GEN038 (IGGT, 1, 80)
                          IF (IPR(221) > 0) THEN
                            NENTRY = NINT (FN(1))
                            GO TO 30
                          END IF
                        ELSE
                          CALL GEN125 (1, LU6,
     1                      'Continue Listing (Y/N[Y])')
                          READ  (LU5, 99994) CYN
                        END IF
                        CALL GEN020 (1, CYN, 1, 1)
                        IF (CYN == 'N') THEN
                          ILST = 0
                        ELSE
                          CALL GGIP (HORS, VERT, 0.0, 1)
                          XH = 0.0
                          XV = VERT
                        END IF
                      END IF
                    END IF
                  END IF
                ELSE
                  IF (IABS (IGBL(8)) == 4) THEN
                    IF (RCODE == REFCOD) THEN
                      NENTRY   = IGBL(100)
                      IPR(221) = 1
                    END IF
                  ELSE IF (IABS (IGBL(8)) == 3) THEN
                    IF (ICL(6:13) == REFCOD) THEN
                      NENTRY   = IGBL(100)
                      IPR(221) = 1
                    END IF
                  ELSE IF (IABS (IGBL(8)) == 1) THEN
                    IF (ICL(6:13) == REFCOD) THEN
                      NENTRY   = IGBL(100)
                      IPR(221) = 1
                    END IF
                  END IF
                END IF
              END IF
            END DO
            IF (IPR(462) == 1) THEN
              DO
C * WHAT NEXT ?
                CALL PLA012 (3, 1)
                IF (IGGT(1:4) /= 'PLOT') THEN
                  CALL GEN072 (IGGT, IFL, FN, IPR(220), IPR(221), 0,
     1               LU6, 1, 1, 80, 7, NP17)
                  CYN = IGGT(1:1)
                  CALL GEN038 (IGGT, 1, 80)
                  IF (IPR(221) > 0) NENTRY = NINT (FN(1))
                  EXIT
                END IF
              END DO
            END IF
            IPR(462) = 0
            IF (ICL(1:1) == ';') CALL GEN038 (ICL, 1, 80)
            CALL GEN108 (LU1, 0)
          END IF
        END IF
C * FIND ENTRY STARTING POINT
   30   IF (NENTRY > 0) THEN
          IF (IABS(IGBL(8)) <= 4) THEN
            IF (NENTRY <= IGBL(100)) THEN
              IGBL(54) = NENTRY - 1
C * READ UNTIL (BUT NOT INCLUDING) FIRST LINE OF REQUESTED ENTRY
              IF (NENTRY <= NP54) THEN
                NCARD   = IENTRY(NENTRY, 2)
                IGBL(9) = IENTRY(NENTRY, 3)
              ELSE
                NCARD = NINT (VOID(NVDR - 6 - NENTRY))
              END IF
              CALL GEN108 (LU1, 0)
              IF (NCARD > 0) THEN
                DO I = 1, NCARD
                  READ (LU1, 99994, IOSTAT = IOST) ICL
                  IF (IOST /= 0) CYCLE
                END DO
              END IF
C * READ UNIT = 5
              ICL    = 'END'
              IPR(3) = 1
            ELSE
C * REPORT ENTRY NOT FOUND ....
              WRITE (LU6, 99998, IOSTAT = IOST)
     1          REFCOD, NENTRY, IGBL(100)
              ICL    = 'END'
              IPR(3) = 1
            END IF
          END IF
        ELSE
C * REPORT ENTRY NOT FOUND ....
          IF (IPR(220) > 1) THEN
            WRITE (LU6, 99998, IOSTAT = IOST) REFCOD, NENTRY, IGBL(100)
            CALL PLA015 (427, 50)
          END IF
        END IF
      END IF
      RETURN
99999 FORMAT (':: No Entries in File LU1 (Instruction Ignored)')
99998 FORMAT (/, ':: Entry not found (', A, 2I10,')')
99997 FORMAT (I5, 1X, A)
99996 FORMAT (I2, 1X, A, 2(I3, I7))
99995 FORMAT ('Count Number of Entries on Input:', I6)
99994 FORMAT (A)
99993 FORMAT (/,'Nr Dataset Name', 42X, 'CIFtyp   Rec RFLtyp Rec')
99992 FORMAT (':: Skipped CIF-data Section: ', A)
99991 FORMAT (':: Default global AUDIT TOOL Name: ', A, /)
      END SUBROUTINE PLA007
 
      SUBROUTINE PLA008
C * SEARCH FOR ASSOCIATED REFLECTION FILE FOR SUPPLIED CIF/RES/SPF
C * STEP 1 - DETERMINE COORDINATE - REFLECTION FILE PAIRING
C * STEP 2 - DETERMINE REFLECTION STYLE IN PLA009 (AND IN CASE OF
C *          IGBL(15) = 1 - WITH PLA010
      USE files
      USE parameters
      USE cchar
      IMPLICIT NONE
C * IGBL(15) =  1 - fcf/FCF
C *          =  0 - hkl/HKL
C *          = -1 - no hkl or fcf reflection file association found
C * CIF MODEL PARAMETER FILE CASE
      IGBL(29) = 0
      KNM16    = KNMFIL + 4
      IF (ABS(IGBL(8)) == 3) THEN
        IGBL(15) = 1
C * SEARCH FOR name.fcf .OR. name.FCF first in case of name.cif INPUT
        FNLU16 = NAMEFIL(1:KNMFIL)//'.fcf'
        INQUIRE (FILE = FNLU16, EXIST = EXST16)
        IF (.NOT. EXST16) THEN
          FNLU16   = NAMEFIL(1:KNMFIL)//'.FCF'
          INQUIRE (FILE = FNLU16, EXIST = EXST16)
          IF (.NOT. EXST16) THEN
            IGBL(15) = 0
            FNLU16 = NAMEFIL(1:KNMFIL)//'.hkl'
            INQUIRE (FILE = FNLU16, EXIST = EXST16)
            IF (.NOT. EXST16) THEN
              FNLU16 = NAMEFIL(1:KNMFIL)//'.HKL'
              INQUIRE (FILE = FNLU16, EXIST = EXST16)
              IF (.NOT. EXST16) THEN
C * NO REFLECTION DATA FOUND
                IGBL(15) = -1
              END IF
            END IF
          END IF
        END IF
C * SPF/RES MODEL PARAMETER FILE
      ELSE IF (ABS(IGBL(8)) == 2 .OR.
     1         ABS(IGBL(8)) == 1) THEN
        IGBL(15) = -1
        FNLU16 = NAMEFIL(1:KNMFIL) //'.hkl'
        INQUIRE (FILE = FNLU16, EXIST = EXST16)
        IF (.NOT. EXST16) THEN
          FNLU16 = NAMEFIL(1:KNMFIL) //'.HKL'
          INQUIRE (FILE = FNLU16, EXIST = EXST16)
          IF (.NOT. EXST16) THEN
            FNLU16 = NAMEFIL(1:KNMFIL) //'.fcf'
            INQUIRE (FILE = FNLU16, EXIST = EXST16)
            IF (.NOT. EXST16) THEN
              FNLU16 = NAMEFIL(1:KNMFIL) //'.FCF'
              INQUIRE (FILE = FNLU16, EXIST = EXST16)
              IF (.NOT. EXST16) THEN
C * NO REFLECTION DATA FOUND
                IGBL(15) = -1
              ELSE
                IGBL(15) = 1
              END IF
            ELSE
              IGBL(15) = 1
            END IF
          ELSE
            IGBL(15) = 0
          END IF
        ELSE
          IGBL(15) = 0
        END IF
      ELSE
        IGBL(15) = -1
      END IF
C * OPEN & DETERMINE REFLECTION FILE TYPE
      IF (IGBL(15) >= 0) THEN
        OPEN (UNIT = LU16, FILE = FNLU16, STATUS = 'OLD', IOSTAT = IOST)
        IF (IOST == 0) THEN
          WRITE (LU6, 99999) FNLU16
C * DETERMINE
          CALL PLA009
C * DETERMINE MODEL & REFLECTION DATA COMBINATIONS
 
C * RES FILE
          IF (IABS (IGBL(8)) == 2) THEN
C * HKL FILE
            IF (IABS (IGBL(9)) == 0) THEN
              IGBL(29) = -1
C * FCF FILE (LIST 4)
            ELSE IF (IABS (IGBL(9)) == 1) THEN
              IGBL(29) = -2
            END IF
C * CIF FILE
          ELSE IF (IABS (IGBL(8)) == 3) THEN
C * FCF FILE (LIST 4)
            IF (IABS (IGBL(9)) == 1) THEN
              IGBL(29) = 1
C * FCF FILE (LIST 6)
            ELSE IF (IABS (IGBL(9)) == 23) THEN
              IGBL(29) = 2
C * FCF FILE (LIST 8)
            ELSE IF (IABS (IGBL(9)) == 25) THEN
              IGBL(29) = 3
            END IF
          END IF
        ELSE
          IGBL(15) = -1
        END IF
      END IF
      RETURN
99999 FORMAT (':: Reflection Data from: ', A)
      END SUBROUTINE PLA008
 
      SUBROUTINE PLA009
C * DETERMINE REFLECTION FILE TYPE (2)
      USE files
      USE parameters
      USE atomdata
      USE cchar
      USE mentry
      IMPLICIT NONE
      INTEGER :: I
      INTEGER :: K
      INTEGER :: N
      INTEGER :: M
      INTEGER :: IH = 0
      INTEGER :: IK = 0
      INTEGER :: IL = 0
      INTEGER :: NC
      INTEGER :: IER
      INTEGER :: NCR
      INTEGER :: NHASH
      INTEGER :: ILMAX
      INTEGER :: IRTYPE
      INTEGER :: NENTRY
C * IGBL(9)  = -1 : HKL-EXT (CONTAINING SQUEEZE AND ORIGINAL Iobs)
C *          =  0 : HKL              (SHELXL HKLF 4 STYLE)
      IF (IGBL(15) == 0) THEN
C * HANDLE NAG COMPILER ISSUE WITH DUMMY USE OF IH,IK,IL
        N = IH + IK + IL
        N = 0
        DO I = 1, 10
          READ (LU16, 99999, IOSTAT = IOST) PRBUF
          READ (PRBUF, 99998, IOSTAT = IOST) IH, IK, IL
          IF (IOST /= 0) THEN
            IF (INDEX (PRBUF, 'CRYSTALS') > 0) THEN
              IGBL(15) = 0
              N        = -2
              EXIT
            END IF
            IGBL(15) = 1
          END IF
        END DO
      END IF
      REWIND (LU16)
      READ (LU16, 99999, IOSTAT = IOST) PRBUF
      IF (IGBL(15) == 0) THEN
C * DETERMINE SHORT/LONG HKLF RECORD
        IF (PRBUF(88:88) /= ' ') N = -1
        IENTRY(1, 3) = N
        IRTYPE       = N
C * FIND OUT ABOUT DIRECTION COSINES, ABS PSI or NONE
        IGBL(37) = 0
        DO K = 1, 48
          IF (PRBUF(81 - K:81 - K) /= ' ' .AND.
     1        PRBUF(81 - K:81 - K) /= CHAR (13)) THEN
            IF (K < 10) THEN
              IGBL(37) = 1
              RETURN
            ELSE
              IGBL(37) = 2
              RETURN
            END IF
          END IF
        END DO
      END IF
C * FCF
      IF (IGBL(15) == 1) THEN
C * Determine Reflection File type
        IER    = 0
        IRTYPE = 0
        NENTRY = 0
        CALL GEN108 (LU16, 0)
C * COUNT NUMBER OF ENTRIES IN FCF-FILE
        OPEN (UNIT = LU63, STATUS = 'SCRATCH', FORM = 'FORMATTED',
     1    IOSTAT = IOST)
C * COUNT RECORDS
        M  = 0
        NC = 0
        DO
          READ (LU16, 99999, IOSTAT = IOST) PRBUF
          IF (IOST /= 0) EXIT
          M  = M  + 1
          NC = NC + 1
          IF (NC == 100) THEN
            IF (NENTRY > 0) THEN
              REWIND LU63
              CALL PLA010 (LU63, IRTYPE, IER)
              IENTRY(NENTRY, 3) = IRTYPE
            END IF
          END IF
          WRITE (LU63, 99999, IOSTAT = IOST) PRBUF
          N = INDEX (PRBUF, 'data_')
          IF (N /= 0) THEN
            REWIND (UNIT = LU63, IOSTAT = IOST)
            NC = 0
C * REMOVE CHAR(13)
            NCR = INDEX (PRBUF, CHAR (13))
            IF (NCR /= 0) PRBUF(NCR:NCR) = CHAR (32)
C * CHECK FOR COMMENT #
            NHASH = INDEX (PRBUF, '#')
            IF (NHASH == 0 .OR. NHASH > N + 15) THEN
              IGBL(126) = IGBL(126) + 1
              IF (IABS (IGBL(8)) == 3) THEN
                ILMAX = MIN (IGBL(100), NP54)
                DO I = 1, ILMAX
C * SUBSTITUTE FORWARD SLASH FOR A BACKWARD SLASH
                  CALL GEN151 (PRBUF, N + 5)
                  IF (CENTRY(I)(1:75) == PRBUF(N + 5:N + 79)) THEN
                    NENTRY            = I
                    IENTRY(NENTRY, 4) = M
                  END IF
                END DO
              ELSE IF (IGBL(100) == 1) THEN
                NENTRY       = 1
                IENTRY(1, 4) = M
              END IF
            END IF
          END IF
        END DO
        CLOSE (UNIT = LU63, IOSTAT = IOST)
      END IF
      CALL GEN108 (LU16, 0)
      IGBL(9) = IENTRY(1, 3)
      RETURN
99999 FORMAT (A)
99998 FORMAT (3I4)
      END SUBROUTINE PLA009
 
      SUBROUTINE PLA010 (LU, IRTYPE, IER)
C * Determine Reflection File type
      USE parameters
      USE atomdata
      USE cchar
      IMPLICIT NONE
      INTEGER :: I
      INTEGER :: J
      INTEGER :: LU
      INTEGER :: IER
      INTEGER :: NSQ
      INTEGER :: IOST
      INTEGER :: IRTYPE
C * TRY 'SHELXL', 'CRYSTALS', 'NRCVAX', TEXSAN AND 'MOLEN' FCF VARIETIES
C *
C * IGBL(9)  = -1 : HKL-EXT
C *          =  0 : HKL              (SHELXL HKLF 4 STYLE)
C *          =  1 : SHELXL LIST 4
C *          =  2 : XTAL-F
C *          =  3 : NRCVAX
C *          =  4 : MOLEN
C *          =  5 : CRYSTALS(F)  [CRYSTL1]
C *          =  6 : TEXSAN1
C *          =  7 : MOLEN1
C *          =  8 : CRYSTALS(I)
C *          =  9 : JANA2 (F**2)
C *          = 10 : TEXSAN2
C *          = 11 : XD
C *          = 12 : RAELS
C *          = 13 : TEXSAN3
C *          = 14 : JANA1 (F)
C *          = 15 : CrystalStructure (RIGAKU)
C *          = 16 : JANA3 (F**2)
C *          = 17 : CRYSTALS(I,TWIN)
C *          = 18 : CRYSTALS (I) Incl/excl
C *          = 21 : SHELXL LIST3
C *          = 22 : SHELXL LIST5
C *          = 23 : SHELXL LIST6
C *          = 24 : SHELXL LIST7
C *          = 25 : SHELXL LIST8
C *          = 26 : REALS(F)
C *          = 27 : JANA-TWIN
C *
C * LOOK IN FIRST 100 RECORDS TO DETECT FCF VARIETY
      DO I = 1, 100
        READ (LU, 99999, IOSTAT = IOST) PRBUF
        IF (IOST == 0) THEN
C * SHELXL STYLE FCF
          IF (INDEX (PRBUF, '_shelx_refln_list_code') /= 0) THEN
C * LIST 3
            IF (INDEX (PRBUF, '3') /= 0) THEN
              IRTYPE  = 21
              EXIT
C * LIST 4
            ELSE IF (INDEX (PRBUF, '4') /= 0) THEN
              IRTYPE   =  1
              IGBL(37) = -1
              DO J = 1, 25
                READ (LU, 99999, IOSTAT = IOST) PRBUF
                IF (IOST /= 0) EXIT
C * LIST 4, JANA-TWIN
                IF (INDEX (PRBUF, '_twin_refln_datum_id') /= 0) THEN
                  IRTYPE  = 27
                  EXIT
                END IF
              END DO
              EXIT
C * LIST 5
            ELSE IF (INDEX (PRBUF, '5') /= 0) THEN
              IRTYPE  = 22
              EXIT
C * LIST 6
            ELSE IF (INDEX (PRBUF, '6') /= 0) THEN
              IRTYPE  = 23
              EXIT
C * LIST 8
            ELSE IF (INDEX (PRBUF, '8') /= 0) THEN
              IRTYPE  = 25
              EXIT
            END IF
C * JANA2 (F^2) - SEMI LIST 4
          ELSE IF (INDEX (PRBUF, '_cell_length_a') /= 0) THEN
            IF (IRTYPE /= 5) THEN
              IRTYPE   =  1
              IGBL(37) = -1
            END IF
C * SHELXL - LIST 7
          ELSE IF (INDEX (PRBUF, '_refln_F_squared_calc_comp1')
     1      /= 0) THEN
            IRTYPE  = 24
C * TEST FOR NRCVAX
          ELSE IF (PRBUF(1:11) == '# h,k,l, Fo') THEN
            IRTYPE   = 3
            IGBL(37) = -1
C * TEST FOR MOLEN
          ELSE IF (PRBUF(1:13) == '# h,k,l, 10*F') THEN
            IRTYPE   = 4
            IGBL(37) = -1
C * TEST FOR CRYSTALS(F)
          ELSE IF (INDEX (PRBUF, 'CRYSTALS') /= 0) THEN
            IRTYPE   = 5
            IGBL(37) = -1
C * TEST FOR TEXSAN1 & TEXSAN3
          ELSE IF (PRBUF(1:11) == '# h,k,l, Fc') THEN
            IF (PRBUF(12:19) == '-squared') THEN
              IRTYPE   = 13
              IGBL(37) = -1
C * TEXSAN1
            ELSE
              IRTYPE  = 6
              IGBL(37) = -1
            END IF
C * JANA3
          ELSE IF (INDEX (PRBUF, 'STRUCTURE-FACTOR') /= 0) THEN
            IRTYPE   = 16
            IGBL(37) = -1
            EXIT
C * TEST FOR JANA (F**2)
          ELSE IF (INDEX (PRBUF, '_refln_intensity_meas') /= 0) THEN
            IRTYPE  = 9
            IGBL(37) = -1
C * TEST FOR XD
          ELSE IF (INDEX (PRBUF, '_refln_XD_refine_code') /= 0) THEN
            IRTYPE   = 11
            IGBL(37) = -1
            PAR(498) = 0.3333
C * TEST FOR CRYSTALSTRUCTURE (RIGAKU)
          ELSE IF (INDEX (PRBUF, 'CrystalStructure') /= 0) THEN
            IRTYPE   = 15
            IGBL(37) = -1
C * TEST FOR CRYSTALS(I)
          ELSE IF (INDEX (PRBUF, '_refln_F_squared') /= 0) THEN
            IF (IRTYPE == 5) THEN
               IRTYPE   = 8
               IGBL(37) = -1
            END IF
C * TEST FOR CRYSTALS (I) TWIN
          ELSE IF (INDEX (PRBUF, '_twin_refln_') /= 0) THEN
            IF (IRTYPE == 5 .OR. IRTYPE == 8) THEN
              IRTYPE = 17
              IGBL(37) = -1
            END IF
C * TEST FOR CRYSTALS(I) + INCL/EXCL
          ELSE IF (INDEX (PRBUF, '_refln_refinement_status')
     1      /= 0) THEN
            IF (IRTYPE == 8) THEN
              IRTYPE   = 18
              IGBL(37) = -1
            ELSE IF (IRTYPE == 5) THEN
              IPR(769) = 1
            END IF
          END IF
        END IF
      END DO
C * NEW ATTEMPT
      IF (IRTYPE == 0) THEN
        CALL GEN108 (LU, 0)
        DO
          READ (LU, 99999, IOSTAT = IOST) PRBUF
          IF (IOST /= 0) THEN
            IER = 1
            RETURN
          END IF
          IF (PRBUF(1:5) == '     ') CYCLE
          IF (PRBUF(1:5) == 'data_') CYCLE
C * TRY TEXSAN1, 2  & 3, MOLEN1, XTAL-F & RAELS
          IF (INDEX(PRBUF, 'loop_') /= 0)  THEN
            NSQ = 0
            DO I = 1, 25
              READ (LU, 99999, IOSTAT = IOST) PRBUF
              IF (IOST /= 0) THEN
                IER = 1
                RETURN
              END IF
              IF (INDEX (PRBUF, 'squared') /= 0) NSQ = 1
              IF (PRBUF(23:23) == '.') THEN
C * TEXSAN3
                IF (NSQ == 1) THEN
                  IRTYPE = 13
                  RETURN
C * TEXSAN1
                ELSE
                  IRTYPE = 6
                  RETURN
                END IF
C * TEXSAN2
              ELSE IF (PRBUF(22:22) == '.') THEN
                IRTYPE = 10
                RETURN
              ELSE IF (PRBUF(18:18) == '.') THEN
C * REALS
                IF (PRBUF(34:34) == '.') THEN
                  IRTYPE = 12
                  RETURN
C * MOLEN1
                ELSE
                  IRTYPE = 7
                  RETURN
                END IF
C * TEST FOR JANA1 (3I4,3F10.2)
              ELSE IF (PRBUF(20:20) == '.') THEN
                IRTYPE = 14
                RETURN
              END IF
            END DO
            IRTYPE = 2
          END IF
        END DO
      END IF
      RETURN
99999 FORMAT (A)
      END SUBROUTINE PLA010
 
      SUBROUTINE PLA011 (X, Y, Z)
C * MAIN MENU DATA ENTRY  (NH, NV)
      USE files
      USE parameters
      USE xwdw
      USE cggt
      USE cchar
      USE menus
      IMPLICIT NONE
      INTEGER :: NH
      INTEGER :: NV
      REAL :: X
      REAL :: Y
      REAL :: Z
      REAL :: SIZ
      REAL :: XHORS
      REAL :: YVERT
C * CHECK FOR NEW PLATON SOURCE/EXECUTABLE
      CALL PLA210 (X, Y)
C * MAIN MENU (NH & NV)
      SIZ = HORS / 63.0
C * NO ENTRY LISTING
      IF (IPR(462) == 0) THEN
C * CHECK FOR NO-ATOMS & NO-FACES AND NO-CELL
        IF (IPR(37) /= 0 .OR. IPR(367) /= 0 .OR.
     1    PAR(101) > 1.0) THEN
          NH = INT (7.0 * X / HORS) + 1
          IF (NH < 1 .OR. NH > 7) THEN
            LRET = -1
            RETURN
          ENDIF
          NV = INT ((Y - 5.0) * NP46 / 11.0)
          IF (NV < 0 .OR. NV > NP46) THEN
            NH = 7
            NV = NP46 + 1
          END IF
        ELSE
          NH = 7
          NV = NP46 + 1
        END IF
C * HELP
        IF (NV == NP46 + 1) THEN
          IF ((VERT - Y) < 1.0) THEN
            IF (X < 10.0) THEN
              CALL PLA300 (1, 1, NV)
            ELSE IF (X > 10.0 .AND. X < 20.0) THEN
              CALL PLA300 (1, 2, NV)
            ELSE
              CALL PLA300 (1, 0, NV)
            END IF
          END IF
          LRET = -1
          RETURN
C * RIGHT-BUTTON (#3) MOUSE CLICK
        ELSE IF (NINT (Z) == 3) THEN
          CALL PLA300 (1, NH, NV)
          LRET = -1
          RETURN
        END IF
C * CHECK FOR REFLECTION DATA REQUIRED & PRESENT
        IF (NV > 0 .AND. NV <= NP46) THEN
C * CIF2SHELX
          IF (NV == 15 .AND. NH == 7 .AND.
     1      (IPR(664) /= 0 .OR. IPR(321) /= 0)) THEN
C * HYBRID:
          ELSE IF (NV == 4 .AND. NH == 3 .AND. IGBL(110) > 0
     1       .AND. IPR(663) /= 0 .AND. IPR(664) /= 0 .AND.
     2       IGBL(29) /= 0) THEN
          ELSE
            IF ((IOPT(NH, NV) > 1 .AND. IGBL(15) < 0) .OR.
     1         (IOPT(NH, NV) == 3 .AND. IGBL(15) == 0 .AND.
     2          IGBL(9) == 0)) THEN
              CALL PLA015 (427, 7)
              LRET = -1
              RETURN
            END IF
          END IF
        ELSE
          LRET = -1
          RETURN
        END IF
        YVERT = VERT - NV * 11.0 / NP46 - 5.7
        XHORS = 9 * SIZ * (NH - 1) + 0.1
        CALL PLA439 (0.0,  OPTS(NH, NV), 10, SIZ, 2, 2, XHORS, YVERT)
C * SELECT FROM MAIN MENU
C * NH = 1 - GRAPHICS TOOLS
        SELECT CASE (NH)
          CASE (1)
            SELECT CASE (NV)
C * NV = 1 - PLUTON (VIA PLATON)
              CASE (1)
C * SET MENU #
                IGBL(6)  = 1
C * SET PLOT AS DEFAULT
                IGBL(24) = 1
C * DO NOT ROUND
                IPR(68)  = 0
C * NO R/S DETERMINATION
                IPR(324) = 0
C * NO NONSYM
                IPR(495) = 0
                CALL PLA280 ('PLUTON')
C * NV = 2 - ORTEP
              CASE (2)
                IGBL(3) = 3
                IGBL(6) = 1
C * NO R/S DETERMINATION
                IPR(324) = 0
                CALL PLA280 ('PLOT ADP COLOR')
C * NV = 3 - NEWMAN
              CASE (3)
                CALL PLA280 ('PLOT NEWMAN COLOR')
C * NV = 4 - PLOT-RING
              CASE (4)
                CALL PLA280 ('PLOT RING COLOR')
                IGBL(6) = 13
C * NV = 5 - PLOT PLAN/RING/LSPL/RESD
              CASE (5)
                CALL PLA280 ('PLOT PLAN COLOR')
                IGBL(6) = 13
C * NV = 6
              CASE (6)
                IGBL(6) = 30
                CALL PLA280 ('PLOT POLY')
C * NV = 7
              CASE (7)
                IGBL(6) = 9
                CALL PLA280 ('CONTOUR DI')
C * NV = 8
              CASE (8)
                IGBL(6) = 9
                CALL PLA280 ('CONTOUR FO')
C * NV = 9 - AUTOMOLFIT
              CASE (9)
                CALL PLA280 ('FIT')
C * NV = 10 - HKL2Powder Plot
              CASE (10)
                CALL PLA280 ('POWDER IOBS')
C * NV = 11 - SimPowder Plot
              CASE (11)
                CALL PLA280 ('POWDER')
C * NV = 12 - CALC RDF
              CASE (12)
                CALL PLA280 ('CALC RDF')
C * NV = 13 - PATTERSON
              CASE (13)
                CALL PLA280 ('SETUP PATT')
C * NV = 14 - SHELXT/PLUTON-PLOT RUN
              CASE (14)
                CALL PLA280 ('XTPLOT')
C * NV = 15 - DIEDERICHS PLOT
              CASE (15)
                IF (IGBL(9) >= 0 .AND. IGBL(9) < 28) THEN
C * SET SIDE MENU NUMBER
                  IGBL(6) = 38
                  CALL PLA280 ('DIEDERICHS')
                ELSE
                  LRET = -1
                  RETURN
                END IF
C * NV = 16 -
              CASE (16)
                CALL PLA280 ('WILSON')
C * NV = 17 - To PLUTON
              CASE (17)
                IGBL(3)  = 8
                IGBL(6)  = 2
                IGBL(24) = 1
                IGBL(75) = 0
                CALL PLA280 ('PLUTON NATIVE')
                LRET = 3
            END SELECT
C * NH = 2 - GEOM TOOLS
          CASE (2)
              SELECT CASE (NV)
C * NV = 1
              CASE (1)
                IGBL(70) = 1
                CALL PLA280 ('CALC')
C * NV = 2
              CASE (2)
                CALL PLA280 ('CALC INTRA')
C * NV = 3
              CASE (3)
                CALL PLA280 ('CALC INTER')
C * NV = 4
              CASE (4)
                CALL PLA280 ('CALC COORDN')
C * NV = 5
              CASE (5)
                CALL PLA280 ('CALC METAL')
C * NV = 6
              CASE (6)
                CALL PLA280 ('CALC GEOM')
C * NV = 7
              CASE (7)
                CALL PLA280 ('CALC HBONDS')
C * NV = 8
              CASE (8)
                CALL PLA280 ('CALC TMA')
C * NV = 9 - LSPL
              CASE (9)
                IPR(460) = 1
                CALL PLA280 ('PLOT ADP COLOR')
C * NV = 10 - DIHEDRAL ANGLE
              CASE (10)
                IPR(551) = 1
                CALL PLA280 ('PLOT ADP COLOR')
C * NV = 11 - ANGLE BETWEEN 2 LINES
              CASE (11)
                IPR(341) = 5
                CALL PLA280 ('PLOT ADP COLOR')
C * NV = 12 - ANGLE BETWEEN LSPL AND LINE
              CASE (12)
                IPR(551) = 1
                CALL PLA280 ('PLOT ADP COLOR')
C * NV = 13 - RING CREMER & POPLE
              CASE (13)
                CALL PLA280 ('PLOT RING COLOR')
                IGBL(6) = 13
C * NV = 14 - BondValence
              CASE (14)
                IGBL(121) = 1
                CALL PLA280 ('CALC COORDN NOANG 4.0')
C * NV = 15 - Volcal
              CASE (15)
                IGBL(144) = 1
                CALL PLA280 ('CALC COORDN')
C * NV = 16 - R/S-CIP
              CASE (16)
                CALL PLA280 ('CIP')
C * NV = 17 - MolVolume
              CASE (17)
                CALL PLA280 ('MOLV')
            END SELECT
C * NH = 3
          CASE (3)
            SELECT CASE (NV)
C * NV = 1 - REPORT SOLVENT ACCESSIBLE VOIDS
              CASE (1)
                CALL PLA280 ('CALC SOLV')
C * NV = 2 - MORE DETAILED SOLVENT ACCESSIBLE VOID CALCULATION (+ PACKING INDEX)
              CASE (2)
                CALL PLA280 ('CALC VOID')
C * NV = 3 - RUN SQUEEZE
              CASE (3)
                CALL PLA280 ('CALC SQUEEZE')
C * NV = 4
              CASE (4)
                CALL PLA280 ('HYBRID')
C * NV = 5 - GENERATE FCF-CIF FROM COORDINATE DATA
              CASE (5)
                IF (IGBL(9) == -1) THEN
                  CALL PLA280 ('CALC FCF')
                ELSE
                  LRET = -1
                  RETURN
                END IF
C * NV = 6 - CONTOURED SQUEEZE MAP
              CASE (6)
                IF (IGBL(9) == -1 .OR. IPR(665) /= 0) THEN
                  IGBL(6)  = 9
                  IPR(515) = 0
                  CALL PLA280 ('CONTOUR SQ')
                ELSE
                  LRET = -1
                  RETURN
                END IF
C * NV = 7 - Solve F3D
              CASE (7)
                CALL PLA280 ('CALC SOLV GRID 0.35 F3D')
C * NV = 8
              CASE (8)
                CALL PLA280 ('CALC SOLV PLOT')
C * NV = 9
              CASE (9)
                CALL PLA280 ('CAVITY')
C * NV = 10 - (Solvent) Accessible Surface Area Calculation
              CASE (10)
                CALL PLA280 ('SASA')
C * NV = 11
              CASE (11)
                CALL PLA280 ('FLIP MENU')
C * NV = 12
              CASE (12)
                CALL PLA280 ('FLIP PATT SHOW')
C * NV = 13 - CHARGE FLIPPING FROM ZERO PHASES
              CASE (13)
                CALL PLA280 ('FLIP 1 5000')
C * NV = 14 - CHARGE FLIPPING
              CASE (14)
                CALL PLA280 ('FLIP')
C * NV = 15 - STRUCTURE?
              CASE (15)
                CALL PLA280 ('STRUCTURE')
C * NV = 16 -
              CASE (16)
C * NV = 17 -
              CASE (17)
            END SELECT
C * NH = 4
          CASE (4)
              SELECT CASE (NV)
C * NV = 1 - ADDSYM
              CASE (1)
                IPR(324)  = 0
C * NO EXPAND
                IGBL(136) = 1
                CALL PLA280 ('CALC ADDSYM')
C * NV = 2 - ADDSYM EQUAL
              CASE (2)
C * NO R/S CALC
                IPR(324)  = 0
C * NO EXPAND
                IGBL(136) = 1
                CALL PLA280 ('CALC ADDSYM EQUAL')
C * NV = 3 - ADDSYM EXACT
              CASE (3)
C * NO R/S CALC
                IPR(324)  = 0
C * NO EXPAND
                IGBL(136) = 1
                CALL PLA280 ('CALC ADDSYM EXACT')
C * NV = 4 - ADDSYM PLOT
              CASE (4)
C * NO R/S CALC
                IPR(324) = 0
                CALL PLA280 ('CALC ADDSYM PLOT')
C * NV = 5 - ADDSYM SHELX
              CASE (5)
C * NO R/S CALC
                IPR(324)  = 0
C * NO EXPAND
                IGBL(136) = 1
                CALL PLA280 ('CALC ADDSYM SHELX NOSF')
C * NV = 6 - NEWSYM
              CASE (6)
                CALL PLA280 ('CALC NEWSYM')
C * NV = 7 - NONSYM
              CASE (7)
                CALL PLA280 ('CALC NONSYM')
C * NV = 8 - LEPAGE
              CASE (8)
                CALL PLA280 ('LEPAGE')
C * NV = 9 - DELRED
              CASE (9)
                CALL PLA280 ('DELRED')
C * NV = 10 - MOLSYM
              CASE (10)
                CALL PLA280 ('CALC MOLSYM')
C * NV = 11 - DETERMINE SPGR FROM EXTINCTIONS
              CASE (11)
                CALL PLA280 ('SPGR')
C * NV = 12 - ASYM
              CASE (12)
                CALL PLA280 ('ASYM')
C * NV = 13 - ASYM AVF
              CASE (13)
                CALL PLA280 ('ASYM AVF')
C * NV = 14 - LEPAGE-TWIN
              CASE (14)
                CALL PLA280 ('LEPAGE 0.0 6')
C * NV = 15
              CASE (15)
C * NV = 16
              CASE (16)
C * NV = 17 - TWINROTMAT FROM (CIF+)FCF
              CASE (17)
                CALL PLA280 ('ROTMAT')
            END SELECT
C * NH = 5
          CASE (5)
            SELECT CASE (NV)
C * NV = 1 - MULABS
              CASE (1)
                CALL PLA280 ('MULABS')
                IGBL(6) = 16
C * NV = 2 - ABS-PSI
              CASE (2)
                CALL PLA280 ('ABSP')
C * NV = 3 - ABS-TOMPA
              CASE(3)
                CALL PLA280 ('ABST')
C * NV = 4 - ABS-GAUSS
              CASE (4)
                CALL PLA280 ('ABSG')
C * NV = 5
              CASE (5)
                CALL PLA280 ('ABSX')
C * NV = 6
              CASE (6)
                CALL PLA280 ('ABSS')
C * NV = 7
              CASE (7)
                CALL PLA280 ('SHXABS')
C * NV = 8 - Calculate Anomalous Dispersion f' and f''
              CASE (8)
                BCD = 'ENTER: ''ANOM ElementName Wavelength'' or '//
     1           '''ANOM wavelength'' or ''ANOM ElementName'''//CHAR (0)
                CALL GGIP (-999.0, 2.0, 85.0, 111)
C * NV = 9 - Anom Disp Plot
              CASE (9)
                CALL PLA280 ('ANOM')
C * NV = 10 - Mu-Plot
              CASE (10)
                CALL PLA280 ('MU')
C * NV = 11
              CASE (11)
C * NV = 12
              CASE (12)
C * NV = 13
              CASE (13)
C * NV = 14 - ANGLE BETWEEN CRYSTAL PLANES
              CASE (14)
                BCD = 'ENTER: ANGLE h1 k1 l1 h2 k2 l2'//CHAR (0)
                CALL GGIP (-999.0, 2.0, 80.0, 111)
C * NV = 15 - XTAL HABIT DISPLAY
              CASE (15)
                CALL PLA280 ('XTAL')
C * NV = 16 -
              CASE (16)
C * NV = 17 -
              CASE (17)
            END SELECT
C * NH = 6
          CASE (6)
            SELECT CASE (NV)
C * NV = 1 - CIF/FCF-VALIDATION
              CASE (1)
                IF (IABS (IGBL(8)) /= 3 .OR. IPR(30) /= 0) THEN
                  LRET = -1
                  RETURN
                END IF
C * ALERT DOCUMENTATION ON (TERMINAL WINDOW)
                IGBL(83) = -1
                IGBL(66) = 1
                IGBL(3)  = 1
                LU6      = LU20
                CALL PLA280 ('VALI')
C * NV = 2
              CASE (2)
                CALL PLA280 ('ASYM AVF VIEW')
                IGBL(6) = 14
C * NV = 3 - FCF - VALIDATION
              CASE (3)
C * SET CHECK MODE
                IGBL(36) = 1
C * SET FCF VALID
                IPR(734) = 1
                CALL PLA280 ('ASYM AVF VALID')
C * NV = 4 - CALCULATE/ ANALYSE DIFFERENCE MAP
              CASE (4)
                CALL PLA280 ('CALC DIFF')
C * NV = 5 - ANALYSIS-OF-VARIANCE
              CASE (5)
                IF (IGBL(9) >= 1 .AND. IGBL(9) < 28) THEN
C * SET SIDE MENU NUMBER
                  IGBL(6) = 32
                  CALL PLA280 ('VARIANCE')
                ELSE
                  LRET = -1
                  RETURN
                END IF
C * NV = 6 - BIJVOET-PAIR ANALYSIS
              CASE (6)
                CALL PLA280 ('BIJVOET 1 1 1 1 0.0')
C * NV = 7 - FIND EXPECTED NUMBER OF REFLECTIONS FOR GIVEN THETAMAX
              CASE (7)
                CALL PLA280 ('ASYM EXPECT')
C * NV = 8
              CASE (8)
                CALL PLA280 ('ASYM VALID')
C * NV = 9 - SUPPLEMENTARY MATERIAL
              CASE (9)
                CALL PLA280 ('TABLE SUP')
C * NV = 10 - EXPECT
              CASE (10)
                CALL PLA280 ('EXPT')
C * NV = 11 - CSD-CELL
              CASE (11)
                CALL PLA294 (1)
                CALL PLA280 ('RESTART')
                LRET = -1
                RETURN
C * NV = 12 - CSD-QUEST
              CASE (12)
                CALL PLA280 ('CALC GEOM CSD')
C * NV = 13 - STIDY
              CASE (13)
                CALL PLA280 ('STIDY')
C * NV = 14 - CALC STRAIN
              CASE (14)
                CALL PLA280 ('STRAIN')
C * NV = 15 -
              CASE (15)
C * NV = 15 - CIF-LOCAL
C * NV = 16 -
              CASE (16)
C * NV = 17 -
              CASE (17)
            END SELECT
C * NH = 7 - MISC-TOOLS
          CASE (7)
            SELECT CASE (NV)
C * NV = 1 -SYSTEM-S
              CASE (1)
                IF (.NOT. DOS) THEN
                  CALL PLA280 ('SYST')
                ELSE
                  WRITE (LINE, 99997)
                  CALL PRINTX (LU6, LINE, 1, 0)
                END IF
C * NV = 2 - EXPAND TO P1
              CASE (2)
                CALL PLA280 ('FCF2HKL')
C * NV = 3 - Expand coordinate set to P1
              CASE (3)
                CALL PLA280 ('EXP1')
C * NV = 4
              CASE (4)
                CALL PLA280 ('CALC FCF GENER')
C * NV = 5
              CASE (5)
                CALL PLA280 ('ASYM GENERATE')
C * NV = 6
              CASE (6)
                CALL PLA280 ('HKLTRANS')
C * NV = 7
              CASE (7)
                CALL PLA280 ('EXOR')
C * NV = 8 - SELECTIVE ANIS /RES
              CASE (8)
C * CHECK FOR RES STYLE DATA
                IF (IABS(IGBL(8)) == 2) THEN
                  IGBL(3) = 26
                  CALL PLA280 ('PLUTON')
                END IF
C * NV = 9 - RENAME - RES ONLY
              CASE (9)
                CALL PLA280 ('RENAME')
C * NV = 10 - AUTO-RENUMBER
              CASE (10)
                IGBL(3) = 27
                CALL PLA280 ('CALC GEOM RENUM SHELX NOSF')
C * NV = 11 - CREATE SPF
              CASE (11)
                IPR(675) = 1
                CALL PLA280 ('CALC SPF')
C * NV = 12 - CREATE SHELXL-res
              CASE (12)
                IPR(675) = 1
                CALL PLA280 ('CALC SHELX NOSF')
C * NV = 13 - CREATE CIF-ACC
              CASE (13)
                CALL PLA280 ('TABL ACC')
C * NV = 14 - CREATE PDB-pdb
              CASE (14)
                IPR(675) = 1
                CALL PLA280 ('CALC PDB EXPAND')
C * NV = 15 - HFIX
              CASE (15)
C * CHECK FOR RES STYLE FILE
                IF (IABS (IGBL(8)) == 2) THEN
                  IGBL(3) = 13
                  CALL PLA280 ('PLUTON')
                ELSE
                  CALL PLA015 (427, 30)
                  LRET = -1
                  RETURN
                END IF
C * NV = 16 - CREATE FCF FROM SHELXL201x CIF
              CASE (16)
                CALL PLA280 ('FCF')
C * NV = 17 - CIF2SHELXL
              CASE (17)
                CALL PLA280 ('CIF2SHELXL')
            END SELECT
        END SELECT
        IF (IGGT(1:1) == ' ') THEN
          LRET = -1
          RETURN
        END IF
        LRET = 2
        RETURN
C * ENTRY LIST
      ELSE IF (IPR(462) == 1) THEN
        NH = INT (6 * X / (RGBL(1) * RGBL(2)))
        NV = INT (43 * Y / RGBL(1)) + 1
        WRITE (IGGT, 99999, IOSTAT = IOST)
     1    INT((IGBL(100) - 1) / 258) * 258 + NH * 43 + NV
      END IF
      RETURN
99999 FORMAT (I6.6)
99997 FORMAT ('** Sorry, System S is not available in the ',
     1  'MS-Windows version **')
      END SUBROUTINE PLA011
 
      SUBROUTINE PLA012 (MSBCD, MUPCASE)
C * MENU - WHAT NEXT ?
      USE files
      USE parameters
      USE xwdw
      USE cggt
      IMPLICIT NONE
 
      INTEGER :: IVENT
      INTEGER :: MMODE
      INTEGER :: MSBCD       ! SUGGESTED CONTINUE MESSAGE
      INTEGER :: MUPCASE
      REAL :: X
      REAL :: Y
      REAL :: Z
      REAL :: ZZ
      MMODE = 0
      LRET  = 0
C * TEST FOR MENU = ON
      IF (IGBL(25) == 1) THEN
        IF (MSBCD == -1) THEN
          SBCD = 'Implement new Sublattice ? (y/n[N])'//CHAR (0)
        ELSE IF (MSBCD == -2) THEN
          SBCD = 'Implement CALC ADDSYM EXACT Mode ? (y/n[Y])'//CHAR (0)
C * SPECIAL DEFAULT ANSWERS FOR PLUTON/S-MODE
        ELSE IF (MSBCD == 1) THEN
          SBCD = 'Continue (Y/N[Y])'//CHAR (0)
        ELSE IF (MSBCD == 2) THEN
          SBCD = 'Hit RETURN to Continue'//CHAR (0)
        ELSE IF (MSBCD == 3) THEN
          SBCD = 'Enter # of ENTRY or Continue (Y/N[Y])'//CHAR (0)
        ELSE IF (MSBCD == 4) THEN
          SBCD = '[NEXT]'//CHAR (0)
        ELSE IF (MSBCD == 5) THEN
          SBCD = '[CALC]'//CHAR (0)
        END IF
C * IPR(308) - CR
C * IPR(332) - HFIX   (PLUTON)
C * IPR(335) - RENAME (PLUTON)
C * IPR(351) - DELETE (PLUTON)
C * IPR(352) - ANIS   (PLUTON)
C * IGBL(3)  - Shortcuts 12=RENAME,13=HFIX,26=ANIS
        IF (IPR(308) ==  1 .AND. IPR(332) ==  0 .AND.
     1      IPR(335) ==  0 .AND. IPR(351) ==  0 .AND.
     2      IPR(352) ==  0 .AND. IGBL(3)  /= 12 .AND.
     3      IGBL(3)  /= 13 .AND. IGBL(3)  /= 26) THEN
          SBCD = '[END]'//CHAR (0)
C * SPECIAL FOR PLATON/ADP
        ELSE IF (IPR(308) == 2) THEN
          SBCD = '[EXIT]'//CHAR (0)
        END IF
      END IF
C * CHECK FOR CONTROL-C
      ZZ   = 0.0
      LRET = 3
      IF (CC) THEN
        ZZ    = 1.0
        IVENT = 5
      ELSE
C * 'END' Status
        IF (IPR(460) == 3 .AND. IPR(551) == 3) THEN
          LMOD  = 0
          CALL PLA015 (-1, 0)
        END IF
C * MAIN EVENT LOOP
        DO
          X = 0.0
          Y = 0.0
          Z = 0.0
C * TEST FOR MENU-ON MODE (IGBL(25) = 1) and X11 (IGBL(32) = 1)
          IF (IGBL(25) * IGBL(32) == 1) THEN
C * SHOW MENU
            MMODE = IGBL(6)
            CALL PLA013
C * TEST FOR SPECIAL HYBRID
            IF (IGBL(48) == 0) THEN
C * WAIT FOR AND NEXT GET EVENT
              IVENT = 5
              CALL GGIP (X, Y, Z, IVENT)
            ELSE
C * SIMULATE EVENT (X = HOR OPTION, Y = VERT OPTION)
              X = 1
              Z = 1
C * RENAME
              IF (IGBL(3) == 12) THEN
                Y = 9
C * HFIX
              ELSE IF (IGBL(3) == 13) THEN
                Y = 15
C * ANIS
              ELSE IF (IGBL(3) == 26) THEN
                X = 2
                Y = 15
              END IF
              IVENT    = 2
              IGBL(48) = 0
            END IF
          ELSE
            IVENT = -1
          END IF
          LRET = 1
C * 'IVENT' VALUE ON RETURN FROM GGIP CAN BE:
C * -1 - NO MOUSE/MENU EVENT
C *  0 - EXPOSE
C *  1 - BOX # 1 - CANVAS       - Tool Listing
C *  2 - BOX # 2 - SIDE-MENU    - Options
C *  3 - BOX # 3 - LOWER LEFT   - Messages, (suggested) instructions)
C *  4 - BOX # 4 - LOWER RIGHT  - Exit & Status display
C *  5 - KEYPRESS
 
          IF (IVENT >= 0) THEN
C * SET META FILE OFF IN MENU-ON MODE
            IF (IGBL(81) == 0) THEN
              MEDIUM      = 2
              IGGT(16:22) = 'OFF    '
              CALL GGIP (-999.0, 0.0, 0.0, 6)
            END IF
C * GENERAL EXPOSE EVENT (TYPE # 0)
          IF (IVENT == 0) IVENT = 2
C * HANDLE KEYPRESS EVENT (# 5)
            IF (IVENT == 5) THEN
C * HANDLE CARRIAGE RETURN REFRESH INSTRUCTIONS
   10         IF (IPR(733) == 1) THEN
                CALL PLA280 ('RESTART')
                IPR(733) = 0
              END IF
              IF (BCD(1:1) == CHAR (13)) THEN
                IF (NCNT == 0) THEN
                  IF (IPR(733) == 1) THEN
                    IPR(733) = 0
                    STRING = 'RESTART'
                    NCNT   = 7
                  ELSE IF (IPR(335) /= 0) THEN
                    STRING = 'RENAME'
                    NCNT   = 6
                  ELSE IF (IPR(332) /= 0) THEN
                    STRING = 'HFIX'
                    NCNT   = 4
                  ELSE IF (IPR(352) /= 0) THEN
                    STRING = 'ANIS'
                    NCNT   = 4
                  ELSE IF (IPR(308) == 1) THEN
                    STRING = 'END '
                    NCNT   = 4
                  ELSE IF (IPR(308) == 2) THEN
                    STRING = 'EXIT'
                    NCNT   = 4
                  ELSE IF (IPR(209) > 0) THEN
                    STRING = 'CALC GEOM SPF'
                    NCNT   = 16
C * ADDSYM/CR
                  ELSE IF (IPR(205) == 1) THEN
                    STRING = 'Y'
                    NCNT   = 1
                  ELSE
                    STRING(1:1) = '!'
                    NCNT = 1
                   END IF
                END IF
                IGBL(5) = LU5
                IF (IPR(308) == 2) THEN
                  CALL GEN020 (1, STRING, 1, 4)
                  IF (STRING(1:3) == 'END') THEN
                    STRING(1:4) = 'EXIT'
                    NCNT = 4
                  END IF
                  IF (STRING(1:4) == 'EXIT') LRET = 7
                END IF
                CALL PLA280 (STRING(1:NCNT))
                NCNT     = 0
                IGBL(24) = 1
                IF (STRING(1:1) /= '!') THEN
                  IF (MMODE == 10 .OR. MMODE == 11 .OR.
     1                MMODE == 12) LRET = 2
                ELSE
                  IF (MMODE == 1) LRET = 3
                END IF
 
C * DELETE CHAR
              ELSE IF (BCD(1:1) == CHAR (8) .OR.
     1                 BCD(1:1) == CHAR (127)) THEN
                IF (NCNT > 0) THEN
                  NCNT = NCNT - 1
                  IF (NCNT == 0) THEN
                    BCD = CHAR(0)
                  ELSE
                    BCD = STRING(1:NCNT)//CHAR (0)
                  END IF
                  SBCD = BCD
                END IF
                LRET = -1
C * CNTR-L, CONVERT TO CR
              ELSE IF (BCD(1:1) == CHAR (12)) THEN
                IF (MMODE == 1) THEN
                  CALL PLA280 ('PLOT')
                ELSE
                  IF (MMODE == 3 .OR. MMODE == 22
     1               .OR. MMODE == 15 .OR. MMODE == 17) LRET = 2
                  BCD(1:1) = CHAR (13)
                  GO TO 10
                END IF
              ELSE IF (BCD(1:1) == CHAR (0)) THEN
                LRET = -1
              ELSE
                IF (NCNT < 80) THEN
                  NCNT = NCNT + 1
                  IF (NCNT >= 75)
     1              WRITE (LU6, 99997, IOSTAT = IOST) NCNT, CHAR (7)
                  STRING(NCNT:NCNT) = BCD(1:1)
                  BCD = STRING(1:NCNT)//CHAR (0)
                  SBCD = BCD
                END IF
                LRET = -1
              END IF
C * GENERAL EXIT BUTTON BOX # 4
            ELSE IF (IVENT == 4) THEN
              CALL PLA280 ('EXIT')
              IF (IGBL(3) == 4) IGBL(3) = 0
C * ORTEP/EXIT
              IF (IGBL(45) == 0 .OR. IGBL(3) == 3) THEN
                IF (MMODE == 1 .OR. MMODE == 8 .OR.
     1              MMODE == 9) LRET = 7
              ELSE
C * EXIT FROM 'SAVE'-LOOP
                IGBL(45) = 0
                CALL PLA280 ('REM')
                IGBL(6) = 10
                CALL GEN108 (LU3, 0)
                WRITE (LU3, 99998, IOSTAT = IOST)
                ENDFILE (LU3, IOSTAT = IOST)
              END IF
C * CONTOUR/EXIT
              IF (MMODE == 22) LRET = 1
              IF (MMODE == 10 .OR. MMODE == 11 .OR.
     1            MMODE == 12 .OR. MMODE == 14) LRET = 2
C * CLICK IN AREA THREE (TYPE # 3)
            ELSE IF (IVENT == 3) THEN
              IF (NINT (Z) == 3) CALL PLA300 (3, 0, 0)
              LRET = -1
C * CLICK IN MENU AREA (TYPE # 2)
            ELSE IF (IVENT == 2) THEN
              IF (NINT (Z) == 3) THEN
                CALL PLA300 (2, 1, NINT (Y))
                LRET = -1
              ELSE
                IGBL(5) = LU5
                CALL PLA016 (NINT (Y), NINT (X))
              END IF
C * GRAPHICS CANVAS EVENT (TYPE # 1)
            ELSE IF (IVENT == 1) THEN
              CALL PLA020 (X, Y, Z)
            END IF
C * NO MOUSE/MENU CASE - RETURN
          ELSE IF (IVENT == -1) THEN
            IGBL(25) = 0
            IF (IGBL(3) == 28 .OR. IGBL(3) == 29 .OR.
     1          IGBL(3) == 31) THEN
              CALL PLA280 ('END')
              LRET = 7
              IGBL(31) = 0
            END IF
          END IF
          IF (LRET /= -1 .OR. IGGT(1:1) == CHAR (12)) EXIT
        END DO
      END IF
      SBCD = CHAR (0)
C * ISSUE AN END OF PICTURE
      XGGIP = 0.0
      YGGIP = 0.0
      CALL GGIP (XGGIP, YGGIP, ZZ, -1)
      IF (IGBL(74) == 1)
     1  WRITE (LU6, 99999, IOSTAT = IOST) LRET, IGGT(1:65)
C * UPPERCASE FOR NON-TEXT INPUT
      IF (MUPCASE > 0) CALL GEN020 (1, IGGT, 1, MUPCASE)
      RETURN
99999 FORMAT ('>> LRET =', I2, ', >>', A)
99998 FORMAT (80X, /)
99997 FORMAT ('Position', I3, A)
      END SUBROUTINE PLA012
 
      SUBROUTINE PLA013
C * MENU - SET SUBMENU OPTIONS
      USE parameters
      USE atomdata
      USE menus
      USE cggt
      IMPLICIT NONE
      INTEGER :: I
      INTEGER :: J
      INTEGER :: K
      INTEGER :: L
      INTEGER :: IWL
      INTEGER :: MODE
      INTEGER :: MNS1
      INTEGER :: MNS2
      REAL :: CKLEUR
      REAL, DIMENSION(25) :: COLOR
      REAL, DIMENSION(25) :: XMNS
C * MMODE = 1 - PLATON/ORTEP   MAIN MENU
C * MMODE = 2 - PLUTON         MAIN MENU
C * MMODE = 3 - PLUTON/SUP1    MENU
C * MMODE = 4 - PLUTON/SUP2    MENU
C * MMODE = 5 - PLUTON/SUP3    MENU
C * MMODE = 6 - PLUTON/SUP4    MENU
C * MMODE = 7 - PLUTON/SUP5    MENU
C * MMODE = 8 - PLATON/ORTSUP1 MENU
C * MMODE = 9 - PLATON/ORTSUP2 MENU
C * MMODE = 10- PLATON/MAIN    MENU
C * MMODE = 11- PLATON/SUP1    MENU
C * MMODE = 12- PLATON/SUP2    MENU
C * MMODE = 13- GEOM           MENU
C * MMODE = 14- ASYM           MENU
C * MMODE = 15- HELENA         MENU
C * MMODE = 16- ABSCOR         MENU
C * MMODE = 17- SYSTEM-S       MENU
C * MMODE = 18- S/SUB1         MENU
C * MMODE = 19- S/SHELXL       MENU
C * MMODE = 20- LEPAGE         MENU
C * MMODE = 21- POWDER         MENU
C * MMODE = 22- CONTOUR        MENU
C * MMODE = 23- CONTOUR-SUP    MENU
C * MMODE = 24- SOLV           MENU
C * MMODE = 25- TwRtMt         MENU
C * MMODE = 26- ADDSYM         MENU
C * MMODE = 27- EXOR           MENU
C * MMODE = 28- RDF            MENU
C * MMODE = 29- BIJVOET        MENU
C * MMODE = 30- POLYHEDRON     MENU
C * MMODE = 31- FLIPPER        MENU
C * MMODE = 32- ANAL-OF-VAR    MENU
C * MMODE = 33- ANOM.DISP.     MENU
C * MMODE = 34- FCF-Compare    MENU
C * MMODE = 35- WILSON-PLOT    MENU
C * MMODE = 36- SQUEEZE        MENU
C * MMODE = 37- SPGRfromEX     MENU
C * MMODE = 38- DiedPlot       MENU
C * GET GRAPHICS STATUS INFO
      CALL GGIP (-999.0, YGGIP, ZGGIP, 8)
      MNH(12) = NINT (ZGGIP)
      CALL PLA293 (PAR(17))
      IF (MNH(12) == 1) THEN
        CMEN(24)(1:3)  = 'EPS'
        CMEN(44)(1:3)  = 'EPS'
        CMEN(104)(1:3) = 'EPS'
        CMEN(148)(5:7) = 'EPS'
      ELSE IF (MNH(12) == 2) THEN
        CMEN(24)(1:3)  = 'HGL'
        CMEN(44)(1:3)  = 'HGL'
        CMEN(104)(1:3) = 'HGL'
        CMEN(148)(5:7) = 'HGL'
      END IF
C * GET SUB-MENU
      MODE = IGBL(6)
C * HELENA
      IF (MODE == 15) THEN
        MNH(27) = MAX (1, IPR(424) + 1)
        MNH(28) = MAX (1, IPR(425) + 1)
        MNH(29) = IPR(426) + 1
        MNH(47) = IPR(446) + 1
C * SYSTEM-S
      ELSE IF (MODE == 17) THEN
        MNH(40) = IABS (IGBL(6)) - 16
C * POWDER
      ELSE IF (MODE == 21) THEN
        MNH(45) = 3 - NINT (LOG (PAR(371)) / LOG (10.0))
        IF (PAR(372) >= 1.0) THEN
          MNH(46) = NINT (LOG (PAR(372)) / LOG (2.0)) + 1
        END IF
      ELSE
        MNH(1)  = IPR(140) + 1
        IF (IPR(478) == 0) THEN
          MNH(2) = 1
C * BWC SETTING (ATOMTYPE/RESD/ARU)
        ELSE IF (IPR(478) == -1) THEN
          MNH(2) = 2
        ELSE
          MNH(2) = 3
        END IF
C * COLOR SETTING (ATOMTYPE/RESD/ARU)
        IF (IPR(477) == 0) THEN
          MNH(3) = 1
        ELSE IF (IPR(477) == -1) THEN
          MNH(3) = 2
        ELSE
          MNH(3) = 3
        END IF
        MNH(5)  = NINT (PAR(349) / 0.05) - 4
        MNH(8)  = IPR(139) + 1
        IF (IPR(111) /= 0)
     1    MNH(9) = INT (4 - (LOG (FLOAT (IPR(111))) / LOG (2.0)))
        MNH(10) = NINT (PAR(36) / 0.05) + 1
        MNH(11) = MAX (0, IABS (IGBL(6)) - 1)
        MNH(13) = NINT (PAR(284) / 0.5) + 1
        MNH(14) = NINT ((PAR(350) - 0.20) / 0.05)
        MNH(15) = IPR(232) + 1
        MNH(17) = NINT (PAR(273) / 5.0)
        MNH(18) = NINT (PAR(278) * 10.0)
        IF (IPR(419) == 0) IPR(419) = 10
        MNH(19) = NINT (LOG(IPR(419) / 2.5) / LOG (2.0))
        MNH(20) = NINT (PAR(279) + 1.5)
        MNH(21) = IGBL(63) + 1
        MNH(22) = NINT ((PAR(325) - 1.0) / 0.25) + 1
        MNH(23) = IPR(346) + 1
        MNH(24) = 6 - NINT(PAR(351) * 10.0)
        MNH(25) = INT ((SIN (PAR(166) / RGBL(6)) * 20.0 / PAR(17))
     1    - 0.1)
        MNH(25) = MAX (1, MIN (MNH(25) - 8, 7))
        MNH(26) = MIN (4, IPR(68) + 1)
        MNH(28) = NINT (PAR(86) * 100.0)
        MNH(29) = NINT (PAR(90) * 100.0)
        MNH(30) = NINT (PAR(88) * 100.0)
        MNH(31) = IPR(94) - 1
        MNH(32) = NINT (PAR(441) * 10.0) + 1
        IF (MNH(28) == MNH(29) .AND. MNH(29) == MNH(30)) THEN
          MNH(27) = MNH(28)
        ELSE
          MNH(27) = 0
        END IF
        IF (PAR(44) > 0.0) THEN
          MNH(33) = MIN (NINT (LOG(PAR(44) * 2.0) / LOG (2.0) + 4), 6)
        ELSE
          MNH(33) = 1
        END IF
        MNH(34) = NINT (PAR(48) / 0.125) + 1
        IF (IPR(341) > 1 .AND. IPR(341) < 5) THEN
          MNH(35) = IPR(341) - 1
        ELSE
          MNH(35) = 0
        END IF
        MNH(36) = IPR(311)
        MNH(37) = IPR(33)  + 1
        MNH(38) = IPR(177) + 1
        MNH(39) = IPR(460)
        MNH(40) = IABS(IGBL(6)) - 16
        IF (IPR(389) == 1) THEN
          MNH(41) = 1
        ELSE IF (IPR(389) == -1) THEN
          MNH(41) = 2
        ELSE
          MNH(41) = 0
        END IF
        MNH(42) = NINT (PAR(58) / 0.05) + 1
        IF (PAR(439) > 0.0) THEN
          MNH(43) = NINT (LOG (PAR(439) / 0.125) / LOG (2.0)) + 1
        END IF
        MNH(44) = IPR(117)
        IF (IABS (IGBL(6)) == 1) THEN
          MNH(48) = 1
        ELSE
          MNH(48) = MAX (0, IABS (IGBL(6)) - 6)
        END IF
      END IF
C * SET WAVELENGTH TYPE
      IF (IABS(IPR(493)) < 7) THEN
        IWL = IABS (IPR(493))
        IF (IWL == 2) THEN
          MNH(49) = 1
        ELSE IF (IWL == 3) THEN
          MNH(49) = 2
        ELSE IF (IWL == 5) THEN
          MNH(49) = 3
        ELSE
          MNH(49) = 4
        END IF
      END IF
      MNH(50) = IPR(500)
      MNH(51) = IPR(461) + 1
      MNH(52) = IPR(41)  + 1
      MNH(53) = IPR(87) + 1
      MNH(54) = IGBL(62)
      IF (IPR(182) == 0) THEN
        MNH(55) = IPR(515) + 1
      ELSE
        MNH(55) = IPR(505)
      END IF
      MNH(56) = IPR(507)
      IF (IPR(132) >= 0) MNH(57) = IPR(132) + 1
      MNH(58) = NINT (PAR(85))
      MNH(59) = NINT (PAR(89))
      MNH(60) = MIN (NINT (PAR(48) / 10.0) + 1, 7)
      IF (IPR(493) /= 8) THEN
        MNH(61) = NINT (PAR(411) * 100.0)
      ELSE
        MNH(61) = NINT (PAR(411) / 0.000375)
      END IF
      MNH(62) = (IPR(514) + 1) / 2
      MNH(63) = MIN (NINT (PAR(412) * 6.0), 5)
      MNH(64) = MIN (4, MAX (1, NINT (PAR(2) / 0.2) + 1))
      MNH(65) = MIN (4, MAX (1, NINT (PAR(27) / 0.2) + 3))
      MNH(66) = IGBL(88) + 1
      MNH(67) = IPR(531) + 1
      MNH(68) = IPR(533)
      MNH(69) = IPR(534)
C * DelCrit
      MNH(70) = MIN (5, 1 + MAX (0, NINT (RGBL(25) / 0.25)))
C * COORD Rad Default
      MNH(71) = MIN (4, MAX (1, NINT (PAR(7)) - 2))
      MNH(72) = MAX (1, IPR(536))
C * PLUTON/ZOOM
      MNH(73) = MIN (8, MAX (1, NINT ((PAR(13) - 0.4) * 2.0)))
C * DIHEDRAL ANGLE CLICK STATUS
      MNH(75) = IPR(551)
C * LEPAGE ROUND
      IF (PAR(440) /= 0.0) THEN
        MNH(74) = NINT (LOG (PAR(440)) / LOG (10.0))
      END IF
      MNH(76) = IGBL(101) + 1
      MNH(77) = NINT (PAR(407) / 10.0) + 1
      MNH(78) = NINT (PAR(43) / 0.2)
      MNH(79) = NINT ((PAR(401) + 0.05) / 0.1)
      MNH(80) = NINT ((PAR(402) + 0.05) / 0.1)
      MNH(81) = NINT ((PAR(403) + 0.05) / 0.1)
      IF (MODE == 25) THEN
        MNH(82) = NINT (LOG (PAR(413)) / LOG (2.0) - 0.01) + 1
        MNH(83) = NINT (PAR(414) / 0.05)
        MNH(84) = NINT (FLOAT (IPR(550)) / 25)
        MNH(85) = NINT (PAR(415) / 0.1)
        MNH(94) = IPR(567) / 5
      END IF
C * PLATON (SUP) MENU'S
      MNH(86) = MAX (0, IGBL(6) - 9)
C * Q-PEAK-H
      MNH(87) = MIN (4, MAX (1, NINT (RGBL(26) / 0.20)))
C * DelCrit
      MNH(88) = MIN (5, 1 + MAX (0, NINT (RGBL(27) / 0.25)))
C * ADDSYM/ELEMENT
      MNH(89) = IPR(206) + 1
C * HFIX BOX (SUB-MENU 3)
      IF (IPR(332) == 1) THEN
        MNH(90) = 1
C * ANIS BOX (SUB-MENU 3)
      ELSE IF (IPR(352) == 1) THEN
        MNH(90) = 2
C * (SUB-MENU 3)
      ELSE
        MNH(90) = 0
      END IF
      IF (MODE == 7) THEN
        IF (ABS(PAR(18)) > 1.0) THEN
          MNH(91) = 2
        ELSE
          MNH(91) = 1
        END IF
      END IF
      MNH(92) = NINT (PAR(449) / 0.1)
      MNH(93) = NINT (PAR(420) / 0.05)
      MNH(95) = MIN (5, NINT (PAR(262) / 2.5))
      MNH(96) = MIN (6, NINT (PAR(451) / 2.5))
      MNH(97) = MIN (6, (IPR(577) + 1) / 2)
      MNH(98) = MIN (6, (IPR(578) + 1) / 2)
      MNH(99) = IGBL(123) + 1
      IF (PAR(453) <= 0.54) THEN
        MNH(100) = 1
      ELSE IF (PAR(453) <= 0.60) THEN
        MNH(100) = 2
      ELSE IF (PAR(453) <= 0.65) THEN
        MNH(100) = 3
      ELSE
        MNH(100) = 4
      END IF
      MNH(101) = IPR(394)
      MNH(102) = IGBL(124) + 1
      MNH(103) = IPR(354)  + 1
      IF (MODE == 29) THEN
        IF (PAR(452) < 0.01) THEN
          MNH(100) = 1
        ELSE
          MNH(100) = NINT (LOG (PAR(452) / 0.25) / LOG (2.0)) + 2
        END IF
        MNH(104) = MAX (MIN (IPR(611) + 1, 10), 1)
        MNH(105) = MAX (MIN (NINT (PAR(487)) / 5, 10), 1)
      END IF
C * hkl2powder (OBS/CAL)
      MNH(106) = IPR(511)
C * SOLV MENU BARS
      MENS(12, 24) = INT (MENS(12, 24) / 100) * 100 + IPR(530) + 1
C * ORTEP-RESD MODES
      IF (MODE == 1 .OR. MODE == 8 .OR. MODE == 9) THEN
C * CALCULATE # RESD BARS
        MENS(17, MODE) = INT (MENS(17, MODE) / 100) * 100 + IPR(75) + 1
        MNH(4)      = IPR(45)
C * PLUTON-RESD MODES
      ELSE IF (MODE == 2 .OR. MODE == 3 .OR. MODE == 5 .OR.
     1         MODE == 6) THEN
C * CALCULATE # RESD BARS
        MENS(14, MODE) = INT (MENS(14, MODE) / 100) * 100 + IPR(75) + 1
C * SOLV/RESD  MODES
      ELSE IF (MODE == 24) THEN
C * CALCULATE # RESD BARS
        MENS(10, MODE) = INT (MENS(10, MODE) / 100) * 100 + IPR(75) + 1
C * ADDSYM-MODE
      ELSE IF (MODE == 26) THEN
        MENS(21, MODE) = INT (MENS(21, MODE) / 100) * 100 + IAN + 1
      ELSE IF (MODE == 10) THEN
        IF (IPR(44) == 0) IGBL(59) = 1
      END IF
C * TEST FOR MONO
      IF (IPR(116) == 0) THEN
        MENS(2, 2) = 4
        MENS(2, 1) = 2
C * STEREO
      ELSE
        MENS(2, 2) = 1
        MENS(2, 1) = 1
      END IF
      IF (MODE == 0) THEN
        BCD(1:12) = '           '//CHAR (0)
      ELSE
        BCD(1:12) = MENX(IABS (MODE))//CHAR (0)
      END IF
      CKLEUR = 5.0 + IGBL(68)
      CALL GGIP (-999.0, CKLEUR, 1.0, 10)
C * SHOW MENU
      CALL GEN074 (COLOR, 1, 25, 0.0)
      CALL GEN074 (XMNS,  1, 25, 0.0)
      DO I = 1, 25
        MENUSUB(I) = ' '
      END DO
C * CHECK FOR NO-ATOMS & NO-FACES AND NO-CELL
      IF (IPR(37) /= 0 .OR. IPR(367) /= 0 .OR.
     1    PAR(101) > 1.0 .OR. MODE == 15 .OR.
     2    MODE == 17 .OR. MODE == 18 .OR. MODE == 19 .OR.
     3    (MODE >= 32 .AND. MODE <= 35)) THEN
        DO I = 1, 25
          IF (MODE /= 0) THEN
            J = MENA(I, IABS (MODE))
C * DEPEND ON IPR VALUE
            IF (J > 0) THEN
              L = J / 1000
              J = MOD (J, 1000)
              K = I
              IF (L > 0) THEN
                IF (IABS (IPR(J)) == L) K = K + 25
              ELSE
                IF (IPR(J) /= 0) K = K + 25
              END IF
C * DEPEND ON IGBL VALUE
            ELSE IF (J < 0) THEN
              K = MAX (MIN (IABS (IGBL(IABS (J))), 1), 0) * 25 + I
            ELSE
              K = I
            END IF
            MENUSUB(I) = CMEN(MOD (MENU(K, IABS (MODE)), 500))
            IF (MENU(K, IABS (MODE)) > 500) THEN
              COLOR(I) = 2.0
            ELSE
              COLOR(I) = 1.0
            END IF
C * BLUE SUB-MENU OPTION ENTRIES
            IF (MODE == 25) THEN
              IF (IPR(771) < 4) THEN
                DO L = IPR(771) + 1, 4
                  COLOR(L +  6) = 4.0
                  COLOR(L + 17) = 4.0
                END DO
              END IF
            END IF
            MNS1 = MENS(I, IABS (MODE)) / 100
            MNS2 = MOD (MENS(I, IABS (MODE)), 100)
            IF (MNS1 > 0) THEN
              XMNS(I) = MNH(MNS1) * 100 + MNS2
            ELSE
              XMNS(I) = MNS2
            END IF
C * SPECIAL BLANKING OF SUB-MENU OPTIONS
            IF (IABS(MODE) == 16) THEN
              IF (IPR(78) /= -2) THEN
                IF (I < 5) THEN
                  MENUSUB(I) = ' '
                END IF
              END IF
            ELSE IF (IPR(772) == 1) THEN
              MENUSUB(I) = ' '
            END IF
          END IF
        END DO
      END IF
      DO I = 1, 25
        BCD(1:12) = MENUSUB(I)//CHAR (0)
C * SHOW SUBMENU
        CALL GGIP (-999.0, COLOR(I), XMNS(I), 10 + I)
      END DO
      IF (IPR(182) == 0) THEN
        BCD = SBCD
      ELSE
        BCD = 'Click on Unique Atoms to be Omitted'//CHAR (0)
      END IF
      CALL GGIP (-999.0, 5.0 + FLOAT (IGBL(68) * IGBL(82)), 70.0, 110)
      RETURN
      END SUBROUTINE PLA013
 
      MODULE tpos
      SAVE
      INTEGER :: KMX
      INTEGER :: IMIN
      INTEGER, DIMENSION(25) :: NTK
      REAL, DIMENSION(250, 3) :: XTK
      END MODULE tpos
 
      SUBROUTINE PLA014 (MODE, NTYP, X, Y, ITEM, IASU)
C * MENU - GET NEAREST ITEM TO CLICK POSITION
      USE parameters
      USE tpos
      IMPLICIT NONE
      INTEGER, PARAMETER :: NP0  = 6
      INTEGER :: I
      INTEGER :: IB
      INTEGER :: IBEG
      INTEGER :: IEND
      INTEGER :: MODE
      INTEGER :: NTYP
      INTEGER :: ITEM
      INTEGER :: IASU
      REAL :: X
      REAL :: Y
      REAL :: Y1
      REAL :: X1
      REAL :: DIST
      REAL :: DELMIN
      IBEG = 0
      IEND = 0
C * NTYP = 1 : PLUTON
C * NTYP = 2 : PLATON
      IF (NTYP == 1) THEN
        X1 =   X + PAR(61)
        Y1 = - Y - PAR(62)
      ELSE
        X1 = X
        Y1 = PAR(38) - Y
      END IF
C * GET NEAREST ITEM
      ITEM   = 0
      DELMIN = 1000.0
      IMIN   = 0
      IASU   = 0
      IF (IABS (MODE) <= 2) THEN
        IB = IPR(158)
C * ATOMS
        IF (MODE > 0) THEN
          IB = IB + IPR(69) * NP0
          IBEG = IPR(69) + 1
          IF (IPR(341) == 2) THEN
            IEND = IPR(62)
          ELSE
            IEND = IPR(37)
          END IF
C * LABELS
        ELSE IF (MODE == -1) THEN
          IB   = IB + IPR(62) * NP0
          IBEG = IPR(62) + 1
          IEND = IPR(62) + IPR(37)
C * ARU
        ELSE IF (MODE == -2) THEN
          IB   = IB + (IPR(62) + IPR(37)) * NP0
          IBEG = IPR(62) + IPR(37) + 1
          IEND = IPR(62) + IPR(37) + IPR(42)
        END IF
C * GET NEAREST ITEM
        CALL PLUT43 (IB, IBEG, IEND, X1, Y1, DELMIN, IASU, IMIN)
C * PLATON TEXT-ITEM
      ELSE IF (MODE == 3) THEN
        DO I = 1, IPR(447)
          DIST = SQRT ((XTK(I, 1) - X1)**2 +
     1        (XTK(I, 2) - Y1)**2)
          IF (DIST < DELMIN) THEN
            DELMIN = DIST
            IMIN = I
          END IF
        END DO
      END IF
C * MARK SELECTED ATOM
      IF (DELMIN < PAR(24) / 4) THEN
        ITEM = IMIN
        IF (MODE == 1) THEN
          IB = IPR(158) + (IMIN - 1) * NP0
C * PUT DIAMOND
          CALL PLUT31 (IB, 2.0)
          IF (IASU /= 0) THEN
            ITEM = IASU / 1000
            IASU = MOD (IASU, 1000)
          END IF
        END IF
      END IF
      RETURN
      END SUBROUTINE PLA014
 
      SUBROUTINE PLA015 (NR, IVAL)
C * NOTIFICATION MESSAGES
      USE parameters
      USE atomdata
      USE cggt
      USE chdat
      IMPLICIT NONE
      INTEGER :: NR
      INTEGER :: IVAL
      INTEGER :: IDUM
      INTEGER :: MODE
      INTEGER :: IPRNR
      T111 = ' '
C * CHECK FOR -F MODE
      IF (IGBL(50) == 2) RETURN
      MODE = IABS (IGBL(6))
      IF (IPR(427) /= 0) THEN
        IF (IGBL(6) > 0) THEN
          CALL GEN038 (T111, 1, 79)
          BCD = T111//CHAR (0)
          CALL GGIP (-999.0, 0.0, 80.0, 111)
        END IF
        IPR(427) = 0
      END IF
C * HANDLE STATUS TEXT ON INPUT/OUTPUT WINDOW
      IF (NR == 0) THEN
C * ONE LINE NOTIFICATION MESSAGES
        SELECT CASE (IVAL)
          CASE (1)
            T111 = 'No Classic Hydrogen Bonds Found'
          CASE (2)
            T111 =
     1        'Classic Hydrogen Bonds Found (See Listing for Details)'
           CASE (3)
            T111 = 'No Solvent Accessible Void Found'
          CASE (4)
            T111 =
     1      'Solvent Accessible Void Found (See Listing for Details)'
          CASE (5)
            T111 = 'No Obvious Additional Symmetry'
          CASE (6)
            T111 =
     1     'Additional (Pseudo)Symmetry Found (See Listing for details)'
          CASE (7)
            T111 = 'No Proper Reflection Data Available !'
          CASE (8)
            T111 = 'Label Conflict, No Substitution !'
          CASE (9)
            T111 = 'Requested Program not Accessible !'
          CASE (10)
            T111 = 'Instruction Ignored'
          CASE (11)
            T111 = 'DIRDIF PATTY for HEAVY ATOM STRUCTURES ONLY !'
          CASE (12)
            T111 = 'No Model-data found for DIRDIF/ORIENT-run'
          CASE (13)
            T111 =
     1      'Problem in DIRDIF (See tm/sg/dirdif08/lis1 for details)'
          CASE (14)
            T111 = 'DIRDIF not Available (or accessible) !'
          CASE (15)
            T111 = '                                      '
          CASE (16)
            T111 = 'SIR nor Available (or accessible) !'
          CASE (17)
            T111 = 'SHELXS   not Available (or accessible) !'
          CASE (18)
            T111 = 'No (more) NEWMAN, RING or PLANE data (Rewind)? '
          CASE (19)
            T111 = 'No Crystal Description Available !'
          CASE (20)
            T111 = 'No Cell data yet !'
          CASE (21)
            T111 = 'Automatic Invert to enantiomeric space group'
          CASE (22)
            T111 = 'Spacegroup not acceptable, try again'
          CASE (23)
            T111 = 'SPGR # Out of Range [0:NP42], try again'
          CASE (24)
            T111 = 'TRMX nor acceptable, try again'
          CASE (25)
            T111 =
     1      'SPGR-Routine cannot identify appropriate space group'
          CASE (26)
            T111 = 'Formula Requires more Element-number pairs - retry'
          CASE (27)
            T111 = 'No Quest for Network structures'
          CASE (28)
            T111 = 'Unsuitable Instruction. Ignored'
          CASE (29)
            T111 = 'SHELXL not Available (or accessible) !'
          CASE (30)
            T111 = 'HFIX-Instruction Valid for RES-files ONLY'
          CASE (31)
            T111 = 'AutoMolFit not possible for this residue pair'
          CASE (32)
            T111 =
     1      'Unresolved problem in SIR97 (see tm/sg/sir for details)'
          CASE (33)
            T111 = 'Missing Element(s) in Formula (Enter New Formula)'
          CASE (34)
            T111 = 'No Coordinate Data found in Current Input File'
          CASE (35)
            T111 = 'No Direction Cosines found'
          CASE (36)
            T111 = 'An Editor will be invoked prior to the SHELX launch'
          CASE (37)
            T111 = 'Twin[Matrix NOT Acceptable (Determinant = 0)'
          CASE (38)
            T111 = 'SHELXL-Problem, No Suitable Res-file '
          CASE (39)
            T111 = 'Result of Calculation on .lis & .lps Files'
          CASE (40)
            T111 = 'RENAME-function valid for RES-files Only !!'
          CASE (41)
            T111 = '                        '
          CASE (42)
            T111 = 'Incorrect Plane Definition. Try Again.'
          CASE (43)
            T111 =
     1      'No TLS-Analysis for Polymeric or Disordered Structures'
          CASE (44)
            T111 = 'ANIS-Instruction Valid for RES-files ONLY'
          CASE (45)
            T111 = 'Click on ARU-Code to ADD ARU to ORTEP PLOT'
          CASE (46)
            T111 = 'No Mu-value given !!'
          CASE (47)
            T111 = 'Validation requires NOMOVE mode !!'
          CASE (48)
            T111 = 'Problem/Error in JOIN Instruction !!'
          CASE (49)
            T111 = 'Error - Not Enough Data Items on Input Line !!'
          CASE (50)
            T111 = 'Error: Requested Data Entry not Found. Try Again.'
          CASE (51)
            T111 =
     1      'No Matching Reflection Data Set Found on Reflection FCF'
          CASE (52)
            T111 = 'No CAVITY''S Found in this Structure'
          CASE (53)
            T111 = 'Label Conflict, Special Substitution !'
          CASE (54)
            T111 = 'SIR2004 nor Available (or accessible) !'
          CASE (55)
            T111 = 'SHELXD nor Available (or accessible) !'
          CASE (56)
            T111 = 'Insufficient Space for Coordinate Expansion'
          CASE (57)
            T111 = 'Requested SIR version not found !'
          CASE (58)
            T111 = 'No Bijvoet Pairs found !'
          CASE (59)
            T111 = 'SHELXT not Available (or accessible) !'
          CASE (60)
            T111 = 'SIR2011 not Available (or accessible) !'
        END SELECT
      ELSE IF (NR > 0) THEN
C * EVICT GEOM-LIST
        IF (IPR(341) == 1) CALL PLUT24 (-3, IDUM, IDUM)
        IPRNR    = IPR(NR)
        IPR(329) = 0
        IPR(332) = 0
        IPR(334) = 0
        IPR(338) = 0
        IPR(341) = 0
        IPR(343) = 0
        IPR(344) = 0
        IPR(348) = 0
        IPR(352) = 0
        IPR(448) = 0
        IPR(440) = 0
        IF (IPRNR == 0 .OR. IPRNR /= IVAL) THEN
          IPR(NR) = IVAL
        ELSE
          IPR(NR) = 0
        END IF
C * WARNING TEXTS
        IF (IPR(311) == 1) THEN
          T111 = 'Click on 2 ATOMS to JOIN'
        ELSE IF (IPR(311) == 2) THEN
          T111 = 'Click on 2 ATOMS to JOIN DASH'
        ELSE IF (IPR(311) == 3) THEN
          T111 = 'Click on 2 ATOMS to DETACH '
        ELSE IF (IPR(312) == 1) THEN
          T111 = 'Click on at least 5 Atom Pairs to FIT'
        ELSE IF (IPR(348) == 1) THEN
          T111 = 'Click on Atom to SELECT Pattern'
        ELSE IF (IPR(327) == 1) THEN
          IF (MODE == 1) THEN
            T111 = 'Click on LABEL [Lower Left Corner] to be DELETED'
          END IF
        ELSE IF (IPR(328) == 1) THEN
          IF (MODE == 1) THEN
            T111 = 'Click on (RED) LABEL to INCLUDE LABEL again'
          END IF
        ELSE IF (IPR(349) == 1) THEN
          IF (MODE == 1) THEN
            T111 = 'Click on LABEL [Lower Left Corner] to REPOSITION'
          ELSE
            T111 = 'Click on LABEL [Center] to REPOSITION'
          END IF
        ELSE IF (IPR(335) == 1) THEN
          T111 = 'Click on ATOM to be RENAMED (or RETURN for ATOM loop)'
        ELSE IF (IPR(351) == 1) THEN
          T111 = 'Click on ATOM to be DELETED [or enter instruction]'
        ELSE IF (IPR(448) == 1) THEN
          T111 = 'Click on TEXT [Lower Left Corner] to REPOSITION'
        ELSE IF (IPR(344) == 1) THEN
          T111 = 'Click on Text [Lower Left Corner] to be DELETED'
        ELSE IF (IPR(343) == 1) THEN
          T111 = 'Click on ATOM as ZOOM CENTRE'
        ELSE IF (IPR(341) == 1) THEN
          T111 = 'Click on Atom for GEOM Calculation'
        ELSE IF (IPR(341) == 2) THEN
          T111 = 'Click on 2 ATOMS for DISTANCE'
        ELSE IF (IPR(341) == 3) THEN
          T111 = 'Click on 3 ATOMS for ANGLE'
        ELSE IF (IPR(341) == 4) THEN
          T111 = 'Click on 4 ATOMS for TORSION ANGLE'
        ELSE IF (IPR(341) == 5) THEN
          T111 = 'Click on 2 ATOMS for LINE 1 and 2 ATOMS FOR LINE 2'
        ELSE IF (IPR(329) == 1) THEN
          T111 = 'Click on 2 ATOMS for VIEW LINE'
        ELSE IF (IPR(329) == 2) THEN
          T111 = 'Click on 3 ATOMS for VIEW PERP'
        ELSE IF (IPR(329) == 3) THEN
          T111 = 'Click on 3 ATOMS for VIEW BISECT'
        ELSE IF (IPR(476) /= 0) THEN
          T111 = 'Click on Atoms Defining Plane (or Dist/End)'
        ELSE IF (IPR(552) /= 0) THEN
          T111 = 'Click on Atoms Defining Planes (or With/End)'
        ELSE IF (IPR(508) == 1) THEN
          T111 = 'Click on FROM Atom Followed by TO Atoms and END'
        ELSE IF (IPR(508) == 2) THEN
          T111 = 'Click on Atoms Defining Cg Terminated with END'
        ELSE IF (IPR(338) == 1) THEN
          T111 = 'Click on ATOM to Select Color'
        ELSE IF (IPR(334) == 1) THEN
          WRITE (T111, 99999)
     1         'Click on TEXT [Lower Left Corner] to Change Size',
     2          PAR(350)
        ELSE IF (IPR(352) == 1) THEN
          T111 = 'Click on ATOM for ANIS [or EXIT] '
        ELSE IF (IPR(332) == 1) THEN
          T111 =
     1    'Click on ATOM for HFIX (or RETURN for loop over ATOMs)'
        ELSE IF (IPR(440) == 1) THEN
          T111 = 'Click on ATOM for ''CALC COORDINATION atom'''
        ELSE IF (IPR(213) == 1) THEN
          T111 = 'Click on ARU-Label for ARU to be Excluded'
        ELSE IF (IPR(536) > 0) THEN
          T111 = 'Click on ATOM to change Atom-Type-Color to '//
     1          COLR(IPR(536))
        END IF
        IF (IGBL(45) /= 0 .AND. IGBL(3) /= 1) THEN
          IF (IPR(20) == 0) THEN
            IF (IGBL(3) == 3) THEN
              BCD = 'Click EXIT to Terminate ORTEP/ADP'//CHAR (0)
            ELSE
              BCD =
     1'SAVE-mode Loop (Click on PREV, NEXT or EXIT to escape)'//CHAR (0)
            END IF
          ELSE
            BCD = 'Click on END to return to System-S'//CHAR (0)
          END IF
          CALL GGIP (-999.0, 3.0, 80.0, 112)
        END IF
 
      END IF
C * NOT FOR -u OR -U  Modes
      IF (IGBL(3) /= 1) THEN
        BCD = T112//CHAR (0)
        CALL GGIP (-999.0, 2.0, 80.0, 112)
        IF (IGBL(6) > 0) THEN
          BCD = T111//CHAR (0)
          CALL GGIP (-999.0, 2.0, 80.0, 111)
        END IF
      END IF
      IF (NR /= 0) IPR(427) = 1
      IGBL(6) = IABS (IGBL(6))
      RETURN
99999 FORMAT (A, '[', F4.2, ']')
      END SUBROUTINE PLA015
 
      SUBROUTINE PLA016 (MENUV, MENUH)
C * SIDE MENU OPTIONS
      USE files
      USE parameters
      USE atomdata
      USE cchar
      USE xwdw
      USE cggt
      USE menus
      IMPLICIT NONE
      INTEGER :: I
      INTEGER :: J
      INTEGER :: M
      INTEGER :: IANG
      INTEGER :: NEXIT
      INTEGER :: MENUV
      INTEGER :: MENUH
      INTEGER :: MMODE
      INTEGER :: NASUP
      REAL :: DX
      REAL :: WL
      REAL :: VAL
      REAL :: ZROT
      REAL :: ANGC
      REAL :: DELTA
      REAL :: PAR351
      CHARACTER(len=5) :: BWC
      CHARACTER(len=5) :: COLOR
C * MMODE = 1 - PLATON/ORTEP   MAIN MENU
C * MMODE = 2 - PLUTON         MAIN MENU
C * MMODE = 3 - PLUTON/SUB1    MENU
C * MMODE = 4 - PLUTON/SUB2    MENU
C * MMODE = 5 - PLUTON/SUB3    MENU
C * MMODE = 6 - PLUTON/SUB4    MENU
C * MMODE = 7 - PLUTON/SUB5    MENU
C * MMODE = 8 - PLATON/ORTSUB1 MENU
C * MMODE = 9 - PLATON/ORTSUB2 MENU
C * MMODE = 10- PLATON/OPENING MENU
C * MMODE = 11- PLATON/SUP     MENU
C * MMODE = 12- GEOM           MENU
C * MMODE = 13- POLYEDRA       MENU
C * MMODE = 14- ASYM           MENU
C * MMODE = 15- HELENA         MENU
C * MMODE = 16- ABSCOR         MENU
C * MMODE = 17- SYSTEM-S       MENU
C * MMODE = 18- S/SUB1         MENU
C * MMODE = 19- S/SHELXL       MENU
C * MMODE = 20- LEPAGE         MENU
C * MMODE = 21- POWDER         MENU
C * MMODE = 22- CONTOUR        MENU
C * MMODE = 23- CONTOUR-SUP    MENU
C * MMODE = 24- SOLV           MENU
C * MMODE = 25- TwinRotMat     MENU
C * MMODE = 26- ADDSYM         MENU
C * MMODE = 27- EXOR           MENU
C * MMODE = 28- RDF            MENU
C * MMODE = 29- BIJVOET        MENU
C * MMODE = 30- POLYHEDRON     MENU
C * MMODE = 31- FLIPPER        MENU
C * MMODE = 32- Anal_of_Var    MENU
C * MMODE = 33- Anomalous Disp MENU
C * MMODE = 34- FCF-Compare    MENU
C * MMODE = 35- WILSON-PLOT    MENU
C * MMODE = 36- SQUEEZE        MENU
C * MMODE = 37- SPGRfromEX     MENU
C * MMODE = 38- DiedPlot       MENU
C * LRET = -1 - GET NEW INSTRUCTION
C * LRET =  1 - DEFAULT RETURN
C * LRET =  2
C * LRET =  3
C * LRET =  4
C * LRET =  5
C * LRET =  6 - Recalculate Label Position
C * LRET =  7
      DX    = 0.0
      NEXIT = 0
C * DEFAULT RETURN FROM SIDE NENU OPTIONS
      LRET = 1
C * SET PLOT AS DEFAULT
      IGBL(24) = 1
C * (0/1) AUTOPLOT
      IF (IGBL(35) == 1) THEN
        IF (IPR(504) == 0) CALL PLA280 ('PLOT')
      ELSE
        CALL GEN038 (IGGT, 1, 80)
      END IF
      IF (IPR(346) > 0) THEN
        COLOR = 'COLOR'
      ELSE
        COLOR = ' '
      END IF
      IF (IPR(345) > 0) THEN
        BWC   = 'BWC'
      ELSE
        BWC   = ' '
      END IF
      MMODE = IGBL(6)
      IF (MMODE == 1 .OR. MMODE == 9 .OR. MMODE == 16) THEN
        PAR(389) = 0.0
        IPR(478) = 0
        ANGC     = 2.0 ** (MENUH - 5)
      END IF
      IF (MMODE == 2 .OR. MMODE == 3) THEN
        ANGC = 2.0 ** (MENUH - 5)
        DX   = (MENUH - 1) * 0.25
      END IF
C * LOOP OVER MENU BOXES
      SELECT CASE (MENUV)
C * MENU BOX # 0 & EXPOSE EVENT
        CASE (0)
C * PLATON / ORTEP
        IF (MMODE == 1 .OR. MMODE == 8 .OR. MMODE == 9) THEN
          IPR(201) = 1
          LRET     = 3
C * REFRESH MAIN-MENU
        ELSE IF (MMODE == 10) THEN
          LRET = 1
C * REFRESH NEWMAN
        ELSE IF (MMODE == 12) THEN
          CALL PLA280 ('REF')
C * REFRESH CONTOUR PLOT
        ELSE IF (MMODE == 22) THEN
          LRET = 2
        END IF
C * MENU BOX # 1
        CASE (1)
C * LOOP OVER MENUS
          SELECT CASE (MMODE)
C * ORTEP OPTIONS
            CASE (1)
              IF (MENUH == 1) THEN
                IGBL(6) = 1
              ELSE
                IGBL(6) = MENUH + 6
              END IF
              LRET = -1
C * PLUTON OPTIONS
            CASE (2)
              IGBL(6) = MENUH + 1
              LRET    = -1
C * PLUTON/SUP
            CASE (3)
              IGBL(6) = MENUH + 1
              LRET    = -1
C * PLUTON/SUP
            CASE (4)
              IGBL(6) = MENUH + 1
              LRET    = -1
C * PLUTON/SUP
            CASE (5)
              IGBL(6) = MENUH + 1
              LRET    = -1
C * PLUTON/SUP
            CASE (6)
              IGBL(6) = MENUH + 1
              LRET    = -1
C * PLUTON/SUP
            CASE (7)
              IGBL(6) = MENUH + 1
              LRET    = -1
C * ORTEP/SUP1
            CASE (8)
              IF (MENUH == 1) THEN
                IGBL(6) = 1
              ELSE
                IGBL(6) = MENUH + 6
              END IF
              IPR(453) = 0
              IPR(448) = 0
              LRET     = -1
C * ORTEP/SUP2
            CASE (9)
              IF (MENUH == 1) THEN
                IGBL(6) = 1
              ELSE
                IGBL(6) = MENUH + 6
              END IF
              IPR(453) = 0
              IPR(448) = 0
              LRET     = -1
C * PLATON/OPTIONS
            CASE (10)
              IGBL(6) = MENUH + 9
              LRET    = -1
C * PLATON/SUP1
            CASE (11)
              IGBL(6) = MENUH + 9
              LRET    = -1
C * PLATON/SUP2
            CASE (12)
              IGBL(6) = MENUH + 9
              LRET    = -1
C * HELENA
            CASE (15)
C * L0MAX
            CASE (16)
              STRING(1:6) = 'L0MAX '
              NCNT        = 6
              SBCD        = STRING(1:NCNT)//CHAR (0)
              CALL PLA015 (539, 1)
              IPR(441) = 0
              IPR(442) = 0
              IPR(443) = 0
              IPR(444) = 0
              IPR(451) = 0
              IPR(540) = 0
              IPR(541) = 0
              IPR(542) = 0
              LRET     = -1
C * S MENU
            CASE (17)
              IGBL(6) = 16 + MENUH
              LRET    = -1
C * S/SUB MENU
            CASE (18)
              IGBL(6) = 16 + MENUH
              LRET    = -1
C * S/SHELXL
            CASE (19)
              IGBL(6) = 16 + MENUH
              LRET    = -1
C * DOT-MAX
            CASE (20)
              IPR(94) = MENUH + 1
              CALL PLA280 ('RESTART')
C * POWDER WAVEL
            CASE (21)
              IF (MENUH == 4) THEN
                WL = PAR(16)
                IPR(493) = 6
              ELSE IF (MENUH == 3) THEN
                WL = 1.54178
                IPR(493) = 5
              ELSE IF (MENUH == 2) THEN
                WL = 0.71073
                IPR(493) = 3
              ELSE IF (MENUH == 1) THEN
                WL = 0.56086
                IPR(493) = 2
              END IF
              CALL PLA293 (WL)
              IPR(500) = 0
              LRET     = 4
C * CONTOUR/OPTION
            CASE (22)
              IGBL(6)  = 23
              LRET     = -1
C * CONTOUR/OPTION
            CASE (23)
              IGBL(6)  = 22
              LRET     = -1
C * TwinRotMat
            CASE (25)
              IPR(550) = MENUH * 25
              CALL PLA280 ('CALC')
C * ADDSYM/PERC
            CASE (26)
              PAR(407) = (MENUH - 1) * 10.0
              IPR(699) = 1
              CALL PLA280 ('CALC ADDSYM')
C * RDF - NORMALIZE
            CASE (28)
              IPR(581) = MOD (IPR(581) + 1, 2)
              LRET     = 2
C * TOGGLE ICALC (FROMFCF/FROMCIF)
            CASE (29)
              IPR(594) = MOD (IPR(594) + 1, 2)
              CALL PLA280 ('FROM')
C * FLIPPER/PLATON
            CASE (31)
              CALL PLA280 ('PLATON')
C * ANAL-OF-VARIANCE - NPP
            CASE (32)
              CALL PLA280 ('NPP')
C * ANOM f' & F''
            CASE (33)
              CALL PLA280 ('ANOM')
C * FCF-COMPARE - NPP
            CASE (34)
              CALL PLA280 ('NPP')
C * WILSON-PLOT
            CASE (35)
              CALL PLA280 ('PLOT')
            CASE DEFAULT
              LRET = -1
          END SELECT
C * MENU BOX # 2
        CASE (2)
C * LOOP OVER MENU OPTIONS
          SELECT CASE (MMODE)
C * STEREO/MONO
            CASE (1)
              IPR(116) = MOD (IPR(116) + 1, 2)
C * TO STEREO
              IF (IPR(116) == 1) THEN
                IPR(479) = 2
                IF (IGBL(75) == 1) IPR(201) = 0
C * SELECT RG OR RB STEREO
                IF (MENUH == 1) THEN
                  IPR(144) = 3
                ELSE
                  IPR(144) = 4
                END IF
C * TO MONO - ROTATE BACK
              ELSE
                IPR(479) = 2
                PAR(389) = 0.0
                IPR(201) = 0
              END IF
              LRET = 2
C * MONO/STEREO MENU-OPTION
            CASE (2)
              IF (IPR(116) == 0) THEN
                IF (MENUH == 1) THEN
                  CALL PLA280 ('STEREO RG')
                ELSE IF (MENUH == 2) THEN
                  CALL PLA280 ('STEREO RB')
                ELSE IF (MENUH == 3) THEN
                  CALL PLA280 ('STEREO')
                ELSE
                  CALL PLA280 ('STEREO  S')
                END IF
              ELSE
                CALL PLA280 ('MONO')
              END IF
C * TEXT ON/OFF
            CASE (3)
              IPR(173) = MOD (IPR(173) + 1, 2)
              CALL PLA280 ('PLOT')
C * SELECT BWC-TYPE
            CASE (4)
              CALL PLA015 (348, 1)
              IF (IPR(348) == 1) IPR(345) = 1
              IPR(461) = MENUH - 1
              LRET     = -1
            CASE (5)
              CALL PLA280 ('VIEW UNIT')
C * CALC DIST
            CASE (6)
              CALL PLA015 (341, 2)
              LRET = -1
C * MENU ON/OFF
            CASE (7)
              CALL PLA280 ('MENU OFF')
C * ORTEP TEXT ON/OFF
            CASE (8)
              IPR(173) = MOD (IPR(173) + 1, 2)
              LRET     =  4
C * X-LineWidth
            CASE (9)
              IGBL(69) = MOD (IGBL(69) + 1, 2)
              YGGIP    = - 100 * (IGBL(69) + 1)
              CALL GGIP (0.0, YGGIP, 0.0, 0)
C * NOMOVE
            CASE (10)
              IF (IPR(30) == 0) IGBL(30) = MOD (IGBL(30) + 1, 2)
              LRET = -1
C * MaxRingSiz = IPR(216) TOGGLE
            CASE (11)
              IPR(29)  = MOD (IPR(29) + 1, 2)
              IF (IPR(29) == 0) THEN
                IPR(579) = IPR(219)
              ELSE
                IPR(579) = IPR(216)
              END IF
              LRET = -1
C * SET PRINTER LEVEL
            CASE (12)
              IGBL(64) = MENUH - 1
              IGBL(63) = IGBL(64)
              LRET     = -1
C * ASYM H
            CASE (14)
              IPR(394) = 1
              LRET     = 3
C * L1MAX
            CASE (16)
              STRING(1:6) = 'L1MAX '
              NCNT        = 6
              SBCD = STRING(1:NCNT)//CHAR (0)
              CALL PLA015 (540, 1)
              IPR(441) = 0
              IPR(442) = 0
              IPR(443) = 0
              IPR(444) = 0
              IPR(451) = 0
              IPR(539) = 0
              IPR(541) = 0
              IPR(542) = 0
              LRET     = -1
C * SYSTEM-S
            CASE (17, 18)
              IF (MENUH == 1) THEN
                CALL PLA280 ('LOG')
              ELSE IF (MENUH == 2) THEN
                CALL PLA280 ('RELINK BACK')
              ELSE
                CALL PLA280 ('RELINK FORWARD')
              END IF
C * EDIT-INS
            CASE (19)
              IGBL(44) = MOD (IGBL(44) + 1, 2)
              IF (IGBL(44) == 1) CALL PLA015 (0, 36)
              LRET = -1
            CASE (20)
              PAR(441) = (MENUH - 1) * 0.1
              CALL PLA280 ('RESTART')
C * POWDER LAMBDA
            CASE (21)
              CALL PLA015 (549, 1)
              IF (IPR(549) == 1) THEN
                STRING   = 'RADN '
                NCNT     = 5
                SBCD     = STRING(1:NCNT)//CHAR (0)
                IPR(493) = 6
              ELSE
                STRING = ' '
                NCNT   = 0
              END IF
              LRET = -1
C * FO-MAP (CONTOUR)
            CASE (22)
              CALL PLA280 ('FO')
              M = MIN (NINT (PAR(412) * 6.0), 5)
              IF (MENUH /= M) THEN
                IF (MENUH < 5) THEN
                  PAR(412) = MENUH * 0.15
                ELSE
                  PAR(412) = 99.0
                END IF
                IPR(414) = 1
                LRET     = 3
              ELSE
                IF (IPR(414) /= 1) THEN
                  IPR(414)  = 1
                ELSE
                  LRET = -1
                END IF
              END IF
C * PATT-MAP (CONTOUR)
            CASE (23)
              CALL PLA280 ('PT')
              M = MIN (NINT (PAR(412) * 6.0), 5)
              IF (MENUH /= M) THEN
                IF (MENUH < 5) THEN
                  PAR(412) = MENUH * 0.15
                ELSE
                  PAR(412) = 99.0
                END IF
                IPR(414) = 5
                LRET     = 3
              ELSE
                IF (IPR(414) /= 5) THEN
                  IPR(414) = 5
                ELSE
                  LRET = -1
                END IF
              END IF
C * STEREO/MONO SOLV
            CASE (24)
              IF (IPR(533) == MENUH) THEN
                IPR(116) = MOD (IPR(116) + 1, 2)
                IPR(533) = 1
              ELSE
                IF (MENUH == 2 .AND. IPR(116) == 0) IPR(116) = 1
                IPR(533) = MENUH
              END IF
C * TwinRotMat
            CASE (25)
              PAR(413) = 2 ** (MENUH - 1)
              CALL PLA280 ('CALC')
C * ADDSYM/Tol-Metric
            CASE (26)
              PAR(43) = MENUH * 0.2
              CALL PLA280 ('CALC ADDSYM')
C * CALC RDF (NEW RADIUS)
            CASE (28)
              PAR(450) = MENUH * 2.5
              CALL PLA280 ('CALC RDF')
C * InclWghtPar
            CASE (29)
              IF (PAR(493) > 0.0) THEN
                IPR(629) = MOD (IPR(629) + 1, 2)
                CALL PLA280 ('WGHT')
              END IF
            CASE (30)
C * COLOR (ON/OFF)
              IPR(346) = MOD (IPR(346) + 1, 2)
              LRET     = 3
C * ADDSYM PLOT
            CASE (31)
              CALL PLA280 ('CALL ADDSYM PLOT')
C * I/SIGMA VERSUS LOG10(I) PLOT
            CASE (32)
              CALL PLA280 ('IOSLI')
C * MU
            CASE (33)
              CALL PLA280 ('MU')
C * N(Z) - STATISTICS
            CASE (35)
              CALL PLA280 ('NZSTAT')
C * I/SIGMA VERSUS LOG10(I) PLOT
            CASE (38)
              CALL PLA280 ('IOSLI')
            CASE DEFAULT
              LRET = -1
          END SELECT
C * MENU BOX # 3
        CASE (3)
C * LOOP OVER MENUS
          SELECT CASE (MMODE)
C * H-ATOMS
            CASE (1)
              IPR(212) = MOD (IPR(212) + 1, 2)
              IPR(201) = 0
              LRET = 4
            CASE (2)
              IF (MENUH == 1) THEN
C * INCLUDE/EXCLUDE H-ATOMS
                IF (IPR(212) == 1) THEN
                  CALL PLA280 ('EXCLUDE H')
                  IPR(212) = 0
                ELSE
                  CALL PLA280 ('INCLUDE H')
                  IPR(212) = 1
                END IF
              ELSE IF (MENUH == 2) THEN
C * INCLUDE/EXCLUDE CH-ATOMS
                IF (IPR(212) == 1) THEN
                  CALL PLA280 ('EXCLUDE CH')
                  IPR(212) = 0
                ELSE
                  CALL PLA280 ('INCLUDE CH')
                  IPR(212) = 1
               END IF
              ELSE IF (MENUH == 3) THEN
C * INCLUDE/EXCLUDE DH-ATOMS
                IF (IPR(212) == 1) THEN
                  CALL PLA280 ('EXCLUDE DH')
                  IPR(212) = 0
                ELSE
                  CALL PLA280 ('INCLUDE DH')
                  IPR(212) = 1
                END IF
              END IF
C * PLUTON/TEXT ON/OFF
            CASE (3)
              IPR(173) = 1
              IPR(344) = 0
              IPR(453) = MOD (IPR(453) + 1, 2)
              IF (IPR(453) == 1) THEN
                CALL PLA280 ('TEXT')
                IPR(448)  = 0
              ELSE
                IPR(448) = 1
              END IF
C * SELECT COLOR
            CASE (4)
              CALL PLA015 (338, 1)
              IF (IPR(338) == 1) THEN
                IPR(346) = 1
              END IF
              LRET = -1
C * PLUTON VIEW MIN
            CASE (5)
              CALL PLA280 ('VIEW MIN')
C * CALC ANGLE
            CASE (6)
              CALL PLA015 (341, 3)
              LRET = -1
C * PERSPECTIVE
            CASE (7)
              PAR(48) = (MENUH - 1) * 10.0
C * PLATON ORTEP/ TEXT
            CASE (8)
              IPR(173) = 1
              IPR(453) = MOD (IPR(453) + 1, 2)
              LRET     = 5
C * COLOR (ON/OFF)
            CASE (9)
              IPR(346) = MOD (IPR(346) + 1, 2)
              IF (IPR(116) == 0) THEN
                LRET = 3
              ELSE
                IPR(116) = 0
                IPR(479) = 2
                PAR(389) = 0.0
                IPR(201) = 0
                LRET     = 2
              END IF
C * JOIN-EXPAND
            CASE (10)
              IPR(110) = MOD (IPR(110) + 1, 2)
              LRET     = -1
C * MAXNUMRING
            CASE (11)
              IPR(592) = MOD (IPR(592) + 1, 2)
              LRET     = -1
C * LPS (ON/OFF)
            CASE (12)
              IGBL(70) = MOD (IGBL(70) + 1, 2)
              IF (IGBL(70) == 0) IGBL(130) = 0
              LRET = -1
C * ASYM K
            CASE (14)
              IPR(394) = 2
              LRET     = 3
            CASE (15)
              IPR(446) = MENUH - 1
              IF (IPR(446) == 0) IPR(428) = 1
C * Tmin
            CASE (16)
              STRING(1:5) = 'TMIN '
              NCNT = 5
              SBCD = STRING(1:NCNT)//CHAR (0)
              CALL PLA015 (541, 1)
              IPR(441) = 0
              IPR(442) = 0
              IPR(443) = 0
              IPR(444) = 0
              IPR(451) = 0
              IPR(540) = 0
              IPR(541) = 0
              IPR(542) = 0
              LRET = -1
C * SYSTEM-S MULABS
            CASE (17)
              CALL PLA280 ('MULABS')
C * SYSTEM-S /SUB
            CASE (18)
              IF (MENUH == 1) THEN
                CALL PLA280 ('TREE')
              ELSE
                CALL PLA280 ('LIST')
              END IF
C * EDIT-s.res
            CASE (19)
              CALL PLA280 ('EDITRES')
C * 2-Axis Crit
            CASE (20)
              PAR(439) = 0.125 * 2 ** (MENUH - 1)
C * VERTICAL SCALE
            CASE (21)
              PAR(372) = 2 ** (MENUH - 1)
              LRET     = 3
C * 2FO-FC-MAP (CONTOUR)
            CASE (22)
              CALL PLA280 ('FS')
              M = MIN (NINT (PAR(412) * 6.0), 5)
              IF (MENUH /= M) THEN
                IF (MENUH < 5) THEN
                  PAR(412) = MENUH * 0.15
                ELSE
                  PAR(412) = 99.0
                END IF
                IPR(414) = 2
                LRET     = 3
              ELSE
                IF (IPR(414) /= 2) THEN
                  IPR(414) = 2
                ELSE
                  LRET = -1
                END IF
              END IF
C * SOLV DOTS/CONTOUR
            CASE (24)
              IPR(534) = MENUH
C * TwinRotMat
            CASE (25)
              IPR(567) = MENUH * 5
              CALL PLA280 ('CALC')
C * ADDSYM/Tol-Rotation
            CASE (26)
              PAR(401) = MENUH * 0.1  - 0.05
              IPR(699) = 1
              CALL PLA280 ('CALC ADDSYM')
C * CALC RDF (NEW WIDTH)
            CASE (28)
              PAR(451) = MENUH * 2.5
              CALL PLA280 ('CALC RDF')
C * POLY (0/1) PERSPECTIVE
            CASE (30)
              IPR(355) = MOD (IPR(355) + 1, 2)
              LRET     = 3
C * ADDSYM SHELX
            CASE (31)
              CALL PLA280 ('ADDSYM SHELX')
C * I/SIGMAW VERSUS LOG10(I) PLOT
            CASE (32)
              CALL PLA280 ('IOSWLI')
C * ANOM CUKA
            CASE (33)
              CALL PLA280 ('ANOM 1.5418')
C * N(Z) - PLOT
            CASE (35)
              CALL PLA280 ('NZPLOT')
            CASE DEFAULT
              LRET = -1
          END SELECT
C * MENU BOX # 4
        CASE (4)
C * LOOP OVER MENUS
          SELECT CASE (MMODE)
C * ORTEP/ATOM DELETE (OMIT)
            CASE (1)
              CALL PLA015 (351, 1)
              IPR(349) = 0
              LRET     = -1
C * SOLID
            CASE (2, 4)
              PAR351 = (6 - MENUH) * 0.1
              IF (IABS(IPR(4)) /= 1 .OR. PAR(351) /= PAR351) THEN
                PAR(351) = PAR351
                IPR(4)   = 0
                CALL PLA280 ('SOLID '//BWC//COLOR)
              ELSE
                CALL PLA280 ('STICK '//COLOR)
              END IF
C * NEW TEXT POSITION
            CASE (3)
              CALL PLA015 (448, 1)
              IF (IPR(448) == 1) IPR(453) = 0
              LRET = -1
            CASE (5)
              CALL PLA280 ('VIEW XO')
C * CALC TORSION
            CASE (6)
              CALL PLA015 (341, 4)
              LRET = -1
C * ORGANIC/INORGANIC - (PLUTON)
            CASE (7)
C * TEST FOR PREVIOUS CALC UNIQUE (NO = 0)
              IF (IPR(30) == 0) THEN
                IGBL(97) = MOD (IGBL(97) + 1, 2)
              END IF
              LRET = -1
C * NEW TEXT POSITION
            CASE (8)
              CALL PLA015 (448, 1)
              IF (IPR(448) == 1) IPR(453) = 0
              LRET = -1
C * LABEL HETERO ATOMS ONLY
            CASE (9)
              IPR(618) = MOD (IPR(618) + 1, 2)
              LRET = 2
C * ORGANIC/INORGANIC (PLATON)
            CASE (10)
C * TEST FOR PREVIOUS CALC UNIQUE (NO = 0)
              IF (IPR(30) == 0) THEN
                IGBL(97) = MOD (IGBL(97) + 1, 2)
              END IF
              LRET = -1
C * DI-HYDROGEN BONDS
            CASE (11)
              IGBL(56) = MOD (IGBL(56) + 1, 2)
              LRET     = -1
C * PDF (ON/OFF)
            CASE (12)
              IF (IGBL(116) > 0) THEN
                IGBL(130) = MOD (IGBL(130) + 1, 2)
                IF (IGBL(130) == 1) IGBL(70) = 1
              END IF
              LRET = -1
C * ASYM L
            CASE (14)
              IPR(394) = 3
              LRET     = 3
C * Tmax
            CASE (16)
              STRING(1:5) = 'TMAX '
              NCNT        = 5
              SBCD        = STRING(1:NCNT)//CHAR (0)
              CALL PLA015 (542, 1)
              IPR(441) = 0
              IPR(442) = 0
              IPR(443) = 0
              IPR(444) = 0
              IPR(451) = 0
              IPR(539) = 0
              IPR(540) = 0
              IPR(541) = 0
              LRET     = -1
C * S
            CASE (17)
              IF (MENUH == 1) THEN
                CALL PLA280 ('ABSTOMPA')
              ELSE IF (MENUH == 2) THEN
                CALL PLA280 ('ABSPSI')
              ELSE IF (MENUH == 3) THEN
                CALL PLA280 ('ABSNONE')
              END IF
C * SYSTEM-S ABST/XTAL
            CASE (18)
              CALL PLA280 ('REMOVE')
C * ASYM MAX2AXIS
            CASE (20)
              IPR(514) = 2 * MENUH - 1
              CALL PLA280 ('RESTART')
C * POWDER/HORS-SCALE
            CASE (21)
              IPR(500) = MENUH
              RGBL(23) = 0.0
              LRET = 3
C * DIFFERENCE MAP - CONTOUR
            CASE (22)
              CALL PLA280 ('DI')
              M = MIN (NINT (PAR(412) * 6.0), 5)
              IF (MENUH /= M) THEN
                IF (MENUH < 5) THEN
                  PAR(412) = MENUH * 0.15
                ELSE
                  PAR(412) = 99.0
                END IF
                IPR(414) = 3
                LRET     = 3
              ELSE
                IF (IPR(414) /= 3) THEN
                  IPR(414) =  3
                ELSE
                  LRET = -1
                END IF
              END IF
C * SOLV VIEW XO
            CASE (24)
              IPR(526) = 1
C * TwinRotMat (DELTATHETA)
            CASE (25)
              PAR(414) = MENUH * 0.05
              CALL PLA280 ('CALC')
C * ADDSYM/Tol-Inversion
            CASE (26)
              PAR(402) = MENUH * 0.1 -0.05
              IPR(699) = 1
              CALL PLA280 ('CALC ADDSYM')
C * POLY - INCL H-ATOMS
            CASE (30)
              IPR(212) = MOD (IPR(212) + 1, 2)
              LRET     = 3
C * ADDSYM EQUAL
            CASE (31)
              CALL PLA280 ('ADDSYM EQUAL')
C * SIGMA VERSUS LOG10(I) PLOT
            CASE (32)
              CALL PLA280 ('SIGLI')
C * ANOM GaKa
            CASE (33)
              CALL PLA280 ('ANOM 1.3414')
            CASE DEFAULT
              LRET = -1
          END SELECT
C * MENU BOX # 5
        CASE (5)
C * LOOP OVER MENUS
          SELECT CASE (MMODE)
C * ORTEP PROBABILITY LEVEL
            CASE (1)
              IPR(45)  = MENUH
              IPR(201) = 0
              LRET     = 2
            CASE (2)
              IF (IABS(IPR(4)) /= 2) THEN
                CALL PLA280 ('ROD   '//BWC//COLOR)
              ELSE
                CALL PLA280 ('STICK '//COLOR)
              END IF
C * LABEL TEXT SIZE
            CASE (3, 8)
              PAR(350) =  0.20 + 0.05 * MENUH
              LRET     = -1
            CASE (4)
              IF (IABS (IPR(4)) /= 2) THEN
                CALL PLA280 ('ROD   '//BWC//COLOR)
              ELSE
                CALL PLA280 ('STICK '//COLOR)
              END IF
            CASE (5)
              CALL PLA280 ('VIEW YO')
C * CALC GEOM
            CASE (6)
              CALL PLA015 (341, 1)
              LRET = -1
C * PLUTON/DisplAllLab
            CASE (7)
              IGBL(105) = MOD (IGBL(105) + 1, 2)
C * ORTEP/DisplAllLab
            CASE (9)
              IGBL(105) = MOD (IGBL(105) + 1, 2)
              IPR(201)  = 0
              LRET      = 2
C * ROUND
            CASE (10)
              IPR(68) = MENUH - 1
              LRET = -1
C * AutoRenum
            CASE (11)
C * TEST FOR PREVIOUS CALC UNIQUE (NO = 0)
              IF (IPR(30) == 0) THEN
                IPR(501) = MOD (IPR(501) + 1, 2)
                IPR(71)  = 0
              END IF
              LRET = -1
C * PAGE HEADER TOGGLE
            CASE (12)
              IGBL(137) = MOD (IGBL(137) + 1, 2)
C * HELENA
            CASE (15)
              IPR(320) = MOD (IPR(320) + 1, 2)
C * MU MM
            CASE (16)
              CALL PLA015 (441, 1)
              IPR(442) = 0
              IPR(443) = 0
              IPR(444) = 0
              IPR(451) = 0
              IPR(539) = 0
              IPR(540) = 0
              IPR(541) = 0
              IPR(542) = 0
              IF (IPR(441) == 1) THEN
                STRING = 'MU'
                NCNT = 3
                SBCD  = STRING(1:NCNT)//CHAR (0)
              ELSE
                NCNT = 0
                STRING = ' '
              END IF
              LRET = -1
C * SYSTEM-S
            CASE (17)
              IF (MENUH == 1) THEN
                CALL PLA280 ('TRMX')
              ELSE
                CALL PLA280 ('SPGR')
              END IF
C * XTAL
            CASE (18)
              CALL PLA280 ('XTAL')
C * SUB/SUPER-CELL
            CASE (20)
              IPR(117) = MENUH
C * POWDER/HORS-STEP
            CASE (21)
              IF (IPR(493) /= 8) THEN
                PAR(411) = MENUH / 100.0
              ELSE
                PAR(411) = MENUH * 0.000375
              END IF
              LRET = 3
C * SQ-MAP
            CASE (22)
              IF (IGBL(9) < 0) THEN
                CALL PLA280 ('SQ')
                M = MIN (NINT (PAR(412) * 5.0), 4)
                IF (MENUH /= M) THEN
                  IF (MENUH < 4) THEN
                    PAR(412) = MENUH * 0.2
                  ELSE
                    PAR(412) = 99.0
                  END IF
                  IPR(414) = 4
                  LRET     = 3
                ELSE
                  IF (IPR(414) /= 4) THEN
                    IPR(414)  = 4
                  ELSE
                    LRET = -1
                  END IF
                END IF
              ELSE
                CALL PLA015 (427, 7)
                LRET = -1
              END IF
C * SOLV VIEW YO
            CASE (24)
              IPR(526) = 2
C * TWIN ListFull
            CASE (25)
              IPR(469) = MOD (IPR(469) + 1, 2)
              CALL PLA280 ('CALC')
C * ADDSYM/Tol-Translation
            CASE (26)
              PAR(403) = MENUH * 0.1 - 0.05
              IPR(699) = 1
              CALL PLA280 ('CALC ADDSYM')
C * EXOR
            CASE (31)
              CALL PLA280 ('EXOR')
C * LOG10(SIGMA) & LOG10(SIGMAW) VERSUS LOG10(I) PLOT
            CASE (32)
              CALL PLA280 ('LSLI')
C * ANOM MoKA
            CASE (33)
              CALL PLA280 ('ANOM 0.71073')
            CASE DEFAULT
              LRET = -1
          END SELECT
C * MENU BOX # 6
        CASE (6)
C * LOOP OVER MENUS
          SELECT CASE (MMODE)
C * COORDN
            CASE (1)
              CALL PLA015 (440, 1)
              IPR(311) = 0
              IPR(351) = 0
              IPR(349) = 0
              IPR(327) = 0
              IPR(328) = 0
              LRET = -1
            CASE (2, 4)
              IF (IABS (IPR(4)) /= 3) THEN
                IF (MENUH == 1) THEN
                  CALL PLA280 ('CPK '//BWC//COLOR)
                ELSE IF (MENUH == 2) THEN
                  CALL PLA280 ('CPK STICK '//BWC//COLOR)
                END IF
              ELSE
                CALL PLA280 ('STICK '//COLOR)
              END IF
C * DELETE TEXT MODE
            CASE (3)
              CALL PLA015 (344, 1)
              LRET = -1
            CASE (5)
              CALL PLA280 ('VIEW ZO')
C * LIST TYPES
            CASE (6)
              IPR(90) = 256
              CALL PLUT12
C * LABEL FULL/NUM
            CASE (7)
              IPR(14)  = MOD (IPR(14) + 1, 2)
C * DELETE TEXT MODE
            CASE (8)
              IPR(453) = 0
              CALL PLA015 (344, 1)
              LRET = -1
C * LabelCg
            CASE (9)
              IPR(506) = MOD (IPR(506) + 1, 2)
              IPR(201) = 0
              LRET     = 2
C * PARENTHESES
            CASE (10)
              IF (IGBL(71) == 0) IPR(71) = MOD (IPR(71) + 1, 2)
              LRET = -1
C * INCLDISCONT
            CASE (11)
              IPR(502) = MOD (IPR(502) + 1, 2)
              LRET = -1
C * ASYM RESUME
            CASE (14)
              IPR(406) = MOD (IPR(406) + 1, 2)
              IPR(389) = 0
              LRET     = 4
C * HELENA SCALE/NOSCALE
            CASE (15)
              IPR(428) = MOD (IPR(428) + 1, 2)
              IF (IPR(428) == 0) IPR(446) = 1
C * ABSCOR/Radius
            CASE (16)
              CALL PLA015 (442, 1)
              IPR(441) = 0
              IPR(443) = 0
              IPR(444) = 0
              IPR(451) = 0
              IPR(539) = 0
              IPR(540) = 0
              IPR(541) = 0
              IPR(542) = 0
              IF (IPR(442) == 1) THEN
                STRING = 'RADIUS'
                NCNT   = 7
                SBCD   = STRING(1:NCNT)//CHAR (0)
              ELSE
                STRING = ' '
                NCNT   = 0
              END IF
              LRET = -1
C * SYSTEM-S
            CASE (17)
              IF (MENUH == 1) THEN
                CALL PLA280 ('FORMULA')
              ELSE IF (MENUH == 2) THEN
                CALL PLA280 ('Z')
              ELSE
                CALL PLA280 ('SHELXS86')
              END IF
C * SYSTEM-S / SUB
            CASE (18)
              IF (MENUH == 1) THEN
                CALL PLA280 ('CELL')
              ELSE
                CALL PLA280 ('HELENA')
              END IF
C * SYSTEM-S/SHELXL TWIN
            CASE (19)
              CALL PLA280 ('TWIN')
C * LEPAGE ROUND/CELL
            CASE (20)
              PAR(440) = 10 ** MENUH
C * POWDER LINEWIDTH
            CASE (21)
              IF (MENUH < 3) THEN
                PAR(371) = 10 ** (3 - MENUH)
              ELSE
                PAR(371) = 1.0 / 10 ** (MENUH - 3)
              END IF
              LRET = 3
C * CONTOUR PLANE-HORIZ
            CASE (22)
              CALL PLA280 ('PLAN')
              IPR(416)  = 0
              IPR(420)  = 0
C * SOLV VIEW ZO
            CASE (24)
              IPR(526) = 3
C * EPS-TwinLaw
            CASE (25)
              MEDIUM      = 2
              IGGT(16:22) = 'ON     '
              CALL GGIP (-999.0, 0.0, 0.0, 6)
              CALL PLA280 ('PLOT')
C * ADDSYM NFRPercImpl
            CASE (26)
              IPR(568) = MOD (IPR(568) + 1, 2)
              LRET = -1
C * Hooft Select Crit
            CASE (29)
              IPR(611) = MENUH - 1
              CALL PLA280 ('SELECT')
C * SIGMA(I) VERSUS SQRT(I) PLOT
            CASE (32)
              CALL PLA280 ('SIRI')
C * ANOM AgKA
            CASE (33)
              CALL PLA280 ('ANOM 0.56086')
            CASE DEFAULT
              LRET = -1
          END SELECT
C * MENU BOX # 7
        CASE (7)
C * LOOP OVER MENUS
          SELECT CASE (MMODE)
C * INTERACTIVE DIST/ANGLE/TORSION
            CASE (1)
              CALL PLA015 (341, MENUH + 1)
              LRET = -1
C * STICK/STRAW/ROD/BWC
            CASE (2, 4)
              IF (IABS(IPR(4)) /= 4) THEN
                CALL PLA280 ('STRAW '//BWC//COLOR)
              ELSE
                CALL PLA280 ('STICK '//COLOR)
              END IF
C * CHANGE TEXT SIZE
            CASE (3, 8)
              CALL PLA015 (334, 1)
              LRET = -1
            CASE (5)
              CALL PLA280 ('VIEW AFACE')
C * LIST LINES
            CASE (6)
              IPR(90) =  16
              CALL PLUT12
C * Label-Alias (PLUTON)
            CASE (7)
              IGBL(55) = MOD (IGBL(55) + 1, 2)
C * Label-Alias (ORTEP)
            CASE (9)
              IGBL(55) = MOD (IGBL(55) + 1, 2)
C * Label-Alias
            CASE (10)
              IGBL(55) = MOD (IGBL(55) + 1, 2)
              LRET = -1
C * TMA-HIncl
            CASE (11)
              IPR(497) = MOD(IPR(497) + 1, 2)
              LRET = -1
C * ASYM RESOLUTION
            CASE (14)
              IPR(387) = MOD (IPR(387) + 1, 2)
              IPR(389) = 0
              LRET     = 4
C * HELENA BETA/PERP/PAR
            CASE (15)
              IF (IPR(370) == 0) IPR(424) = MENUH - 1
C * MUR
            CASE (16)
              CALL PLA015 (443, 1)
              IPR(441) = 0
              IPR(442) = 0
              IPR(444) = 0
              IPR(451) = 0
              IF (IPR(443) == 1) THEN
                STRING = 'MUR'
                NCNT   = 4
                SBCD   = STRING(1:NCNT)//CHAR (0)
             ELSE
               STRING = ' '
               NCNT   = 0
              END IF
              LRET = -1
C * SYSTEM-S
            CASE (17)
              IF (MENUH == 1) THEN
                CALL PLA280 ('SHELXS97 TREF')
              ELSE IF (MENUH == 2) THEN
                CALL PLA280 ('SHELXS97 PATT')
              ELSE IF (MENUH == 3) THEN
                CALL PLA280 ('SHELXD')
              ELSE
                CALL PLA280 ('SHELXT')
              END IF
C * SYSTEM-S/FLIPPER
            CASE (18)
              CALL PLA280 ('FLIPPER')
C * IOBS/ICAL
            CASE (21)
C * SHELXL LIST 4n ONLY
              IF (IGBL(9) == 1) IPR(511) = MENUH
C * RECALCULATE
              LRET     = 5
C * CONTOUR PLANE-ABCD
            CASE (22)
              CALL PLA280 ('PLAN')
              IPR(416)  = 1
              IPR(420)  = 0
C * REVERSE
            CASE (24)
              CALL PLA280 ('REVERSE')
C * TwinRotMat1
            CASE (25)
              IF (IPR(543) == 1) THEN
                IPR(543) = 0
              ELSE
                IPR(543) = 1
                CALL PLA280 ('TWIN')
                IPR(576) = 0
              END IF
C * BIJVOET/PARSONS DIFF TOGGLE
            CASE (29)
              IPR(635) = MOD (IPR(635) + 1, 2)
C * AV(I/SIG) VERSUS SIN(THETA)/LAMBDA
            CASE (32)
              CALL PLA280 ('ISST')
C * ANOM InKa
            CASE (33)
              CALL PLA280 ('ANOM 0.51359')
            CASE DEFAULT
              LRET = -1
          END SELECT
C * MENU BOX # 8
        CASE (8)
C * LOOP OVER MENUS
          SELECT CASE (MMODE)
C * JOIN/DASH/DETACH
            CASE (1)
              CALL PLA015 (311, MENUH)
              LRET = -1
C * STICK/STRAW/ROD/BWC
            CASE (2, 4)
              IF (IABS(IPR(4)) /= 0) THEN
                CALL PLA280 ('STICK '//COLOR)
              ELSE
                CALL PLA280 ('STRAW '//BWC//COLOR)
              END IF
C * PLUTON DELETE
            CASE (3)
              CALL PLA015 (351, 1)
              IF (IPR(335) == 1) CALL PLA015 (335, 1)
              IF (IPR(349) == 1) CALL PLA015 (349, 1)
              IF (IGBL(75) == 0) THEN
                CALL PLA280 ('LABEL ON')
              ELSE
                LRET = -1
              END IF
            CASE (5)
              CALL PLA280 ('VIEW BFACE')
C * LIST ARU
            CASE (6)
              IPR(90) =  32
              CALL PLUT12
C * UISO TOGGLE
            CASE (7)
              IPR(231) = MOD (IPR(231) + 1, 2)
C * DEF COORDN RADIUS
            CASE (8)
              PAR(7) = 2.0 + MENUH
              LRET = -1
C * FIT BY CLICKING
            CASE (9)
              LRET = -1
              IF (IPR(75) > 1) THEN
                CALL PLA015 (312, 1)
                IFL(1)  = 'FIT'
                IPR(33) = MENUH - 1
                IF (IPR(312) == 0) THEN
                  IPR(81) = - LMOD - 1
                  NASUP   = IPR(39) + IPR(64)
                  CALL PLA269 (-1, NASUP)
                  CALL PLA440 (1)
                  LMOD = 0
                  IGBL(6) = IABS (IGBL(6))
                  LRET = 4
                END IF
              END IF
C * R/S-DET
            CASE (10)
              IPR(324) = MOD (IPR(324) + 1, 2)
              LRET = -1
C * ALTLABPACK
            CASE (11)
              IGBL(61) = MOD (IGBL(61) + 1, 2)
              LRET = -1
C * LIST FLAGS & RADII
            CASE (12)
              IF (MENUH == 1) THEN
                CALL PLA280 ('LIST FLAGS')
              ELSE
                CALL PLA280 ('LIST RADII')
              END IF
              LRET = 2
C * ASYM AXES
            CASE (14)
              IPR(388) = MOD (IPR(388) + 1, 2)
              IPR(389) = 0
              LRET     = 4
C * HELENA LSR/MSM/MSA
            CASE (15)
              IF (IPR(370) == 0) IPR(425) = MENUH -1
C * GAUSSIAN GRID
            CASE (16)
              CALL PLA015 (444, 1)
              IPR(441) = 0
              IPR(442) = 0
              IPR(443) = 0
              IPR(451) = 0
              IF (IPR(444) == 1) THEN
                STRING = 'GRID'
                NCNT   = 5
                SBCD   = STRING(1:NCNT)//CHAR (0)
              ELSE
                STRING = ' '
                NCNT   = 0
              END IF
              LRET = -1
C * SYSTEM-S
            CASE (17)
              IF (MENUH == 1) THEN
                CALL PLA280 ('DIRDIF PATTY')
              ELSE
                CALL PLA280 ('DIRDIF ORIENT')
              END IF
C * SYSTEM-S STLM
            CASE (18)
              VAL = 1.0
              IF (MENUH == 1) THEN
                VAL = 0.54
              ELSE IF (MENUH == 2) THEN
                VAL = 0.60
              ELSE IF (MENUH == 3) THEN
                VAL = 0.65
              END IF
              WRITE (IGGT, 99994, IOSTAT = IOST) VAL
              PAR(453) = VAL
C * SYSTEM-S/SHELXL MERG 4
            CASE (19)
              IGBL(91) = MOD (IGBL(91) + 1, 2)
              LRET = -1
C * CONTOUR PLANE-BISECT
            CASE (22)
              CALL PLA280 ('PLAN')
              IPR(416)  = 2
              IPR(420)  = 0
C * NR-Sections
            CASE (23)
              IPR(577) = (MENUH * 2) - 1
              LRET = -1
C * VOID AXES PLOT TOGGLE
            CASE (24)
              IPR(598) = MOD (IPR(598) + 1, 2)
C * TwinRotMat2
            CASE (25)
              IF (IPR(543) == 2) THEN
                IPR(543) = 0
              ELSE
                IPR(543) = 2
                CALL PLA280 ('TWIN')
                IPR(576) = 0
              END IF
C * NOINVERT (LEPAGE)
            CASE (26)
              IPR(708) = MOD (IPR(708) + 1, 2)
              IPR(699) = 1
              CALL PLA280 ('CALC ADDSYM')
C * BIJVOET SIGMA CRIT
            CASE (29)
              IF (MENUH == 1) THEN
                PAR(452) = 0.0
              ELSE
                PAR(452) = 0.25 * 2 ** (MENUH - 2)
              END IF
              CALL PLA280 ('SIGMA')
C * ANALYSIS OF VARIANCE
            CASE (32)
              CALL PLA280 ('VARIANCE')
            CASE DEFAULT
              LRET = -1
          END SELECT
C * MENU BOX # 9
        CASE (9)
C * LOOP OVER MENUS
          SELECT CASE (MMODE)
C * DEFINE ATOM TO CG OF ATOMS
            CASE (1)
C * SET LABEL CG ON
              IPR(506) = 1
C * RESET LABEL POSITIONING
              IPR(201) = 0
              IF (MENUH == 1) THEN
                LMOD     = 1
                IFL(1)   = 'DEFINE'
                IPR(507) = 1
                CALL PLA015 (508, 1)
                LRET = -1
              ELSE IF (MENUH == 3) THEN
                IF (IPR(508) == 1) THEN
                  IPR(507) = 3
                  IPR(508) = 0
                  WRITE (IGGT, 99995, IOSTAT = IOST) IFL(1)(1:6),
     1              IFL(2)(1:7), IFL(3)(1:2), (IFL(I)(1:7), I = 4, LMOD)
                  IGBL(6) = IABS (IGBL(6))
                  LRET = 7
                END IF
              END IF
C * BWC (ON/OFF)
            CASE (2, 4)
C * BWC-SWITCH
              DO
                IPR(345) = MOD (IPR(345) + 1, 2)
                IF (IPR(345) == 1) THEN
C * BWC ATOM-TYPE
                  IF (MENUH == 1) THEN
                    IPR(478) = 0
C * BWC RESD
                  ELSE IF (MENUH == 2) THEN
                    IPR(478) = -1
C * BWC ARU
                  ELSE
                    IPR(478) = 1
                  END IF
                ELSE
                  IF (MENUH * IPR(478) == -2 .OR.
     1                MENUH * IPR(478) ==  3 .OR.
     2                (MENUH == 1 .AND. IPR(478) == 0)) THEN
                    IPR(478) = 0
                  ELSE
                    IPR(478) = 0
                    CYCLE
                  END IF
                END IF
C * TEST for AUTOPLOT
                IF (IGBL(35) == 1) THEN
                  CALL PLA280 ('PLOT')
                ELSE
                  LRET = -1
                END IF
                IF (NEXIT == 0) EXIT
              END DO
C * PLUTON RENAME
            CASE (3)
              IF (IPR(351) == 1) CALL PLA015 (351, 1)
              IF (IPR(349) == 1) CALL PLA015 (349, 1)
              IF (IGBL(3) /= 0) THEN
                CALL PLA015 (335, 1)
                IF (IGBL(75) == 0) THEN
                  CALL PLA280 ('LABEL ON')
                ELSE
                  LRET = -1
                END IF
              ELSE
                CALL PLA015 (427, 40)
                LRET = -1
              END IF
            CASE (5)
              CALL PLA280 ('VIEW CFACE')
C * LIST FLAGS
            CASE (6)
              IPR(90) = 512
              CALL PLUT12
C * NOMOVE
            CASE (7)
              IF (IPR(17) == 0) IGBL(30) = MOD (IGBL(30) + 1, 2)
              LRET = -1
C * NO-SYMM
            CASE (8)
              IGBL(52) = MOD (IGBL(52) + 1, 2)
              LRET = -1
C * FIT RESD 1 on 2
            CASE (9)
              IF (IPR(75) > 1) THEN
                IPR(33) = MENUH - 1
                CALL PLA280 ('FIT 1 2')
              ELSE
                LRET = -1
              END IF
C * HBOND-NORM
            CASE (10)
              IGBL(148) = MOD (IGBL(148) + 1, 2)
              IPR(87)   = IGBL(148)
              LRET = -1
C * SHELXL-ATOM WEIGHT
            CASE (11)
C * TEST FOR PREVIOUS CALC UNIQUE (NO = 0)
              IF (IPR(30) == 0) IPR(181) = MOD(IPR(181) + 1, 2)
              LRET = -1
C * NO INVERT TOGGLE
            CASE (12)
              IF (IPR(33) == 1) THEN
                IPR(33) = 0
              ELSE
                IPR(33) = 1
              END IF
              LRET = -1
C * HELENA DIRCOS/ABSPSI
            CASE (15)
              IF (IPR(370) == 0) IPR(426) = MENUH - 1
C * FACE
            CASE (16)
              CALL PLA015 (451, 1)
              IPR(441) = 0
              IPR(442) = 0
              IPR(443) = 0
              IPR(444) = 0
              IF (IPR(451) == 1) THEN
                STRING = 'FACE'
                NCNT   = 5
                SBCD   = STRING(1:NCNT)//CHAR (0)
              ELSE
                STRING = ' '
                NCNT   = 0
              END IF
              LRET = -1
C * SYSTEM-S
            CASE (17)
              IF (MENUH == 1) THEN
                CALL PLA280 ('SIR97')
              ELSE IF (MENUH == 2) THEN
                CALL PLA280 ('SIR2004')
              ELSE IF (MENUH == 3) THEN
                CALL PLA280 ('SIR2011')
              END IF
C * ORGANIC/INORGANIC
            CASE (18)
              IGBL(97) = MOD (IGBL(97) + 1, 2)
C * SYSTEM-S/SHELXL OMIT-OUTLIER
            CASE (19)
              IGBL(51) = MOD (IGBL(51) + 1, 2)
              LRET = -1
C * CONTOUR PLANE-PERP
            CASE (22)
              CALL PLA280 ('PLAN')
              IPR(416) = 3
              IPR(420) = 0
C * NR+Sections
            CASE (23)
              IPR(578) = (MENUH * 2) - 1
              LRET = -1
C * UnitSymPack
            CASE (24)
              IPR(537) = MOD (IPR(537) + 1, 2)
C * TwinRotMat3
            CASE (25)
              IF (IPR(543) == 3) THEN
                IPR(543) = 0
              ELSE
                IPR(543) = 3
                CALL PLA280 ('TWIN')
                IPR(576) = 0
              END IF
C * NOSUBCELL
            CASE (26)
              IPR(503) = MOD (IPR(503) + 1, 2)
              IPR(699) = 1
              CALL PLA280 ('CALL ADDSYM')
C * Bijvoet Difference - Theta Plot
            CASE (29)
              CALL PLA280 ('SET IPR 656 1')
            CASE DEFAULT
              LRET = -1
          END SELECT
C * MENU BOX # 10
        CASE (10)
C * LOOP OVER MENUS
          SELECT CASE (MMODE)
C * VIEW OPTIONS
            CASE (1)
C * VIEW UNIT
              IF (MENUH == 1) THEN
                CALL PLA226 (0, 0.0)
C * VIEW MIN
 
              ELSE IF (MENUH == 2) THEN
                IGBL(67) = 0
                IPR(201) = 0
C * VIEW XO
              ELSE IF (MENUH == 3) THEN
                CALL PLA226 ( 1, -90.0 / RGBL(6))
                CALL PLA226 (-2, -90.0 / RGBL(6))
C * VIEW YO
              ELSE IF (MENUH == 4) THEN
                CALL PLA226 ( 1, 90.0 / RGBL(6))
                CALL PLA226 (-3, 90.0 / RGBL(6))
C * VIEW ZO
              ELSE IF (MENUH == 5) THEN
                CALL PLA226 (3, 0.0)
              END IF
              MNH(6) = MENUH
              LRET = 4
C * VIEW MIN MENU-OPTION (PLUTON)
            CASE (2)
              IF (MENUH == 1) THEN
                CALL PLA280 ('VIEW UNIT')
              ELSE IF (MENUH == 2) THEN
                CALL PLA280 ('VIEW MIN')
              ELSE IF (MENUH == 3) THEN
                CALL PLA280 ('VIEW XO')
              ELSE IF (MENUH == 4) THEN
                CALL PLA280 ('VIEW YO')
              ELSE IF (MENUH == 5) THEN
                CALL PLA280 ('VIEW ZO')
              END IF
              MNH(6) = MENUH
C * PLUTON MOVE LABEL
            CASE (3)
              CALL PLA015 (349, 1)
              IF (IPR(351) == 1) CALL PLA015 (351, 1)
              IF (IPR(335) == 1) CALL PLA015 (335, 1)
              IF (IGBL(75) == 0) THEN
                CALL PLA280 ('LABEL ON')
              ELSE
                LRET = -1
              END IF
C * (RE)SET GLOBAL PATTERN
            CASE (4)
              IPR(345) = 0
              IPR(139) = MENUH - 1
C * VIEW INVERT
            CASE (5)
              CALL PLA280 ('VIEW INVERT')
C * LIST CELL
            CASE (6)
              CALL PLA280 ('LIST CELL')
C * KEYBOARD INSTRUCTION HELP
            CASE (7)
              CALL PLA280 ('HELP')
C * VIEW INVERT
            CASE (8)
              CALL PLA226 (-4, 0.0)
C * (U/A/E)WLSPL
            CASE (9)
              IPR(41) = MENUH - 1
              LRET = -1
C * NO-SYMM
            CASE (10)
C * TEST FOR PREVIOUS CALC UNIQUE (NO = 0)
              IF (IPR(30) == 0) IGBL(52) = MOD (IGBL(52) + 1, 2)
              LRET = -1
C * (U/A/E)WLSPL
            CASE (11)
              IPR(41) = MENUH - 1
              LRET = -1
C * KeepMonI-n Toggle
            CASE (12)
              IGBL(106) = MOD (IGBL(106) + 1, 2)
C * ASYM SINT/L-MAX
            CASE (14)
              PAR(165) =
     1          ASIN ((0.45 + MENUH * 0.05) * PAR(17)) * RGBL(6)
          LRET = 3
C * DELFACE
            CASE (16)
              STRING(1:5) = 'DELF '
              NCNT = 5
              SBCD = STRING(1:NCNT)//CHAR (0)
              LRET = -1
C * SYSTEM-S
            CASE (17)
              IF (MENUH == 1) THEN
                CALL PLA280 ('EXOR')
              ELSE IF (MENUH == 2) THEN
                CALL PLA280 ('EXORS')
              ELSE IF (MENUH == 3) THEN
                CALL PLA280 ('EXORD')
              END IF
C * SYSTEM-S/SUB SOLVE CHECK
            CASE (18)
              IGBL(40) = MOD (IGBL(40) + 1, 2)
C * AUTO-EXTI-REF
            CASE (19)
              IGBL(96) = MOD (IGBL(96) + 1, 2)
              LRET     = -1
C * KeepMonI-n Toggle
            CASE (20)
              IGBL(106) = MOD (IGBL(106) + 1, 2)
C * CONTOUR PLANE-PERP (XY/YZ/XZ)
            CASE (22)
              CALL PLA280 ('PLAN')
              IPR(416) = 4
              IPR(420) = MENUH
              MNH(16)  = MENUH
C * GET AXIAL LENGTHS
              IF (MENUH == 1) THEN
                PAR(272) = PAR(101)
                PAR(273) = PAR(102)
              ELSE IF (MENUH == 2) THEN
                PAR(272) = PAR(101)
                PAR(273) = PAR(103)
              ELSE
                PAR(272) = PAR(102)
                PAR(273) = PAR(103)
              END IF
C * OPTIMIZE ORIENTATION
              IF (PAR(272) < PAR(273)) THEN
                PAR(276) = 90.0
                CALL GEN018 (PAR(272), PAR(273))
              ELSE
                PAR(276) = 0.0
              END IF
C * FIT TO RATIO PAR(50)
              IF (PAR(273) * PAR(50) < PAR(272)) THEN
                PAR(273) = PAR(272) / PAR(50)
              END IF
              PAR(273) = PAR(273) + 3.0
              PAR(272) = PAR(273) * PAR(50)
C * Fourier3D
            CASE (23)
              CALL PLA280 ('F3D')
C * SOLV/PLOT RESD
            CASE (24)
              IPR(140) = MENUH - 1
C * TwinRotMat4
            CASE (25)
              IF (IPR(543) == 4) THEN
                IPR(543) = 0
              ELSE
                IPR(543) = 4
                CALL PLA280 ('TWIN')
                IPR(576) = 0
              END IF
C * KeepMonI-n Toggle
            CASE (26)
              IGBL(106) = MOD (IGBL(106) + 1, 2)
C * Bijvoet Difference versus FoK Plot
            CASE (29)
              CALL PLA280 ('SET IPR 656 2')
C * POLY VIEW OPTIONS
            CASE (30)
C * VIEW UNIT
              IF (MENUH == 1) THEN
                CALL PLA226 (0, 0.0)
C * VIEW XO
              ELSE IF (MENUH == 2) THEN
                CALL PLA226 (2, 90.0 / RGBL(6))
C * VIEW YO
              ELSE IF (MENUH == 3) THEN
                CALL PLA226 (1, -90.0 / RGBL(6))
C * VIEW ZO
              ELSE IF (MENUH == 4) THEN
                CALL PLA226 (3, 90.0 / RGBL(6))
              END IF
              MNH(6) = MENUH
              LRET = 3
C * NTRY
            CASE (31)
              WRITE (IGGT, 99975, IOSTAT = IOST) MENUH
C * MU CuKa
            CASE (33)
              CALL PLA280 ('MU 1.5418')
C * KeepMonI-n Toggle
            CASE (37)
              IGBL(106) = MOD (IGBL(106) + 1, 2)
            CASE DEFAULT
              LRET = -1
          END SELECT
C * MENU BOX # 11
        CASE (11)
C * LOOP OVER MENUS
          SELECT CASE (MMODE)
C * DISORDER TOGGLE
            CASE (1)
              IF (IPR(44) /= 0) THEN
                IF (MENUH - 1 /= IGBL(88)) THEN
                  IF (IGBL(59) == 1) THEN
                    IGBL(88) = MENUH - 1
                  ELSE
                    IGBL(59) = MOD (IGBL(59) + 1, 2)
                  END IF
                ELSE
                  IGBL(59) = MOD (IGBL(59) + 1, 2)
                  IGBL(88) = MENUH - 1
                END IF
              END IF
              IPR(201) = 0
              LRET = 4
C * NODISORDER TOGGLE
            CASE (2)
              IF (MENUH - 1 /= IGBL(88)) THEN
                IF (IGBL(59) == 1) THEN
                  IGBL(88) = MENUH - 1
                ELSE
                  IGBL(59) = MOD (IGBL(59) + 1, 2)
                END IF
              ELSE
                IGBL(59) = MOD (IGBL(59) + 1, 2)
                IGBL(88) = MENUH - 1
              END IF
C * CALC GEOM
            CASE (3)
              IPR(351) = 0
              CALL PLA015 (341, 1)
              LRET = -1
C * RADII BONDS TAPER
            CASE (4)
              IF (MENUH > 1) THEN
                PAR(44) = 0.5 * 2.0 ** (MENUH - 4)
              ELSE
                PAR(44) = 0.0
              END IF
C * VIEW LINE
            CASE (5)
              IFL(1) = 'VIEW '
              IFL(2) = 'LINE '
              CALL PLA015 (329, 1)
              LRET = -1
C * LIST SYMM
            CASE (6)
              CALL PLA274
              CALL PLA280 ('PLOT')
C * Auto-Plot
            CASE (7)
              IGBL(35) = MOD (IGBL(35) + 1, 2)
              LRET = -1
C * COLOR TYPE (ORTEP)
            CASE (8)
              CALL PLA015 (536, MENUH)
              LRET = -1
C * ANGLE BETWEEN LINES
            CASE (9)
              CALL PLA015 (341, 5)
              LRET = -1
C * DISORDER TOGGLE
            CASE (10)
              IF (IPR(44) /= 0) THEN
                IF (MENUH - 1 /= IGBL(88)) THEN
                  IF (IGBL(59) == 1) THEN
                    IGBL(88) = MENUH - 1
                  ELSE
                    IGBL(59) = MOD (IGBL(59) + 1, 2)
                  END IF
                ELSE
                  IGBL(59) = MOD (IGBL(59) + 1, 2)
                  IGBL(88) = MENUH - 1
                END IF
              END IF
              LRET = -1
C * ExclDisOper
            CASE (11)
              IPR(154) = MOD (IPR(154) + 1, 2)
              LRET = -1
C * NOEXPAND
            CASE (12)
              IF (IGBL(136) == 0) THEN
                CALL PLA280 ('NOEXPAND')
                LRET = 2
              ELSE
                IGBL(136) = 0
              END IF
 
C * OMIT SIGMA - ASYM
            CASE (14)
              PAR(284) = (MENUH - 1) * 0.5
              LRET = 3
C * HELENA-RR#
            CASE (15)
              CALL PLA280 ('RR 1')
C * Refl.List
            CASE (16)
              IGBL(57) = MOD (IGBL(57) + 1, 2)
C * SYSTEM-S
            CASE (17)
              WRITE(IGGT(1:14), 99993, IOSTAT = IOST) MENUH - 1
C * SYSTEM-S/SUB ADDSYM CHECK
            CASE (18)
              IGBL(41) = MOD (IGBL(41) + 1, 2)
            CASE (19)
              IGBL(125) = MOD (IGBL(125) + 1, 2)
              LRET = -1
C * CONTOUR WINDOW-VERTICAL
            CASE (22)
              PAR(279) = - 1.5 + MENUH
              LRET = 2
C * Unit-Fill
            CASE (24)
              IPR(535) = MOD (IPR(535) + 1, 2)
C * EPS-TwinLat
            CASE (25)
              IPR(543) = MENUH
              MEDIUM      = 2
              IGGT(16:22) = 'ON     '
              CALL GGIP (-999.0, 0.0, 0.0, 6)
              CALL PLA280 ('TWIN')
C * Bijvoet Dif Dif/Sig versus Theta
            CASE (29)
              CALL PLA280 ('SET IPR 656 -1')
C * POLY (0/1) DRAW POLYEDRA
            CASE (30)
              IPR(353) = MOD (IPR(353) + 1, 2)
              LRET = 3
C * NSOLVE
            CASE (31)
              WRITE (IGGT, 99974, IOSTAT = IOST) MENUH * 250
C * MU GaKa
            CASE (33)
              CALL PLA280 ('MU 1.3414')
            CASE DEFAULT
              LRET = -1
          END SELECT
C * MENU BOX # 12
        CASE (12)
C * LOOP OVER MENUS
          SELECT CASE (MMODE)
C * LABELS (ON/OFF)
            CASE (1)
              IF (MENUH == IPR(232) + 1)
     1             IGBL(75) = MOD (IGBL(75) + 1, 2)
              IF (MENUH == 2) THEN
                IPR(232) = 1
                IPR(201) = 0
              ELSE
                IPR(232) = 0
              END IF
              IF (IGBL(75) == 1) WRITE (LU6, 99999, IOSTAT = IOST)
              IF (IGBL(35) == 1) THEN
                LRET = 2
              ELSE
                LRET = -1
              END IF
C * LABEL SIZE
            CASE (2)
              PAR(349) = 0.20 + 0.05 * MENUH
C * SELECT ZOOM CENTRE
            CASE(3)
              CALL PLA015 (343, 1)
              LRET = -1
C * OVERLAP MARGIN
            CASE (4)
              PAR(36) = (MENUH - 1) * 0.05
C * VIEW PERP
            CASE (5)
              IFL(1) = 'VIEW '
              IFL(2) = 'PERP '
              CALL PLA015 (329, 2)
              LRET = -1
C * LIST ATOMS
            CASE (6)
              IPR(90)  = 4
              IPR(220) = 2
              CALL PLUT12
C * OVERLAP MARGIN
            CASE (7)
              PAR(58) = (MENUH - 1) * 0.05
C * RASTER-3D
            CASE (8)
              IPR(108) = 1
              IPR(148) = MENUH - 1
              LRET = 2
C * LIST RADII BONDS
            CASE (9)
              CALL PLA280 ('RADII BONDS')
C * LIST ARU (PLATON)
            CASE (10)
              IF (MENUH == 1) THEN
                CALL PLA280 ('LIST ARU')
                LRET = 2
              ELSE
                WRITE (BCD, 99997, IOSTAT = IOST)
     1            (PAR(J), J = 113, 115),
     2            (ACOS (PAR(J)) * RGBL(6), J = 116, 118), PAR(17),
     3            CHAR (0)
                CALL GGIP (-999.0, 5.0 + FLOAT (IGBL(68)), 80.0, 111)
                LRET = -1
              END IF
C * SET FCF-CALC FOR BIJVOET ETC
            CASE (12)
              IPR(594) = MOD (IPR(594) + 1, 2)
              LRET = -1
C * HELENA-RR#
            CASE (15)
              CALL PLA280 ('RR 2')
C * WRITE DIRECTION COSINES
            CASE (11, 16)
              IPR(445) = MOD (IPR(445) + 1, 2)
              LRET = -1
C * SYSTEM-S
            CASE (17)
              WRITE (IGGT(1:16), 99992, IOSTAT = IOST) MENUH - 1
C * SYSTEM-S/SUB VALID CHECK
            CASE (18)
              IGBL(34) = MOD (IGBL(34) + 1, 2)
C * VERT-ANG-SIZE
            CASE (22)
              PAR(273) = MENUH * 5.0
              PAR(272) = 4.0 * PAR(273) / 3.0
              CALL PLA280 ('SCAL')
C * SELECT VOID
            CASE (24)
              IPR(531) = MENUH - 1
C * TwinPLOT Resolution
            CASE (25)
              PAR(449) = MENUH * 0.1
              CALL PLA280 ('RESOLUTION')
C * Bijvoet Dif Dif/Sig versus FOK
            CASE (29)
              CALL PLA280 ('SET IPR 656 -2')
C * POLY/SHADE
            CASE (30)
              IPR(358) = MOD (IPR(358) + 1, 2)
              LRET = 3
C * NSOLVE
            CASE (31)
              WRITE (IGGT, 99973, IOSTAT = IOST) MENUH
C * MU MoKa
            CASE (33)
              CALL PLA280 ('MU 0.71073')
            CASE DEFAULT
              LRET = -1
          END SELECT
C * MENU BOX # 13
        CASE (13)
C * LOOP OVER MENUS
          SELECT CASE (MMODE)
C * LABPOS ON/OFF
            CASE (1)
              CALL PLA015 (349, 1)
              IPR(311) = 0
              IPR(327) = 0
              IPR(328) = 0
              IPR(351) = 0
              LRET     = -1
C * UNIT ON/OFF
            CASE (2)
              IF (IPR(46) == 0) THEN
                CALL PLA280 ('UNIT ON')
              ELSE
                CALL PLA280 ('UNIT OFF')
              END IF
C * PLUTON - ZOOM FACTOR
            CASE (3)
              IPR(130) = 0
              PAR(13)  = 0.4 + MENUH * 0.5
              CALL PLA280 ('PLOT')
C * RESOLUTION
            CASE (4)
              IPR(111) = 2 ** (4 - MENUH)
              PAR(5)   = 1.0 / (3.33333 ** MENUH)
C * VIEW BISECT
            CASE (5)
              IFL(1) = 'VIEW '
              IFL(2) = 'BISECT '
              CALL PLA015 (329, 3)
              LRET = -1
C * LIST BONDS
            CASE (6)
              IPR(90) = 8
              CALL PLUT12
C * POVRAY RESOLUTION
            CASE (7)
              IGBL(123) = MENUH - 1
C * ELLIPS
            CASE (8)
              IPR(177) = MENUH - 1
              IPR(211) = 0
              LRET     = 3
C * LIST CELL/SYMM/ORTEP-SUP2
            CASE (9)
              IF (MENUH == 1) THEN
                WRITE (BCD, 99998, IOSTAT = IOST) PAR(17),
     1           (PAR(J), J = 101, 106), PAR(98), CHAR (0)
                CALL GGIP (-999.0, 5.0 + FLOAT (IGBL(68)), 80.0, 111)
                LRET = -1
              ELSE
                CALL PLA274
                CALL GEN038 (ICL, 1, 80)
                LRET = 4
              END IF
C * LIST CELL/SYMM
            CASE (10)
              IF (MENUH == 1) THEN
                IF (PAR(98) == 1.0) CALL PLA100
                WRITE (BCD, 99998, IOSTAT = IOST) PAR(17),
     1            (PAR(J), J = 101, 106), PAR(98), CHAR (0)
                CALL GGIP (-999.0, 5.0 + FLOAT (IGBL(68)), 80.0, 111)
                LRET = -1
              ELSE
                 CALL PLA280 ('LIST SYMM')
              LRET = 2
             END IF
C * NO-CHECK DIRECTION COSINES
            CASE (11)
              IPR(363) = MOD (IPR(363) + 1, 2)
              LRET = -1
C * TIFF/PNG TOGGLE
            CASE (12)
              IGBL(109) = MOD (IGBL(109) + 1, 2)
              LRET = -1
C * ASYM MISSED REFL
            CASE (14)
              IPR(369) = MOD (IPR(369) + 1, 2)
              IPR(389) = 0
              LRET     = 4
C * HELENA-RR#
            CASE (15)
              CALL PLA280 ('RR 3')
C * NO-CHECK DIRECTION COSINES
            CASE (16)
              IPR(363) = MOD (IPR(363) + 1, 2)
              LRET = -1
C * SYSTEM-S TWINROTMAT
            CASE (17)
              CALL PLA280 ('TWINMAT')
C * SEARCH CSD
            CASE (18)
              CALL PLA280 ('PLATON CSD')
C * VERT-SHIFT
            CASE (22)
              IF (MENUH > 3) THEN
                DELTA = (MENUH - 3) * 0.5
              ELSE
                DELTA = (MENUH - 4) * 0.5
              END IF
              PAR(274) = PAR(274) + DELTA * COS (PAR(276) / RGBL(6))
              PAR(275) = PAR(275) + DELTA * SIN (PAR(276) / RGBL(6))
              CALL PLA280 ('SCAL')
C * UNITCELL SOLV PLOT
            CASE (24)
              IPR(527) = MOD (IPR(527) + 1, 2)
C * TOGGLE ICALC (FROMCIF/FROMFCF)
            CASE (25)
              IPR(608) = MOD (IPR(608) + 1, 2)
              CALL PLA280 ('FROM')
C * PP-BIJVOET
            CASE (29)
              IPR(652) = MENUH - 1
              CALL PLA280 ('NPP')
C * POLY UNITCELL ON/OFF
            CASE (30)
              IPR(357) = MOD (IPR(357) + 1, 2)
              LRET = 3
C * DELTA
            CASE (31)
              WRITE (IGGT, 99972, IOSTAT = IOST) MENUH * 0.01
C * MU AgKa
            CASE (33)
              CALL PLA280 ('MU 0.56086')
            CASE DEFAULT
              LRET = -1
          END SELECT
C * MENU BOX # 14
        CASE (14)
C * LOOP OVER MENUS
          SELECT CASE (MMODE)
C * SET LABEL SIZE
            CASE (1)
              PAR(349) = 0.20 + MENUH * 0.05
              IPR(201) = 0
              LRET = 3
C * ARU NONE # (PLOT RESIDUE #)
            CASE (2, 3, 5, 6)
              IF (MENUH == 1) THEN
                CALL PLA280 ('ARU RESTORE')
              ELSE
                WRITE (IGGT(1:14), 99971, IOSTAT = IOST) MENUH - 1
              END IF
              IPR(140) = MENUH - 1
            CASE (4)
              IF (IPR(63) == 0) THEN
                CALL PLA280 ('LABEL ARU')
              ELSE
                CALL PLA280 ('UNLABEL ARU')
              END IF
C * PLUTON BOX RATIO
            CASE (7)
              IF (MENUH == 1) THEN
                PAR(18) = SIGN (1.0, PAR(18))
              ELSE
                PAR(18) = SIGN (1.333, PAR(18))
              END IF
C * ENVELOPE
            CASE (8)
              IPR(211) = 1
              LRET     = 3
C * LIST ATOMS/UIJ
            CASE (9)
              IF (MENUH == 1) THEN
                CALL PLA280 ('LIST ATOMS')
              ELSE
                CALL PLA280 ('LIST UEQ')
              END IF
C * LIST ATOMS
            CASE (10)
C * TEST FOR PREVIOUS CALC UNIQUE (NO = 0)
              IF (IPR(30) == 0) THEN
C * SET UP CONNECTED SET
                CALL PLA067
                IF (IPR(2) /= 0) RETURN
              END IF
              IPR(220) = 2
              IPR(221) = 0
              CALL PLA073 (1, 1)
C * NOSORT
            CASE (11)
C * TEST FOR PREVIOUS CALC UNIQUE (NO = 0)
              IF (IPR(30) == 0) IGBL(33) = MOD (IGBL(33) + 1, 2)
              LRET = -1
C * Refl List
            CASE (12)
              IGBL(57) = MOD (IGBL(57) + 1, 2)
              LRET = -1
C * (0/1) DISPLAY 'E' IN ASYM VIEW
            CASE (14)
              IPR(776) = MOD (IPR(776) + 1, 2)
              LRET = 4
C * HELENA-RR#
            CASE (15)
              CALL PLA280 ('RR 4')
C * CELL DIMENSION PLOT (ABSORB)
            CASE (16)
              IPR(331) = MOD (IPR(331) + 1, 2)
C * SYSTEM-S
            CASE (17)
              IF (MENUH == 1) THEN
                CALL PLA280 ('HDIF')
              ELSE
                CALL PLA280 ('HFIX')
                IF (IPR(351) == 1) CALL PLA015 (351, 1)
              END IF
C * RPLUTO
            CASE (18)
              CALL PLA280 ('RPLUTO')
C * HORIZONTAL SHIFT
            CASE (22)
              IF (MENUH > 3) THEN
                DELTA = (MENUH - 3) * 0.5
              ELSE
                DELTA = (MENUH - 4) * 0.5
              END IF
              PAR(275) = PAR(275) + DELTA * COS (PAR(276) / RGBL(6))
              PAR(274) = PAR(274) - DELTA * SIN (PAR(276) / RGBL(6))
              CALL PLA280 ('SCAL')
C * SOLV SHOW MOL PLOT
            CASE (24)
              IPR(528) = MOD (IPR(528) + 1, 2)
            CASE (25)
C * Poly: InclAtoms
            CASE (30)
              IPR(359) = MOD (IPR(359) + 1, 2)
              LRET     = 3
C * PERC
            CASE (31)
              WRITE (IGGT, 99970, IOSTAT = IOST) MENUH * 0.05
C * I-OR-F
            CASE (32)
              IPR(711) = MOD (IPR(711) + 1, 2)
C * MU InKa
            CASE (33)
              CALL PLA280 ('MU 0.51359')
            CASE DEFAULT
              LRET = -1
          END SELECT
C * MENU BOX # 15
        CASE (15)
C * LOOP OVER MENUS
          SELECT CASE (MMODE)
C * DELETE LABEL (ON/OFF)
            CASE (1)
              CALL PLA015 (327, 1)
              IPR(440) = 0
              IPR(349) = 0
              IPR(328) = 0
              LRET = -1
C * JOIN HBONDS
            CASE (2)
              IF (MENUH == 1) THEN
                CALL PLA280 ('JOIN RADII INTER HBONDS')
              ELSE
                CALL PLA280 ('JOIN RADII INTER XBONDS')
              END IF
C * HFIX - ANIS
            CASE (3)
C * TEST FOR TYPE RES FILE
              IF (IABS(IGBL(8)) == 2) THEN
C * CASE HFIX
                IF (MENUH == 1) THEN
                  IF (IPR(351) == 1) CALL PLA015 (351, 1)
                  IF (IPR(335) == 1) CALL PLA015 (335, 1)
                  CALL PLA015 (332, 1)
                  IF (IGBL(75) == 0) THEN
                    CALL PLA280 ('LABEL ON')
                  ELSE
                    LRET = -1
                  END IF
C * CASE ANIS
                ELSE IF (MENUH == 2) THEN
                  CALL PLA015 (352, 1)
                  IF (IGBL(3) == 26) LRET = -1
                END IF
              ELSE
                IF (MENUH == 1) THEN
                  CALL PLA015 (427, 30)
                ELSE
                  CALL PLA015 (427, 44)
                END IF
                LRET = -1
              END IF
C * (UN)LABEL UNITCELL
            CASE (4)
              IF (IPR(339) == 0) THEN
                CALL PLA280 ('LABEL UNIT')
                IPR(46) = 1
              ELSE
                CALL PLA280 ('UNLABEL UNIT')
              END IF
C * POVRAY-STYLE
            CASE (7)
              IGBL(101) = MENUH - 1
              CALL PLA280 ('PLOT POV')
              IPR (340) = 1
              IGBL(98)  = 0
C * OCTANT
            CASE (8)
              IPR(177) = MENUH - 1
              IPR(211) = 2
              LRET = 3
C * LIST FLAGS/RADII
            CASE (9)
              IF (MENUH == 1) THEN
                CALL PLA280 ('LIST FLAGS')
              ELSE
                CALL PLA280 ('LIST RADII')
              END IF
C * LIST BONDS
            CASE (10)
C * TEST FOR PREVIOUS CALC UNIQUE (NO = 0)
              IF (IPR(30) == 0) THEN
C * SET UP CONNECTED SET
                CALL PLA067
                IF (IPR(2) /= 0) RETURN
              END IF
              IPR(220) = 2
              IPR(221) = 0
              CALL PLA074 (2, 1)
C * BOND-VALENCE
            CASE (11)
              IGBL(121) = MOD (IGBL(121) + 1, 2)
              LRET = -1
C * DEBUG TOGGLE
            CASE (12)
              IGBL(74) = MOD (IGBL(74) + 1, 2)
              LRET = -1
C * ASYM MULTISCAN
            CASE (14)
              IPR(468) = MOD (IPR(468) + 1, 2)
              LRET     = 3
C * HELENA-RR#
            CASE (15)
              CALL PLA280 ('RR 5')
C * XTAL AXES PLOT
            CASE (16)
              IPR(388) = MOD (IPR(388) + 1, 2)
C * SYSTEM-S
            CASE (17)
              WRITE (IGGT(1:16), 99991, IOSTAT = IOST) MENUH - 1
C * SYSTEM-S/SUB1
            CASE (18)
              CALL PLA280 ('CONTOUR PT')
C * DEBUG TOGGLE
            CASE (19)
              IGBL(74) = MOD (IGBL(74) + 1, 2)
              LRET = -1
C * +/- ROTATION
            CASE (22)
              IF (MENUH > 3) THEN
                ZROT = (MENUH - 3) * 30.0
              ELSE
                ZROT = (MENUH - 4) * 30.0
              END IF
              WRITE (IGGT, 99990, IOSTAT = IOST) ZROT
C * SOLV OHASHI VOLUME PLOT
            CASE (24)
              IPR(529) = MOD (IPR(529) + 1, 2)
              LRET     = 4
C * TWINROTMAT ZONE-H,K,L
            CASE (25)
              IPR(394) = MENUH
              CALL PLA280 ('ZONE')
C * APPLY SLOPE
            CASE (29)
              IPR(593) = MOD (IPR(593) + 1, 2)
              CALL PLA280 ('SLOPE')
C * UNIT LABEL (ON/OFF)
            CASE (30)
              IPR(339) = MOD (IPR(339) + 1, 2)
              LRET = 3
C * UISO
            CASE (31)
              WRITE (IGGT, 99976, IOSTAT = IOST) (MENUH - 1) * 0.01
C * ANAL-OF-VAR - SCATTER PLOT
            CASE (32)
              CALL PLA280 ('SCATTER')
C * FCF-COMPARE  - SCATTER PLOT
            CASE (34)
              CALL PLA280 ('SCATTER')
            CASE DEFAULT
              LRET = -1
          END SELECT
C * MENU BOX # 16
        CASE (16)
C * LOOP OVER MENUS
          SELECT CASE (MMODE)
C * INCLUDE LABEL
            CASE (1)
              CALL PLA015 (328, 1)
              IGBL(75) = 1
              IPR(440) = 0
              IPR(349) = 0
              IPR(327) = 0
            CASE (2)
C * ARU-UNIQUE/PACKRANGE
              MNH(7) = MENUH
              IF (MENUH == 1) THEN
                CALL PLA280 ('ARU NONE 1555')
              ELSE IF (MENUH == 2) THEN
                CALL PLA280 ('ARU UNIQUE')
              ELSE
                WRITE (IGGT(1:46), 99969, IOSTAT = IOST)
     1            0.45 - DX, 0.55 + DX, 0.45 - DX, 0.55 + DX,
     2            0.45 - DX, 0.55 + DX
              END IF
C * VIEW MIN MENU-OPTION (PLUTON)
            CASE (3)
              IF (MENUH == 1) THEN
                CALL PLA280 ('VIEW UNIT')
              ELSE IF (MENUH == 2) THEN
                CALL PLA280 ('VIEW MIN')
              ELSE IF (MENUH == 3) THEN
                CALL PLA280 ('VIEW XO')
              ELSE IF (MENUH == 4) THEN
                CALL PLA280 ('VIEW YO')
              ELSE IF (MENUH == 5) THEN
                CALL PLA280 ('VIEW ZO')
              END IF
              MNH(6) = MENUH
C * (UN)LABEL ATOM
            CASE (4)
              IF (IPR(452) == 0) THEN
                CALL PLA280 ('LABEL ATOM')
              ELSE
                CALL PLA280 ('UNLABEL ATOM')
              END IF
C * PLUTON PARENTHESES
            CASE (7)
              IPR(71) = MOD (IPR(71) + 1, 2)
C * ORTEP/PARENTHESES
            CASE (8)
              IF (IPR(759) == 0) THEN
                IPR(350) = MOD (IPR(350) + 1, 2)
                IPR(201) = 0
                LRET     = 4
              ELSE
                LRET = -1
              END IF
C * LIST ARU
            CASE (9)
              LRET = 1
              CALL PLA280 ('LIST ARU')
C * LIST UIJ
            CASE (10)
              LRET = 2
              CALL PLA280 ('LIST UIJ')
C * RESD SORT TOGGLE
            CASE (11)
              IPR(597) = MOD (IPR(597) + 1, 2)
C * SET WINDOW SIZE
            CASE (12)
              IGBL(62) = MENUH
              WRITE (IGGT, 99988, IOSTAT = IOST) IGBL(62) / 4.0
              LRET = 2
C * ASYM OBS/CALC/DELTA
            CASE (14)
              IPR(132) = MENUH - 1
              LRET = 3
C * HELENA-RR#
            CASE (15)
              CALL PLA280 ('RR 6')
C * XTAL VERTEX LABELS  PLOT
            CASE (16)
              IGBL(75) = MOD (IGBL(75) + 1, 2)
C * SYSTEM-S
            CASE (17)
              WRITE (IGGT(1:17), 99989, IOSTAT = IOST)  MENUH - 1
C * SYSTEM-S/SUB1
            CASE (18)
              CALL PLA280 ('CONTOUR DF')
C * BONDS IN CONTOUR
            CASE (22)
              CALL PLA015 (458, 1)
              LRET = 2
C * SOLV LABEL UNITCELL
            CASE (24)
              IPR(532) = MOD (IPR(532) + 1, 2)
C * TWINROTMAT UP/DOWN
            CASE (25)
              IF (MENUH == 1) THEN
                IPR(389) = 1
              ELSE
                IPR(389) = -1
              END IF
              CALL PLA280 ('NEXT')
C * POLY PACK RANGE
            CASE (30)
              IF (MENUH > 1) THEN
                IPR(354) = MENUH - 1
              ELSE
                IPR(354) = -1
              END IF
              LRET = 3
C * LOGLOG/LINEAR PLOT
            CASE (32)
              IF (IPR(633) == 0) THEN
                CALL PLA280 ('LOGLOG')
              ELSE IF (IPR(633) == 1) THEN
                CALL PLA280 ('LINEAR')
              END IF
C * FCF-COMPARE, LOGLOG/LINEAR PLOT
            CASE (34)
              IF (IPR(633) == 0) THEN
                CALL PLA280 ('LOGLOG')
              ELSE IF (IPR(633) == 1) THEN
                CALL PLA280 ('LINEAR')
              END IF
            CASE DEFAULT
             LRET = -1
          END SELECT
C * MENU BOX # 17
        CASE (17)
C * LOOP OVER MENUS
          SELECT CASE (MMODE)
C * PLOT ADP RESD (0,1,2...)
            CASE (1, 8, 9)
              IPR(140) = MENUH - 1
              IPR(201) = 0
              LRET     = 4
C * LABEL ON/OFF
            CASE (2, 3, 4, 5, 6)
              IF (IGBL(75) == 1) THEN
                IF (MENUH /= IPR(232) + 1) IGBL(75) = 0
              END IF
              IF (MENUH == 2) THEN
                IPR(232) = 1
              ELSE
                IPR(232) = 0
              END IF
              IF (IGBL(75) == 0) THEN
                CALL PLA280 ('LABEL ON')
              ELSE
                CALL PLA280 ('LABEL OFF')
              END IF
C * PORTRAIT MODE
            CASE (7)
              CALL PLA280 ('PORTRAIT')
C * EXCLUDE H (TO BE REQUESTED PRIOR TO CALC INTRA)
            CASE (10)
C * TEST FOR PREVIOUS CALC UNIQUE (NO = 0)
              IF (IPR(30) == 0) THEN
                IPR(605) = 1
                CALL PLA280 ('EXCLUDE H')
                LRET = 2
              END IF
C * DEF COORDN RADIUS
            CASE (11)
              PAR(7) = 2.0 + MENUH
              WRITE (BCD, 99977, IOSTAT = IOST) PAR(7), CHAR (0)
              CALL GGIP (-999.0, 5.0 + FLOAT (IGBL(68)), 80.0, 111)
              LRET = -1
C * RATIO/PORTRAIT
            CASE (12)
              CALL PLA280 ('PORTRAIT')
              LRET = 2
C * CREMER&POPLE
            CASE (13)
              CALL PLA280 ('CANDP')
C * HELENA-RR#
            CASE (15)
              CALL PLA280 ('RR 7')
C * XTAL PLOT-SCALE
            CASE (16)
              PAR(325) = 1.0 + (MENUH - 1) * 0.25
C * SYSTEM-S
            CASE (17)
              IF (MENUH == 1) THEN
                CALL PLA280 ('PLUTON')
              ELSE
                CALL PLA280 ('RENAME')
              END IF
C * SYSTEM-S/SUP1
            CASE (18)
              CALL PLA280 ('CONTOUR FO')
C *SIRWINDOW
            CASE (19)
              IGBL(122) = MOD (IGBL(122) + 1, 2)
              LRET = -1
C * CONTOUR
            CASE (22)
              IF (MENUH == IPR(232) + 1)
     1          IGBL(75) = MOD (IGBL(75) + 1, 2)
              IF (MENUH == 2) THEN
                IPR(232) = 1
                IPR(201) = 0
              ELSE
                IPR(232) = 0
              END IF
              LRET = 2
C * SOLV LABELS (ON/OFF)
            CASE (24)
              IF (MENUH == IPR(232) + 1)
     1          IGBL(75) = MOD (IGBL(75) + 1, 2)
              IF (MENUH == 2) THEN
                IPR(232) = 1
              ELSE
                IPR(232) = 0
              END IF
C * RacemicTwin
            CASE (25)
              IPR(575) = MOD (IPR(575) + 1, 2)
              LRET = -1
C * STUDENT-T
            CASE (29)
              IPR(613) = 1
              PAR(488) = 0.0
              IPR(617) = 1
              CALL PLA280 ('SWITCH')
C * POPY OMIT OUTSIDE
            CASE (30)
              IPR(356) = MOD (IPR(356) + 1, 2)
              LRET = 2
C * STANDARD DEVIATION TOGGLE
            CASE (32)
              IPR(634) = MOD (IPR(634) + 1, 2)
               CALL PLA280 ('STANDARD')
            CASE DEFAULT
             LRET = -1
          END SELECT
C * MENU BOX # 18
        CASE (18)
C * LOOP OVER MENUS
          SELECT CASE (MMODE)
            CASE (1)
C * CROTY
              IPR(479) = 2
C * ROTATION ANGLE STEP
              PAR(389) = ANGC
C * RECALCULATE LABEL POSITION
              IPR(201) = 0
              LRET     = 6
            CASE (2, 3)
              WRITE (IGGT(1:20), 99986, IOSTAT = IOST) ANGC
C * DEFINE (PLUTON)
            CASE (4)
              IF (MENUH == 1) THEN
                IFL(1) = 'DEFINE'
                IFL(2) = 'CG'
                LMOD   = 2
C * SET DEFINE STATUS
                IPR(507) = 1
C * ISSUE INFO MESSAGE
                CALL PLA015 (508, 2)
                LRET = -1
              ELSE IF (MENUH == 2) THEN
                IF (IPR(508) == 2) THEN
C * SET DEFINE STATUS
                  IPR(507) = 2
                  IPR(508) = 0
                  WRITE (IGGT, 99995, IOSTAT = IOST)
     1              (IFL(I)(1:7), I = 1, LMOD)
                  IGBL(6) = IABS (IGBL(6))
                END IF
              END IF
C * ENTRY
            CASE (6)
              CALL PLA280 ('ENTRY')
C * REVERSE B&W
            CASE (7)
              WRITE (IGGT, 99987, IOSTAT = IOST)
C * RADII BONDS Normal (LINES)
            CASE (8)
              PAR(85) = MENUH
              LRET    = 4
C * REVERSE B&W
            CASE (9)
              WRITE (IGGT, 99987, IOSTAT = IOST)
C * Min-Q-Peak Height
            CASE (10)
              IF (IABS(IGBL(8)) == 2) THEN
                RGBL(26) = MENUH  * 0.20
                WRITE (BCD, 99979, IOSTAT = IOST)
     1            RGBL(26), RGBL(27), CHAR (0)
                CALL GGIP (-999.0, 5.0 + FLOAT (IGBL(68)), 80.0, 111)
              END IF
              LRET = -1
C * UisoHRadius toggle
            CASE (11)
              IPR(603) = MOD (IPR(603) + 1, 2)
              LRET     = -1
C * GenerSthlMx
            CASE (12)
              IWIN = 1
              PAR(540) = 0.45 + MENUH * 0.05
              IPR(221) = 1
              FN(1)    = 540
              CALL PLA206 (-1, 'PAR')
              LRET = -1
C * PLOT ADP COLOR
            CASE (13)
              IGBL(6) = 1
              CALL PLA280 ('PLOT ADP COLOR')
C * ASYM UP/DOWN
            CASE (14)
              IF (MENUH == 1) THEN
                IPR(389) = 1
              ELSE
                IPR(389) = -1
              END IF
              LRET = 4
C * HELENA-RR#
            CASE (15)
              CALL PLA280 ('RR 8')
C * ABSCOR/XTAL
            CASE (16)
              WRITE (IGGT(1:20), 99985, IOSTAT = IOST) ANGC
C * SYSTEM-S
            CASE (17)
              IF (MENUH == 1) THEN
                CALL PLA280 ('PLATON')
              ELSE
                CALL PLA280 ('PLATON ADP')
              END IF
C * SYSTEM-S/SUB1
            CASE (18)
              CALL PLA280 ('CONTOUR SQ')
C * REVERSE B&W
            CASE (19)
              WRITE (IGGT, 99987, IOSTAT = IOST)
C * CPI-FILE
            CASE (21)
              IPR(650) = MOD (IPR(650) + 1, 2)
              LRET     = 3
C * CONTOUR GRID STEP
            CASE (22)
              PAR(278)  = 0.1 * MENUH
              LRET = 2
C * CONTOUR GRID STEP
            CASE (23)
              PAR(278) = 0.1 * MENUH
              LRET = 2
C * SET LABEL SIZE
            CASE (24)
              PAR(349) = 0.20 + MENUH * 0.05
C * SelectTwinMatrix#1
            CASE (25)
              IPR(571) = MOD (IPR(571) + 1, 2)
              LRET = -1
C * ListDetails
            CASE (26)
              IPR(566) = MOD (IPR(566) + 1, 2)
              LRET     = -1
C * GAUSSIAN
            CASE (29)
              IPR(613) = 0
              PAR(488) = 0.0
              IPR(617) = 1
              CALL PLA280 ('SWITCH')
            CASE DEFAULT
              LRET = -1
          END SELECT
C * MENU BOX # 19
        CASE (19)
C * LOOP OVER MENUS
          SELECT CASE (MMODE)
C * ROTZ
            CASE (1, 9)
              IPR(479) = 3
              IF (MENUH > 5) THEN
                PAR(389)  = 2 ** (MENUH - 6)
              ELSE
                PAR(389)  =  - 2 ** (5 - MENUH)
              END IF
              IPR(201) = 0
              LRET     = 2
C * X-LineWidth
            CASE (7)
              IGBL(69) = MOD (IGBL(69) + 1, 2)
              YGGIP    = - 100 * (IGBL(69) + 1)
              CALL GGIP (0.0, YGGIP, 0.0, 0)
C * RADII BONDS to Metal (LINES)
            CASE (8)
              PAR(89) = MENUH
              LRET    = 4
C * Min-Q-Peak Dis
            CASE (10)
              IF (IABS (IGBL(8)) == 2) THEN
                RGBL(27) = (MENUH - 1) * 0.25
                WRITE (BCD, 99979, IOSTAT = IOST)
     1            RGBL(26), RGBL(27), CHAR (0)
                CALL GGIP (-999.0, 5.0 + FLOAT (IGBL(68)), 80.0, 111)
              END IF
              LRET = -1
C * INCL C-H ..X
            CASE (11)
              IPR(645) = MOD (IPR(645) + 1, 2)
C * GenerRandom
            CASE (12)
              IPR(647) = MOD (IPR(647) + 1, 2)
C * NEWMAN PLOT
            CASE (13)
              IPR(55) = -1
              CALL PLA280 ('YES')
C * HELENA-RR#
            CASE (15)
              CALL PLA280 ('RR 9')
C * ROTZ
            CASE (16)
              IF (MENUH > 5) THEN
                IANG  = 2 ** (MENUH - 6)
              ELSE
                IANG  =  - 2 ** (5 - MENUH)
              END IF
              WRITE (IGGT(1:9), 99996, IOSTAT = IOST) 'Z', IANG
C * SYSTEM-S
            CASE (17)
              IF (MENUH == 1) THEN
                CALL PLA280 ('INVERT')
              ELSE
                CALL PLA280 ('HFREE')
              END IF
C * ANIS
            CASE (19)
              IF (MENUH == 1) THEN
                CALL PLA280 ('ANIS')
              ELSE IF (MENUH == 2) THEN
 
              END IF
C * LISTREFL (POWDER)
            CASE (21)
              CALL PLA280 ('LIST')
C * CONTOUR STEP
            CASE (22)
              IPR(419)  = NINT (2.5 * 2 ** MENUH)
              LRET = 2
C * SOLV ROTZ
            CASE (24)
              IPR(479) = 3
              IF (MENUH > 5) THEN
                PAR(389) = 2 ** (MENUH - 6)
              ELSE
                PAR(389) =  - 2 ** (5 - MENUH)
              END IF
              LRET = 3
C * SelectTwinMatrix#2
            CASE (25)
              IPR(572)  = MOD (IPR(572) + 1, 2)
              LRET      = -1
C * ADDSYM PART#
            CASE (26)
              IF (MENUH == 1) THEN
                CALL PLA280 ('CALC ADDSYM PART 1')
              ELSE IF (MENUH == 2) THEN
                CALL PLA280 ('CALC ADDSYM PART 2')
              END IF
C * Hooft NU VALUE (Manual)
            CASE (29)
              IPR(613) = 1
              IPR(617) = 0
              PAR(488) = MENUH * 5
              CALL PLA280 ('NUVAL')
C * POLY ROTZ
            CASE (30)
              IF (MENUH > 5) THEN
                IANG  = 2 ** (MENUH - 6)
              ELSE
                IANG  =  - 2 ** (5 - MENUH)
              END IF
              WRITE (IGGT(1:9), 99996, IOSTAT = IOST) 'Z', IANG
            CASE DEFAULT
              IF (MENUH > 5) THEN
                IANG  = 2 ** (MENUH - 6)
              ELSE
                IANG  =  - 2 ** (5 - MENUH)
              END IF
              WRITE (IGGT(1:18), 99984, IOSTAT = IOST) IANG
          END SELECT
C * MENU BOX # 20
        CASE (20)
C * LOOP OVER MENUS
          SELECT CASE (MMODE)
C * ROTY
            CASE (1, 9)
              IPR(479) = 2
              IF (MENUH > 5) THEN
                PAR(389)  = 2 ** (MENUH - 6)
              ELSE
                PAR(389)  =  - 2 ** (5 - MENUH)
              END IF
              IPR(201) = 0
              LRET     = 2
C * SET Q-PEAK DELETE CRIT (PLUTON)
            CASE (7)
              RGBL(25) = (MENUH - 1) * 0.25
              CALL PLA280 ('RESET')
C * RADII BONDS ALL
            CASE (8)
              PAR(86) = MENUH * 0.01
              PAR(88) = MENUH * 0.01
              PAR(90) = MENUH * 0.01
              LRET = 4
C * Q-Peak-Include
            CASE (10)
              IF (MENUH == 1) THEN
                IGBL(95) = MOD (IGBL(95) + 1, 2)
                RGBL(25) = RGBL(27)
              ELSE IF (MENUH == 2) THEN
                IGBL(95) = 1
              END IF
              CALL PLA280 ('RESTART')
              LRET = 2
C * SET Q-PEAK DELETE CRIT
            CASE (11)
              IF (IABS(IGBL(8)) == 2) THEN
                RGBL(25) = (MENUH - 1) * 0.25
                CALL PLA280 ('RESTART')
                LRET = 2
              ELSE
                LRET = -1
              END IF
C * SET META ...
            CASE (12)
              MNH(12) = MENUH
              IF (MENUH == 1) THEN
                CALL PLA280 ('SET META PS')
              ELSE IF (MENUH == 2) THEN
                CALL PLA280 ('SET META HPGL')
              END IF
              LRET = 2
C * RING PLOT
            CASE (13)
              IPR(55) = 2
              CALL PLA280 ('YES')
C * ROTY
            CASE (16)
              IF (MENUH > 5) THEN
                IANG  = 2 ** (MENUH - 6)
              ELSE
                IANG  =  - 2 ** (5 - MENUH)
              END IF
              WRITE (IGGT(1:9), 99996, IOSTAT = IOST) 'Y', IANG
C * SYSTEM-S
            CASE (17)
              IF (MENUH == 1) THEN
                CALL PLA280 ('ASYM')
              ELSE
                CALL PLA280 ('ASYM VIEW')
              END IF
            CASE (18)
              CALL PLA280 ('BROWSE PS')
            CASE (19)
              LRET = -1
C * POWDER DISPL Q-VALUES
            CASE (21)
              IPR(649) = MOD (IPR(649) + 1, 2)
              IPR(569) = 0
              IPR(570) = 0
              LRET     = 3
C * DEFINE CONTOUR LEVEL STEP
            CASE (22)
              STRING(1:3) = 'CL '
              NCNT = 3
              SBCD = STRING(1:NCNT)//CHAR (0)
              LRET = -1
C * SOLV ROTY
            CASE (24)
              IPR(479) = 2
              IF (MENUH > 5) THEN
                PAR(389) = 2 ** (MENUH - 6)
              ELSE
                PAR(389) =  - 2 ** (5 - MENUH)
              END IF
              LRET = 3
C * SelectTwinMatrix#3
            CASE (25)
              IPR(573)  = MOD (IPR(573) + 1, 2)
              LRET = -1
C * ADDSYM EQUAL
            CASE (26)
              CALL PLA280 ('CALC ADDSYM EQUAL')
C * ROTY
            CASE (30)
              IF (MENUH > 5) THEN
                IANG  = 2 ** (MENUH - 6)
              ELSE
                IANG  =  - 2 ** (5 - MENUH)
              END IF
              WRITE (IGGT(1:9), 99996, IOSTAT = IOST) 'Y', IANG
C * REDUCED CELL TOGGLE
            CASE (34)
              CALL PLA280 ('REDUCED')
            CASE DEFAULT
              IF (MENUH > 5) THEN
                IANG  = 2 ** (MENUH - 6)
              ELSE
                IANG  =  - 2 ** (5 - MENUH)
              END IF
              WRITE (IGGT(1:18), 99983, IOSTAT = IOST) IANG
          END SELECT
C * MENU BOX # 21
        CASE (21)
C * LOOP OVER MENUS
          SELECT CASE (MMODE)
C * ROTX
            CASE (1, 9)
              IPR(479) = 1
              IF (MENUH > 5) THEN
                PAR(389)  = 2 ** (MENUH - 6)
              ELSE
                PAR(389)  =  - 2 ** (5 - MENUH)
              END IF
              IPR(201) = 0
              LRET     = 2
C * INCL ZOMBIE (DANGLING BONDS)
            CASE (7)
              IPR(166) = MOD (IPR(166) + 1, 2)
              IPR(130) = 0
              CALL PLA280 ('PLOT')
C * RADII BONDS NORMAL
            CASE (8)
              PAR(86) = MENUH * 0.01
              LRET = 4
C * KEYBOARD INSTRUCTION HELP
          CASE (10)
              CALL PLA280 ('HELP')
              LRET = 2
C * Auto-Plot
            CASE (12)
              IGBL(35) = MOD (IGBL(35) + 1, 2)
              LRET = -1
C * PLAN PLOT
            CASE (13)
              IPR(55) = 1
              CALL PLA280 ('YES')
C * ROTX
            CASE (16)
              IF (MENUH > 5) THEN
                IANG =   2 ** (MENUH - 6)
              ELSE
                IANG = - 2 ** (5 - MENUH)
              END IF
              WRITE (IGGT(1:9), 99996, IOSTAT = IOST) 'X', IANG
C * SYSTEM-S (SQUEEZE/FCF)
            CASE (17)
              IF (MENUH == 1) THEN
                CALL PLA280 ('SQUEEZE')
              ELSE
                CALL PLA280 ('FCF')
             END IF
C * SYSTEM-S/SUB LASER
            CASE (18)
              CALL PLA280 ('LASER')
C * NPEAKFMAP
            CASE (19)
              IGBL(124) = MENUH - 1
C * POWDER DISPL D-VALUES
            CASE (21)
              IPR(569) = MOD (IPR(569) + 1, 2)
              IPR(570) = 0
              IPR(649) = 0
              LRET     = 3
C * XR/YR/ZR ORTEP / OMIT SIG (0/1/2)
            CASE (22)
              IF (IPR(182) == 0) THEN
                CALL PLA280 ('OMIT')
                IPR(515) = MENUH - 1
              ELSE
                IPR(505) = MENUH
                IF (MENUH == 1) THEN
                  CALL PLA280 ('XROT 10')
                ELSE IF (MENUH == 2) THEN
                  CALL PLA280 ('YROT 10')
                ELSE
                  CALL PLA280 ('ZROT 10')
                END IF
              END IF
C * SOLV ROTX
            CASE (24)
              IPR(479) = 1
              IF (MENUH > 5) THEN
                PAR(389) = 2 ** (MENUH - 6)
              ELSE
                PAR(389) =  - 2 ** (5 - MENUH)
              END IF
              LRET = 3
C * SelectTwinMatrix#4
            CASE (25)
              IPR(574)  = MOD (IPR(574) + 1, 2)
              LRET = -1
C * ADDSYM ELEMENT
            CASE (26)
              IF (MENUH == 1) THEN
                NQ1 = ' '
              ELSE
                NQ1 = LMT(MENUH - 1, 1)
              END IF
              CALL PLA280 ('CALC ADDSYM '//NQ1)
C * POLY ROTX
            CASE (30)
              IF (MENUH > 5) THEN
                IANG =   2 ** (MENUH - 6)
              ELSE
                IANG = - 2 ** (5 - MENUH)
              END IF
              WRITE (IGGT(1:9), 99996, IOSTAT = IOST) 'X', IANG
C * STRUCTURE
            CASE (31)
              IPR(640) = MOD (IPR(640) + 1, 2)
            CASE DEFAULT
              IF (MENUH > 5) THEN
                IANG  =   2 ** (MENUH - 6)
              ELSE
                IANG  =  - 2 ** (5 - MENUH)
              END IF
              WRITE (IGGT(1:18), 99982, IOSTAT = IOST) IANG
          END SELECT
C * MENU BOX # 22
        CASE (22)
C * LOOP OVER MENUS
          SELECT CASE (MMODE)
C * LOOP OVER MENUS
C * ORTEP PREV/NEXT
            CASE (1)
              IGBL(58) = 0
              REWIND (UNIT = LU2, IOSTAT = IOST)
              IF (MENUH == 1) THEN
                IGBL(54) = MAX (1, IGBL(54) - 1)
                IF (IGBL(54) > 1) IGBL(58) = 1
                WRITE (IGGT, 99981, IOSTAT = IOST) IGBL(54)
              ELSE
                IF (IGBL(54) < IGBL(100)) THEN
                  IGBL(54) = MAX (1, MIN (IGBL(54) + 1, IGBL(100)))
                  WRITE (IGGT, 99981, IOSTAT = IOST) IGBL(54)
                ELSE
C * EXIT FROM 'SAVE'-LOOP
                  IGBL(45) = 0
                  CALL PLA280 ('REM')
                  IGBL(6) = 10
                  CALL GEN108 (LU3, 0)
                  WRITE (LU3, 99980, IOSTAT = IOST)
                  ENDFILE (LU3, IOSTAT = IOST)
                END IF
              END IF
C * EXCLUDE ARU
            CASE (3)
              CALL PLA015 (213, 1)
              IF (IPR(213) == 1) THEN
                IF (IPR(63) == 0) THEN
                  CALL PLA280 ('LABEL ARU')
                ELSE
                  LRET = -1
                END IF
              ELSE
                CALL PLA280 ('UNLABEL ARU')
              END IF
              IF (IGBL(35) == 0) LRET = -1
C * LRETCOLOR (ATOM-TYPE/RESD/ARU)
            CASE (2, 4, 5, 6)
              DO
                IPR(346) = MOD (IPR(346) + 1, 2)
                IF (IPR(346) == 1) THEN
                  IF (MENUH == 1) THEN
                    IPR(477) = 0
                  ELSE IF (MENUH == 2) THEN
                    IPR(477) = -1
                  ELSE
                    IPR(477) = 1
                  END IF
                ELSE
                  IF (MENUH * IPR(477) == -2 .OR.
     1              MENUH * IPR(477) == 3 .OR.
     2               (MENUH  == 1 .AND. IPR(477) == 0)) THEN
                    IPR(477) = 0
                  ELSE
                    CYCLE
                  END IF
                END IF
                IF (IGBL(35) == 1) THEN
                  CALL PLA280 ('PLOT')
                ELSE
                  LRET = -1
                END IF
                IF (NEXIT == 0) EXIT
              END DO
C * MolExpand  (On/OFF)
            CASE (7)
              IGBL(127) = MOD (IGBL(127) + 1, 2)
C * RADII BONDS To METAL
            CASE (8)
              PAR(90) = MENUH * 0.01
              LRET = 4
C * DISPLAY CSD-CIF LITERATURE REFERENCE
            CASE (9)
                IGBL(104) = MOD (IGBL(104) + 1, 2)
C * PREV/NEXT
            CASE (10)
              IGBL(58) = 0
              IF (MENUH == 1) THEN
                IGBL(54) = MAX (1, IGBL(54) - 1)
                IF (IGBL(54) > 1) IGBL(58) = 1
              ELSE IF (MENUH == 2) THEN
                IGBL(54) = MAX (1, MIN (IGBL(54) + 1, IGBL(100)))
              END IF
              IPR(220) = 0
              IPR(221) = 1
              FN(1) = IGBL(54)
              CALL PLA007
              IGBL(24) = 0
              CALL PLA280 ('END')
              LRET = 3
C * TOLM
            CASE (11)
C * TEST FOR PREVIOUS CALC UNIQUE (NO = 0)
              IF (IPR(30) == 0) PAR(27) = (MENUH - 3) * 0.2
              WRITE (BCD, 99978, IOSTAT = IOST) PAR(2), PAR(27),
     1          CHAR (0)
              CALL GGIP (-999.0, 5.0 + FLOAT (IGBL(68)), 80.0, 111)
              LRET = -1
C * X-LineWidth
            CASE (12)
              IGBL(69) = MOD (IGBL(69) + 1, 2)
              YGGIP = - 100 * (IGBL(69) + 1)
              CALL GGIP (0.0, YGGIP, 0.0, 0)
C * PLAN/NEWMAN/COLOR
            CASE (13)
              IPR(346) = MOD (IPR(346) + 1, 2)
              CALL PLA280 ('REF')
C * NEXT
            CASE (16)
              CALL PLA280 ('NEXT')
C * SYSTEM-S - ADDSYM-SHELX
            CASE (17)
              IF (MENUH == 1) THEN
                CALL PLA280 ('PLATON ADDSYM')
              ELSE
                CALL PLA280 ('PLATON SOLV')
              END IF
C * S/SUB-BROWSE
            CASE (18)
              IF (IGBL(43) == 1) IGBL(42) = 1
              IGBL(42) = MOD (IGBL(42) + 1, 2)
              IGBL(43) = 0
              CALL PLA280 ('BROWSE LPS')
C * S/SHELXL (CGLS)
            CASE (19)
              CALL PLA280 ('CGLS')
C * POWDER DISPL THETA-VALUES
            CASE (21)
              IPR(570) = MOD (IPR(570) + 1, 2)
              IPR(569) = 0
              IPR(649) = 0
              LRET     = 3
C * CONTOUR OMIT FROM SFC
            CASE (22)
              IF (IPR(415) > 0) THEN
                IPR(182) = MOD (IPR(182) + 1, 2)
                IF (IGBL(25) * IGBL(32) == 1) THEN
                  IF (IPR(182) /= 0) THEN
                    BCD =
     1               'Click on Unique Atoms to be Omitted'//CHAR (0)
                    CALL GGIP (-999.0, 5.0 + FLOAT (IGBL(68) * IGBL(82))
     1                   , 30.0, 110)
                    CALL GGIP (0.0, 0.0, 0.0, 6)
                    LRET = -1
                  ELSE
                    LRET = 2
                  END IF
                END IF
              ELSE
                LRET = -1
              END IF
C * SOLV COLOR
            CASE (24)
              IPR(346) = MOD (IPR(346) + 1, 2)
C * TwinRotMat - CRIT-INT
            CASE (25)
              PAR(415) = MENUH * 0.1
              CALL PLA280 ('CALC')
C * ADDSYM EXACT
            CASE (26)
              CALL PLA280 ('CALC ADDSYM EXACT')
C * HKL-Display
            CASE (29)
              IPR(636) = MOD (IPR(636) + 1, 2)
            CASE DEFAULT
              LRET = -1
C * FLIP SHOW
            CASE (31)
              CALL PLA280 ('SHOW')
          END SELECT
C * MENU BOX # 23
        CASE (23)
C * LOOP OVER MENUS
          SELECT CASE (MMODE)
C * SET BOX ON/OFF
            CASE (1)
              IGBL(103) = MOD (IGBL(103) + 1, 2)
              LRET = 3
C * BOX ON/OFF
            CASE (2, 5, 6)
              IF (IGBL(103) == 1) THEN
                CALL PLA280 ('BOX OFF')
              ELSE
                CALL PLA280 ('BOX ON')
              END IF
C * PLUTON OMIT OUTSIDE
            CASE (3)
              CALL GEN038 (IGGT, 1, 80)
              IPR(141) = MOD (IPR(141) + 1, 2)
              IF (IPR(141) == 1) THEN
                CALL PLA280 (
     1           'OMIT OUTSIDE -0.1 1.1 -0.1 1.1 -0.1 1.1')
              ELSE
                CALL PLA280 ('OMIT OUTSIDE 0')
              END IF
C * DEFINE (PLUTON)
            CASE (4)
              IF (MENUH == 1) THEN
                LMOD     = 1
                IFL(1)   = 'DEFINE'
                IPR(507) = 1
                CALL PLA015 (508, 1)
                LRET     = -1
              ELSE IF (MENUH == 3) THEN
                IF (IPR(508) /= 0) THEN
                  IPR(507) = 3
                  IPR(508) = 0
                  WRITE (IGGT, 99995, IOSTAT = IOST)
     1              (IFL(I)(1:7), I = 1, LMOD)
                  IGBL(6) = IABS (IGBL(6))
                END IF
              END IF
C * PREV/NEXT
            CASE (7)
              IGBL(58) = 0
              IF (MENUH == 1) THEN
                IGBL(54) = MAX (1, IGBL(54))
                IF (IGBL(54) > 1) IGBL(58) = 1
              ELSE
                IGBL(54) = IGBL(54) + 1
                IF (IGBL(54) < IGBL(100)) THEN
                  IGBL(54) = MAX (1, MIN (IGBL(54) + 1, IGBL(100)))
                END IF
              END IF
              WRITE (IGGT, 99981, IOSTAT = IOST) IGBL(54)
              IGBL(67) = 0
              LRET = 3
C * RADII BONDS TO H-Atoms
            CASE (8)
              PAR(88) = MENUH * 0.01
              LRET = 4
C * LSPL / DIHEDRAL
            CASE (9)
              IF (MENUH == 1) THEN
                LMOD     = 1
                IFL(1)   = 'LSPL'
                IPR(551) = 1
                CALL PLA015 (552, 1)
                IPR(453) = 0
                IPR(448) = 0
                IPR(460) = 3
                IPR(476) = 0
                LRET     = -1
              ELSE IF (MENUH == 2) THEN
                IF (IPR(552) /= 0 .AND. LMOD > 3) THEN
                  LMOD      = LMOD + 1
                  IPR(551)  = 2
                  IFL(LMOD) = 'WITH'
                END IF
                LRET = -1
              ELSE IF (MENUH == 3) THEN
                IF (IPR(552) /= 0) THEN
                  IPR(551) = 3
                  CALL PLA015 (552, 1)
                  IPR(81)  = - LMOD
                  CALL PLA440 (1)
                  LMOD     = 0
                  IGBL(6) = IABS (IGBL(6))
                ELSE
                  IGBL(6) = 10
                  IF (IABS (IGBL(45)) /= 0) THEN
                    CALL PLA280 ('END')
                  ELSE
                    CALL PLA280 ('REM')
                  END IF
                END IF
              END IF
C * SAVE OPTION
            CASE (10)
              IGBL(45) = MOD (IGBL(45) + 1, 2)
              ISAVEMOD = 1
              CALL GEN108 (LU3, 0)
              LRET = -1
C * TOLA
            CASE (11)
C * TEST FOR PREVIOUS CALC UNIQUE (NO = 0)
              IF (IPR(30) == 0) PAR(2) = (MENUH - 1) * 0.2
              WRITE (BCD, 99978, IOSTAT = IOST) PAR(2), PAR(27),
     1          CHAR (0)
              CALL GGIP (-999.0, 5.0 + FLOAT (IGBL(68)), 80.0, 111)
              LRET = -1
C * REVERSE B&W
            CASE (12)
              CALL PLA280 ('SET REVERSE')
              LRET = 2
            CASE (13)
              IGBL(103) = MOD (IGBL(103) + 1, 2)
              CALL PLA280 ('REF')
C * DECORATION ON/OFF
            CASE (14)
              IGBL(103) = MOD (IGBL(103) + 1, 2)
              IPR(389) = 0
              LRET     = 4
            CASE (16)
              IGBL(103) = MOD (IGBL(103) + 1, 2)
C * SYSTEM-S
            CASE (17)
              IF (MENUH == 1) THEN
                CALL PLA280 ('VALID')
              ELSE
                CALL PLA280 ('REPORT')
              END IF
C * S/SUB-BROWSE
            CASE (18)
              IF (IGBL(42) == 1) IGBL(43) = 1
              IGBL(43) = MOD (IGBL(43) + 1, 2)
              IGBL(42) = 0
              CALL PLA280 ('BROWSE LIS')
C * S/SHELXL (LS)
            CASE (19)
              CALL PLA280 ('SHELXL')
C * POWDER - DECORATION
            CASE (21)
              IGBL(103) = MOD (IGBL(103) + 1, 2)
C * BOX ON/OFF
            CASE (22)
              IGBL(103) = MOD (IGBL(103) + 1, 2)
              LRET = 2
C * SOLV - DECORATION
            CASE (24)
              IGBL(103) = MOD (IGBL(103) + 1, 2)
C * TWINROTMAT HKLF5 DELTH-MAX
            CASE (25)
              PAR(420) = MENUH * 0.05
              CALL PLA280 ('CALC')
C * ADDSYM PLOT
            CASE (26)
              CALL PLA280 ('CALC ADDSYM PLOT')
C * RDF - DECORATION
            CASE (28)
              IGBL(103) = MOD (IGBL(103) + 1, 2)
C * BIJVOET - s.u.-bar
            CASE (29)
              IPR(634) = MOD (IPR(634) + 1, 2)
C * SET BOX ON/OFF
            CASE (30)
              IGBL(103) = MOD (IGBL(103) + 1, 2)
              LRET = 3
C * FLIP - CONTINUE
            CASE (31)
              CALL PLA280 ('CONTINUE')
C * K-ANALYZE
            CASE (32)
              IPR(778) = MOD (IPR(778) + 1, 2)
              CALL PLA280 ('VARIANCE')
C * ANOM - DECORATION
            CASE (33)
              IGBL(103) = MOD (IGBL(103) + 1, 2)
            CASE DEFAULT
              LRET = -1
          END SELECT
C * MENU BOX # 24
        CASE (24)
C * LOOP OVER MENUS
          SELECT CASE (MMODE)
C * SET META FILE ON
            CASE (1)
              IPR(346) = MENUH - 1
              CALL PLA015 (0, 0)
              MEDIUM      = 2
              IGGT(16:22) = 'ON     '
              CALL GGIP (-999.0, 0.0, 0.0, 6)
              LRET = 3
C * ASYM-RESIDUE
            CASE (3)
              IGBL(128) = MOD (IGBL(128) + 1, 2)
              IPR(130) = 0
              CALL PLA280 ('PLOT')
C * META PLOT
            CASE (2, 5, 6)
              IF (MENUH == 1) THEN
                CALL PLA015 (0, 0)
                MEDIUM      = 2
                IGGT(16:22) = 'ON     '
                CALL GGIP (-999.0, 0.0, 0.0, 6)
                CALL PLA280 ('PLOT')
              ELSE IF (MENUH == 2) THEN
                CALL PLA280 ('PLOT POV')
                IPR (340) = 1
                IGBL(98)  = 0
              ELSE IF (MENUH == 3) THEN
                IPR (340) = 1
                CALL PLA280 ('PLOT PDB')
              END IF
C * JOIN (DASH)/DETACH
            CASE (4)
              CALL PLA015 (311, MENUH)
              LRET = -1
C * ENTRY LIST
            CASE (7)
              CALL PLA015 (462, 1)
              IF (IPR(462) == 1) THEN
                CALL PLA280 ('ENTRY')
              ELSE
                WRITE (IGGT, 99981, IOSTAT = IOST) IGBL(54)
              END IF
C * BOND-TAPER
            CASE (8)
              PAR(48) = (MENUH - 1) * 0.125
              LRET    = 4
C * LSPL / DIST
            CASE (9)
              IF (MENUH == 1) THEN
                LMOD     = 1
                IFL(1)   = 'LSPL'
                IPR(460) = 1
                CALL PLA015 (476, 1)
                IPR(453) = 0
                IPR(448) = 0
                IPR(551) = 3
                IPR(552) = 0
                LRET     = -1
              ELSE IF (MENUH == 2) THEN
                IF (IPR(476) /= 0 .AND. LMOD > 3) THEN
                  LMOD      = LMOD + 1
                  IPR(460)  = 2
                  IFL(LMOD) = 'DIST'
                END IF
                LRET = -1
              ELSE IF (MENUH == 3) THEN
                IF (IPR(476) /= 0) THEN
                  IPR(460) = 3
                  CALL PLA015 (476, 1)
                  IPR(81)  = - LMOD
                  CALL PLA440 (1)
                  LMOD     = 0
                  IGBL(6) = IABS (IGBL(6))
                ELSE
                  IGBL(6) = 10
                  IF (IABS (IGBL(45)) /= 0) THEN
                    CALL PLA280 ('END')
                  ELSE
                    CALL PLA280 ('REM')
                  END IF
                END IF
              END IF
C * ENTRY LIST
            CASE (10)
              CALL PLA015 (462, 1)
              IF (IPR(462) == 1) THEN
                CALL PLA280 ('ENTRY')
              ELSE
                WRITE (IGGT, 99981, IOSTAT = IOST) IGBL(54)
              END IF
              LRET = 2
C * REM
            CASE (12)
              IGBL(47) = - IGBL(47)
              IPR(590) = MOD (IPR(590) + 1, 2)
              CALL PLA280 ('REM')
              IGBL(6) = 10
              LRET = 2
C * NEWMAN/RING/PLANE PLOT
            CASE (13)
              IPR(346) = MENUH - 1
              CALL PLA015 (0, 0)
              MEDIUM = 2
              IGGT(16:22) = 'ON     '
              CALL GGIP (-999.0, 0.0, 0.0, 6)
              CALL PLA280 ('REF')
C * CALC
            CASE (16)
              CALL PLA280 ('CALC')
C * SYSTEM-S AutoRenum
            CASE (17)
              CALL PLA280 ('RENUM')
C * SYSTEM-S/SUB - PRUNE
            CASE (18)
              CALL PLA280 ('PRUNE')
C * SYSTEM-S
            CASE (19)
              IF (MENUH == 1) THEN
                CALL PLA280 ('LRES')
              ELSE
                CALL PLA280 ('SHXLPS')
              END IF
C * LEPAGE - NEXT
            CASE (20)
              CALL PLA280 ('NEXT')
C * POWDER - EPS
            CASE (21)
              MEDIUM = 2
              IGGT(16:22) = 'ON     '
              CALL GGIP (-999.0, 0.0, 0.0, 6)
C * CONTOUR
            CASE (22)
              IF (MENUH == 1) THEN
                CALL PLA280 ('UP')
              ELSE
                CALL PLA280 ('DOWN')
              END IF
C * SOLV HARD COPY
            CASE (24)
              MEDIUM      = 2
              IGGT(16:22) = 'ON     '
              CALL GGIP (-999.0, 0.0, 0.0, 6)
C * TwRtMt - HKLF5
            CASE (25)
              CALL PLA280 ('HKLF')
C * ADDSYM SHELX
            CASE (26)
              CALL PLA280 ('CALC ADDSYM SHELX NOSF')
C * RDF - EPS
            CASE (28)
              MEDIUM = 2
              IGGT(16:22) = 'ON     '
              CALL GGIP (-999.0, 0.0, 0.0, 6)
C * BIJVOET - PLOT CAL
            CASE (29)
              MEDIUM = 2
              IGGT(16:22) = 'ON     '
              CALL GGIP (-999.0, 0.0, 0.0, 6)
              IF (IPR(621) == 1) THEN
                CALL PLA280 ('NPP')
                IPR(621) = -1
              END IF
C * SET META FILE ON
            CASE (30)
              IPR(346) = MENUH - 1
              CALL PLA015 (0, 0)
              MEDIUM      = 2
              IGGT(16:22) = 'ON     '
              CALL GGIP (-999.0, 0.0, 0.0, 6)
              LRET = 3
C * CONVERGE
            CASE (31)
              CALL PLA280 ('CONVERGE')
C * Anal-of-Variance - EPS
            CASE (32)
              MEDIUM = 2
              IGGT(16:22) = 'ON     '
              CALL GGIP (-999.0, 0.0, 0.0, 6)
              CALL PLA280 ('PLOT')
              LRET = 2
C * ANOM - EPS
            CASE (33)
              MEDIUM = 2
              IGGT(16:22) = 'ON     '
              CALL GGIP (-999.0, 0.0, 0.0, 6)
              CALL PLA280 ('PLOT')
C * FCF-COMPARE - EPS
            CASE (34)
              MEDIUM = 2
              IGGT(16:22) = 'ON     '
              CALL GGIP (-999.0, 0.0, 0.0, 6)
              CALL PLA280 ('PLOT')
              LRET = 2
C * WILSON PLOT - EPS
            CASE (35)
              MEDIUM = 2
              IGGT(16:22) = 'ON     '
              CALL GGIP (-999.0, 0.0, 0.0, 6)
              CALL PLA280 ('PLOT')
              LRET = 2
C * SQUEEZE SUMMARY PLOT
            CASE (36)
              MEDIUM = 2
              IGGT(16:22) = 'ON     '
              CALL GGIP (-999.0, 0.0, 0.0, 6)
              CALL PLA280 ('PLOT')
              LRET = 2
C * DiedPlot - EPS
            CASE (38)
              MEDIUM = 2
              IGGT(16:22) = 'ON     '
              CALL GGIP (-999.0, 0.0, 0.0, 6)
              CALL PLA280 ('PLOT')
              LRET = 2
            CASE DEFAULT
              LRET = -1
          END SELECT
C * MENU BOX # 25
        CASE (25)
C * LOOP OVER MENUS
          SELECT CASE (MMODE)
            CASE (1, 8, 9)
C * ToPLUTON
              IF (MENUH == 1) THEN
                LRET = 1
                CALL PLA280 ('PLUTON')
                IPR(327) = 0
                IPR(328) = 0
                IPR(349) = 0
                IPR(440) = 0
              ELSE IF (MENUH == 2) THEN
                LRET = 1
                IF (IABS (IGBL(45)) /= 0) THEN
                  IF (IPR(308) == 2) THEN
                    CALL PLA280 ('EXIT')
                    LRET = 7
                  ELSE
                    CALL PLA280 ('END')
                  END IF
                  IPR(351) = 0
                ELSE
                  CALL PLA280 ('REM')
                END IF
              END IF
C *PLUTON
            CASE (2, 3, 4, 5, 6, 7)
              IF (MENUH == 1) THEN
                CALL PLA280 ('RESET')
              ELSE IF (MENUH == 2) THEN
                IGBL(24) = 0
                CALL PLA280 ('END')
                IGBL(67) = 0
                LRET     = 3
              END IF
C * PLATON MAIN & SUP1 & 2-MENU
            CASE (10, 11, 12)
              IF (MENUH == 1) THEN
C * RESET INPUT
                CALL PLA286 (0)
                LRET = 2
              ELSE IF (MENUH == 2) THEN
                IGBL(24) = 0
                CALL PLA280 ('END')
                LRET = 3
              END IF
C * GEOM
            CASE (13)
              IF (MENUH == 1) THEN
                CALL PLA280 ('PLUTON')
              ELSE IF (MENUH == 2) THEN
                CALL PLA280 ('NO')
              END IF
C * ASYM EPS & END
            CASE (14)
              IF (MENUH == 1) THEN
                MEDIUM      = 2
                IGGT(16:22) = 'ON     '
                CALL GGIP (-999.0, 0.0, 0.0, 6)
                IPR(389) = 0
              ELSE
                CALL PLA280 ('END')
                LRET = 2
              END IF
C * HELENA CALC/NEXT-STEP
            CASE (15)
              CALL PLA280 ('CALC')
C * ABSORB
            CASE (16)
              IF (MENUH == 1) THEN
                MEDIUM      = 2
                IGGT(16:22) = 'ON     '
                CALL GGIP (-999.0, 0.0, 0.0, 6)
                CALL PLA280 ('PLOT')
              ELSE
                CALL PLA280 ('END')
              END IF
C * SYSTEM S - ACCEPT DEFAULT
            CASE (17, 18, 19)
              IF (MENUH == 1) THEN
                CALL PLA280 ('SKIP')
              ELSE
                CALL PLA280 ('!')
              END IF
            CASE (20)
              CALL PLA280 ('END')
C * POWDER (END)
            CASE (21)
              IGBL(6) = 10
C * RESET INPUT
              CALL PLA286 (0)
              LRET = 2
C * CONTOUR
            CASE (22)
              IF (MENUH == 1) THEN
                MEDIUM      = 2
                IGGT(16:22) = 'ON     '
                CALL GGIP (-999.0, 0.0, 0.0, 6)
                CALL PLA280 ('EPS')
                LRET = 2
              ELSE
                CALL PLA280 ('QUIT')
              END IF
C *SOLV
            CASE (24)
              LRET = 2
C *TWINROTMAT - END
            CASE (25)
              CALL PLA280 ('END')
C *ADDSYM
            CASE (26)
              CALL PLA280 ('END')
C *EXOR - ACCEPT DEFAULT
            CASE (27)
              IF (MENUH == 1) THEN
               CALL PLA280 ('SKIP')
              ELSE
                CALL PLA280 ('!')
              END IF
C * RDF (END)
            CASE (28)
              CALL PLA280 ('END')
C * BIJVOET (END)
            CASE (29)
              CALL PLA280 ('END')
C * POLYHEDRON END
            CASE (30)
              CALL PLA280 ('END')
C * FLIPPER END
            CASE (31)
              CALL PLA280 ('END')
C * ANAL-OF-VARIANCE
            CASE (32)
              CALL PLA280 ('END')
C * ANOM (END)
            CASE (33)
              IGBL(6) = 10
C * RESET INPUT
              CALL PLA286 (0)
              LRET = 2
C * FCF-CAMPARE END
            CASE (34)
              CALL PLA280 ('END')
C * WILSON PLOT END
            CASE (35)
              CALL PLA280 ('END')
C * SQUEEZE SUMMARY PLOT
            CASE (36)
              CALL PLA280 ('END')
C * SPGRfromEX
            CASE (37)
              CALL PLA280 ('END')
              LRET = 1
C * DIEDPLOT
            CASE (38)
              CALL PLA280 ('END')
            CASE DEFAULT
              LRET = -1
          END SELECT
      END SELECT
      RETURN
99999 FORMAT (/, '>> Labels may be moved by ''clicking'' on them',
     1        ' (When in MoveLabel On - Mode)', //)
99998 FORMAT ('CELL', F9.5, 3F9.4, 3F8.2, F12.2, A)
99997 FORMAT ('RCELL ', 3F10.6, 3F9.2, F10.5, A)
99996 FORMAT (A, 'ROT', I5)
99995 FORMAT (10(A, 1X))
99994 FORMAT ('STLM', F10.2, 5X)
99993 FORMAT ('SHELXL ISO', I3, 1X)
99992 FORMAT ('SHELXL ANISO', I3, 1X)
99991 FORMAT ('SHELXL HATOM', I3, 1X)
99990 FORMAT ('ZROT ', F10.2)
99989 FORMAT ('SHELXL WEIGHT', I3, 1X)
99988 FORMAT ('SET WINDOW', F8.2)
99987 FORMAT ('SET REVERSE')
99986 FORMAT ('CROTY COLOR', F8.2)
99985 FORMAT ('CROTY ', F8.2)
99984 FORMAT ('VIEW CUR ZROT', I5)
99983 FORMAT ('VIEW CUR YROT', I5)
99982 FORMAT ('VIEW CUR XROT', I5)
99981 FORMAT ('ENTRY', I6)
99980 FORMAT (80X, /)
99979 FORMAT ('Min. QPeak Height', F6.2, ', Min. QPeak Dist.', F6.2, A)
99978 FORMAT ('TolA =', F6.2, ', TolM =', F6.2, A)
99977 FORMAT ('Coordination Radius =', F6.1, A)
99976 FORMAT ('UISO', F10.3)
99975 FORMAT ('NTRY', I10)
99974 FORMAT ('NLOOP', I10)
99973 FORMAT ('NSOLVE', I10)
99972 FORMAT ('DELTA', F10.3)
99971 FORMAT ('ARU NONE ', I5)
99970 FORMAT ('PERC', F12.3)
99969 FORMAT ('PACK RANGE', 6F6.2)
      END SUBROUTINE PLA016
 
      SUBROUTINE PLA017 (MODE, IGOTO, ICONT, KL, KN, IS, A, J, NP, S)
C * SPF or RES  & Instructions
      USE files
      USE parameters
      USE atomdata
      USE cchar
      USE cggt
      USE chdat
      IMPLICIT NONE
      INTEGER :: I
      INTEGER :: J
      INTEGER :: L
      INTEGER :: N
      INTEGER :: IS
      INTEGER :: NP
      INTEGER :: KL
      INTEGER :: KN
      INTEGER :: IP
      INTEGER :: IMAX
      INTEGER :: MODE
      INTEGER :: NCHAR
      INTEGER :: IGOTO
      INTEGER :: ICONT
      INTEGER :: IGGTN
      REAL :: A
      REAL :: S
      CHARACTER(len=1) :: ICH
C * CHECK FOR INCLUDE FILE / SAVE FILENAME
      IF (ICL(1:1) == '+') THEN
        INCLUDEFILE = ICL(2:80)
        IPR(738)    = -1
      END IF
      N = INDEX (ICL(1:80), CHAR (13))
      IF (N /= 0) ICL(N:N) = CHAR (32)
C * CHANGE TO UPPER CASE
      CALL GEN020 (1, ICL, 1, 4)
C * CONVERT NON-TITL,REM,MESS & FILE LINE TO UPPER-CASE LETTERS
      IF (ICL(1:4) /= 'TITL' .AND. ICL(1:3) /= 'REM' .AND.
     1    ICL(1:4) /= 'MESS' .AND. ICL(1:4) /= 'FILE') THEN
        IF (ICL(1:4) == 'ENTR') THEN
          N = 5
        ELSE
          N = 80
        END IF
C * CHANGE TO UPPER CASE
        CALL GEN020 (1, ICL, 5, N)
      END IF
C * SKIP CARDS ON LU1
      IF (IPR(470) == 1) THEN
        IF (IGBL(5) == LU1) THEN
          IF (ICL(1:3) /= 'END') THEN
            IPR(471) = IPR(471) + 1
            IGOTO    = 1
            RETURN
          END IF
        END IF
        IPR(470) = 0
      END IF
C * SKIP NON-CONTINUATION CARD WITH FIRST CHAR. BLANK (BLANK CARD), + OR #
      ICH = ICL(1:1)
      IF (KL == 0 .AND. KN == 0 .AND.
     1      (ICH == ' ' .OR. ICH == '#' .OR. ICH == '+')) THEN
C * PLATON MODE
        IF (MODE == 0) THEN
          IF (IGBL(5) == LU5) THEN
            IGOTO = 3
          ELSE
            IGOTO = 1
          END IF
          RETURN
        END IF
      END IF
      IF (IGBL(5) == LU2 .AND. MODE /= 0)
     1  WRITE (LU6, 99998, IOSTAT = IOST) ICL(1:80)
      IF (IGBL(5) == LU3)
     1  WRITE (LU6, 99999, IOSTAT = IOST) ICL(1:80)
C * ANALYSE CONTENTS FROM COLUMN IMIN THROUGH IMAX
      IMAX  = 80
      ICONT = 0
C * SEARCH FOR CONTINUATION MARK = (ALL REMAINDER CHARACTERS SKIPPED)
      DO I = 1, IMAX
        IF (ICL(I:I) == '!') THEN
          IMAX = I - 1
          EXIT
        ELSE IF (ICL(I:I) == '=') THEN
          IMAX  = I - 1
          ICONT = 1
          EXIT
        END IF
      END DO
C * MAXIMUM SIZE LITERAL FIELD : NCHAR
      NCHAR = 8
      I     = 0
      GO TO 20
C * END OF NUMERIC FIELD
   10 IF (KN < NP17) THEN
        KN     = KN + 1
        FN(KN) = S * A / 10.0**NP
      END IF
      IF (ICH == '+' .OR. ICH == '-') I = I - 1
C * START OF A NEW FIELD
   20 A  = 0.0
      IP = 0
      NP = 0
      L  = 0
      S  = 1.0
C * LOOK FOR A NON-BLANK COLUMN
   30 I  = I + 1
      IF (I <= IMAX) THEN
        ICH = ICL(I:I)
C * SUBSTITUTE BLANK FOR <TAB>
        IF (ICH == CHAR (9)) THEN
          ICH = CHAR (32)
          ICL(I:I) = ICH
        END IF
        IF (L == 0 .AND. ICH == ' ') GO TO 30
C * START OF A FIELD
        L = L + 1
        DO J = 1, 10
          IF (ICH == CHAR(ICHAR('0') + J - 1)) THEN
C * START OF A LITERAL FIELD BY A CHARACTER WHICH IS OTHER THAN 0-9+-.
C * NUMERIC FIELD FOUND
            IF (IGBL(5) /= LU5 .AND. KL == 0) THEN
              IGOTO = 1
              RETURN
            END IF
            NP = NP + IP
            A  = 10.0 * A + J - 1
            GO TO 30
          END IF
        END DO
        IF (ICH == '.') THEN
          IP = 1
        ELSE IF (ICH == '+') THEN
          IF (L > 1) GO TO 10
          S = 1.0
        ELSE IF (ICH == '-') THEN
          IF (L > 1) GO TO 10
          S = -1.0
        ELSE IF (ICH == ']') THEN
          GO TO 10
        ELSE IF (ICH == ')') THEN
          GO TO 10
        ELSE
          IF (L <= 1) THEN
C * START NEW LITERAL FIELD
            IF (KL < NP17) KL = KL + 1
            IF (KL > 1 .AND. IS < 0) THEN
C * PLATON
              IF (MODE == 0) THEN
C * TRANSFORM KEYWORD TO ENTRYPOINT NUMBER IN ARRAY
                CALL GEN102 (IS, IFL(1)(1:4), ISWS, NP24)
              ELSE
C * PLUTON
C * TRANSFORM KEYWORD TO ENTRYPOINT NUMBER IN ARRAY
                CALL GEN102 (IS, IFL(1)(1:4), CRD,  NP37)
              END IF
C * DO NOT INTERPRETE TITL, REM AND MESS LINES
              IF (IS > 1 .AND. IS < 5) THEN
                IGOTO = 3
                RETURN
              END IF
            END IF
            DO
              IFL(KL)(L:L) = ICH
              L            = L + 1
              IGGTN        = (KL - 1) * NCHAR + L
C * COPY INTO IGGT (FOR TRANSFER TO GGIP) (AVOID OVERFLOW)
              IF (IGGTN <= 80) IGGT(IGGTN:IGGTN) = ICH
              IF (IGGTN == 2) CALL GEN038 (IGGT, 3, 80)
              DO
                I = I + 1
                IF (I > IMAX) GO TO 20
                ICH = ICL(I:I)
C * BREAK LITERAL MODE ON SPACE, COMMA (OR CONDITIONAL LEFT PARENTHESIS)
                IF (ICH == ' ' .OR. ICH == ',') GO TO 20
C * CATCH PAR[ ] CASE (BUT SKIP FOR LABELS)
                IF ((ICH == '[' .OR. ICH == '(') .AND.
     1            L > 3) GO TO 20
C * PLUS, MINUS OR DOT START NUMERICAL FIELD
                IF (ICH == '.') THEN
                  I = I - 1
                  GO TO 20
                END IF
                IF (ICH == '+' .OR. ICH == '-') THEN
                  IF (IGBL(8) /= 2 .OR. I > 3) THEN
                    I = I - 1
                    GO TO 20
                  END IF
                END IF
                IF (L <= NCHAR) EXIT
              END DO
            END DO
C * END OF LITERAL FIELD
            IGOTO = 2
            RETURN
          ELSE
            GO TO 10
          END IF
        END IF
        GO TO 30
      END IF
      IF (L > 0) GO TO 10
      IGOTO = 2
      RETURN
99999 FORMAT (':: SEx:', A)
99998 FORMAT (':: Def:', A)
      END SUBROUTINE PLA017
 
      SUBROUTINE PLA018 (MODE, X, Y, NQ)
C * NEAREST ATOM POS TO CLICK POS
      USE parameters
      USE plato
      USE sgxyz
      IMPLICIT NONE
 
      INTEGER :: I
      INTEGER :: J
      INTEGER :: NAT
      INTEGER :: IMN
      INTEGER :: IPP
      INTEGER :: IMIN
      INTEGER :: IRES
      INTEGER :: MODE
      INTEGER :: ISKP
      INTEGER :: IDUM
      INTEGER :: JDUM
      INTEGER :: NPOP
      INTEGER :: IRESI
      REAL :: X
      REAL :: Y
      REAL :: XX
      REAL :: YY
      REAL :: DEL
      REAL :: DSH
      REAL :: DELMIN
      CHARACTER(len=NP64) :: NQ
      CHARACTER(len=NP64) :: NQL
      IMIN   = 1
      DELMIN = 100000.0
      NQ     = '*******'
      NAT    = IPR(39) + IPR(64)
C * SEARCH NEAREST ATOM CENTER
      DO I = 1, NAT
        J = IATC(I)
        IF (J /= 0) THEN
C * CHECK FOR SELECTED RESIDUE
          IRESI = IPR(140)
          IF (IRESI /= 0) THEN
            CALL GEN048 (-6, IFG(1, J), 9, IRES)
            IF (IRES /= IRESI) CYCLE
          END IF
          CALL GEN048 (-1, IFG(2, J), 27, ISKP)
          IF (ISKP == 0) THEN
C * IGNORE MINOR/MAJOR DISORDER FORMS WHERE APPROPRIATE
            IF (IGBL(59) /= 0) THEN
C * GET POPULATION PARAMETER
              CALL GEN048 (-8, IFG(2, J), 1, IPP)
              NPOP = IPPR(IPP + 1, 1)
              IF (NPOP < 10000) THEN
                IF (IGBL(88) == 0) THEN
                  IF (NPOP < 5000) CYCLE
                ELSE
                  IF (NPOP > 5000) CYCLE
                END IF
              END IF
            END IF
            CALL PLA047 (LABA(IATC(I)), NQL, IDUM, JDUM, 1,
     1        IGBL(55), 0, 0)
            IF (NQL(1:2) /= 'Cg' .OR. IPR(506) == 1) THEN
              DEL = (XXO(I, 1) - X) ** 2 + (XXO(I, 2) - Y) ** 2
              IF (DEL < DELMIN) THEN
                DELMIN = DEL
                IMIN   = I
              END IF
            END IF
          END IF
        END IF
      END DO
      IF (DELMIN < 0.5) THEN
        IF (MODE <= 0) THEN
          IMN = IATC(IMIN)
          CALL PLA047 (LABA(IMN), NQ, IDUM, JDUM, 1, 1, 0, 0)
          IF (MODE == -1 ) THEN
            IF (IMN <= IPR(37)) THEN
              CALL GEN048 (1, IFG(1, IMN), 30, 1)
            ELSE
              CALL PLA015 (427, 28)
              RETURN
            END IF
          END IF
          DSH = 0.15
          XX  = XXO(IMIN, 1)
          YY  = XXO(IMIN, 2)
C * PLOT MARKER
          CALL PLA406 (XX, YY, DSH, 2.0)
C * FLUSH
          CALL GGIP (0.0, 0.0, 0.0, 6)
        ELSE
          IMIN = IATC(IMIN)
          CALL GEN048 (1, IFG(2, IMIN), 27, 1)
          IPR(201) = 0
        END IF
      END IF
      RETURN
      END SUBROUTINE PLA018
 
      SUBROUTINE PLA019 (MODE, IER)
C * MAIN MENU - NEAREST ATOM + READ/ANSWER
      USE files
      USE parameters
      USE atomdata
      USE cchar
      USE mentry
      USE xwdw
      USE cggt
      USE menus
      IMPLICIT NONE
      INTEGER :: I
      INTEGER :: J
      INTEGER :: IP
      INTEGER :: LU
      INTEGER :: IER
      INTEGER :: MODE
      INTEGER :: NKNM16
      INTEGER :: NKNMXT
      REAL :: XB
      REAL :: YB
      REAL :: XBS
      REAL :: SIZ
      REAL :: XHORS
      REAL :: YVERT
      CHARACTER(len=7) :: DIRC
      LU  = 0
      IER = 0
C * MODE = 0 - NORMAL READ REQUEST
C * MODE = 1 - Yes/No READ REQUEST
      IF (MODE == 0) THEN
        LU = IGBL(5)
        IF (LU == LU5) THEN
C * CHECK FOR X-WINDOW MODE [IGBL(32) = 1]
C * CHECK FOR MENU-ON       [IGBL(25) = 1]
C * CHECK FOR IUCR-OFF      [IGBL(3)  = 0]
          IF (IGBL(3) == 0 .AND. IGBL(25) * IGBL(32) == 1) THEN
C * CHECK FOR PLATON OPENING WINDOW [IGBL(6) = 10]
            IF (IABS(IGBL(6)) >= 10 .AND.
     1          IABS(IGBL(6)) <= 12) THEN
C * SKIP REFRESH OPENING WINDOW
              IF (IGBL(6) < 0) THEN
C * GET NEW DATA
                CALL PLA012 (0, 1)
                IF (LRET /= 1) THEN
                  ICL = IGGT
                  CALL GEN038 (IGGT, 1, 80)
                  RETURN
                END IF
              ELSE
C * OPEN MAIN X-WINDOW, GET INPUT FROM MENU/KEYPRESS
C * SET INTERACTIVE OUTPUT PROGRAM HEADER OFF
                IGBL(72) = 1
              END IF
C * OPEN MAIN WINDOW (X11-ONLY)
              DO
                BCD(1:12) = 'P.L.A.T.O.N'//CHAR (0)
                VERT = RGBL(1)
                HORS = VERT * RGBL(2)
                SIZ  = HORS / 63.0
                CALL GGIP (HORS, VERT, 0.0, 1)
C * GENERATE/DISPLAY PLATON HEADER
                LINE = 'P L A T O N'
                CALL PLA439 (0.0, LINE, 11, 2.0, 4, 15, 3.7, VERT - 2.4)
                CALL PLA439 (0.0, LINE, 11, 2.0, 2, 15, 3.5, VERT - 2.5)
                LINE = 'A Multipurpose Crystallographic Tool'
                CALL PLA439 (0.0, LINE, 36, 0.6, 1,  3, 3.9, VERT - 3.5)
                CALL GEN040 (IGBL(4), NQ1, IP)
                LINE = '(C) 1980-2025 A.L.Spek - Version: '//NQ1
                CALL PLA439 (0.0,  LINE, 50, 0.4, 3, 2, 5.8, VERT - 4.5)
C * GET PLATON UPDATE INFO
                IF (IGBL(142) == 0) CALL PLA430 (UPDATE)
                IF (IGBL(13) > 0) THEN
                  CALL PLA439 (0.0,  '[WEB:'//UPDATE//']', 18, 0.4,
     1              IGBL(14), 2, HORS - 6.1, VERT - 4.5)
                ELSE
                  CALL PLA439 (0.0,  '[NO INTERNET]', 13, 0.4,
     1              4, 2, HORS - 6.1, VERT - 4.5)
                END IF
C * CHECK FOR NO-ATOMS & NO-FACES AND NO-CELL
                IF (IPR(37) /= 0 .OR. IPR(367) /= 0 .OR.
     1            PAR(101) > 1.0) THEN
C * REPORT ON PARAMETER INPUT FILE
                  FNLU1  = NAMEFIL(1:KNMFIL)//'.'//EXTENS(1:KXT)
                  KNMXT  = KNMFIL + KXT + 1
                  NKNMXT = MIN (KNMXT, 25)
                  WRITE (PRBUF, 99999, IOSTAT = IOST)
     1              DTYPE(IABS(IGBL(8)))(1:3)//XLDTP, FNLU1(1:NKNMXT),
     2              IGBL(54), MAX (1, IGBL(100)), JID(1:8)
                  CALL PLA439 (0.0,  PRBUF, 80, SIZ, 3, 2,
     1                   0.1, VERT - 17.5)
C * REPORT ON REFLECTION DATA FILE
                  NKNM16 = MIN (KNM16, 25)
                  IF (IGBL(15) >= 0) THEN
                    IF (IGBL(37) == -1) THEN
                      DIRC = 'FCF'
                    ELSE IF (IGBL(37) == 1) THEN
                      DIRC = 'DIR-COS'
                    ELSE IF (IGBL(37) == 2) THEN
                      DIRC = 'ABS-PSI'
                    ELSE
                      DIRC = 'NO-DIRC'
                    END IF
                    CALL GGIP (0.0, 3.0, 0.0, 0)
                    WRITE (PRBUF, 99998, IOSTAT = IOST) RDTYP(IGBL(9)),
     1                FNLU16(1:NKNM16), DIRC, IGBL(126), JID(1:8)
                      KNMXT = KNM16 + 60
                  ELSE
                    CALL GGIP (0.0, 4.0, 0.0, 0)
                    WRITE (PRBUF, 99997, IOSTAT = IOST) FNLU16(1:NKNM16)
                    KNMXT = KNM16 + 40
                  END IF
                  CALL PLA439 (0.0,  PRBUF, KNMXT, SIZ, -1, 2, 0.1,
     1              VERT - 18.2)
                  WRITE (PRBUF, 99993, IOSTAT = IOST)
     1              HTTPSERVER(1:IGBL(135))
                  CALL PLA439 (0.0, PRBUF, 49, 0.25, 1, 1, 0.1,
     1              VERT - 19.3)
                  WRITE (PRBUF, 99994, IOSTAT = IOST)
     1              HTTPSERVER(1:IGBL(135))
                  CALL PLA439 (0.0, PRBUF, 49, 0.25, 1, 1, 11.0,
     1              VERT - 19.3)
                  CALL GGIP (0.0,  1.0, 0.0, 0)
                  CALL GGIP (0.0, -2.0, 0.0, 0)
                  XB = 0.0
                  YB = VERT - 5.0
                  CALL GGIP (XB, YB, 0.0, 3)
                  XB = HORS
                  CALL GGIP (XB, YB, 0.0, 2)
                  XB = HORS
                  YB = 0.0
                  CALL GGIP (XB, YB, 0.0, 3)
                  XB = HORS
                  YB = VERT
                  CALL GGIP (XB, YB, 0.0, 2)
                  PRBUF(1:41)  =
     1              ' GRAPHICS  GEOM-CALC VOIDS FLIP SYMMETRY '
                  PRBUF(42:73) = ' ABSORPTION   REPORT  MISC-TOOLS'
                  CALL PLA439 (0.0,  PRBUF, 73, SIZ, 5 + IGBL(68), 2,
     1              0.1, VERT - 5.6)
                  DO I = 1, NP46
                    DO J = 1, 7
C * CHECK FOR .RES DEPENDENCY
                      IF (IOPT(J, I) == 9 .AND. IGBL(8) /= -2) THEN
                        IF (IGBL(145) == 0) CALL GGIP (0.0, 4.0, 0.0, 0)
C * F3D     - Check for available
                      ELSE IF (I == 7 .AND. J == 3) THEN
 
                        CALL GGIP (0.0, 4.0, 0.0, 0)
C * SQUEEZE - Check for ELECTRON
                      ELSE IF (I == 3 .AND. J == 3 .AND.
     1                  IGBL(29) == 0) THEN
                        CALL GGIP (0.0, 4.0, 0.0, 0)
C * BIJVOET - Check for ELECTRON
                      ELSE IF (I == 6 .AND. J == 6
     1                  .AND. IPR(493) == 8) THEN
                        CALL GGIP (0.0, 4.0, 0.0, 0)
C * CIF2SHELX: CHECK FOR SHELXL201n CIF
                      ELSE IF (I == 17 .AND. J == 7 .AND.
     1                   IPR(663) /= 0 .AND.
     2                  (IPR(664) /= 0 .OR. IPR(321) /= 0)) THEN
C * HYBRID: CHECK FOR SHELXL201n CIF AND ELECTRON
                      ELSE IF (I == 4 .AND. J == 3) THEN
                        IF (IGBL(29) == 0) THEN
                          CALL GGIP (0.0, 4.0, 0.0, 0)
                        ELSE
                          IF (IGBL(110) > 0 .AND.
     1                      IPR(663) /= 0 .AND. IPR(664) /= 0) THEN
                            IF (IGBL(29) == 0) THEN
                              CALL GGIP (0.0, 4.0, 0.0, 0)
                            ELSE
                              CALL GGIP (0.0, 1.0, 0.0, 0)
                            END IF
                          END IF
                        END IF
                      ELSE IF ((IGBL(15) < 0 .AND. IOPT(J, I) > 1)
     1                 .OR. (IOPT(J, I) == 5 .AND.
     2                   (IGBL(9) < 1 .OR. IGBL(9) > 27))) THEN
                        CALL GGIP (0.0, 4.0, 0.0, 0)
                      ELSE IF (IGBL(15) >= 0 .AND. IGBL(9) == 0
     1                  .AND. IOPT(J, I) == 3) THEN
C * CHECK FOR 'UNIQUE CALCULATION DONE (NO = 0)'
                      ELSE IF (IOPT(J, I) == -2 .AND. (IPR(30) /= 0
     1                  .OR. IPR(37) == 0))
     1                  THEN
                        CALL GGIP (0.0, 4.0, 0.0, 0)
C * CHECK FOR 'NON-UNIQUE CALCULATION' (i.e INTER or COORD)
                      ELSE IF (IOPT(J, I) == -3 .AND. IPR(17) /= 0)
     1                  THEN
                        CALL GGIP (0.0, 4.0, 0.0, 0)
                      ELSE IF (IOPT(J, I) == -4 .AND. IPR(30) /= 0
     1                  .AND.  IPR(136) == 0) THEN
                        CALL GGIP (0.0, 4.0, 0.0, 0)
C * CHECK FOR COORDINATES GIVEN
                      ELSE IF (IOPT(J, I) == -5 .AND. IPR(37) == 0)
     1                  THEN
                        CALL GGIP (0.0, 4.0, 0.0, 0)
C * CHECK FOR FRACTIONAL COORDINATES
                      ELSE IF (IOPT(J, I) == -8 .AND. (IPR(23) == 1
     1                  .OR. IPR(30) /= 0 .OR. IPR(37) == 0)) THEN
                        CALL GGIP (0.0, 4.0, 0.0, 0)
                      ELSE IF (IOPT(J, I) == -9) THEN
                        CALL GGIP (0.0, 4.0, 0.0, 0)
                      ELSE
                        CALL GGIP (0.0, 1.0, 0.0, 0)
                      END IF
                      IF (IOPT(J, I) == -1) THEN
                        IF (IPR(30) /= 0 .OR. IABS (IGBL(8)) < 3 .OR.
     1                      IABS (IGBL(8)) > 3) THEN
                          CALL GGIP (0.0, 4.0, 0.0, 0)
                        ELSE
                          CALL GGIP (0.0, 1.0, 0.0, 0)
                        END IF
                      END IF
C * .INS/.RES INPUT ONLY FOR PATTERSON
                      IF (I == 13 .AND. J == 1 .AND.
     1                  IABS(IGBL(8)) /= 2) THEN
                        CALL GGIP (0.0, 4.0, 0.0, 0)
                      END IF
C * HANDLE CalcFCFsqd
                      IF (IGBL(9) /= -1) THEN
                        IF (J == 3 .AND. I == 5) THEN
                          CALL GGIP (0.0, 4.0, 0.0, 0)
                        END IF
                      END IF
C * HANDLE ContourSol
                      IF (IGBL(9) /= -1 .AND. IPR(665) == 0) THEN
                        IF (J == 3 .AND. I == 6) THEN
                          CALL GGIP (0.0, 4.0, 0.0, 0)
                        END IF
                      END IF
C * CHECK FOR SHELXT (XT) PRESENT
                      IF (IGBL(119) == 0) THEN
                        IF (I == 14 .AND. J == 1)
     1                    CALL GGIP (0.0, 4.0, 0.0, 0)
                      END IF
C * CHECK FOR DOS MODE
                      IF (DOS) THEN
                        IF (I == 1 .AND. J .EQ. 7) THEN
                          CALL GGIP (0.0, 4.0, 0.0, 0)
                        END IF
                      END IF
C * CHECK CSD
                      IF (IGBL(76) == 0) THEN
                        IF ((I == 11 .AND. J == 6) .OR.
     1                    (I == 12 .AND. J == 6))
     2                    CALL GGIP (0.0, 4.0, 0.0, 0)
                      END IF
                      IF (IPR(75) == 1) THEN
                        IF (J == 1 .AND. I == 9)
     1                    CALL GGIP (0.0, 4.0, 0.0, 0)
                      END IF
                      YVERT = VERT - I * 11.0 / NP46 - 5.7
                      XHORS = 9 * SIZ * (J - 1) + 0.1
                      CALL PLA439 (0.0,  OPTS(J, I), 10, SIZ, -1, 2,
     1                  XHORS, YVERT)
                    END DO
                  END DO
                  CALL GGIP (0.0, -2.0, 0.0, 0)
                  CALL GGIP (0.0, 1.0, 0.0, 0)
                  XB = 0.0
                  YB = VERT - 5.8
                  CALL GGIP (XB, YB, 0.0, 3)
                  XB = HORS
                  CALL GGIP (XB, YB, 0.0, 2)
                  XB = 0.0
                  YB = VERT - 16.8
                  CALL GGIP (XB, YB, 0.0, 3)
                  XB = HORS
                  CALL GGIP (XB, YB, 0.0, 2)
                  XB = 0.0
                  XBS = HORS / 7.0
                  DO I = 1, 7
                    XB = XB + XBS
                    YB = VERT - 16.8
                    CALL GGIP (XB, YB, 0.0, 3)
                    YB = VERT - 5.0
                    CALL GGIP (XB, YB, 0.0, 2)
                  END DO
                  CALL GGIP (0.0, -1.0, 0.0, 0)
C * NO PROPER DATA FOUND
                ELSE
                  IF (IABS(IGBL(3)) == 1) THEN
                    WRITE (LU6, 99996)
                    CALL PLA004 (0)
                  ELSE
                    LINE(1:26)  = 'NO PROPER INPUT FILE FOUND'
                    CALL PLA439 (0.0,  LINE, 26, 0.7, 2, 3, 4.8,
     1                VERT - 7.0)
                    LINE(1:33)  = 'NO ATOM DATA, FACES OR CELL FOUND'
                    CALL PLA439 (0.0,  LINE, 33, 0.7, 2, 3, 2.7,
     1                VERT - 8.5)
                    LINE(1:34)  = 'TO PROCEED'
                    CALL PLA439 (0.0,  LINE, 34, 0.7, 1, 3, 2.7,
     1                VERT - 11.0)
                    LINE(1:35)  = 'Enter ''FILE filename'' via Keyboard'
                    CALL PLA439 (0.0,  LINE, 35, 0.5, 1, 2, 2.7,
     1                VERT - 12.5)
                    LINE(1:32)  = 'or Enter Input Data via Keyboard'
                    CALL PLA439 (0.0,  LINE, 32, 0.5, 1, 2, 2.7,
     1                 VERT - 14.0)
                    LINE(1:25)  = 'or Click on HELP for INFO'
                    CALL PLA439 (0.0,  LINE, 25, 0.5, 1, 2, 2.7,
     1                VERT - 15.5)
                  END IF
                END IF
                IF (IGBL(47) > 0) THEN
C * BLANK 'Browser STARTUP'
                  LINE = 'Browser STARTUP'
                  CALL PLA439 (0.0,  LINE, 15, 0.5, 0, 3, HORS - 8.8,
     1              0.7)
C * WHITE 'Browser-mediated HELP'
                  LINE = 'Browser -'
                  CALL PLA439 (0.0,  LINE,  9, 0.5, 1, 3, HORS - 8.8,
     1              0.7)
                  LINE = 'HELP'
                  CALL PLA439 (0.0,  LINE,  4, 1.0, 1, 4, HORS - 3.5,
     1              0.3)
C * FLUSH
                  CALL GGIP (0.0, 0.0, 0.0, 6)
                END IF
C * PLATON MAIN MENU
C * GET NEW DATA
                CALL PLA012 (0, 1)
                IF (LRET /= 1) EXIT
              END DO
              ICL = IGGT
              CALL GEN038 (IGGT, 1, 80)
              RETURN
            END IF
          ELSE
            IF (IGBL(50) == 0) THEN
              CALL GEN125 (0, LU6, '>>')
            ELSE
              ICL = 'END'
              CALL GEN038 (IGGT, 1, 80)
              RETURN
            END IF
          END IF
        END IF
      ELSE IF (MODE == 1) THEN
        LU = LU5
C * CHECK FOR CONTINUE
        CALL GEN125 (1, LU6, ' ..... more (Y/N[Y])?')
      END IF
C * ACTUAL FILE READ
      IF (MODE == 1) THEN
        READ (LU, 99995, IOSTAT = IOST) ICL(1:80)
        IF (IOST == 0) THEN
          IF (ICL(1:1) == 'N' .OR. ICL(1:1) == 'n') THEN
            IER = 1
            RETURN
          END IF
        ELSE
C * READ FAILURE
          IER = -1
          RETURN
        END IF
      ELSE
        READ (LU, 99995, IOSTAT = IOST) ICL
        IF (IOST /= 0) THEN
C * READ FAILURE
          IER = -1
          RETURN
        END IF
      END IF
      RETURN
99999 FORMAT ('Xtal Data (', A, '  ) ', A, '- Set', I5, '(', I5, '): ',
     1        A)
99998 FORMAT ('Refl Data (', A, ') ', A,  ' [ ', A, ']', 2X,
     1       '(', I2, '): ', A)
99997 FORMAT ('No Refl_Data on     ', A, ', .FCF, .fcf or .hkl')
99996 FORMAT (/, ' ** No Recognizable CIF Data Found **', /)
99995 FORMAT (A)
99994 FORMAT (A, 'PLATON_HOW_TO.pdf')
99993 FORMAT (A, 'PLATON-MANUAL.pdf')
      END SUBROUTINE PLA019
 
      SUBROUTINE PLA020 (X, Y, Z)
C * HANDLE EVENTS ON CANVAS (AREA #1)
      USE files
      USE parameters
      USE plato
      USE atomdata
      USE cchar
      USE xwdw
      USE cggt
      USE tpos
      USE chdat
      USE sgxyz
      IMPLICIT NONE
 
      INTEGER       :: I
      INTEGER       :: J
      INTEGER       :: M
      INTEGER       :: N1
      INTEGER       :: N2
      INTEGER       :: NE
      INTEGER       :: NB
      INTEGER       :: NV
      INTEGER       :: NET
      INTEGER, SAVE :: IAT
      INTEGER       :: JAT
      INTEGER       :: LBB
      INTEGER       :: LBC
      INTEGER       :: LBD
      INTEGER       :: IPP
      INTEGER       :: IASU
      INTEGER       :: IVAL
      INTEGER, SAVE :: ITEM
      INTEGER, SAVE :: IATK
      INTEGER       :: JATK
      INTEGER       :: IHAT
      INTEGER       :: IENM
      INTEGER       :: NPOP
      INTEGER       :: IDUM
      INTEGER       :: JDUM
      INTEGER       :: NRCOL
      INTEGER       :: MMODE
      INTEGER       :: INQNR
      INTEGER       :: JNQNR
      REAL :: X
      REAL :: Y
      REAL :: Z
      REAL :: XL
      REAL :: YL
      REAL :: ZL
      REAL :: RL
      REAL :: YY
      REAL :: DEL
      REAL :: DIS
      REAL :: DISM
      REAL :: DIST
      REAL :: XHORS
      REAL :: YHORS
      REAL :: DELMIN
      CHARACTER(len=4) :: NTYP
      CHARACTER(len=7) :: TADD
      YY    = VERT - Y
      MMODE = IGBL(6)
      JATK  = 0
      IASU  = 0
      LRET  = 1
C * DELETE TEXT
      IF (IPR(344) == 1) THEN
        IF (IPR(447) > 0) THEN
C * PLUTON SUB1-MENU
          IF (MMODE == 3) THEN
            LMOD = 0
            CALL PLA109 (3, 1, X, Y)
          ELSE IF (MMODE == 8) THEN
            LMOD = 0
            CALL PLA109 (3, 0, X, Y)
          END IF
          LRET = -1
          RETURN
        END IF
C * CHANGE TEXT SIZE
      ELSE IF (IPR(334) == 1) THEN
        IF (IPR(447) > 0) THEN
          IF (MMODE == 3) THEN
            LMOD = 0
            CALL PLA109 (4, 1, X, Y)
          ELSE
            LMOD = 0
            CALL PLA109 (4, 0, X, Y)
          END IF
        END IF
        LRET = -1
        RETURN
      ELSE IF (IPR(343) == 1) THEN
        CALL PLA014 (1, 1, X, Y, ITEM, IASU)
        IPR(342) = ITEM
C * CLICKABLE VIEW LINE/PERP/BISECT
      ELSE IF (IPR(329) > 0) THEN
        CALL PLA014 (1, 1, X, Y, ITEM, IASU)
        IF (ITEM == 0) THEN
          LRET = -1
          RETURN
        END IF
        LMOD = LMOD + 1
        CALL PLUT25 (1, ITEM, IDUM)
        IFL(LMOD + 2) = NQ1
        IF (IPR(329) == 1) THEN
          IF (LMOD < 2) THEN
            LRET = -1
            RETURN
          END IF
        ELSE
          IF (LMOD < 3) THEN
            LRET = -1
            RETURN
          END IF
        END IF
        IPR(220) = LMOD + 2
        CALL PLUT06
        IPR(329) = 0
        LMOD     = 0
        RETURN
C * CONTOUR OMIT FROM SFC (TEST PRIOR TO IPR(415))
      ELSE IF (IPR(182) == 1) THEN
        CALL PLA018 (-1, X, YY, NQ1)
        LRET = -1
        RETURN
C * CONTOUR/ORTEP
      ELSE IF (IPR(415) > 0) THEN
        CALL PLA018 (0, X, YY, NQ1)
        CALL PLA280 (NQ1)
        RETURN
 
C * FIT BY CLICKING
      ELSE IF (IPR(312) > 0) THEN
        CALL PLA018 (0, X, YY, NQ1)
        IF (NQ1(1:1) /= '*') THEN
          LMOD = LMOD + 1
          IF (MOD(LMOD, 2) == 1) THEN
            XHORS = HORS - 4.0
            YHORS = VERT - 0.5 - (LMOD + 1) * 0.25
          ELSE
            XHORS = HORS - 2.0
            YHORS = VERT - 0.5 - LMOD * 0.25
          END IF
          CALL PLA439 (0.0, NQ1, 6, 0.3, 5 + IGBL(68), 1,
     1                 XHORS, YHORS)
          IFL(LMOD + 1) = NQ1
        END IF
        LRET = -1
        RETURN
C * ORTEP COLOR-TYPE
      ELSE IF (IPR(536) > 0) THEN
        CALL PLA018 (0, X, YY, NQ1)
        CALL PLA046 (3, NQ1, IENM, LBB, LBC, LBD, INQNR, JNQNR, N1)
        CALL PLA280 ('COLOR TYPE '//LMT(IENM, 1)//' '//COLR(IPR(536)))
        IPR(536) = 0
        RETURN
C * CLICKABLE GEOM/DIST/ANGLE/TORSION
      ELSE IF (IPR(341) > 0) THEN
C * ORTEP MODE
        IF (IABS(MMODE) == 1 .OR. IABS (MMODE) == 8 .OR.
     1      IABS(MMODE) == 9) THEN
          CALL PLA018 (0, X, YY, NQ1)
          LMOD = LMOD + 1
          IFL(LMOD + 1) = NQ1
          WRITE (SBCD, 99999, IOSTAT = IOST) (IFL(I), I = 1, LMOD + 1)
          IF (LMOD >= MIN (4,IPR(341))) THEN
            IPR(81) = LMOD + 1
            CALL PLA440 (1)
            LMOD     = 0
            IGBL(6) = IABS (IGBL(6))
          END IF
          LRET = -1
          RETURN
C * PLUTON MODE
        ELSE
          CALL PLA014 (1, 1, X, Y, ITEM, IASU)
          IF (ITEM == 0) THEN
            LRET = -1
            RETURN
          END IF
          IF (IPR(341) == 1) THEN
            IFL(1) = 'GEOM'
C * DIST
          ELSE IF (IPR(341) == 2) THEN
            IFL(1) = 'DIST '
            IF (IASU > 1) THEN
              IF (LMOD == 0) THEN
                LRET = -1
                RETURN
              ELSE IF (LMOD == 1) THEN
                FN(1)    = - IASU
                IPR(221) = 1
              END IF
            END IF
C * ANGLE
          ELSE IF (IPR(341) == 3) THEN
            IFL(1) = 'ANGLE'
C * TORSION
          ELSE IF (IPR(341) == 4) THEN
            IFL(1) = 'TORSION'
          END IF
          LMOD = LMOD + 1
C * RECOVER ATOM LABEL
          CALL PLUT25 (1, ITEM, IDUM)
          IFL(LMOD + 1) = NQ1
          WRITE (SBCD, 99999, IOSTAT = IOST) (IFL(I), I = 1, LMOD + 1),
     1      CHAR(0)
          IF (LMOD < IPR(341)) THEN
            LRET = -1
            RETURN
          END IF
          IPR(220) = LMOD + 1
          IPR(163) = 0
C * GEOMETRY CALCULATION
          CALL PLUT24 (LMOD, IPR(38), IDUM)
          LMOD = 0
          IF (IPR(130) == 0) RETURN
        END IF
C * CLICKABLE LSPL
      ELSE IF ((IPR(476) /= 0 .OR. IPR(552) /= 0)
     1         .AND. MMODE == 9) THEN
        CALL PLA018 (0, X, YY, NQ1)
        LMOD      = LMOD + 1
        IFL(LMOD) = NQ1
        LRET = -1
        RETURN
C * DEFINE ORTEP MODE
      ELSE IF (IPR(508) /= 0 .AND. MMODE == 1) THEN
        CALL PLA018 (0, X, YY, NQ1)
        LMOD      = LMOD + 1
        IFL(LMOD) = NQ1
        IF (LMOD == 2) THEN
          LMOD      = LMOD + 1
          IFL(LMOD) = 'TO'
          IPR(507)  = 2
        END IF
        LRET = -1
        RETURN
C * DEFINE (PLUTON)
      ELSE IF (IPR(508) /= 0 .AND. MMODE == 4) THEN
        CALL PLA014 (1, 1, X, Y, ITEM, IASU)
        IF (ITEM == 0) THEN
          LMOD = 0
          LRET = -1
          RETURN
        END IF
        CALL PLUT25 (1, ITEM, IDUM)
        LMOD = LMOD + 1
        IFL(LMOD) = NQ1
        IF (LMOD == 2) THEN
          LMOD      = LMOD + 1
          IFL(LMOD) = 'TO'
          IPR(507)  = 2
        END IF
        LRET = -1
        RETURN
C * JOIN/DETACH
      ELSE IF (IPR(311) /= 0) THEN
C * ORTEP
        IF (IABS (MMODE) == 1 .OR. IABS (MMODE) == 8) THEN
          LMOD = LMOD + 1
          IF (LMOD == 1) THEN
            CALL PLA018 (0, X, YY, NQ1)
            LRET = -1
            RETURN
          ELSE
            CALL PLA018 (0, X, YY, NQ2)
            IF (IPR(311) == 1) THEN
              CALL PLA280 ('JOIN '//NQ1//NQ2)
            ELSE IF (IPR(311) == 2) THEN
              CALL PLA280 ('JOIN DASH '//NQ1//NQ2)
            ELSE
              CALL PLA280 ('DETACH '//NQ1//NQ2)
            END IF
            RETURN
          END IF
C * PLUTON
        ELSE IF (MMODE == 4) THEN
          CALL PLA014 (1, 1, X, Y, ITEM, IASU)
          IF (ITEM == 0) THEN
            LMOD = 0
            LRET = -1
            RETURN
          END IF
          LMOD = LMOD + 1
          CALL PLUT25 (LMOD, ITEM, IDUM)
          IF (LMOD == 1) THEN
            IAT  = ITEM
            IATK = IDUM
          ELSE
            JAT  = ITEM
            JATK = IDUM
          END IF
          IF (LMOD < 2) THEN
            LRET = -1
            RETURN
          END IF
          IF (IPR(221) == 0) THEN
            CALL PLUT22 (IAT, JAT, DIST)
            IF (DIST > RADR(IATK, 3) + RADR(JATK, 3) + 0.8) THEN
              TADD = ' 0.05 2'
            ELSE
              TADD = '       '
            END IF
          END IF
          IF (IPR(311) == 1) THEN
            CALL PLA280 ('JOIN '//NQ1//NQ2//TADD)
          ELSE IF (IPR(311) == 2) THEN
            CALL PLA280 ('JOIN DASH '//NQ1//NQ2//TADD)
          ELSE
            CALL PLA280 ('DETACH '//NQ1//NQ2)
          END IF
          RETURN
        END IF
C * CONTOUR POS-CLICK
      ELSE IF (IPR(439) == 1) THEN
        WRITE (IGGT, '(''CPS'', 2F10.3)') X, PAR(38) - Y
        RETURN
      END IF
      SELECT CASE (MMODE)
C * MMODE = 1 - PLATON / ORTEP
        CASE (1)
          IPR(478) = 0
          IF (IPR(351) == 1) THEN
            CALL PLA018 (1, X, YY, NQ1)
          ELSE IF (IPR(440) == 1) THEN
            CALL PLA018 (0, X, YY, NQ1)
            CALL GEN020 (1, NQ1, 1, 7)
            IF (NQ1(2:2) == ' ') THEN
              NQ1(2:3) = '()'
            ELSE
              DO J = ICHAR ('A'), ICHAR ('Z')
                IF (NQ1(2:2) == CHAR(J)) THEN
                  IF (NQ1(3:3) == ' ') THEN
                    NQ1(3:4) = '()'
                  END IF
                END IF
              END DO
            END IF
            CALL PLA280 ('CALC COORDN '//NQ1)
C * CLICK FOR ARU ADD
          ELSE IF (IPR(440) == -1) THEN
            IF (X < PAR(37) / 2) THEN
              IMIN = 0
              DISM = 1000.0
              DO J = 1, 100
                DIS = ABS (YY - YMOL(1, J))
                IF (DIS < DISM) THEN
                  IMIN = J
                  DISM = DIS
                END IF
              END DO
              IF (IMIN /= 0) THEN
                FN(1)    = YMOL(2, IMIN)
                IPR(221) = 1
                CALL PLA295
              END IF
            END IF
C * MOVE/DELETE/INCLUDE LABEL
          ELSE IF (IPR(349) /= 0 .OR. IPR(327) /= 0
     1                 .OR. IPR(328) /= 0) THEN
            IF (LMOD == 0) THEN
C * GET NEAREST LABEL (PLATON)
              DELMIN = 1000.0
              IMIN = 1
              DO I = 1, IPR(39) + IPR(64)
                J   = I * NP71
                DEL = (VOID(J - 2) - X)**2 + (VOID(J - 1) - YY)**2
C * IGNORE MAJOR/MINOR FORMS WHERE RELEVANT
                IF (IGBL(59) /= 0) THEN
C * GET POPULATION PARAMETER
                  CALL GEN048 (-8, IFG(2, I), 1, IPP)
                  NPOP = IPPR(IPP + 1, 1)
                  IF (NPOP < 10000) THEN
                    IF (IGBL(88) == 0) THEN
                      IF (NPOP < 5000) CYCLE
                    ELSE
                      IF (NPOP > 5000) CYCLE
                    END IF
                  END IF
                END IF
                IF (IPR(328) == 1) THEN
                  IVAL = 1
                ELSE
                  CALL GEN048 (-1, IFG(2, I), 11, IVAL)
                END IF
                IF (IVAL == 1 .AND. DEL < DELMIN) THEN
                  CALL GEN048 (-1, IFG(1, I), 7, IHAT)
                  IF (IHAT /= 1 .OR. IPR(212) * IPR(232) /= 0)
     1               THEN
                    IMIN   = I
                    DELMIN = DEL
                  END IF
                END IF
              END DO
              CALL PLA047 (LABA(IMIN), NQ1, IDUM, JDUM,
     1                     IPR(350) * 2 - 1, IGBL(55), 0, 0)
              LMOD = 1
              X    = VOID(IMIN * NP71 - 2)
              YY   = VOID(IMIN * NP71 - 1)
            ELSE
              LMOD = 0
              VOID(IMIN * NP71 - 2) = X
              VOID(IMIN * NP71 - 1) = YY
            END IF
            IF (IPR(328) == 1) THEN
              CALL GEN048 (1, IFG(2, IMIN), 11, 1)
              LMOD = 0
            END IF
            YGGIP = FLOAT (1 - LMOD)
            CALL PLA439 (0.0, NQ1, 6, PAR(349), NINT (YGGIP), 1, X, YY)
            IF (IPR(327) == 1) THEN
              CALL GEN048 (1, IFG(2, IMIN), 11, 0)
              LMOD = 0
            END IF
            LRET = -1
            RETURN
          ELSE
            LRET = -1
            RETURN
          END IF
C * MMODE = 2 - PLUTON MODE
        CASE (2)
          LRET = -1
          RETURN
C * MMODE = 3 - PLUTON SUB1
        CASE (3)
C * PLUTON LABEL REPOSITION
          IF (IPR(349) == 1) THEN
            IF (LMOD == 0) THEN
              CALL PLA014 (-1, 1, X, Y, ITEM, IASU)
              NRCOL = 0
              CALL PLUT14 (-1, ITEM, IASU, NRCOL, XL, YL, ZL, RL)
              IF (ITEM /= 0) THEN
                CALL GGIP (0.0, 0.0, 0.0, 0)
                CALL PLUT25 (1, ITEM - IPR(62), IATK)
                CALL PLUT04 (1, ITEM - IPR(62))
                IPR(117) = 0
                CALL GGIP (0.0, 1.0, 0.0, 0)
                LMOD = 1
              END IF
            ELSE
              XL    =   X + PAR(61)
              YL    = - Y - PAR(62)
              NRCOL = 0
              CALL PLUT14 (1, ITEM, IASU, NRCOL, XL, YL, ZL, RL)
              CALL PLUT15 (4, ITEM - IPR(62), 37, 15)
              LMOD = 0
              CALL PLUT04 (1, ITEM - IPR(62))
              IPR(117) = 0
            END IF
            LRET = -1
            RETURN
C * EXLUDE ARU
          ELSE IF (IPR(213) == 1) THEN
            CALL PLA014 (-2, 1, X, Y, ITEM, IASU)
            ITEM = ITEM - IPR(62) - IPR(37)
            IF (ITEM > 0) THEN
              CALL PLUT17 (FLOAT (ITEM), 1005, M, LU6)
            ELSE
              LRET = -1
              RETURN
            END IF
          ELSE IF (IPR(332) == 1 .OR. IPR(335) == 1 .OR.
     1      IPR(351) == 1 .OR. IPR(352) == 1) THEN
            CALL PLA014 (1, 1, X, Y, ITEM, IASU)
            IF (ITEM /= 0) THEN
              CALL PLUT25 (1, ITEM, IATK)
C * DELETE
              IF (IPR(351) == 1) THEN
                WRITE (IGGT(1:), '(''DELETE '', A)', IOSTAT = IOST) NQ1
C * ANIS
              ELSE IF (IPR(352) == 1) THEN
                WRITE (IGGT(1:), '(''ANIS '', A)', IOSTAT = IOST) NQ1
                CALL PLUT15 (1, ITEM, 41, 1)
C * HFIX
              ELSE IF (IPR(332) == 1) THEN
                IF (IGBL(25) == 0) THEN
                  WRITE (LU6, 99992, ADVANCE = 'NO', IOSTAT = IOST) NQ1
                  READ (LU5, 99995) NQ2
                  WRITE (IGGT(1:), 99993, IOSTAT = IOST) NQ1, NQ2
                ELSE
                  IF (NCNT == 0) THEN
                    STRING(1:4) = 'HFIX'
                    NCNT = 4
                  END IF
                  CALL GEN039 (1, NQ1, 1, 7, NB, NE)
                  STRING(NCNT + 1:) = ' '//NQ1(1:NE)//' '
                  NCNT = NCNT + NE + 2
                  SBCD = STRING(1:NCNT)//CHAR (0)
                  CALL GEN038 (IGGT, 1, 80)
                  CALL PLA280 (STRING(1:NCNT))
                  NCNT = 0
                  RETURN
                END IF
C * RENAME
              ELSE IF (IPR(335) == 1) THEN
C * TEST FOR MENU ON/OFF
                IF (IGBL(25) == 0) THEN
                  READ (LU5, 99995) NQ2
                  WRITE (IGGT(1:), 99994, IOSTAT = IOST) NQ1, NQ2
                ELSE
                  IF (NCNT == 0) THEN
                    STRING(1:6) = 'RENAME'
                    NCNT = 6
                    CALL GEN039 (1, NQ1, 1, 7, NB, NE)
                    STRING(NCNT + 1:) = ' '//NQ1(1:NE)//' '
                    NCNT = NCNT + NE + 2
                  END IF
                  CALL GGIP ( 0.0,  1.0,  0.0, 0)
                  SBCD = STRING(1:NCNT)//CHAR (0)
                  CALL GEN038 (IGGT, 1, 80)
                  CALL PLA280 (STRING(1:NCNT))
                  NCNT = 0
                  RETURN
                END IF
              ELSE
                LRET = -1
                RETURN
              END IF
            ELSE
              LRET = -1
              RETURN
            END IF
          ELSE
C * OPTIONS MODE
            CALL PLA109 (5, 1, X, Y)
            LRET = -1
            RETURN
          END IF
C * MMODE = 4 - PLUTON SUB2
        CASE (4)
          CALL PLA014 (1, 1, X, Y, ITEM, IASU)
          IF (ITEM /= 0) THEN
            CALL PLUT25 (1, ITEM, IATK)
            NET = IEL(IEN(IATK))
            N1 = NET / 100
            N2 = NET - N1 * 100
            NTYP = ' '//CHAR (ICHAR ('A') + N1 - 1)//'  '
            IF (N2 /= 0) NTYP(3:3) = CHAR (ICHAR ('a') + N2 - 1)
            IF (IPR(348) == 1) THEN
C * CHECK FOR BWC-SWITCH ON/OFF)
              IF (IPR(461) == 0) THEN
C * CHECK FOR BWC-TYPE (BWC/RES/ARU)
                IF (IPR(478) == 0) THEN
                  IPR(340) = IPR(340) + 1
                  IF (IPR(340) > 17) IPR(340) = 1
                  CALL PLA280 ('BWC TYPE'//NTYP//BWCT(IPR(340)))
                END IF
              ELSE
                IPR(139) = IPR(139) + 1
                IF (IPR(139) > 17) IPR(139) = 1
                CALL PLA280 ('PLOT')
              END IF
            ELSE IF (IPR(338) == 1) THEN
              IPR(337) = IPR(337) + 1
              IF (IPR(337) > 9) IPR(337) = 1
              CALL PLA280 ('COLOR TYPE'//NTYP//COLR(IPR(337)))
            END IF
          ELSE
            LRET = -1
            RETURN
          END IF
C * MMODE = 5 & 6
        CASE (5, 6)
          LRET = -1
          RETURN
C * MMODE 8 & 9 - ORTEP/SUP
        CASE (8, 9)
          CALL PLA109 (5, 0, X, Y)
          LRET = -1
          RETURN
C * MMODE 7, 10, 11, 12
C * PLATON MAIN MENU & PLATON SUP1&2-MENU (PLUTON/SUP5)
        CASE (7, 10, 11, 12)
          CALL PLA011 (X, Y, Z)
C * MMODE = 17 - SYSTEM S
        CASE (17)
C * RESET CANVAS INPUT
          IF (IGBL(28) > 0) THEN
            NV =  NINT ((Y - RGBL(1) + PAR(360) + PAR(361) / 2.0)
     1             / PAR(361))
            IF (NV <= 0) THEN
              CALL PLA280 ('PLOT')
            ELSE
              IF (IGBL(28) == 1) THEN
                 IF (NV < 10) THEN
                  WRITE (IGGT, 99998, IOSTAT = IOST) NV
                ELSE
                  WRITE (IGGT, 99997, IOSTAT = IOST) NV
                END IF
              ELSE IF (IGBL(28) == 2) THEN
                NV = - NV
                IF (NV < 10) THEN
                  WRITE (IGGT, 99997, IOSTAT = IOST) NV
                ELSE
                  WRITE (IGGT, 99996, IOSTAT = IOST) NV
                END IF
              END IF
            END IF
          ELSE
            CALL PLA280 ('PLOT')
          END IF
C * MMODE = 18 - SYSTEM S/SUB1
        CASE (18)
          IF (IGBL(28) == 1) THEN
            NV = MIN (17, MAX (0, INT (Y - 1.5)))
            IF (NV < 10) THEN
              WRITE (IGGT, 99998, IOSTAT = IOST) NV
            ELSE
              WRITE (IGGT, 99997, IOSTAT = IOST) NV
            END IF
          ELSE
            CALL PLA280 ('PLOT')
          END IF
C * MMODE 19 & 22
        CASE (19, 22)
          LRET = -1
          RETURN
      END SELECT
      RETURN
99999 FORMAT (6(A, 1X))
99998 FORMAT (I1)
99997 FORMAT (I2)
99996 FORMAT (I3)
99995 FORMAT (A)
99994 FORMAT ('REN ', A, A)
99993 FORMAT ('HFIX ', A, A)
99992 FORMAT ('HFIX ', A, 1X)
      END SUBROUTINE PLA020
 
      SUBROUTINE PLA021 (MODE, NRETURN)
C * CALLED FROM PLA002 INPUT ROUTINE
      USE files
      USE parameters
      USE plato
      USE xwdw
      IMPLICIT NONE
      INTEGER :: I
      INTEGER :: MODE
      INTEGER :: IPR17
      INTEGER :: IGBL63
      INTEGER :: NRETURN
      REAL, DIMENSION(16) :: SAV
      NRETURN = 0
C * NRETURN = 0 - (RETURN)
C * NRETURN = 1 - (GO TO 010)
C * NRETURN = 2 - (GO TO 200)
C * NRETURN = 3 - (GO TO 130)
C * NRETURN = 4 - (GO TO 190)
C * CALC INTRA MODE
      IF (MODE == 0) THEN
        NRETURN = -1
C * TEST FOR NONSYM/MOLSYM
        IF (IPR(495) <= 1) THEN
C * HANDLE DISPLACEMENT PARAMETERS
          CALL PLA024
          IF (IGBL(131) == 1) THEN
            CALL PLA074 (-2, 0)
C * ERROR HANDLING
            IGBL(1) = 3
            NRETURN = 0
            RETURN
          END IF
C * CLOSE FOR CREATE PDB, SPF & RES
          IF (IPR(675) == 1) THEN
            CALL PLA074 (-2, 0)
            IF(IPR(2) == 0) IPR(2) = -1
C * ERROR HANDLING
            IGBL(1) = 3
            NRETURN = 0
            RETURN
          END IF
C * HANDLE -g, -R & -j MODE
          IF (IGBL(3) == 23 .OR. IGBL(3) == 24 .OR.
     1        IGBL(3) == 27) THEN
            IPR(1)  = 3
            IF (IPR(2) == 0) IPR(2) = -1
C * ERROR HANDLING
            IGBL(1) = 3
            NRETURN = 0
            RETURN
C * HANDLE -S mode CIF2RES & FCF2HKL
          ELSE IF (IGBL(3) == 25) THEN
            CALL PLA139 (LU6, LU16, LU17, IPR(384))
C * TERMINATE JOB
            IGBL(1) = 4
            NRETURN = 0
            RETURN
          ELSE
C * HANDLE ADDSYM/PLUTON
            IF (IPR(504) == 1) THEN
              CALL PLUTON (2)
C * MANAGE LU1
              IGBL(1) = 0
              NRETURN = 0
              RETURN
            END IF
C * OUTPUT CONNECTION TABLES
            CALL PLA074 (-2, 0)
            IF (IPR(2) /= 0) THEN
C * ERROR HANDLING
              IGBL(1) = 3
              NRETURN = 0
              RETURN
            END IF
C * HANDLE -b OPTION
            IF (IGBL(3) == 11) THEN
              IPR(1) = 3
              IF (IPR(2) == 0) IPR(2) = -1
C * ERROR HANDLING
              IGBL(1) = 3
              NRETURN = 0
              RETURN
            ELSE
C * GEOM LISTING IN 'NON PLUTON' MODE
              IF (IPR(14) /= 6) THEN
C * SKIP IN CASE OF ORTEP PLOT
                IF (IPR(14) /= 4) THEN
C * LIST INTRA GEOMETRY
                  CALL PLA077
                  IF (IGBL(31) == 1 .AND. IPR(430) == 0) IPR(2) = -1
C * SEARCH/GENERATE RINGS AND PLANES
                  CALL PLA078
                  IF (IPR(2) /= 0) THEN
C * ERROR HANDLING
                    IGBL(1) = 3
                    NRETURN = 0
                    RETURN
                  END IF
C * LIST LEAST-SQUARES PLANES
                  CALL PLA075
C * RING PUCKERING ANALYSIS
                  CALL PLA076
C * DEFAULT ORTEP PLOT SETTINGS
                ELSE
C * INCLUDE RINGS
                  IPR(10)  = 1
C * LIMIT TO UP TO 6-MEMBERED RINGS
                  IPR(579) = 6
                  CALL PLA078
                  CALL PLA076
                END IF
C * FCF/NEWSYM
                IF (IPR(210) < 0) THEN
C * CHECK FOR RECOGNISED WAVELENGTH
                  IF (IPR(493) == 0) THEN
                    IF (IPR(210) == -2) THEN
                      IPR(493) = -3
                    ELSE
                      IPR(2)  = 47
C * ERROR HANDLING
                      IGBL(1) = 3
                      NRETURN = 0
                      RETURN
                    END IF
                  END IF
                  IF (IPR(498) > 0) THEN
                    IPR(2)  = 45
C * ERROR HANDLING
                    IGBL(1) = 3
                    NRETURN = 0
                    RETURN
                  END IF
C * CHECK FOR NEWSYM CASE
                  IF (IPR(210) == -2) THEN
                    CALL PLA160 (-3, TM1)
C * CALC FCF ETC
                  ELSE
                    CALL PLA135
                  END IF
                  IPR(1) = 1
                  IF (IPR(2) == 0) IPR(2) = -1
C * ERROR HANDLING
                  IGBL(1) = 3
                  NRETURN = 0
                  RETURN
                END IF
              END IF
            END IF
          END IF
        END IF
        RETURN
C * CALC INTER, VOID, SQUEEZE, NEWSYM AND COORDINATION MODE
      ELSE IF (MODE == 1) THEN
        IPR(17)  = IPR(31)
        IPR(189) = IPR(200)
        NRETURN  = -1
C * CHECK FOR SQUEEZE CALCULATION
        IF (IPR(210) == 1) THEN
          IF (IPR(2) == 0) THEN
C * CHECK FOR NON-ZERO U/UIJ ERROR COUNT
            IF (IPR(498) /= 0) THEN
C * SET UIJ ERROR MESSAGE
              IPR(2) = 45
C * TEST FOR CIF BASED ON EXTI REFINEMENT
            ELSE IF (PAR(229) > 0.0 .OR. PAR(226) > 0.0) THEN
              IF (IGBL(29) == -1) THEN
                PAR(229) = -999999.0
              ELSE
                IPR(2) = 75
              END IF
            END IF
            IF (IPR(2) == 0) THEN
C * SET UP CONNECTED SET
              CALL PLA067
C * SQUEEZE CALCULATION FOR NON-ZERO VOID VOLUME
              IF (PAR(150) > 0) CALL PLA125
            ENDIF
          END IF
          IGBL(1) = 3
          IF (IPR(2) == 0) IPR(2) = -1
C * CHECK FOR DIFFERENCE MAP CALCULATION (FFT - PATH)
        ELSE IF (IPR(210) == 2) THEN
C * CHECK FOR NO UIJ ERRORS
          IF (IPR(498) == 0) THEN
            CALL PLA360
            IF (IPR(2) == 0) IPR(2) = -1
          END IF
          IGBL(1) = 3
        ELSE
C * DO CALC INTER ETC.
          CALL PLA067
          IF (IWIN == 1 .AND. IGBL(6) == 0) IGBL(6) = 10
C * TEST FOR ERROR
          IF (IPR(2) == 0) THEN
C * RDF-PLOT
            IF (IPR(57) == 2) THEN
              CALL PLA144 (-1, 0)
C * HANDLE -v OPTION (CALC SOLV)
            ELSE IF (IGBL(3) == 9) THEN
              IPR(1)  = 3
              IGBL(1) = 3
              IF (IPR(2) == 0) IPR(2) = -1
C * HANDLE -q OPTION (SQUEEZE - NO CALC VOID)
            ELSE IF (IGBL(3) == 5 .AND. IPR(210) == 0) THEN
              IF (IGBL(31) /= 0) THEN
                CLOSE (UNIT = LU2, IOSTAT = IOST)
                IF (IOST == 0) IGBL(31) = 0
              END IF
              IPR(1) = 3
              IF (IPR(2) == 0) IPR(2) = -1
              IGBL(1) = 3
C * HANDLE -K OPTION (K.P.I.)
            ELSE IF (IGBL(3) == 36) THEN
              IF (IPR(2) == 0) IPR(2) = -1
              IGBL(1) = 3
            END IF
          END IF
        END IF
        NRETURN = 0
        RETURN
C * CALC ADDSYM
      ELSE IF (MODE == 2) THEN
        IPR(121) = IPR(121) - 1
        IF (IPR(37) /= 0) THEN
C * RUN ADDSYM
          CALL PLA060
C * ERROR TEST
          IF (IPR(2) == 0) THEN
C * HANDLE -m OPTION (ADDSYM MODE)
            IF (IGBL(3) == 4) THEN
              IPR(1) = 3
              IF (IPR(2) == 0) IPR(2) = -1
C * ERROR HANDLING
              IGBL(1) = 3
              RETURN
            END IF
            NRETURN = 1
            RETURN
          END IF
        END IF
        NRETURN = 2
C * CALC INTRA (UNIQUE MOLECULE CALCULATION)
      ELSE IF (MODE == 3) THEN
        IPR(31)  = 0
        IPR(430) = -1
C * NO INTRA AFTER PREVIOUS INTRA
C * TEST FOR PREVIOUS CALC UNIQUE (NO = 0)
        IF (IPR(30) /= 0) THEN
          IPR(2) = 31
          NRETURN = 2
          RETURN
        END IF
C * SET ALL INTRA OPTIONS ON
        IF (IPR(5) == -1) THEN
          IPR(5) = 1
        ELSE
          CALL GEN097 (IPR, 5, 11, 1)
        END IF
        IPR(495) = 1
C * LOWER THE NUMBER OF STILL TO BE EXECUTED TASKS
        IPR(121) = IPR(121) - 1
C * SET FOR CALC INTRA AS LAST INSTRUCTION
        IF (IPR(121) == 0) IPR(136) = 1
        CALL PLA015 (0, 39)
        NRETURN = 3
C * CALC INTER
      ELSE IF (MODE == 4) THEN
        IF (IPR(23) > 0) THEN
          NRETURN = 4
          RETURN
        END IF
        IPR(200) = 0
        IPR(104) = 0
        CALL GEN097 (IPR, 5, 10, 0)
C * TEST FOR PREVIOUS INTER CALC
        IF (IPR(77) == 1) THEN
          IPR(2) = 11
          NRETURN = 2
          RETURN
        END IF
        IPR(77)  = 1
        IPR(31)  = -1
        IPR(90)  = 1
        IPR(121) = IPR(121) - 1
        NRETURN   = 3
C * CALC COORDN
      ELSE IF (MODE == 5) THEN
        IPR(5)  = 0
        IPR(6)  = 1
        IPR(7)  = 16
        IPR(8)  = 0
        IPR(9)  = 0
        IPR(10) = 0
        IPR(1)  = 6
C * BOND VALENCE ANALYSIS - INIT
        CALL PLA096 (0, '        ', -1.0, 0)
C * TEST FOR PREVIOUS CALC UNIQUE (NO = 0)
        IF (IPR(30) == 0) THEN
C * SAVE PARAMETERS TEMPORARILY
          DO I = 1, 16
            SAV(I) = FN(I)
          END DO
C * SET UP CONNECTED SET
          CALL PLA067
          IF (IPR(2) /= 0) THEN
            NRETURN = 0
            RETURN
          END IF
C * RESTORE SAVED PARAMETERS
          DO I = 1, 16
            FN(I) = SAV(I)
          END DO
        END IF
        IPR(31) = 1
        IF (IPR(221) == 1) THEN
          IF ((IPR(220) == 3 .AND. IFL(3)(1:3) == 'NOA') .OR.
     1      IPR(220) == 2) THEN
            IF (IPR(57) == 1) IPR(170) = 1
            PAR(262) = FN(1)
          END IF
        END IF
        IPR(121) = IPR(121) - 1
        IPR(122) = 0
        CALL PLA015 (0, 39)
        NRETURN = 3
C * CALC RADIAL DISTRIBUTION
      ELSE IF (MODE == 6) THEN
        IPR(31) = 1
        IF (IPR(221) == 1) THEN
          IF ((IPR(220) == 3 .AND. IFL(3)(1:3) == 'NOA') .OR.
     1      IPR(220) == 2) THEN
            IF (IPR(57) == 1) IPR(170) = 1
            PAR(262) = FN(1)
          END IF
        END IF
        IPR(121) = IPR(121) - 1
        IPR(122) = 0
        CALL PLA015 (0, 39)
        NRETURN = 3
C *
      ELSE IF (MODE == 7) THEN
C * TRANSFORM LABELS TO SEQUENCE NUMBERS
C * TEST FOR PREVIOUS CALC UNIQUE (NO = 0)
          IF (IPR(30) == 0) THEN
          CALL PLA280 (ICL)
          IGBL(52) = MAX (IGBL(52), IPR(23))
C * SET UP CONNECTED SET
          CALL PLA067
          IF (IPR(2) /= 0) THEN
            NRETURN = 0
            RETURN
          END IF
          CALL PLA073 (-1, 1)
C * TEST FOR PLA024 DONE
          IF (IPR(85) == 0) THEN
            IPR(5) = 0
            CALL PLA024
          END IF
        ELSE
          CALL PLA288 (IPR(785))
        END IF
        NRETURN = 1
C * CALC METAL (WHEN METAL PRESENT)
      ELSE IF (MODE == 8) THEN
        IF (IPR(155) > 0) THEN
          IPR(57)  = 1
          PAR(262) = 5.0
          IPR(170) = 0
          IPR(5)   = 0
          IPR(6)   = 1
          IPR(7)   = 0
          IPR(8)   = 0
          IPR(9)   = 0
          IPR(10)  = 0
          IPR(31)  = 1
          IF (IPR(221) == 1) THEN
            IF ((IPR(220) == 3 .AND. IFL(3)(1:3) == 'NOA') .OR.
     1        IPR(220) == 2) THEN
              IF (IPR(57) == 1) IPR(170) = 1
              PAR(262) = FN(1)
            END IF
          END IF
          IPR(121) = IPR(121) - 1
          IPR(122) = 0
          CALL PLA015 (0, 39)
          NRETURN = 3
        ELSE
          IPR(121) = IPR(121) - 1
          NRETURN = 1
        END IF
C *  CALC SOLV/VOID
      ELSE IF (MODE == 9) THEN
C * ERROR CHECK FOR ANGSTROM/FRACTIONAL DATA
        IF (IPR(23) == 1) THEN
          IPR(2) = 33
          NRETURN = 2
        ELSE
          CALL GEN097 (IPR, 5, 10, 0)
          IPR(31)  = -1
          IPR(90)  = 1
          IPR(121) = IPR(121) - 1
          NRETURN  = 3
        END IF
C * RUN DEFAULT IUCR-CHECK (CIF + FCF) (ASYM)
      ELSE IF (MODE == 10) THEN
C * TEST FOR CIF (BUT NOT CSD-CIF (i.e. IGBL(94) /= 0)
C * CURRENTLY SKIPPED FOR ELECTRON DIFFRACTION
        IF (IABS(IGBL(8)) == 3 .AND. IGBL(94) == 0) THEN
          IPR(121) = IPR(121) - 1
C * TEST FOR ABSENT WAVELENGTH
C * ALERT _091
          IF (IPR(493) == -3)
     1      CALL PLA236 (91, 0, 1.0, 1.0, ' ', ' ')
C * TEST FOR NON In/Ag/Mo/Ga/Cu KA radiation AND NON XKB, 'SYNCHROTRON',
C * OR 'NEUTRON' OR 'ELECTRON'
C * ALERT _092
          IF (IPR(493) > 5 .AND. IPR(630) == 0)
     1      CALL PLA236 (92, 5, -999.0, PAR(17), ' ', ' ')
C * SET FOR EXPECT MODE - CHECK FOR THETA(MAX) VALUE
          IF (PAR(168) > 0.0) THEN
            CALL PLA145 (1)
          END IF
C * CHECK FOR FCF-PRESENT (TYPE SHELXL etc, or LIST 3))
          IF (IGBL(9) > 0 .AND. IGBL(9) < 28) THEN
            IPR(200) = 0
C * SAVE/INIT PARAMETER VALUES
C * PRINT LEVEL
            IGBL63   = IGBL(63)
            IGBL(63) = 0
C * JOIN
            IPR17    = IPR(17)
            IPR(17)  = 0
C * NMOL
            IPR(13)  = 0
C * VALIDATION MODE (AVF)
            CALL PLA145 (2)
C * RESTORE PARAMETER VALUES
C * PRINT LEVEL
            IGBL(63) = IGBL63
C * JOIN
            IPR(17)  = IPR17
C * HKS FILE
            IGBL(18) = 0
C * ANALYSE DIFFERENCE MAP (STRUCTURE FACTORS CALCULATED FROM CIF)
C * CURRENTLY FOR SHELXL-97 & SHELXL-20xy ONLY
            IF ((IPR(725) > 0 .AND. IPR(725) < 5)
     1        .OR. IGBL(9) == 1) THEN
              IPR(210) = 2
              CALL PLA360
            END IF
          END IF
C * IUCR-CHECK (TAKING INTO ACCOUNT FCF ANALYSIS
          IF (IABS(IGBL(8)) == 3) CALL PLA233
          IPR(2) = -1
C * ERROR HANDLING
          IGBL(1) = 3
          NRETURN = 0
          RETURN
        ELSE
          IPR(121) = IPR(121) - 2
          NRETURN = 4
          RETURN
        END IF
C * EXECUTE LIST ON DISPLAY OPTIONS
      ELSE IF (MODE == 11) THEN
C * TEST FOR PREVIOUS CALC UNIQUE (NO = 0)
        IF (IPR(30) == 0) THEN
C * SET UP CONNECTED SET
          CALL PLA067
          IF (IPR(2) /= 0) THEN
C * ERROR HANDLING
            IGBL(1) = 3
            NRETURN = 0
            RETURN
          END IF
C * GET NEW INSTRUCTION
          IF (IPR(205) /= 0) RETURN
          CALL PLA073 (-1, -1)
          IF (IPR(2) /= 0) THEN
C * ERROR HANDLING
            IGBL(1) = 3
            NRETURN = 0
            RETURN
          END IF
        END IF
        IF (IPR(1) == 4) THEN
          IF (IPR(84) == 1) THEN
            CALL PLA073 (1, -1)
          ELSE
            CALL PLA074 (2, -1)
          END IF
          IF (IPR(2) /= 0) THEN
C * ERROR HANDLING
            IGBL(1) = 3
            NRETURN = 0
            RETURN
          END IF
        ELSE IF (IPR(1) == 7) THEN
C * INTERACTIVE DIST, ANGLE, TORSION AND LSPL CALCULATION
          CALL PLA440 (1)
        END IF
C * CHECK FOR '-I' MODE FIT
        IF (IGBL(3) == 41) THEN
          IPR(2) = -1
C * ERROR HANDLING
          IGBL(1) = 3
          NRETURN = 0
          RETURN
        END IF
C * EXECUTE CALC HBONDS
      ELSE IF (MODE == 12) THEN
C * REGISTER MANUAL CALC HBONDS
        IF (IGBL(5) == LU5) THEN
          IPR(736) = 1
        ELSE IF (IGBL(5) == LU1) THEN
          IPR(736) = -1
        END IF
        WRITE(6,'(''IPR736'',I5)') IPR(736)
C * SET COORDINATION MODE
        IPR(31)  = -1
C * COPY DEFAULT HBOND PARAMETERS
        DO I = 1, 3
          RGBL(43 + I) = RGBL(40 + I)
        END DO
C * GET/SAVE COMMAND LINE PARAMETERS p1, p2, p3
        IF (IPR(221) > 0) THEN
          DO I = 1, IPR(221)
            RGBL(43 + I) = FN(I)
          END DO
        END IF
C * RESET ENTRY
        IF (IPR(736) == 1) CALL PLA286 (0)
C * SET 'CALC ALL' LOOP
        IPR(121) = 0
C * TEST FOR PREVIOUS INTER CALC DONE (NO CALC HBONDS AFTER 'CALC INTER')
        IF (IPR(77) == 1) THEN
          IPR(2) = 11
          NRETURN = 2
        END IF
        IPR(77)  = 1
      END IF
      RETURN
      END SUBROUTINE PLA021
 
      SUBROUTINE PLA022 (INQNR)
C * INVESTIGATE THE PARAMETERS OF A (POTENTIALLY) NEW ATOM RECORD
      USE files
      USE parameters
      USE plato
      USE atomdata
      USE cchar
      USE sgxyz
      IMPLICIT NONE
      INTEGER :: I
      INTEGER :: J
      INTEGER :: K
      INTEGER :: L
      INTEGER :: N
      INTEGER :: KN
      INTEGER :: KL
      INTEGER :: MN
      INTEGER :: KNS
      INTEGER :: LOP
      INTEGER :: NCY
      INTEGER :: LBB
      INTEGER :: LBC
      INTEGER :: LBD
      INTEGER :: IVL
      INTEGER :: ISU
      INTEGER :: NAT
      INTEGER :: IHAT
      INTEGER :: JHAT
      INTEGER :: JSYM
      INTEGER :: KNP1
      INTEGER :: NSYM
      INTEGER :: NPOP
      INTEGER :: NIEN
      INTEGER :: IENM
      INTEGER :: IHYD
      INTEGER :: IENR
      INTEGER :: MODE
      INTEGER :: IPOP
      INTEGER :: JDUM
      INTEGER :: MULT
      INTEGER :: MULTX
      INTEGER :: NATP1
      INTEGER, SAVE :: IATYC
      INTEGER, SAVE :: IATYO
      INTEGER, SAVE :: IATYN
      INTEGER :: IENM1
      INTEGER :: INQNR
      INTEGER :: JNQNR
      INTEGER :: ITRNS
      INTEGER :: INTPOP
      INTEGER :: IPOPRES
      REAL :: YY
      REAL :: SJ
      REAL :: RPI
      REAL :: VERS
      REAL :: XLNG
      REAL :: FNK4
      REAL :: RGBL25
      REAL :: POPPARX
C * GET NUMBER OF CURRENTLY ACCEPTED ATOMS
      NAT = IPR(39)
C * CATCH ATTEMPT TO EXCEED MAX NUMBER OF ATOM LIMIT
      IF (NAT < NP1) THEN
        IENR = 0
        ISU  = 0
C * GET NUMBER OF SYMMETRY OPERATIONS
        NSYM = IPR(48)
C * ZERO SKIP-TEST
        IPR(107) = 0
C * SET PACKING PARAMETERS FOR INTERNAL NUMERICAL LABEL REPRESENTATION
        IF (NAT == 0) THEN
          IPR(463) = 128
          IPR(464) = 51200000
          IPR(465) = 400000
          IPR(466) = IPR(465) * 2
        END IF
        NATP1  = NAT + 1
C * GET NUMBER OF NUMERICAL ENTRIES ON INPUT LINE
        KL     = IPR(220)
        KN     = IPR(221)
        MODE   = 100
C * DELETE FROM INPUT CRITERIUM
        RGBL25 = MAX (0.05, RGBL(25))
C * GET ATOM LABEL AT POSITION IPR(473) IN RECORD
        NQ1    = IFL(IPR(473))
C * CHECK FOR AND HANDLE CIF STYLE INPUT
        IF (IGBL(8) == 3) THEN
C * CHECK FOR INCOMPLETE CIF-DATA
          IF (KN /= 10) THEN
C * CHECK FOR VALIDATION
            IF (IGBL(3) == 1) THEN
C * ALERT _170 - INSUFFICIENT DATA
              CALL PLA236 (170, 0, 1.0, 1.0, IFL(2), ' ')
            ELSE
              IPR(2) = 51
            END IF
            RETURN
          END IF
C * COUNT # OF PART EXTENSIONS ON LABEL
          IF (INDEX (NQ1, '^') > 0) IPR(768) = IPR(768) + 1
          IF (NAT == 0) THEN
C * CHECK FOR PROPER CELL DIMENSIONS
            IF (PAR(101) < 1.1 .AND. IPR(23) == 0) THEN
              IPR(2) = 58
              RETURN
            END IF
            IGBL(59) = 0
            IATYC    = 0
            IATYO    = 0
            IATYN    = 0
C * CHECK FOR ABSENCE OF EXPLICIT SYMMETRY
            IF (IPR(319) == 0) THEN
C * ALERT _124 - PROBLEM WITH EQUIVALENT POSITIONS
              CALL PLA236 (124, 0, 1.0, 1.0, CCIF(7)(1:7), ' ')
              IF (SPGRNM(1)(1:1) == ' ') THEN
C * ALERT _121 - INVALID SPACE GROUP
                CALL PLA236 (121, 0, 1.0, 1.0, CCIF(6), ' ')
C * INIT SPACE GROUP SYMMETRY TO P1
                CALL SGSM (1, IDM, SGY, 0, 0, IERR)
                IPR(48) = 1
              END IF
            END IF
          END IF
C * GET ASSIGNED SCATTERING TYPE TO THIS ATOM (_atom_site_type_symbol)
          IF (KL == 3) THEN
            N = 9
            IF (IFL(3)(3:3) == ' ') N = 2
            IF (IFL(3)(2:2) == ' ') N = 1
C * CHECK
            IF (N <= 2) THEN
              NQ4 = '       '//IFL(3)(1:N)
C * ALERT _017 - SCATTERING TYPE CONSISTENCY (SHELXL-CIF)
              IF (INDEX (IFL(2), IFL(3)(1:N)) == 0) THEN
                CALL PLA236 (17, 0, 1.0, 0.0, IFL(2)(1:9), NQ4(1:9))
              END IF
            END IF
          END IF
C * CHECK FOR AND HANDLE RES STYLE INPUT
        ELSE IF (IGBL(8) == 2) THEN
C * HANDLE SPECIAL L-LABELS (IDEAL)
          IF (NQ1(1:1) == 'L') THEN
            DO I = 1, 10
              IF (NQ1(2:2) == CHAR (ICHAR ('0') + I - 1)) RETURN
            END DO
          END IF
C * FIRST CHECK WHETHER ALPHANUMERIC ITEM IPR(473) IS AN ATOM LABEL
C * ADD RESIDUE NUMBER TO LABEL
          IF (IPR(538) /= 0) THEN
            N = INDEX (NQ1, ' ')
            IF (N /= 0) THEN
              IF (IPR(538) < 10) THEN
                WRITE (NQ1(N:N + 1), 99997, IOSTAT = IOST) IPR(538)
              ELSE
                WRITE (NQ1(N:N + 2), 99996, IOSTAT = IOST) IPR(538)
              END IF
            END IF
            IFL(IPR(473)) = NQ1
          END IF
        END IF
C * GET NUMERICAL REPRESENTATION FOR THE LABEL IN NQ1
        NQ2 = NQ1
        NQ4 = NQ1
        LOP = 0
        NCY = 0
        DO
          CALL PLA046 (MODE, NQ1, IENM1, LBB, LBC, LBD, INQNR, JNQNR,
     1                 NIEN)
C * ALERT FOR LABEL WITHOUT NUMERICAL PART
          IF (LBB == 0 .AND. NIEN >= 0) THEN
            IF (NQ1(2:2) /= '0') THEN
              CALL GEN020 (-1, NQ1, 2, 2)
C * ALERT _069
              IF (IPR(105) == 0)
     1          CALL PLA236 (69, 0, -999.0, 1.0, NQ1, ' ')
            END IF
          END IF
C * CHECK & ATTEMPT TO CORRECT LABEL PROBLEM
          IF (NIEN < 0) THEN
            IF (NIEN == -7) THEN
              IPR(2) = 67
              RETURN
            ELSE IF (NIEN == -12) THEN
              NQ1    = NQ2
              IPR(2) = 57
              RETURN
            END IF
C * HANDLE CIF-STYLE DATA LABEL
            IF (IABS (IGBL(8)) == 3) THEN
              IF (KL == 3) THEN
                LOP = LOP + 1
                IF (LOP == 1) THEN
                  NQ1 = IFL(3)
                ELSE
C * HANDLE 'Ox' case (avoid infinite loop
                  MODE     = 100
                  NQ1      = IFL(2)
                  IPR(220) = 2
                  KL       = 2
                END IF
              ELSE
                LOP = LOP + 1
C * NUMBER CHARACTER OR LEFT PARENTHESIS IN POSITION 2 ?
                IF (((ICHAR (IFL(2)(2:2)) >= 48 .AND.
     1              ICHAR (IFL(2)(2:2)) <= 57) .OR.
     2              IFL(2)(2:2) == '(')  .AND. LOP < 3) THEN
                  NQ1 = IFL(2)(1:1)//'      '
                ELSE
C * UNSUITABLE ATOM LABEL
                  NQ0    = NQ1
                  IPR(2) = 3
                  RETURN
                END IF
              END IF
C * HANDLE SHELXL/RES STYLE DATA LABEL
            ELSE IF (IABS (IGBL(8)) == 2) THEN
              IF (IAN > 0 .AND. NINT (FN(1)) <= IAN) THEN
C * SUBSTITUTE LEGAL LABEL
                NQ1 = LMT(NINT(FN(1)), 1)//'     '
              ELSE
C * SHELX/SFAC PROBLEM
                IPR(2) = 46
                RETURN
              END IF
C * HANDLE SPF STYLE DATA LABEL
            ELSE IF (IABS (IGBL(8)) == 1) THEN
              IF (KL == 3) THEN
                NQ1 = IFL(3)
              END IF
              CALL GEN020 (1, NQ1, 1, 2)
              IF (NQ1(1:2) == 'HN') NQ1 = 'H'
              IF (NQ1(1:2) == 'HO') NQ1 = 'H'
              IF (ICHAR (NQ1(2:2)) >= 48 .AND.
     1            ICHAR (NQ1(2:2)) <= 57) THEN
                NQ1(2:) = '      '
              ELSE
                NQ1(3:) = '     '
              END IF
            ELSE
C * UNSUITABLE ATOM LABEL
              NQ0    = NQ1
              IPR(2) = 3
              RETURN
            END IF
C * CREATE ACCEPTABLE LABEL
            IF (NQ1(1:1) == ' ') THEN
              NQ1(1:1) = NQ1(2:2)
              NQ1(2:4) = '999'
            ELSE IF (NQ1(2:2) == ' ') THEN
              NQ1(2:4) = '999'
            ELSE
              NQ1(3:4) = '99'
            END IF
            MODE = 99
            NCY  = NCY + 1
            IF (NCY < 2) THEN
              CYCLE
            ELSE
              WRITE (LU6, 99995) IFL(1), IFL(2),IFL(3)
              RETURN
            END IF
          END IF
          IF (MODE == 100) THEN
C * CHECK FOR PRE-OCCURRENCE OF THIS LABEL
            DO K = 1, NAT
              IF (LABA(K) == INQNR) THEN
C * ALERT _070 - DUPLICATE LABEL
                CALL PLA236 (70, 0, 1.0, 1.0, NQ2, ' ')
C * LABEL PRE-OCCURRED, GENERATE NEW LABEL WITH #
                MODE = 99
                EXIT
              END IF
            END DO
          ELSE IF (MODE == 99) THEN
            EXIT
          END IF
          IF (MODE /= 99) EXIT
        END DO
C * HANDLE SPECIAL CASE OF SHELX INPUT STYLE (AS PRODUCED BY SHELX)
        IF (IABS (IGBL(8)) == 2) THEN
          IPR(32) = MAX (IPR(32), 1)
C * SKIP DENSITY
          IF (KN == 7) KN = 6
          IF (KN == 20) THEN
            DO K = 12, 20
              FN(9 + K) = FN(K)
              FN(K)     = 0.0
            END DO
            KN  = 11
            KNS = 9
          ELSE IF (KN == 10) THEN
            DO K = 7, 10
              FN(14 + K) = FN(K)
              FN(K)      = 0.0
            END DO
            KN  = 6
            KNS = 4
          ELSE
            KNS = 0
          END IF
C * COMPLETE WHEN NO(OR INCOMPLETE) POPULATION AND/OR U/UIJ GIVEN
          IF (KN /= 6  .AND. KN /= 11) THEN
            IPR(498) = IPR(498) + 1
            IF (KN == 4) FN(5) = 11.0
            FN(6) = PAR(30)
            KN    = 6
          END IF
          IENR = NINT (FN(1))
C * IMPLEMENT FREE-VARIABLE VALUES
          DO K = 2, KN
            YY = FN(K)
            IF (ABS (YY) > 5.0) THEN
              I  = NINT (ABS (YY) * 0.1)
              IF (I == 1) THEN
                RPI = 1.0
              ELSE
                RPI = RP(I)
              END IF
              SJ = SIGN (0.5, YY)
              IF (I /= 1 .AND. I > IPR(109)) THEN
C * FVAR ERROR
                IPR(2) = 9
                RETURN
              END IF
              YY = (YY - I * SJ * 20.0) * (RPI + SJ - 0.5)
            END IF
            FN(K - 1) = YY
          END DO
          KN = KN - 1
C * X, Y, Z, POP,U  - CASE
          IF (KN == 5) THEN
            FN(9)  = FN(5)
            FN(10) = 0.0
            KN     = 10
          ELSE
            IPR(32) = 2
C * X, Y, Z, POP, U11, U22, U33, U23, U13, U12 - CASE
            DO K = 1, 6
              FN(15 - K) = FN(11 - K)
            END DO
            CALL GEN074 (FN, 15, 20, 0.0)
            KN = 20
          END IF
          CALL GEN074 (FN, 5, 8, 0.0)
C * SKIP (DUMMY) ATOMS WITH POPULATION 0.0
          IF (FN(4) < 0.0001) THEN
            IPR(100) = IPR(100) + 1
            IPR(471) = IPR(471) + 1
            IPR(2)   = 0
            RETURN
          END IF
          IF (KNS > 0) THEN
            DO K = 1, 3
              FN(K + 4) = FN(20 + K)
            END DO
            IF (KNS == 4) THEN
              FN(10) = FN(24)
            ELSE
              DO K = 1, 6
                FN(14 + K) = FN(23 + K)
              END DO
            END IF
          END IF
        ELSE
          IF (KN == 5) KN = 3
C * COMPLETE WITH ZERO'S
          KNP1 = KN + 1
          CALL GEN074 (FN, KNP1, 9, 0.0)
          IF (KN == 6) THEN
C * SHIFT ESD'S
            DO K = 1, 4
              FN(9 - K) = FN(8 - K)
            END DO
            FN(4) = 0.0
          END IF
C * HANDLE ANGSTROM SCALING (DEFAULT 1.0)
          IF (IPR(23) /= 0) THEN
            ISU = 0
            DO K = 1, 3
              FN(K)     = FN(K)     * PAR(11)
              FN(K + 4) = FN(K + 4) * PAR(11)
              IF (FN(K + 4) > 0) ISU = 1
            END DO
          END IF
        END IF
C * HANDLE SHELXL/CIF ISSUE
        IF (FN(24) == 1 .AND. FN(8) == 0.0) THEN
          IF (FN(4) == 0.330) FN(4) = 0.33333
          IF (FN(4) == 0.670) FN(4) = 0.66667
        END IF
C * DO CELL PARAMETER CALCULATION BEFORE FIRST ATOM INSTRUCTION
        IF (IPR(23) == 0) CALL PLA100
C * APPLY CELL TRANSFORMATION
        CALL GEN002 (1, TM2, FN, SGY, XLNG)
        DO K = 1, 3
          DUMA(K) = 0.0
          FNK4    = FN(K + 4)
          IF (FNK4 > 0.0) IPR(72) = 1
          IF (FNK4 < 0.0) FNK4    = 0.0
          FN(K + 4) = FNK4**2
        END DO
        DO K = 1, 3
          IF (IPR(23) == 0) THEN
            DO L = 1, 3
              DUMA(K) = DUMA(K) + TM2(K, L)**2 * FN(L + 4)
            END DO
          ELSE
            DUMA(K) = FN(K + 4)
          END IF
        END DO
        DO K = 1, 3
C * ADD SHIFT VECTOR
          SGY(K)              = SGY(K) + SHFT(K)
          FN(K)               = SGY(K)
          FN(K + 4)           = SQRT (DUMA(K))
          SGY(K + 3)          = 0.0
          CON(NATP1, K + 2)   = FN(K)
          CON(NATP1, K + 5)   = DUMA(K)
          CON(NAT + 2, K + 2) = 0.0
          MULTX               = 0
        END DO
        IHYD = 0
C * TEST FOR HYDROGENS (H, D OR Hw)
        IF (IEN(NIEN + 1) == 1 .OR. IEN(NIEN + 1) == 33 .OR.
     1      IEN(NIEN + 1) == 113) THEN
          IHYD = 1
        END IF
C * SKIP THIS SECTION FOR ANGSTROM DATA (IPR(23) = 1)
        MULT = IPR(23)
        IF (MULT == 0) THEN
          SGY(10) = 0.0
          CALL SGSM (19, IDM, SGY, 0, LU6, IERR)
C * HANDLE MULTIPLICITY ARTIFACT (CIF/PDB..)
          IF (IGBL(8) == 3 .AND. IPR(23) == 0) THEN
            IF (SGY(10) /= 1.0 .AND. IPR(612) >= 0) THEN
              FN(4) = FN(4) * SGY(10)
              IF (FN(8) > 0.0) FN(8) = FN(8) * SGY(10)
            ELSE
C * CHECK FOR SU
              IF (IHYD == 0 .AND. IGBL(94) == 0) THEN
C * ALERT _161
C * ALERT _162
C * ALERT _163
              END IF
            END IF
          END IF
C * MARK (H)ATOMS IN GENERAL POSITIONS WITHOUT SU
          IF (IHYD == 0) THEN
            IF (SGY(10) == 1.0) THEN
              ISU = 1
              IF (FN(5) <= 0.0 .AND. FN(6) <= 0.0 .AND.
     1            FN(7) <= 0.0) ISU = 0
            ELSE
              ISU = 0
              IF (FN(5) > 0.0 .OR. FN(6) > 0.0 .OR. FN(7) > 0)
     1          ISU = 1
            END IF
          ELSE
            ISU = 0
            IF (FN(5) > 0.0 .OR. FN(6) > 0.0 .OR. FN(7) > 0)
     1        ISU = 1
          END IF
C * TAKE PART -N INTO ACCOUNT
          IF (IGBL(8) == 3 .AND. IPR(612) < 0) THEN
            IPR(696) = IPR(696) + 1
            MULT = 1
          ELSE
            IF (ABS(FN(4) / SGY(10) - 0.5) > 0.4998) THEN
C * LOOP OVER ALL SYMMETRY OPERATIONS
              DO J = 1, NSYM
                JSYM = J
                CALL SGSM (3, ICL, SGY, JSYM, LU7, IERR)
C * LOOP OVER CURRENT SET OF ACCEPTED ATOMS + TENTATIVE NEW ONE
                DO I = 1, NATP1
                  VERS = 0.0
                  DO K = 1, 3
                    DUMA(K) = CON(I, K + 2) - SGY(K + 6)
                    DO WHILE (DUMA(K) > 0.5)
                      SGY(K + 6) = SGY(K + 6) + 1.0
                      DUMA(K)    = DUMA(K)    - 1.0
                    END DO
                    DO WHILE (DUMA(K) <= - 0.5)
                      SGY(K + 6) = SGY(K + 6) - 1.0
                      DUMA(K)    = DUMA(K)    + 1.0
                    END DO
                  END DO
                  VERS = SQRT (PAR(129) * DUMA(1) ** 2
     1                       + PAR(130) * DUMA(2) ** 2
     2                       + PAR(131) * DUMA(3) ** 2
     3                       + PAR(132) * DUMA(1) * DUMA(2)
     4                       + PAR(133) * DUMA(1) * DUMA(3)
     5                       + PAR(134) * DUMA(2) * DUMA(3))
C * CONSIDER/DELETE CLOSE CONTACT ATOM (Q-ATOMS ...)
                  IF (VERS < RGBL25) THEN
C * CONSIDER X-H
                    CALL GEN048 (-1, IFG(1, I), 7, IHAT)
                    IF (IHAT == 1 .OR. IHYD == 1) THEN
                      IF (VERS > PAR(22)) CYCLE
                    END IF
                    IF (NQ2(1:1) /= 'Q' .AND. VERS > PAR(22))
     1                CYCLE
                    IF (I /= NATP1) THEN
                      CALL PLA047 (LABA(I), NQ2, IENM, JDUM,
     1                  IPR(71), IGBL(55), 0, 0)
C * BUT DO NOT ELIMINATE EXPLICITLY DISORDERED ATOMS
                      IPR(100) = IPR(100) + 1
                      WRITE (LU6, 99999, IOSTAT = IOST)
     1                  NQ1(1:7), VERS, NQ2(1:7)
C * AVERAGE POSITIONS (FOR SAME ATOM TYPES)
                      IF (VERS < PAR(22)) THEN
                        IF (IEN(IENM1) == JDUM) THEN
                          DO K = 1, 3
                            FN(K) = (CON(I, K + 2) + SGY(K + 6)) / 2.0
                            CON(I, K + 2) = FN(K)
                          END DO
                          FN(4) = - 1.0
C * WRITE CORRECTION
                          WRITE (LU4) 11, CON(I, 2), (FN(K), K = 1, 8)
                        END IF
                        WRITE (LU6, 99998, IOSTAT = IOST)
     1                    NQ1(1:7), VERS, NQ2(1:7), (FN(K), K = 1, 3)
                      END IF
C * ALERT _310
                      CALL PLA236 (310, 3, VERS, VERS, NQ1, NQ2)
                      IPR(471) = IPR(471) + 1
                      IPR(107) = 1
                      IPR(2)   = 0
                      RETURN
                    ELSE
                      IF (MULT == 0 .OR. IABS (IGBL(8)) /= 2 .OR.
     1                               IABS (IGBL(8)) /= 3) THEN
                        MULTX = MULTX + 1
                        MULT  = MULT + 1
                        DO K = 1, 3
                          CON(NAT + 2, K + 2) = CON(NAT + 2, K + 2)
     1                                        + SGY(K + 6)
                        END DO
                      END IF
                    END IF
                  END IF
                END DO
              END DO
            ELSE
              MULT = NINT (1.0 / SGY(10))
            END IF
          END IF
        END IF
        IF (IGBL(8) == 3 .AND. FN(35) == 1.0 .AND. MULT /= 1) THEN
          FN(4) = FN(4) * MULT
          FN(8) = FN(8) * MULT
        END IF
        CALL PLA047 (INQNR, NQ2, MN, JDUM, 0, IGBL(55), 0, 0)
        DO K = 1, NP64
          IF (NQ2(K : K) == '#') THEN
            IF (IPR(759) == 1) THEN
              IPR(71)  = 0
              IPR(350) = 0
            END IF
            CALL PLA282 (1, IFL(IPR(473)), NQ2, LU6)
            EXIT
          END IF
        END DO
        IF (IPR(39) == 0) IPPR(1, 3) = NSYM
        IPR(39)       = IPR(39) + 1
        IPR(37)       = IPR(39)
        LABA(IPR(39)) = INQNR
C * SHELX(L)/RES
        IF (IABS (IGBL(8)) == 2) THEN
          CON(IPR(39), 8) = IENR
          CON(IPR(39), 9) = FN(4)
        END IF
        IF (IPR(37) == 1) THEN
C * CHECK FOR CIF-DATA
          IF (IABS (IGBL(8)) == 3) THEN
            IF (IGBL(94) == 0) THEN
              IF (CCIF(7)(1:11) /= CCIF(8)(1:11) .AND.
     1            IPR(319) * IPR(318) == 1) THEN
                IDM = CCIF(8)
C * ELIMINATE BLANKS
                CALL GEN047 (IDM, 1, 20)
                NQ2 = IDM(1:7)
                CALL GEN020 (-1, NQ2, 2, 7)
                IF (NQ2(1:1) == ' ') NQ2(1:1) = '?'
                J = INDEX (NQ2(2:7), 'r')
                IF (J /= 0) NQ2(J+1:J+1) = 'R'
                IF (J == 0 .OR. IPR(606) /= 8) THEN
                  IDM = CCIF(6)
                  CALL GEN047 (IDM, 1, 20)
C * ALERT _120
                  IF (IDM(1:1) /= '?') THEN
                    NQ3 = '  '//NQ2(1:7)
                    CALL PLA236 (120, 0, -999.0, 1.0, IDM(1:7), NQ3)
                  END IF
                END IF
              END IF
            END IF
          END IF
        END IF
C * INIT FLAG ARRAY ENTRIES
        DO I = 1, 3
          IFG(I, IPR(39)) = 0
        END DO
        IF (IABS (IGBL(8)) == 3) THEN
C * 'd'
          IF (FN(21) == 1.0) CALL GEN048 (1, IFG(3, IPR(39)), 1, 1)
C * 'c'
          IF (FN(22) == 1.0) CALL GEN048 (1, IFG(3, IPR(39)), 2, 1)
C * 'dum'
          IF (FN(23) == 1.0) CALL GEN048 (1, IFG(3, IPR(39)), 3, 1)
 
          IF (FN(22) == 1.0) THEN
C * ALERT _166
            IF ((FN(5) > 0.0 .OR. FN(6) > 0.0 .OR.
     1          FN(7) > 0.0) .AND. FN(30) /= 1.0 .AND.
     2          FN(26) /= 1.0) THEN
                  CALL PLA236 (166, 0, 1.0, 1.0, IFL(IPR(473)), ' ')
            END IF
          END IF
C * 'S'
          IF (FN(24) == 1.0) CALL GEN048 (1, IFG(3, IPR(39)), 4, 1)
C * 'G'
          IF (FN(25) == 1.0) CALL GEN048 (1, IFG(3, IPR(39)), 5, 1)
C * 'R'
          IF (FN(26) == 1.0) CALL GEN048 (1, IFG(3, IPR(39)), 6, 1)
C * 'D'
          IF (FN(27) == 1.0) CALL GEN048 (1, IFG(3, IPR(39)), 7, 1)
C * 'T'
          IF (FN(28) == 1.0) CALL GEN048 (1, IFG(3, IPR(39)), 8, 1)
C * 'U'
          IF (FN(29) == 1.0) CALL GEN048 (1, IFG(3, IPR(39)), 9, 1)
C * 'P'
          IF (FN(30) == 1.0) CALL GEN048 (1, IFG(3, IPR(39)), 10, 1)
C * COUNT NON-H R-Status
          IF (IHYD == 0 .AND. FN(26) == 1.0) THEN
            IPR(164) = IPR(164) + 1
          END IF
C * DISORDER ASSEMBLY
C * 'A'
          IF (FN(31) == 1.0) CALL GEN048 (1, IFG(3, IPR(39)), 11, 1)
C * 'B'
          IF (FN(32) == 1.0) CALL GEN048 (1, IFG(3, IPR(39)), 12, 1)
C * 'S'
          IF (FN(33) == 1.0) CALL GEN048 (1, IFG(3, IPR(39)), 13, 1)
C * DISORDER GROUP
        END IF
C * SET SHELXL PART #
        IVL = IPR(612) + 16
        CALL GEN048 (5, IFG(3, IPR(39)), 14, IVL)
C * SET SPECIAL POSITION BIT (6)
        IF (MULT > 1) CALL GEN048 (1, IFG(1, IPR(39)), 6 , 1)
C * SET ATOM TYPE NUMBER REFERENCE
        CALL GEN048 (4, IFG(1, IPR(39)), 15, NIEN)
C * HANDLE EXPLICIT MOVE/FIX INSTRUCTION FOR THIS ATOM
        IF (IPR(165) > 0) THEN
          ITRNS    = IPR(165)
          IPR(165) = 0
        ELSE
          ITRNS    = IPR(95)
        END IF
        IATP(IPR(39)) = ITRNS
C * SET SHELXL POPULATION RESTRAINT
        CALL GEN048 (-1, IFG(3, IPR(39)), 10, IPOPRES)
C * REGISTER H-ATOM STATUS
        CALL GEN048 (1, IFG(1, IPR(39)), 7, IHYD)
C * TEST FOR ELEMENT TYPE  (METAL) - SET METAL BIT
        IF (IATPR(IEN(NIEN + 1)) > 0) THEN
          CALL GEN048 (1, IFG(1, IPR(39)), 19, 1)
C * REGISTER METAL CONTAINING COMPOUND
          IPR(155) = 1
C * RESET FROM ORGANIC DEFAULT BOND RADII TO METAL STRUCTURE RADII
          PAR(85)  = 2
          PAR(87)  = 1
        END IF
        NPOP    = IPR(65)
        POPPARX = FN(4) * MULT
C * CHECK POPULATION PARAMETER RANGE (FOR NON-CSD DATA)
        IF (IABS (IGBL(8)) == 3) THEN
C * ALERT _075 - IMPOSSIBLE POPULATION PARAMETER VALUE > 1.0
          IF (POPPARX > 1.001 .AND. IGBL(94) == 0)
     1        CALL PLA236 (75, 3, 1.0, POPPARX, IFL(IPR(473)), ' ')
C * ALERT _076
          IF (POPPARX < 1.0 .AND. MULT /= 1
     1        .AND. ABS (MULT * POPPARX - 1.0) < 0.01
     2        .AND. IPOPRES == 0) THEN
              CALL PLA236 (76, 3, 0.5, POPPARX, IFL(IPR(473)), ' ')
          END IF
        END IF
C * CHECK LABEL ORDER IN CIF
        IF (IGBL(8) == 3) THEN
          IF (MOD (JNQNR, 40) == 0) THEN
            N   = IEN(IENM1)
C * CHECK CARBON ORDER
            IF (N == 2) THEN
              IF (JNQNR > IATYC) THEN
                IATYC = JNQNR
              ELSE
                IPR(545) = IPR(545) + 1
                IF (IPR(545) == 1 .AND. IPR(105) == 0) THEN
C * ALERT _795
                  CALL PLA236 (795, 0, -999.0, 1.0, NQ1, ' ')
                END IF
              END IF
C * CHECK OXYGEN ORDER
            ELSE IF (N == 3) THEN
              IF (JNQNR > IATYO) THEN
                IATYO = JNQNR
              ELSE
                IPR(546) = IPR(546) + 1
                IF (IPR(546) == 1 .AND. IPR(105) == 0) THEN
C * ALERT _796
                  CALL PLA236 (796, 0, -999.0, 1.0, NQ1, ' ')
                END IF
              END IF
C * CHECK NITROGEN ORDER
            ELSE IF (N == 4) THEN
              IF (JNQNR > IATYN) THEN
                IATYN = JNQNR
              ELSE
                IPR(547) = IPR(547) + 1
                IF (IPR(547) == 1 .AND. IPR(5) == 0) THEN
C * ALERT _797
                  CALL PLA236 (797, 0, -999.0, 1.0, NQ1, ' ')
                END IF
              END IF
            END IF
          END IF
        END IF
C * HANDLE POPULATION > 1 FOR NON-CIF
        IF (IABS(IGBL(8)) == 3 .AND. IPR(23) == 0) THEN
          FN(4) = POPPARX
        ELSE
          FN(4) = MIN (1.0, POPPARX)
        END IF
        FN(8) = FN(8) * MULT
C * SET DEFAULT PP TO 1.0 AND ESD TO 0
        IF (IGBL(8) /= 3) THEN
          IF (FN(4) < PAR(12)) FN(4) = 1.0
        END IF
        IF (FN(8) < 0.0) FN(8) = 0.0
        IF (FN(4) < 0.5) JNQNR = JNQNR + 150 * 4000
        JR(IPR(39)) = JNQNR
        INTPOP      = NINT (FN(4) * 10000.0)
        IF (INTPOP == 5000) THEN
          IF (FN(4) > 0.5) INTPOP = 5001
          IF (FN(4) < 0.5) INTPOP = 4999
        END IF
        IPPR(NPOP + 1, 1) = INTPOP
        IPPR(NPOP + 1, 2) = NINT (FN(8) * 10000.0)
        IPPR(NPOP + 1, 3) = NSYM  / MULT
        FN(4)             = FN(4) / MULT
        FN(8)             = FN(8) / MULT
C * PROVISIONAL CALCULATION OF THE DENSITY
        IF (IHYD == 0) PAR(386) = PAR(386) + NSYM * FN(4)
        PAR(388) = PAR(388) + NSYM * FN(4) * ATWT(IEN(NIEN + 1))
        PAR(387) = PAR(388) / (PAR(98) * 0.60221)
C * RESET COORDINATES TO SPECIAL POSITION
        IF (MULTX > 1 .AND. INTPOP == 10000) THEN
          DO K = 1, 3
            CON(NAT + 1, K + 2) = CON(NAT + 2, K + 2) / MULTX
            FN(K) = CON(NAT + 1, K + 2)
          END DO
        END IF
        MULT = NSYM / MULT
        IF (MOD (IPPR(NPOP + 1, 1), 10000) /= 0) THEN
          IPR(44) = 1
          IF (IHYD == 0) IPR(43) = 1
        END IF
C * SET POPULATION PARAMETERS
        DO I = 1, NPOP
          IF (IPPR(I, 3) == IPPR(NPOP + 1, 3) .AND.
     1        IPPR(I, 1) == IPPR(NPOP + 1, 1)) THEN
            IPOP = I - 1
            GO TO 50
          END IF
        END DO
        IPOP = NPOP
        IF (IPOP > MP7) THEN
C * POPULATION PARAMETER OVERFLOW
          IPR(92) = IPR(92) + 1
          IPR(2) = 10
          RETURN
        ELSE
          IPR(65) = IPR(65) + 1
        END IF
C * SET POPULATION NUMBER
   50   CALL GEN048 (8, IFG(2, IPR(39)), 1, IPOP)
C * SET ISU (0/1) - I.E. STANDARD UNCERTAINTY
        CALL GEN048 (1,  IFG(2, IPR(39)), 10, ISU)
        IF (FN(8) > 0.0)
     1    CALL GEN048 (1, IFG(2, IPR(39)), 29, 1)
        CALL GEN048 (-1, IFG(1, IPR(39)), 7, JHAT)
        IF (JHAT == 1) IPR(564) = IPR(564) + ISU
C * SET LABEL ON
        CALL GEN048 (1, IFG(2, IPR(39)), 11, 1)
C * COUNT # ATOMS WITH SU
        IF (FN(5) + FN(6) + FN(7) > 0.0001) IPR(745) = IPR(745) + 1
        WRITE (LU4) 1, INQNR, (FN(K), K = 1, 8)
C * HANDLE MULTIPLICATIVE UEQ TRANSFER TO U-HATOMS (SHELXL)
        IF (IABS (IGBL(8)) == 2) THEN
          IF (FN(9) < 0.0) THEN
            FN(9) = - FN(9) * PAR(61)
          ELSE
            IF (IHYD == 0) PAR(61) = FN(9)
          END IF
        END IF
        IF (KN == 10) WRITE (LU4) 4, INQNR, (FN(K), K = 9, 16)
        IF (KN == 20) THEN
C * SET ANISO-FLAG
          CALL GEN048 (1, IFG(1, IPR(39)), 4, 1)
          CALL GEN144 (1, FN(9), PAR(135))
C * LOAD U-MATRIX(6 TO 9 COMPONENTS)
          CALL GEN025 (DUMV, FN(9), -1)
C * CALCULATE TM2 * UIJ * TR(TM2)
          CALL GEN001 (1, TM2, DUMV, UIJ)
C * EXTRACT FROM TRANSFORMED U-MATRIX (9 TO 6 COMPONENTS)
          CALL GEN025 (UIJ, FN(9), 1)
          CALL GEN144 (-1, FN(9), PAR(113))
C * SAVE UEQ FOR SHELXL H-ATOMS WITH ASSOCIATED NEGATIVE U'S
          IF (IABS(IGBL(8)) == 2 .AND. IHYD == 0) THEN
            CALL GEN025 (UIJ, FN(9), -1)
C * UIJ - MAIN AXES & VALUES & UEQ
            CALL GEN114 (PAR, OR, UIJ, UIJC, DUMA, DUMV, PAR(61))
          END IF
C * WRITE UIJ AND SUIJ
          WRITE (LU4) 2, INQNR, (FN(K), K =  9, 16)
          WRITE (LU4) 3, INQNR, (FN(K), K = 15, 22)
        END IF
      ELSE
        IPR(2) = 1
      END IF
      RETURN
99999 FORMAT (':: ATOM ', A, ' DELETED from INPUT STREAM, ',
     1          F5.2, ' Ang. From ', A)
99998 FORMAT (':: ATOM ', A, ' at', F5.2, ' Ang. from ', A,
     1        ' - New Av Pos:', 3F8.4)
99997 FORMAT ('_', I1)
99996 FORMAT ('_', I2)
99995 FORMAT (':: Label Problem in PLA022', 2X, 3A)
      END SUBROUTINE PLA022
 
      SUBROUTINE PLA023 (MBRAV)
C * LOAD AND EXPAND ASYMMETRIC UNIT COORDINATE SET TO PRIMITIVE TRICLINIC
C * (OPTIONALLY (i.e. NBRAV = 0; EXCL. BRAVAIS LATTICE CENTERING)
      USE files
      USE parameters
      USE plato
      USE atomdata
      USE cchar
      USE sgxyz
      IMPLICIT NONE
      INTEGER :: I
      INTEGER :: J
      INTEGER :: K
      INTEGER :: L
      INTEGER :: M
      INTEGER :: N
      INTEGER :: MN
      INTEGER :: IAT
      INTEGER :: KAT
      INTEGER :: ICT
      INTEGER :: IBV
      INTEGER :: NAT
      INTEGER :: NO1
      INTEGER :: IVAL
      INTEGER :: NUEQ
      INTEGER :: NPDS
      INTEGER :: IENR
      INTEGER :: INQNR
      INTEGER :: NSYMR
      INTEGER :: NSYMI
      INTEGER :: NSYML
      INTEGER :: MBRAV
      LOGICAL :: SFBUILDIN
      LOGICAL, DIMENSION(16) :: SFLOADED
      DO I = 1, 16
        SFLOADED = .FALSE.
      END DO
C * GET NUMBER OF UNIQUE ATOMS
      NAT   = IPR(37)
C * GET NUMBER OF SYMM. OPER. EXCLUDING INVERSION & BRAVAIS CENTERING
      NSYMR = IPR(255)
C * GET DATA ON INVERSION CENTER
      NSYMI = IPR(257)
C * GET DATA ON LATTICE CENTERING
      IF (MBRAV /= 0) THEN
        IBV = IPR(256)
      ELSE
        IBV = 1
      END IF
      NSYML = NSYMR * NSYMI * IBV
C * CHECK FOR ARRAY OVERFLOW
      IF (NAT * NSYML > NP1) THEN
        WRITE (LU6, 99997, IOSTAT = IOST) NP1
        IPR(589) = -1
        RETURN
      END IF
C * REPORT ON TYPE OF LOADED SCATTERING FACTORS FOR SF-CALCULATION
      IF (IGBL(146) == 0 .OR.
     1   (IGBL(146) == 1 .AND. IPR(762) == 0) .OR.
     2   (IGBL(146) == 2 .AND. IPR(763) == 0)) THEN
        SFBUILDIN = .true.
        IF (IPR(493) < 7) THEN
          WRITE (LU6, 99994) 'X-ray, Cromer & Mann, Buildin'
        ELSE IF (IPR(493) == 7) THEN
          WRITE (LU6, 99994) 'Neutron Data Booklet, Buildin'
        ELSE IF (IPR(493) == 8) THEN
          WRITE (LU6, 99994) 'Electron, Peng, Buildin'
        END IF
      ELSE
        SFBUILDIN = .false.
        WRITE (LU6, 99994) 'User Supplied'
      END IF
C * GET ATOM PARAMETERS FROM (SAVE-)FILE LU4
      NUEQ = 0
      NPDS = 0
      CALL GEN021 (UKL, 0.0)
      CALL GEN108 (LU4, 0)
      DO
        READ (LU4, IOSTAT = IOST) ICT, INQNR, (FN(J), J = 1, 8)
        IF (IOST /= 0 .OR. ICT == 6) EXIT
        DO I = 1, NAT
          IF (LABA(I) == INQNR) THEN
            K = I
            SELECT CASE (ICT)
C * LOAD COORDINATES AND POPULATION
              CASE (1)
                CALL GEN048 (-1, IFG(1, K), 30, IVAL)
                IF (IVAL == 1) THEN
                  FN(4) = 0.0
                  CALL PLA047 (INQNR, NQ1, MN, IENR, 1, IGBL(55), 0, 0)
                  WRITE (LU6, 99996, IOSTAT = IOST) NQ1
                  WRITE (LU7, 99996, IOSTAT = IOST) NQ1
                END IF
                DO J = 1, 4
                  XXO(K, J) = FN(J)
                END DO
C * LOCATE AND LOAD SCATTERING FACTOR DATA FOR THIS ATOM
                CALL GEN048 (-4, IFG(1, K), 15, NO1)
C * TEST FOR XRAY + SYNCHROTRON
                M = IEN (NO1 + 1)
C * CHECK FOR INTERNAL/EXTERNALLY PROVIDED SCATTERING FACTORS
                IF (SFBUILDIN) THEN
C * LOAD INTERNALLLY STORED NEUTRAL XRAY SCATTERING FACTORS
                  IF (IABS (IPR(493)) < 7) THEN
                    M = (M - 1) * 19
                    DO J = 1, 9
                      CON(K, J) = SFAC(M + J)
                    END DO
C * LOAD INTERNALLY STORED NEUTRON SCATTERING LENGTH
                  ELSE IF (IABS (IPR(493)) == 7) THEN
                    DO J = 1, 8
                      CON(K, J) = 0.0
                    END DO
                    CON(K, 9) = RNSCL(M)
C * LOAD INTERNALLY STORED ELECTRON SCATTERING FACTORS
                  ELSE IF (IABS (IPR(493)) == 8) THEN
                    M = (M - 1) * 8
                    DO J = 1, 8
                      CON(K, J) = PENG(M + J)
                    END DO
                    CON(K, 9) = 0.0
                  END IF
                ELSE
C * SUBSTITUTE CIF PROVIDED SCATTERING FACTORS
                  IF (IGBL(8) == -3) THEN
                    N = 0
                    IF (IGBL(146) == 1) THEN
                      L = IPR(762)
                      M = 1
                    ELSE
                      L = IPR(763)
                      M = 2
                    END IF
                    DO J = 1, L
                      IF (DISPTYPE(J, M) == LMT(NO1 + 1, 1)) THEN
                        N = J
                        EXIT
                      END IF
                    END DO
                    DO J = 1, 9
                      IF (N > 0) THEN
                        CON(K, J) = CIFSF(N, J, M)
                      ELSE
                        CON(K, J) = 0.0
                      END IF
                    END DO
                  END IF
                END IF
                IF (.NOT. SFLOADED(NO1 + 1)) THEN
                  WRITE (LU6, 99995) LMT(NO1 + 1, 1),
     1              (CON(K, J), J = 1, 9)
                  SFLOADED(NO1 + 1) = .true.
                END IF
C * STORE REFERENCE TO F' AND F"
                IATP(K) = NO1 + 1
C * LOAD UIJ OR UEQ
              CASE (2)
                DO J = 1, 6
                  XSD(K, J) = FN(J)
                END DO
C * LOAD ISOTROPIC U (ADD 100.0 TO MARK AS UISO)
              CASE (4)
                XSD(K, 1) = FN(1) + 100.0
            END SELECT
            EXIT
          END IF
        END DO
      END DO
C * EXPAND BY SYMMETRY TO UNIT CELL FILL (EXCLUDING BRAVAIS CENTERING)
C * TEST FOR NEWSYM MODE (=> SET TO ISOTROPIC VALUE)
      IF (IPR(210) == -2) THEN
        DO K = 1, NAT
          XSD(K, 1) = PAR(247) + 100.0
          CALL GEN048 (1, IFG(1, K), 4, 0)
        END DO
      END IF
      KAT = NAT
      IF (NSYML > 1) THEN
        DO L = 2, NSYML
          DO IAT = 1, NAT
            CALL GEN048 (-1, IFG(1, IAT), 4, IVAL)
C * TRANSFORM COORDINATES
            DO M = 1, 3
              SGY(M)     = XXO(IAT, M)
              SGY(M + 3) = 0.0
            END DO
            CALL SGSM (3, ICL, SGY, L, LU7, IERR)
            KAT = KAT + 1
            DO M = 1, 3
              XXO(KAT, M) = SGY(M + 6)
            END DO
C * COPY LABEL, POPULATION, FLAGS & SCATTERING FACTORS.
            LABA(KAT)   = LABA(IAT)
            XXO(KAT, 4) = XXO(IAT, 4)
            DO M = 1, 3
              IFG(M, KAT) = IFG(M, IAT)
            END DO
            DO M = 1, 9
              CON(KAT, M) = CON(IAT, M)
            END DO
            IATP(KAT) = IATP(IAT)
C * TRANSFORM UIJ
            IF (IVAL == 1) THEN
              CALL SGSM (6, ICL, SGY, L, LU7, IERR)
              DO M = 1, 9
                J = MOD (M - 1, 3) + 1
                K = ((M - 1) / 3)  + 1
                RIK(K, J) = SGY(M)
              END DO
              DO J = 1, 6
                DUMA(J) = XSD(IAT, J)
              END DO
              CALL GEN025 (UKL, DUMA, -1)
              CALL GEN001 (1, RIK, UKL, UIJ)
              CALL GEN025 (UIJ, DUMA, 1)
              DO J = 1, 6
                XSD(KAT, J) = DUMA(J)
              END DO
            ELSE
              XSD(KAT, 1) = XSD(IAT, 1)
            END IF
          END DO
        END DO
      END IF
      IF (NUEQ > 0) WRITE (LU6, 99999, IOSTAT = IOST) NUEQ
      IF (NPDS > 0) WRITE (LU6, 99998, IOSTAT = IOST) NPDS
C * SAVE NATO
      IPR(589) = KAT
      RETURN
99999 FORMAT (':: # Anisotropic atoms converted to isotropic =', I4)
99998 FORMAT (':: # of NPDs reset to U = 0.03 =', I4)
99997 FORMAT ('F: # of Atoms in Expanded set exceeds NP1 =', I5)
99996 FORMAT (':: ', A, ' OMITted From SF-Calculations')
99995 FORMAT (A, 1X, 9F8.4)
99994 FORMAT (':: Used Scattering Factors for SF-Calc: ', A, /)
      END SUBROUTINE PLA023
 
      SUBROUTINE PLA024
C * ANALYSES OF ANISOTRPIC TEMP. FACT. AND OUTPUT OF CONNECTED SET
      USE files
      USE parameters
      USE plato
      USE atomdata
      USE cchar
      USE sgxyz
      IMPLICIT NONE
      INTEGER :: I
      INTEGER :: J
      INTEGER :: K
      INTEGER :: N
      INTEGER :: K0
      INTEGER :: K1
      INTEGER :: JM
      INTEGER :: NSU
      INTEGER :: NAT
      INTEGER :: MT1
      INTEGER :: MT2
      INTEGER :: MT3
      INTEGER :: MR1
      INTEGER :: ICT
      INTEGER :: MNM
      INTEGER :: LBB
      INTEGER :: LBC
      INTEGER :: LBD
      INTEGER :: IHAT
      INTEGER :: IENM
      INTEGER :: NATB
      INTEGER :: NANG
      INTEGER :: JDUM
      INTEGER :: IVAL
      INTEGER :: ILMP
      INTEGER :: ILABA
      INTEGER :: ISPEC
      INTEGER :: INQNR
      INTEGER :: JNQNR
      REAL :: T1
      REAL :: T2
      REAL :: DUM1
      REAL :: DUM2
      REAL :: DUM3
      REAL :: YUNK
      CHARACTER(len=1) :: NOTE1
C * GET NUMBER OF INPUT ATOMS
      NAT  = IPR(37)
C * GET TOTAL NUMBER OF ATOMS
      NATB = IPR(39)
C * GET ATOM CHARACTERISTICS (HYBRIDYSATION ETC.)
      DO I = 1, NATB
        CALL PLA099 (1, I, NANG, DUM1, DUM2, DUM3, NOTE1)
      END DO
C * SAVE CURRENT CONTENTS OF XXO, XSD, CON TEMPORARILY TO VOID ARRAY
      CALL PLA269 (1, NATB)
C * VOID - SCRATCH LAYOUT FOR TEMPORARY STORAGE OF DATA LISTED BELOW
C * 1 ==> IPR(297)  = XXO, XSD, CON, XSD(4:6)=LABEL POS SAVE AREA
      IPR(297) = NP1 * NP71
C * IPR(297) + 1 ==> IPR(298) = ADP
C * BONDS FROM IPR(298)
      IPR(298) = IPR(297) + NP1 * 21
C * WRITE TERMINATOR TO LU4 AND REWIND
      WRITE (LU4) 6, (FN(K), K = 1, 9)
      CALL GEN108 (LU4, 0)
C * ZERO ARRAYS
      CALL GEN074 (DATC, 1, NAT, 0.0)
      CALL GEN074 (UIJC, 1, 9, 0.0)
C * GET COORDINATES, (AN)ISOTROPIC DISPLACEMENT PARAMETERS ETC. FROM LU4
      DO
        READ (LU4) ICT, INQNR, (FN(K), K = 1, 8)
        IF (ICT == 6) EXIT
        DO I = 1, NAT
          IF (LABA(I) == INQNR) THEN
C * ATOM RECORD - COORDINATE AND SOF (11 = UPDATE)
            IF (MOD (ICT, 10) == 1) THEN
              IF (FN(4) > 0.0) THEN
                JM = 4
              ELSE
                JM = 3
              END IF
              DO J = 1, JM
                CON(I, J) = FN(J)
                YUNK      = FN(J + 4)
                IF (YUNK < 0.0) YUNK = 0.0
                CON(I, J + 4) = YUNK
              END DO
              IF (ICT == 1) THEN
                ANIS(I, 1) = 0.0
                SUAN(I, 1) = 0.0
              END IF
C * UIJ - RECORD
            ELSE IF (ICT == 2) THEN
              DO J = 1, 6
                ANIS(I, J) = FN(J)
                SUAN(I, J) = 0.0
              END DO
              CALL GEN048 (1, IFG(1, I), 4, 1)
C * SUIJ - RECORD
            ELSE IF (ICT == 3) THEN
              NSU = 0
              DO J = 1, 6
                IF (FN(J) > 0.0) THEN
                  SUAN(I, J) = FN(J)
                ELSE
                  NSU = NSU + 1
                END IF
              END DO
              IF (NSU > 0) THEN
                IF (IGBL(94) == 0 .AND. ABS (IGBL(8)) == 3) THEN
                  CALL GEN048 (-1, IFG(1, I), 6, ISPEC)
                  IF (ISPEC == 0) THEN
                    ILABA = - LABA(I)
                    CALL PLA047 (ILABA, NQ1, MNM, JDUM, IPR(71),
     1                IGBL(55), 0, 0)
C * ALERT _218
                    CALL PLA236 (218, 0, 1.0, FLOAT (NSU), NQ1, ' ')
                  END IF
                END IF
              END IF
C * IFU - RECORD
            ELSE IF (ICT == 4) THEN
              ANIS(I, 1) = FN(1)
              DATC(I)    = FN(1)
              IF (FN(2) <= 0.0) FN(2) = 0.0
              SUAN(I, 1) = FN(2)
C * MOVE - RECORD
            ELSE
              N = NINT (FN(1))
              CALL PLA025 (I, N)
              CYCLE
            END IF
            CYCLE
          END IF
        END DO
      END DO
C * END - COMPLETE WITH SYMMETRY EXPANDED ATOMS
      DO I = NAT + 1, NATB
C * GET SYMMETRY OPERATION
        ILABA = - LABA(I)
        CALL PLA047 (ILABA, NQ1, MNM, JDUM, IPR(71), 1, 0, 0)
        CALL GEN098 (MOL(MNM), PAR(42), N, MT1, MT2, MT3, MR1)
        FN(2) = MT1
        FN(3) = MT2
        FN(4) = MT3
C * GET SERIAL NUMBER OF NQ1 IN PRIMARY ATOM LIST AND RETURN RESULT IN J
        CALL PLA046 (2, NQ1, IENM, LBB, LBC, LBD, ILMP, JNQNR, J)
        IF (J < 0) THEN
          WRITE (LU6, 99999, IOSTAT = IOST) J, NQ1
          CALL PLA004 (0)
          EXIT
        ELSE
          DO K = 1, 9
            CON(I, K) = CON(J, K)
          END DO
          DO K = 1, 6
            ANIS(I, K) = ANIS(J, K)
            SUAN(I, K) = SUAN(J, K)
          END DO
          CALL GEN048 (-1, IFG(1, J), 4, IVAL)
          CALL GEN048 ( 1, IFG(1, I), 4, IVAL)
C * MOVE
          CALL PLA025 (I, N)
        END IF
      END DO
C * GENERATE DATA IN FORMAT SUITABLE FOR ADP (ORTEP-LOOK ALIKE)
C * ? + 100 NEEDED FOR 'DEFINE INSTRUCTION
      DO I = 1, NATB + 100
C * TEST FOR H-ATOM
        CALL GEN048 (-1, IFG(1, I), 7, IHAT)
C * TEST FOR ISO/ANISOTROPIC
        CALL GEN048 (-1, IFG(1, I), 4, IVAL)
        IF (I <= NATB) THEN
          IF (ANIS(I, 1) <= 0.0 .AND. IVAL == 0) THEN
            IF (IHAT == 0) THEN
              ANIS(I, 1) = PAR(30)
              IPR(171)  = IPR(171) + 1
            ELSE
              ANIS(I, 1) = PAR(30)
              IPR(172)  = IPR(172) + 1
            END IF
          END IF
          IF (IVAL /= 0) THEN
            DO K = 1, 6
              DUMA(K) = ANIS(I, K)
            END DO
            CALL GEN025 (UIJ, DUMA, -1)
          ELSE
            UIJ(1, 1) = ANIS(I, 1)
          END IF
C * CONVERT TEMP FACTOR COEFFICIENTS TO STANDARD TYPE B(I, J)
C * TEST FOR ISO/ANISOTROPIC
        ELSE
          IVAL      = 0
          IHAT      = 0
          UIJ(1, 1) = - 0.1
        END IF
C * ISOTROPIC CASE
        IF (IVAL == 0) THEN
          T1 = SQRT (MAX (0.0, UIJ(1, 1)))
          IF (IPR(32) == 0 .OR. T1 <= 0 .OR. IHAT == 1) THEN
            IF (IHAT == 1) THEN
              IF (IPR(603) == 0) T1 = PAR(265)
            ELSE
              T1 = PAR(266)
            END IF
          END IF
C * DUMMY SPHERE AND REFERENCE VECTORS FOR SPHERE
          DO J = 1, 3
            DUMA(J) = T1
            DO K = 1, 3
              DAM(J, K) = ROR(J, K)
              IF (J == K) THEN
                UIJC(J, K) = T1
              ELSE
                UIJC(J, K) = 0.0
              END IF
            END DO
          END DO
        ELSE
C * UIJ - Main Axes & VALUES & UEQ
          CALL GEN114 (PAR, OR, UIJ, UIJC, DUMA, PAT, T1)
C * MAKE EIGENVECTORS 1 ANGSTROM LONG
          CALL GEN019 (AA, BB, PAT(1, 1), PAT(1, 3), DAM(1, 1), -1)
C * SQRT EIGENVALUE = RMS DISPLACEMENT
          DO J = 1, 3
            T2      = DUMA(J)
            DUMA(J) = SIGN (SQRT (ABS(T2)), T2)
          END DO
        END IF
C * SAVE MAIN-AXES, MAIN-COMPONENTS AND ORTHOGONALIZED UIJ
        DO J = 1, 9
          K0 = MOD (J - 1, 3) + 1
          K1 = ((J - 1) / 3) + 1
          VOID(IPR(297) + I * 21 + J - 21) = DAM(K0, K1)
          VOID(IPR(297) + I * 21 + J -  9) = UIJC(K0, K1)
        END DO
        DO J = 1, 3
          VOID(IPR(297) + I * 21 + J - 12) = DUMA(J)
        END DO
      END DO
C * TEST FOR NO-PLOTTING, ORTEP or PLUTON
      IF (IPR(14) == 0 .OR. IPR(14) == 4 .OR.
     1    IPR(14) == 6) THEN
C * LIST DISPLACEMENT PARAMETERS (NOT FOR RS-CIP)
        IF (IPR(777) == 0) CALL PLA026
        IF (IPR(504) == 0 .AND. IGBL(22) /= -1) THEN
C * DO TLS-ANALYSIS (NOT IN PLUTON OR ORTEP MODES) -  ORGANIC ONLY
          IF (IPR(14) /= 6 .AND. IPR(14) /= 4 .AND.
     1      IGBL(97) == 1) THEN
            CALL PLA027
          ELSE
            IPR(5) = 0
          END IF
        END IF
      END IF
C * RESTORE SAVED ARRAYS FROM TEMPORARY STORAGE IN VOID SCRATCH
      CALL PLA269 (-1, NATB)
C * SET PLA024 ROUTINE DONE
      IPR(85) = 1
      RETURN
99999 FORMAT (//, 'Label Problem #', I3, ' for ', A)
      END SUBROUTINE PLA024
 
      SUBROUTINE PLA025 (I, N)
C * SUPPORT PLA024
      USE parameters
      USE plato
      USE sgxyz
      IMPLICIT NONE
      INTEGER :: I
      INTEGER :: J
      INTEGER :: K
      INTEGER :: N
      INTEGER :: LU
      INTEGER :: K0
      INTEGER :: K1
      INTEGER :: IVAL
      CHARACTER(len=80) :: LINE
      LU = 0
      DO J = 1, 3
        SGY(J)     = CON(I, J)
        SGY(J + 3) = FN(J + 1)
      END DO
      CALL SGSM (3, LINE, SGY, N, LU, IERR)
      DO J = 1, 3
        CON(I, J)  = SGY(J + 6)
        SGY(J)     = CON(I, J + 4)
        SGY(J + 3) = 0.0
      END DO
      CALL SGSM (3, LINE, SGY, -N, LU, IERR)
      DO J = 1, 3
        CON(I, J + 4) = SGY(J + 6)
      END DO
C * TEST FOR (ISO/ANISO)TROPIC
      CALL GEN048 (-1, IFG(1, I), 4, IVAL)
      IF (IVAL > 0) THEN
        IF (N > 0) THEN
C * GET TRANSFORMATION MATRIX
          CALL SGSM (6, LINE, SGY, N, LU, IERR)
          DO K = 1, 9
            K0 = MOD (K - 1, 3) + 1
            K1 = ((K - 1) / 3)  + 1
            RIK(K1, K0) = SGY(K)
          END DO
          DO K = 1, 6
            DUMA(K) = ANIS(I, K)
          END DO
          CALL GEN025 (UKL, DUMA, -1)
          CALL GEN001 (1, RIK, UKL, UIJ)
          CALL GEN025 (UIJ, DUMA, 1)
          DO K = 1, 6
            ANIS(I, K) = DUMA(K)
          END DO
        END IF
      END IF
      RETURN
      END SUBROUTINE PLA025
 
      SUBROUTINE PLA026
C * LISTING OF (AN)ISOTROPIC THERMAL PARAMETERS + SHELX
      USE files
      USE parameters
      USE plato
      USE atomdata
      USE cchar
      USE spgrdata
      USE sgxyz
      IMPLICIT NONE
      INTEGER :: I
      INTEGER :: J
      INTEGER :: K
      INTEGER :: L
      INTEGER :: N
      INTEGER :: JM
      INTEGER :: NM
      INTEGER :: NB
      INTEGER :: NE
      INTEGER :: NLN
      INTEGER :: NAT
      INTEGER :: NOH
      INTEGER :: NCH
      INTEGER :: KCG
      INTEGER :: ISW
      INTEGER :: IHA
      INTEGER :: IFT
      INTEGER :: IHYB
      INTEGER :: IMET
      INTEGER :: IVAL
      INTEGER :: IZET
      INTEGER :: JUNK
      INTEGER :: NCOD
      INTEGER :: NDEC
      INTEGER :: NIEN
      INTEGER :: NRES
      INTEGER :: NATB
      INTEGER :: NATC
      INTEGER :: NADD
      INTEGER :: NFVR
      INTEGER :: NDEV
      INTEGER :: NHAT
      INTEGER :: NRAT
      INTEGER :: JHAT
      INTEGER :: JDUM
      INTEGER :: IDUM
      INTEGER :: IATF
      INTEGER :: IAN0
      INTEGER :: IDISD
      INTEGER :: IDUM1
      INTEGER :: IDUM2
      INTEGER :: IRESI
      INTEGER :: JPART
      INTEGER :: ISCFT
      INTEGER :: JSCFT
      INTEGER :: NRESD
      INTEGER :: ISUEQ
      INTEGER :: IPART
      INTEGER :: IAFIX
      INTEGER :: IALIAS
      INTEGER :: IPARTO
      INTEGER :: IPARTN
      INTEGER :: IPARTI
      INTEGER :: IPARTJ
      INTEGER :: IPR493
      INTEGER :: GEN135
      REAL :: XI
      REAL :: YI
      REAL :: ZI
      REAL :: XJ
      REAL :: YJ
      REAL :: ZJ
      REAL :: D13
      REAL :: D21
      REAL :: D32
      REAL :: FAC
      REAL :: FDC
      REAL :: YNK
      REAL :: UEQ
      REAL :: RMU
      REAL :: DIST
      REAL :: SUEQ
      REAL :: XLNG
      REAL :: XDUM
      REAL :: YUNK
      REAL :: POPL
      REAL :: SQD13
      REAL :: RATIO
      REAL :: GEN009
      REAL :: WAVELTH
      REAL :: DISTMAX
      CHARACTER(len=1)    :: LSB
      CHARACTER(len=1)    :: RSB
      CHARACTER(len=1)    :: ND13
      CHARACTER(len=1)    :: DISOR
      CHARACTER(len=2)    :: RESI
      CHARACTER(len=2)    :: RESI0
      CHARACTER(len=9)    :: STRA
      CHARACTER(len=NP64) :: KDUM
      CHARACTER(len=136)  :: FORMA
      CHARACTER(len=47)   :: FORMB
      CHARACTER(len=57)   :: FORMC
C * SETUP PRINT FORMATS
      FORMA(1:26)    = '(I4,1X, A ,F8.4,''('',I2,'')'''
      FORMA(27:42)   = ',F9.4,''('',I2,'')'''
      FORMA(43:74)   =  FORMA(27:42)//FORMA(27:42)
      FORMA(75:106)  =  FORMA(43:74)
      FORMA(107:136) =  FORMA(27:42)//',3F7.4,F6.2,A)'
      FORMB(1:27)    = '(I4,1X, A ,F8.4,''('',I2,'')'','
      FORMB(28:47)   = '65X,F9.4,''('',I2,'')'')'
      FORMC(1:37)    = '(''HKLF 4 1'',F7.4,F7.4,F7.4,F7.4,F7.4,'
      FORMC(38:57)   = 'F7.4,F7.4,F7.4,F7.4)'
C * INIT
      PAGET = 'ADP-Anal'
      RESI  = '  '
      RESI0 = '  '
      XI    = 0.0
      YI    = 0.0
      ZI    = 0.0
C * ADAPT HKLF 4 FORMAT TO FIT 79 CHARACTER RECORD
      DO I = 1, 9
        N = I * 5 + 9
        IF (PAR(230 + I) < 0.0) FORMC(N:N) = '8'
      END DO
C * SETUP FOR TRACKING AVERAGE U/UEQ VALUES
      DO I = 1, IAN + 1
        BOK(I, 1) = 0.0
        BOK(I, 2) = 9999.0
        BOK(I, 3) = 0.0
        KBO(I, 1) = 0
      END DO
C * HANDLE WAVELENGTH
      IPR493  = IABS (IPR(493))
C * DEFAULT MoKa
      IF (IPR493 == 0) THEN
        IPR493  = 3
        WAVELTH = STWL(6 - IPR493)
        WRITE (LU6, 99958, IOSTAT = IOST)
      ELSE
        WAVELTH = PAR(17)
      END IF
C * GET NUMBER OF UNIQUE (INPUT) ATOMS
      NAT  = IPR(37)
C * GET TOTAL NUMBER OF ATOMS (SYMMETRY EXPANDED)
      NATB = IPR(39)
C * GET NUMBER OF RESIDUES
      NRES = IPR(75)
C * (0/1) FULL LU2
      IF (IPR(67) == 0) THEN
        NATC = NAT
      ELSE
        NATC = NATB
      END IF
C * TEST PARAMETER FILE OUTPUT TYPE
      IF (IGBL(31) == 0) THEN
        IGBL(31) = 3
C * OPEN UNIT #2
        CALL PLA292
      END IF
C * INITIALIZE # FVAR PARAMETERS
      IF (IGBL(31) < 0) IPR(109) = 1
C * PDB - FILE OUTPUT
      IF (IGBL(31) == 7) THEN
        WRITE (LU2, 99963, IOSTAT = IOST) JID(1:73),
     1    (PAR(100 + I), I = 1, 6), SPGRNM(4),
     2    ((ROR(I, J), J = 1, 3), 0.0, I = 1, 3)
      END IF
C * OUTPUT (LU2) TITL, CELL
      IF (IGBL(31) /= 0 .AND. IGBL(31) /= 2 .AND.
     1    IGBL(31) /= 4 .AND. IGBL(31) /= 7) THEN
        REWIND (UNIT = LU2, IOSTAT = IOST)
        WRITE (LU2, 99982, IOSTAT = IOST) JID(1:74)
C * OUTPUT (LU2) TRNS - ADDITIONAL SYMMETRY FOR IPR(209) > 0
        IF (IGBL(31) == 3 .AND.
     1     (IPR(209) > 0 .OR. IPR(504) > 0)) THEN
          WRITE (LU2, 99973, IOSTAT = IOST)
     1      ((ROTM2(I, J), J = 1, 3), I = 1, 3), (ORG(J), J = 1, 3)
C * RESET 'CLOSENESS' CRITERIUM (FROM ADDSYM)
          WRITE (LU2, 99960, IOSTAT = IOST) 0.7
          IF (IPR(261) > -999999) WRITE (LU2, 99998) IPR(261) - 273
          IF (IPR(502) == 2) WRITE (LU2, 99947)
        END IF
C * 'NORMALIZE' CELL FOR '.res'
        IF (IGBL(31) == -2) THEN
C * APPLY SYMMETRY CONSTRAINTS ON CELL DIMENSIONS
          CALL GEN066 (2, PAR(101), PAR(107), SPGRNM(1)(12:12),
     1      IPR(783))
        END IF
        IF (IPR(23) == 0) THEN
          WRITE (LU2, 99974, IOSTAT = IOST)
     1      WAVELTH, (PAR(100 + I), I = 1, 6)
        END IF
C * OUTPUT (LU2) CESD (OMEGA, SPF) OR ZERR FOR SHELXL
        IF (IPR(438) == 1 .OR. IGBL(31) == 3) THEN
          IF (IPR(23) == 0) THEN
            WRITE (LU2, 99979, IOSTAT = IOST) (PAR(106 + I), I = 1, 6)
          END IF
          IF (PAR(2) /= 0.4) WRITE (LU2, 99951, IOSTAT = IOST) PAR(2)
C * OUTPUT VOLUME (OMEGA)
          IF (IPR(438) == 1)
     1      WRITE (LU2, 99990, IOSTAT = IOST) PAR(98), PAR(21)
        ELSE IF (IGBL(31) == -2 .OR. IGBL(31) == -3) THEN
          IF (IPR(276) > 0) THEN
            IZET = IPR(276)
          ELSE IF (IPR(260) > 0) THEN
            IZET = IPR(260)
          ELSE
            IZET = 1
          END IF
          WRITE (LU2, 99971, IOSTAT = IOST)
     1      IZET, (PAR(106 + I), I = 1, 6)
        END IF
C * OUTPUT (LU2) SYMMETRY
C * EXPLICIT OUTPUT OF LATT/SYMM
        IF (IPR(256) == 0 .OR. IGBL(31) < 0) THEN
C * TEST FOR 'WRITE .res'
          IF (IGBL(31) < 0) THEN
C * LATT SHELX STYLE
            WRITE (LU2, 99975) IPR(242)
            ISW = 17
          ELSE
C * TEST FOR NON-ANGSTROM DATA
            IF (IPR(23) == 0) THEN
C * LATT SPF STYLE
              WRITE (LU2, 99978) SPGRNM(1)(13:13), SPGRNM(1)(14:14),
     1          IPR(783)
            END IF
            ISW = 2
          END IF
          IF (IPR(23) == 0) THEN
            CALL SGSM (2, ICL, SGY, 0, LU6, IERR)
            DO I = 2, IPR(255)
              CALL SGSM (ISW, ICL, SGY, I, 0, IERR)
              WRITE (LU2, 99977) ICL(1:60)
            END DO
          END IF
        ELSE
          IF (IGBL(31) == 3 .AND. IPR(67) /= 0) THEN
            WRITE (LU2, 99989)
          ELSE
C * OUTPUT EITHER EXPLICIT SYMMETRY OR SPACEGROUP NAME (IF KNOWN)
            IF (SPGRNM(1)(1:3) == '   ' .AND. IPR(209) == 0
     1          .AND. IPR(504) == 0) THEN
              IF (IPR(23) == 0) THEN
                WRITE (LU2, 99978) SPGRNM(1)(13:13), SPGRNM(1)(14:14)
                ISW = 2
                DO I = 2, IPR(255)
                  CALL SGSM (ISW, ICL, SGY, I, 0, IERR)
                  WRITE (LU2, 99977) ICL(1:60)
                END DO
              END IF
            ELSE
              IF (SPGRNM(2)(1:1) /= '?' .AND. SPGRNM(2)(1:1) /= ' '
     1            .AND. IGBL(31) == 3) THEN
                J   = 2
                LSB = '['
                RSB = ']'
              ELSE
                J   = 1
                LSB = ' '
                RSB = ' '
              END IF
              IF (INDEX (SPGRNM(J)(1:11), ':') /= 0) THEN
                WRITE (LU2, 99976) LSB, SPGRNM(J)(1:11),RSB
              ELSE
                IF (SPGRNM(J)(8:11) == '    ') THEN
                  I = ICHAR (' ')
                ELSE
                  I = ICHAR ('.')
                END IF
                WRITE (LU2, 99976)
     1               LSB, SPGRNM(J)(1:7), CHAR (I), SPGRNM(J)(8:11), RSB
              END IF
            END IF
          END IF
        END IF
C * COPY SCATTERING TYPES FOR SHELX.INS
        IF (IPR(504) == 2) THEN
          WRITE (LU2, 99994) (LMT(IENS(K), 1), K = 1, IAN)
        END IF
        IF ((IGBL(31) == 3 .OR. IGBL(3) < 0)
     1    .AND. IPR(310) > 0) WRITE (LU2, 99998) IPR(310) - 273
      END IF
C * OUTPUT (LU2) SHELXL - SFAC, UNIT, FVAR
      IF (IGBL(31) < 0) THEN
        IAN0 = 0
        NOH  = 1
        DO K = 1, IAN
          IF (LMT(K, 1) == ' H') NOH = 0
          IF (LMT(IENS(K), 1) /= 'Cg') THEN
            IAN0 = IAN0 + 1
            IENS(IAN0) = IENS(K)
          ELSE
            KCG = IENS(K)
          END IF
        END DO
        IF (IAN0 < IAN) IENS(IAN) = KCG
        NFVR = IPR(109)
C * OUTPUT SFAC IN C, H, ALPHABETIC ORDER (CU AG MO GA IN - RADIATION)
        IF (IPR(595) == 0) THEN
          DO K = 1, IAN0
            L = IEN(IENS(K))
C * XRAY SCATTERING + SYNCHROTRON
            IF (IPR493 < 7) THEN
              J   = (L - 1) * 19
              FAC = ANOM(IENS(K), 1)
              FDC = ANOM(IENS(K), 2)
              RMU = ANOM(IENS(K), 3)
              WRITE (LU2, 99981) LMT(IENS(K), 1),
     1          (SFAC(J + I), I = 1, 9), FAC, FDC, RMU, REL(L),
     2           SATWT(IENS(K))
              WRITE (LU6, 99981) LMT(IENS(K), 1),
     1          (SFAC(J + I), I = 1, 9), FAC, FDC, RMU, REL(L),
     2           SATWT(IENS(K))
            ELSE
C * NEUTRON SCATTERING
              WRITE (LU2, 99981) LMT(IENS(K), 1), 0.0, 0.0, 0.0, 0.0,
     1          0.0, 0.0, 0.0, 0.0, RNSCL(L), 0.0, 0.0, 0.0, REL(L),
     2          SATWT(IENS(K))
            END IF
          END DO
        ELSE
          IF (IPR493 == 7) WRITE (LU2, 99933)
C * FOR .res: INPUT ORDER
          IF (IGBL(8) /= 2) THEN
            WRITE (LU2, 99941) (LMT(IENS(K), 1), K = 1, IAN0)
C * INCLUDE DISP RECORDS FOR NON In,Ag,Mo,Ga,Cu WAVELENGTH
            IF (IABS (IPR(493)) == 6) THEN
              DO K = 1, IAN0
                WRITE (LU2, 99936)
     1            LMT(IENS(K), 1), (ANOM(IENS(K), L), L = 1, 3)
              END DO
            END IF
          ELSE
            WRITE (LU2, 99941) (LMT(K, 1), K = 1, IAN)
          END IF
        END IF
C * FOR .res: INPUT ORDER
        IF (IGBL(8) /= 2) THEN
          WRITE (LU2, 99980) (NINT (CONT(IENS(L), 2)), L = 1, IAN0)
        ELSE
          WRITE (LU2, 99980) (NINT (CONT(L, 2)), L = 1, IAN)
        END IF
        IF (IPR(310) > 0) WRITE (LU2, 99998) IPR(310) - 273
C * ADD REFINEMENT INSTRUCTIONS
        IF (IPR(261) > -999999 .AND. IPR(310) == -999999)
     1    WRITE (LU2, 99998) IPR(261) - 273
        IF (PAR(302) * PAR(303) * PAR(304) > 0.0)
     1    WRITE (LU2, 99932) PAR(304), PAR(303), PAR(302)
        WRITE (LU2, 99942)
        IF (NOH == 0) WRITE (LU2, 99949)
C * ADD TWIN/BASF FOR NON-CENTRO STRUCTURES
        IF (IPR(275) == 1) THEN
          IF (PAR(433) < 999999.0) THEN
            YUNK = PAR(433)
          ELSE
            YUNK = 0.0
          END IF
          WRITE (LU2, 99937) YUNK
        END IF
C * EXTI LINE
        IF (PAR(229) > 0.0 .AND. PAR(229) < 1.0)
     1    WRITE (LU2, 99935) PAR(229)
C * HANDLE WEIGHT PARAMETERS
        IF (PAR(493) < 0.0 .OR. PAR(494) < 0.0) THEN
          WRITE (LU2, 99939) 0.1
        ELSE
          WRITE (LU2, 99939) PAR(493), PAR(494)
        END IF
        WRITE (LU2, 99999) PAR(74), (RP(L), L = 2, NFVR)
      ELSE IF (IGBL(31) == 3 .AND. IPR(209) == 0) THEN
        WRITE (LU2, 99970)
      END IF
C * (NO)TEMP FACTOR
      IF (IPR(32) /= 0 .AND. IGBL(63) > 2) THEN
C * START ON NEW-PAGE WITH HEADER
         CALL PLA262 (-2)
         WRITE (LU7, 99984) CHAR(ICHAR('#'))
      END IF
C * LOOP OVER RESIDUE SPECIES
      DO N = 1, NRES
        CALL GEN074 (XPV, 1, 4, 0.0)
        DO I = 1, IAN + 1
          BOK(I, 5) = 9999.0
          BOK(I, 6) = 0.0
        END DO
        CALL GEN074 (DEV, 1, 6, 0.0)
        NDEV = 0
C * TEST FOR MAJOR RESIDUE(S) = 0, ANION/SOLVENT = 1
        NADD = 0
        IF (N > 1) THEN
          IF (RCONT(N) < RCONT(1)) NADD = 1
        END IF
        IF (IPR(32) /= 0) THEN
          NLN = 5
          IF (NRES > 1) NLN = NLN + 5
          IF (IGBL(63) > 2) THEN
            CALL PLA262 (NLN)
            IF (NRES /= 1) WRITE (LU7, 99993) N
            WRITE (LU7, 99991)
          END IF
        END IF
        IF (IPR(438) == 1 .OR. IGBL(31) == 3) WRITE (LU2, 99992) N
        NRAT   = 0
        IPARTO = 0
        IATF   = 0
        DO I = 1, NATB
C * TEST RESIDUE NUMBER BITS
          CALL GEN048 (-6, IFG(1, I), 9, IRESI)
          IF (N == IRESI) THEN
            CALL GEN048 (-1, IFG(1, I), 7, NHAT)
C * REGISTER FIRST NON-H ATOM IN RESIDUE
            IF (NHAT == 0) THEN
              IF (IATF == 0) IATF = I
            END IF
            IF (IGBL(31) < 0) THEN
              IF (NHAT == 0) THEN
                XI = VOID((I - 1) * NP71 + 4)
                YI = VOID((I - 1) * NP71 + 5)
                ZI = VOID((I - 1) * NP71 + 6)
              ELSE
                CYCLE
              END IF
            END IF
C * METAL ?
            CALL GEN048 (-1, IFG(1, I), 19, IMET)
C * GET ATOM TYPE
            CALL GEN048 (-4, IFG(1, I), 15, NIEN)
            NIEN = NIEN + 1
            IF (IGBL(31) == 3 .AND. IPR(501) == 0) THEN
              IALIAS = 1
            ELSE
              IALIAS = IGBL(55)
            END IF
            CALL PLA036 (-I, 1, 1, IDISD, IDUM1, IDUM2, 0, IALIAS)
            CALL PLA036 (-I, 1, 2, IDISD, IDUM1, IDUM2, 0, IGBL(55))
            IF (NHAT == 0) THEN
              XPV(1 + NADD) = XPV(1 + NADD) + IDISD
              IF (IDISD < 10000)
     1          XPV(3 + NADD) = XPV(3 + NADD) + IDISD
            END IF
C * TEST ISO/ANISO BIT
            CALL GEN048 (-1, IFG(1, I), 4, IVAL)
            IF (IVAL > 0) THEN
              JM = 6
            ELSE
              JM = 1
              CALL GEN048 (-1, IFG(1, I), 7, IHA)
C * COUNT ISOTROPIC NON-H ATOMS (MAJOR - ANION/SOLVENT) (IPR(489)/IPR(490))
              IF (IHA == 0 .AND. I <= NAT .AND. IDISD > 5000)
     1          THEN
                IPR(489 + NADD) = IPR(489 + NADD) + 1
C * STORE LABELS OF ISOTROPIC NON-HYDROGEN ATOMS
                IF (IPR(489 + NADD) <= NP77 ) THEN
                  CALL PLA047 (LABA(I), KDUM, IDUM, JDUM, 0, IGBL(55),
     1            0, 1)
                  CISO(IPR(489 + NADD), NADD + 1) = KDUM(1:8)
                END IF
              END IF
            END IF
C * ROUND DISPLACEMENT PARAMETERS FOR OUTPUT
            DO J = 1, JM
              CALL GEN041 (ANIS(I, J), SUAN(I, J), ISDV(J), 5, NDEC,
     1                    IPR(68))
              ISDV(J) = MIN (99, ISDV(J))
              IF (ISDV(J) <= 0) SUAN(I, J) = -1.0
              IF (JM == 1) THEN
C * MODIFY NUMBER OF DECIMAL DIGITS IN OUTPUT FORMAT
                FORMB(15:15) = CHAR (ICHAR ('0') + NDEC)
                FORMB(35:35) = CHAR (ICHAR ('0') + NDEC)
              ELSE
                IFT = -1 + J * 16
C * MODIFY NUMBER OF DECIMAL DIGITS IN OUTPUT FORMAT
                FORMA(IFT:IFT) = CHAR(ICHAR('0') + NDEC)
              END IF
            END DO
C * ROUND COORDINATES FOR OUTPUT
            DO K = 1, 4
              CALL GEN041 (CON(I, K), CON(I, K + 4), IDUM, IPR(183),
     1                   NDEC, IPR(68))
              IF (1.1 * CON(I, K + 4) < 1.0 / 10 ** IPR(183))
     1           CON(I, K + 4) = -1.0
            END DO
c             IPDB = 1
              K = INDEX (NAMS(1, 2), '_')
              IF (K == 0) THEN
                RESI = '0 '
                NQ2  = NAMS(1, 2)(2:8)
              ELSE
                NQ2  = NAMS(1, 2)(2:K - 1)
                RESI = NAMS(1, 2)(K + 1:K + 2)
              END IF
C * PDB ANGSTROM COORDINATES
            IF (IGBL(31) == 7) THEN
              DO K = 1, 3
                V1(K) = CON(I, K)
              END DO
              CALL GEN002 (1, OR, V1, V3, XLNG)
              IF (NQ2(1:1) == CHAR (32)) THEN
                NB = 2
                NE = 5
              ELSE
                NB = 1
                NE = 4
              END IF
              WRITE (LU2, 99962) I, NQ2(NB:NE), 0, (V3(K), K = 1, 3),
     1                           1.0, 0.0, NQ2(1:2)
            END IF
            IF (I <= NATC) THEN
              IF (IGBL(31) < 0) THEN
C * TAKE CARE OF ELEMENT RESHUFLING
                DO L = 1, IAN0
                  IF (IENS(L) == NIEN) THEN
                    ISCFT = L
                    EXIT
                  END IF
                END DO
                POPL = 10.0 + CON(I, 4)
                SGY(10) = PAR(547) / MAX(PAR(101), PAR(102), PAR(103))
C * MAKE SURE OF PROPER COORDINATE CONSTRAINTS FOR SHELXL
                IF (CON(I, 4) < 0.99) THEN
                  DO K = 1, 3
                    SGY(K) = CON(I, K)
                  END DO
                  CALL SGSM (19, ICL, SGY, 0, LU6, IERR)
                  DO K = 1, 3
                    CON(I, K) = SGY(6 + K)
                  END DO
                END IF
C * CHECK OMEGA FILE STATUS AND TEST FOR SPF OUTPUT
              ELSE IF (IPR(438) == 1 .OR. IGBL(31) == 3) THEN
                DISOR = NAMS(1, 1)(1:1)
                IF (DISOR /= ' ') DISOR = 'X'
C * HANDLE SHELXL PART #
                CALL GEN048 (-5, IFG(3, I), 14, IPART)
                IPARTN = IPART - 16
                IF (IPARTN /= IPARTO) THEN
                  WRITE (LU2, 99934 ) IPARTN
                  IPARTO = IPARTN
                END IF
C * TEST FOR ANGSTROM DATA
C * ATOM LINE (ELD)
                  WRITE (LU2, 99987) NAMS(1, 2)(2:NP64), ELB(IEN(NIEN)),
     1              (CON(I, K), K = 1, 8)
              END IF
            END IF
C * ANISOTROPIC
            IF (JM > 1) THEN
C * RECOVER UIJ-MATRIX FROM 6 COMPONENTS
              DO K = 1, 6
                DUMA(K) = ANIS(I, K)
              END DO
              CALL GEN025 (UIJ, DUMA, -1)
C * UIJ - MAIN AXES & VALUES & UEQ
              CALL GEN114 (PAR, OR, UIJ, UIJC, DUMA, DUMV, UEQ)
              NRESD = 0
              SUEQ  = 0.0
              DO J = 1, 3
                IF (SUAN(I, J) > 0.0) THEN
                  NRESD = NRESD + 1
                  SUEQ = SUEQ + SUAN(I, J) ** 2
                END IF
              END DO
              IF (NRESD > 0) SUEQ = SQRT (SUEQ) / NRESD
              CALL GEN041 (UEQ, SUEQ, ISUEQ, 5, NDEC, IPR(68))
              ISUEQ = MIN (99, ISUEQ)
              IF (I <= NAT) THEN
                DO K = 1, 6
                  DEV(K) = DEV(K) + ANIS(I, K)
                END DO
                NDEV = NDEV + 1
                IF (IPR(85) == 0 .AND. DATC(I) > 0.0) THEN
                  YUNK = DATC(I) - UEQ
                  WRITE (NQ3, 99938) YUNK
C * ALERT _224
                  IF ((SUEQ <= 0.0 .AND. ABS (YUNK) > 0.001) .OR.
     1                (SUEQ >  0.0 .AND. ABS (YUNK) > SUEQ)) THEN
                    NQ4 = NAMS(1, 2)(2:10)
                    CALL GEN156 (NQ4)
                    CALL PLA236 (224, 3, ABS (YUNK), 1.0, NQ3, NQ4)
                  END IF
                END IF
              END IF
C * MODIFY NUMBER OF DECIMAL DIGITS IN OUTPUT FORMAT
              FORMA(111:111) = CHAR (ICHAR ('0') + NDEC)
              IF (ISUEQ <= 0) SUEQ = -1
              IF (DUMA(1) < PAR(12)) THEN
                D13 = -1.0
                IF (DUMA(1) < 0) THEN
                  NQ3 = 'N.P.D. '
                ELSE
                  NQ3 = '2Dimens'
                END IF
              ELSE
                D13 = DUMA(3) / DUMA(1)
                D21 = DUMA(2) - DUMA(1)
                D32 = DUMA(3) - DUMA(2)
                IF (D32 < D21) THEN
                  NQ3 = 'oblate '
                ELSE
                  NQ3 = 'prolate'
                END IF
              END IF
              DATC(I) = UEQ
              IF (I <= NAT) THEN
C * GENERAL AVERAGE
                IF (NHAT == 0) THEN
                  BOK(1, 1) = BOK(1, 1)     + UEQ
                  BOK(1, 2) = MIN (BOK(1, 2), UEQ)
                  BOK(1, 3) = MAX (BOK(1, 3), UEQ)
                  KBO(1, 1) = KBO(1, 1) + 1
                END IF
C * AVERAGE PER ATOM TYPE
                BOK(NIEN + 1, 1) = BOK(NIEN + 1, 1)     + UEQ
                BOK(NIEN + 1, 2) = MIN (BOK(NIEN + 1, 2), UEQ)
                BOK(NIEN + 1, 3) = MAX (BOK(NIEN + 1, 3), UEQ)
                KBO(NIEN + 1, 1) = KBO(NIEN + 1, 1) + 1
                BOK(NIEN + 1, 5) = MIN (BOK(NIEN + 1, 5), UEQ)
                BOK(NIEN + 1, 6) = MAX (BOK(NIEN + 1, 6), UEQ)
                IF (D13 > 0.0) SQD13 = SQRT (D13)
C * NAMS(1,1) = ALIAS, NAMS(1,2) = ORIGINAL LABEL
                ND13     = ' '
                IF (D13 <= 0.0 .OR. SQD13 > 2.0) THEN
                  IF (D13 > 9.0 .OR. D13 < 0.0) THEN
                    WRITE (LU6, 99959)
     1              NAMS(1, 2), (DUMA(J), J = 1, 3), D13, NQ3
                    ND13     = '#'
                    IPR(135) = IPR(135) + 1
                  END IF
                  IF (D13 < 0) THEN
                    NCOD = 211 + NADD
C * ALERT _211 +
                    IF (IGBL(22) /= -1) CALL PLA236 (
     1                     NCOD, 1, 1.0, 1.0, NAMS(1, 2)(2:10), ' ')
                  ELSE
                    IF (NAMS(1, 1)(1:1) == '*') THEN
                      NCOD = 215 + NADD
                      IF (IGBL(22) /= -1) CALL PLA236 (
     1                  NCOD, 1, SQD13, SQD13, NAMS(1, 1)(2:10), ' ')
                    ELSE
C * ALERT _213 - Oblate/Prolate UIJ
                      IF (NHAT == 0) THEN
                        NCOD = 213 + NADD
                        IF (IGBL(22) /= -1) CALL PLA236 (
     1                    NCOD, 1, SQD13, SQD13, NAMS(1, 2)(2:10), NQ3)
                      END IF
                    END IF
                  END IF
                END IF
                IF (IPR(32) /= 0) THEN
                  NRAT = NRAT + 1
                  IF (IGBL(63) > 2) THEN
                    WRITE (PRBUF, FORMA) NRAT, NAMS(1, 2)(2:10),
     1                (ANIS(I, J), ISDV(J), J = 1, 6), UEQ, ISUEQ,
     2                (DUMA(J), J = 1, 3), D13, ND13
                    CALL PLA263 (LU7, PRBUF, 132, 1, 9)
                    CALL GEN025 (UIJC, DUMA, 1)
C * LIST CARTESIAN AXES UIJ VALUES
                    IF (IPR(347) > 0) THEN
                      CALL PLA262 (1)
                      WRITE (LU7, 99972) (DUMA(J), J = 1, 6)
                    END IF
                  END IF
                END IF
              END IF
              IF (I <= NATC) THEN
C * SHELXL ATOM RECORD ANIS
                IF (IGBL(31) < 0) THEN
C * HANDLE SHELXL PART #
                  CALL GEN048 (-5, IFG(3, I), 14, IPART)
                  IPARTI = IPART - 16
                  IF (IPARTI /= IPARTO) THEN
                    WRITE (LU2, 99934 ) IPARTI
                    IPARTO = IPARTI
                  END IF
                  IF (RESI /= RESI0) THEN
                    RESI0 = RESI
                    WRITE (LU2, 99931) RESI
                  ENDIF
                  WRITE (LU2, 99997) NQ2(1:4), ISCFT,
     1            (CON(I, K), K = 1, 3), CHAR (ICHAR ('=')),
     2             POPL, (ANIS(I, K), K = 1, 6)
C * TEST FOR OMEGA FILE AND SPF MODE (= IGBL(31)= 3)
                ELSE IF (IPR(438) == 1 .OR. IGBL(31) == 3) THEN
                  WRITE (LU2, 99986) NAMS(1, 2)(2:NP64), ELB(IEN(NIEN)),
     1                               (ANIS(I, K), K = 1, 6), UEQ
                  WRITE (LU2, 99985) NAMS(1, 2)(2:NP64), ELB(IEN(NIEN)),
     1                               (SUAN(I, K), K = 1, 6), SUEQ
                END IF
              END IF
C * ISOTROPIC TEMPERATURE FACTOR
            ELSE IF (JM == 1) THEN
              DATC(I) = ANIS(I, 1)
              IF (I <= NATC) THEN
C * SHELXL ATOM RECORD ISO
                IF (IGBL(31) < 0) THEN
C * HANDLE SHELXL PART #
                  CALL GEN048 (-5, IFG(3, I), 14, IPART)
                  IPARTI = IPART - 16
                  IF (IPARTI /= IPARTO) THEN
                    WRITE (LU2, 99934) IPARTI
                    IPARTO = IPARTI
                  END IF
                  IF (RESI0 /= RESI) THEN
                    RESI0 = RESI
                    WRITE (LU2, 99931) RESI
                  END IF
                  WRITE (LU2, 99996) NQ2(1:4), ISCFT,
     1            (CON(I, K), K = 1, 3), POPL, ANIS(I, 1)
                ELSE IF (IPR(438) == 1 .OR. IGBL(31) == 3) THEN
                  WRITE (LU2, 99988) NAMS(1, 2)(2:NP64), ELB(IEN(NIEN)),
     1                                ANIS(I, 1), SUAN(I, 1)
                END IF
              END IF
              IF (IPR(32) /= 0 .AND. I <= NAT) THEN
                NRAT = NRAT + 1
C * GENERAL AVERAGE
                IF (NHAT == 0) THEN
                  BOK(1, 1) = BOK(1, 1)     + ANIS(I, 1)
                  BOK(1, 2) = MIN (BOK(1, 2), ANIS (I, 1))
                  BOK(1, 3) = MAX (BOK(1, 3), ANIS(I, 1))
                  KBO(1, 1) = KBO(1, 1) + 1
                END IF
                BOK(NIEN + 1, 1) = BOK(NIEN + 1, 1)     + ANIS(I, 1)
                BOK(NIEN + 1, 2) = MIN (BOK(NIEN + 1, 2), ANIS(I, 1))
                BOK(NIEN + 1, 3) = MAX (BOK(NIEN + 1, 3), ANIS(I, 1))
                KBO(NIEN + 1, 1) = KBO(NIEN + 1, 1) + 1
                BOK(NIEN + 1, 5) = MIN (BOK(NIEN + 1, 5), ANIS(I, 1))
                BOK(NIEN + 1, 6) = MAX (BOK(NIEN + 1, 6), ANIS(I, 1))
                IF (IGBL(63) > 2) THEN
                  WRITE (PRBUF, FORMB) NRAT, NAMS(1, 2)(2:10),
     1              ANIS(I, 1), ISDV(1), ANIS(I, 1), ISDV(1)
                  CALL PLA263 (LU7, PRBUF, 132, 1, 1)
                END IF
              END IF
            END IF
C * ADD H-ATOMS BELONGING TO THIS ATOM
            IF (IGBL(31) < 0) THEN
C * GET POSITION OF H IN SFAC RECORD
              JSCFT = 0
              DO J = 1, IAN
                IF (IEN(IENS(J)) == 1) JSCFT = J
              END DO
              NCH = 0
              NM  = 3
              CALL GEN048 (-3, IFG(2, I), 24,  NCH)
              CALL GEN048 (-3, IFG(3, I), 25,  NHAT)
C * CHECK FOR/HANDLE CARBON
              IF (NCH > 0) THEN
                IF (IEN(NIEN) == 2) THEN
                  CALL GEN048 (-4, IFG(1, I), 24, IHYB)
                  IF (NCH == 1) THEN
                    IF (IHYB == 1) THEN
                      NM = 163
                    ELSE IF (IHYB == 2) THEN
                      NM = 43
                    ELSE IF (IHYB == 3) THEN
                      NM = 13
                    END IF
                  ELSE IF (NCH == 2) THEN
                    IF (IHYB == 2) THEN
                      NM = 93
                    ELSE IF (IHYB == 3) THEN
                      NM = 23
                    END IF
                  ELSE IF (NCH == 3) THEN
                    IF (IHYB == 3) THEN
                      IF (NHAT == 6) THEN
                        NM = 127
                      ELSE
                        NM = 137
                      END IF
                    END IF
                  END IF
                END IF
                IAFIX = 0
                IF (IMET == 1) THEN
                  DISTMAX = 1.8
                ELSE
                  DISTMAX = 1.2
                END IF
C * SEARCH H-ATOM LOOP
                DO J = 1, NATC
C * GET H-ATOM INFO
                  CALL GEN048 (-1, IFG(1, J), 7, JHAT)
                  IF (JHAT /= 0) THEN
                    CALL GEN048 (-5, IFG(3, J), 14, JPART)
                    IPARTJ = JPART - 16
                    JUNK   = 0
                    IF (IPARTI == IPARTJ) THEN
                      JUNK = 1
                    ELSE IF (IPARTI == 0 .OR. IPARTJ == 0) THEN
                      JUNK = 1
                    END IF
                    IF (JUNK == 1) THEN
                      XJ = VOID((J - 1) * NP71 + 4)
                      YJ = VOID((J - 1) * NP71 + 5)
                      ZJ = VOID((J - 1) * NP71 + 6)
                      DIST = SQRT ((XI - XJ)**2 + (YI - YJ)**2
     1                     +       (ZI - ZJ)**2)
                      IF (DIST < DISTMAX) THEN
C * TEST FOR NEUTRON
                        IF (IPR493 == 7) THEN
                          YNK = ANIS(I, 1)
                        ELSE
C * ADD PROPER UISO FIX
                          YNK = -1.2
                          IF (NM == 127 .OR. NM == 137 .OR.
     1                      (NM == 3 .AND. IEN(IENS(ISCFT)) == 3))
     2                      YNK = -1.5
                        END IF
C * HANDLE SHELXL PART #
                        JUNK = 0
                        IF (IPARTO /= IPARTJ) THEN
                          WRITE (LU2, 99934) IPARTJ
                          IPARTO = IPARTJ
                        ENDIF
                        IAFIX = IAFIX + 1
                        IF (IAFIX == 1) WRITE (LU2, 99961) NM
 
                          CALL PLA036 (-J, 1, 2, IDISD, IDUM1, IDUM2,
     1                    0, IGBL(55))
                          K = INDEX (NAMS(1, 2), '_')
                          IF (K == 0) THEN
                            RESI = '0 '
                            NQ3  = NAMS(1, 2)(2:8)
                          ELSE
                            NQ3  = NAMS(1, 2)(2:K - 1)
                            RESI = NAMS(1, 2)(K + 1:K + 2)
                          END IF
 
                        WRITE (LU2, 99953) NQ3(1:4), JSCFT,
     1                    (CON(J, K), K = 1, 3), 10.0 + CON(J, 4), YNK
                      END IF
                    END IF
                  END IF
                END DO
                IF (IAFIX > 0) WRITE (LU2, 99961) 0
              END IF
            END IF
            IF (JM > 1) THEN
              J = IPR(297) + (I - 1) * 21
              DO K = 1, 3
                V8(K) = VOID(J + K + 6)
              END DO
              XDUM = SQRT (GEN009 (V8, V8))
              DO K = 1, 3
                V8(K) = V8(K) * (VOID(J + 12) - MAX (VOID(J + 10), 0.0))
     1                / XDUM
              END DO
              CALL GEN002 (1, ROR, V8, V6, XLNG)
              J = (I - 1) * NP71
              DO K = 1, 3
                V5(K) = VOID(J + K) - V6(K)
                V8(K) = VOID(J + K) + V6(K)
              END DO
              IF (I <= NATC .AND. IGBL(63) > 2) THEN
                CALL PLA262 (1)
                WRITE (LU7, 99952) (V5(K), K = 1, 3), (V8(K), K = 1, 3)
              END IF
            END IF
          END IF
        END DO
C * NON-H DISORDER CHECK
        IF (IPR(43) > 0 .AND. IGBL(22) /= -1) THEN
          WRITE (NQ4, 99930) N
C * ALERT _301
          IF (XPV(3) > 0.0)
     1      CALL PLA236 (301, 0, -999.0,
     2                   XPV(3) * 100.0 / XPV(1), NQ4, ' ')
C * ALERT _302
          IF (XPV(4) > 0.0)
     1      CALL PLA236 (302, 0, -999.0,
     2                   XPV(4) * 100.0 / XPV(2), NQ4, ' ')
        END IF
        IF (IPR(32) /= 0) THEN
          DO I = 2, IAN + 1
            IF (BOK(I, 5) > 0.0) THEN
              BOK(I, 4) = MIN (9.9999, BOK(I, 6) / BOK(I, 5))
            ELSE
              BOK(I, 4) = 0.0
            END IF
            IF (BOK(I, 5) > 1000.0) BOK(I, 5) = 0.0
          END DO
          DO I = 1, IAN
            J = IENS(I)
            IF (BOK(J + 1, 4) > 1.5) THEN
              IF (LMT(J, 1) == ' H' .OR. LMT(J, 1) == ' D') THEN
                K = 2 + NADD
              ELSE
                K = NADD
              END IF
C * ALERT _220 +
              STRA = '   '//LMT(J, 1)//'   U'
              WRITE (STRA(1:3), '(I2, 1X)') N
              IF (IGBL(22) /= -1) CALL PLA236 (
     1         220 + K, 1, BOK(J + 1, 4), BOK(J + 1, 4), STRA, ' ')
            END IF
          END DO
        END IF
        IF (NDEV > 0) THEN
          DO I = 1, 6
            DEV(I) = DEV(I) / NDEV
          END DO
          CALL GEN025 (UIJ, DEV, -1)
C * UIJ - Main AXES & VALUES & UEQ
          CALL GEN114 (PAR, OR, UIJ, UIJC, DUMA, DUMV, UEQ)
          CALL PLA262 (3)
          RATIO = DUMA(3) / DUMA(1)
          CALL PLA047 (LABA(IATF), NQ2, IDUM, JDUM, 0, IGBL(55),
     1         0, 1)
 
C * ALERT _260 - REPORT LARGE AVERAGE Ueq FOR RESIDUE
          CALL PLA236 (260, 3, UEQ, UEQ, NQ2, ' ')
          IF (IGBL(63) > 2) WRITE (LU7, 99948) (DEV(K), K = 1, 6),
     1            UEQ, (DUMA(K), K = 1, 3), RATIO
          WRITE (NQ4, 99930) N
C * ALERT _250
          IF (NDEV > 5 .AND. IGBL(22) /= -1)
     1      CALL PLA236 (250, 1, RATIO, RATIO, NQ4, ' ')
        END IF
      END DO
C * OUTPUT TEMPERATURE PARAMETER EXPLANATION
      IF (IPR(32) /= 0) THEN
        IF (IGBL(63) > 2) THEN
          CALL PLA262 (15)
          WRITE (LU7, 99983)
C * OUTPUT U/UEQ AVERAGES
          CALL PLA262 (6)
          WRITE (LU7, 99968) (LMT(IENS(I), 1), I = 1, IAN)
          WRITE (LU7, 99967) BOK(1, 1) / MAX (1, KBO(1, 1)),
     1      (BOK(IENS(I) + 1, 1) /
     2      MAX (1, KBO(IENS(I) + 1, 1)), I = 1, IAN)
        END IF
        DO I = 1, IAN + 1
          IF (BOK(I, 2) > 0.0) THEN
            BOK(I, 1) = MIN (9.9999, BOK(I, 3) / BOK(I, 2))
          ELSE
            BOK(I, 1) = 0.0
          END IF
          IF (BOK(I, 2) > 1000.0) BOK(I, 2) = 0.0
        END DO
        IF (IGBL(63) > 2) THEN
          CALL PLA262 (4)
          WRITE (LU7, 99966) BOK(1, 2), (BOK(IENS(I) + 1, 2),
     1                       I = 1, IAN)
          WRITE (LU7, 99965) BOK(1, 3), (BOK(IENS(I) + 1, 3),
     1                       I = 1, IAN)
          WRITE (LU7, 99964) BOK(1, 1), (BOK(IENS(I) + 1, 1),
     1                       I = 1, IAN)
          WRITE (LU7, 99957) KBO(1, 1), (KBO(IENS(I) + 1, 1),
     1                       I = 1, IAN)
        END IF
      END IF
      IF (IGBL(31) == -2 .OR. IGBL(31) == -3) THEN
C * TEST FOR UNIT MATRIX
        IF (GEN135 (PAR(231)) == 0) THEN
          WRITE (LU2, FORMC) (PAR(I), I = 231, 239)
        ELSE
          WRITE (LU2, 99940)
        END IF
        IF (IPR(209) > 0) THEN
          DO J = 1, 12
            IF (LAUEGR == NLAUE(J)) EXIT
          END DO
          WRITE (LU2, 99954) (PAR(230 + I), I = 1, 9),
     1      SPGRNM(1)(12:13), J, SPGRNM(1)(1:7), IGBL(4)
        END IF
      END IF
      IF (IGBL(31) <  0) WRITE (LU2, 99995)
C * ENDS (SPF)
      IF (IGBL(31) == 3 .AND. IPR(504) /= 2) THEN
C * TEST FOR UNIT MATRIX
        IF (GEN135 (PAR(231)) == 0) THEN
          WRITE (LU2, FORMC) (PAR(I), I = 231, 239)
        ELSE
          WRITE (LU2, 99940)
        END IF
        IF (IGBL(97) == 0) THEN
          WRITE (LU2, 99944)
        ELSE
          WRITE (LU2, 99943)
        END IF
      END IF
C * TEST FOR .RES FILE
      IF (IPR(504) == 2) THEN
C * TEST FOR UNIT MATRIX
        IF (GEN135 (PAR(231)) == 0) THEN
          WRITE (LU2, FORMC) (PAR(I), I = 231, 239)
        ELSE
          WRITE (LU2, 99940)
        END IF
        IF (IPR(595) == 0) THEN
          WRITE (LU2, 99956) IPR(209), ' '
        ELSE
          WRITE (LU2, 99956) IPR(209), 'NOSF'
        END IF
        CLOSE (UNIT = LU1, IOSTAT = IOST)
        CLOSE (UNIT = LU2, IOSTAT = IOST)
        IF (IOST == 0 .OR. IOST /= 0) CALL PLA280 ('END')
        KXT    = 3
        EXTENS = 'spf'
        FNLU1 = NAMEFIL(1:KNMFIL)//'_pl.'//EXTENS(1:KXT)
        OPEN (UNIT = LU1, FILE = FNLU1, FORM = 'FORMATTED',
     1         STATUS = 'OLD')
        IPR(3)  = 1
        IGBL(8) = 1
      END IF
C * NUMBER OF ISOTROPIC NON-H ATOMS
      IF (IGBL(94) == 0) THEN
        IF (IPR(489) + IPR(490) > 0) THEN
          IF (IGBL(22) /= -1) THEN
C * ALERT _201 - Main residue isotropic non-hydrogen atoms
            IF (IPR(489) > 0) THEN
C * CHECK FOR POWDER
              IF (IPR(105) == 0) THEN
C * CHECK FOR ANHARMONIC DISPLACEMENT PARAMETERS
                IF (IPR(756) == 0) THEN
                  CALL PLA236 (-201, 0, FLOAT (IPR(489)),
     1               FLOAT (IPR(489)), ' ', ' ')
                  L = MIN (NP77, IPR(489))
                  DO I = 1, L, 8
                    K = MIN (7, L - I)
                    WRITE (PRBUF, 99969) (CISO(I + J, 1), J = 0, K)
                    WRITE (LU68, 99950)  PRBUF(1:79)
                  END DO
                END IF
              ELSE
                CALL PLA236 (201, 0, -999.0, FLOAT (IPR(489)), ' ', ' ')
              END IF
            END IF
C * ALERT _202 - Anion/Solvent isotropic non-hydrogen atoms
            IF (IPR(490) > 0) THEN
C * CHECK FOR POWDER STUDY
              IF (IPR(105) == 0) THEN
                CALL PLA236 (-202, 0, FLOAT (IPR(490)), FLOAT (IPR(490))
     1                    , ' ', ' ')
                L = MIN (NP77, IPR(490))
                DO I = 1, L, 8
                  K = MIN (7, L - I)
                  WRITE (PRBUF, 99969) (CISO(I + J, 2), J = 0, K)
                    WRITE (LU68, 99950) PRBUF(1:79)
                END DO
              ELSE
                CALL PLA236 (202, 0, -999.0, FLOAT (IPR(490)), ' ', ' ')
              END IF
            END IF
          END IF
        END IF
C * ALERT _210
        IF (IPR(32) == 0 .AND. IGBL(22) /= -1) THEN
C * CHECK FOR POWDER STUDY
          IF (IPR(105) == 0) THEN
C * SUPPRESS FOR ANHARMONIC
            IF (IPR(756) == 0) THEN
              CALL PLA236 (210, 0, 1.0, 1.0, ' ', ' ')
            END IF
          ELSE
            CALL PLA236 (210, 0, -999.0, 1.0, ' ', ' ')
          END IF
        END IF
      END IF
      RETURN
99999 FORMAT ('FVAR ', 6F10.5, ' =', 8(/, 5X, 6F10.5, '='))
99998 FORMAT ('TEMP ', I5)
99997 FORMAT (A, I3, 3F9.5, 1X, A, /, 5X, F10.5, 6F9.4)
99996 FORMAT (A, I3, 3F9.5, F10.5, F9.4)
99995 FORMAT ('END')
99994 FORMAT ('SCAT', 16(1X, A))
99993 FORMAT (/, 57X, 13('='), /, 56('*'), ' Residue = ', I3, 1X,
     1 61('*'), /, 57X, 13('=')/)
99992 FORMAT ('RESD ', I5)
99991 FORMAT (132('-'), /, 'Atom  Label', 4X, 'U11 or Uiso', 6X, 'U22',
     1 10X, 'U33', 10X, 'U23', 10X, 'U13', 10X, 'U12', 8X, 'Ueq(sUeq)',
     2 5X, 'U1', 5X, 'U2', 5X, 'U3', 1X, 'U3/U1', /, 132('-'))
99990 FORMAT ('VOLU ', 2F10.3)
99989 FORMAT ('SPGR P1')
99988 FORMAT ('U    ', A, 1X, A, 2X, 2F12.5)
99987 FORMAT ('ATOM ', A, 1X, A, 2X, 3F12.6, F7.4, ' =', /,
     1        16X, 3F9.6, F7.4)
99986 FORMAT ('UIJ  ', A, 1X, A, ' =', /,
     1        16X, 7F9.5)
99985 FORMAT ('SUIJ ', A, 1X, A, ' =', /,
     1        16X, 7F9.5)
99984 FORMAT ('(An)isotropic, Equivalent and Main Axes Displacement ',
     1 'Parameters - Unusual Values Marked with a ', A,
     2 ' - [Optional Coordinate Split-up]', /, 132('-'))
99983 FORMAT (/, 49X, 21('='), /, 38X, 'The Displacement Factor has ',
     1 'the Form of Exp(-T)'//54X, 'where'//29X, 'T = 8*(pi**2)*Uiso*',
     2 'sin(theta/lambda)**2, for Isotropic Atoms,'//2X, 'T = 2*(pi',
     3 '**2)*(U11*(h*as)**2+U22*(k*bs)**2+U33*(l*cs)**2+2*U23*k*l*',
     4 'bs*cs+2*U13*h*l*as*cs+2*U12*h*k*as*bs),for Anisotr. Atoms'//
     5 37X, ' Ueq = 1/3 Sum(i,j) (Uij*as(i)*as(j)*a(i).a(j))',//, 34X,
     6 ' U1, U2, U3 are the three Main Axes Components of Uij', //,
     7 'Reference U(eq): R.X. Fischer & E. Tillmanns, ',
     8 'Acta Cryst. (1988). C44, 775-776')
99982 FORMAT ('TITL ', A)
99981 FORMAT ('SFAC ', A, 7F10.5, ' =', /, 7X, 4F10.5, F10.3, 2F10.5)
99980 FORMAT ('UNIT ', 2I5, 14I4)
99979 FORMAT ('CESD', 9X, 3F10.4, 3F10.3)
99978 FORMAT ('LATT ', A, 2X, A)
99977 FORMAT ('SYMM ', A)
99976 FORMAT ('SPGR ', 5A)
99975 FORMAT ('LATT', I4)
99974 FORMAT ('CELL', F9.5, 3F10.4, 3F10.3)
99973 FORMAT ('TRNS ', 6F9.5, ' = ', /, 5X, 6F9.5)
99972 FORMAT (13X, 6(F13.4))
99971 FORMAT ('ZERR', I9, 3F10.4, 3F10.3)
99970 FORMAT ('NOMOVE')
99969 FORMAT (14X, 8A)
99968 FORMAT (/, 'Ueq [or U(iso)] Averages per Element', /,
     1        132('-'), /, 10X, 'Non-H', 16(3X, A, 2X))
99967 FORMAT (132('-'), /, 'Average', 1X, 17F7.4)
99966 FORMAT ('Minimum', 1X, 17F7.4)
99965 FORMAT ('Maximum', 1X, 17F7.4)
99964 FORMAT ('Ratio  ', 1X, 17F7.4)
99963 FORMAT ('HEADER', 1X, A, /, 'CRYST1', 3F9.3, 3F7.2, 1X, A, /,
     1        'SCALE1', 4X, 3F10.7, 5X, F10.7, /,
     2        'SCALE2', 4X, 3F10.7, 5X, F10.7, /,
     3        'SCALE3', 4X, 3F10.7, 5X, F10.7)
99962 FORMAT ('ATOM', 2X, I5, 1X, A, 5X, I5, 4X, 3F8.3, 2F6.2, 10X, A)
99961 FORMAT ('AFIX', I4)
99960 FORMAT ('REM RESET CLOSENESS CRITERIUM', /,
     1 'SET PAR 22', F10.3)
99959 FORMAT (':: ADP ', A, 3F8.3, ' - RATIO(MAX/MIN) = ', F8.1, 1X, A)
99958 FORMAT ('W: No Wavelength given, MoKa - assumed for SFAC')
99957 FORMAT ('Number', 2X, 17I7)
99956 FORMAT ('SET IPR 209', I3, /, 'CALC SHELX ', A, /, 'END')
99954 FORMAT ('REM TRMX', 9F7.3, 1X, A, I3, /, 'REM SPGR ', A, /,
     1        'REM PLATON VERSION', I7)
99953 FORMAT (A, I3, 3F9.5, 2F10.5, F9.3)
99952 FORMAT (15X, '[', F9.4, 2F13.4, '] & [', F8.4, 2F13.4,']')
99951 FORMAT ('SET PAR 2', F6.2)
99950 FORMAT (A)
99949 FORMAT ('BOND $H')
99948 FORMAT (/, 'U(i,j)-Average', F11.4, 5F13.4, 6X, 4F7.4, F7.2, /)
99947 FORMAT ('REM SET NO EXPAND OPTION', /, 'SET IGBL 136 1')
99944 FORMAT ('INORGANIC')
99943 FORMAT ('ORGANIC')
99942 FORMAT ('L.S. 5', /, 'FMAP 2', /, 'PLAN -20', /, 'ACTA', /,
     1  'CONF')
99941 FORMAT ('SFAC', 16(1X, A))
99940 FORMAT ('HKLF 4')
99939 FORMAT ('WGHT', 2F10.5)
99938 FORMAT (F7.3)
99937 FORMAT ('BASF', F10.3, /, 'TWIN')
99936 FORMAT ('DISP', 1X, A, 2F10.3, F10.1)
99935 FORMAT ('EXTI', F11.4)
99934 FORMAT ('PART', I4)
99933 FORMAT ('NEUT')
99932 FORMAT ('SIZE', 3F10.4)
99931 FORMAT ('RESI', 1X, A)
99930 FORMAT ('Resd', I5)
      END SUBROUTINE PLA026
 
      MODULE tlsanal
      SAVE
      REAL, DIMENSION(3, 3) :: D
      REAL, DIMENSION(3, 3) :: R
      REAL, DIMENSION(3, 3) :: UC
      REAL, DIMENSION(3, 3) :: UI
      REAL, DIMENSION(3, 3) :: SL
      REAL, DIMENSION(3, 3) :: SO
      REAL, DIMENSION(3, 3) :: TO
      REAL, DIMENSION(3)    :: W3
      REAL, DIMENSION(3)    :: T3
      REAL, DIMENSION(20)   :: AO
      REAL, DIMENSION(25)   :: BN
      REAL, DIMENSION(250)  :: AN
      REAL, DIMENSION(3, 3) :: VI
      REAL, DIMENSION(3, 3) :: VT
      REAL, DIMENSION(3, 3) :: TL
      REAL, DIMENSION(3, 3) :: W1
      REAL, DIMENSION(3, 3) :: W2
      REAL, DIMENSION(3, 3) :: S1
      REAL, DIMENSION(3, 3) :: T1
      REAL, DIMENSION(3, 3) :: T2
      REAL, DIMENSION(3, 3) :: AMC
      REAL, DIMENSION(3, 3) :: ALC
      REAL, DIMENSION(3, 3) :: ATC
      REAL, DIMENSION(3, 3) :: ALM
      REAL, DIMENSION(3, 3) :: ATM
      REAL, DIMENSION(3)    :: XCG
      REAL, DIMENSION(3)    :: ROL
      REAL, DIMENSION(3)    :: W3D
      REAL, DIMENSION(3, 3) :: TW2
      REAL, DIMENSION(3, 3) :: TT2
      REAL, DIMENSION(3, 3) :: SOM
      REAL, DIMENSION(3, 3) :: TOM
      REAL, DIMENSION(3, 3) :: TOM2
      REAL, DIMENSION(3)    :: VALI
      REAL, DIMENSION(3)    :: XOCG
      REAL, DIMENSION(3)    :: TOM3
      REAL, DIMENSION(3, 3) :: HCTI
      REAL, DIMENSION(3, 3) :: HITC
      REAL, DIMENSION(3, 3) :: TTOM2
      END MODULE tlsanal
 
      SUBROUTINE PLA027
C * TLS - ANALYSIS (1)
      USE files
      USE parameters
      USE plato
      USE atomdata
      USE cchar
      USE tlsanal
      USE sgxyz
      IMPLICIT NONE
      INTEGER :: I
      INTEGER :: J
      INTEGER :: K
      INTEGER :: L
      INTEGER :: M
      INTEGER :: N
      INTEGER :: NN
      INTEGER :: IVL
      INTEGER :: NRS
      INTEGER :: NNA
      INTEGER :: NMAX
      INTEGER :: NRES
      INTEGER :: IVAL
      INTEGER :: NATR
      INTEGER :: IDUM
      INTEGER :: JDUM
      INTEGER :: JLOOP
      REAL :: Y
      REAL :: DET
      REAL :: SIG
      REAL :: SUMX
      REAL :: DELM
      REAL :: RMSD
      REAL :: SUM1
      REAL :: UEQC
      REAL :: UEQO
      REAL :: RIND
      REAL :: SUMN
      REAL :: SUMN1
      REAL :: RIND1
      CHARACTER(len=1) :: ITLS
C * TMA - ANALYSIS
      RIND  = 0.0
      RIND1 = 0.0
      IF (IPR(32) /= 0 .AND. IPR(5) /= 0) THEN
C * GET NUMBER OF ATOMS IN ATOM LIST
        NMAX = IPR(39)
        NRES = IPR(75)
        DO I = 1, NMAX
          DO J = 1, 6
            CON(I, J) = ANIS(I, J)
          END DO
          CALL GEN048 (-4, IFG(1, I), 15, IVL)
          CON(I, 7)  = SATWT(IVL + 1)
          CON(I, 8)  = (SUAN(I, 1) + SUAN(I, 2) + SUAN(I, 3)) / 3
          SUAN(I, 7) = CON(I, 8)
        END DO
        DO NRS = 1, NRES
          NATR    = 0
          IPR(73) = 1
          IPR(74) = 1
          ITLS    = 'S'
          DO I = 1, NMAX
            IVL = NP1 + I
C * GET AND TEST FOR RESIDUE NUMBER
            CALL GEN048 (-6, IFG(1, I), 9, IVAL)
            IF (IVAL == NRS) THEN
C * GET (AN)ISO FLAG
              CALL GEN048 (-1, IFG(1, I), 4, IVAL)
              IF (IVAL /= 0) THEN
                IF (IPR(497) /= 0) THEN
                  IVAL = 0
                ELSE
C * H-IDENTIFICATION
                  CALL GEN048 (-1, IFG(1, I), 7, IVAL)
                END IF
C * THIS SECTION IS CORRECT ONLY FOR 1 or -1 STRUCTURES
                IF (IVAL == 0) THEN
                  IVL  = I
                  NATR = NATR + 1
                  CALL PLA047 (LABA(I), NQ1, IVAL, JDUM, IPR(71),
     1                         IGBL(55), 0, 0)
                END IF
              END IF
            END IF
            IATP(I) = IVL
          END DO
          IF (IPR(32) /= 0) THEN
            RMSD = 0.0
            IF (NATR >= 3) THEN
C * CALCULATE LEAST-SQUARES PLANE
              CALL PLA054 (1)
              M = 0
C * CHECK FOR NON-PLANARITY
              DO N = 1, NMAX
                I = IATP(N)
                IF (I <= NP1) THEN
                  M    = M + 1
                  RMSD = RMSD +
     1                   (XPV(1) * XXO(I, 4) + XPV(2) * XXO(I, 5) +
     2                    XPV(3) * XXO(I, 6) - XPV(4)) ** 2
                END IF
              END DO
              RMSD = SQRT (RMSD / M)
            END IF
            IF (NATR < IPR(21) .OR. RMSD < PAR(574)) THEN
              WRITE (LU6, 99998, IOSTAT = IOST) NRS, NATR, IPR(21),
     1          RMSD, PAR(574)
            ELSE
C * ORDER EIGENVECTORS BASED ON SMALL TO LARGE EIGENVALUES
              DO I = 1, 3
                VALI(I)  =  DUMA(I)
                XOCG(I)  =  V7(I)
                VI(I, 3) =  DUMV(I, 1)
                VI(I, 1) =  DUMV(I, 3)
                VI(I, 2) = -DUMV(I, 2)
                VT(3, I) =  DUMV(I, 1)
                VT(1, I) =  DUMV(I, 3)
                VT(2, I) = -DUMV(I, 2)
              END DO
              CALL GEN018 (VALI(1), VALI(3))
              DO K = 1, NMAX
                IF (IATP(K) <= NP1) THEN
                  DO I = 1, 3
                    XXO(K, I) = 0.0
                    DO J = 1, 3
                      XXO(K, I) = XXO(K, I) + (XXO(K, J + 3)
     1                          - XOCG(J)) * VI(J, I)
                    END DO
                  END DO
                END IF
              END DO
C * SAVE TRANSFORMED ORTHOGONAL COORDINATES IN VOID SCRATCH
              CALL PLA269 (2, NMAX)
              DO I = 1, 3
                DO J = 1, 3
                  IF (I == J) THEN
                    D(I, I) = PAR(112 + I)
                  ELSE
                    D(I, J) = 0.0
                  END IF
                END DO
              END DO
C * MATRIX PRODUCTS - CRYSTAL TO INERTIAL
              CALL GEN132 (VT, OR, D, HCTI)
C * GET INVERSE
              CALL GEN003 (HCTI, HITC, DET, 0)
              DO N = 1, NMAX
                IF (IATP(N) <= NP1) THEN
                  DO I = 1, 6
                    DUMA(I) = CON(N, I)
                  END DO
C * COPY 6-ELEMENT VECTOR INTO SYMMETRICAL MATRIX
                  CALL GEN025 (UC, DUMA, -1)
C * CALCULATE UI = HCTI * UC * HCTI~
                  CALL GEN001 (1, HCTI,  UC,   UI)
                  SUAN(N, 1) = UI(1, 1)
                  SUAN(N, 2) = UI(1, 2)
                  SUAN(N, 3) = UI(1, 3)
                  SUAN(N, 4) = UI(2, 2)
                  SUAN(N, 5) = UI(2, 3)
                  SUAN(N, 6) = UI(3, 3)
                END IF
              END DO
C * ZERO AN & BN
              CALL GEN074 (BN, 1, 25,  0.0)
              CALL GEN074 (AN, 1, 250, 0.0)
              NN = 12 + IPR(74) * 8
              DO I = 1, NMAX
                IF (IATP(I) <= NP1) THEN
                  DO JLOOP = 1, 6
                    J = JLOOP
                    CALL GEN100 (AO, J, XXO(I, 1), XXO(I, 2), XXO(I, 3))
                    M = NN + 1
                    DO N = 1, NN
                      Y     = AO(N)
                      L     = M
                      M     = M + NN - N + 1
                      BN(N) = BN(N) + Y * SUAN(I, J)
                      IF (ABS (Y) > 1.0E-15) THEN
                        AN(N) = AN(N) + Y**2
                      END IF
                      DO K = N, NN
                        IF (ABS (Y) > 1.0E-15 .AND.
     1                      ABS (AO(K)) > 1.0E-15) THEN
                          AN(L) = AN(L) + Y * AO(K)
                        END IF
                        L = L + 1
                      END DO
                    END DO
                  END DO
                END IF
              END DO
              IF (IGBL(63) > 2) THEN
C * CHECK FOR INTRA POLYMER
                IF (IPR(739) == 0) THEN
C * NEWPAGE + HEADER Schomaker and Trueblood Analysis
                  CALL PLA262 (-2)
                  WRITE (LU7, 99999, IOSTAT = IOST)
                END IF
                IF (NRES /= 1) THEN
                  CALL PLA262 (5)
                  WRITE (LU7, 99997, IOSTAT = IOST) NRS
                END IF
              END IF
C * CHECK FOR INTRA POLYMER
              IF (IPR(739) == 0) THEN
                CALL GEN012 (AN, BN, NN, 0.0, PAR(410), 1.0)
                IF (IGBL(63) > 2) THEN
C * PRINT U(IJ) COMPARISON TABLE HEADER
                  CALL PLA262 (5)
                  WRITE (LU7, 99996, IOSTAT = IOST)
                END IF
                NNA   = 0
                SUMX  = 0.0
                SUM1  = 0.0
                SUMN  = 0.0
                SUMN1 = 0.0
                DELM  = 0.0
C * ACCUMULATE  DATA FOR R1, R2 & S
                DO I = 1, NMAX
                  IF (IATP(I) <= NP1) THEN
                    DO JLOOP = 1, 6
                      J       = JLOOP
C * GET AND ACCUMULATE OBSERVED VALUES
                      DUMA(J) = - SUAN(I, J)
                      SUMN    = SUMN  + DUMA(J)**2
                      SUMN1   = SUMN1 + ABS (DUMA(J))
C * GET CALCULATED VALUES
                      CALL GEN100 (AO, J, XXO(I, 1), XXO(I, 2),
     1                             XXO(I, 3))
                      DO K = 1, NN
                        DUMA(J) = DUMA(J) + AO(K) * AN(K)
                      END DO
                      SUMX  = SUMX  + DUMA(J)**2
                      SUM1 = SUM1 + ABS (DUMA(J))
                      IF (ABS(DUMA(J)) > DELM) DELM = ABS (DUMA(J))
                    END DO
                    NNA = NNA + 6
                    IF (IGBL(63) > 2) THEN
                      CALL PLA047 (LABA(I), NQ1, IDUM, JDUM,
     1                  IPR(71), IGBL(55), 0, 1 - IGBL(55))
                      CALL PLA262 (2)
                      UEQO = (SUAN(I, 1) + SUAN(I, 4) + SUAN(I, 6))
     1                     / 3.0
                      UEQC = UEQO + (DUMA(1) + DUMA(4) + DUMA(6)) / 3.0
                      WRITE (LU7, 99995, IOSTAT = IOST) NQ1(1:7),
     1                  (SUAN(I, K), DUMA(K), K = 1, 6), UEQO, UEQC
                      UI(1, 1) = DUMA(1)
                      UI(1, 2) = DUMA(2)
                      UI(1, 3) = DUMA(3)
                      UI(2, 1) = UI(1, 2)
                      UI(2, 2) = DUMA(4)
                      UI(2, 3) = DUMA(5)
                      UI(3, 1) = UI(1, 3)
                      UI(3, 2) = UI(2, 3)
                      UI(3, 3) = DUMA(6)
                      CALL GEN001 (1, HITC, UI, UC)
                      WRITE (LU7, 99993, IOSTAT = IOST)
     1                  CON(I, 1), UC(1, 1), CON(I, 6), UC(1, 2),
     2                  CON(I, 5), UC(1, 3), CON(I, 2), UC(2, 2),
     3                  CON(I, 4), UC(2, 3), CON(I, 3), UC(3, 3)
                    END IF
                  END IF
                END DO
C * GET R1 & R2
                SIG   = SQRT (SUMX / (NNA - IPR(73) * NN))
                RIND1 = SUM1 / SUMN1
                RIND  = SQRT (SUMX / SUMN)
                IF (IGBL(63) > 2) THEN
                  CALL PLA262 (17)
                  WRITE (LU7, 99994, IOSTAT = IOST)
     1              RIND1, RIND, SIG, NATR, IPR(73), NN, DELM, ITLS
                END IF
                DO I = 1, NN
                  BN(I) = BN(I) * SIG
                END DO
                CALL PLA043 (0, 1, LU7, 0)
              END IF
C * SKIP SUBSEQUENT TLS - ANALYSIS FOR RIND > PAR(34) .OR. POLYMERS
              IF (RIND > PAR(34) .OR. IPR(739) > 0) THEN
                CALL PLA029 (0, W1, W2, NRS)
              ELSE
                CALL PLA029 (1, W1, W2, NRS)
              END IF
            END IF
          END IF
        END DO
      END IF
      RETURN
99999 FORMAT ('V.Schomaker and K.N.Trueblood Rigid Body Motion',
     1 ' Analysis, TLS - Model   (Acta Cryst. (1968), B24, 63-76)',
     2 '  -  see also Dunitz, p244', /, 132('='))
99998 FORMAT (':: No TLS-Analysis for Resd Nr:', I3, /,
     1 ':: # non-H atoms', I3 ' <', I3, ' and/or Planar Molecule',
     2 ' RMSD =', F6.3, ' [', F6.3, '] Ang.', /)
99997 FORMAT (/, 57X, 13('='), /, 56('*'), ' Residue =', I4, 1X,
     1 61('*'), /, 57X, 13('='), /)
99996 FORMAT ('Observed Vibration Tensor in Inertial System ',
     1 'I(1) = L, I(2) = M',
     2 ', I(3) = N (Difference U(calc) - U(obs) in [ ])', /,
     3 132('='), /, 'Label     U(L,L)', 12X, 'U(L,M)', 12X, 'U(L,N)',
     4 12X, 'U(M,M)', 12X, 'U(M,N)', 12X, 'U(N,N)', 9X,
     5 'Ueq(obs) Ueq(cal)', /, 12X, 'U11', 15X, 'U12', 15X, 'U13',
     6 15X, 'U22', 15X, 'U23', 15X, 'U33', /, 132('-'))
99995 FORMAT (A, 6(F9.5, '[', F7.5, ']'), F8.4, F9.4)
99994 FORMAT (//
     1 'R1 = Sum(abs(U(obs)-U(calc)))/Sum(abs(U(obs)))     =', F10.5,//
     2 'R2 = Sqrt(Sum((U(obs)-U(calc))**2)/Sum(U(obs)**2)) =', F10.5,//
     3 'S  = Sqrt(Sum((U(obs)-U(calc))**2)/(6*N-NS*M))     =', F10.5,//
     4 'N  = Number of Atoms in Rigid Group', 16X,        '=', I10  ,//
     5 'NS = Symmetry Factor', 31X, '=', I10, //, 'M  = Number of ',
     6 'Rigid-Body Parameters', 15X, '=', I10, //, 5X,
     7 'Largest abs(U(obs)-U(calc))', 19X, '=', F10.5, //, 54X, 'TL', A,
     8 '-Mode')
99993 FORMAT (7X, 6(F9.5, '[', F7.5, ']'))
       END SUBROUTINE PLA027
 
      SUBROUTINE PLA028
C * TMA ANALYSIS (2)
      USE files
      USE parameters
      USE plato
      USE tlsanal
      USE sgxyz
      IMPLICIT NONE
      INTEGER :: I
      INTEGER :: J
      INTEGER :: K
      INTEGER :: L
      INTEGER :: N
      REAL :: TRSN
      REAL :: TRSO
      REAL :: XLNG
      REAL :: ATCIJ
      REAL :: ALCIJ
      REAL :: AMCIJ
      K = 0
      DO I = 1, 3
        DO J = I, 3
          K = K + 1
          W1(I, J) = AN(K)
          W1(J, I) = AN(K)
          T1(I, J) = AN(K + 6)
          T1(J, I) = T1(I, J)
          S1(I, J) = 0.0
          S1(J, I) = 0.0
        END DO
      END DO
      BN(21) = 0.0
      IF (IPR(74) /= 0) THEN
        S1(1, 1) = AN(13)
        S1(1, 2) = AN(14)
        S1(1, 3) = AN(15)
        S1(2, 1) = AN(16)
        S1(2, 2) = AN(17)
        S1(2, 3) = AN(18)
        S1(3, 1) = AN(19)
        S1(3, 2) = AN(20)
        S1(3, 3) = -AN(13) - AN(17)
        BN(21) = SQRT (BN(13)**2 + BN(17)**2)
      END IF
      CALL GEN024 (W1, W2, W3, TW2)
      CALL GEN024 (T1, T2, T3, TT2)
      CALL GEN004 (VT, OR, AMC)
      CALL GEN132 (W2, VT, OR, ALC)
      CALL GEN002 (1, ROR, XOCG, XCG, XLNG)
      CALL GEN001 (1, W2, S1, SL)
      CALL GEN001 (1, W2, T1, TL)
      ROL(1) = (SL(2, 3) - SL(3, 2)) / (W3(2) + W3(3))
      ROL(2) = (SL(3, 1) - SL(1, 3)) / (W3(3) + W3(1))
      ROL(3) = (SL(1, 2) - SL(2, 1)) / (W3(1) + W3(2))
      R(1, 1) =   0.0
      R(1, 2) =   ROL(3)
      R(1, 3) = - ROL(2)
      R(2, 1) = - ROL(3)
      R(2, 2) =   0.0
      R(2, 3) =   ROL(1)
      R(3, 1) =   ROL(2)
      R(3, 2) = - ROL(1)
      R(3, 3) =   0.0
      DO N = 1, 3
        DO I = 1, 3
          SO(N, I) = R(I, N) * W3(N) + SL(N, I)
        END DO
      END DO
      DO I = 1, 3
        DO L = 1, 3
          TO(I, L) = 0.0
          DO J = 1, 3
            TO(I, L) = TO(I, L) + R(I, J) * R(L, J) * W3(J)
     1               + R(I, J) * SL(J, L) + R(L, J) * SL(J, I)
          END DO
          TO(I, L) = TO(I, L) + TL(I, L)
        END DO
      END DO
      CALL GEN001 (1, TW2, TO, TOM)
      CALL GEN001 (1, TW2, SO, SOM)
      CALL GEN024 (TOM, TOM2, TOM3, TTOM2)
      CALL GEN132 (TOM2, VT, OR, ATC)
      DO I = 1, 3
        W3D(I) = W3(I) * RGBL(6)**2
        DO J = 1, 3
          AMCIJ = AMC(I, J) / PAR(100 + J)
          IF (ABS (AMCIJ) > 1.0) AMCIJ = SIGN (1.0, AMCIJ)
          AMC(I, J) = ACOS (AMCIJ) * RGBL(6)
          ALCIJ     = ALC(I, J) / PAR(100 + J)
          IF (ABS (ALCIJ) > 1.0) ALCIJ = SIGN (1.0, ALCIJ)
          ALC(I, J) = ACOS(ALCIJ) * RGBL(6)
          ATCIJ     = ATC(I, J) / PAR(100 + J)
          IF (ABS (ATCIJ) > 1.0) ATCIJ = SIGN (1.0, ATCIJ)
          ATC(I, J) = ACOS (ATCIJ)      * RGBL(6)
          ALM(I, J) = ACOS (W2(I, J))   * RGBL(6)
          ATM(I, J) = ACOS (TOM2(I, J)) * RGBL(6)
        END DO
      END DO
      TRSO = T3(1)   + T3(2)   + T3(3)
      TRSN = TOM3(1) + TOM3(2) + TOM3(3)
C * LIMIT ESD'S TO MAX 0.99999 TO MEET PRINTING FORMAT
      DO I = 1, 21
        IF (ABS(BN(I)) > 0.99999) BN(I) = 0.999989
      END DO
      IF (IGBL(63) > 2) THEN
        CALL PLA262 (0)
        WRITE (LU7, 99999, IOSTAT = IOST)
     1    (I, (VT(I, J), J = 1, 3), VALI(I),
     2    (AMC(I, J), J = 1, 3), CHAR (ICHAR ('W') + I),
     3     XCG(I), I = 1, 3)
        WRITE (LU7, 99998, IOSTAT = IOST)
     1   (W1(1, J), NINT (BN(J) * 1.0E+5), J = 1, 3),
     2   (W2(1, J), J = 1, 3), W3(1), W3D(1), SQRT (MAX (0.0, W3D(1))),
     3   (W1(2, J), NINT (BN(J + 2) * 1.0E+5), J = 2, 3),
     4   (W2(2, J), J = 1, 3), W3(2), W3D(2), SQRT (MAX (0.0, W3D(2))),
     5    W1(3, 3), NINT (BN(6) * 1.0E+5),
     6   (W2(3, J), J = 1, 3), W3(3), W3D(3), SQRT (MAX (0.0, W3D(3)))
        WRITE (LU7, 99997, IOSTAT = IOST)
     1    (T1(1, J), NINT (BN(J + 6) * 1.0E+5), J = 1, 3),
     2    (T2(1, J), J = 1, 3), T3(1), SQRT (T3(1)),
     3    (T1(2, J), NINT (BN(J + 8) * 1.0E+5), J = 2, 3),
     4    (T2(2, J), J = 1, 3), T3(2), SQRT (MAX (0.0, T3(2))),
     5    T1(3, 3), NINT (BN(12) * 1.0E+5),
     6    (T2(3, J), J = 1, 3), T3(3), SQRT (MAX (0.0, T3(3)))
        IF (IPR(74) /= 0) THEN
          WRITE (LU7, 99996, IOSTAT = IOST)
     1      (S1(1, J), NINT (BN(J + 12) * 1.0E+5), J = 1, 3),
     2      (S1(2, J), NINT (BN(J + 15) * 1.0E+5), J = 1, 3),
     3      (S1(3, J), NINT (BN(J + 18) * 1.0E+5), J = 1, 3)
          WRITE (LU7, 99995, IOSTAT = IOST) TRSO, TRSN
          WRITE (LU7, 99994, IOSTAT = IOST)
     1      (I, ROL(I), (SOM(I, J), J = 1, 3),
     2      (TOM(I, J), J = 1, 3), I, (TOM2(I, J), J = 1, 3),
     3      TOM3(I), I = 1, 3)
        END IF
        WRITE (LU7, 99993, IOSTAT = IOST)
        WRITE (LU7, 99992, IOSTAT = IOST)
     1    (I, (ALM(I, J), J = 1, 3), (ALC(I, J), J = 1, 3),
     2     I, (ATM(I, J), J = 1, 3), (ATC(I, J), J = 1, 3), I = 1, 3)
      END IF
      RETURN
99999 FORMAT ('Inertial Tensor I, Eigenvectors and Eigenvalues ',
     1 'of I in the Cartesian XO,YO,ZO System and Angular Relation',
     2 ' with X,Y,Z System', /, 132('-'), /, 15X, 'XO', 8X, 'YO',
     3 8X, 'ZO', 10X, 'Value', 14X, 'X', 9X, 'Y', 9X, 'Z', 5X, 'Origin',
     4 ' (Mass-Weighted)', /, 132('-'), /, 3('I(', I1, ')', 3X,
     5 3F10.5, 5X, F10.2, 6X, 3F10.2, 3X, A, ' =', F9.5, /))
99998 FORMAT ('Librational Tensor, L(rad**2)', 25X, 'Eigenvectors ',
     1 'and Eigenvalues of L in the Inertial System XI,YI,ZI', /,
     2 132('-'), /, 66X, 'XI', 8X, 'YI', 8X, 'ZI', 9X, 'rad**2', 4X,
     3 'Deg**2', 7X, 'Deg', /, 132('-'), /, F8.5, '(', I3, ')', F11.5,
     4 '(', I3, ')', F11.5, '(', I3, ')', 9X, 'L(1)', 3F10.5, 5X,
     5 F10.5, 2F10.2, /, 16X, F8.5, '(', I3, ')', F11.5, '(', I3,
     6 ')', 9X, 'L(2)', 3F10.5, 5X, F10.5, 2F10.2, /, 32X, F8.5, '(',
     7 I3, ')', 9X, 'L(3)', 3F10.5, 5X, F10.5, 2F10.2, /)
99997 FORMAT ('Translational Tensor, T(ang**2)', 23X, 'Eigenvectors',
     1 ' and Eigenvalues of T in the Inertial System XI,YI,ZI', /,
     2 132('-'), /, 66X, 'XI', 8X, 'YI', 8X, 'ZI', 10X, 'Ang^2', 12X,
     3 'Ang', /, 132('-'), /, F8.5, '(', I3, ')', F11.5, '(', I3,
     4 ')', F11.5, '(', I3, ')', 9X, 'T(1)', 3F10.5, 2F15.5, /, 16X,
     5 F8.5, '(', I3, ')', F11.5, '(', I3, ')', 9X, 'T(2)', 3F10.5,
     6 2F15.5, /, 32X, F8.5, '(', I3, ')', 9X, 'T(3)', 3F10.5,
     7 2F15.5)
99996 FORMAT ('Cross Tensor, S(rad*Ang)', /, 132('-'),
     1 3(/, F8.5, '(', I3, ')', 2(F11.5, '(', I3, ')')), /)
99995 FORMAT ('Calculation of the Origin Shift that Symmetrizes S',
     1 23X, '-  Trace old-T = ', F10.5, 7X, 'Trace new-T = ', F10.5, /,
     2 132('-'), /, 'Shift Origin in I', 17X, 'New S-Tensor', 17X,
     3 'New T-Tensor', 8X, 'Eigenvectors and Values of New-T in ',
     4 'I-System', /, 132('-'))
99994 FORMAT ('Rol(', I1, ')', F10.5, 3X, 3F10.5, 3X, 3F10.5, 1X,
     1 'New T(', I1, ')', 3F9.5, 4X, F9.5)
99993 FORMAT (/43X, 'Angular Relationships (Degrees)', /, 43X, 31('='))
99992 FORMAT ('Libration Axes  -  Inertial  Axes  ',
     1 'Libration Axes - Crystal Axes  ',
     2 'Translation Axes - Inertial  Axes  ',
     3 'Translation Axes - Crystal Axes', /, 64('-'), 2X, 67('-'), /,
     4 15X, 'XI', 6X, 'YI', 6X, 'ZI', 14X, 'X', 7X, 'Y', 7X, 'Z',
     5 18X, 'XI', 6X, 'YI', 6X, 'ZI', 15X, 'X', 7X, 'Y', 7X, 'Z', /,
     6 3('L(', I1, ')', 5X, 3F8.2, 7X, 3F8.2,
     7 2X, 'New T(', I1, ')', 2X, 3F8.2, 8X, 3F8.2, /))
      END SUBROUTINE PLA028
 
      SUBROUTINE PLA029 (MODE, W, W2, NRS)
C * TMA-ANALYSIS (3) (GEOM)
      USE files
      USE parameters
      USE plato
      USE atomdata
      USE cchar
      USE sgxyz
      IMPLICIT NONE
      INTEGER :: I
      INTEGER :: J
      INTEGER :: K
      INTEGER :: L
      INTEGER :: M
      INTEGER :: N
      INTEGER :: N0
      INTEGER :: NR1
      INTEGER :: NR2
      INTEGER :: NRB
      INTEGER :: NRS
      INTEGER :: NAD
      INTEGER :: IDS
      INTEGER :: JDS
      INTEGER :: IER
      INTEGER :: IENI
      INTEGER :: IENJ
      INTEGER :: IDIJ
      INTEGER :: IDUM
      INTEGER :: NADD
      INTEGER :: NDEC
      INTEGER :: NDIJ
      INTEGER :: NATR
      INTEGER :: MODE
      INTEGER :: NMAX
      INTEGER :: NSVI
      INTEGER :: NSVJ
      INTEGER :: JHYB
      INTEGER :: JUNK
      INTEGER :: IVLJ
      INTEGER :: IVAL
      INTEGER :: ISVI
      INTEGER :: ISVJ
      INTEGER :: ISSU
      INTEGER :: IHYB
      INTEGER :: IGEN
      INTEGER :: IVALI
      INTEGER :: IVALJ
      INTEGER :: IATPRI
      INTEGER :: IATPRJ
      REAL :: V
      REAL :: S
      REAL :: SC
      REAL :: VJ
      REAL :: VI
      REAL :: ANG
      REAL :: SVI
      REAL :: SVJ
      REAL :: SSU
      REAL :: DIJ
      REAL :: RVLI
      REAL :: SDIJ
      REAL :: TADD
      REAL :: XLNG
      REAL :: DMAX
      REAL :: TRACE
      REAL :: DELIJ
      REAL :: THIRSH
      REAL :: THIRSH0
      REAL :: DISTMAX
      REAL, DIMENSION(3, 3) :: W
      REAL, DIMENSION(3, 3) :: W2
      REAL, DIMENSION(3, 3) :: WO
      REAL, DIMENSION(3)    :: DY
      REAL, DIMENSION(3)    :: Z
      REAL, DIMENSION(3)    :: ANGL
      CHARACTER(len=1)   :: XMRK
      CHARACTER(len=114) :: FORMX
      FORMX(1:41)   = '(A,''- '',A,F6.0,''('',I3,'')'',F11.4,3F8.4,1X,'
      FORMX(42:79)  = 'F7.0,''('',I2,'')'',1X,F7.0,''('',I2,'')'',1X,'
      FORMX(80:114) = 'F7.0,''('',I2,'')'',1X,A,F9.4,2X,3F7.2)'
C * MODE = 0 - NO TLS ANALYSIS
C * MODE = 1 -    TLS ANALYSIS
      IER = 0
C * GET NUMBER OF ATOMS IN ATOM LIST
      NMAX = IPR(39)
      IF (MODE /= 0) THEN
        CALL PLA028
        TRACE = W(1, 1) + W(2, 2) + W(3, 3)
        DO I = 1, 3
          DO J = 1, 3
            IF (I == J) THEN
              TADD = TRACE
            ELSE
              TADD = 0.0
            END IF
            WO(I, J) = (TADD - W(I, J)) / 2
          END DO
        END DO
      ELSE
C * TEST FOR NON-POLYMER AND NO-DISORDER
        IF (IPR(739) /= 0 .OR. IPR(43) /= 0) THEN
          CALL PLA015 (0, 43)
          WRITE (LU6, 99993, IOSTAT = IOST)
          IF (IGBL(63) > 2) THEN
            CALL PLA262 (2)
            WRITE (LU7, 99993, IOSTAT = IOST)
          END IF
        ELSE
          WRITE (LU6, 99990, IOSTAT = IOST) NRS, PAR(34)
          IF (IGBL(63) > 2) THEN
            CALL PLA262 (2)
            WRITE (LU7, 99990, IOSTAT = IOST) NRS, PAR(34)
          END IF
        END IF
        CALL GEN074 (ANGL, 1, 3, 0.0)
        CALL GEN074 (DY,   1, 3, 0.0)
      END IF
      IF (NMAX < 500) THEN
        IF (IGBL(63) > 2) THEN
C * NEWPAGE
          CALL PLA262 (-7)
          WRITE (LU7, 99995, IOSTAT = IOST)
          WRITE (LU7, 99994, IOSTAT = IOST)
        END IF
        DELIJ = 0
        NRB   = 0
        NATR  = 0
        DO I = 1, NMAX
C * GET DISORDER INFO
          CALL GEN048 (-8, IFG(2, I), 1, IDS)
          IDS = IPPR(IDS + 1, 1)
          CALL GEN048 (-4, IFG(1, I), 24, IHYB)
C * TEST FOR MAJOR RESIDUE(S) = 0, ANION/SOLVENT = 1
          CALL GEN048 (-6, IFG(1, I), 9, IVAL)
          NADD = 0
          IF (RCONT(IVAL) < IPR(487) .AND. IPR(75) > 1) NADD = 1
          CALL GEN048 (-1, IFG(1, I), 19, IVALI)
          IF (IATP(I) <= NP1) THEN
            CALL PLA047 (LABA(I), NQ1, IDUM, IENI, IPR(71),
     1         IGBL(55), 0, 1 - IGBL(55))
            RVLI   = REL(IENI)
            IATPRI = IATPR(IENI)
            NR1    = IATNR(IENI)
            NATR   = NATR + 1
            DO J = I, NMAX
              IF (I /= J .AND. IATP(J) <= NP1) THEN
C * GET DISORDER INFO
                CALL GEN048 (-8, IFG(2, J), 1, JDS)
                JDS = IPPR(JDS + 1, 1)
                CALL GEN048 (-4, IFG(1, J), 24, JHYB)
                CALL PLA047 (LABA(J), NQ2, IDUM, IENJ, IPR(71),
     1                       IGBL(55), 0, 1 - IGBL(55))
                IATPRJ = IATPR(IENJ)
                CALL GEN048 (-1, IFG(1, J), 31, IVAL)
C * AVOID METAL N(O3) ETC. 'BONDS'
                IF (IATPRI * IVAL <= 0) THEN
                NR2  = IATNR(IENJ)
C * AVOID METAL-METAL
                  IF (IATPRI > 0 .AND. IATPRJ > 0) THEN
                    DMAX = 2.0
                  ELSE
                    DMAX = RVLI + REL(IENJ) + PAR(2)
                  END IF
                  DO K = 1, 3
                    V7(K) = XXO(I, K) - XXO(J, K)
                  END DO
                  CALL PLA053 (I, J, 0, 0, S, SSU, ISSU, NDEC, IER)
                  IF (S > 0.001 .AND. S < DMAX) THEN
                    SC = 0.0
                    IF (MODE /= 0) CALL GEN002 (1, WO, V7, DY, XLNG)
                    DO K = 1, 3
                      IF (MODE /= 0) THEN
                        Z(K) = V7(K) + DY(K)
                        SC   = SC + Z(K)**2
                      END IF
                      V7(K) = V7(K) / S
                    END DO
                    IF (MODE /= 0) THEN
                      CALL GEN002 (1, W2, V7, ANGL, XLNG)
                      DO K = 1, 3
                        ANG = MAX (-1.0, MIN (1.0, ANGL(K)))
                        ANGL(K) = ACOS(ANG) * RGBL(6)
                      END DO
                      SC = SQRT(SC)
                    END IF
C * GET COMPONENTS OF DISPLACEMENT ELLIPSOIDS ALONG BOND I-J
                    VI = 0.0
                    VJ = 0.0
                    DO K = 1, 3
                      DO L = 1, 3
                        M = K * L
                        IF (M == 6) M = 5
                        IF (M == 9) M = 6
                        VI = VI + V7(K) * SUAN(I, M) * V7(L)
                        VJ = VJ + V7(K) * SUAN(J, M) * V7(L)
                      END DO
                    END DO
                    SVI = CON(I, 8)
                    CALL GEN041 (VI, SVI, ISVI, 5, NSVI, IPR(68))
                    SVJ = CON(J, 8)
                    CALL GEN041 (VJ, SVJ, ISVJ, 5, NSVJ, IPR(68))
                    ISVI = MAX (0, MIN (99, ISVI))
                    ISVJ = MAX (0, MIN (99, ISVJ))
                    DIJ  = ABS(VI - VJ)
                    XMRK = ' '
                    NDIJ = 5
                    IF (ISVI > 0 .AND. ISVJ > 0) THEN
                      SDIJ = SQRT(CON(I, 8)**2 + CON(J, 8)**2)
                      CALL GEN041 (DIJ, SDIJ, IDIJ, 5, NDIJ, IPR(68))
                      IDIJ   = MIN (99, IDIJ)
                      THIRSH = DIJ / SDIJ
                      IF (THIRSH > PAR(421)) XMRK = '#'
                    ELSE
                      IDIJ = 0
                    END IF
                    DELIJ = DELIJ + DIJ**2
                    NRB   = NRB + 1
                    SDIJ  = SQRT(DIJ)
                    IF (I <= IPR(37)) THEN
                      CALL GEN048 (-1, IFG(1, I), 6, IGEN)
                      IF (IGEN == 1) THEN
                        JUNK = IPR(37)
                      ELSE
                        JUNK = IPR(39)
                      END IF
C * ALLOW FOR MAJOR DISORDER FORM BONDS AND
C * BONDS BETWEEN FULLY AND PARTIALLY OCCUPIED ATOMS
                      IF ((IDS == JDS  .AND. IDS > 5000)  .OR.
     1                    (IDS < 10000 .AND. JDS == 10000) .OR.
     2                    (IDS == 10000 .AND. JDS < 10000)) THEN
                        IF (J <= JUNK .AND. NR2 <= NR1) THEN
C * CHECK PRINT LEVEL
                          IF (IGBL(63) > 2) THEN
                            ISSU = MIN (999, ISSU)
                            FORMX(14:14) = CHAR (ICHAR ('0') + NDEC)
                            FORMX(45:45) = CHAR (ICHAR ('0') + NSVI)
                            FORMX(64:64) = CHAR (ICHAR ('0') + NSVJ)
                            FORMX(83:83) = CHAR (ICHAR ('0') + NDIJ)
                            WRITE (PRBUF, FORMX, IOSTAT = IOST)
     1                        NQ1(1:7), NQ2(1:7), S, ISSU, SC, DY, VI,
     2                        ISVI, VJ, ISVJ, DIJ, IDIJ, XMRK, SDIJ,
     3                        ANGL
                            CALL PLA263 (LU7, PRBUF, 132, 1, 3)
                          END IF
                          IF (IDIJ /= 0) THEN
                            IF (THIRSH > PAR(421))
     1                        WRITE (LU6, 99991, IOSTAT = IOST)
     2                        NQ1, NQ2, THIRSH
                            IF (THIRSH > 2.0 .AND. DIJ > 0.001)
     1                        THEN
                              CALL GEN048 (-1, IFG(1, J), 19, IVALJ)
                              NAD = NADD + 2 * MAX (IVALI, IVALJ)
C * ALERT _234
                              IF (THIRSH <= 5.0) THEN
                                CALL PLA236 (234, 2, SDIJ, SDIJ, NQ1,
     1                             NQ2)
                              ELSE
C * ALERT _23x : Hirshfeld
                                THIRSH0 = THIRSH
C * HANDLE LONG BONDS
                                IF (NR2 == 8) THEN
C * HANDLE LARGE ZN-O 'BOND DISTANCES
                                  IF (NR1 == 30) THEN
                                    DISTMAX = 2.3
                                  ELSE IF (NR1 > 36) THEN
                                    DISTMAX = 2.6
                                  ELSE
                                    DISTMAX = 10.0
                                  ENDIF
                                  IF (S > DISTMAX) THIRSH0 = -999.0
                                END IF
C * CHECK FOR DISORDER BOND
                                IF (IDS < 10000 .OR. JDS < 10000)
     1                            THIRSH0 = -999.0
C * CHECK FOR sp1 ATOMS
                                IF (IHYB == 1 .OR. JHYB == 1)
     1                            THIRSH0 = -999.0
C * NO METAL - HALOGEN A,B,C ALERTS -> G-ALERT
                                IF ((IATPRI > 0 .AND. IATPRJ == -7)
     1                            .OR.
     2                             (IATPRI == -7 .AND. IATPRJ > 0))
     3                            THIRSH0 = -999.0
C * NO SI - HALOGEN A,B,C ALERTS -> G-ALERT
                                IF ((NR1 == 14 .AND. IATPRJ == -7)
     1                            .OR.
     2                             (IATPRI == -7 .AND. NR2 == 14))
     3                            THIRSH0 = -999.0
C * HIGH RESOLUTION CASE
                                IF (NAD /= 0) THEN
C * TEST SINTH/Lambda-max value
                                  IF ((PAR(287) > 0.65 .AND.
     1                                 THIRSH <= 15.0) .OR.
     2                                (PAR(287) > 0.6 .AND.
     3                                 THIRSH < 10.0) .OR.
     4                                 (PAR(173) < 2.0 .AND.
     5                                  PAR(168) > 27.45))
     6                                   THIRSH0 = -999.0
                                END IF
                                CALL PLA236 (230 + NAD, 1, THIRSH0,
     1                            THIRSH, NQ1, NQ2)
                              END IF
                            END IF
                          END IF
                        END IF
                      END IF
                    END IF
                  END IF
                END IF
              END IF
            END DO
          END IF
        END DO
        IF (NRB > 0) DELIJ = SQRT (DELIJ / NRB)
        IF (IGBL(63) > 2) THEN
          CALL PLA262 (5)
          WRITE (LU7, 99992, IOSTAT = IOST) DELIJ, PAR(421)
        END IF
C * SETUP NON-BONDING 'RIGID-BOND' TEST MATRIX
        IF (NATR <= 40) THEN
          IF (IGBL(63) > 2) THEN
            CALL PLA262 (0)
            CALL PLA262 (5)
            WRITE (LU7, 99999, IOSTAT = IOST) (J, J = 1, NATR)
            WRITE (LU7, 99998, IOSTAT = IOST)
          END IF
          N0 = 0
          DO I = 1, NMAX
            IF (IATP(I) <= NP1) THEN
              CALL PLA047 (LABA(I), NQ1, IDUM, IENI, IPR(71),
     1          IGBL(55), 0, 0)
              RVLI = REL(IENI)
              N0 = N0 + 1
              N  = 0
              DO J = 1, NMAX
                IF (IATP(J) <= NP1) THEN
                  CALL GEN048 (-4, IFG(1, J), 15, IVLJ)
                  DMAX = RVLI + REL(IEN(IVLJ + 1)) + PAR(2)
                  S = 0
                  V = 0
                  IF (I /= J) THEN
                    DO K = 1, 3
                      V7(K) = XXO(I, K) - XXO(J, K)
                      S     = S + V7(K)**2
                    END DO
                    S = SQRT (S)
                    V = S
                    IF (I < J .AND. S > 0.001) THEN
                      DO K = 1, 3
                        V7(K) = V7(K) / S
                      END DO
                      V = 0
                      DO K = 1, 3
                        DO L = 1, 3
                          M = K * L
                          IF (M == 6) M = 5
                          IF (M == 9) M = 6
                          V = V + V7(K) * SUAN(I, M) * V7(L)
     1                    - V7(K) * SUAN(J, M) * V7(L)
                        END DO
                      END DO
                      V = V * 1000.0
                    END IF
                  END IF
                  N = N + 1
                  IATC(N) = MIN (99, NINT (ABS (V)))
                  IF (S < DMAX) IATC(N) = -IATC(N)
                END IF
              END DO
              IF (IGBL(63) > 2) THEN
                CALL PLA262 (1)
                WRITE (LU7, 99997, IOSTAT = IOST)
     1            N0, NQ1(1:6), (IATC(K), K = 1, N)
              END IF
            END IF
          END DO
          IF (IGBL(63) > 2) THEN
            CALL PLA262(8)
            WRITE (LU7, 99996, IOSTAT = IOST)
          END IF
        END IF
      END IF
      RETURN
99999 FORMAT ('Test Matrix for Rigid-Body Vibrations - /Del(A,B)/ = ',
     1 '/Z(A,B)**2 - Z(B,A)**2/ Should be Near Zero (Acta Cryst. A34,',
     2 ' 1978, 828)', /, 132('='), //, 'Atom-Atom   ', 40I3)
99998 FORMAT (132('-'))
99997 FORMAT (I2, 1X, A, ' - ', 40I3)
99996 FORMAT (/, 'Remarks', /, 7('-'), /, '- Upper Triangle Entries ',
     1 'Represent /Del(A,B)/*1000 Values'//'- Lower Triangle Entries ',
     2 'Represent Distances (A-B) Angstrom'//'- Negative Entries ',
     3 'Indicate Bonded Atoms')
99995 FORMAT ('Rigid-Body Model Libration Corrections for Bond',
     1 ' Distances and "Hirshfeld Rigid-Bond" Test (Acta Cryst., 1976,',
     2 ' A32, 239-244)', /, 132('=')/)
99994 FORMAT (75X, 'MSDA from U(obs)', /, 5X, 'Bond', 11X,
     1 'Bond Distance   Components of the Correction  Vibration Along',
     2 ' the Interatomic Bond', 8X, 'Angle with Lib. Axes', //,
     3 'Atom(I)  Atom(J)', 7X, 'Obsd', 6X, 'Calcd', 2X,
     4 'Del(L)  Del(M)  Del(N)', 4X, 'I to J', 6X,  'J to I', 4X,
     5 'Difference', 2X, 'Sqrt(Diff)    L(1)   L(2)   L(3)', /,
     6  132('-'))
99993 FORMAT (/,
     1 ':: No TLS-Analysis for Polymeric or Disordered Structures')
99992 FORMAT (/, 59X , 'Sqrt(Sum(DelIJ**2)/Nrb) = ', F10.4, //,
     1 30X, '# - Indicates bonds exceeding the', F4.1,
     2 ' sigma test level')
99991 FORMAT (':: ', A, '-', A, 'fails Hirshfeld Rigid Bond test at',
     1 F6.2, ' sigma level')
99990 FORMAT (/, ':: No TLS-Analysis for Residue Nr:', I3,
     1 ', Because R >', F6.2)
      END SUBROUTINE PLA029
 
      SUBROUTINE PLA030 (LABA, XXO, CON, NT, IFG, IPPR, BOND)
C * DETERMINE R/S CHIRALITY FOR FOUR COORDINATED ATOMS.
C * THE HYBRIDISATION OF THE ATOMS AND THE BOND ORDER ARE DETERMINED
C * AUTOMATICALLY FROM THE SUPPLIED GEOMETRY PARAMETERS
C *
C * THIS ROUTINE IS INSPIRED BY, BUT DEVIATES SIGNIFICANTLY FROM, THE CODE
C * OF THE PROGRAM 'CHIRAL' BY J.G.VINTER, A.DAVIS & P.M. WILLIAMS
C * VERSION 06-06-2024
      USE files
      USE parameters
      USE atomdata
      USE cggt
      IMPLICIT NONE
      INTEGER, PARAMETER :: NP1  = 20000
      INTEGER, PARAMETER :: MP7  = 256
      INTEGER :: I
      INTEGER :: J
      INTEGER :: K
      INTEGER :: L
      INTEGER :: N
      INTEGER :: KP
      INTEGER :: NC
      INTEGER :: NO1
      INTEGER :: MSD       ! Maximum Search Depth (def 6)
      INTEGER :: LCH       ! Chain Length
      INTEGER :: NAT
      INTEGER :: NBD       ! Number of Bonds
      INTEGER :: NPK
      INTEGER :: ILO
      INTEGER :: IHP
      INTEGER :: NHP
      INTEGER :: IHI
      INTEGER :: IHYA
      INTEGER :: IHYB
      INTEGER :: IDUM
      INTEGER :: JDUM
      INTEGER :: NANG
      INTEGER :: NATO
      INTEGER :: NOIP
      INTEGER :: NOIQ
      INTEGER :: ISHL
      INTEGER :: IPQ1
      INTEGER :: IPQ2
      INTEGER :: IMET
      INTEGER :: IHINP
      INTEGER :: IPNTR
      INTEGER :: ISAME
      INTEGER :: JSAME
      INTEGER :: NSAME
      INTEGER :: NCMAX = 4
      INTEGER :: NOIPX
      INTEGER :: NOIQX
      INTEGER :: KCENT     ! Serial # of Chiral? Atom
      INTEGER :: ITMP1
      INTEGER :: ITMP2
      INTEGER :: IBNDO
      INTEGER :: ISHLS
      INTEGER :: NFOUND
      INTEGER :: MAXPAD
      INTEGER :: NRCHAIN
      INTEGER :: ICHIRAL
      INTEGER :: ILOWEST
      INTEGER :: ISMPNTR
      INTEGER :: IPADMIN
      INTEGER :: IPADNUM
      INTEGER :: IPADNUMX
      INTEGER :: IHIGHEST
      INTEGER, DIMENSION(NP1)    :: NT        ! Relative Weight of Atoms
      INTEGER, DIMENSION(100)    :: JR
      INTEGER, DIMENSION(4)      :: IRP
      INTEGER, DIMENSION(4)      :: IPS
      INTEGER, DIMENSION(9)      :: JRS
      INTEGER, DIMENSION(3, NP1) :: IFG
      INTEGER, DIMENSION(NP10)   :: ITC
      INTEGER, DIMENSION(100)    :: JLN
      INTEGER, DIMENSION(100)    :: NCN
      INTEGER, DIMENSION(NP1)    :: LABA
      INTEGER, DIMENSION(MP7, 3) :: IPPR
      INTEGER, DIMENSION(4)      :: IFTM
      INTEGER, DIMENSION(4)      :: ITMPL
      INTEGER, DIMENSION(5)      :: ISMLST
      INTEGER, DIMENSION(4)      :: IPRIOR
      INTEGER, DIMENSION(4)      :: INPRIOR
      INTEGER, DIMENSION(4)      :: IWPRIOR
      INTEGER, DIMENSION(4)      :: ISHLPRI
      INTEGER, DIMENSION(4)      :: IPATHFOUND
      REAL :: D
      REAL :: DUM1
      REAL :: DUM2
      REAL :: DUM3
      REAL :: DIST
      REAL :: GEN009
      REAL, DIMENSION(3)      :: V1
      REAL, DIMENSION(3)      :: V2
      REAL, DIMENSION(3)      :: V3
      REAL, DIMENSION(3)      :: V4
      REAL, DIMENSION(3)      :: V5
      REAL, DIMENSION(3)      :: V6
      REAL, DIMENSION(3)      :: V7
      REAL, DIMENSION(*)      :: BOND
      REAL, DIMENSION(NP10)   :: DTC
      REAL, DIMENSION(NP1, 6) :: XXO
      REAL, DIMENSION(NP1, 9) :: CON
      CHARACTER(len=1) :: NOTE1
      INTEGER,          ALLOCATABLE, DIMENSION(:) :: NCHAIN
      INTEGER,          ALLOCATABLE, DIMENSION(:) :: NWGT
      CHARACTER(len=6), ALLOCATABLE, DIMENSION(:) :: NQY
      ALLOCATE (NCHAIN(NP67), NWGT(NP1), NQY(NP1))
C * GET NUMBER OF ATOMS IN EXPANDED ATOM LIST
      NAT = IPR(39)
C * COUNTER OF ATOMS INCLUDING PSEUDO ATOMS ADDED BELOW
      NATO = IPR(39)
C * GET NUMBER OF BONDS
      NBD = IPR(131)
C * NCMAX = UP TO NCMAX 'CONNECTIONS' FOR R/S
      NCMAX = 4
C * MSD = MAX SEARCH DEPTH
      MSD = IPR(492)
C * REPORT MAXIMUM SEARCH DEPTH
      IF (IPR(777) == 1) WRITE (LU6, 99988) MSD
C * SAVE XXO, XSD & CON FOR LATER RECOVERY - ARRAYS USED FOR SCRATCH
      CALL PLA269 (1, NAT)
C * GET THE RELATIVE WEIGHTS FOR ORDERING ATOM TYPES ON ATOMIC WEIGHT
      DO I = 1, IAN
        DTC(I) = ATWT(IEN(I))
        ITC(I) = I
      END DO
C * SORT ON ATOMIC WEIGHT (DTC: SMALL TO LARGE)
      CALL GEN036 (DTC, ITC, 1, IAN)
C * LIST ATOM TYPE RELATIVE WEIGHT ENCODING
      IF (IPR(777) == 1) THEN
        WRITE (LU6, 99985)
        DO I = 1, IAN
          WRITE(LU6, 99984) ELB(IEN(ITC(I))), I, DTC(I)
        END DO
C * LIST ATOM SITE WEIGHT ENCODING SCHEME
        WRITE (LU6, 99983)
      END IF
      DO I = 1, IAN
        DTC(I) = ITC(I)
        ITC(I) = I
      END DO
      CALL GEN036 (DTC, ITC, 1, IAN)
C * KEEP MAJOR DISORDER FORM ONLY FOR R/S - ANALYSIS
C * (I.E. POP > 5000 /10000) ELIMINATE MINOR DISORDER FORM
      DO I = 1, NAT
        NC = - NINT (CON(I, 9))
        IF (NC > 0 .AND. NC < 9) THEN
          L = 0
          DO J = 1, NC
            K = NINT (CON(I, J))
C * GET POPULATION PARAMETER
            CALL GEN048 (-8, IFG(2, K), 1, KP)
            KP = IPPR(KP + 1, 1)
            IF (KP > 5000) THEN
              L = L + 1
              CON(I, L) = CON(I, J)
            END IF
          END DO
          NC = L
          CON(I, 9) = - NC
C * ZERO CON(I, J) ENTRIES BETWEEN NC & 9
          IF (NC < 8) THEN
            DO J = NC + 1, 8
              CON(I, J) = 0.0
            END DO
          END IF
        END IF
C * DETERMINE HYBRIDYSATION FOR MAJOR DISORDER FORM
        CALL PLA099 (0, I, NANG, DUM1, DUM2, DUM3, NOTE1)
C * GET RELATIVE WEIGHT FOR ATOM I
        CALL GEN048 (-4, IFG(1, I), 15, IDUM)
C * REGISTER RELATIVE ATOMWEIGHT (1 = lowest)
        NT(I) = ITC(IDUM + 1)
      END DO
C * LOAD BONDS FROM SCRATCH AND ADD DUMMY ATOMS AND CONNECTIONS
C * TO MOLECULE ACCORDING TO BOND ORDER.
C *
C *          |    |                     |    |
C * E.G.   - C == C -     ------>     - C -- C -
C *                                     |    |
C *         IPQ1 IPQ2                   C    C
      N = 0
C * ADD BLANC LINE
      IF (IPR(777) == 1) WRITE (LU6, 99997)
C * LOOP OVER BOND-TYPES
      DO K = 1, 4
C * CARBON-CARBON BONDS
        IF (K == 1) THEN
          NOIPX = 2
          NOIQX = 2
C * OXYGEN CARBON BOND
        ELSE IF (K == 2) THEN
          NOIPX = 3
          NOIQX = 2
C * NITROGEN CARBON BOND
        ELSE IF (K == 3) THEN
          NOIPX = 4
          NOIQX = 2
C * NITROGEN-NITROGEN BOND
        ELSE IF (K == 4) THEN
          NOIPX = 4
          NOIQX = 4
        END IF
        DO I = 1, NBD
          IPQ1 = NINT (BOND(I * 3 - 2))
          IPQ2 = NINT (BOND(I * 3 - 1))
C * GET ELEMENT TYPE OF BONDED ATOMS
          CALL GEN048 (-4, IFG(1, IPQ1), 15, NOIP)
          CALL GEN048 (-4, IFG(1, IPQ2), 15, NOIQ)
          NOIP = IEN(NOIP + 1)
          NOIQ = IEN(NOIQ + 1)
C * GET ATOM LABELS FOR THIS BOND
          IF (NOIP == NOIPX .AND. NOIQ == NOIQX) THEN
            CALL PLA047 (LABA(IPQ1), NQ1, IDUM, JDUM, IPR(71),
     1        IGBL(55), 0, 0)
            CALL PLA047 (LABA(IPQ2), NQ2, IDUM, JDUM, IPR(71),
     1        IGBL(55), 0, 0)
C * GET DISTANCE OF BONDED ATOMS
            CALL PLA050 (IPQ1, IPQ2, 0, 0, DIST)
C * GET HYBRIDISATION OF BONDED ATOMS
            CALL GEN048 (-4, IFG(1, IPQ1), 24, IHYA)
            CALL GEN048 (-4, IFG(1, IPQ2), 24, IHYB)
C * TRIPLE BOND
            IF (IHYA == 1 .AND. IHYB == 1) THEN
              IBNDO = 3
C * SP2-SP
            ELSE IF (IHYA * IHYB == 2) THEN
              IBNDO = 2
C * SP2-SP2
            ELSE IF (IHYA == 2 .AND. IHYB == 2) THEN
              IBNDO = 2
C * CHECK C-C BOND DISTANCE
              IF (NOIP == 2 .AND. NOIQ == 2) THEN
                IF (DIST > PAR(384)) IBNDO = 1
C * CHECK N-C BOND DISTANCE
              ELSE IF (NOIP == 4 .AND. NOIQ == 2) THEN
                IF (DIST > 1.35) IBNDO = 1
              END IF
            ELSE
              IBNDO = 1
            END IF
            IF (IBNDO > 1) THEN
              DO J = 2, IBNDO
                ITMP1 = - NINT (CON(IPQ1, 9)) + 1
                ITMP2 = - NINT (CON(IPQ2, 9)) + 1
                IF (ITMP1 <= 4 .AND. ITMP2 <= 4) THEN
                  NATO             = NATO + 1
                  DO L = 1, 8
                    CON(NATO, L) = 0.0
                  END DO
C * ADD ATOM TYPES
                  NT(NATO)         = NT(IPQ2)
                  CON(NATO, 1)     = IPQ1
                  CON(NATO, 9)     = - 1
                  CON(IPQ1, ITMP1) = NATO
                  CON(IPQ1, 9)     = - ITMP1
                  LABA(NATO)       = LABA(IPQ2)
                  NATO             = NATO + 1
C * ADD ATOM TYPES
                  NT(NATO)         = NT(IPQ1)
                  CON(NATO, 1)     = IPQ2
                  CON(NATO, 9)     = - 1
                  CON(IPQ2, ITMP2) = NATO
                  CON(IPQ2, 9)     = - ITMP2
                  LABA(NATO)       = LABA(IPQ1)
C * REPORT ADDED PSEUDO-BOND FOR DOUBLE & TRIPLE BONDS
                  IF (IPR(777) == 1) THEN
                    WRITE (LU6, 99998) NQ1(1:7), NQ2(1:7)
                    N = N + 1
                  END IF
                END IF
              END DO
            END IF
          END IF
        END DO
      END DO
C * ADD BLANC LINE
      IF (N > 0) WRITE (LU6, 99997)
C * GET ATOM NODE WEIGHTS
      DO I = 1, NATO
        NC = - NINT (CON(I, 9))
        IF (NC < 0 ) NC = 9
        NC = MIN (NC, NCMAX)
C * GET PRIORITIES OF BONDED ATOMS
        DO J = 1, NC
          JRS(J) = NT(NINT (CON(I, J)))
        END DO
C * SORT BONDED ATOMS ON THEIR RELATIVE WEIGHT (LARGE TO SMALL)
        CALL GEN022 (JRS, 1, NC, -1)
C * INIT WEIGHT ON RELATIVE WEIGHT OF THE CENTRAL ATOM
        NWGT(I) = NT(I) * 10 ** NCMAX
C * PACK RELATIVE PRIORITIES OF UP TO 4 BONDED ATOMS INTO A SINGLE NUMBER
        DO J = 1, NC
          NWGT(I) = NWGT(I) + JRS(J) * 10 ** (NCMAX - J)
        END DO
        CALL PLA047 (LABA(I), NQ1, IDUM, JDUM, IPR(71), IGBL(55), 0, 0)
        NQY(I) = ' '//NQ1(1:5)
        IF (I > NAT) NQY(I)(1:1) = '*'
      END DO
C * LIST ATOM NODE WEIGHTS
      IF (IPR(777) == 1) THEN
        WRITE (LU6, 99989)
        J = 0
        L = 5
        DO
          WRITE (LU6, 99990) (J + I, NQY(J + I), NWGT(J + I), I = 1, L)
          J = J + 5
          IF (J + 5 > NATO) THEN
            L = NATO - J
            IF (L < 1) EXIT
          END IF
        END DO
      END IF
C * FIND CHIRALITY OF ALL FOUR-COORDINATED ATOMS.
C * KCENT IS THE ATOM WHOS CHIRALITY IS TO BE TESTED
C * MARK ATOMS FOR R/S CANDIDATES
C * ORDER BONDS AROUND ATOM I ON PRIORITY AND SELECT POTENTIAL CHIRAL ATOMS
      DO I = 1, NAT
C * PRESET FOR ACHIRAL
        ICHIRAL = 0
C * GET HYBRIDIZATION
        CALL GEN048 (-4, IFG(1, I), 24, IHYA)
C * TEST FOR METAL
        CALL GEN048 (-1, IFG(1, I), 19, IMET)
C * TEST FOR P & S
        CALL GEN048 (-4, IFG(1, I), 15, NO1)
        NO1 = IEN(NO1 + 1)
C * CONSIDER C, N, Si ONLY
        NC  = - NINT (CON(I, 9))
        IF (NC == 4 .AND. IMET == 0 .AND. IHYA == 3 .and.
     1    NO1 /= 6 .AND. NO1 /= 8) THEN
          N = 0
          DO J = 1, 4
            K = NINT (CON(I, J))
C * CHECK FOR H-ATOM
            CALL GEN048 (-1, IFG(1, K), 7, L)
            N = N + L
          END DO
          IF (N < 2) ICHIRAL = 2
        END IF
        CALL GEN048 (2, IFG(1, I), 28, ICHIRAL)
      END DO
 
      IF (IPR(777) == 1) WRITE (LU6, 99993) MSD
C * MAIN LOOP OVER POTENTIALLY 'CHIRAL' ATOMS
      DO 70 KCENT = 1, NAT
        CALL GEN048 (-2, IFG(1, KCENT), 28, ICHIRAL)
        IF (ICHIRAL == 2) THEN
          CALL PLA047 (LABA(KCENT), NQ1, IDUM, JDUM,
     1      IPR(71), IGBL(55), 0, 0)
 
C * ASSIGN INITIAL PRIORITIES TO THE DIRECTLY CONNECTED ATOMS
          DO I = 1, 4
            J          = NINT (CON(KCENT, I))
            INPRIOR(I) = J
            IWPRIOR(I) = NWGT(J)
          END DO
C * SORT PRIORITIES (LOW TO HIGH WEIGHT) AND FIND THOSE THAT ARE SAME
C * IWPRIOR = 1,2,3,or 4; INPRIOR = SEQUENCE NUMBER IN ATOM LIST
          CALL GEN033 (IWPRIOR, INPRIOR, 1, 4)
          IF (IPR(777) == 1) WRITE (LU6, 99994) NQY(KCENT),
     1      (I, INPRIOR(I), NQY(INPRIOR(I)), NWGT(INPRIOR(I)), I = 1, 4)
C * DECIDE ORDER FOR ATOMS WITH SAME PRIORITY
C * ISMLST REGISTERS NSAME ATOM LIST SEQUENCE NUMBERS
 
C * ZERO ARRAY
          CALL GEN097 (ISMLST, 1, 5, 0)
          ISMPNTR = 1
          ISHLS   = 1
C * MAIN PRIORITY LOOP FOR THIS POTENTIALLY CHIRAL ATOM
C * FIND SAME PRIORITIES CASES IN PRIORITY LIST
          DO
            NSAME     = 1
            ISMLST(1) = INPRIOR(ISMPNTR)
            IF (ISMPNTR < 4) THEN
              DO I = 1, 4 - ISMPNTR
                IF (IWPRIOR(ISMPNTR + I) /= IWPRIOR(ISMPNTR)) EXIT
                ISMLST(I + 1) = INPRIOR(ISMPNTR + I)
                NSAME         = NSAME + 1
              END DO
            END IF
            IF (NSAME > 1) THEN
C * REPORT SAME LIST ATOM LABELS
              IF (IPR(777) == 1)
     1          WRITE (LU6, 99996) (NQY(ISMLST(I)), I = 1, NSAME)
C * SET THE PACKING SIZE, NPK, IN THE LINEAR NCHAIN ARRAY, FOR THE SET OF
C *   CHAINS TO BE COMPARED FOR PRECEDENCE.
C * MSD = MAXIMUM CHAIN DEPTH, NSAME = NUMBER OF CHAINS TO BE COMPARED
              NPK    = (MSD + 1) * NSAME
              MAXPAD = NP67 / NPK
              CALL GEN097 (NCHAIN, 1, NP67, 0)
C * EACH PATH IS STORED SEQUENTIALLY IN A BLOCK OF (MSD + 1) * NSAME ENTRIES
C *   REFERENCES TO ATOMS IN THE ATOM LIST. MSD = Maximum Search Depth
C * AN ADDITIONAL BLOCK OF LENGTH NSAME STORES THE CHAIN LENGTH (EXCLUDING
C * BLOCKS CONTAINS UP TO 4 REFERENCES TO BE COMPARED.
C * |path1|path2|path3|....|pathK|                 K = Number of path's
C *    I                                               for NSAME ATOM
C *    V
C * |shell1|shell2|shell3|....|shell-msd|L|        msd = Max Search Depths
C *    I                              I
C *    V                              V
C * |atom1|..|atom-nsame|     |l1|..|l-nsame|      lN = ChainLength
C * ASSIGN PRIORITIES TO ATOMS OF SIMILAR PRIORITY USING PATHS
C * FROM THESE ATOMS AS PER IUPAC CHIRAL RULES.
C * FIND ALL PATHS FROM ATOMS IN ISMLST.
C * THIS IS THE SLOW BIT AS ALL PATHS MUST BE FOUND FIRST SO THAT
C * THEY CAN BE ORDERED AND TRAVERSED IN DESCENDING ORDER OR PRIORITY.
C * ZERO ARRAY
              IPADMIN = 99
C * BEGIN ISAME LOOP
              DO ISAME = 1, NSAME
                IHINP = 0
C * MARK OUTGOING AND CLOSING BONDS IN TETRAEDER AS TRAVERSED
C * INCLUDE BASE-ATOM
                ISMLST(NSAME + 1) = KCENT
                IPRIOR(ISAME)     = 0
C * SEQUENCE NUMBER OF PATH
                IPADNUM           = 0
                JR(1)             = KCENT
                JR(2)             = ISMLST(ISAME)
                LCH               = 1
                DO
                  LCH = LCH + 1
C * LCH = CHAIN LENGTH, MSD = MAX SEARCH DEPTH/CHAIN LENGTH (IPR(492)
                  IF (LCH <= MSD) THEN
C * HANDLE CLOSURE
                    IF (LCH > 3) THEN
                      DO K = LCH - 3, 1, -1
                          IF (JR(LCH) == JR(K)) GO TO 10
                      END DO
                    END IF
                    NC = - NINT (CON(JR(LCH), 9))
                    IF (NC < 0) NC = 9
C * CHECK FOR/HANDLE TERMINAL H-ATOM
                    IF (NC /= 1) THEN
                      NCN(LCH) = NC
                      JLN(LCH) = 0
                      GO TO 20
                    END IF
                  END IF
C * END-OF-CHAIN REACHED COPY/STORE THIS CHAIN (JR)
   10             DO I = 2, LCH
                    NCHAIN(IPADNUM * NPK + (I - 2) * NSAME + ISAME) =
     1                JR(I)
                  END DO
C * STORE PATH-LENGTH
                  LCH = LCH - 1
                  NCHAIN(IPADNUM * NPK + MSD * NSAME + ISAME) = LCH
                  IPADNUM = IPADNUM + 1
C * NO NEXT ATOM FOUND - START A NEW PATH. FIND LAST BRANCH POINT IN
C * LAST PATH WHERE THE NEW PATH CAN DIVERT FROM.
C * REGISTER GLOBAL MAXIMUM PATH_LENGTH
                  IHINP = MAX (IHINP, LCH)
                  IF (IPADNUM == MAXPAD) THEN
                    IPR(126) = IPR(126) + 1
                    WRITE (LU6, 99999, IOSTAT = IOST) MAXPAD
                    ISMLST(1) = -1
                    GO TO 60
                  END IF
C * RETRACE
   20             IF (LCH <= 1) EXIT
                  JLN(LCH) = JLN(LCH) + 1
                  IF (JLN(LCH) > NCN(LCH)) THEN
                    LCH = LCH - 1
                    GO TO 20
                  END IF
                  JR(LCH + 1) = NINT (CON(JR(LCH), JLN(LCH)))
C * AVOID BACK-LOOP
                  IF (JR(LCH + 1) == JR(LCH - 1)) GO TO 20
                  IF (LCH <= 0) EXIT
                END DO
C * NO MORE PATHS FROM THIS START ATOM. FIND LENGTH OF LONGEST
C * PATH AND SORT PATHS INTO DECREASING ORDER OR PRIORITY.
C * ORDER ATOM SHELLS IN REVERSE DIRECTION.
                IPADMIN  = MIN (IPADMIN, IPADNUM)
                IPADNUMX = IPADNUM
C * BEGIN ISHL LOOP
                DO ISHL = IHINP, 2, -1
C * SORT ONE SHELL
                  CALL PLA031 (NQY, IPADNUMX, NWGT, NPK, ISAME, IHINP,
     1              NSAME, MSD, IPADNUM, ISHL, NCHAIN, JR, ISMLST)
                END DO
C * END ISHL LOOP
              END DO
C * END ISAME LOOP
C * NOW THAT WE HAVE FOUND ALL THE PATHS FROM THE NSAME ATOMS, LET'S START
C * GOING OUT THROUGH THE PATHS IN PRIORITY ORDER UNTIL WE FIND A DIFFERENCE ..
C * AND HENCE ASSIGN PRIORITY.
C * BEGIN NRCHAIN LOOP
              DO NRCHAIN = -1, IPADMIN - 2
C * ZERO ARRAY IPATHFOUND & IPS
                CALL GEN097 (IPATHFOUND, 1, NSAME, 0)
                CALL GEN097 (IPS,        1, NSAME, 0)
                CALL GEN097 (IPRIOR,     1, NSAME, 0)
C * FIND MAXIMUM LENGTH OF PATH FOR THE NSAME PRIORITIES
                IHP = 0
C * BEGIN ISAME LOOP
                DO ISAME = 1, NSAME
                  IPS(ISAME) = IPS(ISAME) + 1
                  NHP = NCHAIN((IPS(ISAME) + NRCHAIN) * NPK
     1                + MSD * NSAME + ISAME)
                  IHP = MAX (IHP, NHP)
                END DO
C * END ISAME LOOP
C * EXIT FOR THIS ATOM WHEN MAX CHAINLENGTH LESS 2
                IF (IHP < 2) GO TO 70
C * LOOP OVER SHELLS OUTWARDS TO MAX LENGTH
                DO ISHL = 2, IHP
                  ISHLS = ISHL
C * DETERMINE MAXIMUM NUMBER OF CONNECTIONS
   30             NCMAX = 0
C * BEGIN ISAME LOOP
                  DO ISAME = 1, NSAME
                    IPNTR = NCHAIN((IPS(ISAME) + NRCHAIN) * NPK
     1                    + (ISHL - 1) * NSAME + ISAME)
C * GET/SAVE POINTER TO ATOM
                    IRP(ISAME) = IPNTR
                    IF (ISAME == NSAME) THEN
                      IF (IPR(777) == 1) WRITE (LU6, 99986) NRCHAIN + 2,
     1                ISHL, (NQY(IRP(I)), NWGT(IRP(I)), I = 1, NSAME)
                      IF (IRP(2) == IRP(1)) THEN
                        IF (IRP(1) <= 0) GO TO 60
                        CALL PLA047 (LABA(IRP(1)), NQ1, IDUM, JDUM,
     1                    IPR(71),IGBL(55), 0, 0)
C * Closure Message
                        IF (IPR(777) == 1) WRITE (LU6, 99995) NQ1
                        GO TO 45
                        DO I = 1, NSAME
                          DO
                            IPS(I) = IPS(I) + 1
                            N = NCHAIN(IPS(I) * NPK + (ISHL - 1)
     1                        * NSAME + I)
                            IF (N == 0) GO TO 70
                            IF (N /= IRP(1)) EXIT
                          END DO
                        END DO
                        GOTO 30
                      ELSE
                        IF (IRP(1) <= 0) THEN
                          IF (IPR(777) == 1)
     1                      WRITE (LU6,'(''Problem 2'')')
                          GO TO 60
                        END IF
                        CALL PLA047 (LABA(IRP(1)), NQ1, IDUM, JDUM,
     1                    IPR(71),IGBL(55), 0, 0)
                        IF (IRP(2) <= 0) THEN
                          IF (IPR(777) == 1)
     1                      WRITE (LU6,'(''Problem 3'')')
                          GO TO 60
                        END IF
                        CALL PLA047 (LABA(IRP(2)), NQ2, IDUM, JDUM,
     1                    IPR(71),IGBL(55), 0, 0)
                      END IF
                    END IF
                    IF (IPNTR > 0) THEN
                      IF (NINT (CON(IPNTR, 9)) < - NCMAX) THEN
                        NCMAX = - NINT (CON(IPNTR, 9))
C * ESCAPE TO ? ASSIGNMENT
                        IF (NCMAX > 4) THEN
                          IF (IPR(777) == 1)
     1                      WRITE (LU6, 99982) NQY(IPNTR)
                          GO TO 60
                        END IF
                      END IF
                    END IF
                  END DO
C * END OF ISAME LOOP
                  DO ISAME = 1, NSAME
                    IF (IPATHFOUND(ISAME) == 0) THEN
                      ISHLPRI(ISAME) = 0
                      IPNTR = NCHAIN((IPS(ISAME) + NRCHAIN) * NPK
     1                      + (ISHL - 1) * NSAME + ISAME)
                      IF (IPNTR > 0) ISHLPRI(ISAME) = NWGT(IPNTR)
                    END IF
                  END DO
C * END ISAME LOOP
C * FIND WHICH ATOMS IN THE PATHS AT THE CURRENT SHELL LEVEL HAVE
C * A UNIQUE PRIORITY AND FLAG THEM.
                  NFOUND = 0
C * BEGIN ISAME LOOP
                  DO 40 ISAME = 1, NSAME
                    IF (IPATHFOUND(ISAME) == 1) THEN
                      NFOUND = NFOUND + 1
                    ELSE
C * BEGIN JSAME LOOP
                      DO JSAME = 1, NSAME
                        IF (ISAME /= JSAME) THEN
                          IF (ISHLPRI(ISAME) == ISHLPRI(JSAME)
     1                      .AND. IPATHFOUND(JSAME) == 0) GO TO 40
                        END IF
                      END DO
C * END JSAME LOOP
                      IPATHFOUND(ISAME) = 1
                      NFOUND            = NFOUND + 1
                      IFTM(ISAME)       = ISHL
                    END IF
   40             CONTINUE
C * END ISAME LOOP
C * INSERT UNIQUE PATHS IN PRIORITY LIST FOR CHIRAL ATOM.
C * BEGIN ISAME LOOP
                  DO ISAME = 1, NSAME
                    ILOWEST  = ISHLPRI(1) + 1
                    IHIGHEST = 0
                    IHI      = 1
                    ILO      = 1
C * BEGIN JSAME LOOP
                    DO JSAME = 1, NSAME
                      IF (ISHLPRI(JSAME) > IHIGHEST) THEN
                        IHI      = JSAME
                        IHIGHEST = ISHLPRI(JSAME)
                      END IF
                      IF (ISHLPRI(JSAME) < ILOWEST .AND.
     1                    ISHLPRI(JSAME) /= -1) THEN
                        ILO     = JSAME
                        ILOWEST = ISHLPRI(JSAME)
                      END IF
                    END DO
C * END JSAME LOOP
                    IF (IHIGHEST /= 0 .AND. IPATHFOUND(IHI) == 1 .AND.
     1                IFTM(IHI) == ISHL) THEN
C * BEGIN JSAME LOOP
                      DO JSAME = 1, NSAME
                        IF (IPRIOR(JSAME) == 0) THEN
                          IPRIOR(JSAME) = IHI
                          ISHLPRI(IHI)  = -1
                          EXIT
                        END IF
                      END DO
C * END  JSAME LOOP
                    END IF
                    IF (ILOWEST /= 0 .AND. IPATHFOUND(ILO) == 1 .AND.
     1                IFTM(ILO) == ISHL) THEN
C * BEGIN JSAME LOOP
                      DO JSAME = NSAME, 1, -1
                        IF (IPRIOR(JSAME) == 0) THEN
                          IPRIOR(JSAME) = ILO
                          ISHLPRI(ILO)  = - 1
                          EXIT
                        END IF
                      END DO
C * END JSAME LOOP
                    END IF
                  END DO
C * END ISAME LOOP
                  IF (IPR(777) == 1 .AND. NFOUND == NSAME)
     1              WRITE (LU6, 99987)
     2              NFOUND, (NQY(ISMLST(IPRIOR(I))), I = 1, NSAME)
C * HAVE WE ASSIGNED A PRIORITY TO ALL THE PATHS.
                  IF (NFOUND == NSAME) THEN
C * SORT ISMLST INTO PRIORITY ORDER AND RETURN.
                    DO ISAME = 1, NSAME
C * TEMP FIX FOR ILL UNDERSTOOD PROBLEM
                      IF (IPRIOR(ISAME) < 1 .OR. IPRIOR(ISAME) > 4) THEN
                        WRITE (LU6, '(''R/S DET PROBLEM'')')
                        GO TO 60
                      END IF
                      ITMPL(ISAME) = ISMLST(IPRIOR(ISAME))
                    END DO
                    DO ISAME = 1, NSAME
                      ISMLST(ISAME) = ITMPL(ISAME)
                    END DO
                    DO ISAME = 1, NSAME
                      IF (ISMLST(ISAME) < 0) GO TO 70
                    END DO
                    GO TO 50
                  END IF
C * NO, WE HAVEN'T, SO INCREASE SHELL AND DO AGAIN.
                END DO
C * END OF ISHL LOOP
C * IF WE GET HERE THEN TWO PATHS ARE IDENTICAL SO GO ON TO
C * NEXT SET OF PATHS FROM START ATOM.
   45           CONTINUE
              END DO
C * END OF NRCHAIN LOOP
C * NO DIFFERENCES FOUND IN ANY OF THE PATHS FROM TWO OR MORE ATOMS
C * SO RETURN NO CHIRALITY.
              IF (IPR(777) == 1) WRITE (LU6, 99992)
              GO TO 70
            END IF
C * ADD THE NEXT NSAME PRIORITY ENTRIES TO THE PRIORITY LIST
   50       DO I = 1, NSAME
              INPRIOR(ISMPNTR + I - 1) = ISMLST(NSAME    - I + 1)
              IWPRIOR(ISMPNTR + I - 1) = NT(ISMLST(NSAME - I + 1))
            END DO
            ISMPNTR = ISMPNTR + NSAME
            IF (ISMPNTR > 4) EXIT
          END DO
C * END MAIN POTENTIALLY CHIRAL ATOM LOOP
C * WE HAVE A CHIRAL CENTRE.  CLOCKWISE OR ANTI-CLOCKWISE ?
          DO I = 1, 3
            V1(I) = XXO(INPRIOR(4), I + 3)
            V2(I) = XXO(INPRIOR(3), I + 3)
            V3(I) = XXO(INPRIOR(2), I + 3)
            V4(I) = XXO(INPRIOR(1), I + 3)
          END DO
C * CALCULATE THE EQUATION OF THE PLANE PASSING THROUGH
C * THE THREE HIGHEST PRIORITY ATOMS DEFINE IN DECREASING ORDER.
          CALL GEN008 (V2, V3, V5, 0)
          D =  GEN009 (V1, V5)
          CALL GEN008 (V1, V2, V6, 0)
          CALL GEN015 (V5, V6, V7, 1.0)
          CALL GEN008 (V3, V1, V6, 0)
          CALL GEN015 (V6, V7, V5, 1.0)
C * V5 AND D DEFINE THE PLANE.  NOW CALCULATE THE DISTANCE OF THE FOURTH
C * (LOWEST PRIORITY) ATOM FROM THIS PLANE.
C * THE LENGTH, D,  OF THIS LINE IS IRRELEVANT, BUT, THE SIGN INDICATES
C * CHIRALITY.  - EQUALS S, + EQUALS R
          IF (GEN009 (V4, V5) < D) THEN
            ICHIRAL = 1
            NQ2     = 'S'
          ELSE
            ICHIRAL = 3
            NQ2     = 'R'
          END IF
          IF (IABS (2 - ICHIRAL) == 1) IPR(583) = IPR(583) + 1
C * LIST CHIRAL SEQUENCE
          IF (IPR(777) == 1) WRITE (LU6, 99991) ISHLS + 1, NQ2(1:1),
     1      NQY(KCENT), (NQY(INPRIOR(5 - J)), J = 1, 4)
        END IF
C * ICHIRAL 1 = S, 2 = ?, 3 = R
   60   CALL GEN048 (2, IFG(1, KCENT), 28, ICHIRAL)
   70 CONTINUE
C * ADD BLANC LINE
      IF (IPR(777) == 1) WRITE (LU6, 99997)
      DEALLOCATE (NCHAIN, NWGT, NQY)
C * GET LABUTE ATOM TOPOLOGY NUMBERS
      CALL PLA032 (NAT, NATO, NT, IFG, CON)
C * RECOVER XXO, XSD, CON FROM SCRATCH
      CALL PLA269 (-1, NAT)
C * SET RETURN VALUE WHEN IN R/S OPTION MODE
      IF (IPR(777) == 1) IGBL(1) = 4
      RETURN
99999 FORMAT (':: MAXPATH = ', I4, ' EXCEEDED')
99998 FORMAT (':: PSEUDO-BOND(S) AND ATOMS ADDED TO: ', A, '& ', A,
     1        'FOR R/S DETERMINATION')
99997 FORMAT (1X)
99996 FORMAT (/, 'SAME LIST: ', 4A)
99995 FORMAT (/, 'Closure on ', A, '(No RS)')
99994 FORMAT (/, 80('='), /,
     1        'SORTED (SMALL TO LARGE) INITIAL PRIORITY FOR ', A,
     2        /, 80('='), /, ' I PRIOR  LABEL WPRIOR', /,
     3        22('='), 4(/,I2, I6, 1X, A, I7), /, 80('='))
99993 FORMAT (/, 'Shell 1 to', I3, ' R/S Tests', /, 23('='))
99992 FORMAT (/, 'Insufficient Differences')
99991 FORMAT (/, 'Chiral Shell =', I2, ' - (', A,') ', A, ': ',
     1        3(A, ' >> '), A, /)
99990 FORMAT (5(I4, A, I5, ','))
99989 FORMAT ('Atom_Node_Weights (# in atom list, Label, Weight)')
99988 FORMAT (/, ':: R/S - Assignment - Maximum Search Depth =', I3,
     1        ' shells', //, '   *** Use Keyboard Instruction, CIP n,',
     2        ' for Search Depth up to n Shells ***')
99987 FORMAT (/, 'NFOUND =', I2, ', FINAL SAME LIST ORDER = ', 4A)
99986 FORMAT (/, 'Compare Chain(', I2, ') - Shell(', I2, ') ',
     1        4(A, I6, ','))
99985 FORMAT (/, 'Relative Atom_Type_Weight Encoding')
99984 FORMAT (A, ' =', I3, F10.2)
99983 FORMAT (/, 'Atom_Node_Weight Encoding: nijkl, Where n = Atom_',
     1       'Type_Weight of the Node Atom', /, 'and i,j,k,l Those of ',
     2       'the Atom_type_Weight Sorted Node Coordinating Atoms')
99982 FORMAT (/, 'ABORT! ', A, 'has more than 4 connections')
      END SUBROUTINE PLA030
 
      SUBROUTINE PLA031 (NQY, IPADNUMX, NWGT, NPK, ISAME, IHINP, NSAME,
     1  MSD, IPADNUM, ISHL, NCHAIN, JR, ISMLST)
 
C * ROUTINE TO SORT ONE SHELL OF ALL THE PATHS INTO DECREASING ORDER
C * OF PRIORITY AT THE CURRENT ISHL LEVEL.
C * SORT PRIORITES OF NSAME PATHS AT SHELL ISHL STARTING AT ISMPNTR.
      USE files
      USE parameters
      IMPLICIT NONE
      INTEGER, PARAMETER :: NP1 = 20000
      INTEGER :: I
      INTEGER :: J
      INTEGER :: K
      INTEGER :: L
      INTEGER :: M
      INTEGER :: I1
      INTEGER :: I2
      INTEGER :: I3
      INTEGER :: I4
      INTEGER :: I5
      INTEGER :: MSD
      INTEGER :: NPK
      INTEGER :: ISHL
      INTEGER :: IHINP
      INTEGER :: ISAME
      INTEGER :: NSAME
      INTEGER :: IPADNUM
      INTEGER :: IPADNUMX
      INTEGER, DIMENSION(100) :: JR
      INTEGER, DIMENSION(*)   :: NWGT
      INTEGER, DIMENSION(*)   :: NCHAIN
      INTEGER, DIMENSION(5)   :: ISMLST
      CHARACTER(len=6), DIMENSION(NP1) :: NQY
      DO J = 2, IPADNUMX
C * GET SERIAL NUMBER IN ATOM LIST
        I1 = NCHAIN((J - 1) * NPK + (ISHL - 1) * NSAME + ISAME)
C * GET THE LENGTH OF CHAIN # J
        I2 = NCHAIN((J - 1) * NPK +        MSD * NSAME + ISAME)
        I3 = 0
        IF (I1 > 0) I3 = NWGT(I1)
C * COPY CHAIN #J
        DO K = 1, IHINP
          JR(K) = NCHAIN((J - 1) * NPK + (K - 1) * NSAME + ISAME)
        END DO
        DO I = J - 1, 1, -1
          I4 = NCHAIN((I - 1) * NPK + (ISHL - 1) * NSAME + ISAME)
          I5 = 0
          IF (I4 > 0) I5 = NWGT(I4)
C * CHECK WHETHER PREVIOUS CHAIN HAS A >= TYPE VALUE
          IF (I5 >= I3) GO TO 30
          DO K = 1, IHINP
            NCHAIN(I       * NPK + (K - 1) * NSAME + ISAME) =
     1      NCHAIN((I - 1) * NPK + (K - 1) * NSAME + ISAME)
          END DO
          NCHAIN(I       * NPK + MSD * NSAME + ISAME) =
     1    NCHAIN((I - 1) * NPK + MSD * NSAME + ISAME)
        END DO
        I = 0
   30   NCHAIN(I * NPK + (ISHL - 1) * NSAME + ISAME) = I1
        DO K = 1, IHINP
          NCHAIN(I * NPK  + (K - 1) * NSAME + ISAME) = JR(K)
        END DO
        NCHAIN(I * NPK + MSD * NSAME + ISAME) = I2
      END DO
      M = NCHAIN((ISHL - 1) * NSAME + ISAME)
      IF (M > 0) M = NWGT(M)
C * LIST CHAINS FOR THIS ATOM, HIGHEST PRIORITY FIRST
      IF (IPR(777) == 1 .AND. ISHL == 2) THEN
        WRITE (LU6, 99999) NQY(ISMLST(ISAME))
        DO K = 0, IPADNUM - 1
          M = NCHAIN(K * NPK + MSD * NSAME + ISAME)
          DO L = 1, M
            JR(L) = NCHAIN(K * NPK + (L - 1) * NSAME + ISAME)
          END DO
          WRITE (LU6, 99998) K + 1, (NQY(JR(I)), NWGT(JR(I)), I = 1, M)
        END DO
      END IF
      RETURN
99999 FORMAT (/, 'SORTED CHAINS for ', A, /, 5X, 'I', 11X, 'II', 10X,
     1        'III', 9X, 'IV', 10X, 'V', 11X, 'VI', 10X, 'VII')
99998 FORMAT (I2, ': ', 10(A, I5, ','))
      END SUBROUTINE PLA031
 
      SUBROUTINE PLA032 (NAT, NATO, NT, IFG, CON)
C * LABUTE ALGORITHM FOR THE ASSIGNMENT OF A TOPOLOGY NUMBER TO ATOMS
      USE parameters
      IMPLICIT NONE
      INTEGER, PARAMETER :: NP1  = 20000
      INTEGER :: I
      INTEGER :: J
      INTEGER :: K
      INTEGER :: M
      INTEGER :: N
      INTEGER :: NC
      INTEGER :: NVX
      INTEGER :: NAT
      INTEGER :: MPG
      INTEGER :: NVB
      INTEGER :: MPRI
      INTEGER :: IPTM
      INTEGER :: NATO
      INTEGER :: IVAL
      INTEGER :: ISORT
      INTEGER, DIMENSION(NP1)    :: NT        ! Relative Weight of Atoms
      INTEGER, DIMENSION(9)      :: INL
      INTEGER, DIMENSION(9)      :: LST
      INTEGER, DIMENSION(3, NP1) :: IFG
      INTEGER, DIMENSION(9)      :: INB
      INTEGER, DIMENSION(9)      :: INE
      REAL,    DIMENSION(NP1, 9) :: CON
      INTEGER, ALLOCATABLE, DIMENSION(:)   :: NCHAIN
      INTEGER, ALLOCATABLE, DIMENSION(:,:) :: IPTR
      ALLOCATE (NCHAIN(NP67), IPTR(2, NP1))
 
      IF (IGBL(3) /= 33 .AND. IGBL(3) /= 34 .AND.
     1  NATO * 8 <= NP67) THEN
C * ZERO
        CALL GEN097 (NCHAIN, 1, NP67, 0)
C * INIT SORTING
        INB(1) = 1
        INE(1) = NATO
        DO I = INB(1), INE(1)
          NCHAIN ((I - 1) * 8 + 1) = NT(I)
          IPTR (1, I) = NT(I)
          IPTR (2, I) = I
        END DO
C * PRELIMINARY SORT ON ATOM TYPE
        CALL GEN037 (IPTR, INB(1), INE(1))
C * LOAD WEIGHTS OF NC CONNECTED ATOMS (IN POS 2 - NC + 1)
        MPG = 0
   10   DO I = INB(1), INE(1)
          NC = - NINT (CON(I, 9))
          IF (NC < 0 .OR. NC > 6) NC = 6
          IF (NC > 0) THEN
            DO J = 1, NC
              LST(J) = NT(NINT (CON(I, J)))
            END DO
            CALL GEN022 (LST, 1, NC, 1)
            DO K = 1, NC
              NCHAIN((I - 1) * 8 + K + 1) = LST (NC + 1 - K)
            END DO
          END IF
        END DO
C * SORT PRIORITIES
        M          = 1
        MPRI       = 1
   20   INL(M)     = INB(M) - 1
        INB(M + 1) = INB(M)
        N          = NCHAIN((IPTR(2, INB(M)) - 1) * 8 + M)
        NVB        = NCHAIN((IPTR(2, INB(M)) - 1) * 8 + M + 1)
        ISORT      = 0
C * LOAD SORT ITEM
   30   INL(M) = INL(M)  + 1
        IF (INL(M) <= INE(M)) THEN
          IPTM = IPTR(2, INL(M))
          IF (NCHAIN((IPTM - 1) * 8 + M) == N) THEN
            NVX             = NCHAIN ((IPTM - 1) * 8 + M + 1)
            IPTR(1, INL(M)) = NVX
            IF (NVX /= NVB) ISORT = 1
            NT(IPTM) = MPRI
            GO TO 30
          END IF
        END IF
        INE(M + 1) = INL(M) - 1
C * SORT
        IF (ISORT == 1) THEN
          CALL GEN037 (IPTR, INB(M + 1), INE(M + 1))
        ELSE
          IF (NVB == 0) GO TO 40
        END IF
C * ??????  (EXIT LOOP)
        DO K = 1, NATO
          I = IPTR(2, K)
          DO J = 1, 6
            IF (NCHAIN((I - 1) * 8 + J) == 0) EXIT
          END DO
        END DO
        IF (M < 8) THEN
          M = M + 1
          GO TO 20
        END IF
   40   INB(M + 1) = INL(M)
        IF (INB(M + 1) <= INE(M)) THEN
          N      = NCHAIN((IPTR(2, INB(M + 1)) - 1) * 8 + M)
          NVB    = NCHAIN((IPTR(2, INB(M + 1)) - 1) * 8 + M + 1)
          ISORT  = 0
          MPRI   = MPRI + 1
          INL(M) = INL(M) - 1
          GO TO 30
        ELSE
          M = M - 1
          IF (M /= 0) GO TO 40
          IF (MPRI > MPG) THEN
            MPG = MPRI
            GO TO 10
          END IF
          DO K = 1, NAT
            IVAL = NT(K)
            CALL GEN048 (10, IFG(2, K), 14, IVAL)
          END DO
        END IF
      END IF
      DO I = 1, NAT
        CALL GEN048 (-2, IFG(1, I), 28, K)
        IF (K == 2) K = 0
        CALL GEN048 ( 2, IFG(1, I), 28, K)
      END DO
      DEALLOCATE (NCHAIN, IPTR)
      RETURN
      END SUBROUTINE PLA032
 
      SUBROUTINE PLA033 (NJ, NK)
C *   SUPPORT ROUTINE FOR NEWMAN PROJECTIONS
      USE files
      USE parameters
      USE plato
      USE sgxyz
      IMPLICIT NONE
      INTEGER :: I
      INTEGER :: J
      INTEGER :: K
      INTEGER :: L
      INTEGER :: M
      INTEGER :: N
      INTEGER :: NJ
      INTEGER :: NK
      INTEGER :: ISH
      INTEGER :: NTYP
      REAL :: XR
      REAL :: YR
      REAL :: ZR
      REAL :: XR0
      REAL :: YR0
      REAL :: ZR0
      REAL :: DEN
      REAL :: DELX
      REAL :: DELY
      REAL, DIMENSION(3, 3) :: YUNK
      NTYP = -1
      IF (NJ /= 0) THEN
        IPR(60) = IPR(60) + 1
        J       = JR(2)
        K       = JR(3)
        CALL PLA227 (K, J, RMAT(1, 3))
        DEN = SQRT (RMAT(1, 3)**2 + RMAT(2, 3)**2)
        IF (DEN < PAR(12)) THEN
          RMAT(1, 2) = 0.0
          RMAT(2, 2) = 1.0
        ELSE
          RMAT(1, 2) =  RMAT(2, 3) / DEN
          RMAT(2, 2) = -RMAT(1, 3) / DEN
        END IF
        RMAT(3, 2) = 0.0
        CALL GEN008 (RMAT(1, 2), RMAT(1, 3), RMAT(1, 1), 1)
C * TRANSPOSE
        CALL GEN005 (RMAT, YUNK)
C * COPY MATRIX
        CALL GEN052 (YUNK, RMAT)
        M = 0
        DO I = 1, NJ
          N = NINT (CON(J, I))
          IF (N /= K) THEN
            M = M + 1
            IATC(M) = N + NP1
          END IF
        END DO
        DO I = 1, NK
          N = NINT (CON(K, I))
          IF (N /= J) THEN
            M = M + 1
            IATC(M) = N
          END IF
        END DO
C * ROTATION
        CALL PLA044 (RMAT, J, XR0, YR0, ZR0, 0.0, 0.0, 0.0, 1.0, 0.0)
        DO I = 1, M
          DATC(I) = 90.0
          L = MOD (IATC(I), NP1)
          CALL PLA044 (RMAT, L, XR, YR, ZR, XR0, YR0, ZR0, 1.0, 0.0)
          IF (ABS (XR) > 0.00001) THEN
            DATC(I) = ATAN2 (YR, XR) * RGBL(6)
            IF (DATC(I) < 0.0) DATC(I) = DATC(I) + 360.0
          END IF
        END DO
        CALL GEN036 (DATC, IATC, 1, M)
        ISH           = (IPR(60) - 1) * 60
        IATP(1 + ISH) = M
        IATP(2 + ISH) = J
        IATP(3 + ISH) = K
        DO I = 1, M
          IATP(I + 3  + ISH) = IATC(I)
          IATP(I + 20 + ISH) = NINT (100.0 * (DATC(I) - DATC(1)))
          IATP(I + 38 + ISH) = NINT (100.0 * (DATC(I) - DATC(1)))
        END DO
        DO I = 2, M
          DO J = 1, 6
            DELX = PAR(24) * ABS (COS (IATP(I + 38 + ISH) / RGBL(6))
     1       - COS (IATP(I + 37 + ISH) / RGBL(6)))
            DELY = PAR(24) * ABS (SIN (IATP(I + 38 + ISH) / RGBL(6))
     1       - SIN (IATP(I + 37 + ISH) / RGBL(6)))
            IF (4.5 * DELX > 6.0 * PAR(25) .OR.
     1          4.5 * DELY > PAR(25)) EXIT
            IATP(I + 38 + ISH) = IATP(I + 38 + ISH) + 1
            IATP(I + 37 + ISH) = IATP(I + 37 + ISH) - 1
          END DO
        END DO
        IATP(M + 4  + ISH) = IATC(1)
        IATP(M + 21 + ISH) = IATP(21 + ISH) + 36000
        IF (IPR(60) /= 4) RETURN
      END IF
      WRITE (LU8) NTYP, IPR(60), JR, RMAT
      WRITE (LU8) (IATP(L), L = 1, 240)
      IPR(60) = 0
      RETURN
      END SUBROUTINE PLA033
 
      SUBROUTINE PLA034 (NRSD)
C * GENERATE TORSION ANGLES
      USE files
      USE parameters
      USE plato
      USE atomdata
      USE cchar
      USE sgxyz
      IMPLICIT NONE
      INTEGER :: I
      INTEGER :: J
      INTEGER :: K
      INTEGER :: L
      INTEGER :: M
      INTEGER :: KB
      INTEGER :: NJ
      INTEGER :: NK
      INTEGER :: KB1
      INTEGER :: LAT
      INTEGER :: NCJ
      INTEGER :: NCK
      INTEGER :: ISA
      INTEGER :: NHB
      INTEGER :: IHB
      INTEGER :: NAT
      INTEGER :: MTL
      INTEGER :: IER
      INTEGER :: IFT
      INTEGER :: IHA
      INTEGER :: IHI
      INTEGER :: IHJ
      INTEGER :: IHK
      INTEGER :: IHL
      INTEGER :: IAT
      INTEGER :: JAT
      INTEGER :: KAT
      INTEGER :: JATL
      INTEGER :: KATL
      INTEGER :: IVAL
      INTEGER :: IVLT
      INTEGER :: JHYB
      INTEGER :: JMET
      INTEGER :: KHYB
      INTEGER :: KMET
      INTEGER :: NRSD
      INTEGER :: NTOR
      INTEGER :: IDS1
      INTEGER :: IDS2
      INTEGER :: IDS3
      INTEGER :: IDS4
      INTEGER :: ISP1
      INTEGER :: ISP2
      INTEGER :: ISP3
      INTEGER :: ISP4
      INTEGER :: NDEC
      INTEGER :: IRESJ
      INTEGER :: ITEST
      INTEGER :: MNUM1
      INTEGER :: MNUM2
      INTEGER :: MNUM3
      INTEGER :: MNUM4
      REAL :: A
      REAL :: SA
      CHARACTER(len=73) :: FORMX
      SA   = 0.0
      ISA  = 0
      IER  = 0
      NDEC = 0
      IF (IPR(8) > 0) THEN
        IPR(60) = 0
        NAT     = IPR(37)
        MTL     = 3
        NTOR    = 0
        KB      = 0
C * PREPARE PRINT FORMAT
        FORMX(1 :4)  = '(1X,'
        FORMX(5:24)  = '4(A),F8.2,''('',I3,'')'''
        FORMX(25:48) = ',4X,'//FORMX(5:24)
        FORMX(49:73) = FORMX(25:48)//')'
C * H & NON-H ATOM LOOP
        DO NHB = 1, 2
          IHB = NHB - 1
C * GENERATE BLANK LINE TO SEPARATE OUT H-ATOM ENTRIES
          IF (IHB == 1 .AND. IGBL(63) > 2) THEN
            CALL PLA262 (1)
            WRITE (LU7, '( )', IOSTAT = IOST)
          END IF
          DO 30 JAT = 1, NAT
            JR(2) = JAT
C * TRUNCATE
            JATL  = LABA(JAT) / IPR(463)
C * TEST RESIDUE NUMBER
            CALL GEN048 (-6, IFG(1, JAT), 9, IRESJ)
            IF (IRESJ /= NRSD) GO TO 30
C * GET H(,D)-ATOM BIT
            CALL GEN048 (-1, IFG(1, JAT), 7, IHJ)
            NJ = - NINT (CON(JAT, 9))
            IF (NJ < 0) THEN
              NJ = 9
              CALL GEN048 (-1, IFG(1, JAT), 8, IVAL)
              IF (IVAL > 0) NJ = NJ + IPR(76)
            END IF
            IF (NJ <= 1) GO TO 30
            DO 20 J = 1, NJ
              IF (J <= 9) THEN
                KAT = NINT (CON(JAT, J))
              ELSE
                IF (IBON(J - 9, 1) /= JAT) GO TO 20
                KAT = IBON(J - 9, 2)
              END IF
              JR(3) = KAT
C * TRUNCATE
              KATL = LABA(KAT) / IPR(463)
              IF (JATL > KATL) GO TO 20
              NK = - NINT (CON(KAT, 9))
              IF (NK < 0) THEN
                NK = 9
                CALL GEN048 (-1, IFG(1, KAT), 8, IVAL)
                IF (IVAL > 0) NK = NK + IPR(76)
              END IF
              IF (NK <= 1) GO TO 20
              CALL GEN048 (-1, IFG(1, KAT), 7,  IHK)
C * GENERATE NEWMAN-PROJECTION DATA FOR THIS BOND WITH COORDN LE IPR(163)
              IF (NJ <= IPR(163) .AND. NK <= IPR(163))
     1           CALL PLA033 (NJ, NK)
              DO 10 I = 1, NJ
                IF (I <= 9) THEN
                  IAT = NINT (CON(JAT, I))
                ELSE
                  IF (IBON(I - 9, 1) /= JAT) GO TO 10
                  IAT = IBON(I - 9, 2)
                END IF
                JR(1) = IAT
                IF (IAT == KAT) GO TO 10
                CALL GEN048 (-1, IFG(1, IAT), 7,  IHI)
                DO K = 1, NK
                  IF (K <= 9) THEN
                    LAT = NINT (CON(KAT, K))
                  ELSE
                    IF (IBON(K - 9, 1) /= KAT) CYCLE
                    LAT = IBON(K - 9, 2)
                  END IF
                  JR(4) = LAT
                  IF (LAT == JAT) CYCLE
                  IF (IAT == LAT) CYCLE
                  CALL GEN048 (-1, IFG(1, LAT), 7, IHL)
                  IHA = IHI + IHJ + IHK + IHL
                  IF (IHB == 0) THEN
                    IF (IHA > 0) CYCLE
                  ELSE
                    IF (IHA == 0) CYCLE
                  END IF
                  KB1 = KB + 1
                  CALL PLA036 (IAT, KB1, 1, IDS1, MNUM1, ISP1,
     1                         IPR(71), IGBL(55))
C * SKIP MINOR DISORDER ATOMS
                  IF (IDS1 < 5000) GO TO 10
                  CALL PLA036 (JAT, KB1, 2, IDS2, MNUM2, ISP2,
     1                         IPR(71), IGBL(55))
C * SKIP MINOR DISORDER ATOMS
                  IF (IDS2 < 5000) GO TO 30
                  CALL PLA036 (KAT, KB1, 3, IDS3, MNUM3, ISP3,
     1                         IPR(71), IGBL(55))
C * SKIP MINOR DISORDER ATOMS
                  IF (IDS3 < 5000) GO TO 20
                  CALL PLA036 (LAT, KB1, 4, IDS4, MNUM4, ISP4,
     1                         IPR(71), IGBL(55))
C * SKIP MINOR DISORDER ATOMS
                  IF (IDS4 < 5000) CYCLE
                  IVLT = 0
                  IF (MNUM1 > 1) THEN
                    IVLT = IVLT + 1
                  END IF
                  IF (MNUM2 > 1) THEN
                    IVLT = IVLT + 1
                  END IF
                  IF (MNUM3 > 1) THEN
                    IVLT = IVLT + 1
                  END IF
                  IF (MNUM4 > 1) THEN
                    IVLT = IVLT + 1
                  END IF
                  ITEST = (4 - ISP1 - ISP2 - ISP3 - ISP4) / 2
                  IF (IVLT > ITEST) CYCLE
C * SKIP PSEUDO-LINEAR I,J,K,L = ANGLES I,J,K AND J,K,L > PAR(15) DEG.
                  CALL PLA050 (IAT, JAT, KAT, 0, A)
                  IF (A > PAR(15)) CYCLE
                  CALL PLA050 (JAT, KAT, LAT, 0, A)
                  IF (A > PAR(15)) CYCLE
C * AVOID SPECIAL DISORDER CASES
                  CALL PLA053 (IAT, JAT, KAT, LAT, A, SA, ISA,
     1                         NDEC, IER)
                  IF (IER /= 0) CYCLE
C * SAVE IN LINE BUFFER - WE PRINT MTL TORSION ANGLES PER LINE
                  KB        = KB + 1
                  NTOR      = NTOR + 1
                  DBUF(KB)  = A
                  IDBUF(KB) = ISA
                  IFT       = -11 + KB * 24
C * MODIFY NUMBER OF DECIMAL DIGITS IN OUTPUT FORMAT
                  FORMX(IFT : IFT) = CHAR (ICHAR ('0') + NDEC)
C * CHECK FOR OMEGA-FILE WRITE
                  IF (IPR(438) == 1) THEN
                    IF(IPR(430) <= 0 .OR. IHA == 0) THEN
                      IPR(253) = IPR(253) + 1
                      WRITE (LU2, 99998, IOSTAT = IOST)
     1                  (NAMS(KB, M)(2:8), M = 1, 4), A, SA
                    END IF
                  END IF
C * VALIDATE TORSION ANGLE FOR X-C-C-H (METHYL)
                  CALL GEN048 (-3, IFG(2, KAT), 24, KMET)
                  CALL GEN048 (-4, IFG(1, KAT), 24, KHYB)
                  NCK = NINT (CON(KAT, 9))
                  CALL GEN048 (-3, IFG(2, JAT), 24, JMET)
                  CALL GEN048 (-4, IFG(1, JAT), 24, JHYB)
                  NCJ = NINT (CON(JAT, 9))
                  IF (NCK == -4) THEN
                    IF (KMET == 3 .AND. JHYB == 2) THEN
                      IF (180.0 - ABS (A) < 0.15) THEN
C * ALERT _380
                        CALL PLA236 (380, 2, -999.0, 1.0,
     1                    NAMS(KB, 3)(2:10), ' ')
                      END IF
                    END IF
                  END IF
                  IF (NCJ == -4) THEN
                    IF (JMET == 3 .AND. KHYB == 2) THEN
                      IF (180.0 - ABS (A) < 0.15) THEN
C * ALERT _380
                        CALL PLA236 (380, 2, -999.0, 1.0,
     1                    NAMS(KB, 2)(2:10), ' ')
                      END IF
                    END IF
                  END IF
C * TEST FOR PRINTING OF RESIDUE AND TORSION ANGLE HEADER
                  IF (NTOR == 1) THEN
                    IF (IPR(134) == 1) THEN
                      IF (IGBL(63) > 2) THEN
                        CALL PLA262 (4)
                        WRITE (LU7, 99999, IOSTAT = IOST) NRSD
                      END IF
                      IPR(134) = 0
                    END IF
                    IF (IGBL(63) > 2) THEN
                      CALL PLA262 (3)
                      WRITE (LU7, 99997, IOSTAT = IOST) '>', PAR(15)
                    END IF
                  END IF
                  IF (KB < MTL) CYCLE
                  IF (IGBL(63) > 2) THEN
                    WRITE (PRBUF, FORMX, IOSTAT = IOST)
     1                ((NAMS(L, M)(2:8), M = 1, 4),
     2                DBUF(L), IDBUF(L), L = 1, MTL)
                    CALL PLA263 (LU7, PRBUF, 132, 1, 3)
                  END IF
                  KB = 0
                END DO
   10         CONTINUE
   20       CONTINUE
   30     CONTINUE
C * CLEAR BUFFER
          IF (KB > 0) THEN
            IF (IGBL(63) > 2) THEN
              WRITE (PRBUF, FORMX, IOSTAT = IOST)
     1          ((NAMS(L, M)(2:8), M = 1, 4),
     2          DBUF(L), IDBUF(L), L = 1, KB)
              CALL PLA263 (LU7, PRBUF, 132, 1, 3)
            END IF
            KB = 0
          END IF
        END DO
C * SUPPORT NEWMAN - PROJECTIONS
        IF (IPR(60) /= 0) CALL PLA033 (0, 0)
      END IF
      RETURN
99999 FORMAT (/, 57X, 13('='), /, 56('*'), ' Residue =', I4, 1X,
     1 61('*'), /, 57X, 13('='))
99998 FORMAT ('TORS ', 4(A, 2X), 2F7.2)
99997 FORMAT (/, 'Torsion/Dihedral Angles (Deg.) - Klyne & Prelog',
     1 ' Convention (Dunitz, p241) - (Excl. Minor Disorder & Embedded',
     2 ' Bond Angl. ', A, F5.0, ' Deg.)', /, 132('='))
      END SUBROUTINE PLA034
 
      SUBROUTINE PLA035
C * ANALYSE METAL - RING GEOMETRY
      USE files
      USE parameters
      USE plato
      USE atomdata
      USE cchar
      USE sgxyz
      IMPLICIT NONE
      INTEGER :: I
      INTEGER :: J
      INTEGER :: K
      INTEGER :: IP
      INTEGER :: IR
      INTEGER :: NM
      INTEGER :: MN
      INTEGER :: MM
      INTEGER :: IER
      INTEGER :: IFT
      INTEGER :: LBB
      INTEGER :: LBC
      INTEGER :: LBD
      INTEGER :: MET
      INTEGER :: NAT
      INTEGER :: KRC
      INTEGER :: NRT
      INTEGER :: NDC
      INTEGER :: KAT
      INTEGER :: KAT1
      INTEGER :: IENM
      INTEGER :: NRAT
      INTEGER :: NRES
      INTEGER :: NIEN
      INTEGER :: NDCJ
      INTEGER :: NDEC
      INTEGER :: JDUM
      INTEGER :: IDUM
      INTEGER :: IDUM1
      INTEGER :: IDUM2
      INTEGER :: NDECJ
      INTEGER :: INQNR
      INTEGER :: JNQNR
      INTEGER :: KMETAL
      INTEGER, DIMENSION(9) :: IXMD
      INTEGER, DIMENSION(6) :: ICSD
      REAL :: DSH
      REAL :: YUNK
      REAL :: DCEN
      REAL :: DIST
      REAL :: DPERP
      REAL, DIMENSION(9, 2) :: XMD
      CHARACTER(len=160) :: FORMX
      CHARACTER(len=79)  :: FORMI
      CHARACTER(len=68)  :: FORMJ
C * PREPARE PRINT FORMAT
      FORMI( 1:28) = '(''Centroid '',A,'': x ,y ,z '','
      FORMI(29:62) = 'F10.5,''('',I4,'')'',F10.5,''('',I4,'')'','
      FORMI(63:79) = 'F10.5,''('',I4,'')'')'
      FORMJ( 1:17) = '(16X,''XO,YO,ZO '','
      FORMJ(18:68) = FORMI(29:79)
      FORMX(  1: 15) = '('' From: '',A   '
      FORMX( 16: 31) = ',F8.4,''('',I3,'')'''
      FORMX( 32: 79) = FORMX(16:31)//FORMX(16:31)//FORMX(16:31)
      FORMX( 80:127) = FORMX(32:79)
      FORMX(128:160) = FORMX(16:31)//FORMX(16:31)//')'
      NRAT     = IPR(12)
      NAT      = IPR(39)
      IPR(64)  = IPR(64) + 1
C * NEW CG# ATOM DATA POINTER
      KRC      = NAT + IPR(64)
C * COPY FLAGS FOR Cg# FROM ATOM JR(1) = FIRST RING ATOM
      DO I = 1, 3
        IFG(I, KRC) = IFG(I, JR(1))
      END DO
C * COPY TRNS CODE
      NTRNS(KRC) = NTRNS(JR(1))
C * GET RESIDUE NUMBER
      CALL GEN048 (-6, IFG(1, KRC), 9, NRES)
C * GENERATE NEW LABEL CGnm (CORRESPONDING TO PLANE NUMBER)
      CALL GEN040 (IPR(19) + IATP(KRC), NQ2, IP)
      NQ1(1:7)      = 'CG     '
      NQ1(3:2 + IP) = NQ2(1:IP)
      CALL PLA046 (1, NQ1, IENM, LBB, LBC, LBD,
     1             INQNR, JNQNR, NIEN)
C * STORE ELEMENT TYPE IN FLAG ARRAY
      CALL GEN048 (6, IFG(1, KRC), 15, NIEN)
C * STORE Cg# LABEL
      LABA(KRC) = INQNR
C * UNPACK LABEL-CODE CLEANLY
      CALL PLA047 (INQNR, NQ1, MN, JDUM, IPR(71), IGBL(55), 0, 0)
C * ROUND AND PRINT CENTROID COORDINATES
      DO K = 1, 3
        YUNK = SQRT (XSD(KRC, K))
        CALL GEN041 (XXO(KRC, K), YUNK, ICSD(K), IPR(183),
     1               NDEC, IPR(68))
        NDC           = K * 17 + 16
        YUNK = SQRT(XSD(KRC, K + 3))
        CALL GEN041 (XXO(KRC, K + 3), YUNK, ICSD(K + 3), 5, NDECJ,
     1       IPR(68))
        NDCJ          = K * 17 + 5
C * MODIFY NUMBER OF DECIMAL DIGITS
        FORMI(NDC:NDC)   = CHAR (ICHAR ('0') + NDEC)
        FORMJ(NDCJ:NDCJ) = CHAR (ICHAR ('0') + NDECJ)
        ICSD(K)          = MIN (99, ICSD(K))
        ICSD(K + 3)      = MIN (99, ICSD(K + 3))
      END DO
      IF (IGBL(63) > 2) THEN
        CALL PLA262 (1)
        WRITE (LU7, '(/)', IOSTAT = IOST)
        WRITE (PRBUF, FORMI, IOSTAT = IOST)
     1    NQ1(1:6), (XXO(KRC, K), ICSD(K), K = 1, 3)
        CALL PLA263 (LU7, PRBUF, 132, 1, 3)
        WRITE (PRBUF, FORMJ, IOSTAT = IOST)
     1    (XXO(KRC, K), ICSD(K), K = 4, 6)
        CALL PLA263 (LU7, PRBUF, 132, 1, 3)
      END IF
      IF (NRAT <= 7) THEN
C * STORE CG# FOR PRINTING AS LAST ENTRY(NRAT)
        NRAT          = NRAT + 1
        NAMS(NRAT, 1) = ' '//NQ1(1:NP64-1)
        NRT           = NRAT + 1
        NAMS(NRT, 1)  = '  RING '
        NM = 0
C * LOOP OVER ALL ATOMS TO FIND SHORT METAL-RING INTERACTIONS
        DO 120 I = 1, NAT
          CALL GEN048 (-1, IFG(1, I), 19, MET)
          IF (MET == 0) GO TO 120
          JR(NRAT)    = KRC
C * TEST DISTANCE TO RING-CENTROID
          CALL PLA050 (I, KRC, 0, 0, DCEN)
          IF (DCEN > PAR(422)) GO TO 120
C * GET LABEL OF METAL ATOM
          CALL PLA047 (LABA(I), NQ1, IDUM, JDUM, IPR(71),
     1      IGBL(55), 0, 0)
C * CALCULATE LEAST-SQUARES PLANE TROUGH RING
          CALL PLA055
C * CALCULATE PERPENDICULAR METAL-RING DISTANCE
          CALL PLA056 (XPV(1), I, XMD(NRT, 1), XMD(NRT, 2),
     1                 IDUM1, 5, IDUM2)
          XMD(NRT, 1) = ABS (XMD(NRT, 1))
          IXMD(NRT)   = MIN (999, NINT(10000.0 * XMD(NRT, 2)))
C * GET METAL TO RING-ATOM DISTANCES (INCLUDING CG#)
          DO J = 1, NRAT
            CALL PLA053 (I, JR(J), 0, 0, XMD(J, 1), XMD(J, 2),
     1                  IXMD(J), NDEC, IER)
            IF (IER == 0) THEN
C * SKIP THIS CALCULATION WHEN METAL IS PART OF THE RING
              IF (XMD(J, 1) < PAR(12)) GO TO 120
              IFT = 4 + J * 16
C * MODIFY NUMBER OF DECIMAL DIGITS IN OUTPUT FORMAT
              FORMX(IFT : IFT) = CHAR (ICHAR ('0') + NDEC)
            END IF
          END DO
C * CALCULATE AND ANALYSE RING-SLIPPAGE PARAMETER
          DPERP = - XPV(4)
          DO J = 1, 3
            DPERP = DPERP + XPV(J) * XXO(I, J + 3)
          END DO
          DSH = SQRT (MAX (0.0, DCEN**2 - ABS (DPERP)**2))
C * SKIP UNINTERESTING CASES
          IF (DSH > PAR(423) .OR. ABS (DPERP) < PAR(424)) GO TO 120
C * LIST RING SLIPPAGE RESULTS
          IF (IGBL(63) > 2) THEN
            NM = NM + 1
C * PRINT HEADER LINE
            IF (NM == 1) THEN
              WRITE (LU7, 99998, IOSTAT = IOST)
     1          PAR(422), PAR(424), PAR(423)
              WRITE (LU7, 99997, IOSTAT = IOST)
     1          (NAMS(J, 1)(2:7), J = 1, NRT)
              WRITE (LU7, 99996, IOSTAT = IOST)
            END IF
C * PRINT DISTANCE LINE
            WRITE (PRBUF, FORMX, IOSTAT = IOST)
     1         NQ1(1:7), (XMD(J, 1), IXMD(J), J = 1, NRT)
            CALL PLA263 (LU7, PRBUF, 132, 1, 3)
C * PRINT RING SLIPPAGE SHIFT
            WRITE (LU7, 99999, IOSTAT = IOST) DSH
          END IF
C * REPLACE Me-Ring ATOM BONDS BY ONE DASHED LINE TO CENTRE OF GRAVITY
          IF (DSH < PAR(70)) THEN
C * CG-ATOM REFERENCE IS 'KRC' AND TRANSFORMED IN 'KAT'
C * LOAD METAL AS LAST ENTRY FOR SYMMETRY TRANSFORMATION
            JR(NRAT) = I
            DO MM = 1, IPR(51)
              IF (MM == 1) THEN
                DO J = 2, NRAT
                  CALL PLA268 (JR(NRAT), JR(J - 1), -1, -1.0)
                END DO
C * ADD METAL-CG BOND
                CALL PLA268 (JR(NRAT), KRC, 1, -1.0)
              ELSE
                CALL GEN098 (MOL(MM), PAR(42), IPR(54),
     1               ITR(1), ITR(2), ITR(3), IR)
                IF (NRES == IR) THEN
                  KAT       = IPR(39) + IPR(64) + 1
                  IF (MN > IPR(463)) THEN
                    IPR(2) = 54
                    GO TO 130
                  END IF
                  LABA(KAT) = LABA(KRC) + MM - 1
C * IS THIS A NEW CG ?
                  DO J = 1, IPR(64)
                    IF (LABA(KAT) == LABA(IPR(39) + J)) THEN
                      KAT = IPR(39) + J
                      GO TO 70
                    END IF
                  END DO
                  IPR(64) = IPR(64) + 1
                  CALL PLA059 (KRC, KAT)
C * COPY FLAGS
                  DO J = 1, 3
                    IFG(J, KAT) = IFG(J, KRC)
                  END DO
C * STORE COORDINATES (AND ESD'S) ALSO IN BACKING STORE 'VOID'
                  DO J = 1, 6
                    VOID((KAT - 1) * NP71 + J)     = XXO(KAT, J)
                    VOID((KAT - 1) * NP71 + J + 6) = XSD(KAT, J)
                  END DO
C * SET RESIDUE NUMBER OF TRANSFORMED CG EQUAL TO CURRENT
                  CALL GEN048 (6, IFG(1, KAT), 9, IR)
C * FIND TRANSFORMED ATOMS (RING + METAL)
   70             DO 100 J = 1, NRAT
C * GET TRANSFORMATION CODE
                    KAT1 = KAT + 1
                    CALL PLA059 (JR(NRAT + 1 - J), KAT1)
                    DO K = 1, NAT
                      CALL PLA050 (K, KAT1, 0, 0, DIST)
                      IF (DIST < 0.05) THEN
                        IF (J == 1) THEN
                          KMETAL = K
C * ADD METAL-CG BOND
                          CALL PLA268 (KMETAL, KAT, 1, -1.0)
                        ELSE
C * DELETE INDIVIDUAL METAL-C BOND
                          CALL PLA268 (KMETAL, K, -1, -1.0)
                        END IF
                        GO TO 100
                      ENDIF
                    END DO
  100             CONTINUE
                END IF
              END IF
            END DO
          END IF
  120   CONTINUE
      END IF
  130 RETURN
99999 FORMAT (/, 'Ring-Slippage: Distance Between Perpendicular ',
     1 'Projection of Heavy Atom on Ring L.S.-Plane and Ring ',
     2 'Centroid =', F6.3, ' Ang'/)
99998 FORMAT (///, 10X, 'Metal - Ring Geometry [d(Metal-Cg) < ',
     1 F5.1, ' Ang., d(perp) > ', F5.1, ' Ang., Slippage < ',
     2 F6.3, ' Ang.]', /, 10X, 102('='), /)
99997 FORMAT ('Distance (Ang) to:', 1X, A, 8(7X, A))
99996 FORMAT (132('-'))
      END SUBROUTINE PLA035
 
      SUBROUTINE PLA036 (IAT, KB, NA, IDS, MNUM, ISPOS, IPAR, IALIAS)
C * GET DISORDER INFORMATION IN NAMS(,,)
      USE parameters
      USE plato
      USE atomdata
      USE cchar
      USE sgxyz
      IMPLICIT NONE
      INTEGER :: I
      INTEGER :: NA
      INTEGER :: KB
      INTEGER :: IAT
      INTEGER :: IDS
      INTEGER :: IPAR
      INTEGER :: MNUM
      INTEGER :: JDUM
      INTEGER :: ILABI
      INTEGER :: ISPOS
      INTEGER :: IALIAS
      INTEGER :: NAMDIS
      CHARACTER(len=NP64) :: NQ
      I = IABS(IAT)
      IF (IAT > 0) THEN
        ILABI =   LABA(I)
      ELSE
        ILABI = - LABA(I)
      END IF
C * GET SPECIAL POSITION FLAG
      CALL GEN048 (-1, IFG(1, I), 6, ISPOS)
C * GET DISORDER INFORMATION
      CALL GEN048 (-8, IFG(2, I), 1, IDS)
      IDS = IPPR(IDS + 1, 1)
      IF (IDS == 10000) THEN
        NAMDIS = ICHAR (' ')
      ELSE IF (IDS > 5000) THEN
        NAMDIS = ICHAR ('>')
      ELSE IF (IDS == 5000) THEN
        NAMDIS = ICHAR ('*')
      ELSE
        NAMDIS = ICHAR ('<')
      END IF
      CALL PLA047 (ILABI, NQ, MNUM, JDUM, IPAR, IALIAS, 0,
     1  1 - IALIAS)
      NAMS(KB, NA) = CHAR (NAMDIS)//NQ(1:NP64-1)
      RETURN
      END SUBROUTINE PLA036
 
      SUBROUTINE PLA037 (K, N, M)
C * ANALYSIS OF ATOM LABEL FOR ATOM TYPE/SERIAL NUMBER
      USE parameters
      USE atomdata
      USE cchar
      IMPLICIT NONE
      INTEGER :: I
      INTEGER :: J
      INTEGER :: K
      INTEGER :: N
      INTEGER :: M
      INTEGER :: LBB
      INTEGER :: LBC
      INTEGER :: LBD
      INTEGER :: NIEN
      INTEGER :: IENM
      INTEGER :: INQNR
      INTEGER :: JNQNR
C * RETURN VALUE N > 0 : ELEMENT
C *              N < 0 : ATOM NR
C *              N = 0 : ERROR
C *              M = 2 : SEARCH IN PRIMARY ATOM ARRAY
C *              M = 3 : SEARCH IN EXPANDED ARRAY
      NQ0 = IFL(K)(1:7)
C * IS THIS AN ELEMENT LABEL ?
      IF (NQ0(3:3) == ' ') THEN
C * TRANSFORM ATOM TYPE FROM ASCII TO NUMBER n * 100 + m
        DO I = 1, 26
          IF (NQ0(1:1) == CHAR (ICHAR ('A') + I - 1)) THEN
            N = I * 100
            IF (NQ0(2:2) == ' ') GO TO 10
            DO J = 1, 26
              IF (NQ0(2:2) == CHAR (ICHAR ('A') + J - 1)) THEN
                N =  N + J
                GO TO 10
              END IF
            END DO
            GO TO 20
          END IF
        END DO
C * GET ELEMENT NUMBER (POINTER IN ARRAY IEN)
   10   DO J = 1, IAN
          IF (N == IEL(IEN(J))) THEN
            N = J
            RETURN
          END IF
        END DO
      END IF
C * NO ELEMENT NAME, NOW LOOK FOR POSSIBLE ATOM LABEL
   20 N = 0
C * GET NUMBER OF UNIQUE ATOMS
      CALL PLA046 (M, NQ0, IENM, LBB, LBC, LBD,
     1             INQNR, JNQNR, NIEN)
      IF (NIEN < 0) THEN
C * UNSUITABLE ATOM LABEL
        IPR(2) = 3
      ELSE
        N = - NIEN
      END IF
      RETURN
      END SUBROUTINE PLA037
 
      SUBROUTINE PLA038 (IAT, JAT, IFIN)
C * SUBROUTINE GENERATES SEQUENCE OF UNIQUE BONDS (IAT, JAT)
      USE parameters
      USE plato
      USE atomdata
      USE cchar
      USE sgxyz
      IMPLICIT NONE
      INTEGER       :: K
      INTEGER       :: KJ
      INTEGER, SAVE :: NC
      INTEGER, SAVE :: KI
      INTEGER, SAVE :: IX
      INTEGER, SAVE :: NAT
      INTEGER       :: IAT
      INTEGER       :: JAT
      INTEGER       :: KAT
      INTEGER       :: NEL
      INTEGER       :: NCI
      INTEGER       :: NCJ
      INTEGER       :: IHA
      INTEGER       :: IVAL
      INTEGER       :: JUNK
      INTEGER       :: IFIN
      INTEGER       :: LABJ
      INTEGER       :: IENJ
      INTEGER       :: IDUM
      INTEGER, SAVE :: IENI
      INTEGER, SAVE :: LABI
      INTEGER, SAVE :: IMET
      INTEGER, SAVE :: JMET
      INTEGER       :: NDIST
      INTEGER, SAVE :: IATNRI
      REAL :: DIST
C * INITIALIZED BY IFIN = -3, -2, -1 ; END SIGNAL WITH IFIN = 1 ON RETURN
C * NON-INIT MODE
      IF (IFIN == 0) THEN
        GO TO 20
C * INIT MODE IFIN = -3 (ALL ATOMS, BOND-LABELS)
      ELSE IF (IFIN == -3) THEN
        NAT = IPR(39)
        IX  = 0
C * INIT MODE IFIN = -2 (ALL ATOMS)
      ELSE IF (IFIN == -2) THEN
        NAT = IPR(39)
        IX  = 1
C * INIT MODE IFIN = -1 (UNIQUE ATOMS, BOND-LABELS)
      ELSE
        NAT = IPR(37)
        IX  = 0
      END IF
      IFIN = 0
      IMET = 0
      JMET = 0
      IENI = 0
      IAT  = 0
   10 IAT  = IAT + 1
      IF (IAT > NAT) THEN
        IFIN = 1
        RETURN
      END IF
C * TEST FOR H-ATOM IDENTIFICATION BIT
      CALL GEN048 (-1, IFG(1, IAT), 7, IHA)
      IF (IHA == 1) GO TO 10
      CALL GEN048 (-1, IFG(1, IAT), 19, IMET)
C * GET ELEMENT TYPE FOR ATOM IAT
      CALL PLA047 (LABA(IAT), NQ1, IDUM, IENI, IPR(71), IGBL(55),
     1  0, 1 - IGBL(55))
      IF (IX == 0) THEN
        IATNRI = IATNR(IENI)
        LABI   = LABA(IAT) / IPR(463)
      END IF
      NC = - NINT (CON(IAT, 9))
      IF (NC == 0) THEN
        GO TO 10
      ELSE IF (NC < 0) THEN
        NC = 9
C * TEST FOR MORE THAN 9 CONNECTIONS
        CALL GEN048 (-1, IFG(1, IAT), 8, IVAL)
        IF (IVAL > 0) NC = NC + IPR(76)
      END IF
C * LOOP OVER CONNECTIONS
      KI = 0
   20 KI = KI + 1
      IF (KI > NC) GO TO 10
      IF (KI <= 9) THEN
        JAT = NINT (CON(IAT, KI))
      ELSE
        IF (IBON(KI - 9, 1) == IAT) THEN
          JAT = IBON(KI - 9, 2)
        ELSE
          GO TO 20
        END IF
      END IF
C * TEST HYDROGEN ATOM IDENTIFICATION BIT ATOM JAT
      IF (IPR(133) >= 0) THEN
        IF (JAT == 0) GO TO 20
        CALL GEN048 (-1, IFG(1, JAT), 7, IHA)
        IF (IHA /= IPR(133)) GO TO 20
      END IF
C * GET ATOM TYPE FOR ATOM JAT
      CALL PLA047 (LABA(JAT), NQ2, IDUM, IENJ, IPR(71), IGBL(55),
     1     0, 1 - IGBL(55))
      CALL GEN048 (-1, IFG(1, JAT), 19, JMET)
C * HANDLE X-C-O2 .. Metal Bonds
      IF (IMET == 1 .AND. IENJ == 2 .OR.
     1    JMET == 1 .AND. IENI == 2) THEN
        NDIST = 0
C * CHECK FOR C
        IF (IENJ == 2) THEN
          NCJ   = - NINT (CON(JAT, 9))
          DO KJ = 1, NCJ
            KAT = NINT (CON(JAT, KJ))
            CALL GEN048 (-4, IFG(1, KAT), 15, NEL)
            NEL = IEN(NEL + 1)
C * TEST FOR O
            IF (NEL == 3) THEN
              CALL PLA050 (IAT, KAT, 0, 0, DIST)
              IF (IENI > 0) THEN
                IF (DIST < REL(IENI) + 1.10) NDIST = NDIST + 1
              END IF
            END IF
          END DO
          IF (NDIST >= 2) GO TO 20
        ELSE
          NCI = - NINT (CON(IAT, 9))
          DO K = 1, NCI
            KAT = NINT (CON(IAT, K))
            CALL GEN048 (-4, IFG(1, KAT), 15, NEL)
            NEL = IEN(NEL + 1)
C * TEST FOR O
            IF (NEL == 3) THEN
              CALL PLA050 (JAT, KAT, 0, 0, DIST)
              IF (DIST < REL(IENJ) + 1.20) NDIST = NDIST + 1
            END IF
          END DO
          IF (NDIST >= 2) GO TO 20
        END IF
      END IF
      IF (IX == 0) THEN
        JUNK = IATNRI - IATNR(IENJ)
        IF (JUNK < 0) THEN
          GO TO 20
        ELSE IF (JUNK == 0) THEN
          LABJ = LABA(JAT) / IPR(463)
          IF (LABI > LABJ) GO TO 20
        END IF
      END IF
      RETURN
      END SUBROUTINE PLA038
 
      SUBROUTINE PLA039 (IAT, JAT, KAT, NRSD, A, SA, ISA, ND, KB, IFIN)
C * GENERATE ANGLES FROM CONN ARRAY
      USE parameters
      USE plato
      USE sgxyz
      IMPLICIT NONE
      INTEGER, SAVE :: NC
      INTEGER, SAVE :: KI
      INTEGER, SAVE :: KJ
      INTEGER       :: ND
      INTEGER       :: KB
      INTEGER       :: KB1
      INTEGER       :: IER
      INTEGER       :: IHA
      INTEGER       :: IAT
      INTEGER       :: JAT
      INTEGER       :: KAT
      INTEGER       :: ISA
      INTEGER, SAVE :: IHI
      INTEGER, SAVE :: IHJ
      INTEGER, SAVE :: IHK
      INTEGER, SAVE :: NAT
      INTEGER       :: ISP1
      INTEGER       :: ISP2
      INTEGER       :: ISP3
      INTEGER       :: IVAL
      INTEGER       :: NRSD
      INTEGER       :: IFIN
      INTEGER       :: IDS1
      INTEGER       :: IDS2
      INTEGER       :: IDS3
      INTEGER       :: IRESJ
      INTEGER       :: MNUM1
      INTEGER       :: MNUM2
      INTEGER       :: MNUM3
      REAL :: A
      REAL :: SA
      REAL :: A1
      ND  = 0
      ISA = 0
      IER = 0
      A   = 0.0
      SA  = 0.0
      IF (IFIN == 0) THEN
        GO TO 30
      ELSE IF (IFIN == -1) THEN
        NAT = IPR(37)
      END IF
      IFIN = 0
      JAT  = 0
   10 JAT  = JAT + 1
      IF (JAT > NAT) THEN
        IFIN = 1
        RETURN
      END IF
C * GET H-ATOM BIT
      CALL GEN048 (-1, IFG(1, JAT), 7,  IHJ)
      IF (IHJ == 1) GO TO 10
C * GET RESIDUE NUMBER AND CHECK WITH CURRENT RESIDUE NUMBER
      CALL GEN048 (-6, IFG(1, JAT), 9, IRESJ)
      IF (IRESJ /= NRSD) GO TO 10
C * GET AND CHECK FOR > 1 NUMBER OF CONNECTIONS FOR THIS JAT ATOM
      NC = - NINT(CON(JAT, 9))
      IF (NC < 0) THEN
        NC = 9
C * TEST FOR MORE THAN 9 CONNECTIONS
        CALL GEN048 (-1, IFG(1, JAT), 8, IVAL)
        IF (IVAL > 0) NC = NC + IPR(76)
      END IF
      IF (NC <= 1) GO TO 10
      KI = 0
   20 KI = KI + 1
      IF (KI >= NC) GO TO 10
      IF (KI <= 9) THEN
        IAT = NINT (CON(JAT, KI))
      ELSE
        IF (IBON(KI - 9, 1) /= JAT) GO TO 20
        IAT = IBON(KI - 9, 2)
      END IF
      KJ = KI
C * GET H-ATOM BIT
      CALL GEN048 (-1, IFG(1, IAT), 7,  IHI)
   30 KJ = KJ + 1
      IF (KJ > NC) GO TO 20
      IF (KJ <= 9) THEN
        KAT = NINT (CON(JAT, KJ))
      ELSE
        IF (IBON(KJ - 9, 1) /= JAT) GO TO 30
        KAT = IBON(KJ - 9, 2)
      END IF
C * GET H-ATOM FLAG
      CALL GEN048 (-1, IFG(1, KAT), 7,  IHK)
      IHA  = IHI + IHJ + IHK
      IF (IPR(133) == 0) THEN
        IF (IHA > 0) GO TO 30
      ELSE
        IF (IHA == 0) GO TO 30
      END IF
      KB1 = KB + 1
C * GET LABEL/DISORDER/SYMMETRY-FLAG INFORMATION
      CALL PLA036 (IAT, KB1, 1, IDS1, MNUM1, ISP1, IPR(71), IGBL(55))
      CALL PLA036 (JAT, KB1, 2, IDS2, MNUM2, ISP2, IPR(71), IGBL(55))
      CALL PLA036 (KAT, KB1, 3, IDS3, MNUM3, ISP3, IPR(71), IGBL(55))
C * ELIMINATE CERTAIN DISORDER-DATA
      IF (IDS1 < 10000 .AND. IDS3 < 10000) THEN
        IF (IDS1 /= IDS3) GO TO 30
        IF (IDS2 < 10000) THEN
          IF (IDS1 /= IDS2 .OR. IDS2 /= IDS3) GO TO 30
        END IF
      END IF
      CALL PLA053 (IAT, JAT, KAT, 0, A, SA, ISA, ND, IER)
      IF (IER /= 0) GO TO 30
C * HANDLE SPECIAL CASE OF 180 DEGREES (INVERSION/ MIRROR)
      IF (ISP2 == 1 .AND. MNUM3 > 1) THEN
        CALL PLA050 (IAT, JAT, KAT, 0, A1)
        IF (ABS (A1) > 179.9) THEN
          A  = 180.0
          SA = 0.0
        END IF
      END IF
      RETURN
      END SUBROUTINE PLA039
 
      SUBROUTINE PLA040 (MODE, IAT, IVAL, KAT)
C * MANAGE CONN ARRAY
      USE parameters
      USE plato
      USE sgxyz
      IMPLICIT NONE
      INTEGER :: K
      INTEGER :: L
      INTEGER :: NC
      INTEGER :: IVL
      INTEGER :: IAT
      INTEGER :: KAT
      INTEGER :: MODE
      INTEGER :: IVAL
C * BRANCH FOR GET, INITIALIZE OR STORAGE OF CONNECTION
      IF (MODE < 0) THEN
C * GET CONNECTION
        NC = - NINT (CON(IAT, 9))
C * BRANCH FOR >= 9, 0, < 9 BONDS FOR ATOM IAT
        IF (NC /= 0) THEN
          IF (NC < 0) THEN
            NC = 9
            CALL GEN048 (-1, IFG(1, IAT), 8, IVL)
            IF (IVL > 0) NC = NC + IPR(76)
          END IF
          DO L = 1, NC
            IF (L > 9) THEN
              IF (IBON(L - 9, 1) /= IAT) CYCLE
              IF (IBON(L - 9, 2) == KAT) THEN
                IVAL = L
                RETURN
              END IF
            ELSE
              IF (NINT (CON(IAT, L)) == KAT) THEN
                IVAL = L
                RETURN
              END IF
            END IF
          END DO
        END IF
        IVAL = 0
      ELSE IF (MODE == 0) THEN
C * RESET CONNECTIVITY
        DO K = IAT, IVAL
          CON(K, 9) = KAT
        END DO
      ELSE
C * STORE CONNECTION (INCREASE # BONDS IPR(147)
        IVAL = 0
        IPR(147) = IPR(147) + 1
        IF (CON(IAT, 9) > 0) THEN
          CALL GEN048 (1, IFG(1, IAT), 8, 1)
          IF (IPR(76) /= IPR(96)) THEN
            IPR(76)          = IPR(76) + 1
            IBON(IPR(76), 1) = IAT
            IBON(IPR(76), 2) = KAT
            IVAL             = 9 + IPR(76)
          END IF
        ELSE
          CON(IAT, 9)  =   CON(IAT, 9) - 1
          IVAL           = - NINT (CON(IAT, 9))
          CON(IAT, IVAL) =   KAT
        END IF
      END IF
      RETURN
      END SUBROUTINE PLA040
 
      SUBROUTINE PLA041 (IATPR, N)
C * SPECIAL ME..O,N ETC. TEST
      USE parameters
 
      IMPLICIT NONE
      INTEGER :: N
      INTEGER :: IATPR
      INTEGER :: IPRM
      INTEGER :: IPRN
      INTEGER :: ITST
      IPRN = IPR(509 + N)
C * CHECK FOR CU, AG, CR, CO, MN, TI, NI, ZN, TL
      IF (IPRN == 10 .OR. IPRN == 11 .OR.
     1    IPRN == 13 .OR. IPRN == 30 .OR.
     2    IPRN == 31 .OR. IPRN == 59 .OR.
     3    IPRN == 94 .OR. IPRN == 95 .OR.
     4    IPRN == 103) THEN
            IPRM = IPRN
C * (EARTH)ALKALI
      ELSE IF (IATPR == 5 .OR. IATPR == 6) THEN
            IPRM = 1
      ELSE IF (IPR(325) == 1 .AND. IATPR < 0) THEN
        IF (IPRN == 3 .OR. IPRN == 4) THEN
          IPRM = - IPRN
        ELSE
          IPRM = -1
        END IF
C * NON-METAL (ORGANIC) CASE
      ELSE IF (IPR(325) == 0 .AND. IATPR < 0) THEN
C * CHECK FOR O, N, Cl
        IF (IPRN >= 3 .AND. IPRN <= 5) THEN
          IPRM = - IPRN
        ELSE
          IPRM = -1
        END IF
C * NON-METAL - NON- HALOGEN (ORGANIC) CASE
      ELSE IF (IPR(325) == -1 .AND. IATPR == -1) THEN
C * TEST FOR O, N
        IF (IPRN == 3 .OR. IPRN == 4) THEN
          IPRM = - IPRN
        ELSE
          IPRM = -1
        END IF
      ELSE
        IPRM = 0
      END IF
      IPR(157 + N) = IPRM
C * METAL/NON-METAL
      IPR(191 + N) = ISIGN (1, IATPR)
      IF (N > 0) THEN
        PAR(293) = 0.0
C * ADD ADDITIONAL TOLERANCE FOR (EARTH)ALKALI TO O, C, N,  ..
C * TEST FOR AUTO RADII
        IF (IPR(156) == 0) THEN
          ITST = IPR(157) * IPR(158)
C * ZN..O,N
          IF (ITST == -309 .OR. ITST == -412) THEN
            PAR(293) = PAR(541)
C * Cu..O,N,Cl
          ELSE IF (ITST == -30 .OR. ITST ==  -40 .OR.
     1      ITST == -50 .OR. ITST == -120) THEN
            PAR(293) = PAR(542)
C * MN..O,N
          ELSE IF (ITST == -177 .OR. ITST == -236) THEN
            PAR(293) = PAR(543)
C * AG..O,N
          ELSE IF (ITST == -39 .OR. ITST == -52) THEN
            PAR(293) = PAR(544)
C * CR..O,N
          ELSE IF (ITST == -93 .OR. ITST == -124) THEN
            PAR(293) = PAR(545)
C * TL..O,N
          ELSE IF (ITST == -285 .OR. ITST == -380) THEN
            PAR(293) = PAR(546)
C * O,N,Cl - Alkali
          ELSE IF (ITST == -1 .OR. ITST == -3 .OR.
     1      ITST == -4 .OR. ITST == -5) THEN
            PAR(293) = IGBL(97) * PAR(26)
          END IF
C * AVOID SOME METAL - METAL BONDS
          IF (IPR(191) + IPR(192) == 2) PAR(293) = PAR(27)
        END IF
      END IF
      RETURN
      END SUBROUTINE PLA041
 
      SUBROUTINE PLA042 (MODE)
C * LATTICE/SP:GR HEADER
      USE files
      USE parameters
      USE plato
      USE atomdata
      USE cchar
      USE sgxyz
      IMPLICIT NONE
      INTEGER :: I
      INTEGER :: J
      INTEGER :: K
      INTEGER :: MODE
      INTEGER :: NRXX
      REAL :: WAVL
      CHARACTER(len=120) :: FCELA
      CHARACTER(len=89)  :: FCELB
      CHARACTER(len=89)  :: FCELC
      CHARACTER(len=95)  :: FCELV
C * HEADER, CELL, SYMM LISTING
C * TEST FOR PREVIOUS CALL
      IF (IPR(680) == 0) THEN
        FCELA(  1: 38) = '( ''a ='',F9.4,''('',I3,'')  Angstrom'',16X,'
        FCELA( 39: 75) = '''alpha ='',F9.3,''('',I3,'') Degree'',13X,'
        FCELA( 76:106) = '''a  ='',F9.3,5X,''alpha  ='',F8.2,'
        FCELA(107:120) = '''  V  ='',F8.1)'
        FCELB(  1: 28) = '( ''b ='',F9.4,''('',I3,'')'',26X,'
        FCELB( 29: 58) = ''' beta ='',F9.3,''('',I3,'')'',20X,'
        FCELB( 59: 89) = '''b  ='',F9.3,5X,''beta   ='',F8.2)'
        FCELC(  1: 28) = '( ''c ='',F9.4,''('',I3,'')'',26X,'
        FCELC( 29: 58) = '''gamma ='',F9.3,''('',I3,'')'',20X,'
        FCELC( 59: 89) = '''c  ='',F9.3,5X,''gamma  ='',F8.2)'
        FCELV(  1: 40) = '( ''V ='',F9.2,''('',I3,'') Cubic-Angstrom'','
        FCELV( 41: 64) = '10X,''d(100) ='',F12.4,3X,'
        FCELV( 65: 95) = '''Angstrom'',24X,''Niggli Values'')'
C * CHECK FOR REDUCED CELL IN TRICLINIC
        IF (MODE == 0 .OR. MODE == 1) THEN
C * ALERT _155
          IF (SPGRNM(1)(12:12) == 'a') THEN
            IF (ABS (PAR(101) - PAR(123)) > 0.01 .OR.
     1          ABS (PAR(102) - PAR(124)) > 0.01 .OR.
     2          ABS (PAR(103) - PAR(125)) > 0.01 .OR.
     3          ABS (PAR(104) - PAR(126)) > 0.1  .OR.
     4          ABS (PAR(105) - PAR(127)) > 0.1  .OR.
     5          ABS (PAR(106) - PAR(128)) > 0.1)
     6          CALL PLA236 (155, 0, 1.0, 1.0, ' ', ' ')
          END IF
        END IF
        IF (IGBL(63) > 2) THEN
C * NEWPAGE
          CALL PLA262 (-5)
          WRITE (LU7, 99999, IOSTAT = IOST)
     1      IGBL(4), JID(1:71), DATIJD
        END IF
        IF (IPR(23) /= 0) THEN
          WRITE (LU6, 99995, IOSTAT = IOST) PAR(11)
        ELSE
          WRITE (LU6, 99998, IOSTAT = IOST)
     1      JID(1:70), MAX (PAR(17), 0.0), (PAR(100 + I), I = 1, 6),
     2      PAR(98), SPGRNM(1)(15:26), CHSG
          IPR(83) = 34
          IF (IGBL(63) > 2) THEN
            WRITE (LU7, 99993, IOSTAT = IOST)
     1        SPGRNM(1)(13:13), MAX (0, IPR(310))
            FCELA(12 : 12) = CHAR (ICHAR ('0') + IPR(287))
            FCELA(52 : 52) = CHAR (ICHAR ('0') + IPR(290))
            WRITE (PRBUF, FCELA, IOSTAT = IOST)
     1        PAR(101), IPR(281), PAR(104), IPR(284), PAR(123),
     2        PAR(126), PAR(99)
            CALL GEN065 (LU7, PRBUF, 1, 132, 3)
            FCELB(12 : 12) = CHAR (ICHAR ('0') + IPR(288))
            FCELB(42 : 42) = CHAR (ICHAR ('0') + IPR(291))
            WRITE (PRBUF, FCELB, IOSTAT = IOST)
     1        PAR(102), IPR(282), PAR(105), IPR(285), PAR(124),
     2        PAR(127)
            CALL GEN065 (LU7, PRBUF, 1, 132, 3)
            FCELC(12 : 12) = CHAR (ICHAR ('0') + IPR(289))
            FCELC(42 : 42) = CHAR (ICHAR ('0') + IPR(292))
            WRITE (PRBUF, FCELC, IOSTAT = IOST)
     1        PAR(103), IPR(283), PAR(106), IPR(286), PAR(125),
     2        PAR(128)
            CALL GEN065 (LU7, PRBUF, 1, 132, 3)
            WRITE (LU7, 99991, IOSTAT = IOST)
            FCELV(12 : 12) = CHAR (ICHAR ('0') + IPR(294))
            WRITE (PRBUF, FCELV, IOSTAT = IOST)
     1       PAR(98), IPR(293), 1.0 / PAR(113)
            CALL GEN065 (LU7, PRBUF, 1, 132, 3)
            WAVL = MAX (0.0, PAR(17))
C * LIST REDUCED CELL NIGGLI VALUES
            WRITE (LU7, 99990, IOSTAT = IOST)
     1        1.0 / PAR(114), (PAR(150 + J), J = 1, 3), KRAD,
     2        WAVL, 1.0 / PAR(115), (PAR(150 + J), J = 4, 6)
            CALL PLA262 (1)
            WRITE (LU7, 99997, IOSTAT = IOST)
            WRITE (LU7, 99994, IOSTAT = IOST)
            WRITE (PRBUF, 99989, IOSTAT = IOST) (OR(1, J), J = 1, 3),
     1                           (ROR(1, K), K = 1, 3)
            CALL GEN065 (LU7, PRBUF, 1, 132, 2)
            WRITE (PRBUF, 99988, IOSTAT = IOST) (OR(2, J), J = 1, 3),
     1                           (ROR(2, K), K = 1, 3)
            CALL GEN065 (LU7, PRBUF, 1, 132, 2)
            WRITE (PRBUF, 99987, IOSTAT = IOST) (OR(3, J), J = 1, 3),
     1                           (ROR(3, K), K = 1, 3)
            CALL GEN065 (LU7, PRBUF, 1, 132, 2)
C * OUTPUT SYMMETRY
            IF (MODE == 1 .OR. MODE == 2)  THEN
              WRITE (LU7, 99996, IOSTAT = IOST)
C * FOR CIF2SHELXL ?
C * RELOAD SPACE-GROUP BY NAME FOR CONSISTENCY
              IF (SPGRNM(1)(1:1) /= ' ') THEN
                NRXX = 0
                IF (INDEX (SPGRNM(1)(1:11), ':') /= 0) THEN
                  WRITE (ICL, 99986, IOSTAT = IOST) SPGRNM(1)(1:11)
                ELSE
                  WRITE (ICL, 99985, IOSTAT = IOST)
     1            SPGRNM(1)(1:7)//' '//SPGRNM(1)(8:11)
                  IF (SPGRNM(1)(13:13) /= ' ') ICL(13:13) = '.'
                END IF
                CALL SGSM (0, ICL, SGY, NRXX, LU6, IERR)
              END IF
C * HANDLE NEWPAGE
              CALL SGSM (2, ICL, SGY, 0, LU7, IERR)
              IF (ABS (IGBL(8)) == 3) CALL PLA058 (LU11)
            END IF
          END IF
          IPPR(1, 3) = IPR(48)
        END IF
        IPR(680) = 1
      END IF
      RETURN
99999 FORMAT ('PLATON(V-', I6, ')-Run for: ', A, 9X, 'TIME: ', A, /,
     1 132('='), /, 110X, '(C) 1980-2025 A.L.Spek')
99998 FORMAT (/, ':: TITL ', A, /, ':: LAMBDA', F10.5, /,
     1        ':: CELL ', 3F10.4, 3F10.3, F10.1, /,
     2        ':: SPGR ', A, 2X, A)
99997 FORMAT (48X, 26('=')/, 47('='), ' Orthogonalization Matrices ',
     1 57('='), /, 48X, 26('='))
99996 FORMAT (/, 50X, 20('='), /, 49('='), ' Space Group Symmetry ',
     1 61('='), /, 50X, 20('='), //, '(See e.g. G. Burns & A.M. ',
     2 'Glazer, Space Groups for Solid State Scientists, ',
     3 'Academic Press, 1990 or Int. Tables A)', /)
99995 FORMAT (':: Angstrom Coordinate Data Scale = ', F10.4, /)
99994 FORMAT (/, '(See e.g. J.D.Dunitz, Xray Analysis and Structure',
     1 ' Determination of Organic Molecules, Cornell Univ. Press,',
     2 ' 1979, P236)', /)
99993 FORMAT (55X, 12('='), /, 54('='), ' Crystal Data ', 64('='), /,
     1 55X, 12('=') / 24X, 'Input Cell', 2X, '(Lattice Type: ', A1,')',
     2 3X, '-   Temp =', I4, 'K', 13X, 'Reduced Cell', 5X,
     3 '(Acta Cryst.(1976),A32,297-298)', /, 81('-'), 3X, 48('-'))
99991 FORMAT (1X)
99990 FORMAT (42X, 'd(010) =', F12.4, 26X, 3F10.3, /,
     1        'Lambda(', A, ') =', F10.5, ' Angstrom', 9X,
     2        'd(001) =', F12.4, 26X, 3F10.3, /)
99989 FORMAT ('(XO)   (', 3F10.5, ' ) (X)   ,   (X)   (', 3F10.5,
     1 ' ) (XO)', 5X, ' Orthogonal Axes AO, BO and CO')
99988 FORMAT ('(YO) = (', 3F10.5, ' )*(Y)   ,   (Y) = (', 3F10.5,
     1 ' )*(YO)', 13X, 'are defined as:')
99987 FORMAT ('(ZO)   (', 3F10.5, ' ) (Z)   ,   (Z)   (', 3F10.5,
     1 ' ) (ZO)', 5X, 'AO // A, CO // C*, BO // CO X AO')
99986 FORMAT ('SPGR ', A, 64X)
99985 FORMAT ('SPGR ', A, 63X)
      END SUBROUTINE PLA042
 
      SUBROUTINE PLA043 (MODE, ITYPE, LU, NWIN)
C * SYMMETRY CODE LISTING
      USE files
      USE parameters
      USE plato
      USE atomdata
      USE cchar
      USE xwdw
      USE sgxyz
      IMPLICIT NONE
      INTEGER :: I
      INTEGER :: J
      INTEGER :: K
      INTEGER :: LU
      INTEGER :: N0
      INTEGER :: N1
      INTEGER :: N2
      INTEGER :: N3
      INTEGER :: ML
      INTEGER :: IER
      INTEGER :: IHOR
      INTEGER :: IRS0
      INTEGER :: MOL1
      INTEGER :: MOL2
      INTEGER :: MOL3
      INTEGER :: MOL4
      INTEGER :: MODE
      INTEGER :: NWIN
      INTEGER :: NMOL
      INTEGER :: ITYPE
      INTEGER :: NPRNT
      REAL :: XML
      REAL :: YML
      REAL :: HOR
      CHARACTER(len=3)  :: ILTR
      CHARACTER(len=46) :: FORMA
      CHARACTER(len=13) :: CFXML
      FORMA(1:33)  = '(A,''['',F9.2,''] = '',A,'' = [ '',5I3,'
      FORMA(34:46) = ''' ] '',3F11.3)'
      IHOR  = -1
      IF (IWIN == 1) THEN
        IF (NWIN == 1) CALL GGIP (HORS, VERT, 0.0, 1)
        IF (ITYPE /= 0) VRT = VERT - 0.6
      END IF
      IF (ITYPE == 0) THEN
        FORMA(8:11) = 'F7.0'
      ELSE
        IF (PAR(42) < 100.0) FORMA(11:11) = '1'
      END IF
C * ITYPE =  1 - INTER PRINT MODE
C * ITYPE =  0 - HBOND-TYPE
C * ITYPE = -1 - PUB-TYPE MODE
C * ITYPE = -2 -     ,,   SHORT PRINT
C * PRINT Asymmetric Residue Unit CODE LIST
      IF (MODE >= 0) THEN
        NMOL = IPR(13)
        IF (NMOL > 1) THEN
          NPRNT = 0
          DO 10 I = 1, NMOL
            IF (ITYPE == 0) THEN
              IF (MP(I) == 0) GO TO 10
            END IF
            ML = MOL(I)
C * NO ML = 0
            IF (ML /= 0) THEN
              XML = ML / PAR(42)
C * ELIMINATE DUPLICATES FOR TYPE <= 0
              IF (I > 1 .AND. ITYPE <= 0) THEN
                XML = INT (XML)
                DO J = 1, I - 1
                  IF (MP(J) == 1) THEN
                    YML = INT (MOL(J) / PAR(42))
                    IF (XML == YML) GO TO 10
                  END IF
                END DO
              END IF
              CALL GEN098 (ML, PAR(42), MOL1, MOL2, MOL3, MOL4, IRS0)
              IF (IRS0 > 0) THEN
                IF (MOL1 > IPR(48)) THEN
                  IF (I == (IPR(13) - IPR(101) + 1) .AND.
     1                      IGBL(63) > 2) THEN
                    IF (LU == LU7) CALL PLA262 (4)
                    WRITE (LU, 99996, IOSTAT = IOST)
                  END IF
                  MOL1 = MOL1 - IPR(48)
                  ILTR = '* ='
                  XML  = XML - IPR(48) * 1000
                END IF
                IF (I > 1) THEN
                  IF (IPR(17) == 0 .OR. ITYPE < 0) THEN
                    IF (I <= 27) THEN
                      ILTR = CHAR (ICHAR ('a') + I - 2)//' ='
                    ELSE
                      ILTR = '* ='
                    END IF
                  ELSE
                    ILTR = '   '
                  END IF
                  CALL SGSM (2, ICL, SGY, 0, 0, IERR)
                  SGY(4) = MOL2
                  SGY(5) = MOL3
                  SGY(6) = MOL4
C * GET SYMMETRY CODE STRING
                  CALL SGSM (20, ICL, SGY, MOL1, 0, IERR)
                  DO K = 1, 3
                    SGY(K) = RCG(K, IRS0)
                  END DO
                  CALL SGSM (3, ICL, SGY, MOL1, LU, IERR)
                  IF (IGBL(63) > 2) THEN
                    IF (NPRNT == 0 .AND. LU > 0) THEN
                      IF (ITYPE == 1) THEN
                        IF (LU == LU7) CALL PLA262 (7)
                        WRITE (LU, 99998, IOSTAT = IOST)
                      ELSE IF (ITYPE == 0) THEN
                        IF (LU == LU7) CALL PLA262 (3)
                        WRITE (LU, 99997, IOSTAT = IOST)
                      END IF
                      NPRNT = 1
                    END IF
                  END IF
                  IF (IGBL(63) > 2 .OR. LU /= LU7) THEN
                    CALL GEN020 (-1, ICL, 1, 33)
C * GET CIF-SYMMETRY CODE
                    IF (IABS (IGBL(8)) == 3) THEN
                      CALL PLA273 (1, XML, N0, N1, N2, N3, IER)
                      WRITE (CFXML, 99994, IOSTAT = IOST)
     1                  N0,N1+5,N2+5,N3+5
                    ELSE
                      CFXML = ' '
                    END IF
                    WRITE (PRBUF, FORMA, IOSTAT = IOST)
     1                ILTR, XML, CFXML//ICL(1:33), MOL1, MOL2, MOL3,
     2                MOL4, IRS0, (SGY(K), K = 7, 9)
                    CALL GEN065 (0, PRBUF, 1, 132, 7)
                    IF (LU == LU7) CALL PLA262 (1)
                    IF (ITYPE == 1) THEN
                      WRITE (LU, 99995, IOSTAT = IOST) PRBUF
                    ELSE
                      IF (LU > 0) THEN
                        WRITE (LU, 99995, IOSTAT = IOST) PRBUF(1:49)
                        IF (IWIN == 1 .AND. ITYPE /= 0) THEN
                          VRT = VRT - 0.45
                          CALL PLA439 (0.0, PRBUF, 50, 0.30,
     1                                 5 + IGBL(68), 2, 1.0, VRT)
                        END IF
                      ELSE
C * HBOND-TYPE
                        IF (IWIN == 1) THEN
                          IHOR = MOD (IHOR + 1, 2)
                          IF (IHOR == 0) VRT  = VRT - 0.45
                          HOR = IHOR * HORS / 2 + 0.35
                          CALL PLA439 (0.0, PRBUF, 49, 0.28, 1, 2,
     1                                 HOR, VRT)
                        END IF
                      END IF
                    END IF
                  END IF
                END IF
              END IF
            END IF
   10     CONTINUE
          IF (LU == 0 .AND. NMOL > 0) VRT = VRT - 0.5
          IF (ITYPE == 1 .AND. IGBL(63) > 2) THEN
            IF (LU == LU7) CALL PLA262 (7)
            WRITE (LU, 99999, IOSTAT = IOST)
          END IF
C * OUTPUT NETWORK ANALYSIS RESULT
          IF (MODE /= 0) CALL PLA094 (0, 0, 0, 0, 0, 0)
        END IF
      END IF
      RETURN
99999 FORMAT (/, 'Note: Symmetry Operations Refer to the Coordinates ',
     1 'listed in the Fractional Coordinate Table given above',
     2 //, 65X, 'SYM', 9X, '-  Number of the Symmetry Operator.',
     3 /, 'X(J) = X(sym) + TX , Y(J) = Y(sym) + TY , ',
     4 'Z(J) = Z(sym) + TZ,', 4X, 'Ires', 8X, '-  Residue Number.', /,
     5 65X, 'TX, TY, TZ  -  Unit Cell Translations.')
99998 FORMAT (/, 42X, 'Asymmetric Residue Unit (= ARU) Code List', /,
     1 42X, 41('='), //, 5X, 'ARU-Code', 4X, 'CIF-sym-Code', 2X,
     2 'Symmetry-Code', 24X, 'sym TX TY TZ', ' Ires', 6X, 'x(cen)',
     3  5X, 'y(cen)', 5X, 'z(cen)', /, 132('-'))
99997 FORMAT (/, 'Translation of ARU-Code to CIF and Equivalent ',
     1        'Position Code', /, 59('='))
99996 FORMAT (/, 37X, 'Detected and Excluded Disorder Asymmetric ',
     1 'Residue Units', /, 37X, 55('='), /)
99995 FORMAT (A)
99994 FORMAT ('[',I4,'_',3I1,  '] = ')
      END SUBROUTINE PLA043
 
      SUBROUTINE PLA044 (R, IAT, XR, YR, ZR, SX, SY, SZ, SC, SXY)
C * ROTATION SUPPORT
      USE plato
      USE sgxyz
      IMPLICIT NONE
      INTEGER :: N
      INTEGER :: IAT
      REAL :: XR
      REAL :: YR
      REAL :: ZR
      REAL :: SX
      REAL :: SY
      REAL :: SZ
      REAL :: SC
      REAL :: SXY
      REAL :: XOR
      REAL :: YOR
      REAL :: ZOR
      REAL, DIMENSION(3, 3) :: R
C * FIND PROJECTION OF ORIGIN ON THE L.S.-PLANE AND ROTATE
      IF (IAT < 0) THEN
        N   = - IAT
        XOR = XLS(1, N) * XLS(4, N)
        YOR = XLS(2, N) * XLS(4, N)
        ZOR = XLS(3, N) * XLS(4, N)
      ELSE
        XOR = XXO(IAT, 4)
        YOR = XXO(IAT, 5)
        ZOR = XXO(IAT, 6)
      END IF
      XR = SC * (R(1, 1) * XOR + R(1, 2) * YOR + R(1,3) * ZOR -SX) + SXY
      YR = SC * (R(2, 1) * XOR + R(2, 2) * YOR + R(2,3) * ZOR -SY) + SXY
      ZR = SC * (R(3, 1) * XOR + R(3, 2) * YOR + R(3,3) * ZOR -SZ) + SXY
      RETURN
      END SUBROUTINE PLA044
 
      SUBROUTINE PLA045 (NTYP)
C * LS-PLANE HANDLING
      USE files
      USE parameters
      USE plato
      USE sgxyz
      IMPLICIT NONE
      INTEGER :: I
      INTEGER :: J
      INTEGER :: K
      INTEGER :: L4
      INTEGER :: NTYP
      INTEGER :: NMAX
      INTEGER :: IPR52
      INTEGER :: IYUNK
      REAL :: DET
      REAL :: DMIN
      REAL :: TEMP
C * TEST WHETHER THIS IS A NEW LS-PLANE
      IF (IPR(52) < NP2) THEN
        NMAX  = IPR(39)
        IPR52 = IPR(52)
        CALL PLA054 (0)
        DO I = 1, 4
          XLS(I, IPR52 + 1) = XPV(I)
        END DO
        IF (NTYP == 1) THEN
          IF (IPR52 > 0) THEN
            DO J = 1, IPR52
              DMIN = 0
              DO K = 1, 4
                DMIN = DMIN + ABS (XLS(K, IPR52 + 1) - XLS(K, J))
              END DO
              IF (DMIN < 0.00001) RETURN
            END DO
          END IF
        END IF
        CALL GEN022 (IATP, 1, NMAX, 1)
        IPR(52) = IPR(52) + 1
        IF (NTYP == 3) THEN
          CALL GEN004 (ROR, DUMV, ORRES)
          CALL GEN003 (ORRES, RMAT, DET, 0)
        END IF
        CALL GEN005 (DUMV, RMAT)
        DO K = 1, 3
          TEMP = RMAT(1, K)
          RMAT(1, K) = - RMAT(3, K)
          RMAT(3, K) = TEMP
        END DO
C * COUNT NUMBER OF RINGS
        IF (NTYP == 2) THEN
          IPR(69)  = IPR(69) + 1
          IF (IPR(12) > 4 .AND. IPR(12) < 8) THEN
            IYUNK = 2 * (IPR(12) - 5)
            IPR(496) = IPR(496) + 10 ** IYUNK
          END IF
        END IF
        WRITE (LU8) NTYP, IPR(12), JR, RMAT
        WRITE (LU8) (IATP(L4), L4 = 1, IPR(39))
      END IF
      RETURN
      END SUBROUTINE PLA045
 
      SUBROUTINE PLA046 (MODUS, NQ, IENM, LBB, LBC, LBD, INQNR, JNQNR,
     1                   NIEN)
C * PACK ATOMLABEL INTO UNIQUE INTEGER VALUE: NQ ----> INQNR
      USE parameters
      USE plato
      USE atomdata
      USE cchar
      USE sgxyz
      IMPLICIT NONE
      INTEGER :: I
      INTEGER :: J
      INTEGER :: K
      INTEGER :: L
      INTEGER :: M
      INTEGER :: N
      INTEGER :: KL
      INTEGER :: NB
      INTEGER :: NE
      INTEGER :: NR
      INTEGER :: NQX
      INTEGER :: NCH
      INTEGER :: NAT
      INTEGER :: LBA
      INTEGER :: LBB
      INTEGER :: LBC
      INTEGER :: LBD
      INTEGER :: LEV
      INTEGER :: LBB1
      INTEGER :: ITEL
      INTEGER :: NIEN
      INTEGER :: MODE
      INTEGER :: MODX
      INTEGER :: IENM
      INTEGER :: MODUS
      INTEGER :: INQNR
      INTEGER :: JNQNR
      INTEGER :: MSUBST
      CHARACTER(len=*) :: NQ
      CHARACTER(len=1) :: ICH = ' '
      CHARACTER(len=2) :: NQJ = '  '
C * MODE = 10 : PLUTON/PACK-MODE
C * MODE =  9 : PLUTON/PACK-MODE
C * MODE =  8 : PLUTON/SPLIT-MODE
C * MODE =  4 : GIVE SERIAL NUMBER IN EXP+CG'S ATOM ARRAY FOR NQ IN NIEN
C * MODE =  3 : GIVE SERIAL NUMBER IN EXPANDED ATOM ARRAY FOR NQ IN NIEN
C * MODE =  2 : GIVE SERIAL NUMBER IN PRIMARY  ATOM ARRAY FOR NQ IN NIEN
C * MODE =  1 : ONE SYMMETRY CHARACTER EXTENSION ALLOWED
C * MODE =  0 :  ,,    ,,       ,,         ,,    NOT ALLOWED
C * MODE = -1 : GENERATE UNIQUE LABEL
C * MODE = -2 : SAME AS 2 WITHOUT DETACH OF _nr
C * SPLIT ATOM LABEL INTO THE FOUR COMPONENTS
C * IENM         - ELEMENT NUMBER (IN IEN(1:IAN) ARRAY)
C * LBB          - NUMERICAL PART (NEGATIVE FOR ELEMENT NAME ONLY)
C * LBC          - SEMI-NUMERICAL PART
C * LBD          - SYMMETRY CHARACTER NUMBER
C * NIEN         - SERIAL NUMBER IN ATOM ARRAY (NEGATIVE = ERROR)
C * IEN(1:NP10)  - SFAC POINTER ARRAY INTO IEL & ELB
C * IENS(1:NP10) - SFAC POINTER ARRAY INTO LMT
C * IEL(1:NP9)   - NUMERICAL CODE FOR UPPERCASE ELEMENT LABELS (e.g. 119)
C * ELB(1:NP9)   - TWo LETTER ELEMENT LABELS (e.g. As)
C * LMT(1:NP9)   - SFAC LABELS
C * ERROR CODES
C * NIEN =  -1 - UNKNOWN ELEMENT TYPE
C * NIEN =  -2 - TOO MANY ATOM TYPES FOR PLUTON
C * NIEN =  -3 -
C * NIEN =  -4 -
C * NIEN =  -5 -
C * NIEN =  -6 -
C * NIEN =  -7 -
C * NIEN =  -8 - ATOM TYPE NOT HO
C * NIEN =  -9 - QUOTE IN LABEL
C * NIEN = -10 -
C * NIEN = -11 - UNDERSCORE IN LABEL
C * NIEN = -12 -
C * NIEN = -13
C * NIEN = -14 - '*' CHARACTER IN LABEL
C * NIEN = -15 - TOO MANY CHARACTER IN LABEL
      MODE = MODUS
      MODX = 0
      NAT  = 0
      K    = 0
      IF (MODUS > 98) THEN
        IF (MODUS == 100) THEN
          IF (INDEX (NQ, '#') /= 0) THEN
            NIEN = -8
            RETURN
          END IF
        END IF
        MODE = MODUS - 100
        MODX = 1
      END IF
      IF (MODE /= -1) THEN
C * HANDLE '_nr' NOT DETACH/DETACH
        IF (MODE == -2) THEN
          N    = 0
          MODE = 2
        ELSE
          N = INDEX (NQ, '_')
C * HANDLE DOUBLE UNDERSCORE CASE (e.g. C7_1_A)
          IF (N < NP64 - 2) THEN
            M = INDEX (NQ(N + 1 : NP64), '_')
            N = N + M
          END IF
          IF (N < NP64) THEN
            IF (N > 0) THEN
              ICH = NQ(N + 1 : N + 1)
              DO I = 1, 10
                IF (ICH == CHAR (ICHAR ('0') + I - 1)) THEN
                  N = 0
                  GO TO 10
                END IF
              END DO
C * SEPARATE AND STORE SYMMETRY PART FROM THE LABEL ROOT
              NQJ    = NQ(N : N + 1)
              NQ(N:) = ' '
            END IF
          ELSE
            NIEN = -15
            RETURN
          END IF
        END IF
C * SUBSTITUTE PREVIOUSLY GENERATED & STORED  ALIASES
C * CHECK FOR NON-ZERO NUMBER OF ALIASES
   10   IF (IPR(759) > 0) THEN
          MSUBST = 0
          CALL PLA281 (1, NQ, MSUBST)
          IF (N > 0) THEN
            M = INDEX (NQ, ' ')
            NQ(M:) = NQJ
          END IF
          IF (MSUBST > 0) GO TO 30
        END IF
        IF (N > 0) NQ(N:) = NQJ
      END IF
 
C * CHECK/ALIAS CIF FOR HO & HN for H on O or H on N (NOT FOR ELD+GEOMFILE)
      IF (MODX == 1 .AND.
     1  (IABS(IGBL(8)) == 1 .OR. IABS(IGBL(8)) == 3)) THEN
C * UPPER CASE SECOND CHARACTER IN LABEL
        CALL GEN020 (1, NQ, 2, 2)
        KL = IPR(220)
C * FIND OUT ABOUT ONE OR TWO LETTER ATOM TYPE
        IF (KL == 3) THEN
          IF (IFL(3)(2:2) == ' ') THEN
            N = 1
          ELSE
            N = 2
          END IF
C * UPPER CASE SECOND CHARACTER IN LABEL
          CALL GEN020 (1, IFL(3), 2, 2)
          IF (NQ(1:N) == IFL(3)(1:N)) THEN
C * CHECK FOR UPPERCASE CHARACTER
            IF (N == 1) THEN
              IF (ICHAR (NQ(2:2)) >= 65 .AND. ICHAR (NQ(2:2)) <= 90)
     1          GO TO 20
            END IF
          ELSE
            GO TO 20
          END IF
        END IF
        IF (NQ(1:2) == 'HO' .AND. IPR(435) == 0) THEN
          GO TO 20
        ELSE IF (NQ(1:2) == 'HN') THEN
          GO TO 20
        ELSE IF (NQ(2:2) == '0') THEN
          GO TO 20
        ELSE IF (NQ(2:3) == '00') THEN
          GO TO 20
        ELSE
          GO TO 30
        END IF
   20   IF (KL == 3) THEN
          IF (IFL(3)(1:2) /= 'HO') THEN
            NIEN = -8
            RETURN
          ELSE
            IPR(435) = 1
          END IF
        END IF
      END IF
   30 NR    = 0
      LBA   = 0
      LBC   = 0
      NCH   = 0
      ITEL  = 0
      NIEN  = 0
      INQNR = 0
      JNQNR = 0
C * CHECK FOR PLUTON/SPLIT MODE
      IF (MODE == 8)  THEN
        LBB = -1
        LBD = 27
      ELSE
        LBB = 0
        LBD = 0
      END IF
C * LABEL PHASE 1(2)3
      LEV = 1
      NB  = 1
      NE  = NP64
      CALL GEN039 (1, NQ, 1, NP64, NB, NE)
C * LOOP OVER CHARACTERS IN LABEL
      DO 40 I = 1, NE
        ICH = NQ(I : I)
C * IDENTIFY SPECIAL *, (, ), _, ' , " , \, AND # SYMBOLS
C * CHECK FOR \
        IF (ICH == '*') THEN
          NIEN = -14
          RETURN
        ELSE IF (ICH == CHAR (92)) THEN
          NIEN = -10
          RETURN
        ELSE IF (ICH == '(')  THEN
          LBB = 0
          LEV = 2
        ELSE IF (ICH == ')') THEN
          LEV = 4
        ELSE IF (ICH == '_') THEN
          IF (MODE /= 0) THEN
            LEV = 4
          ELSE
            NIEN = -11
            RETURN
          END IF
        ELSE IF (ICH == '''') THEN
          IF (LBC == 0) THEN
            LBC = 1
            LEV = 3
          ELSE
            NIEN = -9
            RETURN
          END IF
        ELSE IF (ICH == '"') THEN
          IF (LBC == 0) THEN
            LBC = 2
            LEV = 3
          ELSE
            NIEN = -9
            RETURN
          END IF
        ELSE IF (ICH == '#') THEN
          IF (MODE > 0) THEN
            LBC = 3
            LEV = 3
          ELSE
            GO TO 50
          END IF
        ELSE
C * IS THIS AN ALPHABETIC CHARACTER ?
          DO J = 1, 26
            IF (ICH == CHAR (ICHAR ('A') + J - 1) .OR.
     1          ICH == CHAR (ICHAR ('a') + J - 1)) THEN
C * EL-TYPE SYMBOL LEVEL
              IF (LEV == 1) THEN
                NR = NR + 1
                IF (NR == 1) THEN
                  NQJ = ' '//CHAR (ICHAR ('A') + J - 1)
                  LBA = J * 100
                ELSE IF (NR == 2) THEN
                  NQJ(1:1) = NQJ(2:2)
                  NQJ(2:2) = CHAR (ICHAR ('a') + J - 1)
                  LBA      = LBA + J
                ELSE
                  LBA = -1
                  GO TO 50
                END IF
                GO TO 40
C * NUM LEVEL (CHAR)
              ELSE IF (LEV == 2) THEN
                IF (NCH == 0 .AND. LBC == 0 .AND.
     1              IGBL(61) == 0) THEN
                  NCH = NCH + 1
                  LBC = 3 + J
                  LEV = 3
                ELSE
                  NIEN = -8
                  RETURN
                END IF
              ELSE IF (LEV == 3) THEN
                NIEN = -8
                RETURN
              ELSE
                IF (MODE <= 0) THEN
                  GO TO 50
                ELSE
                  LBD = J
                  GO TO 40
                END IF
              END IF
            END IF
          END DO
C * LOOK FOR NUMERIC CHARACTERS
          DO J = 1, 10
            IF (ICH == CHAR (ICHAR ('0') + J - 1)) THEN
              IF (LEV <= 2) THEN
                IF (MODE == 8 .AND. LBB == -1) LBB = 0
                LBB  = LBB * 10 + J - 1
                IF (LBB == 0) THEN
                  NIEN = -13
                  NQ(I:) = ' '
                  RETURN
                END IF
                ITEL = ITEL + 1
                LEV  = 2
                GO TO 40
              ELSE
                NIEN = -8
                RETURN
              END IF
            END IF
          END DO
        END IF
   40 CONTINUE
C * COUNT # OF CHARACTERS
   50 ITEL = ITEL + NR
      IF (LBC > 0)  ITEL = ITEL + 1
      IENM = 0
C * FIRST LOOP OVER CURRENT ATOM-TYPE LIST
      IF (IAN > 0) THEN
        DO I = 1, IAN
          IF (LBA == IEL(IEN(I))) THEN
            IENM = I
            EXIT
          END IF
        END DO
      END IF
      IF (IENM == 0) THEN
        K = 0
        DO I = 1, NP9
          IF (LBA == IEL(I)) THEN
            K = I
            EXIT
          END IF
        END DO
      END IF
      IF (IABS (IGBL(8)) == 1) THEN
        IF (MODE == 9) K = 0
        KL = IPR(220)
      END IF
      IF (MODE == 8) THEN
        IF (IENM > 0) RETURN
        IF (K >= NP9 - 3 .AND. K <= NP9) IENM = K
      ELSE IF (MODE < 8) THEN
        IF (IENM == 0) THEN
C * TEST FOR IGBL(8) = 2 (SHELX-RES-FORMAT)
          IF (IABS (IGBL(8)) /= 2 .OR. NQJ == 'Cg' .OR.
     1      NQJ == ' Q') THEN
            IF (K > 0) THEN
              IAN = IAN + 1
              IF (IAN > NP10) THEN
                NIEN = -2
                RETURN
              END IF
              IEN(IAN)    = K
              L           = IABS (IATPR(K))
              LMT(IAN, 2) = JTP(L)
C * SECOND CHARACTER OF ATOM TYPE (IF ANY) IS MODIFIED TO LOWER CASE
              LMT(IAN,  1) = NQJ
              RADR(IAN, 3) = REL(K)
              RADR(IAN, 4) = ABS (VDWR(K))
              IF (K == 3) THEN
                IACL(IAN) = 2
              ELSE IF (K == 4) THEN
                IACL(IAN) = 4
              ELSE IF (IATPR(K) == -7) THEN
                IACL(IAN) = 3
              ELSE IF (K > 2) THEN
                IF (ICLR < 8) ICLR = ICLR + 1
                IACL(IAN) = ICLR
              END IF
              IENM = IAN
            END IF
          ELSE
            NIEN = -3
            RETURN
          END IF
        END IF
        IF (IENM <= 0) THEN
          NIEN = -5
          RETURN
        END IF
        IF (MODE < 0 .OR. (MODE == 0 .AND. ITEL > 4)) THEN
C * ADD HASH (#) CHARACTER TO LABEL
          LBC  = 3
          ITEL = 3
          IF (MOD(LBA, 100) /= 0) ITEL = ITEL + 1
C * CHECK AGAINST MAXIMUM NUMBER OF DIMENSIONED ALIASES
          IF (IPR(759) >= NP36) THEN
            NIEN = -7
            RETURN
          END IF
C * COUNT PER ELEMENT
          IENLB(IENM) = IENLB(IENM) + 1
          LBB         = IENLB(IENM)
          IF (LBB >= 10)   ITEL = ITEL + 1
          IF (LBB >= 100)  ITEL = ITEL + 1
          IF (LBB >= 1000) ITEL = ITEL + 1
          IF (LBB > 9999 .AND. IGBL(61) == 0) THEN
            NIEN = -12
            RETURN
          END IF
C * SET PARENTHESES OFF
          IF (ITEL > 4) IPR(71) = 0
        END IF
C * LABEL PACKING CONSTANTS
        JNQNR = ((120 - IATNR(IEN(IENM))) * 10000  + LBB) * 40 + LBC
        IF (IGBL(61) == 0) THEN
          IF (LBC > 0) LBC = LBC + 10
C * NR = 1 OR 2 (= # ELEMENT CHARACTERS)
          IF (LBB >= 10 ** (5 - NR) .AND. LBC == 0) THEN
            LBB1 = LBB / 10
            LBC  = LBB - LBB1 * 10 + 1
            LBB  = LBB1
          END IF
          NQX = LBB * 40 + LBC
        ELSE
          NQX = LBB * 4 + LBC
        END IF
        IF (LBD >= 128) THEN
          NIEN = -6
          RETURN
        END IF
        INQNR = (IENM * 400000 + NQX) * 128 + LBD
C * RETURN ELEMENT TYPE, ATOM # OR ERROR CODE
        IF (MODE > 1) THEN
          IF (MODE == 2) THEN
            NAT = IPR(37)
          ELSE IF (MODE == 3) THEN
            NAT = IPR(39)
          ELSE IF (MODE == 4) THEN
            NAT = IPR(39) + IPR(64)
          END IF
          DO I = 1, NAT
            IF (INQNR == LABA(I)) THEN
              NIEN = I
              RETURN
            END IF
          END DO
          NIEN = - 4
        ELSE
          NIEN = IENM - 1
        END IF
C * PLUTON PACK MODE
      ELSE IF (MODE == 9 .OR. MODE == 10) THEN
        IF (IENM == 0) THEN
          IF (K == 0) THEN
            NIEN = -1
            RETURN
          ELSE
            IAN = IAN + 1
            IF (IAN > NP10) THEN
              NIEN = -2
              RETURN
            END IF
            RADR(IAN, 3) = REL(K)
            RADR(IAN, 4) = ABS (VDWR(K))
            IEN(IAN) = K
            IENM     = IAN
          END IF
        END IF
        IF (ITEL > 4 .OR. MODE == 10) THEN
          LBC         = 3
          IENLB(IENM) = IENLB(IENM) + 1
          LBB         = IENLB(IENM)
        END IF
        NQX   = LBB * 32 + LBC
        INQNR = (IENM - 1) * 64000 + NQX
        JNQNR = (120 - IATNR(IEN(IENM))) * 64000 + NQX
      END IF
      RETURN
      END SUBROUTINE PLA046
 
      SUBROUTINE PLA047 (INQNR, NQ, MN, IENR, IPAR, IALIAS, IPDB, IMU)
C * RECOVER ATOMLABEL : INQNR ----> NQ (IN-/EXCLUDING PARENTHESES)
      USE parameters
      USE atomdata
      IMPLICIT NONE
      INTEGER :: I
      INTEGER :: J
      INTEGER :: K = 0
      INTEGER :: L
      INTEGER :: M
      INTEGER :: N
      INTEGER :: J1
      INTEGER :: J2
      INTEGER :: MN
      INTEGER :: J3
      INTEGER :: IMU
      INTEGER :: JX1
      INTEGER :: JX2
      INTEGER :: JX3
      INTEGER :: JX4
      INTEGER :: IENR
      INTEGER :: IPAR
      INTEGER :: JPAR
      INTEGER :: IPDB
      INTEGER :: IALIAS
      INTEGER :: INQNR
      INTEGER, DIMENSION(4) :: NUM
      CHARACTER(len=*)    :: NQ
      CHARACTER(len=NP64) :: NQL1
      CHARACTER(len=NP64) :: NQL2
      CHARACTER(len=NP64) :: NQL3
C * THE MOLECULE NUMBER IS IN MN
C * NO SYMMETRY CHARACTER IN CASE OF INQNR < 0
C * IPAR =  0 : NO PARENTHESES
C * IPAR =  1 :    PARENTHESES
C * IPAR = -1 : NO PARENTHESES & NO UNDERSCORE
C * IPDB =  0 : NO SPECIAL HANDLING
      JPAR = IPAR
      IF (IGBL(71) > 0 .AND. IALIAS == 0 .AND. JPAR == 1) JPAR = 0
      NQ   = ' '
      NQL3 = ' '
      IENR = 0
      MN   = 0
C * LABEL PACKING CONSTANTS
C * SPLIT INQNR INTO JX1, JX2, JX3, JX4
      JX3 = ABS(INQNR)
      IF (JX3 > 0) THEN
        JX1 = JX3 / 51200000
        JX3 = MOD (JX3, 51200000)
        JX2 = JX3 / 128
        JX3 = MOD (JX3, 128)
        IF (IGBL(61) == 0) THEN
          JX4 = MOD (JX2, 40)
          JX2 = JX2 / 40
          IF (JX4 > 0 .AND. JX4 < 11) THEN
            JX2 = JX2 * 10 + JX4 - 1
            JX4 = 0
          ELSE
            JX4 = JX4 - 10
          END IF
        ELSE
          JX4 = MOD (JX2, 4)
          JX2 = JX2 / 4
        END IF
        MN = JX3 + 1
        IF (JX2 == 0) JPAR = MIN (JPAR, 0)
        IF (INQNR  < 0) JX3  = 0
        IENR = IEN(JX1)
        JX1  = IEL(IENR)
        J1   = JX1 / 100
        J2   = MOD (JX1, 100)
        K    = 1
        IF (IPDB == 1 .AND. J2 == 0) K = 2
        NQL3(K : K) = CHAR (ICHAR ('A') + J1 - 1)
        K = K + 1
        IF (J2 > 0) THEN
          IF (IPDB <= 0) THEN
            NQL3(K : K) = CHAR (ICHAR ('a') + J2 - 1)
          ELSE
            NQL3(K : K) = CHAR (ICHAR ('A') + J2 - 1)
          END IF
          K = K + 1
        END IF
        IF (JPAR > 0) THEN
          NQL3(K : K) = '('
          K = K + 1
        END IF
C * NUMBER JX2 MAY BE IN THE RANGE 0:9999 : GENERATE UP TO 3 CHARACTERS
        J2     = JX2 / 10
        NUM(4) = MOD (JX2, 10)
        J3     = J2 / 10
        NUM(3) = MOD (J2, 10)
        NUM(1) = J3 / 10
        NUM(2) = MOD (J3, 10)
        J2     = 0
        DO J = 1,  4
          IF (NUM(J) > 0 .OR. J2 > 0) THEN
            NQL3(K : K) = CHAR (ICHAR ('0') + NUM(J))
            K  = K  + 1
            J2 = J2 + 1
          END IF
        END DO
        IF (JX4 > 0) THEN
C * OPTIONALLY ADD ' AND " etc.
          IF (JX4 == 1) THEN
            NQL3(K : K) = ''''
          ELSE IF (JX4 == 2) THEN
            NQL3(K : K) = '"'
          ELSE IF (JX4 == 3) THEN
            NQL3(K : K) = '#'
          ELSE IF (JX4 > 3) THEN
            NQL3(K : K) = CHAR (ICHAR ('A') + JX4 - 4)
          END IF
          K = K  + 1
        END IF
C * ADD CLOSE PARENTHESIS
        IF (JPAR > 0) THEN
          NQL3(K : K) = ')'
          K = K + 1
        END IF
C * HANDLE SYMMETRY CHARACTER
        IF (JX3 > 0) THEN
C * ADD UNDERSCORE BETWEEN ELEMENT AND SYMMETRY SYMBOL WHEN APPLICABLE
          IF (JPAR == 0) THEN
            NQL3(K : K) = '_'
            K          = K + 1
          END IF
          IF (JX3 < 27) THEN
            NQL3(K : K) = CHAR (ICHAR ('a') + JX3 - 1)
          ELSE
            NQL3(K : K) = '*'
          END IF
          K = K + 1
        END IF
        NQL3(K : K) = ' '
      END IF
C * SUBSTITUTE ALIASES BY ORIGINALS
      IF (K > 1 .AND. IPR(759) > 0 .AND. IALIAS == 0) THEN
        NQL1 = NQL3(1:K)
        L  = K
        IF (JX3 > 0) THEN
          L = L - 1
          NQL3(L:L) = ' '
          IF (JPAR == 0) L = L - 1
          NQL3(L:L) = ' '
        END IF
        DO I = 1, IPR(759)
C * TEST FOR AUTORENUM
          IF (IPR(501) == 0) THEN
            N = INDEX (BLAB(I), '#')
          ELSE
            N = INDEX (BLAB(I), ' ')
          END IF
          IF (N > 0) THEN
            IF (NQL3(1:N) == BLAB(I)(1:N)) THEN
              M  = INDEX (ALAB(I), ' ')
              IF (M == 0) THEN
                M = NP64
              ELSE
                M = M - 1
              END IF
              IF (IMU == 0) THEN
                IF (INDEX (ALAB(I), '_') /= 0) THEN
                  NQ = NQL1
                  RETURN
                END IF
              END IF
              IF (M < 1 .OR. M > (NP64 + L - K)) THEN
                NQ = NQL1
              ELSE
                NQL2 = ALAB(I)(1:M)//NQL1(L:K)
                CALL GEN020 (-1, NQL3, 1, 2)
                IF (NQL2(1:2) == NQL3(1:2)) NQL2(1:2) = BLAB(I)(1:2)
                NQ = NQL2
              END IF
              RETURN
            END IF
          END IF
        END DO
        NQ = NQL1
      ELSE
        NQ = NQL3
      END IF
      RETURN
      END SUBROUTINE PLA047
 
      SUBROUTINE PLA048
C * ANALYSE RING INTERACTIONS
      USE files
      USE parameters
      USE plato
      USE atomdata
      USE cchar
      USE sgxyz
      IMPLICIT NONE
      INTEGER :: I
      INTEGER :: J
      INTEGER :: K
      INTEGER :: L
      INTEGER :: M
      INTEGER :: N
      INTEGER :: I1
      INTEGER :: J1
      INTEGER :: NC
      INTEGER :: NR
      INTEGER :: NS
      INTEGER :: MET
      INTEGER :: IER
      INTEGER :: NDC
      INTEGER :: NPL
      INTEGER :: NSM
      INTEGER :: NSYM
      INTEGER :: NTMP
      INTEGER :: NDCJ
      INTEGER :: NDEC
      INTEGER :: MODE
      INTEGER :: IDUM
      INTEGER :: IRES
      INTEGER :: IVAL
      INTEGER :: NBEG
      INTEGER :: JBEG
      INTEGER :: JDUM
      INTEGER :: JEND
      INTEGER :: JRES
      INTEGER :: NEND
      INTEGER :: NHAT
      INTEGER :: NMAX
      INTEGER :: NPL5
      INTEGER :: NPL8
      INTEGER :: NPRT
      INTEGER :: NTMPC
      INTEGER :: NRING
      INTEGER :: NDEC0
      INTEGER :: NDEC1
      INTEGER :: NDEC2
      INTEGER :: NDEC3
      INTEGER :: IRMST
      INTEGER :: NDECJ
      INTEGER :: NEWTMP
      INTEGER :: NDECA1
      INTEGER :: ISANG1
      INTEGER :: IDIST2
      INTEGER :: IDIST3
      INTEGER :: ISDIST1
      INTEGER :: ISDIST3
      INTEGER, DIMENSION(6) :: ICSD
      REAL :: DUM
      REAL :: ANG1
      REAL :: ANG2
      REAL :: ANG3
      REAL :: ANG4
      REAL :: ARUJ
      REAL :: DMIN
      REAL :: DMAX
      REAL :: YUNK
      REAL :: ANG2M
      REAL :: ANG3M
      REAL :: SANG1
      REAL :: DIST1
      REAL :: DIST2
      REAL :: DIST3
      REAL :: DIST4
      REAL :: SDIST1
      REAL :: SDIST2
      REAL :: SDIST3
      REAL :: GEN009
      REAL :: GEN027
      REAL, DIMENSION(3, 3) :: B
      REAL, DIMENSION(3, 3) :: C
      REAL, DIMENSION(3)    :: UVIJ
      CHARACTER(len=119) :: FORMI
      CHARACTER(len=116) :: FORMJ
      CHARACTER(len=120) :: FORMK
      FORMI( 1:31)   = '(A           ,F10.6,''('',I4,'')'','
      FORMI(32:68)   = 'F10.6,''('',I4,'')'',F10.6,''('',I4,'')'',7X,'
      FORMI(69:119)  = FORMI(15:64)//')'
      FORMJ(1:30)    = '(A,''-'',A,''['',I2,''] -> '',A,''['','
      FORMJ(31:69)   = 'F9.2,'']'',F7.3,''('',I3,'')  '',3F7.4, F9.4,'
      FORMJ(70:95)   = 'F7.3,F7.2,F8.2,''('',I3,'')'','
      FORMJ(96:116)  = 'F8.4,''('',I3,'')'',F7.0)'
      FORMK(1:33)    = '(A,''['',I2,''] -> '',A,''['',F9.2,'']'','
      FORMK(34:70)   = 'F7.4,''('',I3,'') '',3F7.4,F9.4,F6.2,''('','
      FORMK(71:108)  = 'I2,'')'',2F6.1,F7.4,''('',I3,'')'',F7.4,''('','
      FORMK(109:120) = 'I3,'')'',F8.3)'
      DMIN  = 0.0
      ANG2M = 0.0
      NTMP  = 0
      NPRT  = 0
C * SUBROUTINE ANALYZES FOR SHORT Y-X/METAL/RING - RING INTERACTIONS:
C * MODE = 1 : CG-CG
C * MODE = 2 : CG-METAL
C * MODE = 3 : METAL-GG COORDINATION
C * MODE = 4 : X-H..CG INTERACTIONS
C * MODE = 5 : Y-X..CG INTERACTIONS
      NSYM    = IPR(48)
      NRING   = IPR(64)
      NMAX    = IPR(39)
      IRMST   = 0
      ISANG1  = 0
      ISDIST1 = 0
      ISDIST3 = 0
      NDEC0   = 0
      NDEC1   = 0
      NDEC3   = 0
      SANG1   = 0
      SDIST1  = 0
      SDIST3  = 0
      DIST4   = 0.0
C * LOOP OVER RING INTERACTION TYPES
      DO MODE = 1, 5
        CALL PLA097 (0, 0.0)
C * FIND SHORT DISTANCES BETWEEN CG's - ROLLETT, COMP. METH. IN CRYST. 1965
        IF (MODE == 1) THEN
          DMAX = PAR(36)
          DMIN = 2.5
        ELSE IF (MODE == 2) THEN
          DMAX = PAR(69)
          DMIN = 2.0
          ANG2M = 45.0
        ELSE IF (MODE == 3) THEN
          DMAX = 3.0
          DMIN = 1.5
C * C-H..Pi
        ELSE IF (MODE == 4) THEN
          DMAX  = PAR(263)
          DMIN  = 2.0
          ANG3M = PAR(264)
        ELSE IF (MODE == 5) THEN
          DMAX = PAR(447)
          DMIN = 2.5
          ANG3M = PAR(448)
        END IF
        DO I = 1, 3
          V3(I) = DMAX * PAR(112 + I)
        END DO
C * FIRST (N)-LOOP
C * MODE < 3 : LOOP OVER RINGS
C * MODE > 2 : LOOP OVER ATOMS
        IF (MODE > 2) THEN
          NBEG = 1
          NEND = IPR(37)
          NTMP = 0
          NPRT = 0
        ELSE
C * RING COORDINATES FOLLOW LAST REGULAR ATOM
          NBEG = NMAX + 1
          NEND = NMAX + NRING
        END IF
        NR = 0
C * N-LOOP
        DO 80 N = NBEG, NEND
          NEWTMP = NMAX + NRING
C * TEST FOR METAL
          CALL GEN048 (-1, IFG(1, N), 19, MET)
C * TEST FOR H-ATOM
          CALL GEN048 (-1, IFG(1, N), 7, NHAT)
C * METAL
          IF (MODE == 3) THEN
            IF (MET == 0) GO TO 80
            NTMP = 0
C * X-H
          ELSE IF (MODE == 4) THEN
            IF (NHAT == 0) GO TO 80
            NTMP = 0
C * Y-X
          ELSE IF (MODE == 5) THEN
            IF (NINT (CON(N, 9)) /= -1 .OR.
     1          MET /= 0 .OR. NHAT /= 0) GO TO 80
            NTMP = 0
          END IF
C * GET ARU FOR THIS HATOM/METAL/RING/OTHER SINGLE BONDED ATOM
          CALL GEN048 (-6, IFG(1, N), 9, IRES)
C * GET LABEL FOR THIS HATOM/METAL/RING CG
          CALL PLA047 (LABA(N), NQ1, IDUM, JDUM, IPR(71),
     1      IGBL(55), 0, 1 - IGBL(55))
C * SECOND (J)-LOOP
C * MODE /= 2 : LOOP OVER RINGS
C * MODE == 2 : LOOP OVER ATOMS
          IF (MODE == 2) THEN
            JBEG = 1
            JEND = IPR(37)
          ELSE
            JBEG = NMAX + 1
            JEND = NMAX + NRING
          END IF
C * J-LOOP
          DO 60 J = JBEG, JEND
            IF (MODE == 2) THEN
C * TEST FOR METAL
              CALL GEN048 (-1, IFG(1, J), 19, MET)
              IF (MET == 0) GO TO 60
            END IF
C * GET RESIDUE NUMBER
            CALL GEN048 (-6, IFG(1, J), 9, JRES)
            DO 50 NSM = 1, NSYM
              DO I = 1, 3
                SGX(I)     = XXO(J, I)
                SGX(I + 3) = 0.0
                V4(I)      = 0.0
              END DO
              NS = NSM
              CALL SGSM (3, LINE, SGX, NS, 6, IERR)
              IF (MODE == 3 .AND. NSM == 1) THEN
                K = 3
                GO TO 40
              ELSE
                K = 1
              END IF
C * TRANSLATE SGX ON AXIS K TO A POINT BELOW LOWER LIMIT
   10         IF ((XXO(N, K) - SGX(6 + K)) > V3(K)) GO TO 30
              SGX(6 + K) = SGX(6 + K) - 1.0
              V4(K)      = V4(K) - 1.0
              GO TO 10
   20         K = K - 1
C * ADVANCE ONE UNIT ON AXIS KAX
   30         SGX(6 + K) = SGX(6 + K) + 1.0
              V4(K)      = V4(K) + 1.0
              IF ((XXO(N, K)  - SGX(6 + K)) >= V3(K)) GO TO 30
              IF ((SGX(6 + K) - XXO(N, K))  <= V3(K)) GO TO 40
C * TEST GIVES ATOM OUT OF RANGE - REDUCE AXIS K BY ONE
              K = K - 1
C * K = 0 SIGNALS END OF TRANSLATION SEARCH
              IF (K > 0) THEN
                GO TO 30
              ELSE
                GO TO 50
              END IF
C * IF SGX WAS WITHIN RANGE ON AXIS K THEN WE ADVANCE K BY 1
   40         K = K + 1
              IF (K > 3) THEN
                DO L = 1, 3
                  V5(L) = SGX(6 + L) - XXO(N, L)
                END DO
                CALL GEN002 (1, OR, V5, V6, DUM)
C * GET UNIT-VECTOR ALONG Cg-Cg/Me
                CALL GEN002 (2, OR, V5, V7, DIST1)
C * TEMP FIX
                IF (IATP(N) <= 0) THEN
                  WRITE (LU6, 99993, IOSTAT = IOST) IATP(N)
                  RETURN
                END IF
                IF (DIST1 < DMAX .AND. DIST1 > DMIN) THEN
C * STORE COORDINATES NEW POSITIONS TEMPORARILY
                  NEWTMP = NEWTMP + 1
C * TEMP FIX
                  IF (NEWTMP == 0) GO TO 20
                  IPR(54) = NS
                  DO I = 1, 3
                    ITR(I) = NINT (V4(I))
                  END DO
                  CALL PLA059 (J, NEWTMP)
                  DO I = 1, 3
                    IFG(I, NEWTMP) = IFG(I, J)
                  END DO
                  IF (MODE < 3) THEN
                    NPL = IPR(19) + IATP(N)
C * TEMP FIX
                    IF (NPL > NP2) THEN
                      WRITE (LU6, 99993, IOSTAT = IOST) IATP(N)
                      RETURN
                    END IF
                    CALL PLA056 (XLS(1, NPL), NEWTMP, DIST3, SDIST3,
     1                IDIST3, 4, NDEC3)
                  END IF
C * AVOID 'FLAT' COORDINATION CASES (TEST DIST ATOM N TO PLANE J
                  IF (MODE == 3) THEN
                    IF (IATP(J) > 0) THEN
                      NPL = IPR(19) + IATP(J)
C * TEMP FIX
                      IF (NPL > NP2) THEN
                        WRITE (LU6, 99993, IOSTAT = IOST) IATP(J)
                        RETURN
                      END IF
                      DIST3 = ABS (XLS(1, NPL) * XXO(N, 4)
     1                      + XLS(2, NPL)      * XXO(N, 5)
     2                      + XLS(3, NPL)      * XXO(N, 6)
     3                      - XLS(4, NPL))
                      IF (ABS (DIST3) < DMIN) THEN
                        NEWTMP = NEWTMP -1
                        GO TO 60
                      END IF
                    END IF
                  END IF
C * GENERATE ARU
                  ARUJ = NS * 1000.0 + V4(1) * 100 + V4(2) * 10 + V4(3)
     1                 + 555 + JRES / PAR(42)
C * GET LABEL
                  CALL PLA047 (LABA(J), NQ2, IDUM, JDUM, IPR(71),
     1                         IGBL(55), 0, 0)
                  LABA(NEWTMP) = LABA(J)
                  IF (MODE < 3) THEN
C * NORMAL TO PLANE N
                    NPL8 = IPR(19) + IATP(N)
                    V8(1) = XLS(1, NPL8)
                    V8(2) = XLS(2, NPL8)
                    V8(3) = XLS(3, NPL8)
C * CALCULATE BETA = ANGLE BETWEEN NORMAL AND CG-Cg(Me)
                    ANG2  = GEN027 (V8, V7, RGBL(6))
                    IF (ANG2 > 90.0) ANG2 = 180.0 - ANG2
                  END IF
                  IF (MODE == 1 .OR. MODE == 4
     1                            .OR. MODE == 5) THEN
C * TEMPERARY PROBLEM FIX
                    IF (IATP(J) <= 0 .OR. IATP(J) > NP2) THEN
                      WRITE (LU6, 99993, IOSTAT = IOST) IATP(J)
                      RETURN
                    END IF
                    NPL5  = IPR(19) + IATP(J)
                    V5(1) = XLS(1, NPL5)
                    V5(2) = XLS(2, NPL5)
                    V5(3) = XLS(3, NPL5)
                    V1(4) = XLS(4, NPL5)
C * GET SYMMETRY MATRIX
                    CALL SGSM (6, LINE, SGZ, NS, 6, IERR)
                    M = 0
                    DO I1 = 1, 3
                      V2(I1) = V4(I1) + SGZ(I1 + 9)
                      DO J1 = 1, 3
                        M           = M + 1
                        UIJ(I1, J1) = SGZ(M)
                      END DO
                    END DO
C * CALCULATE P' = P O R-1 O-1 = TR(TR(O-1) R TR(O) p)
                    CALL GEN005 (OR, B)
                    CALL GEN004 (UIJ, B, C)
                    CALL GEN005 (ROR, B)
                    CALL GEN004 (B, C, UIJ)
                    CALL GEN002 (1, UIJ, V5, V1, DUM)
C * CALCULATE R'
                    CALL GEN002 (-1, OR, V1, V6, DUM)
                    V1(4) = V1(4) + GEN009(V6, V2)
                    ANG3  = GEN027 (V1, V7, RGBL(6))
                    IF (ANG3 > 90.0) ANG3 = 180.0 - ANG3
                    CALL PLA056 (V1, N, DIST2, SDIST2, IDIST2, 4, NDEC2)
C * HANDLE ALPHA
                    ANG1  = GEN027 (V8, V1, RGBL(6))
                    IF (ANG1 > 90.0) ANG1 = 180.0 - ANG1
                    SANG1 = 0.0
                    IF (MODE == 1) THEN
                      SANG1 = XLS(5, NPL8)**2 + XLS(5, NPL5)**2
     1                      + XLS(6, NPL8)**2 + XLS(6, NPL5)**2
     2                      + XLS(7, NPL8)**2 + XLS(7, NPL5)**2
                      SANG1 = RGBL(6) * SQRT (SANG1)
                      IF (SANG1 > 0.0001 .AND. SANG1 < 0.9) THEN
                        CALL GEN041 (ANG1, SANG1, ISANG1, 2,
     1                    NDECA1, IPR(68))
                      ELSE
                        SANG1  = 0.0
                        ISANG1 = 0
                        NDECA1 = 0
                      END IF
                      IF (ANG2 < PAR(62)) THEN
                        NR = NR + 1
                        IF (NR == 1) THEN
                          CALL PLA262 (-14)
                          WRITE (LU7, 99999, IOSTAT = IOST)
     1                      PAR(36), PAR(427), PAR(62)
                          CALL GEN074 (DUMA, 1, 6, 99999.0)
                          DUMA(4) = 0.0
                        END IF
                        CALL PLA053 (N, NEWTMP, 0, 0, DIST1, SDIST1,
     1                               ISDIST1, NDEC1, IER)
                        IF (IER /= 0) DIST1 = 0.0
                        FORMK(37:37)   = CHAR (ICHAR ('0') + NDEC1)
                        FORMK(65:65)   = CHAR (ICHAR ('0') + NDECA1)
                        FORMK(87:87)   = CHAR (ICHAR ('0') + NDEC2)
                        FORMK(103:103) = CHAR (ICHAR ('0') + NDEC3)
C * Cg-Cg Interaction Geometry
                        IF (ANG1 < PAR(427)) THEN
                          DIST4 = DIST1 * SIN (ANG2 / RGBL(6))
                          WRITE (PRBUF, FORMK, IOSTAT = IOST)
     1                      NQ1(1:7), IRES, NQ2(1:7), ARUJ, DIST1,
     2                      ISDIST1, (V1(L), L = 1, 4), ANG1, ISANG1,
     3                      ANG2, ANG3, ABS (DIST2), IDIST2, ABS (DIST3)
     4                      , IDIST3, DIST4
                        ELSE
                          WRITE (PRBUF, FORMK, IOSTAT = IOST)
     1                      NQ1(1:7), IRES, NQ2(1:7), ARUJ, DIST1,
     2                      ISDIST1, (V1(L), L = 1, 4), ANG1, ISANG1,
     3                      ANG2, ANG3, ABS (DIST2), IDIST2,
     4                      ABS (DIST3), IDIST3
                        END IF
                        CALL PLA263 (LU7, PRBUF, 132, 1, 3)
                        CALL PLA097 (1, ARUJ)
                        DUMA(1) = MIN (DUMA(1), DIST1)
                        DUMA(2) = MIN (DUMA(2), ANG1)
                        DUMA(3) = MIN (DUMA(3), ANG2)
                        DUMA(4) = MAX (DUMA(4), ANG3)
                        DUMA(5) = MIN (DUMA(5), DIST2)
                        DUMA(6) = MIN (DUMA(6), DIST3)
                      END IF
                    ELSE
C * MODE = 4 & MODE = 5
                      IF (ANG3 < ANG3M) THEN
C * DETERMINE X ON H (Y on X)
                        IF (NINT (CON(N, 9)) == -1) THEN
                          I = NINT (CON(N, 1))
                          CALL PLA047 (LABA(I), NQ3, IDUM, JDUM,
     1                      IPR(71), IGBL(55), 0, 1 - IGBL(55))
C * UNIT VECTOR ALONG I-N
                          CALL PLA227 (I, N, UVIJ)
                          ANG4  = GEN027 (V1, UVIJ, RGBL(6))
                          IF (ANG4 > 90.0) ANG4 = 180.0 - ANG4
                          ANG4 = 90.0 - ANG4
                          IF (MODE == 4) ANG4 = NINT (ANG4)
C * X-H..Cg Angle
                          CALL PLA053 (I, N, NEWTMP, 0, ANG1, SANG1,
     1                                 ISANG1, NDEC0, IER)
                          IF (IER /= 0) ANG1 = 0
                          IF (ISANG1 == 0) THEN
                            NDEC0 = 0
                            ANG1  = NINT (ANG1)
                          END IF
                          FORMJ(83:83) = CHAR (ICHAR ('0') + NDEC0)
C * H..Cg Dist
                          CALL PLA053 (N, NEWTMP, 0, 0, DIST1, SDIST1,
     1                                 ISDIST1, NDEC1, IER)
                          IF (IER /= 0) DIST1 = 0.0
                          FORMJ(43:43) = CHAR (ICHAR ('0') + NDEC1)
C * X..Cg Dist
                          CALL PLA053 (I, NEWTMP, 0, 0, DIST3, SDIST3,
     1                                 ISDIST3, NDEC3, IER)
                          IF (IER /= 0) DIST3 = 0.0
                          FORMJ(99:99) = CHAR (ICHAR ('0') + NDEC3)
                          NR = NR + 1
                          IF (NR == 1) THEN
                            CALL PLA262 (-12)
                            IF (MODE == 4) THEN
                              WRITE (LU7, 99992, IOSTAT = IOST)
     1                          DMAX, ANG3M
                              WRITE (LU6, 99988, IOSTAT = IOST)
                            ELSE
                              WRITE (LU7, 99998, IOSTAT = IOST)
     1                          DMAX, ANG3M
                              WRITE (LU6, 99986, IOSTAT = IOST)
                            END IF
                            CALL GEN074 (DUMA, 1, 5, 99999.0)
                            DUMA(4) = 0.0
                            DUMA(6) = 0.0
                          END IF
                          IF (MODE == 5) THEN
                            FORMJ(73:73)   = '3'
                            FORMJ(112:115) = 'F7.2'
                            WRITE (PRBUF, FORMJ, IOSTAT = IOST)
     1                        NQ3(1:7), NQ1(1:7), IRES, NQ2(1:7), ARUJ,
     2                        DIST1, ISDIST1, (V1(L), L = 1, 4), DIST2,
     3                        ANG3, ANG1, ISANG1, DIST3, ISDIST3, ANG4
                          ELSE
                            FORMJ(73:73)   = '2'
                            FORMJ(112:115) = 'I7  '
                            WRITE (PRBUF, FORMJ, IOSTAT = IOST)
     1                        NQ3(1:7), NQ1(1:7), IRES, NQ2(1:7), ARUJ,
     2                        DIST1, ISDIST1, (V1(L), L = 1, 4), DIST2,
     3                        ANG3, ANG1, ISANG1, DIST3, ISDIST3,
     4                        NINT (ANG4)
                          END IF
                          CALL PLA263 (LU7, PRBUF, 132, 1, 3)
                          WRITE (LU6, 99987) PRBUF(1:54), ANG3
                          CALL PLA097 (1, ARUJ)
                          DUMA(1) = MIN (DUMA(1), DIST1)
                          DUMA(2) = MIN (DUMA(2), DIST2)
                          DUMA(5) = MIN (DUMA(5), DIST3)
                          DUMA(3) = MIN (DUMA(3), ANG3)
                          DUMA(4) = MAX (DUMA(4), ANG1)
                          DUMA(6) = MAX (DUMA(6), ANG4)
                        END IF
                      END IF
                    END IF
                  ELSE IF (MODE == 2) THEN
                    IF (ANG2 < ANG2M) THEN
                      NR = NR + 1
                      IF (NR == 1) THEN
                         CALL PLA262 (8)
                         WRITE (LU7, 99997, IOSTAT = IOST) DMAX
                      END IF
                      CALL PLA262 (1)
                      WRITE (LU7, 99996, IOSTAT = IOST)
     1                  NQ1(1:7), IRES, NQ2(1:7), ARUJ, DIST1, DIST3,
     2                  ANG2
                      CALL PLA097 (1, ARUJ)
                    END IF
                  ELSE IF (MODE == 3) THEN
                    IF (NTMP < 8) THEN
                      NTMP       = NTMP + 1
                      IATC(NTMP) = NEWTMP
                    ELSE
                      IRMST = IRMST + 1
                    END IF
                  END IF
                END IF
                GO TO 20
              END IF
              GO TO 10
   50       CONTINUE
   60     CONTINUE
          IF (MODE == 3) THEN
            IF (NTMP > 0) THEN
C * SAVE TEMPORARILY
              DO I = 1, 9
                DATC(I) = CON(N, I)
              END DO
              NC = - NINT (CON(N, 9))
              IF (NC < 0) THEN
                NC = 9
                CALL GEN048 (-1, IFG(1, N), 8, IVAL)
                IF (IVAL > 0) NC = NC + IPR(76)
              END IF
              DO I = 1, NTMP
                CON(N, I) = IATC(I)
              END DO
              NTMPC = NTMP
              DO 70 I = 1, NC
                IF (I <= 9) THEN
                  K = NINT (DATC(I))
                ELSE
                  IF (IBON(I - 9, 1) /= N) GO TO 70
                  K = IBON(I - 9, 2)
                END IF
                DO L = 1, NTMPC
                  CALL PLA050 (IATC(L), K, 0, 0, DIST2)
                  IF (DIST2 < 1.5) GO TO 70
                END DO
                IF (NTMP < 9 - 1) THEN
                  NTMP = NTMP + 1
                  CON(N, NTMP) = K
                ELSE
                  IRMST = IRMST + 1
                END IF
   70         CONTINUE
              CON(N, 9) = - NTMP
              IF (NPRT == 0) THEN
                CALL PLA262 (0)
                NPRT = 1
                CALL PLA262 (3)
                WRITE (LU7, 99995, IOSTAT = IOST)
              END IF
              IPR(81) = 2
              IFL(2)  = NQ1
              CALL PLA440 (0)
              DO I = 1, 9
                CON(N, I) = DATC(I)
              END DO
            END IF
          END IF
   80   CONTINUE
C * LIST EXTREMA
        IF (MODE == 1 .AND. NR > 0) THEN
          CALL PLA262 (2)
          WRITE (LU7, 99989, IOSTAT = IOST) (DUMA(L), L = 1, 6)
        ELSE IF ((MODE == 4 .OR. MODE == 5) .AND. NR > 0) THEN
          CALL PLA262 (2)
          WRITE (LU7, 99990, IOSTAT = IOST) (DUMA(L), L = 1, 6)
        END IF
        CALL PLA097 (-1, 0.0)
      END DO
C * LIST CG(I)
      CALL PLA262 (5)
      WRITE (LU7, 99991, IOSTAT = IOST)
      DO I = NMAX + 1, NMAX + NRING
        CALL PLA262 (1)
C * ROUND AND PRINT CENTROID COORDINATES
        DO K = 1, 3
          YUNK = SQRT (XSD(I, K))
          CALL GEN041 (XXO(I, K), YUNK, ICSD(K), IPR(183),
     1                 NDEC, IPR(68))
          NDC  = K * 17 + 2
          YUNK = SQRT (XSD(I, K + 3))
          CALL GEN041 (XXO(I, K + 3), YUNK, ICSD(K + 3), 5, NDECJ,
     1       IPR(68))
C * MODIFY NUMBER OF DECIMAL DIGITS
          NDCJ             = K * 17 + 56
          FORMI(NDC:NDC)   = CHAR (ICHAR ('0') + NDEC)
          FORMI(NDCJ:NDCJ) = CHAR (ICHAR ('0') + NDECJ)
          ICSD(K)          = MIN (99, ICSD(K))
          ICSD(K + 3)      = MIN (99, ICSD(K + 3))
        END DO
        CALL PLA047 (LABA(I), NQ2, IDUM, JDUM, IPR(71),
     1                         IGBL(55), 0, 0)
        WRITE (PRBUF, FORMI, IOSTAT = IOST)
     1    NQ2(1:6), (XXO(I, K), ICSD(K), K = 1, 6)
        CALL PLA263 (LU7, PRBUF, 132, 1, 3)
      END DO
      IF (IRMST > 0) THEN
        WRITE (LU6, 99994, IOSTAT = IOST)
        WRITE (LU7, 99994, IOSTAT = IOST)
      END IF
      RETURN
99999 FORMAT ('Analysis of Short Ring-Interactions with Cg-Cg ',
     1 'Distances < ', F5.1, ' Ang., Alpha <', F8.3, ' Deg. and Beta <',
     2 F5.1, ' Deg.', /, 132('='), /,
     3 '- Cg(I)    = Plane number I (= ring number in () above)', /,
     4 '- Alpha    = Dihedral Angle between Planes I and J (Deg)', /,
     5 '- Beta     = Angle Cg(I)-->Cg(J) or ',
     6 'Cg(I)-->Me vector and normal to plane I (Deg)', /,
     7 '- Gamma    = Angle Cg(I)-->Cg(J) vector and normal to',
     8 ' plane J (Deg)', /,
     9 '- Cg-Cg    = Distance between ring Centroids (Ang.)', /,
     * '- CgI_Perp = Perpendicular distance of Cg(I) on',
     1 ' ring J (Ang.)', /,
     2 '- CgJ_Perp = Perpendicular distance of Cg(J) on',
     3 ' ring I (Ang.)', /,
     4 '- Slippage = Distance between Cg(I) and Perpendicular',
     5 ' Projection of Cg(J) on Ring I (Ang).', /,
     6 '- P,Q,R,S  = J-Plane Parameters for Carth. Coord.',
     7 ' (Xo, Yo, Zo)', //, 'Cg(I) Res(I)', 3X,
     8 'Cg(J)  [', 3X, 'ARU(J)] ', 6X, 'Cg-Cg', 1X,
     9 'Transformed J-Plane P, Q, R, S', 5X, 'Alpha', 2X,
     * 'Beta', 1X, 'Gamma', 4X, 'CgI_Perp    CgJ_Perp  Slippage', /)
99998 FORMAT (/, 'Analysis of Y-X...Cg(Pi-Ring) Interactions',
     1 ' (X..Cg <', F4.1, ' Ang. - Gamma < ', F5.1, ' Deg)', /,
     2         132('='), //, '   Y--X(I)    Res(I)', 3X,
     3 'Cg(J)  [', 3X, 'ARU(J)]', 7X, 'X..Cg', 2X,
     4 'Transformed J-Plane P, Q, R, S  X-Perp Gamma', 6X,
     5 'Y-X..Cg', 8X, 'Y..Cg Y-X,Pi', /)
99997 FORMAT (//, 'Ring-Metal Interactions with Cg-Me < ', F5.1,
     1 ' Ang.', /, 132('='), //,
     2 'Cg(I) Res(I)', 3X, 'Me(J)   [', 3X, 'ARU(J)]  Cg(I)-Me(J)',
     3 ' MeJ_Perp    Beta', /)
99996 FORMAT (A, '[', I2, '] -> ', A, ' [', F9.2, '] ', 2F10.3, F9.2)
99995 FORMAT ('Geometry around Metals Involving Ring centroids', /,
     1        132('='), /)
99994 FORMAT (/, 'W: Ring-Metal Search Truncated', /)
99993 FORMAT (/, 'W: Problem - Ring-(Ring/Metal) search aborted', I5,/)
99992 FORMAT (/, 'Analysis of X-H...Cg(Pi-Ring) Interactions',
     1 ' (H..Cg <', F4.1, ' Ang. - Gamma < ', F5.1, ' Deg)', /,
     2   132('='), /,
     3 '- Cg(J)   = Center of gravity of ring J (Plane number above)', /
     4 , '- H-Perp  = Perpendicular distance of H to ring plane J', /,
     5 '- Gamma   = Angle between Cg-H vector and ring J normal', /,
     6 '- X-H..Cg = X-H-Cg angle (degrees)', /,
     7 '- X..Cg   = Distance of X to Cg (Angstrom)', /,
     8 '- X-H, Pi = Angle of the X-H bond with the Pi-plane (i.e.',
     9 ' Perpendicular = 90 degrees, Parallel = 0 degrees)', //,
     * '   X--H(I)    Res(I)', 3X,
     1 'Cg(J)  [', 3X, 'ARU(J)]', 7X, 'H..Cg', 2X,
     2 'Transformed J-Plane P, Q, R, S  H-Perp Gamma', 6X,
     3 'X-H..Cg', 8X, 'X..Cg X-H,Pi', /)
99991 FORMAT (/, 'The Cg(I) refer to the Ring Centre-of-Gravity ',
     1        'numbers given in () in the Ring-Analysis above', //,
     2        'Cg(I)', 11X, 'x', 15X, 'y', 15X, 'z', 20X,
     3        'Xo', 14X, 'Yo', 14x, 'Zo', /)
99990 FORMAT (43X, 10('-'), 33X, 46('-'), /, 36X, 'Min or Max',
     1        F7.3, 32X, F7.3, F7.1, 5X, F8.2, 5X, F8.3, F7.2)
99989 FORMAT (35X, 10('-'), 33X, 44('-'), /, 28X, 'Min or Max',
     1        F7.3, 35X, 3F6.1, 2F12.3, F8.3)
99988 FORMAT (/, '   X--H(I)    Res(I)', 3X, 'Cg(J)  [', 3X, 'ARU(J)]',
     1       7X, 'H..Cg', 2X, 'Gamma')
99987 FORMAT (A, F6.1)
99986 FORMAT (/, '   Y--X(I)    Res(I)', 3X, 'Cg(J)  [', 3X, 'ARU(J)]',
     1       7X, 'X..Cg', 2X, 'Gamma')
      END SUBROUTINE PLA048
 
      SUBROUTINE PLA049 (IFUN, D)
C * DETERMINE DERIVED PARAMETER ERROR BY ERROR PROPAGATION
      USE plato
      USE sgxyz
      IMPLICIT NONE
      INTEGER :: I
      INTEGER :: J
      INTEGER :: K
      INTEGER :: KM
      INTEGER :: ITP
      INTEGER :: IFUN
      INTEGER :: ITEK
      REAL :: D
      REAL :: SINC
      REAL :: GEN009
      REAL, DIMENSION(8) :: DSV
      REAL, DIMENSION(3) :: VECIJK
      REAL, DIMENSION(3) :: VECIJKD
      KM     = 1
      DSV(1) = D
      DSV(2) = XPV(1)
      IF (IFUN == 2) THEN
        CALL GEN008 (VECIJ, VECJK, VECIJK, 0)
      ELSE IF (IFUN == 4) THEN
C * SAVE XPV TEMPORARILY IN DSV
        DO I = 1, 8
          DSV(I) = XPV(I)
        END DO
        KM = 4
      END IF
      DO I = 1, NDERIV
        ITP = IDIR(I)
        DO J = 1, 3
          ITEK = 1
          SINC = SQRT (XSD(ITP, J + 3))
          XXO(ITP, J + 3) = XXO(ITP, J + 3) + SINC
C * BOND
          IF (IFUN == 1) THEN
            CALL PLA050 (IDIR(1), IDIR(2), 0, 0, XPV(1))
C * ANGLE
          ELSE IF (IFUN == 2) THEN
            CALL PLA050 (IDIR(1), IDIR(2), IDIR(3), 0, XPV(1))
            CALL GEN008 (VECIJ, VECJK, VECIJKD, 0)
            IF (GEN009 (VECIJK, VECIJKD) < 0.0)
     1        XPV(1) = 360.0 - XPV(1)
C * TORSION
          ELSE IF (IFUN == 3) THEN
            CALL PLA050 (IDIR(1), IDIR(2), IDIR(3), IDIR(4), XPV(1))
            IF ((DSV(1) - XPV(1)) > 180.0)  THEN
              XPV(1) = XPV(1) + 360.0
            ELSE IF ((DSV(1) - XPV(1)) < -180.0) THEN
              XPV(1) = XPV(1) - 360.0
            END IF
C * PLANE
          ELSE IF (IFUN == 4) THEN
            CALL PLA054 (0)
            ITEK = NINT(GEN009(XPV, DSV))
          END IF
          XXO(ITP, J + 3) = XXO(ITP, J + 3) - SINC
C * MAKE SURE THAT PLANES ARE ORIENTED SIMILARLY
          DO K = 1, KM
            XDIR(I, J, K) = ITEK * XPV(K) - DSV(K)
          END DO
        END DO
      END DO
      D      = DSV(1)
      XPV(1) = DSV(2)
      IF (IFUN == 4) THEN
        DO I = 1, 8
          XPV(I) = DSV(I)
        END DO
      END IF
      RETURN
      END SUBROUTINE PLA049
 
      SUBROUTINE PLA050 (I, J, K, L, D)
C * DISTANCE, BOND-ANGLE and TORSION ANGLE CALCULATION ROUTINE
      USE files
      USE parameters
      USE plato
      USE sgxyz
      IMPLICIT NONE
      INTEGER :: I
      INTEGER :: J
      INTEGER :: K
      INTEGER :: L
      INTEGER :: M
      INTEGER :: N
      REAL :: D
      REAL :: C
      REAL :: DK
      REAL :: DAB
      REAL :: DAK
      REAL :: DBK
      REAL :: GEN009
      REAL, DIMENSION(3) :: R
      REAL, DIMENSION(3) :: S
      REAL, DIMENSION(3) :: T
      D = 0
      IF ((I > 0 .AND. I <= NP1) .AND.
     1    (J > 0 .AND. J <= NP1)) THEN
        IF (K == 0) THEN
C * CHECK FOR DISTANCE CALCULATION
          DO M = 1, 3
            DK = XXO(I, M + 3) - XXO(J, M + 3)
            D = D + DK**2
          END DO
          D = SQRT(D)
          RETURN
C * CHECK FOR BOND ANGLE CALCULATION
        ELSE IF ((K > 0 .AND. K <= NP1) .AND. L == 0) THEN
          DAK = 0
          DBK = 0
          DAB = 0
          DO M = 1, 3
            VECIJ(M)  = XXO(I, M + 3) - XXO(J, M + 3)
            VECJK(M)  = XXO(K, M + 3) - XXO(J, M + 3)
            DAK       = DAK + VECIJ(M)**2
            DBK       = DBK + VECJK(M)**2
            DAB       = DAB + VECIJ(M)*VECJK(M)
          END DO
          IF (DAK > 0.0 .AND. DBK > 0.0) THEN
            C = DAB / SQRT (DAK * DBK)
            C = MAX (-1.0, MIN (1.0, C))
            D = ACOS(C) * RGBL(6)
          END IF
          RETURN
C * CHECK FOR TORSION ANGLE CALCULATION
        ELSE IF (L > 0 .AND. L <= NP1) THEN
          DO N = 1, 3
            VECIJ(N) = XXO(J, N + 3) - XXO(I, N + 3)
            VECJK(N) = XXO(K, N + 3) - XXO(J, N + 3)
            VECKL(N) = XXO(L, N + 3) - XXO(K, N + 3)
          END DO
          CALL GEN008 (VECIJ, VECJK, R, 1)
          CALL GEN008 (VECJK, VECKL, S, 1)
          CALL GEN008 (R, S, T, 1)
          D = MAX (-1.0, MIN (1.0, GEN009(R, S)))
          D = ACOS (D) * RGBL(6)
          IF (GEN009 (VECJK, T) < 0.0) D = - D
          RETURN
        END IF
      END IF
      WRITE (LU6, 99999, IOSTAT = IOST) I, J, K, L
      WRITE (LU7, 99999, IOSTAT = IOST) I, J, K, L
      RETURN
99999 FORMAT (/, 'F: Invalid arg(s) in call to PLA050 ', 4I8, /)
      END SUBROUTINE PLA050
 
      SUBROUTINE PLA051 (IAT)
C * SET PARAMETERS FOR S.U. CALCULATION
      USE plato
      USE sgxyz
      IMPLICIT NONE
      INTEGER :: I
      INTEGER :: J
      INTEGER :: IAT
      NDERIV       = NDERIV + 1
      IDIR(NDERIV) = IAT
      DO I = 1, 3
        DO J = 1, 4
          XDIR(NDERIV, I, J) = 0.0
        END DO
      END DO
      RETURN
      END SUBROUTINE PLA051
 
      SUBROUTINE PLA052 (IFUN, SD)
C * SET PARAMETERS FOR ESD CALCULATION (LS-PLANE)
      USE plato
      USE sgxyz
      IMPLICIT NONE
      INTEGER :: I
      INTEGER :: J
      INTEGER :: K
      INTEGER :: KM
      INTEGER :: IFUN
      REAL :: YUNK
      REAL, DIMENSION(*) :: SD
      IF (IFUN == 4) THEN
        KM = 4
        DO K = 1, KM
          SD(K) = 0.0
        END DO
      ELSE
        KM    = 1
        SD(1) = 0.0
      END IF
      DO I = 1, NDERIV
        DO J = 1, 3
          DO K = 1, KM
            YUNK = XDIR(I, J, K)
            IF (ABS (YUNK) > 1.0E-15) SD(K) = SD(K) + YUNK**2
          END DO
        END DO
      END DO
      DO K = 1, KM
        SD(K) = SQRT (SD(K))
      END DO
      RETURN
      END SUBROUTINE PLA052
 
      SUBROUTINE PLA053 (I0, J0, K0, L0, D, SD, ISD, NDEC, IER)
C * CALCULATE DISTANCE (MODE = 1 - K0 = 0 & L0 = 0),
C *           ANGLE    (MODE = 2 - L0 = 0) OR
C *           TORSION  (MODE = 3) WITH S.U. (E.S.D.)
      USE parameters
      USE plato
      USE sgxyz
      IMPLICIT NONE
      INTEGER :: I
      INTEGER :: J
      INTEGER :: K
      INTEGER :: L
      INTEGER :: N
      INTEGER :: I0
      INTEGER :: J0
      INTEGER :: K0
      INTEGER :: L0
      INTEGER :: ISD
      INTEGER :: NDEC
      INTEGER :: IER
      INTEGER :: JHAT
      INTEGER :: KHAT
      INTEGER :: LHAT
      INTEGER :: IDUM
      INTEGER :: IHAT
      INTEGER :: IVAL
      INTEGER :: JVAL
      INTEGER :: KVAL
      INTEGER :: MODE
      INTEGER :: NDCD
      INTEGER :: NHAT
      INTEGER :: NRND
      INTEGER :: NOESD
      INTEGER :: IPR68
      INTEGER :: NESDI
      INTEGER :: NESDJ
      INTEGER :: NESDK
      INTEGER :: NESDL
      REAL :: D
      REAL :: SD
      REAL :: D1
      REAL :: SDADD
      REAL :: GEN158
      REAL, DIMENSION(2) :: SDD
      REAL, DIMENSION(3) :: X1
      REAL, DIMENSION(3) :: X2
      REAL, DIMENSION(3) :: X3
      I    = I0
      J    = J0
      K    = K0
      L    = L0
      IHAT = 0
      JHAT = 0
      KHAT = 0
      LHAT = 0
      IER  = 0
C * DEFAULT WITH ESD
      NOESD = 1
      SD    = 0.0
      IF (L < 0) THEN
        L    = -L
        NRND = 1
      ELSE
        NRND = 0
      END IF
      CALL PLA050 (I, J, K, L, D)
C * ATOM I COORDINATE SU'S (ISU) (NO = 0)
      CALL GEN048 (-1, IFG(2, I), 10, NESDI)
      CALL GEN048 (-1, IFG(1, I), 7,  IHAT)
      IF (IHAT == 1) NOESD = MIN (NOESD, NESDI)
C * CHECK WHETHER ATOM IS OMITTED
      IF (NESDI == 1) THEN
        CALL GEN048 (-1, IFG(2, I), 30, IVAL)
        IF (IVAL == 1) NESDI = 0
      END IF
C * ATOM J COORDINATE SU
      CALL GEN048 (-1, IFG(2, J), 10, NESDJ)
      CALL GEN048 (-1, IFG(1, J), 7,  JHAT)
      IF (JHAT == 1) NOESD = MIN (NOESD, NESDJ)
C * CHECK WHETHER ATOM IS OMITTED
      IF (NESDJ == 1) THEN
        CALL GEN048 (-1, IFG(2, J), 30, IVAL)
        IF (IVAL == 1) NESDJ = 0
      END IF
C * CHECK FOR BONDS
      IF (K == 0) THEN
        MODE  = 1
        NDCD  = 4
        NESDK = 0
        NESDL = 0
C * CHECK FOR ANGLES
      ELSE
        CALL GEN048 (-1, IFG(2, K), 10, NESDK)
        CALL GEN048 (-1, IFG(1, K), 7,  KHAT)
        IF (KHAT == 1) NOESD = MIN (NOESD, NESDK)
C * CHECK WHETHER ATOM IS OMITTED
        IF (NESDK == 1) THEN
          CALL GEN048 (-1, IFG(2, K), 30, IVAL)
          IF (IVAL == 1) NESDK = 0
        END IF
        NDCD = 2
        IF (L == 0) THEN
          MODE  = 2
          NESDL = 0
          IF (D < 1.0)  IER = - 1
          CALL GEN048 (-1, IFG(1, I), 5, IVAL)
          CALL GEN048 (-1, IFG(1, J), 6, JVAL)
          CALL GEN048 (-1, IFG(1, K), 5, KVAL)
          IF (ABS (180.0 - D) < 0.05) THEN
            IF (JVAL == 1 .AND. IVAL + KVAL == 1) NOESD = 0
          ELSE IF (ABS (120.0 - D) < 0.05 .OR.
     1             ABS (60.0  - D) < 0.05) THEN
            CALL GEN048 (-1, IFG(1, J), 6, IVAL)
            IF (JVAL == 1 .AND. IVAL + KVAL == 1) THEN
              IF (IPR(259) == 5 .OR. IPR(259) == 6) NOESD = 0
            END IF
          END IF
C * CHECK FOR TORSIONS
        ELSE
          CALL GEN048 (-1, IFG(2, L), 10, NESDL)
          CALL GEN048 (-1, IFG(1, L), 7, LHAT)
          IF (LHAT == 1) NOESD = MIN (NOESD, NESDL)
C * CHECK WHETHER ATOM IS OMITTED
          IF (NESDL == 1) THEN
            CALL GEN048 (-1, IFG(2, L), 30, IVAL)
            IF (IVAL == 1) NESDL = 0
          END IF
          MODE = 3
          CALL PLA050 (I, J, 0, 0, D1)
          IF (D1 < 0.1) IER = - 1
          CALL PLA050 (K, L, 0, 0, D1)
          IF (D1 < 0.1) IER = - 1
          CALL PLA050 (I, K, 0, 0, D1)
          IF (D1 < 0.1) IER = - 1
          CALL PLA050 (J, L, 0, 0, D1)
          IF (D1 < 0.1) IER = - 1
        END IF
      END IF
      IF (NOESD == 1) THEN
        IF (NESDI + NESDJ + NESDK + NESDL /= 0) THEN
          NDERIV = 0
          CALL PLA051 (I)
          CALL PLA051 (J)
          IF (K > 0) CALL PLA051 (K)
          IF (L > 0) CALL PLA051 (L)
          CALL PLA049 (MODE, D)
          CALL PLA052 (MODE, SDD)
        ELSE
          SDD = 0.0
        END IF
C * ADD CELL ERROR CONTRIBUTION TO BOND SU
        IF (K == 0) THEN
          SD = SQRT(SDD(1)**2 + (PAR(13) * D)**2)
C * ADD CELL ERROR CONTRIBUTION TO BOND ANGLE
        ELSE IF (L == 0) THEN
          DO N = 1, 3
             X1(N) = XXO(I, N)
             X2(N) = XXO(J, N)
             X3(N) = XXO(K, N)
          END DO
          SDADD = GEN158(PAR(101), PAR(107), X1, X2, X3)
          IF (SDADD > 0.0) THEN
            SD = SQRT (SDD(1)**2 + SDADD)
          ELSE
            SD = SDD(1)
          END IF
C * ADD CELL ERROR CONTRIBUTION TO TORSION ANGLE
        ELSE
          SD = SQRT (SDD(1)**2 + PAR(14)**2)
        END IF
      END IF
      IDUM = NDCD
      DO
        CALL GEN041 (D, SD, ISD, IDUM, NDEC, IPR(68))
        IF (IPR(68) == 0) THEN
          IF (ISD > 99 .AND. IDUM > 0) THEN
            IDUM = IDUM - 1
            CYCLE
          END IF
          IPR68 = 10
          EXIT
        ELSE
          IPR68 = IPR(68)
          EXIT
        END IF
      END DO
      IF (ISD > IPR68 * 10 - 1) THEN
        ISD  = -1
        NDEC = 0
        SD   = -1.0
      END IF
      IF (ISD == 0 .AND. NRND == 0) THEN
        NHAT = IHAT + JHAT + KHAT + LHAT
        IF (NHAT /= 0) THEN
          IF (MODE == 1) THEN
            NDEC = 2
            D = NINT (D * 100.0) / 100.0
          ELSE
            NDEC = 0
            D    = NINT (D)
          END IF
        END IF
      END IF
      RETURN
      END SUBROUTINE PLA053
 
      SUBROUTINE PLA054 (MODE)
C * CALCULATE THE L.S. PLANE THROUGH NATP ATOMS GIVEN IN IATP
      USE parameters
      USE plato
      USE atomdata
      USE sgxyz
      IMPLICIT NONE
      INTEGER :: I
      INTEGER :: J
      INTEGER :: N
      INTEGER :: KP
      INTEGER :: IVL
      INTEGER :: MODE
      INTEGER :: NMAX
      INTEGER :: IWHT
      REAL :: WM
      REAL :: WHT
      REAL :: GEN009
      REAL, DIMENSION(3, 3) :: A
      REAL, DIMENSION(3)    :: B
      REAL, DIMENSION(3, 3) :: C
      NMAX = IPR(39)
C * THE METHOD IS TO CALCULATE THE PRINCIPLE AXES OF INERTIA -
C * THE L.S.-PLANE IS NORMAL TO THE AXIS OF GREATEST INERTIA.
      WHT = 1.0
      IF (MODE == 1) THEN
        IWHT = 1
      ELSE
        IWHT = IPR(41)
      END IF
C * GET THE MASS CENTRE
      CALL GEN074 (V7, 1, 3, 0.0)
      KP = 0
      WM = 0
      DO N = 1, NMAX
        I = IATP(N)
        IF (I <= NP1) THEN
          IF (IWHT == 1) THEN
            CALL GEN048 (-4, IFG(1, I), 15, IVL)
            WHT = SATWT(IVL + 1)
          ELSE IF (IWHT == 2) THEN
            WHT = 3.0 / (XSD(I, 4) + XSD(I, 5) + XSD(I, 6))
          END IF
          KP = KP + 1
          WM = WM + WHT
          DO J = 1, 3
            V7(J) = V7(J) + WHT * XXO(I, J + 3)
          END DO
        END IF
      END DO
C * WEIGHTED CENTER OF GRAVITY
      DO I = 1, 3
        V7(I) = V7(I) / WM
        DO J = 1, 3
          C(I, J) = 0.0
        END DO
      END DO
C * SET UP THE INERTIAL MATRIX (= C)
      DO N = 1, NMAX
        I = IATP(N)
        IF (I <= NP1) THEN
          IF (IWHT == 1) THEN
            CALL GEN048 (-4, IFG(1, I), 15, IVL)
            WHT = SATWT(IVL + 1)
          ELSE IF (IWHT == 2) THEN
            WHT = 3.0 / (XSD(I, 4) + XSD(I, 5) + XSD(I, 6))
          END IF
          DO J = 1, 3
            B(J) = XXO(I, J + 3) - V7(J)
          END DO
          C(1, 1) = C(1, 1) + WHT * (B(2)**2 + B(3)**2)
          C(1, 2) = C(1, 2) - WHT *  B(1) * B(2)
          C(1, 3) = C(1, 3) - WHT *  B(1) * B(3)
          C(2, 2) = C(2, 2) + WHT * (B(1)**2 + B(3)**2)
          C(2, 3) = C(2, 3) - WHT *  B(2) * B(3)
          C(3, 3) = C(3, 3) + WHT * (B(1)**2 + B(2)**2)
        END IF
      END DO
      CALL GEN024 (C, A, B, DUMV)
C * ARRAY DUMV CONTAINS EIGENVECTORS AS COLUMNS, C  CONTAINS EIGENVALUES
      DO I = 1, 3
        XPV(I)  = DUMV(I, 1)
        DUMA(I) = B(I)
      END DO
C * THE EQUATION OF THE PLANE IS  PV . X = D
C * THE MASS CENTRE LIES ON THE P, SO WE CAN CALCULATE D
      XPV(4) = GEN009(XPV, V7)
      XPV(8) = XPV(4)
      RETURN
      END SUBROUTINE PLA054
 
      SUBROUTINE PLA055
C * LEAST-SQUARES PLANE CALCULATION (WITH S.U.)
      USE parameters
      USE plato
      USE sgxyz
      IMPLICIT NONE
      INTEGER :: I
      INTEGER :: J
      INTEGER :: K
      INTEGER :: N
      INTEGER :: NMAX
      INTEGER :: IATPI
      REAL :: D
      REAL :: XLNG
      REAL :: YUNK
      NMAX = IPR(39)
      CALL PLA054 (0)
      CALL GEN002 (-1, OR, XPV(1), XPV(5), XLNG)
      CALL GEN074 (XSPV, 1, 8, 0.0)
      IF (IPR(72) > 0) THEN
        NDERIV = 0
        N    = 0
        DO I = 1, NMAX
          IATPI = IATP(I)
          IF (IATPI <= NP1) THEN
            N = N + 1
C * DO NOT CALC. PLANE ESD FOR L.S. PLANES THROUGH MORE THAN NP7 ATOMS
            IF (N > NP7) RETURN
            CALL PLA051 (IATPI)
          END IF
        END DO
        D = 0.0
        CALL PLA049 (4, D)
        CALL PLA052 (4, XSPV)
        DO J = 1, 3
          XSPV(4 + J) = 0.0
          DO K = 1, 3
            YUNK = XSPV(K) * OR(K, J)
            IF (ABS (YUNK) > 1.0E-15) THEN
              XSPV(4 + J) = XSPV(4 + J) + YUNK**2
            END IF
          END DO
        END DO
        DO K = 5, 7
          XSPV(K) = SQRT (XSPV(K))
        END DO
        XSPV(8) = XSPV(4)
      END IF
      RETURN
      END SUBROUTINE PLA055
 
      SUBROUTINE PLA056 (PV, IAT, D, SD, ISD, NDECD, NDEC)
C * ROUTINE TO CALCULATE DISTANCE + S.U. OF AN ATOM (IAT) TO A PLANE (PV)
      USE parameters
      USE plato
      USE sgxyz
      IMPLICIT NONE
      INTEGER :: I
      INTEGER :: J
      INTEGER :: IAT
      INTEGER :: ISD
      INTEGER :: NDECD
      INTEGER :: NDEC
      REAL :: D
      REAL :: SD
      REAL :: DAC
      REAL :: DACD
      REAL :: SINC
      REAL, DIMENSION(*) :: PV
      ISD  = 0
      NDEC = NDECD
      SD   = 0.0
C * CALCULATE DISTANCE
      D = - PV(4)
      DO I = 1, 3
        D = D + PV(I) * XXO(IAT, I + 3)
      END DO
C * NUMERICAL PROPAGATION OF ERROR CALCULATION OF S.U.
      IF (IPR(72) /= 0) THEN
        DO I = 1, 3
C * SET INCREMENT AT 1/2 S.U.
          SINC = SQRT (XSD(IAT, I + 3)) / 2.0
          IF (SINC > 0.0) THEN
            XXO(IAT, I + 3) = XXO(IAT, I + 3) + SINC
            DAC = - PV(4)
            DO J = 1, 3
              DAC = DAC + PV(J) * XXO(IAT, J + 3)
            END DO
            XXO(IAT, I + 3) = XXO(IAT, I + 3) - SINC
            DACD = ABS (DAC - D)
            IF (DACD > 0.1E-10) THEN
              SD = SD + (DACD**2) * 4.0
            END IF
          END IF
        END DO
        SD = SQRT (SD)
C * ROUND
        CALL GEN041 (D, SD, ISD, NDECD, NDEC, IPR(68))
      END IF
      RETURN
      END SUBROUTINE PLA056
 
      SUBROUTINE PLA057 (IAT, JAT, KAT)
C * OUTPUT SHORT INTRA/INTER MOLECULAR CONTACTS
      USE files
      USE parameters
      USE plato
      USE atomdata
      USE cchar
      USE sgxyz
      IMPLICIT NONE
      INTEGER :: I
      INTEGER :: J
      INTEGER :: K
      INTEGER :: L
      INTEGER :: N
      INTEGER :: NC
      INTEGER :: MN
      INTEGER :: IAT
      INTEGER :: JAT
      INTEGER :: KAT
      INTEGER :: NCI
      INTEGER :: NCJ
      INTEGER :: IHA
      INTEGER :: IER
      INTEGER :: IAN0
      INTEGER :: IARU
      INTEGER :: IDOA
      INTEGER :: IDOH
      INTEGER :: KDOA
      INTEGER :: KDOH
      INTEGER :: MOL2
      INTEGER :: JNCX
      INTEGER :: INCX
      INTEGER :: IDUM1
      INTEGER :: IDUM2
      INTEGER :: IDUM3
      INTEGER :: IKDOH
      INTEGER :: IPOPI
      INTEGER :: IPR20
      INTEGER :: ISDIJ
      INTEGER :: ISKIP
      INTEGER :: KATHA
      INTEGER :: NATHX
      INTEGER :: NATHY
      INTEGER :: IANGL
      INTEGER :: NDEC1
      INTEGER :: NDEC2
      INTEGER :: NLINE
      INTEGER :: IPOPK
      INTEGER :: IDSORD
      REAL :: X1
      REAL :: X2
      REAL :: X3
      REAL :: X4
      REAL :: SA
      REAL :: DIJ
      REAL :: ANGL
      REAL :: DELT
      REAL :: DMX0
      REAL :: SDIJ
      REAL :: XMOL2
      REAL :: ANGLE
      REAL :: DIJ29
      REAL :: TESTVAL
      CHARACTER(len=2)  :: MARK
      CHARACTER(len=5)  :: IMRK1
      CHARACTER(len=98) :: FORMI
      CHARACTER(len=24) :: FORMJ
      CHARACTER(len=6)  :: FORMK
      CHARACTER(len=9)  :: CXMOL2
      PAGET = 'INTER'
      ANGLE = 0.0
      DIJ   = 0.0
      SDIJ  = 0.0
      NDEC1 = 0
      NDEC2 = 0
      ISDIJ = 0
      NATHX = 0
      NATHY = 0
C * SETUP PRINT FORMATS
      FORMI( 1: 32) = '(   A,1X,''.... '',A,''['',A   ,'']'','
      FORMI(33: 65) = 'F8.3,''('',I3,'')'',A,F5.2,F6.2,1X,A,'
      FORMI(66: 98) = '1X,2(3F7.4,2X),A,F7.2,''('',I3,'')'')'
      FORMJ( 1: 24) = '(112X,A,F7.2,''('',I3,'')'')'
      FORMK( 1: 6 ) = '(F9.2)'
      IF (PAR(42) < 100.0) FORMK(5:5) = '1'
C * OUTPUT OF SHORT CONTACTS
      IF (IPR(90) == 1) THEN
C * HEADER PRINT TEST
        IF (IPR(15) <= 0) THEN
          IF (IPR(15) == 0 .AND. IGBL(63) > 2) THEN
C * NEWPAGE
            CALL PLA262 (-6)
C * LIST CONTACT RADII USED FOR INTER ANALYSES
C * BUT DO NOT INCLUDE 'CG' ENTRY IN LISTING
            IF (LMT(IENS(IAN), 1) == 'Cg') THEN
              IAN0 = IAN - 1
            ELSE
              IAN0 = IAN
            END IF
            WRITE (LU7, 99997, IOSTAT = IOST) PAR(1), PAR(33),
     1        (LMT(IENS(K), 1), K = 1, IAN0)
            WRITE (LU7, 99996, IOSTAT = IOST)
     1       (RADR(IENS(K), 2), K = 1, IAN0)
            IF (IGBL(63) > 3) THEN
              CALL PLA262 (6)
              WRITE (LU7, 99998, IOSTAT = IOST)
            END IF
          END IF
          CALL PLA066 (0, 0, 0, 0, 0.0, 0.0, 0.0, 0.0, 0.0)
C * CALL EXIT/STOP
          IF (IPR(2) /= 0) CALL GEN127 ('302')
C * ARU HEADER PRINT
          PAR(67) = 1555.0 + IPR(61) / PAR(42)
          IF (IPR(75) /= 1 .AND. IGBL(63) > 2) THEN
            CALL PLA262 (6)
            WRITE (LU7, 99999, IOSTAT = IOST) PAR(67)
          END IF
          IF (IGBL(63) > 2) THEN
            CALL PLA262 (3)
            WRITE (LU7, 99995, IOSTAT = IOST) PAR(67)
          END IF
          IPR(15) = 1
        END IF
C * GET LABEL AND DISORDER INFORMATION ON IAT
        CALL PLA036 (IAT, 1, 1, IPOPI, IDUM1, IDUM2, IPR(71), IGBL(55))
        IDSORD = 0
        IF (IPR(67) /= 0) IPOPI = 10000
        IF (IPOPI < 10000) THEN
          IDSORD = IDSORD + 10
          X1 = - IAT
        ELSE
          X1 = IAT
        END IF
        X3  = 0.0
        NCI = - NINT (CON(IAT, 9))
        IF (NCI < 0) NCI = 9
        IF (NCI > 0) THEN
          INCX = NINT (CON(IAT, 1))
          IF (INCX > 0 .AND. INCX <= NP1) THEN
            X3 = INCX
C * GET NUMBER OF ATTACHED H-ATOMS
            CALL GEN048 (-3, IFG(2, INCX), 24, NATHX)
          ELSE
            RETURN
          END IF
        END IF
C * GET LABEL AND DISORDER INFORMATION ON KAT
        CALL PLA036 ( KAT, 1, 4, IPOPK, MN, IDUM2, IPR(71), IGBL(55))
        CALL PLA036 (-KAT, 1, 2, IPOPK, MN, IDUM2, IPR(71), IGBL(55))
        IF (IPOPK < 10000) THEN
          IDSORD = IDSORD + 1
          X2 = - JAT
        ELSE
          X2 = JAT
        END IF
        X4  = 0.0
        NCJ = - NINT (CON(JAT, 9))
        IF (NCJ < 0) NCJ = 9
        IF (NCJ > 0) THEN
          JNCX = NINT (CON(JAT, 1))
          IF (JNCX > 0 .AND. JNCX <= NP1) THEN
            X4 = JNCX
C * GET NUMBER OF ATTACHED H-ATOMS
            CALL GEN048 (-3, IFG(2, JNCX), 24, NATHY)
          ELSE
            RETURN
          END IF
        END IF
        MOL2 = MOL(MN)
        IARU = NINT (PAR(42))
        IF (MOL2 == 1555 * IARU) MOL2 = MOL2 + IPR(62)
        XMOL2 = MOL2 / PAR(42)
        CALL PLA053 (IAT, KAT, 0, 0, DIJ, SDIJ, ISDIJ, NDEC1, IER)
        ISDIJ = MIN (999, ISDIJ)
        MARK  = '  '
        DMX0  = PAR(23) - PAR(1)
        DELT  = DIJ - DMX0
        DIJ29 = DIJ
        IF (DELT < 0) THEN
          DIJ29 = DIJ29 + 100.0
          MARK  = ' <'
          IF (DELT + PAR(1) < 0.0) THEN
C * TEST FOR H-(,D) ATOM
            CALL GEN048 (-1, IFG(1, IAT), 7, IHA)
            CALL GEN048 (-1, IFG(1, KAT), 7, KATHA)
C * TEST FOR D-H(D) ATOM
            CALL GEN048 (-1, IFG(1, IAT), 20, IDOH)
            CALL GEN048 (-1, IFG(1, KAT), 20, KDOH)
C * TEST FOR POTENTIAL ACCEPTOR
            CALL GEN048 (-1, IFG(2, IAT), 28, IDOA)
            CALL GEN048 (-1, IFG(2, KAT), 28, KDOA)
C * REGISTER EXTREME SHORT INTER CONTACTS
            IF (DELT < PAR(199) .AND. IAT < KAT) THEN
              IF ((IDOH == 1 .OR. KDOA == 1) .AND.
     1            (IDOA == 1 .OR. KDOH == 1)) THEN
                IPR(160) = IPR(160) + 1
              END IF
              PAR(200) = MIN (DELT, PAR(200))
            END IF
C * HANDLE SHORT CONTACT
            IF (DELT < PAR(251 + 2 * IPR(20))
     1          .AND. IAT <= JAT) THEN
              IF (IHA == 1 .AND. KATHA == 1 .AND.
     1            (IPOPI == 10000 .OR. IPOPK == 10000)) THEN
C * HANDLE SPECIAL H-X-H CASE WITH NCI OR NCJ > 1)
                ISKIP = 0
                IF (KAT == JAT) THEN
                  DO I = 1, NCI
                    DO J = 1, NCJ
                      IF (NINT (CON(IAT, I)) == NINT (CON(JAT, J)))
     1                  ISKIP = 1
                    END DO
                  END DO
                END IF
                IF (ISKIP == 0) THEN
                  IPR(403 + IPR(20)) = IPR(403 + IPR(20)) + 1
                  PAR(252 + 2 * IPR(20)) =
     1                    MIN (DELT, PAR(252 + 2 * IPR(20)))
                  IPR20 = IPR(20)
                  IKDOH = IDOH + KDOH
                  IF (IKDOH == 0) THEN
                    IF (NATHX == 3 .OR. NATHY == 3)
     1                IPR20 = IPR20 + 2
                  ELSE IF (IKDOH == 1) THEN
                    IPR20 = IPR(20) + 4
                  ELSE IF (IKDOH == 2) THEN
                    IPR20 = IPR(20) + 6
                  END IF
C * ALERT _41x
                  CALL PLA393 (MOL2, PAR(42), IDM)
                  IF (IPOPI < 10000 .OR. IPOPK < 10000) THEN
                    TESTVAL = -999.0
                  ELSE
                    TESTVAL = - DELT
                  ENDIF
                  IF (KDOA > 0) TESTVAL = - 999.0
                  CALL PLA236 (-(410 + IPR20), 2,
     1              TESTVAL, DIJ, NAMS(1, 1)(2:10), NAMS(1, 2)(2:10))
                  CALL PLA236 (0, 0, 0.0, 0.0, IDM, ' ')
                END IF
              END IF
            END IF
            DIJ29 = DIJ29 + 100.0
            MARK = '<<'
C * STORE SHORT INTER CONTACT FOR CLUSTER/NETWORK ANALYSIS
C * BUT EXCLUDE THE MINOR DISORDER CONTACTS
            IF (IPOPI >= 5000 .AND. IPOPK >= 5000) THEN
              IF (IHA /= 1 .AND. KATHA /= 1 .AND. IPR(20) == 1)
     1          THEN
                  IF (IPR(88) < NP2) THEN
                    IPR(88)         = IPR(88) + 1
                    XLS(1, IPR(88)) = IAT
                    XLS(2, IPR(88)) = PAR(67)
                    XLS(3, IPR(88)) = JAT
                    XLS(4, IPR(88)) = XMOL2
                    XLS(5, IPR(88)) = IPR(61)
                    XLS(6, IPR(88)) = DIJ
                    XLS(7, IPR(88)) = DELT
                    XLS(8, IPR(88)) = IDSORD
                  ELSE
C * OVERFLOW
                    IPR(149) = IPR(149) + 100
                  END IF
              END IF
            END IF
          END IF
        END IF
        IF (IPR(20) == 1) THEN
          CALL PLA066 (1, MOL2, NATHX, NATHY, X1, X2, X3, X4, DIJ29)
C * CALL EXIT/STOP
          IF (IPR(2) /= 0) CALL GEN127 ('303')
        END IF
        IF (IPR(20) == 0) THEN
          IMRK1 = 'Intra'
        ELSE
          IMRK1 = '     '
        END IF
        ANGL  = -1.0
        SA    = 0.0
        IANGL = 0
        NC    = - NINT (CON(IAT, 9))
        N     = 0
        NLINE = 0
        DO
          N = N + 1
          IF (N > NC) THEN
            IF (NLINE /= 0) RETURN
          ELSE
            K = NINT (CON(IAT, N))
            IF (K > IPR(37)) CYCLE
            CALL PLA053 (K, IAT, KAT, 0, ANGLE, SA, IANGL, NDEC2, IER)
            IF (IER /= 0) CYCLE
            IF (ANGLE < PAR(33)) CYCLE
C * GET LABEL AND DISORDER INFO ON K
            CALL PLA036 (K, 1, 3, IDUM1, IDUM2, IDUM3, IPR(71),
     1        IGBL(55))
            ANGL  = ANGLE
            IANGL = MIN (999, IANGL)
          END IF
          IF (NLINE == 0) THEN
            WRITE (CXMOL2, FORMK, IOSTAT = IOST) XMOL2
            IF (INT (XMOL2) == 1555) CXMOL2 = '         '
            FORMI(36 : 36) = CHAR (ICHAR ('0') + NDEC1)
            IF (ANGL < 0) THEN
              WRITE (PRBUF, FORMI, IOSTAT = IOST)
     1          (NAMS(1, L)(1:8), L = 1, 2), CXMOL2, DIJ, ISDIJ, MARK,
     2          DMX0, DELT, IMRK1, (XXO(IAT, L), L = 1, 3),
     3          (XXO(KAT, L), L = 1, 3)
            ELSE
              FORMI(86 : 86) = CHAR (ICHAR ('0') + NDEC2)
              WRITE (PRBUF, FORMI, IOSTAT = IOST)
     1         (NAMS(1, L)(1:8), L = 1, 2), CXMOL2, DIJ, ISDIJ, MARK,
     2         DMX0, DELT, IMRK1, (XXO(IAT, L), L = 1, 3),
     3         (XXO(KAT, L), L = 1, 3), NAMS(1, 3)(1:8), ANGL, IANGL
            END IF
C * GENERATE TABLE/CIF DATA
            IF (MN < 28) THEN
              IF (IPR(438) * IGBL(97) == 1) THEN
                IPR(254) = IPR(254) + 1
                WRITE (LU2, 99994, IOSTAT = IOST)
     1            NAMS(1, 1)(2:8), NAMS(1, 4)(2:8), DIJ, SDIJ
              END IF
            END IF
          ELSE
            FORMJ(12 : 12) = CHAR (ICHAR ('0') + NDEC2)
            WRITE (PRBUF, FORMJ, IOSTAT = IOST) NAMS(1, 3)(1:8),
     1      ANGL, IANGL
          END IF
          IF (IGBL(63) > 2) CALL PLA263 (LU7, PRBUF, 132, 1, 11)
          NLINE = NLINE + 1
        END DO
      END IF
      RETURN
99999 FORMAT (/, 57X, 13('='), /, 56('*'), ' ARU =', F8.2, 1X,
     1        61('*'), /, 57X, 13('='), /)
99998 FORMAT (/, 'Default Contact Radii are those given by A.Bondi',
     1 ', J.Phys.Chem. (1964),68,441. (or Coval. Rad. + 0.8 Ang.',
     2 ' when not given)', //, '* WARNING * : no Far-Reaching',
     3 ' Conclusions should be drawn based on the Default Radii',
     4 ' Assigned to Metals', //, 'Short "INTRA" Distances between',
     5 ' two Atoms that are Separated by less than 4 Bonds are NOT',
     6 ' Listed (Except for Potential D/A Contacts)', /)
99997 FORMAT ('Analysis of Short Intra- and Inter-molecular Contacts',
     1 ' ,  d(I-J) <  R(I) + R(J) + Tolr, With Tolr =', F5.1,
     2 ' Ang. (X - I...J) >', F5.0, ' Deg.', /, 132('-'), /,
     3 'Contact Radii :', 16(3X, A))
99996 FORMAT ('(Angstrom)', 5X, 16F5.2)
99995 FORMAT (132('-')/, 'At(I)[', F7.2, '] At(J)  [  ARU(J) ]',
     1 7X, 'D(I-J)  SumRad  Del  Type    X(I)   Y(I)   Z(I)', 5X,
     2 'X(J)   Y(J)   Z(J)   X', 9X, 'X - I...J', /, 132('-'))
99994 FORMAT ('NONB ', 2(A, 2X), 2F8.4)
      END SUBROUTINE PLA057
 
      SUBROUTINE PLA058 (LU)
C * SAVE SYMMETRY OPERARATIONS FROM CIF
      USE symsav
      USE sgxyz
      IMPLICIT NONE
      INTEGER :: I
      INTEGER :: LU
      INTEGER :: IOST
      CHARACTER(len=80) :: LINE
      NSCF = 0
      CALL GEN108 (LU, 0)
      DO
        READ (LU, IOSTAT = IOST) LINE
        IF (IOST /= 0) EXIT
        IERR  = 0
        SELECT CASE (LINE(1:4))
C * SYMM FROM SAVED FROM CIF
          CASE ('SYMM')
            CALL SGSM (22, LINE, SGX, 0, 0, IERR)
            NSCF = NSCF + 1
            DO I = 1, 4
              NSCIF(I, NSCF) = NINT (SGX(I + 8))
            END DO
            IF (NSID(NSCF) == 0) NSID(NSCF) = NSCF
          CASE ('BOND')
            EXIT
        END SELECT
      END DO
      RETURN
      END SUBROUTINE PLA058
 
      SUBROUTINE PLA059 (JAT, KAT)
C * ORTHOGONALISE - SYMMETRY INFO TRANSFERRED THROUGH ITR & IPR(54)
 
      USE files
      USE parameters
      USE plato
      USE sgxyz
      IMPLICIT NONE
      INTEGER :: I
      INTEGER :: J
      INTEGER :: L
      INTEGER :: JAT
      INTEGER :: KAT
      INTEGER :: JP3
      INTEGER :: NSMM
 
      REAL :: ORJK
      IF (JAT > NP1 .OR. JAT <= 0) THEN
        WRITE (LU6, 99999, IOSTAT = IOST) JAT, KAT
C * CALL EXIT/STOP
        CALL GEN127 ('Report problem to Author')
      ELSE
        IF (JAT /= KAT) THEN
C * APPLY SYMMETRY TRANSFORMATION
          DO I = 1, 3
            SGY(I + 3) = 0.0
            SGY(I)     = XXO(JAT, I)
          END DO
          CALL SGSM (3, ICL, SGY, IPR(54), LU7, IERR)
          DO I = 4, 6
            SGZ(I)           = SGY(I + 3) + ITR(I - 3)
            SGZ(IPR(30 + I)) = SGZ(I)
          END DO
C * TRANSFORM ESD FOR SYMMETRY TRANSFORMATION (NOT FOR SOLV & VOID)
          IF (IPR(189) == 0) THEN
            DO I = 1, 3
              SGY(I) = XSD(JAT, I)
            END DO
            NSMM = -IPR(54)
            CALL SGSM (3, ICL, SGY, NSMM, LU7, IERR)
          END IF
        END IF
        DO I = 1, 3
          J   = 4 - I
          JP3 = J + 3
          IF (JAT /= KAT) THEN
            XXO(KAT, J) = SGZ(JP3)
            XSD(KAT, J) = SGY(J + 6)
          END IF
          XXO(KAT, JP3) = 0.0
          XSD(KAT, JP3) = 0.0
          DO L = J, 3
            ORJK = OR(J, L)
            XXO(KAT, JP3) = XXO(KAT, JP3) + XXO(KAT, L) * ORJK
C * NOT FOR SOLV & VOID CALCULATIONS
            IF (IPR(189) == 0) THEN
C * S.U. REQUESTED
              IF (IPR(72) /= 0) THEN
                XSD(KAT, JP3) = XSD(KAT, JP3) + XSD(KAT, L) * ORJK**2
              END IF
            END IF
          END DO
        END DO
      END IF
      RETURN
99999 FORMAT (/, 'Problem in PLA059; JAT & KAT =', 2I12, /)
      END SUBROUTINE PLA059
 
      MODULE latice
      SAVE
C * THE ROTATIONS AND TRANSLATIONS IN TWELFTHS FOR SYMMETRY ELEMENTS,
C * IN THE ORDER 6, 3, 4, 2, 1.
      REAL, DIMENSION(3, 5, 5)   :: ROT = RESHAPE ((/
     1  -1.0,-1.0, 0.0,  1.0, 0.0, 0.0,  0.0, 0.0,-1.0,  0.0, 0.0, 0.0,
     2   0.0, 0.0, 2.0,  0.0,-1.0, 0.0,  1.0, 1.0, 0.0,  0.0, 0.0,-1.0,
     3   0.0, 0.0, 0.0,  0.0, 0.0, 4.0,  0.0,-1.0, 0.0,  1.0, 0.0, 0.0,
     4   0.0, 0.0,-1.0,  0.0, 0.0, 0.0,  0.0, 0.0, 3.0, -1.0, 0.0, 0.0,
     5   0.0,-1.0, 0.0,  0.0, 0.0, 1.0,  0.0, 0.0, 6.0,  6.0, 6.0, 0.0,
     6  -1.0, 0.0, 0.0,  0.0,-1.0, 0.0,  0.0, 0.0,-1.0,  0.0, 0.0, 0.0,
     7   0.0, 0.0, 0.0/), (/3, 5, 5/))
      REAL, DIMENSION(3, 3, 8)   :: TRDAT = RESHAPE ((/
     1  1.0,  0.0,  0.0,   0.0,  1.0,  0.0,   0.0,  0.0,  1.0,
     2  0.0,  1.0,  0.0,   1.0,  0.0,  0.0,   0.0,  0.0, -1.0,
     3  0.0,  0.0,  1.0,   1.0,  0.0,  0.0,   0.0,  1.0,  0.0,
     4  0.0,  0.0, -1.0,   0.0,  1.0,  0.0,   1.0,  0.0,  0.0,
     5  0.0,  1.0,  0.0,   0.0,  0.0,  1.0,   1.0,  0.0,  0.0,
     6  1.0,  0.0,  0.0,   0.0,  0.0, -1.0,   0.0,  1.0,  0.0,
     7  0.0,  0.0,  1.0,   0.0, -1.0,  0.0,   1.0,  0.0,  0.0,
     8  1.0,  0.0, -1.0,   0.0, -1.0,  0.0,   0.0,  0.0, -1.0/),
     9 (/3, 3, 8/))
C * CELL-TO-PRIMITIVE CELL TRANSFORMATION FOR THE VARIOUS LATTICE TYPES
C * P, A, B, C, F, I, R
      REAL, DIMENSION(3, 3, 128) :: TRNSX = RESHAPE ((/
     1  1.0,  0.0,  0.0,  0.0,  1.0,  0.0,  0.0,  0.0,  1.0,
     2  1.0,  0.0,  0.0,  0.0,  1.0,  0.5,  0.0,  0.0,  0.5,
     3  0.5,  0.0,  0.0,  0.0,  1.0,  0.0,  0.5,  0.0,  1.0,
     4  1.0,  0.5,  0.0,  0.0,  0.5,  0.0,  0.0,  0.0,  1.0,
     5  0.5,  0.5,  0.0,  0.0,  0.5,  0.5,  0.5,  0.0,  0.5,
     6  1.0,  0.0,  0.5,  0.0,  1.0,  0.5,  0.0,  0.0,  0.5,
     7  0.666667, -0.333333, -0.333333, 0.333333, 0.333333, -0.666667,
     8  0.333333,  0.333333,  0.333333,
     9  0.0,  1.0,  0.0,  1.0,  0.0,  0.0,  0.0,  0.0, -1.0,
     * -1.0,  0.0,  0.0,  0.0,  0.0,  1.0,  0.0,  1.0,  0.0,
     1  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
     2  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
     3  1.0,  0.0,  0.0,  0.0,  1.0,  0.0,  0.0,  0.0,  1.0,
     4  1.0,  0.0,  0.0,  0.0,  1.0,  0.0,  0.0,  0.0,  1.0,
     5  1.0,  0.0,  0.0,  0.0,  1.0,  0.0,  0.0,  0.0,  1.0,
     6  1.0,  0.0,  1.0,  0.0,  1.0,  1.0,  0.0,  0.0,  1.0,
C * SUPERLAT1:
     7  1.0,  0.0,  0.0,  0.0,  1.0,  0.0,  0.0,  0.0,  1.0,
C * SUPERLAT2: SANTORO & MIGHELL, ACTA CRYST. (1972),A28,284-287
     8  2.0,  0.0,  0.0,  0.0,  1.0,  0.0,  0.0,  0.0,  1.0,
     9  1.0,  0.0,  0.0,  0.0,  2.0,  0.0,  0.0,  0.0,  1.0,
     *  1.0,  0.0,  0.0,  0.0,  1.0,  0.0,  0.0,  0.0,  2.0,
     1  2.0,  1.0,  0.0,  0.0,  1.0,  0.0,  0.0,  0.0,  1.0,
     2  2.0,  0.0,  1.0,  0.0,  1.0,  0.0,  0.0,  0.0,  1.0,
     3  1.0,  0.0,  0.0,  0.0,  1.0,  0.0,  0.0,  1.0,  2.0,
     4  1.0,  0.0,  1.0,  1.0,  1.0,  0.0,  0.0,  1.0,  1.0,
C * SUPERLAT3:
     5  3.0,  0.0,  0.0,  0.0,  1.0,  0.0,  0.0,  0.0,  1.0,
     6  1.0,  0.0,  0.0,  0.0,  3.0,  0.0,  0.0,  0.0,  1.0,
     7  1.0,  0.0,  0.0,  0.0,  1.0,  0.0,  0.0,  0.0,  3.0,
     8  1.0,  2.0,  0.0, -1.0,  1.0,  0.0,  0.0,  0.0,  1.0,
     9  1.0, -2.0,  0.0,  1.0,  1.0,  0.0,  0.0,  0.0,  1.0,
     * -1.0,  2.0,  0.0,  0.0,  0.0,  1.0,  1.0,  1.0,  0.0,
     1  1.0,  2.0,  0.0,  0.0,  0.0,  1.0,  1.0, -1.0,  0.0,
     2  0.0,  0.0,  1.0,  1.0,  2.0,  0.0, -1.0,  1.0,  0.0,
     3  0.0,  0.0,  1.0,  1.0, -2.0,  0.0,  1.0,  1.0,  0.0,
     4  2.0,  1.0,  0.0,  1.0,  1.0,  2.0,  1.0,  0.0,  1.0,
     5  1.0, -1.0,  2.0,  2.0, -1.0,  0.0,  1.0,  0.0,  1.0,
     6  1.0,  1.0,  2.0,  1.0,  0.0,  1.0,  2.0,  1.0,  0.0,
     7  1.0,  1.0,  0.0,  1.0,  2.0,  2.0,  1.0,  0.0,  1.0,
C * SUPERLAT4:
     8  4.0,  0.0,  0.0,  0.0,  1.0,  0.0,  0.0,  0.0,  1.0,
     9  1.0,  0.0,  0.0,  0.0,  4.0,  0.0,  0.0,  0.0,  1.0,
     *  1.0,  0.0,  0.0,  0.0,  1.0,  0.0,  0.0,  0.0,  4.0,
     1  4.0,  3.0,  0.0,  0.0,  1.0,  0.0,  0.0,  0.0,  1.0,
     2  4.0,  1.0,  0.0,  0.0,  1.0,  0.0,  0.0,  0.0,  1.0,
     3  4.0,  0.0,  3.0,  0.0,  1.0,  0.0,  0.0,  0.0,  1.0,
     4  4.0,  0.0,  1.0,  0.0,  1.0,  0.0,  0.0,  0.0,  1.0,
     5  1.0,  0.0,  0.0,  0.0,  1.0,  0.0,  0.0,  3.0,  4.0,
     6  1.0,  0.0,  0.0,  0.0,  1.0,  0.0,  0.0,  1.0,  4.0,
     7  4.0,  2.0,  0.0,  0.0,  1.0,  0.0,  0.0,  0.0,  1.0,
     8  4.0,  0.0,  2.0,  0.0,  1.0,  0.0,  0.0,  0.0,  1.0,
     9  1.0,  0.0,  0.0,  0.0,  2.0,  0.0,  0.0,  1.0,  2.0,
     *  2.0,  1.0,  0.0,  0.0,  2.0,  0.0,  0.0,  0.0,  1.0,
     1  2.0,  0.0,  1.0,  0.0,  1.0,  0.0,  0.0,  0.0,  2.0,
     2  1.0,  0.0,  0.0,  0.0,  1.0,  0.0,  0.0,  2.0,  4.0,
     3  2.0,  0.0,  1.0,  2.0,  1.0,  0.0,  0.0,  1.0,  1.0,
     4  1.0,  0.0,  2.0,  1.0,  1.0,  0.0,  0.0,  1.0,  2.0,
     5  1.0,  0.0,  1.0,  1.0,  2.0,  0.0,  0.0,  2.0,  1.0,
     6  1.0,  1.0,  2.0,  2.0,  1.0,  1.0,  1.0,  2.0,  1.0,
     7  3.0,  1.0,  2.0,  1.0,  1.0,  0.0,  0.0,  1.0,  1.0,
     8  4.0,  1.0,  2.0,  0.0,  1.0,  0.0,  0.0,  0.0,  1.0,
     9  2.0,  1.0,  3.0,  1.0,  1.0,  0.0,  0.0,  1.0,  1.0,
     *  4.0,  2.0,  1.0,  0.0,  1.0,  0.0,  0.0,  0.0,  1.0,
     1  1.0,  0.0,  1.0,  1.0,  1.0,  0.0,  1.0,  3.0,  2.0,
     2  2.0,  0.0,  1.0,  0.0,  1.0,  0.0,  0.0,  1.0,  2.0,
     3  2.0,  0.0,  2.0,  1.0,  1.0,  0.0,  0.0,  1.0,  1.0,
     4  1.0,  0.0,  1.0,  2.0,  2.0,  0.0,  0.0,  1.0,  1.0,
     5  1.0,  0.0,  1.0,  1.0,  1.0,  0.0,  0.0,  2.0,  2.0,
     6  2.0,  0.0,  0.0,  0.0,  2.0,  0.0,  0.0,  0.0,  1.0,
     7  2.0,  0.0,  0.0,  0.0,  1.0,  0.0,  0.0,  0.0,  2.0,
     8  1.0,  0.0,  0.0,  0.0,  2.0,  0.0,  0.0,  0.0,  2.0,
     9  2.0,  0.0,  0.0,  0.0,  1.0,  0.0,  0.0,  1.0,  2.0,
     *  2.0,  0.0,  1.0,  0.0,  2.0,  0.0,  0.0,  0.0,  1.0,
     1  2.0,  1.0,  0.0,  0.0,  1.0,  0.0,  0.0,  0.0,  2.0,
     2  2.0,  1.0,  0.0,  0.0,  1.0,  0.0,  0.0,  1.0,  2.0,
C * SUBLAT1:
     3  1.0,  0.0,  0.0,  0.0,  0.1,  0.0,  0.0,  0.0,  0.1,
C * SUBLAT2:
 
     4  0.5,  0.0,  0.0,  0.0,  1.0,  0.0,  0.0,  0.0,  1.0,
     5  1.0,  0.0,  0.0,  0.0,  0.5,  0.0,  0.0,  0.0,  1.0,
     6  1.0,  0.0,  0.0,  0.0,  1.0,  0.0,  0.0,  0.0,  0.5,
     7  0.5,  0.0,  0.0, -0.5,  1.0,  0.0,  0.0,  0.0,  1.0,
     8  0.5,  0.0,  0.0,  0.0,  1.0,  0.0, -0.5,  0.0,  1.0,
     9  1.0,  0.0,  0.0,  0.0,  1.0, -0.5,  0.0,  0.0,  0.5,
     *  0.5, -0.5,  0.5,  0.5,  0.5, -0.5, -0.5,  0.5,  0.5,
C * SUBLAT3:
     1  0.33333, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 1.0,
     2  1.0, 0.0, 0.0, 0.0, 0.33333, 0.0, 0.0, 0.0, 1.0,
     3  1.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.33333,
     4  0.33333, 0.33333, 0.0,-0.66667, 0.33333, 0.0, 0.0, 0.0, 1.0,
     5  0.33333,-0.33333, 0.0, 0.66667, 0.33333, 0.0, 0.0, 0.0, 1.0,
     6 -0.33333, 0.33333, 0.0, 0.0, 0.0, 1.0, 0.66667, 0.33333, 0.0,
     7  0.33333, 0.33333, 0.0, 0.0, 0.0, 1.0, 0.66667,-0.33333, 0.0,
     8  0.0, 0.0, 1.0, 0.33333, 0.33333, 0.0,-0.66667, 0.33333, 0.0,
     9  0.0, 0.0, 1.0, 0.33333,-0.33333, 0.0, 0.66667, 0.33333, 0.0,
     *  0.33333, 0.33333,-0.33333,-0.33333, 0.66667, 0.33333, 0.66667,
     1 -1.33333, 0.33333,
     2 -0.33333,-0.66667, 0.33333, 0.33333,-0.33333,-0.33333, 0.66667,
     3  1.33333, 0.33333,
     4 -0.33333, 0.66667, 0.33333, 0.66667,-1.33333, 0.33333, 0.33333,
     5  0.33333,-0.33333,
     6  0.66667, 0.33333,-0.66667,-0.33333, 0.33333, 0.33333, 0.66667,
     7 -0.66667, 0.33333,
C * SUBLAT4:
     8  0.25, 0.00, 0.00, 0.00, 1.00, 0.00, 0.00, 0.00, 1.00,
     9  1.00, 0.00, 0.00, 0.00, 0.25, 0.00, 0.00, 0.00, 1.00,
     *  1.00, 0.00, 0.00, 0.00, 1.00, 0.00, 0.00, 0.00, 0.25,
     1  0.25, 0.00, 0.00,-0.75, 1.00, 0.00, 0.00, 0.00, 1.00,
     2  0.25, 0.00, 0.00,-0.25, 1.00, 0.00, 0.00, 0.00, 1.00,
     3  0.25, 0.00, 0.00, 0.00, 1.00, 0.00,-0.75, 0.00, 1.00,
     4  0.25, 0.00, 0.00, 0.00, 1.00, 0.00,-0.25, 0.00, 1.00,
     5  1.00, 0.00, 0.00, 0.00, 1.00,-0.75, 0.00, 0.00, 0.25,
     6  1.00, 0.00, 0.00, 0.00, 1.00,-0.25, 0.00, 0.00, 0.25,
     7  0.25, 0.00, 0.00,-0.50, 1.00, 0.00, 0.00, 0.00, 1.00,
     8  0.25, 0.00, 0.00, 0.00, 1.00, 0.00,-0.50, 0.00, 1.00,
     9  1.00, 0.00, 0.00, 0.00, 0.50,-0.25, 0.00, 0.00, 0.50,
     *  0.50, 0.00, 0.00,-0.25, 0.50, 0.00, 0.00, 0.00, 1.00,
     1  0.50, 0.00, 0.00, 0.00, 1.00, 0.00,-0.25, 0.00, 0.50,
     2  1.00, 0.00, 0.00, 0.00, 1.00,-0.50, 0.00, 0.00, 0.25,
     3  0.25,-0.50, 0.50, 0.25, 0.50,-0.50,-0.25, 0.50, 0.50,
     4  0.50,-0.50,-0.50, 0.50, 0.50, 0.50,-0.50,-0.25, 0.25,
     5  0.50,-0.25, 0.50, 0.50, 0.25,-0.50,-0.50, 0.25, 0.50,
     6 -0.25,-0.25, 0.75, 0.75,-0.25,-0.25,-0.25, 0.75,-0.25,
     7  0.25,-0.25, 0.25, 0.25, 0.75,-0.75,-0.50, 0.50, 0.50,
     8  0.25, 0.00, 0.00,-0.25, 1.00, 0.00,-0.50, 0.00, 1.00,
     9  0.25,-0.25, 0.25, 0.50, 0.50,-0.50,-0.75, 0.75, 0.25,
     *  0.25, 0.00, 0.00,-0.50, 1.00, 0.00,-0.25, 0.00, 1.00,
     1  0.50,-0.50, 0.50, 0.75, 0.25,-0.75,-0.25, 0.25, 0.25,
     2  0.50, 0.00, 0.00, 0.25, 1.00,-0.50,-0.25, 0.00, 0.50,
     3  0.25,-0.25, 0.25, 0.50, 0.50,-0.50,-0.50, 0.50, 0.50,
     4  0.50,-0.50, 0.50, 0.25, 0.25,-0.25,-0.50, 0.50, 0.50,
     5  0.50, 0.50,-0.25,-0.50, 0.50, 0.25, 0.50,-0.50, 0.25,
     6  0.50, 0.00, 0.00, 0.00, 0.50, 0.00, 0.00, 0.00, 1.00,
     7  0.50, 0.00, 0.00, 0.00, 1.00, 0.00, 0.00, 0.00, 0.50,
     8  1.00, 0.00, 0.00, 0.00, 0.50, 0.00, 0.00, 0.00, 0.50,
     9  0.50, 0.00, 0.00, 0.00, 1.00,-0.50, 0.00, 0.00, 0.50,
     *  0.50, 0.00, 0.00, 0.00, 0.50, 0.00,-0.50, 0.00, 1.00,
     1  0.50, 0.00, 0.00,-0.50, 1.00, 0.00, 0.00, 0.00, 0.50,
     2  0.50, 0.00, 0.00,-0.50, 1.00,-0.50, 0.00, 0.00, 0.50,
     3  0.50, 0.00, 0.00, 0.00, 0.50, 0.00, 0.00, 0.00, 0.50/),
     4  (/3, 3, 128/))
      CHARACTER(len=5), DIMENSION(8) :: TRTYP = (/'ABC  ', 'BA-C ',
     1  'CAB  ', '-CBA ', 'BCA  ', 'A-CB ', 'C-BA ', 'A-B-N'/)
      END MODULE latice
 
      MODULE addsym
      SAVE
      INTEGER, PARAMETER :: NP20 = 20
      INTEGER :: LU = 0
      INTEGER :: NFT
      INTEGER :: NSV
      INTEGER :: NFTX
      INTEGER :: NEWS
      INTEGER :: JERR
      INTEGER :: NORG
      INTEGER :: NSYM
      INTEGER :: MSYM
      INTEGER :: NINC
      INTEGER :: NPIV
      INTEGER :: NSKIP
      INTEGER :: NCHIR
      INTEGER :: NSGTR
      INTEGER :: LOOPR
      INTEGER :: NLCLP
      INTEGER :: NNFIT
      INTEGER :: NNDIS
      INTEGER :: INVST
      INTEGER :: NORGM
      INTEGER :: NOINV
      INTEGER :: NEWLT
      INTEGER :: NATOMS
      INTEGER :: NNNFIT
      INTEGER :: NNNDIS
      INTEGER :: NCHIRF
      INTEGER :: NAL110
      INTEGER :: NNF111
      INTEGER :: NRET61
      INTEGER :: IMETRIC
      INTEGER :: NAL112S
      INTEGER, DIMENSION(3)  :: NA
      INTEGER, DIMENSION(15) :: NMIS
      INTEGER, DIMENSION(64) :: IMPROP
      REAL :: DSMAX
      REAL, DIMENSION(4, NP20)    :: HH
      REAL, DIMENSION(3, NP20)    :: PH
      REAL, DIMENSION(3, 3, NP20) :: RH
      REAL, DIMENSION(4, 37)      :: HX
      REAL, DIMENSION(3, 37)      :: DHX
      REAL, DIMENSION(4, 4)       :: SHRT
      REAL, DIMENSION(NP20)       :: AANG
      REAL, DIMENSION(3)          :: ORGM
      REAL, DIMENSION(3)          :: OADD
      REAL, DIMENSION(3, 3, 15)   :: XMISR
      REAL, DIMENSION(3, 15)      :: XMISL
      REAL, DIMENSION(3, 15)      :: XMISG
      REAL, DIMENSION(3)          :: OSHFT
      REAL, DIMENSION(10)         :: FRACT = (/
     1  0.0, 0.2, 0.25, 0.33333, 0.4, 0.5, 0.6, 0.66667, 0.75, 0.8/)
      REAL, DIMENSION(3)          :: GLIDE
      REAL, DIMENSION(NP20)       :: PERPAX
      CHARACTER(len=1) :: XSUB
      CHARACTER(len=1) :: CENT
      CHARACTER(len=1) :: LATT
      CHARACTER(len=3) :: FSYM
      END MODULE addsym
 
      SUBROUTINE PLA060
C * ADDSYM - CHECKING ROUTINE FOR MISSED HIGHER/PSEUDO SYMMETRY
C * A loosely based on and extended version of the MISSYM algorithm
C * See: Y. Le Page (1987), J. Appl. Cryst., 20, 264-269.
      USE files
      USE parameters
      USE plato
      USE atomdata
      USE cchar
      USE xwdw
      USE cggt
      USE addsym
      USE latice
      USE sgxyz
C * DECLARE ALLOCATED LOCAL ARRAYS
      IMPLICIT NONE
      INTEGER, ALLOCATABLE, DIMENSION(:)   :: LCOR ! LABA
      INTEGER, ALLOCATABLE, DIMENSION(:)   :: NCOR ! NONFITS
      INTEGER, ALLOCATABLE, DIMENSION(:)   :: MCOR ! CHEM TYPE
      REAL,    ALLOCATABLE, DIMENSION(:,:) :: XCOR ! REDCEL/NATCEL COORD
      INTEGER :: I
      INTEGER :: J
      INTEGER :: K
      INTEGER :: L
      INTEGER :: M
      INTEGER :: N
      INTEGER :: IT
      INTEGER :: NX
      INTEGER :: NY
      INTEGER :: N2
      INTEGER :: NO1
      INTEGER :: NMX
      INTEGER :: LBB
      INTEGER :: LBC
      INTEGER :: LBD
      INTEGER :: IDUM
      INTEGER :: JDUM
      INTEGER :: IDSO
      INTEGER :: IMET
      INTEGER :: JCAI
      INTEGER :: JUMP
      INTEGER :: MULT
      INTEGER :: NRXX
      INTEGER :: NLTX
      INTEGER :: KMAX
      INTEGER :: IENM
      INTEGER :: INQNR
      INTEGER :: JNQNR
      INTEGER :: INCGO
      INTEGER :: IPNUM
      INTEGER :: NATOMB
      INTEGER :: ISWTCH
      REAL :: SGN
      REAL :: SMD
      REAL :: SMR
      REAL :: YUNK
      REAL :: XLNG
      REAL :: XLEN
      REAL :: SGN0
      REAL :: AIMAX
      REAL :: AJMAX
      REAL :: GEN009
      REAL :: GEN130
      CHARACTER(len=8) :: PARTNUM
C *
C * ADDSYM IPR(504) = 0: A <name>_pl.spf written with revised space group name
C *                 = 1: The <name>_pl.spf file is used for a PLUTON plot
C *                 = 2: The <name>_pl.spf used to create <name>_pl.res
C * NO ADDSYM CHECK FOR ANGSTROM DATA
      IF (IPR(23) == 1) THEN
        WRITE (LU6, 99995)
        RETURN
      END IF
C * NO ADDSYM CHECK FOR NO LATTICE TYPE GIVEN
      IF (IPR(241) == 0) THEN
        WRITE (LU6, 99996)
        RETURN
      END IF
C * ALLOCATE LOCAL ARRAYS
      ALLOCATE (LCOR(NP1), NCOR(NP1), MCOR(NP1), XCOR(6, NP1))
C * LCOR                 - LABA
C * NCOR                 - (NON)FITS
C * MCOR                 - CHEM TYPE
C * XCOR(I, J), I = 1, 3 - COORDINATES IN REDUCED CELL
C * XCOR(I, J), I = 4, 6 - COORDINATES IN NATURAL SYSTEM
C * HX                   -
C * DHX                  - 37 ROW-INDEX COMBINATIONS OF 0, +/- 1 OR 2
C * IFNT                 - CHIRALITY (WHEN DETERMINED IN PRIOR CALC GEOM/INTRA)
C * INITIALISATIONS
      IPR(30)  = 0
      IPR(205) = 1
      PAGET    = 'ADDSYM'
C * PREPARE ATOM SET (PART1)
      CALL PLA088
C * SET SUB-MENU NUMBER
      IGBL(6) = 26
C * DETERMINE ORG/INORG STRUCTURE TYPE
      CALL PLA384
C * EQUAL ATOM TYPE DEFAULT = NO
      IPR(207) = 1
C * SET NOSF OPTION VALUE
      IPR(595) = 0
C * LOAD TEST CRITERIA DEFAULTS FOR (IN)ORGANIC COMPOUNDS
      IF (IPR(699) == 0) THEN
        DO I = 1, 3
          PAR(400 + I) = RGBL(33 + I - IGBL(97) * 3)
        END DO
C * VALIDATION TEST CRITERIA
        DO I = 1, 3
          PAR(403 + I) = RGBL(36 + I)
        END DO
C * SET ADDSYM APPROX FIT MINIMUM PERCENTAGE BASED ON VOLUME
        IF (PAR(98) < 10000) THEN
          PAR(407) = RGBL(40)
        ELSE
C * SET DEFAULT TO 'EXACT' FOR VOLUME GREATER THAN 10000
          PAR(407) = 0.0
        END IF
      END IF
C * SAVE CURRENT SET OF SYMMETRY OPERATIONS (TO BE RECOVERED LATER)
      IF (SPGRNM(1)(1:1) == ' ') CALL SGSM (25, ICL, SGY, 0, 0, IERR)
C * RESTART POINT
      LBB      = 0
      LBC      = 0
      LBD      = 0
      IENM     = 0
      LOOPR    = 1
      INQNR    = 0
      JNQNR    = 0
   10 JERR     = 0
      INVST    = 0
      NCHIR    = 0
      NOINV    = 0
      NNF111   = 0
      NAL110   = 0
      NAL112S  = 0
      IPR(206) = 0
C * ADDSYM (0/1/2) -/PLOT/SHX
      IPR(410) = 0
      IPR(504) = 0
C * ANALYSE ADDSYM INSTRUCTION RECORD
      IF (IPR(220) > 2) THEN
        DO I = 3, IPR(220)
C * NO ADDSYM FOR H ATOMS
          IF (IFL(I) == 'H ') CYCLE
C * CHECK FOR OPTIONS
          SELECT CASE (IFL(I)(1:4))
C * TEST FOR EQUAL KEYWORD
            CASE ('EQUA')
              IPR(207) = 0
C * TEST FOR PLOT KEYWORD
            CASE ('PLOT')
              IPR(504) = 1
C * TEST FOR SHELX KEYWORD
            CASE ('SHEL')
              IPR(504) = 2
C * TEST FOR EXACT KEYWORD
            CASE ('EXAC')
              PAR(407) = 0.00
              IF (IPR(221) == 0) THEN
                FN(1)   = 0.80
                IF (LOOPR < 3) THEN
                  FN(2) = 0.25
                  FN(3) = 0.25
                  FN(4) = 0.25
                 ELSE
                  FN(2) = 0.1
                  FN(3) = 0.1
                  FN(4) = 0.1
                END IF
                IPR(221) = 4
               END IF
C * NO 'LONG SFAC'
            CASE ('NOSF')
              IPR(595) = 1
C * TEST FOR ELD KEYWORD
            CASE ('ELD ')
              IGBL(65) = 1
C * DO NOT CHANGE CERTAIN MONOCLINIC SPACE GROUPS TO STANDARD SETTING
            CASE ('KEEP')
              IGBL(106) = 1
C * DO SPECIFIED PART ONLY
            CASE ('PART')
              IPR(410) = NINT (FN(1))
C * TEST FOR ATOM TYPE ONLY
            CASE DEFAULT
              CALL PLA037 (I, N, 2)
              IF (N > 0)  THEN
                IPR(206) = N
              ELSE
C * CHECK FOR SUPPLIED PIVOT ATOM
                CALL PLA046 (0, IFL(I), IENM, LBB, LBC, LBD, INQNR,
     1            JNQNR, JDUM)
              END IF
          END SELECT
        END DO
      END IF
C * RESET MAX ANGLE DIFFERENCE TEST VALUE
      IF (IPR(221) > 0) THEN
        PAR(43) = FN(1)
C * RESET MAX DISTANCE TEST VALUE
        IF (IPR(221) > 1) THEN
          PAR(401) = FN(2)
C * RESET MAX DISTANCE DIFFERENCE TEST VALUE FOR INVERSION
          IF (IPR(221) > 2) THEN
            PAR(402) = FN(3)
C * RESET MAX DISTANCE DIFFERENCE TEST VALUE FOR TRANSLATION
            IF (IPR(221) > 3) THEN
              PAR(403) = FN(4)
C * RESET MAX NON-FIT PERCENTAGE VALUE
              IF (IPR(221) > 4) THEN
                IF (FN(5) > 0.0) PAR(407) = FN(5)
              END IF
            END IF
          END IF
        END IF
      END IF
C * DETERMINE (NON)WINDOW MODE
      IWIN = 0
      IF (IGBL(25) * IGBL(32) == 1 .AND. IPR(504) == 0 .AND.
     1    IPR(121) == 0) IWIN = 1
C * INIT COUNTER FOR NUMBER OF ADDITIONAL SYMMETRY ELEMENTS
      IPR(209) = 0
C * LOAD THE 37 ACCEPTABLE ROW-INDEX COMBINATIONS OF 0, +/- 1 OR 2
      N = 0
      CALL GEN101 (2, N, DHX)
      XSUB  = CHAR (32)
      NLCLP = 0
      NLTX  = 1
C * MISSED TRANSLATION SYMMETRY (RESTART) LOOP
   20 NLCLP = NLCLP + 1
C * GET NIGGLI REDUCED CELL
      CALL PLA266 (NLTX)
      NRXX  = 0
      NSGTR = 0
      NEWLT = 0
C * REPORT ON ATOMS DELETED FROM THE INPUT STREAM
      IF (IPR(100) > 0) WRITE (LU6, 99987, IOSTAT = IOST) IPR(100)
C * PRINT HEADER (TEST PRINTLEVEL)
      IF (IGBL(63) > 2) THEN
        CALL PLA262 (-2)
        WRITE (LU7, 99999, IOSTAT = IOST)
      END IF
C * SEARCH ON ONLY ONE ATOM TYPE?
      IF (IPR(206) == 0) THEN
C * REPORT SEARCH TYPE AND MAXIMUM NON-FIT PERCENTAGE
        IF (IPR(207) /= 0) THEN
          IF (IPR(410) == 0) THEN
            PARTNUM = ' '
          ELSE
            WRITE (PARTNUM, 99988, IOSTAT = IOST) IPR(410)
          END IF
          WRITE (PRBUF, 99993, IOSTAT = IOST) NINT (PAR(407)), PARTNUM
       ELSE
          WRITE (PRBUF, 99992) NINT (PAR(407))
        END IF
      ELSE
        CALL GEN020 (-1, NQ0, 2, 2)
        WRITE (PRBUF, 99994, IOSTAT = IOST) NQ0, NINT (PAR(407))
      END IF
      WRITE (LU6, 99976, IOSTAT = IOST)
      WRITE (LU6, 99990, IOSTAT = IOST) PRBUF
      IF (IPR(206) == 0 .AND. IPR(207) /= 0)
     1   WRITE (LU6, 99983, IOSTAT = IOST)
      IF (IGBL(63) > 2) THEN
        CALL PLA262 (2)
        WRITE (LU7, 99990, IOSTAT = IOST) PRBUF
      END IF
C * GRAPHICS OUTPUT SETTING
      IF (IWIN == 1) THEN
        CALL GGIP (HORS, VERT, 0.0, 1)
        VRT = VERT - 1.0
        CALL PLA439 (0.0, PRBUF, 80, 0.35, 3, 2, 1.0, VRT)
      END IF
      NEWS = 0
C * DETERMINE PROPER/IMPROPER SYMMETRY ELEMENT TYPE (+1/-1)
C * NSYM = NUMBER OF SYMMETRY OPERATIONS EXCLUDING BRAVAIS CENTERING
      NSYM = IPR(255) * IPR(257)
      DO I = 1, NSYM
        CALL SGSM (6, ICL, SGY, I, LU6, IERR)
        IMPROP(I) = NINT (GEN130(SGY))
      END DO
C * TRANSFORM ALL THE ATOMIC COORDINATES TO THE REDUCED CELL AXIAL SYSTEM
C * AND GET/ADD THOSE FOR THE SYMMETRY-RELATED ATOMS.
C * DUPLICATIONS, HYDROGEN & DISORDERED ATOMS ARE ELIMINATED)
      NATOMB = 0
      NATOMS = 0
C * SKIPPED DISORDERED ATOM COUNTER
      NSKIP  = 0
C * COUNT NUMBER OF INCLUDED ATOMS
      NINC   = 0
C * DEFAULT PIVOT ATOM
      NPIV   = 1
C * LOOP OVER THE SET OF INPUT ATOMS
      DO I = 1, IPR(37)
C * GET ELEMENT TYPE
        CALL GEN048 (-4, IFG(1, I), 15, NO1)
        NO1 = NO1 + 1
C * CHECK CHIRALITY FOR SELECTED ATOM-TYPE ONLY
        IF (IPR(206) == 0 .OR. NO1 == IPR(206)) THEN
C * CHECK/STORE R/S CHIRALITY TYPE
          CALL GEN048 (-2, IFG(1, I), 28, JCAI)
          IF (JCAI > 0) THEN
            JR(I) = JCAI - 2
            NCHIR = NCHIR + 1
          ELSE
            JR(I) = 0
          END IF
C * SKIP HYDROGEN ATOMS, THEY ARE OFTEN TOO IMPRECISE OR PARTIALLY MISSING
          IF (IEN(NO1) /= 1 .AND. IEN(NO1) /= 33 .AND.
     1      IEN(NO1) /= 133) THEN
            INCGO = 1
C * SKIP DISORDERED ATOMS
            CALL GEN048 (-8, IFG(2, I), 1, IDSO)
            IF (IPPR(IDSO + 1, 1) < 10000) INCGO = 0
            IF (IPR(410) /= 0) THEN
              INCGO = 1
C * GET PART NUMBER
              CALL GEN048 (-5, IFG(3, I), 14, IPNUM)
              IF (IPNUM - 16 /= IPR(410)) INCGO = 0
            END IF
C * ACCEPTED ATOM FOR ADDSYM TEST
            IF (INCGO == 1) THEN
C * CHECK FOR METAL
              CALL GEN048 (-1, IFG(1, I), 19, IMET)
C * COPY SELECTED ATOMS IN CON-ARRAY
              DO L = 1, 3
                SGY(L)     = XXO(I, L)
                SGY(L + 3) = 0.0
              END DO
              NATOMB = NATOMS
              NINC   = NINC + 1
C * GENERATE & STORE SYMMETRY-RELATED ATOM
              DO J  = 1, NSYM
                CALL SGSM (3, ICL, SGY, J, LU6, IERR)
C * TRANSFORM TO REDUCED CELL
                CALL GEN002 (1, TRNSM1, SGY(7), V2, XLNG)
C * TEMPORARILY STORE THOSE REDUCED CELL ATOMIC COORDINATES
                DO K = 1, 3
                  XCOR(K, NATOMS + 1) = MOD (V2(K) + 10.0, 1.0)
                END DO
                IF (J > 1) THEN
                  DO L = NATOMB + 1, NATOMS
                    M = 0
                    DO K = 1, 3
                      IF (ABS (MOD (10.5 + XCOR(K, NATOMS + 1)
     1                - XCOR(K, L), 1.0) - 0.5) < 0.001) M = M + 1
                    END DO
C * THIS ATOM IS ALREADY IN THE REDUCED CELL ATOM LIST
                    IF (M == 3) EXIT
                  END DO
C * SKIP TO NEXT SYMMETRY RELATED ATOM
                  IF (M == 3) CYCLE
                END IF
C * CHECK FOR TOO MANY ATOMS FOR checkCIF/ADDSYM TEST
                IF (IGBL(3) == 1) THEN
                  IF (NATOMS >= IPR(737)) THEN
                    CALL PLA236 (608, 0, -999.0, 0.0, ' ', ' ')
                    GO TO 30
                  END IF
                END IF
C * THIS IS A NEW ATOM, KEEP IT
                IF (NATOMS < NP1) THEN
                  NATOMS       = NATOMS + 1
C * (RE)SET PIVOT ATOM
                  IF (INQNR == LABA(I)  .AND. J == 1) NPIV = NATOMS
C * SAVE LABEL
                  LCOR(NATOMS) = LABA(I)
C * SAVE (NON)METAL TYPE
                  JCA(NATOMS)  = IMET
C * SAVE CHIRALITY
                  IFNT(NATOMS) = JR(I) * IMPROP(J)
C * GIVE THE SAME ATOM TYPE TO ALL ATOMS WHEN THE CHEMICAL TYPE IS NOT
C * ESTABLISHED FOR SURE (IPR(207) = 0)
                  MCOR(NATOMS) = (IEN(NO1) - 1) * IPR(207) + 1
                ELSE
                  WRITE (LU6, 99978, IOSTAT = IOST) NP1
                  JERR = 1
                  GO TO 30
                END IF
              END DO
            ELSE
              NSKIP = NSKIP + 1
              IF (NSKIP == 1) THEN
                IF (IGBL(63) > 0) THEN
                  CALL PLA262 (2)
                  WRITE (LU6, 99976)
                  WRITE (LU6, 99991, IOSTAT = IOST)
                  WRITE (LU7, 99976)
                  WRITE (LU7, 99991, IOSTAT = IOST)
                END IF
              END IF
              CALL PLA047 (LABA(I), NQ1, IDUM, JDUM, 0, IGBL(55),
     1          0, 0)
              IF (IGBL(63) > 0) THEN
                IF (MOD (NSKIP, 8) /= 0) THEN
                  WRITE (LU6, 99977, ADVANCE = 'NO', IOSTAT = IOST)
     1              NQ1(1:7)
                  WRITE (LU7, 99977, ADVANCE = 'NO', IOSTAT = IOST)
     1              NQ1(1:7)
                ELSE
                  WRITE (LU6, 99982, ADVANCE = 'NO', IOSTAT = IOST)
                  WRITE (LU7, 99982, ADVANCE = 'NO', IOSTAT = IOST)
     1              NQ1(1:7)
                  CALL PLA262 (1)
                END IF
              END IF
            END IF
          END IF
        END IF
      END DO
      IF (IWIN == 1) THEN
        CALL PLA047 (LCOR(NPIV), NQ1, IDUM, JDUM, 0, IGBL(55),
     1          0, 0)
        WRITE (PRBUF, 99986, IOSTAT = IOST) NQ1(1:7), JID(1:30)
        CALL PLA439 (0.0, PRBUF, 80, 0.35, 5 + IGBL(68), 2, 1.0,
     1    VERT - 0.5)
      END IF
C * TESTSET OF ATOMS IS NOW COMPLETE
      NCHIRF = NCHIR
      IF (NATOMS == 0) THEN
        WRITE (PRBUF, 99980, IOSTAT = IOST)
        WRITE (LU6, 99989, IOSTAT = IOST) PRBUF(1:80)
        IF (IWIN == 1) THEN
          VRT = VRT - 0.5
          CALL PLA439 (0.0, PRBUF, 80, 0.35, 2, 2, 1.0, VRT)
        END IF
      ELSE IF (IPR(206) == 0 .AND. IPR(410) == 0 .AND.
     1         NSKIP / 2  > (NSKIP / 2 + NINC) / 4) THEN
C * ALERT _811 - TOO MANY EXCLUDED ATOMS, NO ADDSYM ANALYSIS
        CALL PLA236 (811, 0, -999.0, 1.0, ' ', ' ')
        WRITE (PRBUF, 99997, IOSTAT = IOST)
        WRITE (LU6, 99989, IOSTAT = IOST) PRBUF(1:80)
        IF (IGBL(63) > 0)
     1    WRITE (LU7, 99989, IOSTAT = IOST) PRBUF(1:80)
        IF (IWIN == 1) THEN
          VRT = VRT - 0.5
          CALL PLA439 (0.0, PRBUF, 80, 0.35, 2, 2, 1.0, VRT)
        END IF
      ELSE
        IF (NSKIP > 0) THEN
          WRITE (PRBUF, 99975) NSKIP
          WRITE (LU6, 99976)
          WRITE (LU6, 99979, IOSTAT = IOST) PRBUF
          IF (IGBL(63) > 0) THEN
            CALL PLA262 (1)
            WRITE (LU7, 99976)
            WRITE (LU7, 99979, IOSTAT = IOST) PRBUF
          END IF
          IF (IWIN == 1) THEN
            VRT = VRT - 0.5
            CALL PLA439 (0.0, PRBUF(3:80), 77, 0.35, 2, 2, 1.0, VRT)
          END IF
        END IF
        IF (PAR(386) /= 0.0) THEN
          YUNK = PAR(98) / PAR(386)
        ELSE
          YUNK = 0.0
        END IF
        WRITE (PRBUF, 99985, IOSTAT = IOST) PAR(387), YUNK
        WRITE (LU6, 99998, IOSTAT = IOST) NINC, NATOMS
        WRITE (LU6, 99990, IOSTAT = IOST) PRBUF(1:80)
        IF (IGBL(63) > 0) THEN
          CALL PLA262 (2)
          WRITE (LU7, 99998, IOSTAT = IOST) NINC, NATOMS
          WRITE (LU7, 99990, IOSTAT = IOST) PRBUF(1:80)
        END IF
        IF (IWIN == 1) THEN
          IF (PAR(387) < 1.0) THEN
            VRT = VRT - 0.5
            CALL PLA439 (0.0, PRBUF, 80, 0.35, 2, 2, 1.0, VRT)
          END IF
        END IF
C * NOW FIND THE ROW INDICES FOR METRICAL SYMMETRY ELEMENTS
C * FROM INPUT CELL DATA. SEE: LE PAGE, Y. (1982).J.APPL.CRYST.,15,255.
        NSV      = 0
        N2       = 0
        IMETRIC  = 0
        IPR(118) = 0
        IPR(459) = 0
        NNFIT    = 100
        NNNFIT   = 100
        NFT      = 100
C * GET MAXIMUM ANGULAR TOLERANCE (DIRECT-RECIPROCAL LATTICE VECTORS)
C * FIND THE 2-AXES
C * ADIR & AINV ARE DIRECT AND INVERS REDUCED CELL ORTHOGONAL MATRICES
C * AND GET THE DIRECTION COSINES [HX] OF THE POSSIBLE ROWS [DHX]
        DO I = 1, 37
          CALL GEN002 (2, ADIR, DHX(1, I), HX(1, I), HX(4, I))
        END DO
C * GET THE DIR. COSINES [V1] OF THE NORMAL TO THE POSSIBLE PLANES (DHX)
C * IN TURN (LOOP OVER PLANES)
        DO I = 1, 37
          CALL GEN002 (-2, AINV, DHX(1, I), V1, XLNG)
C * SELECT THE ROWS IN TURN (LOOP OVER ROWS)
          DO J = 1, 37
C * CALCULATE THE MULTIPLICITY OF THE CELL DEFINED BY THE MESH ON THE
C * PLANE AND THE TRANSLATION ALONG THE ROW
            MULT = NINT (ABS (GEN009 (DHX(1, I), DHX(1, J))))
            IF (MULT == 1 .OR. MULT == 2) THEN
C * CALCULATE THE ANGLE BETWEEN THE ROW AND THE NORMAL TO THE PLANE
              CALL GEN008 (V1, HX(1, J), V5, -1)
              IF (V5(1) < SIN (PAR(43) / RGBL(6))) THEN
C * TEST FOR TOO MANY AXIS FOUND CONDITION
                IF (N2 >= NP20) THEN
                  IPR(2) = 23
                  GO TO 30
                END IF
C * STORE DATA FOR THIS 2-AXIS
                N2 = N2 + 1
                DO K = 1, 3
                  PH(K, N2)    = DHX(K, I)
                  HH(K, N2)    = HX (K, J)
                  RH(K, 3, N2) = DHX(K, J)
                END DO
                AANG(N2)   = ASIN (V5(1)) * RGBL(6)
                PERPAX(N2) = 2.0
                HH(4, N2)  = HX(4, J)
              END IF
            END IF
          END DO
        END DO
        MSYM = N2
        IF (N2 > 0) THEN
          IF (N2 > 2) THEN
C * FIND THE KIND OF AXIS: FIND A FAMILY OF COPLANAR TWOFOLD AXES
            DO I = 1, N2 - 2
              DO J = I + 1, N2 - 1
                NMX   = 2
                CALL GEN008 (HH(1, I), HH(1, J), V6 , 0)
                DO K = J + 1, N2
                  IF (ABS (GEN009 (V6, HH(1, K))) <= 0.01)
     1                NMX = NMX + 1
                END DO
C * NOW FIND A TWOFOLD AXIS PERPENDICULAR TO THIS PLANE
                JUMP = 0
                DO K = 1, N2
                  IF (ABS (GEN009(PH(1, K), RH(1, 3, I))) <= 0.01) THEN
                    IF (ABS (GEN009(PH(1, K), RH(1, 3, J))) <= 0.01)
     1                THEN
C * FOUND ONE: ITS MAXIMUM ORDER IS NMX, THE NUMBER OF PERP. AXES.
                      IF (NMX > PERPAX(K)) PERPAX(K) = NMX
                      JUMP = 1
                      EXIT
                    END IF
                  END IF
                END DO
                IF (JUMP == 0 .AND. NMX > 2) THEN
C * THREE COPLANAR AXES WERE FOUND, BUT NO PERPENDICULAR ONE:
C * THIS IS LIKELY TO BE A THREEFOLD AXIS. (V3=RECIP, V4=DIRECT)
                  CALL GEN002 ( 2, AINV, V6, V4, XLEN)
                  CALL GEN002 (-2, ADIR, V6, V3, XLNG)
C * MAKE COPRIME INTEGERS (THE SMALLEST NON-ZERO INTEGER WILL BE 1)
                  SMR = 2.0
                  SMD = 2.0
                  DO K = 1, 3
                    IF (ABS (V3(K)) > 0.1 .AND. ABS (V3(K)) < SMR)
     1                      SMR = ABS (V3(K))
                    IF (ABS (V4(K)) > 0.1 .AND. ABS (V4(K)) < SMD)
     1                      SMD = ABS(V4(K))
                  END DO
                  DO K = 1, 3
                    V3(K) = NINT (V3(K) / SMR)
                    V4(K) = NINT (V4(K) / SMD)
                  END DO
                  CALL GEN002 (-2, AINV, V3, V1, XLNG)
                  CALL GEN002 ( 2, ADIR, V4, V2, XLEN)
                  CALL GEN008 (V1, V2, V5, -1)
                  IF (V5(1) < SIN (PAR(43) / RGBL(6))) THEN
C * ALL SEEMS TO BE OK, SAVE THE RESULTS
                    MSYM = MSYM + 1
                    DO K = 1, 3
                      PH(K,    MSYM) = V3(K)
                      RH(K, 3, MSYM) = V4(K)
                      HH(K,    MSYM) = V2(K)
                    END DO
                    AANG(MSYM)   = ASIN (V5(1)) * RGBL(6)
                    PERPAX(MSYM) = NMX
                    HH(4, MSYM)  = XLEN
                  END IF
                END IF
              END DO
            END DO
C * ORDER THE AXES ON TYPE AND THE ANGLE WITH THE PLANE
            DO I = 1, MSYM - 1
              AIMAX = PERPAX(I) - AANG(I)
              KMAX  = I
              DO J = I + 1, MSYM
                AJMAX = PERPAX(J) - AANG(J)
                IF (AJMAX > AIMAX) THEN
                  AIMAX = AJMAX
                  KMAX  = J
                END IF
              END DO
              CALL GEN018 (PERPAX(I), PERPAX(KMAX))
              DO K = 1, 3
                CALL GEN018 (RH(K, 3, I), RH(K, 3, KMAX))
                CALL GEN018 (PH(K, I),    PH(K, KMAX))
                CALL GEN018 (HH(K, I),    HH(K, KMAX))
              END DO
              CALL GEN018 (AANG(I), AANG(KMAX))
              CALL GEN018 (HH(4, I), HH(4, KMAX))
            END DO
          END IF
C * GET 2 PRIMITIVE TRANSLATIONS FOR THE PERPENDICULAR PLANE
          DO IT = 1, MSYM
            J = 0
            DO I = 1, 37
              IF (ABS (GEN009 (DHX(1, I), PH(1, IT))) < 0.01) THEN
                J = J + 1
                DO K = 1, 3
                  SHRT(K, J) = DHX(K, I)
                END DO
                IF (J == 2) EXIT
              END IF
            END DO
C * GET THE 2 SHORTEST TRANSLATIONS IN THE PLANE: GENERATE MESH DIAGONALS
            ISWTCH = 1
            DO WHILE (ISWTCH == 1)
              ISWTCH = 0
              DO I = 1, 3
                SHRT (I, 3) = SHRT (I, 1) + SHRT (I, 2)
                SHRT (I, 4) = SHRT (I, 1) - SHRT (I, 2)
              END DO
              DO I = 1, 4
                CALL GEN002 (2, ADIR, SHRT(1, I), V5, SHRT(4, I))
              END DO
C * RANK THEIR LENGTHS
              DO I = 1, 2
                DO J = 2, 4
                  IF (SHRT(4, J) < SHRT(4, I)) THEN
                    DO K = 1, 4
                      CALL GEN018 (SHRT(K, I), SHRT(K, J))
                    END DO
                    ISWTCH = 1
                  END IF
                END DO
              END DO
            END DO
C * FINISHED WHEN NO MORE INTERCHANGE
C * MAKE SURE THE ANGLE IS NOT ACUTE
            CALL GEN002 (2, ADIR, SHRT(1, 1), SHRT(1, 3), XLEN)
            CALL GEN002 (2, ADIR, SHRT(1, 2), SHRT(1, 4), XLEN)
            IF (GEN009 (SHRT(1, 3), SHRT(1, 4)) > 0.000001) THEN
              DO NX = 1, 3
                SHRT(NX, 2) = - SHRT(NX, 2)
              END DO
            END IF
C * MAKE SURE THE REFERENCE SYSTEM IS RIGHT-HANDED
            SGN0 = SIGN (1.0, GEN009 (RH(1, 3, IT), PH(1, IT)))
C * CALCULATE THE DET. OF THE VECTORS SHRT(I,1), SHRT(J,2), RH(K,3,IT)
            CALL GEN008 (SHRT(1, 1), SHRT(1, 2), V3, 0)
            SGN = SIGN (1.0, GEN009 (V3, RH(1, 3, IT)))
C * THIS IS A POTENTIAL SYMMETRY AXIS, WE SAVE THE VALUES
            DO NX = 1, 3
              RH(NX, 3, IT) = SGN * RH(NX, 3, IT)
              PH(NX, IT)    = SGN * PH(NX, IT) * SGN0
              DO NY = 1, 2
                RH(NX, NY, IT) = SGN * SHRT(NX, NY)
              END DO
            END DO
          END DO
        END IF
C * FILL THE NEXT SLOT (USED FOR INVERSION CENTERS AND TRANSLATIONS)
C * 1 0 0, 0 1 0, 0 0 1
        MSYM        = MSYM + 1
        PH(1, MSYM) = 0.0
        PH(2, MSYM) = 0.0
        PH(3, MSYM) = 1.0
        CALL GEN021 (RH(1, 1, MSYM), 1.0)
C * FIND THE MISSING SYMMETRY, IF ANY.
        CALL PLA061 (LCOR, NCOR, MCOR, XCOR, NLTX)
        IF (NRET61 == 1) GO TO 20
C * ANALYSE SYMMETRY OPERATIONS INTO STANDARD SPACE GROUP
        CALL PLA062
C * RELOAD ORIGINAL SPACE-GROUP
        IF (SPGRNM(1)(1:1) /= ' ') THEN
          IF (INDEX (SPGRNM(1)(1:11), ':') /= 0) THEN
            WRITE (ICL, 99974, IOSTAT = IOST) SPGRNM(1)(1:11)
          ELSE
            WRITE (ICL, 99974, IOSTAT = IOST)
     1        SPGRNM(1)(1:7)//' '//SPGRNM(1)(8:11)
            IF (SPGRNM(1)(13:13) /= ' ') ICL(13:13) = '.'
          END IF
          CALL SGSM (0, ICL, SGY, NRXX, LU6, IERR)
        ELSE
C * RELOAD SYMMETRY FROM SAVE FILE
          CALL SGSM (26, ICL, SGY, 0, 0, IERR)
        END IF
        IF (LOOPR < 3 .AND. JERR > 0) THEN
C * ALERT _115 - Non-crystallographic Inversion
          IF (NNF111 /= 0)
     1      CALL PLA236 (115, 0, -999.0, FLOAT (NNF111), ' ', ' ')
          PRBUF = 'Local/Non-Crystallographic Inversion Center Detected'
          IF (IWIN == 1) THEN
            VRT = VRT - 1.5
            CALL PLA439 (0.0, PRBUF, 80, 0.35, 1, 2, 4.0, VRT)
          END IF
          WRITE (LU6, 99989, IOSTAT = IOST) PRBUF(1:80)
          IF (IGBL(63) > 0) THEN
            CALL PLA262 (3)
            WRITE (LU7, 99989, IOSTAT = IOST) PRBUF(1:80)
          END IF
C * RESET TO NO-INVERSION
          NNF111   = 0
          IPR(209) = 0
C * ASK TO RERUN WITH 'EXACT' MODE
          IF (IWIN == 1) THEN
C * WHAT NEXT ?
            CALL PLA012 (-2, 1)
          ELSE
            IGGT = 'Y'
          END IF
          IF (IGGT(1:1) /= 'N') THEN
            LOOPR         = LOOPR + 1
            IPR(220)      = IPR(220) + 1
            IFL(IPR(220)) = 'EXACT'
            IPR(221)      = 0
            NOINV         = 1
            IF (LU == 0) LU = LU6
            WRITE (LU, 99984, IOSTAT = IOST)
            GO TO 10
          END IF
        ELSE
C * ALERT _111 - ADDITIONAL (Pseudo) Centre of Symmetry found
          IF (NNF111 /= 0) THEN
            IF (NNF111 == 100 .AND. IPR(773) == 0) THEN
                YUNK = 100.0
            ELSE
              YUNK = -999.0
            END IF
            CALL PLA236 (111, 0, YUNK, FLOAT (NNF111), ' ', ' ')
          END IF
        END IF
C * SAVE THIS ENTRY AND DISPLAY (IF REQUESTED)
        IF (ISAVEMOD == 0 .OR. IGBL(65) == 1) THEN
          IF (IPR(209) > 0 .OR. IPR(504) > 0) THEN
            IF (SPGRNM(2)(1:1) == '?') THEN
              SPGRNM(2) = SPGRNM(1)
              CALL GEN074 (ORG, 1, 3, 0.0)
              WRITE (LU6, 99981, IOSTAT = IOST)
              IF (IGBL(63) > 0) THEN
                CALL PLA262 (2)
                WRITE (LU7, 99981, IOSTAT = IOST)
              END IF
            END IF
            CALL PLA280 ('CALC GEOM SPF')
            JID(40:50) = 'New:'//SPGRNM(2)(1:7)
C * SET VIEW MIN
            IGBL(67) = 0
          END IF
        END IF
      END IF
C * WHAT NEXT ?
   30 IF (IWIN == 1) CALL PLA012 (0, 1)
      SELECT CASE (IGGT(1:4))
        CASE ('PLOT')
          CALL PLA280 ('CALC ADDSYM')
        CASE ('!   ')
          CALL PLA280 ('CALC ADDSYM')
        CASE ('END ')
          CALL PLA280 ('!')
          IGBL(30) = 0
          CALL PLA280 ('CALC GEOM SPF')
      END SELECT
      IF (LOOPR > 0) THEN
        IF (IPR(121) > 0) IPR(220) = 1
      END IF
C * RETURN TO MAIN PLATON MENU
      IGBL(6) = 10
C * RELEASE LOCAL ARRAYS
      DEALLOCATE (LCOR, NCOR, MCOR, XCOR)
      RETURN
99999 FORMAT ('ADDSYM - CHECK  (cf. MISSYM (C): Le Page, Y.,',
     1        ' J. Appl. Cryst. (1987), 20, 264-269; J. Appl.',
     2        ' Cryst. (1988), 21, 983-984)', /, 132('-'))
99998 FORMAT ('- Number of Input Atoms Included in Search', I5,
     1        ' (Unitcell', I5, ')')
99997 FORMAT (':: No ADDSYM Analysis: Too many Excluded Atoms')
99996 FORMAT (/, ':: No ADDSYM for No Lattice Type Given', /)
99995 FORMAT (/, ':: No ADDSYM for Angstrom Data', /)
99994 FORMAT ('ADDSYM Search on Atom Type ', A, 'ONLY',
     1        ' [Max Allowed NonFit', I3, ' % ]')
99993 FORMAT ('ADDSYM Search on ALL NON-H Atom Types',
     1        ' [Max Allowed NonFit', I3, ' % ]', A)
99992 FORMAT ('ADDSYM Search on ALL NON-H Atom Types (Treated EQUAL)',
     1        ' [Max Allowed NonFit', I3, ' % ]')
99991 FORMAT (':: Excluded Disorder Atoms From ADDSYM Analysis:')
99990 FORMAT ('- ', A)
99989 FORMAT (/, A, /)
99988 FORMAT (' PART', I3)
99987 FORMAT (/, ':: Note:', I5, ' Atoms deleted from input !')
99986 FORMAT ('Pivot Atom ',  A, 7X, 'PLATON/ADDSYM for ', A)
99985 FORMAT ('Density based on Input Atom Set =', F6.3,
     1        ' g.cm-3 - Vol / Non-H atom =', F5.1, ' Ang^3')
99984 FORMAT (/, ':: Restart with CALC ADDSYM EXACT')
99983 FORMAT ('- The  ADDSYM Search may be rerun for a choosen atom',
     1        ' type', /
     1         '- Use LIST RADII for an overview of the atom types', /)
99982 FORMAT (3X, A)
99981 FORMAT (/, ':: Higher (pseudo)symmetry not compatible,',
     1           '(current symmetry retained)')
99980 FORMAT (':: No Fully Occ. Atoms found in list ...',
     1        ' ADDSYM request aborted!')
99979 FORMAT (A)
99978 FORMAT (':: Over', I7, 'atoms in the Primitive Cell',
     1        ' (ADDSYM request aborted!)')
99977 FORMAT (3X, A)
99976 FORMAT (1X)
99975 FORMAT ('- Warning: Number of Excluded Disordered Input Atoms =',
     1       I3, ' from ADDSYM Analysis')
99974 FORMAT ('SPGR ', A, 64X)
      END SUBROUTINE PLA060
 
      SUBROUTINE PLA061 (LCOR, NCOR, MCOR, XCOR, NLTX)
C * FIND THE MISSING SYMMETRY, IF ANY.
      USE files
      USE parameters
      USE plato
      USE atomdata
      USE cchar
      USE xwdw
      USE cggt
      USE addsym
      USE latice
      USE sgxyz
      IMPLICIT NONE
      INTEGER :: I
      INTEGER :: J
      INTEGER :: K
      INTEGER :: N
      INTEGER :: IK
      INTEGER :: IL
      INTEGER :: IR
      INTEGER :: JG
      INTEGER :: LUX
      INTEGER :: NRT
      INTEGER :: IAT1
      INTEGER :: IAT2
      INTEGER :: IAT3
      INTEGER :: IAT4
      INTEGER :: IDUM = 0
      INTEGER :: JDUM = 0
      INTEGER :: JROT
      INTEGER :: ISYM
      INTEGER :: ISIG
      INTEGER :: ISTR
      INTEGER :: ITEL
      INTEGER :: ITRY
      INTEGER :: ITYP
      INTEGER :: NTYP
      INTEGER :: MULT
      INTEGER :: NLTX
      INTEGER :: NCHR
      INTEGER :: NFIT
      INTEGER :: NROT
      INTEGER :: MIAT1
      INTEGER :: MIAT3
      INTEGER :: ITRI0
      INTEGER :: ITYPB
      INTEGER :: ITYPE
      INTEGER :: IFNT1
      INTEGER :: IFNT2
      INTEGER :: IFNT3
      INTEGER :: IFNT4
      INTEGER :: IMULT
      INTEGER :: IPERP
      INTEGER :: IPRMX
      INTEGER :: IRCTR
      INTEGER :: NLOOP
      INTEGER :: NSAVR
      INTEGER :: IGLIDE
      INTEGER :: ISHIFT
      INTEGER, DIMENSION(*) :: LCOR
      INTEGER, DIMENSION(*) :: NCOR
      INTEGER, DIMENSION(*) :: MCOR
      INTEGER, DIMENSION(3) :: IROW
      INTEGER, DIMENSION(3) :: IROW0
      REAL :: ANG
      REAL :: DET
      REAL :: DIS
      REAL :: DLE
      REAL :: FIT
      REAL :: GLI
      REAL :: ORI
      REAL :: P407
      REAL :: XDUM
      REAL :: DLIM
      REAL :: TEMP
      REAL :: XLNG
      REAL :: YUNK
      REAL :: DSAVR
      REAL :: DELTA
      REAL :: DSCENT
      REAL :: GEN009
      REAL, DIMENSION(6, *) :: XCOR
      REAL, DIMENSION(3)    :: DEL
      REAL, DIMENSION(3)    :: ROW
      REAL, DIMENSION(3)    :: GLY
      REAL, DIMENSION(3)    :: ORIG
      REAL, DIMENSION(3)    :: RATOM
      REAL, DIMENSION(3, 2) :: ATOM2
      REAL, DIMENSION(3, 2) :: GLIDO
      REAL, DIMENSION(3, 4) :: ROTAX
      REAL, DIMENSION(3, 3) :: TTRM1
      REAL, DIMENSION(3, 3) :: BTRM1
      REAL, DIMENSION(3)    :: TRANSL
      REAL, DIMENSION(3, 3) :: TTRANS
      REAL, DIMENSION(3, 3) :: BTRANS
      REAL, DIMENSION(2)    :: GLITOT
      CHARACTER(len=1) :: STAR
      CHARACTER(len=7) :: TEXT1
      NROT     = 0
      DSCENT   = 999.0
      NRET61   = 0
C * FIRST USE DISTANCE APPROPRIATE FOR AXES AND PLANES
      DLIM     = PAR(401)
      PAR(291) = 0.0
C * OUTPUT A TITLE
      WRITE (LINE, 99989, IOSTAT = IOST)
      WRITE (IDM,  99981, IOSTAT = IOST)
     1  PAR(43), PAR(401), PAR(402), PAR(403)
      DO I = 1, 2 + IWIN
        IF (I == 1) THEN
          IF (IGBL(63) <= 2) CYCLE
          LUX = LU7
          CALL PLA262 (6)
        ELSE IF (I == 2) THEN
          LUX = LU6
        ELSE
          VRT = VRT - 0.5
          CALL PLA439 (0.0, IDM, 80, 0.35, 3, 2, 1.0, VRT)
          WRITE (PRBUF, 99984, IOSTAT = IOST)
          VRT = VRT - 0.5
          CALL PLA439 (0.0, PRBUF, 80, 0.35, 5 + IGBL(68), 2, 1.0,
     1                 VRT)
          WRITE (PRBUF, 99985, IOSTAT = IOST)
          VRT = VRT - 0.5
          CALL PLA439 (0.0, PRBUF, 80, 0.35, 5 + IGBL(68), 2, 1.0,
     1                 VRT)
          CALL GGIP (0.0, 1.0, 0.0, 0)
          CALL GGIP (0.0,  VRT - 0.2, 0.0, 3)
          CALL GGIP (HORS, VRT - 0.2, 0.0, 2)
          VRT = VRT - 0.3
          CALL GGIP (0.0, 0.0, 0.0, 6)
          CYCLE
        ENDIF
        WRITE (LUX, 99990, IOSTAT = IOST) LINE(1:78)
        WRITE (LUX, 99990, IOSTAT = IOST) IDM
        CALL PLA047 (LCOR(NPIV), NQ6, IDUM, JDUM, 0,
     1                IGBL(55), 0, 0)
        WRITE (LUX, 99980, IOSTAT = IOST) NQ6
        WRITE (LUX, 99988, IOSTAT = IOST)
        WRITE (LUX, 99984, IOSTAT = IOST)
        WRITE (LUX, 99985, IOSTAT = IOST)
        WRITE (LUX, 99986, IOSTAT = IOST)
      END DO
C * TEST LOOP OF THE METRICAL SYMMETRY OPERATION SET FOR SUPPORT IN
C * THE PRIMITIVE TRICLINIC COORDINATE SET
      DO 100  ISYM = 1, MSYM
C * SELECT A SYMMETRY DIRECTION AND BUILD THE NATURAL CELL
        DO I = 1, 3
          DO J = 1, 3
            BTRANS(I, J) = RH(I, J, ISYM)
          END DO
          IROW0(I) = NINT (RH(I, 3, ISYM))
        END DO
C * INVERT
        CALL GEN003 (BTRANS, BTRM1, DET, 0)
C * FLAG A REDUCED CELL TRANSLATION WHICH DOES NOT PROJECT ON A NET NODE
        IRCTR = 0
        DO I = 1, 3
          IF (ABS (ABS (BTRM1(3, I)) - 0.5) < 0.48) IRCTR = I
        END DO
C * TRANSFORM COORDINATES ACCORDINGLY (BTRM1) INTO 'NATURAL SYSTEM'
        DO I = 1, NATOMS
          DO J = 1, 3
            V1(J) = XCOR(J, I)
          END DO
          CALL GEN002 (1, BTRM1, V1, V2, XLNG)
          DO J = 1, 3
            XCOR(J + 3, I) = V2(J)
          END DO
        END DO
C * TEST FIRST PLANES & AXES
        IF (ISYM < MSYM) THEN
          IPERP = NINT (PERPAX(ISYM))
          ANG   = AANG(ISYM)
          MULT  = NINT (GEN009 (RH(1, 3, ISYM), PH(1, ISYM)))
          DLE   = HH(4, ISYM)
C * SIXFOLD AXIS, ALL TYPES OF AXES SHOULD BE TRIED (2, 3, 6)
          IF (IPERP >= 6) THEN
            ITYPB = 1
            ITYPE = 4
C * THREE-FOLD AXIS, DO NOT EXAMINE ANY OTHER POSSIBILITY (3)
          ELSE IF (IPERP == 3) THEN
            ITYPB = 2
            ITYPE = 2
C * FOURFOLD AXIS, EXAMINE 4 AND 2
          ELSE IF (IPERP >= 4) THEN
            ITYPB = 3
            ITYPE = 4
C * TWOFOLD AXIS, CANNOT BE ANYTHING ELSE
          ELSE
            ITYPB = 4
            ITYPE = 4
          END IF
        ELSE
C * LAST POSSIBILITY, A SYMMETRY CENTER. USE CORRESPONDING DISTANCE LIMIT
C * ITRY = -5 : SEARCH FOR TRANSLATIONS
C * ITRY =  5 : SEARCH FOR INVERSION CENTERS
          ITYPB = 5
          ITYPE = 5
          INVST = 0
        END IF
C * SEARCH SUPPORT FOR POSSIBLE SYMMETRY ELEMENTS
        DO ITYP = ITYPB, ITYPE
          IF (ITYP == 1) THEN
            NROT = 6
          ELSE IF (ITYP == 2) THEN
            NROT = 3
          ELSE IF (ITYP == 3 .AND. ITYPB /= 1) THEN
            NROT = 4
          ELSE IF (ITYP == 4) THEN
            NROT = 2
          END IF
C * LOOP OVER IMPROPER = 1/PROPER = 2
          DO NTYP = 1, 2
            ITRY  = ITYP * (-1) ** NTYP
            IF (ITRY == 5 .AND. NOINV == 1) CYCLE
            JROT  = 6 - NTYP
            DSMAX = -1.0
            NCHR  = 0
C * INVERSION
            IF (ITRY == 5) THEN
              IF (IPR(708) /= 0) CYCLE
              DLIM = PAR(402)
C * TRANSLATION
            ELSE IF (ITRY == -5) THEN
              DLIM = PAR(403)
            END IF
C * COPY THE ROTATION AND TRANSLATION PARTS OF THE CONSIDERED OPERATION
            DO I = 1, 3
              ROTAX(I, 4) = 0.0
              TRANSL(I)   = ROT(I, JROT, ITYP)
              DO J = 1, 3
                TEMP = ROT(I, J, ITYP)
                IF (ITRY < 0) TEMP = - TEMP
                ROTAX(I, J) = TEMP
                IF (I == J) TEMP = TEMP - 1.0
                ROTM1(I, J) = TEMP
              END DO
            END DO
C * GET (R - I) ** -1.0 AVOID SINGULARITIES
            DO 10 I = 1, 3
              V6(I) = 1.0
              DO J = 1, 3
                IF (ROTM1(I, J) /= 0.0) GO TO 10
                IF (ROTM1(J, I) /= 0.0) GO TO 10
              END DO
              V6(I)       = 0.0
              ROTM1(I, I) = 1.0
   10       CONTINUE
C * INVERT
            CALL GEN003 (ROTM1, ROTM2, DET, 0)
            DO I = 1, 3
              ROTM2(I, I) = ROTM2(I, I) * V6(I)
            END DO
C * SELECT FIRST ATOM = IAT1 AS PIVOT ATOM (PLACED IN THE NATURAL SYSTEM)
            IAT1  = NPIV
C * GET ATOM TYPE MIAT1 FOR ATOM IAT1
            MIAT1 = MCOR(IAT1)
C * GET  R/S TYPE IFNT1 FOR ATOM IAT1
            IFNT1 = IFNT(IAT1)
C * GET THE TO BE TESTED SYMMETRY-EQUIVALENT OF ATOM IAT1
            DO I = 1, 3
              RATOM(I) = 0.0
              DO J = 1, 3
                RATOM(I) = RATOM(I) + ROTAX(I, J) * XCOR(J + 3, IAT1)
              END DO
            END DO
C * FIND ATOM IAT2 (WHERE APPLICAL, WITH SIMILAR TYPE AND CHIRALITY)
C *  AND PLACE IT IN THE NATURAL SYSTEM
            DO 90 IAT2 = 1, NATOMS
C * GET CHIRALITY OF IFNT2 FOR ATOM IAT2
              IFNT2 = IFNT(IAT2)
C * CHECK CHIRALITY (WHERE APPROPRIATE)
              IF (NCHIR > 0) THEN
                IF (NTYP == 1 .OR. ITRY == 5) THEN
                  IF ((IFNT1 + IFNT2) /= 0) GO TO 90
                ELSE IF (NTYP == 2 .OR. ITRY == -5) THEN
                  IF ((IFNT1 - IFNT2) /= 0) GO TO 90
                END IF
              END IF
              NCHR  = IABS(IFNT1)
              DSMAX = -1.0
              DSAVR = 0.0
              NSAVR = 1
C * COMPARE ATOM TYPES OF ATOM IAT1 & ATOM IAT2
              IF (MCOR(IAT2) == MIAT1) THEN
C * GET COORDINATES OF ATOM IAT2
                DO I = 1, 3
                  ATOM2(I, 1) = XCOR(I + 3, IAT2)
                END DO
                IF (IRCTR /= 0) THEN
                  DO I = 1, 3
                    ATOM2(I, 2) = ATOM2(I, 1) + BTRM1(I, IRCTR)
                  END DO
                END IF
C * FIND THE GLIDE, IF ANY. SKIP THE SECONDARY ELEMENT
                DO J = 1, 2
                  IF (J /= 2 .OR. IRCTR /= 0) THEN
                    GLITOT(J) = 0.0
                    DO I = 1, 3
                      GLIDO(I, J) = 0.0
C * ALL FOR PURE TRANSLATIONS: ITRY = -5
                      IF (TRANSL(I) >= 0.1 .OR. ITRY == -5) THEN
                        GLIDO(I, J) = ATOM2(I, J) - XCOR(I + 3, IAT1)
                        GLITOT(J)   = GLITOT(J)   + GLIDO(I, J)**2
                        GLITOT(J)   = GLITOT(J)   - INT (GLITOT(J)
     1                                + 0.1)
                        IF (ITRY /= - 5) THEN
C * INAPPROPRIATE GLIDE, NEXT ATOM
                          XDUM = MOD (12.0 * GLIDO(I, J) /
     1                                       TRANSL(I), 1.0)
                          IF (XDUM >= 0.05 .AND. XDUM <= 0.95)
     1                      GO TO 90
                        END IF
                      END IF
                    END DO
                  END IF
                END DO
C * THE GLIDE IS CREDIBLE, PICK THE SMALLER ONE
                JG = 1
                IF (IRCTR /= 0) THEN
                  IF (ABS (GLITOT(2)) < ABS (GLITOT(1))) JG = 2
                END IF
C * FIND FIXED COORDINATES FOR THE OPERATION
                DO I = 1, 3
                  ROTAX(I, 4) = GLIDO(I, JG) * 12.0
                  V1(I) = RATOM(I) - ATOM2(I, JG) + GLIDO(I, JG)
                END DO
                CALL GEN002 (1, ROTM2, V1, ORIG, XLNG)
C * THE OPERATION IS NOW CHARACTERIZED BY ITS ROTATION, ITS GLIDE AND ITS
C * FIXED COORDINATES. TEST IT FOR ALL ATOMS, ATOM IAT1 ALREADY PASSED IT
                P407  = PAR(407)
   20           NFIT  = 0
                NNFIT = 100
                NLOOP = 0
                DO I = 1, NATOMS
                  NCOR(I) = 0
                END DO
                NCOR(IAT1) = 2
                NCOR(IAT2) = 2
C * FIND SUPPORT FOR THIS SYMMETRY BY OTHER PAIRS
C * ATOM IAT3 LOOP
                DO 40 IAT3 = 1, NATOMS
C * GET LABEL OF ATOM IAT3
                  CALL PLA047 (LCOR(IAT3), NQ5, IDUM, JDUM, 0,
     1              IGBL(55), 0, 0)
C * GET R/S-INFO IFNT3 FOR ATOM IAT3
                  IFNT3 = IFNT(IAT3)
C * BRING THE ATOM IN THE NATURAL CELL AND
C * CALCULATE THE COORDINATES OF THE ATOM RELATED BY THE OPERATION
                  DO K = 1, 3
                    V1(K) = XCOR(K + 3, IAT3) - ORIG(K)
                  END DO
                  DO K = 1, 3
                    V2(K) = ROTAX(K, 4) / 12.0 + ORIG(K)
                    DO J = 1, 3
                      V2(K) = V2(K) + ROTAX(K, J) * V1(J)
                    END DO
                  END DO
C * BRING IT BACK TO THE REDUCED CELL AND SEE IF IT BELONGS TO THE LIST
                  CALL GEN002 (1, BTRANS, V2, V3, XLNG)
C * GET ATOM TYPE OF ATOM IAT3
                  MIAT3 = MCOR(IAT3)
C * ATOM IAT4 LOOP
                  DO 30 IAT4 = 1, NATOMS
                    CALL PLA047 (LCOR(IAT4), NQ5, IDUM, JDUM, 0,
     1                IGBL(55), 0, 0)
C * GET R/S-INFO IFNT4 FOR ATOM IAT4
                    IFNT4 = IFNT(IAT4)
C * CHECK CHIRALITY (WHERE APPLICABLE)
                    IF (NCHIR > 0) THEN
                      IF (NTYP == 1 .OR. ITRY == 5) THEN
                        IF ((IFNT3 + IFNT4) /= 0) CYCLE
                      ELSE IF (NTYP == 2 .OR. ITRY == -5) THEN
                        IF ((IFNT3 - IFNT4) /= 0) CYCLE
                      END IF
                    END IF
C * COMPARE ATOM TYPES ATOM 3 & ATOM 4
                    IF (MCOR(IAT4) == MIAT3) THEN
C * AVOID ZERO TRANSLATION
                      IF (ITRY /= -5 .OR. IAT3 /= IAT4) THEN
C * CHECK THAT ALL THREE COORDINATES FIT
                        DO K = 1, 3
                          DELTA = MOD (V3(K) - XCOR(K, IAT4), 1.0)
                          IF (ABS (DELTA) > 0.5)
     1                      DELTA = DELTA - SIGN (1.0, DELTA)
                          IF (ABS (DELTA) > 0.2) THEN
                            GO TO 30
                          END IF
                          DEL(K) = DELTA
                        END DO
                        CALL GEN002 (2, ADIR, DEL, V4, DIS)
                        DIS = DIS / 2
                        IF (DIS <= DLIM) THEN
C * REGISTER MAXIMUM DEVIATION WITHIN ALLOWED TOLERANCE 'DLIM'
                          IF (DIS > DSMAX) THEN
                            DSMAX = DIS
                            DSAVR = DSAVR + DIS
                            NSAVR = NSAVR + 1
                            CALL PLA047 (LCOR(IAT3), NQ3,
     1                        IDUM, JDUM, 0, IGBL(55), 0,
     2                        1 - IGBL(55))
                            CALL PLA047 (LCOR(IAT4), NQ4,
     1                        IDUM, JDUM, 0, IGBL(55), 0,
     2                        1 - IGBL(55))
                            NQ3(6 : 6) = '-'
                          END IF
                          NCOR(IAT3) = NCOR(IAT3) + 1
C * THIS ATOM IAT3 PASSED THE TEST, NEXT ATOM IAT3
                          NCHR = NCHR + IABS (IFNT3)
                          GO TO 40
                        END IF
                      END IF
                    END IF
   30             CONTINUE
C * END OF ATOM IAT4 LOOP
C * FAILURE, THIS ATOM HAS NO EQUIVALENT (COUNT FAILURE)
                  NFIT = NFIT + 1
                  IF (NFIT * 100.0 / NATOMS > P407) THEN
                    GO TO 90
                  END IF
   40           CONTINUE
C * END OF ATOM IAT3 LOOP
C * (ALL) ATOMS PASSED THE TEST CRITERIUM, THIS IS AN (APPROXIMATE) SYMMETRY ELE
C * SPECIAL TREATMENT INVERSION SYMMETRY IN NON_CENTRO STRUCTURES
                IF (ITRY == 5) THEN
                  IF (IPR(257) == 1) THEN
                    IF (NFIT /= 0) IPR(118) = 1
                  END IF
                END IF
                NQ1  = ' '
                NFTX = 0
                CALL GEN038 (LINE, 1, 80)
                DO N = 1, NATOMS
                  IF (NCOR(N) < 1) THEN
                    CALL PLA047 (LCOR(N), NQ2, IDUM, JDUM, 0,
     1                           IGBL(55), 0, 0)
                    IF (NQ2 /= NQ1) THEN
                      NQ1 = NQ2
C * NO < 100 % METAL NON-FIT
                      IF (JCA(N) == 1 .AND. ITRY == 5) THEN
                        IF (NFTX /= 0) THEN
                          WRITE (LU6, 99988, IOSTAT = IOST)
                          IF (IGBL(63) > 0) THEN
                            CALL PLA262 (1)
                            WRITE (LU7, 99988, IOSTAT = IOST)
                          END IF
                        END IF
                        GO TO 90
                      END IF
                      NFTX = NFTX + 1
                      IF (NFTX < 12) THEN
                        LINE((NFTX - 1) * 5 + 1:) = NQ1
                      END IF
                    END IF
                  END IF
                END DO
                FIT = NFTX * 100.0 / NINC
                IF (FIT > P407) THEN
                  IPR(118) = 0
                  GO TO 90
                END IF
                IF (NFTX == 0) THEN
                  NNFIT = 100
                ELSE
                  NNFIT = INT (100.0 - FIT)
                END IF
C * FOUND ONE GENERATOR, TRANSFORM IT TO THE INPUT CELL
                CALL GEN004 (TRNS,   BTRANS, TTRANS)
                CALL GEN003 (TTRANS, TTRM1,  DET, 0)
                CALL GEN132 (TTRANS, ROTAX, TTRM1, ROTM1)
C * COMPARE ITS ROTATIONAL PART WITH THOSE OF THE INPUT SPACE GROUP
C * FLAG THE NEW ELEMENTS WITH AN ASTERISK
                ISTR   = 1
                NNNDIS = MAX (NNNDIS, ISTR)
                STAR   = '*'
                IF (ITRY /= -5) THEN
                  DO 50 I = 1, NSYM
                    CALL SGSM (6, ICL, SGY, I, LU6, IERR)
                    ITEL = 0
                    DO IR = 1, 3
                      DO IL = 1, 3
                        ITEL = ITEL + 1
                        IF (ABS (ROTM1(IR, IL) - SGY(ITEL))
     1                      > 0.01) GO TO 50
                      END DO
                    END DO
                    ISTR = 0
                    STAR = ' '
C * MAKE SURE THAT UN-STARRED SYMMETRY ELEMENT HAVE 100 % FIT
                    IF (NFIT > 0 .AND. NLCLP == 1) THEN
                      P407  = 0.0
                      NLOOP = NLOOP + 1
                      IF (NLOOP < 10) GO TO 20
                    END IF
                    GO TO 60
   50             CONTINUE
                  IPR(209) = 1
                END IF
C * NOW PREPARE THE OUTPUT LINE.
   60           FSYM = ' '
                NRT  = NROT
                IF (ITRY > 0 .AND. ITYP /= 4) THEN
                  FSYM(1 : 1) = '-'
                  IF (NRT == 4) NRT = 5
                END IF
                FSYM(2 : 2) = CHAR (ICHAR ('0') + NROT)
                IF (ITRY == -4) THEN
                  FSYM(2 : 2) = 'm'
                  NRT         = 0
                END IF
C * BRING AN EVENTUAL GLIDE COMPONENT BETWEEN 0 AND 1
                IGLIDE = 0
                DO I = 1, 3
                  ORI = MOD (ORIG(I), 1.0)
                  IF (ORI < -0.45) ORI = ORI + 1.0
                  IF (ORI >   0.6) ORI = ORI - 1.0
                  ORIG(I) = ORI
                  GLI     = MOD (GLIDO(I, JG), 1.0)
                  IF (GLI < -0.45) GLI = GLI + 1.0
                  IF (GLI >  0.6)  GLI = GLI - 1.0
                  GLIDE(I) = GLI
                  IF (ABS (GLI) >= 0.05) IGLIDE = 1
                END DO
C * TRANSFORM THE ROW INDICES, THE ORIGIN OF THE ELEMENT AND
C * THE GLIDE TO THE INPUT CELL
                CALL GEN002 (1, BTRANS, GLIDE,        V1, XLNG)
                CALL GEN002 (1, TRNS ,  V1,        GLIDE, XLNG)
                CALL GEN002 (1, TRNS ,  V1,          GLY, XLNG)
                CALL GEN002 (1, BTRANS, ORIG ,        V1, XLNG)
                CALL GEN002 (1, TRNS ,  V1 ,        ORIG, XLNG)
                CALL GEN002 (1, TRNS ,  RH(1, 3, ISYM), ROW, XLNG)
                DO I = 1, 3
                  IF (ISYM >= MSYM) THEN
                    ORIG(I) = MOD (1.0 + ORIG(I), 0.5)
                  ELSE
                    IF (ORIG(I) < - 0.1) ORIG(I) = ORIG(I) + 1.0
                  END IF
                END DO
C * MAKE THE ROW INDICES INTEGER, FIRST NON-ZERO INDEX POSITIVE
                IF (DSMAX < 0.0001) THEN
                  NQ3 = ' '
                  NQ4 = ' '
                END IF
C * ITYP /= 5 (I.E. ROTATIONS)
                IF (ITYP /= 5) THEN
                  ISIG  = 0
                  DO I = 1, 3
                    IF (ISIG == 0 .AND. ROW(I) < -0.01)
     1                  ISIG = -1
                    IF (ISIG == 0 .AND. ROW(I) >  0.01)
     1                  ISIG = 1
                  END DO
                  IMULT = 0
   70             IMULT = IMULT + ISIG
                  DO I = 1, 3
                    IROW(I) = NINT (IMULT * ROW(I))
                    IF (ABS (ABS (ROW(I) * IMULT) - IABS (IROW(I)))
     1                  > 0.01) GO TO 70
                  END DO
C * IF THE SENSE OF THE ROW WAS CHANGED FOR OUTPUT, A POSITIVE ROTATION
C * IS NOW ACCOMPANIED BY AN OPPOSITE GLIDE
                  IF (ITRY < 0) THEN
                    DO I = 1, 3
                      GLIDE(I) = ISIG * GLIDE(I)
                      GLY(I)   = GLIDE(I)
                    END DO
                  END IF
                  IF (IGLIDE == 1) THEN
                    TEXT1 = 'Screw  '
                    DO I = 1, 3
                      ITR(I)   = MOD (NINT (12.0 * GLIDE(I)) + 12, 12)
                      GLIDE(I) = ITR(I) / 12.0
                      ISHIFT    = ITR(I) * IROW(I)
                      ITRI0    = ITR(I)
                      IF (ISHIFT /= 0) THEN
                        IF (NROT == 3) THEN
                          IF (ITRI0 == 2) THEN
                            ITRI0 = 4
                          ELSE IF (ITRI0 == 10) THEN
                            ITRI0 = 8
                          END IF
                        END IF
                        FSYM(3:3) =
     1                    CHAR (ICHAR ('0') + ITRI0 * NROT / 12)
                      END IF
                    END DO
                    IF (ITRY == - 4) THEN
                      NRT   = 0
                      FSYM(3:3) = ' '
                      TEXT1 = 'Glide  '
C * TEST FOR c, b, a, d or n - PLANE
                      IF (ITR(1) == 0 .AND. ITR(2) == 0) THEN
                        FSYM(2 : 2) = 'c'
                      ELSE IF (ITR(1) == 0 .AND. ITR(3) == 0) THEN
                        FSYM(2 : 2) = 'b'
                      ELSE IF (ITR(2) == 0 .AND. ITR(3) == 0) THEN
                        FSYM(2 : 2) = 'a'
                      ELSE IF (MOD (ITR(1), 6) == 3 .OR.
     1                         MOD (ITR(2), 6) == 3) THEN
                        FSYM(2 : 2) = 'd'
                      ELSE
                        FSYM(2 : 2) = 'n'
                      END IF
                    END IF
                    IPRMX = 80
                  ELSE
                    IPRMX = 55
                  END IF
C * SAVE SYMMETRY
                  NEWS = NEWS + 1
                  NMIS(NEWS) = (6 - NRT) * 100 + NEWS
                  DO IR = 1, 3
                    DO IK = 1, 3
                      XMISR(IR, IK, NEWS) = ROTM1(IR, IK)
                    END DO
                    XMISL(IR, NEWS) = ORIG(IR)
                    XMISG(IR, NEWS) = GLY(IR) * ISIG
                  END DO
C * NOW OUTPUT THE RESULTS IN THE PROPER FORM
                  IF (NFTX > 0) THEN
                    WRITE (LU6, 99996, IOSTAT = IOST)
                    WRITE (LU6, 99983, IOSTAT = IOST) LINE(1:75)
                    WRITE (LU6, 99988, IOSTAT = IOST)
                    WRITE (LU6, 99988, IOSTAT = IOST)
C * CHECK PRINTLEVEL
                    IF (IGBL(63) > 0) THEN
                      CALL PLA262 (4)
                      WRITE (LU7, 99996, IOSTAT = IOST)
                      WRITE (LU7, 99983, IOSTAT = IOST) LINE(1:75)
                      WRITE (LU7, 99988, IOSTAT = IOST)
                    END IF
                  END IF
                  DSAVR = DSAVR / NSAVR
C * LIST SYMMETRY ELEMENT INFO
                  WRITE (PRBUF, 99995, IOSTAT = IOST)
     1              FSYM(1:2), STAR, IROW, IROW0, DLE, IPERP, MULT,
     2              ANG, NNFIT, DSAVR, ORIG
                  NNNFIT = MIN (NNNFIT, NNFIT)
                  CALL GEN065 (0, PRBUF, 1, 81, 23)
                  WRITE (LU6, 99983, IOSTAT = IOST) PRBUF(1:80)
                  IF ((NNFIT < 100 .OR. DSMAX > PAR(404)) .AND.
     1              ISTR == 1) THEN
                    ISTR   = 5
                    NNNDIS = ISTR
                    NNDIS  = ISTR
                  END IF
                  IF (STAR == '*') THEN
C * ALERT _112 - Additional (Pseudo) Symmetry Element Found
                    YUNK = -999.0
                    IF (NNFIT == 100 .AND. IPR(773) == 0) THEN
                      YUNK = 100.0
                    END IF
                    CALL PLA236 (112, 0, YUNK, FLOAT (NNFIT), FSYM, ' ')
                  END IF
                  IF (IWIN == 1) THEN
                    VRT = VRT - 0.5
                    CALL PLA439 (0.0, PRBUF, 80, 0.35, 1 + ISTR,
     1                           2, 1.0, VRT)
                  END IF
                  IF (IGBL(63) > 2) THEN
                    CALL PLA262 (1)
                    WRITE (LU7, 99983, IOSTAT = IOST) PRBUF(1:80)
                  END IF
                  IF (DSMAX > -1.0) THEN
                    WRITE (PRBUF, 99991, IOSTAT = IOST) FSYM(3:3),
     1                NQ3(1:6), NQ4(1:6), DSMAX, TEXT1, GLIDE
                    CALL GEN065 (0, PRBUF, 1, IPRMX + 1, 7)
                    WRITE (LU6, 99983, IOSTAT = IOST) PRBUF(1:IPRMX)
                    IF (IWIN == 1) THEN
                      DO I = 1, IPRMX
                        IF (PRBUF(I:I) /= ' ') THEN
                          VRT = VRT - 0.5
                          CALL PLA439 (0.0, PRBUF, IPRMX, 0.35,
     1                       1 + ISTR, 2,  1.0, VRT)
                          GO TO 80
                        END IF
                      END DO
                    END IF
   80               IF (IWIN == 1) CALL GGIP (0.0, 0.0, 0.0, 6)
                    IF (IGBL(63) > 2) THEN
                      CALL PLA262 (1)
                      WRITE (LU7, 99983, IOSTAT = IOST) PRBUF(1:IPRMX)
                    END IF
                  END IF
                  IF (DSMAX > PAR(291)) PAR(291) = DSMAX
                  NSV         = NSV + 1
                  KBO(NSV, 1) = NROT
                  KBO(NSV, 2) = ISYM
                  KBO(NSV, 3) = ISTR
                  KBO(NSV, 4) = NINT (DLE * 10000.0)
C * ITYP = 5 (I.E. Lattice Translations and Inversions)
                ELSE
                  IF (ITRY < 0) THEN
C * HANDLE LATTICE TRANSLATION
                    CALL PLA065
                    GO TO 90
                  ELSE
                    IF (IPR(257) == 1) INVST = 1
                    IF (STAR == '*') THEN
                      IF (LOOPR == 1) NNF111 = NNFIT
                    END IF
                    DSAVR = DSAVR / NSAVR
                    WRITE (PRBUF, 99987, IOSTAT = IOST)
     1                STAR, NNFIT, DSAVR, ORIG
C * TEMP SAVE BEST ORIGIN
                    IF (DSMAX < DSCENT) THEN
                      NFT     = NNFIT
                      DSCENT  = DSMAX
                      ORGM(1) = ORIG(1)
                      ORGM(2) = ORIG(2)
                      ORGM(3) = ORIG(3)
                    END IF
                    CALL GEN065 (0, PRBUF, 1, 81, 7)
                    WRITE (LU6, 99983, IOSTAT = IOST) PRBUF(1:80)
                    IF (IGBL(63) > 2) THEN
                      CALL PLA262 (1)
                      WRITE (LU7, 99983, IOSTAT = IOST) PRBUF(1:80)
                    END IF
                    IF ((NNFIT < 100 .OR. DSMAX > PAR(405))
     1                .AND. ISTR == 1) THEN
                      ISTR  = 5
                      NNDIS = 5
                    END IF
                    IF (IWIN == 1) THEN
                      VRT = VRT - 0.5
                      CALL PLA439 (0.0, PRBUF, 80, 0.35, 1 + ISTR,
     1                             2, 1.0, VRT)
                    END IF
                    IF (STAR == '*' .AND. DSMAX > -1.0) THEN
                      WRITE (PRBUF, 99992, IOSTAT = IOST)
     1                  NQ3(1:6), NQ4(1:6), DSMAX
                        CALL GEN065 (0, PRBUF, 1, 81, 7)
                      WRITE (LU6, 99983, IOSTAT = IOST) PRBUF(1:80)
                      IF (IWIN == 1) THEN
                        VRT = VRT - 0.5
                        CALL PLA439 (0.0, PRBUF, 80, 0.35, 1 + ISTR,
     1                               2, 1.0, VRT)
                      END IF
                      IF (IGBL(63) > 2) THEN
                        CALL PLA262 (1)
                        WRITE (LU7, 99983, IOSTAT = IOST) PRBUF(1:80)
                      END IF
                    END IF
                  END IF
                END IF
                IF (ITYP /= 5 .OR. STAR == '  ') GO TO 100
              END IF
C * NEXT POSSIBLE OPERATOR
   90       CONTINUE
C * FIRST IMPLEMENT LATTICE CENTERING
          END DO
        END DO
C * ALL SYMMETRY ELEMENTS EXHAUSTED - REPORT AS METRIC SYMMETRY
        IF (ISYM < MSYM) THEN
          IMETRIC = IMETRIC + 1
          WRITE (PRBUF, 99993, IOSTAT = IOST)
     1      IROW0, DLE, IPERP, MULT, ANG
          CALL GEN065 (0, PRBUF, 1, 61, 20)
          WRITE (LU6, 99998, IOSTAT = IOST) PRBUF(1:61)
          IF (IGBL(63) > 2) THEN
            CALL PLA262 (2)
            WRITE (LU7, 99998, IOSTAT = IOST) PRBUF(1:61)
          END IF
        END IF
  100 CONTINUE
C * CHECK FOR NEW LATTICE TRANSLATIONS AND (NO) SUBCELL OPTION (IPR(503) = 0)
      IF (IPR(503) == 0) THEN
        IF (NEWLT > 0) THEN
C * FIND TRANSFORMATION MATRIX TO SUBLATTICE
          NLTX = 0
          CALL PLA064 (NEWLT, IPR(241), NLTX)
          IF (NLTX > 0) THEN
            IF (IWIN == 1) THEN
              IF (NNFIT == 100) THEN
                XSUB = 'S'
                WRITE (LU6, 99999)
                NRET61 = 1
                RETURN
              ELSE
C * WHAT NEXT ?
                CALL PLA012 (-1, 1)
              END IF
            ELSE
              IGGT  = 'Y'
            END IF
            IF (IGGT(1:1) == 'Y') THEN
              CALL PLA236 (116, 0, -999.0, 1.0, ' ', ' ')
              WRITE (PRBUF, 99982, IOSTAT = IOST) JID(1:21)
              WRITE (LU6, 99994, IOSTAT = IOST) PRBUF
              IF (IWIN == 1) THEN
                VRT = VRT - 1.5
                CALL PLA439 (0.0, PRBUF, 80, 0.35, 1, 2, 4.0, VRT)
                CALL PLA297 (0)
              END IF
              IF (IGBL(63) > 2) THEN
                CALL PLA262 (3)
                WRITE (LU7, 99997, IOSTAT = IOST) PRBUF
              END IF
              XSUB   = 'S'
              NRET61 = 1
              RETURN
            ELSE
              IPR(459) = 0
              IPR(209) = 0
            END IF
          END IF
        END IF
      END IF
      RETURN
99999 FORMAT (/, 'Implement Suggested Subcell and Restart ADDSYM', /)
99998 FORMAT (A, /)
99997 FORMAT (/, A, /)
99996 FORMAT (/, ':: NonFits (i.e. Atoms with no symmetry related',
     1           ' counterpart):')
99995 FORMAT (A, 1X, A, ' [', 3I2, '] [', 3I2, ']', F6.2, 2I3, F6.2,
     1        I5, F8.3, '  Through', 3F6.3)
99994 FORMAT (/, ':: ', A, /)
99993 FORMAT (14X, '[', 3I2, ']', F6.2, 2I3, F6.2, 14X, ' Metric')
99992 FORMAT (36X, 2A, F5.3)
99991 FORMAT (2X, A, 33X, 2A, F5.3, 2X, A, 3F6.3)
99990 FORMAT ('- ', A)
99989 FORMAT ('The Structure Implies the Following Symmetry ',
     1        'Elements Subject to the Criteria:')
99988 FORMAT (1X)
99987 FORMAT ('-1 ', A, 1X, 35('='), 2X, I3, F8.3, 2X, 'at', 5X,
     1         3F6.3, 1X)
99986 FORMAT (80('-'))
99985 FORMAT ('Elem', 1X, 'Cell_Row', 1X, 'Cell_Row', 3X,
     1        'd  Typ Dot Angle Fit  MaxDev.', 13X,
     2        'x     y     z')
99984 FORMAT ('Symm.  Input  Reduced  (Ang)', 8X, '(Deg)', 2X,
     1        '%', 3X, 'AvrDev.(Ang)', 10X, 'Input Cell')
99983 FORMAT (A)
99982 FORMAT ('Forced RESTART of ADDSYM to Implement TRANSLATION for ',
     1        A)
99981 FORMAT ('Criteria', F5.2, ' Deg (Metric),', F5.2, ' Ang (Rot),'
     1        , F5.2, ' Ang (Inv),', F5.2, ' Ang (Transl)')
99980 FORMAT ('- Pivot Atom ', A)
      END SUBROUTINE PLA061
 
      SUBROUTINE PLA062
C * ADDSYM-SYMMETRY CHECK (2)
      USE files
      USE parameters
      USE plato
      USE atomdata
      USE cchar
      USE xwdw
      USE spgrdata
      USE addsym
      USE latice
      USE sgxyz
      IMPLICIT NONE
      INTEGER :: I
      INTEGER :: J
      INTEGER :: K
      INTEGER :: N
      INTEGER :: N0
      INTEGER :: NB
      INTEGER :: JN
      INTEGER :: IR
      INTEGER :: INZ
      INTEGER :: IN1
      INTEGER :: JMX
      INTEGER :: NRT
      INTEGER :: NSP
      INTEGER :: NRT1
      INTEGER :: NRXX
      INTEGER :: NROT
      INTEGER :: NNRT
      INTEGER :: NCOL
      INTEGER :: LAT0
      INTEGER :: LAT1
      INTEGER :: IDET
      INTEGER :: IDUM
      INTEGER :: ISYM
      INTEGER :: JMAX
      INTEGER :: MLAUE
      INTEGER :: ISYST
      INTEGER :: ISGNR
      INTEGER :: JPRLP
      INTEGER :: GEN135
      INTEGER :: UNITMAT
      REAL :: DET
      REAL :: YUNK
      REAL :: XLNG
      REAL :: DANG
      REAL :: DDIS
      REAL :: DUM433
      REAL, DIMENSION(3, 3) :: DUMMY
      REAL, DIMENSION(3, 3) :: DUM1
      REAL, DIMENSION(3, 3) :: DUM2
      REAL, DIMENSION(3, 3) :: DUM3
      REAL, DIMENSION(3, 3) :: DUM4
      REAL, DIMENSION(3, 3) :: TR1
      REAL, DIMENSION(3, 3) :: TTRM1
      CHARACTER(len=7) :: ZSPG0
      CHARACTER(len=9) :: ZSPG2
      CHARACTER(len=9) :: ZSPG3
C * ANALYZE THE 'NSV' SYMMETRY ELEMENTS INTO A (STANDARD/NEW) SPACE GROUP
C * KBO(I, 1) = NROT
C * KBO(I, 2) = ISYM
C * KBO(I, 3) = ISTR - STARRED =
C * KBO(I, 4) = D
C * PAT(3, 3) = Reduced to Convential Cell Transformation
      IN1   = 0
      ISYST = 8
      MLAUE = 12
      NRXX  = 0
C * ELIMINATE NEW (STARRED) OPERATION (NSV = 2 NOT POSSIBLE)
      IF (NSV == 2) THEN
        DO I = 1, 2
          IF (KBO(I, 3) == 1) THEN
            KBO(I, 1) = 0
            EXIT
          END IF
        END DO
      END IF
C * BUBBLE-SORT ON VALUE OF 'NROT' (LARGE TO SMALL)
      IF (NSV > 1) THEN
        JMX = NSV - 1
        NB  = 1
        DO WHILE (NB /= 0)
          NB  = 0
          DO J = 1, JMX
            IF (KBO(J, 1) < KBO(J + 1, 1)) THEN
              DO K = 1, 3
                CALL GEN014 (KBO(J, K), KBO(J + 1, K))
              END DO
              NB = 1
            END IF
          END DO
        END DO
      END IF
      IF (NSV == 2) NSV = 1
C * GET NEW LATTICE TYPE AND TRANSFORMATION
      IF (NSV == 0) THEN
C * TRICLINIC
        CALL GEN021 (PAT, 1.0)
        ISYST = 1
        MLAUE = 1
      ELSE
        NROT = KBO(1, 1)
        IF (NSV == 7 .AND. NROT /= 6) THEN
          K = 4
        ELSE
          K = 0
        END IF
        IF (K == 4 .OR. NSV == 3 .OR. NSV == 13) THEN
C * BUBBLE-SORT ON VALUE OF 'D' (SMALL to LARGE))
          IF (NSV == 3) THEN
            NB  = 1
            DO WHILE (NB /= 0)
              NB  = 0
              DO I = 1, 2
                IF (KBO(I, 4) > KBO(I + 1, 4)) THEN
                  DO J = 1, 4
                    CALL GEN014 (KBO(I, J), KBO(I + 1, J))
                  END DO
                  NB = 1
                END IF
              END DO
            END DO
          END IF
          DO I = 1, 3
            DO J = 1, 3
              PAT(I, J) = RH(J, 3, KBO(K + I, 2))
            END DO
          END DO
          IF (NSV == 3) THEN
C * ORTHORHOMBIC
            ISYST = 3
            MLAUE = 3
          ELSE IF (NSV == 7) THEN
C * LOW-CUBIC
            ISYST = 7
            MLAUE = 10
          ELSE
C * HIGH-CUBIC
            ISYST = 7
            MLAUE = 11
          END IF
        ELSE
          ISYM = KBO(1, 2)
          DO J = 1, 3
            DO K = 1, 3
              PAT(K, J) = RH(J, K, ISYM)
            END DO
          END DO
          IF (NSV == 1) THEN
            IF (NROT == 2) THEN
C * MONOCLINIC
              ISYST = 2
              MLAUE = 2
              DO J = 1, 3
                CALL GEN018 (PAT(2, J), PAT(3, J))
              END DO
            ELSE IF (NROT == 3) THEN
C * LOW-TRIGONAL
              ISYST = 5
              MLAUE = 6
            ELSE IF (NROT == 4) THEN
C * LOW-TETRAGONAL
              ISYST = 4
              MLAUE = 4
            ELSE
C * LOW-HEXAGONAL
              ISYST = 6
              MLAUE = 8
            END IF
          ELSE IF (NSV == 4) THEN
            IF (NROT /= 4) THEN
C * HIGH-TRIGONAL
              ISYST = 5
              MLAUE = 7
            ELSE
C * HIGH-TETRAGONAL
              ISYST = 4
              MLAUE = 5
            END IF
          ELSE IF (NSV == 5) THEN
C * HIGH-TETRAGONAL
            ISYST = 4
            MLAUE = 5
          ELSE IF (NSV == 7) THEN
C * HIGH-HEXAGONAL
            ISYST = 6
            MLAUE = 9
          END IF
        END IF
      END IF
      CALL GEN010 (PAT, IDET, 0)
      IF (IDET < 0) THEN
        DO J = 1, 3
          PAT(2, J) = - PAT(2, J)
        END DO
      END IF
      CALL GEN003 (PAT, ROTM1, DET, 0)
      IDET = NINT (DET)
      IF (IDET == 4) THEN
        LATT = 'F'
      ELSE IF (IDET == 3) THEN
        LATT = 'R'
C * TEST FOR OBVERSE/REVERSE
        V1(1) = 2.0
        V1(2) = 1.0
        V1(3) = 1.0
        CALL GEN094 (PAT, V1, 3, IDUM)
        IF (IDUM /= 0) THEN
          CALL GEN021 (DAM, 1.0)
          DAM(1, 2) =  1.0
          DAM(2, 1) = -1.0
          DAM(2, 2) =  0.0
          CALL GEN004 (DAM, PAT, PAT)
        END IF
      ELSE IF (IDET == 2) THEN
        V1(1) = 0.0
        V1(2) = 1.0
        V1(3) = 1.0
        N     = 0
C * TEST LATTICE TYPE A
        CALL GEN094 (PAT, V1, 2, IDUM)
        IF (IDUM == 0) THEN
          LATT = 'A'
          N    = 1
        ELSE
C * TEST LATTICE TYPE B
          CALL GEN018 (V1(1), V1(2))
          CALL GEN094 (PAT, V1, 2, IDUM)
          IF (IDUM == 0) THEN
            LATT = 'B'
            N    = 2
          ELSE
C * TEST LATTICE TYPE C
            CALL GEN018 (V1(2), V1(3))
            CALL GEN094 (PAT, V1, 2, IDUM)
            IF (IDUM == 0) THEN
              LATT = 'C'
            ELSE
C * TEST LATTICE TYPE I
              V1(3) = 1.0
              CALL GEN094 (PAT, V1, 2, IDUM)
              IF (IDUM == 0) THEN
                LATT = 'I'
              ELSE
                LATT = ' '
              END IF
            END IF
          END IF
        END IF
C * TRANSFORM LATT A & B TO C
        IF (N /= 0) THEN
          DO I = 1, 3
            PAT(2, I) = - PAT(2, I)
            CALL GEN018 (PAT(N, I), PAT(3, I))
          END DO
          LATT = 'C'
        END IF
      ELSE
        LATT = 'P'
      END IF
      IF (ISYST == 5) THEN
        LAT0 = 6
      ELSE
        LAT0 = ISYST
      END IF
C * TRANSFORM mI to mC
      IF (LAT0 == 2 .AND. LATT == 'I' .AND. IGBL(106) == 0) THEN
        LATT = 'C'
        CALL GEN021 (DAM, 1.0)
        DAM(1, 3) =  1.0
        DAM(3, 1) = -1.0
        DAM(3, 3) =  0.0
        CALL GEN004 (DAM, PAT, PAT)
      END IF
C * TRANSPOSE
      CALL GEN005 (TRNS, QM)
C * MULTIPLY MATRICES
      CALL GEN004 (PAT, QM, ROTM2)
C * CHECK FOR AND AVOID TRIVIAL TRANSFORMATIONS (VOIDED TEMP)
      IF (LAT0 < 4) THEN
        CALL GEN104 (LAT0, ROTM2, DUM4)
      ELSE
        CALL GEN021 (DUM4, 1.0)
      ENDIF
      CALL GEN004 (DUM4, PAT, PAT)
      CALL GEN004 (PAT, QM, ROTM2)
C * GET T-TRANSPOSE AND T-TRANSPOSE-INVERTED
      CALL GEN005 (ROTM2, TR1)
      CALL GEN003 (TR1, ROTM1, DET, 0)
C * TRY TO FIND NEW SPACEGROUP SETTING/NAME
C * BLANK SPACE GROUP NAME
      CALL GEN038 (SPGRNM(2), 1, 11)
C * SHIFT TO NEWLY FOUND INVERSION CENTRE (INVST = 1)
      IF (INVST == 1) THEN
        CALL GEN002 (1, ROTM1, ORGM, ORG, XLNG)
      ELSE
C * INIT ORG SHIFT TO ZERO
        CALL GEN074 (ORG, 1, 3, 0.0)
      END IF
      IF (INVST == 1 .OR. IPR(257) == 2) THEN
        CENT = 'C'
      ELSE
        CENT = 'A'
      END IF
C * SPECIAL PREPARATION FOR CUBIC (MOVE 3-FOLD AXIS TO HIGHEST PRIORITY)
      IF (LAT0 == 7) THEN
        DO JN = 1, NEWS
          INZ = NMIS(JN) / 100
          IF (INZ == 3) NMIS(JN) = NMIS(JN) + 300
        END DO
      END IF
C * SORT SMALL TO LARGE
      CALL GEN022 (NMIS, 1, NEWS, 1)
C * TRANSFORM SYMMETRY OPERATIONS TO NEW SETTING
      NRT1 = 0
      NNRT = 0
      DO I = 1, 3
        OADD(I) = 0.25
      END DO
C * XMISR - ROTATION MATRIX
C * XMISL - LOCATION VECTOR OF SYMMETRY ELEMENT
C * XMISG - SHIFT VECTOR (SCREW OR GLIDE)
C * LOOP OVER DETECTED SYMMETRY ELEMENTS
      DO JN = 1, NEWS
        INZ = MOD (NMIS(JN), 100)
        NRT = 6 - NMIS(JN) / 100
        IF (NRT == 5) THEN
          NRT  = 4
          NNRT = 1
        END IF
C * TRANSFORM SYMMETRY OPERATION TO CRYSTAL SYSTEM SETTING
        CALL GEN004 (ROTM1, XMISR(1, 1, INZ), XMISR(1, 1, INZ))
        CALL GEN004 (XMISR(1, 1, INZ), TR1, XMISR(1, 1, INZ))
        CALL GEN002 (1, ROTM1, XMISL(1, INZ), XMISL(1, INZ), XLNG)
        CALL GEN002 (1, ROTM1, XMISG(1, INZ), XMISG(1, INZ), XLNG)
C * DETERMINE ORIGIN SHIFT TO SUITABLE STARTING ORIGIN
        IF (JN == 1) THEN
          IF (INVST == 0 .AND. IPR(257) == 1) THEN
            IN1 = INZ
            DO I = 1, 3
              ORG(I) = XMISL(I, INZ)
            END DO
            NRT1   = NRT
C * SET PROPER ORIGIN SEARCH STEP FOR TETRAGONAL
            IF (LAT0 == 4) THEN
              OADD(3) = 0.125
C * SET PROPER ORIGIN SEARCH STEP FOR TRIGONAL & HEXAGONAL LATTICE
            ELSE IF (LAT0 == 6) THEN
              OADD(1) = 0.3333
              OADD(2) = 0.3333
              OADD(3) = 0.5 / NRT1
            ELSE IF (LAT0 == 7) THEN
              DO I = 1, 3
                OADD(I) = 0.125
              END DO
            END IF
          ELSE
C * SHIFT ORIGIN
C * TRIGONAL
            IF (NRT == 3 .OR. NRT == 6) THEN
C * SHIFT OVER HALF FOR DIFFERENCE = ODD * 1/6
              ORG(1) = ORG(1) +
     1           0.5 * MOD (NINT ((XMISL(1, INZ) - ORG(1)) * 6), 2)
              ORG(2) = ORG(2) +
     1           0.5 * MOD (NINT ((XMISL(2, INZ) - ORG(2)) * 6), 2)
            END IF
          END IF
        ELSE IF (JN == 2 .AND. NNRT == 0) THEN
          IF (INVST == 0 .AND. IPR(257) == 1) THEN
C * C-AXIS UNIQUE FOR NON-TRICLINIC,MONOCLINIC OR ORTHORHOMBIC
            IF (NRT1 > 2) THEN
C * DETERMINE 4-AXIS ALONG A,B or C
              IF (NRT == 4) THEN
                IF (XMISR(1, 1, IN1) == 1) THEN
                  ORG(1) = XMISL(1, INZ)
                ELSE IF (XMISR(2, 2, IN1) == 1) THEN
                  ORG(2) = XMISL(2, INZ)
                ELSE IF (XMISR(3, 3, IN1) == 1) THEN
                  ORG(3) = XMISL(3, INZ)
                END IF
              ELSE
                ORG(3) = XMISL(3, INZ)
              END IF
            ELSE
              IF (NINT (XMISR(1, 1, IN1)) ==  1 .AND.
     1            NINT (XMISR(2, 2, IN1)) == -1 .AND.
     2            NINT (XMISR(3, 3, IN1)) == -1) THEN
                ORG(1) = XMISL(1, INZ)
              ELSE IF (NINT (XMISR(1, 1, IN1)) == -1 .AND.
     1                 NINT (XMISR(2, 2, IN1)) ==  1 .AND.
     2                 NINT (XMISR(3, 3, IN1)) == -1) THEN
                ORG(2) = XMISL(2, INZ)
              ELSE IF (NINT (XMISR(1, 1, IN1)) == -1 .AND.
     1                 NINT (XMISR(2, 2, IN1)) == -1 .AND.
     2                 NINT (XMISR(3, 3, IN1)) ==  1) THEN
                ORG(3) = XMISL(3, INZ)
              END IF
            END IF
          END IF
        END IF
        DO IR = 1, 3
          XMISL(IR, INZ) = XMISL(IR, INZ) - ORG(IR)
        END DO
      END DO
C * SETUP NEW SYMMETRY
      NORG  = -1
      NORGM =  1
C * FIND CONVENTIONAL ORIGIN
      DO
        IF (NORG < NORGM) THEN
          CALL PLA063
C * INITIALIZE WITH (CENTRO) LATTICE
          WRITE (ICL, 99958,IOSTAT = IOST) LATT, CENT
          CALL SGSM (0, ICL, FN, 0, LU6, IERR)
C * LOOP OVER AND LOAD THE TRANSFORMED SYMMETRY OPERATIONS
          DO JN = 1, NEWS
            INZ = MOD (NMIS(JN), 100)
            DO J = 1, 3
              V5(J) = - XMISL(J, INZ) + OSHFT(J)
            END DO
            CALL GEN002 (1, XMISR(1, 1, INZ), V5, V6, XLNG)
            K = 0
            DO I = 1, 3
C * ROUND TO REASONABLE FRACTIONS
              FN(9 + I) = NINT (24.0 * MOD (XMISL(I, INZ) - OSHFT(I) +
     1                     V6(I) + XMISG(I, INZ) + 10.0, 1.0)) / 24.0
              DO J = 1, 3
                K     = K + 1
                FN(K) = XMISR(I, J, INZ)
              END DO
            END DO
C * INPUT SYMMETRY OPERATION TO SGSM ROUTINE AS (R|T) MATRIX
            CALL SGSM (15, ICL, FN, 0, 0, IERR)
C * ERROR HANDLING
            IF (IERR /= 0) THEN
              IF (LOOPR == 1) THEN
                JERR = JERR + 10
                RETURN
              ELSE
                EXIT
              END IF
            END IF
          END DO
C * GET SPACE GROUP INFO
          IF (IERR == 0) THEN
            IF (IBVL(LAT0)//LATT == 'mI' .AND. IGBL(106) == 1) THEN
              CALL SGSM (18, ICL, FN, 0, 0, IERR)
            ELSE
              CALL SGSM (24, ICL, FN, 0, 0, IERR)
            END IF
            SPGRNM(2) = ICL(1:26)
C * CHECK FOR SAME LATTICE TYPE
            IF (IBVL(LAT0)//LATT == ICL(12:13)) THEN
              IF (SPGRNM(2)(1:5) /= 'C2/n') THEN
                IF (SPGRNM(2)(1:2) /= '  ') GO TO 20
              END IF
            END IF
          END IF
        ELSE
          SPGRNM(2)(1:1) = ' '
          JERR = JERR + 100
          RETURN
        END IF
      END DO
C * ADD ADDITIONAL SHIFT
   20 DO J = 1, 3
        ORG(J)   = ORG(J) + OSHFT(J)
        OSHFT(J) = 0.0
      END DO
      IF (SPGRNM(2)(1:1) == ' ') THEN
        SPGRNM(2)(1:1) = '?'
C * GET SPACE GROUP INFO
        CALL SGSM (18, ICL, FN, 0, 0, IERR)
        SPGRNM(2) = ICL(1:26)
        ISGNR     = NINT (FN(1))
        LAT0      = NINT (FN(2))
        LATT      = SPGRNM(2)(13:13)
      ELSE
C * TRANSFORM TO STANDARD SETTING
        IF (SPGRNM(2)(12:12) == 'm') THEN
          IF (SPGRNM(2)(1:7) == 'Pa     ') THEN
            SPGRNM(2)(1:11) = 'Pc     C-BA'
          ELSE IF (SPGRNM(2)(1:7) == 'P2/a   ') THEN
            SPGRNM(2)(1:11) = 'P2/c   C-BA'
          ELSE IF (SPGRNM(2)(1:7) == 'P21/a  ') THEN
            SPGRNM(2)(1:11) = 'P21/c  C-BA'
C * TRANSFORM P21/n TO P21/c etc. BY DEFAULT
          ELSE IF (IGBL(106) == 0) THEN
            IF (SPGRNM(2)(1:7) == 'Pn     ') THEN
              SPGRNM(2)(1:11) = 'Pc     A-B-'
            ELSE IF (SPGRNM(2)(1:7) == 'P2/n   ') THEN
              SPGRNM(2)(1:11) = 'P2/c   A-B-'
            ELSE IF (SPGRNM(2)(1:7) == 'P21/n  ') THEN
              SPGRNM(2)(1:11) = 'P21/c  A-B-'
            END IF
          END IF
        ELSE IF (SPGRNM(2)(12:12) == 'c') THEN
          IF (SPGRNM(2)(1:7) == 'Pb-3   ') THEN
            SPGRNM(2)(1:11) = 'Pa-3   BA-C'
            OSHFT(2) = 0.5
          END IF
        END IF
C * UPPERCASE THE SETTING SYMBOL
        CALL GEN020 (1, SPGRNM(2), 8, 11)
        N = 0
C * NON-STANDARD ORTHORHOMBIC TRANSFORMATIONS
        IF (.FALSE.) THEN
          DUM433 = 0.0
C * OBTAIN LIST OF EQUIVALENT TRANSFORMATIONS TO STANDARD SPACE GROUP
          CALL SGSM (23, ICL, FN, 0, 0, IERR)
          DO K = 1, 6
            IF (FN(K) /= 0) THEN
C * COPY MATRIX
              CALL GEN052 (TRDAT(1, 1, K), DUM1)
              CALL GEN004 (DUM1, PAT, DUM2)
              CALL GEN004 (DUM2, QM,  DUM3)
              CALL GEN004 (DUM3, AA,  DUM4)
C * TRANSPOSE
              CALL GEN005 (DUM3, DUM3)
              CALL GEN004 (DUM4, DUM3, DUM4)
              IF (DUM4(3, 3) > DUM433) THEN
                DUM433 = DUM4(3, 3)
                N      = K
              ELSE IF (DUM4(3, 3) == DUM433) THEN
                IF (DUM4(1, 1) < DUM4(2, 2)) THEN
                  N = K
                END IF
              END IF
              IF (DUM4(1, 1) < DUM4(2, 2) .AND.
     1            DUM4(2, 2) < DUM4(3, 3)) THEN
                 N = K
                 GO TO 30
              END IF
            END IF
          END DO
        ELSE
          DO K = 1, 8
            IF (SPGRNM(2)(8:11) == TRTYP(K)(1:4)) THEN
              N = K
              GO TO 30
            END IF
          END DO
        END IF
   30   WRITE (ICL, 99968, IOSTAT = IOST) SPGRNM(2)(1:7)
        CALL SGSM (0, ICL, SGY, NRXX, LU6, IERR)
C * GET SPACE GROUP INFO
        CALL SGSM (18, ICL, FN, 0, 0, IERR)
        SPGRNM(2) = ICL(1:26)
        ISGNR     = NINT (FN(1))
        LAT0      = NINT (FN(2))
        LATT      = SPGRNM(2)(13:13)
C * IMPLEMENT TRANSFORMATION TO STANDARD SETTING
        IF (N /= 0) THEN
          CALL GEN052 (TRDAT(1, 1, N), DUM1)
        ELSE
          CALL GEN021 (DUM1, 1.0)
        END IF
C * COPY PAT MATRIX
        CALL GEN052 (PAT, DUM2)
        CALL GEN004 (DUM1, DUM2, DUM3)
        CALL GEN004 (DUM3, QM, ROTM2)
        CALL GEN021 (DUM4, 1.0)
        CALL GEN004 (DUM4, DUM3, PAT)
C * GET T-TRANSPOSE AND T-TRANSPOSE-INVERTED (TO TRANSFORM ORIGIN)
C * MULTIPLY
        CALL GEN004 (DUM4, DUM1, DUM1)
C * TRANSPOSE
        CALL GEN005 (DUM1, TR1)
C * INVERT
        CALL GEN003 (TR1, TTRM1, DET, 0)
C * MATRIX - VECTOR TRANSFORMATION
        CALL GEN002 (1, TTRM1, ORG, ORG, XLNG)
      END IF
      DO J = 1, 3
        ORG(J) = ORG(J) + OSHFT(J)
        IF (ORG(J) < - 0.5) ORG(J) = ORG(J) + 1.0
        IF (ORG(J) >   0.5) ORG(J) = ORG(J) - 1.0
      END DO
      LU = LU6
      IF (LU > 0) THEN
        WRITE (LU6, 99997, IOSTAT = IOST)
        IF (IWIN == 1 .AND. LU /= 0) THEN
          IF (VRT < 7.0) THEN
C * WHAT NEXT ?
            CALL PLA012 (0, 1)
            CALL GGIP (HORS, VERT, 0.0, 1)
            VRT = VERT - 2.0
          END IF
          WRITE (PRBUF, 99987, IOSTAT = IOST)
          VRT = VRT - 0.7
          CALL PLA439 (0.0, PRBUF, 80, 0.35, 5 + IGBL(68), 2, 1.0, VRT)
          CALL GGIP (0.0, 1.0, 0.0, 0)
          CALL GGIP (0.0,  VRT - 0.2, 0.0, 3)
          CALL GGIP (HORS, VRT - 0.2, 0.0, 2)
          VRT = VRT - 0.3
        END IF
      END IF
      CALL GEN003 (ROTM2, DUMMY, DET, 0)
      UNITMAT = GEN135 (ROTM2)
      CALL GEN005 (DUMMY, DUMMY)
      IF (IGBL(63) > 2) THEN
        CALL PLA262 (8)
        WRITE (LU7, 99997, IOSTAT = IOST)
      END IF
      WRITE (PRBUF, 99996, IOSTAT = IOST) (PAT(1, J), J = 1, 3),
     1    (QM(1, J), J = 1, 3), (ROTM2(1, J), J = 1, 3)
      CALL GEN065 (LU, PRBUF, 1, 80, 16)
      IF (IWIN == 1 .AND. LU /= 0) THEN
        VRT = VRT - 0.5
        CALL PLA439 (0.0, PRBUF, 80, 0.35, 1, 2, 1.0, VRT)
      END IF
      IF (IGBL(63) > 2) WRITE (LU7, 99960, IOSTAT = IOST) PRBUF
      WRITE (PRBUF, 99995, IOSTAT = IOST) (PAT(2, J), J = 1, 3),
     1    (QM(2, J), J = 1, 3), (ROTM2(2, J), J = 1, 3)
      CALL GEN065 (LU, PRBUF, 1, 80, 16)
      IF (IWIN == 1 .AND. LU /= 0) THEN
        VRT = VRT - 0.5
        CALL PLA439 (0.0, PRBUF, 80, 0.35, 1, 2, 1.0, VRT)
      END IF
      IF (IGBL(63) > 2)  WRITE (LU7, 99960, IOSTAT = IOST) PRBUF
      WRITE (PRBUF, 99994, IOSTAT = IOST) (PAT(3, J), J = 1, 3),
     1    (QM(3, J), J = 1, 3), (ROTM2(3, J), J = 1, 3), DET
      CALL GEN065 (LU, PRBUF, 1, 80, 16)
      IF (IWIN == 1 .AND. LU /= 0) THEN
        VRT = VRT - 0.5
        CALL PLA439 (0.0, PRBUF, 80, 0.35, 1, 2, 1.0, VRT)
      END IF
      IF (IGBL(63) > 0) WRITE (LU7, 99960, IOSTAT = IOST) PRBUF
      CALL GEN004 (ROTM2, AA, DUMV)
C * TRANSPOSE
      CALL GEN005 (ROTM2, ROTM1)
      CALL GEN004 (DUMV, ROTM1, DUMV)
      CALL GEN026 (-1, DUMV, PAR(143))
      CALL GEN003 (DUMV, ROTM1, DET, 0)
      PAR(100) = SQRT (DET)
      DDIS     = 0.0
      DANG     = 0.0
C * MONOCLINIC
      IF (ISYST == 2) THEN
        DANG = MAX (ABS (PAR(146) - 90.0), DANG)
        DANG = MAX (ABS (PAR(148) - 90.0), DANG)
C * ORTHORHOMBIC
      ELSE IF (ISYST == 3) THEN
        DANG = MAX (ABS (PAR(146) - 90.0), DANG)
        DANG = MAX (ABS (PAR(147) - 90.0), DANG)
        DANG = MAX (ABS (PAR(148) - 90.0), DANG)
C * TETRAGONAL
      ELSE IF (ISYST == 4) THEN
        DDIS = MAX (ABS (PAR(143) - PAR(144)), DDIS)
        DANG = MAX (ABS (PAR(146) - 90.0), DANG)
        DANG = MAX (ABS (PAR(147) - 90.0), DANG)
        DANG = MAX (ABS (PAR(148) - 90.0), DANG)
C * TRIGONAL/HEXAGONAL
      ELSE IF (ISYST == 5 .OR. ISYST == 6) THEN
        DDIS = MAX (ABS (PAR(143) - PAR(144)), DDIS)
        DANG = MAX (ABS (PAR(148) - 120.0), DANG)
C *n CUBIC
      ELSE IF (ISYST == 7) THEN
        DDIS = MAX (ABS (PAR(143) - PAR(144)), DDIS)
        DDIS = MAX (ABS (PAR(143) - PAR(145)), DDIS)
        DDIS = MAX (ABS (PAR(144) - PAR(145)), DDIS)
        DANG = MAX (ABS (PAR(146) - 90.0), DANG)
        DANG = MAX (ABS (PAR(147) - 90.0), DANG)
        DANG = MAX (ABS (PAR(148) - 90.0), DANG)
      END IF
C * PRINT CELL PARAMETERS A, B, C, ALPHA, BETA, GAMMA AND LATTICE TYPE
C * PRINT INPUT, REDUCED AND CONVENTIONAL CELL PARAMETERS
      IF (IGBL(63) > 2) THEN
        JMAX = 2
      ELSE
        JMAX = 1
      END IF
      DO JPRLP = 1, JMAX
        IF (JPRLP == 2) THEN
          LU = LU7
          CALL PLA262 (6)
        ELSE
          LU = LU6
        END IF
        WRITE (LU, 99969, IOSTAT = IOST)
        WRITE (LU, 99998, IOSTAT = IOST)
        WRITE (LU, 99964, IOSTAT = IOST)
        WRITE (LU, 99993, IOSTAT = IOST)
     1    SPGRNM(1)(12:13), (PAR(100 + I), I = 1, 6),
     2    NINT (PAR(98)), KRSYST(2),  LAUEGR
        WRITE (LU, 99992, IOSTAT = IOST)
     1   (PAR(122 + I), I = 1, 6), NINT (PAR(99))
        LAT1 = LAT0
        IF (LAT1 == 5) LAT1 = 6
        KRSYST(3) = XSYST(ISYST)
        CALL GEN020 (-1, KRSYST(3), 1, 12)
        WRITE (LU, 99991, IOSTAT = IOST)
     1    IBVL(LAT1), LATT, (PAR(142 + I), I = 1, 6),
     2    NINT (PAR(100)), KRSYST(3), LGR(MLAUE)
        IF (JPRLP == 1) THEN
          IF (IWIN == 1) THEN
            WRITE (PRBUF, 99998, IOSTAT = IOST)
            VRT = VRT - 0.8
            CALL PLA439 (0.0, PRBUF, 80, 0.35, 5 + IGBL(68), 2, 1.0,
     1                   VRT)
            CALL GGIP (0.0, 1.0, 0.0, 0)
            CALL GGIP (0.0,  VRT - 0.2, 0.0, 3)
            CALL GGIP (HORS, VRT - 0.2, 0.0, 2)
            WRITE (PRBUF, 99993, IOSTAT = IOST)
     1             SPGRNM(1)(12:13), (PAR(100 + I), I = 1, 6),
     2                    NINT (PAR(98)), KRSYST(2),  LAUEGR
            VRT = VRT - 0.8
            CALL PLA439 (0.0, PRBUF, 80, 0.35, 1, 2, 1.0, VRT)
            WRITE (PRBUF, 99992, IOSTAT = IOST)
     1            (PAR(122 + I), I = 1, 6), NINT (PAR(99))
            VRT = VRT - 0.5
            CALL PLA439 (0.0, PRBUF, 80, 0.35, 1, 2, 1.0, VRT)
            LAT1 = LAT0
            IF (LAT1 == 5) LAT1 = 6
            WRITE (PRBUF, 99991, IOSTAT = IOST)
     1        IBVL(LAT1), LATT, (PAR(142 + I), I = 1, 6),
     2        NINT (PAR(100)), KRSYST(3), LGR(MLAUE)
            VRT = VRT - 0.5
            CALL PLA439 (0.0, PRBUF, 80, 0.35, 1, 2, 1.0, VRT)
          END IF
          IF (NLCLP == 1) THEN
            N0 = INDEX (ZSPG, ':')
            IF (N0 /= 0) THEN
              ZSPG0 = ZSPG(1:N0-1)
            ELSE
              ZSPG0 = ZSPG
            END IF
C * REPORT ON NON-STANDARD SETTINGS
            IF (ZSPG0 == SPGRNM(2)(1:7)) THEN
              IF (ABS (PAR(101) - PAR(143)) > 0.01 .OR.
     1            ABS (PAR(102) - PAR(144)) > 0.01 .OR.
     2            ABS (PAR(103) - PAR(145)) > 0.01 .OR.
     3            ABS (PAR(104) - PAR(146)) > 0.1  .OR.
     4            ABS (PAR(105) - PAR(147)) > 0.1  .OR.
     5            ABS (PAR(106) - PAR(148)) > 0.1) THEN
C * TEMPORARY TEST
                IF (SPGRNM(2)(12:12) /= 'o' .AND.
     1              SPGRNM(2)(12:12) /= 'a') THEN
C * ALERT _158
                  CALL PLA236 (158, 0, -999.0, 1.0, ' ', ' ')
                  WRITE (PRBUF, 99983, IOSTAT = IOST)
                  IF (IWIN == 1) THEN
                    VRT = VRT - 0.9
                    CALL PLA439 (0.0, PRBUF, 80, 0.35, 2, 2, 1.0, VRT)
                  END IF
                  WRITE (LU, 99972, IOSTAT = IOST) PRBUF(1:60)
                END IF
              END IF
              IF (SPGRNM(1)(1:1) == ' ') THEN
                NSP = 2
              ELSE
                NSP = 1
              END IF
              WRITE (LU, 99984, IOSTAT = IOST) SPGRNM(NSP)(1:11)
              IF (IWIN == 1) THEN
                IF (ABS (ORG(1)) + ABS (ORG(2)) + ABS (ORG(3)) .GT.
     1              0.001) THEN
                  WRITE (PRBUF, 99988, IOSTAT = IOST)
     1              ORG(1), ORG(2), ORG(3)
                  VRT = VRT - 0.7
                CALL PLA439 (0.0, PRBUF, 80, 0.35, 1, 2, 1.0, VRT)
                END IF
                VRT = VRT - 0.9
                IF (NSGTR == 0) THEN
                  WRITE (PRBUF, 99963, IOSTAT = IOST) SPGRNM(NSP)(1:11)
                  NCOL = 3
                ELSE
                  WRITE (PRBUF, 99971, IOSTAT = IOST) SPGRNM(NSP)(1:11)
                  NCOL = 2
                END IF
                CALL PLA439 (0.0, PRBUF, 80, 0.35, NCOL, 2, 1.0,
     1                       VRT)
              END IF
            ELSE
              IF (INDEX (SPGRNM(2), '?') /= 0) THEN
                IF (LOOPR < 3) THEN
                  JERR = JERR + 1000
                  RETURN
                END IF
                IF (IWIN == 1) THEN
                  VRT = VRT - 0.9
                  WRITE (PRBUF, 99973, IOSTAT = IOST)
                  CALL PLA439 (0.0, PRBUF, 80, 0.35, 2, 2, 1.0, VRT)
                END IF
                WRITE (LU, 99972, IOSTAT = IOST) PRBUF
C * ALERT _114
                CALL PLA236 (114, 0, 1.0, 1.0, ' ', ' ')
              END IF
            END IF
          END IF
        END IF
        IF (DDIS > 0.0001) WRITE (LU, 99967, IOSTAT = IOST) DDIS
        IF (DANG > 0.001)  WRITE (LU, 99966, IOSTAT = IOST) DANG
      END DO
C * REPORT (NEW) SPGR (ZSPG = INPUT, SPGRNM(2)(1:7) = NEW
      IF ((ZSPG /= SPGRNM(2)(1:7) .AND.
     1     SPGRNM(2)(1:1) /= '?') .OR. NLCLP /= 1) THEN
C * REPORT ON CONVENTIONAL SYMMETRY
        WRITE (LU6, 99975, IOSTAT = IOST)
        IF (IGBL(63) > 0) THEN
          CALL PLA262 (-4)
 
          WRITE (LU7, 99975, IOSTAT = IOST)
        END IF
        CALL SGSM (2, ICL, FN, 0, LU6, IERR)
        IF (IGBL(63) > 0) CALL SGSM (2, ICL, FN, 0, LU7, IERR)
        IF (IPR(209) == 0 .AND. IPR(118) == 0 .AND.
     1      IPR(459) == 0) THEN
C * CHECK FOR CSD-CIF
          IF (IGBL(94) == 0) THEN
            IF (SPGRNM(2)(3:7) == '     ') THEN
              ZSPG3 = '       '//SPGRNM(2)(1:2)
            ELSE IF (SPGRNM(2)(4:7) == '    ') THEN
              ZSPG3 = '      '//SPGRNM(2)(1:3)
            ELSE IF (SPGRNM(2)(5:7) == '   ') THEN
              ZSPG3 = '     '//SPGRNM(2)(1:4)
            ELSE IF (SPGRNM(2)(6:7) == '  ') THEN
              ZSPG3 = '    '//SPGRNM(2)(1:5)
            ELSE IF (SPGRNM(2)(7:7) == ' ') THEN
              ZSPG3 = '   '//SPGRNM(2)(1:6)
            ELSE
              ZSPG3 = '  '//SPGRNM(2)(1:7)
            END IF
            IF (ZSPG(1:7) == 'P21/n  ') THEN
              ZSPG2 = '    '//ZSPG(1:5)
            ELSE IF (ZSPG(1:7) == 'I2/n   ') THEN
              ZSPG2 = '     '//ZSPG(1:4)
            ELSE IF (ZSPG(1:7) == 'C2/m   ') THEN
              ZSPG2 = '     '//ZSPG(1:4)
            ELSE IF (ZSPG(1:7) == 'C2/c   ') THEN
              ZSPG2 = '     '//ZSPG(1:4)
            ELSE
              ZSPG2 = '  '//ZSPG
            END IF
C * ALERT _128
            CALL PLA236 (128, 0, -999.0, 1.0, ZSPG2, ZSPG3)
          END IF
          WRITE (PRBUF, 99989, IOSTAT = IOST) ZSPG, SPGRNM(2)(1:7)
          WRITE (LU6, 99961, IOSTAT = IOST) PRBUF(1:80)
          IF (IWIN == 1) THEN
            VRT = VRT - 0.8
            CALL PLA439 (0.0, PRBUF, 80, 0.35, 3, 2, 1.0, VRT)
          END IF
          IF (IGBL(63) > 0) THEN
            CALL PLA262 (2)
            WRITE (LU7, 99961, IOSTAT = IOST) PRBUF(1:80)
          END IF
        END IF
      END IF
C * REPORT ON HIGHER STRUCTURE SYMMETRY
      DO JPRLP = 1, JMAX
        IF (JPRLP == 2) THEN
          LU = LU7
        ELSE
          LU = LU6
        END IF
        IF (IMETRIC > 0) THEN
          IF (JPRLP == 2) CALL PLA262 (2)
          WRITE (LU, 99979, IOSTAT = IOST)
        END IF
 
C * CHECK FOR ADDITIONAL SYMMETRY ELEMENTS(EXCLUDING INVERSION)
        IF (IPR(209) == 0) THEN
C * TEST FOR PSEUDO-SYMMETRY, ADDITIONAL TRANSL.SYMM
          IF (IPR(118) == 0 .AND. IPR(459) == 0
     1      .AND. NSGTR == 0) THEN
            IF (JPRLP == 1) THEN
              CALL PLA015 (0, 5)
            ELSE IF (JPRLP == 2) THEN
              CALL PLA262 (3)
              WRITE (LU, 99985, IOSTAT = IOST)
              IF (IPR(207) /= 0) THEN
                CALL PLA262 (1)
                WRITE (LU, 99970, IOSTAT = IOST)
              END IF
            END IF
          ELSE
C * REPORT POSSIBLE PSEUDO TRANSLATION TO BE CHECKED
            IF (IPR(459) /= 0) THEN
              WRITE (PRBUF, 99977, IOSTAT = IOST)
              IF (JPRLP == 1) THEN
                IF (IWIN == 1) THEN
                  VRT = VRT - 1.0
                  CALL PLA439 (0.0, PRBUF, 80, 0.35, 2, 2, 1.0, VRT)
                END IF
              END IF
              IF (JPRLP == 2) CALL PLA262 (1)
              WRITE (LU, 99974, IOSTAT = IOST) PRBUF
            END IF
C * REPORT POSSIBLE PSEUDO INVERSION TO BE CHECKED
            IF (IPR(118) /= 0) THEN
              WRITE (PRBUF, 99978, IOSTAT = IOST)
              IF (JPRLP == 1) THEN
                IF (IWIN == 1) THEN
                  VRT = VRT - 1.0
                  CALL PLA439 (0.0, PRBUF, 80, 0.35, 2, 2, 1.0, VRT)
                END IF
              END IF
              IF (JPRLP == 2) CALL PLA262 (1)
              WRITE (LU, 99974, IOSTAT = IOST) PRBUF
              CALL PLA262 (1)
              WRITE (LU, 99976, IOSTAT = IOST)
            END IF
          END IF
        ELSE
          IF (JPRLP == 2) CALL PLA262 (12)
          WRITE (LU, 99965, IOSTAT = IOST) ORG(1), ORG(2), ORG(3),
     1          ((DUMMY(I, J), J = 1, 3), -ORG(I), I = 1, 3)
          IF (IGBL(45) > 0) IGBL(45) = - 1
          NNNFIT = MIN (NNNFIT, NFT)
          WRITE (LU, 99999, IOSTAT = IOST)
          IF (SPGRNM(1)(1:11) /= SPGRNM(2)(1:11) .OR.
    