/* SPDX-License-Identifier: MIT */
/*
 * Copyright © 2022 Intel Corporation
 */

#ifndef _XE_WA_
#define _XE_WA_

#include "xe_assert.h"

struct drm_printer;
struct xe_gt;
struct xe_hw_engine;
struct xe_tile;

int xe_wa_device_init(struct xe_device *xe);
int xe_wa_gt_init(struct xe_gt *gt);
void xe_wa_process_device_oob(struct xe_device *xe);
void xe_wa_process_gt_oob(struct xe_gt *gt);
void xe_wa_process_gt(struct xe_gt *gt);
void xe_wa_process_engine(struct xe_hw_engine *hwe);
void xe_wa_process_lrc(struct xe_hw_engine *hwe);
void xe_wa_apply_tile_workarounds(struct xe_tile *tile);
void xe_wa_device_dump(struct xe_device *xe, struct drm_printer *p);
void xe_wa_dump(struct xe_gt *gt, struct drm_printer *p);

/**
 * XE_GT_WA - Out-of-band GT workarounds, to be queried and called as needed.
 * @gt__: gt instance
 * @id__: XE_OOB_<id__>, as generated by build system in generated/xe_wa_oob.h
 */
#define XE_GT_WA(gt__, id__) ({						\
	xe_gt_assert(gt__, (gt__)->wa_active.oob_initialized);		\
	test_bit(XE_WA_OOB_ ## id__, (gt__)->wa_active.oob);		\
})

/**
 * XE_DEVICE_WA - Out-of-band Device workarounds, to be queried and called
 * as needed.
 * @xe__: xe_device
 * @id__: XE_DEVICE_WA_OOB_<id__>, as generated by build system in generated/xe_device_wa_oob.h
 */
#define XE_DEVICE_WA(xe__, id__) ({					\
	xe_assert(xe__, (xe__)->wa_active.oob_initialized);		\
	test_bit(XE_DEVICE_WA_OOB_ ## id__, (xe__)->wa_active.oob);	\
})

#define XE_DEVICE_WA_DISABLE(xe__, id__) ({				\
	xe_assert(xe__, (xe__)->wa_active.oob_initialized);		\
	clear_bit(XE_DEVICE_WA_OOB_ ## id__, (xe__)->wa_active.oob);	\
})

#endif
