/*
 * Decompiled with CFR 0.152.
 */
package com.jsql.view.swing.text.action;

import java.awt.event.ActionEvent;
import java.util.Objects;
import javax.swing.Action;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.TextAction;

public class SilentDeleteTextAction
extends TextAction {
    private final transient Action deleteAction;

    public SilentDeleteTextAction(String name, Action deleteAction) {
        super(name);
        this.deleteAction = deleteAction;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        JTextComponent target = this.getTextComponent(e);
        if (Objects.nonNull(target) && target.isEditable()) {
            Caret caret = target.getCaret();
            int dot = caret.getDot();
            int mark = caret.getMark();
            if ("delete-previous".equals(this.getValue("Name"))) {
                if (dot == 0 && mark == 0) {
                    return;
                }
            } else {
                Document doc = target.getDocument();
                if (dot == mark && doc.getLength() == dot) {
                    return;
                }
            }
        }
        this.deleteAction.actionPerformed(e);
    }
}

