/*
 * Decompiled with CFR 0.152.
 */
package com.jsql.view.swing.action;

import com.jsql.util.LogLevelUtil;
import com.jsql.view.swing.dialog.ReplaceFileChooser;
import com.jsql.view.swing.table.PanelTable;
import com.jsql.view.swing.util.MediatorHelper;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.InvalidPathException;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.table.TableModel;
import javax.swing.text.JTextComponent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ActionSaveTab
extends AbstractAction {
    private static final Logger LOGGER = LogManager.getRootLogger();
    private ReplaceFileChooser replaceFileChooser;

    public ActionSaveTab() {
        try {
            this.replaceFileChooser = new ReplaceFileChooser(MediatorHelper.model().getMediatorUtils().getPreferencesUtil().getPathFile());
        }
        catch (IllegalArgumentException | InternalError | NoSuchMethodError | NullPointerException e) {
            LOGGER.log(LogLevelUtil.CONSOLE_ERROR, "Internal error in JFileChooser, verify your system and see stacktrace in tab Java: {}", (Object)e.getMessage());
            LOGGER.log(LogLevelUtil.CONSOLE_JAVA, e, e);
        }
        this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(83, 128));
        this.putValue("MnemonicKey", 83);
        this.putValue("Name", "Save Tab As...");
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.replaceFileChooser.setDialogTitle("Save Tab As");
        Component componentResult = MediatorHelper.tabResults().getSelectedComponent();
        if (componentResult instanceof PanelTable) {
            JTable table = ((PanelTable)componentResult).getTableValues();
            this.saveToFile(table);
        } else if (componentResult instanceof JScrollPane && ((JScrollPane)componentResult).getViewport().getView() instanceof JTextComponent) {
            JTextComponent textarea = (JTextComponent)((JScrollPane)componentResult).getViewport().getView();
            this.saveToFile(textarea);
        } else {
            LOGGER.log(LogLevelUtil.CONSOLE_ERROR, "Nothing to save");
        }
    }

    private void saveToFile(JComponent textarea) {
        if (textarea == null) {
            return;
        }
        this.replaceFileChooser.updateUI();
        try {
            int stateSave = this.replaceFileChooser.showSaveDialog(MediatorHelper.frame());
            if (stateSave == 0) {
                String folderSelectedFile = this.replaceFileChooser.getCurrentDirectory().toString();
                MediatorHelper.model().getMediatorUtils().getPreferencesUtil().set(folderSelectedFile);
                if (textarea instanceof JTextComponent) {
                    this.saveTextToFile((JTextComponent)textarea);
                } else if (textarea instanceof JTable) {
                    this.saveTableToFile((JTable)textarea);
                }
            }
        }
        catch (InvalidPathException e) {
            LOGGER.log(LogLevelUtil.CONSOLE_JAVA, e, (Throwable)e);
        }
    }

    private void saveTableToFile(JTable tableResults) {
        File fileSelected = this.replaceFileChooser.getSelectedFile();
        try (FileWriter fileWriter = new FileWriter(fileSelected, StandardCharsets.UTF_8);){
            int i;
            TableModel tableModel = tableResults.getModel();
            for (i = 2; i < tableModel.getColumnCount(); ++i) {
                fileWriter.write(tableModel.getColumnName(i) + "\t");
            }
            fileWriter.write("\n");
            for (i = 0; i < tableModel.getRowCount(); ++i) {
                for (int j = 2; j < tableModel.getColumnCount(); ++j) {
                    if (tableModel.getValueAt(i, j) == null) {
                        fileWriter.write("\t");
                        continue;
                    }
                    Object line = tableModel.getValueAt(i, j).toString();
                    line = ((String)line).replace("\n", "\\n").replace("\t", "\\t");
                    line = (String)line + "\t";
                    fileWriter.write((String)line);
                }
                fileWriter.write("\n");
            }
        }
        catch (IOException e) {
            LOGGER.log(LogLevelUtil.CONSOLE_ERROR, String.format("Error writing to %s", fileSelected.getName()), (Object)e.getMessage());
        }
    }

    private void saveTextToFile(JTextComponent textarea) {
        File fileSelected = this.replaceFileChooser.getSelectedFile();
        try (FileWriter fileWriter = new FileWriter(fileSelected, StandardCharsets.UTF_8);
             BufferedWriter fileOut = new BufferedWriter(fileWriter);){
            textarea.write(fileOut);
        }
        catch (IOException e) {
            LOGGER.log(LogLevelUtil.CONSOLE_ERROR, String.format("Error writing to %s", fileSelected.getName()), (Throwable)e);
        }
    }
}

