/*
 * Decompiled with CFR 0.152.
 */
package com.jsql.util;

import com.jsql.model.InjectionModel;
import com.jsql.util.GitUtil;
import com.jsql.util.LogLevelUtil;
import java.net.Socket;
import java.util.Optional;
import java.util.prefs.Preferences;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ProxyUtil {
    private static final Logger LOGGER = LogManager.getRootLogger();
    private String proxyAddressHttp;
    private String proxyAddressHttps;
    private String proxyPortHttp;
    private String proxyPortHttps;
    private boolean isUsingProxyHttp = false;
    private boolean isUsingProxyHttps = false;
    private static final String PROPERTIES_HTTP_PROXY_HOST = "http.proxyHost";
    private static final String PROPERTIES_HTTP_PROXY_PORT = "http.proxyPort";
    private static final String PROPERTIES_HTTPS_PROXY_HOST = "https.proxyHost";
    private static final String PROPERTIES_HTTPS_PROXY_PORT = "https.proxyPort";

    public void setPreferences(boolean isUsingProxyHttp, String proxyAddressHttp, String proxyPortHttp, boolean isUsingProxyHttps, String proxyAddressHttps, String proxyPortHttps) {
        this.setUsingProxyHttp(isUsingProxyHttp);
        this.setProxyAddressHttp(proxyAddressHttp);
        this.setProxyPortHttp(proxyPortHttp);
        this.setUsingProxyHttps(isUsingProxyHttps);
        this.setProxyAddressHttps(proxyAddressHttps);
        this.setProxyPortHttps(proxyPortHttps);
        Preferences prefs = Preferences.userRoot().node(InjectionModel.class.getName());
        prefs.putBoolean("isUsingProxy", this.isUsingProxyHttp());
        prefs.put("proxyAddress", this.getProxyAddressHttp());
        prefs.put("proxyPort", this.getProxyPortHttp());
        prefs.putBoolean("isUsingProxyHttps", this.isUsingProxyHttps());
        prefs.put("proxyAddressHttps", this.getProxyAddressHttps());
        prefs.put("proxyPortHttps", this.getProxyPortHttps());
        if (this.isUsingProxyHttp()) {
            System.setProperty(PROPERTIES_HTTP_PROXY_HOST, this.getProxyAddressHttp());
            System.setProperty(PROPERTIES_HTTP_PROXY_PORT, this.getProxyPortHttp());
        } else {
            System.setProperty(PROPERTIES_HTTP_PROXY_HOST, "");
            System.setProperty(PROPERTIES_HTTP_PROXY_PORT, "");
        }
        if (this.isUsingProxyHttps()) {
            System.setProperty(PROPERTIES_HTTPS_PROXY_HOST, this.getProxyAddressHttps());
            System.setProperty(PROPERTIES_HTTPS_PROXY_PORT, this.getProxyPortHttps());
        } else {
            System.setProperty(PROPERTIES_HTTPS_PROXY_HOST, "");
            System.setProperty(PROPERTIES_HTTPS_PROXY_PORT, "");
        }
    }

    public void initProxy() {
        Preferences preferences = Preferences.userRoot().node(InjectionModel.class.getName());
        this.setUsingProxyHttp(preferences.getBoolean("isUsingProxy", false));
        this.setUsingProxyHttps(preferences.getBoolean("isUsingProxyHttps", false));
        this.setProxyAddressHttp(preferences.get("proxyAddress", "127.0.0.1"));
        this.setProxyPortHttp(preferences.get("proxyPort", "8118"));
        this.setProxyAddressHttps(preferences.get("proxyAddressHttps", "127.0.0.1"));
        this.setProxyPortHttps(preferences.get("proxyPortHttps", "8118"));
        if (this.isUsingProxyHttp()) {
            System.setProperty(PROPERTIES_HTTP_PROXY_HOST, this.getProxyAddressHttp());
            System.setProperty(PROPERTIES_HTTP_PROXY_PORT, this.getProxyPortHttp());
        }
        if (this.isUsingProxyHttps()) {
            System.setProperty(PROPERTIES_HTTPS_PROXY_HOST, this.getProxyAddressHttps());
            System.setProperty(PROPERTIES_HTTPS_PROXY_PORT, this.getProxyPortHttps());
        }
    }

    public boolean isNotLive(GitUtil.ShowOnConsole showOnConsole) {
        boolean isLive = true;
        if (this.isUsingProxyHttp() && StringUtils.isNotEmpty(this.getProxyAddressHttp()) && StringUtils.isNotEmpty(this.getProxyPortHttp())) {
            isLive = this.isSocketOn(showOnConsole, this.getProxyAddressHttp(), this.getProxyPortHttp(), "HTTP");
        }
        if (this.isUsingProxyHttps() && StringUtils.isNotEmpty(this.getProxyAddressHttps()) && StringUtils.isNotEmpty(this.getProxyPortHttps())) {
            isLive = this.isSocketOn(showOnConsole, this.getProxyAddressHttps(), this.getProxyPortHttps(), "HTTPS");
        }
        return !isLive;
    }

    private boolean isSocketOn(GitUtil.ShowOnConsole showOnConsole, String address, String port, String protocol) {
        boolean isSocketOn = true;
        try {
            Socket socket = new Socket(address, Integer.parseInt(port));
            socket.close();
            this.logStatus(showOnConsole, address, port, protocol);
        }
        catch (Exception e) {
            isSocketOn = false;
            this.logStatus(showOnConsole, address, port, protocol, e);
        }
        return isSocketOn;
    }

    private void logStatus(GitUtil.ShowOnConsole showOnConsole, String address, String port, String protocol) {
        if (showOnConsole == GitUtil.ShowOnConsole.YES) {
            LOGGER.log(LogLevelUtil.CONSOLE_SUCCESS, "Connection successful to {} proxy {}:{}", () -> protocol, () -> address, () -> port);
        }
    }

    private void logStatus(GitUtil.ShowOnConsole showOnConsole, String address, String port, String protocol, Exception e) {
        if (showOnConsole == GitUtil.ShowOnConsole.YES) {
            String message = Optional.ofNullable(e.getMessage()).orElse("");
            LOGGER.log(LogLevelUtil.CONSOLE_ERROR, () -> String.format("Connection to %s proxy %s:%s failed, verify your proxy settings: %s", protocol, address, port, message.replace(e.getClass().getName() + ": ", "")));
        }
    }

    public String getProxyAddressHttp() {
        return this.proxyAddressHttp;
    }

    public void setProxyAddressHttp(String proxyAddressHttp) {
        this.proxyAddressHttp = proxyAddressHttp;
    }

    public String getProxyPortHttp() {
        return this.proxyPortHttp;
    }

    public void setProxyPortHttp(String proxyPortHttp) {
        this.proxyPortHttp = proxyPortHttp;
    }

    public boolean isUsingProxyHttp() {
        return this.isUsingProxyHttp;
    }

    public void setUsingProxyHttp(boolean isUsingProxyHttp) {
        this.isUsingProxyHttp = isUsingProxyHttp;
    }

    public String getProxyAddressHttps() {
        return this.proxyAddressHttps;
    }

    public void setProxyAddressHttps(String proxyAddressHttps) {
        this.proxyAddressHttps = proxyAddressHttps;
    }

    public String getProxyPortHttps() {
        return this.proxyPortHttps;
    }

    public void setProxyPortHttps(String proxyPortHttps) {
        this.proxyPortHttps = proxyPortHttps;
    }

    public boolean isUsingProxyHttps() {
        return this.isUsingProxyHttps;
    }

    public void setUsingProxyHttps(boolean isUsingProxyHttps) {
        this.isUsingProxyHttps = isUsingProxyHttps;
    }
}

