/*
 * Decompiled with CFR 0.152.
 */
package com.jsql.util;

import com.jsql.model.InjectionModel;
import com.jsql.model.bean.util.Header;
import com.jsql.model.bean.util.Interaction;
import com.jsql.model.bean.util.Request;
import com.jsql.model.exception.InjectionFailureException;
import com.jsql.model.exception.JSqlException;
import com.jsql.model.injection.method.AbstractMethodInjection;
import com.jsql.util.HeaderUtil;
import com.jsql.util.I18nUtil;
import com.jsql.util.LogLevelUtil;
import java.io.IOException;
import java.net.Authenticator;
import java.net.CookieManager;
import java.net.PasswordAuthentication;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpHeaders;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.security.SecureRandom;
import java.time.Duration;
import java.util.AbstractMap;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.TreeMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ConnectionUtil {
    private static final Logger LOGGER = LogManager.getRootLogger();
    private String urlByUser;
    private String urlBase;
    private AbstractMethodInjection methodInjection;
    private String typeRequest = "GET";
    private final Random randomForUserAgent = new SecureRandom();
    private final InjectionModel injectionModel;
    private final CookieManager cookieManager = new CookieManager();

    public ConnectionUtil(InjectionModel injectionModel) {
        this.injectionModel = injectionModel;
    }

    public HttpClient.Builder getHttpClient() {
        HttpClient.Builder httpClientBuilder = HttpClient.newBuilder().connectTimeout(Duration.ofSeconds(this.getTimeout().intValue())).sslContext(this.injectionModel.getMediatorUtils().getCertificateUtil().getSslContext()).followRedirects(this.injectionModel.getMediatorUtils().getPreferencesUtil().isFollowingRedirection() ? HttpClient.Redirect.ALWAYS : HttpClient.Redirect.NEVER);
        if (this.injectionModel.getMediatorUtils().getPreferencesUtil().isHttp2Disabled()) {
            httpClientBuilder.version(HttpClient.Version.HTTP_1_1);
        }
        if (!this.injectionModel.getMediatorUtils().getPreferencesUtil().isNotProcessingCookies()) {
            httpClientBuilder.cookieHandler(this.cookieManager);
        }
        if (this.injectionModel.getMediatorUtils().getAuthenticationUtil().isAuthentEnabled()) {
            httpClientBuilder.authenticator(new Authenticator(){

                @Override
                protected PasswordAuthentication getPasswordAuthentication() {
                    return new PasswordAuthentication(ConnectionUtil.this.injectionModel.getMediatorUtils().getAuthenticationUtil().getUsernameAuthentication(), ConnectionUtil.this.injectionModel.getMediatorUtils().getAuthenticationUtil().getPasswordAuthentication().toCharArray());
                }
            });
        }
        return httpClientBuilder;
    }

    public static <T> Map<String, String> getHeadersMap(HttpResponse<T> httpResponse) {
        Map<String, String> sortedMap = ConnectionUtil.getHeadersMap(httpResponse.headers());
        String responseCodeHttp = String.valueOf(httpResponse.statusCode());
        sortedMap.put(":status", responseCodeHttp);
        return sortedMap;
    }

    public static Map<String, String> getHeadersMap(HttpHeaders httpHeaders) {
        Map<String, String> unsortedMap = httpHeaders.map().entrySet().stream().sorted(Map.Entry.comparingByKey()).map(entrySet -> new AbstractMap.SimpleEntry<String, String>((String)entrySet.getKey(), String.join((CharSequence)", ", (Iterable)entrySet.getValue()))).collect(Collectors.toMap(AbstractMap.SimpleEntry::getKey, AbstractMap.SimpleEntry::getValue));
        return new TreeMap<String, String>(unsortedMap);
    }

    public HttpResponse<String> checkConnectionResponse() throws IOException, InterruptedException, JSqlException {
        String queryString = this.injectionModel.getMediatorUtils().getParameterUtil().getQueryStringFromEntries();
        Object testUrl = this.getUrlBase().replaceAll("\\?$", "");
        if (StringUtils.isNotEmpty(queryString)) {
            testUrl = (String)testUrl + "?" + queryString;
        }
        String contentTypeRequest = "text/plain";
        String body = this.injectionModel.getMediatorUtils().getParameterUtil().getRawRequest();
        if (this.injectionModel.getMediatorUtils().getParameterUtil().isMultipartRequest()) {
            body = body.replaceAll("(?s)\\\\n", "\r\n");
        } else if (this.injectionModel.getMediatorUtils().getParameterUtil().isRequestSoap()) {
            contentTypeRequest = "text/xml";
        } else if (!this.injectionModel.getMediatorUtils().getParameterUtil().getListRequest().isEmpty()) {
            contentTypeRequest = "application/x-www-form-urlencoded";
        }
        HttpRequest.Builder httpRequest = HttpRequest.newBuilder();
        try {
            httpRequest.uri(URI.create(((String)testUrl).replace("*", "")));
        }
        catch (IllegalArgumentException e) {
            throw new JSqlException(e);
        }
        httpRequest.setHeader("Content-Type", contentTypeRequest).timeout(Duration.ofSeconds(this.getTimeout().intValue()));
        this.injectionModel.getMediatorUtils().getCsrfUtil().addHeaderToken(httpRequest);
        this.injectionModel.getMediatorUtils().getDigestUtil().addHeaderToken(httpRequest);
        httpRequest.method(this.typeRequest, HttpRequest.BodyPublishers.ofString(body));
        for (AbstractMap.SimpleEntry<String, String> header : this.injectionModel.getMediatorUtils().getParameterUtil().getListHeader()) {
            HeaderUtil.sanitizeHeaders(httpRequest, header);
        }
        return this.injectionModel.getMediatorUtils().getHeaderUtil().checkResponseHeader(httpRequest, body);
    }

    public void testConnection() throws IOException, InterruptedException, JSqlException {
        LOGGER.log(LogLevelUtil.CONSOLE_DEFAULT, () -> I18nUtil.valueByKey("LOG_CONNECTION_TEST"));
        this.getCookieManager().getCookieStore().removeAll();
        HttpResponse<String> httpResponse = this.checkConnectionResponse();
        if (!(httpResponse.statusCode() != 401 && httpResponse.statusCode() != 403 || this.injectionModel.getMediatorUtils().getPreferencesUtil().isNotProcessingCookies() || !this.injectionModel.getMediatorUtils().getCsrfUtil().isCsrf() && !this.injectionModel.getMediatorUtils().getDigestUtil().isDigest())) {
            if (this.injectionModel.getMediatorUtils().getPreferencesUtil().isProcessingCsrf()) {
                LOGGER.log(LogLevelUtil.CONSOLE_INFORM, () -> "Testing CSRF handshake from previous connection...");
            } else if (StringUtils.isNotEmpty(this.injectionModel.getMediatorUtils().getDigestUtil().getTokenDigest())) {
                LOGGER.log(LogLevelUtil.CONSOLE_INFORM, () -> "Testing Digest handshake from previous connection...");
            }
            httpResponse = this.checkConnectionResponse();
        }
        if (httpResponse.statusCode() >= 400 && !this.injectionModel.getMediatorUtils().getPreferencesUtil().isNotTestingConnection()) {
            throw new InjectionFailureException(String.format("Connection failed: problem when calling %s", httpResponse.uri().toURL()));
        }
    }

    public String getSourceLineFeed(String url) {
        return this.getSource(url, true, false);
    }

    public String getSource(String url) {
        return this.getSource(url, false, false);
    }

    public String getSource(String url, boolean isConnectIssueIgnored) {
        return this.getSource(url, false, isConnectIssueIgnored);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public String getSource(String url, boolean lineFeed, boolean isConnectIssueIgnored) {
        EnumMap<Header, Object> msgHeader = new EnumMap<Header, Object>(Header.class);
        msgHeader.put(Header.URL, url);
        String pageSource = "";
        try {
            HttpHeaders httpHeaders;
            HttpRequest httpRequest = HttpRequest.newBuilder().uri(URI.create(url)).timeout(Duration.ofSeconds(this.getTimeout().intValue())).build();
            if (lineFeed) {
                HttpResponse<Stream<String>> response = this.getHttpClient().build().send(httpRequest, HttpResponse.BodyHandlers.ofLines());
                pageSource = response.body().collect(Collectors.joining("\n"));
                httpHeaders = response.headers();
            } else {
                HttpResponse<String> response = this.getHttpClient().build().send(httpRequest, HttpResponse.BodyHandlers.ofString());
                pageSource = response.body();
                httpHeaders = response.headers();
            }
            msgHeader.put(Header.RESPONSE, ConnectionUtil.getHeadersMap(httpHeaders));
            msgHeader.put(Header.HEADER, ConnectionUtil.getHeadersMap(httpRequest.headers()));
            msgHeader.put(Header.SOURCE, pageSource);
        }
        catch (IOException e) {
            if (!isConnectIssueIgnored) {
                LOGGER.log(LogLevelUtil.CONSOLE_JAVA, e, (Throwable)e);
            }
            msgHeader.put(Header.SOURCE, pageSource);
            Request request = new Request();
            request.setMessage(Interaction.MESSAGE_HEADER);
            request.setParameters(msgHeader);
            this.injectionModel.sendToViews(request);
        }
        catch (InterruptedException e2) {
            LOGGER.log(LogLevelUtil.IGNORE, e2, (Throwable)e2);
            Thread.currentThread().interrupt();
            msgHeader.put(Header.SOURCE, pageSource);
            {
                catch (Throwable throwable) {
                    msgHeader.put(Header.SOURCE, pageSource);
                    Request request = new Request();
                    request.setMessage(Interaction.MESSAGE_HEADER);
                    request.setParameters(msgHeader);
                    this.injectionModel.sendToViews(request);
                    throw throwable;
                }
            }
            Request request = new Request();
            request.setMessage(Interaction.MESSAGE_HEADER);
            request.setParameters(msgHeader);
            this.injectionModel.sendToViews(request);
        }
        Request request = new Request();
        request.setMessage(Interaction.MESSAGE_HEADER);
        request.setParameters(msgHeader);
        this.injectionModel.sendToViews(request);
        return pageSource.trim();
    }

    public void setCustomUserAgent(HttpRequest.Builder httpRequest) {
        if (this.injectionModel.getMediatorUtils().getPreferencesUtil().isUserAgentRandom()) {
            String agents = this.injectionModel.getMediatorUtils().getUserAgentUtil().getCustomUserAgent();
            List listAgents = Stream.of(agents.split("[\\r\\n]+")).filter(q -> !q.matches("^#.*")).collect(Collectors.toList());
            String randomElement = (String)listAgents.get(this.randomForUserAgent.nextInt(listAgents.size()));
            httpRequest.setHeader("User-Agent", randomElement);
        }
    }

    public ConnectionUtil withMethodInjection(AbstractMethodInjection methodInjection) {
        this.methodInjection = methodInjection;
        return this;
    }

    public ConnectionUtil withTypeRequest(String typeRequest) {
        this.typeRequest = typeRequest;
        return this;
    }

    public String getUrlByUser() {
        return this.urlByUser;
    }

    public void setUrlByUser(String urlByUser) {
        this.urlByUser = urlByUser;
    }

    public String getUrlBase() {
        return this.urlBase;
    }

    public void setUrlBase(String urlBase) {
        this.urlBase = urlBase;
    }

    public AbstractMethodInjection getMethodInjection() {
        return this.methodInjection;
    }

    public void setMethodInjection(AbstractMethodInjection methodInjection) {
        this.methodInjection = methodInjection;
    }

    public String getTypeRequest() {
        return this.typeRequest;
    }

    public void setTypeRequest(String typeRequest) {
        this.typeRequest = typeRequest;
    }

    public Integer getTimeout() {
        return this.injectionModel.getMediatorUtils().getPreferencesUtil().countConnectionTimeout();
    }

    public CookieManager getCookieManager() {
        return this.cookieManager;
    }
}

