/*
 * Decompiled with CFR 0.152.
 */
package com.jsql.model.injection.strategy.blind;

import com.jsql.model.InjectionModel;
import com.jsql.model.exception.StoppedByUserSlidingException;
import com.jsql.model.injection.strategy.blind.AbstractInjectionBit;
import com.jsql.model.injection.strategy.blind.AbstractInjectionMonobit;
import com.jsql.model.injection.strategy.blind.callable.CallableBlindBit;
import com.jsql.model.injection.strategy.blind.patch.Diff;
import com.jsql.model.injection.strategy.blind.patch.DiffMatchPatch;
import com.jsql.util.LogLevelUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class InjectionBlindBit
extends AbstractInjectionMonobit<CallableBlindBit> {
    private static final Logger LOGGER = LogManager.getRootLogger();
    private String sourceReferencePage;
    private List<Diff> falseDiffs = new ArrayList<Diff>();
    private List<Diff> trueDiffs = new ArrayList<Diff>();

    public InjectionBlindBit(InjectionModel injectionModel, AbstractInjectionBit.BlindOperator blindOperator) {
        super(injectionModel, blindOperator);
        List<String> falsys = this.injectionModel.getMediatorVendor().getVendor().instance().getFalsyBit();
        if (falsys.isEmpty() || this.injectionModel.isStoppedByUser()) {
            return;
        }
        this.sourceReferencePage = this.callUrl("", "bit#ref:" + blindOperator.toString().toLowerCase());
        ExecutorService taskExecutor = this.injectionModel.getMediatorUtils().getThreadUtil().getExecutor("CallableGetBlindBitTagFalse");
        ArrayList<CallableBlindBit> callablesFalsys = new ArrayList<CallableBlindBit>();
        for (String falsy : falsys) {
            callablesFalsys.add(new CallableBlindBit(falsy, injectionModel, this, blindOperator, "bit#falsy"));
        }
        try {
            List futuresFalsys = taskExecutor.invokeAll(callablesFalsys);
            this.injectionModel.getMediatorUtils().getThreadUtil().shutdown(taskExecutor);
            for (Future futureFalsy : futuresFalsys) {
                if (this.injectionModel.isStoppedByUser()) {
                    return;
                }
                if (this.falseDiffs.isEmpty()) {
                    this.falseDiffs = ((CallableBlindBit)futureFalsy.get()).getDiffsWithReference();
                    continue;
                }
                this.falseDiffs.retainAll(((CallableBlindBit)futureFalsy.get()).getDiffsWithReference());
            }
        }
        catch (ExecutionException e) {
            LOGGER.log(LogLevelUtil.CONSOLE_JAVA, e, (Throwable)e);
        }
        catch (InterruptedException e) {
            LOGGER.log(LogLevelUtil.IGNORE, e, (Throwable)e);
            Thread.currentThread().interrupt();
        }
        if (this.injectionModel.isStoppedByUser()) {
            return;
        }
        this.cleanTrueDiffs(injectionModel, blindOperator);
    }

    private void cleanTrueDiffs(InjectionModel injectionModel, AbstractInjectionBit.BlindOperator blindOperator) {
        ExecutorService taskExecutor = this.injectionModel.getMediatorUtils().getThreadUtil().getExecutor("CallableGetBlindBitTagTrue");
        ArrayList<CallableBlindBit> callablesTruthys = new ArrayList<CallableBlindBit>();
        List<String> truthys = this.injectionModel.getMediatorVendor().getVendor().instance().getTruthyBit();
        for (String truthy : truthys) {
            callablesTruthys.add(new CallableBlindBit(truthy, injectionModel, this, blindOperator, "bit#truthy"));
        }
        try {
            List futuresTruthys = taskExecutor.invokeAll(callablesTruthys);
            this.injectionModel.getMediatorUtils().getThreadUtil().shutdown(taskExecutor);
            for (Future futureTruthy : futuresTruthys) {
                if (this.injectionModel.isStoppedByUser()) {
                    return;
                }
                if (this.trueDiffs.isEmpty()) {
                    this.trueDiffs = ((CallableBlindBit)futureTruthy.get()).getDiffsWithReference();
                } else {
                    this.trueDiffs.retainAll(((CallableBlindBit)futureTruthy.get()).getDiffsWithReference());
                }
                this.falseDiffs.removeAll(((CallableBlindBit)futureTruthy.get()).getDiffsWithReference());
            }
        }
        catch (ExecutionException e) {
            LOGGER.log(LogLevelUtil.CONSOLE_JAVA, e, (Throwable)e);
        }
        catch (InterruptedException e) {
            LOGGER.log(LogLevelUtil.IGNORE, e, (Throwable)e);
            Thread.currentThread().interrupt();
        }
    }

    @Override
    public CallableBlindBit getCallableBitTest(String sqlQuery, int indexChar, int bit) {
        return new CallableBlindBit(sqlQuery, indexChar, bit, this.injectionModel, this, this.blindOperator, "bit#" + indexChar + "~" + bit);
    }

    @Override
    public boolean isInjectable() throws StoppedByUserSlidingException {
        if (this.injectionModel.isStoppedByUser()) {
            throw new StoppedByUserSlidingException();
        }
        CallableBlindBit callable = new CallableBlindBit(this.injectionModel.getMediatorVendor().getVendor().instance().sqlBlindConfirm(), this.injectionModel, this, this.blindOperator, "bit#confirm");
        try {
            callable.call();
        }
        catch (Exception e) {
            LOGGER.log(LogLevelUtil.CONSOLE_JAVA, e, (Throwable)e);
        }
        return callable.isTrue() && this.trueDiffs.stream().anyMatch(diff -> !DiffMatchPatch.Operation.EQUAL.equals((Object)diff.getOperation())) || this.falseDiffs.stream().anyMatch(diff -> !DiffMatchPatch.Operation.EQUAL.equals((Object)diff.getOperation()));
    }

    @Override
    public String getInfoMessage() {
        return "- Strategy Blind bit: query True when Diffs are matching " + String.valueOf(this.falseDiffs) + "\n\n";
    }

    public String getSourceReferencePage() {
        return this.sourceReferencePage;
    }

    public List<Diff> getFalseDiffs() {
        return this.falseDiffs;
    }

    public List<Diff> getTrueDiffs() {
        return this.trueDiffs;
    }
}

