/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.binary;

import java.io.Closeable;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.jkiss.dbeaver.ui.editors.binary.BinaryContent;
import org.jkiss.dbeaver.utils.ContentUtils;

public class ActionHistory {
    private static final int MERGE_TIME = 1500;
    private BinaryContent.Range actionLastRange = null;
    private BinaryContent content = null;
    private List<Integer> deletedList = null;
    private boolean isBackspace = false;
    private List<Object[]> actionList = null;
    private int actionsIndex = 0;
    private List<BinaryContent.Range> currentAction = null;
    private ActionType currentActionType = null;
    private long mergedSinglesTop = -1L;
    private boolean mergingSingles = false;
    private long previousTime = 0L;
    private long newRangeLength = -1L;
    private long newRangePosition = -1L;

    ActionHistory(BinaryContent aContent) {
        if (aContent == null) {
            throw new NullPointerException("null content");
        }
        this.content = aContent;
        this.actionList = new ArrayList<Object[]>();
    }

    private long actionExclusiveEnd() {
        long newRangeExclusiveEnd;
        long result = 0L;
        if (this.currentAction != null && this.currentAction.size() > 0) {
            BinaryContent.Range highest = this.currentAction.get(this.currentAction.size() - 1);
            result = highest.exclusiveEnd();
        }
        if ((newRangeExclusiveEnd = this.newRangePosition + this.newRangeLength) > result) {
            result = newRangeExclusiveEnd;
        }
        return result;
    }

    private long actionPosition() {
        long result = -1L;
        if (this.currentAction != null && this.currentAction.size() > 0) {
            BinaryContent.Range lowest = this.currentAction.get(0);
            result = lowest.position;
        }
        if (result < 0L || this.newRangePosition >= 0L && this.newRangePosition < result) {
            result = this.newRangePosition;
        }
        return result;
    }

    void addDeleted(long position, List<Integer> integerList, boolean isSingle) {
        if ((long)integerList.size() > 1L || !isSingle) {
            BinaryContent.Range range = this.newRangeFromIntegerList(position, integerList);
            ArrayList<BinaryContent.Range> oneElementList = new ArrayList<BinaryContent.Range>();
            oneElementList.add(range);
            this.addLostRanges(oneElementList);
        } else {
            this.addLostByte(position, integerList.get(0));
        }
        this.previousTime = System.currentTimeMillis();
    }

    void addLostByte(long position, Integer integer) {
        if (this.deletedList == null) {
            this.deletedList = new ArrayList<Integer>();
        }
        this.updateNewRange(position);
        if (this.isBackspace) {
            this.deletedList.add(0, integer);
        } else {
            this.deletedList.add(integer);
        }
        this.previousTime = System.currentTimeMillis();
    }

    void addLostRange(BinaryContent.Range aRange) {
        if (this.mergingSingles) {
            if (this.mergedSinglesTop < 0L) {
                this.mergedSinglesTop = aRange.exclusiveEnd();
            } else if (this.currentActionType == ActionType.DELETE && !this.isBackspace) {
                aRange.position = this.mergedSinglesTop++;
            }
            this.previousTime = System.currentTimeMillis();
        }
        this.mergeRange(aRange);
    }

    void addLostRanges(List<BinaryContent.Range> ranges) {
        if (ranges == null) {
            return;
        }
        for (BinaryContent.Range range : ranges) {
            this.addLostRange(range);
        }
    }

    void addRangeToCurrentAction(BinaryContent.Range aRange) {
        if (this.actionPosition() <= aRange.position) {
            this.currentAction.add(aRange);
        } else {
            this.currentAction.add(0, aRange);
        }
        this.actionLastRange = aRange;
    }

    void addInserted(BinaryContent.Range aRange) {
        this.currentAction.add(aRange);
        this.endAction();
    }

    public boolean canRedo() {
        return this.actionsIndex < this.actionList.size() && this.currentAction == null;
    }

    public boolean canUndo() {
        return this.currentAction != null || this.actionsIndex > 0;
    }

    void dispose() {
        if (this.actionList != null) {
            for (Object[] tuple : this.actionList) {
                List ranges = (List)tuple[1];
                this.disposeRanges(ranges);
            }
            this.actionList = null;
        }
        if (this.currentAction != null) {
            this.disposeRanges(this.currentAction);
            this.currentAction = null;
        }
    }

    private void disposeRanges(List<BinaryContent.Range> ranges) {
        if (ranges == null) {
            return;
        }
        for (BinaryContent.Range range : ranges) {
            if (!(range.data instanceof Closeable)) continue;
            ContentUtils.close((Closeable)((Closeable)range.data));
        }
    }

    void endAction() {
        if (this.currentAction == null) {
            return;
        }
        if (this.mergingSingles) {
            this.newRangeToCurrentAction();
        }
        Object[] tuple = new Object[]{this.currentActionType, this.currentAction};
        this.actionList.subList(this.actionsIndex, this.actionList.size()).clear();
        this.actionList.add(tuple);
        this.actionsIndex = this.actionList.size();
        this.isBackspace = false;
        this.currentActionType = null;
        this.currentAction = null;
        this.actionLastRange = null;
        this.newRangePosition = -1L;
        this.newRangeLength = -1L;
        this.mergedSinglesTop = -1L;
    }

    void eventPreModify(ActionType type, long position, boolean isSingle) {
        if (type != this.currentActionType || !isSingle || System.currentTimeMillis() - this.previousTime > 1500L || (type == ActionType.INSERT || type == ActionType.OVERWRITE) && this.actionExclusiveEnd() != position || type == ActionType.DELETE && this.actionPosition() != position && this.actionPosition() - 1L != position) {
            this.startAction(type, isSingle);
        } else {
            boolean bl = this.isBackspace = this.actionPosition() > position;
        }
        if (isSingle && type == ActionType.INSERT) {
            this.updateNewRange(position);
            this.previousTime = System.currentTimeMillis();
        }
    }

    protected void finalize() throws Throwable {
        this.dispose();
        super.finalize();
    }

    private void mergeRange(BinaryContent.Range aRange) {
        if (this.actionLastRange == null || this.actionLastRange.data != aRange.data) {
            this.newRangeToCurrentAction();
            this.addRangeToCurrentAction(aRange);
        } else {
            if (this.actionLastRange.compareTo(aRange) > 0) {
                this.actionLastRange.position -= aRange.length;
                this.actionLastRange.dataOffset -= aRange.length;
                this.newRangePosition = aRange.position;
            }
            this.actionLastRange.length += aRange.length;
        }
        if (this.currentActionType == ActionType.OVERWRITE && this.mergingSingles) {
            if (this.newRangePosition < 0L) {
                this.newRangePosition = aRange.position;
                this.newRangeLength = 1L;
            } else {
                ++this.newRangeLength;
            }
        }
    }

    private ByteBuffer newBufferFromIntegerList(List<Integer> integerList) {
        ByteBuffer store = ByteBuffer.allocate(integerList.size());
        for (Integer anIntegerList : integerList) {
            store.put(anIntegerList.byteValue());
        }
        store.position(0);
        return store;
    }

    private BinaryContent.Range newRangeFromIntegerList(long position, List<Integer> integerList) {
        ByteBuffer store = this.newBufferFromIntegerList(integerList);
        return new BinaryContent.Range(position, store, true);
    }

    private void newRangeToCurrentAction() {
        BinaryContent.Range newRange;
        if (this.currentActionType == ActionType.DELETE) {
            if (this.deletedList == null) {
                return;
            }
            newRange = this.newRangeFromIntegerList(this.newRangePosition, this.deletedList);
            this.deletedList = null;
        } else {
            if (this.newRangePosition < 0L) {
                return;
            }
            this.content.actionsOn(false);
            this.content.commitChanges();
            this.content.actionsOn(true);
            newRange = (BinaryContent.Range)this.content.getRangeAt(this.newRangePosition).clone();
        }
        this.addRangeToCurrentAction(newRange);
    }

    Object[] redoAction() {
        if (!this.canRedo()) {
            return null;
        }
        return this.actionList.get(this.actionsIndex++);
    }

    private void startAction(ActionType type, boolean isSingle) {
        this.endAction();
        this.currentAction = new ArrayList<BinaryContent.Range>();
        this.currentActionType = type;
        this.mergingSingles = isSingle;
    }

    public String toString() {
        return this.actionList.toString();
    }

    Object[] undoAction() {
        if (!this.canUndo()) {
            return null;
        }
        this.endAction();
        --this.actionsIndex;
        return this.actionList.get(this.actionsIndex);
    }

    private void updateNewRange(long position) {
        if (this.newRangePosition < 0L) {
            this.newRangePosition = position;
            this.newRangeLength = 1L;
        } else {
            if (this.newRangePosition > position) {
                this.newRangePosition = position;
            }
            ++this.newRangeLength;
        }
    }

    static enum ActionType {
        DELETE,
        INSERT,
        OVERWRITE;

    }
}

