This is the resurrected CLC-INTERCAL compiler, starting with (per)version
1.-94.-2 from the author's own archives, now back in active development.

CLC-INTERCAL 1.00 has just escaped and is available from
[the download page](https://uilebheist.srht.site/dist/CLC-INTERCAL-1.00/)
Older (per)versions are also available as downloadable tarballs.

This README file is part of the "Bundle" distribution, which contains
CLC-INTERCAL and all its optional components, each in its own separate
subdirectory, plus a number of other useful things in the "bonus"
directory. To install the components separately, refer to their own
README files, to install the whole bundle read on. (Note that the "bonus"
directory is not available separately at present, only as part of the
bundle distribution).

Documentation about CLC-INTERCAL is available in the "Docs" package.
Some of the files are automatically generated by the build process, so
the "doc/html" directory contains incomplete information. After
building, look in `CLC-INTERCAL-Docs/blib/htmldoc/` for the HTML
documentation, and in `CLC-INTERCAL-Docs/doc/examples/` for some
example programs. Note that the "Docs" package needs to be built
after the rest, as the build process uses the compiler and some
extensions.

A working perl installation with the ability to install modules is
necessary to install CLC-INTERCAL, since most of it is written
in Perl; what is not written in Perl is written in INTERCAL and the
build system will take care to bootstrap the process.

Additionally, the INET package needs the following modules:

    Net::Interface           version 1.0 or newer, see note below
    Socket6                  necessary for IPv6
    IO::Socket::INET6        necessary for IPv6

Socket6 and IO::Socket::INET6 are very likely to be offered as pre-built
packages for most systems, if not they can be obtained from CPAN and
built from sources.

CLC-INTERCAL now comes with its own module to detect network interfaces,
which has been tested on Linux and various BSD variants; if the Makefile.PL
determines that it can be built, it will use it.  If it cannot be built,
it tries to use Net::Interface instead.  For this, the Debian package
libnet-interface-perl and the FreeBSD package p5-Net-Interface work fine
according to our tests; OpenBSD and Gentoo don't provide packages for
it, but it was easy enough to build from sources after applying a small
patch to work with recent version of Perl; for NetBSD, it needed a second
small patch to provide the information we need.  Please see the
[INSTALL file](INSTALL.md) for information on how to find the sources
and our patches.  But our own module worked on all these systems, so
building Net::Interfaces is probably no longer necessary.

The Bundle also includes the INTERCAL calculator, "intercalc", which
can use one of several user interfaces depending on what's installed
and the environment it runs on. The "batch" mode which just gets
expressions and statements from standard input and produces results on
standard output is always available, but the remaining interfaces
require some extra Perl modules to run:

    Term::ReadLine::Gnu      for line-based interface with editing and history
    Curses                   for a full-screen text interface
    Gtk3 or Gtk2             for X-based interface

All our test systems provided packages for these except NetBSD which
did not have a Gtk2 or Gtk3 package available prebuilt for download.

For more information about the required and recommended dependencies
and the packages to install on various operating systems, please see
[INSTALL file](INSTALL.md) or the
[online documentation](https://uilebheist.srht.site/docs/index.html#installing)

After installing the dependencies, to build the package use the standard
sequence of commands:

    perl Makefile.PL       <- see note below about XS-based modules
    make
    make test              <- see note below about syslib tests
    make install           <- as root or sudo

If the build process determines that some XS-based modules can be built
but then the build fails, please retry with:

    perl Makefile.PL --avoid-xs

and if the build succeeds please report a bug including any relevant
details of the system (system architecture and operating system, C compiler
installed and its version, Perl version, and of course the error messages
produced by the failed build) (see the end of this document for a link to
the issue tracker).

If XS build fails for one extension only, this can be disabled while
still keeping XSs for other extensions with one of:

    perl Makefilre.PL --avoid-xs=Base
    perl Makefilre.PL --avoid-xs=INET

Depending on which build failed (the --avoid-xs=EXTENSION option can be
repleatd, or can take a comma-separated list of extensions, however at
present there are only two XS modules, so one of the above commands will
be sufficient).

The "make test" includes, but does not run, two sets of tests for the
C-INTERCAL's system and floating point libraries: these are
CLC-INTERCAL-Base/t/18syslib.i.t and CLC-INTERCAL-Base/t/20floatlib.i.t
and by by default they just say "skipped: see the documentation to run this
test". There main reason why they do not run by default is that they require
the "system library" files, which we don't provide because their licensing
status is unclear; they are included in the C-INTERCAL distribution, so
if that is installed (or the files are obtained in some other way) the tests
can run by setting the environment variable `$ICK_SYSLIB_DIR` to point to a
directory containing these files (syslib.i, floatlib.i and syslib3.3i to
syslib7.7i). For example after installing C-INTERCAL 0.31 one could enable
these extra tests with a command like (sh-like shells):

    ICK_SYSLIB_DIR=/usr/share/ick-0.31 make test

For more information about the installation, and about using CLC-INTERCAL,
please refer to the documentation in the "Docs" package, which is included
in directory CLC-INTERCAL-Docs/doc/html; some files in that directory are
templates which will be filled in by the build process, but the installation
information is all present before building.

The original README file for CLC-INTERCAL 1.-94.-2 can be found in the
CLC-INTERCAL-Base directory, where it describes how to install the base
system; other extensions have their own separate README. Note however that
such installation instructions are unnecessary if you install the whole
bundle using the instructions in this file.

The project is now hosted as a [git repository on
SourceHut](https://git.sr.ht/~uilebheist/CLC-INTERCAL) with a
[todo / bug-tracking list](https://todo.sr.ht/~uilebheist/CLC-INTERCAL)
in the unlikely case somebody uses this and finds a bug.

A very low volume
[mailing list](https://lists.sr.ht/~uilebheist/clc-intercal-announce)
will announce new compiler escapes. Feel free to subscribe to be told
immediately about such important events. Announcements will also be
posted on USENET (`alt.lang.intercal`).

Also available: the [online documentation](https://uilebheist.srht.site/docs/)
is the same as the documentation found in the "Docs" package, but may
contain information about changes to the compiler which will form part
of a future escape. All older escapes are available for download on the
[download page](https://uilebheist.srht.site/dist/)

The Esolang wiki has an
[article about CLC-INTERCAL](https://esolangs.org/wiki/CLC-INTERCAL) which
complements the documentation in the distribution.

