export { Breadcrumb, Request, SdkInfo, Event, Exception, Response, Severity, StackFrame, Stacktrace, Status, Thread, User, } from '@sentry/types';
export { addGlobalEventProcessor, addBreadcrumb, captureException, captureEvent, captureMessage, configureScope, getHubFromCarrier, getCurrentHub, Hub, Scope, setContext, setExtra, setExtras, setTag, setTags, setUser, withScope, } from '@sentry/core';
import { Event } from '@sentry/types';
import { ElectronOptions } from '../common';
import { Electron, OnUncaughtException } from './integrations';
export { MainClient } from './client';
export { MainBackend } from './backend';
export { NetTransport } from './transports/net';
export { Integrations as NodeIntegrations } from '@sentry/node';
export declare const ElectronIntegrations: {
    Electron: typeof Electron;
    OnUncaughtException: typeof OnUncaughtException;
};
/**
 * Init call to node, if no transport is set, we use net of electron
 * @param options ElectronOptions
 */
export declare function init(options: ElectronOptions): void;
/**
 * This function does nothing, call it in the renderer
 */
export declare function showReportDialog(): void;
/**
 * Uploads a native crash dump (Minidump) to Sentry.
 *
 * @param path The relative or absolute path to the minidump.
 * @param event Optional event payload to attach to the minidump.
 */
export declare function captureMinidump(path: string, event?: Event): void;
/**
 * A promise that resolves when all current events have been sent.
 * If you provide a timeout and the queue takes longer to drain the promise returns false.
 *
 * @param timeout Maximum time in ms the client should wait.
 */
export declare function flush(timeout?: number): Promise<boolean>;
/**
 * A promise that resolves when all current events have been sent.
 * If you provide a timeout and the queue takes longer to drain the promise returns false.
 *
 * @param timeout Maximum time in ms the client should wait.
 */
export declare function close(timeout?: number): Promise<boolean>;
//# sourceMappingURL=index.d.ts.map