import { BaseClient, Scope } from '@sentry/core';
import { Event, EventHint } from '@sentry/types';
import { ElectronClient, ElectronOptions } from '../common';
import { MainBackend } from './backend';
/** Frontend implementation for Electron renderer backends. */
export declare class MainClient extends BaseClient<MainBackend, ElectronOptions> implements ElectronClient {
    /**
     * Creates a new Electron SDK instance.
     * @param options Configuration options for this SDK.
     */
    constructor(options: ElectronOptions);
    /**
     * Uploads a native crash dump (Minidump) to Sentry.
     *
     * @param path The relative or absolute path to the minidump.
     * @param event Optional event payload to attach to the minidump.
     * @param scope Optional SDK scope used to upload.
     */
    captureMinidump(path: string, event?: Event, scope?: Scope): string | undefined;
    /**
     * @inheritDoc
     */
    captureEvent(event: Event, hint?: EventHint, scope?: Scope): string | undefined;
    /**
     * Does nothing in main/node
     */
    showReportDialog(_: unknown): void;
    /**
     * @inheritDoc
     */
    protected _prepareEvent(event: Event, scope?: Scope, hint?: EventHint): PromiseLike<Event | null>;
}
//# sourceMappingURL=client.d.ts.map