Object.defineProperty(exports, "__esModule", { value: true });
exports.RendererClient = void 0;
var tslib_1 = require("tslib");
var browser_1 = require("@sentry/browser");
var core_1 = require("@sentry/core");
var utils_1 = require("@sentry/utils");
var backend_1 = require("./backend");
/** Frontend implementation for Electron renderer backends. */
var RendererClient = /** @class */ (function (_super) {
    tslib_1.__extends(RendererClient, _super);
    /**
     * Creates a new Electron SDK instance.
     * @param options Configuration options for this SDK.
     */
    function RendererClient(options) {
        return _super.call(this, backend_1.RendererBackend, options) || this;
    }
    /**
     * Uploads a native crash dump (Minidump) to Sentry.
     *
     * @param path The relative or absolute path to the minidump.
     * @param event Optional event payload to attach to the minidump.
     * @param scope The SDK scope used to upload.
     */
    RendererClient.prototype.captureMinidump = function () {
        utils_1.logger.warn('captureMinidump is a noop on the renderer');
        return undefined;
    };
    /**
     * Basically calling {@link BrowserClient.showReportDialog}
     * @inheritdoc
     */
    RendererClient.prototype.showReportDialog = function (options) {
        if (options === void 0) { options = {}; }
        if (!options.eventId) {
            options.eventId = core_1.getCurrentHub().lastEventId();
        }
        browser_1.injectReportDialog(options);
    };
    /**
     * @inheritDoc
     */
    RendererClient.prototype._prepareEvent = function (event, scope, hint) {
        event.platform = event.platform || 'javascript';
        event.sdk = tslib_1.__assign(tslib_1.__assign({}, event.sdk), { name: browser_1.SDK_NAME, packages: tslib_1.__spreadArray(tslib_1.__spreadArray([], tslib_1.__read(((event.sdk && event.sdk.packages) || []))), [
                {
                    name: 'npm:@sentry/browser',
                    version: browser_1.SDK_VERSION,
                },
            ]), version: browser_1.SDK_VERSION });
        return _super.prototype._prepareEvent.call(this, event, scope, hint);
    };
    return RendererClient;
}(core_1.BaseClient));
exports.RendererClient = RendererClient;
//# sourceMappingURL=client.js.map