Object.defineProperty(exports, "__esModule", { value: true });
exports.supportsGetPathCrashDumps = exports.supportsCrashpadOnWindows = exports.requiresNativeHandlerRenderer = exports.supportsRenderProcessGone = void 0;
var utils_1 = require("@sentry/utils");
/**
 * Parsed Electron version
 */
function version() {
    var version = utils_1.parseSemver(process.versions.electron);
    return { major: version.major || 0, minor: version.minor || 0, patch: version.patch || 0 };
}
/**
 * Electron >=8.4 | >=9.1 | >=10
 * Use `render-process-gone` rather than `crashed`
 */
function supportsRenderProcessGone() {
    var _a = version(), major = _a.major, minor = _a.minor;
    return (major === 8 && minor >= 4) || (major === 9 && minor >= 1) || major >= 10;
}
exports.supportsRenderProcessGone = supportsRenderProcessGone;
/**
 * Electron < 9 requires `crashReporter.start()` in the renderer
 */
function requiresNativeHandlerRenderer() {
    var major = version().major;
    return major < 9;
}
exports.requiresNativeHandlerRenderer = requiresNativeHandlerRenderer;
/**
 * Electron >= 6 uses crashpad on Windows
 */
function supportsCrashpadOnWindows() {
    var major = version().major;
    return major >= 6;
}
exports.supportsCrashpadOnWindows = supportsCrashpadOnWindows;
/**
 * Electron >= 9 supports `app.getPath('crashDumps')` rather than
 * `crashReporter.getCrashesDirectory()`
 */
function supportsGetPathCrashDumps() {
    var major = version().major;
    return major >= 9;
}
exports.supportsGetPathCrashDumps = supportsGetPathCrashDumps;
//# sourceMappingURL=electron-version.js.map