Object.defineProperty(exports, "__esModule", { value: true });
exports.OnUncaughtException = void 0;
var tslib_1 = require("tslib");
var core_1 = require("@sentry/core");
var types_1 = require("@sentry/types");
var utils_1 = require("@sentry/utils");
var electron_1 = require("electron");
/** Capture unhandled erros. */
var OnUncaughtException = /** @class */ (function () {
    /**
     * @inheritDoc
     */
    function OnUncaughtException(_options) {
        if (_options === void 0) { _options = {}; }
        this._options = _options;
        /**
         * @inheritDoc
         */
        this.name = OnUncaughtException.id;
    }
    /**
     * @inheritDoc
     */
    OnUncaughtException.prototype.setupOnce = function () {
        var _this = this;
        global.process.on('uncaughtException', function (error) {
            var self = core_1.getCurrentHub().getIntegration(OnUncaughtException);
            if (self) {
                core_1.getCurrentHub().withScope(function (scope) { return tslib_1.__awaiter(_this, void 0, void 0, function () {
                    var theError, nodeClient, ref, stack, message;
                    var _this = this;
                    return tslib_1.__generator(this, function (_a) {
                        switch (_a.label) {
                            case 0:
                                scope.addEventProcessor(function (event) { return tslib_1.__awaiter(_this, void 0, void 0, function () {
                                    return tslib_1.__generator(this, function (_a) {
                                        return [2 /*return*/, (tslib_1.__assign(tslib_1.__assign({}, event), { level: types_1.Severity.Fatal }))];
                                    });
                                }); });
                                theError = error;
                                if (!utils_1.isError(error) && error.stack) {
                                    theError = new Error();
                                    theError.message = error.message;
                                    theError.stack = error.stack;
                                    theError.name = error.name;
                                }
                                nodeClient = core_1.getCurrentHub().getClient();
                                nodeClient.captureException(theError, { originalException: error }, core_1.getCurrentHub().getScope());
                                return [4 /*yield*/, nodeClient.flush(nodeClient.getOptions().shutdownTimeout || 2000)];
                            case 1:
                                _a.sent();
                                if (this._options.onFatalError) {
                                    this._options.onFatalError(error);
                                }
                                else if (global.process.listenerCount('uncaughtException') <= 2) {
                                    // In addition to this handler there is always one in Electron
                                    // The dialog is only shown if there are no other handlers
                                    // eslint-disable-next-line no-console
                                    console.error('Uncaught Exception:');
                                    // eslint-disable-next-line no-console
                                    console.error(error);
                                    ref = error.stack;
                                    stack = ref !== undefined ? ref : error.name + ": " + error.message;
                                    message = "Uncaught Exception:\n" + stack;
                                    electron_1.dialog.showErrorBox('A JavaScript error occurred in the main process', message);
                                }
                                return [2 /*return*/];
                        }
                    });
                }); });
            }
        });
    };
    /**
     * @inheritDoc
     */
    OnUncaughtException.id = 'OnUncaughtException';
    return OnUncaughtException;
}());
exports.OnUncaughtException = OnUncaughtException;
//# sourceMappingURL=onuncaughtexception.js.map