/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javaws.jnl;

import com.sun.deploy.config.JREInfo;
import com.sun.deploy.util.JVMParameters;
import com.sun.deploy.util.Trace;
import com.sun.deploy.util.TraceLevel;
import com.sun.javaws.jnl.JREDesc;
import com.sun.javaws.jnl.LaunchDesc;
import com.sun.javaws.jnl.LaunchSelection;
import com.sun.javaws.jnl.ResourcesDesc;

public class DefaultMatchJRE
implements LaunchSelection.MatchJREIf {
    private static final boolean DEBUG = false;
    private JREDesc selectedJREDesc;
    private JREInfo selectedJREInfo;
    private boolean matchComplete;
    private boolean matchSecureComplete;
    private boolean matchVersion;
    private boolean matchJVMArgs;
    private boolean matchSecureJVMArgs;
    private long selectedMaxHeap;
    private long selectedInitHeap;
    private String selectedJVMArgString;
    private JVMParameters selectedJVMArgs;

    public DefaultMatchJRE() {
        this.reset(null);
    }

    public boolean hasBeenRun() {
        return null != this.selectedJVMArgs;
    }

    public void beginTraversal(LaunchDesc launchDesc) {
        this.reset(launchDesc);
    }

    private void reset(LaunchDesc launchDesc) {
        this.matchComplete = false;
        this.matchSecureComplete = false;
        this.matchVersion = false;
        this.matchJVMArgs = false;
        this.matchSecureJVMArgs = false;
        this.selectedInitHeap = -1L;
        this.selectedJVMArgString = null;
        this.selectedJREDesc = null;
        this.selectedJREInfo = null;
        if (null == launchDesc) {
            this.selectedMaxHeap = -1L;
            this.selectedJVMArgs = null;
        } else {
            this.selectedMaxHeap = JVMParameters.getDefaultHeapSize();
            this.selectedJVMArgs = new JVMParameters();
        }
    }

    public JREInfo getSelectedJREInfo() {
        return this.selectedJREInfo;
    }

    public JREDesc getSelectedJREDesc() {
        return this.selectedJREDesc;
    }

    public JVMParameters getSelectedJVMParameters() {
        return this.selectedJVMArgs;
    }

    public String getSelectedJVMParameterString() {
        return this.selectedJVMArgString;
    }

    public long getSelectedInitHeapSize() {
        return this.selectedInitHeap;
    }

    public long getSelectedMaxHeapSize() {
        return this.selectedMaxHeap;
    }

    public boolean isRunningJVMSatisfying(boolean bl) {
        if (bl) {
            return this.matchComplete;
        }
        return this.matchSecureComplete;
    }

    public boolean isRunningJVMVersionSatisfying() {
        return this.matchVersion;
    }

    public boolean isRunningJVMArgsSatisfying(boolean bl) {
        if (bl) {
            return this.matchJVMArgs;
        }
        return this.matchSecureJVMArgs;
    }

    public void digest(JREDesc jREDesc, JREInfo jREInfo) {
        this.selectedJREDesc = jREDesc;
        this.selectedJREInfo = jREInfo;
        long l = jREDesc.getMaxHeap();
        if (l > this.selectedMaxHeap) {
            this.selectedMaxHeap = l;
        }
        if ((l = jREDesc.getMinHeap()) > this.selectedInitHeap) {
            this.selectedInitHeap = l;
        }
        this.selectedJVMArgs.parse(jREDesc.getVmArgs());
        l = this.selectedJVMArgs.getMaxHeapSize();
        if (l > this.selectedMaxHeap) {
            this.selectedMaxHeap = l;
        }
        this.selectedJVMArgs.setMaxHeapSize(JVMParameters.getDefaultHeapSize());
    }

    public void digest(LaunchDesc launchDesc) {
        ResourcesDesc resourcesDesc = launchDesc.getResources();
        if (null != resourcesDesc) {
            this.selectedJVMArgs.addProperties(resourcesDesc.getResourcePropertyList());
        }
    }

    public void endTraversal(LaunchDesc launchDesc) {
        if (launchDesc.isApplicationDescriptor() && null == this.selectedJREDesc) {
            throw new InternalError("selectedJREDesc null");
        }
        if (this.selectedInitHeap > 0L && this.selectedInitHeap != JVMParameters.getDefaultHeapSize()) {
            this.selectedJVMArgs.parse("-Xms" + JVMParameters.unparseMemorySpec((long)this.selectedInitHeap));
        }
        this.selectedJVMArgs.setMaxHeapSize(this.selectedMaxHeap);
        this.selectedJVMArgString = this.selectedJVMArgs.getCommandLineArgumentsAsString(false);
        if (this.selectedJREInfo == null) {
            return;
        }
        JREInfo jREInfo = launchDesc.getHomeJRE();
        this.matchVersion = jREInfo.getProductVersion().match(this.selectedJREInfo.getProductVersion());
        JVMParameters jVMParameters = JVMParameters.getRunningJVMParameters();
        if (jVMParameters == null) {
            if (Trace.isTraceLevelEnabled((TraceLevel)TraceLevel.BASIC)) {
                Trace.println((String)("\t Match: Running JVM is not set: want:<" + this.selectedJVMArgs.getCommandLineArgumentsAsString(false) + ">"), (TraceLevel)TraceLevel.BASIC);
            }
            this.matchJVMArgs = false;
            this.matchSecureJVMArgs = false;
        } else if (jVMParameters.satisfies(this.selectedJVMArgs)) {
            this.matchJVMArgs = true;
            this.matchSecureJVMArgs = true;
        } else if (jVMParameters.satisfiesSecure(this.selectedJVMArgs)) {
            this.matchJVMArgs = false;
            this.matchSecureJVMArgs = true;
        } else {
            this.matchJVMArgs = false;
            this.matchSecureJVMArgs = false;
        }
        this.matchComplete = this.matchVersion & this.matchJVMArgs;
        this.matchSecureComplete = this.matchVersion & this.matchSecureJVMArgs;
    }

    public String toString() {
        return "DefaultMatchJRE: \n  JREDesc:    " + this.getSelectedJREDesc() + "\n  JREInfo:    " + this.getSelectedJREInfo() + "\n  Init Heap:  " + this.getSelectedInitHeapSize() + "\n  Max  Heap:  " + this.getSelectedMaxHeapSize() + "\n  Satisfying: " + this.isRunningJVMSatisfying(true) + ", " + this.isRunningJVMSatisfying(false) + "\n  SatisfyingVersion: " + this.isRunningJVMVersionSatisfying() + "\n  SatisfyingJVMArgs: " + this.isRunningJVMArgsSatisfying(true) + ", " + this.isRunningJVMSatisfying(false) + "\n  SatisfyingSecure: " + this.isRunningJVMSatisfying(true) + "\n  Selected JVMParam: " + this.getSelectedJVMParameters() + "\n  Running  JVMParam: " + JVMParameters.getRunningJVMParameters();
    }
}

