/*
 * Decompiled with CFR 0.152.
 */
package org.jcp.xml.dsig.internal.dom;

import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SignatureException;
import java.security.spec.AlgorithmParameterSpec;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.crypto.Mac;
import javax.crypto.SecretKey;
import javax.xml.crypto.MarshalException;
import javax.xml.crypto.dsig.XMLSignContext;
import javax.xml.crypto.dsig.XMLSignatureException;
import javax.xml.crypto.dsig.XMLValidateContext;
import javax.xml.crypto.dsig.spec.HMACParameterSpec;
import javax.xml.crypto.dsig.spec.SignatureMethodParameterSpec;
import org.jcp.xml.dsig.internal.MacOutputStream;
import org.jcp.xml.dsig.internal.dom.DOMSignatureMethod;
import org.jcp.xml.dsig.internal.dom.DOMSignedInfo;
import org.jcp.xml.dsig.internal.dom.DOMUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public abstract class DOMHMACSignatureMethod
extends DOMSignatureMethod {
    private static Logger log = Logger.getLogger("org.jcp.xml.dsig.internal.dom");
    private Mac hmac;
    private int outputLength;
    private boolean outputLengthSet;

    DOMHMACSignatureMethod(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidAlgorithmParameterException {
        super(algorithmParameterSpec);
    }

    DOMHMACSignatureMethod(Element element) throws MarshalException {
        super(element);
    }

    void checkParams(SignatureMethodParameterSpec signatureMethodParameterSpec) throws InvalidAlgorithmParameterException {
        if (signatureMethodParameterSpec != null) {
            if (!(signatureMethodParameterSpec instanceof HMACParameterSpec)) {
                throw new InvalidAlgorithmParameterException("params must be of type HMACParameterSpec");
            }
            this.outputLength = ((HMACParameterSpec)signatureMethodParameterSpec).getOutputLength();
            this.outputLengthSet = true;
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "Setting outputLength from HMACParameterSpec to: " + this.outputLength);
            }
        }
    }

    SignatureMethodParameterSpec unmarshalParams(Element element) throws MarshalException {
        this.outputLength = new Integer(element.getFirstChild().getNodeValue());
        this.outputLengthSet = true;
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "unmarshalled outputLength: " + this.outputLength);
        }
        return new HMACParameterSpec(this.outputLength);
    }

    void marshalParams(Element element, String string) throws MarshalException {
        Document document = DOMUtils.getOwnerDocument(element);
        Element element2 = DOMUtils.createElement(document, "HMACOutputLength", "http://www.w3.org/2000/09/xmldsig#", string);
        element2.appendChild(document.createTextNode(String.valueOf(this.outputLength)));
        element.appendChild(element2);
    }

    boolean verify(Key key, DOMSignedInfo dOMSignedInfo, byte[] byArray, XMLValidateContext xMLValidateContext) throws InvalidKeyException, SignatureException, XMLSignatureException {
        if (key == null || dOMSignedInfo == null || byArray == null) {
            throw new NullPointerException();
        }
        if (!(key instanceof SecretKey)) {
            throw new InvalidKeyException("key must be SecretKey");
        }
        if (this.outputLengthSet && this.outputLength < this.getDigestLength()) {
            throw new XMLSignatureException("HMACOutputLength must not be less than " + this.getDigestLength());
        }
        if (this.hmac == null) {
            try {
                this.hmac = Mac.getInstance(this.getSignatureAlgorithm());
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                throw new XMLSignatureException(noSuchAlgorithmException);
            }
        }
        this.hmac.init((SecretKey)key);
        dOMSignedInfo.canonicalize(xMLValidateContext, new MacOutputStream(this.hmac));
        byte[] byArray2 = this.hmac.doFinal();
        return MessageDigest.isEqual(byArray, byArray2);
    }

    byte[] sign(Key key, DOMSignedInfo dOMSignedInfo, XMLSignContext xMLSignContext) throws InvalidKeyException, XMLSignatureException {
        if (key == null || dOMSignedInfo == null) {
            throw new NullPointerException();
        }
        if (!(key instanceof SecretKey)) {
            throw new InvalidKeyException("key must be SecretKey");
        }
        if (this.outputLengthSet && this.outputLength < this.getDigestLength()) {
            throw new XMLSignatureException("HMACOutputLength must not be less than " + this.getDigestLength());
        }
        if (this.hmac == null) {
            try {
                this.hmac = Mac.getInstance(this.getSignatureAlgorithm());
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                throw new XMLSignatureException(noSuchAlgorithmException);
            }
        }
        this.hmac.init((SecretKey)key);
        dOMSignedInfo.canonicalize(xMLSignContext, new MacOutputStream(this.hmac));
        return this.hmac.doFinal();
    }

    public boolean paramsEqual(AlgorithmParameterSpec algorithmParameterSpec) {
        if (this.getParameterSpec() == algorithmParameterSpec) {
            return true;
        }
        if (!(algorithmParameterSpec instanceof HMACParameterSpec)) {
            return false;
        }
        HMACParameterSpec hMACParameterSpec = (HMACParameterSpec)algorithmParameterSpec;
        return this.outputLength == hMACParameterSpec.getOutputLength();
    }

    abstract int getDigestLength();

    static final class SHA1
    extends DOMHMACSignatureMethod {
        SHA1(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidAlgorithmParameterException {
            super(algorithmParameterSpec);
        }

        SHA1(Element element) throws MarshalException {
            super(element);
        }

        public String getAlgorithm() {
            return "http://www.w3.org/2000/09/xmldsig#hmac-sha1";
        }

        String getSignatureAlgorithm() {
            return "HmacSHA1";
        }

        int getDigestLength() {
            return 160;
        }
    }

    static final class SHA256
    extends DOMHMACSignatureMethod {
        SHA256(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidAlgorithmParameterException {
            super(algorithmParameterSpec);
        }

        SHA256(Element element) throws MarshalException {
            super(element);
        }

        public String getAlgorithm() {
            return "http://www.w3.org/2001/04/xmldsig-more#hmac-sha256";
        }

        String getSignatureAlgorithm() {
            return "HmacSHA256";
        }

        int getDigestLength() {
            return 256;
        }
    }

    static final class SHA384
    extends DOMHMACSignatureMethod {
        SHA384(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidAlgorithmParameterException {
            super(algorithmParameterSpec);
        }

        SHA384(Element element) throws MarshalException {
            super(element);
        }

        public String getAlgorithm() {
            return "http://www.w3.org/2001/04/xmldsig-more#hmac-sha384";
        }

        String getSignatureAlgorithm() {
            return "HmacSHA384";
        }

        int getDigestLength() {
            return 384;
        }
    }

    static final class SHA512
    extends DOMHMACSignatureMethod {
        SHA512(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidAlgorithmParameterException {
            super(algorithmParameterSpec);
        }

        SHA512(Element element) throws MarshalException {
            super(element);
        }

        public String getAlgorithm() {
            return "http://www.w3.org/2001/04/xmldsig-more#hmac-sha512";
        }

        String getSignatureAlgorithm() {
            return "HmacSHA512";
        }

        int getDigestLength() {
            return 512;
        }
    }
}

