// Copyright Amazon.com Inc. or its affiliates. All Rights Reserved.
// SPDX-License-Identifier: Apache-2.0
export function concatBuffers(...inputBuffers) {
    const neededLength = inputBuffers.reduce((sum, buff) => sum + buff.byteLength, 0);
    const outputBuffer = new Uint8Array(neededLength);
    let offset = 0;
    inputBuffers.forEach((buff) => {
        if (ArrayBuffer.isView(buff)) {
            const { buffer, byteOffset, byteLength } = buff;
            outputBuffer.set(new Uint8Array(buffer, byteOffset, byteLength), offset);
        }
        else {
            outputBuffer.set(new Uint8Array(buff), offset);
        }
        offset += buff.byteLength;
    });
    return outputBuffer;
}
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiY29uY2F0X2J1ZmZlcnMuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyIuLi8uLi8uLi9zcmMvY29uY2F0X2J1ZmZlcnMudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IkFBQUEsb0VBQW9FO0FBQ3BFLHNDQUFzQztBQUl0QyxNQUFNLFVBQVUsYUFBYSxDQUMzQixHQUFHLFlBQThDO0lBRWpELE1BQU0sWUFBWSxHQUFHLFlBQVksQ0FBQyxNQUFNLENBQ3RDLENBQUMsR0FBRyxFQUFFLElBQUksRUFBRSxFQUFFLENBQUMsR0FBRyxHQUFHLElBQUksQ0FBQyxVQUFVLEVBQ3BDLENBQUMsQ0FDRixDQUFBO0lBQ0QsTUFBTSxZQUFZLEdBQUcsSUFBSSxVQUFVLENBQUMsWUFBWSxDQUFDLENBQUE7SUFDakQsSUFBSSxNQUFNLEdBQUcsQ0FBQyxDQUFBO0lBRWQsWUFBWSxDQUFDLE9BQU8sQ0FBQyxDQUFDLElBQUksRUFBRSxFQUFFO1FBQzVCLElBQUksV0FBVyxDQUFDLE1BQU0sQ0FBQyxJQUFJLENBQUMsRUFBRTtZQUM1QixNQUFNLEVBQUUsTUFBTSxFQUFFLFVBQVUsRUFBRSxVQUFVLEVBQUUsR0FBRyxJQUFJLENBQUE7WUFDL0MsWUFBWSxDQUFDLEdBQUcsQ0FBQyxJQUFJLFVBQVUsQ0FBQyxNQUFNLEVBQUUsVUFBVSxFQUFFLFVBQVUsQ0FBQyxFQUFFLE1BQU0sQ0FBQyxDQUFBO1NBQ3pFO2FBQU07WUFDTCxZQUFZLENBQUMsR0FBRyxDQUFDLElBQUksVUFBVSxDQUFDLElBQUksQ0FBQyxFQUFFLE1BQU0sQ0FBQyxDQUFBO1NBQy9DO1FBQ0QsTUFBTSxJQUFJLElBQUksQ0FBQyxVQUFVLENBQUE7SUFDM0IsQ0FBQyxDQUFDLENBQUE7SUFFRixPQUFPLFlBQVksQ0FBQTtBQUNyQixDQUFDIn0=