"use strict";
// Copyright Amazon.com Inc. or its affiliates. All Rights Reserved.
// SPDX-License-Identifier: Apache-2.0
Object.defineProperty(exports, "__esModule", { value: true });
exports.UnsupportedAlgorithm = exports.KeyLengthError = exports.HKDFError = void 0;
class HKDFError extends Error {
    constructor(message) {
        super(message);
        Object.setPrototypeOf(this, HKDFError.prototype);
    }
}
exports.HKDFError = HKDFError;
class KeyLengthError extends HKDFError {
    name = 'KeyLengthError';
    constructor(maxLength, algorithm) {
        super('Can not derive keys larger than ' +
            maxLength +
            ' for algorithm:' +
            algorithm);
        Object.setPrototypeOf(this, KeyLengthError.prototype);
    }
}
exports.KeyLengthError = KeyLengthError;
class UnsupportedAlgorithm extends HKDFError {
    name = 'UnsupportedAlgorithm';
    constructor(algorithm) {
        super('Hash algorithm: ' + algorithm + ' is not an implemented algorithm');
        Object.setPrototypeOf(this, UnsupportedAlgorithm.prototype);
    }
}
exports.UnsupportedAlgorithm = UnsupportedAlgorithm;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiZXJyb3JzLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiLi4vLi4vLi4vc3JjL2Vycm9ycy50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiO0FBQUEsb0VBQW9FO0FBQ3BFLHNDQUFzQzs7O0FBRXRDLE1BQWEsU0FBVSxTQUFRLEtBQUs7SUFDbEMsWUFBWSxPQUFnQjtRQUMxQixLQUFLLENBQUMsT0FBTyxDQUFDLENBQUE7UUFDZCxNQUFNLENBQUMsY0FBYyxDQUFDLElBQUksRUFBRSxTQUFTLENBQUMsU0FBUyxDQUFDLENBQUE7SUFDbEQsQ0FBQztDQUNGO0FBTEQsOEJBS0M7QUFFRCxNQUFhLGNBQWUsU0FBUSxTQUFTO0lBQ3BDLElBQUksR0FBRyxnQkFBZ0IsQ0FBQTtJQUM5QixZQUFZLFNBQWlCLEVBQUUsU0FBaUI7UUFDOUMsS0FBSyxDQUNILGtDQUFrQztZQUNoQyxTQUFTO1lBQ1QsaUJBQWlCO1lBQ2pCLFNBQVMsQ0FDWixDQUFBO1FBQ0QsTUFBTSxDQUFDLGNBQWMsQ0FBQyxJQUFJLEVBQUUsY0FBYyxDQUFDLFNBQVMsQ0FBQyxDQUFBO0lBQ3ZELENBQUM7Q0FDRjtBQVhELHdDQVdDO0FBRUQsTUFBYSxvQkFBcUIsU0FBUSxTQUFTO0lBQzFDLElBQUksR0FBRyxzQkFBc0IsQ0FBQTtJQUNwQyxZQUFZLFNBQWlCO1FBQzNCLEtBQUssQ0FBQyxrQkFBa0IsR0FBRyxTQUFTLEdBQUcsa0NBQWtDLENBQUMsQ0FBQTtRQUMxRSxNQUFNLENBQUMsY0FBYyxDQUFDLElBQUksRUFBRSxvQkFBb0IsQ0FBQyxTQUFTLENBQUMsQ0FBQTtJQUM3RCxDQUFDO0NBQ0Y7QUFORCxvREFNQyJ9