/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.hibernate.orm.runtime;

import jakarta.annotation.PreDestroy;
import jakarta.enterprise.context.RequestScoped;
import java.util.HashMap;
import java.util.Map;
import org.hibernate.Session;
import org.hibernate.SessionFactory;

@RequestScoped
public class RequestScopedSessionHolder {
    private final Map<String, Session> sessions = new HashMap<String, Session>();

    public Session getOrCreateSession(String name, SessionFactory factory) {
        return this.sessions.computeIfAbsent(name, n -> factory.openSession());
    }

    @PreDestroy
    public void destroy() {
        for (Map.Entry<String, Session> entry : this.sessions.entrySet()) {
            entry.getValue().close();
        }
    }
}

