/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.sa.jdi;

import com.jetbrains.sa.jdi.BaseLineInfo;
import com.jetbrains.sa.jdi.LineInfo;
import com.jetbrains.sa.jdi.LocalVariableImpl;
import com.jetbrains.sa.jdi.LocationImpl;
import com.jetbrains.sa.jdi.MethodImpl;
import com.jetbrains.sa.jdi.ReferenceTypeImpl;
import com.jetbrains.sa.jdi.SDE;
import com.jetbrains.sa.jdi.StratumLineInfo;
import com.sun.jdi.AbsentInformationException;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import sun.jvm.hotspot.oops.InstanceKlass;
import sun.jvm.hotspot.oops.Klass;
import sun.jvm.hotspot.oops.LineNumberTableElement;
import sun.jvm.hotspot.oops.LocalVariableTableElement;
import sun.jvm.hotspot.oops.Method;
import sun.jvm.hotspot.tools.jcore.ByteCodeRewriter;

public class ConcreteMethodImpl
extends MethodImpl {
    private SoftReference<SoftLocationXRefs> softBaseLocationXRefsRef;
    private SoftReference<SoftLocationXRefs> softOtherLocationXRefsRef;
    private SoftReference<List<LocalVariableImpl>> variablesRef = null;
    private int firstIndex = -1;
    private int lastIndex = -1;
    private SoftReference<byte[]> bytecodesRef = null;

    ConcreteMethodImpl(ReferenceTypeImpl declaringType, Method saMethod) {
        super(declaringType, saMethod);
    }

    @Override
    public int argSlotCount() {
        return (int)this.saMethod.getSizeOfParameters();
    }

    private SoftLocationXRefs getLocations(SDE.Stratum stratum) {
        SoftLocationXRefs info;
        if (stratum.isJava()) {
            return this.getBaseLocations();
        }
        String stratumID = stratum.id();
        SoftLocationXRefs softLocationXRefs = info = this.softOtherLocationXRefsRef == null ? null : this.softOtherLocationXRefsRef.get();
        if (info != null && info.stratumID.equals(stratumID)) {
            return info;
        }
        ArrayList<LocationImpl> lineLocations = new ArrayList<LocationImpl>();
        HashMap<Integer, List<LocationImpl>> lineMapper = new HashMap<Integer, List<LocationImpl>>();
        int lowestLine = -1;
        int highestLine = -1;
        SDE.LineStratum lastLineStratum = null;
        SDE.Stratum baseStratum = this.declaringType.stratum("Java");
        for (LocationImpl loc : this.getBaseLocations().lineLocations) {
            int lineNumber;
            int baseLineNumber = loc.lineNumber(baseStratum);
            SDE.LineStratum lineStratum = stratum.lineStratum(this.declaringType, baseLineNumber);
            if (lineStratum == null || (lineNumber = lineStratum.lineNumber()) == -1 || lineStratum.equals(lastLineStratum)) continue;
            lastLineStratum = lineStratum;
            if (lineNumber > highestLine) {
                highestLine = lineNumber;
            }
            if (lineNumber < lowestLine || lowestLine == -1) {
                lowestLine = lineNumber;
            }
            loc.addStratumLineInfo(new StratumLineInfo(stratumID, lineNumber, lineStratum.sourceName(), lineStratum.sourcePath()));
            lineLocations.add(loc);
            Integer key = lineNumber;
            ArrayList<LocationImpl> mappedLocs = (ArrayList<LocationImpl>)lineMapper.get(key);
            if (mappedLocs == null) {
                mappedLocs = new ArrayList<LocationImpl>(1);
                lineMapper.put(key, mappedLocs);
            }
            mappedLocs.add(loc);
        }
        info = new SoftLocationXRefs(stratumID, lineMapper, lineLocations, lowestLine, highestLine);
        this.softOtherLocationXRefsRef = new SoftReference<SoftLocationXRefs>(info);
        return info;
    }

    private SoftLocationXRefs getBaseLocations() {
        int count;
        SoftLocationXRefs info;
        SoftLocationXRefs softLocationXRefs = info = this.softBaseLocationXRefsRef == null ? null : this.softBaseLocationXRefsRef.get();
        if (info != null) {
            return info;
        }
        byte[] codeBuf = this.bytecodes();
        this.firstIndex = 0;
        this.lastIndex = codeBuf.length - 1;
        boolean hasLineInfo = this.saMethod.hasLineNumberTable();
        LineNumberTableElement[] lntab = null;
        if (hasLineInfo) {
            lntab = this.saMethod.getLineNumberTable();
            count = lntab.length;
        } else {
            count = 0;
        }
        ArrayList<LocationImpl> lineLocations = new ArrayList<LocationImpl>(count);
        HashMap<Integer, List<LocationImpl>> lineMapper = new HashMap<Integer, List<LocationImpl>>();
        int lowestLine = -1;
        int highestLine = -1;
        for (int i = 0; i < count; ++i) {
            long bci = lntab[i].getStartBCI();
            int lineNumber = lntab[i].getLineNumber();
            if (i + 1 != count && bci == (long)lntab[i + 1].getStartBCI()) continue;
            if (lineNumber > highestLine) {
                highestLine = lineNumber;
            }
            if (lineNumber < lowestLine || lowestLine == -1) {
                lowestLine = lineNumber;
            }
            LocationImpl loc = new LocationImpl(this, bci);
            loc.addBaseLineInfo(new BaseLineInfo(lineNumber, this.declaringType));
            lineLocations.add(loc);
            Integer key = lineNumber;
            ArrayList<LocationImpl> mappedLocs = (ArrayList<LocationImpl>)lineMapper.get(key);
            if (mappedLocs == null) {
                mappedLocs = new ArrayList<LocationImpl>(1);
                lineMapper.put(key, mappedLocs);
            }
            mappedLocs.add(loc);
        }
        info = new SoftLocationXRefs("Java", lineMapper, lineLocations, lowestLine, highestLine);
        this.softBaseLocationXRefsRef = new SoftReference<SoftLocationXRefs>(info);
        return info;
    }

    @Override
    public List<LocationImpl> allLineLocations(SDE.Stratum stratum) throws AbsentInformationException {
        List<LocationImpl> lineLocations = this.getLocations((SDE.Stratum)stratum).lineLocations;
        if (lineLocations.size() == 0) {
            throw new AbsentInformationException();
        }
        return Collections.unmodifiableList(lineLocations);
    }

    @Override
    LineInfo codeIndexToLineInfo(SDE.Stratum stratum, long codeIndex) {
        LocationImpl current;
        if (this.firstIndex == -1) {
            this.getBaseLocations();
        }
        if (codeIndex < (long)this.firstIndex || codeIndex > (long)this.lastIndex) {
            throw new InternalError("Location with invalid code index");
        }
        List<LocationImpl> lineLocations = this.getLocations((SDE.Stratum)stratum).lineLocations;
        if (lineLocations.size() == 0) {
            return super.codeIndexToLineInfo(stratum, codeIndex);
        }
        Iterator<LocationImpl> iter = lineLocations.iterator();
        LocationImpl bestMatch = iter.next();
        while (iter.hasNext() && (current = iter.next()).codeIndex() <= codeIndex) {
            bestMatch = current;
        }
        return bestMatch.getLineInfo(stratum);
    }

    @Override
    public List<LocalVariableImpl> variables() throws AbsentInformationException {
        return this.getVariables();
    }

    @Override
    public byte[] bytecodes() {
        byte[] bytecodes;
        byte[] byArray = bytecodes = this.bytecodesRef == null ? null : this.bytecodesRef.get();
        if (bytecodes == null) {
            bytecodes = this.saMethod.getByteCode();
            Klass klass = this.declaringType.ref();
            if (klass instanceof InstanceKlass) {
                new ByteCodeRewriter(this.saMethod, ((InstanceKlass)klass).getConstants(), bytecodes).rewrite();
            }
            this.bytecodesRef = new SoftReference<byte[]>(bytecodes);
        }
        return (byte[])bytecodes.clone();
    }

    private List<LocalVariableImpl> getVariables() throws AbsentInformationException {
        List<LocalVariableImpl> variables;
        List<LocalVariableImpl> list = variables = this.variablesRef == null ? null : this.variablesRef.get();
        if (variables != null) {
            return variables;
        }
        if (this.saMethod.getMaxLocals() == 0L) {
            variables = Collections.unmodifiableList(Collections.emptyList());
            this.variablesRef = new SoftReference<List<LocalVariableImpl>>(variables);
            return variables;
        }
        if (!this.saMethod.hasLocalVariableTable()) {
            throw new AbsentInformationException();
        }
        LocalVariableTableElement[] locals = this.saMethod.getLocalVariableTable();
        int localCount = locals.length;
        variables = new ArrayList<LocalVariableImpl>(localCount);
        for (LocalVariableTableElement local : locals) {
            boolean isInternalName;
            String name = this.saMethod.getConstants().getSymbolAt((long)local.getNameCPIndex()).asString();
            boolean bl = isInternalName = name.startsWith("this") && (name.length() == 4 || name.charAt(4) == '$' || !Character.isJavaIdentifierPart(name.charAt(4)));
            if (isInternalName) continue;
            int slot = local.getSlot();
            long codeIndex = local.getStartBCI();
            int length = local.getLength();
            LocationImpl scopeStart = new LocationImpl(this, codeIndex);
            LocationImpl scopeEnd = new LocationImpl(this, codeIndex + (long)length - 1L);
            String signature = this.saMethod.getConstants().getSymbolAt((long)local.getDescriptorCPIndex()).asString();
            int genericSigIndex = local.getSignatureCPIndex();
            String genericSignature = null;
            if (genericSigIndex != 0) {
                genericSignature = this.saMethod.getConstants().getSymbolAt((long)genericSigIndex).asString();
            }
            LocalVariableImpl variable = new LocalVariableImpl(this, slot, scopeStart, scopeEnd, name, signature, genericSignature);
            variables.add(variable);
        }
        variables = Collections.unmodifiableList(variables);
        this.variablesRef = new SoftReference<List<LocalVariableImpl>>(variables);
        return variables;
    }

    private static class SoftLocationXRefs {
        final String stratumID;
        final Map<Integer, List<LocationImpl>> lineMapper;
        final List<LocationImpl> lineLocations;
        final int lowestLine;
        final int highestLine;

        SoftLocationXRefs(String stratumID, Map<Integer, List<LocationImpl>> lineMapper, List<LocationImpl> lineLocations, int lowestLine, int highestLine) {
            this.stratumID = stratumID;
            this.lineMapper = Collections.unmodifiableMap(lineMapper);
            this.lineLocations = Collections.unmodifiableList(lineLocations);
            this.lowestLine = lowestLine;
            this.highestLine = highestLine;
        }
    }
}

