/*
 * Decompiled with CFR 0.152.
 */
package jogamp.opengl;

import com.jogamp.common.util.IntIntHashMap;
import com.jogamp.opengl.GLException;
import java.nio.IntBuffer;
import java.util.ArrayList;

public class GLStateTracker {
    public static final int MIN_CLIENT_ATTRIB_STACK_DEPTH = 16;
    private volatile boolean enabled = true;
    private PixelStateMap pixelStateMap = new PixelStateMap();
    private final BlendGlobal blendGlobalState = new BlendGlobal();
    private final ArrayList<BlendFuncEq> blendStatePerOutput = new ArrayList(0);
    private final ArrayList<SavedState> stack = new ArrayList(16);

    public GLStateTracker() {
        this.clearStates();
    }

    public final void setEnabled(boolean bl) {
        this.enabled = bl;
    }

    public final boolean isEnabled() {
        return this.enabled;
    }

    public final PixelStateMap getPixelStateMap() {
        return this.pixelStateMap;
    }

    public final BlendGlobal getBlendGlobal() {
        return this.blendGlobalState;
    }

    public final ArrayList<BlendFuncEq> getBlendStatePerOutput() {
        return this.blendStatePerOutput;
    }

    public final boolean getInt(int n, int[] nArray, int n2) {
        int n3;
        if (this.enabled && -1 != (n3 = this.pixelStateMap.states.get(n))) {
            nArray[n2] = n3;
            return true;
        }
        return false;
    }

    public final boolean getInt(int n, IntBuffer intBuffer, int n2) {
        int n3;
        if (this.enabled && -1 != (n3 = this.pixelStateMap.states.get(n))) {
            intBuffer.put(intBuffer.position(), n3);
            return true;
        }
        return false;
    }

    public final void setInt(int n, int n2) {
        if (this.enabled) {
            this.pixelStateMap.states.put(n, n2);
        }
    }

    public final void pushAttrib(int n) {
        if (this.enabled) {
            SavedState savedState = new SavedState();
            if (0 != (n & 1)) {
                savedState.setPixelStateMap(this.pixelStateMap);
            }
            this.stack.add(this.stack.size(), savedState);
        }
    }

    public final void popAttrib() {
        if (this.enabled) {
            if (this.stack.isEmpty()) {
                throw new GLException("stack contains no elements");
            }
            SavedState savedState = this.stack.remove(this.stack.size() - 1);
            if (null == savedState) {
                throw new GLException("null stack element (remaining stack size " + this.stack.size() + ")");
            }
            PixelStateMap pixelStateMap = savedState.getPixelStateMap();
            if (null != pixelStateMap) {
                this.pixelStateMap = pixelStateMap;
            }
        }
    }

    public final void clearStates() {
        this.stack.clear();
        this.pixelStateMap.clearStates();
        this.blendGlobalState.clearStates();
        this.blendStatePerOutput.clear();
    }

    public static class BlendFuncEq {
        int dst_alpha;
        int dst_rgb;
        int src_alpha;
        int src_rgb;
        int eq_alpha;
        int eq_rgb;

        public BlendFuncEq() {
            this.clearStates();
        }

        public BlendFuncEq(BlendFuncEq blendFuncEq) {
            this.set(blendFuncEq);
        }

        public final void clearStates() {
            this.dst_alpha = 0;
            this.dst_rgb = 0;
            this.src_alpha = 1;
            this.src_rgb = 1;
            this.eq_alpha = 32774;
            this.eq_rgb = 32774;
        }

        public final void set(BlendFuncEq blendFuncEq) {
            this.dst_alpha = blendFuncEq.dst_alpha;
            this.dst_rgb = blendFuncEq.dst_rgb;
            this.src_alpha = blendFuncEq.src_alpha;
            this.src_rgb = blendFuncEq.src_rgb;
            this.eq_alpha = blendFuncEq.eq_alpha;
            this.eq_rgb = blendFuncEq.eq_rgb;
        }
    }

    public static class BlendGlobal {
        public float r;
        public float g;
        public float b;
        public float a;
        public boolean enabled;
        public BlendFuncEq state;

        public BlendGlobal() {
            this.state = new BlendFuncEq();
            this.clearStates();
        }

        public BlendGlobal(BlendGlobal blendGlobal) {
            this.set(blendGlobal);
        }

        public final void clearStates() {
            this.r = 0.0f;
            this.g = 0.0f;
            this.b = 0.0f;
            this.a = 0.0f;
            this.enabled = false;
            this.state.clearStates();
        }

        public final void set(BlendGlobal blendGlobal) {
            this.r = blendGlobal.r;
            this.g = blendGlobal.g;
            this.b = blendGlobal.b;
            this.a = blendGlobal.a;
            this.enabled = blendGlobal.enabled;
            this.state.set(blendGlobal.state);
        }
    }

    public static class PixelStateMap {
        private static final int PIXEL_STATE_MAP_CAPACITY = 32;
        private final IntIntHashMap states;

        public PixelStateMap() {
            this.states = new IntIntHashMap(32, 0.75f);
            this.states.setKeyNotFoundValue(-1);
        }

        public PixelStateMap(PixelStateMap pixelStateMap) {
            this.states = (IntIntHashMap)pixelStateMap.states.clone();
        }

        public final void clearStates() {
            this.states.clear();
            this.states.put(3333, 4);
            this.states.put(3328, 0);
            this.states.put(3329, 0);
            this.states.put(3330, 0);
            this.states.put(3331, 0);
            this.states.put(3332, 0);
            this.states.put(32876, 0);
            this.states.put(32875, 0);
            this.states.put(3317, 4);
            this.states.put(3312, 0);
            this.states.put(3313, 0);
            this.states.put(3314, 0);
            this.states.put(3315, 0);
            this.states.put(3316, 0);
            this.states.put(32878, 0);
            this.states.put(32877, 0);
        }
    }

    static class SavedState {
        private PixelStateMap pixelStateMap;

        SavedState() {
        }

        final void setPixelStateMap(PixelStateMap pixelStateMap) {
            this.pixelStateMap = new PixelStateMap(pixelStateMap);
        }

        final PixelStateMap getPixelStateMap() {
            return this.pixelStateMap;
        }
    }
}

