/*
 * Decompiled with CFR 0.152.
 */
package net.schmizz.sshj.userauth.keyprovider;

import java.util.List;
import java.util.Objects;

public class PEMKey {
    private final PEMKeyType pemKeyType;
    private final List<String> headers;
    private final byte[] body;

    PEMKey(PEMKeyType pemKeyType, List<String> headers, byte[] body) {
        this.pemKeyType = Objects.requireNonNull(pemKeyType, "PEM Key Type required");
        this.headers = Objects.requireNonNull(headers, "Headers required");
        this.body = Objects.requireNonNull(body, "Body required");
    }

    PEMKeyType getPemKeyType() {
        return this.pemKeyType;
    }

    List<String> getHeaders() {
        return this.headers;
    }

    byte[] getBody() {
        return (byte[])this.body.clone();
    }

    public static enum PEMKeyType {
        DSA("-----BEGIN DSA PRIVATE KEY-----"),
        EC("-----BEGIN EC PRIVATE KEY-----"),
        RSA("-----BEGIN RSA PRIVATE KEY-----"),
        PKCS8("-----BEGIN PRIVATE KEY-----"),
        PKCS8_ENCRYPTED("-----BEGIN ENCRYPTED PRIVATE KEY-----");

        private final String header;

        private PEMKeyType(String header) {
            this.header = header;
        }

        String getHeader() {
            return this.header;
        }
    }
}

