/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.jdbc.oracle;

import java.io.UnsupportedEncodingException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.StringTokenizer;
import java.util.logging.Level;
import oracle.ons.Notification;
import oracle.ucp.UniversalConnectionPoolException;
import oracle.ucp.diagnostics.DiagnosticsCollectorImpl;
import oracle.ucp.jdbc.oracle.OracleFailoverEventImpl;

final class ONSDatabaseFailoverEvent
extends OracleFailoverEventImpl {
    static final String CLASS_NAME = ONSDatabaseFailoverEvent.class.getName();
    private static final String ONS_FAILOVER_EVENT_DELIMITER = "{} =";

    ONSDatabaseFailoverEvent(Notification n) throws UniversalConnectionPoolException {
        super(n.type());
        String drainTimeout;
        String reason;
        String cardinality;
        String status;
        String db_domain;
        String host;
        String database;
        String instance;
        DiagnosticsCollectorImpl.getCommon().trace(Level.FINEST, CLASS_NAME, "ONSDatabaseFailoverEvent", "Notification: {0}, eventType: {1}, eventBody: {2}", null, null, n, n.type(), n.body());
        String version = n.get("VERSION");
        if (version != null && !version.startsWith("1.")) {
            DiagnosticsCollectorImpl.getCommon().trace(Level.FINEST, CLASS_NAME, "ONSDatabaseFailoverEvent", "Invalid Event version {0}", null, null, version);
            this.setValidity(false);
            return;
        }
        String service = n.get("service");
        if (service != null) {
            this.setServiceName(service.trim().toLowerCase());
        }
        if ((instance = n.get("instance")) != null && !instance.equals(" ")) {
            this.setInstanceName(instance.trim().toLowerCase());
        }
        if ((database = n.get("database")) != null) {
            this.setDbUniqueName(database.trim().toLowerCase());
        }
        if ((host = n.get("host")) != null) {
            this.setHostName(host.trim().toLowerCase());
        }
        if ((db_domain = n.get("db_domain")) != null) {
            this.setDbDomainName(db_domain.trim().toLowerCase());
        }
        if ((status = n.get("status")) != null) {
            this.setStatus(status);
        }
        if ((cardinality = n.get("card")) != null) {
            try {
                this.setCardinality(Integer.parseInt(cardinality));
            }
            catch (NumberFormatException nfe) {
                DiagnosticsCollectorImpl.getCommon().trace(Level.FINEST, CLASS_NAME, "ONSDatabaseFailoverEvent", "invalid cardinality {0}", null, null, nfe.getMessage());
                this.setValidity(false);
                return;
            }
        }
        if ((reason = n.get("reason")) != null) {
            this.setReason(reason.trim().toLowerCase());
        }
        if ((drainTimeout = n.get("drain_timeout")) != null) {
            try {
                this.setDrainTimeout(Integer.parseInt(drainTimeout));
            }
            catch (NumberFormatException nfe) {
                DiagnosticsCollectorImpl.getCommon().trace(Level.FINEST, CLASS_NAME, "ONSDatabaseFailoverEvent", "invalid drain_timeout {0}", null, null, nfe.getMessage());
                this.setValidity(false);
                return;
            }
        }
        String timestampValueStr = null;
        String timezoneValueStr = null;
        String tsprop = n.get("timestamp");
        if (tsprop != null) {
            timestampValueStr = tsprop;
        }
        String tzprop = n.get("timezone");
        if (tsprop != null) {
            timezoneValueStr = "GMT" + tzprop;
        }
        if (timestampValueStr == null && timezoneValueStr == null) {
            DiagnosticsCollectorImpl.getCommon().trace(Level.FINEST, CLASS_NAME, "ONSDatabaseFailoverEvent", "Older server, no timestamp/timezone in HA event", null, null, new Object[0]);
        } else {
            SimpleDateFormat format = timezoneValueStr != null ? new SimpleDateFormat("yyyy-MM-dd HH:mm:ss z") : new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            format.setLenient(false);
            Date ts = null;
            String tsWithZoneString = timezoneValueStr != null ? timestampValueStr + " " + timezoneValueStr : timestampValueStr;
            try {
                ts = format.parse(tsWithZoneString);
            }
            catch (ParseException pe) {
                DiagnosticsCollectorImpl.getCommon().trace(Level.WARNING, CLASS_NAME, "ONSDatabaseFailoverEvent", "Invalid timestamp/timezone in HA event: {0}", null, null, tsWithZoneString);
                this.setValidity(false);
                return;
            }
            if (ts == null) {
                DiagnosticsCollectorImpl.getCommon().trace(Level.WARNING, CLASS_NAME, "ONSDatabaseFailoverEvent", "Invalid timestamp/timezone in HA event: {0}", null, null, tsWithZoneString);
                this.setValidity(false);
                return;
            }
            this.setTimestamp(ts);
            this.setTimeZone(timezoneValueStr);
        }
    }

    ONSDatabaseFailoverEvent(String eventType, byte[] eventBody) throws UniversalConnectionPoolException {
        super(eventType);
        DiagnosticsCollectorImpl.getCommon().trace(Level.FINEST, CLASS_NAME, "ONSDatabaseFailoverEvent", "EventType: {0}, eventBody: {1}", null, null, eventType, eventBody);
        StringTokenizer strTokens = null;
        try {
            strTokens = new StringTokenizer(new String(eventBody, "UTF-8"), ONS_FAILOVER_EVENT_DELIMITER, true);
        }
        catch (UnsupportedEncodingException e) {
            DiagnosticsCollectorImpl.getCommon().trace(Level.WARNING, CLASS_NAME, "ONSDatabaseFailoverEvent", "", null, e, new Object[0]);
        }
        String st = null;
        String val = null;
        String key = null;
        String timestampValueStr = null;
        String timezoneValueStr = null;
        while (strTokens.hasMoreTokens()) {
            val = null;
            st = strTokens.nextToken();
            if (st.equals("=") && strTokens.hasMoreTokens()) {
                val = strTokens.nextToken();
            } else {
                key = st;
            }
            if (key.equalsIgnoreCase("version") && val != null && !val.startsWith("1.")) {
                DiagnosticsCollectorImpl.getCommon().trace(Level.FINEST, CLASS_NAME, "ONSDatabaseFailoverEvent", "Invalid Event version {0}", null, null, val);
                this.setValidity(false);
                return;
            }
            if (key.equalsIgnoreCase("service") && val != null) {
                this.setServiceName(val.trim().toLowerCase());
                continue;
            }
            if (key.equalsIgnoreCase("instance") && val != null && !val.equals(" ")) {
                this.setInstanceName(val.trim().toLowerCase());
                continue;
            }
            if (key.equalsIgnoreCase("database") && val != null) {
                this.setDbUniqueName(val.trim().toLowerCase());
                continue;
            }
            if (key.equalsIgnoreCase("host") && val != null) {
                this.setHostName(val.trim().toLowerCase());
                continue;
            }
            if (key.equalsIgnoreCase("db_domain") && val != null) {
                this.setDbDomainName(val.trim().toLowerCase());
                continue;
            }
            if (key.equalsIgnoreCase("status") && val != null) {
                this.setStatus(val);
                continue;
            }
            if (key.equalsIgnoreCase("card") && val != null) {
                try {
                    this.setCardinality(Integer.parseInt(val));
                    continue;
                }
                catch (NumberFormatException nfe) {
                    DiagnosticsCollectorImpl.getCommon().trace(Level.FINEST, CLASS_NAME, "ONSDatabaseFailoverEvent", "invalid cardinality {0}", null, null, nfe.getMessage());
                    this.setValidity(false);
                    return;
                }
            }
            if (key.equalsIgnoreCase("reason") && val != null) {
                this.setReason(val.trim().toLowerCase());
                continue;
            }
            if (key.equalsIgnoreCase("timestamp") && val != null) {
                String space = strTokens.nextToken();
                String hmsValue = strTokens.nextToken();
                timestampValueStr = val + " " + hmsValue;
                continue;
            }
            if (key.equalsIgnoreCase("timezone") && val != null) {
                timezoneValueStr = "GMT" + val;
                continue;
            }
            if (!key.equalsIgnoreCase("drain_timeout") || val == null) continue;
            try {
                this.setDrainTimeout(Integer.parseInt(val));
            }
            catch (NumberFormatException nfe) {
                DiagnosticsCollectorImpl.getCommon().trace(Level.FINEST, CLASS_NAME, "ONSDatabaseFailoverEvent", "invalid drain_timeout {0}", null, null, nfe.getMessage());
                this.setValidity(false);
                return;
            }
        }
        if (timestampValueStr == null && timezoneValueStr == null) {
            DiagnosticsCollectorImpl.getCommon().trace(Level.FINEST, CLASS_NAME, "ONSDatabaseFailoverEvent", "Older server, no timestamp/timezone in HA event", null, null, new Object[0]);
        } else {
            SimpleDateFormat format = timezoneValueStr != null ? new SimpleDateFormat("yyyy-MM-dd HH:mm:ss z") : new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            format.setLenient(false);
            Date ts = null;
            String tsWithZoneString = timezoneValueStr != null ? timestampValueStr + " " + timezoneValueStr : timestampValueStr;
            try {
                ts = format.parse(tsWithZoneString);
            }
            catch (ParseException pe) {
                DiagnosticsCollectorImpl.getCommon().trace(Level.WARNING, CLASS_NAME, "ONSDatabaseFailoverEvent", "Invalid timestamp/timezone in HA event: {0}", null, null, tsWithZoneString);
                this.setValidity(false);
                return;
            }
            if (ts == null) {
                DiagnosticsCollectorImpl.getCommon().trace(Level.WARNING, CLASS_NAME, "ONSDatabaseFailoverEvent", "Invalid timestamp/timezone in HA event: {0}", null, null, tsWithZoneString);
                this.setValidity(false);
                return;
            }
            this.setTimestamp(ts);
            this.setTimeZone(timezoneValueStr);
        }
        strTokens = null;
    }
}

