/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.plaf.BorderUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicBorders;
import javax.swing.plaf.basic.BasicTextAreaUI;
import org.jvnet.lafwidget.LafWidget;
import org.jvnet.lafwidget.LafWidgetRepository;
import org.jvnet.lafwidget.animation.FadeStateListener;
import org.jvnet.lafwidget.layout.TransitionLayout;
import org.jvnet.lafwidget.utils.RenderingUtils;
import org.jvnet.substance.SubstanceLookAndFeel;
import org.jvnet.substance.utils.SubstanceColorUtilities;
import org.jvnet.substance.utils.SubstanceCoreUtilities;
import org.jvnet.substance.utils.SubstanceSizeUtils;
import org.jvnet.substance.utils.SubstanceTextUtilities;
import org.jvnet.substance.utils.border.SubstanceBorder;

public class SubstanceTextAreaUI
extends BasicTextAreaUI {
    protected Set lafWidgets;
    protected FadeStateListener substanceFadeStateListener;
    protected JTextArea textArea;
    protected PropertyChangeListener substancePropertyChangeListener;

    public void __org__jvnet__substance__SubstanceTextAreaUI__update(Graphics graphics, JComponent jComponent) {
        super.update(graphics, jComponent);
    }

    @Override
    public void update(Graphics graphics, JComponent jComponent) {
        Object object;
        Graphics2D graphics2D = (Graphics2D)graphics;
        Composite composite = graphics2D.getComposite();
        float f = 1.0f;
        if (composite instanceof AlphaComposite && ((AlphaComposite)(object = (AlphaComposite)composite)).getRule() == 3) {
            f = ((AlphaComposite)object).getAlpha();
        }
        graphics2D.setComposite(TransitionLayout.getAlphaComposite((Component)jComponent, f));
        object = RenderingUtils.installDesktopHints(graphics2D, jComponent);
        this.__org__jvnet__substance__SubstanceTextAreaUI__update(graphics2D, jComponent);
        graphics2D.setComposite(composite);
        if (object != null) {
            graphics2D.addRenderingHints((Map<?, ?>)object);
        }
    }

    public void __org__jvnet__substance__SubstanceTextAreaUI__installUI(JComponent jComponent) {
        super.installUI(jComponent);
    }

    @Override
    public void installUI(JComponent jComponent) {
        this.lafWidgets = LafWidgetRepository.getRepository().getMatchingWidgets(jComponent);
        this.__org__jvnet__substance__SubstanceTextAreaUI__installUI(jComponent);
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.installUI();
        }
    }

    public void __org__jvnet__substance__SubstanceTextAreaUI__uninstallUI(JComponent jComponent) {
        super.uninstallUI(jComponent);
    }

    @Override
    public void uninstallUI(JComponent jComponent) {
        this.__org__jvnet__substance__SubstanceTextAreaUI__uninstallUI(jComponent);
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.uninstallUI();
        }
    }

    @Override
    protected void installListeners() {
        this.__org__jvnet__substance__SubstanceTextAreaUI__installListeners();
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.installListeners();
        }
    }

    @Override
    protected void installDefaults() {
        this.__org__jvnet__substance__SubstanceTextAreaUI__installDefaults();
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.installDefaults();
        }
    }

    @Override
    protected void uninstallListeners() {
        this.__org__jvnet__substance__SubstanceTextAreaUI__uninstallListeners();
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.uninstallListeners();
        }
    }

    protected void __org__jvnet__substance__SubstanceTextAreaUI__uninstallDefaults() {
        super.uninstallDefaults();
    }

    @Override
    protected void uninstallDefaults() {
        this.__org__jvnet__substance__SubstanceTextAreaUI__uninstallDefaults();
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.uninstallDefaults();
        }
    }

    public static ComponentUI createUI(JComponent comp) {
        SubstanceCoreUtilities.testComponentCreationThreadingViolation(comp);
        return new SubstanceTextAreaUI(comp);
    }

    public SubstanceTextAreaUI(JComponent c) {
        this.textArea = (JTextArea)c;
    }

    protected void __org__jvnet__substance__SubstanceTextAreaUI__installListeners() {
        super.installListeners();
        this.substanceFadeStateListener = new FadeStateListener(this.textArea, null, null);
        this.substanceFadeStateListener.registerListeners(false);
        this.substancePropertyChangeListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if ("font".equals(evt.getPropertyName())) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            int caretPos = SubstanceTextAreaUI.this.textArea.getCaretPosition();
                            SubstanceTextAreaUI.this.textArea.updateUI();
                            SubstanceTextAreaUI.this.textArea.setCaretPosition(caretPos);
                        }
                    });
                }
                if ("componentOrientation".equals(evt.getPropertyName())) {
                    SubstanceTextAreaUI.this.getComponent().setText(SubstanceTextAreaUI.this.getComponent().getText());
                }
            }
        };
        this.textArea.addPropertyChangeListener(this.substancePropertyChangeListener);
    }

    protected void __org__jvnet__substance__SubstanceTextAreaUI__uninstallListeners() {
        this.substanceFadeStateListener.unregisterListeners();
        this.substanceFadeStateListener = null;
        this.textArea.removePropertyChangeListener(this.substancePropertyChangeListener);
        this.substancePropertyChangeListener = null;
        super.uninstallListeners();
    }

    protected void __org__jvnet__substance__SubstanceTextAreaUI__installDefaults() {
        Color foregr;
        super.installDefaults();
        Border b = this.textArea.getBorder();
        if (b == null || b instanceof UIResource) {
            BorderUIResource.CompoundBorderUIResource newB = new BorderUIResource.CompoundBorderUIResource(new SubstanceBorder(SubstanceSizeUtils.getTextBorderInsets(SubstanceSizeUtils.getComponentFontSize(this.textArea))), new BasicBorders.MarginBorder());
            this.textArea.setBorder(newB);
        }
        if ((foregr = this.textArea.getForeground()) == null || foregr instanceof UIResource) {
            this.textArea.setForeground(SubstanceColorUtilities.getForegroundColor(SubstanceLookAndFeel.getCurrentSkin(this.textArea).getMainDefaultColorScheme()));
        }
    }

    @Override
    protected void paintBackground(Graphics g) {
        SubstanceTextUtilities.paintTextCompBackground(g, this.textArea);
    }
}

