/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.math.matrix;

import com.carrotsearch.hppc.sorting.IndirectSort;
import java.util.Arrays;
import java.util.function.IntBinaryOperator;
import org.carrot2.math.mahout.function.DoubleFunction;
import org.carrot2.math.mahout.function.Functions;
import org.carrot2.math.mahout.function.IntIntDoubleFunction;
import org.carrot2.math.mahout.matrix.DoubleMatrix2D;

public class MatrixUtils {
    public static DoubleMatrix2D normalizeColumnL2(DoubleMatrix2D A, double[] work) {
        work = MatrixUtils.prepareWork(A, work);
        for (int r = 0; r < A.rows(); ++r) {
            for (int c = 0; c < A.columns(); ++c) {
                int n = c;
                work[n] = work[n] + A.getQuick(r, c) * A.getQuick(r, c);
            }
        }
        for (int c = 0; c < A.columns(); ++c) {
            work[c] = Math.sqrt(work[c]);
        }
        MatrixUtils.normalizeColumns(A, work);
        return A;
    }

    public static DoubleMatrix2D normalizeSparseColumnL2(final DoubleMatrix2D A, double[] work) {
        final double[] w = MatrixUtils.prepareWork(A, work);
        A.forEachNonZero(new IntIntDoubleFunction(){

            @Override
            public double apply(int row, int column, double value) {
                int n = column;
                w[n] = w[n] + value * value;
                return value;
            }
        });
        for (int c = 0; c < A.columns(); ++c) {
            w[c] = Math.sqrt(w[c]);
        }
        A.forEachNonZero(new IntIntDoubleFunction(){

            @Override
            public double apply(int row, int column, double value) {
                A.setQuick(row, column, value / w[column]);
                return 0.0;
            }
        });
        return A;
    }

    public static DoubleMatrix2D normalizeColumnL1(DoubleMatrix2D A, double[] work) {
        work = MatrixUtils.prepareWork(A, work);
        for (int r = 0; r < A.rows(); ++r) {
            for (int c = 0; c < A.columns(); ++c) {
                int n = c;
                work[n] = work[n] + A.getQuick(r, c);
            }
        }
        MatrixUtils.normalizeColumns(A, work);
        return A;
    }

    private static double[] prepareWork(DoubleMatrix2D A, double[] work) {
        if (work == null || work.length != A.columns()) {
            work = new double[A.columns()];
        } else {
            Arrays.fill(work, 0.0);
        }
        return work;
    }

    private static void normalizeColumns(DoubleMatrix2D A, double[] work) {
        for (int r = A.rows() - 1; r >= 0; --r) {
            for (int c = 0; c < A.columns(); ++c) {
                if (work[c] == 0.0) continue;
                A.setQuick(r, c, A.getQuick(r, c) / work[c]);
            }
        }
    }

    public static double computeOrthogonality(DoubleMatrix2D A) {
        double orthogonality = 0.0;
        DoubleMatrix2D cosines = A.zMult(A, null, 1.0, 0.0, true, false);
        for (int r = 0; r < cosines.rows(); ++r) {
            for (int c = r + 1; c < cosines.columns(); ++c) {
                orthogonality += cosines.getQuick(r, c);
            }
        }
        return orthogonality / ((double)((cosines.rows() - 1) * cosines.rows()) / 2.0);
    }

    public static double computeSparseness(DoubleMatrix2D A) {
        int count = 0;
        for (int r = 0; r < A.rows(); ++r) {
            for (int c = 0; c < A.columns(); ++c) {
                if (A.getQuick(r, c) == 0.0) continue;
                ++count;
            }
        }
        return (double)count / (double)(A.rows() * A.columns());
    }

    public static int[] minInColumns(DoubleMatrix2D A, int[] indices, double[] minValues) {
        return MatrixUtils.inColumns(A, indices, minValues, DoubleComparators.REVERSED_ORDER, Functions.IDENTITY);
    }

    public static int[] maxInColumns(DoubleMatrix2D A, int[] indices, double[] maxValues) {
        return MatrixUtils.maxInColumns(A, indices, maxValues, Functions.IDENTITY);
    }

    public static int[] maxInColumns(DoubleMatrix2D A, int[] indices, double[] maxValues, DoubleFunction transform) {
        return MatrixUtils.inColumns(A, indices, maxValues, DoubleComparators.NATURAL_ORDER, transform);
    }

    private static int[] inColumns(DoubleMatrix2D A, int[] indices, double[] extValues, DoubleComparator doubleComparator, DoubleFunction transform) {
        if (indices == null) {
            indices = new int[A.columns()];
        }
        if (A.columns() == 0 || A.rows() == 0) {
            return indices;
        }
        if (extValues == null) {
            extValues = new double[A.columns()];
        }
        for (int c = 0; c < A.columns(); ++c) {
            extValues[c] = transform.apply(A.getQuick(0, c));
        }
        Arrays.fill(indices, 0);
        for (int r = 1; r < A.rows(); ++r) {
            for (int c = 0; c < A.columns(); ++c) {
                double transformed = transform.apply(A.getQuick(r, c));
                if (doubleComparator.compare(transformed, extValues[c]) <= 0) continue;
                extValues[c] = transformed;
                indices[c] = r;
            }
        }
        return indices;
    }

    public static int maxInRow(DoubleMatrix2D A, int row) {
        int index = 0;
        double max = A.getQuick(row, index);
        for (int c = 1; c < A.columns(); ++c) {
            if (!(max < A.getQuick(row, c))) continue;
            max = A.getQuick(row, c);
            index = c;
        }
        return index;
    }

    public static double[] sumRows(DoubleMatrix2D A, double[] sums) {
        if (sums == null || A.rows() != sums.length) {
            sums = new double[A.rows()];
        } else {
            Arrays.fill(sums, 0.0);
        }
        for (int r = 0; r < A.rows(); ++r) {
            for (int c = 0; c < A.columns(); ++c) {
                int n = r;
                sums[n] = sums[n] + A.getQuick(r, c);
            }
        }
        return sums;
    }

    public static double frobeniusNorm(DoubleMatrix2D matrix) {
        return Math.sqrt(matrix.aggregate(Functions.PLUS, Functions.SQUARE));
    }

    public static DoubleMatrix2D sortedRowsView(DoubleMatrix2D matrix, IntBinaryOperator comparator) {
        return matrix.viewSelection(IndirectSort.mergesort((int)0, (int)matrix.rows(), (IntBinaryOperator)comparator), null);
    }

    private static final class DoubleComparators {
        public static final DoubleComparator NATURAL_ORDER = new NaturalOrderDoubleComparator();
        public static final DoubleComparator REVERSED_ORDER = new ReversedOrderDoubleComparator();

        private DoubleComparators() {
        }

        private static class ReversedOrderDoubleComparator
        implements DoubleComparator {
            private ReversedOrderDoubleComparator() {
            }

            @Override
            public int compare(double v1, double v2) {
                return -Double.compare(v1, v2);
            }
        }

        private static class NaturalOrderDoubleComparator
        implements DoubleComparator {
            private NaturalOrderDoubleComparator() {
            }

            @Override
            public int compare(double v1, double v2) {
                return Double.compare(v1, v2);
            }
        }
    }

    private static interface DoubleComparator {
        public int compare(double var1, double var3);
    }
}

