/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.security.hadoop;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.net.URISyntaxException;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiConsumer;
import org.apache.http.HttpRequest;
import org.apache.http.client.methods.HttpRequestWrapper;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.protocol.HttpContext;
import org.apache.solr.client.solrj.impl.Http2SolrClient;
import org.apache.solr.client.solrj.impl.HttpClientBuilderFactory;
import org.apache.solr.client.solrj.impl.SolrHttpClientBuilder;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.request.SolrRequestInfo;
import org.apache.solr.security.HttpClientBuilderPlugin;
import org.apache.solr.security.hadoop.HadoopAuthPlugin;
import org.apache.solr.servlet.SolrDispatchFilter;
import org.eclipse.jetty.client.api.Request;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigurableInternodeAuthHadoopPlugin
extends HadoopAuthPlugin
implements HttpClientBuilderPlugin {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final String HTTPCLIENT_BUILDER_FACTORY = "clientBuilderFactory";
    private static final String DO_AS = "doAs";
    private HttpClientBuilderFactory factory = null;

    public ConfigurableInternodeAuthHadoopPlugin(CoreContainer coreContainer) {
        super(coreContainer);
    }

    @Override
    public void init(Map<String, Object> pluginConfig) {
        super.init(pluginConfig);
        String httpClientBuilderFactory = (String)Objects.requireNonNull(pluginConfig.get(HTTPCLIENT_BUILDER_FACTORY), "Please specify clientBuilderFactory to be used for Solr internal communication.");
        this.factory = (HttpClientBuilderFactory)this.coreContainer.getResourceLoader().newInstance(httpClientBuilderFactory, HttpClientBuilderFactory.class);
    }

    public void setup(Http2SolrClient client) {
        this.factory.setup(client);
    }

    public SolrHttpClientBuilder getHttpClientBuilder(SolrHttpClientBuilder builder) {
        return this.factory.getHttpClientBuilder(builder);
    }

    @Override
    public void close() throws IOException {
        super.close();
        if (this.factory != null) {
            this.factory.close();
        }
    }

    public boolean interceptInternodeRequest(HttpRequest httpRequest, HttpContext httpContext) {
        if (!(httpRequest instanceof HttpRequestWrapper)) {
            log.warn("Unable to add doAs to forwarded/distributed request - unknown request type");
            return false;
        }
        AtomicBoolean success = new AtomicBoolean(false);
        return this.intercept((key, value) -> {
            HttpRequestWrapper request = (HttpRequestWrapper)httpRequest;
            URIBuilder uriBuilder = new URIBuilder(request.getURI());
            uriBuilder.setParameter(key, value);
            try {
                request.setURI(uriBuilder.build());
                success.set(true);
            }
            catch (URISyntaxException e) {
                log.warn("Unable to add doAs to forwarded/distributed request - bad URI");
            }
        }) && success.get();
    }

    protected boolean interceptInternodeRequest(Request request) {
        return this.intercept((arg_0, arg_1) -> ((Request)request).param(arg_0, arg_1));
    }

    private boolean intercept(BiConsumer<String, String> setParam) {
        SolrRequestInfo info = SolrRequestInfo.getRequestInfo();
        if (info != null && (info.getAction() == SolrDispatchFilter.Action.FORWARD || info.getAction() == SolrDispatchFilter.Action.REMOTEQUERY) && info.getUserPrincipal() != null) {
            String name = info.getUserPrincipal().getName();
            log.debug("Setting doAs={} to forwarded/remote request", (Object)name);
            setParam.accept(DO_AS, name);
            return true;
        }
        return false;
    }
}

