/*
 * Decompiled with CFR 0.152.
 */
package com.github.junrar.rarfile;

import com.github.junrar.io.Raw;
import com.github.junrar.rarfile.BaseBlock;
import com.github.junrar.rarfile.UnrarHeadertype;

public class EndArcHeader
extends BaseBlock {
    public static final short endArcArchiveDataCrcSize = 4;
    public static final short endArcVolumeNumberSize = 2;
    private int archiveDataCRC;
    private short volumeNumber;

    public EndArcHeader(BaseBlock bb, byte[] endArcHeader) {
        super(bb);
        int pos = 0;
        if (this.hasArchiveDataCRC()) {
            this.archiveDataCRC = Raw.readIntLittleEndian(endArcHeader, pos);
            pos += 4;
        }
        if (this.hasVolumeNumber()) {
            this.volumeNumber = Raw.readShortLittleEndian(endArcHeader, pos);
        }
    }

    public boolean isValid() {
        if (this.getHeadCRC() != 15812) {
            return false;
        }
        if (this.getHeaderType() != UnrarHeadertype.EndArcHeader) {
            return false;
        }
        if (this.getFlags() != 16384) {
            return false;
        }
        return this.getHeaderSize(false) == 7;
    }

    public int getArchiveDataCRC() {
        return this.archiveDataCRC;
    }

    public short getVolumeNumber() {
        return this.volumeNumber;
    }
}

