/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.microsoft;

import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.input.CloseShieldInputStream;
import org.apache.poi.hdgf.extractor.VisioTextExtractor;
import org.apache.poi.hpbf.extractor.PublisherTextExtractor;
import org.apache.poi.poifs.crypt.Decryptor;
import org.apache.poi.poifs.crypt.EncryptionInfo;
import org.apache.poi.poifs.filesystem.DirectoryEntry;
import org.apache.poi.poifs.filesystem.DirectoryNode;
import org.apache.poi.poifs.filesystem.Entry;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.apache.poi.poifs.macros.VBAMacroReader;
import org.apache.poi.util.IOUtils;
import org.apache.poi.util.LocaleUtil;
import org.apache.tika.exception.EncryptedDocumentException;
import org.apache.tika.exception.TikaException;
import org.apache.tika.extractor.EmbeddedDocumentExtractor;
import org.apache.tika.extractor.EmbeddedDocumentUtil;
import org.apache.tika.io.TikaInputStream;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.metadata.TikaCoreProperties;
import org.apache.tika.mime.MediaType;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.PasswordProvider;
import org.apache.tika.parser.microsoft.AbstractOfficeParser;
import org.apache.tika.parser.microsoft.ExcelExtractor;
import org.apache.tika.parser.microsoft.HSLFExtractor;
import org.apache.tika.parser.microsoft.OfficeParserConfig;
import org.apache.tika.parser.microsoft.OutlookExtractor;
import org.apache.tika.parser.microsoft.POIFSContainerDetector;
import org.apache.tika.parser.microsoft.SummaryExtractor;
import org.apache.tika.parser.microsoft.WordExtractor;
import org.apache.tika.parser.microsoft.ooxml.OOXMLParser;
import org.apache.tika.sax.BodyContentHandler;
import org.apache.tika.sax.EmbeddedContentHandler;
import org.apache.tika.sax.XHTMLContentHandler;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class OfficeParser
extends AbstractOfficeParser {
    private static final long serialVersionUID = 7393462244028653479L;
    private static final Set<MediaType> SUPPORTED_TYPES = Collections.unmodifiableSet(new HashSet<MediaType>(Arrays.asList(POIFSDocumentType.access$000(POIFSDocumentType.WORKBOOK), POIFSDocumentType.access$000(POIFSDocumentType.OLE10_NATIVE), POIFSDocumentType.access$000(POIFSDocumentType.WORDDOCUMENT), POIFSDocumentType.access$000(POIFSDocumentType.UNKNOWN), POIFSDocumentType.access$000(POIFSDocumentType.ENCRYPTED), POIFSDocumentType.access$000(POIFSDocumentType.POWERPOINT), POIFSDocumentType.access$000(POIFSDocumentType.PUBLISHER), POIFSDocumentType.access$000(POIFSDocumentType.PROJECT), POIFSDocumentType.access$000(POIFSDocumentType.VISIO), POIFSDocumentType.access$000(POIFSDocumentType.XLR), POIFSDocumentType.access$000(POIFSDocumentType.OUTLOOK), POIFSDocumentType.access$000(POIFSDocumentType.SOLIDWORKS_PART), POIFSDocumentType.access$000(POIFSDocumentType.SOLIDWORKS_ASSEMBLY), POIFSDocumentType.access$000(POIFSDocumentType.SOLIDWORKS_DRAWING))));

    public Set<MediaType> getSupportedTypes(ParseContext context) {
        return SUPPORTED_TYPES;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parse(InputStream stream, ContentHandler handler, Metadata metadata, ParseContext context) throws IOException, SAXException, TikaException {
        this.configure(context);
        XHTMLContentHandler xhtml = new XHTMLContentHandler(handler, metadata);
        xhtml.startDocument();
        TikaInputStream tstream = TikaInputStream.cast((InputStream)stream);
        POIFSFileSystem mustCloseFs = null;
        try {
            DirectoryNode root;
            if (tstream == null) {
                mustCloseFs = new POIFSFileSystem((InputStream)new CloseShieldInputStream(stream));
                root = mustCloseFs.getRoot();
            } else {
                Object container = tstream.getOpenContainer();
                if (container instanceof POIFSFileSystem) {
                    root = ((POIFSFileSystem)container).getRoot();
                } else if (container instanceof DirectoryNode) {
                    root = (DirectoryNode)container;
                } else {
                    POIFSFileSystem fs = null;
                    fs = tstream.hasFile() ? new POIFSFileSystem(tstream.getFile(), true) : new POIFSFileSystem((InputStream)new CloseShieldInputStream((InputStream)tstream));
                    tstream.setOpenContainer((Object)fs);
                    root = fs.getRoot();
                }
            }
            this.parse(root, context, metadata, xhtml);
            OfficeParserConfig officeParserConfig = (OfficeParserConfig)context.get(OfficeParserConfig.class);
            if (officeParserConfig.getExtractMacros()) {
                OfficeParser.extractMacros(root.getFileSystem(), (ContentHandler)xhtml, EmbeddedDocumentUtil.getEmbeddedDocumentExtractor((ParseContext)context));
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(mustCloseFs);
            throw throwable;
        }
        IOUtils.closeQuietly((Closeable)mustCloseFs);
        xhtml.endDocument();
    }

    /*
     * Unable to fully structure code
     */
    protected void parse(DirectoryNode root, ParseContext context, Metadata metadata, XHTMLContentHandler xhtml) throws IOException, SAXException, TikaException {
        new SummaryExtractor(metadata).parseSummaries(root);
        type = POIFSDocumentType.detectType((DirectoryEntry)root);
        if (type != POIFSDocumentType.UNKNOWN) {
            this.setType(metadata, type.getType());
        }
        switch (1.$SwitchMap$org$apache$tika$parser$microsoft$OfficeParser$POIFSDocumentType[type.ordinal()]) {
            case 1: 
            case 2: 
            case 3: {
                break;
            }
            case 4: {
                publisherTextExtractor = new PublisherTextExtractor(root);
                xhtml.element("p", publisherTextExtractor.getText());
                break;
            }
            case 5: {
                new WordExtractor(context, metadata).parse(root, xhtml);
                break;
            }
            case 6: {
                new HSLFExtractor(context, metadata).parse(root, xhtml);
                break;
            }
            case 7: 
            case 8: {
                locale = (Locale)context.get(Locale.class, (Object)LocaleUtil.getUserLocale());
                new ExcelExtractor(context, metadata).parse(root, xhtml, locale);
                break;
            }
            case 9: {
                break;
            }
            case 10: {
                visioTextExtractor = new VisioTextExtractor(root);
                for (String text : visioTextExtractor.getAllText()) {
                    xhtml.element("p", text);
                }
                break;
            }
            case 11: {
                extractor = new OutlookExtractor(root, metadata, context);
                extractor.parse(xhtml, metadata);
                break;
            }
            case 12: {
                info = new EncryptionInfo(root);
                d = Decryptor.getInstance((EncryptionInfo)info);
                try {
                    password = "VelvetSweatshop";
                    passwordProvider = (PasswordProvider)context.get(PasswordProvider.class);
                    if (passwordProvider != null && (suppliedPassword = passwordProvider.getPassword(metadata)) != null) {
                        password = suppliedPassword;
                    }
                    if (!d.verifyPassword(password)) {
                        throw new EncryptedDocumentException();
                    }
                    parser = new OOXMLParser();
                    tis = TikaInputStream.get((InputStream)d.getDataStream(root));
                    var16_21 = null;
                    parser.parse((InputStream)tis, (ContentHandler)new EmbeddedContentHandler((ContentHandler)new BodyContentHandler((ContentHandler)xhtml)), metadata, context);
                    if (tis == null) break;
                    if (var16_21 == null) ** GOTO lbl57
                    try {
                        tis.close();
                    }
                    catch (Throwable var17_22) {
                        var16_21.addSuppressed(var17_22);
                    }
                    break;
lbl57:
                    // 1 sources

                    tis.close();
                    ** break;
                    catch (Throwable var17_23) {
                        try {
                            var16_21 = var17_23;
                            throw var17_23;
                        }
                        catch (Throwable var18_24) {
                            if (tis != null) {
                                if (var16_21 != null) {
                                    try {
                                        tis.close();
                                    }
                                    catch (Throwable var19_25) {
                                        var16_21.addSuppressed(var19_25);
                                    }
                                } else {
                                    tis.close();
                                }
                            }
                            throw var18_24;
lbl74:
                            // 1 sources

                            break;
                        }
                    }
                }
                catch (GeneralSecurityException ex) {
                    throw new EncryptedDocumentException((Throwable)ex);
                }
            }
        }
    }

    private void setType(Metadata metadata, MediaType type) {
        metadata.set("Content-Type", type.toString());
    }

    public static void extractMacros(POIFSFileSystem fs, ContentHandler xhtml, EmbeddedDocumentExtractor embeddedDocumentExtractor) throws IOException, SAXException {
        VBAMacroReader reader = null;
        Map macros = null;
        try {
            reader = new VBAMacroReader(fs);
            macros = reader.readMacros();
        }
        catch (SecurityException e) {
            throw e;
        }
        catch (Exception e) {
            Metadata m = new Metadata();
            m.set(TikaCoreProperties.EMBEDDED_RESOURCE_TYPE, TikaCoreProperties.EmbeddedResourceType.MACRO.toString());
            m.set("Content-Type", "text/x-vbasic");
            EmbeddedDocumentUtil.recordException((Throwable)e, (Metadata)m);
            if (embeddedDocumentExtractor.shouldParseEmbedded(m)) {
                embeddedDocumentExtractor.parseEmbedded((InputStream)new ByteArrayInputStream(new byte[]{32}), xhtml, m, true);
            }
            return;
        }
        for (Map.Entry e : macros.entrySet()) {
            Metadata m = new Metadata();
            m.set("embeddedResourceType", TikaCoreProperties.EmbeddedResourceType.MACRO.toString());
            m.set("Content-Type", "text/x-vbasic");
            if (!embeddedDocumentExtractor.shouldParseEmbedded(m)) continue;
            embeddedDocumentExtractor.parseEmbedded((InputStream)new ByteArrayInputStream(((String)e.getValue()).getBytes(StandardCharsets.UTF_8)), xhtml, m, true);
        }
    }

    public static enum POIFSDocumentType {
        WORKBOOK("xls", MediaType.application((String)"vnd.ms-excel")),
        OLE10_NATIVE("ole", POIFSContainerDetector.OLE10_NATIVE),
        COMP_OBJ("ole", POIFSContainerDetector.COMP_OBJ),
        WORDDOCUMENT("doc", MediaType.application((String)"msword")),
        UNKNOWN("unknown", MediaType.application((String)"x-tika-msoffice")),
        ENCRYPTED("ole", MediaType.application((String)"x-tika-ooxml-protected")),
        POWERPOINT("ppt", MediaType.application((String)"vnd.ms-powerpoint")),
        PUBLISHER("pub", MediaType.application((String)"x-mspublisher")),
        PROJECT("mpp", MediaType.application((String)"vnd.ms-project")),
        VISIO("vsd", MediaType.application((String)"vnd.visio")),
        WORKS("wps", MediaType.application((String)"vnd.ms-works")),
        XLR("xlr", MediaType.application((String)"x-tika-msworks-spreadsheet")),
        OUTLOOK("msg", MediaType.application((String)"vnd.ms-outlook")),
        SOLIDWORKS_PART("sldprt", MediaType.application((String)"sldworks")),
        SOLIDWORKS_ASSEMBLY("sldasm", MediaType.application((String)"sldworks")),
        SOLIDWORKS_DRAWING("slddrw", MediaType.application((String)"sldworks")),
        GRAPH("", MediaType.application((String)"vnd.ms-graph"));

        private final String extension;
        private final MediaType type;

        private POIFSDocumentType(String extension, MediaType type) {
            this.extension = extension;
            this.type = type;
        }

        public static POIFSDocumentType detectType(POIFSFileSystem fs) {
            return POIFSDocumentType.detectType((DirectoryEntry)fs.getRoot());
        }

        public static POIFSDocumentType detectType(DirectoryEntry node) {
            HashSet<String> names = new HashSet<String>();
            for (Entry entry : node) {
                names.add(entry.getName());
            }
            MediaType type = POIFSContainerDetector.detect(names, node);
            for (POIFSDocumentType poifsType : POIFSDocumentType.values()) {
                if (!type.equals((Object)poifsType.type)) continue;
                return poifsType;
            }
            return UNKNOWN;
        }

        public String getExtension() {
            return this.extension;
        }

        public MediaType getType() {
            return this.type;
        }

        static /* synthetic */ MediaType access$000(POIFSDocumentType x0) {
            return x0.type;
        }
    }
}

