/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.journal;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.apache.tika.exception.TikaException;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.utils.XMLReaderUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class TEIDOMParser {
    public Metadata parse(String source, ParseContext parseContext) throws TikaException, SAXException, IOException {
        Document root = XMLReaderUtils.buildDOM((InputStream)new ByteArrayInputStream(source.getBytes(StandardCharsets.UTF_8)), (ParseContext)parseContext);
        Metadata metadata = new Metadata();
        this.createGrobidMetadata(source, root.getDocumentElement(), metadata);
        return metadata;
    }

    private void createGrobidMetadata(String source, Element root, Metadata metadata) {
        if (root != null) {
            Node profileDesc;
            Node teiHeader;
            Node fileDesc;
            Node text = TEIDOMParser.getFirstChild(root.getChildNodes(), "text");
            if (text != null) {
                this.parseText(text, metadata);
            }
            if ((fileDesc = TEIDOMParser.getFirstChild((teiHeader = TEIDOMParser.getFirstChild(root.getChildNodes(), "teiHeader")).getChildNodes(), "fileDesc")) != null) {
                this.parseFileDesc(fileDesc, metadata);
            }
            if ((profileDesc = TEIDOMParser.getFirstChild(teiHeader.getChildNodes(), "profileDesc")) != null) {
                this.parseProfileDesc(profileDesc, metadata);
            }
        }
        this.addStaticMet(source, root, metadata);
    }

    private void addStaticMet(String source, Element obj, Metadata metadata) {
        metadata.add("Class", Metadata.class.getName());
        metadata.add("TEIXMLSource", source);
    }

    private void parseText(Node text, Metadata metadata) {
        String lang = TEIDOMParser.getFirstAttribute(text, "xml", "lang");
        if (lang != null) {
            metadata.add("Language", lang);
        }
    }

    private void parseFileDesc(Node fileDesc, Metadata metadata) {
        Node sourceDesc;
        Node titleStmt = TEIDOMParser.getFirstChild(fileDesc.getChildNodes(), "titleStmt");
        if (titleStmt != null) {
            this.parseTitleStmt(titleStmt, metadata);
        }
        if ((sourceDesc = TEIDOMParser.getFirstChild(fileDesc.getChildNodes(), "sourceDesc")) != null) {
            this.parseSourceDesc(sourceDesc, metadata);
        }
    }

    private void parseTitleStmt(Node titleStmt, Metadata metadata) {
        String titleText;
        Node title = TEIDOMParser.getFirstChild(titleStmt.getChildNodes(), "title");
        if (title != null && (titleText = title.getTextContent()) != null) {
            metadata.add("Title", titleText);
        }
    }

    private void parseSourceDesc(Node sourceDesc, Metadata metadata) {
        Node biblStruct = TEIDOMParser.getFirstChild(sourceDesc.getChildNodes(), "biblStruct");
        if (biblStruct != null) {
            this.parseBiblStruct(biblStruct, metadata);
        }
    }

    private void parseBiblStruct(Node biblStruct, Metadata metadata) {
        Node analytic = TEIDOMParser.getFirstChild(biblStruct.getChildNodes(), "analytic");
        if (analytic != null) {
            List<Node> authorNodes = TEIDOMParser.getChildNodes(analytic.getChildNodes(), "author");
            ArrayList<Author> authorList = new ArrayList<Author>();
            for (Node authorNode : authorNodes) {
                this.parseAuthor(authorNode, authorList);
            }
            metadata.add("Address", this.getMetadataAddresses(authorList));
            metadata.add("Affiliation", this.getMetadataAffiliations(authorList));
            metadata.add("Authors", this.getMetadataAuthors(authorList));
            metadata.add("FullAffiliations", this.getMetadataFullAffiliations(authorList));
        } else {
            metadata.add("Error", "Unable to parse: no analytic section in JSON");
        }
    }

    private String getMetadataFullAffiliations(List<Author> authorList) {
        ArrayList<Affiliation> unique = new ArrayList<Affiliation>();
        StringBuilder metAffils = new StringBuilder();
        for (Author a : authorList) {
            for (Affiliation af : a.getAffiliations()) {
                if (unique.contains(af)) continue;
                unique.add(af);
            }
        }
        metAffils.append("[");
        for (Affiliation af : unique) {
            metAffils.append(af.toString());
            metAffils.append(",");
        }
        metAffils.append((CharSequence)metAffils.deleteCharAt(metAffils.length() - 1));
        metAffils.append("]");
        return metAffils.toString();
    }

    private String getMetadataAuthors(List<Author> authorList) {
        ArrayList<Affiliation> unique = new ArrayList<Affiliation>();
        StringBuilder metAuthors = new StringBuilder();
        for (Author a : authorList) {
            for (Affiliation af : a.getAffiliations()) {
                if (unique.contains(af)) continue;
                unique.add(af);
            }
        }
        for (Author a : authorList) {
            metAuthors.append(this.printOrBlank(a.getFirstName()));
            metAuthors.append(this.printOrBlank(a.getMiddleName()));
            metAuthors.append(this.printOrBlank(a.getSurName()));
            StringBuilder affilBuilder = new StringBuilder();
            for (int idx = 0; idx < unique.size(); ++idx) {
                Affiliation af = (Affiliation)unique.get(idx);
                if (!a.getAffiliations().contains(af)) continue;
                affilBuilder.append(idx + 1);
                affilBuilder.append(",");
            }
            if (affilBuilder.length() > 0) {
                affilBuilder.deleteCharAt(affilBuilder.length() - 1);
            }
            metAuthors.append(affilBuilder.toString());
            metAuthors.append(" ");
        }
        return metAuthors.toString();
    }

    private String getMetadataAffiliations(List<Author> authorList) {
        ArrayList<Affiliation> unique = new ArrayList<Affiliation>();
        StringBuilder metAffil = new StringBuilder();
        for (Author a : authorList) {
            for (Affiliation af : a.getAffiliations()) {
                if (unique.contains(af)) continue;
                unique.add(af);
            }
        }
        int count = 1;
        for (Affiliation a : unique) {
            metAffil.append(count);
            metAffil.append(" ");
            metAffil.append(a.getOrgName().toString());
            metAffil.deleteCharAt(metAffil.length() - 1);
            metAffil.append("; ");
            ++count;
        }
        if (count > 1) {
            metAffil.deleteCharAt(metAffil.length() - 1);
            metAffil.deleteCharAt(metAffil.length() - 1);
        }
        return metAffil.toString();
    }

    private String getMetadataAddresses(List<Author> authorList) {
        ArrayList<Address> unique = new ArrayList<Address>();
        StringBuilder metAddress = new StringBuilder();
        for (Author a : authorList) {
            for (Affiliation af : a.getAffiliations()) {
                if (unique.contains(af.getAddress())) continue;
                unique.add(af.getAddress());
            }
        }
        for (Address ad : unique) {
            metAddress.append(ad.toString());
            metAddress.append(" ");
        }
        return metAddress.toString();
    }

    private void parseAuthor(Node authorNode, List<Author> authorList) {
        Author author = new Author();
        Node persName = TEIDOMParser.getFirstChild(authorNode.getChildNodes(), "persName");
        if (persName != null) {
            String surnameContent;
            List<Node> forenames = TEIDOMParser.getChildNodes(persName.getChildNodes(), "forename");
            for (Node forenameNode : forenames) {
                this.parseNamePart(forenameNode, author);
            }
            Node surnameNode = TEIDOMParser.getFirstChild(persName.getChildNodes(), "surname");
            if (surnameNode != null && (surnameContent = surnameNode.getTextContent()) != null) {
                author.setSurName(surnameContent);
            }
        }
        List<Node> affiliationNodes = TEIDOMParser.getChildNodes(authorNode.getChildNodes(), "affiliation");
        for (Node affiliationNode : affiliationNodes) {
            this.parseOneAffiliation(affiliationNode, author);
        }
        authorList.add(author);
    }

    private void parseNamePart(Node namePart, Author author) {
        String type = TEIDOMParser.getFirstAttribute(namePart, null, "type");
        String content = namePart.getTextContent();
        if (type != null && content != null) {
            if (type.equals("first")) {
                author.setFirstName(content);
            }
            if (type.equals("middle")) {
                author.setMiddleName(content);
            }
        }
    }

    private void parseOneAffiliation(Node affiliationNode, Author author) {
        Affiliation affiliation = new Affiliation();
        Node address = TEIDOMParser.getFirstChild(affiliationNode.getChildNodes(), "address");
        if (address != null) {
            this.parseAddress(address, affiliation);
        }
        List<Node> orgNameNodes = TEIDOMParser.getChildNodes(affiliationNode.getChildNodes(), "orgName");
        OrgName orgName = new OrgName();
        for (Node orgNameNode : orgNameNodes) {
            this.parseOrgName(orgNameNode, orgName);
        }
        affiliation.setOrgName(orgName);
        author.getAffiliations().add(affiliation);
    }

    private void parseAddress(Node addressNode, Affiliation affiliation) {
        Node countryNode;
        Node settlementNode;
        Node postCode;
        Address address = new Address();
        Node region = TEIDOMParser.getFirstChild(addressNode.getChildNodes(), "region");
        if (region != null && region.getTextContent() != null) {
            address.setRegion(region.getTextContent());
        }
        if ((postCode = TEIDOMParser.getFirstChild(addressNode.getChildNodes(), "postCode")) != null && postCode.getTextContent() != null) {
            address.setPostCode(postCode.getTextContent());
        }
        if ((settlementNode = TEIDOMParser.getFirstChild(addressNode.getChildNodes(), "settlement")) != null && settlementNode.getTextContent() != null) {
            address.setSettlment(settlementNode.getTextContent());
        }
        if ((countryNode = TEIDOMParser.getFirstChild(addressNode.getChildNodes(), "country")) != null) {
            String content;
            Country country = new Country();
            String key = TEIDOMParser.getFirstAttribute(countryNode, null, "key");
            if (key != null) {
                country.setKey(key);
            }
            if ((content = countryNode.getTextContent()) != null) {
                country.setContent(content);
            }
            address.setCountry(country);
        }
        affiliation.setAddress(address);
    }

    private void parseOrgName(Node orgNode, OrgName orgName) {
        String orgType;
        OrgTypeName typeName = new OrgTypeName();
        String orgContent = orgNode.getTextContent();
        if (orgContent != null) {
            typeName.setName(orgContent);
        }
        if ((orgType = TEIDOMParser.getFirstAttribute(orgNode, null, "type")) != null) {
            typeName.setType(orgType);
        }
        orgName.getTypeNames().add(typeName);
    }

    private void parseProfileDesc(Node profileDesc, Metadata metadata) {
        Node keywordsNode;
        Node textClassNode;
        Node pNode;
        Node abstractNode = TEIDOMParser.getFirstChild(profileDesc.getChildNodes(), "abstract");
        if (abstractNode != null && (pNode = TEIDOMParser.getFirstChild(abstractNode.getChildNodes(), "p")) != null) {
            metadata.add("Abstract", pNode.getTextContent());
        }
        if ((textClassNode = TEIDOMParser.getFirstChild(profileDesc.getChildNodes(), "textClass")) != null && (keywordsNode = TEIDOMParser.getFirstChild(textClassNode.getChildNodes(), "keywords")) != null) {
            List<Node> terms = TEIDOMParser.getChildNodes(keywordsNode.getChildNodes(), "term");
            if (terms.size() == 0) {
                metadata.add("Keyword", keywordsNode.getTextContent());
            } else {
                for (Node term : terms) {
                    metadata.add("Keyword", term.getTextContent());
                }
            }
        }
    }

    private String printOrBlank(String val) {
        if (val != null && !val.equals("")) {
            return val + " ";
        }
        return " ";
    }

    private static Node getFirstChild(NodeList childNodes, String name) {
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node n = childNodes.item(i);
            if (!n.getNodeName().equals(name)) continue;
            return n;
        }
        return null;
    }

    private static String getFirstAttribute(Node node, String ns, String name) {
        if (node.hasAttributes()) {
            NamedNodeMap attrs = node.getAttributes();
            for (int i = 0; i < attrs.getLength(); ++i) {
                Node attr = attrs.item(i);
                if (!attr.getLocalName().equals(name)) continue;
                return attr.getNodeValue();
            }
        }
        return null;
    }

    private static List<Node> getChildNodes(NodeList childNodes, String localName) {
        ArrayList<Node> ret = new ArrayList<Node>();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node child = childNodes.item(i);
            if (child.getLocalName() == null || !child.getLocalName().equals(localName)) continue;
            ret.add(child);
        }
        return ret;
    }

    private class Country {
        private String key = null;
        private String content = null;

        public String getKey() {
            return this.key;
        }

        public void setKey(String key) {
            this.key = key;
        }

        public String getContent() {
            return this.content;
        }

        public void setContent(String content) {
            this.content = content;
        }

        public boolean equals(Object obj) {
            Country otherC = (Country)obj;
            if (this.key == null) {
                if (otherC.getKey() != null) {
                    return false;
                }
                if (this.content == null) {
                    return otherC.getContent() == null;
                }
                return this.content.equals(otherC.getContent());
            }
            if (this.content == null) {
                if (otherC.getContent() != null) {
                    return false;
                }
                return this.key.equals(otherC.getKey());
            }
            return this.key.equals(otherC.getKey()) && this.content.equals(otherC.getContent());
        }
    }

    private class Address {
        private String region = null;
        private String postCode = null;
        private String settlment = null;
        private Country country;

        public Address() {
            this.country = new Country();
        }

        public String getRegion() {
            return this.region;
        }

        public void setRegion(String region) {
            this.region = region;
        }

        public String getPostCode() {
            return this.postCode;
        }

        public void setPostCode(String postCode) {
            this.postCode = postCode;
        }

        public String getSettlment() {
            return this.settlment;
        }

        public void setSettlment(String settlment) {
            this.settlment = settlment;
        }

        public Country getCountry() {
            return this.country;
        }

        public void setCountry(Country country) {
            this.country = country;
        }

        public boolean equals(Object obj) {
            Address otherA = (Address)obj;
            if (this.settlment == null) {
                return otherA.getSettlment() == null;
            }
            if (this.country == null) {
                return otherA.getCountry() == null;
            }
            if (this.postCode == null) {
                return otherA.getPostCode() == null;
            }
            if (this.region == null) {
                return otherA.getRegion() == null;
            }
            return this.settlment.equals(otherA.getSettlment()) && this.country.equals(otherA.getCountry()) && this.postCode.equals(otherA.getPostCode()) && this.region.equals(otherA.getRegion());
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append(this.settlment);
            builder.append(", ");
            builder.append(this.region);
            builder.append(" ");
            builder.append(this.postCode);
            builder.append(" ");
            builder.append(this.country.getContent());
            return builder.toString();
        }
    }

    class OrgTypeName {
        private String name = null;
        private String type = null;

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }

        public boolean equals(Object obj) {
            OrgTypeName otherOrgName = (OrgTypeName)obj;
            return this.type.equals(otherOrgName.getType()) && this.name.equals(otherOrgName.getName());
        }
    }

    class OrgName {
        private List<OrgTypeName> typeNames = new ArrayList<OrgTypeName>();

        public List<OrgTypeName> getTypeNames() {
            return this.typeNames;
        }

        public void setTypeNames(List<OrgTypeName> typeNames) {
            this.typeNames = typeNames;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            for (OrgTypeName on : this.typeNames) {
                builder.append(on.getName());
                builder.append(" ");
            }
            return builder.toString();
        }

        public boolean equals(Object obj) {
            OrgName otherA = (OrgName)obj;
            if (otherA.getTypeNames() != null) {
                if (this.typeNames == null) {
                    return false;
                }
                return this.typeNames.size() == otherA.getTypeNames().size();
            }
            return this.typeNames == null;
        }
    }

    class Affiliation {
        private OrgName orgName;
        private Address address;

        public Affiliation() {
            this.orgName = new OrgName();
            this.address = new Address();
        }

        public OrgName getOrgName() {
            return this.orgName;
        }

        public void setOrgName(OrgName orgName) {
            this.orgName = orgName;
        }

        public Address getAddress() {
            return this.address;
        }

        public void setAddress(Address address) {
            this.address = address;
        }

        public boolean equals(Object obj) {
            Affiliation otherA = (Affiliation)obj;
            return this.getAddress().equals(otherA.getAddress()) && this.getOrgName().equals(otherA.getOrgName());
        }

        public String toString() {
            return "Affiliation {orgName=" + this.orgName + ", address=" + this.address + "}";
        }
    }

    class Author {
        private String surName = null;
        private String middleName = null;
        private String firstName = null;
        private List<Affiliation> affiliations = new ArrayList<Affiliation>();

        public String getSurName() {
            return this.surName;
        }

        public void setSurName(String surName) {
            this.surName = surName;
        }

        public String getMiddleName() {
            return this.middleName;
        }

        public void setMiddleName(String middleName) {
            this.middleName = middleName;
        }

        public String getFirstName() {
            return this.firstName;
        }

        public void setFirstName(String firstName) {
            this.firstName = firstName;
        }

        public List<Affiliation> getAffiliations() {
            return this.affiliations;
        }

        public void setAffiliations(List<Affiliation> affiliations) {
            this.affiliations = affiliations;
        }

        public String toString() {
            return "Author [surName=" + this.surName + ", middleName=" + this.middleName != null ? this.middleName : ", firstName=" + this.firstName + ", affiliations=" + this.affiliations + "]";
        }
    }
}

