/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.rowset;

import java.io.BufferedReader;
import java.io.CharArrayReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringBufferInputStream;
import java.io.Writer;
import java.lang.reflect.Executable;
import java.sql.Clob;
import java.sql.NClob;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.ClioSupport;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Log;
import oracle.jdbc.logging.annotations.Supports;
import oracle.jdbc.logging.runtime.TraceControllerImpl;

@DefaultLogger(value="oracle.jdbc")
@Supports(value={Feature.ROWSET})
public class OracleSerialClob
implements Clob,
NClob,
Serializable,
Cloneable {
    private static final int MAX_CHAR_BUFFER_SIZE = 1024;
    private char[] buffer;
    private long length;
    private boolean isFreed;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;
    private static Executable $$$methodRef$$$12;
    private static Logger $$$loggerRef$$$12;
    private static Executable $$$methodRef$$$13;
    private static Logger $$$loggerRef$$$13;
    private static Executable $$$methodRef$$$14;
    private static Logger $$$loggerRef$$$14;
    private static Executable $$$methodRef$$$15;
    private static Logger $$$loggerRef$$$15;
    private static Executable $$$methodRef$$$16;
    private static Logger $$$loggerRef$$$16;
    private static Executable $$$methodRef$$$17;
    private static Logger $$$loggerRef$$$17;

    public OracleSerialClob(char[] chars) throws SQLException {
        boolean bl = (0x1000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$14, Level.FINEST, OracleSerialClob.class, $$$methodRef$$$14, null, new Object[]{chars});
            }
            this.isFreed = false;
            if (chars == null) {
                SQLException sQLException = (SQLException)DatabaseError.createSqlException(68).fillInStackTrace();
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$14, Level.FINEST, OracleSerialClob.class, $$$methodRef$$$14, null, sQLException);
                }
                throw sQLException;
            }
            this.length = chars.length;
            this.buffer = new char[(int)this.length];
            int i2 = 0;
            while ((long)i2 < this.length) {
                this.buffer[i2] = chars[i2];
                ++i2;
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$14, Level.FINEST, OracleSerialClob.class, $$$methodRef$$$14, null);
                ClioSupport.exiting($$$loggerRef$$$14, Level.FINEST, OracleSerialClob.class, $$$methodRef$$$14, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$14, Level.FINEST, OracleSerialClob.class, $$$methodRef$$$14, null, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public OracleSerialClob(Clob clob) throws SQLException {
        boolean bl = (0x1000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$15, Level.FINEST, OracleSerialClob.class, $$$methodRef$$$15, null, clob);
            }
            this.isFreed = false;
            if (clob == null) {
                SQLException sQLException = (SQLException)DatabaseError.createSqlException(68).fillInStackTrace();
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$15, Level.FINEST, OracleSerialClob.class, $$$methodRef$$$15, null, sQLException);
                }
                throw sQLException;
            }
            this.length = clob.length();
            this.buffer = new char[(int)this.length];
            BufferedReader bufferedreader = new BufferedReader(clob.getCharacterStream());
            try {
                int bytesRead = 0;
                int offset = 0;
                do {
                    if (bl) {
                        this.debug($$$loggerRef$$$15, Level.FINEST, $$$methodRef$$$15, "OracleSerialClob.OracleSerialClob(Clob)inside do-while loop, bytesRead=" + bytesRead + ", offset=" + offset);
                    }
                    bytesRead = bufferedreader.read(this.buffer, offset, (int)(this.length - (long)offset));
                    offset += bytesRead;
                } while (bytesRead > 0);
            }
            catch (IOException ioexception) {
                try {
                    SQLException sQLException = (SQLException)DatabaseError.createSqlException(null, 347, ioexception.getMessage()).fillInStackTrace();
                    if (bl) {
                        ClioSupport.throwing($$$loggerRef$$$15, Level.FINEST, OracleSerialClob.class, $$$methodRef$$$15, null, sQLException);
                    }
                    throw sQLException;
                }
                catch (Throwable throwable) {
                    try {
                        if (bufferedreader != null) {
                            bufferedreader.close();
                        }
                    }
                    catch (IOException ioexception2) {
                        SQLException sQLException = (SQLException)DatabaseError.createSqlException(null, 347, ioexception2.getMessage()).fillInStackTrace();
                        if (bl) {
                            ClioSupport.throwing($$$loggerRef$$$15, Level.FINEST, OracleSerialClob.class, $$$methodRef$$$15, null, sQLException);
                        }
                        throw sQLException;
                    }
                    Throwable throwable2 = throwable;
                    if (bl) {
                        ClioSupport.throwing($$$loggerRef$$$15, Level.FINEST, OracleSerialClob.class, $$$methodRef$$$15, null, throwable2);
                    }
                    throw throwable2;
                }
            }
            try {
                if (bufferedreader != null) {
                    bufferedreader.close();
                }
            }
            catch (IOException ioexception) {
                SQLException sQLException = (SQLException)DatabaseError.createSqlException(null, 347, ioexception.getMessage()).fillInStackTrace();
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$15, Level.FINEST, OracleSerialClob.class, $$$methodRef$$$15, null, sQLException);
                }
                throw sQLException;
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$15, Level.FINEST, OracleSerialClob.class, $$$methodRef$$$15, null);
                ClioSupport.exiting($$$loggerRef$$$15, Level.FINEST, OracleSerialClob.class, $$$methodRef$$$15, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable3 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$15, Level.FINEST, OracleSerialClob.class, $$$methodRef$$$15, null, throwable3);
            }
            throw throwable;
        }
    }

    public OracleSerialClob(Reader reader) throws SQLException {
        boolean bl = (0x1000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$16, Level.FINEST, OracleSerialClob.class, $$$methodRef$$$16, null, reader);
            }
            this.isFreed = false;
            if (reader == null) {
                SQLException sQLException = (SQLException)DatabaseError.createSqlException(68).fillInStackTrace();
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$16, Level.FINEST, OracleSerialClob.class, $$$methodRef$$$16, null, sQLException);
                }
                throw sQLException;
            }
            try {
                int len = 0;
                char[] charBuf = new char[1024];
                StringBuilder inStr = new StringBuilder(1024);
                while ((len = reader.read(charBuf)) != -1) {
                    inStr.append(charBuf, 0, len);
                }
                reader.close();
                this.buffer = inStr.toString().toCharArray();
                this.length = this.buffer.length;
            }
            catch (Exception exc) {
                SQLException sQLException = (SQLException)DatabaseError.createSqlException(null, 347, exc.getMessage()).fillInStackTrace();
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$16, Level.FINEST, OracleSerialClob.class, $$$methodRef$$$16, null, sQLException);
                }
                throw sQLException;
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$16, Level.FINEST, OracleSerialClob.class, $$$methodRef$$$16, null);
                ClioSupport.exiting($$$loggerRef$$$16, Level.FINEST, OracleSerialClob.class, $$$methodRef$$$16, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$16, Level.FINEST, OracleSerialClob.class, $$$methodRef$$$16, null, throwable2);
            }
            throw throwable;
        }
    }

    public OracleSerialClob(Reader reader, long rlength) throws SQLException {
        boolean bl = (0x1000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$17, Level.FINEST, OracleSerialClob.class, $$$methodRef$$$17, null, reader, rlength);
            }
            this.isFreed = false;
            if (reader == null) {
                SQLException sQLException = (SQLException)DatabaseError.createSqlException(68).fillInStackTrace();
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$17, Level.FINEST, OracleSerialClob.class, $$$methodRef$$$17, null, sQLException);
                }
                throw sQLException;
            }
            try {
                int len = 0;
                char[] charBuf = new char[1024];
                StringBuilder inStr = new StringBuilder(1024);
                for (long lengthRemaining = rlength; lengthRemaining > 0L && (len = reader.read(charBuf, 0, Math.min(1024, (int)lengthRemaining))) != -1; lengthRemaining -= (long)len) {
                    inStr.append(charBuf, 0, len);
                }
                reader.close();
                this.buffer = inStr.toString().toCharArray();
                this.length = this.buffer.length;
            }
            catch (Exception exc) {
                SQLException sQLException = (SQLException)DatabaseError.createSqlException(null, 347, exc.getMessage()).fillInStackTrace();
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$17, Level.FINEST, OracleSerialClob.class, $$$methodRef$$$17, null, sQLException);
                }
                throw sQLException;
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$17, Level.FINEST, OracleSerialClob.class, $$$methodRef$$$17, null);
                ClioSupport.exiting($$$loggerRef$$$17, Level.FINEST, OracleSerialClob.class, $$$methodRef$$$17, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$17, Level.FINEST, OracleSerialClob.class, $$$methodRef$$$17, null, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public InputStream getAsciiStream() throws SQLException {
        boolean bl = (0x1000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$0, Level.FINEST, OracleSerialClob.class, $$$methodRef$$$0, this, new Object[0]);
            }
            if (this.isFreed) {
                SQLException sQLException = (SQLException)DatabaseError.createSqlException(192).fillInStackTrace();
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$0, Level.FINEST, OracleSerialClob.class, $$$methodRef$$$0, this, sQLException);
                }
                throw sQLException;
            }
            StringBufferInputStream stringBufferInputStream = new StringBufferInputStream(new String(this.buffer));
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$0, Level.FINEST, OracleSerialClob.class, $$$methodRef$$$0, this, stringBufferInputStream);
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, OracleSerialClob.class, $$$methodRef$$$0, this, null);
            }
            return stringBufferInputStream;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, OracleSerialClob.class, $$$methodRef$$$0, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public Reader getCharacterStream() throws SQLException {
        boolean bl = (0x1000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$1, Level.FINEST, OracleSerialClob.class, $$$methodRef$$$1, this, new Object[0]);
            }
            if (this.isFreed) {
                SQLException sQLException = (SQLException)DatabaseError.createSqlException(192).fillInStackTrace();
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$1, Level.FINEST, OracleSerialClob.class, $$$methodRef$$$1, this, sQLException);
                }
                throw sQLException;
            }
            CharArrayReader charArrayReader = new CharArrayReader(this.buffer);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$1, Level.FINEST, OracleSerialClob.class, $$$methodRef$$$1, this, charArrayReader);
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, OracleSerialClob.class, $$$methodRef$$$1, this, null);
            }
            return charArrayReader;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, OracleSerialClob.class, $$$methodRef$$$1, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public String getSubString(long l2, int n2) throws SQLException {
        boolean bl = (0x1000000L & TraceControllerImpl.feature) != 0L;
        try {
            void len;
            void pos;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$2, Level.FINEST, OracleSerialClob.class, $$$methodRef$$$2, this, l2, n2);
            }
            if (bl) {
                this.debug($$$loggerRef$$$2, Level.FINEST, $$$methodRef$$$2, "OracleSerialClob.getSubString(" + (long)pos + ", " + (int)len + "), length=" + this.length);
            }
            if (this.isFreed) {
                SQLException sQLException = (SQLException)DatabaseError.createSqlException(192).fillInStackTrace();
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$2, Level.FINEST, OracleSerialClob.class, $$$methodRef$$$2, this, sQLException);
                }
                throw sQLException;
            }
            if (pos < 1L || len < 0 || (long)len > this.length || pos + (long)len - 1L > this.length) {
                SQLException sQLException = (SQLException)DatabaseError.createSqlException(68).fillInStackTrace();
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$2, Level.FINEST, OracleSerialClob.class, $$$methodRef$$$2, this, sQLException);
                }
                throw sQLException;
            }
            if (len == false) {
                String string = new String();
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$2, Level.FINEST, OracleSerialClob.class, $$$methodRef$$$2, this, string);
                    ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, OracleSerialClob.class, $$$methodRef$$$2, this, null);
                }
                return string;
            }
            String string = new String(this.buffer, (int)pos - 1, (int)len);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$2, Level.FINEST, OracleSerialClob.class, $$$methodRef$$$2, this, string);
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, OracleSerialClob.class, $$$methodRef$$$2, this, null);
            }
            return string;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, OracleSerialClob.class, $$$methodRef$$$2, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public long length() throws SQLException {
        boolean bl = (0x1000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$3, Level.FINEST, OracleSerialClob.class, $$$methodRef$$$3, this, new Object[0]);
            }
            if (this.isFreed) {
                SQLException sQLException = (SQLException)DatabaseError.createSqlException(192).fillInStackTrace();
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$3, Level.FINEST, OracleSerialClob.class, $$$methodRef$$$3, this, sQLException);
                }
                throw sQLException;
            }
            long l2 = this.length;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$3, Level.FINEST, OracleSerialClob.class, $$$methodRef$$$3, this, l2);
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, OracleSerialClob.class, $$$methodRef$$$3, this, null);
            }
            return l2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, OracleSerialClob.class, $$$methodRef$$$3, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public long position(String string, long l2) throws SQLException {
        boolean bl = (0x1000000L & TraceControllerImpl.feature) != 0L;
        try {
            void l3;
            void s2;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$4, Level.FINEST, OracleSerialClob.class, $$$methodRef$$$4, this, string, l2);
            }
            if (bl) {
                this.debug($$$loggerRef$$$4, Level.FINEST, $$$methodRef$$$4, "OracleSerialClob.position(" + (String)s2 + ", " + (long)l3 + "), length=" + this.length);
            }
            if (this.isFreed) {
                SQLException sQLException = (SQLException)DatabaseError.createSqlException(192).fillInStackTrace();
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$4, Level.FINEST, OracleSerialClob.class, $$$methodRef$$$4, this, sQLException);
                }
                throw sQLException;
            }
            if (l3 < 1L) {
                SQLException sQLException = (SQLException)DatabaseError.createSqlException(null, 68, "position()").fillInStackTrace();
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$4, Level.FINEST, OracleSerialClob.class, $$$methodRef$$$4, this, sQLException);
                }
                throw sQLException;
            }
            if (l3 > this.length || l3 + (long)s2.length() - 1L > this.length) {
                long l4 = -1L;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$4, Level.FINEST, OracleSerialClob.class, $$$methodRef$$$4, this, l4);
                    ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, OracleSerialClob.class, $$$methodRef$$$4, this, null);
                }
                return -1L;
            }
            char[] ac2 = s2.toCharArray();
            int i2 = (int)(l3 - 1L);
            boolean flag = false;
            long l22 = ac2.length;
            while ((long)i2 < this.length) {
                int j2 = 0;
                long l1 = i2 + 1;
                int k2 = i2;
                while ((long)j2 < l22 && (long)k2 < this.length && ac2[j2] == this.buffer[k2]) {
                    ++k2;
                    if ((long)(++j2) != l22) continue;
                    long l5 = l1;
                    if (bl) {
                        ClioSupport.returning($$$loggerRef$$$4, Level.FINEST, OracleSerialClob.class, $$$methodRef$$$4, this, l5);
                        ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, OracleSerialClob.class, $$$methodRef$$$4, this, null);
                    }
                    return l5;
                }
                ++i2;
            }
            long l6 = -1L;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$4, Level.FINEST, OracleSerialClob.class, $$$methodRef$$$4, this, l6);
                ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, OracleSerialClob.class, $$$methodRef$$$4, this, null);
            }
            return -1L;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, OracleSerialClob.class, $$$methodRef$$$4, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public long position(Clob clob, long l2) throws SQLException {
        boolean bl = (0x1000000L & TraceControllerImpl.feature) != 0L;
        try {
            void l3;
            void clob2;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$5, Level.FINEST, OracleSerialClob.class, $$$methodRef$$$5, this, clob, l2);
            }
            if (this.isFreed) {
                SQLException sQLException = (SQLException)DatabaseError.createSqlException(192).fillInStackTrace();
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$5, Level.FINEST, OracleSerialClob.class, $$$methodRef$$$5, this, sQLException);
                }
                throw sQLException;
            }
            long l4 = this.position(clob2.getSubString(1L, (int)clob2.length()), (long)l3);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$5, Level.FINEST, OracleSerialClob.class, $$$methodRef$$$5, this, l4);
                ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, OracleSerialClob.class, $$$methodRef$$$5, this, null);
            }
            return l4;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, OracleSerialClob.class, $$$methodRef$$$5, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public int setString(long l2, String string) throws SQLException {
        boolean bl = (0x1000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$6, Level.FINEST, OracleSerialClob.class, $$$methodRef$$$6, this, l2, string);
            }
            if (this.isFreed) {
                SQLException sQLException = (SQLException)DatabaseError.createSqlException(192).fillInStackTrace();
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$6, Level.FINEST, OracleSerialClob.class, $$$methodRef$$$6, this, sQLException);
                }
                throw sQLException;
            }
            SQLException sQLException = (SQLException)DatabaseError.createUnsupportedFeatureSqlException().fillInStackTrace();
            if (bl) {
                ClioSupport.throwing($$$loggerRef$$$6, Level.FINEST, OracleSerialClob.class, $$$methodRef$$$6, this, sQLException);
            }
            throw sQLException;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$6, Level.FINEST, OracleSerialClob.class, $$$methodRef$$$6, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public int setString(long l2, String string, int n2, int n3) throws SQLException {
        boolean bl = (0x1000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$7, Level.FINEST, OracleSerialClob.class, $$$methodRef$$$7, this, l2, string, n2, n3);
            }
            if (this.isFreed) {
                SQLException sQLException = (SQLException)DatabaseError.createSqlException(192).fillInStackTrace();
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$7, Level.FINEST, OracleSerialClob.class, $$$methodRef$$$7, this, sQLException);
                }
                throw sQLException;
            }
            SQLException sQLException = (SQLException)DatabaseError.createUnsupportedFeatureSqlException().fillInStackTrace();
            if (bl) {
                ClioSupport.throwing($$$loggerRef$$$7, Level.FINEST, OracleSerialClob.class, $$$methodRef$$$7, this, sQLException);
            }
            throw sQLException;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$7, Level.FINEST, OracleSerialClob.class, $$$methodRef$$$7, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public OutputStream setAsciiStream(long l2) throws SQLException {
        boolean bl = (0x1000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$8, Level.FINEST, OracleSerialClob.class, $$$methodRef$$$8, this, l2);
            }
            if (this.isFreed) {
                SQLException sQLException = (SQLException)DatabaseError.createSqlException(192).fillInStackTrace();
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$8, Level.FINEST, OracleSerialClob.class, $$$methodRef$$$8, this, sQLException);
                }
                throw sQLException;
            }
            SQLException sQLException = (SQLException)DatabaseError.createUnsupportedFeatureSqlException().fillInStackTrace();
            if (bl) {
                ClioSupport.throwing($$$loggerRef$$$8, Level.FINEST, OracleSerialClob.class, $$$methodRef$$$8, this, sQLException);
            }
            throw sQLException;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$8, Level.FINEST, OracleSerialClob.class, $$$methodRef$$$8, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public Writer setCharacterStream(long l2) throws SQLException {
        boolean bl = (0x1000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$9, Level.FINEST, OracleSerialClob.class, $$$methodRef$$$9, this, l2);
            }
            if (this.isFreed) {
                SQLException sQLException = (SQLException)DatabaseError.createSqlException(192).fillInStackTrace();
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$9, Level.FINEST, OracleSerialClob.class, $$$methodRef$$$9, this, sQLException);
                }
                throw sQLException;
            }
            SQLException sQLException = (SQLException)DatabaseError.createUnsupportedFeatureSqlException().fillInStackTrace();
            if (bl) {
                ClioSupport.throwing($$$loggerRef$$$9, Level.FINEST, OracleSerialClob.class, $$$methodRef$$$9, this, sQLException);
            }
            throw sQLException;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$9, Level.FINEST, OracleSerialClob.class, $$$methodRef$$$9, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public void truncate(long l2) throws SQLException {
        boolean bl = (0x1000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$10, Level.FINEST, OracleSerialClob.class, $$$methodRef$$$10, this, l2);
            }
            if (this.isFreed) {
                SQLException sQLException = (SQLException)DatabaseError.createSqlException(192).fillInStackTrace();
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$10, Level.FINEST, OracleSerialClob.class, $$$methodRef$$$10, this, sQLException);
                }
                throw sQLException;
            }
            SQLException sQLException = (SQLException)DatabaseError.createUnsupportedFeatureSqlException().fillInStackTrace();
            if (bl) {
                ClioSupport.throwing($$$loggerRef$$$10, Level.FINEST, OracleSerialClob.class, $$$methodRef$$$10, this, sQLException);
            }
            throw sQLException;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$10, Level.FINEST, OracleSerialClob.class, $$$methodRef$$$10, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public void free() throws SQLException {
        boolean bl = (0x1000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$11, Level.FINEST, OracleSerialClob.class, $$$methodRef$$$11, this, new Object[0]);
            }
            if (this.isFreed) {
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$11, Level.FINEST, OracleSerialClob.class, $$$methodRef$$$11, this);
                    ClioSupport.exiting($$$loggerRef$$$11, Level.FINEST, OracleSerialClob.class, $$$methodRef$$$11, this, null);
                }
                return;
            }
            this.isFreed = true;
            this.buffer = null;
            this.length = 0L;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$11, Level.FINEST, OracleSerialClob.class, $$$methodRef$$$11, this);
                ClioSupport.exiting($$$loggerRef$$$11, Level.FINEST, OracleSerialClob.class, $$$methodRef$$$11, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$11, Level.FINEST, OracleSerialClob.class, $$$methodRef$$$11, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Reader getCharacterStream(long l2, long l3) throws SQLException {
        boolean bl = (0x1000000L & TraceControllerImpl.feature) != 0L;
        try {
            void _len;
            void pos;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$12, Level.FINEST, OracleSerialClob.class, $$$methodRef$$$12, this, l2, l3);
            }
            if (this.isFreed) {
                SQLException sQLException = (SQLException)DatabaseError.createSqlException(192).fillInStackTrace();
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$12, Level.FINEST, OracleSerialClob.class, $$$methodRef$$$12, this, sQLException);
                }
                throw sQLException;
            }
            if (--pos < 0L || pos + 1L > this.length || _len < 0L || _len > this.length || pos + _len > this.length) {
                SQLException sQLException = (SQLException)DatabaseError.createSqlException(68).fillInStackTrace();
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$12, Level.FINEST, OracleSerialClob.class, $$$methodRef$$$12, this, sQLException);
                }
                throw sQLException;
            }
            CharArrayReader charArrayReader = new CharArrayReader(this.buffer, (int)pos, (int)_len);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$12, Level.FINEST, OracleSerialClob.class, $$$methodRef$$$12, this, charArrayReader);
                ClioSupport.exiting($$$loggerRef$$$12, Level.FINEST, OracleSerialClob.class, $$$methodRef$$$12, this, null);
            }
            return charArrayReader;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$12, Level.FINEST, OracleSerialClob.class, $$$methodRef$$$12, this, throwable2);
            }
            throw throwable;
        }
    }

    protected OracleConnection getConnectionDuringExceptionHandling() {
        boolean bl = (0x1000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$13, Level.FINEST, OracleSerialClob.class, $$$methodRef$$$13, this, new Object[0]);
            }
            OracleConnection oracleConnection = null;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$13, Level.FINEST, OracleSerialClob.class, $$$methodRef$$$13, this, oracleConnection);
                ClioSupport.exiting($$$loggerRef$$$13, Level.FINEST, OracleSerialClob.class, $$$methodRef$$$13, this, null);
            }
            return null;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$13, Level.FINEST, OracleSerialClob.class, $$$methodRef$$$13, this, throwable2);
            }
            throw throwable;
        }
    }

    @Log
    protected void debug(Logger logger, Level level, Executable method, String msg) {
        ClioSupport.log(logger, level, this.getClass(), method, msg);
    }

    static {
        try {
            $$$methodRef$$$17 = OracleSerialClob.class.getDeclaredConstructor(Reader.class, Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$17 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$16 = OracleSerialClob.class.getDeclaredConstructor(Reader.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$16 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$15 = OracleSerialClob.class.getDeclaredConstructor(Clob.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$15 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$14 = OracleSerialClob.class.getDeclaredConstructor(char[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$14 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$13 = OracleSerialClob.class.getDeclaredMethod("getConnectionDuringExceptionHandling", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$13 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$12 = OracleSerialClob.class.getDeclaredMethod("getCharacterStream", Long.TYPE, Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$11 = OracleSerialClob.class.getDeclaredMethod("free", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$10 = OracleSerialClob.class.getDeclaredMethod("truncate", Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$9 = OracleSerialClob.class.getDeclaredMethod("setCharacterStream", Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$8 = OracleSerialClob.class.getDeclaredMethod("setAsciiStream", Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$7 = OracleSerialClob.class.getDeclaredMethod("setString", Long.TYPE, String.class, Integer.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$6 = OracleSerialClob.class.getDeclaredMethod("setString", Long.TYPE, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$5 = OracleSerialClob.class.getDeclaredMethod("position", Clob.class, Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$4 = OracleSerialClob.class.getDeclaredMethod("position", String.class, Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = OracleSerialClob.class.getDeclaredMethod("length", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = OracleSerialClob.class.getDeclaredMethod("getSubString", Long.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = OracleSerialClob.class.getDeclaredMethod("getCharacterStream", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = OracleSerialClob.class.getDeclaredMethod("getAsciiStream", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
    }
}

