/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.nodes.bytecode;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.builtins.objects.dict.DictNodes;
import com.oracle.graal.python.builtins.objects.dict.PDict;
import com.oracle.graal.python.lib.PyDictDelItem;
import com.oracle.graal.python.nodes.PNodeWithContext;
import com.oracle.graal.python.nodes.bytecode.CopyDictWithoutKeysNodeGen;
import com.oracle.graal.python.runtime.object.PFactory;
import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.bytecode.OperationProxy;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;

@GenerateInline(value=false)
@OperationProxy.Proxyable
public abstract class CopyDictWithoutKeysNode
extends PNodeWithContext {
    public abstract PDict execute(Frame var1, Object var2, Object[] var3);

    @Specialization(guards={"keys.length == keysLength", "keysLength <= 32"}, limit="1")
    public static PDict copy(VirtualFrame frame, Object subject, @NeverDefault Object[] keys, @Bind Node inliningTarget, @Cached(value="keys.length") int keysLength, @Bind PythonLanguage language, @Cached.Shared @Cached DictNodes.UpdateNode updateNode, @Cached.Shared @Cached PyDictDelItem delItem) {
        PDict rest = PFactory.createDict(language);
        updateNode.execute((Frame)frame, rest, subject);
        CopyDictWithoutKeysNode.deleteKeys(frame, inliningTarget, keys, keysLength, delItem, rest);
        return rest;
    }

    @ExplodeLoop
    private static void deleteKeys(VirtualFrame frame, Node inliningTarget, Object[] keys, int keysLen, PyDictDelItem delItem, PDict rest) {
        CompilerAsserts.partialEvaluationConstant((int)keysLen);
        for (int i = 0; i < keysLen; ++i) {
            delItem.execute((Frame)frame, inliningTarget, rest, keys[i]);
        }
    }

    @Specialization(guards={"keys.length > 32"})
    public static PDict copy(VirtualFrame frame, Object subject, Object[] keys, @Bind Node inliningTarget, @Bind PythonLanguage language, @Cached.Shared @Cached DictNodes.UpdateNode updateNode, @Cached.Shared @Cached PyDictDelItem delItem) {
        PDict rest = PFactory.createDict(language);
        updateNode.execute((Frame)frame, rest, subject);
        for (int i = 0; i < keys.length; ++i) {
            delItem.execute((Frame)frame, inliningTarget, rest, keys[i]);
        }
        return rest;
    }

    public static CopyDictWithoutKeysNode create() {
        return CopyDictWithoutKeysNodeGen.create();
    }
}

