
# 13 "plugins/ltac/g_rewrite.mlg"
 

open Names
open Locus
open Constrexpr
open Glob_term
open Genintern
open Geninterp
open Extraargs
open Rewrite
open ComRewrite
open Stdarg
open Tactypes
open Procq.Prim
open Procq.Constr
open Pvernac.Vernac_
open Pltac
open Vernacextend


# 24 "plugins/ltac/g_rewrite.ml"

let _ = Mltop.add_known_module "rocq-runtime.plugins.ltac"

# 36 "plugins/ltac/g_rewrite.mlg"
 

type constr_expr_with_bindings = constr_expr with_bindings
type glob_constr_with_bindings = glob_constr_and_expr with_bindings
type glob_constr_with_bindings_sign = interp_sign * glob_constr_and_expr with_bindings

let pr_glob_constr_with_bindings_sign env sigma _ _ _ (ge : glob_constr_with_bindings_sign) =
  Printer.pr_glob_constr_env env sigma (fst (fst (snd ge)))
let pr_glob_constr_with_bindings env sigma _ _ _ (ge : glob_constr_with_bindings) =
  Printer.pr_glob_constr_env env sigma (fst (fst ge))
let pr_constr_expr_with_bindings env sigma prc _ _ (ge : constr_expr_with_bindings) = prc env sigma (fst ge)
let interp_glob_constr_with_bindings ist _ _ c = (ist, c)
let glob_glob_constr_with_bindings ist l = Tacintern.intern_constr_with_bindings ist l
let subst_glob_constr_with_bindings s c =
  Tacsubst.subst_glob_with_bindings s c


# 46 "plugins/ltac/g_rewrite.ml"

let (wit_glob_constr_with_bindings, glob_constr_with_bindings) = Tacentries.argument_extend ~plugin:"rocq-runtime.plugins.ltac" ~name:"glob_constr_with_bindings" 
                                                                 {
                                                                 Tacentries.arg_parsing = 
                                                                 Vernacextend.Arg_alias
                                                                 (constr_with_bindings);
                                                                 Tacentries.arg_tag = 
                                                                 None;
                                                                 Tacentries.arg_intern = 
                                                                 Tacentries.ArgInternFun ((fun f ist v -> (ist, f ist v)) (
                                                                 
# 58 "plugins/ltac/g_rewrite.mlg"
                    glob_glob_constr_with_bindings 
# 60 "plugins/ltac/g_rewrite.ml"
));
                                                                 Tacentries.arg_subst = 
                                                                 Tacentries.ArgSubstFun (
                                                                 
# 59 "plugins/ltac/g_rewrite.mlg"
                     subst_glob_constr_with_bindings 
# 67 "plugins/ltac/g_rewrite.ml"
);
                                                                 Tacentries.arg_interp = 
                                                                 Tacentries.ArgInterpSimple (
                                                                 
# 57 "plugins/ltac/g_rewrite.mlg"
                     interp_glob_constr_with_bindings 
# 74 "plugins/ltac/g_rewrite.ml"
);
                                                                 Tacentries.arg_printer = 
                                                                 ((fun env sigma -> 
                                                                 
# 61 "plugins/ltac/g_rewrite.mlg"
                     pr_constr_expr_with_bindings env sigma 
# 81 "plugins/ltac/g_rewrite.ml"
), (fun env sigma -> 
                                                                 
# 62 "plugins/ltac/g_rewrite.mlg"
                      pr_glob_constr_with_bindings env sigma 
# 86 "plugins/ltac/g_rewrite.ml"
), (fun env sigma -> 
                                                                 
# 55 "plugins/ltac/g_rewrite.mlg"
                 pr_glob_constr_with_bindings_sign env sigma 
# 91 "plugins/ltac/g_rewrite.ml"
));
                                                                 }
let _ = (wit_glob_constr_with_bindings, glob_constr_with_bindings)


# 67 "plugins/ltac/g_rewrite.mlg"
 

let subst_strategy sub = map_strategy
    (Tacsubst.subst_glob_constr_and_expr sub)
    (Tacsubst.subst_glob_red_expr sub)
    (fun x -> x)

let pr_strategy _ _ _ (s : strategy) = Pp.str "<strategy>"
let pr_raw_strategy env sigma prc prlc _ (s : Tacexpr.raw_strategy) =
  let prr = Pptactic.pr_red_expr env sigma (prc, prlc, Pputils.pr_or_by_notation Libnames.pr_qualid, prc,Pputils.pr_or_var Pp.int) in
  Rewrite.pr_strategy (prc env sigma) prr Pputils.pr_lident s
let pr_glob_strategy env sigma prc prlc _ (s : Tacexpr.glob_strategy) =
  let prcst = Pputils.pr_or_var Pptactic.(pr_and_short_name (pr_evaluable_reference_env env)) in
  let prr = Pptactic.pr_red_expr env sigma (prc, prlc, prcst, prc, Pputils.pr_or_var Pp.int) in
  Rewrite.pr_strategy (prc env sigma) prr Id.print s


# 115 "plugins/ltac/g_rewrite.ml"

let (wit_rewstrategy, rewstrategy) = Tacentries.argument_extend ~plugin:"rocq-runtime.plugins.ltac" ~name:"rewstrategy" 
                                     {
                                     Tacentries.arg_parsing = Vernacextend.Arg_rules
                                                              ([]);
                                     Tacentries.arg_tag = None;
                                     Tacentries.arg_intern = Tacentries.ArgInternFun ((fun f ist v -> (ist, f ist v)) (
                                                             
# 89 "plugins/ltac/g_rewrite.mlg"
                    Tacintern.intern_strategy 
# 126 "plugins/ltac/g_rewrite.ml"
));
                                     Tacentries.arg_subst = Tacentries.ArgSubstFun (
                                                            
# 90 "plugins/ltac/g_rewrite.mlg"
                     subst_strategy 
# 132 "plugins/ltac/g_rewrite.ml"
);
                                     Tacentries.arg_interp = Tacentries.ArgInterpSimple (
                                                             
# 88 "plugins/ltac/g_rewrite.mlg"
                     Tacinterp.interp_strategy 
# 138 "plugins/ltac/g_rewrite.ml"
);
                                     Tacentries.arg_printer = ((fun env sigma -> 
                                                              
# 92 "plugins/ltac/g_rewrite.mlg"
                     pr_raw_strategy env sigma 
# 144 "plugins/ltac/g_rewrite.ml"
), (fun env sigma -> 
                                                              
# 93 "plugins/ltac/g_rewrite.mlg"
                      pr_glob_strategy env sigma 
# 149 "plugins/ltac/g_rewrite.ml"
), (fun env sigma -> 
                                                              
# 86 "plugins/ltac/g_rewrite.mlg"
                 pr_strategy 
# 154 "plugins/ltac/g_rewrite.ml"
));
                                     }
let _ = (wit_rewstrategy, rewstrategy)

let _ =
  let ne_rewstrategy1_list_sep_semicolon =
    Procq.Entry.make "ne_rewstrategy1_list_sep_semicolon"
  and rewstrategy1 = Procq.Entry.make "rewstrategy1"
  and rewstrategy0 = Procq.Entry.make "rewstrategy0"
  in
  let () = assert (Procq.Entry.is_empty rewstrategy) in
  let () =
  Egramml.grammar_extend ~plugin_uid:("rocq-runtime.plugins.ltac", "g_rewrite.mlg:0")
  rewstrategy
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, Some (Gramlib.Gramext.NonA),
                           [Procq.Production.make
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.nterm ne_rewstrategy1_list_sep_semicolon)))
                            (fun h loc -> 
# 101 "plugins/ltac/g_rewrite.mlg"
                                                    h 
# 177 "plugins/ltac/g_rewrite.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next
                             (Procq.Rule.next
                              (Procq.Rule.next (Procq.Rule.stop)
                               ((Procq.Symbol.token (Tok.PIDENT (Some
                               ("fix"))))))
                              ((Procq.Symbol.nterm identref)))
                             ((Procq.Symbol.token (Tok.PKEYWORD (":=")))))
                            ((Procq.Symbol.nterm rewstrategy1)))
                           (fun s _ id _ loc -> 
# 100 "plugins/ltac/g_rewrite.mlg"
                                                                StratFix (id, s) 
# 192 "plugins/ltac/g_rewrite.ml"
)])]))
  in let () =
  assert (Procq.Entry.is_empty ne_rewstrategy1_list_sep_semicolon) in
  let () =
  Egramml.grammar_extend ~plugin_uid:("rocq-runtime.plugins.ltac", "g_rewrite.mlg:1")
  ne_rewstrategy1_list_sep_semicolon
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, Some (Gramlib.Gramext.LeftA),
                           [Procq.Production.make
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.nterm rewstrategy1)))
                            (fun h loc -> 
# 106 "plugins/ltac/g_rewrite.mlg"
                              h 
# 207 "plugins/ltac/g_rewrite.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next
                             (Procq.Rule.next (Procq.Rule.stop)
                              (Procq.Symbol.self))
                             ((Procq.Symbol.token (Tok.PKEYWORD (";")))))
                            ((Procq.Symbol.nterm rewstrategy1)))
                           (fun h' _ h loc -> 
# 105 "plugins/ltac/g_rewrite.mlg"
                                              StratBinary (Compose, h, h') 
# 219 "plugins/ltac/g_rewrite.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty rewstrategy1) in
  let () =
  Egramml.grammar_extend ~plugin_uid:("rocq-runtime.plugins.ltac", "g_rewrite.mlg:2")
  rewstrategy1
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, Some (Gramlib.Gramext.RightA),
                           [Procq.Production.make
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.nterm rewstrategy0)))
                            (fun h loc -> 
# 127 "plugins/ltac/g_rewrite.mlg"
                              h 
# 233 "plugins/ltac/g_rewrite.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.token (Tok.PIDENT (Some
                             ("fold"))))))
                            ((Procq.Symbol.nterm constr)))
                           (fun c _ loc -> 
# 126 "plugins/ltac/g_rewrite.mlg"
                                      StratFold c 
# 244 "plugins/ltac/g_rewrite.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.token (Tok.PIDENT (Some
                             ("eval"))))))
                            ((Procq.Symbol.nterm red_expr)))
                           (fun r _ loc -> 
# 125 "plugins/ltac/g_rewrite.mlg"
                                        StratEval r 
# 255 "plugins/ltac/g_rewrite.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.token (Tok.PIDENT (Some
                             ("terms"))))))
                            ((Procq.Symbol.list0 (Procq.Symbol.nterm constr))))
                           (fun h _ loc -> 
# 124 "plugins/ltac/g_rewrite.mlg"
                                             StratTerms h 
# 266 "plugins/ltac/g_rewrite.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.token (Tok.PIDENT (Some
                             ("hints"))))))
                            ((Procq.Symbol.nterm preident)))
                           (fun h _ loc -> 
# 123 "plugins/ltac/g_rewrite.mlg"
                                         StratHints (false, h) 
# 277 "plugins/ltac/g_rewrite.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.token (Tok.PIDENT (Some
                             ("old_hints"))))))
                            ((Procq.Symbol.nterm preident)))
                           (fun h _ loc -> 
# 122 "plugins/ltac/g_rewrite.mlg"
                                             StratHints (true, h) 
# 288 "plugins/ltac/g_rewrite.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.token (Tok.PIDENT (Some
                             ("choice"))))))
                            ((Procq.Symbol.list1 ((Procq.Symbol.nterm rewstrategy0)))))
                           (fun h _ loc -> 
# 121 "plugins/ltac/g_rewrite.mlg"
                                                    StratNAry (Choice, h) 
# 299 "plugins/ltac/g_rewrite.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.token (Tok.PIDENT (Some
                             ("repeat"))))))
                            (Procq.Symbol.self))
                           (fun h _ loc -> 
# 120 "plugins/ltac/g_rewrite.mlg"
                                      StratUnary (Repeat, h) 
# 310 "plugins/ltac/g_rewrite.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.token (Tok.PIDENT (Some
                             ("any"))))))
                            (Procq.Symbol.self))
                           (fun h _ loc -> 
# 119 "plugins/ltac/g_rewrite.mlg"
                                   StratUnary (Any, h) 
# 321 "plugins/ltac/g_rewrite.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.token (Tok.PIDENT (Some
                             ("try"))))))
                            (Procq.Symbol.self))
                           (fun h _ loc -> 
# 118 "plugins/ltac/g_rewrite.mlg"
                                   StratUnary (Try, h) 
# 332 "plugins/ltac/g_rewrite.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.token (Tok.PIDENT (Some
                             ("progress"))))))
                            (Procq.Symbol.self))
                           (fun h _ loc -> 
# 117 "plugins/ltac/g_rewrite.mlg"
                                        StratUnary (Progress, h) 
# 343 "plugins/ltac/g_rewrite.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.token (Tok.PIDENT (Some
                             ("topdown"))))))
                            (Procq.Symbol.self))
                           (fun h _ loc -> 
# 116 "plugins/ltac/g_rewrite.mlg"
                                       StratUnary(Topdown, h) 
# 354 "plugins/ltac/g_rewrite.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.token (Tok.PIDENT (Some
                             ("bottomup"))))))
                            (Procq.Symbol.self))
                           (fun h _ loc -> 
# 115 "plugins/ltac/g_rewrite.mlg"
                                        StratUnary(Bottomup, h) 
# 365 "plugins/ltac/g_rewrite.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.token (Tok.PIDENT (Some
                             ("outermost"))))))
                            (Procq.Symbol.self))
                           (fun h _ loc -> 
# 114 "plugins/ltac/g_rewrite.mlg"
                                         StratUnary(Outermost, h) 
# 376 "plugins/ltac/g_rewrite.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.token (Tok.PIDENT (Some
                             ("innermost"))))))
                            (Procq.Symbol.self))
                           (fun h _ loc -> 
# 113 "plugins/ltac/g_rewrite.mlg"
                                         StratUnary(Innermost, h) 
# 387 "plugins/ltac/g_rewrite.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.token (Tok.PIDENT (Some
                             ("subterm"))))))
                            (Procq.Symbol.self))
                           (fun h _ loc -> 
# 112 "plugins/ltac/g_rewrite.mlg"
                                       StratUnary (Subterm, h) 
# 398 "plugins/ltac/g_rewrite.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.token (Tok.PIDENT (Some
                             ("subterms"))))))
                            (Procq.Symbol.self))
                           (fun h _ loc -> 
# 111 "plugins/ltac/g_rewrite.mlg"
                                        StratUnary (Subterms, h) 
# 409 "plugins/ltac/g_rewrite.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.token (Tok.PKEYWORD ("<-")))))
                            ((Procq.Symbol.nterm constr)))
                           (fun c _ loc -> 
# 110 "plugins/ltac/g_rewrite.mlg"
                              StratConstr (c, false) 
# 419 "plugins/ltac/g_rewrite.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty rewstrategy0) in
  let () =
  Egramml.grammar_extend ~plugin_uid:("rocq-runtime.plugins.ltac", "g_rewrite.mlg:3")
  rewstrategy0
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, Some (Gramlib.Gramext.NonA),
                           [Procq.Production.make
                            (Procq.Rule.next
                             (Procq.Rule.next
                              (Procq.Rule.next (Procq.Rule.stop)
                               ((Procq.Symbol.token (Tok.PKEYWORD ("(")))))
                              ((Procq.Symbol.nterm rewstrategy)))
                             ((Procq.Symbol.token (Tok.PKEYWORD (")")))))
                            (fun _ h _ loc -> 
# 135 "plugins/ltac/g_rewrite.mlg"
                                       h 
# 437 "plugins/ltac/g_rewrite.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next (Procq.Rule.stop)
                            ((Procq.Symbol.token (Tok.PIDENT (Some
                            ("refl"))))))
                           (fun _ loc -> 
# 134 "plugins/ltac/g_rewrite.mlg"
                          StratRefl 
# 446 "plugins/ltac/g_rewrite.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next (Procq.Rule.stop)
                            ((Procq.Symbol.token (Tok.PIDENT (Some
                            ("fail"))))))
                           (fun _ loc -> 
# 133 "plugins/ltac/g_rewrite.mlg"
                          StratFail 
# 455 "plugins/ltac/g_rewrite.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next (Procq.Rule.stop)
                            ((Procq.Symbol.token (Tok.PIDENT (Some ("id"))))))
                           (fun _ loc -> 
# 132 "plugins/ltac/g_rewrite.mlg"
                        StratId 
# 463 "plugins/ltac/g_rewrite.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next (Procq.Rule.stop)
                            ((Procq.Symbol.nterm constr)))
                           (fun c loc -> 
# 131 "plugins/ltac/g_rewrite.mlg"
                        StratConstr (c, true) 
# 471 "plugins/ltac/g_rewrite.ml"
)])]))
  in ()


# 141 "plugins/ltac/g_rewrite.mlg"
 

let db_strat db = StratUnary (Topdown, StratHints (false, db))
let cl_rewrite_clause_db ist db = cl_rewrite_clause_strat (strategy_of_ast (db_strat db))

let cl_rewrite_clause (ist, c) b occ cl =
  let c env sigma = Tacinterp.interp_open_constr_with_bindings ist env sigma c in
  cl_rewrite_clause c b occ cl


# 487 "plugins/ltac/g_rewrite.ml"

let () = Tacentries.tactic_extend "rocq-runtime.plugins.ltac" "rewrite_strat" ~level:0 
         [(Tacentries.TyML (Tacentries.TyIdent ("rewrite_strat", Tacentries.TyArg (
                                                                 Extend.TUentry (Genarg.get_arg_tag wit_rewstrategy), 
                                                                 Tacentries.TyIdent ("in", 
                                                                 Tacentries.TyArg (
                                                                 Extend.TUentry (Genarg.get_arg_tag wit_hyp), 
                                                                 Tacentries.TyNil)))), 
           (fun s id ist -> 
# 153 "plugins/ltac/g_rewrite.mlg"
                                                       cl_rewrite_clause_strat s (Some id) 
# 499 "plugins/ltac/g_rewrite.ml"
)));
         (Tacentries.TyML (Tacentries.TyIdent ("rewrite_strat", Tacentries.TyArg (
                                                                Extend.TUentry (Genarg.get_arg_tag wit_rewstrategy), 
                                                                Tacentries.TyNil)), 
          (fun s ist -> 
# 154 "plugins/ltac/g_rewrite.mlg"
                                          cl_rewrite_clause_strat s None 
# 507 "plugins/ltac/g_rewrite.ml"
)));
         (Tacentries.TyML (Tacentries.TyIdent ("rewrite_db", Tacentries.TyArg (
                                                             Extend.TUentry (Genarg.get_arg_tag wit_preident), 
                                                             Tacentries.TyIdent ("in", 
                                                             Tacentries.TyArg (
                                                             Extend.TUentry (Genarg.get_arg_tag wit_hyp), 
                                                             Tacentries.TyNil)))), 
          (fun db id ist -> 
# 155 "plugins/ltac/g_rewrite.mlg"
                                                  cl_rewrite_clause_db ist db (Some id) 
# 518 "plugins/ltac/g_rewrite.ml"
)));
         (Tacentries.TyML (Tacentries.TyIdent ("rewrite_db", Tacentries.TyArg (
                                                             Extend.TUentry (Genarg.get_arg_tag wit_preident), 
                                                             Tacentries.TyNil)), 
          (fun db ist -> 
# 156 "plugins/ltac/g_rewrite.mlg"
                                     cl_rewrite_clause_db ist db None 
# 526 "plugins/ltac/g_rewrite.ml"
)))]


# 159 "plugins/ltac/g_rewrite.mlg"
 

let clsubstitute o c =
  Proofview.Goal.enter begin fun gl ->
  let is_tac id = match DAst.get (fst (fst (snd c))) with GVar id' when Id.equal id' id -> true | _ -> false in
  let hyps = Tacmach.pf_ids_of_hyps gl in
    Tacticals.tclMAP
      (fun cl ->
        match cl with
          | Some id when is_tac id -> Tacticals.tclIDTAC
          | _ -> cl_rewrite_clause c o AllOccurrences cl)
      (None :: List.map (fun id -> Some id) hyps)
  end


# 546 "plugins/ltac/g_rewrite.ml"

let () = Tacentries.tactic_extend "rocq-runtime.plugins.ltac" "substitute" ~level:0 
         [(Tacentries.TyML (Tacentries.TyIdent ("substitute", Tacentries.TyArg (
                                                              Extend.TUentry (Genarg.get_arg_tag wit_orient), 
                                                              Tacentries.TyArg (
                                                              Extend.TUentry (Genarg.get_arg_tag wit_glob_constr_with_bindings), 
                                                              Tacentries.TyNil))), 
           (fun o c ist -> 
# 176 "plugins/ltac/g_rewrite.mlg"
                                                               clsubstitute o c 
# 557 "plugins/ltac/g_rewrite.ml"
)))]

let () = Tacentries.tactic_extend "rocq-runtime.plugins.ltac" "setoid_rewrite" ~level:0 
         [(Tacentries.TyML (Tacentries.TyIdent ("setoid_rewrite", Tacentries.TyArg (
                                                                  Extend.TUentry (Genarg.get_arg_tag wit_orient), 
                                                                  Tacentries.TyArg (
                                                                  Extend.TUentry (Genarg.get_arg_tag wit_glob_constr_with_bindings), 
                                                                  Tacentries.TyNil))), 
           (fun o c ist -> 
# 184 "plugins/ltac/g_rewrite.mlg"
        cl_rewrite_clause c o AllOccurrences None 
# 569 "plugins/ltac/g_rewrite.ml"
)));
         (Tacentries.TyML (Tacentries.TyIdent ("setoid_rewrite", Tacentries.TyArg (
                                                                 Extend.TUentry (Genarg.get_arg_tag wit_orient), 
                                                                 Tacentries.TyArg (
                                                                 Extend.TUentry (Genarg.get_arg_tag wit_glob_constr_with_bindings), 
                                                                 Tacentries.TyIdent ("in", 
                                                                 Tacentries.TyArg (
                                                                 Extend.TUentry (Genarg.get_arg_tag wit_hyp), 
                                                                 Tacentries.TyNil))))), 
          (fun o c id ist -> 
# 186 "plugins/ltac/g_rewrite.mlg"
        cl_rewrite_clause c o AllOccurrences (Some id) 
# 582 "plugins/ltac/g_rewrite.ml"
)));
         (Tacentries.TyML (Tacentries.TyIdent ("setoid_rewrite", Tacentries.TyArg (
                                                                 Extend.TUentry (Genarg.get_arg_tag wit_orient), 
                                                                 Tacentries.TyArg (
                                                                 Extend.TUentry (Genarg.get_arg_tag wit_glob_constr_with_bindings), 
                                                                 Tacentries.TyIdent ("at", 
                                                                 Tacentries.TyArg (
                                                                 Extend.TUentry (Genarg.get_arg_tag wit_occurrences), 
                                                                 Tacentries.TyNil))))), 
          (fun o c occ ist -> 
# 188 "plugins/ltac/g_rewrite.mlg"
        cl_rewrite_clause c o (occurrences_of occ) None 
# 595 "plugins/ltac/g_rewrite.ml"
)));
         (Tacentries.TyML (Tacentries.TyIdent ("setoid_rewrite", Tacentries.TyArg (
                                                                 Extend.TUentry (Genarg.get_arg_tag wit_orient), 
                                                                 Tacentries.TyArg (
                                                                 Extend.TUentry (Genarg.get_arg_tag wit_glob_constr_with_bindings), 
                                                                 Tacentries.TyIdent ("at", 
                                                                 Tacentries.TyArg (
                                                                 Extend.TUentry (Genarg.get_arg_tag wit_occurrences), 
                                                                 Tacentries.TyIdent ("in", 
                                                                 Tacentries.TyArg (
                                                                 Extend.TUentry (Genarg.get_arg_tag wit_hyp), 
                                                                 Tacentries.TyNil))))))), 
          (fun o c occ id ist -> 
# 190 "plugins/ltac/g_rewrite.mlg"
        cl_rewrite_clause c o (occurrences_of occ) (Some id) 
# 611 "plugins/ltac/g_rewrite.ml"
)));
         (Tacentries.TyML (Tacentries.TyIdent ("setoid_rewrite", Tacentries.TyArg (
                                                                 Extend.TUentry (Genarg.get_arg_tag wit_orient), 
                                                                 Tacentries.TyArg (
                                                                 Extend.TUentry (Genarg.get_arg_tag wit_glob_constr_with_bindings), 
                                                                 Tacentries.TyIdent ("in", 
                                                                 Tacentries.TyArg (
                                                                 Extend.TUentry (Genarg.get_arg_tag wit_hyp), 
                                                                 Tacentries.TyIdent ("at", 
                                                                 Tacentries.TyArg (
                                                                 Extend.TUentry (Genarg.get_arg_tag wit_occurrences), 
                                                                 Tacentries.TyNil))))))), 
          (fun o c id occ ist -> 
# 192 "plugins/ltac/g_rewrite.mlg"
        cl_rewrite_clause c o (occurrences_of occ) (Some id) 
# 627 "plugins/ltac/g_rewrite.ml"
)))]

let () = Vernacextend.static_vernac_extend ~plugin:(Some "rocq-runtime.plugins.ltac") ~command:"AddRelation" ~classifier:(fun ~atts:_ _ -> Vernacextend.classify_as_sideeff) ?entry:None 
         [(Vernacextend.TyML
         (false,
          Vernacextend.TyTerminal
          ("Add",
           Vernacextend.TyTerminal
           ("Relation",
            Vernacextend.TyNonTerminal (Extend.TUentry (Genarg.get_arg_tag wit_constr),
            Vernacextend.TyNonTerminal (Extend.TUentry (Genarg.get_arg_tag wit_constr),
            Vernacextend.TyTerminal
            ("reflexivity",
             Vernacextend.TyTerminal
             ("proved",
              Vernacextend.TyTerminal
              ("by",
               Vernacextend.TyNonTerminal (Extend.TUentry (Genarg.get_arg_tag wit_constr),
               Vernacextend.TyTerminal
               ("symmetry",
                Vernacextend.TyTerminal
                ("proved",
                 Vernacextend.TyTerminal
                 ("by",
                  Vernacextend.TyNonTerminal (Extend.TUentry (Genarg.get_arg_tag wit_constr),
                  Vernacextend.TyTerminal
                  ("as",
                   Vernacextend.TyNonTerminal (Extend.TUentry (Genarg.get_arg_tag wit_identref),
                   Vernacextend.TyNil)))))))))))))),
          (let coqpp_body a aeq lemma1 lemma2 n atts =
            Vernactypes.vtdefault (fun () -> 
# 198 "plugins/ltac/g_rewrite.mlg"
        declare_relation atts a aeq n (Some lemma1) (Some lemma2) None 
# 661 "plugins/ltac/g_rewrite.ml"
) in
            fun a aeq lemma1 lemma2 n ?loc ~atts () ->
            coqpp_body a aeq lemma1 lemma2 n (Attributes.parse 
# 196 "plugins/ltac/g_rewrite.mlg"
               rewrite_attributes
# 667 "plugins/ltac/g_rewrite.ml"
 atts)),
          None));
         (Vernacextend.TyML
         (false,
          Vernacextend.TyTerminal
          ("Add",
           Vernacextend.TyTerminal
           ("Relation",
            Vernacextend.TyNonTerminal (Extend.TUentry (Genarg.get_arg_tag wit_constr),
            Vernacextend.TyNonTerminal (Extend.TUentry (Genarg.get_arg_tag wit_constr),
            Vernacextend.TyTerminal
            ("reflexivity",
             Vernacextend.TyTerminal
             ("proved",
              Vernacextend.TyTerminal
              ("by",
               Vernacextend.TyNonTerminal (Extend.TUentry (Genarg.get_arg_tag wit_constr),
               Vernacextend.TyTerminal
               ("as",
                Vernacextend.TyNonTerminal (Extend.TUentry (Genarg.get_arg_tag wit_identref),
                Vernacextend.TyNil)))))))))),
          (let coqpp_body a aeq lemma1 n atts =
            Vernactypes.vtdefault (fun () -> 
# 202 "plugins/ltac/g_rewrite.mlg"
        declare_relation atts a aeq n (Some lemma1) None None 
# 693 "plugins/ltac/g_rewrite.ml"
) in
            fun a aeq lemma1 n ?loc ~atts () ->
            coqpp_body a aeq lemma1 n (Attributes.parse 
# 200 "plugins/ltac/g_rewrite.mlg"
               rewrite_attributes
# 699 "plugins/ltac/g_rewrite.ml"
 atts)),
          None));
         (Vernacextend.TyML
         (false,
          Vernacextend.TyTerminal
          ("Add",
           Vernacextend.TyTerminal
           ("Relation",
            Vernacextend.TyNonTerminal (Extend.TUentry (Genarg.get_arg_tag wit_constr),
            Vernacextend.TyNonTerminal (Extend.TUentry (Genarg.get_arg_tag wit_constr),
            Vernacextend.TyTerminal
            ("as",
             Vernacextend.TyNonTerminal (Extend.TUentry (Genarg.get_arg_tag wit_identref),
             Vernacextend.TyNil)))))),
          (let coqpp_body a aeq n atts =
            Vernactypes.vtdefault (fun () -> 
# 204 "plugins/ltac/g_rewrite.mlg"
        declare_relation atts a aeq n None None None 
# 718 "plugins/ltac/g_rewrite.ml"
) in
            fun a aeq n ?loc ~atts () ->
            coqpp_body a aeq n (Attributes.parse 
# 203 "plugins/ltac/g_rewrite.mlg"
               rewrite_attributes
# 724 "plugins/ltac/g_rewrite.ml"
 atts)),
          None))]

let () = Vernacextend.static_vernac_extend ~plugin:(Some "rocq-runtime.plugins.ltac") ~command:"AddRelation2" ~classifier:(fun ~atts:_ _ -> Vernacextend.classify_as_sideeff) ?entry:None 
         [(Vernacextend.TyML
         (false,
          Vernacextend.TyTerminal
          ("Add",
           Vernacextend.TyTerminal
           ("Relation",
            Vernacextend.TyNonTerminal (Extend.TUentry (Genarg.get_arg_tag wit_constr),
            Vernacextend.TyNonTerminal (Extend.TUentry (Genarg.get_arg_tag wit_constr),
            Vernacextend.TyTerminal
            ("symmetry",
             Vernacextend.TyTerminal
             ("proved",
              Vernacextend.TyTerminal
              ("by",
               Vernacextend.TyNonTerminal (Extend.TUentry (Genarg.get_arg_tag wit_constr),
               Vernacextend.TyTerminal
               ("as",
                Vernacextend.TyNonTerminal (Extend.TUentry (Genarg.get_arg_tag wit_identref),
                Vernacextend.TyNil)))))))))),
          (let coqpp_body a aeq lemma2 n atts =
            Vernactypes.vtdefault (fun () -> 
# 210 "plugins/ltac/g_rewrite.mlg"
        declare_relation atts a aeq n None (Some lemma2) None 
# 752 "plugins/ltac/g_rewrite.ml"
) in
            fun a aeq lemma2 n ?loc ~atts () ->
            coqpp_body a aeq lemma2 n (Attributes.parse 
# 208 "plugins/ltac/g_rewrite.mlg"
               rewrite_attributes
# 758 "plugins/ltac/g_rewrite.ml"
 atts)),
          None));
         (Vernacextend.TyML
         (false,
          Vernacextend.TyTerminal
          ("Add",
           Vernacextend.TyTerminal
           ("Relation",
            Vernacextend.TyNonTerminal (Extend.TUentry (Genarg.get_arg_tag wit_constr),
            Vernacextend.TyNonTerminal (Extend.TUentry (Genarg.get_arg_tag wit_constr),
            Vernacextend.TyTerminal
            ("symmetry",
             Vernacextend.TyTerminal
             ("proved",
              Vernacextend.TyTerminal
              ("by",
               Vernacextend.TyNonTerminal (Extend.TUentry (Genarg.get_arg_tag wit_constr),
               Vernacextend.TyTerminal
               ("transitivity",
                Vernacextend.TyTerminal
                ("proved",
                 Vernacextend.TyTerminal
                 ("by",
                  Vernacextend.TyNonTerminal (Extend.TUentry (Genarg.get_arg_tag wit_constr),
                  Vernacextend.TyTerminal
                  ("as",
                   Vernacextend.TyNonTerminal (Extend.TUentry (Genarg.get_arg_tag wit_identref),
                   Vernacextend.TyNil)))))))))))))),
          (let coqpp_body a aeq lemma2 lemma3 n atts =
            Vernactypes.vtdefault (fun () -> 
# 212 "plugins/ltac/g_rewrite.mlg"
        declare_relation atts a aeq n None (Some lemma2) (Some lemma3) 
# 791 "plugins/ltac/g_rewrite.ml"
) in
            fun a aeq lemma2 lemma3 n ?loc ~atts () ->
            coqpp_body a aeq lemma2 lemma3 n (Attributes.parse 
# 211 "plugins/ltac/g_rewrite.mlg"
               rewrite_attributes
# 797 "plugins/ltac/g_rewrite.ml"
 atts)),
          None))]

let () = Vernacextend.static_vernac_extend ~plugin:(Some "rocq-runtime.plugins.ltac") ~command:"AddRelation3" ~classifier:(fun ~atts:_ _ -> Vernacextend.classify_as_sideeff) ?entry:None 
         [(Vernacextend.TyML
         (false,
          Vernacextend.TyTerminal
          ("Add",
           Vernacextend.TyTerminal
           ("Relation",
            Vernacextend.TyNonTerminal (Extend.TUentry (Genarg.get_arg_tag wit_constr),
            Vernacextend.TyNonTerminal (Extend.TUentry (Genarg.get_arg_tag wit_constr),
            Vernacextend.TyTerminal
            ("reflexivity",
             Vernacextend.TyTerminal
             ("proved",
              Vernacextend.TyTerminal
              ("by",
               Vernacextend.TyNonTerminal (Extend.TUentry (Genarg.get_arg_tag wit_constr),
               Vernacextend.TyTerminal
               ("transitivity",
                Vernacextend.TyTerminal
                ("proved",
                 Vernacextend.TyTerminal
                 ("by",
                  Vernacextend.TyNonTerminal (Extend.TUentry (Genarg.get_arg_tag wit_constr),
                  Vernacextend.TyTerminal
                  ("as",
                   Vernacextend.TyNonTerminal (Extend.TUentry (Genarg.get_arg_tag wit_identref),
                   Vernacextend.TyNil)))))))))))))),
          (let coqpp_body a aeq lemma1 lemma3 n atts =
            Vernactypes.vtdefault (fun () -> 
# 218 "plugins/ltac/g_rewrite.mlg"
        declare_relation atts a aeq n (Some lemma1) None (Some lemma3) 
# 832 "plugins/ltac/g_rewrite.ml"
) in
            fun a aeq lemma1 lemma3 n ?loc ~atts () ->
            coqpp_body a aeq lemma1 lemma3 n (Attributes.parse 
# 216 "plugins/ltac/g_rewrite.mlg"
               rewrite_attributes
# 838 "plugins/ltac/g_rewrite.ml"
 atts)),
          None));
         (Vernacextend.TyML
         (false,
          Vernacextend.TyTerminal
          ("Add",
           Vernacextend.TyTerminal
           ("Relation",
            Vernacextend.TyNonTerminal (Extend.TUentry (Genarg.get_arg_tag wit_constr),
            Vernacextend.TyNonTerminal (Extend.TUentry (Genarg.get_arg_tag wit_constr),
            Vernacextend.TyTerminal
            ("reflexivity",
             Vernacextend.TyTerminal
             ("proved",
              Vernacextend.TyTerminal
              ("by",
               Vernacextend.TyNonTerminal (Extend.TUentry (Genarg.get_arg_tag wit_constr),
               Vernacextend.TyTerminal
               ("symmetry",
                Vernacextend.TyTerminal
                ("proved",
                 Vernacextend.TyTerminal
                 ("by",
                  Vernacextend.TyNonTerminal (Extend.TUentry (Genarg.get_arg_tag wit_constr),
                  Vernacextend.TyTerminal
                  ("transitivity",
                   Vernacextend.TyTerminal
                   ("proved",
                    Vernacextend.TyTerminal
                    ("by",
                     Vernacextend.TyNonTerminal (Extend.TUentry (Genarg.get_arg_tag wit_constr),
                     Vernacextend.TyTerminal
                     ("as",
                      Vernacextend.TyNonTerminal (Extend.TUentry (Genarg.get_arg_tag wit_identref),
                      Vernacextend.TyNil)))))))))))))))))),
          (let coqpp_body a aeq lemma1 lemma2 lemma3 n atts =
            Vernactypes.vtdefault (fun () -> 
# 222 "plugins/ltac/g_rewrite.mlg"
        declare_relation atts a aeq n (Some lemma1) (Some lemma2) (Some lemma3) 
# 878 "plugins/ltac/g_rewrite.ml"
) in
            fun a aeq lemma1 lemma2 lemma3 n ?loc ~atts () ->
            coqpp_body a aeq lemma1 lemma2 lemma3 n (Attributes.parse 
# 219 "plugins/ltac/g_rewrite.mlg"
               rewrite_attributes
# 884 "plugins/ltac/g_rewrite.ml"
 atts)),
          None));
         (Vernacextend.TyML
         (false,
          Vernacextend.TyTerminal
          ("Add",
           Vernacextend.TyTerminal
           ("Relation",
            Vernacextend.TyNonTerminal (Extend.TUentry (Genarg.get_arg_tag wit_constr),
            Vernacextend.TyNonTerminal (Extend.TUentry (Genarg.get_arg_tag wit_constr),
            Vernacextend.TyTerminal
            ("transitivity",
             Vernacextend.TyTerminal
             ("proved",
              Vernacextend.TyTerminal
              ("by",
               Vernacextend.TyNonTerminal (Extend.TUentry (Genarg.get_arg_tag wit_constr),
               Vernacextend.TyTerminal
               ("as",
                Vernacextend.TyNonTerminal (Extend.TUentry (Genarg.get_arg_tag wit_identref),
                Vernacextend.TyNil)))))))))),
          (let coqpp_body a aeq lemma3 n atts =
            Vernactypes.vtdefault (fun () -> 
# 225 "plugins/ltac/g_rewrite.mlg"
        declare_relation atts a aeq n None None (Some lemma3) 
# 910 "plugins/ltac/g_rewrite.ml"
) in
            fun a aeq lemma3 n ?loc ~atts () ->
            coqpp_body a aeq lemma3 n (Attributes.parse 
# 223 "plugins/ltac/g_rewrite.mlg"
               rewrite_attributes
# 916 "plugins/ltac/g_rewrite.ml"
 atts)),
          None))]


# 228 "plugins/ltac/g_rewrite.mlg"
 

type binders_argtype = local_binder_expr list

let wit_binders =
 (Genarg.create_arg "binders" : binders_argtype Genarg.vernac_genarg_type)

let binders = Procq.create_generic_entry2 "binders" (Genarg.rawwit wit_binders)

let () =
  let raw_printer l = Genprint.PrinterBasic (fun env sigma -> Pp.pr_non_empty_arg (Ppconstr.pr_binders env sigma) l) in
  Genprint.register_vernac_print0 wit_binders raw_printer


# 936 "plugins/ltac/g_rewrite.ml"

let _ = let () = assert (Procq.Entry.is_empty binders) in
  let () =
  Egramml.grammar_extend ~plugin_uid:("rocq-runtime.plugins.ltac", "g_rewrite.mlg:4")
  binders
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.nterm Procq.Constr.binders)))
                            (fun b loc -> 
# 246 "plugins/ltac/g_rewrite.mlg"
                                      b 
# 950 "plugins/ltac/g_rewrite.ml"
)])]))
  in ()

let () = Vernacextend.static_vernac_extend ~plugin:(Some "rocq-runtime.plugins.ltac") ~command:"AddParametricRelation" ~classifier:(fun ~atts:_ _ -> Vernacextend.classify_as_sideeff) ?entry:None 
         [(Vernacextend.TyML
         (false,
          Vernacextend.TyTerminal
          ("Add",
           Vernacextend.TyTerminal
           ("Parametric",
            Vernacextend.TyTerminal
            ("Relation",
             Vernacextend.TyNonTerminal (Extend.TUentry (Genarg.get_arg_tag wit_binders),
             Vernacextend.TyTerminal
             (":",
              Vernacextend.TyNonTerminal (Extend.TUentry (Genarg.get_arg_tag wit_constr),
              Vernacextend.TyNonTerminal (Extend.TUentry (Genarg.get_arg_tag wit_constr),
              Vernacextend.TyTerminal
              ("reflexivity",
               Vernacextend.TyTerminal
               ("proved",
                Vernacextend.TyTerminal
                ("by",
                 Vernacextend.TyNonTerminal (Extend.TUentry (Genarg.get_arg_tag wit_constr),
                 Vernacextend.TyTerminal
                 ("symmetry",
                  Vernacextend.TyTerminal
                  ("proved",
                   Vernacextend.TyTerminal
                   ("by",
                    Vernacextend.TyNonTerminal (Extend.TUentry (Genarg.get_arg_tag wit_constr),
                    Vernacextend.TyTerminal
                    ("as",
                     Vernacextend.TyNonTerminal (Extend.TUentry (Genarg.get_arg_tag wit_identref),
                     Vernacextend.TyNil))))))))))))))))),
          (let coqpp_body b a aeq lemma1 lemma2 n atts =
            Vernactypes.vtdefault (fun () -> 
# 253 "plugins/ltac/g_rewrite.mlg"
        declare_relation atts ~binders:b a aeq n (Some lemma1) (Some lemma2) None 
# 990 "plugins/ltac/g_rewrite.ml"
) in
            fun b a aeq lemma1 lemma2 n ?loc ~atts () ->
            coqpp_body b a aeq lemma1 lemma2 n (Attributes.parse 
# 250 "plugins/ltac/g_rewrite.mlg"
               rewrite_attributes
# 996 "plugins/ltac/g_rewrite.ml"
 atts)),
          None));
         (Vernacextend.TyML
         (false,
          Vernacextend.TyTerminal
          ("Add",
           Vernacextend.TyTerminal
           ("Parametric",
            Vernacextend.TyTerminal
            ("Relation",
             Vernacextend.TyNonTerminal (Extend.TUentry (Genarg.get_arg_tag wit_binders),
             Vernacextend.TyTerminal
             (":",
              Vernacextend.TyNonTerminal (Extend.TUentry (Genarg.get_arg_tag wit_constr),
              Vernacextend.TyNonTerminal (Extend.TUentry (Genarg.get_arg_tag wit_constr),
              Vernacextend.TyTerminal
              ("reflexivity",
               Vernacextend.TyTerminal
               ("proved",
                Vernacextend.TyTerminal
                ("by",
                 Vernacextend.TyNonTerminal (Extend.TUentry (Genarg.get_arg_tag wit_constr),
                 Vernacextend.TyTerminal
                 ("as",
                  Vernacextend.TyNonTerminal (Extend.TUentry (Genarg.get_arg_tag wit_identref),
                  Vernacextend.TyNil))))))))))))),
          (let coqpp_body b a aeq lemma1 n atts =
            Vernactypes.vtdefault (fun () -> 
# 257 "plugins/ltac/g_rewrite.mlg"
        declare_relation atts ~binders:b a aeq n (Some lemma1) None None 
# 1027 "plugins/ltac/g_rewrite.ml"
) in
            fun b a aeq lemma1 n ?loc ~atts () ->
            coqpp_body b a aeq lemma1 n (Attributes.parse 
# 254 "plugins/ltac/g_rewrite.mlg"
               rewrite_attributes
# 1033 "plugins/ltac/g_rewrite.ml"
 atts)),
          None));
         (Vernacextend.TyML
         (false,
          Vernacextend.TyTerminal
          ("Add",
           Vernacextend.TyTerminal
           ("Parametric",
            Vernacextend.TyTerminal
            ("Relation",
             Vernacextend.TyNonTerminal (Extend.TUentry (Genarg.get_arg_tag wit_binders),
             Vernacextend.TyTerminal
             (":",
              Vernacextend.TyNonTerminal (Extend.TUentry (Genarg.get_arg_tag wit_constr),
              Vernacextend.TyNonTerminal (Extend.TUentry (Genarg.get_arg_tag wit_constr),
              Vernacextend.TyTerminal
              ("as",
               Vernacextend.TyNonTerminal (Extend.TUentry (Genarg.get_arg_tag wit_identref),
               Vernacextend.TyNil))))))))),
          (let coqpp_body b a aeq n atts =
            Vernactypes.vtdefault (fun () -> 
# 259 "plugins/ltac/g_rewrite.mlg"
        declare_relation atts ~binders:b a aeq n None None None 
# 1057 "plugins/ltac/g_rewrite.ml"
) in
            fun b a aeq n ?loc ~atts () ->
            coqpp_body b a aeq n (Attributes.parse 
# 258 "plugins/ltac/g_rewrite.mlg"
               rewrite_attributes
# 1063 "plugins/ltac/g_rewrite.ml"
 atts)),
          None))]

let () = Vernacextend.static_vernac_extend ~plugin:(Some "rocq-runtime.plugins.ltac") ~command:"AddParametricRelation2" ~classifier:(fun ~atts:_ _ -> Vernacextend.classify_as_sideeff) ?entry:None 
         [(Vernacextend.TyML
         (false,
          Vernacextend.TyTerminal
          ("Add",
           Vernacextend.TyTerminal
           ("Parametric",
            Vernacextend.TyTerminal
            ("Relation",
             Vernacextend.TyNonTerminal (Extend.TUentry (Genarg.get_arg_tag wit_binders),
             Vernacextend.TyTerminal
             (":",
              Vernacextend.TyNonTerminal (Extend.TUentry (Genarg.get_arg_tag wit_constr),
              Vernacextend.TyNonTerminal (Extend.TUentry (Genarg.get_arg_tag wit_constr),
              Vernacextend.TyTerminal
              ("symmetry",
               Vernacextend.TyTerminal
               ("proved",
                Vernacextend.TyTerminal
                ("by",
                 Vernacextend.TyNonTerminal (Extend.TUentry (Genarg.get_arg_tag wit_constr),
                 Vernacextend.TyTerminal
                 ("as",
                  Vernacextend.TyNonTerminal (Extend.TUentry (Genarg.get_arg_tag wit_identref),
                  Vernacextend.TyNil))))))))))))),
          (let coqpp_body b a aeq lemma2 n atts =
            Vernactypes.vtdefault (fun () -> 
# 265 "plugins/ltac/g_rewrite.mlg"
        declare_relation atts ~binders:b a aeq n None (Some lemma2) None 
# 1096 "plugins/ltac/g_rewrite.ml"
) in
            fun b a aeq lemma2 n ?loc ~atts () ->
            coqpp_body b a aeq lemma2 n (Attributes.parse 
# 263 "plugins/ltac/g_rewrite.mlg"
               rewrite_attributes
# 1102 "plugins/ltac/g_rewrite.ml"
 atts)),
          None));
         (Vernacextend.TyML
         (false,
          Vernacextend.TyTerminal
          ("Add",
           Vernacextend.TyTerminal
           ("Parametric",
            Vernacextend.TyTerminal
            ("Relation",
             Vernacextend.TyNonTerminal (Extend.TUentry (Genarg.get_arg_tag wit_binders),
             Vernacextend.TyTerminal
             (":",
              Vernacextend.TyNonTerminal (Extend.TUentry (Genarg.get_arg_tag wit_constr),
              Vernacextend.TyNonTerminal (Extend.TUentry (Genarg.get_arg_tag wit_constr),
              Vernacextend.TyTerminal
              ("symmetry",
               Vernacextend.TyTerminal
               ("proved",
                Vernacextend.TyTerminal
                ("by",
                 Vernacextend.TyNonTerminal (Extend.TUentry (Genarg.get_arg_tag wit_constr),
                 Vernacextend.TyTerminal
                 ("transitivity",
                  Vernacextend.TyTerminal
                  ("proved",
                   Vernacextend.TyTerminal
                   ("by",
                    Vernacextend.TyNonTerminal (Extend.TUentry (Genarg.get_arg_tag wit_constr),
                    Vernacextend.TyTerminal
                    ("as",
                     Vernacextend.TyNonTerminal (Extend.TUentry (Genarg.get_arg_tag wit_identref),
                     Vernacextend.TyNil))))))))))))))))),
          (let coqpp_body b a aeq lemma2 lemma3 n atts =
            Vernactypes.vtdefault (fun () -> 
# 267 "plugins/ltac/g_rewrite.mlg"
        declare_relation atts ~binders:b a aeq n None (Some lemma2) (Some lemma3) 
# 1140 "plugins/ltac/g_rewrite.ml"
) in
            fun b a aeq lemma2 lemma3 n ?loc ~atts () ->
            coqpp_body b a aeq lemma2 lemma3 n (Attributes.parse 
# 266 "plugins/ltac/g_rewrite.mlg"
               rewrite_attributes
# 1146 "plugins/ltac/g_rewrite.ml"
 atts)),
          None))]

let () = Vernacextend.static_vernac_extend ~plugin:(Some "rocq-runtime.plugins.ltac") ~command:"AddParametricRelation3" ~classifier:(fun ~atts:_ _ -> Vernacextend.classify_as_sideeff) ?entry:None 
         [(Vernacextend.TyML
         (false,
          Vernacextend.TyTerminal
          ("Add",
           Vernacextend.TyTerminal
           ("Parametric",
            Vernacextend.TyTerminal
            ("Relation",
             Vernacextend.TyNonTerminal (Extend.TUentry (Genarg.get_arg_tag wit_binders),
             Vernacextend.TyTerminal
             (":",
              Vernacextend.TyNonTerminal (Extend.TUentry (Genarg.get_arg_tag wit_constr),
              Vernacextend.TyNonTerminal (Extend.TUentry (Genarg.get_arg_tag wit_constr),
              Vernacextend.TyTerminal
              ("reflexivity",
               Vernacextend.TyTerminal
               ("proved",
                Vernacextend.TyTerminal
                ("by",
                 Vernacextend.TyNonTerminal (Extend.TUentry (Genarg.get_arg_tag wit_constr),
                 Vernacextend.TyTerminal
                 ("transitivity",
                  Vernacextend.TyTerminal
                  ("proved",
                   Vernacextend.TyTerminal
                   ("by",
                    Vernacextend.TyNonTerminal (Extend.TUentry (Genarg.get_arg_tag wit_constr),
                    Vernacextend.TyTerminal
                    ("as",
                     Vernacextend.TyNonTerminal (Extend.TUentry (Genarg.get_arg_tag wit_identref),
                     Vernacextend.TyNil))))))))))))))))),
          (let coqpp_body b a aeq lemma1 lemma3 n atts =
            Vernactypes.vtdefault (fun () -> 
# 273 "plugins/ltac/g_rewrite.mlg"
        declare_relation atts ~binders:b a aeq n (Some lemma1) None (Some lemma3) 
# 1186 "plugins/ltac/g_rewrite.ml"
) in
            fun b a aeq lemma1 lemma3 n ?loc ~atts () ->
            coqpp_body b a aeq lemma1 lemma3 n (Attributes.parse 
# 271 "plugins/ltac/g_rewrite.mlg"
               rewrite_attributes
# 1192 "plugins/ltac/g_rewrite.ml"
 atts)),
          None));
         (Vernacextend.TyML
         (false,
          Vernacextend.TyTerminal
          ("Add",
           Vernacextend.TyTerminal
           ("Parametric",
            Vernacextend.TyTerminal
            ("Relation",
             Vernacextend.TyNonTerminal (Extend.TUentry (Genarg.get_arg_tag wit_binders),
             Vernacextend.TyTerminal
             (":",
              Vernacextend.TyNonTerminal (Extend.TUentry (Genarg.get_arg_tag wit_constr),
              Vernacextend.TyNonTerminal (Extend.TUentry (Genarg.get_arg_tag wit_constr),
              Vernacextend.TyTerminal
              ("reflexivity",
               Vernacextend.TyTerminal
               ("proved",
                Vernacextend.TyTerminal
                ("by",
                 Vernacextend.TyNonTerminal (Extend.TUentry (Genarg.get_arg_tag wit_constr),
                 Vernacextend.TyTerminal
                 ("symmetry",
                  Vernacextend.TyTerminal
                  ("proved",
                   Vernacextend.TyTerminal
                   ("by",
                    Vernacextend.TyNonTerminal (Extend.TUentry (Genarg.get_arg_tag wit_constr),
                    Vernacextend.TyTerminal
                    ("transitivity",
                     Vernacextend.TyTerminal
                     ("proved",
                      Vernacextend.TyTerminal
                      ("by",
                       Vernacextend.TyNonTerminal (Extend.TUentry (Genarg.get_arg_tag wit_constr),
                       Vernacextend.TyTerminal
                       ("as",
                        Vernacextend.TyNonTerminal (Extend.TUentry (Genarg.get_arg_tag wit_identref),
                        Vernacextend.TyNil))))))))))))))))))))),
          (let coqpp_body b a aeq lemma1 lemma2 lemma3 n atts =
            Vernactypes.vtdefault (fun () -> 
# 277 "plugins/ltac/g_rewrite.mlg"
        declare_relation atts ~binders:b a aeq n (Some lemma1) (Some lemma2) (Some lemma3) 
# 1237 "plugins/ltac/g_rewrite.ml"
) in
            fun b a aeq lemma1 lemma2 lemma3 n ?loc ~atts () ->
            coqpp_body b a aeq lemma1 lemma2 lemma3 n
              (Attributes.parse 
# 274 "plugins/ltac/g_rewrite.mlg"
               rewrite_attributes
# 1244 "plugins/ltac/g_rewrite.ml"
 atts)),
          None));
         (Vernacextend.TyML
         (false,
          Vernacextend.TyTerminal
          ("Add",
           Vernacextend.TyTerminal
           ("Parametric",
            Vernacextend.TyTerminal
            ("Relation",
             Vernacextend.TyNonTerminal (Extend.TUentry (Genarg.get_arg_tag wit_binders),
             Vernacextend.TyTerminal
             (":",
              Vernacextend.TyNonTerminal (Extend.TUentry (Genarg.get_arg_tag wit_constr),
              Vernacextend.TyNonTerminal (Extend.TUentry (Genarg.get_arg_tag wit_constr),
              Vernacextend.TyTerminal
              ("transitivity",
               Vernacextend.TyTerminal
               ("proved",
                Vernacextend.TyTerminal
                ("by",
                 Vernacextend.TyNonTerminal (Extend.TUentry (Genarg.get_arg_tag wit_constr),
                 Vernacextend.TyTerminal
                 ("as",
                  Vernacextend.TyNonTerminal (Extend.TUentry (Genarg.get_arg_tag wit_identref),
                  Vernacextend.TyNil))))))))))))),
          (let coqpp_body b a aeq lemma3 n atts =
            Vernactypes.vtdefault (fun () -> 
# 280 "plugins/ltac/g_rewrite.mlg"
        declare_relation atts ~binders:b a aeq n None None (Some lemma3) 
# 1275 "plugins/ltac/g_rewrite.ml"
) in
            fun b a aeq lemma3 n ?loc ~atts () ->
            coqpp_body b a aeq lemma3 n (Attributes.parse 
# 278 "plugins/ltac/g_rewrite.mlg"
               rewrite_attributes
# 1281 "plugins/ltac/g_rewrite.ml"
 atts)),
          None))]


# 283 "plugins/ltac/g_rewrite.mlg"
 

let morphism_tactic =
  let open Tacexpr in
  let name = "Corelib.Classes.SetoidTactics.add_morphism_tactic" in
  let tacqid = Libnames.qualid_of_string name in
  let tac = CAst.make @@ TacArg (TacCall (CAst.make (tacqid, []))) in
  Tacinterp.interp tac


# 1297 "plugins/ltac/g_rewrite.ml"

let () = Vernacextend.static_vernac_extend ~plugin:(Some "rocq-runtime.plugins.ltac") ~command:"AddSetoid1" ~classifier:(fun ~atts:_ _ -> Vernacextend.classify_as_sideeff) ?entry:None 
         [(Vernacextend.TyML
         (false,
          Vernacextend.TyTerminal
          ("Add",
           Vernacextend.TyTerminal
           ("Setoid",
            Vernacextend.TyNonTerminal (Extend.TUentry (Genarg.get_arg_tag wit_constr),
            Vernacextend.TyNonTerminal (Extend.TUentry (Genarg.get_arg_tag wit_constr),
            Vernacextend.TyNonTerminal (Extend.TUentry (Genarg.get_arg_tag wit_constr),
            Vernacextend.TyTerminal
            ("as",
             Vernacextend.TyNonTerminal (Extend.TUentry (Genarg.get_arg_tag wit_identref),
             Vernacextend.TyNil))))))),
          (let coqpp_body a aeq t n atts =
            Vernactypes.vtdefault (fun () -> 
# 296 "plugins/ltac/g_rewrite.mlg"
      
         add_setoid atts [] a aeq t n
     
# 1319 "plugins/ltac/g_rewrite.ml"
) in
            fun a aeq t n ?loc ~atts () ->
            coqpp_body a aeq t n (Attributes.parse 
# 295 "plugins/ltac/g_rewrite.mlg"
               rewrite_attributes
# 1325 "plugins/ltac/g_rewrite.ml"
 atts)),
          None));
         (Vernacextend.TyML
         (false,
          Vernacextend.TyTerminal
          ("Add",
           Vernacextend.TyTerminal
           ("Parametric",
            Vernacextend.TyTerminal
            ("Setoid",
             Vernacextend.TyNonTerminal (Extend.TUentry (Genarg.get_arg_tag wit_binders),
             Vernacextend.TyTerminal
             (":",
              Vernacextend.TyNonTerminal (Extend.TUentry (Genarg.get_arg_tag wit_constr),
              Vernacextend.TyNonTerminal (Extend.TUentry (Genarg.get_arg_tag wit_constr),
              Vernacextend.TyNonTerminal (Extend.TUentry (Genarg.get_arg_tag wit_constr),
              Vernacextend.TyTerminal
              ("as",
               Vernacextend.TyNonTerminal (Extend.TUentry (Genarg.get_arg_tag wit_identref),
               Vernacextend.TyNil)))))))))),
          (let coqpp_body binders a aeq t n atts =
            Vernactypes.vtdefault (fun () -> 
# 300 "plugins/ltac/g_rewrite.mlg"
      
         add_setoid atts binders a aeq t n
     
# 1352 "plugins/ltac/g_rewrite.ml"
) in
            fun binders a aeq t n ?loc ~atts () ->
            coqpp_body binders a aeq t n (Attributes.parse 
# 299 "plugins/ltac/g_rewrite.mlg"
               rewrite_attributes
# 1358 "plugins/ltac/g_rewrite.ml"
 atts)),
          None));
         (Vernacextend.TyML
         (false,
          Vernacextend.TyTerminal
          ("Add",
           Vernacextend.TyTerminal
           ("Morphism",
            Vernacextend.TyNonTerminal (Extend.TUentry (Genarg.get_arg_tag wit_constr),
            Vernacextend.TyTerminal
            (":",
             Vernacextend.TyNonTerminal (Extend.TUentry (Genarg.get_arg_tag wit_identref),
             Vernacextend.TyNil))))),
          (let coqpp_body m n atts =
            Vernactypes.vtopenproof (fun () -> (
# 305 "plugins/ltac/g_rewrite.mlg"
         if Lib.is_modtype () then
           CErrors.user_err Pp.(str "Add Morphism cannot be used in a module type. Use Parameter Morphism instead.");
         add_morphism_interactive atts ~tactic:morphism_tactic m n 
# 1378 "plugins/ltac/g_rewrite.ml"
)) in
            fun m n ?loc ~atts () -> coqpp_body m n (Attributes.parse 
# 303 "plugins/ltac/g_rewrite.mlg"
               rewrite_attributes
# 1383 "plugins/ltac/g_rewrite.ml"
 atts)),
          Some (fun m n  ~atts -> 
# 304 "plugins/ltac/g_rewrite.mlg"
         VtStartProof(GuaranteesOpacity, [n.CAst.v]) 
# 1388 "plugins/ltac/g_rewrite.ml"
)));
         (Vernacextend.TyML
         (false,
          Vernacextend.TyTerminal
          ("Declare",
           Vernacextend.TyTerminal
           ("Morphism",
            Vernacextend.TyNonTerminal (Extend.TUentry (Genarg.get_arg_tag wit_constr),
            Vernacextend.TyTerminal
            (":",
             Vernacextend.TyNonTerminal (Extend.TUentry (Genarg.get_arg_tag wit_identref),
             Vernacextend.TyNil))))),
          (let coqpp_body m n atts = Vernactypes.vtdefault (fun () -> 
# 310 "plugins/ltac/g_rewrite.mlg"
         add_morphism_as_parameter atts m n 
# 1404 "plugins/ltac/g_rewrite.ml"
) in
            fun m n ?loc ~atts () -> coqpp_body m n (Attributes.parse 
# 308 "plugins/ltac/g_rewrite.mlg"
               rewrite_attributes
# 1409 "plugins/ltac/g_rewrite.ml"
 atts)),
          Some (fun m n  ~atts -> 
# 309 "plugins/ltac/g_rewrite.mlg"
         VtSideff([n.CAst.v], VtLater) 
# 1414 "plugins/ltac/g_rewrite.ml"
)));
         (Vernacextend.TyML
         (false,
          Vernacextend.TyTerminal
          ("Add",
           Vernacextend.TyTerminal
           ("Morphism",
            Vernacextend.TyNonTerminal (Extend.TUentry (Genarg.get_arg_tag wit_constr),
            Vernacextend.TyTerminal
            ("with",
             Vernacextend.TyTerminal
             ("signature",
              Vernacextend.TyNonTerminal (Extend.TUentry (Genarg.get_arg_tag wit_lconstr),
              Vernacextend.TyTerminal
              ("as",
               Vernacextend.TyNonTerminal (Extend.TUentry (Genarg.get_arg_tag wit_identref),
               Vernacextend.TyNil)))))))),
          (let coqpp_body m s n atts =
            Vernactypes.vtopenproof (fun () -> (
# 313 "plugins/ltac/g_rewrite.mlg"
         add_morphism atts ~tactic:morphism_tactic [] m s n 
# 1436 "plugins/ltac/g_rewrite.ml"
)) in
            fun m s n ?loc ~atts () ->
            coqpp_body m s n (Attributes.parse 
# 311 "plugins/ltac/g_rewrite.mlg"
               rewrite_attributes
# 1442 "plugins/ltac/g_rewrite.ml"
 atts)),
          Some (fun m s n  ~atts -> 
# 312 "plugins/ltac/g_rewrite.mlg"
         VtStartProof(GuaranteesOpacity,[n.CAst.v]) 
# 1447 "plugins/ltac/g_rewrite.ml"
)));
         (Vernacextend.TyML
         (false,
          Vernacextend.TyTerminal
          ("Add",
           Vernacextend.TyTerminal
           ("Parametric",
            Vernacextend.TyTerminal
            ("Morphism",
             Vernacextend.TyNonTerminal (Extend.TUentry (Genarg.get_arg_tag wit_binders),
             Vernacextend.TyTerminal
             (":",
              Vernacextend.TyNonTerminal (Extend.TUentry (Genarg.get_arg_tag wit_constr),
              Vernacextend.TyTerminal
              ("with",
               Vernacextend.TyTerminal
               ("signature",
                Vernacextend.TyNonTerminal (Extend.TUentry (Genarg.get_arg_tag wit_lconstr),
                Vernacextend.TyTerminal
                ("as",
                 Vernacextend.TyNonTerminal (Extend.TUentry (Genarg.get_arg_tag wit_identref),
                 Vernacextend.TyNil))))))))))),
          (let coqpp_body binders m s n atts =
            Vernactypes.vtopenproof (fun () -> (
# 317 "plugins/ltac/g_rewrite.mlg"
         add_morphism atts ~tactic:morphism_tactic binders m s n 
# 1474 "plugins/ltac/g_rewrite.ml"
)) in
            fun binders m s n ?loc ~atts () ->
            coqpp_body binders m s n (Attributes.parse 
# 314 "plugins/ltac/g_rewrite.mlg"
               rewrite_attributes
# 1480 "plugins/ltac/g_rewrite.ml"
 atts)),
          Some (fun binders m s n  ~atts -> 
# 316 "plugins/ltac/g_rewrite.mlg"
         VtStartProof(GuaranteesOpacity,[n.CAst.v]) 
# 1485 "plugins/ltac/g_rewrite.ml"
)))]

let () = Tacentries.tactic_extend "rocq-runtime.plugins.ltac" "setoid_symmetry" ~level:0 
         [(Tacentries.TyML (Tacentries.TyIdent ("setoid_symmetry", Tacentries.TyNil), 
           (fun ist -> 
# 321 "plugins/ltac/g_rewrite.mlg"
                              setoid_symmetry 
# 1493 "plugins/ltac/g_rewrite.ml"
)));
         (Tacentries.TyML (Tacentries.TyIdent ("setoid_symmetry", Tacentries.TyIdent ("in", 
                                                                  Tacentries.TyArg (
                                                                  Extend.TUentry (Genarg.get_arg_tag wit_hyp), 
                                                                  Tacentries.TyNil))), 
          (fun n ist -> 
# 322 "plugins/ltac/g_rewrite.mlg"
                                          setoid_symmetry_in n 
# 1502 "plugins/ltac/g_rewrite.ml"
)))]

let () = Tacentries.tactic_extend "rocq-runtime.plugins.ltac" "setoid_reflexivity" ~level:0 
         [(Tacentries.TyML (Tacentries.TyIdent ("setoid_reflexivity", 
                            Tacentries.TyNil), (fun ist -> 
# 326 "plugins/ltac/g_rewrite.mlg"
                                setoid_reflexivity 
# 1510 "plugins/ltac/g_rewrite.ml"
)))]

let () = Tacentries.tactic_extend "rocq-runtime.plugins.ltac" "setoid_transitivity" ~level:0 
         [(Tacentries.TyML (Tacentries.TyIdent ("setoid_transitivity", 
                            Tacentries.TyArg (Extend.TUentry (Genarg.get_arg_tag wit_constr), 
                            Tacentries.TyNil)), (fun t ist -> 
# 330 "plugins/ltac/g_rewrite.mlg"
                                           setoid_transitivity (Some t) 
# 1519 "plugins/ltac/g_rewrite.ml"
)));
         (Tacentries.TyML (Tacentries.TyIdent ("setoid_etransitivity", 
                           Tacentries.TyNil), (fun ist -> 
# 331 "plugins/ltac/g_rewrite.mlg"
                                  setoid_transitivity None 
# 1525 "plugins/ltac/g_rewrite.ml"
)))]

let () = Vernacextend.static_vernac_extend ~plugin:(Some "rocq-runtime.plugins.ltac") ~command:"PrintRewriteHintDb" ~classifier:(fun ~atts:_ _ -> Vernacextend.classify_as_query) ?entry:None 
         [(Vernacextend.TyML
         (false,
          Vernacextend.TyTerminal
          ("Print",
           Vernacextend.TyTerminal
           ("Rewrite",
            Vernacextend.TyTerminal
            ("HintDb",
             Vernacextend.TyNonTerminal (Extend.TUentry (Genarg.get_arg_tag wit_preident),
             Vernacextend.TyNil)))),
          (let coqpp_body s () = Vernactypes.vtdefault (fun () -> 
# 336 "plugins/ltac/g_rewrite.mlg"
    Feedback.msg_notice (Autorewrite.print_rewrite_hintdb s) 
# 1542 "plugins/ltac/g_rewrite.ml"
) in
            fun s ?loc ~atts () ->
            coqpp_body s (Attributes.unsupported_attributes atts)),
          None))]

