/*
 * Decompiled with CFR 0.152.
 */
package com.pty4j.util;

import java.util.concurrent.Callable;
import kotlin.Pair;
import org.jetbrains.annotations.NotNull;

public final class LazyValue<T> {
    private final Callable<T> myProvider;
    private final Object myLock = new Object();
    private volatile Pair<T, Throwable> myResult;

    public LazyValue(@NotNull Callable<T> provider) {
        this.myProvider = provider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T getValue() throws Exception {
        Pair result = this.myResult;
        if (result != null) {
            return this.unpack(result);
        }
        Object object = this.myLock;
        synchronized (object) {
            result = this.myResult;
            if (result == null) {
                try {
                    T value = this.myProvider.call();
                    result = new Pair(value, null);
                }
                catch (Throwable t) {
                    result = new Pair(null, (Object)t);
                }
                this.myResult = result;
            }
        }
        return this.unpack(result);
    }

    private T unpack(@NotNull Pair<T, Throwable> result) throws Exception {
        if (result.getSecond() != null) {
            if (result.getSecond() instanceof Exception) {
                throw (Exception)result.getSecond();
            }
            if (result.getSecond() instanceof Error) {
                throw (Error)result.getSecond();
            }
            throw new RuntimeException("Rethrowing unknown Throwable", (Throwable)result.getSecond());
        }
        return (T)result.getFirst();
    }
}

