/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.aalto.out;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.namespace.NamespaceContext;

final class NsBinder {
    static final int DEFAULT_ARRAY_SIZE = 32;
    final int _scopeStart;
    String[] _nsStrings;
    int _scopeEnd;

    private NsBinder(int scopeStart, String[] strs) {
        this._scopeStart = this._scopeEnd = scopeStart;
        this._nsStrings = strs;
    }

    public static NsBinder createEmpty() {
        String[] strs = new String[32];
        strs[0] = "xml";
        strs[1] = "http://www.w3.org/XML/1998/namespace";
        strs[2] = "xmlns";
        strs[3] = "http://www.w3.org/2000/xmlns/";
        return new NsBinder(4, strs);
    }

    public NsBinder createChild() {
        return new NsBinder(this._scopeEnd, this._nsStrings);
    }

    public String findUriByPrefix(String prefix) {
        String[] strs = this._nsStrings;
        int phash = prefix.hashCode();
        for (int ix = this._scopeEnd - 2; ix >= 0; ix -= 2) {
            String thisP = strs[ix];
            if (thisP != prefix && (thisP.hashCode() != phash || !thisP.equals(prefix))) continue;
            return strs[ix + 1];
        }
        return null;
    }

    public String findPrefixByUri(String uri) {
        String[] strs = this._nsStrings;
        int uhash = uri.hashCode();
        block0: for (int ix = this._scopeEnd - 1; ix > 0; ix -= 2) {
            String thisU = strs[ix];
            if (thisU != uri && (thisU.hashCode() != uhash || !thisU.equals(uri))) continue;
            String prefix = strs[ix - 1];
            if (ix < this._scopeStart) {
                int phash = prefix.hashCode();
                int end = this._scopeEnd;
                for (int j = ix - 1; j < end; j += 2) {
                    String thisP = strs[ix];
                    if (thisP == prefix || thisP.hashCode() == phash && thisP.equals(prefix)) continue block0;
                }
            }
            return prefix;
        }
        return null;
    }

    public List<String> getPrefixesBoundToUri(String uri, List<String> l) {
        String[] strs = this._nsStrings;
        int uhash = uri.hashCode();
        block0: for (int ix = this._scopeEnd - 1; ix > 0; ix -= 2) {
            String thisU = strs[ix];
            if (thisU != uri && (thisU.hashCode() != uhash || !thisU.equals(uri))) continue;
            String prefix = strs[ix - 1];
            if (ix < this._scopeStart) {
                int phash = prefix.hashCode();
                int end = this._scopeEnd;
                for (int j = ix - 1; j < end; j += 2) {
                    String thisP = strs[ix];
                    if (thisP == prefix || thisP.hashCode() == phash && thisP.equals(prefix)) continue block0;
                }
            }
            if (l == null) {
                l = new ArrayList<String>();
            }
            l.add(prefix);
        }
        return l;
    }

    public int size() {
        return this._scopeEnd >> 1;
    }

    public int localSize() {
        return this._scopeEnd - this._scopeStart >> 1;
    }

    String addMapping(String prefix, String uri) {
        String[] strs = this._nsStrings;
        int phash = prefix.hashCode();
        int end = this._scopeEnd;
        for (int ix = this._scopeStart; ix < end; ix += 2) {
            String thisP = strs[ix];
            if (thisP != prefix && (thisP.hashCode() != phash || !thisP.equals(prefix))) continue;
            String old = strs[ix + 1];
            strs[ix + 1] = uri;
            return old;
        }
        if (this._scopeEnd >= strs.length) {
            this._nsStrings = strs = Arrays.copyOf(strs, strs.length << 1);
        }
        strs[this._scopeEnd++] = prefix;
        strs[this._scopeEnd++] = uri;
        return null;
    }

    String generatePrefix(String prefixBase, NamespaceContext ctxt, int[] seqArr) {
        String prefix;
        String[] strs = this._nsStrings;
        int seqNr = seqArr[0];
        block0: while (true) {
            prefix = (prefixBase + seqNr).intern();
            ++seqNr;
            int phash = prefix.hashCode();
            for (int ix = this._scopeEnd - 2; ix >= 0; ix -= 2) {
                String thisP = strs[ix];
                if (thisP == prefix || thisP.hashCode() == phash && thisP.equals(prefix)) continue block0;
            }
            if (ctxt == null || ctxt.getNamespaceURI(prefix) == null) break;
        }
        seqArr[0] = seqNr;
        return prefix;
    }

    public String toString() {
        return "[" + this.getClass().toString() + "; " + this.size() + " entries; of which " + this.localSize() + " local]";
    }
}

