/*
 * Decompiled with CFR 0.152.
 */
package org.jsmpp.session;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.jsmpp.bean.BindType;
import org.jsmpp.extra.SessionState;
import org.jsmpp.session.Session;
import org.jsmpp.session.SessionContext;
import org.jsmpp.session.SessionStateListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSessionContext
implements SessionContext {
    private static final Logger logger = LoggerFactory.getLogger(AbstractSessionContext.class);
    private long lastActivityTimestamp;
    private List<SessionStateListener> sessionStateListeners = new CopyOnWriteArrayList<SessionStateListener>();

    public AbstractSessionContext() {
    }

    public AbstractSessionContext(SessionStateListener sessionStateListener) {
        this.sessionStateListeners.add(sessionStateListener);
    }

    @Override
    public synchronized void open() {
        this.changeState(SessionState.OPEN);
    }

    @Override
    public synchronized void bound(BindType bindType) {
        if (bindType.equals((Object)BindType.BIND_TX)) {
            this.changeState(SessionState.BOUND_TX);
        } else if (bindType.equals((Object)BindType.BIND_RX)) {
            this.changeState(SessionState.BOUND_RX);
        } else if (bindType.equals((Object)BindType.BIND_TRX)) {
            this.changeState(SessionState.BOUND_TRX);
        } else {
            throw new IllegalArgumentException("Bind type " + (Object)((Object)bindType) + " not supported");
        }
    }

    @Override
    public synchronized void unbound() {
        this.changeState(SessionState.UNBOUND);
    }

    @Override
    public synchronized void close() {
        this.changeState(SessionState.CLOSED);
    }

    public void addSessionStateListener(SessionStateListener listener) {
        this.sessionStateListeners.add(listener);
    }

    public void removeSessionStateListener(SessionStateListener l) {
        this.sessionStateListeners.remove(l);
    }

    protected void fireStateChanged(SessionState newState, SessionState oldState, Session source) {
        for (SessionStateListener l : this.sessionStateListeners) {
            if (newState.equals((Object)oldState)) {
                throw new IllegalStateException("State is already " + (Object)((Object)newState));
            }
            try {
                l.onStateChange(newState, oldState, source);
            }
            catch (Exception e) {
                logger.error("Invalid runtime exception thrown when calling onStateChange for {}", (Object)source, (Object)e);
            }
        }
    }

    @Override
    public void notifyActivity() {
        this.lastActivityTimestamp = System.currentTimeMillis();
    }

    @Override
    public long getLastActivityTimestamp() {
        return this.lastActivityTimestamp;
    }

    protected abstract void changeState(SessionState var1);
}

