/*
 * SPDX-FileCopyrightText: NVIDIA CORPORATION & AFFILIATES
 * Copyright (c) 2004-2025 NVIDIA CORPORATION & AFFILIATES. All rights reserved.
 *
 * This software is available to you under the terms of the
 * OpenIB.org BSD license included below:
 *
 *     Redistribution and use in source and binary forms, with or
 *     without modification, are permitted provided that the following
 *     conditions are met:
 *
 *      - Redistributions of source code must retain the above
 *        copyright notice, this list of conditions and the following
 *        disclaimer.
 *
 *      - Redistributions in binary form must reproduce the above
 *        copyright notice, this list of conditions and the following
 *        disclaimer in the documentation and/or other materials
 *        provided with the distribution.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS
 * BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN
 * ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
 * CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 *
 */

#pragma once

#include <atomic>
#include <memory>
#include <mutex>
#include <queue>

#include "agg_types.h"
#include "ibis.h"
#include "traps_handler.h"

class CommandManager;

class TrapsQueue
{
    CommandManager* m_command_manager_ptr;

    std::queue<std::unique_ptr<TrapHandler>> m_handlers_;
    std::mutex m_queue_lock_;

    std::vector<bool> m_agg_node_lids_;
    std::mutex m_agg_node_lids_lock_;
    std::atomic_bool m_should_stop_;

   public:
    TrapsQueue(CommandManager* command_manager_ptr);
    ~TrapsQueue();

    void Register();
    void AddTrap(SharpTrapNumberEnum trap_number,
                 void* p_data,
                 ib_address_t* p_ib_address,
                 MAD_AggregationManagement* p_am_mad,
                 Notice* p_notice);
    bool IsAggNode(uint16_t lid);
    void HandleAggNodeUpdateArray(const PortInfo& port_info, bool val);
    void HandleTraps();

   private:
    void AddTrap(std::unique_ptr<TrapHandler> p_trap_handler);
    std::unique_ptr<TrapHandler> GetTrap();   // returns nullptr if empty
    std::size_t GetTrapsQueueSize();
};
