/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment.dev;

import io.quarkus.maven.dependency.ArtifactCoordsPattern;
import io.quarkus.maven.dependency.ArtifactKey;
import java.util.ArrayList;
import java.util.List;

public class ExtensionDevModeJvmOptionFilter {
    private boolean disableAll;
    private List<String> disableFor = List.of();
    private List<ArtifactCoordsPattern> disableForPatterns;

    public boolean isDisableAll() {
        return this.disableAll;
    }

    public void setDisableAll(boolean disableAll) {
        this.disableAll = disableAll;
        this.resetPatterns();
    }

    public List<String> getDisableFor() {
        return this.disableFor;
    }

    public void setDisableFor(List<String> disableFor) {
        this.disableFor = disableFor;
        this.resetPatterns();
    }

    private void resetPatterns() {
        this.disableForPatterns = null;
    }

    List<ArtifactCoordsPattern> getDisableForPatterns() {
        if (this.disableFor.isEmpty()) {
            return List.of();
        }
        if (this.disableForPatterns == null) {
            ArrayList<ArtifactCoordsPattern> result = new ArrayList<ArtifactCoordsPattern>(this.disableFor.size());
            for (String s : this.disableFor) {
                result.add(ArtifactCoordsPattern.of((String)s));
            }
            this.disableForPatterns = result;
        }
        return this.disableForPatterns;
    }

    boolean isDisabled(ArtifactKey extensionKey) {
        for (ArtifactCoordsPattern pattern : this.getDisableForPatterns()) {
            if (!pattern.matches(extensionKey.getGroupId(), extensionKey.getArtifactId(), extensionKey.getClassifier(), "jar", null)) continue;
            return true;
        }
        return false;
    }
}

