/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.data.attestation.statement;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.webauthn4j.util.ArrayUtil;
import java.util.Arrays;
import org.jetbrains.annotations.Nullable;

public class Response {
    @JsonProperty
    private final String nonce;
    @JsonProperty
    private final Long timestampMs;
    @JsonProperty
    private final String apkPackageName;
    @JsonProperty
    private final String[] apkCertificateDigestSha256;
    @JsonProperty
    private final String apkDigestSha256;
    @JsonProperty
    private final Boolean ctsProfileMatch;
    @JsonProperty
    private final Boolean basicIntegrity;
    @JsonProperty
    private final String advice;
    @JsonProperty
    private final String error;

    @JsonCreator
    public Response(@JsonProperty(value="nonce") @Nullable String nonce, @JsonProperty(value="timestampMs") @Nullable Long timestampMs, @JsonProperty(value="apkPackageName") @Nullable String apkPackageName, @JsonProperty(value="apkCertificateDigestSha256") @Nullable String[] apkCertificateDigestSha256, @JsonProperty(value="apkDigestSha256") @Nullable String apkDigestSha256, @JsonProperty(value="ctsProfileMatch") @Nullable Boolean ctsProfileMatch, @JsonProperty(value="basicIntegrity") @Nullable Boolean basicIntegrity, @JsonProperty(value="advice") @Nullable String advice, @JsonProperty(value="error") @Nullable String error) {
        this.nonce = nonce;
        this.timestampMs = timestampMs;
        this.apkPackageName = apkPackageName;
        this.apkCertificateDigestSha256 = apkCertificateDigestSha256;
        this.apkDigestSha256 = apkDigestSha256;
        this.ctsProfileMatch = ctsProfileMatch;
        this.basicIntegrity = basicIntegrity;
        this.advice = advice;
        this.error = error;
    }

    public Response(@JsonProperty(value="nonce") @Nullable String nonce, @JsonProperty(value="timestampMs") @Nullable Long timestampMs, @JsonProperty(value="apkPackageName") @Nullable String apkPackageName, @JsonProperty(value="apkCertificateDigestSha256") @Nullable String[] apkCertificateDigestSha256, @JsonProperty(value="apkDigestSha256") @Nullable String apkDigestSha256, @JsonProperty(value="ctsProfileMatch") @Nullable Boolean ctsProfileMatch, @JsonProperty(value="basicIntegrity") @Nullable Boolean basicIntegrity, @JsonProperty(value="advice") @Nullable String advice) {
        this(nonce, timestampMs, apkPackageName, apkCertificateDigestSha256, apkDigestSha256, ctsProfileMatch, basicIntegrity, advice, null);
    }

    @Nullable
    public String getNonce() {
        return this.nonce;
    }

    @Nullable
    public Long getTimestampMs() {
        return this.timestampMs;
    }

    @Nullable
    public String getApkPackageName() {
        return this.apkPackageName;
    }

    @Nullable
    public String[] getApkCertificateDigestSha256() {
        return ArrayUtil.clone(this.apkCertificateDigestSha256);
    }

    @Nullable
    public String getApkDigestSha256() {
        return this.apkDigestSha256;
    }

    @Nullable
    public Boolean getCtsProfileMatch() {
        return this.ctsProfileMatch;
    }

    @Nullable
    public Boolean getBasicIntegrity() {
        return this.basicIntegrity;
    }

    @Nullable
    public String getAdvice() {
        return this.advice;
    }

    @Nullable
    public String getError() {
        return this.error;
    }

    public String toString() {
        return "Response(nonce=" + this.nonce + ", timestampMs=" + this.timestampMs + ", apkPackageName=" + this.apkPackageName + ", apkCertificateDigestSha256=" + Arrays.toString(this.apkCertificateDigestSha256) + ", apkDigestSha256=" + this.apkDigestSha256 + ", ctsProfileMatch=" + this.ctsProfileMatch + ", basicIntegrity=" + this.basicIntegrity + ", advice=" + this.advice + ", error=" + this.error + ")";
    }
}

