/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.io.vavr.collection;

import java.util.NoSuchElementException;
import org.jetbrains.kotlin.io.vavr.Tuple;
import org.jetbrains.kotlin.io.vavr.Tuple2;
import org.jetbrains.kotlin.io.vavr.collection.Collections;
import org.jetbrains.kotlin.io.vavr.collection.Traversable;

abstract class AbstractQueue<T, Q extends AbstractQueue<T, Q>>
implements Traversable<T> {
    AbstractQueue() {
    }

    public Tuple2<T, Q> dequeue() {
        if (this.isEmpty()) {
            throw new NoSuchElementException("dequeue of empty " + this.getClass().getSimpleName());
        }
        return Tuple.of(this.head(), this.tail());
    }

    public abstract Q tail();

    public Q retainAll(Iterable<? extends T> elements) {
        return (Q)Collections.retainAll(this, elements);
    }

    public Q removeAll(Iterable<? extends T> elements) {
        return (Q)Collections.removeAll(this, elements);
    }

    @Override
    public String toString() {
        return this.mkString(this.stringPrefix() + "(", ", ", ")");
    }
}

