/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.catalog;

import java.io.IOException;
import java.io.Writer;
import org.gradle.api.initialization.ProjectDescriptor;
import org.gradle.api.internal.catalog.AbstractProjectAccessorsSourceGenerator;
import org.gradle.internal.UncheckedException;

public class ProjectAccessorsSourceGenerator
extends AbstractProjectAccessorsSourceGenerator {
    public ProjectAccessorsSourceGenerator(Writer writer) {
        super(writer);
    }

    public static String generateSource(Writer writer, ProjectDescriptor current, String packageName) {
        ProjectAccessorsSourceGenerator generator = new ProjectAccessorsSourceGenerator(writer);
        try {
            String className = ProjectAccessorsSourceGenerator.toClassName(current.getPath(), ProjectAccessorsSourceGenerator.rootProjectName(current));
            generator.generate(packageName, className, current);
            return className;
        }
        catch (IOException e) {
            throw UncheckedException.throwAsUncheckedException((Throwable)e);
        }
    }

    private void generate(String packageName, String className, ProjectDescriptor current) throws IOException {
        this.writeHeader(packageName);
        this.writeLn("@NullMarked");
        this.writeLn("public class " + className + " extends DelegatingProjectDependency {");
        this.writeLn();
        this.writeLn("    @Inject");
        this.writeLn("    public " + className + "(TypeSafeProjectDependencyFactory factory, ProjectDependencyInternal delegate) {");
        this.writeLn("        super(factory, delegate);");
        this.writeLn("    }");
        this.writeLn();
        this.processChildren(current);
        this.writeLn("}");
    }
}

