/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.launcher.daemon.server;

import java.util.List;
import org.gradle.api.internal.specs.ExplainingSpec;
import org.gradle.launcher.daemon.context.DaemonCompatibilitySpec;
import org.gradle.launcher.daemon.context.DaemonContext;
import org.gradle.launcher.daemon.server.Daemon;
import org.gradle.launcher.daemon.server.expiry.DaemonExpirationResult;
import org.gradle.launcher.daemon.server.expiry.DaemonExpirationStatus;
import org.gradle.launcher.daemon.server.expiry.DaemonExpirationStrategy;
import org.gradle.util.internal.CollectionUtils;

public class CompatibleDaemonExpirationStrategy
implements DaemonExpirationStrategy {
    private final Daemon daemon;
    private final ExplainingSpec<DaemonContext> compatibilitySpec;
    public static final String EXPIRATION_REASON = "other compatible daemons were started";

    CompatibleDaemonExpirationStrategy(Daemon daemon, ExplainingSpec<DaemonContext> compatibilitySpec) {
        this.daemon = daemon;
        this.compatibilitySpec = compatibilitySpec;
    }

    CompatibleDaemonExpirationStrategy(Daemon daemon) {
        this(daemon, (ExplainingSpec<DaemonContext>)new DaemonCompatibilitySpec(daemon.getDaemonContext().toRequest()));
    }

    @Override
    public DaemonExpirationResult checkExpiration() {
        List compatibleIdleDaemons = CollectionUtils.filter((List)this.daemon.getDaemonRegistry().getIdle(), daemonInfo -> this.compatibilitySpec.isSatisfiedBy((Object)daemonInfo.getContext()));
        if (compatibleIdleDaemons.size() > 1) {
            return new DaemonExpirationResult(DaemonExpirationStatus.GRACEFUL_EXPIRE, EXPIRATION_REASON);
        }
        return DaemonExpirationResult.NOT_TRIGGERED;
    }
}

