/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.main.application;

import java.awt.Component;
import java.awt.KeyboardFocusManager;
import java.awt.LayoutManager;
import java.awt.LayoutManager2;
import java.awt.event.KeyEvent;
import javax.swing.JComponent;
import javax.swing.JSplitPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import org.freeplane.core.resources.IFreeplanePropertyListener;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.ui.ViewController;
import org.freeplane.main.application.AuxiliarySplitPaneController;
import org.freeplane.main.application.AuxiliarySplitPanes;
import org.freeplane.main.application.SplitPaneLayoutManager2Decorator;
import org.freeplane.main.application.SplitPaneLayoutManagerDecorator;

public class AuxillaryEditorSplitPane
extends JSplitPane
implements IFreeplanePropertyListener {
    private static final long serialVersionUID = 1L;
    private JComponent auxillaryComponent;
    private Component mainComponent;
    private boolean dividerLocationIsRestored;
    private final AuxiliarySplitPaneController controller;
    private String currentLocation;
    private AuxiliarySplitPanes manager;
    private String mode;
    private String auxVisibilityBaseKey;
    private boolean auxVisibilityBound;

    public AuxillaryEditorSplitPane(Component mainComponent, AuxiliarySplitPaneController controller) {
        this.controller = controller;
        this.mainComponent = mainComponent;
        this.currentLocation = controller.getLocation();
        if ("top".equals(this.currentLocation) || "left".equals(this.currentLocation)) {
            this.setLeftComponent(null);
            this.setRightComponent(mainComponent);
        } else {
            this.setLeftComponent(mainComponent);
            this.setRightComponent(null);
        }
        this.dividerLocationIsRestored = false;
        this.setResizeWeight(0.5);
        this.setContinuousLayout(true);
        this.setOneTouchExpandable(false);
    }

    @Override
    protected boolean processKeyBinding(KeyStroke ks, KeyEvent e, int condition, boolean pressed) {
        return false;
    }

    @Override
    public void setLayout(LayoutManager layout) {
        if (layout == null || layout instanceof SplitPaneLayoutManagerDecorator) {
            super.setLayout(layout);
        } else if (layout instanceof LayoutManager2) {
            super.setLayout(new SplitPaneLayoutManager2Decorator((LayoutManager2)layout));
        } else {
            super.setLayout(new SplitPaneLayoutManagerDecorator(layout));
        }
    }

    void insertComponentIntoSplitPane(JComponent pAuxillaryComponent, String mode) {
        this.mode = mode;
        this.insertComponentIntoSplitPane(pAuxillaryComponent);
    }

    private void insertComponentIntoSplitPane(JComponent pAuxillaryComponent) {
        Component focusOwner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        this.currentLocation = this.controller.getLocation();
        if ("right".equals(this.currentLocation) || "left".equals(this.currentLocation)) {
            if (this.getOrientation() != 1) {
                this.setOrientation(1);
                this.dividerLocationIsRestored = false;
            }
        } else if (this.getOrientation() != 0) {
            this.setOrientation(0);
            this.dividerLocationIsRestored = false;
        }
        if ("top".equals(this.currentLocation) || "left".equals(this.currentLocation)) {
            if (this.getRightComponent() != this.mainComponent) {
                this.repositionComponent(this.mainComponent, "right");
            }
            if (this.getLeftComponent() != pAuxillaryComponent) {
                if (this.auxillaryComponent == pAuxillaryComponent) {
                    this.repositionComponent(this.auxillaryComponent, "left");
                } else {
                    this.auxillaryComponent = pAuxillaryComponent;
                    this.setLeftComponent(pAuxillaryComponent);
                }
            }
        } else {
            if (this.getLeftComponent() != this.mainComponent) {
                this.repositionComponent(this.mainComponent, "left");
                this.dividerLocationIsRestored = false;
            }
            if (this.getRightComponent() != pAuxillaryComponent) {
                if (this.auxillaryComponent == pAuxillaryComponent) {
                    this.repositionComponent(this.auxillaryComponent, "right");
                } else {
                    this.auxillaryComponent = pAuxillaryComponent;
                    this.setRightComponent(pAuxillaryComponent);
                }
                this.dividerLocationIsRestored = false;
            }
        }
        if (focusOwner != null && SwingUtilities.isDescendingFrom(focusOwner, this)) {
            focusOwner.requestFocusInWindow();
        }
        this.revalidate();
        this.repaint();
        this.applyAuxVisibility();
    }

    private void repositionComponent(Component component, String constraints) {
        LayoutManager layoutMgr;
        if ("right".equals(constraints)) {
            this.rightComponent = component;
            if (this.leftComponent == component) {
                this.leftComponent = null;
            }
        } else {
            this.leftComponent = component;
            if (this.rightComponent == component) {
                this.rightComponent = null;
            }
        }
        if ((layoutMgr = this.getLayout()) != null) {
            layoutMgr.removeLayoutComponent(component);
            if (layoutMgr instanceof LayoutManager2) {
                ((LayoutManager2)layoutMgr).addLayoutComponent(component, constraints);
            } else {
                layoutMgr.addLayoutComponent(constraints, component);
            }
        }
    }

    @Override
    protected void validateTree() {
        boolean dividerLocationWasRestored = this.dividerLocationIsRestored;
        int dividerLocation = this.getDividerLocation();
        this.dividerLocationIsRestored = false;
        super.validateTree();
        this.dividerLocationIsRestored = dividerLocationWasRestored && dividerLocation == this.getDividerLocation();
        this.restoreDividerLocation();
    }

    private void restoreDividerLocation() {
        if (this.dividerLocationIsRestored || this.auxillaryComponent == null) {
            return;
        }
        double lastSplitPanePosition = Double.NaN;
        lastSplitPanePosition = "left".equals(this.currentLocation) || "top".equals(this.currentLocation) ? 1.0 - this.controller.getPosition(Double.NaN) : this.controller.getPosition(Double.NaN);
        if (Double.isNaN(lastSplitPanePosition)) {
            this.setDividerLocation(0.5);
        } else if (this.getProportionalDividerLocation() != lastSplitPanePosition) {
            this.setDividerLocation(lastSplitPanePosition);
        }
        this.dividerLocationIsRestored = true;
        this.invalidate();
        super.validateTree();
    }

    @Override
    public void setDividerLocation(int location) {
        super.setDividerLocation(location);
        if (this.dividerLocationIsRestored) {
            this.saveSplitPanePosition();
        }
    }

    private void saveSplitPanePosition() {
        double proportionalLocation = this.getProportionalDividerLocation();
        if ("left".equals(this.currentLocation) || "top".equals(this.currentLocation)) {
            this.controller.setPosition(1.0 - proportionalLocation);
        } else {
            this.controller.setPosition(proportionalLocation);
        }
    }

    public double getProportionalDividerLocation() {
        if (this.getOrientation() == 0) {
            int height = this.getHeight() - this.getDividerSize();
            return height > 0 ? (double)this.getDividerLocation() / (double)height : 0.0;
        }
        int width = this.getWidth() - this.getDividerSize();
        return width > 0 ? (double)this.getDividerLocation() / (double)width : 0.0;
    }

    public void changeAuxComponentSide(String location) {
        if (location == null || location.equals(this.currentLocation)) {
            return;
        }
        this.controller.setLocation(location);
        if (this.getLeftComponent() != null && this.getRightComponent() != null) {
            this.insertComponentIntoSplitPane(this.auxillaryComponent);
        }
    }

    public JComponent getAuxiliaryComponent() {
        return this.auxillaryComponent;
    }

    void setManager(AuxiliarySplitPanes manager) {
        this.manager = manager;
    }

    public AuxiliarySplitPanes getManager() {
        return this.manager;
    }

    @Override
    public void remove(Component component) {
        if (component == this.auxillaryComponent) {
            this.removeAuxiliaryComponent();
        } else {
            super.remove(component);
        }
    }

    void removeAuxiliaryComponent() {
        if (this.auxillaryComponent != null) {
            super.remove(this.auxillaryComponent);
            this.auxillaryComponent = null;
            this.dividerLocationIsRestored = false;
            if (this.getLeftComponent() != this.mainComponent) {
                this.repositionComponent(this.mainComponent, "left");
                this.setRightComponent(null);
            }
        }
    }

    public void moveAuxillaryComponentTo(AuxillaryEditorSplitPane toSplitPane, String targetMode) {
        if (this.auxillaryComponent != null) {
            boolean isModeSame = targetMode.equals(this.mode);
            if (isModeSame) {
                toSplitPane.insertComponentIntoSplitPane(this.auxillaryComponent, this.mode);
            } else {
                this.removeAuxiliaryComponent();
            }
        }
    }

    public void bindAuxiliaryVisibilityToProperty(String baseKey) {
        this.auxVisibilityBaseKey = baseKey;
    }

    private void applyAuxVisibility() {
        if (this.auxVisibilityBaseKey == null) {
            return;
        }
        boolean fs = false;
        try {
            ViewController vc = Controller.getCurrentController().getViewController();
            fs = vc != null && vc.isFullScreenEnabled();
        }
        catch (Exception vc) {
            // empty catch block
        }
        String key = this.auxVisibilityBaseKey + (fs ? ".fullscreen" : "");
        boolean visible = ResourceController.getResourceController().getBooleanProperty(key);
        if (this.auxillaryComponent != null) {
            this.auxillaryComponent.setVisible(visible);
            this.revalidate();
            this.repaint();
        }
    }

    public void propertyChanged(String propertyName, String newValue, String oldValue) {
        if (this.auxVisibilityBaseKey == null) {
            return;
        }
        if (propertyName.equals(this.auxVisibilityBaseKey) || propertyName.equals(this.auxVisibilityBaseKey + ".fullscreen") || "fullscreen_enabled".equals(propertyName)) {
            this.applyAuxVisibility();
        }
    }

    @Override
    public void addNotify() {
        super.addNotify();
        if (this.auxVisibilityBaseKey != null && !this.auxVisibilityBound) {
            ResourceController.getResourceController().addPropertyChangeListener((IFreeplanePropertyListener)this);
            this.auxVisibilityBound = true;
        }
        this.applyAuxVisibility();
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        if (this.auxVisibilityBaseKey != null && this.auxVisibilityBound) {
            ResourceController.getResourceController().removePropertyChangeListener((IFreeplanePropertyListener)this);
            this.auxVisibilityBound = false;
        }
    }

    @Override
    public void setBounds(int x, int y, int width, int height) {
        this.dividerLocationIsRestored = false;
        super.setBounds(x, y, width, height);
    }
}

