/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.oracle.model;

import java.sql.Connection;
import java.sql.SQLException;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.oracle.model.OracleDataSource;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.access.DBAUserPasswordManager;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.impl.DBObjectNameCaseTransformer;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.utils.CommonUtils;

public class OracleChangeUserPasswordManager
implements DBAUserPasswordManager {
    private OracleDataSource dataSource;

    OracleChangeUserPasswordManager(OracleDataSource dataSource) {
        this.dataSource = dataSource;
    }

    public void changeUserPassword(@NotNull DBRProgressMonitor monitor, @NotNull String userName, @NotNull String newPassword, @NotNull String oldPassword) throws DBException {
        try (JDBCSession session = (JDBCSession)DBUtils.openMetaSession((DBRProgressMonitor)monitor, (DBPDataSource)this.dataSource, (String)"Change user password");){
            session.enableLogging(false);
            String transformedUserName = DBObjectNameCaseTransformer.transformName((DBPDataSource)this.dataSource, (String)userName);
            JDBCUtils.executeSQL((Connection)session, (String)("ALTER USER " + DBUtils.getQuotedIdentifier((DBPDataSource)this.dataSource, (String)(transformedUserName != null ? transformedUserName : userName)) + " IDENTIFIED BY " + DBUtils.getQuotedIdentifier((DBPDataSource)this.dataSource, (String)CommonUtils.notEmpty((String)newPassword)) + " REPLACE " + DBUtils.getQuotedIdentifier((DBPDataSource)this.dataSource, (String)CommonUtils.notEmpty((String)oldPassword))), (Object[])new Object[0]);
        }
        catch (SQLException e) {
            throw new DBCException("Error changing user password", (Throwable)e);
        }
    }
}

