/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.authenticator;

import java.io.Serializable;
import org.apache.catalina.Context;
import org.apache.catalina.Session;

public class SingleSignOnSessionKey
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String sessionId;
    private final String contextName;
    private final String hostName;

    public SingleSignOnSessionKey(Session session) {
        this.sessionId = session.getId();
        Context context = session.getManager().getContext();
        this.contextName = context.getName();
        this.hostName = context.getParent().getName();
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public String getContextName() {
        return this.contextName;
    }

    public String getHostName() {
        return this.hostName;
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.sessionId == null ? 0 : this.sessionId.hashCode());
        n = 31 * n + (this.contextName == null ? 0 : this.contextName.hashCode());
        n = 31 * n + (this.hostName == null ? 0 : this.hostName.hashCode());
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        SingleSignOnSessionKey singleSignOnSessionKey = (SingleSignOnSessionKey)object;
        if (this.sessionId == null ? singleSignOnSessionKey.sessionId != null : !this.sessionId.equals(singleSignOnSessionKey.sessionId)) {
            return false;
        }
        if (this.contextName == null ? singleSignOnSessionKey.contextName != null : !this.contextName.equals(singleSignOnSessionKey.contextName)) {
            return false;
        }
        if (this.hostName == null) {
            return singleSignOnSessionKey.hostName == null;
        }
        return this.hostName.equals(singleSignOnSessionKey.hostName);
    }

    public String toString() {
        return "Host: [" + this.hostName + "], Context: [" + this.contextName + "], SessionID: [" + this.sessionId + "]";
    }
}

