/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.util;

import org.bouncycastle.crypto.EntropySource;
import org.bouncycastle.crypto.fips.FipsEntropyConfig;

public class EntropyUtil {
    public static byte[] generateSeed(EntropySource entropySource, int n) {
        byte[] byArray = new byte[n];
        if (n * 8 <= entropySource.entropySize()) {
            byte[] byArray2 = entropySource.getEntropy();
            System.arraycopy(byArray2, 0, byArray, 0, byArray.length);
        } else {
            int n2 = entropySource.entropySize() / 8;
            for (int i = 0; i < byArray.length; i += n2) {
                byte[] byArray3 = entropySource.getEntropy();
                if (byArray3.length <= byArray.length - i) {
                    System.arraycopy(byArray3, 0, byArray, i, byArray3.length);
                    continue;
                }
                System.arraycopy(byArray3, 0, byArray, i, byArray.length - i);
            }
        }
        return byArray;
    }

    public static String isNotStuck(byte by, byte[] byArray) {
        int n = FipsEntropyConfig.getStuckC();
        if (byArray.length < n) {
            throw new IllegalArgumentException("alpha value too large for entropy size");
        }
        int n2 = 1;
        byte by2 = by;
        for (int i = 0; i != byArray.length; ++i) {
            byte by3 = byArray[i];
            if (by3 == by2) {
                if (++n2 < n) continue;
                return "entropy source stuck";
            }
            by2 = by3;
            n2 = 1;
        }
        return null;
    }

    public static String isProportionate(WindowStats windowStats, byte[] byArray) {
        try {
            for (int i = 0; i < byArray.length; ++i) {
                windowStats.check(byArray[i]);
            }
            return null;
        }
        catch (IllegalStateException illegalStateException) {
            return illegalStateException.getMessage();
        }
    }

    public static WindowStats createStats() {
        return new WindowStats(FipsEntropyConfig.getAdaptiveProportionateC(), FipsEntropyConfig.getAdaptiveProportionateW());
    }

    public static class WindowStats {
        private final int W;
        private final int adptC;
        byte a;
        int i;
        int b;

        WindowStats(int n, int n2) {
            this.adptC = n;
            this.W = n2;
            this.i = n2;
        }

        void incB() {
            ++this.b;
            if (this.b >= this.adptC) {
                throw new IllegalStateException("proportionate test failed");
            }
        }

        void check(byte by) {
            if (this.i > this.W - 1) {
                this.reset(by);
            } else if (this.a == by) {
                this.incB();
            }
            ++this.i;
        }

        void reset(byte by) {
            this.b = 1;
            this.i = 0;
            this.a = by;
        }
    }
}

