/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.action.models;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.OpenSearchStatusException;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionType;
import org.opensearch.action.DocWriteResponse;
import org.opensearch.action.FailedNodeException;
import org.opensearch.action.get.GetResponse;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.HandledTransportAction;
import org.opensearch.action.update.UpdateRequest;
import org.opensearch.action.update.UpdateResponse;
import org.opensearch.cluster.node.DiscoveryNode;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.inject.Inject;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.util.concurrent.ThreadContext;
import org.opensearch.commons.authuser.User;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.common.Strings;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentObject;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.ml.common.FunctionName;
import org.opensearch.ml.common.MLModel;
import org.opensearch.ml.common.connector.Connector;
import org.opensearch.ml.common.controller.MLRateLimiter;
import org.opensearch.ml.common.model.MLModelState;
import org.opensearch.ml.common.settings.MLCommonsSettings;
import org.opensearch.ml.common.settings.MLFeatureEnabledSetting;
import org.opensearch.ml.common.transport.model.MLUpdateModelInput;
import org.opensearch.ml.common.transport.model.MLUpdateModelRequest;
import org.opensearch.ml.common.transport.update_cache.MLUpdateModelCacheAction;
import org.opensearch.ml.common.transport.update_cache.MLUpdateModelCacheNodesRequest;
import org.opensearch.ml.common.transport.update_cache.MLUpdateModelCacheNodesResponse;
import org.opensearch.ml.engine.MLEngine;
import org.opensearch.ml.helper.ConnectorAccessControlHelper;
import org.opensearch.ml.helper.ModelAccessControlHelper;
import org.opensearch.ml.model.MLModelGroupManager;
import org.opensearch.ml.model.MLModelManager;
import org.opensearch.ml.utils.RestActionUtils;
import org.opensearch.ml.utils.TenantAwareHelper;
import org.opensearch.remote.metadata.client.SdkClient;
import org.opensearch.remote.metadata.client.UpdateDataObjectRequest;
import org.opensearch.remote.metadata.common.SdkClientUtils;
import org.opensearch.tasks.Task;
import org.opensearch.transport.TransportService;
import org.opensearch.transport.client.Client;

public class UpdateModelTransportAction
extends HandledTransportAction<ActionRequest, UpdateResponse> {
    @Generated
    private static final Logger log = LogManager.getLogger(UpdateModelTransportAction.class);
    private final Client client;
    private final SdkClient sdkClient;
    private final Settings settings;
    private final ClusterService clusterService;
    private final ModelAccessControlHelper modelAccessControlHelper;
    private final ConnectorAccessControlHelper connectorAccessControlHelper;
    private final MLFeatureEnabledSetting mlFeatureEnabledSetting;
    private final MLModelManager mlModelManager;
    private final MLModelGroupManager mlModelGroupManager;
    private final MLEngine mlEngine;
    private volatile List<String> trustedConnectorEndpointsRegex;

    @Inject
    public UpdateModelTransportAction(TransportService transportService, ActionFilters actionFilters, Client client, SdkClient sdkClient, ConnectorAccessControlHelper connectorAccessControlHelper, ModelAccessControlHelper modelAccessControlHelper, MLModelManager mlModelManager, MLModelGroupManager mlModelGroupManager, Settings settings, ClusterService clusterService, MLEngine mlEngine, MLFeatureEnabledSetting mlFeatureEnabledSetting) {
        super("cluster:admin/opensearch/ml/models/update", transportService, actionFilters, MLUpdateModelRequest::new);
        this.client = client;
        this.sdkClient = sdkClient;
        this.modelAccessControlHelper = modelAccessControlHelper;
        this.connectorAccessControlHelper = connectorAccessControlHelper;
        this.mlModelManager = mlModelManager;
        this.mlModelGroupManager = mlModelGroupManager;
        this.clusterService = clusterService;
        this.mlEngine = mlEngine;
        this.settings = settings;
        this.mlFeatureEnabledSetting = mlFeatureEnabledSetting;
        this.trustedConnectorEndpointsRegex = (List)MLCommonsSettings.ML_COMMONS_TRUSTED_CONNECTOR_ENDPOINTS_REGEX.get(settings);
        clusterService.getClusterSettings().addSettingsUpdateConsumer(MLCommonsSettings.ML_COMMONS_TRUSTED_CONNECTOR_ENDPOINTS_REGEX, it -> {
            this.trustedConnectorEndpointsRegex = it;
        });
    }

    protected void doExecute(Task task, ActionRequest request, ActionListener<UpdateResponse> actionListener) {
        MLUpdateModelRequest updateModelRequest = MLUpdateModelRequest.fromActionRequest((ActionRequest)request);
        MLUpdateModelInput updateModelInput = updateModelRequest.getUpdateModelInput();
        String modelId = updateModelInput.getModelId();
        String tenantId = updateModelInput.getTenantId();
        if (!TenantAwareHelper.validateTenantId(this.mlFeatureEnabledSetting, tenantId, actionListener)) {
            return;
        }
        User user = RestActionUtils.getUserContext(this.client);
        boolean isSuperAdmin = this.isSuperAdminUserWrapper(this.clusterService, this.client);
        String[] excludes = new String[]{"model_content", "content"};
        try (ThreadContext.StoredContext context = this.client.threadPool().getThreadContext().stashContext();){
            ActionListener wrappedListener = ActionListener.runBefore(actionListener, () -> ((ThreadContext.StoredContext)context).restore());
            this.mlModelManager.getModel(modelId, tenantId, null, excludes, (ActionListener<MLModel>)ActionListener.wrap(mlModel -> {
                if (TenantAwareHelper.validateTenantResource(this.mlFeatureEnabledSetting, tenantId, mlModel.getTenantId(), actionListener)) {
                    if (!this.isModelDeploying(mlModel.getModelState()).booleanValue()) {
                        FunctionName functionName = mlModel.getAlgorithm();
                        if (functionName == FunctionName.TEXT_EMBEDDING || functionName == FunctionName.REMOTE) {
                            if (mlModel.getIsHidden() != null && mlModel.getIsHidden().booleanValue()) {
                                if (isSuperAdmin) {
                                    this.updateRemoteOrTextEmbeddingModel(modelId, tenantId, updateModelInput, (MLModel)mlModel, user, (ActionListener<UpdateResponse>)wrappedListener);
                                } else {
                                    wrappedListener.onFailure((Exception)new OpenSearchStatusException("User doesn't have privilege to perform this operation on this model", RestStatus.FORBIDDEN, new Object[0]));
                                }
                            } else {
                                this.modelAccessControlHelper.validateModelGroupAccess(user, this.mlFeatureEnabledSetting, tenantId, mlModel.getModelGroupId(), this.client, this.sdkClient, (ActionListener<Boolean>)ActionListener.wrap(hasPermission -> {
                                    if (hasPermission.booleanValue()) {
                                        this.updateRemoteOrTextEmbeddingModel(modelId, tenantId, updateModelInput, (MLModel)mlModel, user, (ActionListener<UpdateResponse>)wrappedListener);
                                    } else {
                                        wrappedListener.onFailure((Exception)new OpenSearchStatusException("User doesn't have privilege to perform this operation on this model, model ID " + modelId, RestStatus.FORBIDDEN, new Object[0]));
                                    }
                                }, exception -> {
                                    log.error("Permission denied: Unable to update the model with ID {}. Details: {}", (Object)modelId, exception);
                                    wrappedListener.onFailure(exception);
                                }));
                            }
                        } else {
                            wrappedListener.onFailure((Exception)new OpenSearchStatusException("The function category " + functionName.toString() + " is not supported at this time.", RestStatus.FORBIDDEN, new Object[0]));
                        }
                    } else {
                        wrappedListener.onFailure((Exception)new OpenSearchStatusException("Model is deploying. Please wait for the model to complete deployment. model ID " + modelId, RestStatus.CONFLICT, new Object[0]));
                    }
                }
            }, e -> wrappedListener.onFailure((Exception)new OpenSearchStatusException("Failed to find model to update with the provided model id: " + modelId, RestStatus.NOT_FOUND, new Object[0]))));
        }
        catch (Exception e2) {
            log.error("Failed to update ML model for {}", (Object)modelId, (Object)e2);
            actionListener.onFailure(e2);
        }
    }

    private void updateRemoteOrTextEmbeddingModel(String modelId, String tenantId, MLUpdateModelInput updateModelInput, MLModel mlModel, User user, ActionListener<UpdateResponse> wrappedListener) throws IOException {
        boolean isUpdateModelCache;
        boolean isPredictorUpdate;
        String newModelGroupId = Strings.hasLength((String)updateModelInput.getModelGroupId()) && !Objects.equals(updateModelInput.getModelGroupId(), mlModel.getModelGroupId()) ? updateModelInput.getModelGroupId() : null;
        String newConnectorId = Strings.hasLength((String)updateModelInput.getConnectorId()) ? updateModelInput.getConnectorId() : null;
        boolean isModelDeployed = this.isModelDeployed(mlModel.getModelState());
        boolean bl = isPredictorUpdate = updateModelInput.getConnector() != null || newConnectorId != null || !Objects.equals(updateModelInput.getIsEnabled(), mlModel.getIsEnabled()) || updateModelInput.getGuardrails() != null || updateModelInput.getModelInterface() != null;
        if (MLRateLimiter.updateValidityPreCheck((MLRateLimiter)mlModel.getRateLimiter(), (MLRateLimiter)updateModelInput.getRateLimiter())) {
            MLRateLimiter updatedRateLimiterConfig = MLRateLimiter.update((MLRateLimiter)mlModel.getRateLimiter(), (MLRateLimiter)updateModelInput.getRateLimiter());
            updateModelInput.setRateLimiter(updatedRateLimiterConfig);
            isPredictorUpdate = isPredictorUpdate || updatedRateLimiterConfig.isValid();
        }
        boolean bl2 = isUpdateModelCache = isPredictorUpdate && isModelDeployed;
        if (mlModel.getAlgorithm() == FunctionName.TEXT_EMBEDDING) {
            if (newConnectorId == null && updateModelInput.getConnector() == null) {
                this.updateModelWithRegisteringToAnotherModelGroup(modelId, newModelGroupId, tenantId, user, updateModelInput, wrappedListener, isUpdateModelCache);
            } else {
                wrappedListener.onFailure((Exception)new OpenSearchStatusException("Trying to update the connector or connector_id field on a local model.", RestStatus.BAD_REQUEST, new Object[0]));
            }
        } else if (newConnectorId == null) {
            if (updateModelInput.getConnector() != null) {
                Connector connector = mlModel.getConnector();
                if (connector == null) {
                    wrappedListener.onFailure((Exception)new OpenSearchStatusException("Cannot update connector settings for this model. The model was created with a connector_id and does not have an inline connector.", RestStatus.BAD_REQUEST, new Object[0]));
                    return;
                }
                connector.update(updateModelInput.getConnector(), (arg_0, arg_1) -> ((MLEngine)this.mlEngine).encrypt(arg_0, arg_1));
                connector.validateConnectorURL(this.trustedConnectorEndpointsRegex);
                updateModelInput.setUpdatedConnector(connector);
                updateModelInput.setConnector(null);
            }
            this.updateModelWithRegisteringToAnotherModelGroup(modelId, newModelGroupId, tenantId, user, updateModelInput, wrappedListener, isUpdateModelCache);
        } else {
            this.updateModelWithNewStandAloneConnector(modelId, newModelGroupId, newConnectorId, tenantId, mlModel, user, updateModelInput, wrappedListener, isUpdateModelCache);
        }
    }

    private void updateModelWithNewStandAloneConnector(String modelId, String newModelGroupId, String newConnectorId, String tenantId, MLModel mlModel, User user, MLUpdateModelInput updateModelInput, ActionListener<UpdateResponse> wrappedListener, boolean isUpdateModelCache) {
        if (Strings.hasLength((String)mlModel.getConnectorId())) {
            this.connectorAccessControlHelper.validateConnectorAccess(this.sdkClient, this.client, newConnectorId, tenantId, this.mlFeatureEnabledSetting, (ActionListener<Boolean>)ActionListener.wrap(hasNewConnectorPermission -> {
                if (hasNewConnectorPermission.booleanValue()) {
                    this.updateModelWithRegisteringToAnotherModelGroup(modelId, newModelGroupId, tenantId, user, updateModelInput, wrappedListener, isUpdateModelCache);
                } else {
                    wrappedListener.onFailure((Exception)new OpenSearchStatusException("You don't have permission to update the connector, connector id: " + newConnectorId, RestStatus.FORBIDDEN, new Object[0]));
                }
            }, exception -> {
                log.error("Permission denied: Unable to update the connector with ID {}. Details: {}", (Object)newConnectorId, exception);
                wrappedListener.onFailure(exception);
            }));
        } else {
            wrappedListener.onFailure((Exception)new OpenSearchStatusException("This remote does not have a connector_id field, maybe it uses an internal connector.", RestStatus.BAD_REQUEST, new Object[0]));
        }
    }

    private void updateModelWithRegisteringToAnotherModelGroup(String modelId, String newModelGroupId, String tenantId, User user, MLUpdateModelInput updateModelInput, ActionListener<UpdateResponse> wrappedListener, boolean isUpdateModelCache) {
        UpdateRequest updateRequest = new UpdateRequest(".plugins-ml-model", modelId);
        if (newModelGroupId != null) {
            this.modelAccessControlHelper.validateModelGroupAccess(user, newModelGroupId, this.client, (ActionListener<Boolean>)ActionListener.wrap(hasNewModelGroupPermission -> {
                if (hasNewModelGroupPermission.booleanValue()) {
                    this.mlModelGroupManager.getModelGroupResponse(this.sdkClient, newModelGroupId, (ActionListener<GetResponse>)ActionListener.wrap(newModelGroupResponse -> this.buildUpdateRequest(modelId, newModelGroupId, updateRequest, updateModelInput, (GetResponse)newModelGroupResponse, wrappedListener, isUpdateModelCache), exception -> wrappedListener.onFailure((Exception)new OpenSearchStatusException("Failed to find the model group with the provided model group id in the update model input, MODEL_GROUP_ID: " + newModelGroupId, RestStatus.NOT_FOUND, new Object[0]))));
                } else {
                    wrappedListener.onFailure((Exception)new OpenSearchStatusException("User Doesn't have privilege to re-link this model to the target model group due to no access to the target model group with model group ID " + newModelGroupId, RestStatus.FORBIDDEN, new Object[0]));
                }
            }, exception -> {
                log.error("Permission denied: Unable to update the model with ID {}. Details: {}", (Object)modelId, exception);
                wrappedListener.onFailure(exception);
            }));
        } else {
            this.buildUpdateRequest(modelId, tenantId, updateRequest, updateModelInput, wrappedListener, isUpdateModelCache);
        }
    }

    private void buildUpdateRequest(String modelId, String tenantId, UpdateRequest updateRequest, MLUpdateModelInput updateModelInput, ActionListener<UpdateResponse> wrappedListener, boolean isUpdateModelCache) {
        ActionListener<UpdateResponse> updateListener;
        updateModelInput.setLastUpdateTime(Instant.now());
        UpdateDataObjectRequest updateDataObjectRequest = ((UpdateDataObjectRequest.Builder)((UpdateDataObjectRequest.Builder)((UpdateDataObjectRequest.Builder)UpdateDataObjectRequest.builder().index(updateRequest.index())).id(updateRequest.id())).tenantId(tenantId)).dataObject((ToXContentObject)updateModelInput).build();
        if (isUpdateModelCache) {
            String[] targetNodeIds = this.getAllNodes();
            MLUpdateModelCacheNodesRequest mlUpdateModelCacheNodesRequest = new MLUpdateModelCacheNodesRequest(targetNodeIds, modelId);
            updateListener = this.getUpdateResponseListenerWithUpdateModelCache(modelId, wrappedListener, mlUpdateModelCacheNodesRequest);
        } else {
            updateListener = this.getUpdateResponseListener(modelId, wrappedListener);
        }
        this.sdkClient.updateDataObjectAsync(updateDataObjectRequest).whenComplete((ur, ut) -> {
            if (ut == null) {
                try {
                    updateListener.onResponse((Object)ur.updateResponse());
                }
                catch (Exception e) {
                    updateListener.onFailure(e);
                }
            } else {
                Exception e = SdkClientUtils.unwrapAndConvertToException((Throwable)ut, (Class[])new Class[0]);
                updateListener.onFailure(e);
            }
        });
    }

    private void buildUpdateRequest(String modelId, String newModelGroupId, UpdateRequest updateRequest, MLUpdateModelInput updateModelInput, GetResponse newModelGroupResponse, ActionListener<UpdateResponse> wrappedListener, boolean isUpdateModelCache) {
        ActionListener<UpdateResponse> updateListener;
        Map newModelGroupSourceMap = newModelGroupResponse.getSourceAsMap();
        String updatedVersion = this.incrementLatestVersion(newModelGroupSourceMap);
        updateModelInput.setVersion(updatedVersion);
        updateModelInput.setLastUpdateTime(Instant.now());
        UpdateDataObjectRequest updateModelGroupRequest = this.createUpdateModelGroupRequest(newModelGroupSourceMap, newModelGroupId, newModelGroupResponse.getSeqNo(), newModelGroupResponse.getPrimaryTerm(), Integer.parseInt(updatedVersion));
        UpdateDataObjectRequest updateDataObjectRequest = ((UpdateDataObjectRequest.Builder)((UpdateDataObjectRequest.Builder)UpdateDataObjectRequest.builder().index(updateRequest.index())).id(updateRequest.id())).dataObject((ToXContentObject)updateModelInput).build();
        if (isUpdateModelCache) {
            String[] targetNodeIds = this.getAllNodes();
            MLUpdateModelCacheNodesRequest mlUpdateModelCacheNodesRequest = new MLUpdateModelCacheNodesRequest(targetNodeIds, modelId);
            updateListener = this.getUpdateResponseListenerWithUpdateModelCache(modelId, wrappedListener, mlUpdateModelCacheNodesRequest);
        } else {
            updateListener = this.getUpdateResponseListener(modelId, wrappedListener);
        }
        this.sdkClient.updateDataObjectAsync(updateModelGroupRequest).whenComplete((r, throwable) -> {
            if (throwable == null) {
                this.sdkClient.updateDataObjectAsync(updateDataObjectRequest).whenComplete((ur, ut) -> {
                    if (ut == null) {
                        try {
                            updateListener.onResponse((Object)ur.updateResponse());
                        }
                        catch (Exception e) {
                            updateListener.onFailure(e);
                        }
                    } else {
                        Exception e = SdkClientUtils.unwrapAndConvertToException((Throwable)ut, (Class[])new Class[0]);
                        updateListener.onFailure(e);
                    }
                });
            } else {
                Exception e = SdkClientUtils.unwrapAndConvertToException((Throwable)throwable, (Class[])new Class[0]);
                log.error("Failed to register ML model with model ID {} to the new model group with model group ID {}", (Object)modelId, (Object)newModelGroupId, (Object)e);
                wrappedListener.onFailure(e);
            }
        });
    }

    private ActionListener<UpdateResponse> getUpdateResponseListenerWithUpdateModelCache(String modelId, ActionListener<UpdateResponse> wrappedListener, MLUpdateModelCacheNodesRequest mlUpdateModelCacheNodesRequest) {
        return ActionListener.wrap(updateResponse -> {
            if (updateResponse != null && updateResponse.getResult() == DocWriteResponse.Result.UPDATED) {
                this.client.execute((ActionType)MLUpdateModelCacheAction.INSTANCE, (ActionRequest)mlUpdateModelCacheNodesRequest, ActionListener.wrap(r -> {
                    if (r != null && this.isUpdateModelCacheSuccessOnAllNodes((MLUpdateModelCacheNodesResponse)r)) {
                        log.info("Successfully updated ML model cache with model ID {}", (Object)modelId);
                        wrappedListener.onResponse(updateResponse);
                    } else {
                        Object[] nodeIds = this.getUpdateModelCacheFailedNodesList((MLUpdateModelCacheNodesResponse)r);
                        log.error("Successfully update ML model index with model ID {} but update model cache was failed on following nodes {}, please retry or redeploy model manually.", (Object)modelId, (Object)Arrays.toString(nodeIds));
                        wrappedListener.onFailure((Exception)new RuntimeException("Successfully update ML model index with model ID " + modelId + " but update model cache was failed on following nodes " + Arrays.toString(nodeIds) + ", please retry or redeploy model manually."));
                    }
                }, e -> {
                    log.error("Failed to update ML model cache for model: " + modelId, (Throwable)e);
                    wrappedListener.onFailure(e);
                }));
            } else if (updateResponse != null && updateResponse.getResult() != DocWriteResponse.Result.UPDATED) {
                log.warn("Update model for model {} got a result status other than update, result status: {}", (Object)modelId, (Object)updateResponse.getResult());
                wrappedListener.onResponse(updateResponse);
            } else {
                log.error("Failed to update ML model: " + modelId);
                wrappedListener.onFailure((Exception)new RuntimeException("Failed to update ML model: " + modelId));
            }
        }, exception -> {
            log.error("Failed to update ML model: " + modelId, (Throwable)exception);
            wrappedListener.onFailure(exception);
        });
    }

    private ActionListener<UpdateResponse> getUpdateResponseListener(String modelId, ActionListener<UpdateResponse> wrappedListener) {
        return ActionListener.wrap(updateResponse -> {
            if (updateResponse != null && updateResponse.getResult() == DocWriteResponse.Result.UPDATED) {
                log.info("Successfully update ML model with model ID {}", (Object)modelId);
                wrappedListener.onResponse(updateResponse);
            } else if (updateResponse != null && updateResponse.getResult() != DocWriteResponse.Result.UPDATED) {
                log.warn("Update model for model {} got a result status other than update, result status: {}", (Object)modelId, (Object)updateResponse.getResult());
                wrappedListener.onResponse(updateResponse);
            } else {
                log.error("Failed to update ML model: " + modelId);
                wrappedListener.onFailure((Exception)new RuntimeException("Failed to update ML model: " + modelId));
            }
        }, exception -> {
            log.error("Failed to update ML model: " + modelId, (Throwable)exception);
            wrappedListener.onFailure(exception);
        });
    }

    private String incrementLatestVersion(Map<String, Object> modelGroupSourceMap) {
        return Integer.toString((Integer)modelGroupSourceMap.get("latest_version") + 1);
    }

    private UpdateDataObjectRequest createUpdateModelGroupRequest(final Map<String, Object> modelGroupSourceMap, String modelGroupId, long seqNo, long primaryTerm, int updatedVersion) {
        modelGroupSourceMap.put("latest_version", updatedVersion);
        modelGroupSourceMap.put("last_updated_time", Instant.now().toEpochMilli());
        ToXContentObject dataObject = new ToXContentObject(){

            public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
                builder.startObject();
                for (Map.Entry e : modelGroupSourceMap.entrySet()) {
                    builder.field((String)e.getKey(), e.getValue());
                }
                return builder.endObject();
            }
        };
        return ((UpdateDataObjectRequest.Builder)((UpdateDataObjectRequest.Builder)UpdateDataObjectRequest.builder().index(".plugins-ml-model-group")).id(modelGroupId)).ifSeqNo(seqNo).ifPrimaryTerm(primaryTerm).dataObject(dataObject).build();
    }

    private Boolean isModelDeployed(MLModelState mlModelState) {
        return mlModelState.equals((Object)MLModelState.LOADED) || mlModelState.equals((Object)MLModelState.PARTIALLY_LOADED) || mlModelState.equals((Object)MLModelState.DEPLOYED) || mlModelState.equals((Object)MLModelState.PARTIALLY_DEPLOYED);
    }

    private Boolean isModelDeploying(MLModelState mlModelState) {
        return mlModelState.equals((Object)MLModelState.LOADING) || mlModelState.equals((Object)MLModelState.DEPLOYING);
    }

    private String[] getAllNodes() {
        Iterator iterator = this.clusterService.state().nodes().iterator();
        ArrayList<String> nodeIds = new ArrayList<String>();
        while (iterator.hasNext()) {
            nodeIds.add(((DiscoveryNode)iterator.next()).getId());
        }
        return nodeIds.toArray(new String[0]);
    }

    private boolean isUpdateModelCacheSuccessOnAllNodes(MLUpdateModelCacheNodesResponse updateModelCacheNodesResponse) {
        return updateModelCacheNodesResponse.failures() == null || updateModelCacheNodesResponse.failures().isEmpty();
    }

    private String[] getUpdateModelCacheFailedNodesList(MLUpdateModelCacheNodesResponse updateModelCacheNodesResponse) {
        if (updateModelCacheNodesResponse == null) {
            return this.getAllNodes();
        }
        ArrayList<String> nodeIds = new ArrayList<String>();
        for (FailedNodeException failedNodeException : updateModelCacheNodesResponse.failures()) {
            nodeIds.add(failedNodeException.nodeId());
        }
        return nodeIds.toArray(new String[0]);
    }

    @VisibleForTesting
    boolean isSuperAdminUserWrapper(ClusterService clusterService, Client client) {
        return RestActionUtils.isSuperAdminUser(clusterService, client);
    }
}

