/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.symmetry;

import java.util.Map;
import javajs.util.PT;
import org.jmol.symmetry.SpaceGroup;
import org.jmol.symmetry.Symmetry;
import org.jmol.symmetry.SymmetryOperation;
import org.jmol.util.SimpleUnitCell;

class SymmetryInfo {
    boolean isCurrentCell = true;
    private String displayName;
    boolean coordinatesAreFractional;
    boolean isMultiCell;
    String sgName;
    String sgTitle;
    SymmetryOperation[] symmetryOperations;
    SymmetryOperation[] additionalOperations;
    String infoStr;
    int[] cellRange;
    char latticeType = (char)80;
    String intlTableNo;
    String intlTableJmolId;
    private int spaceGroupIndex;
    private String spaceGroupF2CTitle;
    float[][] spaceGroupF2C;
    float[] spaceGroupF2CParams;
    protected String strSUPERCELL;
    String intlTableIndexNdotM;
    String intlTableTransform;
    float slop;
    private SpaceGroup sgDerived;
    private String itaNo;

    SymmetryInfo() {
    }

    void setSymmetryInfoFromModelkit(SpaceGroup sg) {
        this.cellRange = null;
        this.sgName = sg.getName();
        this.intlTableJmolId = sg.jmolId;
        this.intlTableNo = sg.itaNumber;
        this.latticeType = sg.latticeType;
        this.symmetryOperations = sg.finalOperations;
        this.coordinatesAreFractional = true;
        this.setInfo(sg.getOperationCount());
    }

    float[] setSymmetryInfoFromFile(Map<String, Object> modelInfo, float[] unitCellParams) {
        this.spaceGroupIndex = (Integer)modelInfo.remove("spaceGroupIndex");
        this.cellRange = (int[])modelInfo.remove("ML_unitCellRange");
        this.sgName = (String)modelInfo.get("spaceGroup");
        this.spaceGroupF2C = (float[][])modelInfo.remove("f2c");
        this.spaceGroupF2CTitle = (String)modelInfo.remove("f2cTitle");
        this.spaceGroupF2CParams = (float[])modelInfo.remove("f2cParams");
        this.sgTitle = (String)modelInfo.remove("spaceGroupTitle");
        this.strSUPERCELL = (String)modelInfo.remove("supercell");
        if (this.sgName == null || this.sgName == "") {
            this.sgName = "spacegroup unspecified";
        }
        this.intlTableNo = (String)modelInfo.get("intlTableNo");
        this.intlTableIndexNdotM = (String)modelInfo.get("intlTableIndex");
        this.intlTableTransform = (String)modelInfo.get("intlTableTransform");
        this.intlTableJmolId = (String)modelInfo.remove("intlTableJmolId");
        String s = (String)modelInfo.get("latticeType");
        this.latticeType = (char)(s == null ? 80 : (int)s.charAt(0));
        this.symmetryOperations = (SymmetryOperation[])modelInfo.remove("symOpsTemp");
        this.coordinatesAreFractional = modelInfo.containsKey("coordinatesAreFractional") ? (Boolean)modelInfo.get("coordinatesAreFractional") : false;
        boolean bl = this.isMultiCell = this.coordinatesAreFractional && this.symmetryOperations != null;
        if (unitCellParams == null) {
            unitCellParams = (float[])modelInfo.get("unitCellParams");
        }
        Object object = unitCellParams = (Object)(SimpleUnitCell.isValid(unitCellParams) ? unitCellParams : null);
        if (unitCellParams == null) {
            this.coordinatesAreFractional = false;
            this.symmetryOperations = null;
            this.cellRange = null;
            this.infoStr = "";
            modelInfo.remove("unitCellParams");
            this.slop = Float.NaN;
        } else if (unitCellParams.length > 26) {
            this.slop = unitCellParams[26];
        }
        int symmetryCount = modelInfo.containsKey("symmetryCount") ? (Integer)modelInfo.get("symmetryCount") : 0;
        this.setInfo(symmetryCount);
        return unitCellParams;
    }

    private void setInfo(int symmetryCount) {
        String info = "Spacegroup: " + this.sgName;
        if (this.symmetryOperations != null) {
            String c = "";
            String s = "\nNumber of symmetry operations: " + (symmetryCount == 0 ? 1 : symmetryCount) + "\nSymmetry Operations:";
            for (int i = 0; i < symmetryCount; ++i) {
                SymmetryOperation op = this.symmetryOperations[i];
                s = s + "\n" + op.fixMagneticXYZ(op, op.xyz);
                if (!op.isCenteringOp) continue;
                c = c + " (" + PT.rep(PT.replaceAllCharacters(op.xyz, "xyz", "0"), "0+", "") + ")";
            }
            if (c.length() > 0) {
                info = info + "\nCentering: " + c;
            }
            info = info + s;
            info = info + "\n";
        }
        this.infoStr = info;
    }

    SymmetryOperation[] getAdditionalOperations() {
        if (this.additionalOperations == null && this.symmetryOperations != null) {
            this.additionalOperations = SymmetryOperation.getAdditionalOperations(this.symmetryOperations, 115);
        }
        return this.additionalOperations;
    }

    SpaceGroup getDerivedSpaceGroup() {
        if (this.sgDerived == null) {
            this.sgDerived = SpaceGroup.getSpaceGroupFromIndex(this.spaceGroupIndex);
        }
        return this.sgDerived;
    }

    boolean setIsCurrentCell(boolean TF) {
        return this.isCurrentCell != TF && (this.isCurrentCell = TF);
    }

    String getSpaceGroupTitle() {
        return this.isCurrentCell && this.spaceGroupF2CTitle != null ? this.spaceGroupF2CTitle : (this.sgName.startsWith("cell=") ? this.sgName : this.sgTitle);
    }

    String getDisplayName(Symmetry sym) {
        if (this.displayName == null) {
            String sgName;
            boolean isPolymer = sym.isPolymer();
            boolean isSlab = sym.isSlab();
            String string = isPolymer ? "polymer" : (sgName = isSlab ? "slab" : this.getSpaceGroupTitle());
            if (sgName == null) {
                return null;
            }
            if (sgName.startsWith("cell=!")) {
                sgName = "cell=inverse[" + sgName.substring(6) + "]";
            }
            if ((sgName = PT.rep(sgName, ";0,0,0", "")).indexOf("#") < 0) {
                String trm = this.intlTableTransform;
                String intTab = this.intlTableIndexNdotM;
                if (!isSlab && !isPolymer && intTab != null) {
                    if (trm != null) {
                        int pt = sgName.indexOf(trm);
                        if (pt >= 0) {
                            sgName = PT.rep(sgName, "(" + trm + ")", "");
                        }
                        if (intTab.indexOf(trm) < 0) {
                            pt = intTab.indexOf(".");
                            if (pt > 0) {
                                intTab = intTab.substring(0, pt);
                            }
                            intTab = intTab + ":" + trm;
                        }
                    }
                    sgName = (sgName.startsWith("0") ? "" : (sgName.equals("unspecified!") ? "#" : sgName + " #")) + intTab;
                }
            }
            if (sgName.indexOf("-- [--]") >= 0) {
                sgName = "";
            }
            this.displayName = sgName;
        }
        return this.displayName;
    }

    public String getClegId() {
        if (this.itaNo == null) {
            this.itaNo = this.intlTableIndexNdotM;
            if (this.itaNo == null || this.itaNo.indexOf(":") > 0) {
                return this.itaNo;
            }
            int pt = this.itaNo.indexOf(".");
            this.itaNo = (pt > 0 ? this.itaNo.substring(0, pt) : this.itaNo) + ":" + this.intlTableTransform;
        }
        return this.itaNo;
    }
}

