#ifndef TETRAHEDRON_H
#define TETRAHEDRON_H

#include <QGLWidget>
#include <QDialog>
#include <QProcess>
#include <GL/glu.h>
#include "myfileopen.h"
#include "videowrapper.h"
#include "thmsk.h"

class Tetrahedron : public QGLWidget
{
    Q_OBJECT

public:
    Tetrahedron(QWidget *parent = 0, int parar = 0, int paran = 0);
    //~Tetrahedron();

    int num_select;
    int tool;
    int pos_x;
    int pos_y;
    int pos_z;
    int isback;
    int is_anaglyph;
    int bcle_render;
    int is_mblur;
    int is_fog;
    int is_sample_layer;
    int is_shift;
    int is_ctrl;

    int isrendering;

    int affiche_grille;

    float wg_fps_int;

    int back_w;
    int back_h;

    int fog_red;
    int fog_green;
    int fog_blue;

    int rouge;
    int vert;
    int bleu;

    int valueadd_R;
    int valueadd_V;
    int valueadd_B;

    int src_open_file;

    /*int c_r;
    int c_v;
    int c_b;
    int ac_r;
    int ac_v;
    int ac_b;*/

    QColor trtcolor;
    int wl_surf;
    //int wg_alpha_trans;

    int is_flakes;
    GLfloat size_flakes;
    int nbre_flakes;
    int type_flakes;
    int mcolor_flakes;
    int prof_flakes;
    int speed_flakes;

    int sm_mxw;
    float wl_cl;
    int wl_ix;
    int wl_cpt_fl;

    int must_update;

    float scale_factor;
    float wg_x;
    float wdecal;
    GLfloat light_position[];

    GLfloat anag_x;
    GLfloat anag_y;

    GLfloat tab_coo[20][17];
    GLfloat tab_old_blur[20];
    //GLfloat tab_coo_select[1][10]; // *** COORD POUR DIAPO SELECT ***
    //GLfloat Particles[20][3];
    QString tab_coo_timeline[20][20];
    QString tab_diapo[20][9];
    bool tab_msk[20];
    float tab_order[20][2];
    QString back_color;
    QString str_trans;
    int lgt_trans;
    int lgt_trans_old;
    QString wg_string_003;
    QString name_application;
    QString wg_strtr;

    QString tab_save_diapo[400][46];
    QImage table_preview_transition[251];
    QImage wg_img_smile_effect;
    QImage wg_table_photo[20];

    videowrapper *wg_tabvid[21];

    QMovie tabgif[20];

    QAction *load_image;
    QAction *load_back_image;
    QAction *swap_image;
    QAction *edit_image;
    QAction *delete_image;
    QAction *init_image;
    QAction *gb_image;
    QAction *gb_image_x;
    QAction *gb_image_y;
    QAction *ef_image;
    QAction *rx_image;
    QAction *ry_image;
    QAction *rz_image;
    QAction *load_cray_r;
    QAction *load_cray_v;
    QAction *load_cray_b;
    QAction *load_cray_w;
    QAction *load_star_w;
    QAction *load_cube;
    QAction *load_cube_change;
    QAction *custo_mask;
    QAction *load_earth;
    QAction *load_plane;
    QAction *load_text;
    QAction *duplicate_image;

    int nombre_diapos;
    int length_diapo;
    int position_timeline;

    GLuint texture_diapo[46];
    GLuint texture_diapo_cube[6];

    QString wg_path_images;
    float ratio_import;

    bool od_red;
    bool od_green;
    bool od_blue;

    bool og_red;
    bool og_green;
    bool og_blue;

    int wg_esp_ana;

    int wg_has_mx;
    int wg_has_my;
    int wg_has_mz;

    int wg_nb_cube;

    //int alpha_blend;
    float alpha_blend;

    float wg_tx;
    float wg_ty;

    float wg_fd_tx;
    float wg_fd_ty;

    int wg_infree_1;
    int wg_infree_2;

    GLUquadricObj *quadric;

    float wl_rp;
    float rst;

    float dep_px;
    float dep_py;
    float dep_pz;
    float dep_rx;
    float dep_ry;
    float dep_rz;
    float fin_px;
    float fin_py;
    float fin_pz;
    float fin_rx;
    float fin_ry;
    float fin_rz;

    float dep_x1;
    float dep_x2;
    float dep_y1;
    float dep_y2;
    float fin_x1;
    float fin_x2;
    float fin_y1;
    float fin_y2;

    float TF;
    float tp;
    float gama;

    float NUMALPHA;
    float alphaX;
    float alphaY;
    float alphaZ;
    float alphaRX;
    float alphaRY;
    float alphaRZ;

    int minidx;
    int maxidx;

    int dep_opa;
    int fin_opa;
    int dep_blur;
    int fin_blur;

    int dep_red;
    int dep_green;
    int dep_blue;

    int fin_red;
    int fin_green;
    int fin_blue;

    int dep_pos;
    int fin_pos;
    int fra;

    int minpos;
    int maxpos;

    GLfloat elements[1000][7];

    GLfloat wg_fl_sp_fl;

    QImage wg_alpha;
    QPixmap wg_pix_texture; // *** PIXMAP GLOBAL PEUT ETRE REUTILISE ***

    QString wg_src_effects;
    QString wg_dst_effects;

    int src_effect;

    QStringList wg_stringlist_001;
    QStringList wg_stringlist_002;

protected:
    void paintGL();
    void mousePressEvent(QMouseEvent *);
    void mouseMoveEvent(QMouseEvent *);
    void wheelEvent(QWheelEvent *);

public slots:
    void initializeGL();
    void resizeGL(int, int);
    void f_load_image();
    void f_load_image_for_cube();
    void f_load_image_for_cube_change();
    void f_load_image_for_sphere();
    void f_load_image_step_2_sphere(const QStringList);
    void f_swap_image();
    void f_dupliquer_image();
    void f_init_image();

    void f_change_tool_grab();
    void f_change_tool_grab_x();
    void f_change_tool_grab_y();

    void f_change_ef_image();
    void f_change_tool_rotate_x();
    void f_change_tool_rotate_y();
    void f_change_tool_rotate_z();

    void f_change_tool_grab_fi();
    void f_change_tool_rotate_x_fi();
    void f_change_tool_rotate_y_fi();
    void f_change_tool_rotate_z_fi();

    void f_mark_pos(int,int,int,int,int,int,int,int,int,int,int);
    void f_mark_vis(int,int);
    void f_follow_timeline(int);

    void f_open_ipreview(QString);
    void f_load_image_step_2(QStringList);
    void f_load_image_step_2_cube( const QStringList );
    void f_load_image_step_2_cube_change( const QStringList );

    void f_load_background_1();
    void f_load_background(QStringList);

    void f_hide_preview();

    void f_save_diapo(int);
    //void f_load_diapo(int);
    void f_init_tabcoo();
    void f_init_coo_one_slide(int);
    void f_init_tabtex();
    void f_load_theme(QString,QString);
    void f_delete_image();

    void f_load_mask(QString, int);

    //void f_effect_run(int, int);

    void f_check_anaglyph(int);

    void f_combo_od_changed(int);
    void f_combo_og_changed(int);

    void f_sl_esp_ana(int);

    int f_load_exif(QString);

    void f_sl_sca_diapo(int);

    void f_mark_del(int);
    void f_put_reflect(int);
    void f_edit_image();

    void f_check_motion_blur(int);

    void f_netbuf();
    void f_reload_img(int);

    void f_effect_run(int,int);

    QImage blur_shadow(QImage,int);

    void f_check_fog(int);
    //void f_init_gl(int);
    void f_load_cray_r();
    void f_load_cray_v();
    void f_load_cray_b();
    void f_load_cray_w();
    void f_load_load_star_w(QString);
    void f_load_cube(QString);
    void f_load_earth();
    void f_load_plane();
    void f_load_text();
    void f_load_object(QListWidgetItem*);
    void f_load_object_from_drop(QString);

    void f_custo_mask();
    QImage f_mutation_overmask(QImage, QString);

    void f_read_ffmpeg();

    void f_end_proc_magick(int, QProcess::ExitStatus);

    void f_apply_mask(int, int, float);

    void f_txt_changed(QString);

    void f_font_slidetxt(QFont);

    void f_reload_text();

    void f_bt_bold_txtslide();
    void f_bt_italic_txtslide();
    void f_bt_underline_txtslide();

    void f_net_video();

    void f_flakes_changed(int);
    void f_flakes_nbre_changed(int);
    void f_flakes_size_changed(int);
    void f_flakes_type_changed(int);
    void f_flakes_mcolor(int);
    void f_flakes_prof_changed(int);
    void f_flakes_speed_changed(int);

    void effect_polaroid();
    void effect_sepia();
    void effect_paint();
    void effect_auto_gamma();
    void effect_negate();
    void effect_multi_polaroid();
    void effect_charcoal();
    void effect_posterize();
    void effect_auto_level();
    void effect_radial_blur();

signals:
    void dia_select(int);
    void dia_of_preview(QString);
    void hide_preview();
    void update_preview();
    void move_start();
    void load_back();
    void update_coo();
    void change_length(int);
    void add_diapo();
    void update_diapo();
    void s_delete_diapo(int);
    void s_edit_image();
    //void ok_anti(int);
    void s_d_f_custo_mask();
    void tool_change(int);
    void flakes_act(int);
    void tool_ef_image();
    void effect_render();
    void file_smile();

private slots:

private:
    void draw();
    void draw_select();
    void contextMenuEvent(QContextMenuEvent *);
    QPoint lastPos;

    void keyPressEvent( QKeyEvent * );
    void keyReleaseEvent( QKeyEvent * );
    QProcess proc_ffmpeg;
    QProcess proc_magick;

    void dropEvent(QDropEvent *);
    void dragEnterEvent(QDragEnterEvent *);
    Qt::DropActions supportedDropActions () const;
};

#endif
