/* ============================================================
 * File  : tetrahedron.cpp
 * Author: Stephane Gibault
 * Date  : Sun Feb 4 2007
 * Description :
 *
 * 
 *  (C) 2007 by Stephane Gibault
 *
 * This program is free software; you can redistribute it
 * and/or modify it under the terms of the GNU General
 * Public License as published by the Free Software Foundation;
 * either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * ============================================================ */

#include <QtOpenGL>
#include "tetrahedron.h"
#include <math.h>
#include <QtGui>
#include <cmath>

Tetrahedron::Tetrahedron(QWidget *parent, int parar, int paran)
    : QGLWidget(QGLFormat(QGL::SampleBuffers),parent)
{
    qDebug() << "LAUNCH PARAMETERS = " << parar << " " << paran;

    if ( parar == 2 && paran == 2 )
    {
        setFormat(QGLFormat(QGL::DirectRendering | QGL::DepthBuffer | QGL::SampleBuffers));
    }
    else
    {
        if ( parar == 0 && paran == 2 )
        {
            setFormat(QGLFormat(QGL::IndirectRendering | QGL::DepthBuffer | QGL::SampleBuffers));
        }
        else
        {
            if ( parar == 0 && paran == 0 )
            {
                setFormat(QGLFormat(QGL::IndirectRendering | QGL::DepthBuffer));
            }
            else
            {
                setFormat(QGLFormat(QGL::DirectRendering | QGL::DepthBuffer));
            }
        }
    }

    this->setFocusPolicy(Qt::StrongFocus);
    this->setAcceptDrops(true);

    num_select = 0;
    nombre_diapos = 0;
    tool = 0;
    isback = 0;
    is_anaglyph = 0;
    wg_esp_ana = 1;
    scale_factor = 1;
    position_timeline = 10;
    str_trans = "";
    bcle_render = 1;
    is_mblur = 0;
    wg_has_mx = 0;
    wg_has_my = 0;
    wg_has_mz = 0;
    is_fog = 0;
    fog_red = 220;
    fog_green = 220;
    fog_blue = 220;
    wg_nb_cube = 0;
    is_sample_layer = 0;
    alpha_blend = 0;
    wg_fd_tx = 1.0;
    wg_fd_ty = 1.0;
    lgt_trans = 1;
    lgt_trans_old = 0;
    wg_fps_int = 25;
    is_shift = 0;
    is_ctrl = 0;

    is_flakes = 0;
    nbre_flakes = 500;
    size_flakes = 50;
    type_flakes = 0;
    mcolor_flakes = 0;
    prof_flakes = 0;
    speed_flakes = 100;

    isrendering = 0;

    affiche_grille = 0;

    must_update = 1;
    light_position[0] = 1.0;
    light_position[1] = 1.0;
    light_position[2] = 1.0;
    light_position[3] = 1.0;

    gama = 0.45;

    name_application = "2ManDVD";

    od_red = true;
    od_green = false;
    od_blue = true;

    og_red = false;
    og_green = true;
    og_blue = false;

    wg_path_images = QDir::homePath();
    back_color = "0:0:0";
    ratio_import=1.0;

    int i = 0;
    srand(time(NULL));
    while ( i < 1000 )
    {
            elements[i][0] = (float)(((float)rand() / ((float)RAND_MAX + 1) * 40)-20);
            elements[i][1] = (float)(((float)rand() / ((float)RAND_MAX + 1) * 40)-20);
            elements[i][2] = (float)(((float)rand() / ((float)RAND_MAX + 1) * 20)*-1);
            elements[i][3] = rand()%(10-0);
            elements[i][4] = (float)(rand()%(10-6))+6 / (float)10;
            elements[i][5] = (float)(rand()%(10-6))+6 / (float)10;
            elements[i][6] = (float)(rand()%(10-6))+6 / (float)10;

            if ( elements[i][2] > -1.90f )
            {
                    elements[i][2] = -1.90f;
            }
            i++;
    }

    load_image = new QAction(tr("Charger des images"), this);
    load_image->setIcon ( QIcon(":/Interface/Interface/open.png") );
    swap_image = new QAction(tr("Changer l'image de la diapositive"), this);
    swap_image->setIcon ( QIcon(":/Interface/Interface/open.png") );
    delete_image = new QAction(tr("Supprimer la diapositive"), this);
    delete_image->setIcon ( QIcon(":/Interface/Interface/trash.png") );
    duplicate_image = new QAction(tr("Dupliquer la diapositive"), this);
    duplicate_image->setIcon ( QIcon(":/Interface/Interface/copy.png") );
    init_image = new QAction(tr("Reinitialiser les coordonnees de la diapositive"), this);
    init_image->setIcon ( QIcon(":/Interface/Interface/coord.png") );
    init_image->setShortcut(QApplication::translate("this", "Ctrl+Z", 0, QApplication::UnicodeUTF8));
    edit_image = new QAction(tr("Decouper l'image"), this);
    edit_image->setIcon ( QIcon(":/Interface/Interface/contours.png") );

    load_cray_r = new QAction(tr("Crayon rouge"), this);
    load_cray_r->setIcon ( QIcon(":/Interface/Interface/cr.png") );
    load_cray_v = new QAction(tr("Crayon vert"), this);
    load_cray_v->setIcon ( QIcon(":/Interface/Interface/cv.png") );
    load_cray_b = new QAction(tr("Crayon bleu"), this);
    load_cray_b->setIcon ( QIcon(":/Interface/Interface/cb.png") );
    load_cray_w = new QAction(tr("Crayon blanc"), this);
    load_cray_w->setIcon ( QIcon(":/Interface/Interface/cw.png") );
    load_star_w = new QAction(tr("Sphere texturee"), this);
    load_star_w->setIcon ( QIcon(":/Interface/Interface/snowman.png") );
    load_cube = new QAction(tr("Cube (6 photos)"), this);
    load_cube->setIcon ( QIcon(":/Interface/Interface/cube.png") );
    load_earth = new QAction(tr("Earth"), this);
    load_earth->setIcon ( QIcon(":/Interface/Interface/Earth-icon.png") );
    load_plane = new QAction(tr("Avion en papier"), this);
    load_plane->setIcon ( QIcon(":/Interface/Interface/plane.png") );

    load_text = new QAction(tr("Texte 2D"), this);
    load_text->setIcon ( QIcon(":/Interface/Interface/subtitle.png") );

    custo_mask = new QAction(tr("Custmosiser le mask"), this);
    custo_mask->setIcon ( QIcon(":/Interface/Interface/customize.png") );

    load_cube_change = new QAction(tr("Changer les images du cube (6 photos)"), this);
    load_cube_change->setIcon ( QIcon(":/Interface/Interface/cube.png") );

    gb_image = new QAction(tr("Déplacer / Zoomer"), this);
    gb_image->setIcon ( QIcon(":/Interface/Interface/smile_grab.png") );

    gb_image_x = new QAction(tr("Déplacer axe x"), this);
    gb_image_x->setIcon ( QIcon(":/Interface/Interface/smile_grab.png") );
    gb_image_y = new QAction(tr("Déplacer axe y"), this);
    gb_image_y->setIcon ( QIcon(":/Interface/Interface/smile_grab.png") );

    ef_image = new QAction(tr("Appliquer un effet"), this);
    ef_image->setIcon ( QIcon(":/Interface/Interface/scalemedia.png") );
    rx_image = new QAction(tr("Tourner axe x"), this);
    rx_image->setIcon ( QIcon(":/Interface/Interface/smile_rx.png") );
    ry_image = new QAction(tr("Tourner axe y"), this);
    ry_image->setIcon ( QIcon(":/Interface/Interface/smile_ry.png") );
    rz_image = new QAction(tr("Tourner axe z"), this);
    rz_image->setIcon ( QIcon(":/Interface/Interface/smile_rz.png") );

    load_back_image = new QAction(tr("Charger une image d'arriere plan"), this);
    load_back_image->setIcon ( QIcon(":/Interface/Interface/btimg.png") );

    connect(load_image, SIGNAL(triggered()), this, SLOT(f_load_image()));
    connect(load_back_image, SIGNAL(triggered()), this, SLOT(f_load_background_1()));
    connect(edit_image, SIGNAL(triggered()), this, SLOT(f_edit_image()));
    connect(load_cray_r, SIGNAL(triggered()), this, SLOT(f_load_cray_r()));
    connect(load_cray_v, SIGNAL(triggered()), this, SLOT(f_load_cray_v()));
    connect(load_cray_b, SIGNAL(triggered()), this, SLOT(f_load_cray_b()));
    connect(load_cray_w, SIGNAL(triggered()), this, SLOT(f_load_cray_w()));
    connect(load_star_w, SIGNAL(triggered()), this, SLOT(f_load_image_for_sphere()));
    connect(load_cube, SIGNAL(triggered()), this, SLOT(f_load_image_for_cube()));
    connect(load_cube_change, SIGNAL(triggered()), this, SLOT(f_load_image_for_cube_change()));
    connect(load_earth, SIGNAL(triggered()), this, SLOT(f_load_earth()));
    connect(load_plane, SIGNAL(triggered()), this, SLOT(f_load_plane()));
    connect(load_text, SIGNAL(triggered()), this, SLOT(f_load_text()));

    connect(swap_image, SIGNAL(triggered()), this, SLOT(f_swap_image()));
    connect(delete_image, SIGNAL(triggered()), this, SLOT(f_delete_image()));
    connect(init_image, SIGNAL(triggered()), this, SLOT(f_init_image()));
    connect(duplicate_image, SIGNAL(triggered()), this, SLOT(f_dupliquer_image()));

    connect(gb_image, SIGNAL(triggered()), this, SLOT(f_change_tool_grab()));
    connect(gb_image_x, SIGNAL(triggered()), this, SLOT(f_change_tool_grab_x()));
    connect(gb_image_y, SIGNAL(triggered()), this, SLOT(f_change_tool_grab_y()));

    connect(ef_image, SIGNAL(triggered()), this, SLOT(f_change_ef_image()));
    connect(rx_image, SIGNAL(triggered()), this, SLOT(f_change_tool_rotate_x()));
    connect(ry_image, SIGNAL(triggered()), this, SLOT(f_change_tool_rotate_y()));
    connect(rz_image, SIGNAL(triggered()), this, SLOT(f_change_tool_rotate_z()));

    connect(custo_mask, SIGNAL(triggered()), this, SLOT(f_custo_mask()));

    connect(&proc_ffmpeg, SIGNAL(readyReadStandardOutput()), this, SLOT(f_read_ffmpeg()));
    connect(&proc_ffmpeg, SIGNAL(readyReadStandardError()), this, SLOT(f_read_ffmpeg()));

    connect(&proc_magick, SIGNAL(finished(int, QProcess::ExitStatus)), this, SLOT(f_end_proc_magick(int, QProcess::ExitStatus)));

    f_init_tabcoo();

    // *** TEST FONCTIONS OPENGL ***
    /*qDebug() << "SYSTEM OVERLAY : " << QGLFormat::hasOpenGLOverlays();
    if ( format().directRendering() == true )
    {
            qDebug() << "DIRECT RENDERING : TRUE";
    }
    else
    {
            qDebug() << "DIRECT RENDERING : FALSE";
    }
    if ( format().doubleBuffer() == true )
    {
            qDebug() << "DOUBLE BUFFERING : TRUE";
    }
    else
    {
            qDebug() << "DOUBLE BUFFERING : FALSE <--> OOPS WARNING <-->";
    }
    if ( format().QGLFormat::hasOpenGL() == true )
    {
            qDebug() << "OPENGL SUPPORT : TRUE";
    }
    else
    {
            qDebug() << "OPENGL SUPPORT : FALSE <--> OOPS WARNING <-->";
    }
    if ( format().sampleBuffers() == true )
    {
            qDebug() << "OPENGL SAMPLE LAYER : TRUE ... YOU COULD USE ANTIALIASING";
    }
    else
    {
            qDebug() << "OPENGL SAMPLE LAYER : FALSE ... YOU COULDN T USE ANTIALIASING";
    }*/
}

void Tetrahedron::f_custo_mask()
{
    emit s_d_f_custo_mask();
}

// *** MENU CONTEXTUEL ***

void Tetrahedron::contextMenuEvent(QContextMenuEvent *event)
{
    if ( wg_nb_cube == 1 )
    {
        load_cube->setDisabled(true);
    }
    else
    {
        load_cube->setEnabled(true);
    }

    QMenu menu(this);
    if ( num_select == 0 )
    {
        menu.addAction(load_image);
        QMenu *menuobj = menu.addMenu(QIcon(":/Interface/Interface/new1.png"),tr("Insérer un objet"));
        menuobj->addAction(load_cray_r);
        menuobj->addAction(load_cray_v);
        menuobj->addAction(load_cray_b);
        menuobj->addAction(load_cray_w);

        menuobj->addSeparator();
        menuobj->addAction(load_star_w);

        menuobj->addSeparator();
        menuobj->addAction(load_cube);

        menuobj->addSeparator();
        menuobj->addAction(load_earth);

        menuobj->addSeparator();
        menuobj->addAction(load_plane);

        menuobj->addSeparator();
        menuobj->addAction(load_text);

        menu.addSeparator();
        menu.addAction(load_back_image);
    }
    else
    {
        if ( tab_diapo[num_select][0].mid(0,1) == "?" )
        {
            if ( tab_diapo[num_select][0].mid(0,2) == "?6" )
            {
                menu.addAction(load_cube_change);
                menu.addSeparator();
            }
            else
            {
                menu.addAction(duplicate_image);
            }

            menu.addAction(delete_image);

            menu.addSeparator();

            menu.addAction(load_image);
            QMenu *menuobj = menu.addMenu(QIcon(":/Interface/Interface/new1.png"),tr("Insérer un objet"));
            menuobj->addAction(load_cray_r);
            menuobj->addAction(load_cray_v);
            menuobj->addAction(load_cray_b);
            menuobj->addAction(load_cray_w);

            menuobj->addSeparator();
            menuobj->addAction(load_star_w);

            menuobj->addSeparator();
            menuobj->addAction(load_cube);

            menuobj->addSeparator();
            menuobj->addAction(load_earth);

            menuobj->addSeparator();
            menuobj->addAction(load_plane);

            menuobj->addSeparator();
            menuobj->addAction(load_text);

            menu.addSeparator();
            menu.addAction(load_back_image);

            menu.addSeparator();

            QMenu *menualign = menu.addMenu(QIcon(":/Interface/Interface/smile_grab.png"),tr("Manipulation"));

            QMenu *menudep = menualign->addMenu(QIcon(":/Interface/Interface/smile_grab.png"),tr("Déplacement"));
            menudep->addAction(gb_image);
            menudep->addAction(gb_image_x);
            menudep->addAction(gb_image_y);

            menualign->addAction(rx_image);
            menualign->addAction(ry_image);
            menualign->addAction(rz_image);
        }
        else
        {
            menu.addAction(swap_image);
            if ( tab_diapo[num_select][3] != "" )
            {
                menu.addAction(custo_mask);
            }
            menu.addSeparator();
            menu.addAction(load_image);
            menu.addAction(duplicate_image);

            QMenu *menuobj = menu.addMenu(QIcon(":/Interface/Interface/new1.png"),tr("Insérer un objet"));
            menuobj->addAction(load_cray_r);
            menuobj->addAction(load_cray_v);
            menuobj->addAction(load_cray_b);
            menuobj->addAction(load_cray_w);

            menuobj->addSeparator();
            menuobj->addAction(load_star_w);

            menuobj->addSeparator();
            menuobj->addAction(load_cube);

            menuobj->addSeparator();
            menuobj->addAction(load_earth);

            menuobj->addSeparator();
            menuobj->addAction(load_plane);

            menuobj->addSeparator();
            menuobj->addAction(load_text);

            menu.addSeparator();
            menu.addAction(delete_image);
            menu.addAction(init_image);

            menu.addSeparator();
            menu.addAction(load_back_image);

            QMenu *menualign = menu.addMenu(QIcon(":/Interface/Interface/smile_grab.png"),tr("Manipulation"));

            QMenu *menudep = menualign->addMenu(QIcon(":/Interface/Interface/smile_grab.png"),tr("Déplacement"));
            menudep->addAction(gb_image);
            menudep->addAction(gb_image_x);
            menudep->addAction(gb_image_y);

            menualign->addAction(rx_image);
            menualign->addAction(ry_image);
            menualign->addAction(rz_image);

            if ( tab_diapo[num_select][0].right(4) == ".avi" || tab_diapo[num_select][0].right(4) == ".AVI" || tab_diapo[num_select][0].right(4) == ".mpg" || tab_diapo[num_select][0].right(4) == ".MPG" || tab_diapo[num_select][0].right(5) == ".MPEG" || tab_diapo[num_select][0].right(5) == ".mpeg" || tab_diapo[num_select][0].right(4) == ".mp4" || tab_diapo[num_select][0].right(4) == ".MP4" )
            {

            }
            else
            {
                menu.addSeparator();
                menu.addAction(edit_image);
                menu.addAction(ef_image);
            }
        }
    }
    menu.exec(event->globalPos());
}

void Tetrahedron::f_load_cube(QString wl_totpath)
{
    if ( nombre_diapos+1 >= 20 )
    {
        QMessageBox::information(this, name_application, tr("Nombre maximum de photos par diapositive atteint"));
        return;
    }

    f_init_coo_one_slide(nombre_diapos+1);

    tab_diapo[nombre_diapos+1][0] = "?6" + wl_totpath;                                // *** NOM DU FICHIER DIAPO ***
    tab_diapo[nombre_diapos+1][1] = QString::number(0);                               // *** LARGEUR DE LA TEXTURE ***
    tab_diapo[nombre_diapos+1][2] = QString::number(0);                               // *** HAUTEUR DE LA TEXTURE ***
    tab_diapo[nombre_diapos+1][3] = "";
    tab_diapo[nombre_diapos+1][4] = "0:255";                                            // *** LUMIERE ET CONTRASTE ***
    tab_diapo[nombre_diapos+1][5] = "1.0";                                            // *** SCALE FACTOR ***
    tab_diapo[nombre_diapos+1][6] = "0";                                              // *** REFLECT ***
    tab_diapo[nombre_diapos+1][7] = "0/0/0/0";                                        // *** CROP ***
    tab_diapo[nombre_diapos+1][8] = "0";                                              // *** ORIENTATION EXIF ***

    tab_coo[nombre_diapos+1][0] = 0.0;      // *** X ***
    tab_coo[nombre_diapos+1][1] = 0.0;      // *** Y ***
    tab_coo[nombre_diapos+1][2] = -12.0;     // *** Z ***
    tab_coo[nombre_diapos+1][3] = 100.0;      // *** IMG X ***
    tab_coo[nombre_diapos+1][4] = 100.0;      // *** IMG Y ***
    tab_coo[nombre_diapos+1][5] = 90.0;     // *** ROTATE X ***
    tab_coo[nombre_diapos+1][6] = 0.0;      // *** ROTATE Y ***
    tab_coo[nombre_diapos+1][7] = 0.0;      // *** ROTATE Z ***
    tab_coo[nombre_diapos+1][8] = 110;       // *** VISIBILITE ***
    tab_coo[nombre_diapos+1][9] = 0.0;      // *** TRANSPARENCE ***
    tab_coo[nombre_diapos+1][10] = 0.0;     // *** BLUR ***
    tab_coo[nombre_diapos+1][11] = 0;      // *** TRANS DIAPO ***
    tab_coo[nombre_diapos+1][12] = 255;      // *** RED ***
    tab_coo[nombre_diapos+1][13] = 255;      // *** GREEN ***
    tab_coo[nombre_diapos+1][14] = 255;      // *** BLUE ***
    tab_coo[nombre_diapos+1][15] = 100.0;      // *** IMG X ***
    tab_coo[nombre_diapos+1][16] = 100.0;      // *** IMG Y ***

    tab_coo_timeline[nombre_diapos+1][0] = "10:0.0:0.0:-12.0:90.0:0.0:0.0:110:0:0:255:255:255:100:100:100:100";
    tab_coo_timeline[nombre_diapos+1][1] = "690:0.0:0.0:-12.0:90.0:0.0:0.0:110:0:0:255:255:255:100:100:100:100";

    nombre_diapos++;
    f_follow_timeline(position_timeline);
    wg_nb_cube = 1;

    emit add_diapo();
}

void Tetrahedron::f_load_earth()
{
    if ( nombre_diapos+1 >= 20 )
    {
        QMessageBox::information(this, name_application, tr("Nombre maximum de photos par diapositive atteint"));
        return;
    }

    f_init_coo_one_slide(nombre_diapos+1);

    tab_diapo[nombre_diapos+1][0] = "?7";                                             // *** NOM DU FICHIER DIAPO ***
    tab_diapo[nombre_diapos+1][1] = QString::number(0);                               // *** LARGEUR DE LA TEXTURE ***
    tab_diapo[nombre_diapos+1][2] = QString::number(0);                               // *** HAUTEUR DE LA TEXTURE ***
    tab_diapo[nombre_diapos+1][3] = "";
    tab_diapo[nombre_diapos+1][4] = "0:255";                                            // *** LUMIERE ET CONTRASTE ***
    tab_diapo[nombre_diapos+1][5] = "1.0";                                            // *** SCALE FACTOR ***
    tab_diapo[nombre_diapos+1][6] = "0";                                              // *** REFLECT ***
    tab_diapo[nombre_diapos+1][7] = "0/0/0/0";                                        // *** CROP ***
    tab_diapo[nombre_diapos+1][8] = "0";                                              // *** ORIENTATION EXIF ***

    tab_coo[nombre_diapos+1][0] = 0.0;      // *** X ***
    tab_coo[nombre_diapos+1][1] = 0.0;      // *** Y ***
    tab_coo[nombre_diapos+1][2] = -12.0;     // *** Z ***
    tab_coo[nombre_diapos+1][3] = 100.0;      // *** IMGX ***
    tab_coo[nombre_diapos+1][4] = 100.0;      // *** IMGY ***
    tab_coo[nombre_diapos+1][5] = 90.0;     // *** ROTATE X ***
    tab_coo[nombre_diapos+1][6] = 180.0;      // *** ROTATE Y ***
    tab_coo[nombre_diapos+1][7] = 0.0;      // *** ROTATE Z ***
    tab_coo[nombre_diapos+1][8] = 110;       // *** VISIBILITE ***
    tab_coo[nombre_diapos+1][9] = 0.0;      // *** TRANSPARENCE ***
    tab_coo[nombre_diapos+1][10] = 0.0;     // *** BLUR ***
    tab_coo[nombre_diapos+1][11] = 0;      // *** TRANS DIAPO ***
    tab_coo[nombre_diapos+1][12] = 255;      // *** RED ***
    tab_coo[nombre_diapos+1][13] = 255;      // *** GREEN ***
    tab_coo[nombre_diapos+1][14] = 255;      // *** BLUE ***
    tab_coo[nombre_diapos+1][15] = 100.0;      // *** IMG X ***
    tab_coo[nombre_diapos+1][16] = 100.0;      // *** IMG Y ***

    tab_coo_timeline[nombre_diapos+1][0] = "10:0.0:0.0:-12.0:90.0:180.0:0.0:110:0:0:255:255:255:100:100:100:100";
    tab_coo_timeline[nombre_diapos+1][1] = "690:0.0:0.0:-12.0:90.0:180.0:0.0:110:0:0:255:255:255:100:100:100:100";

    nombre_diapos++;
    f_follow_timeline(position_timeline);

    emit add_diapo();
}

void Tetrahedron::f_load_plane()
{
    if ( nombre_diapos+1 >= 20 )
    {
        QMessageBox::information(this, name_application, tr("Nombre maximum de photos par diapositive atteint"));
        return;
    }

    f_init_coo_one_slide(nombre_diapos+1);

    tab_diapo[nombre_diapos+1][0] = "?8";                                             // *** NOM DU FICHIER DIAPO ***
    tab_diapo[nombre_diapos+1][1] = QString::number(0);                               // *** LARGEUR DE LA TEXTURE ***
    tab_diapo[nombre_diapos+1][2] = QString::number(0);                               // *** HAUTEUR DE LA TEXTURE ***
    tab_diapo[nombre_diapos+1][3] = "";
    tab_diapo[nombre_diapos+1][4] = "0:255";                                            // *** LUMIERE ET CONTRASTE ***
    tab_diapo[nombre_diapos+1][5] = "1.0";                                            // *** SCALE FACTOR ***
    tab_diapo[nombre_diapos+1][6] = "0";                                              // *** REFLECT ***
    tab_diapo[nombre_diapos+1][7] = "0/0/0/0";                                        // *** CROP ***
    tab_diapo[nombre_diapos+1][8] = "0";                                              // *** ORIENTATION EXIF ***

    tab_coo[nombre_diapos+1][0] = 0.0;      // *** X ***
    tab_coo[nombre_diapos+1][1] = 0.0;      // *** Y ***
    tab_coo[nombre_diapos+1][2] = -20.0;     // *** Z ***
    tab_coo[nombre_diapos+1][3] = 100.0;      // *** IMGX ***
    tab_coo[nombre_diapos+1][4] = 100.0;      // *** IMGY ***
    tab_coo[nombre_diapos+1][5] = -40.0;     // *** ROTATE X ***
    tab_coo[nombre_diapos+1][6] = 0.0;      // *** ROTATE Y ***
    tab_coo[nombre_diapos+1][7] = -40.0;      // *** ROTATE Z ***
    tab_coo[nombre_diapos+1][8] = 110;       // *** VISIBILITE ***
    tab_coo[nombre_diapos+1][9] = 0.0;      // *** TRANSPARENCE ***
    tab_coo[nombre_diapos+1][10] = 0.0;     // *** BLUR ***
    tab_coo[nombre_diapos+1][11] = 0;      // *** TRANS DIAPO ***
    tab_coo[nombre_diapos+1][12] = 255;      // *** RED ***
    tab_coo[nombre_diapos+1][13] = 255;      // *** GREEN ***
    tab_coo[nombre_diapos+1][14] = 255;      // *** BLUE ***
    tab_coo[nombre_diapos+1][15] = 100.0;      // *** IMG X ***
    tab_coo[nombre_diapos+1][16] = 100.0;      // *** IMG Y ***

    tab_coo_timeline[nombre_diapos+1][0] = "10:0.0:0.0:-20.0:-40.0:0.0:-40.0:110:0:0:255:255:255:100:100:100:100";
    tab_coo_timeline[nombre_diapos+1][1] = "690:0.0:0.0:-20.0:-40.0:0.0:-40.0:110:0:0:255:255:255:100:100:100:100";

    nombre_diapos++;
    f_follow_timeline(position_timeline);

    emit add_diapo();
}

void Tetrahedron::f_load_object(QListWidgetItem* wname)
{
    if ( nombre_diapos >= 19 )
    {
        return;
    }

    QString wl_myfic = QDir::homePath() + "/.2ManDVD_Library/" +"/Bibliotheque/Animations/"+ wname->text() + ".gif";
    QImage wl_img_texture;

    if ( wl_img_texture.load(wl_myfic) == true )
    {
        // *** CHARGEMENT DE LA TEXTURE ***
        QImage wl_puis_001(sm_mxw,sm_mxw,QImage::Format_ARGB32_Premultiplied);

        if ( wl_img_texture.width() > wl_img_texture.height() )
        {
            wl_img_texture = wl_img_texture.scaledToWidth(sm_mxw,Qt::SmoothTransformation);
        }
        else
        {
            wl_img_texture = wl_img_texture.scaledToHeight(sm_mxw,Qt::SmoothTransformation);
        }

        wl_puis_001 = wl_img_texture.copy ( 0, 0, sm_mxw, sm_mxw); //sm_mxw, sm_mxw);

        wg_table_photo[nombre_diapos+1] = wl_puis_001;

        f_init_coo_one_slide(nombre_diapos+1);

        int sens = f_load_exif(wl_myfic);

        tab_diapo[nombre_diapos+1][0] = wl_myfic;                                         // *** NOM DU FICHIER DIAPO ***
        tab_diapo[nombre_diapos+1][1] = QString::number(wl_img_texture.width());          // *** LARGEUR DE LA TEXTURE ***
        tab_diapo[nombre_diapos+1][2] = QString::number(wl_img_texture.height());         // *** HAUTEUR DE LA TEXTURE ***
        tab_diapo[nombre_diapos+1][3] = "";
        tab_diapo[nombre_diapos+1][4] = "0:255";                                            // *** LUMIERE ET CONTRASTE ***
        tab_diapo[nombre_diapos+1][5] = "0.5";                                            // *** SCALE FACTOR ***
        tab_diapo[nombre_diapos+1][6] = "0";                                              // *** REFLECT ***
        tab_diapo[nombre_diapos+1][7] = "0/0/0/0";                                        // *** CROP ***
        tab_diapo[nombre_diapos+1][8] = QString::number(sens);                            // *** ORIENTATION EXIF ***

        tab_coo[nombre_diapos+1][0] = 0.0;      // *** X ***
        tab_coo[nombre_diapos+1][1] = 0.0;      // *** Y ***
        tab_coo[nombre_diapos+1][2] = -3.8;     // *** Z ***
        tab_coo[nombre_diapos+1][3] = 100.0;      // *** IMGX ***
        tab_coo[nombre_diapos+1][4] = 100.0;      // *** IMGY ***
        tab_coo[nombre_diapos+1][5] = 0.0;      // *** ROTATE X ***
        tab_coo[nombre_diapos+1][6] = 0.0;      // *** ROTATE Y ***
        tab_coo[nombre_diapos+1][7] = 0.0;      // *** ROTATE Z ***
        tab_coo[nombre_diapos+1][8] = 110;       // *** VISIBILITE ***
        tab_coo[nombre_diapos+1][9] = 0.0;      // *** TRANSPARENCE ***
        tab_coo[nombre_diapos+1][10] = 0.0;     // *** BLUR ***
        tab_coo[nombre_diapos+1][11] = 0;      // *** TRANS DIAPO ***
        tab_coo[nombre_diapos+1][12] = 255;      // *** RED ***
        tab_coo[nombre_diapos+1][13] = 255;      // *** GREEN ***
        tab_coo[nombre_diapos+1][14] = 255;      // *** BLUE ***
        tab_coo[nombre_diapos+1][15] = 100.0;      // *** IMG X ***
        tab_coo[nombre_diapos+1][16] = 100.0;      // *** IMG Y ***

        tab_coo_timeline[nombre_diapos+1][0] = "10:0.0:0.0:-3.8:0.0:0.0:0.0:110:0:0:255:255:255:100:100:100:100";
        tab_coo_timeline[nombre_diapos+1][1] = "690:0.0:0.0:-3.8:0.0:0.0:0.0:110:0:0:255:255:255:100:100:100:100";

        QImage f = QGLWidget::convertToGLFormat( wl_puis_001 );

        glDeleteTextures (1,&texture_diapo[nombre_diapos+1]);
        glGenTextures (1,&texture_diapo[nombre_diapos+1]);
        glBindTexture (GL_TEXTURE_2D, texture_diapo[nombre_diapos+1]);

        glTexParameteri (GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR);
        glTexParameteri (GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR);

        glTexImage2D (GL_TEXTURE_2D, 0, GL_RGBA, f.width(), f.height(),
                      0, GL_RGBA, GL_UNSIGNED_BYTE, f.bits());

        tabgif[nombre_diapos+1].setFileName(wl_myfic);
        tabgif[nombre_diapos+1].setCacheMode( QMovie::CacheAll );
        tabgif[nombre_diapos+1].jumpToFrame( 0 );

        nombre_diapos++;
        f_follow_timeline(position_timeline);

        emit add_diapo();
    }
}

void Tetrahedron::f_load_object_from_drop(QString wname)
{
    if ( nombre_diapos >= 19 )
    {
        return;
    }

    QString wl_myfic = QDir::homePath() + "/.2ManDVD_Library/" +"/Bibliotheque/Animations/"+ wname + ".gif";
    QImage wl_img_texture;

    if ( wl_img_texture.load(wl_myfic) == true )
    {
        // *** CHARGEMENT DE LA TEXTURE ***
        QImage wl_puis_001(sm_mxw,sm_mxw,QImage::Format_ARGB32_Premultiplied);

        if ( wl_img_texture.width() > wl_img_texture.height() )
        {
            wl_img_texture = wl_img_texture.scaledToWidth(sm_mxw,Qt::SmoothTransformation);
        }
        else
        {
            wl_img_texture = wl_img_texture.scaledToHeight(sm_mxw,Qt::SmoothTransformation);
        }

        wl_puis_001 = wl_img_texture.copy ( 0, 0, sm_mxw, sm_mxw); //sm_mxw, sm_mxw);

        wg_table_photo[nombre_diapos+1] = wl_puis_001;

        f_init_coo_one_slide(nombre_diapos+1);

        int sens = f_load_exif(wl_myfic);

        tab_diapo[nombre_diapos+1][0] = wl_myfic;                                         // *** NOM DU FICHIER DIAPO ***
        tab_diapo[nombre_diapos+1][1] = QString::number(wl_img_texture.width());          // *** LARGEUR DE LA TEXTURE ***
        tab_diapo[nombre_diapos+1][2] = QString::number(wl_img_texture.height());         // *** HAUTEUR DE LA TEXTURE ***
        tab_diapo[nombre_diapos+1][3] = "";
        tab_diapo[nombre_diapos+1][4] = "0:255";                                            // *** LUMIERE ET CONTRASTE ***
        tab_diapo[nombre_diapos+1][5] = "0.5";                                            // *** SCALE FACTOR ***
        tab_diapo[nombre_diapos+1][6] = "0";                                              // *** REFLECT ***
        tab_diapo[nombre_diapos+1][7] = "0/0/0/0";                                        // *** CROP ***
        tab_diapo[nombre_diapos+1][8] = QString::number(sens);                            // *** ORIENTATION EXIF ***

        tab_coo[nombre_diapos+1][0] = 0.0;      // *** X ***
        tab_coo[nombre_diapos+1][1] = 0.0;      // *** Y ***
        tab_coo[nombre_diapos+1][2] = -3.8;     // *** Z ***
        tab_coo[nombre_diapos+1][3] = 100.0;      // *** IMGX ***
        tab_coo[nombre_diapos+1][4] = 100.0;      // *** IMGY ***
        tab_coo[nombre_diapos+1][5] = 0.0;      // *** ROTATE X ***
        tab_coo[nombre_diapos+1][6] = 0.0;      // *** ROTATE Y ***
        tab_coo[nombre_diapos+1][7] = 0.0;      // *** ROTATE Z ***
        tab_coo[nombre_diapos+1][8] = 110;       // *** VISIBILITE ***
        tab_coo[nombre_diapos+1][9] = 0.0;      // *** TRANSPARENCE ***
        tab_coo[nombre_diapos+1][10] = 0.0;     // *** BLUR ***
        tab_coo[nombre_diapos+1][11] = 0;      // *** TRANS DIAPO ***
        tab_coo[nombre_diapos+1][12] = 255;      // *** RED ***
        tab_coo[nombre_diapos+1][13] = 255;      // *** GREEN ***
        tab_coo[nombre_diapos+1][14] = 255;      // *** BLUE ***
        tab_coo[nombre_diapos+1][15] = 100.0;      // *** IMG X ***
        tab_coo[nombre_diapos+1][16] = 100.0;      // *** IMG Y ***

        tab_coo_timeline[nombre_diapos+1][0] = "10:0.0:0.0:-3.8:0.0:0.0:0.0:110:0:0:255:255:255:100:100:100:100";
        tab_coo_timeline[nombre_diapos+1][1] = "690:0.0:0.0:-3.8:0.0:0.0:0.0:110:0:0:255:255:255:100:100:100:100";

        QImage f = QGLWidget::convertToGLFormat( wl_puis_001 );

        glDeleteTextures (1,&texture_diapo[nombre_diapos+1]);
        glGenTextures (1,&texture_diapo[nombre_diapos+1]);
        glBindTexture (GL_TEXTURE_2D, texture_diapo[nombre_diapos+1]);

        glTexParameteri (GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR);
        glTexParameteri (GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR);

        glTexImage2D (GL_TEXTURE_2D, 0, GL_RGBA, f.width(), f.height(),
                      0, GL_RGBA, GL_UNSIGNED_BYTE, f.bits());

        tabgif[nombre_diapos+1].setFileName(wl_myfic);
        tabgif[nombre_diapos+1].setCacheMode( QMovie::CacheAll );
        tabgif[nombre_diapos+1].jumpToFrame( 0 );

        nombre_diapos++;
        f_follow_timeline(position_timeline);

        emit add_diapo();
    }
}

void Tetrahedron::f_load_text()
{
    if ( nombre_diapos+1 >= 20 )
    {
        QMessageBox::information(this, name_application, tr("Nombre maximum de photos par diapositive atteint"));
        return;
    }

    QFont myfont;
    myfont.setPointSize( 1000 );

    int wl_larg_txt;
    int wl_height_txt;

    QFontMetrics fm(myfont);
    wl_larg_txt = fm.width("Text");

    QString wl_tmps = "Text";

    if ( wl_larg_txt > 1000 )
    {
        int wl_fsize = 1000/(wl_tmps.length());

        if ( wl_fsize + fm.descent() > sm_mxw )
        {
            wl_fsize = wl_fsize-fm.descent();
        }
        myfont.setPointSize(wl_fsize);
        QFontMetrics fm2(myfont);
        wl_larg_txt = fm2.width(wl_tmps);
    }
    else
    {
        wl_larg_txt = fm.width(wl_tmps);
        if ( 1000 + fm.descent() > sm_mxw )
        {
            myfont.setPointSize(1000-fm.descent());
        }
        else
        {
            wl_height_txt = sm_mxw;
            myfont.setPointSize(wl_height_txt);
        }
    }

    QImage wl_img_001(sm_mxw,sm_mxw,QImage::Format_ARGB32_Premultiplied);
    wl_img_001.fill(0);

    QPainter p;
    p.begin(&wl_img_001);
    p.setFont(myfont);
    QRect textRect = p.fontMetrics().boundingRect("Text");
    p.setPen(QColor(255,255,255));
    p.drawText(QRect(0,0,sm_mxw,textRect.height()), Qt::AlignCenter,"Text");
    p.end();

    QImage f = QGLWidget::convertToGLFormat( wl_img_001 );

    glDeleteTextures (1,&texture_diapo[nombre_diapos+1]);
    glGenTextures (1,&texture_diapo[nombre_diapos+1]);
    glBindTexture (GL_TEXTURE_2D, texture_diapo[nombre_diapos+1]);

    glTexParameteri (GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR);
    glTexParameteri (GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR);

    glTexImage2D (GL_TEXTURE_2D, 0, GL_RGBA, f.width(), f.height(),
                  0, GL_RGBA, GL_UNSIGNED_BYTE, f.bits());

    wg_table_photo[nombre_diapos+1] = wl_img_001;

    f_init_coo_one_slide(nombre_diapos+1);

    tab_diapo[nombre_diapos+1][0] = "?9Text!;!255*^*255*^*255!;!NONE!;!000";          // *** NOM DU FICHIER DIAPO ***
    tab_diapo[nombre_diapos+1][1] = QString::number(sm_mxw);                          // *** LARGEUR DE LA TEXTURE ***
    tab_diapo[nombre_diapos+1][2] = QString::number(textRect.height());               // *** HAUTEUR DE LA TEXTURE ***
    tab_diapo[nombre_diapos+1][3] = "";
    tab_diapo[nombre_diapos+1][4] = "0:255";                                            // *** LUMIERE ET CONTRASTE ***
    tab_diapo[nombre_diapos+1][5] = "0.5";                                            // *** SCALE FACTOR ***
    tab_diapo[nombre_diapos+1][6] = "0";                                              // *** REFLECT ***
    tab_diapo[nombre_diapos+1][7] = "0/0/0/0";                                        // *** CROP ***
    tab_diapo[nombre_diapos+1][8] = "0";                                              // *** ORIENTATION EXIF ***

    tab_coo[nombre_diapos+1][0] = 0.0;      // *** X ***
    tab_coo[nombre_diapos+1][1] = 0.0;      // *** Y ***
    tab_coo[nombre_diapos+1][2] = -3.7;     // *** Z ***
    tab_coo[nombre_diapos+1][3] = 100.0;      // *** IMGX ***
    tab_coo[nombre_diapos+1][4] = 100.0;      // *** IMGY ***
    tab_coo[nombre_diapos+1][5] = 0.0;     // *** ROTATE X ***
    tab_coo[nombre_diapos+1][6] = 0.0;      // *** ROTATE Y ***
    tab_coo[nombre_diapos+1][7] = 0.0;      // *** ROTATE Z ***
    tab_coo[nombre_diapos+1][8] = 110;       // *** VISIBILITE ***
    tab_coo[nombre_diapos+1][9] = 0.0;      // *** TRANSPARENCE ***
    tab_coo[nombre_diapos+1][10] = 0.0;     // *** BLUR ***
    tab_coo[nombre_diapos+1][11] = 0;      // *** TRANS DIAPO ***
    tab_coo[nombre_diapos+1][12] = 255;      // *** RED ***
    tab_coo[nombre_diapos+1][13] = 255;      // *** GREEN ***
    tab_coo[nombre_diapos+1][14] = 255;      // *** BLUE ***
    tab_coo[nombre_diapos+1][15] = 100.0;      // *** IMG X ***
    tab_coo[nombre_diapos+1][16] = 100.0;      // *** IMG Y ***

    tab_coo_timeline[nombre_diapos+1][0] = "10:0.0:0.0:-3.7:0.0:0.0:0.0:110:0:0:255:255:255:100:100:100:100";
    tab_coo_timeline[nombre_diapos+1][1] = "690:0.0:0.0:-3.7:0.0:0.0:0.0:110:0:0:255:255:255:100:100:100:100";

    nombre_diapos++;

    f_follow_timeline(position_timeline);

    emit add_diapo();
}

void Tetrahedron::f_txt_changed(QString txtslide)
{
    if ( must_update == 0 )
    {
        return;
    }

    wg_stringlist_001 = tab_diapo[num_select][0].split("!;!",QString::KeepEmptyParts);

    txtslide.replace( "$", "md*%");
    txtslide.replace( "!:!", "ms*%");
    txtslide.replace( ":", "mp*%");

    tab_diapo[num_select][0] = "?9" + txtslide + + "!;!" + wg_stringlist_001.at(1) + "!;!" + wg_stringlist_001.at(2) + "!;!" + wg_stringlist_001.at(3);

    f_reload_text();
}

void Tetrahedron::f_font_slidetxt(QFont nfont)
{
    if ( must_update == 0 || num_select == 0 )
    {
        return;
    }

    wg_stringlist_001 = tab_diapo[num_select][0].split("!;!",QString::KeepEmptyParts);

    tab_diapo[num_select][0] = wg_stringlist_001.at(0) + "!;!" + wg_stringlist_001.at(1) + "!;!" + nfont.toString() + "!;!" + wg_stringlist_001.at(3);

    f_reload_text();
}

void Tetrahedron::f_bt_bold_txtslide()
{
    if ( must_update == 0 || num_select == 0 )
    {
        return;
    }

    wg_stringlist_001 = tab_diapo[num_select][0].split("!;!",QString::KeepEmptyParts);

    if ( wg_stringlist_001.at(3).mid(0,1) == "0" )
    {
        tab_diapo[num_select][0] = wg_stringlist_001.at(0) + "!;!" + wg_stringlist_001.at(1) + "!;!" + wg_stringlist_001.at(2) + "!;!1" + wg_stringlist_001.at(3).mid(1,2);
    }
    else
    {
        tab_diapo[num_select][0] = wg_stringlist_001.at(0) + "!;!" + wg_stringlist_001.at(1) + "!;!" + wg_stringlist_001.at(2) + "!;!0" + wg_stringlist_001.at(3).mid(1,2);
    }

    f_reload_text();
}

void Tetrahedron::f_bt_italic_txtslide()
{
    if ( must_update == 0 || num_select == 0 )
    {
        return;
    }

    wg_stringlist_001 = tab_diapo[num_select][0].split("!;!",QString::KeepEmptyParts);

    if ( wg_stringlist_001.at(3).mid(1,1) == "0" )
    {
        tab_diapo[num_select][0] = wg_stringlist_001.at(0) + "!;!" + wg_stringlist_001.at(1) + "!;!" + wg_stringlist_001.at(2) + "!;!" + wg_stringlist_001.at(3).mid(0,1) + "1" + wg_stringlist_001.at(3).mid(2,1);
    }
    else
    {
        tab_diapo[num_select][0] = wg_stringlist_001.at(0) + "!;!" + wg_stringlist_001.at(1) + "!;!" + wg_stringlist_001.at(2) + "!;!" + wg_stringlist_001.at(3).mid(0,1) + "0" + wg_stringlist_001.at(3).mid(2,1);
    }

    f_reload_text();

}

void Tetrahedron::f_bt_underline_txtslide()
{
    if ( must_update == 0 || num_select == 0 )
    {
        return;
    }

    wg_stringlist_001 = tab_diapo[num_select][0].split("!;!",QString::KeepEmptyParts);

    if ( wg_stringlist_001.at(3).mid(2,1) == "0" )
    {
        tab_diapo[num_select][0] = wg_stringlist_001.at(0) + "!;!" + wg_stringlist_001.at(1) + "!;!" + wg_stringlist_001.at(2) + "!;!" + wg_stringlist_001.at(3).mid(0,2) + "1";
    }
    else
    {
        tab_diapo[num_select][0] = wg_stringlist_001.at(0) + "!;!" + wg_stringlist_001.at(1) + "!;!" + wg_stringlist_001.at(2) + "!;!" + wg_stringlist_001.at(3).mid(0,2) + "0";
    }

    f_reload_text();
}

void Tetrahedron::f_reload_text()
{   
    wg_stringlist_001 = tab_diapo[num_select][0].split("!;!",QString::KeepEmptyParts);

    QFont myfont;
    QPainter p;
    QImage wl_img_001(sm_mxw,sm_mxw,QImage::Format_ARGB32_Premultiplied);
    wl_img_001.fill(0);

    if ( wg_stringlist_001.at(2) != "NONE" )
    {
        myfont.setFamily(wg_stringlist_001.at(2));
    }

    myfont.setPointSize ( 1000 );

    int wl_larg_txt;
    int wl_height_txt;

    wg_stringlist_002 = wg_stringlist_001.at(1).split("*^*",QString::KeepEmptyParts);

    int wl_r = wg_stringlist_002.at(0).toInt();
    int wl_g = wg_stringlist_002.at(1).toInt();
    int wl_b = wg_stringlist_002.at(2).toInt();

    if ( wg_stringlist_001.at(3).mid(0,1) == "1" )
    {
        myfont.setBold(true);
    }

    if ( wg_stringlist_001.at(3).mid(1,1) == "1" )
    {
        myfont.setItalic(true);
    }

    if ( wg_stringlist_001.at(3).mid(2,1) == "1" )
    {
        myfont.setUnderline(true);
    }

    QString wl_tmps = wg_stringlist_001.at(0);

    wl_tmps.replace( "md*%", "$" );
    wl_tmps.replace( "ms*%", "!:!" );
    wl_tmps.replace( "mp*%", ":" );

    QFontMetrics fm(myfont);
    wl_larg_txt = fm.width(wl_tmps.mid(2,wl_tmps.length()));

    if ( wl_larg_txt > 1000 )
    {
        int wl_fsize = 1000/(wl_tmps.length()-2);

        if ( wl_fsize + fm.descent() > sm_mxw )
        {
            wl_fsize = wl_fsize-fm.descent();
        }
        myfont.setPointSize(wl_fsize);
        QFontMetrics fm2(myfont);
        wl_larg_txt = fm2.width(wl_tmps.mid(2,wl_tmps.length()));
    }
    else
    {
        wl_larg_txt = fm.width(wl_tmps.mid(2,wl_tmps.length()));
        if ( 1000 + fm.descent() > sm_mxw )
        {
            myfont.setPointSize(1000-fm.descent());
        }
        else
        {
            wl_height_txt = sm_mxw;
            myfont.setPointSize(wl_height_txt);
        }
    }

    p.begin(&wl_img_001);
    p.setFont(myfont);
    QRect textRect = p.fontMetrics().boundingRect(wl_tmps.mid(2,wg_stringlist_001.at(0).length()));
    p.setPen(QColor(wl_r,wl_g,wl_b));
    p.drawText(QRect(0,0,sm_mxw,textRect.height()), Qt::AlignHCenter | Qt::AlignTop,wl_tmps.mid(2,wg_stringlist_001.at(0).length()));
    p.end();

    if ( tab_coo[num_select][10] > 0 )
    {
        wl_img_001 = blur_shadow(wl_img_001, tab_coo[num_select][10]);
    }

    QImage f = QGLWidget::convertToGLFormat( wl_img_001 );

    glDeleteTextures (1,&texture_diapo[num_select]);
    glGenTextures (1,&texture_diapo[num_select]);
    glBindTexture (GL_TEXTURE_2D, texture_diapo[num_select]);

    glTexParameteri (GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR);
    glTexParameteri (GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR);

    glTexImage2D (GL_TEXTURE_2D, 0, GL_RGBA, f.width(), f.height(),
                  0, GL_RGBA, GL_UNSIGNED_BYTE, f.bits());

    wg_table_photo[num_select] = wl_img_001;

    tab_diapo[num_select][0] = "?9" + wg_stringlist_001.at(0).mid(2,wg_stringlist_001.at(0).length()) + "!;!" + wg_stringlist_002.at(0) + "*^*" + wg_stringlist_002.at(1) + "*^*" + wg_stringlist_002.at(2) + "!;!" + wg_stringlist_001.at(2) + "!;!" + wg_stringlist_001.at(3);
    tab_diapo[num_select][1] = QString::number(sm_mxw);
    tab_diapo[num_select][2] = QString::number(textRect.height());

    updateGL();
}

void Tetrahedron::f_load_cray_r()
{
    if ( nombre_diapos+1 >= 20 )
    {
        QMessageBox::information(this, name_application, tr("Nombre maximum de photos par diapositive atteint"));
        return;
    }

    f_init_coo_one_slide(nombre_diapos+1);

    tab_diapo[nombre_diapos+1][0] = "?1";                                             // *** NOM DU FICHIER DIAPO ***
    tab_diapo[nombre_diapos+1][1] = QString::number(0);                               // *** LARGEUR DE LA TEXTURE ***
    tab_diapo[nombre_diapos+1][2] = QString::number(0);                               // *** HAUTEUR DE LA TEXTURE ***
    tab_diapo[nombre_diapos+1][3] = "";
    tab_diapo[nombre_diapos+1][4] = "0:255";                                            // *** LUMIERE ET CONTRASTE ***
    tab_diapo[nombre_diapos+1][5] = "1.0";                                            // *** SCALE FACTOR ***
    tab_diapo[nombre_diapos+1][6] = "0";                                              // *** REFLECT ***
    tab_diapo[nombre_diapos+1][7] = "0/0/0/0";                                        // *** CROP ***
    tab_diapo[nombre_diapos+1][8] = "0";                                              // *** ORIENTATION EXIF ***

    tab_coo[nombre_diapos+1][0] = 0.0;      // *** X ***
    tab_coo[nombre_diapos+1][1] = 0.0;      // *** Y ***
    tab_coo[nombre_diapos+1][2] = -12.0;     // *** Z ***
    tab_coo[nombre_diapos+1][3] = 100.0;      // *** IMGX ***
    tab_coo[nombre_diapos+1][4] = 100.0;      // *** IMGY ***
    tab_coo[nombre_diapos+1][5] = 90.0;     // *** ROTATE X ***
    tab_coo[nombre_diapos+1][6] = 0.0;      // *** ROTATE Y ***
    tab_coo[nombre_diapos+1][7] = 0.0;      // *** ROTATE Z ***
    tab_coo[nombre_diapos+1][8] = 110;       // *** VISIBILITE ***
    tab_coo[nombre_diapos+1][9] = 0.0;      // *** TRANSPARENCE ***
    tab_coo[nombre_diapos+1][10] = 0.0;     // *** BLUR ***
    tab_coo[nombre_diapos+1][11] = 0;      // *** TRANS DIAPO ***
    tab_coo[nombre_diapos+1][12] = 255;      // *** RED ***
    tab_coo[nombre_diapos+1][13] = 255;      // *** GREEN ***
    tab_coo[nombre_diapos+1][14] = 255;      // *** BLUE ***
    tab_coo[nombre_diapos+1][15] = 100.0;      // *** IMG X ***
    tab_coo[nombre_diapos+1][16] = 100.0;      // *** IMG Y ***

    tab_coo_timeline[nombre_diapos+1][0] = "10:0.0:0.0:-12.0:90.0:0.0:0.0:110:0:0:255:255:255:100:100:100:100";
    tab_coo_timeline[nombre_diapos+1][1] = "690:0.0:0.0:-12.0:90.0:0.0:0.0:110:0:0:255:255:255:100:100:100:100";

    nombre_diapos++;
    f_follow_timeline(position_timeline);

    emit add_diapo();
}

void Tetrahedron::f_load_cray_v()
{
    if ( nombre_diapos+1 >= 20 )
    {
        QMessageBox::information(this, name_application, tr("Nombre maximum de photos par diapositive atteint"));
        return;
    }

    f_init_coo_one_slide(nombre_diapos+1);

    tab_diapo[nombre_diapos+1][0] = "?2";                                             // *** NOM DU FICHIER DIAPO ***
    tab_diapo[nombre_diapos+1][1] = QString::number(0);                               // *** LARGEUR DE LA TEXTURE ***
    tab_diapo[nombre_diapos+1][2] = QString::number(0);                               // *** HAUTEUR DE LA TEXTURE ***
    tab_diapo[nombre_diapos+1][3] = "";
    tab_diapo[nombre_diapos+1][4] = "0:255";                                            // *** LUMIERE ET CONTRASTE ***
    tab_diapo[nombre_diapos+1][5] = "1.0";                                            // *** SCALE FACTOR ***
    tab_diapo[nombre_diapos+1][6] = "0";                                              // *** REFLECT ***
    tab_diapo[nombre_diapos+1][7] = "0/0/0/0";                                        // *** CROP ***
    tab_diapo[nombre_diapos+1][8] = "0";                                              // *** ORIENTATION EXIF ***

    tab_coo[nombre_diapos+1][0] = 0.0;      // *** X ***
    tab_coo[nombre_diapos+1][1] = 0.0;      // *** Y ***
    tab_coo[nombre_diapos+1][2] = -12.0;    // *** Z ***
    tab_coo[nombre_diapos+1][3] = 100.0;      // *** IMGX ***
    tab_coo[nombre_diapos+1][4] = 100.0;      // *** IMGY ***
    tab_coo[nombre_diapos+1][5] = 90.0;     // *** ROTATE X ***
    tab_coo[nombre_diapos+1][6] = 0.0;      // *** ROTATE Y ***
    tab_coo[nombre_diapos+1][7] = 0.0;      // *** ROTATE Z ***
    tab_coo[nombre_diapos+1][8] = 110;       // *** VISIBILITE ***
    tab_coo[nombre_diapos+1][9] = 0.0;      // *** TRANSPARENCE ***
    tab_coo[nombre_diapos+1][10] = 0.0;     // *** BLUR ***
    tab_coo[nombre_diapos+1][11] = 0;      // *** TRANS DIAPO ***
    tab_coo[nombre_diapos+1][12] = 255;      // *** RED ***
    tab_coo[nombre_diapos+1][13] = 255;      // *** GREEN ***
    tab_coo[nombre_diapos+1][14] = 255;      // *** BLUE ***
    tab_coo[nombre_diapos+1][15] = 100.0;      // *** IMG X ***
    tab_coo[nombre_diapos+1][16] = 100.0;      // *** IMG Y ***

    tab_coo_timeline[nombre_diapos+1][0] = "10:0.0:0.0:-12.0:90.0:0.0:0.0:110:0:0:255:255:255:100:100:100:100";
    tab_coo_timeline[nombre_diapos+1][1] = "690:0.0:0.0:-12.0:90.0:0.0:0.0:110:0:0:255:255:255:100:100:100:100";

    nombre_diapos++;
    f_follow_timeline(position_timeline);

    emit add_diapo();
}

void Tetrahedron::f_load_cray_b()
{
    if ( nombre_diapos+1 >= 20 )
    {
        QMessageBox::information(this, name_application, tr("Nombre maximum de photos par diapositive atteint"));
        return;
    }

    f_init_coo_one_slide(nombre_diapos+1);

    tab_diapo[nombre_diapos+1][0] = "?3";                                             // *** NOM DU FICHIER DIAPO ***
    tab_diapo[nombre_diapos+1][1] = QString::number(0);                               // *** LARGEUR DE LA TEXTURE ***
    tab_diapo[nombre_diapos+1][2] = QString::number(0);                               // *** HAUTEUR DE LA TEXTURE ***
    tab_diapo[nombre_diapos+1][3] = "";
    tab_diapo[nombre_diapos+1][4] = "0:255";                                            // *** LUMIERE ET CONTRASTE ***
    tab_diapo[nombre_diapos+1][5] = "1.0";                                            // *** SCALE FACTOR ***
    tab_diapo[nombre_diapos+1][6] = "0";                                              // *** REFLECT ***
    tab_diapo[nombre_diapos+1][7] = "0/0/0/0";                                        // *** CROP ***
    tab_diapo[nombre_diapos+1][8] = "0";                                              // *** ORIENTATION EXIF ***

    tab_coo[nombre_diapos+1][0] = 0.0;      // *** X ***
    tab_coo[nombre_diapos+1][1] = 0.0;      // *** Y ***
    tab_coo[nombre_diapos+1][2] = -12.0;     // *** Z ***
    tab_coo[nombre_diapos+1][3] = 100.0;      // *** IMGX ***
    tab_coo[nombre_diapos+1][4] = 100.0;      // *** IMGY ***
    tab_coo[nombre_diapos+1][5] = 90.0;     // *** ROTATE X ***
    tab_coo[nombre_diapos+1][6] = 0.0;      // *** ROTATE Y ***
    tab_coo[nombre_diapos+1][7] = 0.0;      // *** ROTATE Z ***
    tab_coo[nombre_diapos+1][8] = 110;       // *** VISIBILITE ***
    tab_coo[nombre_diapos+1][9] = 0.0;      // *** TRANSPARENCE ***
    tab_coo[nombre_diapos+1][10] = 0.0;     // *** BLUR ***
    tab_coo[nombre_diapos+1][11] = 0;      // *** TRANS DIAPO ***
    tab_coo[nombre_diapos+1][12] = 255;      // *** RED ***
    tab_coo[nombre_diapos+1][13] = 255;      // *** GREEN ***
    tab_coo[nombre_diapos+1][14] = 255;      // *** BLUE ***
    tab_coo[nombre_diapos+1][15] = 100.0;      // *** IMG X ***
    tab_coo[nombre_diapos+1][16] = 100.0;      // *** IMG Y ***

    tab_coo_timeline[nombre_diapos+1][0] = "10:0.0:0.0:-12.0:90.0:0.0:0.0:110:0:0:255:255:255:100:100:100:100";
    tab_coo_timeline[nombre_diapos+1][1] = "690:0.0:0.0:-12.0:90.0:0.0:0.0:110:0:0:255:255:255:100:100:100:100";

    nombre_diapos++;
    f_follow_timeline(position_timeline);

    emit add_diapo();
}

void Tetrahedron::f_load_cray_w()
{
    if ( nombre_diapos+1 >= 20 )
    {
        QMessageBox::information(this, name_application, tr("Nombre maximum de photos par diapositive atteint"));
        return;
    }

    f_init_coo_one_slide(nombre_diapos+1);

    tab_diapo[nombre_diapos+1][0] = "?4";                                             // *** NOM DU FICHIER DIAPO ***
    tab_diapo[nombre_diapos+1][1] = QString::number(0);                               // *** LARGEUR DE LA TEXTURE ***
    tab_diapo[nombre_diapos+1][2] = QString::number(0);                               // *** HAUTEUR DE LA TEXTURE ***
    tab_diapo[nombre_diapos+1][3] = "";
    tab_diapo[nombre_diapos+1][4] = "0:255";                                            // *** LUMIERE ET CONTRASTE ***
    tab_diapo[nombre_diapos+1][5] = "1.0";                                            // *** SCALE FACTOR ***
    tab_diapo[nombre_diapos+1][6] = "0";                                              // *** REFLECT ***
    tab_diapo[nombre_diapos+1][7] = "0/0/0/0";                                        // *** CROP ***
    tab_diapo[nombre_diapos+1][8] = "0";                                              // *** ORIENTATION EXIF ***

    tab_coo[nombre_diapos+1][0] = 0.0;      // *** X ***
    tab_coo[nombre_diapos+1][1] = 0.0;      // *** Y ***
    tab_coo[nombre_diapos+1][2] = -12.0;     // *** Z ***
    tab_coo[nombre_diapos+1][3] = 100.0;      // *** IMGX ***
    tab_coo[nombre_diapos+1][4] = 100.0;      // *** IMGY ***
    tab_coo[nombre_diapos+1][5] = 90.0;     // *** ROTATE X ***
    tab_coo[nombre_diapos+1][6] = 0.0;      // *** ROTATE Y ***
    tab_coo[nombre_diapos+1][7] = 0.0;      // *** ROTATE Z ***
    tab_coo[nombre_diapos+1][8] = 110;       // *** VISIBILITE ***
    tab_coo[nombre_diapos+1][9] = 0.0;      // *** TRANSPARENCE ***
    tab_coo[nombre_diapos+1][10] = 0.0;     // *** BLUR ***
    tab_coo[nombre_diapos+1][11] = 0;      // *** TRANS DIAPO ***
    tab_coo[nombre_diapos+1][12] = 255;      // *** RED ***
    tab_coo[nombre_diapos+1][13] = 255;      // *** GREEN ***
    tab_coo[nombre_diapos+1][14] = 255;      // *** BLUE ***
    tab_coo[nombre_diapos+1][15] = 100.0;      // *** IMG X ***
    tab_coo[nombre_diapos+1][16] = 100.0;      // *** IMG Y ***

    tab_coo_timeline[nombre_diapos+1][0] = "10:0.0:0.0:-12.0:90.0:0.0:0.0:110:0:0:255:255:255:100:100:100:100";
    tab_coo_timeline[nombre_diapos+1][1] = "690:0.0:0.0:-12.0:90.0:0.0:0.0:110:0:0:255:255:255:100:100:100:100";

    nombre_diapos++;
    f_follow_timeline(position_timeline);

    emit add_diapo();
}

void Tetrahedron::f_load_load_star_w(QString path)
{
    tab_diapo[nombre_diapos+1][0] = "?5" + path;                                      // *** NOM DU FICHIER DIAPO ***
    tab_diapo[nombre_diapos+1][1] = QString::number(0);                               // *** LARGEUR DE LA TEXTURE ***
    tab_diapo[nombre_diapos+1][2] = QString::number(0);                               // *** HAUTEUR DE LA TEXTURE ***
    tab_diapo[nombre_diapos+1][3] = "";
    tab_diapo[nombre_diapos+1][4] = "0:255";                                            // *** LUMIERE ET CONTRASTE ***
    tab_diapo[nombre_diapos+1][5] = "1.0";                                            // *** SCALE FACTOR ***
    tab_diapo[nombre_diapos+1][6] = "0";                                              // *** REFLECT ***
    tab_diapo[nombre_diapos+1][7] = "0/0/0/0";                                        // *** CROP ***
    tab_diapo[nombre_diapos+1][8] = "0";                                              // *** ORIENTATION EXIF ***

    tab_coo[nombre_diapos+1][0] = 0.0;      // *** X ***
    tab_coo[nombre_diapos+1][1] = 0.0;      // *** Y ***
    tab_coo[nombre_diapos+1][2] = -3.8;     // *** Z ***
    tab_coo[nombre_diapos+1][3] = 100.0;      // *** IMGX ***
    tab_coo[nombre_diapos+1][4] = 100.0;      // *** IMGY ***
    tab_coo[nombre_diapos+1][5] = 0.0;     // *** ROTATE X ***
    tab_coo[nombre_diapos+1][6] = 0.0;      // *** ROTATE Y ***
    tab_coo[nombre_diapos+1][7] = 0.0;      // *** ROTATE Z ***
    tab_coo[nombre_diapos+1][8] = 110;       // *** VISIBILITE ***
    tab_coo[nombre_diapos+1][9] = 0.0;      // *** TRANSPARENCE ***
    tab_coo[nombre_diapos+1][10] = 0.0;     // *** BLUR ***
    tab_coo[nombre_diapos+1][12] = 255;      // *** RED ***
    tab_coo[nombre_diapos+1][13] = 255;      // *** GREEN ***
    tab_coo[nombre_diapos+1][14] = 255;      // *** BLUE ***
    tab_coo[nombre_diapos+1][15] = 100.0;      // *** IMG X ***
    tab_coo[nombre_diapos+1][16] = 100.0;      // *** IMG Y ***

    tab_coo_timeline[nombre_diapos+1][0] = "10:0.0:0.0:-12.0:0.0:0.0:0.0:110:0:0:255:255:255:100:100:100:100";
    tab_coo_timeline[nombre_diapos+1][1] = "690:0.0:0.0:-12.0:0.0:0.0:0.0:110:0:0:255:255:255:100:100:100:100";

    nombre_diapos++;
    f_follow_timeline(position_timeline);

    emit add_diapo();
}

void Tetrahedron::f_edit_image()
{
    emit s_edit_image();
}

void Tetrahedron::f_init_image()
{
    tab_coo[num_select][0] = 0.0;      // *** X ***
    tab_coo[num_select][1] = 0.0;      // *** Y ***
    tab_coo[num_select][2] = -3.8;     // *** Z ***
    tab_coo[num_select][3] = 100.0;      // *** IMGX ***
    tab_coo[num_select][4] = 100.0;      // *** IMGY ***
    tab_coo[num_select][5] = 0.0;      // *** ROTATE X ***
    tab_coo[num_select][6] = 0.0;      // *** ROTATE Y ***
    tab_coo[num_select][7] = 0.0;      // *** ROTATE Z ***
    tab_coo[num_select][8] = 1.0;      // *** VISIBILITE ***
    tab_coo[num_select][9] = 0.0;      // *** TRANSPARENCE ***
    tab_coo[num_select][15] = 100.0;      // *** IMG X ***
    tab_coo[num_select][16] = 100.0;      // *** IMG Y ***

    tab_coo_timeline[num_select][0] = "10:0.0:0.0:-3.8:0.0:0.0:0.0:1:0:0:255:255:255:100:100:100:100";
    tab_coo_timeline[num_select][1] = "690:0.0:0.0:-3.8:0.0:0.0:0.0:1:0:0:255:255:255:100:100:100:100";

    int wl_i = 2;

    while (wl_i < 20)
    {
        tab_coo_timeline[num_select][wl_i] = "";
        wl_i++;
    }

    dia_select(num_select);
    updateGL();
}

void Tetrahedron::f_load_image()
{
    /*myfileopen *hdlfopen = new myfileopen(this);
    hdlfopen->setDirectory(wg_path_images);
    hdlfopen->source = 1;
    num_select = 0;
    hdlfopen->setFileMode(QFileDialog::ExistingFiles);
    hdlfopen->setWindowTitle(tr("Diapositive"));
    hdlfopen->setFilter("(*.PNG *.png *.jpg *.JPG *.jeg *.JPEG *.gif *.GIF *.avi *.AVI *.MPG *.mpg *.MPEG *.mpeg *.mp4 *.MP4)");
    hdlfopen->show();
    connect(hdlfopen, SIGNAL(change_image(QString)),this, SLOT(f_open_ipreview(QString)));
    connect(hdlfopen, SIGNAL(filesSelected( const QStringList )),this, SLOT(f_load_image_step_2( const QStringList )));
    connect(hdlfopen, SIGNAL(f_close()),this, SLOT(f_hide_preview()));
    connect(hdlfopen, SIGNAL(finished(int)),this, SLOT(f_hide_preview()));*/

    num_select = 0;

    src_open_file = 0;

    emit file_smile();
}

void Tetrahedron::f_load_image_for_sphere()
{
    myfileopen *hdlfopen = new myfileopen(this);
    hdlfopen->setDirectory(wg_path_images);
    hdlfopen->source = 1;
    num_select = 0;
    hdlfopen->setFileMode(QFileDialog::ExistingFiles);
    hdlfopen->setWindowTitle(tr("Diapositive"));
    hdlfopen->setFilter("(*.PNG *.png *.jpg *.JPG *.jeg *.JPEG)");
    hdlfopen->show();
    connect(hdlfopen, SIGNAL(change_image(QString)),this, SLOT(f_open_ipreview(QString)));
    connect(hdlfopen, SIGNAL(filesSelected( const QStringList )),this, SLOT(f_load_image_step_2_sphere( const QStringList )));
    connect(hdlfopen, SIGNAL(f_close()),this, SLOT(f_hide_preview()));
    connect(hdlfopen, SIGNAL(finished(int)),this, SLOT(f_hide_preview()));
}

void Tetrahedron::f_load_image_step_2_sphere( const QStringList wl_slmyfic)
{
    QString wl_myfic = wl_slmyfic.at(0);

    int i = wl_myfic.lastIndexOf( '/' );
    wg_path_images = wl_myfic.mid(0, i);

    QImage wl_img_texture;
    QImage wl_puis_001(sm_mxw,sm_mxw,QImage::Format_ARGB32_Premultiplied);

    QString wl_totpath = "";

    wl_myfic = wl_slmyfic.at(0);
    wl_totpath = wl_totpath + wl_myfic;
    if ( wl_img_texture.load(wl_myfic) == true )
    {
        /*if ( wl_img_texture.width() < wl_img_texture.height() )
        {
            wl_img_texture = wl_img_texture.scaledToWidth(sm_mxw,Qt::SmoothTransformation);
        }
        else
        {
            wl_img_texture = wl_img_texture.scaledToHeight(sm_mxw,Qt::SmoothTransformation);
        }*/

        wl_img_texture = wl_img_texture.scaled(sm_mxw,sm_mxw,Qt::IgnoreAspectRatio,Qt::FastTransformation);

        wl_puis_001 = wl_img_texture.copy ( 0, 0, sm_mxw, sm_mxw);

        QImage f = QGLWidget::convertToGLFormat( wl_puis_001 );

        glDeleteTextures (1,&texture_diapo[nombre_diapos+1]);
        glGenTextures (1,&texture_diapo[nombre_diapos+1]);
        glBindTexture (GL_TEXTURE_2D, texture_diapo[nombre_diapos+1]);

        glTexParameteri (GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR);
        glTexParameteri (GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR);

        glTexImage2D (GL_TEXTURE_2D, 0, GL_RGBA, f.width(), f.height(),
                      0, GL_RGBA, GL_UNSIGNED_BYTE, f.bits());
        //nombre_diapos++;
    }

    f_load_load_star_w(wl_totpath);
    //updateGL();
}

void Tetrahedron::f_load_image_for_cube()
{
    myfileopen *hdlfopen = new myfileopen(this);
    hdlfopen->setDirectory(wg_path_images);
    hdlfopen->source = 1;
    num_select = 0;
    hdlfopen->setFileMode(QFileDialog::ExistingFiles);
    hdlfopen->setWindowTitle(tr("Selectionner jusqu a 6 images pour votre cube"));
    hdlfopen->setFilter("(*.PNG *.png *.jpg *.JPG *.jeg *.JPEG)");
    hdlfopen->show();
    connect(hdlfopen, SIGNAL(change_image(QString)),this, SLOT(f_open_ipreview(QString)));
    connect(hdlfopen, SIGNAL(filesSelected( const QStringList )),this, SLOT(f_load_image_step_2_cube( const QStringList )));
    connect(hdlfopen, SIGNAL(f_close()),this, SLOT(f_hide_preview()));
    connect(hdlfopen, SIGNAL(finished(int)),this, SLOT(f_hide_preview()));
}

void Tetrahedron::f_load_image_for_cube_change()
{
    myfileopen *hdlfopen = new myfileopen(this);
    hdlfopen->setDirectory(wg_path_images);
    hdlfopen->source = 1;
    num_select = 0;
    hdlfopen->setFileMode(QFileDialog::ExistingFiles);
    hdlfopen->setWindowTitle(tr("Selectionner jusqu a 6 images pour votre cube"));
    hdlfopen->setFilter("(*.PNG *.png *.jpg *.JPG *.jeg *.JPEG)");
    hdlfopen->show();
    connect(hdlfopen, SIGNAL(change_image(QString)),this, SLOT(f_open_ipreview(QString)));
    connect(hdlfopen, SIGNAL(filesSelected( const QStringList )),this, SLOT(f_load_image_step_2_cube_change( const QStringList )));
    connect(hdlfopen, SIGNAL(f_close()),this, SLOT(f_hide_preview()));
    connect(hdlfopen, SIGNAL(finished(int)),this, SLOT(f_hide_preview()));
}

void Tetrahedron::f_load_image_step_2_cube( const QStringList wl_slmyfic)
{
    QString wl_myfic = wl_slmyfic.at(0);

    int i = wl_myfic.lastIndexOf( '/' );
    wg_path_images = wl_myfic.mid(0, i);

    QImage wl_img_texture;
    QImage wl_puis_001(sm_mxw,sm_mxw,QImage::Format_ARGB32_Premultiplied);
    int wl_int_001 = 0;

    QString wl_totpath = "";

    while ( wl_int_001 < wl_slmyfic.count() && wl_int_001 < 6 )
    {
        wl_myfic = wl_slmyfic.at(wl_int_001);
        wl_totpath = wl_totpath + wl_myfic + ")(";
        if ( wl_img_texture.load(wl_myfic) == true )
        {
            if ( wl_img_texture.width() < wl_img_texture.height() )
            {
                wl_img_texture = wl_img_texture.scaledToWidth(sm_mxw,Qt::SmoothTransformation);
            }
            else
            {
                wl_img_texture = wl_img_texture.scaledToHeight(sm_mxw,Qt::SmoothTransformation);
            }

            wl_puis_001 = wl_img_texture.copy ( 0, 0, sm_mxw, sm_mxw);

            QImage f = QGLWidget::convertToGLFormat( wl_puis_001 );

            glDeleteTextures (1,&texture_diapo_cube[wl_int_001]);
            glGenTextures (1,&texture_diapo_cube[wl_int_001]);
            glBindTexture (GL_TEXTURE_2D, texture_diapo_cube[wl_int_001]);

            glTexParameteri (GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR);
            glTexParameteri (GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR);

            glTexImage2D (GL_TEXTURE_2D, 0, GL_RGBA, f.width(), f.height(),
                          0, GL_RGBA, GL_UNSIGNED_BYTE, f.bits());
        }
        wl_int_001++;
    }

    while ( wl_int_001 < 6 )
    {
        QImage f = QGLWidget::convertToGLFormat( wl_puis_001 );

        glDeleteTextures (1,&texture_diapo_cube[wl_int_001]);
        glGenTextures (1,&texture_diapo_cube[wl_int_001]);
        glBindTexture (GL_TEXTURE_2D, texture_diapo_cube[wl_int_001]);

        glTexParameteri (GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR);
        glTexParameteri (GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR);

        glTexImage2D (GL_TEXTURE_2D, 0, GL_RGBA, f.width(), f.height(),
                      0, GL_RGBA, GL_UNSIGNED_BYTE, f.bits());

        wl_totpath = wl_totpath + wl_myfic + ")(";

        wl_int_001++;
    }

    f_load_cube(wl_totpath);
    //updateGL();
}

void Tetrahedron::f_load_image_step_2_cube_change( const QStringList wl_slmyfic)
{
    QString wl_myfic = wl_slmyfic.at(0);

    int i = wl_myfic.lastIndexOf( '/' );
    wg_path_images = wl_myfic.mid(0, i);

    QImage wl_img_texture;
    QImage wl_puis_001(sm_mxw,sm_mxw,QImage::Format_ARGB32_Premultiplied);
    int wl_int_001 = 0;

    QString wl_totpath = "";

    while ( wl_int_001 < wl_slmyfic.count() && wl_int_001 < 6 )
    {
        wl_myfic = wl_slmyfic.at(wl_int_001);
        wl_totpath = wl_totpath + wl_myfic + ")(";
        if ( wl_img_texture.load(wl_myfic) == true )
        {
            if ( wl_img_texture.width() < wl_img_texture.height() )
            {
                wl_img_texture = wl_img_texture.scaledToWidth(sm_mxw,Qt::SmoothTransformation);
            }
            else
            {
                wl_img_texture = wl_img_texture.scaledToHeight(sm_mxw,Qt::SmoothTransformation);
            }

            wl_puis_001 = wl_img_texture.copy ( 0, 0, sm_mxw, sm_mxw);

            QImage f = QGLWidget::convertToGLFormat( wl_puis_001 );

            glDeleteTextures (1,&texture_diapo_cube[wl_int_001]);
            glGenTextures (1,&texture_diapo_cube[wl_int_001]);
            glBindTexture (GL_TEXTURE_2D, texture_diapo_cube[wl_int_001]);

            glTexParameteri (GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR);
            glTexParameteri (GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR);

            glTexImage2D (GL_TEXTURE_2D, 0, GL_RGBA, f.width(), f.height(),
                          0, GL_RGBA, GL_UNSIGNED_BYTE, f.bits());
        }
        wl_int_001++;
    }

    while ( wl_int_001 < 6 )
    {
        QImage f = QGLWidget::convertToGLFormat( wl_puis_001 );

        glDeleteTextures (1,&texture_diapo_cube[wl_int_001]);
        glGenTextures (1,&texture_diapo_cube[wl_int_001]);
        glBindTexture (GL_TEXTURE_2D, texture_diapo_cube[wl_int_001]);

        glTexParameteri (GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR);
        glTexParameteri (GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR);

        glTexImage2D (GL_TEXTURE_2D, 0, GL_RGBA, f.width(), f.height(),
                      0, GL_RGBA, GL_UNSIGNED_BYTE, f.bits());

        wl_totpath = wl_totpath + wl_myfic + ")(";

        wl_int_001++;
    }

    tab_diapo[num_select+1][0] = "?6" + wl_totpath;                                // *** NOM DU FICHIER DIAPO ***;

    updateGL();
}

void Tetrahedron::f_dupliquer_image()
{
    int wl_int_001 = 0;

    while ( wl_int_001 < 9 )
    {
        tab_diapo[nombre_diapos+1][wl_int_001] = tab_diapo[num_select][wl_int_001];
        wl_int_001++;
    }

    wl_int_001 = 0;
    while ( wl_int_001 < 17 )
    {
        tab_coo[nombre_diapos+1][wl_int_001] = tab_coo[num_select][wl_int_001];
        wl_int_001++;
    }

    wl_int_001 = 0;
    while ( wl_int_001 < 20 )
    {
        tab_coo_timeline[nombre_diapos+1][wl_int_001] = tab_coo_timeline[num_select][wl_int_001];
        wl_int_001++;
    }

    nombre_diapos++;

    f_reload_img(nombre_diapos);

    emit add_diapo();
    updateGL();
}

void Tetrahedron::f_swap_image()
{
    /*myfileopen *hdlfopen = new myfileopen(this);
    hdlfopen->setDirectory(wg_path_images);
    hdlfopen->source = 1;
    hdlfopen->setWindowTitle(tr("Diapositive"));
    hdlfopen->setFilter("(*.PNG *.png *.jpg *.JPG *.jeg *.JPEG *.gif *.GIF *.avi *.AVI *.MPG *.mpg *.MPEG *.mpeg *.mp4 *.MP4)");
    connect(hdlfopen, SIGNAL(change_image(QString)),this, SLOT(f_open_ipreview(QString)));
    connect(hdlfopen, SIGNAL(filesSelected( const QStringList )),this, SLOT(f_load_image_step_2( const QStringList )));
    connect(hdlfopen, SIGNAL(f_close()),this, SLOT(f_hide_preview()));
    connect(hdlfopen, SIGNAL(finished(int)),this, SLOT(f_hide_preview()));
    hdlfopen->show();*/

    src_open_file = 1;

    emit file_smile();
}

void Tetrahedron::f_load_background_1()
{
    /*myfileopen *hdlfopen = new myfileopen(this);
    hdlfopen->setDirectory(wg_path_images);
    hdlfopen->source = 1;
    hdlfopen->setWindowTitle(tr("Image d'arriere plan"));
    hdlfopen->setFilter("(*.PNG *.png *.jpg *.JPG *.jeg *.JPEG *.avi *.AVI *.MPG *.mpg *.MPEG *.mpeg *.mp4 *.MP4)");
    connect(hdlfopen, SIGNAL(change_image(QString)),this, SLOT(f_open_ipreview(QString)));
    connect(hdlfopen, SIGNAL(filesSelected( const QStringList )),this, SLOT(f_load_background( const QStringList )));
    connect(hdlfopen, SIGNAL(f_close()),this, SLOT(f_hide_preview()));
    connect(hdlfopen, SIGNAL(finished(int)),this, SLOT(f_hide_preview()));
    hdlfopen->show();*/

    src_open_file = 2;

    emit file_smile();
}

void Tetrahedron::f_load_background( const QStringList wl_slmyfic)
{
    QString wl_myfic = wl_slmyfic.at(0);

    int i = wl_myfic.lastIndexOf( '/' );
    wg_path_images = wl_myfic.mid(0, i);

    QImage wl_img_texture;

    if ( back_color.right(4) == ".avi" || back_color.right(4) == ".AVI" || back_color.right(4) == ".mpg" || back_color.right(4) == ".MPG" || back_color.right(5) == ".MPEG" || back_color.right(5) == ".mpeg" || back_color.right(4) == ".mp4" || back_color.right(4) == ".MP4" )
    {
        wg_tabvid[20]->delete_videowrapper();
        delete wg_tabvid[20];
        wg_tabvid[20] = 0;
    }

    if ( wl_img_texture.load(wl_myfic) == true )
    {
        if ( wl_img_texture.width() > wl_img_texture.height() )
        {
            wl_img_texture = wl_img_texture.scaledToWidth(sm_mxw,Qt::SmoothTransformation);
        }
        else
        {
            wl_img_texture = wl_img_texture.scaledToHeight(sm_mxw,Qt::SmoothTransformation);
        }

        QImage wl_puis_001(sm_mxw,sm_mxw,QImage::Format_ARGB32_Premultiplied);
        wl_puis_001 = wl_img_texture.copy ( 0, 0, sm_mxw, sm_mxw);

        wg_fd_tx = (float)wl_img_texture.width()/(float)sm_mxw;
        wg_fd_ty = (float)wl_img_texture.height()/(float)sm_mxw;

        QImage f = QGLWidget::convertToGLFormat( wl_puis_001 );

        glDeleteTextures (1,&texture_diapo[41]);
        glGenTextures (1,&texture_diapo[41]);
        glBindTexture (GL_TEXTURE_2D, texture_diapo[41]);

        glTexParameteri (GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR);
        glTexParameteri (GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR);

        glTexImage2D (GL_TEXTURE_2D, 0, GL_RGBA, f.width(), f.height(),
                      0, GL_RGBA, GL_UNSIGNED_BYTE, f.bits());

        isback = 1;
        back_color = wl_myfic;
        updateGL();
        //emit update_preview();
    }
    else
    {
        if ( wl_myfic.right(4) == ".avi" || wl_myfic.right(4) == ".AVI" || wl_myfic.right(4) == ".mpg" || wl_myfic.right(4) == ".MPG" || wl_myfic.right(5) == ".MPEG" || wl_myfic.right(5) == ".mpeg" || wl_myfic.right(4) == ".mp4" || wl_myfic.right(4) == ".MP4" )
        {
            videowrapper *hdlw = new videowrapper();
            wg_tabvid[20] = hdlw;

            int result = hdlw->load_video(wl_myfic);
            if ( result == 0 )
            {
                wl_img_texture = hdlw->read_frame(0);
                QImage wl_puis_001(sm_mxw,sm_mxw,QImage::Format_ARGB32_Premultiplied);

                if ( wl_img_texture.width() > wl_img_texture.height() )
                {
                    wl_img_texture = wl_img_texture.scaledToWidth(sm_mxw,Qt::SmoothTransformation);
                }
                else
                {
                    wl_img_texture = wl_img_texture.scaledToHeight(sm_mxw,Qt::SmoothTransformation);
                }

                wl_puis_001 = wl_img_texture.copy ( 0, 0, sm_mxw, sm_mxw); //sm_mxw, sm_mxw);

                wg_fd_tx = (float)wl_img_texture.width()/(float)sm_mxw;
                wg_fd_ty = (float)wl_img_texture.height()/(float)sm_mxw;

                QImage f = QGLWidget::convertToGLFormat( wl_puis_001 );

                glDeleteTextures (1,&texture_diapo[41]);
                glGenTextures (1,&texture_diapo[41]);
                glBindTexture (GL_TEXTURE_2D, texture_diapo[41]);

                glTexParameteri (GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR);
                glTexParameteri (GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR);

                glTexImage2D (GL_TEXTURE_2D, 0, GL_RGBA, f.width(), f.height(),
                              0, GL_RGBA, GL_UNSIGNED_BYTE, f.bits());

                isback = 1;
                back_color = wl_myfic;
                updateGL();
                //emit update_preview();
           }
        }
    }
}


void Tetrahedron::f_hide_preview()
{
    emit hide_preview();
}

int Tetrahedron::f_load_exif(QString wl_ig)
{
    //int sens = 0;
    wg_string_003 = "";

    QFile wmyficext;
    QTextStream outext(&wmyficext);

    wmyficext.setFileName(QDir::homePath() + "/.mdvexif.sh");
    wmyficext.open( QIODevice::WriteOnly );
    outext << "export LANG=en_EN.utf-8" << endl;
    outext << "exif -t 0x0112 " + wl_ig << endl;
    outext << "exit" << endl;
    wmyficext.close();
    QString programf = "bash";
    QStringList argumentsf;
    argumentsf << QDir::homePath() + "/.mdvexif.sh";

    proc_ffmpeg.setProcessChannelMode(QProcess::MergedChannels);
    proc_ffmpeg.start(programf,argumentsf);

    proc_ffmpeg.waitForFinished(-1);
    QByteArray buffer(proc_ffmpeg.readAllStandardOutput());
    wg_string_003 = wg_string_003 + buffer;

    int wl_int_001 =  wg_string_003.lastIndexOf( "left - bottom", -1, Qt::CaseInsensitive );
    if ( wl_int_001 > -1 )
    {
        //sens = 1;
        return 1;
    }

    wl_int_001 =  wg_string_003.lastIndexOf( "right - top", -1, Qt::CaseInsensitive );
    if ( wl_int_001 > -1 )
    {
        //sens = 2;
        return 2;
    }
    return 0;
    //return sens;
}

void Tetrahedron::f_read_ffmpeg()
{
        QByteArray buffer(proc_ffmpeg.readAllStandardOutput());
        wg_string_003 = wg_string_003 + buffer;
}

void Tetrahedron::f_load_image_step_2(const QStringList wl_slmyfic)
{
    int wl_int_001 = 0;
    QString wl_myfic;
    QImage wl_img_texture;
    QImage f;
    int i;

    wl_myfic = wl_slmyfic.at(wl_int_001);

    i = wl_myfic.lastIndexOf( '/' );
    if ( i >= 0 )
    {
        wg_path_images = wl_myfic.mid(0, i);
    }

    while ( wl_int_001 < wl_slmyfic.count() && nombre_diapos+1 < 20 )
    {
        if ( wl_int_001 > 0 ) // *** PIEGE POUR IMPORT MULTIPLE DE PHOTOS ***
        {
            num_select = 0;
        }
        wl_myfic = wl_slmyfic.at(wl_int_001);

        QImageReader image_reader(wl_myfic);
        int image_width = image_reader.size().width();
        int image_height = image_reader.size().height();
        int isok = image_width;

        if (image_width > image_height) {
                  image_height = static_cast<double>(sm_mxw) / image_width * image_height;
                  image_width = sm_mxw;
                } else if (image_width < image_height) {
                  image_width = static_cast<double>(sm_mxw) / image_height * image_width;
                  image_height = sm_mxw;
                } else {
                  image_width = sm_mxw;
                  image_height = sm_mxw;
                }
                image_reader.setScaledSize(QSize(image_width, image_height));
                wl_img_texture = image_reader.read();

        //if ( wl_img_texture.load(wl_myfic) == true )
        if ( isok > 0 )
        {
            if ( num_select == 0 ) // *** NOUVELLE DIAPOSITIVE ***
            {
                // *** CHARGEMENT DE LA TEXTURE ***
                QImage wl_puis_001(sm_mxw,sm_mxw,QImage::Format_ARGB32_Premultiplied);

                /*if ( wl_img_texture.width() > wl_img_texture.height() )
                {
                    wl_img_texture = wl_img_texture.scaledToWidth(sm_mxw,Qt::SmoothTransformation);
                }
                else
                {
                    wl_img_texture = wl_img_texture.scaledToHeight(sm_mxw,Qt::SmoothTransformation);
                }*/

                wl_puis_001 = wl_img_texture.copy ( 0, 0, sm_mxw, sm_mxw);

                wg_table_photo[nombre_diapos+1] = wl_puis_001;

                f_init_coo_one_slide(nombre_diapos+1);

                int sens = f_load_exif(wl_myfic);

                tab_diapo[nombre_diapos+1][0] = wl_myfic;                                         // *** NOM DU FICHIER DIAPO ***
                tab_diapo[nombre_diapos+1][1] = QString::number(wl_img_texture.width());          // *** LARGEUR DE LA TEXTURE ***
                tab_diapo[nombre_diapos+1][2] = QString::number(wl_img_texture.height());         // *** HAUTEUR DE LA TEXTURE ***
                tab_diapo[nombre_diapos+1][3] = "";
                tab_diapo[nombre_diapos+1][4] = "0:255";                                            // *** LUMIERE ET CONTRASTE ***
                tab_diapo[nombre_diapos+1][5] = "1.0";                                            // *** SCALE FACTOR ***
                tab_diapo[nombre_diapos+1][6] = "0";                                              // *** REFLECT ***
                tab_diapo[nombre_diapos+1][7] = "0/0/0/0";                                        // *** CROP ***
                tab_diapo[nombre_diapos+1][8] = QString::number(sens);                            // *** ORIENTATION EXIF ***

                tab_coo[nombre_diapos+1][0] = 0.0;      // *** X ***
                tab_coo[nombre_diapos+1][1] = 0.0;      // *** Y ***
                tab_coo[nombre_diapos+1][2] = -3.8;     // *** Z ***
                tab_coo[nombre_diapos+1][3] = 100.0;      // *** IMGX ***
                tab_coo[nombre_diapos+1][4] = 100.0;      // *** IMGY ***
                tab_coo[nombre_diapos+1][5] = 0.0;      // *** ROTATE X ***               
                tab_coo[nombre_diapos+1][6] = 0.0;      // *** ROTATE Y ***
                tab_coo[nombre_diapos+1][7] = 0.0;      // *** ROTATE Z ***
                tab_coo[nombre_diapos+1][8] = 110;       // *** VISIBILITE ***
                tab_coo[nombre_diapos+1][9] = 0.0;      // *** TRANSPARENCE ***
                tab_coo[nombre_diapos+1][10] = 0.0;     // *** BLUR ***
                tab_coo[nombre_diapos+1][11] = 0;      // *** TRANS DIAPO ***
                tab_coo[nombre_diapos+1][12] = 255;      // *** RED ***
                tab_coo[nombre_diapos+1][13] = 255;      // *** GREEN ***
                tab_coo[nombre_diapos+1][14] = 255;      // *** BLUE ***
                tab_coo[nombre_diapos+1][15] = 100.0;      // *** IMG X ***
                tab_coo[nombre_diapos+1][16] = 100.0;      // *** IMG Y ***

                tab_coo_timeline[nombre_diapos+1][0] = "10:0.0:0.0:-3.8:0.0:0.0:0.0:110:0:0:255:255:255:100:100:100:100";
                tab_coo_timeline[nombre_diapos+1][1] = "690:0.0:0.0:-3.8:0.0:0.0:0.0:110:0:0:255:255:255:100:100:100:100";

                f = QGLWidget::convertToGLFormat( wl_puis_001 );

                glDeleteTextures (1,&texture_diapo[nombre_diapos+1]);
                glGenTextures (1,&texture_diapo[nombre_diapos+1]);
                glBindTexture (GL_TEXTURE_2D, texture_diapo[nombre_diapos+1]);

                glTexParameteri (GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR);
                glTexParameteri (GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR);

                glTexImage2D (GL_TEXTURE_2D, 0, GL_RGBA, f.width(), f.height(),
                              0, GL_RGBA, GL_UNSIGNED_BYTE, f.bits());

                if ( wl_myfic.right(4) == ".gif" || wl_myfic.right(4) == ".GIF" )
                {
                    tabgif[nombre_diapos+1].setFileName(wl_myfic);
                    tabgif[nombre_diapos+1].setCacheMode( QMovie::CacheAll );
                    tabgif[nombre_diapos+1].jumpToFrame( 0 );
                }

                nombre_diapos++;
                //f_follow_timeline(position_timeline);

                emit add_diapo();
            }
            else // *** CHANGEMENT DE TEXTURE ***
            {
                // *** CHARGEMENT DE LA TEXTURE ***
                glDeleteTextures(1, &texture_diapo[num_select] );
                QImage wl_puis_001(sm_mxw,sm_mxw,QImage::Format_ARGB32_Premultiplied);

                if ( wl_img_texture.width() > wl_img_texture.height() )
                {
                    wl_img_texture = wl_img_texture.scaledToWidth(sm_mxw,Qt::SmoothTransformation);
                }
                else
                {
                    wl_img_texture = wl_img_texture.scaledToHeight(sm_mxw,Qt::SmoothTransformation);
                }
                wl_img_texture = wl_img_texture.convertToFormat ( QImage::Format_ARGB32, Qt::AutoColor );

                QStringList wg_str_001 = tab_diapo[num_select][4].split(":",QString::SkipEmptyParts);

                if ( wg_str_001.at(0).toInt() != 0 || wg_str_001.at(1).toInt() != 255 )
                {
                    wg_img_smile_effect = wl_img_texture;
                    f_effect_run(wg_str_001.at(0).toInt(), wg_str_001.at(1).toInt());
                    wl_img_texture = wg_img_smile_effect;
                }

                if ( tab_diapo[num_select][3] != "" )
                {
                    QStringList wl_explode = tab_diapo[num_select][3].split("%*",QString::KeepEmptyParts);

                    QImage wl_image_2(QDir::homePath() + "/.2ManDVD_Library/" +"/Bibliotheque/Masks/"+wl_explode.at(0)+".png");
                    wl_image_2 = wl_image_2.scaled(wl_img_texture.width(), wl_img_texture.height());
                    wl_image_2 = wl_image_2.convertToFormat ( QImage::Format_ARGB32, Qt::AutoColor ); //_Premultiplied

                    QPainter g;

                    QPainter::CompositionMode mode = (QPainter::CompositionMode)6;

                    g.begin(&wl_img_texture);
                    g.setCompositionMode ( mode );
                    g.drawImage(QRect(0,0,-1,-1),wl_image_2);

                    QString wl_str_001 = QDir::homePath() + "/.2ManDVD_Library/"  + "/Bibliotheque/Masks/2t_" + wl_explode.at(0) + ".png";
                    QImage wl_over_mask;

                    if ( wl_over_mask.load(wl_str_001) == true )
                    {
                        wl_over_mask = wl_over_mask.scaled(wl_img_texture.width(), wl_img_texture.height());
                        wl_over_mask = f_mutation_overmask( wl_over_mask, wl_explode.at(1) + "%*" + wl_explode.at(2) + "%*" + wl_explode.at(3) + "%*" + wl_explode.at(4) );
                        wl_over_mask = wl_over_mask.convertToFormat ( QImage::Format_ARGB32, Qt::AutoColor ); //_Premultiplied
                        g.setCompositionMode ( (QPainter::CompositionMode)0 );
                        g.drawImage(QRect(0,0,-1,-1),wl_over_mask);
                    }

                    g.end();
                }

                if ( tab_coo[num_select][10] > 0 )
                {
                    wl_img_texture = blur_shadow(wl_img_texture, tab_coo[num_select][10]);
                }

                wl_puis_001 = wl_img_texture.copy ( 0, 0, sm_mxw, sm_mxw);
                wg_table_photo[num_select] = wl_puis_001;

                int sens = f_load_exif(wl_myfic);

                tab_diapo[num_select][0] = wl_myfic;                                         // *** NOM DU FICHIER DIAPO ***
                tab_diapo[num_select][1] = QString::number(wl_img_texture.width());          // *** LARGEUR DE LA TEXTURE ***
                tab_diapo[num_select][2] = QString::number(wl_img_texture.height());         // *** HAUTEUR DE LA TEXTURE ***
                //tab_diapo[num_select][4] = "0:255";
                tab_diapo[num_select][7] = "0/0/0/0";                                        // *** CROP ***
                tab_diapo[num_select][8] = QString::number(sens);                            // *** ORIENTATION EXIF ***

                QImage f = QGLWidget::convertToGLFormat( wl_puis_001 );

                glDeleteTextures (1,&texture_diapo[num_select]);
                glGenTextures (1,&texture_diapo[num_select]);
                glBindTexture (GL_TEXTURE_2D, texture_diapo[num_select]);

                glTexParameteri (GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR);
                glTexParameteri (GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR);

                glTexImage2D (GL_TEXTURE_2D, 0, GL_RGBA, f.width(), f.height(),
                              0, GL_RGBA, GL_UNSIGNED_BYTE, f.bits());

                if ( wl_myfic.right(4) == ".gif" || wl_myfic.right(4) == ".GIF" )
                {
                    tabgif[num_select].setFileName(wl_myfic);
                    tabgif[num_select].setCacheMode( QMovie::CacheAll );
                    tabgif[num_select].jumpToFrame( 0 );
                }
                emit update_diapo();
            }
        }
        else
        {
            // *** C EST PEUT ETRE UNE VIDEO ***
            if ( wl_myfic.right(4) == ".avi" || wl_myfic.right(4) == ".AVI" || wl_myfic.right(4) == ".mpg" || wl_myfic.right(4) == ".MPG" || wl_myfic.right(5) == ".MPEG" || wl_myfic.right(5) == ".mpeg" || wl_myfic.right(4) == ".mp4" || wl_myfic.right(4) == ".MP4" )
            {
                if ( num_select == 0 ) // *** NOUVELLE DIAPOSITIVE ***
                {
                    videowrapper *hdlw = new videowrapper();
                    wg_tabvid[nombre_diapos+1] = hdlw;

                    int result = hdlw->load_video(wl_myfic);

                    if ( result == 0 )
                    {
                        wl_img_texture = hdlw->read_frame(0);
                        QImage wl_puis_001(sm_mxw,sm_mxw,QImage::Format_ARGB32_Premultiplied);
                        if ( wl_img_texture.width() > wl_img_texture.height() )
                        {
                            wl_img_texture = wl_img_texture.scaledToWidth(sm_mxw,Qt::SmoothTransformation);
                        }
                        else
                        {
                            wl_img_texture = wl_img_texture.scaledToHeight(sm_mxw,Qt::SmoothTransformation);
                        }

                        wl_puis_001 = wl_img_texture.copy ( 0, 0, sm_mxw, sm_mxw); //sm_mxw, sm_mxw);
                        wg_table_photo[nombre_diapos+1] = wl_puis_001;

                        f_init_coo_one_slide(nombre_diapos+1);
                        tab_diapo[nombre_diapos+1][0] = wl_myfic;                                         // *** NOM DU FICHIER DIAPO ***
                        tab_diapo[nombre_diapos+1][1] = QString::number(wl_img_texture.width());          // *** LARGEUR DE LA TEXTURE ***
                        tab_diapo[nombre_diapos+1][2] = QString::number(wl_img_texture.height());         // *** HAUTEUR DE LA TEXTURE ***
                        tab_diapo[nombre_diapos+1][3] = "";
                        tab_diapo[nombre_diapos+1][4] = "0:255";                                            // *** LUMIERE ET CONTRASTE ***
                        tab_diapo[nombre_diapos+1][5] = "1.0";                                            // *** SCALE FACTOR ***
                        tab_diapo[nombre_diapos+1][6] = "0";                                              // *** REFLECT ***
                        tab_diapo[nombre_diapos+1][7] = "0/0/0/0";                                        // *** CROP ***
                        tab_diapo[nombre_diapos+1][8] = "0"                  ;                            // *** ORIENTATION EXIF ***

                        tab_coo[nombre_diapos+1][0] = 0.0;      // *** X ***
                        tab_coo[nombre_diapos+1][1] = 0.0;      // *** Y ***
                        tab_coo[nombre_diapos+1][2] = -3.8;     // *** Z ***
                        tab_coo[nombre_diapos+1][3] = 100.0;      // *** IMGX ***
                        tab_coo[nombre_diapos+1][4] = 100.0;      // *** IMGY ***
                        tab_coo[nombre_diapos+1][5] = 0.0;      // *** ROTATE X ***
                        tab_coo[nombre_diapos+1][6] = 0.0;      // *** ROTATE Y ***
                        tab_coo[nombre_diapos+1][7] = 0.0;      // *** ROTATE Z ***
                        tab_coo[nombre_diapos+1][8] = 110;       // *** VISIBILITE ***
                        tab_coo[nombre_diapos+1][9] = 0.0;      // *** TRANSPARENCE ***
                        tab_coo[nombre_diapos+1][10] = 0.0;     // *** BLUR ***
                        tab_coo[nombre_diapos+1][11] = 0;      // *** TRANS DIAPO ***
                        tab_coo[nombre_diapos+1][12] = 255;      // *** RED ***
                        tab_coo[nombre_diapos+1][13] = 255;      // *** GREEN ***
                        tab_coo[nombre_diapos+1][14] = 255;      // *** BLUE ***
                        tab_coo[nombre_diapos+1][15] = 100.0;      // *** IMG X ***
                        tab_coo[nombre_diapos+1][16] = 100.0;      // *** IMG Y ***

                        tab_coo_timeline[nombre_diapos+1][0] = "10:0.0:0.0:-3.8:0.0:0.0:0.0:110:0:0:255:255:255:100:100:100:100";
                        tab_coo_timeline[nombre_diapos+1][1] = "690:0.0:0.0:-3.8:0.0:0.0:0.0:110:0:0:255:255:255:100:100:100:100";

                        f = QGLWidget::convertToGLFormat( wl_puis_001 );

                        glDeleteTextures (1,&texture_diapo[nombre_diapos+1]);
                        glGenTextures (1,&texture_diapo[nombre_diapos+1]);
                        glBindTexture (GL_TEXTURE_2D, texture_diapo[nombre_diapos+1]);

                        glTexParameteri (GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR);
                        glTexParameteri (GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR);

                        glTexImage2D (GL_TEXTURE_2D, 0, GL_RGBA, f.width(), f.height(),
                                      0, GL_RGBA, GL_UNSIGNED_BYTE, f.bits());

                        nombre_diapos++;

                        f_follow_timeline(position_timeline);

                        emit update_preview();

                        emit add_diapo();

                    }
                    else
                    {
                        qDebug() << "ERROR LOADING VIDEO : " << wl_myfic;
                    }
                }
                else
                {
                    // *** CHARGEMENT DE LA TEXTURE ***
                    glDeleteTextures(1, &texture_diapo[num_select] );

                    if ( tab_diapo[num_select][0].right(4) == ".avi" || tab_diapo[num_select][0].right(4) == ".AVI" || tab_diapo[num_select][0].right(4) == ".mpg" || tab_diapo[num_select][0].right(4) == ".MPG" || tab_diapo[num_select][0].right(5) == ".MPEG" || tab_diapo[num_select][0].right(5) == ".mpeg" || tab_diapo[num_select][0].right(4) == ".mp4" || tab_diapo[num_select][0].right(4) == ".MP4" )
                    {
                        wg_tabvid[num_select]->delete_videowrapper();
                        delete wg_tabvid[num_select];
                    }

                    videowrapper *hdlw = new videowrapper();
                    wg_tabvid[num_select] = hdlw;

                    int result = hdlw->load_video(wl_myfic);
                    if ( result == 0 )
                    {
                        wl_img_texture = hdlw->read_frame(0);

                        tab_diapo[num_select][0] = wl_myfic;                                         // *** NOM DU FICHIER DIAPO ***
                        tab_diapo[num_select][4] = "0:255";
                        tab_diapo[num_select][7] = "0/0/0/0";                                        // *** CROP ***
                        tab_diapo[num_select][8] = "0";                                              // *** ORIENTATION EXIF ***

                        QImage wl_puis_001(sm_mxw,sm_mxw,QImage::Format_ARGB32_Premultiplied);

                        if ( wl_img_texture.width() > wl_img_texture.height() )
                        {
                            wl_img_texture = wl_img_texture.scaledToWidth(sm_mxw,Qt::SmoothTransformation);
                        }
                        else
                        {
                            wl_img_texture = wl_img_texture.scaledToHeight(sm_mxw,Qt::SmoothTransformation);
                        }
                        tab_diapo[num_select][1] = QString::number(wl_img_texture.width());          // *** LARGEUR DE LA TEXTURE ***
                        tab_diapo[num_select][2] = QString::number(wl_img_texture.height());         // *** HAUTEUR DE LA TEXTURE ***
                        wl_puis_001 = wl_img_texture.copy ( 0, 0, sm_mxw, sm_mxw); //sm_mxw, sm_mxw);

                        wl_img_texture = wl_puis_001;

                        QStringList wg_str_001 = tab_diapo[num_select][4].split(":",QString::SkipEmptyParts);

                        if ( wg_str_001.at(0).toInt() != 0 || wg_str_001.at(1).toInt() != 255 )
                        {
                            wg_img_smile_effect = wl_img_texture;
                            f_effect_run(wg_str_001.at(0).toInt(), wg_str_001.at(1).toInt());
                            wl_img_texture = wg_img_smile_effect;
                        }

                        if ( tab_diapo[num_select][3] != "" )
                        {
                            QStringList wl_explode = tab_diapo[num_select][3].split("%*",QString::KeepEmptyParts);

                            QImage wl_image_2(QDir::homePath() + "/.2ManDVD_Library/" +"/Bibliotheque/Masks/"+wl_explode.at(0)+".png");
                            wl_image_2 = wl_image_2.scaled(sm_mxw, sm_mxw);
                            wl_image_2 = wl_image_2.convertToFormat ( QImage::Format_ARGB32, Qt::AutoColor ); //_Premultiplied

                            QPainter g;

                            QPainter::CompositionMode mode = (QPainter::CompositionMode)6;

                            g.begin(&wl_img_texture);
                            g.setCompositionMode ( mode );
                            g.drawImage(QRect(0,0,-1,-1),wl_image_2);

                            QString wl_str_001 = QDir::homePath() + "/.2ManDVD_Library/"  + "/Bibliotheque/Masks/2t_" + wl_explode.at(0) + ".png";
                            QImage wl_over_mask;

                            if ( wl_over_mask.load(wl_str_001) == true )
                            {
                                wl_over_mask = wl_over_mask.scaled(sm_mxw, sm_mxw);
                                wl_over_mask = f_mutation_overmask( wl_over_mask, wl_explode.at(1) + "%*" + wl_explode.at(2) + "%*" + wl_explode.at(3) + "%*" + wl_explode.at(4) );
                                wl_over_mask = wl_over_mask.convertToFormat ( QImage::Format_ARGB32, Qt::AutoColor ); //_Premultiplied
                                g.setCompositionMode ( (QPainter::CompositionMode)0 );
                                g.drawImage(QRect(0,0,-1,-1),wl_over_mask);
                            }

                            g.end();
                        }

                        if ( tab_coo[num_select][10] > 0 )
                        {
                            wl_img_texture = blur_shadow(wl_img_texture, tab_coo[num_select][10]);
                        }

                        wl_puis_001 = wl_img_texture.copy ( 0, 0, sm_mxw, sm_mxw);
                        wg_table_photo[num_select] = wl_puis_001;

                        QImage f = QGLWidget::convertToGLFormat( wl_puis_001 );

                        glDeleteTextures (1,&texture_diapo[num_select]);
                        glGenTextures (1,&texture_diapo[num_select]);
                        glBindTexture (GL_TEXTURE_2D, texture_diapo[num_select]);

                        glTexParameteri (GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR);
                        glTexParameteri (GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR);

                        glTexImage2D (GL_TEXTURE_2D, 0, GL_RGBA, f.width(), f.height(),
                                      0, GL_RGBA, GL_UNSIGNED_BYTE, f.bits());

                        emit update_diapo();
                    }
                }
            }
        }
        wl_int_001++;
    }

    emit update_preview();
    emit hide_preview();

    if ( nombre_diapos+1 >= 20 )
    {
        QMessageBox::information(this, name_application, tr("Nombre maximum de photos par diapositive atteint"));
    }
}

void Tetrahedron::f_open_ipreview(QString wlfile)
{
    emit dia_of_preview(wlfile);
}

//

void Tetrahedron::initializeGL()
{
    qglClearColor(Qt::black);
    glClearAccum(0.0, 0.0, 0.0, 1.0);
    glClear(GL_DEPTH_BUFFER_BIT|GL_COLOR_BUFFER_BIT);

    glEnable( GL_DEPTH_TEST );
    glDisable( GL_NORMALIZE );
    glDisable( GL_DITHER );
    //glDisable( GL_SMOOTH );
    //
    glShadeModel(GL_FLAT);
    glEnable( GL_ALPHA_TEST );
    glEnable( GL_BLEND );
    glDisable( GL_STENCIL_TEST );

    glDisable(GL_FOG);
    glDepthMask(GL_FALSE);
    glAlphaFunc(GL_GREATER, 0.0f);

    glEnable( GL_COLOR_MATERIAL );

    //glEnable(GL_MULTISAMPLE_ARB);
    //glHint(GL_SAMPLE_BUFFERS_ARB,1);
    //glDisable(GL_POINT_SMOOTH);
    //glDisable(GL_LINE_SMOOTH);

    glEnable( GL_SMOOTH );
    glEnable(GL_LINE_SMOOTH);
    glHint(GL_LINE_SMOOTH_HINT, GL_FASTEST);
    glEnable(GL_POINT_SMOOTH);
    glHint(GL_POINT_SMOOTH_HINT, GL_NICEST);
    //glEnable(GL_POLYGON_SMOOTH);
    glHint(GL_POLYGON_SMOOTH_HINT, GL_DONT_CARE);

    glHint(GL_PERSPECTIVE_CORRECTION_HINT, GL_NICEST);
    glHint(GL_TEXTURE_COMPRESSION_HINT, GL_NICEST);
    glHint(GL_FRAGMENT_SHADER_DERIVATIVE_HINT, GL_NICEST);

    //qglClearColor(Qt::black);

    glMatrixMode(GL_MODELVIEW);
    glEnable(GL_TEXTURE_2D);
    //glEnable(GL_MULTISAMPLE);


    // *** CHARGEMENT TEXTURE SELECTION ***
    glDeleteTextures(1, &texture_diapo[42] );
    QImage wl_puis_001(128,128,QImage::Format_ARGB32_Premultiplied);
    QImage wl_img_texture(":/Interface/Interface/edition.png");

    wl_puis_001 = wl_img_texture.copy ( 0, 0, sm_mxw, sm_mxw);

    QPainter p;
    p.begin(&wl_puis_001);

    QPen pen;

    pen.setStyle(Qt::DashDotLine);
    pen.setWidth(1);
    pen.setBrush(QColor(255,0,0));
    pen.setCapStyle(Qt::RoundCap);
    pen.setJoinStyle(Qt::RoundJoin);

    p.setPen(pen);
    p.drawRect(0,0,wl_puis_001.width()-1,wl_puis_001.height()-1);
    p.end();

    QImage f = QGLWidget::convertToGLFormat( wl_puis_001 );

    glDeleteTextures (1,&texture_diapo[42]);
    glGenTextures (1,&texture_diapo[42]);
    glBindTexture (GL_TEXTURE_2D, texture_diapo[42]);

    glTexParameteri (GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR);
    glTexParameteri (GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR);

    glTexImage2D (GL_TEXTURE_2D, 0, GL_RGBA, f.width(), f.height(),
                  0, GL_RGBA, GL_UNSIGNED_BYTE, f.bits());


    // *** CHARGEMENT TEXTURE POUR EARTH ***
    glDeleteTextures(1, &texture_diapo[44] );
    QImage wl_puis_003(sm_mxw,sm_mxw,QImage::Format_ARGB32_Premultiplied);
    wl_img_texture.load(":/Interface/Interface/EarthMap.jpg");
    wl_img_texture = wl_img_texture.scaled(sm_mxw,sm_mxw,Qt::IgnoreAspectRatio);

    wl_puis_003 = wl_img_texture.copy ( 0, 0, sm_mxw, sm_mxw);

    f = QGLWidget::convertToGLFormat( wl_puis_003 );

    glDeleteTextures (1,&texture_diapo[44]);
    glGenTextures (1,&texture_diapo[44]);
    glBindTexture (GL_TEXTURE_2D, texture_diapo[44]);

    glTexParameteri (GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR);
    glTexParameteri (GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR);

    glTexImage2D (GL_TEXTURE_2D, 0, GL_RGBA, f.width(), f.height(),
                  0, GL_RGBA, GL_UNSIGNED_BYTE, f.bits());

    // *** CHARGEMENT TEXTURE POUR SNOW ***
    glDeleteTextures(1, &texture_diapo[45] );
    QImage wl_puis_004(sm_mxw,sm_mxw,QImage::Format_ARGB32_Premultiplied);
    wl_img_texture.load(":/Interface/Interface/snow.png");
    wl_img_texture = wl_img_texture.scaled(sm_mxw,sm_mxw,Qt::IgnoreAspectRatio);

    wl_puis_004 = wl_img_texture.copy ( 0, 0, sm_mxw, sm_mxw);

    f = QGLWidget::convertToGLFormat( wl_puis_004 );

    glDeleteTextures (1,&texture_diapo[45]);
    glGenTextures (1,&texture_diapo[45]);
    glBindTexture (GL_TEXTURE_2D, texture_diapo[45]);

    glTexParameteri (GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR);
    glTexParameteri (GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR);

    glTexImage2D (GL_TEXTURE_2D, 0, GL_RGBA, f.width(), f.height(),
                  0, GL_RGBA, GL_UNSIGNED_BYTE, f.bits());
}

/*void Tetrahedron::quality_high()
{
        glEnable( GL_SMOOTH );


        glEnable(GL_LINE_SMOOTH);
        glHint(GL_LINE_SMOOTH_HINT, GL_FASTEST);

        glEnable(GL_POINT_SMOOTH);
        glHint(GL_POINT_SMOOTH_HINT, GL_NICEST);

        glEnable(GL_POLYGON_SMOOTH);
        glHint(GL_POLYGON_SMOOTH_HINT, GL_DONT_CARE);

        wg_niv_qual = 1;
}*/

void Tetrahedron::resizeGL(int width, int height)
{
        glViewport(0, 0, width, height);
        glMatrixMode(GL_PROJECTION);
        glLoadIdentity();
        GLfloat szx = GLfloat(width) / GLfloat(height);
        glFrustum(-szx, szx, -1.0, 1.0, 1.9, 30.1);
        glMatrixMode(GL_MODELVIEW);
}

void Tetrahedron::paintGL()
{
        //glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
    	draw();
}

void Tetrahedron::mousePressEvent(QMouseEvent *event)
{
        int x,y;
        x = event->x();
        y = event->y();

        glDisable(GL_TEXTURE_2D);
        glDisable(GL_DITHER);
        if ( is_fog > 0 )
        {
            glDisable(GL_FOG);
        }

        draw_select();

        glEnable(GL_TEXTURE_2D);
        glEnable(GL_DITHER);
        if ( is_fog > 0 )
        {
            glEnable (GL_FOG);
        }

        GLint viewport[4];
        GLubyte pixel[3];

        glGetIntegerv(GL_VIEWPORT,viewport);

        glReadPixels(x,viewport[3]-y,1,1,GL_RGB,GL_UNSIGNED_BYTE,(void *)pixel);

        num_select = (pixel[0]-10)/10;

        if ( num_select > 0 )
        {
            emit dia_select(num_select);
        }
        else
        {
            num_select = 0;
            emit dia_select(num_select);
        }

        emit update_coo();
        lastPos = event->pos();
        updateGL();
}

void Tetrahedron::mouseMoveEvent(QMouseEvent *event)
{
        if ( tool == 0 )
        {
            if (event->buttons() & Qt::LeftButton)
            {
                GLfloat dx;
                GLfloat dy;

                if ( wg_has_mx == 0 && wg_has_my == 0 && wg_has_mz == 0 )
                {
                    dx = GLfloat(event->x() - lastPos.x()) / width();
                    dy = GLfloat(event->y() - lastPos.y()) / height();
                }
                else
                {
                    if ( wg_has_mx == 1 )
                    {
                        dx = GLfloat(event->x() - lastPos.x()) / width();
                        dy = GLfloat(lastPos.y()/ height());
                    }
                    else
                    {
                        if ( wg_has_my == 1 )
                        {
                            dy = GLfloat(event->y() - lastPos.y()) / height();
                            dx = GLfloat(lastPos.x()/ width());
                        }
                    }
                }

                if ( is_ctrl == 0 )
                {
                    tab_coo[num_select][0]+= dx*10;
                    tab_coo[num_select][1]-= dy*10;
                }
                else
                {
                    int wl_int_001 = 1;

                    while ( wl_int_001 <= nombre_diapos )
                    {
                        tab_coo[wl_int_001][0]+= dx*10;
                        tab_coo[wl_int_001][1]-= dy*10;
                        wl_int_001++;
                    }
                }
            }
        }
        else
        {
            if ( tool < 4 )
            {
                if ( is_shift == 1 )
                {                   
                    if ( is_ctrl == 0 )
                    {
                        if ( event->x() - lastPos.x() > 0 )
                        {
                            tab_coo[num_select][4+tool] = tab_coo[num_select][4+tool] + 0.1;
                        }
                        else
                        {
                            tab_coo[num_select][4+tool] = tab_coo[num_select][4+tool] - 0.1;
                        }

                    }
                    else
                    {
                        int wl_int_001 = 1;

                        while ( wl_int_001 <= nombre_diapos )
                        {
                            if ( event->x() - lastPos.x() > 0 )
                            {
                                tab_coo[wl_int_001][4+tool] = tab_coo[wl_int_001][4+tool] + 0.1;
                            }
                            else
                            {
                                tab_coo[wl_int_001][4+tool] = tab_coo[wl_int_001][4+tool] - 0.1;
                            }

                            wl_int_001++;
                        }
                    }
                }
                else
                {
                    if ( is_ctrl == 0 )
                    {
                        if ( event->x() - lastPos.x() > 0 )
                        {
                            tab_coo[num_select][4+tool] = tab_coo[num_select][4+tool] + 0.5;
                        }
                        else
                        {
                            tab_coo[num_select][4+tool] = tab_coo[num_select][4+tool] - 0.5;
                        }
                    }
                    else
                    {
                        int wl_int_001 = 1;

                        while ( wl_int_001 <= nombre_diapos )
                        {
                            if ( tab_msk[wl_int_001] == true )
                            {
                                if ( event->x() - lastPos.x() > 0 )
                                {
                                    tab_coo[wl_int_001][4+tool] = tab_coo[wl_int_001][4+tool] + 0.5;
                                }
                                else
                                {
                                    tab_coo[wl_int_001][4+tool] = tab_coo[wl_int_001][4+tool] - 0.5;
                                }

                                /*if ( wl_int_001 != num_select )
                                {
                                    float d = sqrt(pow(tab_coo[num_select][0]-tab_coo[wl_int_001][0],2)+pow(tab_coo[num_select][1]-tab_coo[wl_int_001][1],2));
                                    float ax = 1.0;
                                    float ay = -1.0;

                                    tab_coo[wl_int_001][0] = tab_coo[wl_int_001][0]+ax*2*d*sin(tab_coo[wl_int_001][4+tool]/2)*(sqrt(2)/2);
                                    tab_coo[wl_int_001][1] = tab_coo[wl_int_001][1]+ay*2*d*sin(tab_coo[wl_int_001][4+tool]/2)*(sqrt(2)/2);
                                }*/
                            }
                            wl_int_001++;
                        }
                    }
                }
            }
        }
        updateGL();

        emit update_coo();

        lastPos = event->pos();
}

void Tetrahedron::wheelEvent(QWheelEvent *event)
{
        if ( num_select > 0 )
        {
            if ( event->delta() > 0 )
            {
                    if ( tab_coo[num_select][2] < -2.2 )
                    {
                            tab_coo[num_select][2]+= 0.1;
                    }
            }
            else
            {
                    if ( tab_coo[num_select][2] > -29.6 )
                    {
                            tab_coo[num_select][2]+= - 0.1;
                    }
            }
            updateGL();
            emit update_coo();
        }
}

// *****************************
// *** FONCTIONS D'AFFICHAGE ***
// *****************************

void Tetrahedron::draw()
{
    QStringList wl_explode;

    if ( bcle_render == 1 )
    {
            glClearAccum(0.0, 0.0, 0.0, 1.0);
            glClear(GL_DEPTH_BUFFER_BIT);
    }

    glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT | GL_STENCIL_BUFFER_BIT);

    int wl_int_001 = 1;
    int wl_int_002;
    int wl_int_003 = 1;
    wdecal = 0;

    glInitNames();
    glPushName(-1);

    glEnable(GL_BLEND);
    //glColor4f(1.0f,1.0f,1.0f,(float)((float)100-(float)tab_coo[wl_int_003][9])/(float)100);
    //glBlendFunc (GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);

    glEnable(GL_CULL_FACE);

    if ( isback == 1 )
    {
        if ( is_anaglyph > 0 )
        {
            for ( int wtest = 0; wtest < 3; wtest++ )
            {
                glColor3f(1.0f,1.0f,1.0f);

                if ( wtest == 1 )
                {
                    glColorMask(og_red, og_green, og_blue, GL_TRUE);
                    wdecal = -0.01*wg_esp_ana;
                }
                if ( wtest == 2 )
                {
                    glColorMask(od_red, od_green, od_blue, GL_TRUE);
                    wdecal = +0.01*wg_esp_ana;
                }
                if ( wtest == 0 )
                {
                    glColorMask(GL_TRUE, GL_TRUE, GL_TRUE, GL_TRUE);
                    wdecal = 0;
                }

                glLoadIdentity();

                if ( wtest == 0 )
                {
                    glTranslatef(0.0f,0.0f,-30.0f);
                }
                else
                {
                    glTranslatef(0.0f+wdecal,0.0f,-30.0f);
                }

                glLoadName(0);
                glBindTexture( GL_TEXTURE_2D, texture_diapo[41] );

                if ( wg_fd_tx == wg_fd_ty )
                {
                    ratio_import=1.5;
                }
                else
                {
                    ratio_import = wg_fd_tx/wg_fd_ty;
                }

                glBegin(GL_QUADS);

                glTexCoord2f(wg_fd_tx, -wg_fd_ty);
                glVertex3f(19.0f*ratio_import , -19.0f , 0.0f);

                glTexCoord2f(wg_fd_tx, 0.0);
                glVertex3f(19.0f*ratio_import , 19.0f , 0.0f);

                glTexCoord2f(0.0, 0.0);
                glVertex3f(-19.0f*ratio_import , 19.0f , 0.0f);

                glTexCoord2f(0.0, -wg_fd_ty);
                glVertex3f(-19.0f*ratio_import , -19.0f , 0.0f);

                glEnd();
            }
        }
        else
        {
            glColor3f(1.0f,1.0f,1.0f);

            glLoadIdentity();
            glLoadName(0);
            glBindTexture( GL_TEXTURE_2D, texture_diapo[41] );

            glTranslatef(0.0f,0.0f,-30.0f);

            if ( wg_fd_tx == wg_fd_ty )
            {
                ratio_import=1.5;
            }
            else
            {
                ratio_import = wg_fd_tx/wg_fd_ty;
            }

            glBegin(GL_QUADS);

            glTexCoord2f(wg_fd_tx, -wg_fd_ty);
            glVertex3f(19.0f*ratio_import , -19.0f , 0.0f);

            glTexCoord2f(wg_fd_tx, 0.0);
            glVertex3f(19.0f*ratio_import , 19.0f , 0.0f);

            glTexCoord2f(0.0, 0.0);
            glVertex3f(-19.0f*ratio_import , 19.0f , 0.0f);

            glTexCoord2f(0.0, -wg_fd_ty);
            glVertex3f(-19.0f*ratio_import , -19.0f , 0.0f);

            glEnd();
        }
    }
    else
    {
        glColor3f(1.0f,1.0f,1.0f);

        glLoadIdentity();
        glLoadName(0);
        glBindTexture( GL_TEXTURE_2D, texture_diapo[41] );

        glTranslatef(0.0f,0.0f,-30.0f);

        if ( this->width() == 720 )
        {
            ratio_import=1.0;
        }
        else
        {
            ratio_import=1.778;
        }

        glBegin(GL_QUADS);

        glColor3f(0.0f,0.0f,0.0f);
        glVertex3f(19.75f*ratio_import , -15.8f , 0.0f);

        glColor3f(0.0f,0.0f,0.0f);
        glVertex3f(19.75f*ratio_import , 15.8f , 0.0f);

        glColor3f(0.0f,0.0f,0.0f);
        glVertex3f(-19.75f*ratio_import , 15.8f , 0.0f);

        glColor3f(0.0f,0.0f,0.0f);
        glVertex3f(-19.75f*ratio_import , -15.8f , 0.0f);

        glEnd();
    }

    glDisable(GL_CULL_FACE);

    // *** CLASSEMENT ORDRE Z ***

    while ( wl_int_001 < nombre_diapos+1 )
    {
        tab_order[wl_int_001][0] = 10;
        tab_order[wl_int_001][1] = 0;
        wl_int_001++;
    }

    wl_int_001 = 1;
    while ( wl_int_001 < nombre_diapos+1 )
    {
        wl_int_002 = 1;
        while ( tab_coo[wl_int_001][2] > tab_order[wl_int_002][0] && tab_order[wl_int_002][1] != 0 )
        {
            wl_int_002++;
        }

        if ( tab_order[wl_int_002][1] < 1 )
        {
            tab_order[wl_int_002][0] = tab_coo[wl_int_001][2];
            tab_order[wl_int_002][1] = wl_int_001;
        }
        else
        {
            wl_int_003 = wl_int_002;
            while ( tab_order[wl_int_003][1] > 0 )
            {
                wl_int_003++;
            }
            while ( wl_int_003 > wl_int_002 )
            {
                tab_order[wl_int_003][0] = tab_order[wl_int_003-1][0];
                tab_order[wl_int_003][1] = tab_order[wl_int_003-1][1];
                wl_int_003--;
            }
            tab_order[wl_int_002][0] = tab_coo[wl_int_001][2];
            tab_order[wl_int_002][1] = wl_int_001;
        }
        wl_int_001++;
    }

    if ( is_anaglyph > 0 )
    {
        for ( int wtest = 0; wtest < 3; wtest++ )
        {
            if ( wtest == 1 )
            {
                glColorMask(og_red, og_green, og_blue, GL_TRUE);
                wdecal = -0.01*wg_esp_ana;
            }
            if ( wtest == 2 )
            {
                glColorMask(od_red, od_green, od_blue, GL_TRUE);
                wdecal = +0.01*wg_esp_ana;
            }
            if ( wtest == 0 )
            {
                glColorMask(GL_TRUE, GL_TRUE, GL_TRUE, GL_TRUE);
                wdecal = 0;
            }

            wl_int_001 = 1;

            while ( wl_int_001 < nombre_diapos+1 )
            {
                wl_int_003 = tab_order[wl_int_001][1];

                if ( tab_msk[wl_int_003] == true )
                {
                    if ( tab_diapo[wl_int_003][0].mid(0,1) != "?" || tab_diapo[wl_int_003][0].mid(0,2) == "?9" )
                    {
                        scale_factor = tab_diapo[wl_int_003][5].toFloat();

                        glLoadIdentity();

                        if ( wtest == 0 )
                        {
                            glTranslatef(tab_coo[wl_int_003][0], tab_coo[wl_int_003][1], tab_coo[wl_int_003][2]);
                            glRotatef(tab_coo[wl_int_003][5], 1.0, 0.0, 0.0);
                            glRotatef(tab_coo[wl_int_003][6], 0.0, 1.0, 0.0);
                            if ( tab_diapo[wl_int_003][8] == "1" )
                            {
                                glRotatef(tab_coo[wl_int_003][7]+90, 0.0, 0.0, 1.0);
                            }
                            else
                            {
                                if ( tab_diapo[wl_int_003][8] == "2" )
                                {
                                    glRotatef(tab_coo[wl_int_003][7]-90, 0.0, 0.0, 1.0);
                                }
                                else
                                {
                                    glRotatef(tab_coo[wl_int_003][7], 0.0, 0.0, 1.0);
                                }
                            }
                        }
                        else
                        {
                            glTranslatef(tab_coo[wl_int_003][0], tab_coo[wl_int_003][1], tab_coo[wl_int_003][2]);
                            glRotatef(tab_coo[wl_int_003][5], 1.0, 0.0, 0.0);
                            glRotatef(tab_coo[wl_int_003][6], 0.0, 1.0, 0.0);
                            if ( tab_diapo[wl_int_003][8] == "1" )
                            {
                                glRotatef(tab_coo[wl_int_003][7]+90, 0.0, 0.0, 1.0);
                            }
                            else
                            {
                                if ( tab_diapo[wl_int_003][8] == "2" )
                                {
                                    glRotatef(tab_coo[wl_int_003][7]-90, 0.0, 0.0, 1.0);
                                }
                                else
                                {
                                    glRotatef(tab_coo[wl_int_003][7], 0.0, 0.0, 1.0);
                                }
                            }
                            if ( tab_diapo[wl_int_003][8] == "0" )
                            {
                                glTranslatef(wdecal, 0.0, 0.0);
                            }
                            else
                            {
                                glTranslatef(0.0, wdecal, 0.0);
                            }
                        }

                        glLoadName(wl_int_003);

                        glBindTexture( GL_TEXTURE_2D, texture_diapo[wl_int_003] );
                        glColor4f(tab_coo[wl_int_003][12]/(float)255,tab_coo[wl_int_003][13]/(float)255,tab_coo[wl_int_003][14]/(float)255,(float)((float)100-(float)tab_coo[wl_int_003][9])/(float)100);
                        //glColor4f(1.0f,1.0f,1.0f,(float)((float)100-(float)tab_coo[wl_int_003][9])/(float)100);
                        glBlendFunc (GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);

                        glBegin(GL_QUADS);

                        wg_strtr = QString::number(tab_coo[wl_int_003][8]);

                        if ( wg_strtr.mid(0,1).toInt() < 2 || tab_coo[wl_int_003][11] > 0 ) // *** DIAPO STANDARD ***
                        {
                            if ( tab_diapo[wl_int_003][7] == "0/0/0/0" )
                            {
                                wg_x = (float)(0-(2 * (tab_diapo[wl_int_003][1].toFloat() / tab_diapo[wl_int_003][2].toFloat()))) * -1;

                                if ( tab_diapo[wl_int_003][1].toFloat() > tab_diapo[wl_int_003][2].toFloat() )
                                {
                                    wg_tx = 1.0;
                                    wg_ty = (float)((float)tab_diapo[wl_int_003][2].toFloat()/(float)sm_mxw);
                                }
                                else
                                {
                                    wg_ty = 1.0;
                                    wg_tx = (float)((float)tab_diapo[wl_int_003][1].toFloat()/(float)sm_mxw);
                                }
                            }
                            else
                            {
                                wl_explode = tab_diapo[wl_int_003][7].split("/",QString::KeepEmptyParts);

                                int cropxd, cropyd, cropxe, cropye;
                                if ( wl_explode.at(0).toFloat() > wl_explode.at(2).toFloat() )
                                {
                                    cropxd = wl_explode.at(0).toFloat();
                                    cropxe = wl_explode.at(2).toFloat();
                                }
                                else
                                {
                                    cropxe = wl_explode.at(0).toFloat();
                                    cropxd = wl_explode.at(2).toFloat();
                                }

                                if ( wl_explode.at(1).toFloat() > wl_explode.at(3).toFloat() )
                                {
                                    cropyd = wl_explode.at(1).toFloat();
                                    cropye = wl_explode.at(3).toFloat();
                                }
                                else
                                {
                                    cropye = wl_explode.at(1).toFloat();
                                    cropyd = wl_explode.at(3).toFloat();
                                }

                                wg_x = (float)(0-(2 * ((float)(cropxd-cropxe) / (float)(cropyd-cropye)))) * -1;

                                if ( (cropxd-cropxe) > (cropyd-cropye) )
                                {
                                    wg_tx = 1.0;
                                    wg_ty = (float)((float)(cropyd-cropye)/(float)(cropxd-cropxe));
                                }
                                else
                                {
                                    wg_ty = 1.0;
                                    wg_tx = (float)((float)(cropxd-cropxe)/(float)(cropyd-cropye));
                                }
                            }

                            glTexCoord2f(wg_tx-((wg_tx/2)-((tab_coo[wl_int_003][15]/100.0)*wg_tx)/2.0), -wg_ty+((wg_ty/2)-((tab_coo[wl_int_003][16]/100.0)*wg_ty)/2.0));
                            glVertex3f(wg_x*scale_factor*(tab_coo[wl_int_003][15]/100.0) , -2.0f*scale_factor*(tab_coo[wl_int_003][16]/100.0) , 0.0f);

                            glTexCoord2f(wg_tx-((wg_tx/2)-((tab_coo[wl_int_003][15]/100.0)*wg_tx)/2.0), 0.0-((wg_ty/2)-((tab_coo[wl_int_003][4]/100.0)*wg_ty)/2.0));
                            glVertex3f(wg_x*scale_factor*(tab_coo[wl_int_003][15]/100.0) , 2.0f*scale_factor*(tab_coo[wl_int_003][4]/100.0) , 0.0f);

                            glTexCoord2f(0.0+((wg_tx/2)-((tab_coo[wl_int_003][3]/100.0)*wg_tx)/2.0), 0.0-((wg_ty/2)-((tab_coo[wl_int_003][4]/100.0)*wg_ty)/2.0));
                            glVertex3f(-wg_x*scale_factor*(tab_coo[wl_int_003][3]/100.0) , 2.0f*scale_factor*(tab_coo[wl_int_003][4]/100.0) , 0.0f);

                            glTexCoord2f(0.0+((wg_tx/2)-((tab_coo[wl_int_003][3]/100.0)*wg_tx)/2.0), -wg_ty+((wg_ty/2)-((tab_coo[wl_int_003][16]/100.0)*wg_ty)/2.0));
                            glVertex3f(-wg_x*scale_factor*(tab_coo[wl_int_003][3]/100.0) , -2.0f*scale_factor*(tab_coo[wl_int_003][16]/100.0) , 0.0f);
                        }

                        glEnd();

                        if ( tab_diapo[wl_int_003][6] != "0" && tab_coo[wl_int_003][3]+tab_coo[wl_int_003][4]+tab_coo[wl_int_003][15]+tab_coo[wl_int_003][16] == 400 ) // *** REFLECT ***
                        {
                            if ( tab_diapo[wl_int_003][8] == "1" )
                            {
                                glRotatef(tab_coo[wl_int_003][7]-180, 0.0, 0.0, 1.0);
                                glTranslatef(+(wg_x*2)*scale_factor, 0.0, 0.0);
                                glScalef(1.0, -1.0, 1.0);

                                glShadeModel(GL_SMOOTH);

                                glBegin(GL_QUADS);

                                if ( wg_strtr.mid(0,1).toInt() < 2 || tab_coo[wl_int_003][11] >= 0 )
                                {

                                    glColor4f(tab_coo[wl_int_003][12]/(float)255,tab_coo[wl_int_003][13]/(float)255,tab_coo[wl_int_003][14]/(float)255,0.0);
                                    glTexCoord2f(wg_tx, -wg_ty);
                                    glVertex3f(wg_x*scale_factor , -2.0f*scale_factor , 0.0f);

                                    glColor4f(tab_coo[wl_int_003][12]/(float)255,tab_coo[wl_int_003][13]/(float)255,tab_coo[wl_int_003][14]/(float)255,0.0);
                                    glTexCoord2f(wg_tx, 0.0);
                                    glVertex3f(wg_x*scale_factor , 2.0f*scale_factor , 0.0f);

                                    glColor4f(tab_coo[wl_int_003][12]/(float)255,tab_coo[wl_int_003][13]/(float)255,tab_coo[wl_int_003][14]/(float)255,0.4*((float)((float)100-(float)tab_coo[wl_int_003][9])/(float)100));
                                    glTexCoord2f(0.0, 0.0);
                                    glVertex3f(-wg_x*scale_factor , 2.0f*scale_factor , 0.0f);

                                    glColor4f(tab_coo[wl_int_003][12]/(float)255,tab_coo[wl_int_003][13]/(float)255,tab_coo[wl_int_003][14]/(float)255,0.4*((float)((float)100-(float)tab_coo[wl_int_003][9])/(float)100));
                                    glTexCoord2f(0.0, -wg_ty);
                                    glVertex3f(-wg_x*scale_factor , -2.0f*scale_factor , 0.0f);
                                }
                            }
                            else
                            {
                                if ( tab_diapo[wl_int_003][8] == "2" )
                                {
                                    glRotatef(tab_coo[wl_int_003][7]+180, 0.0, 0.0, 1.0);
                                    glTranslatef(-(wg_x*1.5)*scale_factor, 0.0, 0.0);
                                    glScalef(1.0, -1.0, 1.0);

                                    glShadeModel(GL_SMOOTH);

                                    glBegin(GL_QUADS);

                                    if ( wg_strtr.mid(0,1).toInt() < 2 || tab_coo[wl_int_003][11] >= 0 )
                                    {
                                        glColor4f(tab_coo[wl_int_003][12]/(float)255,tab_coo[wl_int_003][13]/(float)255,tab_coo[wl_int_003][14]/(float)255,0.4*((float)((float)100-(float)tab_coo[wl_int_003][9])/(float)100));
                                        glTexCoord2f(wg_tx, -wg_ty);
                                        glVertex3f(wg_x*scale_factor/2 , -2.0f*scale_factor , 0.0f);

                                        glColor4f(tab_coo[wl_int_003][12]/(float)255,tab_coo[wl_int_003][13]/(float)255,tab_coo[wl_int_003][14]/(float)255,0.4*((float)((float)100-(float)tab_coo[wl_int_003][9])/(float)100));
                                        glTexCoord2f(wg_tx, 0.0);
                                        glVertex3f(wg_x*scale_factor/2 , 2.0f*scale_factor , 0.0f);

                                        glColor4f(tab_coo[wl_int_003][12]/(float)255,tab_coo[wl_int_003][13]/(float)255,tab_coo[wl_int_003][14]/(float)255,0.0);
                                        glTexCoord2f(wg_tx/2, 0.0);

                                        glVertex3f(-wg_x*scale_factor/2 , 2.0f*scale_factor , 0.0f);

                                        glColor4f(tab_coo[wl_int_003][12]/(float)255,tab_coo[wl_int_003][13]/(float)255,tab_coo[wl_int_003][14]/(float)255,0.0);
                                        glTexCoord2f(wg_tx/2, -wg_ty);
                                        glVertex3f(-wg_x*scale_factor/2 , -2.0f*scale_factor , 0.0f);
                                    }
                                }
                                else
                                {
                                    glTranslatef(0.0, -3.0f*scale_factor, 0.0);
                                    glScalef(1.0, -1.0, 1.0);

                                    glShadeModel(GL_SMOOTH);

                                    glBegin(GL_QUADS);

                                    if ( wg_strtr.mid(0,1).toInt() < 2 || tab_coo[wl_int_003][11] >= 0 )
                                    {
                                        glColor4f(tab_coo[wl_int_003][12]/(float)255,tab_coo[wl_int_003][13]/(float)255,tab_coo[wl_int_003][14]/(float)255,0.4*((float)((float)100-(float)tab_coo[wl_int_003][9])/(float)100));
                                        glTexCoord2f(wg_tx, -wg_ty);
                                        glVertex3f(wg_x*scale_factor , -1.0f*scale_factor , 0.0f);

                                        glColor4f(tab_coo[wl_int_003][12]/(float)255,tab_coo[wl_int_003][13]/(float)255,tab_coo[wl_int_003][14]/(float)255,0.0);
                                        glTexCoord2f(wg_tx, -wg_ty/2);
                                        glVertex3f(wg_x*scale_factor , 1.0f*scale_factor , 0.0f);

                                        glColor4f(tab_coo[wl_int_003][12]/(float)255,tab_coo[wl_int_003][13]/(float)255,tab_coo[wl_int_003][14]/(float)255,0.0);
                                        glTexCoord2f(0.0, -wg_ty/2);
                                        glVertex3f(-wg_x*scale_factor , 1.0f*scale_factor , 0.0f);

                                        glColor4f(tab_coo[wl_int_003][12]/(float)255,tab_coo[wl_int_003][13]/(float)255,tab_coo[wl_int_003][14]/(float)255,0.4*((float)((float)100-(float)tab_coo[wl_int_003][9])/(float)100));
                                        glTexCoord2f(0.0, -wg_ty);
                                        glVertex3f(-wg_x*scale_factor , -1.0f*scale_factor , 0.0f);
                                    }
                                }
                            }

                            glEnd();
                            glShadeModel(GL_FLAT);
                        }
                    }
                    else
                    {
                        // *********************
                        // *** AUTRES OBJETS ***
                        // *********************
                        scale_factor = tab_diapo[wl_int_003][5].toFloat();

                        /*if ( wl_int_003 == num_select )
                        {
                            tab_coo_select[0][0] = tab_coo[wl_int_003][0];
                            tab_coo_select[0][1] = tab_coo[wl_int_003][1];
                            tab_coo_select[0][2] = tab_coo[wl_int_003][2];
                            tab_coo_select[0][5] = tab_coo[wl_int_003][5];
                            tab_coo_select[0][6] = tab_coo[wl_int_003][6];
                            tab_coo_select[0][7] = tab_coo[wl_int_003][7];
                            tab_coo_select[0][8] = scale_factor;
                        }*/

                        glEnable( GL_LIGHTING ) ;
                        glEnable( GL_LIGHT0 );
                        glDisable(GL_TEXTURE_2D);

                        glColor3f(1.0f,1.0f,1.0f);
                        glLoadIdentity();
                        glEnable(GL_CULL_FACE);

                        if ( wtest == 0 )
                        {
                            glTranslatef(tab_coo[wl_int_003][0], tab_coo[wl_int_003][1], tab_coo[wl_int_003][2]);
                            glRotatef(tab_coo[wl_int_003][5], 1.0, 0.0, 0.0);
                            glRotatef(tab_coo[wl_int_003][6], 0.0, 1.0, 0.0);
                            glRotatef(tab_coo[wl_int_003][7], 0.0, 0.0, 1.0);

                        }
                        else
                        {
                            glTranslatef(tab_coo[wl_int_003][0], tab_coo[wl_int_003][1], tab_coo[wl_int_003][2]);
                            glRotatef(tab_coo[wl_int_003][5], 1.0, 0.0, 0.0);
                            glRotatef(tab_coo[wl_int_003][6], 0.0, 1.0, 0.0);
                            glRotatef(tab_coo[wl_int_003][7], 0.0, 0.0, 1.0);
                            glTranslatef(wdecal, 0.0, 0.0);
                        }

                        if ( tab_diapo[wl_int_003][0].mid(1,1) == "1" )
                        {
                            glLoadName(wl_int_003);

                            glColorMaterial ( GL_FRONT_AND_BACK, GL_AMBIENT_AND_DIFFUSE );
                            glLightfv(GL_LIGHT0, GL_POSITION, light_position);

                            GLfloat light_ambient[] = { 0.4, 0.0, 0.0, 1.0};
                            glLightfv(GL_LIGHT0, GL_AMBIENT, light_ambient);

                            glTranslatef(0, 0, -2.5*scale_factor);

                            glColor3ub(200,0,0);
                            quadric = gluNewQuadric();
                            gluQuadricNormals(quadric, GLU_SMOOTH );

                            gluCylinder(quadric, .5*scale_factor, .5*scale_factor, 5*scale_factor, 8, 2);

                            glTranslatef(0, 0, 5*scale_factor);
                            glColor3ub(240,215,160);
                            gluCylinder(quadric, .5*scale_factor, 0*scale_factor, 1*scale_factor, 8, 2);

                            glTranslatef(0, 0, 0.5*scale_factor);
                            glColor3ub(200,0,0);
                            gluCylinder(quadric, .25*scale_factor, 0*scale_factor, 0.5*scale_factor, 10, 2);

                            glTranslatef(0, 0, -5.5*scale_factor);
                            glColor3ub(200,0,0);
                            glRotatef(180, 0, 1, 0);
                            gluDisk(quadric,0,0.5*scale_factor,8*scale_factor,8*scale_factor);

                            glDisable(GL_CULL_FACE);
                            glDisable( GL_LIGHTING ) ;
                            glDisable( GL_LIGHT0 );
                        }
                        else
                        {
                            if ( tab_diapo[wl_int_003][0].mid(1,1) == "2" )
                            {
                                glLoadName(wl_int_003);

                                glColorMaterial ( GL_FRONT_AND_BACK, GL_AMBIENT_AND_DIFFUSE );
                                glLightfv(GL_LIGHT0, GL_POSITION, light_position);

                                GLfloat light_ambient[] = { 0.0, 0.4, 0.0, 1.0};
                                glLightfv(GL_LIGHT0, GL_AMBIENT, light_ambient);

                                glTranslatef(0, 0, -2.5*scale_factor);

                                glColor3ub(0,200,0);
                                quadric = gluNewQuadric();
                                gluQuadricNormals(quadric, GLU_SMOOTH );

                                gluCylinder(quadric, .5*scale_factor, .5*scale_factor, 5*scale_factor, 8, 2);

                                glTranslatef(0, 0, 5*scale_factor);
                                glColor3ub(240,215,160);
                                gluCylinder(quadric, .5*scale_factor, 0*scale_factor, 1*scale_factor, 8, 2);

                                glTranslatef(0, 0, 0.5*scale_factor);
                                glColor3ub(0,200,0);
                                gluCylinder(quadric, .25*scale_factor, 0*scale_factor, 0.5*scale_factor, 10, 2);

                                glTranslatef(0, 0, -5.5*scale_factor);
                                glColor3ub(0,200,0);
                                glRotatef(180, 0, 1, 0);
                                gluDisk(quadric,0,0.5*scale_factor,8*scale_factor,8*scale_factor);

                                glDisable(GL_CULL_FACE);
                                glDisable( GL_LIGHTING ) ;
                                glDisable( GL_LIGHT0 );
                            }
                            else
                            {
                                if ( tab_diapo[wl_int_003][0].mid(1,1) == "3" )
                                {
                                    glLoadName(wl_int_003);

                                    glColorMaterial ( GL_FRONT_AND_BACK, GL_AMBIENT_AND_DIFFUSE );
                                    glLightfv(GL_LIGHT0, GL_POSITION, light_position);

                                    GLfloat light_ambient[] = { 0.0, 0.0, 0.4, 1.0};
                                    glLightfv(GL_LIGHT0, GL_AMBIENT, light_ambient);

                                    glTranslatef(0, 0, -2.5*scale_factor);

                                    glColor3ub(0,0,200);
                                    quadric = gluNewQuadric();
                                    gluQuadricNormals(quadric, GLU_SMOOTH );

                                    gluCylinder(quadric, .5*scale_factor, .5*scale_factor, 5*scale_factor, 8, 2);

                                    glTranslatef(0, 0, 5*scale_factor);
                                    glColor3ub(240,215,160);
                                    gluCylinder(quadric, .5*scale_factor, 0*scale_factor, 1*scale_factor, 8, 2);

                                    glTranslatef(0, 0, 0.5*scale_factor);
                                    glColor3ub(0,0,200);
                                    gluCylinder(quadric, .25*scale_factor, 0*scale_factor, 0.5*scale_factor, 10, 2);

                                    glTranslatef(0, 0, -5.5*scale_factor);
                                    glColor3ub(0,0,200);
                                    glRotatef(180, 0, 1, 0);
                                    gluDisk(quadric,0,0.5*scale_factor,8*scale_factor,8*scale_factor);

                                    glDisable(GL_CULL_FACE);
                                    glDisable( GL_LIGHTING ) ;
                                    glDisable( GL_LIGHT0 );
                                }
                                else
                                {
                                    if ( tab_diapo[wl_int_003][0].mid(1,1) == "4" )
                                    {
                                        glLoadName(wl_int_003);

                                        glColorMaterial ( GL_FRONT_AND_BACK, GL_AMBIENT_AND_DIFFUSE );
                                        glLightfv(GL_LIGHT0, GL_POSITION, light_position);

                                        GLfloat light_ambient[] = { 0.4, 0.4, 0.4, 1.0};
                                        glLightfv(GL_LIGHT0, GL_AMBIENT, light_ambient);

                                        glTranslatef(0, 0, -2.5*scale_factor);

                                        glColor3ub(200,200,200);
                                        quadric = gluNewQuadric();
                                        gluQuadricNormals(quadric, GLU_SMOOTH );

                                        gluCylinder(quadric, .5*scale_factor, .5*scale_factor, 5*scale_factor, 8, 2);

                                        glTranslatef(0, 0, 5*scale_factor);
                                        glColor3ub(240,215,160);
                                        gluCylinder(quadric, .5*scale_factor, 0*scale_factor, 1*scale_factor, 8, 2);

                                        glTranslatef(0, 0, 0.5*scale_factor);
                                        glColor3ub(200,200,200);
                                        gluCylinder(quadric, .25*scale_factor, 0*scale_factor, 0.5*scale_factor, 10, 2);

                                        glTranslatef(0, 0, -5.5*scale_factor);
                                        glColor3ub(200,200,200);
                                        glRotatef(180, 0, 1, 0);
                                        gluDisk(quadric,0,0.5*scale_factor,8*scale_factor,8*scale_factor);

                                        glDisable(GL_CULL_FACE);
                                        glDisable( GL_LIGHTING ) ;
                                        glDisable( GL_LIGHT0 );
                                    }
                                    else
                                    {
                                        if ( tab_diapo[wl_int_003][0].mid(1,1) == "5" ) // *** SPHERE TEXTUREE ANAGLYPH ***
                                        {
                                            glEnable( GL_LIGHTING ) ;
                                            glEnable( GL_LIGHT0 );
                                            glEnable(GL_CULL_FACE);
                                            glEnable(GL_TEXTURE_2D);

                                            glColor3f(1.0f,1.0f,1.0f);
                                            //glLoadIdentity();

                                            glLoadName(wl_int_003);

                                            glColor3ub(255,255,255);
                                            quadric = gluNewQuadric();
                                            gluQuadricNormals(quadric, GLU_SMOOTH );
                                            gluQuadricTexture(quadric,GL_TRUE);

                                            glBindTexture(GL_TEXTURE_2D,texture_diapo[wl_int_003]);
                                            gluSphere(quadric,2.0f*scale_factor,128,128);
                                            glDisable(GL_CULL_FACE);
                                            glDisable( GL_LIGHTING ) ;
                                            glDisable( GL_LIGHT0 );
                                        }
                                        else
                                        {
                                            if ( tab_diapo[wl_int_003][0].mid(1,1) == "6" )
                                            {
                                                glDisable( GL_LIGHTING ) ;
                                                glDisable( GL_LIGHT0 );
                                                glEnable(GL_TEXTURE_2D);

                                                glLoadName(wl_int_003);

                                                // *** FACE ARRIERE ***

                                                glBindTexture( GL_TEXTURE_2D, texture_diapo_cube[0] );

                                                glBegin(GL_QUADS);

                                                glColor4f(1.0,1.0,1.0,1.0);
                                                glTexCoord2f(0.0, 1.0);
                                                glVertex3f(-1.0f * scale_factor, -1.0f * scale_factor, -1.0f * scale_factor );

                                                glColor4f(1.0,1.0,1.0,1.0);
                                                glTexCoord2f(0.0, 0.0);
                                                glVertex3f(-1.0f * scale_factor,  1.0f * scale_factor, -1.0f * scale_factor );

                                                glColor4f(1.0,1.0,1.0,1.0);
                                                glTexCoord2f(1.0, 0.0);
                                                glVertex3f( 1.0f * scale_factor,  1.0f * scale_factor, -1.0f * scale_factor );

                                                glColor4f(1.0,1.0,1.0,1.0);
                                                glTexCoord2f(1.0, 1.0);
                                                glVertex3f( 1.0f * scale_factor, -1.0f * scale_factor, -1.0f * scale_factor );

                                                glEnd();

                                                // *** FACE DU HAUT ***
                                                glBindTexture( GL_TEXTURE_2D, texture_diapo_cube[1] );

                                                glBegin(GL_QUADS);

                                                glColor4f(1.0,1.0,1.0,1.0);
                                                glTexCoord2f(0.0, 1.0);
                                                glVertex3f(-1.0f * scale_factor,  1.0f * scale_factor , -1.0f * scale_factor );

                                                glColor4f(1.0,1.0,1.0,1.0);
                                                glTexCoord2f(0.0, 0.0);
                                                glVertex3f(-1.0f * scale_factor,  1.0f * scale_factor ,  1.0f * scale_factor );

                                                glColor4f(1.0,1.0,1.0,1.0);
                                                glTexCoord2f(1.0, 0.0);
                                                glVertex3f( 1.0f * scale_factor,  1.0f * scale_factor ,  1.0f * scale_factor );

                                                glColor4f(1.0,1.0,1.0,1.0);
                                                glTexCoord2f(1.0, 1.0);
                                                glVertex3f( 1.0f * scale_factor,  1.0f * scale_factor , -1.0f * scale_factor );

                                                glEnd();

                                                // *** FACE DU BAS ***
                                                glBindTexture( GL_TEXTURE_2D, texture_diapo_cube[2] );

                                                glBegin(GL_QUADS);

                                                glColor4f(1.0,1.0,1.0,1.0);
                                                glTexCoord2f(1.0, 1.0);
                                                glVertex3f(-1.0f * scale_factor , -1.0f * scale_factor , -1.0f * scale_factor );

                                                glColor4f(1.0,1.0,1.0,1.0);
                                                glTexCoord2f(0.0, 1.0);
                                                glVertex3f( 1.0f * scale_factor , -1.0f * scale_factor , -1.0f * scale_factor );

                                                glColor4f(1.0,1.0,1.0,1.0);
                                                glTexCoord2f(0.0, 0.0);
                                                glVertex3f( 1.0f * scale_factor , -1.0f * scale_factor ,  1.0f * scale_factor );

                                                glColor4f(1.0,1.0,1.0,1.0);
                                                glTexCoord2f(1.0, 0.0);
                                                glVertex3f(-1.0f * scale_factor , -1.0f * scale_factor ,  1.0f * scale_factor );

                                                glEnd();

                                                // *** FACE DE GAUCHE ***
                                                glBindTexture( GL_TEXTURE_2D, texture_diapo_cube[3] );

                                                glBegin(GL_QUADS);

                                                glColor4f(1.0,1.0,1.0,1.0);
                                                glTexCoord2f(0.0, 1.0);

                                                glVertex3f(-1.0f * scale_factor , -1.0f * scale_factor, -1.0f * scale_factor );

                                                glColor4f(1.0,1.0,1.0,1.0);
                                                glTexCoord2f(0.0, 0.0);
                                                glVertex3f(-1.0f * scale_factor , -1.0f * scale_factor,  1.0f * scale_factor );

                                                glColor4f(1.0,1.0,1.0,1.0);
                                                glTexCoord2f(1.0, 0.0);
                                                glVertex3f(-1.0f * scale_factor ,  1.0f * scale_factor,  1.0f * scale_factor );

                                                glColor4f(1.0,1.0,1.0,1.0);
                                                glTexCoord2f(1.0, 1.0);
                                                glVertex3f(-1.0f * scale_factor ,  1.0f * scale_factor, -1.0f * scale_factor );

                                                glEnd();

                                                // *** FACE DE DROITE ***
                                                glBindTexture( GL_TEXTURE_2D, texture_diapo_cube[4] );

                                                glBegin(GL_QUADS);

                                                glColor4f(1.0,1.0,1.0,1.0);
                                                glTexCoord2f(1.0, 1.0);
                                                glVertex3f( 1.0f * scale_factor , -1.0f * scale_factor , -1.0f * scale_factor );

                                                glColor4f(1.0,1.0,1.0,1.0);
                                                glTexCoord2f(0.0, 1.0);
                                                glVertex3f( 1.0f * scale_factor ,  1.0f * scale_factor , -1.0f * scale_factor );

                                                glColor4f(1.0,1.0,1.0,1.0);
                                                glTexCoord2f(0.0, 0.0);
                                                glVertex3f( 1.0f * scale_factor ,  1.0f * scale_factor ,  1.0f * scale_factor );

                                                glColor4f(1.0,1.0,1.0,1.0);
                                                glTexCoord2f(1.0, 0.0);
                                                glVertex3f( 1.0f * scale_factor , -1.0f * scale_factor ,  1.0f * scale_factor );

                                                glEnd();

                                                // *** FACE AVANT ***
                                                glBindTexture( GL_TEXTURE_2D, texture_diapo_cube[5] );

                                                glBegin(GL_QUADS);

                                                glColor4f(1.0,1.0,1.0,1.0);
                                                glTexCoord2f(0.0, 0.0);
                                                glVertex3f(-1.0f * scale_factor , -1.0f * scale_factor ,  1.0f * scale_factor );

                                                glColor4f(1.0,1.0,1.0,1.0);
                                                glTexCoord2f(1.0, 0.0);
                                                glVertex3f( 1.0f * scale_factor , -1.0f * scale_factor ,  1.0f * scale_factor );

                                                glColor4f(1.0,1.0,1.0,1.0);
                                                glTexCoord2f(1.0, 1.0);
                                                glVertex3f( 1.0f * scale_factor ,  1.0f * scale_factor ,  1.0f * scale_factor );

                                                glColor4f(1.0,1.0,1.0,1.0);
                                                glTexCoord2f(0.0, 1.0);
                                                glVertex3f(-1.0f * scale_factor ,  1.0f * scale_factor ,  1.0f * scale_factor );

                                                glEnd();

                                                glEnable(GL_TEXTURE_2D);
                                                glDisable(GL_CULL_FACE);
                                            }
                                            else
                                            {
                                                if ( tab_diapo[wl_int_003][0].mid(1,1) == "7" )
                                                {
                                                    glEnable( GL_LIGHTING ) ;
                                                    glEnable( GL_LIGHT0 );
                                                    glEnable(GL_CULL_FACE);

                                                    glColor3f(1.0f,1.0f,1.0f);
                                                    glEnable(GL_TEXTURE_2D);

                                                    glColorMaterial ( GL_FRONT_AND_BACK, GL_AMBIENT_AND_DIFFUSE );
                                                    glLightfv(GL_LIGHT0, GL_POSITION, light_position);

                                                    GLfloat light_ambient[] = { 1.0, 1.0, 1.0, 1.0};
                                                    glLightfv(GL_LIGHT0, GL_AMBIENT, light_ambient);

                                                    glLoadName(wl_int_003);

                                                    glColor3ub(255,255,255);
                                                    quadric = gluNewQuadric();
                                                    gluQuadricNormals(quadric, GLU_SMOOTH );
                                                    gluQuadricTexture(quadric,GL_TRUE);

                                                    glBindTexture(GL_TEXTURE_2D,texture_diapo[44]);
                                                    gluSphere(quadric,2.0f*scale_factor,128,128);
                                                    glDisable(GL_CULL_FACE);
                                                    glDisable( GL_LIGHTING ) ;
                                                    glDisable( GL_LIGHT0 );
                                                }
                                                else
                                                {
                                                    if ( tab_diapo[wl_int_003][0].mid(1,1) == "8" )
                                                    {
                                                        glEnable( GL_LIGHTING ) ;
                                                        glEnable( GL_LIGHT0 );
                                                        glEnable(GL_TEXTURE_2D);

                                                        glColor3f(1.0f,1.0f,1.0f);
                                                        glDisable(GL_CULL_FACE);

                                                        glLoadName(wl_int_003);

                                                        glColorMaterial ( GL_FRONT_AND_BACK, GL_AMBIENT_AND_DIFFUSE );

                                                        GLfloat light_ambient[] = { 1.0, 1.0, 1.0, 1.0};
                                                        glLightfv(GL_LIGHT0, GL_AMBIENT, light_ambient);

                                                        glBegin(GL_TRIANGLE_STRIP);

                                                        glColor3f(255,255,255);

                                                        glVertex3f(-7.0*scale_factor, 0.0*scale_factor, 2.0*scale_factor);
                                                        glVertex3f(-1.0*scale_factor, 0.0*scale_factor, 3.0*scale_factor);
                                                        glVertex3f(-1.0*scale_factor, 7.0*scale_factor, 3.0*scale_factor);
                                                        glVertex3f(0.0*scale_factor, 0.0*scale_factor, 0.0*scale_factor);
                                                        glVertex3f(0.0*scale_factor, 8.0*scale_factor, 0.0*scale_factor);
                                                        glVertex3f(1.0*scale_factor, 0.0*scale_factor, 3.0*scale_factor);
                                                        glVertex3f(1.0*scale_factor, 7.0*scale_factor, 3.0*scale_factor);
                                                        glVertex3f(7.0*scale_factor, 0.0*scale_factor, 2.0*scale_factor);

                                                        glEnd();

                                                        glDisable( GL_LIGHTING ) ;
                                                        glDisable( GL_LIGHT0 );
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                        glEnable(GL_TEXTURE_2D);
                    }
                }
                //
                wl_int_001++;
            }
        }
    }
    else
    { // *** PAS D'ANAGLYPH ***
        wl_int_001 = 1;
        while ( wl_int_001 < nombre_diapos+1 )
        {
            wl_int_003 = tab_order[wl_int_001][1];

            if ( tab_msk[wl_int_003] == true )
            {
                if ( tab_diapo[wl_int_003][0].mid(0,1) != "?" || tab_diapo[wl_int_003][0].mid(0,2) == "?9" )
                {
                    scale_factor = tab_diapo[wl_int_003][5].toFloat();

                    glLoadIdentity();

                    glTranslatef(tab_coo[wl_int_003][0], tab_coo[wl_int_003][1], tab_coo[wl_int_003][2]);
                    glRotatef(tab_coo[wl_int_003][5], 1.0, 0.0, 0.0);
                    glRotatef(tab_coo[wl_int_003][6], 0.0, 1.0, 0.0);

                    if ( tab_diapo[wl_int_003][8] == "1" )
                    {
                        glRotatef(tab_coo[wl_int_003][7]+90, 0.0, 0.0, 1.0);
                    }
                    else
                    {
                        if ( tab_diapo[wl_int_003][8] == "2" )
                        {
                            glRotatef(tab_coo[wl_int_003][7]-90, 0.0, 0.0, 1.0);
                        }
                        else
                        {
                            glRotatef(tab_coo[wl_int_003][7], 0.0, 0.0, 1.0);
                        }
                    }

                    glLoadName(wl_int_003);

                    glBindTexture( GL_TEXTURE_2D, texture_diapo[wl_int_003] );

                    glColor4f(tab_coo[wl_int_003][12]/(float)255,tab_coo[wl_int_003][13]/(float)255,tab_coo[wl_int_003][14]/(float)255,(float)((float)100-(float)tab_coo[wl_int_003][9])/(float)100);
                    glBlendFunc (GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);

                    glBegin(GL_QUADS);

                    wg_strtr = QString::number(tab_coo[wl_int_003][8]);

                    if ( wg_strtr.mid(0,1).toInt() < 2 || tab_coo[wl_int_003][11] > 0 ) // *** DIAPO STANDARD ***
                    {
                        if ( tab_diapo[wl_int_003][7] == "0/0/0/0" )
                        {
                            wg_x = (float)(0-(2 * (tab_diapo[wl_int_003][1].toFloat() / tab_diapo[wl_int_003][2].toFloat()))) * -1;

                            if ( tab_diapo[wl_int_003][1].toFloat() > tab_diapo[wl_int_003][2].toFloat() )
                            {
                                wg_tx = 1.0;
                                wg_ty = (float)((float)tab_diapo[wl_int_003][2].toFloat()/(float)sm_mxw);
                            }
                            else
                            {
                                wg_ty = 1.0;
                                wg_tx = (float)((float)tab_diapo[wl_int_003][1].toFloat()/(float)sm_mxw);
                            }
                        }
                        else
                        {
                            wl_explode = tab_diapo[wl_int_003][7].split("/",QString::KeepEmptyParts);

                            int cropxd, cropyd, cropxe, cropye;
                            if ( wl_explode.at(0).toFloat() > wl_explode.at(2).toFloat() )
                            {
                                cropxd = wl_explode.at(0).toFloat();
                                cropxe = wl_explode.at(2).toFloat();
                            }
                            else
                            {
                                cropxe = wl_explode.at(0).toFloat();
                                cropxd = wl_explode.at(2).toFloat();
                            }

                            if ( wl_explode.at(1).toFloat() > wl_explode.at(3).toFloat() )
                            {
                                cropyd = wl_explode.at(1).toFloat();
                                cropye = wl_explode.at(3).toFloat();
                            }
                            else
                            {
                                cropye = wl_explode.at(1).toFloat();
                                cropyd = wl_explode.at(3).toFloat();
                            }

                            wg_x = (float)(0-(2 * ((float)(cropxd-cropxe) / (float)(cropyd-cropye)))) * -1;

                            if ( (cropxd-cropxe) > (cropyd-cropye) )
                            {
                                wg_tx = 1.0;
                                wg_ty = (float)((float)(cropyd-cropye)/(float)(cropxd-cropxe));
                            }
                            else
                            {
                                wg_ty = 1.0;
                                wg_tx = (float)((float)(cropxd-cropxe)/(float)(cropyd-cropye));
                            }
                        }

                        glBindTexture( GL_TEXTURE_2D, texture_diapo[wl_int_003] );
                        glTexCoord2f(wg_tx-((wg_tx/2)-((tab_coo[wl_int_003][15]/100.0)*wg_tx)/2.0), -wg_ty+((wg_ty/2)-((tab_coo[wl_int_003][16]/100.0)*wg_ty)/2.0));
                        glVertex3f(wg_x*scale_factor*(tab_coo[wl_int_003][15]/100.0) , -2.0f*scale_factor*(tab_coo[wl_int_003][16]/100.0) , 0.0f);

                        glTexCoord2f(wg_tx-((wg_tx/2)-((tab_coo[wl_int_003][15]/100.0)*wg_tx)/2.0), 0.0-((wg_ty/2)-((tab_coo[wl_int_003][4]/100.0)*wg_ty)/2.0));
                        glVertex3f(wg_x*scale_factor*(tab_coo[wl_int_003][15]/100.0) , 2.0f*scale_factor*(tab_coo[wl_int_003][4]/100.0) , 0.0f);

                        glTexCoord2f(0.0+((wg_tx/2)-((tab_coo[wl_int_003][3]/100.0)*wg_tx)/2.0), 0.0-((wg_ty/2)-((tab_coo[wl_int_003][4]/100.0)*wg_ty)/2.0));
                        glVertex3f(-wg_x*scale_factor*(tab_coo[wl_int_003][3]/100.0) , 2.0f*scale_factor*(tab_coo[wl_int_003][4]/100.0) , 0.0f);

                        glTexCoord2f(0.0+((wg_tx/2)-((tab_coo[wl_int_003][3]/100.0)*wg_tx)/2.0), -wg_ty+((wg_ty/2)-((tab_coo[wl_int_003][16]/100.0)*wg_ty)/2.0));
                        glVertex3f(-wg_x*scale_factor*(tab_coo[wl_int_003][3]/100.0) , -2.0f*scale_factor*(tab_coo[wl_int_003][16]/100.0) , 0.0f);
                    }

                    glEnd();

                    if ( tab_diapo[wl_int_003][6] != "0" && tab_coo[wl_int_003][3]+tab_coo[wl_int_003][4]+tab_coo[wl_int_003][15]+tab_coo[wl_int_003][16] == 400 ) // *** REFLECT ***
                    {
                        if ( tab_diapo[wl_int_003][8] == "1" )
                        {
                            glRotatef(tab_coo[wl_int_003][7]-180, 0.0, 0.0, 1.0);
                            glTranslatef(+(wg_x*1.5)*scale_factor, 0.0, 0.0);
                            glScalef(1.0, -1.0, 1.0);

                            glShadeModel(GL_SMOOTH);

                            glBegin(GL_QUADS);

                            if ( wg_strtr.mid(0,1).toInt() < 2 || tab_coo[wl_int_003][11] >= 0 )
                            {
                                glColor4f(tab_coo[wl_int_003][12]/(float)255,tab_coo[wl_int_003][13]/(float)255,tab_coo[wl_int_003][14]/(float)255,0.0);
                                glTexCoord2f(wg_tx/2, -wg_ty);
                                glVertex3f(wg_x*scale_factor/2 , -2.0f*scale_factor , 0.0f);

                                glColor4f(tab_coo[wl_int_003][12]/(float)255,tab_coo[wl_int_003][13]/(float)255,tab_coo[wl_int_003][14]/(float)255,0.0);
                                glTexCoord2f(wg_tx/2, 0.0);
                                glVertex3f(wg_x*scale_factor/2 , 2.0f*scale_factor , 0.0f);

                                glColor4f(tab_coo[wl_int_003][12]/(float)255,tab_coo[wl_int_003][13]/(float)255,tab_coo[wl_int_003][14]/(float)255,0.4*((float)((float)100-(float)tab_coo[wl_int_003][9])/(float)100));
                                glTexCoord2f(0.0, 0.0);
                                glVertex3f(-wg_x*scale_factor/2 , 2.0f*scale_factor , 0.0f);

                                glColor4f(tab_coo[wl_int_003][12]/(float)255,tab_coo[wl_int_003][13]/(float)255,tab_coo[wl_int_003][14]/(float)255,0.4*((float)((float)100-(float)tab_coo[wl_int_003][9])/(float)100));
                                glTexCoord2f(0.0, -wg_ty);
                                glVertex3f(-wg_x*scale_factor/2 , -2.0f*scale_factor , 0.0f);
                            }
                        }
                        else
                        {
                            if ( tab_diapo[wl_int_003][8] == "2" )
                            {
                                glRotatef(tab_coo[wl_int_003][7]+180, 0.0, 0.0, 1.0);
                                glTranslatef(-(wg_x*1.5)*scale_factor, 0.0, 0.0);
                                glScalef(1.0, -1.0, 1.0);

                                glShadeModel(GL_SMOOTH);

                                glBegin(GL_QUADS);

                                if ( wg_strtr.mid(0,1).toInt() < 2 || tab_coo[wl_int_003][11] >= 0 )
                                {

                                    glColor4f(tab_coo[wl_int_003][12]/(float)255,tab_coo[wl_int_003][13]/(float)255,tab_coo[wl_int_003][14]/(float)255,0.4*((float)((float)100-(float)tab_coo[wl_int_003][9])/(float)100));
                                    glTexCoord2f(wg_tx, -wg_ty);
                                    glVertex3f(wg_x*scale_factor/2 , -2.0f*scale_factor , 0.0f);

                                    glColor4f(tab_coo[wl_int_003][12]/(float)255,tab_coo[wl_int_003][13]/(float)255,tab_coo[wl_int_003][14]/(float)255,0.4*((float)((float)100-(float)tab_coo[wl_int_003][9])/(float)100));
                                    glTexCoord2f(wg_tx, 0.0);
                                    glVertex3f(wg_x*scale_factor/2 , 2.0f*scale_factor , 0.0f);

                                    glColor4f(tab_coo[wl_int_003][12]/(float)255,tab_coo[wl_int_003][13]/(float)255,tab_coo[wl_int_003][14]/(float)255,0.0);
                                    glTexCoord2f(wg_tx/2, 0.0);

                                    glVertex3f(-wg_x*scale_factor/2 , 2.0f*scale_factor , 0.0f);

                                    glColor4f(tab_coo[wl_int_003][12]/(float)255,tab_coo[wl_int_003][13]/(float)255,tab_coo[wl_int_003][14]/(float)255,0.0);
                                    glTexCoord2f(wg_tx/2, -wg_ty);
                                    glVertex3f(-wg_x*scale_factor/2 , -2.0f*scale_factor , 0.0f);
                                }
                            }
                            else
                            {
                                glTranslatef(0.0, -3.0f*scale_factor, 0.0);
                                glScalef(1.0, -1.0, 1.0);

                                glShadeModel(GL_SMOOTH);

                                glBegin(GL_QUADS);

                                if ( wg_strtr.mid(0,1).toInt() < 2 || tab_coo[wl_int_003][11] >= 0 )
                                {
                                    glColor4f(tab_coo[wl_int_003][12]/(float)255,tab_coo[wl_int_003][13]/(float)255,tab_coo[wl_int_003][14]/(float)255,0.4*((float)((float)100-(float)tab_coo[wl_int_003][9])/(float)100));
                                    glTexCoord2f(wg_tx, -wg_ty);
                                    glVertex3f(wg_x*scale_factor , -1.0f*scale_factor , 0.0f);

                                    glColor4f(tab_coo[wl_int_003][12]/(float)255,tab_coo[wl_int_003][13]/(float)255,tab_coo[wl_int_003][14]/(float)255,0.0);
                                    glTexCoord2f(wg_tx, -wg_ty/2);
                                    glVertex3f(wg_x*scale_factor , 1.0f*scale_factor , 0.0f);

                                    glColor4f(tab_coo[wl_int_003][12]/(float)255,tab_coo[wl_int_003][13]/(float)255,tab_coo[wl_int_003][14]/(float)255,0.0);
                                    glTexCoord2f(0.0, -wg_ty/2);
                                    glVertex3f(-wg_x*scale_factor , 1.0f*scale_factor , 0.0f);

                                    glColor4f(tab_coo[wl_int_003][12]/(float)255,tab_coo[wl_int_003][13]/(float)255,tab_coo[wl_int_003][14]/(float)255,0.4*((float)((float)100-(float)tab_coo[wl_int_003][9])/(float)100));
                                    glTexCoord2f(0.0, -wg_ty);
                                    glVertex3f(-wg_x*scale_factor , -1.0f*scale_factor , 0.0f);
                                }
                            }
                        }

                        glEnd();
                        glShadeModel(GL_FLAT);
                    }
                }
                else
                {
                    // *********************
                    // *** AUTRES OBJETS ***
                    // *********************
                    scale_factor = tab_diapo[wl_int_003][5].toFloat();

                    if ( tab_diapo[wl_int_003][0].mid(1,1) == "1" )
                    {
                        glEnable( GL_LIGHTING ) ;
                        glEnable( GL_LIGHT0 );
                        glDisable(GL_TEXTURE_2D);

                        glColor3f(1.0f,1.0f,1.0f);
                        glLoadIdentity();
                        glEnable(GL_CULL_FACE);

                        glTranslatef(tab_coo[wl_int_003][0], tab_coo[wl_int_003][1], tab_coo[wl_int_003][2]);
                        glRotatef(tab_coo[wl_int_003][5], 1.0, 0.0, 0.0);
                        glRotatef(tab_coo[wl_int_003][6], 0.0, 1.0, 0.0);
                        glRotatef(tab_coo[wl_int_003][7], 0.0, 0.0, 1.0);

                        glLoadName(wl_int_003);

                        glColorMaterial ( GL_FRONT_AND_BACK, GL_AMBIENT_AND_DIFFUSE );
                        glLightfv(GL_LIGHT0, GL_POSITION, light_position);

                        GLfloat light_ambient[] = { 0.4, 0.0, 0.0, 1.0};
                        glLightfv(GL_LIGHT0, GL_AMBIENT, light_ambient);

                        glTranslatef(0, 0, -2.5*scale_factor);

                        glColor3ub(200,0,0);
                        quadric = gluNewQuadric();

                        gluQuadricNormals(quadric, GLU_SMOOTH );

                        gluCylinder(quadric, .5*scale_factor, .5*scale_factor, 5*scale_factor, 8, 2);

                        glTranslatef(0, 0, 5*scale_factor);
                        glColor3ub(240,215,160);
                        gluCylinder(quadric, .5*scale_factor, 0*scale_factor, 1*scale_factor, 8, 2);

                        glTranslatef(0, 0, 0.5*scale_factor);
                        glColor3ub(200,0,0);
                        gluCylinder(quadric, .25*scale_factor, 0*scale_factor, 0.5*scale_factor, 10, 2);

                        glTranslatef(0, 0, -5.5*scale_factor);
                        glColor3ub(200,0,0);
                        glRotatef(180, 0, 1, 0);
                        gluDisk(quadric,0,0.5*scale_factor,8*scale_factor,8*scale_factor);

                        glDisable(GL_CULL_FACE);
                        glEnable(GL_TEXTURE_2D);
                        glDisable( GL_LIGHTING ) ;
                        glDisable( GL_LIGHT0 );
                    }
                    else
                    {
                        if ( tab_diapo[wl_int_003][0].mid(1,1) == "2" )
                        {
                            glEnable( GL_LIGHTING ) ;
                            glEnable( GL_LIGHT0 );
                            glDisable(GL_TEXTURE_2D);

                            glColor3f(1.0f,1.0f,1.0f);
                            glLoadIdentity();
                            glEnable(GL_CULL_FACE);

                            glTranslatef(tab_coo[wl_int_003][0], tab_coo[wl_int_003][1], tab_coo[wl_int_003][2]);
                            glRotatef(tab_coo[wl_int_003][5], 1.0, 0.0, 0.0);
                            glRotatef(tab_coo[wl_int_003][6], 0.0, 1.0, 0.0);
                            glRotatef(tab_coo[wl_int_003][7], 0.0, 0.0, 1.0);

                            glLoadName(wl_int_003);

                            glColorMaterial ( GL_FRONT_AND_BACK, GL_AMBIENT_AND_DIFFUSE );
                            glLightfv(GL_LIGHT0, GL_POSITION, light_position);

                            GLfloat light_ambient[] = { 0.0, 0.4, 0.0, 1.0};
                            glLightfv(GL_LIGHT0, GL_AMBIENT, light_ambient);

                            glTranslatef(0, 0, -2.5*scale_factor);

                            glColor3ub(0,200,0);
                            quadric = gluNewQuadric();
                            gluQuadricNormals(quadric, GLU_SMOOTH );

                            gluCylinder(quadric, .5*scale_factor, .5*scale_factor, 5*scale_factor, 8, 2);

                            glTranslatef(0, 0, 5*scale_factor);
                            glColor3ub(240,215,160);
                            gluCylinder(quadric, .5*scale_factor, 0*scale_factor, 1*scale_factor, 8, 2);

                            glTranslatef(0, 0, 0.5*scale_factor);
                            glColor3ub(0,200,0);
                            gluCylinder(quadric, .25*scale_factor, 0*scale_factor, 0.5*scale_factor, 10, 2);

                            glTranslatef(0, 0, -5.5*scale_factor);
                            glColor3ub(0,200,0);
                            glRotatef(180, 0, 1, 0);
                            gluDisk(quadric,0,0.5*scale_factor,8*scale_factor,8*scale_factor);

                            glDisable(GL_CULL_FACE);
                            glDisable( GL_LIGHTING ) ;
                            glDisable( GL_LIGHT0 );
                            glEnable(GL_TEXTURE_2D);
                        }
                        else
                        {
                            if ( tab_diapo[wl_int_003][0].mid(1,1) == "3" )
                            {
                                glEnable( GL_LIGHTING ) ;
                                glEnable( GL_LIGHT0 );
                                glDisable(GL_TEXTURE_2D);

                                glColor3f(1.0f,1.0f,1.0f);
                                glLoadIdentity();
                                glEnable(GL_CULL_FACE);

                                glTranslatef(tab_coo[wl_int_003][0], tab_coo[wl_int_003][1], tab_coo[wl_int_003][2]);
                                glRotatef(tab_coo[wl_int_003][5], 1.0, 0.0, 0.0);
                                glRotatef(tab_coo[wl_int_003][6], 0.0, 1.0, 0.0);
                                glRotatef(tab_coo[wl_int_003][7], 0.0, 0.0, 1.0);

                                glLoadName(wl_int_003);

                                glColorMaterial ( GL_FRONT_AND_BACK, GL_AMBIENT_AND_DIFFUSE );
                                glLightfv(GL_LIGHT0, GL_POSITION, light_position);

                                GLfloat light_ambient[] = { 0.0, 0.0, 0.4, 1.0};
                                glLightfv(GL_LIGHT0, GL_AMBIENT, light_ambient);

                                glTranslatef(0, 0, -2.5*scale_factor);

                                glColor3ub(0,0,200);
                                quadric = gluNewQuadric();
                                gluQuadricNormals(quadric, GLU_SMOOTH );

                                gluCylinder(quadric, .5*scale_factor, .5*scale_factor, 5*scale_factor, 8, 2);

                                glTranslatef(0, 0, 5*scale_factor);
                                glColor3ub(240,215,160);
                                gluCylinder(quadric, .5*scale_factor, 0*scale_factor, 1*scale_factor, 8, 2);

                                glTranslatef(0, 0, 0.5*scale_factor);
                                glColor3ub(0,0,200);
                                gluCylinder(quadric, .25*scale_factor, 0*scale_factor, 0.5*scale_factor, 10, 2);

                                glTranslatef(0, 0, -5.5*scale_factor);
                                glColor3ub(0,0,200);
                                glRotatef(180, 0, 1, 0);
                                gluDisk(quadric,0,0.5*scale_factor,8*scale_factor,8*scale_factor);

                                glDisable(GL_CULL_FACE);
                                glDisable( GL_LIGHTING ) ;
                                glDisable( GL_LIGHT0 );
                                glEnable(GL_TEXTURE_2D);
                            }
                            else
                            {
                                if ( tab_diapo[wl_int_003][0].mid(1,1) == "4" )
                                {
                                    glEnable( GL_LIGHTING ) ;
                                    glEnable( GL_LIGHT0 );
                                    glDisable(GL_TEXTURE_2D);

                                    glColor3f(1.0f,1.0f,1.0f);
                                    glLoadIdentity();
                                    glEnable(GL_CULL_FACE);

                                    glTranslatef(tab_coo[wl_int_003][0], tab_coo[wl_int_003][1], tab_coo[wl_int_003][2]);
                                    glRotatef(tab_coo[wl_int_003][5], 1.0, 0.0, 0.0);
                                    glRotatef(tab_coo[wl_int_003][6], 0.0, 1.0, 0.0);
                                    glRotatef(tab_coo[wl_int_003][7], 0.0, 0.0, 1.0);

                                    glLoadName(wl_int_003);

                                    glColorMaterial ( GL_FRONT_AND_BACK, GL_AMBIENT_AND_DIFFUSE );
                                    glLightfv(GL_LIGHT0, GL_POSITION, light_position);

                                    GLfloat light_ambient[] = { 0.4, 0.4, 0.4, 1.0};
                                    glLightfv(GL_LIGHT0, GL_AMBIENT, light_ambient);

                                    glTranslatef(0, 0, -2.5*scale_factor);

                                    glColor3ub(200,200,200);
                                    quadric = gluNewQuadric();
                                    gluQuadricNormals(quadric, GLU_SMOOTH );

                                    gluCylinder(quadric, .5*scale_factor, .5*scale_factor, 5*scale_factor, 8, 2);

                                    glTranslatef(0, 0, 5*scale_factor);
                                    glColor3ub(240,215,160);
                                    gluCylinder(quadric, .5*scale_factor, 0*scale_factor, 1*scale_factor, 8, 2);

                                    glTranslatef(0, 0, 0.5*scale_factor);
                                    glColor3ub(200,200,200);
                                    gluCylinder(quadric, .25*scale_factor, 0*scale_factor, 0.5*scale_factor, 10, 2);

                                    glTranslatef(0, 0, -5.5*scale_factor);
                                    glColor3ub(200,200,200);
                                    glRotatef(180, 0, 1, 0);
                                    gluDisk(quadric,0,0.5*scale_factor,8*scale_factor,8*scale_factor);

                                    glDisable(GL_CULL_FACE);
                                    glDisable( GL_LIGHTING ) ;
                                    glDisable( GL_LIGHT0 );
                                    glEnable(GL_TEXTURE_2D);
                                }
                                else
                                {
                                    if ( tab_diapo[wl_int_003][0].mid(1,1) == "5" ) // *** SPHERE TEXTUREE ***
                                    {
                                        glEnable( GL_LIGHTING ) ;
                                        glEnable( GL_LIGHT0 );
                                        glEnable(GL_CULL_FACE);
                                        glEnable(GL_TEXTURE_2D);

                                        glColor3f(1.0f,1.0f,1.0f);
                                        glLoadIdentity();

                                        glTranslatef(tab_coo[wl_int_003][0], tab_coo[wl_int_003][1], tab_coo[wl_int_003][2]);
                                        glRotatef(tab_coo[wl_int_003][5], 1.0, 0.0, 0.0);
                                        glRotatef(tab_coo[wl_int_003][6], 0.0, 1.0, 0.0);
                                        glRotatef(tab_coo[wl_int_003][7], 0.0, 0.0, 1.0);

                                        glLoadName(wl_int_003);

                                        glColor3ub(255,255,255);
                                        quadric = gluNewQuadric();
                                        gluQuadricNormals(quadric, GLU_SMOOTH );
                                        gluQuadricTexture(quadric,GL_TRUE);

                                        glBindTexture(GL_TEXTURE_2D,texture_diapo[wl_int_003]);
                                        gluSphere(quadric,2.0f*scale_factor,128,128);
                                        glDisable(GL_CULL_FACE);
                                        glDisable( GL_LIGHTING ) ;
                                        glDisable( GL_LIGHT0 );
                                    }
                                    else
                                    {
                                        if ( tab_diapo[wl_int_003][0].mid(1,1) == "6" )
                                        {
                                            glColor3f(1.0f,1.0f,1.0f);
                                            glLoadIdentity();

                                            glTranslatef(tab_coo[wl_int_003][0], tab_coo[wl_int_003][1], tab_coo[wl_int_003][2]);
                                            glRotatef(tab_coo[wl_int_003][5], 1.0, 0.0, 0.0);
                                            glRotatef(tab_coo[wl_int_003][6], 0.0, 1.0, 0.0);
                                            glRotatef(tab_coo[wl_int_003][7], 0.0, 0.0, 1.0);

                                            glLoadName(wl_int_003);
                                            glEnable(GL_CULL_FACE);

                                            glColorMaterial ( GL_FRONT_AND_BACK, GL_AMBIENT_AND_DIFFUSE );

                                            GLfloat light_ambient[] = { 1.0, 1.0, 1.0, 0.2};
                                            glLightfv(GL_LIGHT0, GL_AMBIENT, light_ambient);

                                            // *** FACE ARRIERE ***

                                            glBindTexture( GL_TEXTURE_2D, texture_diapo_cube[0] );

                                            glBegin(GL_QUADS);

                                            glColor4f(1.0,1.0,1.0,1.0);
                                            glTexCoord2f(0.0, 1.0);
                                            glVertex3f(-1.0f * scale_factor, -1.0f * scale_factor, -1.0f * scale_factor );

                                            glColor4f(1.0,1.0,1.0,1.0);
                                            glTexCoord2f(0.0, 0.0);
                                            glVertex3f(-1.0f * scale_factor,  1.0f * scale_factor, -1.0f * scale_factor );

                                            glColor4f(1.0,1.0,1.0,1.0);
                                            glTexCoord2f(1.0, 0.0);
                                            glVertex3f( 1.0f * scale_factor,  1.0f * scale_factor, -1.0f * scale_factor );

                                            glColor4f(1.0,1.0,1.0,1.0);
                                            glTexCoord2f(1.0, 1.0);
                                            glVertex3f( 1.0f * scale_factor, -1.0f * scale_factor, -1.0f * scale_factor );

                                            glEnd();

                                            // *** FACE DU HAUT ***
                                            glBindTexture( GL_TEXTURE_2D, texture_diapo_cube[1] );

                                            glBegin(GL_QUADS);

                                            glColor4f(1.0,1.0,1.0,1.0);
                                            glTexCoord2f(0.0, 1.0);
                                            glVertex3f(-1.0f * scale_factor,  1.0f * scale_factor , -1.0f * scale_factor );

                                            glColor4f(1.0,1.0,1.0,1.0);
                                            glTexCoord2f(0.0, 0.0);
                                            glVertex3f(-1.0f * scale_factor,  1.0f * scale_factor ,  1.0f * scale_factor );

                                            glColor4f(1.0,1.0,1.0,1.0);
                                            glTexCoord2f(1.0, 0.0);
                                            glVertex3f( 1.0f * scale_factor,  1.0f * scale_factor ,  1.0f * scale_factor );

                                            glColor4f(1.0,1.0,1.0,1.0);
                                            glTexCoord2f(1.0, 1.0);
                                            glVertex3f( 1.0f * scale_factor,  1.0f * scale_factor , -1.0f * scale_factor );

                                            glEnd();

                                            // *** FACE DU BAS ***
                                            glBindTexture( GL_TEXTURE_2D, texture_diapo_cube[2] );

                                            glBegin(GL_QUADS);

                                            glColor4f(1.0,1.0,1.0,1.0);
                                            glTexCoord2f(1.0, 1.0);
                                            glVertex3f(-1.0f * scale_factor , -1.0f * scale_factor , -1.0f * scale_factor );

                                            glColor4f(1.0,1.0,1.0,1.0);
                                            glTexCoord2f(0.0, 1.0);
                                            glVertex3f( 1.0f * scale_factor , -1.0f * scale_factor , -1.0f * scale_factor );

                                            glColor4f(1.0,1.0,1.0,1.0);
                                            glTexCoord2f(0.0, 0.0);
                                            glVertex3f( 1.0f * scale_factor , -1.0f * scale_factor ,  1.0f * scale_factor );

                                            glColor4f(1.0,1.0,1.0,1.0);
                                            glTexCoord2f(1.0, 0.0);
                                            glVertex3f(-1.0f * scale_factor , -1.0f * scale_factor ,  1.0f * scale_factor );

                                            glEnd();

                                            // *** FACE DE GAUCHE ***
                                            glBindTexture( GL_TEXTURE_2D, texture_diapo_cube[3] );

                                            glBegin(GL_QUADS);

                                            glColor4f(1.0,1.0,1.0,1.0);
                                            glTexCoord2f(0.0, 1.0);

                                            glVertex3f(-1.0f * scale_factor , -1.0f * scale_factor, -1.0f * scale_factor );

                                            glColor4f(1.0,1.0,1.0,1.0);
                                            glTexCoord2f(0.0, 0.0);
                                            glVertex3f(-1.0f * scale_factor , -1.0f * scale_factor,  1.0f * scale_factor );

                                            glColor4f(1.0,1.0,1.0,1.0);
                                            glTexCoord2f(1.0, 0.0);
                                            glVertex3f(-1.0f * scale_factor ,  1.0f * scale_factor,  1.0f * scale_factor );

                                            glColor4f(1.0,1.0,1.0,1.0);
                                            glTexCoord2f(1.0, 1.0);
                                            glVertex3f(-1.0f * scale_factor ,  1.0f * scale_factor, -1.0f * scale_factor );

                                            glEnd();

                                            // *** FACE DE DROITE ***
                                            glBindTexture( GL_TEXTURE_2D, texture_diapo_cube[4] );

                                            glBegin(GL_QUADS);

                                            glColor4f(1.0,1.0,1.0,1.0);
                                            glTexCoord2f(1.0, 1.0);
                                            glVertex3f( 1.0f * scale_factor , -1.0f * scale_factor , -1.0f * scale_factor );

                                            glColor4f(1.0,1.0,1.0,1.0);
                                            glTexCoord2f(0.0, 1.0);
                                            glVertex3f( 1.0f * scale_factor ,  1.0f * scale_factor , -1.0f * scale_factor );

                                            glColor4f(1.0,1.0,1.0,1.0);
                                            glTexCoord2f(0.0, 0.0);
                                            glVertex3f( 1.0f * scale_factor ,  1.0f * scale_factor ,  1.0f * scale_factor );

                                            glColor4f(1.0,1.0,1.0,1.0);
                                            glTexCoord2f(1.0, 0.0);
                                            glVertex3f( 1.0f * scale_factor , -1.0f * scale_factor ,  1.0f * scale_factor );

                                            glEnd();

                                            // *** FACE AVANT ***
                                            glBindTexture( GL_TEXTURE_2D, texture_diapo_cube[5] );

                                            glBegin(GL_QUADS);

                                            glColor4f(1.0,1.0,1.0,1.0);
                                            glTexCoord2f(0.0, 0.0);
                                            glVertex3f(-1.0f * scale_factor , -1.0f * scale_factor ,  1.0f * scale_factor );

                                            glColor4f(1.0,1.0,1.0,1.0);
                                            glTexCoord2f(1.0, 0.0);
                                            glVertex3f( 1.0f * scale_factor , -1.0f * scale_factor ,  1.0f * scale_factor );

                                            glColor4f(1.0,1.0,1.0,1.0);
                                            glTexCoord2f(1.0, 1.0);
                                            glVertex3f( 1.0f * scale_factor ,  1.0f * scale_factor ,  1.0f * scale_factor );

                                            glColor4f(1.0,1.0,1.0,1.0);
                                            glTexCoord2f(0.0, 1.0);
                                            glVertex3f(-1.0f * scale_factor ,  1.0f * scale_factor ,  1.0f * scale_factor );

                                            glEnd();
                                            glDisable(GL_CULL_FACE);
                                        }
                                        else
                                        {
                                            if ( tab_diapo[wl_int_003][0].mid(1,1) == "7" )
                                            {
                                                glEnable( GL_LIGHTING ) ;
                                                glEnable( GL_LIGHT0 );
                                                glEnable(GL_CULL_FACE);
                                                glEnable(GL_TEXTURE_2D);

                                                glColor3f(1.0f,1.0f,1.0f);
                                                glLoadIdentity();

                                                glTranslatef(tab_coo[wl_int_003][0], tab_coo[wl_int_003][1], tab_coo[wl_int_003][2]);
                                                glRotatef(tab_coo[wl_int_003][5], 1.0, 0.0, 0.0);
                                                glRotatef(tab_coo[wl_int_003][6], 0.0, 1.0, 0.0);
                                                glRotatef(tab_coo[wl_int_003][7], 0.0, 0.0, 1.0);

                                                glColorMaterial ( GL_FRONT_AND_BACK, GL_AMBIENT_AND_DIFFUSE );
                                                glLightfv(GL_LIGHT0, GL_POSITION, light_position);

                                                GLfloat light_ambient[] = { 1.0, 1.0, 1.0, 1.0};
                                                glLightfv(GL_LIGHT0, GL_AMBIENT, light_ambient);

                                                glLoadName(wl_int_003);

                                                glColor3ub(255,255,255);
                                                quadric = gluNewQuadric();
                                                gluQuadricNormals(quadric, GLU_SMOOTH );
                                                gluQuadricTexture(quadric,GL_TRUE);

                                                glBindTexture(GL_TEXTURE_2D,texture_diapo[44]);
                                                gluSphere(quadric,2.0f*scale_factor,128,128);
                                                glDisable(GL_CULL_FACE);
                                                glDisable( GL_LIGHTING ) ;
                                                glDisable( GL_LIGHT0 );
                                            }
                                            else
                                            {
                                                if ( tab_diapo[wl_int_003][0].mid(1,1) == "8" )
                                                {
                                                    glEnable( GL_LIGHTING ) ;
                                                    glEnable( GL_LIGHT0 );
                                                    glEnable(GL_TEXTURE_2D);

                                                    glColor3f(1.0f,1.0f,1.0f);
                                                    glLoadIdentity();
                                                    glDisable(GL_CULL_FACE);

                                                    glTranslatef(tab_coo[wl_int_003][0], tab_coo[wl_int_003][1], tab_coo[wl_int_003][2]);
                                                    glRotatef(tab_coo[wl_int_003][5], 1.0, 0.0, 0.0);
                                                    glRotatef(tab_coo[wl_int_003][6], 0.0, 1.0, 0.0);
                                                    glRotatef(tab_coo[wl_int_003][7], 0.0, 0.0, 1.0);

                                                    glLoadName(wl_int_003);

                                                    glColorMaterial ( GL_FRONT_AND_BACK, GL_AMBIENT_AND_DIFFUSE );
                                                    //glLightfv(GL_LIGHT0, GL_POSITION, light_position);

                                                    GLfloat light_ambient[] = { 1.0, 1.0, 1.0, 1.0};
                                                    glLightfv(GL_LIGHT0, GL_AMBIENT, light_ambient);

                                                    //glTranslatef(0, 0, -2.5*scale_factor);

                                                    glBegin(GL_TRIANGLE_STRIP);

                                                    glColor3f(255,255,255);

                                                    glVertex3f(-7.0*scale_factor, 0.0*scale_factor, 2.0*scale_factor);
                                                    glVertex3f(-1.0*scale_factor, 0.0*scale_factor, 3.0*scale_factor);
                                                    glVertex3f(-1.0*scale_factor, 7.0*scale_factor, 3.0*scale_factor);
                                                    glVertex3f(0.0*scale_factor, 0.0*scale_factor, 0.0*scale_factor);
                                                    glVertex3f(0.0*scale_factor, 8.0*scale_factor, 0.0*scale_factor);
                                                    glVertex3f(1.0*scale_factor, 0.0*scale_factor, 3.0*scale_factor);
                                                    glVertex3f(1.0*scale_factor, 7.0*scale_factor, 3.0*scale_factor);
                                                    glVertex3f(7.0*scale_factor, 0.0*scale_factor, 2.0*scale_factor);

                                                    glEnd();

                                                    glDisable( GL_LIGHTING ) ;
                                                    glDisable( GL_LIGHT0 );
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
            //

            wl_int_001++;
        }
    }


    if ( affiche_grille == 1 && isrendering == 0 )
    {
            glLoadIdentity();
            glTranslatef(-1.870f, -1.051f, -1.99f);
            glColor4f(1.0f,1.0f,1.0f,1.0f);
            glBegin(GL_LINES);

            for (int i=0; i<=20; i++)
            {
                    glVertex3f(0, (float)i/(float)10,0);
                    glVertex3f(4, (float)i/(float)10,0);
            }

            for (int j=0; j<=36; j++)
            {
                    glVertex3f((float)j/(float)10, 0,0);
                    glVertex3f((float)j/(float)10, 4,0);
            }
            glEnd();
    }

    if ( is_flakes > 0 ) // *** TEMPETE ***
    {
        wl_cpt_fl=0;

        wg_fl_sp_fl = (float)((float)0.2*(float)speed_flakes)/(float)100;

        while ( wl_cpt_fl < nbre_flakes )
        {
             //
             elements[wl_cpt_fl][1] = elements[wl_cpt_fl][1] - wg_fl_sp_fl;
             elements[wl_cpt_fl][0] = elements[wl_cpt_fl][0] + (elements[wl_cpt_fl][3]/100);

             if ( elements[wl_cpt_fl][1] < -1.5*(-elements[wl_cpt_fl][2]+(float)((float)prof_flakes/(float)10)) )
             {
                     elements[wl_cpt_fl][1] = -(elements[wl_cpt_fl][2]-(float)((float)prof_flakes/(float)10));
             }
             //
             glLoadIdentity();
             glBindTexture(GL_TEXTURE_2D,texture_diapo[45]);
             glTranslatef(0.0f, 0.0f, elements[wl_cpt_fl][2]-(float)((float)prof_flakes/(float)10));

             if ( mcolor_flakes == 2 )
             {
                 glColor4f(elements[wl_cpt_fl][4],elements[wl_cpt_fl][5],elements[wl_cpt_fl][6],1.0f);
             }
             else
             {
                 glColor4f(1.0f,1.0f,1.0f,1.0f);
             }

             //glBlendFunc (GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);

             glBegin(GL_QUADS);

             glTexCoord2f(1.0, 0.0);
             glVertex3f(elements[wl_cpt_fl][0], elements[wl_cpt_fl][1]-(size_flakes/100), 0.0f);

             glTexCoord2f(1.0, 1.0f);
             glVertex3f(elements[wl_cpt_fl][0], elements[wl_cpt_fl][1], 0.0f);

             glTexCoord2f(0.0f, 1.0f);
             glVertex3f(elements[wl_cpt_fl][0]-(size_flakes/100), elements[wl_cpt_fl][1], 0.0f);

             glTexCoord2f(0.0f, 0.0);
             glVertex3f((elements[wl_cpt_fl][0]-(size_flakes/100)), elements[wl_cpt_fl][1]-(size_flakes/100), 0.0f);

             glEnd();
             wl_cpt_fl++;
        }
    }

    glDisable(GL_BLEND);

    if ( is_mblur > 0 )
    {
            if ( bcle_render == 1 )
            {
                    glClear(GL_ACCUM_BUFFER_BIT);
                    glAccum(GL_LOAD, 1.0);
                    bcle_render = 2;
            }
            else
            {
                    if ( bcle_render == 2 )
                    {
                            glAccum(GL_ACCUM, 0.1);
                            glAccum(GL_MULT, 0.9);
                            glAccum(GL_RETURN, 1.0);
                    }
            }
    }

    glColorMask(GL_TRUE, GL_TRUE, GL_TRUE, GL_TRUE);
    //glFlush();
    //glFinish();
}

void Tetrahedron::f_flakes_changed(int state)
{
    is_flakes = state;
    emit flakes_act(state);
    updateGL();
}

void Tetrahedron::f_flakes_nbre_changed(int value)
{
    nbre_flakes = value;
    updateGL();
}

void Tetrahedron::f_flakes_size_changed(int value)
{
    size_flakes = value;
    updateGL();
}

void Tetrahedron::f_flakes_mcolor(int value)
{
    mcolor_flakes = value;
    updateGL();
}

void Tetrahedron::f_flakes_prof_changed(int value)
{
    prof_flakes = value;
    updateGL();
}

void Tetrahedron::f_flakes_speed_changed(int value)
{
    speed_flakes = value;
    updateGL();
}

void Tetrahedron::f_flakes_type_changed(int value)
{
    if ( is_flakes == 2 )
    {
        QImage wl_img_texture;
        if ( value == 0 )
        {
            wl_img_texture.load(":/Interface/Interface/snow.png");
        }
        else
        {
            if ( value == 1 )
            {
                wl_img_texture.load(":/Interface/Interface/snow2.png");
            }
            else
            {
                if ( value == 2 )
                {
                    wl_img_texture.load(":/Interface/Interface/feuille.png");
                }
                else
                {
                    if ( value == 3 )
                    {
                        wl_img_texture.load(":/Interface/Interface/bubble.png");
                    }
                    else
                    {
                        if ( value == 4 )
                        {
                            wl_img_texture.load(":/Interface/Interface/flower.png");
                        }
                        else
                        {
                            if ( value == 5 )
                            {
                                wl_img_texture.load(":/Interface/Interface/bug.png");
                            }
                            else
                            {
                                wl_img_texture.load(":/Interface/Interface/heart.png");
                            }
                        }
                    }
                }
            }
        }

        // *** CHARGEMENT TEXTURE POUR SNOW ***
        glDeleteTextures(1, &texture_diapo[45] );
        wl_img_texture = wl_img_texture.scaled(sm_mxw,sm_mxw,Qt::IgnoreAspectRatio);

        QImage f = QGLWidget::convertToGLFormat( wl_img_texture );

        glDeleteTextures (1,&texture_diapo[45]);
        glGenTextures (1,&texture_diapo[45]);
        glBindTexture (GL_TEXTURE_2D, texture_diapo[45]);

        glTexParameteri (GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR);
        glTexParameteri (GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR);

        glTexImage2D (GL_TEXTURE_2D, 0, GL_RGBA, f.width(), f.height(),
                      0, GL_RGBA, GL_UNSIGNED_BYTE, f.bits());
        updateGL();
    }
    type_flakes = value;
}

void Tetrahedron::f_apply_mask(int numtxt, int valpha, float fl_alpha)
{
    QString wl_tmps = QString::number(valpha);

    /*if ( wl_tmps.mid(0,2) == "10" || wl_tmps.mid(0,2) == "20" )
    {
        return;
    }*/

    glDeleteTextures(1, &texture_diapo[numtxt]);
    QImage wl_puis_001(sm_mxw,sm_mxw,QImage::Format_ARGB32_Premultiplied);

    if ( fl_alpha == 0 )
    {
        wl_puis_001 = wg_table_photo[numtxt].copy ( 0, 0, sm_mxw, sm_mxw);

        QImage f = QGLWidget::convertToGLFormat( wl_puis_001 );

        //glDeleteTextures (1,&texture_diapo[numtxt]);
        glGenTextures (1,&texture_diapo[numtxt]);
        glBindTexture (GL_TEXTURE_2D, texture_diapo[numtxt]);

        glTexParameteri (GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR);
        glTexParameteri (GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR);

        glTexImage2D (GL_TEXTURE_2D, 0, GL_RGBA, f.width(), f.height(),
                      0, GL_RGBA, GL_UNSIGNED_BYTE, f.bits());

        return;
    }

    if ( wl_tmps.mid(0,2) == "11" )
    {
        wg_alpha.load(QDir::homePath() + "/.2ManDVD_Library/" +"/Bibliotheque/Luma/Recouvrement_droite.png");
    }
    else
    {
        if ( wl_tmps.mid(0,2) == "12" )
        {
            wg_alpha.load(QDir::homePath() + "/.2ManDVD_Library/" +"/Bibliotheque/Luma/Recouvrement_gauche.png");
        }
        else
        {
            if ( wl_tmps.mid(0,2) == "13" )
            {
                wg_alpha.load(QDir::homePath() + "/.2ManDVD_Library/" +"/Bibliotheque/Luma/Recouvrement_haut.png");
            }
            else
            {
                if ( wl_tmps.mid(0,2) == "14" )
                {
                    wg_alpha.load(QDir::homePath() + "/.2ManDVD_Library/" +"/Bibliotheque/Luma/Recouvrement_bas.png");
                }
                else
                {
                    if ( wl_tmps.mid(0,2) == "15" )
                    {
                        wg_alpha.load(QDir::homePath() + "/.2ManDVD_Library/" +"/Bibliotheque/Luma/Coeur.png");
                    }
                    else
                    {
                        if ( wl_tmps.mid(0,2) == "16" )
                        {
                            wg_alpha.load(QDir::homePath() + "/.2ManDVD_Library/" +"/Bibliotheque/Luma/Vague_001.png");
                        }
                        else
                        {
                            if ( wl_tmps.mid(0,2) == "17" )
                            {
                                wg_alpha.load(QDir::homePath() + "/.2ManDVD_Library/" +"/Bibliotheque/Luma/Rond_001.png");
                            }
                            else
                            {
                                if ( wl_tmps.mid(0,2) == "18" )
                                {
                                    wg_alpha.load(QDir::homePath() + "/.2ManDVD_Library/" +"/Bibliotheque/Luma/Sinus1.png");
                                }
                                else
                                {
                                    if ( wl_tmps.mid(0,2) == "19" )
                                    {
                                        wg_alpha.load(QDir::homePath() + "/.2ManDVD_Library/" +"/Bibliotheque/Luma/Brule_002.png");
                                    }
                                    else
                                    {
                                        if ( wl_tmps.mid(0,2) == "20" )
                                        {
                                            wg_alpha.load(QDir::homePath() + "/.2ManDVD_Library/" +"/Bibliotheque/Luma/Blob.png");
                                        }
                                        else
                                        {
                                            if ( wl_tmps.mid(0,2) == "21" )
                                            {
                                                wg_alpha.load(QDir::homePath() + "/.2ManDVD_Library/" +"/Bibliotheque/Luma/Vague_002.png");
                                            }
                                            else
                                            {
                                                if ( wl_tmps.mid(0,2) == "22" )
                                                {
                                                    wg_alpha.load(QDir::homePath() + "/.2ManDVD_Library/" +"/Bibliotheque/Luma/special_effect02.png");
                                                }
                                                else
                                                {
                                                    if ( wl_tmps.mid(0,2) == "23" )
                                                    {
                                                        wg_alpha.load(QDir::homePath() + "/.2ManDVD_Library/" +"/Bibliotheque/Luma/polar.png");
                                                    }
                                                    else
                                                    {
                                                        if ( wl_tmps.mid(0,2) == "24" )
                                                        {
                                                            wg_alpha.load(QDir::homePath() + "/.2ManDVD_Library/" +"/Bibliotheque/Luma/Carre_006.png");
                                                        }
                                                        else
                                                        {
                                                            wg_alpha.load(QDir::homePath() + "/.2ManDVD_Library/" +"/Bibliotheque/Luma/Carre_007.png");
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    if ( tab_diapo[numtxt][7] != "0/0/0/0" )
    {
        wg_alpha = wg_alpha.scaled(tab_diapo[numtxt][1].toInt(),tab_diapo[numtxt][2].toInt(),Qt::IgnoreAspectRatio); //tab_diapo[numtxt][1].toInt(), tab_diapo[numtxt][2].toInt(),Qt::IgnoreAspectRatio);
    }
    else
    {
        wg_alpha = wg_alpha.scaled(wg_table_photo[numtxt].width()*((float)((float)tab_diapo[numtxt][1].toFloat()/(float)sm_mxw)),wg_table_photo[numtxt].height()*((float)((float)tab_diapo[numtxt][2].toFloat()/(float)sm_mxw)),Qt::IgnoreAspectRatio); //tab_diapo[numtxt][1].toInt(), tab_diapo[numtxt][2].toInt(),Qt::IgnoreAspectRatio);
    }

    QImage dstImage(sm_mxw,sm_mxw,QImage::Format_ARGB32);
    dstImage.fill(0);

    //wg_alpha_trans = wl_tmps.mid(2,wl_tmps.length()-2).toInt();

    thmsk *mytmsk = new thmsk();

    mytmsk->wl_img_texture = &wg_table_photo[numtxt];
    mytmsk->alpha = fl_alpha;
    mytmsk->mix = 0;
    mytmsk->max = wg_alpha.width();
    mytmsk->miy = 0;
    mytmsk->may = wg_alpha.height()/2;
    mytmsk->dstImage = &dstImage;
    mytmsk->wl_alpha = wg_alpha;

    thmsk *mytmsk2 = new thmsk();

    mytmsk2->wl_img_texture = &wg_table_photo[numtxt];
    mytmsk2->alpha = fl_alpha;
    mytmsk2->mix = 0;
    mytmsk2->max = wg_alpha.width();
    mytmsk2->miy = wg_alpha.height()/2;
    mytmsk2->may = wg_alpha.height();
    mytmsk2->dstImage = &dstImage;
    mytmsk2->wl_alpha = wg_alpha;

    mytmsk->start();
    mytmsk2->start();
    mytmsk->wait();
    mytmsk2->wait();

    QImage f = QGLWidget::convertToGLFormat( dstImage );

    glGenTextures (1,&texture_diapo[numtxt]);
    glBindTexture (GL_TEXTURE_2D, texture_diapo[numtxt]);

    glTexParameteri (GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR);
    glTexParameteri (GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR);

    glTexImage2D (GL_TEXTURE_2D, 0, GL_RGBA, f.width(), f.height(),
                  0, GL_RGBA, GL_UNSIGNED_BYTE, f.bits());

    delete mytmsk;
    delete mytmsk2;
}

void Tetrahedron::draw_select()
{
    glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);

    int wl_int_001 = 1;
    glInitNames();
    glPushName(-1);

    // *** CLASSEMENT ORDRE Z ***

    while ( wl_int_001 < nombre_diapos+1 )
    {
        tab_order[wl_int_001][0] = 10;
        tab_order[wl_int_001][1] = 0;
        wl_int_001++;
    }

    wl_int_001 = 1;
    int wl_int_002;
    int wl_int_003;

    while ( wl_int_001 < nombre_diapos+1 )
    {
        wl_int_002 = 1;
        while ( tab_coo[wl_int_001][2] > tab_order[wl_int_002][0] && tab_order[wl_int_002][1] != 0 )
        {
            wl_int_002++;
        }

        if ( tab_order[wl_int_002][1] < 1 )
        {
            tab_order[wl_int_002][0] = tab_coo[wl_int_001][2];
            tab_order[wl_int_002][1] = wl_int_001;
        }
        else
        {
            wl_int_003 = wl_int_002;
            while ( tab_order[wl_int_003][1] > 0 )
            {
                wl_int_003++;
            }
            while ( wl_int_003 > wl_int_002 )
            {
                tab_order[wl_int_003][0] = tab_order[wl_int_003-1][0];
                tab_order[wl_int_003][1] = tab_order[wl_int_003-1][1];
                wl_int_003--;
            }
            tab_order[wl_int_002][0] = tab_coo[wl_int_001][2];
            tab_order[wl_int_002][1] = wl_int_001;
        }
        wl_int_001++;
    }

    wl_int_001 = 1;
    quadric = gluNewQuadric();

    while ( wl_int_001 < nombre_diapos+1 )
    {
        glLoadIdentity();

        wl_int_003 = tab_order[wl_int_001][1];

        if ( tab_msk[wl_int_003] == true && tab_coo[wl_int_003][9] < 100 )
        {
            if ( tab_diapo[wl_int_003][0].mid(0,1) != "?" )
            {
                scale_factor = tab_diapo[wl_int_003][5].toFloat();

                glTranslatef(tab_coo[wl_int_003][0], tab_coo[wl_int_003][1], tab_coo[wl_int_003][2]);
                glRotatef(tab_coo[wl_int_003][5], 1.0, 0.0, 0.0);
                glRotatef(tab_coo[wl_int_003][6], 0.0, 1.0, 0.0);
                glRotatef(tab_coo[wl_int_003][7], 0.0, 0.0, 1.0);

                glLoadName(wl_int_003);

                glBegin(GL_QUADS);
                glColor3ub(10+(wl_int_003*10),0,0);

                if ( tab_diapo[wl_int_003][7] == "0/0/0/0" )
                {
                    wg_x = (float)(0-(2 * (tab_diapo[wl_int_003][1].toFloat() / tab_diapo[wl_int_003][2].toFloat()))) * -1;
                }
                else
                {
                    QStringList wl_explode = tab_diapo[wl_int_003][7].split("/",QString::KeepEmptyParts);

                    wg_x = (float)(0-(2 * ((wl_explode.at(2).toFloat()-wl_explode.at(0).toFloat()) / (wl_explode.at(3).toFloat()-wl_explode.at(1).toFloat())))) * -1;
                }

                /*glVertex3f(wg_x*scale_factor , -2.0f*scale_factor , 0.0f);
                glVertex3f(wg_x*scale_factor , 2.0f*scale_factor , 0.0f);
                glVertex3f(-wg_x*scale_factor , 2.0f*scale_factor , 0.0f);
                glVertex3f(-wg_x*scale_factor , -2.0f*scale_factor , 0.0f);*/

                glVertex3f(wg_x*scale_factor*(tab_coo[wl_int_003][15]/100.0) , -2.0f*scale_factor*(tab_coo[wl_int_003][16]/100.0) , 0.0f);
                glVertex3f(wg_x*scale_factor*(tab_coo[wl_int_003][15]/100.0) , 2.0f*scale_factor*(tab_coo[wl_int_003][4]/100.0) , 0.0f);
                glVertex3f(-wg_x*scale_factor*(tab_coo[wl_int_003][3]/100.0) , 2.0f*scale_factor*(tab_coo[wl_int_003][4]/100.0) , 0.0f);
                glVertex3f(-wg_x*scale_factor*(tab_coo[wl_int_003][3]/100.0) , -2.0f*scale_factor*(tab_coo[wl_int_003][16]/100.0) , 0.0f);


                glEnd();
            }
            else
            {
                // *********************
                // *** AUTRES OBJETS ***
                // *********************
                scale_factor = tab_diapo[wl_int_003][5].toFloat();

                glTranslatef(tab_coo[wl_int_003][0], tab_coo[wl_int_003][1], tab_coo[wl_int_003][2]);
                glRotatef(tab_coo[wl_int_003][5], 1.0, 0.0, 0.0);
                glRotatef(tab_coo[wl_int_003][6], 0.0, 1.0, 0.0);
                glRotatef(tab_coo[wl_int_003][7], 0.0, 0.0, 1.0);

                glColor3ub(10+(wl_int_003*10),0,0);

                if ( tab_diapo[wl_int_003][0].mid(1,1) == "1" )
                {
                    glLoadName(wl_int_003);

                    glTranslatef(0, 0, -2.5*scale_factor);

                    quadric = gluNewQuadric();
                    gluQuadricNormals(quadric, GLU_SMOOTH );

                    gluCylinder(quadric, .5*scale_factor, .5*scale_factor, 5*scale_factor, 8, 2);

                    glTranslatef(0, 0, 5*scale_factor);
                    gluCylinder(quadric, .5*scale_factor, 0*scale_factor, 1*scale_factor, 8, 2);

                    glTranslatef(0, 0, 0.5*scale_factor);
                    gluCylinder(quadric, .25*scale_factor, 0*scale_factor, 0.5*scale_factor, 10, 2);

                    glTranslatef(0, 0, -5.5*scale_factor);
                    glRotatef(180, 0, 1, 0);
                    gluDisk(quadric,0,0.5*scale_factor,8*scale_factor,8*scale_factor);
                }
                else
                {
                    if ( tab_diapo[wl_int_003][0].mid(1,1) == "2" )
                    {
                        glLoadName(wl_int_003);

                        glTranslatef(0, 0, -2.5*scale_factor);

                        quadric = gluNewQuadric();
                        gluQuadricNormals(quadric, GLU_SMOOTH );

                        gluCylinder(quadric, .5*scale_factor, .5*scale_factor, 5*scale_factor, 8, 2);

                        glTranslatef(0, 0, 5*scale_factor);
                        gluCylinder(quadric, .5*scale_factor, 0*scale_factor, 1*scale_factor, 8, 2);

                        glTranslatef(0, 0, 0.5*scale_factor);
                        gluCylinder(quadric, .25*scale_factor, 0*scale_factor, 0.5*scale_factor, 10, 2);

                        glTranslatef(0, 0, -5.5*scale_factor);
                        glRotatef(180, 0, 1, 0);
                        gluDisk(quadric,0,0.5*scale_factor,8*scale_factor,8*scale_factor);
                    }
                    else
                    {
                        if ( tab_diapo[wl_int_003][0].mid(1,1) == "3" )
                        {
                            glLoadName(wl_int_003);

                            glTranslatef(0, 0, -2.5*scale_factor);

                            quadric = gluNewQuadric();
                            gluQuadricNormals(quadric, GLU_SMOOTH );

                            gluCylinder(quadric, .5*scale_factor, .5*scale_factor, 5*scale_factor, 8, 2);

                            glTranslatef(0, 0, 5*scale_factor);
                            gluCylinder(quadric, .5*scale_factor, 0*scale_factor, 1*scale_factor, 8, 2);

                            glTranslatef(0, 0, 0.5*scale_factor);
                            gluCylinder(quadric, .25*scale_factor, 0*scale_factor, 0.5*scale_factor, 10, 2);

                            glTranslatef(0, 0, -5.5*scale_factor);
                            glRotatef(180, 0, 1, 0);
                            gluDisk(quadric,0,0.5*scale_factor,8*scale_factor,8*scale_factor);
                        }
                        else
                        {
                            if ( tab_diapo[wl_int_003][0].mid(1,1) == "4" )
                            {
                                glLoadName(wl_int_003);

                                glTranslatef(0, 0, -2.5*scale_factor);

                                quadric = gluNewQuadric();
                                gluQuadricNormals(quadric, GLU_SMOOTH );

                                gluCylinder(quadric, .5*scale_factor, .5*scale_factor, 5*scale_factor, 8, 2);

                                glTranslatef(0, 0, 5*scale_factor);
                                gluCylinder(quadric, .5*scale_factor, 0*scale_factor, 1*scale_factor, 8, 2);

                                glTranslatef(0, 0, 0.5*scale_factor);
                                gluCylinder(quadric, .25*scale_factor, 0*scale_factor, 0.5*scale_factor, 10, 2);

                                glTranslatef(0, 0, -5.5*scale_factor);
                                glRotatef(180, 0, 1, 0);
                                gluDisk(quadric,0,0.5*scale_factor,8*scale_factor,8*scale_factor);
                            }
                            else
                            {
                                if ( tab_diapo[wl_int_003][0].mid(1,1) == "5" )
                                {
                                    glLoadName(wl_int_003);

                                    quadric = gluNewQuadric();
                                    gluQuadricNormals(quadric, GLU_SMOOTH );
                                    gluQuadricTexture(quadric,GL_TRUE);
                                    gluSphere(quadric,2.0f*scale_factor,128,128);
                                }
                                else
                                {
                                    if ( tab_diapo[wl_int_003][0].mid(1,1) == "6" )
                                    {
                                        glLoadName(wl_int_003);

                                        glBegin(GL_QUADS);

                                        // *** FACE ARRIERE ***
                                        glVertex3f(-1.0f * scale_factor, -1.0f * scale_factor, -1.0f * scale_factor );
                                        glVertex3f(-1.0f * scale_factor,  1.0f * scale_factor, -1.0f * scale_factor );
                                        glVertex3f( 1.0f * scale_factor,  1.0f * scale_factor, -1.0f * scale_factor );
                                        glVertex3f( 1.0f * scale_factor, -1.0f * scale_factor, -1.0f * scale_factor );

                                        // *** FACE DU HAUT ***
                                        glVertex3f(-1.0f * scale_factor,  1.0f * scale_factor , -1.0f * scale_factor );
                                        glVertex3f(-1.0f * scale_factor,  1.0f * scale_factor ,  1.0f * scale_factor );
                                        glVertex3f( 1.0f * scale_factor,  1.0f * scale_factor ,  1.0f * scale_factor );
                                        glVertex3f( 1.0f * scale_factor,  1.0f * scale_factor , -1.0f * scale_factor );

                                        // *** FACE DU BAS ***
                                        glVertex3f(-1.0f * scale_factor , -1.0f * scale_factor , -1.0f * scale_factor );
                                        glVertex3f( 1.0f * scale_factor , -1.0f * scale_factor , -1.0f * scale_factor );
                                        glVertex3f( 1.0f * scale_factor , -1.0f * scale_factor ,  1.0f * scale_factor );
                                        glVertex3f(-1.0f * scale_factor , -1.0f * scale_factor ,  1.0f * scale_factor );

                                        // *** FACE DE GAUCHE ***
                                        glVertex3f(-1.0f * scale_factor , -1.0f * scale_factor, -1.0f * scale_factor );
                                        glVertex3f(-1.0f * scale_factor , -1.0f * scale_factor,  1.0f * scale_factor );
                                        glVertex3f(-1.0f * scale_factor ,  1.0f * scale_factor,  1.0f * scale_factor );
                                        glVertex3f(-1.0f * scale_factor ,  1.0f * scale_factor, -1.0f * scale_factor );

                                        // *** FACE DE DROITE ***
                                        glVertex3f( 1.0f * scale_factor , -1.0f * scale_factor , -1.0f * scale_factor );
                                        glVertex3f( 1.0f * scale_factor ,  1.0f * scale_factor , -1.0f * scale_factor );
                                        glVertex3f( 1.0f * scale_factor ,  1.0f * scale_factor ,  1.0f * scale_factor );
                                        glVertex3f( 1.0f * scale_factor , -1.0f * scale_factor ,  1.0f * scale_factor );

                                        // *** FACE AVANT ***
                                        glVertex3f(-1.0f * scale_factor , -1.0f * scale_factor ,  1.0f * scale_factor );
                                        glVertex3f( 1.0f * scale_factor , -1.0f * scale_factor ,  1.0f * scale_factor );
                                        glVertex3f( 1.0f * scale_factor ,  1.0f * scale_factor ,  1.0f * scale_factor );
                                        glVertex3f(-1.0f * scale_factor ,  1.0f * scale_factor ,  1.0f * scale_factor );

                                        glEnd();
                                    }
                                    else
                                    {
                                        if ( tab_diapo[wl_int_003][0].mid(1,1) == "7" )
                                        {
                                            glLoadName(wl_int_003);

                                            quadric = gluNewQuadric();
                                            gluQuadricNormals(quadric, GLU_SMOOTH );

                                            gluSphere(quadric,1.0f*scale_factor,25,25);
                                        }
                                        else
                                        {
                                            if ( tab_diapo[wl_int_003][0].mid(1,1) == "8" )
                                            {
                                                glLoadName(wl_int_003);

                                                glBegin(GL_TRIANGLE_STRIP);

                                                glVertex3f(-7.0*scale_factor, 0.0*scale_factor, 2.0*scale_factor);
                                                glVertex3f(-1.0*scale_factor, 0.0*scale_factor, 3.0*scale_factor);
                                                glVertex3f(-1.0*scale_factor, 7.0*scale_factor, 3.0*scale_factor);
                                                glVertex3f(0.0*scale_factor, 0.0*scale_factor, 0.0*scale_factor);
                                                glVertex3f(0.0*scale_factor, 8.0*scale_factor, 0.0*scale_factor);
                                                glVertex3f(1.0*scale_factor, 0.0*scale_factor, 3.0*scale_factor);
                                                glVertex3f(1.0*scale_factor, 7.0*scale_factor, 3.0*scale_factor);
                                                glVertex3f(7.0*scale_factor, 0.0*scale_factor, 2.0*scale_factor);

                                                glEnd();
                                            }
                                            else
                                            {
                                                scale_factor = tab_diapo[wl_int_003][5].toFloat();

                                                glLoadName(wl_int_003);

                                                glBegin(GL_QUADS);

                                                if ( tab_diapo[wl_int_003][7] == "0/0/0/0" )
                                                {
                                                    wg_x = (float)(0-(2 * (tab_diapo[wl_int_003][1].toFloat() / tab_diapo[wl_int_003][2].toFloat()))) * -1;
                                                }
                                                else
                                                {
                                                    QStringList wl_explode = tab_diapo[wl_int_003][7].split("/",QString::KeepEmptyParts);

                                                    wg_x = (float)(0-(2 * ((wl_explode.at(2).toFloat()-wl_explode.at(0).toFloat()) / (wl_explode.at(3).toFloat()-wl_explode.at(1).toFloat())))) * -1;
                                                }

                                                glVertex3f(wg_x*scale_factor , -2.0f*scale_factor , 0.0f);
                                                glVertex3f(wg_x*scale_factor , 2.0f*scale_factor , 0.0f);
                                                glVertex3f(-wg_x*scale_factor , 2.0f*scale_factor , 0.0f);
                                                glVertex3f(-wg_x*scale_factor , -2.0f*scale_factor , 0.0f);

                                                glEnd();
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        //

        wl_int_001++;
    }
}

// *****************************
// *** SELECTION DE L'OUTILS ***
// *****************************

void Tetrahedron::f_change_tool_grab()
{
    tool = 0;
    wg_has_mx = 0;
    wg_has_my = 0;
    wg_has_mz = 0;
    emit tool_change(0);
}

void Tetrahedron::f_change_tool_grab_x()
{
    tool = 0;
    wg_has_mx = 1;
    wg_has_my = 0;
    wg_has_mz = 0;
    emit tool_change(0);
}

void Tetrahedron::f_change_tool_grab_y()
{
    tool = 0;
    wg_has_mx = 0;
    wg_has_my = 1;
    wg_has_mz = 0;
    emit tool_change(0);
}

void Tetrahedron::f_change_ef_image()
{
    emit tool_ef_image();
}

void Tetrahedron::f_change_tool_rotate_x()
{
    tool = 1;
    emit tool_change(1);
}

void Tetrahedron::f_change_tool_rotate_y()
{
    tool = 2;
    emit tool_change(2);
}

void Tetrahedron::f_change_tool_rotate_z()
{
    tool = 3;
    emit tool_change(3);
}

void Tetrahedron::f_change_tool_rotate_x_fi()
{
    tool = 1;
}

void Tetrahedron::f_change_tool_rotate_y_fi()
{
    tool = 2;
}

void Tetrahedron::f_change_tool_rotate_z_fi()
{
    tool = 3;
}

void Tetrahedron::f_change_tool_grab_fi()
{
    tool = 0;
}

// **************************
// *** FONCTIONS TIMELINE ***
// **************************

void Tetrahedron::f_mark_pos(int pos_timeline, int visible, int opacite, int blur, int red, int green, int blue, int x1, int y1, int x2, int y2)
{
    if ( num_select > 0 )
    {
        if ( is_ctrl == 0 )
        {
            int j = 0;
            int ok = 0;
            QStringList wl_exp;

            while ( j < 20 && tab_coo_timeline[num_select][j] != "" && ok == 0 )
            {
                wl_exp = tab_coo_timeline[num_select][j].split(":",QString::SkipEmptyParts);
                if ( wl_exp.at(0).toInt() == pos_timeline || wl_exp.at(0).toInt() > pos_timeline )
                {
                    ok = 1;
                }
                else
                {
                    j++;
                }
            }

            if ( j == 20 )
            {
                QMessageBox::information(this, name_application, tr("Nombre maximum de keyframe pour cette image atteint."));
                return;
            }

            if ( ok == 1 )
            {
                if ( wl_exp.at(0).toInt() == pos_timeline )
                {
                    tab_coo_timeline[num_select][j] = QString::number(pos_timeline) + ":" + QString::number(tab_coo[num_select][0]) + ":" + QString::number(tab_coo[num_select][1]) + ":" + QString::number(tab_coo[num_select][2]) + ":" + QString::number(tab_coo[num_select][5]) + ":" + QString::number(tab_coo[num_select][6]) + ":" + QString::number(tab_coo[num_select][7]) + ":" + wl_exp.at(7) + ":" + QString::number(opacite) + ":" + QString::number(blur) + ":" + QString::number(red) + ":" + QString::number(green) + ":" + QString::number(blue) + ":" + QString::number(x1) + ":" + QString::number(y1) + ":" + QString::number(x2) + ":" + QString::number(y2);
                }
                else
                {
                    int wl_int_001 = j;
                    while ( wl_int_001 < 20 && tab_coo_timeline[num_select][wl_int_001] != "" )
                    {
                        wl_int_001++;
                    }

                    while ( wl_int_001 > j )
                    {
                        tab_coo_timeline[num_select][wl_int_001] = tab_coo_timeline[num_select][wl_int_001-1];
                        wl_int_001--;
                    }
                    tab_coo_timeline[num_select][j] = QString::number(pos_timeline) + ":" + QString::number(tab_coo[num_select][0]) + ":" + QString::number(tab_coo[num_select][1]) + ":" + QString::number(tab_coo[num_select][2]) + ":" + QString::number(tab_coo[num_select][5]) + ":" + QString::number(tab_coo[num_select][6]) + ":" + QString::number(tab_coo[num_select][7]) + ":" + QString::number(visible) + ":" + QString::number(opacite) + ":" + QString::number(blur) + ":" + QString::number(red) + ":" + QString::number(green) + ":" + QString::number(blue) + ":" + QString::number(x1) + ":" + QString::number(y1) + ":" + QString::number(x2) + ":" + QString::number(y2);

                    j = 0;
                    while ( j < 10 )
                    {
                        j++;
                    }
                }
            }
            else
            {
                tab_coo_timeline[num_select][j] = QString::number(pos_timeline) + ":" + QString::number(tab_coo[num_select][0]) + ":" + QString::number(tab_coo[num_select][1]) + ":" + QString::number(tab_coo[num_select][2]) + ":" + QString::number(tab_coo[num_select][5]) + ":" + QString::number(tab_coo[num_select][6]) + ":" + QString::number(tab_coo[num_select][7]) + ":" + QString::number(visible) + ":" + QString::number(opacite) + ":" + QString::number(blur) + ":" + QString::number(red) + ":" + QString::number(green) + ":" + QString::number(blue) + ":" + QString::number(x1) + ":" + QString::number(y1) + ":" + QString::number(x2) + ":" + QString::number(y2);
            }

            position_timeline = pos_timeline;

            emit dia_select(num_select);
        }
        else
        {
            int wl_int_001 = 1;
            int wl_int_002;
            int j = 0;
            int ok = 0;
            QStringList wl_exp;

            while ( wl_int_001 <= nombre_diapos )
            {
                j = 0;
                ok = 0;

                while ( j < 20 && tab_coo_timeline[wl_int_001][j] != "" && ok == 0 )
                {
                    wl_exp = tab_coo_timeline[wl_int_001][j].split(":",QString::SkipEmptyParts);
                    if ( wl_exp.at(0).toInt() == pos_timeline || wl_exp.at(0).toInt() > pos_timeline )
                    {
                        ok = 1;
                    }
                    else
                    {
                        j++;
                    }
                }

                /*if ( j == 20 )
                {
                    QMessageBox::information(this, name_application, tr("Nombre maximum de keyframe pour cette image atteint."));
                    return;
                }*/

                if ( ok == 1 )
                {
                    if ( wl_exp.at(0).toInt() == pos_timeline )
                    {
                        tab_coo_timeline[wl_int_001][j] = QString::number(pos_timeline) + ":" + QString::number(tab_coo[wl_int_001][0]) + ":" + QString::number(tab_coo[wl_int_001][1]) + ":" + QString::number(tab_coo[wl_int_001][2]) + ":" + QString::number(tab_coo[wl_int_001][5]) + ":" + QString::number(tab_coo[wl_int_001][6]) + ":" + QString::number(tab_coo[wl_int_001][7]) + ":" + wl_exp.at(7) + ":" + QString::number(opacite) + ":" + QString::number(blur) + ":" + QString::number(red) + ":" + QString::number(green) + ":" + QString::number(blue) + ":" + QString::number(x1) + ":" + QString::number(y1) + ":" + QString::number(x2) + ":" + QString::number(y2);
                    }
                    else
                    {
                        wl_int_002 = j;
                        while ( wl_int_002 < 20 && tab_coo_timeline[wl_int_001][wl_int_002] != "" )
                        {
                            wl_int_002++;
                        }

                        while ( wl_int_002 > j )
                        {
                            tab_coo_timeline[wl_int_001][wl_int_002] = tab_coo_timeline[wl_int_001][wl_int_002-1];
                            wl_int_002--;
                        }
                        tab_coo_timeline[wl_int_001][j] = QString::number(pos_timeline) + ":" + QString::number(tab_coo[wl_int_001][0]) + ":" + QString::number(tab_coo[wl_int_001][1]) + ":" + QString::number(tab_coo[wl_int_001][2]) + ":" + QString::number(tab_coo[wl_int_001][5]) + ":" + QString::number(tab_coo[wl_int_001][6]) + ":" + QString::number(tab_coo[wl_int_001][7]) + ":" + QString::number(visible) + ":" + QString::number(opacite) + ":" + QString::number(blur) + ":" + QString::number(red) + ":" + QString::number(green) + ":" + QString::number(blue) + ":" + QString::number(x1) + ":" + QString::number(y1) + ":" + QString::number(x2) + ":" + QString::number(y2);

                        j = 0;
                        while ( j < 10 )
                        {
                            j++;
                        }
                    }
                }
                else
                {
                    tab_coo_timeline[wl_int_001][j] = QString::number(pos_timeline) + ":" + QString::number(tab_coo[wl_int_001][0]) + ":" + QString::number(tab_coo[wl_int_001][1]) + ":" + QString::number(tab_coo[wl_int_001][2]) + ":" + QString::number(tab_coo[wl_int_001][5]) + ":" + QString::number(tab_coo[wl_int_001][6]) + ":" + QString::number(tab_coo[wl_int_001][7]) + ":" + QString::number(visible) + ":" + QString::number(opacite) + ":" + QString::number(blur) + ":" + QString::number(red) + ":" + QString::number(green) + ":" + QString::number(blue) + ":" + QString::number(x1) + ":" + QString::number(y1) + ":" + QString::number(x2) + ":" + QString::number(y2);
                }

                wl_int_001++;
            }
            position_timeline = pos_timeline;

            emit dia_select(num_select);
        }
    }
}

void Tetrahedron::f_mark_vis(int pos_timeline, int visible)
{
    if ( num_select > 0 )
    {
        int j = 0;
        int ok = 0;
        QStringList wl_exp;

        while ( j < 20 && tab_coo_timeline[num_select][j] != "" && ok == 0 )
        {
            wl_exp = tab_coo_timeline[num_select][j].split(":",QString::SkipEmptyParts);
            if ( wl_exp.at(0).toInt() == pos_timeline || wl_exp.at(0).toInt() > pos_timeline )
            {
                ok = 1;
            }
            else
            {
                j++;
            }
        }

        if ( ok == 1 )
        {
            if ( wl_exp.at(0).toInt() == pos_timeline )
            {
                QString visibletr = QString::number(visible);
                    QString visibletr2;

                    if ( visibletr.mid(0,1) == "2" )
                    {
                        visibletr2 = "2" + visibletr.mid(1,visibletr.length()-1);
                    }
                    else
                    {
                        visibletr2 = "1" + visibletr.mid(1,visibletr.length()-1);
                    }

                    tab_coo_timeline[num_select][j] = wl_exp.at(0) + ":" + wl_exp.at(1) + ":" + wl_exp.at(2) + ":" + wl_exp.at(3) + ":" + wl_exp.at(4) + ":" + wl_exp.at(5) + ":" + wl_exp.at(6) + ":" + visibletr2 + ":" + wl_exp.at(8) + ":" + wl_exp.at(9) + ":" + wl_exp.at(10) + ":" + wl_exp.at(11) + ":" + wl_exp.at(12) + ":" + wl_exp.at(13) + ":" + wl_exp.at(14) + ":" + wl_exp.at(15) + ":" + wl_exp.at(16);
            }
            else
            {
                qDebug() << "ERROR CHANGING VIEW STATE - NO MATCHING POINT FOUND (ERR 1)";
            }
        }
        else
        {
            qDebug() << "ERROR CHANGING VIEW STATE - NO MATCHING POINT FOUND (ERR 2)";
        }

        position_timeline = pos_timeline;

        emit dia_select(num_select);
    }
}

void Tetrahedron::f_follow_timeline(int position)
{
    position_timeline = position;

    int i = 1;
    int j = 0;

    minpos = 0;
    maxpos = 10000;

    minidx = 0;
    maxidx = 0;

    dep_opa = 0;
    fin_opa = 0;
    dep_blur = 0;
    fin_blur = 0;

    wl_cl = 0;
    wl_ix = 0;

    QImage wl_puis_001(sm_mxw,sm_mxw,QImage::Format_ARGB32_Premultiplied);
    QImage wl_img_texture;
    QImage wl_over_mask;
    QImage f;
    QString wl_tmps;
    QImage wl_image_2;
    QPainter g;

    while ( i <= nombre_diapos )
    {
        j = 0;

        while ( tab_coo_timeline[i][j] != "" )
        {
            wg_stringlist_002 = tab_coo_timeline[i][j].split(":",QString::SkipEmptyParts);

            if ( wg_stringlist_002.at(0).toInt() < position && wg_stringlist_002.at(0).toInt() > minpos )
            {
                minidx = j;
                minpos = wg_stringlist_002.at(0).toInt();
            }
            if ( wg_stringlist_002.at(0).toInt() >= position && wg_stringlist_002.at(0).toInt() < maxpos )
            {
                maxidx = j;
                maxpos = wg_stringlist_002.at(0).toInt();
            }
            j++;
        }

        if ( tab_diapo[i][0].right(4) == ".gif" || tab_diapo[i][0].right(4) == ".GIF" )
        {
            // *** LECTURE FRAME GIF ANIME ***

            wl_cl = 0;
            wl_ix = 0;

            tabgif[i].jumpToFrame(0);

            while ( wl_ix < tabgif[i].frameCount() )
            {
                wl_cl = wl_cl + tabgif[i].nextFrameDelay();
                wl_ix++;
            }

            wl_rp = (float)(((float)position-10)*(float)length_diapo)/(float)680;
            wl_rp = wl_rp * 1000;

            rst = fmod(wl_rp,wl_cl);

            fra = (rst*wl_ix)/wl_cl;

            tabgif[i].jumpToFrame(fra);

            wl_img_texture = tabgif[i].currentImage();

            if ( wl_img_texture.width() > wl_img_texture.height() )
            {
                wl_img_texture = wl_img_texture.scaledToWidth(sm_mxw,Qt::SmoothTransformation);
            }
            else
            {
                wl_img_texture = wl_img_texture.scaledToHeight(sm_mxw,Qt::SmoothTransformation);
            }

            if ( tab_diapo[i][3] != "" )
            {
                wg_stringlist_002 = tab_diapo[i][3].split("%*",QString::KeepEmptyParts);
                wl_image_2.load(QDir::homePath() + "/.2ManDVD_Library/" +"/Bibliotheque/Masks/"+wg_stringlist_002.at(0)+".png");
                wl_image_2 = wl_image_2.scaled(wl_img_texture.width(),wl_img_texture.height());
                wl_image_2 = wl_image_2.convertToFormat ( QImage::Format_ARGB32, Qt::AutoColor ); //_Premultiplied

                wg_stringlist_001 = tab_diapo[i][4].split(":",QString::SkipEmptyParts);

                if ( wg_stringlist_001.at(0).toInt() != 0 || wg_stringlist_001.at(1).toInt() != 255 )
                {
                    wg_img_smile_effect = wl_img_texture;
                    f_effect_run(wg_stringlist_001.at(0).toInt(),wg_stringlist_001.at(1).toInt());
                    wl_img_texture = wg_img_smile_effect;
                }

                QPainter::CompositionMode mode = (QPainter::CompositionMode)6;

                g.begin(&wl_img_texture);
                g.setCompositionMode ( mode );
                g.drawImage(QRect(0,0,-1,-1),wl_image_2);

                if ( wl_over_mask.load(QDir::homePath() + "/.2ManDVD_Library/"  + "/Bibliotheque/Masks/2t_" + wg_stringlist_002.at(0) + ".png") == true )
                {

                    wl_over_mask = wl_over_mask.scaled(wl_img_texture.width(),wl_img_texture.height());
                    wl_over_mask = f_mutation_overmask(wl_over_mask,wg_stringlist_002.at(1) + "%*" + wg_stringlist_002.at(2) + "%*" + wg_stringlist_002.at(3) + "%*" + wg_stringlist_002.at(4));
                    wl_over_mask = wl_over_mask.convertToFormat ( QImage::Format_ARGB32, Qt::AutoColor ); //_Premultiplied

                    g.setCompositionMode ( (QPainter::CompositionMode)0 );

                    g.drawImage(QRect(0,0,-1,-1),wl_over_mask);
                }

                g.end();
            }

            wl_puis_001 = wl_img_texture.copy ( 0, 0, sm_mxw, sm_mxw);

            wg_table_photo[i] = wl_puis_001;

            glDeleteTextures (1,&texture_diapo[i]);
            f = QGLWidget::convertToGLFormat( wl_puis_001 );

            glGenTextures (1,&texture_diapo[i]);
            glBindTexture (GL_TEXTURE_2D, texture_diapo[i]);

            glTexParameteri (GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR);
            glTexParameteri (GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR);

            glTexImage2D (GL_TEXTURE_2D, 0, GL_RGBA, f.width(), f.height(),
                          0, GL_RGBA, GL_UNSIGNED_BYTE, f.bits());
        }
        else
        {
            if ( tab_diapo[i][0].right(4) == ".avi" || tab_diapo[i][0].right(4) == ".AVI" || tab_diapo[i][0].right(4) == ".mpg" || tab_diapo[i][0].right(4) == ".MPG" || tab_diapo[i][0].right(5) == ".MPEG" || tab_diapo[i][0].right(5) == ".mpeg" || tab_diapo[i][0].right(4) == ".mp4" || tab_diapo[i][0].right(4) == ".MP4" )
            {
                wl_rp = (float)((position-10)*(float)((float)length_diapo*(float)wg_fps_int))/(float)680;

                wl_img_texture = wg_tabvid[i]->read_frame(wl_rp);

                if ( wl_img_texture.width() > wl_img_texture.height() )
                {
                    wl_img_texture = wl_img_texture.scaledToWidth(sm_mxw,Qt::SmoothTransformation);
                }
                else
                {
                    wl_img_texture = wl_img_texture.scaledToHeight(sm_mxw,Qt::SmoothTransformation);
                }

                /*wg_stringlist_001 = tab_diapo[i][4].split(":",QString::SkipEmptyParts);

                if ( wg_stringlist_001.at(0).toInt() != 0 || wg_stringlist_001.at(1).toInt() != 255 )
                {
                    wg_img_smile_effect = wl_img_texture;
                    f_effect_run(wg_stringlist_001.at(0).toInt(),wg_stringlist_001.at(1).toInt());
                    wl_img_texture = wg_img_smile_effect;
                }

                if ( tab_diapo[i][3] != "" )
                {
                    wg_stringlist_002 = tab_diapo[i][3].split("%*",QString::KeepEmptyParts);
                    wl_image_2.load(QDir::homePath() + "/.2ManDVD_Library/" +"/Bibliotheque/Masks/"+wg_stringlist_002.at(0)+".png");
                    wl_image_2 = wl_image_2.scaled(wl_img_texture.width(),wl_img_texture.height());
                    wl_image_2 = wl_image_2.convertToFormat ( QImage::Format_ARGB32, Qt::AutoColor ); //_Premultiplied

                    QPainter::CompositionMode mode = (QPainter::CompositionMode)6;

                    g.begin(&wl_img_texture);
                    g.setCompositionMode ( mode );
                    g.drawImage(QRect(0,0,-1,-1),wl_image_2);

                    if ( wl_over_mask.load(QDir::homePath() + "/.2ManDVD_Library/"  + "/Bibliotheque/Masks/2t_" + wg_stringlist_002.at(0) + ".png") == true )
                    {

                        wl_over_mask = wl_over_mask.scaled(wl_img_texture.width(),wl_img_texture.height());

                        wl_over_mask = f_mutation_overmask(wl_over_mask,wg_stringlist_002.at(1) + "%*" + wg_stringlist_002.at(2) + "%*" + wg_stringlist_002.at(3) + "%*" + wg_stringlist_002.at(4));

                        wl_over_mask = wl_over_mask.convertToFormat ( QImage::Format_ARGB32, Qt::AutoColor ); //_Premultiplied
                        g.setCompositionMode ( (QPainter::CompositionMode)0 );

                        g.drawImage(QRect(0,0,-1,-1),wl_over_mask);
                    }

                    g.end();
                }*/

                wl_puis_001 = wl_img_texture.copy ( 0, 0, sm_mxw, sm_mxw); //sm_mxw, sm_mxw);

                wg_table_photo[i] = wl_puis_001;

                glDeleteTextures (1,&texture_diapo[i]);
                f = QGLWidget::convertToGLFormat( wl_puis_001 );

                glGenTextures (1,&texture_diapo[i]);
                glBindTexture (GL_TEXTURE_2D, texture_diapo[i]);

                glTexParameteri (GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR);
                glTexParameteri (GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR);

                glTexImage2D (GL_TEXTURE_2D, 0, GL_RGBA, f.width(), f.height(),
                              0, GL_RGBA, GL_UNSIGNED_BYTE, f.bits());
            }
        }

        // *** CALCUL DE LA POSITION ***

        wg_stringlist_002 = tab_coo_timeline[i][minidx].split(":",QString::SkipEmptyParts);

        dep_px = wg_stringlist_002.at(1).toFloat();
        dep_py = wg_stringlist_002.at(2).toFloat();
        dep_pz = wg_stringlist_002.at(3).toFloat();
        dep_rx = wg_stringlist_002.at(4).toFloat();
        dep_ry = wg_stringlist_002.at(5).toFloat();
        dep_rz = wg_stringlist_002.at(6).toFloat();

        dep_pos = wg_stringlist_002.at(0).toInt();
        tab_coo[i][8] = wg_stringlist_002.at(wg_stringlist_002.count()-10).toInt(); // *** VISIBILITE ***

        dep_opa = wg_stringlist_002.at(wg_stringlist_002.count()-9).toInt();
        dep_blur = wg_stringlist_002.at(wg_stringlist_002.count()-8).toInt();

        dep_red = wg_stringlist_002.at(wg_stringlist_002.count()-7).toInt();
        dep_green = wg_stringlist_002.at(wg_stringlist_002.count()-6).toInt();
        dep_blue = wg_stringlist_002.at(wg_stringlist_002.count()-5).toInt();

        dep_x1 = wg_stringlist_002.at(wg_stringlist_002.count()-4).toInt();
        dep_y1 = wg_stringlist_002.at(wg_stringlist_002.count()-3).toInt();
        dep_x2 = wg_stringlist_002.at(wg_stringlist_002.count()-2).toInt();
        dep_y2 = wg_stringlist_002.at(wg_stringlist_002.count()-1).toInt();

        wg_stringlist_002 = tab_coo_timeline[i][maxidx].split(":",QString::SkipEmptyParts);

        fin_px = wg_stringlist_002.at(1).toFloat();
        fin_py = wg_stringlist_002.at(2).toFloat();
        fin_pz = wg_stringlist_002.at(3).toFloat();
        fin_rx = wg_stringlist_002.at(4).toFloat();
        fin_ry = wg_stringlist_002.at(5).toFloat();
        fin_rz = wg_stringlist_002.at(6).toFloat();

        fin_pos = wg_stringlist_002.at(0).toInt();

        fin_opa = wg_stringlist_002.at(wg_stringlist_002.count()-9).toInt();
        fin_blur = wg_stringlist_002.at(wg_stringlist_002.count()-8).toInt();

        fin_red = wg_stringlist_002.at(wg_stringlist_002.count()-7).toInt();
        fin_green = wg_stringlist_002.at(wg_stringlist_002.count()-6).toInt();
        fin_blue = wg_stringlist_002.at(wg_stringlist_002.count()-5).toInt();

        fin_x1 = wg_stringlist_002.at(wg_stringlist_002.count()-4).toInt();
        fin_y1 = wg_stringlist_002.at(wg_stringlist_002.count()-3).toInt();
        fin_x2 = wg_stringlist_002.at(wg_stringlist_002.count()-2).toInt();
        fin_y2 = wg_stringlist_002.at(wg_stringlist_002.count()-1).toInt();

        wg_strtr = QString::number(tab_coo[i][8]);

        if ( wg_stringlist_002.at(wg_stringlist_002.count()-10).mid(0,1) != wg_strtr.mid(0,1) && wg_stringlist_002.at(wg_stringlist_002.count()-10).mid(1,2) != "10" )
        {
            if ( wg_stringlist_002.at(wg_stringlist_002.count()-10).mid(0,1) == "2" && wg_strtr.mid(0,1) != "2" ) // && wl_explode.at(wl_explode.count()-3).length() == 3 && wl_explode.at(wl_explode.count()-3).mid(1,2) != "00" )
            {
                if ( position >= dep_pos )
                {
                    //alpha_blend = (((position-dep_pos)*100)/(fin_pos-dep_pos));

                    alpha_blend = (float)( (pow((position-dep_pos),(1.0/1.4))*100.0) /  ( pow((fin_pos-dep_pos),(1.0/1.4)) * pow(25,(1.0/1.4)) ) )*10;

                    /*if ( alpha_blend >= 100 )
                    {
                        alpha_blend = 99;
                    }*/
                }
                else
                {
                    if ( tab_coo[i][11] > 0 )
                    {
                        alpha_blend = 0;
                    }
                }
            }
            else
            {
                if ( position <= fin_pos && position >= dep_pos )
                {
                    //alpha_blend = 100-(((position-dep_pos)*100)/(fin_pos-dep_pos));

                    alpha_blend = 100-(float)(( (pow((position-dep_pos),(1.0/1.4))*100.0) /  ( pow((fin_pos-dep_pos),(1.0/1.4)) * pow(25,(1.0/1.4)) ) )*10);

                    /*if ( alpha_blend > 99 )
                    {
                        alpha_blend = 99;
                    }*/
                }
                else
                {
                    if ( tab_coo[i][11] > 0 )
                    {
                        alpha_blend = 0;
                    }
                }
            }

            wl_tmps = "";
           // if ( QString::number(alpha_blend).length() > 1 )
           // {
           //     wl_tmps = wl_explode.at(wl_explode.count()-10).mid(1,2); //+ QString::number(alpha_blend);
           // }
           // else
           // {
                wl_tmps = wg_stringlist_002.at(wg_stringlist_002.count()-10).mid(1,2); // + "0" + QString::number(alpha_blend);
           // }
            tab_coo[i][11] = wl_tmps.toInt();
        }
        else
        {
            if ( tab_coo[i][11] > 0 )
            {
                alpha_blend = 0;
                tab_coo[i][11] = 0;
            }
            else
            {
                alpha_blend = 0;
                tab_coo[i][11] = -1;
            }
        }

        // *** CALCULS POUR LA POSITION ***

        if ( dep_pos != position && fin_pos != position )
        {
            TF = (float)fin_pos-(float)dep_pos;
            tp = (float)position-(float)dep_pos;

            NUMALPHA = 1.0/((1.0-gama)*TF);
            alphaX = (float)(fin_px-dep_px)*(NUMALPHA);
            alphaY = (float)(fin_py-dep_py)*(NUMALPHA);
            alphaZ = (float)(fin_pz-dep_pz)*(NUMALPHA);
            alphaRX = (float)(fin_rx-dep_rx)*(NUMALPHA);
            alphaRY = (float)(fin_ry-dep_ry)*(NUMALPHA);
            alphaRZ = (float)(fin_rz-dep_rz)*(NUMALPHA);

            if( tp < TF*gama){
                tab_coo[i][0] = dep_px+(alphaX*pow(tp,2)/(2.0*gama*TF));
                tab_coo[i][1] = dep_py+(alphaY*pow(tp,2)/(2.0*gama*TF));
                tab_coo[i][2] = dep_pz+(alphaZ*pow(tp,2)/(2.0*gama*TF));
                tab_coo[i][5] = dep_rx+(alphaRX*pow(tp,2)/(2.0*gama*TF));
                tab_coo[i][6] = dep_ry+(alphaRY*pow(tp,2)/(2.0*gama*TF));
                tab_coo[i][7] = dep_rz+(alphaRZ*pow(tp,2)/(2.0*gama*TF));
            }
            else if( TF*gama <= tp && tp < TF*(1.0-gama) ){
                tab_coo[i][0] = dep_px+(alphaX*tp-(alphaX*gama*TF)/2.0);
                tab_coo[i][1] = dep_py+(alphaY*tp-(alphaY*gama*TF)/2.0);
                tab_coo[i][2] = dep_pz+(alphaZ*tp-(alphaZ*gama*TF)/2.0);
                tab_coo[i][5] = dep_rx+(alphaRX*tp-(alphaRX*gama*TF)/2.0);
                tab_coo[i][6] = dep_ry+(alphaRY*tp-(alphaRY*gama*TF)/2.0);
                tab_coo[i][7] = dep_rz+(alphaRZ*tp-(alphaRZ*gama*TF)/2.0);
            }else if( TF*(1.0-gama) <= tp ){
                tab_coo[i][0] = dep_px+(-alphaX*pow(tp,2)/(2.0*gama*TF) + alphaX*tp/gama + alphaX*TF*( 1.0-gama-1.0/(2.0*gama) ));
                tab_coo[i][1] = dep_py+(-alphaY*pow(tp,2)/(2.0*gama*TF) + alphaY*tp/gama + alphaY*TF*( 1.0-gama-1.0/(2.0*gama) ));
                tab_coo[i][2] = dep_pz+(-alphaZ*pow(tp,2)/(2.0*gama*TF) + alphaZ*tp/gama + alphaZ*TF*( 1.0-gama-1.0/(2.0*gama) ));
                tab_coo[i][5] = dep_rx+(-alphaRX*pow(tp,2)/(2.0*gama*TF) + alphaRX*tp/gama + alphaRX*TF*( 1.0-gama-1.0/(2.0*gama) ));
                tab_coo[i][6] = dep_ry+(-alphaRY*pow(tp,2)/(2.0*gama*TF) + alphaRY*tp/gama + alphaRY*TF*( 1.0-gama-1.0/(2.0*gama) ));
                tab_coo[i][7] = dep_rz+(-alphaRZ*pow(tp,2)/(2.0*gama*TF) + alphaRZ*tp/gama + alphaRZ*TF*( 1.0-gama-1.0/(2.0*gama) ));
            }

            if ( dep_opa == 100 && fin_opa == 100 )
            {
                tab_coo[i][9] = 100;
            }
            else
            {
                if ( fin_opa < dep_opa )
                {
                    tab_coo[i][9] = (float)dep_opa+((((float)fin_opa-(float)dep_opa)/(float)((float)fin_pos-(float)dep_pos))*(float)((float)position-(float)dep_pos));
                }
                else
                {
                    if ( fin_opa > dep_opa )
                    {
                        tab_coo[i][9] = (float)((((float)fin_opa-(float)dep_opa)/(float)((float)fin_pos-(float)dep_pos))*(float)((float)position-(float)dep_pos));
                    }
                    else
                    {
                        tab_coo[i][9] = (float)fin_opa;
                    }
                }
            }

            // *** CALCULS POUR COLORATION ***
            tab_coo[i][12] = dep_red+(((float)(fin_red-dep_red)/(float)(fin_pos-dep_pos))*(position-dep_pos));
            tab_coo[i][13] = dep_green+(((float)(fin_green-dep_green)/(float)(fin_pos-dep_pos))*(position-dep_pos));
            tab_coo[i][14] = dep_blue+(((float)(fin_blue-dep_blue)/(float)(fin_pos-dep_pos))*(position-dep_pos));

            // *** CALCULS POUR CROP ***
            tab_coo[i][3] = dep_x1+(((float)(fin_x1-dep_x1)/(float)(fin_pos-dep_pos))*(position-dep_pos));
            tab_coo[i][4] = dep_y1+(((float)(fin_y1-dep_y1)/(float)(fin_pos-dep_pos))*(position-dep_pos));
            tab_coo[i][15] = dep_x2+(((float)(fin_x2-dep_x2)/(float)(fin_pos-dep_pos))*(position-dep_pos));
            tab_coo[i][16] = dep_y2+(((float)(fin_y2-dep_y2)/(float)(fin_pos-dep_pos))*(position-dep_pos));

            if ( dep_blur == 0 && fin_blur == 0 )
            {
                tab_coo[i][10] = 0;
                if ( tab_old_blur[i] > 0 )
                {
                    f_reload_img(i);
                }
            }
            else
            {
                if ( fin_blur < dep_blur )
                {
                    tab_coo[i][10] = (float)dep_blur+(((fin_blur-dep_blur)/(float)(fin_pos-dep_pos))*(float)(position-dep_pos));
                }
                else
                {
                    if ( fin_blur > dep_blur )
                    {
                        tab_coo[i][10] = (float)(((fin_blur-dep_blur)/(float)(fin_pos-dep_pos))*(float)(position-dep_pos));
                    }
                    else
                    {
                        tab_coo[i][10] = (float)fin_blur;
                    }
                }
                if ( tab_coo[i][10] != tab_old_blur[i] )
                {
                    f_reload_img(i);
                }
            }
        }
        else
        {
            if ( dep_pos == position )
            {
                tab_coo[i][0] = dep_px;
                tab_coo[i][1] = dep_py;
                tab_coo[i][2] = dep_pz;

                tab_coo[i][5] = dep_rx;
                tab_coo[i][6] = dep_ry;
                tab_coo[i][7] = dep_rz;

                tab_coo[i][9] = dep_opa;
                tab_coo[i][10] = dep_blur;

                // *** CALCULS POUR COLORATION ***
                tab_coo[i][12] = dep_red;
                tab_coo[i][13] = dep_green;
                tab_coo[i][14] = dep_blue;

                // *** CALCULS POUR CROP ***
                tab_coo[i][3] = dep_x1;
                tab_coo[i][4] = dep_y1;
                tab_coo[i][15] = dep_x2;
                tab_coo[i][16] = dep_y2;
            }
            else
            {
                tab_coo[i][0] = fin_px;
                tab_coo[i][1] = fin_py;
                tab_coo[i][2] = fin_pz;

                tab_coo[i][5] = fin_rx;
                tab_coo[i][6] = fin_ry;
                tab_coo[i][7] = fin_rz;

                tab_coo[i][9] = fin_opa;
                tab_coo[i][10] = fin_blur;

                // *** CALCULS POUR COLORATION ***
                tab_coo[i][12] = fin_red;
                tab_coo[i][13] = fin_green;
                tab_coo[i][14] = fin_blue;

                // *** CALCULS POUR CROP ***
                tab_coo[i][3] = fin_x1;
                tab_coo[i][4] = fin_y1;
                tab_coo[i][15] = fin_x2;
                tab_coo[i][16] = fin_y2;
            }

            if ( dep_opa != 0 || fin_opa != 0 || tab_old_blur[i] > 0 || tab_coo[i][10] != tab_old_blur[i] )
            {
                f_reload_img(i);
            }
        }

        tab_old_blur[i] = tab_coo[i][10];

        /*if ( i == num_select )
        {
            emit update_coo();
        }*/

        minpos = 0;
        maxpos = 10000;

        minidx = 0;
        maxidx = 0;

        if ( tab_coo[i][11] >= 0 )
        {
            //qDebug() << tab_coo[i][11];
            f_apply_mask(i,tab_coo[i][11],alpha_blend);
        }

        i++;
    }

    // *** L'ARRIERE PLAN EST T'IL UNE VIDEO ***
    if ( back_color.right(4) == ".avi" || back_color.right(4) == ".AVI" || back_color.right(4) == ".mpg" || back_color.right(4) == ".MPG" || back_color.right(5) == ".MPEG" || back_color.right(5) == ".mpeg" || back_color.right(4) == ".mp4" || back_color.right(4) == ".MP4" )
    {
        wl_rp = (float)((position-10)*(float)(length_diapo*wg_fps_int))/680;

        wl_img_texture = wg_tabvid[20]->read_frame(wl_rp);

        if ( wl_img_texture.width() > wl_img_texture.height() )
        {
            wl_img_texture = wl_img_texture.scaledToWidth(sm_mxw,Qt::SmoothTransformation);
        }
        else
        {
            wl_img_texture = wl_img_texture.scaledToHeight(sm_mxw,Qt::SmoothTransformation);
        }

        wl_puis_001 = wl_img_texture.copy ( 0, 0, sm_mxw, sm_mxw);

        wg_fd_tx = (float)wl_img_texture.width()/(float)sm_mxw;
        wg_fd_ty = (float)wl_img_texture.height()/(float)sm_mxw;

        f = QGLWidget::convertToGLFormat( wl_puis_001 );

        glDeleteTextures (1,&texture_diapo[41]);
        glGenTextures (1,&texture_diapo[41]);
        glBindTexture (GL_TEXTURE_2D, texture_diapo[41]);

        glTexParameteri (GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR);
        glTexParameteri (GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR);

        glTexImage2D (GL_TEXTURE_2D, 0, GL_RGBA, f.width(), f.height(),
                      0, GL_RGBA, GL_UNSIGNED_BYTE, f.bits());
    }

    updateGL();
}

void Tetrahedron::f_save_diapo(int num_diapo)
{
    int wl_int_001 = 1;
    int wl_int_002;
    QString wg_str_001 = "";

    while ( wl_int_001 < nombre_diapos+1 )
    {
        wl_int_002 = 0;

        wg_str_001 = tab_diapo[wl_int_001][0] + "$" + tab_diapo[wl_int_001][1] + "$" + tab_diapo[wl_int_001][2] + "$" + tab_diapo[wl_int_001][3] + "$" + tab_diapo[wl_int_001][4] + "$" + tab_diapo[wl_int_001][5] + "$" + tab_diapo[wl_int_001][6] + "$" + tab_diapo[wl_int_001][7] + "$" + tab_diapo[wl_int_001][8] + "$";

        while ( tab_coo_timeline[wl_int_001][wl_int_002] != "" )
        {
            wg_str_001 = wg_str_001 + tab_coo_timeline[wl_int_001][wl_int_002] + "$";
            wl_int_002++;
        }

        tab_save_diapo[num_diapo][wl_int_001]=wg_str_001;
        wl_int_001++;
    }
    tab_save_diapo[num_diapo][wl_int_001]="$#$";
    tab_save_diapo[num_diapo][wl_int_001+1]=QString::number(length_diapo);
    tab_save_diapo[num_diapo][wl_int_001+2]=back_color;
    tab_save_diapo[num_diapo][wl_int_001+3]=str_trans + "}" + QString::number(lgt_trans);
    tab_save_diapo[num_diapo][wl_int_001+4]=QString::number(is_mblur);
    tab_save_diapo[num_diapo][wl_int_001+5]=QString::number(is_fog) + ":" + QString::number(fog_red) + ":" + QString::number(fog_green) + ":" + QString::number(fog_blue) + ":" + QString::number(is_flakes) + ":" + QString::number(nbre_flakes) + ":" + QString::number(size_flakes) + ":" + QString::number(type_flakes);
}

void Tetrahedron::f_init_tabcoo()
{
    // *** INITIALISATION DES TABLES DE COORDONNEES ***

    wg_infree_1 = 0;

    while ( wg_infree_1 < 20 )
    {
        wg_infree_2 = 0;
        while ( wg_infree_2 < 20 )
        {
            tab_coo_timeline[wg_infree_1][wg_infree_2] = "";
            tab_coo[wg_infree_1][wg_infree_2] = 0.0;
            wg_infree_2++;
        }
        tab_old_blur[wg_infree_1] = 0;
        wg_infree_1++;
    }
}

void Tetrahedron::f_init_tabtex()
{
    // *** INITIALISATION DES TABLES DE COORDONNEES ***

    wg_infree_1 = 0;
    isback = 0;

    while ( wg_infree_1 < 20 )
    {
        wg_infree_2 = 0;
        while ( wg_infree_2 < 7 ) //3
        {
            tab_diapo[wg_infree_1][wg_infree_2] = "";
            wg_infree_2++;
        }
        wg_infree_1++;
    }
}

void Tetrahedron::f_init_coo_one_slide(int numdia)
{
    wg_infree_1 = 0;

    while ( wg_infree_1 < 20 )
    {
        tab_coo_timeline[numdia][wg_infree_1] = "";
        wg_infree_1++;
    }
}

void Tetrahedron::f_net_video()
{
    wg_infree_1 = 0;

    while ( wg_infree_1 < 20 )
    {
        if ( tab_diapo[wg_infree_1][0].right(4) == ".avi" || tab_diapo[wg_infree_1][0].right(4) == ".AVI" || tab_diapo[wg_infree_1][0].right(4) == ".mpg" || tab_diapo[wg_infree_1][0].right(4) == ".MPG" || tab_diapo[wg_infree_1][0].right(5) == ".MPEG" || tab_diapo[wg_infree_1][0].right(5) == ".mpeg" || tab_diapo[wg_infree_1][0].right(4) == ".mp4" || tab_diapo[wg_infree_1][0].right(4) == ".MP4" )
        {
            if ( wg_tabvid[wg_infree_1] != 0 )
            {
               wg_tabvid[wg_infree_1]->delete_videowrapper();
               delete wg_tabvid[wg_infree_1];
               wg_tabvid[wg_infree_1] = 0;
            }
        }
        wg_infree_1++;
    }
}

// **************
// *** THEMES ***
// **************

void Tetrahedron::f_load_theme(QString thm, QString nameth)
{
    // *** NETTOYAGE DE L'ACCUM BUFFER ***
    glClearAccum(0.0, 0.0, 0.0, 1.0);
    glClear(GL_DEPTH_BUFFER_BIT);
    glAccum(GL_LOAD, 1.0);
    is_mblur = 0;
    updateGL();

    QStringList wl_exp;
    QStringList wl_exp_2;
    QStringList wl_exp_3;

    wl_exp = thm.split("_",QString::SkipEmptyParts);
    QImage wl_puis_001(sm_mxw,sm_mxw,QImage::Format_ARGB32_Premultiplied);
    QImage wl_img_texture;
    QImage f;
    QFont myfont;
    myfont.setPixelSize ( 400 );
    QPainter p;
    int wl_indx;
    int wl_nb_diap = 0;;
    int wl_exnew = 0;

    if ( this->width() == 720 && ( wl_exp.at(0) == "0" || wl_exp.at(0) == "2" ) )
    {
        ratio_import=1.0;
    }
    else
    {
        ratio_import=1.4222222;
    }

    emit change_length(wl_exp.at(1).toInt());
    is_mblur = wl_exp.at(2).toInt();

    for (int i = 3; i < wl_exp.size(); ++i)
    {
        wl_nb_diap = i-2;

        if ( i-2 <= nombre_diapos )
        {  // *** UNE DIAPO AVEC LE MEME NUMERO EXISTE ***
            wl_exp_2 = wl_exp.at(i).split("$",QString::SkipEmptyParts); //SkipEmptyParts

            wl_indx = 0;
            while ( wl_indx < 20 )
            {
                tab_coo_timeline[i-2][wl_indx] = "";
                tab_coo[i-2][wl_indx] = 0.0;

                wl_indx++;
            }

            for (int j = 0; j < wl_exp_2.size(); ++j)
            {
                    if ( j == 0 )
                    {
                        wl_exp_3 = wl_exp_2.at(j).split(":",QString::KeepEmptyParts);

                        tab_coo[i-2][0] = wl_exp_3.at(3).toFloat()*ratio_import;      // *** X ***
                        tab_coo[i-2][1] = wl_exp_3.at(4).toFloat();      // *** Y ***
                        tab_coo[i-2][2] = wl_exp_3.at(5).toFloat();      // *** Z ***
                        tab_coo[i-2][3] = wl_exp_3.at(3).toFloat()*ratio_import;      // *** OLD POS X ***
                        tab_coo[i-2][4] = wl_exp_3.at(4).toFloat();      // *** OLD POS Y ***
                        tab_coo[i-2][5] = wl_exp_3.at(6).toFloat();      // *** ROTATE X ***
                        tab_coo[i-2][6] = wl_exp_3.at(7).toFloat();      // *** ROTATE Y ***
                        tab_coo[i-2][7] = wl_exp_3.at(8).toFloat();      // *** ROTATE Z ***
                        tab_coo[i-2][8] = wl_exp_3.at(9).toFloat();      // *** VISIBLE ***
                        tab_coo[i-2][9] = wl_exp_3.at(10).toFloat();      // *** TRANSPARENCE ***

                        tab_coo[i-2][10] = wl_exp_3.at(11).toFloat();     // *** BLUR ***
                        tab_coo[i-2][11] = wl_exp_3.at(12).toFloat();      // *** TRANS DIAPO ***
                        tab_coo[i-2][12] = wl_exp_3.at(13).toFloat();      // *** RED ***
                        tab_coo[i-2][13] = wl_exp_3.at(14).toFloat();      // *** GREEN ***
                        tab_coo[i-2][14] = wl_exp_3.at(15).toFloat();      // *** BLUE ***


                        tab_diapo[i-2][6] = wl_exp_3.at(1);              // *** REFLECT ***
                        tab_diapo[i-2][7] = "0/0/0/0";                   // *** CROP ***
                        tab_diapo[i-2][3] = wl_exp_3.at(wl_exp_3.count()-1);              // *** MASK ***
                        tab_diapo[i-2][3].replace(QString("underscore"), QString("_"));
                        tab_diapo[i-2][4] = "0:" + wl_exp_3.at(0);              // *** CONTRASTE ***

                        int wl_i = 0;
                        int wl_j = 0;
                        while ( wl_i < 3 )
                        {
                            if ( wl_exp_2.at(j).mid(wl_j,1) == ":" )
                            {
                                wl_i++;
                            }
                            wl_j++;
                        }

                        tab_coo_timeline[i-2][j] = wl_exp_2.at(j).mid(wl_j,wl_exp_2.at(j).lastIndexOf( ":" )-wl_j);
                    }
                    else
                    {
                        tab_coo_timeline[i-2][j] = wl_exp_2.at(j);
                    }
            }

            glDeleteTextures(1, &texture_diapo[i-2] );
            QImage wl_puis_001(sm_mxw,sm_mxw,QImage::Format_ARGB32_Premultiplied); //_Premultiplied

            if ( wl_img_texture.load(QDir::homePath() + "/.2ManDVD_Library/"  + "/Bibliotheque/3d/" + nameth + "_" + QString::number(i-2) + ".png") == true )
            {
                if ( wl_img_texture.width() > wl_img_texture.height() )
                {
                    wl_img_texture = wl_img_texture.scaledToWidth(sm_mxw,Qt::SmoothTransformation);
                }
                else
                {
                    wl_img_texture = wl_img_texture.scaledToHeight(sm_mxw,Qt::SmoothTransformation);
                }

                wl_puis_001 = wl_img_texture.copy ( 0, 0, sm_mxw, sm_mxw);
                wl_exnew = 1;
            }
            else
            {
                if ( tab_diapo[i-2][0] == "NULL" )
                {
                    p.begin(&wl_puis_001);
                    p.setBrush(QColor(50,50,50));
                    p.setPen(QColor(20,20,20));
                    p.drawRect(0,0,sm_mxw,sm_mxw);
                    p.setFont(myfont);
                    p.setPen(QColor(255,255,255));
                    p.drawText(QRect(0,0,sm_mxw,sm_mxw), Qt::AlignCenter,QString::number(i-2));
                    p.end();

                    wl_img_texture = wl_puis_001;
                }
                else
                {
                    wl_img_texture.load(tab_diapo[i-2][0]);
                    if ( wl_img_texture.width() > wl_img_texture.height() )
                    {
                        wl_img_texture = wl_img_texture.scaledToWidth(sm_mxw,Qt::SmoothTransformation);
                    }
                    else
                    {
                        wl_img_texture = wl_img_texture.scaledToHeight(sm_mxw,Qt::SmoothTransformation);
                    }
                    wl_puis_001 = wl_img_texture.copy ( 0, 0, sm_mxw, sm_mxw);
                }
                wl_exnew = 0;
            }


            if ( tab_diapo[i-2][3] != "" )
            {
                QPainter g;

                QPainter::CompositionMode mode = (QPainter::CompositionMode)6;

                QStringList wl_explode = tab_diapo[i-2][3].split("%*",QString::KeepEmptyParts);

                QImage wl_image_2(QDir::homePath() + "/.2ManDVD_Library/" +"/Bibliotheque/Masks/"+wl_explode.at(0)+".png");

                wl_image_2 = wl_image_2.scaled(wl_img_texture.width(),wl_img_texture.height());
                wl_image_2 = wl_image_2.convertToFormat ( QImage::Format_ARGB32, Qt::AutoColor ); //_Premultiplied

                g.begin(&wl_puis_001);
                g.setCompositionMode ( mode );
                g.drawImage(QRect(0,0,-1,-1),wl_image_2);

                QImage wl_over_mask;

                QString wl_str_001 = QDir::homePath() + "/.2ManDVD_Library/"  + "/Bibliotheque/Masks/2t_" + wl_explode.at(0) + ".png";

                if ( wl_over_mask.load(wl_str_001) == true )
                {
                    wl_over_mask = wl_over_mask.scaled(wl_puis_001.width(),wl_puis_001.height());

                    wl_over_mask = f_mutation_overmask(wl_over_mask,wl_explode.at(1) + "%*" + wl_explode.at(2) + "%*" + wl_explode.at(3) + "%*" + wl_explode.at(4));

                    wl_over_mask = wl_over_mask.convertToFormat ( QImage::Format_ARGB32, Qt::AutoColor ); //_Premultiplied
                    g.setCompositionMode ( (QPainter::CompositionMode)0 );
                    g.drawImage(QRect(0,0,-1,-1),wl_over_mask);
                }

                g.end();
            }
            if ( wl_exnew == 1 )
            {
                tab_diapo[i-2][1] = QString::number(sm_mxw);
                tab_diapo[i-2][2] = QString::number(sm_mxw/(wl_img_texture.width()/wl_img_texture.height()));
            }
            tab_diapo[i-2][5] = wl_exp_3.at(2);                                             // *** SCALE ***

            wg_table_photo[i-2] = wl_puis_001;
            f = QGLWidget::convertToGLFormat( wl_puis_001 );

            glDeleteTextures(1, &texture_diapo[i+1] );
            glGenTextures (1,&texture_diapo[i-2]);
            glBindTexture (GL_TEXTURE_2D, texture_diapo[i-2]);

            glTexParameteri (GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR);
            glTexParameteri (GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR);

            glTexImage2D (GL_TEXTURE_2D, 0, GL_RGBA, f.width(), f.height(),
                          0, GL_RGBA, GL_UNSIGNED_BYTE, f.bits());
        }
        else
        { // *** IL FAUT CREER UNE DIAPO ***
            if ( wl_img_texture.load(QDir::homePath() + "/.2ManDVD_Library/"  + "/Bibliotheque/3d/" + nameth + "_" + QString::number(i-2) + ".png") == true )
            {
                if ( wl_img_texture.width() > wl_img_texture.height() )
                {
                    wl_img_texture = wl_img_texture.scaledToWidth(sm_mxw,Qt::SmoothTransformation);
                }
                else
                {
                    wl_img_texture = wl_img_texture.scaledToHeight(sm_mxw,Qt::SmoothTransformation);
                }

                wl_puis_001 = wl_img_texture.copy ( 0, 0, sm_mxw, sm_mxw);
                wl_exnew = 1;
            }
            else
            {
                p.begin(&wl_puis_001);
                p.setBrush(QColor(50,50,50));
                p.setPen(QColor(20,20,20));
                p.drawRect(0,0,sm_mxw,sm_mxw);
                p.setFont(myfont);
                p.setPen(QColor(255,255,255));
                p.drawText(QRect(0,0,sm_mxw,sm_mxw), Qt::AlignCenter,QString::number(i-2));
                p.end();
                wl_exnew = 0;
            }

            wl_exp_2 = wl_exp.at(i).split("$",QString::SkipEmptyParts);

            wl_indx = 0;
            while ( wl_indx < 20 )
            {
                tab_coo_timeline[i-2][wl_indx] = "";
                tab_coo[i-2][wl_indx] = 0.0;

                wl_indx++;
            }

            for (int j = 0; j < wl_exp_2.size(); ++j)
            {
                    if ( j == 0 )
                    {
                        wl_exp_3 = wl_exp_2.at(j).split(":",QString::KeepEmptyParts);

                        tab_coo[i-2][0] = wl_exp_3.at(3).toFloat()*ratio_import;      // *** X ***
                        tab_coo[i-2][1] = wl_exp_3.at(4).toFloat();      // *** Y ***
                        tab_coo[i-2][2] = wl_exp_3.at(5).toFloat();      // *** Z ***
                        tab_coo[i-2][3] = wl_exp_3.at(3).toFloat()*ratio_import;      // *** OLD POS X ***
                        tab_coo[i-2][4] = wl_exp_3.at(4).toFloat();      // *** OLD POS Y ***
                        tab_coo[i-2][5] = wl_exp_3.at(6).toFloat();      // *** ROTATE X ***
                        tab_coo[i-2][6] = wl_exp_3.at(7).toFloat();      // *** ROTATE Y ***
                        tab_coo[i-2][7] = wl_exp_3.at(8).toFloat();      // *** ROTATE Z ***
                        tab_coo[i-2][8] = wl_exp_3.at(9).toFloat();      // *** VISIBLE ***
                        tab_coo[i-2][9] = wl_exp_3.at(10).toFloat();      // *** TRANSPARENCE ***

                        tab_coo[i-2][10] = wl_exp_3.at(11).toFloat();     // *** BLUR ***
                        tab_coo[i-2][11] = wl_exp_3.at(12).toFloat();      // *** TRANS DIAPO ***
                        tab_coo[i-2][12] = wl_exp_3.at(13).toFloat();      // *** RED ***
                        tab_coo[i-2][13] = wl_exp_3.at(14).toFloat();      // *** GREEN ***
                        tab_coo[i-2][14] = wl_exp_3.at(15).toFloat();      // *** BLUE ***


                        tab_diapo[i-2][6] = wl_exp_3.at(1);              // *** REFLECT ***
                        tab_diapo[i-2][7] = "0/0/0/0";                   // *** CROP ***
                        tab_diapo[i-2][3] = wl_exp_3.at(wl_exp_3.count()-1);              // *** MASK ***
                        tab_diapo[i-2][3].replace(QString("underscore"), QString("_"));
                        tab_diapo[i-2][4] = "0:" + wl_exp_3.at(0);              // *** CONTRASTE ***

                        int wl_i = 0;
                        int wl_j = 0;
                        while ( wl_i < 3 )
                        {
                            if ( wl_exp_2.at(j).mid(wl_j,1) == ":" )
                            {
                                wl_i++;
                            }
                            wl_j++;
                        }

                        tab_coo_timeline[i-2][j] = wl_exp_2.at(j).mid(wl_j,wl_exp_2.at(j).lastIndexOf( ":" )-wl_j);
                    }
                    else
                    {
                        tab_coo_timeline[i-2][j] = wl_exp_2.at(j);
                    }
            }

            if ( tab_diapo[i-2][3] != "" )
            {

                QPainter g;

                QPainter::CompositionMode mode = (QPainter::CompositionMode)6;

                QStringList wl_explode = tab_diapo[i-2][3].split("%*",QString::KeepEmptyParts);

                QImage wl_image_2(QDir::homePath() + "/.2ManDVD_Library/" +"/Bibliotheque/Masks/"+wl_explode.at(0)+".png");

                wl_image_2 = wl_image_2.scaled(wl_puis_001.width(),wl_puis_001.height());
                wl_image_2 = wl_image_2.convertToFormat ( QImage::Format_ARGB32, Qt::AutoColor ); //_Premultiplied

                g.begin(&wl_puis_001);
                g.setCompositionMode ( mode );
                g.drawImage(QRect(0,0,-1,-1),wl_image_2);

                QImage wl_over_mask;

                QString wl_str_001 = QDir::homePath() + "/.2ManDVD_Library/"  + "/Bibliotheque/Masks/2t_" + wl_explode.at(0) + ".png";

                if ( wl_over_mask.load(wl_str_001) == true )
                {
                    wl_over_mask = wl_over_mask.scaled(wl_puis_001.width(),wl_puis_001.height());

                    wl_over_mask = f_mutation_overmask(wl_over_mask,wl_explode.at(1) + "%*" + wl_explode.at(2) + "%*" + wl_explode.at(3) + "%*" + wl_explode.at(4));

                    wl_over_mask = wl_over_mask.convertToFormat ( QImage::Format_ARGB32, Qt::AutoColor ); //_Premultiplied
                    g.setCompositionMode ( (QPainter::CompositionMode)0 );
                    g.drawImage(QRect(0,0,-1,-1),wl_over_mask);
                }

                g.end();
            }

            wg_table_photo[i-2] = wl_puis_001;
            f = QGLWidget::convertToGLFormat( wl_puis_001 );

            glDeleteTextures(1, &texture_diapo[i-2] );
            glGenTextures (1,&texture_diapo[i-2]);
            glBindTexture (GL_TEXTURE_2D, texture_diapo[i-2]);

            glTexParameteri (GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR);
            glTexParameteri (GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR);

            glTexImage2D (GL_TEXTURE_2D, 0, GL_RGBA, f.width(), f.height(),
                          0, GL_RGBA, GL_UNSIGNED_BYTE, f.bits());

            tab_diapo[i-2][0] = "NULL";                                                     // *** NOM DU FICHIER DIAPO ***
            if ( wl_exnew == 0 )
            {
                tab_diapo[i-2][1] = QString::number(sm_mxw);
                tab_diapo[i-2][2] = QString::number(sm_mxw);
            }
            else
            {
                tab_diapo[i-2][1] = QString::number(sm_mxw);
                tab_diapo[i-2][2] = QString::number(sm_mxw/(wl_img_texture.width()/wl_img_texture.height()));
            }

            //tab_diapo[i-2][4] = "0:255";
            //tab_diapo[i-2][5] = "1";
            tab_diapo[i-2][5] = wl_exp_3.at(2);                                             // *** SCALE ***
            tab_diapo[i-2][7] = "0/0/0/0";                                                  // *** CROP ***
            tab_diapo[i-2][8] = "0";                                                        // *** ORIENTATION EXIF ***

            nombre_diapos++;

            emit add_diapo();
        }
        f_reload_img(i-2);
    }

    // *** SUPPRESSION DES DIAPOS EN TROP ***

    int j;
    //wl_nb_diap++;
    int nbsup = 0;
    int wl_svix = wl_nb_diap-1;

    while ( wl_nb_diap < nombre_diapos )
    {
        if ( tab_diapo[wl_nb_diap+1][0] != "NULL" )
        {
            glDeleteTextures(1, &texture_diapo[wl_nb_diap+1] );
        }

        j = 0;
        while ( j < 20 )
        {
            tab_coo_timeline[wl_nb_diap+1][j] = "";
            tab_coo[wl_nb_diap+1][j] = 0.0;

            j++;
        }
        j = 0;
        while ( j < 7 )
        {
            tab_diapo[wl_nb_diap+1][j] = "";
            j++;
        }

        emit s_delete_diapo(wl_svix);

        wl_nb_diap++;
        nbsup++;
    }

    nombre_diapos=nombre_diapos-nbsup;

    num_select = 0;
    is_fog = 0;

    //QImage wl_img_texture;

    if ( wl_img_texture.load(QDir::homePath() + "/.2ManDVD_Library/" +"/Bibliotheque/3d/" + nameth + ".jpg") == true )
    {
        if ( wl_img_texture.width() > wl_img_texture.height() )
        {
            wl_img_texture = wl_img_texture.scaledToWidth(sm_mxw,Qt::SmoothTransformation);
        }
        else
        {
            wl_img_texture = wl_img_texture.scaledToHeight(sm_mxw,Qt::SmoothTransformation);
        }

        QImage wl_puis_001(sm_mxw,sm_mxw,QImage::Format_ARGB32_Premultiplied);
        wl_puis_001 = wl_img_texture.copy ( 0, 0, sm_mxw, sm_mxw);

        wg_fd_tx = (float)wl_img_texture.width()/(float)sm_mxw;
        wg_fd_ty = (float)wl_img_texture.height()/(float)sm_mxw;

        QImage f = QGLWidget::convertToGLFormat( wl_puis_001 );

        glDeleteTextures (1,&texture_diapo[41]);
        glGenTextures (1,&texture_diapo[41]);
        glBindTexture (GL_TEXTURE_2D, texture_diapo[41]);

        glTexParameteri (GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR);
        glTexParameteri (GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR);

        glTexImage2D (GL_TEXTURE_2D, 0, GL_RGBA, f.width(), f.height(),
                      0, GL_RGBA, GL_UNSIGNED_BYTE, f.bits());

        isback = 1;
        back_color = QDir::homePath() + "/.2ManDVD_Library/" +"/Bibliotheque/3d/" + nameth + ".jpg";
        //updateGL();
    }
    else
    {
        isback = 0;
        back_color = "0:0:0";
    }

    //emit update_preview();
    emit move_start();
    //emit update_preview();
    //f_follow_timeline(10);
}

void Tetrahedron::f_delete_image()
{

    int wl_int_001 = num_select;
    int wl_int_002 = 0;

    QImage wl_puis_001(sm_mxw,sm_mxw,QImage::Format_ARGB32_Premultiplied);
    QImage wl_img_texture;
    QImage f;
    QPainter p;
    QFont myfont;
    myfont.setPixelSize ( 400 );

    glDeleteTextures(1, &texture_diapo[num_select] );

    if ( tab_diapo[wl_int_001][0].mid(0,2) == "?6" )
    {
        wg_nb_cube = 0;
    }

    if ( tab_diapo[wl_int_001][0].right(4) == ".avi" || tab_diapo[wl_int_001][0].right(4) == ".AVI" || tab_diapo[wl_int_001][0].right(4) == ".mpg" || tab_diapo[wl_int_001][0].right(4) == ".MPG" || tab_diapo[wl_int_001][0].right(5) == ".MPEG" || tab_diapo[wl_int_001][0].right(5) == ".mpeg" || tab_diapo[wl_int_001][0].right(4) == ".mp4" || tab_diapo[wl_int_001][0].right(4) == ".MP4" )
    {
        wg_tabvid[wl_int_001]->delete_videowrapper();
        delete wg_tabvid[wl_int_001];
        wg_tabvid[wl_int_001] = 0;       
    }

    while ( wl_int_001 < nombre_diapos )
    {
        tab_diapo[wl_int_001][0] = tab_diapo[wl_int_001+1][0];
        tab_diapo[wl_int_001][1] = tab_diapo[wl_int_001+1][1];
        tab_diapo[wl_int_001][2] = tab_diapo[wl_int_001+1][2];
        tab_diapo[wl_int_001][3] = tab_diapo[wl_int_001+1][3];
        tab_diapo[wl_int_001][4] = tab_diapo[wl_int_001+1][4];
        tab_diapo[wl_int_001][5] = tab_diapo[wl_int_001+1][5];
        tab_diapo[wl_int_001][6] = tab_diapo[wl_int_001+1][6];
        tab_diapo[wl_int_001][7] = tab_diapo[wl_int_001+1][7];
        tab_diapo[wl_int_001][8] = tab_diapo[wl_int_001+1][8];

        tab_coo[wl_int_001][0] = tab_coo[wl_int_001+1][0];
        tab_coo[wl_int_001][1] = tab_coo[wl_int_001+1][1];
        tab_coo[wl_int_001][2] = tab_coo[wl_int_001+1][2];
        tab_coo[wl_int_001][3] = tab_coo[wl_int_001+1][3];
        tab_coo[wl_int_001][4] = tab_coo[wl_int_001+1][4];
        tab_coo[wl_int_001][5] = tab_coo[wl_int_001+1][5];
        tab_coo[wl_int_001][6] = tab_coo[wl_int_001+1][6];
        tab_coo[wl_int_001][7] = tab_coo[wl_int_001+1][7];
        tab_coo[wl_int_001][8] = tab_coo[wl_int_001+1][8];
        tab_coo[wl_int_001][9] = tab_coo[wl_int_001+1][9];
        tab_coo[wl_int_001][10] = tab_coo[wl_int_001+1][10];
        tab_coo[wl_int_001][11] = tab_coo[wl_int_001+1][11];

        wg_tabvid[wl_int_001] = wg_tabvid[wl_int_001+1];

        if ( tabgif[wl_int_001+1].fileName().right(4) == ".gif" || tabgif[wl_int_001+1].fileName().right(4) == ".GIF" )
        {
            tabgif[wl_int_001].setFileName(tabgif[wl_int_001+1].fileName());
            tabgif[wl_int_002+1].setCacheMode( QMovie::CacheAll );
            tabgif[wl_int_002+1].jumpToFrame( 0 );

            tabgif[wl_int_001+1].setFileName("");
        }

        wl_int_002 = 0;
        while ( wl_int_002 < 20 )
        {
            tab_coo_timeline[wl_int_001][wl_int_002] = tab_coo_timeline[wl_int_001+1][wl_int_002];
            wl_int_002++;
        }

        if ( tab_diapo[wl_int_001+1][3] == "" )
        {
            if ( tab_diapo[wl_int_001+1][0] == "NULL" )
            {
                p.begin(&wl_puis_001);
                p.setBrush(QColor(50,50,50));
                p.setPen(QColor(20,20,20));
                p.drawRect(0,0,sm_mxw,sm_mxw);
                p.setFont(myfont);
                p.setPen(QColor(255,255,255));
                p.drawText(QRect(0,0,sm_mxw,sm_mxw), Qt::AlignCenter,QString::number(wl_int_001));
                p.end();

                f = QGLWidget::convertToGLFormat( wl_puis_001 );

                //glDeleteTextures(1, &texture_diapo[wl_int_001] );
                glGenTextures (1,&texture_diapo[wl_int_001]);
                glBindTexture (GL_TEXTURE_2D, texture_diapo[wl_int_001]);

                glTexParameteri (GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR);
                glTexParameteri (GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR);

                glTexImage2D (GL_TEXTURE_2D, 0, GL_RGBA, f.width(), f.height(),
                              0, GL_RGBA, GL_UNSIGNED_BYTE, f.bits());
            }
            else
            {
                if ( wl_img_texture.load(tab_diapo[wl_int_001+1][0]) == true )
                {
                    //glDeleteTextures(1, &texture_diapo[wl_int_001] );
                    if ( wl_img_texture.width() > wl_img_texture.height() )
                    {
                        wl_img_texture = wl_img_texture.scaledToWidth(sm_mxw,Qt::SmoothTransformation);
                    }
                    else
                    {
                        wl_img_texture = wl_img_texture.scaledToHeight(sm_mxw,Qt::SmoothTransformation);
                    }
                    wl_puis_001 = wl_img_texture.copy ( 0, 0, sm_mxw, sm_mxw);
                    f = QGLWidget::convertToGLFormat( wl_puis_001 );
                    glGenTextures (1,&texture_diapo[wl_int_001]);
                    glBindTexture (GL_TEXTURE_2D, texture_diapo[wl_int_001]);
                    glTexParameteri (GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR);
                    glTexParameteri (GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR);
                    glTexImage2D (GL_TEXTURE_2D, 0, GL_RGBA, f.width(), f.height(),
                                  0, GL_RGBA, GL_UNSIGNED_BYTE, f.bits());
                }
                else
                {
                    f_reload_img(wl_int_001);
                }
            }
        }
        else
        {
                f_load_mask(tab_diapo[wl_int_001][3], wl_int_001);
        }

        wl_int_001++;
    }

    emit s_delete_diapo(num_select);

    nombre_diapos--;
    num_select = 0;
    updateGL();
    emit update_preview();
    emit dia_select(num_select);
}

void Tetrahedron::f_load_mask(QString msk, int num)
{
    tab_diapo[num][3] = msk;
    glDeleteTextures(1, &texture_diapo[num] );

    QImage wl_puis_001(sm_mxw,sm_mxw,QImage::Format_ARGB32);
    QImage wl_img_texture(sm_mxw,sm_mxw,QImage::Format_ARGB32);
    QPixmap wl_pix_texture;
    QImage f;
    QPainter p;
    QFont myfont;
    QImage wl_over_mask;
    myfont.setPixelSize ( 400 );

    if ( tab_diapo[num][0] != "NULL"  )
    {
        wl_pix_texture.fill(QColor(0,0,0,0));
        if ( wl_pix_texture.load(tab_diapo[num][0]) == true )
        {
            if ( wl_pix_texture.width() > wl_pix_texture.height() )
            {
                wl_pix_texture = wl_pix_texture.scaledToWidth(sm_mxw,Qt::SmoothTransformation);
            }
            else
            {
                wl_pix_texture = wl_pix_texture.scaledToHeight(sm_mxw,Qt::SmoothTransformation);
            }

            if ( tab_diapo[num][3] != "" )
            {
                QImage wl_image_2(QDir::homePath() + "/.2ManDVD_Library/" +"/Bibliotheque/Masks/"+tab_diapo[num][3]+".png");
                wl_image_2 = wl_image_2.scaled(wl_pix_texture.width(),wl_pix_texture.height());
                wl_image_2 = wl_image_2.convertToFormat ( QImage::Format_ARGB32, Qt::AutoColor );

                wl_img_texture = wl_pix_texture.toImage();

                wg_img_smile_effect = wl_img_texture;

                QStringList wl_exp_001 = tab_diapo[num][4].split(":",QString::SkipEmptyParts);

                f_effect_run(wl_exp_001.at(0).toInt(),wl_exp_001.at(1).toInt());

                wl_img_texture = wg_img_smile_effect.convertToFormat ( QImage::Format_ARGB32, Qt::AutoColor );

                QPainter g;

                QPainter::CompositionMode mode = (QPainter::CompositionMode)6;

                g.begin(&wl_img_texture);
                g.setCompositionMode ( mode );
                g.drawImage(QRect(0,0,-1,-1),wl_image_2);

                QString wl_str_001 = QDir::homePath() + "/.2ManDVD_Library/"  + "/Bibliotheque/Masks/2t_" + tab_diapo[num][3] + ".png";

                if ( wl_over_mask.load(wl_str_001) == true )
                {

                    wl_over_mask = wl_over_mask.scaled(wl_pix_texture.width(),wl_pix_texture.height());

                    wl_over_mask = f_mutation_overmask(wl_over_mask,"255%*255%*255%*255");

                    wl_over_mask = wl_over_mask.convertToFormat ( QImage::Format_ARGB32, Qt::AutoColor );
                    g.setCompositionMode ( (QPainter::CompositionMode)0 );

                    g.drawImage(QRect(0,0,-1,-1),wl_over_mask);
                }

                tab_diapo[num][3] = msk + "%*255%*255%*255%*255";

                g.end();
            }
            else
            {
                wl_img_texture = wl_pix_texture.toImage();

                wg_img_smile_effect = wl_img_texture;

                QStringList wl_exp_001 = tab_diapo[num][4].split(":",QString::SkipEmptyParts);

                f_effect_run(wl_exp_001.at(0).toInt(),wl_exp_001.at(1).toInt());

                wl_img_texture = wg_img_smile_effect.convertToFormat ( QImage::Format_ARGB32, Qt::AutoColor );
            }

            if ( tab_coo[num][10] > 0 )
            {
                wl_img_texture = blur_shadow(wl_img_texture, tab_coo[num][10]);
            }

            wl_puis_001 = wl_img_texture.copy ( 0, 0, sm_mxw, sm_mxw);
            wg_table_photo[num] = wl_puis_001;

            f = QGLWidget::convertToGLFormat( wl_puis_001 );
            //glDeleteTextures (1,&texture_diapo[num]);
            glGenTextures (1,&texture_diapo[num]);
            glBindTexture (GL_TEXTURE_2D, texture_diapo[num]);
            glTexParameteri (GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR);
            glTexParameteri (GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR);
            glTexImage2D (GL_TEXTURE_2D, 0, GL_RGBA, f.width(), f.height(),
                          0, GL_RGBA, GL_UNSIGNED_BYTE, f.bits());
        }
        else
        {
            int result = wg_tabvid[num]->load_video(tab_diapo[num][0]);
            if ( result == 0 )
            {
                wl_img_texture = wg_tabvid[num]->read_frame(wg_tabvid[num]->old_frame);
                QImage wl_puis_001(sm_mxw,sm_mxw,QImage::Format_ARGB32_Premultiplied);

                if ( wl_img_texture.width() > wl_img_texture.height() )
                {
                    wl_img_texture = wl_img_texture.scaledToWidth(sm_mxw,Qt::SmoothTransformation);
                }
                else
                {
                    wl_img_texture = wl_img_texture.scaledToHeight(sm_mxw,Qt::SmoothTransformation);
                }

                if ( tab_diapo[num][3] != "" )
                {
                    QImage wl_image_2(QDir::homePath() + "/.2ManDVD_Library/" +"/Bibliotheque/Masks/"+tab_diapo[num][3]+".png");
                    wl_image_2 = wl_image_2.scaled(wl_img_texture.width(),wl_img_texture.height());
                    wl_image_2 = wl_image_2.convertToFormat ( QImage::Format_ARGB32, Qt::AutoColor ); //_Premultiplied

                    wg_img_smile_effect = wl_img_texture;

                    QStringList wl_exp_001 = tab_diapo[num][4].split(":",QString::SkipEmptyParts);

                    f_effect_run(wl_exp_001.at(0).toInt(),wl_exp_001.at(1).toInt());

                    wl_img_texture = wg_img_smile_effect.convertToFormat ( QImage::Format_ARGB32, Qt::AutoColor ); //_Premultiplied;
                    QPainter g;

                    QPainter::CompositionMode mode = (QPainter::CompositionMode)6;

                    g.begin(&wl_img_texture);
                    g.setCompositionMode ( mode );
                    g.drawImage(QRect(0,0,-1,-1),wl_image_2);

                    QString wl_str_001 = QDir::homePath() + "/.2ManDVD_Library/"  + "/Bibliotheque/Masks/2t_" + tab_diapo[num][3] + ".png";

                    if ( wl_over_mask.load(wl_str_001) == true )
                    {

                        wl_over_mask = wl_over_mask.scaled(wl_img_texture.width(),wl_img_texture.height());
                        wl_over_mask = f_mutation_overmask(wl_over_mask,"255%*255%*255%*255");
                        wl_over_mask = wl_over_mask.convertToFormat ( QImage::Format_ARGB32, Qt::AutoColor ); //_Premultiplied
                        g.setCompositionMode ( (QPainter::CompositionMode)0 );

                        g.drawImage(QRect(0,0,-1,-1),wl_over_mask);
                    }

                    tab_diapo[num][3] = msk + "%*255%*255%*255%*255";

                    g.end();
                }
                else
                {
                    wg_img_smile_effect = wl_img_texture;

                    QStringList wl_exp_001 = tab_diapo[num][4].split(":",QString::SkipEmptyParts);

                    f_effect_run(wl_exp_001.at(0).toInt(),wl_exp_001.at(1).toInt());

                    wl_img_texture = wg_img_smile_effect.convertToFormat ( QImage::Format_ARGB32, Qt::AutoColor ); //_Premultiplied;*/
                }

                if ( tab_coo[num][10] > 0 )
                {
                    wl_img_texture = blur_shadow(wl_img_texture, tab_coo[num][10]);
                }

                wl_puis_001 = wl_img_texture.copy ( 0, 0, sm_mxw, sm_mxw);
                wg_table_photo[num] = wl_puis_001;

                f = QGLWidget::convertToGLFormat( wl_puis_001 );
                //glDeleteTextures (1,&texture_diapo[num]);
                glGenTextures (1,&texture_diapo[num]);
                glBindTexture (GL_TEXTURE_2D, texture_diapo[num]);
                glTexParameteri (GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR);
                glTexParameteri (GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR);
                glTexImage2D (GL_TEXTURE_2D, 0, GL_RGBA, f.width(), f.height(),
                              0, GL_RGBA, GL_UNSIGNED_BYTE, f.bits());
            }
            else
            {
                qDebug() << "ERROR LOADING VIDEO : " << tab_diapo[num][0];
            }
        }
    }
    else
    {
        wl_pix_texture.load(":/Interface/Interface/error.png");
        wl_pix_texture = wl_pix_texture.scaled(sm_mxw,sm_mxw);
        wl_pix_texture.fill(QColor(0,0,0,0));

        p.begin(&wl_pix_texture);
        p.setBrush(QColor(50,50,50));
        p.setPen(QColor(20,20,20));
        p.drawRect(0,0,sm_mxw,sm_mxw);
        p.setFont(myfont);
        p.setPen(QColor(255,255,255));
        p.drawText(QRect(0,0,sm_mxw,sm_mxw), Qt::AlignCenter,QString::number(num));
        p.end();

        if ( tab_diapo[num][3] != "" )
        {
            QImage wl_image_2(QDir::homePath() + "/.2ManDVD_Library/" +"/Bibliotheque/Masks/"+tab_diapo[num][3]+".png");
            wl_image_2 = wl_image_2.scaled(wl_pix_texture.width(),wl_pix_texture.height());
            wl_image_2 = wl_image_2.convertToFormat ( QImage::Format_ARGB32, Qt::AutoColor ); //_Premultiplied

            wl_img_texture = wl_pix_texture.toImage();

            wl_img_texture = wl_img_texture.convertToFormat ( QImage::Format_ARGB32, Qt::AutoColor ); //_Premultiplied

            QPainter g;

            QPainter::CompositionMode mode = (QPainter::CompositionMode)6;

            g.begin(&wl_img_texture);
            g.setCompositionMode ( mode );
            g.drawImage(QRect(0,0,-1,-1),wl_image_2);

            QString wl_str_001 = QDir::homePath() + "/.2ManDVD_Library/"  + "/Bibliotheque/Masks/2t_" + tab_diapo[num][3] + ".png";

            if ( wl_over_mask.load(wl_str_001) == true )
            {
                wl_over_mask = wl_over_mask.scaled(wl_pix_texture.width(),wl_pix_texture.height());

                wl_over_mask = f_mutation_overmask(wl_over_mask,"255%*255%*255%*255");

                wl_over_mask = wl_over_mask.convertToFormat ( QImage::Format_ARGB32, Qt::AutoColor ); //_Premultiplied
                g.setCompositionMode ( (QPainter::CompositionMode)0 );
                g.drawImage(QRect(0,0,-1,-1),wl_over_mask);
            }
            /*else
            {
                wl_img_texture = wl_pix_texture.toImage();
            }*/

            g.end();

            tab_diapo[num][3] = msk + "%*255%*255%*255%*255";
        }

        f = QGLWidget::convertToGLFormat( wl_img_texture );

        //glDeleteTextures(1, &texture_diapo[num] );
        glGenTextures (1,&texture_diapo[num]);
        glBindTexture (GL_TEXTURE_2D, texture_diapo[num]);

        glTexParameteri (GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR);
        glTexParameteri (GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR);

        glTexImage2D (GL_TEXTURE_2D, 0, GL_RGBA, f.width(), f.height(),
                      0, GL_RGBA, GL_UNSIGNED_BYTE, f.bits());
    }
    updateGL();
}

QImage Tetrahedron::f_mutation_overmask(QImage wl_msk, QString wl_msk_over)
{
        // *** MUTATION DES COULEURS OVER MASK ***

        if ( wl_msk_over != "" )
        {
                QStringList wl_explode = wl_msk_over.split("%*",QString::KeepEmptyParts);
                int lumi = 0;
                rouge = wl_explode.at(0).toInt();
                vert = wl_explode.at(1).toInt();
                bleu = wl_explode.at(2).toInt();
                valueadd_R = 0;
                valueadd_V = 0;
                valueadd_B = 0;
                int opacity = wl_explode.at(3).toInt();
                QRgb srcPixel;
                //
                for (int y = 0; y < wl_msk.height(); y++)
                {
                        for (int x = 0; x < wl_msk.width(); x++)
                        {
                                srcPixel = wl_msk.pixel(x, y);
                                trtcolor = srcPixel;
                                //
                                if (qAlpha(srcPixel) > 1 )
                                {
                                        //
                                        valueadd_R = lumi + rouge;
                                        valueadd_V = lumi + vert;
                                        valueadd_B = lumi + bleu;
                                        //

                                        if ( valueadd_R > 0 )
                                        {
                                                if ( trtcolor.red() < 255 - valueadd_R)
                                                {
                                                        trtcolor.setRed(trtcolor.red() + valueadd_R);
                                                }
                                                else
                                                {
                                                        trtcolor.setRed(255);
                                                }
                                        }
                                        else
                                        {
                                                if ( trtcolor.red() > (valueadd_R*-1))
                                                {
                                                        trtcolor.setRed(trtcolor.red() + valueadd_R);
                                                }
                                                else
                                                {
                                                        trtcolor.setRed(0);
                                                }
                                        }

                                        if ( valueadd_V > 0 )
                                        {
                                                if ( trtcolor.green() < 255 - valueadd_V)
                                                {
                                                        trtcolor.setGreen(trtcolor.green() + valueadd_V);
                                                }
                                                else
                                                {
                                                        trtcolor.setGreen(255);
                                                }
                                        }
                                        else
                                        {
                                                if ( trtcolor.green() > (valueadd_V*-1))
                                                {
                                                        trtcolor.setGreen(trtcolor.green() + valueadd_V);
                                                }
                                                else
                                                {
                                                        trtcolor.setGreen(0);
                                                }
                                        }

                                        if ( valueadd_B > 0 )
                                        {
                                                if ( trtcolor.blue() < 255 - valueadd_B)
                                                {
                                                        trtcolor.setBlue(trtcolor.blue() + valueadd_B);
                                                }
                                                else
                                                {
                                                        trtcolor.setBlue(255);
                                                }
                                        }
                                        else
                                        {
                                                if ( trtcolor.blue() > (valueadd_B*-1))
                                                {
                                                        trtcolor.setBlue(trtcolor.blue() + valueadd_B);
                                                }
                                                else
                                                {
                                                        trtcolor.setBlue(0);
                                                }
                                        }
                                        //
                                        trtcolor.setAlpha(opacity);
                                        wl_msk.setPixel(x, y, trtcolor.rgba());
                                }
                                else
                                {
                                        trtcolor.setAlpha(0);
                                        wl_msk.setPixel(x, y, trtcolor.rgba());
                                }
                        }
                }
        }
        //
        return wl_msk;
}

void Tetrahedron::f_check_motion_blur(int value)
{
    is_mblur = value;
    updateGL();
}

void Tetrahedron::f_check_fog(int value)
{
    if ( value > 0 )
    {
        GLfloat fogColor[4] = {(float)fog_red/(float)255, (float)fog_green/(float)255, (float)fog_blue/(float)255, 0.8};

        glEnable (GL_FOG);
        glFogi (GL_FOG_MODE,  GL_LINEAR);
        glFogfv (GL_FOG_COLOR, fogColor);
        glFogf (GL_FOG_DENSITY, 0.2f);
        glHint (GL_FOG_HINT, GL_NICEST);
        glFogf(GL_FOG_START, 5.0f);
        glFogf(GL_FOG_END, 12.0f);

        is_fog = value;

        updateGL();
    }
    else
    {
        glDisable (GL_FOG);

        is_fog = value;

        updateGL();
    }
}

void Tetrahedron::f_check_anaglyph(int value)
{
    is_anaglyph = value;
    updateGL();
}

void Tetrahedron::f_combo_od_changed(int valpos)
{
    if ( valpos == 0 )
    {
        od_red = true;
        od_green = false;
        od_blue = false;

        updateGL();
        return;
    }

    if ( valpos == 1 )
    {
        od_red = false;
        od_green = true;
        od_blue = false;

        updateGL();
        return;
    }

    if ( valpos == 2 )
    {
        od_red = false;
        od_green = false;
        od_blue = true;

        updateGL();
        return;
    }

    if ( valpos == 3 )
    {
        od_red = true;
        od_green = false;
        od_blue = true;

        updateGL();
        return;
    }

    if ( valpos == 4 )
    {
        od_red = false;
        od_green = true;
        od_blue = true;

        updateGL();
        return;
    }
}

void Tetrahedron::f_combo_og_changed(int valpos)
{
    if ( valpos == 0 )
    {
        og_red = true;
        og_green = false;
        og_blue = false;

        updateGL();
        return;
    }

    if ( valpos == 1 )
    {
        og_red = false;
        og_green = true;
        og_blue = false;

        updateGL();
        return;
    }

    if ( valpos == 2 )
    {
        og_red = false;
        og_green = false;
        og_blue = true;

        updateGL();
        return;
    }

    if ( valpos == 3 )
    {
        og_red = true;
        og_green = false;
        og_blue = true;

        updateGL();
        return;
    }

    if ( valpos == 4 )
    {
        og_red = false;
        og_green = true;
        og_blue = true;

        updateGL();
        return;
    }
}

void Tetrahedron::f_sl_esp_ana(int valesp)
{
    wg_esp_ana = valesp;
    updateGL();
}

void Tetrahedron::f_sl_sca_diapo(int valsca)
{
    if ( num_select > 0 )
    {
        scale_factor = ((float)valsca/(float)100);
        tab_diapo[num_select][5] = QString::number(scale_factor);
        updateGL();
    }
}

void Tetrahedron::f_mark_del(int pos)
{
    if ( num_select > 0 )
    {
        int j = 0;
        int ok = 0;
        QStringList wl_exp;

        while ( j < 20 && tab_coo_timeline[num_select][j] != "" && ok == 0 )
        {
            wl_exp = tab_coo_timeline[num_select][j].split(":",QString::SkipEmptyParts);
            if ( wl_exp.at(0).toInt() == pos )
            {
                ok = 1;
            }
            else
            {
                j++;
            }
        }

        if ( ok == 1 )
        {
            while ( tab_coo_timeline[num_select][j] != "" && j < 20 )
            {
                tab_coo_timeline[num_select][j] = tab_coo_timeline[num_select][j+1];
                j++;
            }
            f_apply_mask(num_select, 0, 0.0);
            f_follow_timeline(position_timeline);
        }
        else
        {
            qDebug() << "ERROR DELETING KEYFRAME - NO MATCHING POINT FOUND";
        }

    }
}

void Tetrahedron::f_put_reflect(int state)
{
    tab_diapo[num_select][6] = QString::number(state);
    updateGL();
}

void Tetrahedron::f_netbuf()
{
    // *** NETTOYAGE DE L'ACCUM BUFFER ***
    bcle_render = 1;
    glClearAccum(0.0, 0.0, 0.0, 1.0);
    glClear(GL_DEPTH_BUFFER_BIT);
    updateGL();
}

void Tetrahedron::keyPressEvent( QKeyEvent *k )
{
    if ( k->key() == Qt::Key_X )
    {
        wg_has_mx = 1;
        wg_has_my = 0;
    }

    if ( k->key() == Qt::Key_Y )
    {
        wg_has_mx = 0;
        wg_has_my = 1;
    }

    if ( k->key() == Qt::Key_A )
    {
        wg_has_mx = 0;
        wg_has_my = 0;
    }

    if ( k->key() == Qt::Key_Shift )
    {
        is_shift = 1;
    }

    if ( k->key() == Qt::Key_Control )
    {
        is_ctrl = 1;
    }

    if ( k->key() == Qt::Key_Delete && num_select > 0 )
    {
        f_delete_image();
    }
}

void Tetrahedron::keyReleaseEvent( QKeyEvent *k )
{
    if ( k->key() == Qt::Key_Shift )
    {
        is_shift = 0;
    }

    if ( k->key() == Qt::Key_Control )
    {
        is_ctrl = 0;
    }
}

void Tetrahedron::f_reload_img(int numtex)
{
    if ( tab_diapo[numtex][0] == "" )
    {
            return;
    }
    if ( tab_diapo[numtex][0] == "NULL" || ( tab_diapo[numtex][0].mid(0,1) == "?" && tab_diapo[numtex][0].mid(0,2) != "?9") )
    {
        if ( tab_diapo[numtex][0] == "NULL" )
        {
            QImage wl_puis_001(sm_mxw,sm_mxw,QImage::Format_ARGB32);
            QFont myfont;
            myfont.setPixelSize ( 400 );

            QPainter p;

            p.begin(&wl_puis_001);
            p.setBrush(QColor(50,50,50));
            p.setPen(QColor(20,20,20));
            p.drawRect(0,0,sm_mxw,sm_mxw);
            p.setFont(myfont);
            p.setPen(QColor(255,255,255));
            p.drawText(QRect(0,0,sm_mxw,sm_mxw), Qt::AlignCenter,QString::number(numtex));
            p.end();

            QStringList wg_str_001;

            // *** CHARGEMENT DE LA TEXTURE ***

            //glDeleteTextures(1, &texture_diapo[numtex] );
            QImage wl_img_texture = wl_puis_001;

            if ( tab_diapo[numtex][7] != "0/0/0/0" )
            {
                wg_str_001 = tab_diapo[numtex][7].split("/",QString::KeepEmptyParts);
                wl_img_texture = wl_img_texture.copy(wg_str_001.at(0).toFloat(),wg_str_001.at(1).toFloat(),wg_str_001.at(2).toFloat()-wg_str_001.at(0).toFloat(),wg_str_001.at(3).toFloat()-wg_str_001.at(1).toFloat());
            }

            if ( wl_img_texture.width() > wl_img_texture.height() )
            {
                wl_img_texture = wl_img_texture.scaledToWidth(sm_mxw,Qt::SmoothTransformation);
            }
            else
            {
                wl_img_texture = wl_img_texture.scaledToHeight(sm_mxw,Qt::SmoothTransformation);
            }

            wl_img_texture = wl_img_texture.convertToFormat ( QImage::Format_ARGB32, Qt::AutoColor );

            wg_str_001 = tab_diapo[numtex][4].split(":",QString::SkipEmptyParts);

            if ( wg_str_001.at(0).toInt() != 0 || wg_str_001.at(1).toInt() != 255 )
            {
                wg_img_smile_effect = wl_img_texture;
                f_effect_run(wg_str_001.at(0).toInt(), wg_str_001.at(1).toInt());
                wl_img_texture = wg_img_smile_effect;
            }

            if ( tab_diapo[numtex][3] != "" )
            {
                QStringList wl_explode = tab_diapo[numtex][3].split("%*",QString::KeepEmptyParts);

                QImage wl_image_2(QDir::homePath() + "/.2ManDVD_Library/" +"/Bibliotheque/Masks/"+wl_explode.at(0)+".png");

                wl_image_2 = wl_image_2.scaled(sm_mxw, sm_mxw);
                wl_image_2 = wl_image_2.convertToFormat ( QImage::Format_ARGB32, Qt::AutoColor ); //_Premultiplied

                QPainter g;

                QPainter::CompositionMode mode = (QPainter::CompositionMode)6;

                g.begin(&wl_img_texture);
                g.setCompositionMode ( mode );
                g.drawImage(QRect(0,0,-1,-1),wl_image_2);

                QString wl_str_001 = QDir::homePath() + "/.2ManDVD_Library/"  + "/Bibliotheque/Masks/2t_" + wl_explode.at(0) + ".png";
                QImage wl_over_mask;

                if ( wl_over_mask.load(wl_str_001) == true )
                {
                    wl_over_mask = wl_over_mask.scaled(sm_mxw, sm_mxw);

                    wl_over_mask = f_mutation_overmask( wl_over_mask, wl_explode.at(1) + "%*" + wl_explode.at(2) + "%*" + wl_explode.at(3) + "%*" + wl_explode.at(4) );

                    wl_over_mask = wl_over_mask.convertToFormat ( QImage::Format_ARGB32, Qt::AutoColor ); //_Premultiplied
                    g.setCompositionMode ( (QPainter::CompositionMode)0 );

                    g.drawImage(QRect(0,0,-1,-1),wl_over_mask);
                }

                g.end();
            }

            if ( tab_coo[numtex][10] > 0 )
            {
                wl_img_texture = blur_shadow(wl_img_texture, tab_coo[numtex][10]);
            }

            wg_table_photo[numtex] = wl_img_texture;
            wl_puis_001 = wl_img_texture.copy ( 0, 0, sm_mxw, sm_mxw);

            QImage f = QGLWidget::convertToGLFormat( wl_puis_001 );

            glDeleteTextures (1,&texture_diapo[numtex]);

            glGenTextures (1,&texture_diapo[numtex]);
            glBindTexture (GL_TEXTURE_2D, texture_diapo[numtex]);

            glTexParameteri (GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR);
            glTexParameteri (GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR);

            glTexImage2D (GL_TEXTURE_2D, 0, GL_RGBA, f.width(), f.height(),
                          0, GL_RGBA, GL_UNSIGNED_BYTE, f.bits());

        }
        else
        {
            if ( tab_diapo[numtex][0].mid(0,2) == "?5" )
            {
                QImage wl_img_texture(sm_mxw,sm_mxw,QImage::Format_ARGB32);
                QStringList wg_str_001;

                wg_pix_texture.fill(QColor(0,0,0,0));

                if ( wg_pix_texture.load(tab_diapo[numtex][0].mid(2,tab_diapo[numtex][0].length()-2)) == true )
                {
                    // *** CHARGEMENT DE LA TEXTURE ***

                    //glDeleteTextures(1, &texture_diapo[numtex] );
                    QImage wl_puis_001(sm_mxw,sm_mxw,QImage::Format_ARGB32); //_Premultiplied

                    wl_img_texture = wg_pix_texture.toImage();

                    wl_img_texture = wl_img_texture.scaled(sm_mxw,sm_mxw,Qt::IgnoreAspectRatio,Qt::FastTransformation);
                    wl_img_texture = wl_img_texture.convertToFormat ( QImage::Format_ARGB32, Qt::AutoColor );

                    wg_str_001 = tab_diapo[numtex][4].split(":",QString::SkipEmptyParts);

                    wg_table_photo[numtex] = wl_img_texture;
                    wl_puis_001 = wl_img_texture.copy ( 0, 0, sm_mxw, sm_mxw);

                    QImage f = QGLWidget::convertToGLFormat( wl_puis_001 );

                    glDeleteTextures (1,&texture_diapo[numtex]);

                    glGenTextures (1,&texture_diapo[numtex]);
                    glBindTexture (GL_TEXTURE_2D, texture_diapo[numtex]);

                    glTexParameteri (GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR);
                    glTexParameteri (GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR);

                    glTexImage2D (GL_TEXTURE_2D, 0, GL_RGBA, f.width(), f.height(),
                                  0, GL_RGBA, GL_UNSIGNED_BYTE, f.bits());
                }
                else
                {
                    qDebug() << "ERROR LOADING IMAGE FOR SPHERE = " << tab_diapo[numtex][0].mid(2,tab_diapo[numtex][0].length()-2);
                }
            }
        }
        return;
    }
    else
    {
        if ( tab_diapo[numtex][0].mid(0,2) == "?9" )
        {
            int oldnum = num_select;
            num_select = numtex;
            f_reload_text();
            num_select = oldnum;

            return;
        }
        else
        {
            if ( tab_diapo[numtex][0].right(4) == ".avi" || tab_diapo[numtex][0].right(4) == ".AVI" || tab_diapo[numtex][0].right(4) == ".mpg" || tab_diapo[numtex][0].right(4) == ".MPG" || tab_diapo[numtex][0].right(5) == ".MPEG" || tab_diapo[numtex][0].right(5) == ".mpeg" || tab_diapo[numtex][0].right(4) == ".mp4" || tab_diapo[numtex][0].right(4) == ".MP4" )
            {
                QImage wl_img_texture = wg_tabvid[numtex]->read_frame(0);

                if ( wl_img_texture.width() > wl_img_texture.height() )
                {
                    wl_img_texture = wl_img_texture.scaledToWidth(sm_mxw,Qt::SmoothTransformation);
                }
                else
                {
                    wl_img_texture = wl_img_texture.scaledToHeight(sm_mxw,Qt::SmoothTransformation);
                }

                QStringList wl_exp_001 = tab_diapo[numtex][4].split(":",QString::SkipEmptyParts);
                wg_img_smile_effect = wl_img_texture;
                f_effect_run(wl_exp_001.at(0).toInt(),wl_exp_001.at(1).toInt());
                wl_img_texture = wg_img_smile_effect;

                if ( tab_diapo[numtex][3] != "" )
                {
                    QStringList wl_explode = tab_diapo[numtex][3].split("%*",QString::KeepEmptyParts);
                    QImage wl_image_2(QDir::homePath() + "/.2ManDVD_Library/" +"/Bibliotheque/Masks/"+wl_explode.at(0)+".png");
                    wl_image_2 = wl_image_2.scaled(wl_img_texture.width(),wl_img_texture.height());
                    wl_image_2 = wl_image_2.convertToFormat ( QImage::Format_ARGB32, Qt::AutoColor ); //_Premultiplied

                    //wg_img_smile_effect = wl_img_texture;

                    wl_img_texture = wg_img_smile_effect.convertToFormat ( QImage::Format_ARGB32, Qt::AutoColor ); //_Premultiplied;

                    //wl_img_texture = wl_img_texture.convertToFormat ( QImage::Format_ARGB32, Qt::AutoColor ); //_Premultiplied

                    QPainter g;

                    QPainter::CompositionMode mode = (QPainter::CompositionMode)6;

                    g.begin(&wl_img_texture);
                    g.setCompositionMode ( mode );
                    g.drawImage(QRect(0,0,-1,-1),wl_image_2);

                    QString wl_str_001 = QDir::homePath() + "/.2ManDVD_Library/"  + "/Bibliotheque/Masks/2t_" + wl_explode.at(0) + ".png";
                    QImage wl_over_mask;

                    if ( wl_over_mask.load(wl_str_001) == true )
                    {

                        wl_over_mask = wl_over_mask.scaled(wl_img_texture.width(),wl_img_texture.height());

                        wl_over_mask = f_mutation_overmask(wl_over_mask,wl_explode.at(1) + "%*" + wl_explode.at(2) + "%*" + wl_explode.at(3) + "%*" + wl_explode.at(4));

                        wl_over_mask = wl_over_mask.convertToFormat ( QImage::Format_ARGB32, Qt::AutoColor ); //_Premultiplied
                        g.setCompositionMode ( (QPainter::CompositionMode)0 );

                        g.drawImage(QRect(0,0,-1,-1),wl_over_mask);
                    }

                    g.end();
                }
                if ( tab_coo[numtex][10] > 0 )
                {
                    wl_img_texture = blur_shadow(wl_img_texture, tab_coo[numtex][10]);
                }
                QImage wl_puis_001 = wl_img_texture.copy ( 0, 0, sm_mxw, sm_mxw); //sm_mxw, sm_mxw);

                wg_table_photo[numtex] = wl_puis_001;

                glDeleteTextures (1,&texture_diapo[numtex]);
                QImage f = QGLWidget::convertToGLFormat( wl_puis_001 );

                glGenTextures (1,&texture_diapo[numtex]);
                glBindTexture (GL_TEXTURE_2D, texture_diapo[numtex]);

                glTexParameteri (GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR);
                glTexParameteri (GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR);

                glTexImage2D (GL_TEXTURE_2D, 0, GL_RGBA, f.width(), f.height(),
                              0, GL_RGBA, GL_UNSIGNED_BYTE, f.bits());
            }
            else
            {
                QImage wl_img_texture(sm_mxw,sm_mxw,QImage::Format_ARGB32);
                QStringList wg_str_001;

                if ( tab_diapo[numtex][7] == "0/0/0/0" )
                {
                    QImageReader image_reader(tab_diapo[numtex][0]);
                    int image_width = image_reader.size().width();
                    int image_height = image_reader.size().height();

                    if (image_width > image_height) {
                          image_height = static_cast<double>(sm_mxw) / image_width * image_height;
                          image_width = sm_mxw;
                        } else if (image_width < image_height) {
                          image_width = static_cast<double>(sm_mxw) / image_height * image_width;
                          image_height = sm_mxw;
                        } else {
                          image_width = sm_mxw;
                          image_height = sm_mxw;
                        }
                        image_reader.setScaledSize(QSize(image_width, image_height));
                        wl_img_texture = image_reader.read();
                }
                else
                {
                    if ( wg_pix_texture.load(tab_diapo[numtex][0]) == true )
                    {
                        // *** CHARGEMENT DE LA TEXTURE ***

                        wl_img_texture = wg_pix_texture.toImage();

                        wg_str_001 = tab_diapo[numtex][7].split("/",QString::KeepEmptyParts);
                        int cropxd, cropyd, cropxe, cropye;
                        if ( wg_str_001.at(0).toFloat() > wg_str_001.at(2).toFloat() )
                        {
                            cropxd = wg_str_001.at(0).toFloat();
                            cropxe = wg_str_001.at(2).toFloat();
                        }
                        else
                        {
                            cropxe = wg_str_001.at(0).toFloat();
                            cropxd = wg_str_001.at(2).toFloat();
                        }

                        if ( wg_str_001.at(1).toFloat() > wg_str_001.at(3).toFloat() )
                        {
                            cropyd = wg_str_001.at(1).toFloat();
                            cropye = wg_str_001.at(3).toFloat();
                        }
                        else
                        {
                            cropye = wg_str_001.at(1).toFloat();
                            cropyd = wg_str_001.at(3).toFloat();
                        }

                        wl_img_texture = wl_img_texture.copy(cropxe,cropye,cropxd-cropxe,cropyd-cropye);

                        if ( wl_img_texture.width() > wl_img_texture.height() )
                        {
                            wl_img_texture = wl_img_texture.scaledToWidth(sm_mxw,Qt::SmoothTransformation);
                        }
                        else
                        {
                            wl_img_texture = wl_img_texture.scaledToHeight(sm_mxw,Qt::SmoothTransformation);
                        }
                    }

                }

                wl_img_texture = wl_img_texture.convertToFormat ( QImage::Format_ARGB32, Qt::AutoColor );
                tab_diapo[numtex][1] = QString::number(wl_img_texture.width());
                tab_diapo[numtex][2] = QString::number(wl_img_texture.height());

                wg_str_001 = tab_diapo[numtex][4].split(":",QString::SkipEmptyParts);

                if ( wg_str_001.at(0).toInt() != 0 || wg_str_001.at(1).toInt() != 255 )
                {
                    wg_img_smile_effect = wl_img_texture;
                    f_effect_run(wg_str_001.at(0).toInt(), wg_str_001.at(1).toInt());
                    wl_img_texture = wg_img_smile_effect;
                }

                if ( tab_diapo[numtex][3] != "" )
                {
                    QStringList wl_explode = tab_diapo[numtex][3].split("%*",QString::KeepEmptyParts);

                    QImage wl_image_2(QDir::homePath() + "/.2ManDVD_Library/" +"/Bibliotheque/Masks/"+wl_explode.at(0)+".png");

                    wl_image_2 = wl_image_2.scaled(wl_img_texture.width(), wl_img_texture.height());
                    wl_image_2 = wl_image_2.convertToFormat ( QImage::Format_ARGB32, Qt::AutoColor ); //_Premultiplied

                    QPainter g;

                    QPainter::CompositionMode mode = (QPainter::CompositionMode)6;

                    g.begin(&wl_img_texture);
                    g.setCompositionMode ( mode );
                    g.drawImage(QRect(0,0,-1,-1),wl_image_2);

                    QImage wl_over_mask;

                    if ( wl_over_mask.load(QDir::homePath() + "/.2ManDVD_Library/"  + "/Bibliotheque/Masks/2t_" + wl_explode.at(0) + ".png") == true )
                    {
                        wl_over_mask = wl_over_mask.scaled(wl_img_texture.width(), wl_img_texture.height());

                        wl_over_mask = f_mutation_overmask( wl_over_mask, wl_explode.at(1) + "%*" + wl_explode.at(2) + "%*" + wl_explode.at(3) + "%*" + wl_explode.at(4) );

                        wl_over_mask = wl_over_mask.convertToFormat ( QImage::Format_ARGB32, Qt::AutoColor ); //_Premultiplied
                        g.setCompositionMode ( (QPainter::CompositionMode)0 );

                        g.drawImage(QRect(0,0,-1,-1),wl_over_mask);
                    }

                    g.end();
                }

                if ( tab_coo[numtex][10] > 0 )
                {
                    wl_img_texture = blur_shadow(wl_img_texture, tab_coo[numtex][10]);
                }

                QImage wl_puis_001(sm_mxw,sm_mxw,QImage::Format_ARGB32); //_Premultiplied
                wl_puis_001.fill(0);
                wl_puis_001 = wl_img_texture.copy ( 0, 0, sm_mxw, sm_mxw);
                wg_table_photo[numtex] = wl_puis_001;
                QImage f = QGLWidget::convertToGLFormat( wl_puis_001 );

                glDeleteTextures (1,&texture_diapo[numtex]);

                glGenTextures (1,&texture_diapo[numtex]);
                glBindTexture (GL_TEXTURE_2D, texture_diapo[numtex]);

                glTexParameteri (GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR);
                glTexParameteri (GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR);

                glTexImage2D (GL_TEXTURE_2D, 0, GL_RGBA, f.width(), f.height(),
                              0, GL_RGBA, GL_UNSIGNED_BYTE, f.bits());
            }
        }
    }
}

void Tetrahedron::f_effect_run(int lumi, int cont)
{
        trtcolor.setRed(0);
        trtcolor.setGreen(0);
        trtcolor.setBlue(0);
        trtcolor.setAlpha(0);

        rouge = 0;
        vert = 0;
        bleu = 0;
        valueadd_R = 0;
        valueadd_V = 0;
        valueadd_B = 0;

        QRgb srcPixel;

        int h, s, v, a;

        wg_img_smile_effect = wg_img_smile_effect.convertToFormat(QImage::Format_ARGB32_Premultiplied, Qt::AutoColor);
        QRgb *ltrt1 = reinterpret_cast<QRgb *>(wg_img_smile_effect.scanLine(0));

        ltrt1 = reinterpret_cast<QRgb *>(wg_img_smile_effect.scanLine(0));

        for (int y = 0; y < wg_img_smile_effect.height(); y++)
        {
                ltrt1 = reinterpret_cast<QRgb *>(wg_img_smile_effect.scanLine(y));

                for (int x = 0; x < wg_img_smile_effect.width(); x++)
                {
                        srcPixel = ltrt1[x];
                        trtcolor = srcPixel;
                        //
                        if (qAlpha(srcPixel) > 200 )
                        {
                                //
                                valueadd_R = lumi + rouge;
                                valueadd_V = lumi + vert;
                                valueadd_B = lumi + bleu;
                                //
                                if ( valueadd_R > 0 )
                                {
                                        if ( trtcolor.red() < 255 - valueadd_R)
                                        {
                                                trtcolor.setRed(trtcolor.red() + valueadd_R);
                                        }
                                        else
                                        {
                                                trtcolor.setRed(255);
                                        }
                                }
                                else
                                {
                                        if ( trtcolor.red() > (valueadd_R*-1))
                                        {
                                                trtcolor.setRed(trtcolor.red() + valueadd_R);
                                        }
                                        else
                                        {
                                                trtcolor.setRed(0);
                                        }
                                }

                                if ( valueadd_V > 0 )
                                {
                                        if ( trtcolor.green() < 255 - valueadd_V)
                                        {
                                                trtcolor.setGreen(trtcolor.green() + valueadd_V);
                                        }
                                        else
                                        {
                                                trtcolor.setGreen(255);
                                        }
                                }
                                else
                                {
                                        if ( trtcolor.green() > (valueadd_V*-1))
                                        {
                                                trtcolor.setGreen(trtcolor.green() + valueadd_V);
                                        }
                                        else
                                        {
                                                trtcolor.setGreen(0);
                                        }
                                }

                                if ( valueadd_B > 0 )
                                {
                                        if ( trtcolor.blue() < 255 - valueadd_B)
                                        {
                                                trtcolor.setBlue(trtcolor.blue() + valueadd_B);
                                        }
                                        else
                                        {
                                                trtcolor.setBlue(255);
                                        }
                                }
                                else
                                {
                                        if ( trtcolor.blue() > (valueadd_B*-1))
                                        {
                                                trtcolor.setBlue(trtcolor.blue() + valueadd_B);
                                        }
                                        else
                                        {
                                                trtcolor.setBlue(0);
                                        }
                                }

                                //trtcolor.setAlpha(opacity);

                                trtcolor.getHsv(&h, &s, &v, &a);

                                trtcolor.setHsv(h,(cont*s)/255,v,a);

                                wg_img_smile_effect.setPixel(x, y, trtcolor.rgba());
                       }
                }
        }
}

// **********************************
// *** AJOUTER LE MEDIA AU PROJET ***
// **********************************
void Tetrahedron::dragEnterEvent(QDragEnterEvent *event)
{
        event->acceptProposedAction();
}

void Tetrahedron::dropEvent(QDropEvent *event)
{
        QList<QUrl> myurl = event->mimeData()->urls();
        QString wl_str_001;
        QStringList wl_mylist;
        int wl_int_001 = 0;
        int wl_int_002 = 0;

        while ( wl_int_001 < myurl.count() )
        {
            wl_str_001 = myurl[wl_int_001].toString(QUrl::None);
            if ( wl_str_001.mid(0,6) == "file:/" )
            {
                wl_mylist.append(wl_str_001.mid(7,wl_str_001.length()-7));
                wl_int_002++;
            }
            else
            {
                if ( wl_str_001.mid(0,4) == "$ANI" )
                {
                    f_load_object_from_drop(wl_str_001.mid(4,wl_str_001.length()-4));
                }
            }
            wl_int_001++;
        }

        if ( wl_int_002 > 0 )
        {
            f_load_image_step_2(wl_mylist);
        }

        updateGL();
}

#ifndef BLUR_CPP
#define BLUR_CPP
  /*   Copyright 2007 Jani Huhtanen <jani.huhtanen@tut.fi>
  *
  *   This program is free software; you can redistribute it and/or modify
  *   it under the terms of the GNU Library General Public License version 2 as
  *   published by the Free Software Foundation
  *
  *   This program is distributed in the hope that it will be useful,
  *   but WITHOUT ANY WARRANTY; without even the implied warranty of
  *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  *   GNU General Public License for more details
  *
  *   You should have received a copy of the GNU Library General Public
  *   License along with this program; if not, write to the
  *   Free Software Foundation, Inc.,
  *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
  */

// Exponential blur, Jani Huhtanen, 2006
//
template<int aprec, int zprec>
static inline void blurinner(unsigned char *bptr, int &zR, int &zG, int &zB, int &zA, int alpha);

template<int aprec,int zprec>
static inline void blurrow( QImage & im, int line, int alpha);

template<int aprec, int zprec>
static inline void blurcol( QImage & im, int col, int alpha);
/*
*  expblur(QImage &img, int radius)
*
*  In-place blur of image 'img' with kernel
*  of approximate radius 'radius'.
*
*  Blurs with two sided exponential impulse
*  response.
*
*  aprec = precision of alpha parameter
*  in fixed-point format 0.aprec
*
*  zprec = precision of state parameters
*  zR,zG,zB and zA in fp format 8.zprec
*/
template<int aprec,int zprec>
void expblur( QImage &img, int radius )
{
        int alpha = (int)((1<<aprec)*(1.0f-std::exp(-2.3f/(radius+1.f))));
        for(int row=0;row<img.height();row++)
        {
                blurrow<aprec,zprec>(img,row,alpha);
        }
        for(int col=0;col<img.width();col++)
        {
                blurcol<aprec,zprec>(img,col,alpha);
        }
        return;
}

template<int aprec, int zprec>
static inline void blurinner(unsigned char *bptr, int &zR, int &zG, int &zB, int &zA, int alpha)
{
        int R,G,B,A;
        R = *bptr;
        G = *(bptr+1);
        B = *(bptr+2);
        A = *(bptr+3);

        zR += (alpha * ((R<<zprec)-zR))>>aprec;
        zG += (alpha * ((G<<zprec)-zG))>>aprec;
        zB += (alpha * ((B<<zprec)-zB))>>aprec;
        zA += (alpha * ((A<<zprec)-zA))>>aprec;

        *bptr =     zR>>zprec;
        *(bptr+1) = zG>>zprec;
        *(bptr+2) = zB>>zprec;
        *(bptr+3) = zA>>zprec;
}

template<int aprec,int zprec>
static inline void blurrow( QImage & im, int line, int alpha)
{
        int zR,zG,zB,zA;

        QRgb *ptr = (QRgb *)im.scanLine(line);

        zR = *((unsigned char *)ptr    )<<zprec;
        zG = *((unsigned char *)ptr + 1)<<zprec;
        zB = *((unsigned char *)ptr + 2)<<zprec;
        zA = *((unsigned char *)ptr + 3)<<zprec;

        for(int index=1; index<im.width(); index++)
        {
                blurinner<aprec,zprec>((unsigned char *)&ptr[index],zR,zG,zB,zA,alpha);
        }
        for(int index=im.width()-2; index>=0; index--)
        {
                blurinner<aprec,zprec>((unsigned char *)&ptr[index],zR,zG,zB,zA,alpha);
        }
}

template<int aprec, int zprec>
static inline void blurcol( QImage & im, int col, int alpha)
{
        int zR,zG,zB,zA;

        QRgb *ptr = (QRgb *)im.bits();
        ptr+=col;

        zR = *((unsigned char *)ptr    )<<zprec;
        zG = *((unsigned char *)ptr + 1)<<zprec;
        zB = *((unsigned char *)ptr + 2)<<zprec;
        zA = *((unsigned char *)ptr + 3)<<zprec;

        for(int index=im.width(); index<(im.height()-1)*im.width(); index+=im.width())
        {
                blurinner<aprec,zprec>((unsigned char *)&ptr[index],zR,zG,zB,zA,alpha);
        }

        for(int index=(im.height()-2)*im.width(); index>=0; index-=im.width())
        {
                blurinner<aprec,zprec>((unsigned char *)&ptr[index],zR,zG,zB,zA,alpha);
        }

}

template<class T>
inline const T& qClamp(const T &x, const T &low, const T &high)
{
        if      (x <  low) return low;
        else if (x > high) return high;
        else               return x;
}
#endif

QImage Tetrahedron::blur_shadow(QImage wl_ims_1, int radius)
{
        expblur <8, 8>(wl_ims_1, radius);
        return wl_ims_1;
}

void Tetrahedron::effect_polaroid()
{
    QFile wmyficext;
    QTextStream outext(&wmyficext);

    wmyficext.setFileName(QDir::homePath() + "/.effect_mandvd.sh");
    wmyficext.open( QIODevice::WriteOnly );
    outext << "convert " + wg_src_effects + " -bordercolor white  -border 4% -bordercolor grey60 -border 1 -background  none -rotate 0 -background  black \\( +clone -shadow 90x20+20+20 \\) +swap -background  none -flatten " + wg_dst_effects << endl;
    outext << "exit" << endl;

    wmyficext.close();
    QStringList argumentsf;
    argumentsf << QDir::homePath() + "/.effect_mandvd.sh";

    if ( src_effect == 1 )
    {
        proc_magick.setProcessChannelMode(QProcess::MergedChannels);
        proc_magick.start("bash",argumentsf);
    }
    else
    {
        proc_ffmpeg.setProcessChannelMode(QProcess::MergedChannels);
        proc_ffmpeg.start("bash",argumentsf);

        proc_ffmpeg.waitForFinished(-1);
    }

}

void Tetrahedron::effect_sepia()
{
    QFile wmyficext;
    QTextStream outext(&wmyficext);

    wmyficext.setFileName(QDir::homePath() + "/.effect_mandvd.sh");
    wmyficext.open( QIODevice::WriteOnly );
    outext << "convert " + wg_src_effects + " \\( +clone -sepia-tone 60% \\) -average " + wg_dst_effects << endl;
    outext << "exit" << endl;

    wmyficext.close();
    QStringList argumentsf;
    argumentsf << QDir::homePath() + "/.effect_mandvd.sh";

    if ( src_effect == 1 )
    {
        proc_magick.setProcessChannelMode(QProcess::MergedChannels);
        proc_magick.start("bash",argumentsf);
    }
    else
    {
        proc_ffmpeg.setProcessChannelMode(QProcess::MergedChannels);
        proc_ffmpeg.start("bash",argumentsf);

        proc_ffmpeg.waitForFinished(-1);
    }
}

void Tetrahedron::effect_paint()
{
    QFile wmyficext;
    QTextStream outext(&wmyficext);

    wmyficext.setFileName(QDir::homePath() + "/.effect_mandvd.sh");
    wmyficext.open( QIODevice::WriteOnly );
    outext << "convert " + wg_src_effects + " -paint 3 " + wg_dst_effects << endl;
    outext << "exit" << endl;

    wmyficext.close();
    QStringList argumentsf;
    argumentsf << QDir::homePath() + "/.effect_mandvd.sh";

    if ( src_effect == 1 )
    {
        proc_magick.setProcessChannelMode(QProcess::MergedChannels);
        proc_magick.start("bash",argumentsf);
    }
    else
    {
        proc_ffmpeg.setProcessChannelMode(QProcess::MergedChannels);
        proc_ffmpeg.start("bash",argumentsf);

        proc_ffmpeg.waitForFinished(-1);
    }
}

void Tetrahedron::effect_auto_gamma()
{
    QFile wmyficext;
    QTextStream outext(&wmyficext);

    wmyficext.setFileName(QDir::homePath() + "/.effect_mandvd.sh");
    wmyficext.open( QIODevice::WriteOnly );
    outext << "convert " + wg_src_effects + " -auto-gamma " + wg_dst_effects << endl;
    outext << "exit" << endl;

    wmyficext.close();
    QStringList argumentsf;
    argumentsf << QDir::homePath() + "/.effect_mandvd.sh";

    if ( src_effect == 1 )
    {
        proc_magick.setProcessChannelMode(QProcess::MergedChannels);
        proc_magick.start("bash",argumentsf);
    }
    else
    {
        proc_ffmpeg.setProcessChannelMode(QProcess::MergedChannels);
        proc_ffmpeg.start("bash",argumentsf);

        proc_ffmpeg.waitForFinished(-1);
    }
}

void Tetrahedron::effect_negate()
{
    QFile wmyficext;
    QTextStream outext(&wmyficext);

    wmyficext.setFileName(QDir::homePath() + "/.effect_mandvd.sh");
    wmyficext.open( QIODevice::WriteOnly );
    outext << "convert " + wg_src_effects + " -negate " + wg_dst_effects << endl;
    outext << "exit" << endl;

    wmyficext.close();
    QStringList argumentsf;
    argumentsf << QDir::homePath() + "/.effect_mandvd.sh";

    if ( src_effect == 1 )
    {
        proc_magick.setProcessChannelMode(QProcess::MergedChannels);
        proc_magick.start("bash",argumentsf);
    }
    else
    {
        proc_ffmpeg.setProcessChannelMode(QProcess::MergedChannels);
        proc_ffmpeg.start("bash",argumentsf);

        proc_ffmpeg.waitForFinished(-1);
    }
}

void Tetrahedron::effect_multi_polaroid()
{
    QFile wmyficext;
    QTextStream outext(&wmyficext);

    wmyficext.setFileName(QDir::homePath() + "/.effect_mandvd.sh");
    wmyficext.open( QIODevice::WriteOnly );
    outext << "convert " + wg_src_effects + " -bordercolor white  -border 6 -bordercolor grey60 -border 1 -bordercolor none  -background  none \\( -clone 0 -rotate `convert null: -format '%[fx:rand()*30-15]' info:` \\) \\( -clone 0 -rotate `convert null: -format '%[fx:rand()*30-15]' info:` \\) \\( -clone 0 -rotate `convert null: -format '%[fx:rand()*30-15]' info:` \\) \\( -clone 0 -rotate `convert null: -format '%[fx:rand()*30-15]' info:` \\) -delete 0  -border 100x80  -gravity center +repage  -flatten  -trim -background none \\( +clone -shadow 60x4+4+4 \\) +swap -background none -flatten " + wg_dst_effects << endl;
    outext << "exit" << endl;
    wmyficext.close();
    QStringList argumentsf;
    argumentsf << QDir::homePath() + "/.effect_mandvd.sh";

    if ( src_effect == 1 )
    {
        proc_magick.setProcessChannelMode(QProcess::MergedChannels);
        proc_magick.start("bash",argumentsf);
    }
    else
    {
        proc_ffmpeg.setProcessChannelMode(QProcess::MergedChannels);
        proc_ffmpeg.start("bash",argumentsf);

        proc_ffmpeg.waitForFinished(-1);
    }
}

void Tetrahedron::effect_charcoal()
{
    QFile wmyficext;
    QTextStream outext(&wmyficext);

    wmyficext.setFileName(QDir::homePath() + "/.effect_mandvd.sh");
    wmyficext.open( QIODevice::WriteOnly );
    outext << "convert " + wg_src_effects + " -charcoal 2 " + wg_dst_effects << endl;
    outext << "exit" << endl;
    wmyficext.close();
    QStringList argumentsf;
    argumentsf << QDir::homePath() + "/.effect_mandvd.sh";

    if ( src_effect == 1 )
    {
        proc_magick.setProcessChannelMode(QProcess::MergedChannels);
        proc_magick.start("bash",argumentsf);
    }
    else
    {
        proc_ffmpeg.setProcessChannelMode(QProcess::MergedChannels);
        proc_ffmpeg.start("bash",argumentsf);

        proc_ffmpeg.waitForFinished(-1);
    }
}

void Tetrahedron::effect_posterize()
{
    QFile wmyficext;
    QTextStream outext(&wmyficext);

    wmyficext.setFileName(QDir::homePath() + "/.effect_mandvd.sh");
    wmyficext.open( QIODevice::WriteOnly );
    outext << "convert " + wg_src_effects + " -posterize 7 " + wg_dst_effects << endl;
    outext << "exit" << endl;
    wmyficext.close();
    QStringList argumentsf;
    argumentsf << QDir::homePath() + "/.effect_mandvd.sh";

    if ( src_effect == 1 )
    {
        proc_magick.setProcessChannelMode(QProcess::MergedChannels);
        proc_magick.start("bash",argumentsf);
    }
    else
    {
        proc_ffmpeg.setProcessChannelMode(QProcess::MergedChannels);
        proc_ffmpeg.start("bash",argumentsf);

        proc_ffmpeg.waitForFinished(-1);
    }
}

void Tetrahedron::effect_radial_blur()
{
    QFile wmyficext;
    QTextStream outext(&wmyficext);

    wmyficext.setFileName(QDir::homePath() + "/.effect_mandvd.sh");
    wmyficext.open( QIODevice::WriteOnly );
    outext << "convert " + wg_src_effects + " -radial-blur 3 " + wg_dst_effects << endl;
    outext << "exit" << endl;
    wmyficext.close();
    QStringList argumentsf;
    argumentsf << QDir::homePath() + "/.effect_mandvd.sh";

    if ( src_effect == 1 )
    {
        proc_magick.setProcessChannelMode(QProcess::MergedChannels);
        proc_magick.start("bash",argumentsf);
    }
    else
    {
        proc_ffmpeg.setProcessChannelMode(QProcess::MergedChannels);
        proc_ffmpeg.start("bash",argumentsf);

        proc_ffmpeg.waitForFinished(-1);
    }
}

void Tetrahedron::effect_auto_level()
{
    QFile wmyficext;
    QTextStream outext(&wmyficext);

    wmyficext.setFileName(QDir::homePath() + "/.effect_mandvd.sh");
    wmyficext.open( QIODevice::WriteOnly );
    outext << "convert " + wg_src_effects + " -auto-level " + wg_dst_effects << endl;
    outext << "exit" << endl;
    wmyficext.close();
    QStringList argumentsf;
    argumentsf << QDir::homePath() + "/.effect_mandvd.sh";

    if ( src_effect == 1 )
    {
        proc_magick.setProcessChannelMode(QProcess::MergedChannels);
        proc_magick.start("bash",argumentsf);
    }
    else
    {
        proc_ffmpeg.setProcessChannelMode(QProcess::MergedChannels);
        proc_ffmpeg.start("bash",argumentsf);

        proc_ffmpeg.waitForFinished(-1);
    }
}

void Tetrahedron::f_end_proc_magick(int, QProcess::ExitStatus)
{
    emit effect_render();
}
